<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for service_report
 */
class ServiceReport extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $buyer_id;
    public $hardware_id;
    public $service_executive;
    public $entry_time;
    public $current_reading;
    public $error_ref;
    public $service_type;
    public $complaint;
    public $observation;
    public $product_replaced;
    public $consumable_replaced;
    public $work_detail;
    public $future_task;
    public $last_status;
    public $uploads;
    public $out_time;
    public $operator;
    public $datetime;
    public $a_operator;
    public $invoice;
    public $invoice_date;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "service_report";
        $this->TableName = 'service_report';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "service_report";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_id->addMethod("getSelectFilter", fn() => "`id`>1000 and `status`=1");
        $this->buyer_id->addMethod("getDefault", fn() => (isset($_COOKIE["CID"]))? $_COOKIE["CID"]:'');
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->Nullable = false; // NOT NULL field
        $this->buyer_id->Required = true; // Required field
        $this->buyer_id->Lookup = new Lookup($this->buyer_id, 'buyer', false, 'id', ["name","code","mobile","city_name"], '', '', [], ["x_hardware_id","x_error_ref","x_product_replaced[]","x_consumable_replaced[]"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->buyer_id) . "',COALESCE(`code`,''),'" . ValueSeparator(2, $this->buyer_id) . "',COALESCE(`mobile`,''),'" . ValueSeparator(3, $this->buyer_id) . "',COALESCE(`city_name`,''))");
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // hardware_id
        $this->hardware_id = new DbField(
            $this, // Table
            'x_hardware_id', // Variable name
            'hardware_id', // Name
            '`hardware_id`', // Expression
            '`hardware_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`hardware_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->hardware_id->addMethod("getDefault", fn() => (isset($_COOKIE["HI"]))? $_COOKIE["HI"]:'');
        $this->hardware_id->InputTextType = "text";
        $this->hardware_id->Raw = true;
        $this->hardware_id->Required = true; // Required field
        $this->hardware_id->setSelectMultiple(false); // Select one
        $this->hardware_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->hardware_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->hardware_id->Lookup = new Lookup($this->hardware_id, 'client_hardware_data', false, 'id', ["ref","name_ref","harward_code","serial_no"], '', '', ["x_buyer_id"], [], ["partner_id"], ["x_partner_id"], [], [], false, '`name_ref` ASC', '', "CONCAT(COALESCE(`ref`, ''),'" . ValueSeparator(1, $this->hardware_id) . "',COALESCE(`name_ref`,''),'" . ValueSeparator(2, $this->hardware_id) . "',COALESCE(`harward_code`,''),'" . ValueSeparator(3, $this->hardware_id) . "',COALESCE(`serial_no`,''))");
        $this->hardware_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->hardware_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['hardware_id'] = &$this->hardware_id;

        // service_executive
        $this->service_executive = new DbField(
            $this, // Table
            'x_service_executive', // Variable name
            'service_executive', // Name
            '`service_executive`', // Expression
            '`service_executive`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`service_executive`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->service_executive->addMethod("getSelectFilter", fn() => "FIND_IN_SET('92', `category`)");
        $this->service_executive->addMethod("getDefault", fn() => (isset($_COOKIE["SE"]))? $_COOKIE["SE"]:'');
        $this->service_executive->InputTextType = "text";
        $this->service_executive->Raw = true;
        $this->service_executive->Required = true; // Required field
        $this->service_executive->Lookup = new Lookup($this->service_executive, 'admin', false, 'id', ["user_name","","",""], '', '', [], ["x_error_ref"], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->service_executive->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->service_executive->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['service_executive'] = &$this->service_executive;

        // entry_time
        $this->entry_time = new DbField(
            $this, // Table
            'x_entry_time', // Variable name
            'entry_time', // Name
            '`entry_time`', // Expression
            CastDateFieldForLike("`entry_time`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`entry_time`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->entry_time->addMethod("getDefault", fn() => (isset($_COOKIE["ET"]))? $_COOKIE["ET"]:'');
        $this->entry_time->InputTextType = "text";
        $this->entry_time->Raw = true;
        $this->entry_time->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->entry_time->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['entry_time'] = &$this->entry_time;

        // current_reading
        $this->current_reading = new DbField(
            $this, // Table
            'x_current_reading', // Variable name
            'current_reading', // Name
            '`current_reading`', // Expression
            '`current_reading`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_reading`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->current_reading->addMethod("getDefault", fn() => (isset($_COOKIE["CR"]))? $_COOKIE["CR"]:'');
        $this->current_reading->InputTextType = "text";
        $this->current_reading->Raw = true;
        $this->current_reading->Nullable = false; // NOT NULL field
        $this->current_reading->Required = true; // Required field
        $this->current_reading->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_reading->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_reading'] = &$this->current_reading;

        // error_ref
        $this->error_ref = new DbField(
            $this, // Table
            'x_error_ref', // Variable name
            'error_ref', // Name
            '`error_ref`', // Expression
            '`error_ref`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`error_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->error_ref->addMethod("getSelectFilter", fn() => "`status` !=9");
        $this->error_ref->addMethod("getDefault", fn() => (isset($_COOKIE["ER"]))? $_COOKIE["ER"]:'');
        $this->error_ref->InputTextType = "text";
        $this->error_ref->setSelectMultiple(false); // Select one
        $this->error_ref->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->error_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->error_ref->Lookup = new Lookup($this->error_ref, 'service_request', false, 'id', ["datetime","rid_1","",""], '', '', ["x_service_executive","x_buyer_id"], [], ["service_executive","buyer_id"], ["x_service_executive","x_buyer_id"], ["error"], ["x_complaint"], false, '`id` ASC', '', "CONCAT(COALESCE(" . CastDateFieldForLike("`datetime`", 111, "DB") . ", ''),'" . ValueSeparator(1, $this->error_ref) . "',COALESCE(`rid_1`,''))");
        $this->error_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->error_ref->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['error_ref'] = &$this->error_ref;

        // service_type
        $this->service_type = new DbField(
            $this, // Table
            'x_service_type', // Variable name
            'service_type', // Name
            '`service_type`', // Expression
            '`service_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`service_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->service_type->addMethod("getSelectFilter", fn() => "`grp`=11  and `status` = 1");
        $this->service_type->addMethod("getDefault", fn() => (isset($_COOKIE["ST"]))? $_COOKIE["ST"]:'');
        $this->service_type->InputTextType = "text";
        $this->service_type->Raw = true;
        $this->service_type->Required = true; // Required field
        $this->service_type->setSelectMultiple(false); // Select one
        $this->service_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->service_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->service_type->Lookup = new Lookup($this->service_type, 'service_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->service_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->service_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['service_type'] = &$this->service_type;

        // complaint
        $this->complaint = new DbField(
            $this, // Table
            'x_complaint', // Variable name
            'complaint', // Name
            '`complaint`', // Expression
            '`complaint`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`complaint`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->complaint->addMethod("getSelectFilter", fn() => "`grp` = 21 and `status` = 1");
        $this->complaint->addMethod("getDefault", fn() => (isset($_COOKIE["CO"]))? $_COOKIE["CO"]:'');
        $this->complaint->InputTextType = "text";
        $this->complaint->Required = true; // Required field
        $this->complaint->setSelectMultiple(false); // Select one
        $this->complaint->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->complaint->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->complaint->Lookup = new Lookup($this->complaint, 'service_misc', false, 'item', ["item","","",""], '', '', [], [], [], [], [], [], true, '`item` ASC', '', "`item`");
        $this->complaint->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['complaint'] = &$this->complaint;

        // observation
        $this->observation = new DbField(
            $this, // Table
            'x_observation', // Variable name
            'observation', // Name
            '`observation`', // Expression
            '`observation`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`observation`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->observation->addMethod("getDefault", fn() => (isset($_COOKIE["OB"]))? $_COOKIE["OB"]:'');
        $this->observation->InputTextType = "text";
        $this->observation->Required = true; // Required field
        $this->observation->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['observation'] = &$this->observation;

        // product_replaced
        $this->product_replaced = new DbField(
            $this, // Table
            'x_product_replaced', // Variable name
            'product_replaced', // Name
            '`product_replaced`', // Expression
            '`product_replaced`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_replaced`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->product_replaced->addMethod("getSelectFilter", fn() => ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')")));
        $this->product_replaced->addMethod("getEditCustomAttributes", fn() => 'selected');
        $this->product_replaced->addMethod("getDefault", fn() => (isset($_COOKIE["PRE"]))? $_COOKIE["PRE"]:'');
        $this->product_replaced->InputTextType = "text";
        $this->product_replaced->Lookup = new Lookup($this->product_replaced, 'material_out_wbc', false, 'id', ["rid_name","quantity","",""], '', '', ["x_buyer_id"], [], ["issue_to"], ["x_issue_to"], [], [], false, '`rid_name` ASC', '<div><span class="text-info">{{:df}}, Qty : {{:df2}}</span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'material_out_wbcedit?id={{:lf}}\'});"> Edit </span><a href="materialoutwbcdelete?id={{:lf}}"><span style="color:red"> Delete </span></a></div>', "CONCAT(COALESCE(`rid_name`, ''),'" . ValueSeparator(1, $this->product_replaced) . "',COALESCE(`quantity`,''))");
        $this->product_replaced->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_replaced->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_replaced'] = &$this->product_replaced;

        // consumable_replaced
        $this->consumable_replaced = new DbField(
            $this, // Table
            'x_consumable_replaced', // Variable name
            'consumable_replaced', // Name
            '`consumable_replaced`', // Expression
            '`consumable_replaced`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`consumable_replaced`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->consumable_replaced->addMethod("getSelectFilter", fn() => ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')")));
        $this->consumable_replaced->addMethod("getDefault", fn() => (isset($_COOKIE["CRE"]))? $_COOKIE["CRE"]:'');
        $this->consumable_replaced->InputTextType = "text";
        $this->consumable_replaced->Lookup = new Lookup($this->consumable_replaced, 'material_out_wbc', false, 'id', ["rid_name","quantity","",""], '', '', ["x_buyer_id"], [], ["issue_to"], ["x_issue_to"], [], [], false, '`rid_name` ASC', '<div><span class="text-info">{{:df}}, Qty : {{:df2}}</span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'material_out_wbcedit?id={{:lf}}\'});"> Edit </span><a href="materialoutwbcdelete?id={{:lf}}"><span style="color:red"> Delete </span></a></div>', "CONCAT(COALESCE(`rid_name`, ''),'" . ValueSeparator(1, $this->consumable_replaced) . "',COALESCE(`quantity`,''))");
        $this->consumable_replaced->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->consumable_replaced->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['consumable_replaced'] = &$this->consumable_replaced;

        // work_detail
        $this->work_detail = new DbField(
            $this, // Table
            'x_work_detail', // Variable name
            'work_detail', // Name
            '`work_detail`', // Expression
            '`work_detail`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`work_detail`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->work_detail->addMethod("getDefault", fn() => (isset($_COOKIE["WD"]))? $_COOKIE["WD"]:'');
        $this->work_detail->InputTextType = "text";
        $this->work_detail->Required = true; // Required field
        $this->work_detail->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['work_detail'] = &$this->work_detail;

        // future_task
        $this->future_task = new DbField(
            $this, // Table
            'x_future_task', // Variable name
            'future_task', // Name
            '`future_task`', // Expression
            '`future_task`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`future_task`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->future_task->addMethod("getDefault", fn() => (isset($_COOKIE["FT"]))? $_COOKIE["FT"]:'');
        $this->future_task->InputTextType = "text";
        $this->future_task->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['future_task'] = &$this->future_task;

        // last_status
        $this->last_status = new DbField(
            $this, // Table
            'x_last_status', // Variable name
            'last_status', // Name
            '`last_status`', // Expression
            '`last_status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`last_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->last_status->addMethod("getSelectFilter", fn() => "`grp` = 41 and `status` =1");
        $this->last_status->addMethod("getDefault", fn() => 4104);
        $this->last_status->InputTextType = "text";
        $this->last_status->Raw = true;
        $this->last_status->Required = true; // Required field
        $this->last_status->setSelectMultiple(false); // Select one
        $this->last_status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->last_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->last_status->Lookup = new Lookup($this->last_status, 'service_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->last_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->last_status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['last_status'] = &$this->last_status;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->InputTextType = "text";
        $this->uploads->UploadMultiple = true;
        $this->uploads->Upload->UploadMultiple = true;
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // out_time
        $this->out_time = new DbField(
            $this, // Table
            'x_out_time', // Variable name
            'out_time', // Name
            '`out_time`', // Expression
            CastDateFieldForLike("`out_time`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`out_time`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->out_time->InputTextType = "text";
        $this->out_time->Raw = true;
        $this->out_time->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->out_time->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['out_time'] = &$this->out_time;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->a_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->setSelectMultiple(false); // Select one
        $this->a_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->a_operator->Lookup = new Lookup($this->a_operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // invoice
        $this->invoice = new DbField(
            $this, // Table
            'x_invoice', // Variable name
            'invoice', // Name
            '`invoice`', // Expression
            '`invoice`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`invoice`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice->InputTextType = "text";
        $this->invoice->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice'] = &$this->invoice;

        // invoice_date
        $this->invoice_date = new DbField(
            $this, // Table
            'x_invoice_date', // Variable name
            'invoice_date', // Name
            '`invoice_date`', // Expression
            CastDateFieldForLike("`invoice_date`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`invoice_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_date->InputTextType = "text";
        $this->invoice_date->Raw = true;
        $this->invoice_date->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->invoice_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_date'] = &$this->invoice_date;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "service_report";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Category() == 92) ? "`service_executive` = " .  CurrentUserID() . ' and `last_status` NOT IN (4104,4105) and `out_time` is NULL' : "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->hardware_id->DbValue = $row['hardware_id'];
        $this->service_executive->DbValue = $row['service_executive'];
        $this->entry_time->DbValue = $row['entry_time'];
        $this->current_reading->DbValue = $row['current_reading'];
        $this->error_ref->DbValue = $row['error_ref'];
        $this->service_type->DbValue = $row['service_type'];
        $this->complaint->DbValue = $row['complaint'];
        $this->observation->DbValue = $row['observation'];
        $this->product_replaced->DbValue = $row['product_replaced'];
        $this->consumable_replaced->DbValue = $row['consumable_replaced'];
        $this->work_detail->DbValue = $row['work_detail'];
        $this->future_task->DbValue = $row['future_task'];
        $this->last_status->DbValue = $row['last_status'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->out_time->DbValue = $row['out_time'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->invoice->DbValue = $row['invoice'];
        $this->invoice_date->DbValue = $row['invoice_date'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $oldFiles = EmptyValue($row['uploads']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['uploads']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("servicereportlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "servicereportview" => $Language->phrase("View"),
            "servicereportedit" => $Language->phrase("Edit"),
            "servicereportadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "servicereportlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "ServiceReportView",
            Config("API_ADD_ACTION") => "ServiceReportAdd",
            Config("API_EDIT_ACTION") => "ServiceReportEdit",
            Config("API_DELETE_ACTION") => "ServiceReportDelete",
            Config("API_LIST_ACTION") => "ServiceReportList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "servicereportlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("servicereportview", $parm);
        } else {
            $url = $this->keyUrl("servicereportview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "servicereportadd?" . $parm;
        } else {
            $url = "servicereportadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("servicereportedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("servicereportlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("servicereportadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("servicereportlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("servicereportdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->hardware_id->setDbValue($row['hardware_id']);
        $this->service_executive->setDbValue($row['service_executive']);
        $this->entry_time->setDbValue($row['entry_time']);
        $this->current_reading->setDbValue($row['current_reading']);
        $this->error_ref->setDbValue($row['error_ref']);
        $this->service_type->setDbValue($row['service_type']);
        $this->complaint->setDbValue($row['complaint']);
        $this->observation->setDbValue($row['observation']);
        $this->product_replaced->setDbValue($row['product_replaced']);
        $this->consumable_replaced->setDbValue($row['consumable_replaced']);
        $this->work_detail->setDbValue($row['work_detail']);
        $this->future_task->setDbValue($row['future_task']);
        $this->last_status->setDbValue($row['last_status']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->out_time->setDbValue($row['out_time']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->invoice->setDbValue($row['invoice']);
        $this->invoice_date->setDbValue($row['invoice_date']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "ServiceReportList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // buyer_id

        // hardware_id

        // service_executive

        // entry_time

        // current_reading

        // error_ref

        // service_type

        // complaint

        // observation

        // product_replaced

        // consumable_replaced

        // work_detail

        // future_task

        // last_status

        // uploads

        // out_time

        // operator

        // datetime

        // a_operator

        // invoice

        // invoice_date

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // buyer_id
        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                }
            }
        } else {
            $this->buyer_id->ViewValue = null;
        }

        // hardware_id
        $curVal = strval($this->hardware_id->CurrentValue);
        if ($curVal != "") {
            $this->hardware_id->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
            if ($this->hardware_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->hardware_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hardware_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->hardware_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->hardware_id->Lookup->renderViewRow($rswrk[0]);
                    $this->hardware_id->ViewValue = $this->hardware_id->displayValue($arwrk);
                } else {
                    $this->hardware_id->ViewValue = FormatNumber($this->hardware_id->CurrentValue, $this->hardware_id->formatPattern());
                }
            }
        } else {
            $this->hardware_id->ViewValue = null;
        }

        // service_executive
        $this->service_executive->ViewValue = $this->service_executive->CurrentValue;
        $curVal = strval($this->service_executive->CurrentValue);
        if ($curVal != "") {
            $this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
            if ($this->service_executive->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->service_executive->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_executive->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->service_executive->getSelectFilter($this); // PHP
                $sqlWrk = $this->service_executive->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->service_executive->Lookup->renderViewRow($rswrk[0]);
                    $this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
                } else {
                    $this->service_executive->ViewValue = FormatNumber($this->service_executive->CurrentValue, $this->service_executive->formatPattern());
                }
            }
        } else {
            $this->service_executive->ViewValue = null;
        }

        // entry_time
        $this->entry_time->ViewValue = $this->entry_time->CurrentValue;
        $this->entry_time->ViewValue = FormatDateTime($this->entry_time->ViewValue, $this->entry_time->formatPattern());

        // current_reading
        $this->current_reading->ViewValue = $this->current_reading->CurrentValue;
        $this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, $this->current_reading->formatPattern());

        // error_ref
        $curVal = strval($this->error_ref->CurrentValue);
        if ($curVal != "") {
            $this->error_ref->ViewValue = $this->error_ref->lookupCacheOption($curVal);
            if ($this->error_ref->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->error_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->error_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->error_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->error_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->error_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->error_ref->ViewValue = $this->error_ref->displayValue($arwrk);
                } else {
                    $this->error_ref->ViewValue = $this->error_ref->CurrentValue;
                }
            }
        } else {
            $this->error_ref->ViewValue = null;
        }

        // service_type
        $curVal = strval($this->service_type->CurrentValue);
        if ($curVal != "") {
            $this->service_type->ViewValue = $this->service_type->lookupCacheOption($curVal);
            if ($this->service_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->service_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->service_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->service_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->service_type->Lookup->renderViewRow($rswrk[0]);
                    $this->service_type->ViewValue = $this->service_type->displayValue($arwrk);
                } else {
                    $this->service_type->ViewValue = FormatNumber($this->service_type->CurrentValue, $this->service_type->formatPattern());
                }
            }
        } else {
            $this->service_type->ViewValue = null;
        }

        // complaint
        $curVal = strval($this->complaint->CurrentValue);
        if ($curVal != "") {
            $this->complaint->ViewValue = $this->complaint->lookupCacheOption($curVal);
            if ($this->complaint->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->complaint->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $curVal, $this->complaint->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                $lookupFilter = $this->complaint->getSelectFilter($this); // PHP
                $sqlWrk = $this->complaint->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->complaint->Lookup->renderViewRow($rswrk[0]);
                    $this->complaint->ViewValue = $this->complaint->displayValue($arwrk);
                } else {
                    $this->complaint->ViewValue = $this->complaint->CurrentValue;
                }
            }
        } else {
            $this->complaint->ViewValue = null;
        }

        // observation
        $this->observation->ViewValue = $this->observation->CurrentValue;

        // product_replaced
        $curVal = strval($this->product_replaced->CurrentValue);
        if ($curVal != "") {
            $this->product_replaced->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
            if ($this->product_replaced->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->product_replaced->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->product_replaced->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->product_replaced->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_replaced->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->product_replaced->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->product_replaced->Lookup->renderViewRow($row);
                        $this->product_replaced->ViewValue->add($this->product_replaced->displayValue($arwrk));
                    }
                } else {
                    $this->product_replaced->ViewValue = $this->product_replaced->CurrentValue;
                }
            }
        } else {
            $this->product_replaced->ViewValue = null;
        }

        // consumable_replaced
        $curVal = strval($this->consumable_replaced->CurrentValue);
        if ($curVal != "") {
            $this->consumable_replaced->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
            if ($this->consumable_replaced->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->consumable_replaced->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->consumable_replaced->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->consumable_replaced->getSelectFilter($this); // PHP
                $sqlWrk = $this->consumable_replaced->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->consumable_replaced->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->consumable_replaced->Lookup->renderViewRow($row);
                        $this->consumable_replaced->ViewValue->add($this->consumable_replaced->displayValue($arwrk));
                    }
                } else {
                    $this->consumable_replaced->ViewValue = $this->consumable_replaced->CurrentValue;
                }
            }
        } else {
            $this->consumable_replaced->ViewValue = null;
        }

        // work_detail
        $this->work_detail->ViewValue = $this->work_detail->CurrentValue;

        // future_task
        $this->future_task->ViewValue = $this->future_task->CurrentValue;

        // last_status
        $curVal = strval($this->last_status->CurrentValue);
        if ($curVal != "") {
            $this->last_status->ViewValue = $this->last_status->lookupCacheOption($curVal);
            if ($this->last_status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->last_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->last_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->last_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->last_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->last_status->Lookup->renderViewRow($rswrk[0]);
                    $this->last_status->ViewValue = $this->last_status->displayValue($arwrk);
                } else {
                    $this->last_status->ViewValue = FormatNumber($this->last_status->CurrentValue, $this->last_status->formatPattern());
                }
            }
        } else {
            $this->last_status->ViewValue = null;
        }

        // uploads
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }

        // out_time
        $this->out_time->ViewValue = $this->out_time->CurrentValue;
        $this->out_time->ViewValue = FormatDateTime($this->out_time->ViewValue, $this->out_time->formatPattern());

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // a_operator
        $curVal = strval($this->a_operator->CurrentValue);
        if ($curVal != "") {
            $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            if ($this->a_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                } else {
                    $this->a_operator->ViewValue = FormatNumber($this->a_operator->CurrentValue, $this->a_operator->formatPattern());
                }
            }
        } else {
            $this->a_operator->ViewValue = null;
        }

        // invoice
        $this->invoice->ViewValue = $this->invoice->CurrentValue;

        // invoice_date
        $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
        $this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, $this->invoice_date->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // buyer_id
        $this->buyer_id->HrefValue = "";
        $this->buyer_id->TooltipValue = "";

        // hardware_id
        $this->hardware_id->HrefValue = "";
        $this->hardware_id->TooltipValue = "";

        // service_executive
        $this->service_executive->HrefValue = "";
        $this->service_executive->TooltipValue = "";

        // entry_time
        $this->entry_time->HrefValue = "";
        $this->entry_time->TooltipValue = "";

        // current_reading
        $this->current_reading->HrefValue = "";
        $this->current_reading->TooltipValue = "";

        // error_ref
        $this->error_ref->HrefValue = "";
        $this->error_ref->TooltipValue = "";

        // service_type
        $this->service_type->HrefValue = "";
        $this->service_type->TooltipValue = "";

        // complaint
        $this->complaint->HrefValue = "";
        $this->complaint->TooltipValue = "";

        // observation
        $this->observation->HrefValue = "";
        $this->observation->TooltipValue = "";

        // product_replaced
        $this->product_replaced->HrefValue = "";
        $this->product_replaced->TooltipValue = "";

        // consumable_replaced
        $this->consumable_replaced->HrefValue = "";
        $this->consumable_replaced->TooltipValue = "";

        // work_detail
        $this->work_detail->HrefValue = "";
        $this->work_detail->TooltipValue = "";

        // future_task
        $this->future_task->HrefValue = "";
        $this->future_task->TooltipValue = "";

        // last_status
        $this->last_status->HrefValue = "";
        $this->last_status->TooltipValue = "";

        // uploads
        $this->uploads->HrefValue = "";
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";

        // out_time
        $this->out_time->HrefValue = "";
        $this->out_time->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // invoice
        $this->invoice->HrefValue = "";
        $this->invoice->TooltipValue = "";

        // invoice_date
        $this->invoice_date->HrefValue = "";
        $this->invoice_date->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->EditValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                }
            }
        } else {
            $this->buyer_id->EditValue = null;
        }

        // hardware_id
        $this->hardware_id->setupEditAttributes();
        $curVal = strval($this->hardware_id->CurrentValue);
        if ($curVal != "") {
            $this->hardware_id->EditValue = $this->hardware_id->lookupCacheOption($curVal);
            if ($this->hardware_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->hardware_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hardware_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->hardware_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->hardware_id->Lookup->renderViewRow($rswrk[0]);
                    $this->hardware_id->EditValue = $this->hardware_id->displayValue($arwrk);
                } else {
                    $this->hardware_id->EditValue = FormatNumber($this->hardware_id->CurrentValue, $this->hardware_id->formatPattern());
                }
            }
        } else {
            $this->hardware_id->EditValue = null;
        }

        // service_executive
        $this->service_executive->setupEditAttributes();
        $this->service_executive->EditValue = $this->service_executive->CurrentValue;
        $curVal = strval($this->service_executive->CurrentValue);
        if ($curVal != "") {
            $this->service_executive->EditValue = $this->service_executive->lookupCacheOption($curVal);
            if ($this->service_executive->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->service_executive->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->service_executive->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->service_executive->getSelectFilter($this); // PHP
                $sqlWrk = $this->service_executive->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->service_executive->Lookup->renderViewRow($rswrk[0]);
                    $this->service_executive->EditValue = $this->service_executive->displayValue($arwrk);
                } else {
                    $this->service_executive->EditValue = FormatNumber($this->service_executive->CurrentValue, $this->service_executive->formatPattern());
                }
            }
        } else {
            $this->service_executive->EditValue = null;
        }

        // entry_time
        $this->entry_time->setupEditAttributes();
        $this->entry_time->EditValue = FormatDateTime($this->entry_time->CurrentValue, $this->entry_time->formatPattern());
        $this->entry_time->PlaceHolder = RemoveHtml($this->entry_time->caption());

        // current_reading
        $this->current_reading->setupEditAttributes();
        $this->current_reading->EditValue = $this->current_reading->CurrentValue;
        $this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());
        if (strval($this->current_reading->EditValue) != "" && is_numeric($this->current_reading->EditValue)) {
            $this->current_reading->EditValue = FormatNumber($this->current_reading->EditValue, null);
        }

        // error_ref
        $this->error_ref->setupEditAttributes();
        $this->error_ref->PlaceHolder = RemoveHtml($this->error_ref->caption());

        // service_type
        $this->service_type->setupEditAttributes();
        $this->service_type->PlaceHolder = RemoveHtml($this->service_type->caption());

        // complaint
        $this->complaint->setupEditAttributes();
        $curVal = strval($this->complaint->CurrentValue);
        if ($curVal != "") {
            $this->complaint->EditValue = $this->complaint->lookupCacheOption($curVal);
            if ($this->complaint->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->complaint->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $curVal, $this->complaint->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                $lookupFilter = $this->complaint->getSelectFilter($this); // PHP
                $sqlWrk = $this->complaint->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->complaint->Lookup->renderViewRow($rswrk[0]);
                    $this->complaint->EditValue = $this->complaint->displayValue($arwrk);
                } else {
                    $this->complaint->EditValue = $this->complaint->CurrentValue;
                }
            }
        } else {
            $this->complaint->EditValue = null;
        }

        // observation
        $this->observation->setupEditAttributes();
        $this->observation->EditValue = $this->observation->CurrentValue;
        $this->observation->PlaceHolder = RemoveHtml($this->observation->caption());

        // product_replaced
        $this->product_replaced->EditCustomAttributes = $this->product_replaced->getEditCustomAttributes(); // PHP
        $this->product_replaced->PlaceHolder = RemoveHtml($this->product_replaced->caption());

        // consumable_replaced
        $this->consumable_replaced->PlaceHolder = RemoveHtml($this->consumable_replaced->caption());

        // work_detail
        $this->work_detail->setupEditAttributes();
        $this->work_detail->EditValue = $this->work_detail->CurrentValue;
        $this->work_detail->PlaceHolder = RemoveHtml($this->work_detail->caption());

        // future_task
        $this->future_task->setupEditAttributes();
        $this->future_task->EditValue = $this->future_task->CurrentValue;
        $this->future_task->PlaceHolder = RemoveHtml($this->future_task->caption());

        // last_status
        $this->last_status->setupEditAttributes();
        $this->last_status->PlaceHolder = RemoveHtml($this->last_status->caption());

        // uploads
        $this->uploads->setupEditAttributes();
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // out_time
        $this->out_time->setupEditAttributes();
        $this->out_time->EditValue = FormatDateTime($this->out_time->CurrentValue, $this->out_time->formatPattern());
        $this->out_time->PlaceHolder = RemoveHtml($this->out_time->caption());

        // operator

        // datetime

        // a_operator

        // invoice
        $this->invoice->setupEditAttributes();
        if (!$this->invoice->Raw) {
            $this->invoice->CurrentValue = HtmlDecode($this->invoice->CurrentValue);
        }
        $this->invoice->EditValue = $this->invoice->CurrentValue;
        $this->invoice->PlaceHolder = RemoveHtml($this->invoice->caption());

        // invoice_date
        $this->invoice_date->setupEditAttributes();
        $this->invoice_date->EditValue = FormatDateTime($this->invoice_date->CurrentValue, $this->invoice_date->formatPattern());
        $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->hardware_id);
                    $doc->exportCaption($this->service_executive);
                    $doc->exportCaption($this->entry_time);
                    $doc->exportCaption($this->current_reading);
                    $doc->exportCaption($this->error_ref);
                    $doc->exportCaption($this->service_type);
                    $doc->exportCaption($this->complaint);
                    $doc->exportCaption($this->observation);
                    $doc->exportCaption($this->product_replaced);
                    $doc->exportCaption($this->consumable_replaced);
                    $doc->exportCaption($this->work_detail);
                    $doc->exportCaption($this->future_task);
                    $doc->exportCaption($this->last_status);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->out_time);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->invoice);
                    $doc->exportCaption($this->invoice_date);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->hardware_id);
                    $doc->exportCaption($this->service_executive);
                    $doc->exportCaption($this->entry_time);
                    $doc->exportCaption($this->current_reading);
                    $doc->exportCaption($this->error_ref);
                    $doc->exportCaption($this->service_type);
                    $doc->exportCaption($this->complaint);
                    $doc->exportCaption($this->observation);
                    $doc->exportCaption($this->product_replaced);
                    $doc->exportCaption($this->consumable_replaced);
                    $doc->exportCaption($this->work_detail);
                    $doc->exportCaption($this->last_status);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->out_time);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->invoice);
                    $doc->exportCaption($this->invoice_date);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->hardware_id);
                        $doc->exportField($this->service_executive);
                        $doc->exportField($this->entry_time);
                        $doc->exportField($this->current_reading);
                        $doc->exportField($this->error_ref);
                        $doc->exportField($this->service_type);
                        $doc->exportField($this->complaint);
                        $doc->exportField($this->observation);
                        $doc->exportField($this->product_replaced);
                        $doc->exportField($this->consumable_replaced);
                        $doc->exportField($this->work_detail);
                        $doc->exportField($this->future_task);
                        $doc->exportField($this->last_status);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->out_time);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->invoice);
                        $doc->exportField($this->invoice_date);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->hardware_id);
                        $doc->exportField($this->service_executive);
                        $doc->exportField($this->entry_time);
                        $doc->exportField($this->current_reading);
                        $doc->exportField($this->error_ref);
                        $doc->exportField($this->service_type);
                        $doc->exportField($this->complaint);
                        $doc->exportField($this->observation);
                        $doc->exportField($this->product_replaced);
                        $doc->exportField($this->consumable_replaced);
                        $doc->exportField($this->work_detail);
                        $doc->exportField($this->last_status);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->out_time);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->invoice);
                        $doc->exportField($this->invoice_date);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
