<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SampleReqCartStatusView extends SampleReqCartStatus
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SampleReqCartStatusView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "samplereqcartstatusview";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->datetime->setVisibility();
        $this->po_id->setVisibility();
        $this->r_text->setVisibility();
        $this->old_ref->setVisibility();
        $this->status->setVisibility();
        $this->request_by->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->upload->setVisibility();
        $this->operator->setVisibility();
        $this->design->setVisibility();
        $this->color->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->shipping_mode->setVisibility();
        $this->delivery_week->setVisibility();
        $this->purpose->setVisibility();
        $this->label->setVisibility();
        $this->ssd->setVisibility();
        $this->remarks->setVisibility();
        $this->shipping_address->setVisibility();
        $this->shipping_address_2->setVisibility();
        $this->sp_remarks->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
        $this->pp_remarks->setVisibility();
        $this->price->setVisibility();
        $this->declaration->setVisibility();
        $this->app_status->setVisibility();
        $this->app_operator->setVisibility();
        $this->app_datetime->setVisibility();
        $this->po_remarks->setVisibility();
        $this->po_operator->setVisibility();
        $this->po_datetime->setVisibility();
        $this->bom->setVisibility();
        $this->pd_upload->setVisibility();
        $this->pd_comments->setVisibility();
        $this->pd_operator->setVisibility();
        $this->pd_datetime->setVisibility();
        $this->da_comments->setVisibility();
        $this->da_status->setVisibility();
        $this->da_operator->setVisibility();
        $this->da_datetime->setVisibility();
        $this->dispatch->setVisibility();
        $this->d_operator->setVisibility();
        $this->d_datetime->setVisibility();
        $this->r_comments->setVisibility();
        $this->r_operator->setVisibility();
        $this->r_datetime->setVisibility();
        $this->f_yn->setVisibility();
        $this->feedback->setVisibility();
        $this->f_operator->setVisibility();
        $this->f_datetime->setVisibility();
        $this->f_upload->setVisibility();
        $this->fr_operator->setVisibility();
        $this->fr_datetime->setVisibility();
        $this->req_chat_id->setVisibility();
        $this->_barcode->setVisibility();
        $this->url->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sample_req_cart_status';
        $this->TableName = 'sample_req_cart_status';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (sample_req_cart_status)
        if (!isset($GLOBALS["sample_req_cart_status"]) || $GLOBALS["sample_req_cart_status"]::class == PROJECT_NAMESPACE . "sample_req_cart_status") {
            $GLOBALS["sample_req_cart_status"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->RecKey["id"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_status');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "samplereqcartstatusview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $this->pd_upload->OldUploadPath = $this->pd_upload->getUploadPath(); // PHP
                $this->pd_upload->UploadPath = $this->pd_upload->OldUploadPath;
                $this->f_upload->OldUploadPath = $this->f_upload->getUploadPath(); // PHP
                $this->f_upload->UploadPath = $this->f_upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->request_by);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->shipping_mode);
        $this->setupLookupOptions($this->delivery_week);
        $this->setupLookupOptions($this->purpose);
        $this->setupLookupOptions($this->label);
        $this->setupLookupOptions($this->shipping_address);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->app_status);
        $this->setupLookupOptions($this->app_operator);
        $this->setupLookupOptions($this->po_operator);
        $this->setupLookupOptions($this->pd_operator);
        $this->setupLookupOptions($this->da_status);
        $this->setupLookupOptions($this->da_operator);
        $this->setupLookupOptions($this->d_operator);
        $this->setupLookupOptions($this->r_operator);
        $this->setupLookupOptions($this->f_yn);
        $this->setupLookupOptions($this->f_operator);
        $this->setupLookupOptions($this->fr_operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (Post("id") !== null) {
            $this->id->setFormValue(Post("id"));
            $this->RecKey["id"] = $this->id->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "samplereqcartstatuslist"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $res = ($this->Recordset = ExecuteQuery($sql, $conn));
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "samplereqcartstatuslist"; // No matching record, return to list
                    }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = RowType::VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset?->free();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->datetime->setDbValue($row['datetime']);
        $this->po_id->setDbValue($row['po_id']);
        $this->r_text->setDbValue($row['r_text']);
        $this->old_ref->setDbValue($row['old_ref']);
        $this->status->setDbValue($row['status']);
        $this->request_by->setDbValue($row['request_by']);
        if (array_key_exists('EV__request_by', $row)) {
            $this->request_by->VirtualValue = $row['EV__request_by']; // Set up virtual field value
        } else {
            $this->request_by->VirtualValue = ""; // Clear value
        }
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->upload->setDbValue($this->upload->Upload->DbValue);
        $this->operator->setDbValue($row['operator']);
        $this->design->setDbValue($row['design']);
        $this->color->setDbValue($row['color']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->delivery_week->setDbValue($row['delivery_week']);
        $this->purpose->setDbValue($row['purpose']);
        $this->label->setDbValue($row['label']);
        $this->ssd->setDbValue($row['ssd']);
        $this->remarks->setDbValue($row['remarks']);
        $this->shipping_address->setDbValue($row['shipping_address']);
        $this->shipping_address_2->setDbValue($row['shipping_address_2']);
        $this->sp_remarks->setDbValue($row['sp_remarks']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->pp_remarks->setDbValue($row['pp_remarks']);
        $this->price->setDbValue($row['price']);
        $this->declaration->setDbValue($row['declaration']);
        $this->app_status->setDbValue($row['app_status']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->po_remarks->setDbValue($row['po_remarks']);
        $this->po_operator->setDbValue($row['po_operator']);
        $this->po_datetime->setDbValue($row['po_datetime']);
        $this->bom->setDbValue($row['bom']);
        $this->pd_upload->Upload->DbValue = $row['pd_upload'];
        $this->pd_upload->setDbValue($this->pd_upload->Upload->DbValue);
        $this->pd_comments->setDbValue($row['pd_comments']);
        $this->pd_operator->setDbValue($row['pd_operator']);
        $this->pd_datetime->setDbValue($row['pd_datetime']);
        $this->da_comments->setDbValue($row['da_comments']);
        $this->da_status->setDbValue($row['da_status']);
        $this->da_operator->setDbValue($row['da_operator']);
        $this->da_datetime->setDbValue($row['da_datetime']);
        $this->dispatch->setDbValue($row['dispatch']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->r_comments->setDbValue($row['r_comments']);
        $this->r_operator->setDbValue($row['r_operator']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->f_yn->setDbValue($row['f_yn']);
        $this->feedback->setDbValue($row['feedback']);
        $this->f_operator->setDbValue($row['f_operator']);
        $this->f_datetime->setDbValue($row['f_datetime']);
        $this->f_upload->Upload->DbValue = $row['f_upload'];
        $this->f_upload->setDbValue($this->f_upload->Upload->DbValue);
        $this->fr_operator->setDbValue($row['fr_operator']);
        $this->fr_datetime->setDbValue($row['fr_datetime']);
        $this->req_chat_id->setDbValue($row['req_chat_id']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->url->setDbValue($row['url']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['old_ref'] = $this->old_ref->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['request_by'] = $this->request_by->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['upload'] = $this->upload->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['color'] = $this->color->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['shipping_mode'] = $this->shipping_mode->DefaultValue;
        $row['delivery_week'] = $this->delivery_week->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['ssd'] = $this->ssd->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['shipping_address'] = $this->shipping_address->DefaultValue;
        $row['shipping_address_2'] = $this->shipping_address_2->DefaultValue;
        $row['sp_remarks'] = $this->sp_remarks->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['pp_remarks'] = $this->pp_remarks->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['declaration'] = $this->declaration->DefaultValue;
        $row['app_status'] = $this->app_status->DefaultValue;
        $row['app_operator'] = $this->app_operator->DefaultValue;
        $row['app_datetime'] = $this->app_datetime->DefaultValue;
        $row['po_remarks'] = $this->po_remarks->DefaultValue;
        $row['po_operator'] = $this->po_operator->DefaultValue;
        $row['po_datetime'] = $this->po_datetime->DefaultValue;
        $row['bom'] = $this->bom->DefaultValue;
        $row['pd_upload'] = $this->pd_upload->DefaultValue;
        $row['pd_comments'] = $this->pd_comments->DefaultValue;
        $row['pd_operator'] = $this->pd_operator->DefaultValue;
        $row['pd_datetime'] = $this->pd_datetime->DefaultValue;
        $row['da_comments'] = $this->da_comments->DefaultValue;
        $row['da_status'] = $this->da_status->DefaultValue;
        $row['da_operator'] = $this->da_operator->DefaultValue;
        $row['da_datetime'] = $this->da_datetime->DefaultValue;
        $row['dispatch'] = $this->dispatch->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['r_comments'] = $this->r_comments->DefaultValue;
        $row['r_operator'] = $this->r_operator->DefaultValue;
        $row['r_datetime'] = $this->r_datetime->DefaultValue;
        $row['f_yn'] = $this->f_yn->DefaultValue;
        $row['feedback'] = $this->feedback->DefaultValue;
        $row['f_operator'] = $this->f_operator->DefaultValue;
        $row['f_datetime'] = $this->f_datetime->DefaultValue;
        $row['f_upload'] = $this->f_upload->DefaultValue;
        $row['fr_operator'] = $this->fr_operator->DefaultValue;
        $row['fr_datetime'] = $this->fr_datetime->DefaultValue;
        $row['req_chat_id'] = $this->req_chat_id->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // datetime

        // po_id

        // r_text

        // old_ref

        // status

        // request_by

        // company_id

        // partner_id

        // upload

        // operator

        // design

        // color

        // size

        // quantity

        // shipping_mode

        // delivery_week

        // purpose

        // label

        // ssd

        // remarks

        // shipping_address

        // shipping_address_2

        // sp_remarks

        // a_operator

        // a_datetime

        // pp_remarks

        // price

        // declaration

        // app_status

        // app_operator

        // app_datetime

        // po_remarks

        // po_operator

        // po_datetime

        // bom

        // pd_upload

        // pd_comments

        // pd_operator

        // pd_datetime

        // da_comments

        // da_status

        // da_operator

        // da_datetime

        // dispatch

        // d_operator

        // d_datetime

        // r_comments

        // r_operator

        // r_datetime

        // f_yn

        // feedback

        // f_operator

        // f_datetime

        // f_upload

        // fr_operator

        // fr_datetime

        // req_chat_id

        // barcode

        // url

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // r_text
            $this->r_text->ViewValue = $this->r_text->CurrentValue;

            // old_ref
            $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // request_by
            if ($this->request_by->VirtualValue != "") {
                $this->request_by->ViewValue = $this->request_by->VirtualValue;
            } else {
                $this->request_by->ViewValue = $this->request_by->CurrentValue;
                $curVal = strval($this->request_by->CurrentValue);
                if ($curVal != "") {
                    $this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
                    if ($this->request_by->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->request_by->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->request_by->Lookup->renderViewRow($rswrk[0]);
                            $this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
                        } else {
                            $this->request_by->ViewValue = $this->request_by->CurrentValue;
                        }
                    }
                } else {
                    $this->request_by->ViewValue = null;
                }
            }

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // color
            $this->color->ViewValue = $this->color->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // shipping_mode
            if (strval($this->shipping_mode->CurrentValue) != "") {
                $this->shipping_mode->ViewValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
            } else {
                $this->shipping_mode->ViewValue = null;
            }

            // delivery_week
            $curVal = strval($this->delivery_week->CurrentValue);
            if ($curVal != "") {
                $this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
                if ($this->delivery_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->delivery_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->delivery_week->Lookup->renderViewRow($rswrk[0]);
                        $this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
                    } else {
                        $this->delivery_week->ViewValue = FormatNumber($this->delivery_week->CurrentValue, $this->delivery_week->formatPattern());
                    }
                }
            } else {
                $this->delivery_week->ViewValue = null;
            }

            // purpose
            $curVal = strval($this->purpose->CurrentValue);
            if ($curVal != "") {
                $this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
                if ($this->purpose->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->purpose->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->purpose->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->purpose->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->purpose->Lookup->renderViewRow($rswrk[0]);
                        $this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
                    } else {
                        $this->purpose->ViewValue = FormatNumber($this->purpose->CurrentValue, $this->purpose->formatPattern());
                    }
                }
            } else {
                $this->purpose->ViewValue = null;
            }

            // label
            $curVal = strval($this->label->CurrentValue);
            if ($curVal != "") {
                $this->label->ViewValue = $this->label->lookupCacheOption($curVal);
                if ($this->label->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->label->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->label->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->label->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->label->Lookup->renderViewRow($rswrk[0]);
                        $this->label->ViewValue = $this->label->displayValue($arwrk);
                    } else {
                        $this->label->ViewValue = $this->label->CurrentValue;
                    }
                }
            } else {
                $this->label->ViewValue = null;
            }

            // ssd
            $this->ssd->ViewValue = $this->ssd->CurrentValue;
            $this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, $this->ssd->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // shipping_address_2
            $this->shipping_address_2->ViewValue = $this->shipping_address_2->CurrentValue;

            // sp_remarks
            $this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // pp_remarks
            $this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;

            // price
            $this->price->ViewValue = $this->price->CurrentValue;

            // declaration
            $this->declaration->ViewValue = $this->declaration->CurrentValue;

            // app_status
            $curVal = strval($this->app_status->CurrentValue);
            if ($curVal != "") {
                $this->app_status->ViewValue = $this->app_status->lookupCacheOption($curVal);
                if ($this->app_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->app_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->app_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->app_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->app_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->app_status->Lookup->renderViewRow($rswrk[0]);
                        $this->app_status->ViewValue = $this->app_status->displayValue($arwrk);
                    } else {
                        $this->app_status->ViewValue = FormatNumber($this->app_status->CurrentValue, $this->app_status->formatPattern());
                    }
                }
            } else {
                $this->app_status->ViewValue = null;
            }

            // app_operator
            $this->app_operator->ViewValue = $this->app_operator->CurrentValue;
            $curVal = strval($this->app_operator->CurrentValue);
            if ($curVal != "") {
                $this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
                if ($this->app_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->app_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->app_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->app_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->app_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
                    } else {
                        $this->app_operator->ViewValue = FormatNumber($this->app_operator->CurrentValue, $this->app_operator->formatPattern());
                    }
                }
            } else {
                $this->app_operator->ViewValue = null;
            }

            // app_datetime
            $this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
            $this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, $this->app_datetime->formatPattern());

            // po_remarks
            $this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;

            // po_operator
            $curVal = strval($this->po_operator->CurrentValue);
            if ($curVal != "") {
                $this->po_operator->ViewValue = $this->po_operator->lookupCacheOption($curVal);
                if ($this->po_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->po_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->po_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->po_operator->ViewValue = $this->po_operator->displayValue($arwrk);
                    } else {
                        $this->po_operator->ViewValue = FormatNumber($this->po_operator->CurrentValue, $this->po_operator->formatPattern());
                    }
                }
            } else {
                $this->po_operator->ViewValue = null;
            }

            // po_datetime
            $this->po_datetime->ViewValue = $this->po_datetime->CurrentValue;
            $this->po_datetime->ViewValue = FormatDateTime($this->po_datetime->ViewValue, $this->po_datetime->formatPattern());

            // bom
            $this->bom->ViewValue = $this->bom->CurrentValue;

            // pd_upload
            $this->pd_upload->UploadPath = $this->pd_upload->getUploadPath(); // PHP
            if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
                $this->pd_upload->ViewValue = $this->pd_upload->Upload->DbValue;
            } else {
                $this->pd_upload->ViewValue = "";
            }

            // pd_comments
            $this->pd_comments->ViewValue = $this->pd_comments->CurrentValue;

            // pd_operator
            $curVal = strval($this->pd_operator->CurrentValue);
            if ($curVal != "") {
                $this->pd_operator->ViewValue = $this->pd_operator->lookupCacheOption($curVal);
                if ($this->pd_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->pd_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pd_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->pd_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->pd_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->pd_operator->ViewValue = $this->pd_operator->displayValue($arwrk);
                    } else {
                        $this->pd_operator->ViewValue = FormatNumber($this->pd_operator->CurrentValue, $this->pd_operator->formatPattern());
                    }
                }
            } else {
                $this->pd_operator->ViewValue = null;
            }

            // pd_datetime
            $this->pd_datetime->ViewValue = $this->pd_datetime->CurrentValue;
            $this->pd_datetime->ViewValue = FormatDateTime($this->pd_datetime->ViewValue, $this->pd_datetime->formatPattern());

            // da_comments
            $this->da_comments->ViewValue = $this->da_comments->CurrentValue;

            // da_status
            $curVal = strval($this->da_status->CurrentValue);
            if ($curVal != "") {
                $this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
                if ($this->da_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->da_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->da_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->da_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->da_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->da_status->Lookup->renderViewRow($rswrk[0]);
                        $this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
                    } else {
                        $this->da_status->ViewValue = FormatNumber($this->da_status->CurrentValue, $this->da_status->formatPattern());
                    }
                }
            } else {
                $this->da_status->ViewValue = null;
            }

            // da_operator
            $curVal = strval($this->da_operator->CurrentValue);
            if ($curVal != "") {
                $this->da_operator->ViewValue = $this->da_operator->lookupCacheOption($curVal);
                if ($this->da_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->da_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->da_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->da_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->da_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->da_operator->ViewValue = $this->da_operator->displayValue($arwrk);
                    } else {
                        $this->da_operator->ViewValue = FormatNumber($this->da_operator->CurrentValue, $this->da_operator->formatPattern());
                    }
                }
            } else {
                $this->da_operator->ViewValue = null;
            }

            // da_datetime
            $this->da_datetime->ViewValue = $this->da_datetime->CurrentValue;
            $this->da_datetime->ViewValue = FormatDateTime($this->da_datetime->ViewValue, $this->da_datetime->formatPattern());

            // dispatch
            $this->dispatch->ViewValue = $this->dispatch->CurrentValue;

            // d_operator
            $curVal = strval($this->d_operator->CurrentValue);
            if ($curVal != "") {
                $this->d_operator->ViewValue = $this->d_operator->lookupCacheOption($curVal);
                if ($this->d_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->d_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->d_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->d_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->d_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->d_operator->ViewValue = $this->d_operator->displayValue($arwrk);
                    } else {
                        $this->d_operator->ViewValue = FormatNumber($this->d_operator->CurrentValue, $this->d_operator->formatPattern());
                    }
                }
            } else {
                $this->d_operator->ViewValue = null;
            }

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // r_comments
            $this->r_comments->ViewValue = $this->r_comments->CurrentValue;

            // r_operator
            $curVal = strval($this->r_operator->CurrentValue);
            if ($curVal != "") {
                $this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
                if ($this->r_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->r_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->r_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->r_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->r_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
                    } else {
                        $this->r_operator->ViewValue = FormatNumber($this->r_operator->CurrentValue, $this->r_operator->formatPattern());
                    }
                }
            } else {
                $this->r_operator->ViewValue = null;
            }

            // r_datetime
            $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
            $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

            // f_yn
            $curVal = strval($this->f_yn->CurrentValue);
            if ($curVal != "") {
                $this->f_yn->ViewValue = $this->f_yn->lookupCacheOption($curVal);
                if ($this->f_yn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->f_yn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->f_yn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->f_yn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->f_yn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->f_yn->Lookup->renderViewRow($rswrk[0]);
                        $this->f_yn->ViewValue = $this->f_yn->displayValue($arwrk);
                    } else {
                        $this->f_yn->ViewValue = FormatNumber($this->f_yn->CurrentValue, $this->f_yn->formatPattern());
                    }
                }
            } else {
                $this->f_yn->ViewValue = null;
            }

            // feedback
            $this->feedback->ViewValue = $this->feedback->CurrentValue;

            // f_operator
            $this->f_operator->ViewValue = $this->f_operator->CurrentValue;
            $curVal = strval($this->f_operator->CurrentValue);
            if ($curVal != "") {
                $this->f_operator->ViewValue = $this->f_operator->lookupCacheOption($curVal);
                if ($this->f_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->f_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->f_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->f_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->f_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->f_operator->ViewValue = $this->f_operator->displayValue($arwrk);
                    } else {
                        $this->f_operator->ViewValue = FormatNumber($this->f_operator->CurrentValue, $this->f_operator->formatPattern());
                    }
                }
            } else {
                $this->f_operator->ViewValue = null;
            }

            // f_datetime
            $this->f_datetime->ViewValue = $this->f_datetime->CurrentValue;
            $this->f_datetime->ViewValue = FormatDateTime($this->f_datetime->ViewValue, $this->f_datetime->formatPattern());

            // f_upload
            $this->f_upload->UploadPath = $this->f_upload->getUploadPath(); // PHP
            if (!EmptyValue($this->f_upload->Upload->DbValue)) {
                $this->f_upload->ImageWidth = 0;
                $this->f_upload->ImageHeight = 50;
                $this->f_upload->ImageAlt = $this->f_upload->alt();
                $this->f_upload->ImageCssClass = "ew-image";
                $this->f_upload->ViewValue = $this->f_upload->Upload->DbValue;
            } else {
                $this->f_upload->ViewValue = "";
            }

            // fr_operator
            $curVal = strval($this->fr_operator->CurrentValue);
            if ($curVal != "") {
                $this->fr_operator->ViewValue = $this->fr_operator->lookupCacheOption($curVal);
                if ($this->fr_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->fr_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->fr_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->fr_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->fr_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->fr_operator->ViewValue = $this->fr_operator->displayValue($arwrk);
                    } else {
                        $this->fr_operator->ViewValue = FormatNumber($this->fr_operator->CurrentValue, $this->fr_operator->formatPattern());
                    }
                }
            } else {
                $this->fr_operator->ViewValue = null;
            }

            // fr_datetime
            $this->fr_datetime->ViewValue = $this->fr_datetime->CurrentValue;
            $this->fr_datetime->ViewValue = FormatDateTime($this->fr_datetime->ViewValue, $this->fr_datetime->formatPattern());

            // req_chat_id
            $this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // r_text
            $this->r_text->HrefValue = "";
            $this->r_text->TooltipValue = "";

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }
            $this->old_ref->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // request_by
            $this->request_by->HrefValue = "";
            $this->request_by->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            if (!EmptyValue($this->partner_id->CurrentValue)) {
                $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
                $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
                }
            } else {
                $this->partner_id->HrefValue = "";
            }
            $this->partner_id->TooltipValue = "";

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
            $this->upload->TooltipValue = "";
            if ($this->upload->UseColorbox) {
                if (EmptyValue($this->upload->TooltipValue)) {
                    $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->upload->LinkAttrs["data-rel"] = "sample_req_cart_status_x_upload";
                $this->upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // color
            $this->color->HrefValue = "";
            $this->color->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";
            $this->shipping_mode->TooltipValue = "";

            // delivery_week
            $this->delivery_week->HrefValue = "";
            $this->delivery_week->TooltipValue = "";

            // purpose
            $this->purpose->HrefValue = "";
            $this->purpose->TooltipValue = "";

            // label
            $this->label->HrefValue = "";
            $this->label->TooltipValue = "";

            // ssd
            $this->ssd->HrefValue = "";
            $this->ssd->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // shipping_address_2
            $this->shipping_address_2->HrefValue = "";
            $this->shipping_address_2->TooltipValue = "";

            // sp_remarks
            $this->sp_remarks->HrefValue = "";
            $this->sp_remarks->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";

            // pp_remarks
            $this->pp_remarks->HrefValue = "";
            $this->pp_remarks->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // declaration
            $this->declaration->HrefValue = "";
            $this->declaration->TooltipValue = "";

            // app_status
            $this->app_status->HrefValue = "";
            $this->app_status->TooltipValue = "";

            // app_operator
            $this->app_operator->HrefValue = "";
            $this->app_operator->TooltipValue = "";

            // app_datetime
            $this->app_datetime->HrefValue = "";
            $this->app_datetime->TooltipValue = "";

            // po_remarks
            $this->po_remarks->HrefValue = "";
            $this->po_remarks->TooltipValue = "";

            // po_operator
            $this->po_operator->HrefValue = "";
            $this->po_operator->TooltipValue = "";

            // po_datetime
            $this->po_datetime->HrefValue = "";
            $this->po_datetime->TooltipValue = "";

            // bom
            $this->bom->HrefValue = "";
            $this->bom->TooltipValue = "";

            // pd_upload
            $this->pd_upload->UploadPath = $this->pd_upload->getUploadPath(); // PHP
            if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
                $this->pd_upload->HrefValue = "%u"; // Add prefix/suffix
                $this->pd_upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->pd_upload->HrefValue = FullUrl($this->pd_upload->HrefValue, "href");
                }
            } else {
                $this->pd_upload->HrefValue = "";
            }
            $this->pd_upload->ExportHrefValue = $this->pd_upload->UploadPath . $this->pd_upload->Upload->DbValue;
            $this->pd_upload->TooltipValue = "";

            // pd_comments
            $this->pd_comments->HrefValue = "";
            $this->pd_comments->TooltipValue = "";

            // pd_operator
            $this->pd_operator->HrefValue = "";
            $this->pd_operator->TooltipValue = "";

            // pd_datetime
            $this->pd_datetime->HrefValue = "";
            $this->pd_datetime->TooltipValue = "";

            // da_comments
            $this->da_comments->HrefValue = "";
            $this->da_comments->TooltipValue = "";

            // da_status
            $this->da_status->HrefValue = "";
            $this->da_status->TooltipValue = "";

            // da_operator
            $this->da_operator->HrefValue = "";
            $this->da_operator->TooltipValue = "";

            // da_datetime
            $this->da_datetime->HrefValue = "";
            $this->da_datetime->TooltipValue = "";

            // dispatch
            $this->dispatch->HrefValue = "";
            $this->dispatch->TooltipValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";
            $this->d_operator->TooltipValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
            $this->d_datetime->TooltipValue = "";

            // r_comments
            $this->r_comments->HrefValue = "";
            $this->r_comments->TooltipValue = "";

            // r_operator
            $this->r_operator->HrefValue = "";
            $this->r_operator->TooltipValue = "";

            // r_datetime
            $this->r_datetime->HrefValue = "";
            $this->r_datetime->TooltipValue = "";

            // f_yn
            $this->f_yn->HrefValue = "";
            $this->f_yn->TooltipValue = "";

            // feedback
            $this->feedback->HrefValue = "";
            $this->feedback->TooltipValue = "";

            // f_operator
            $this->f_operator->HrefValue = "";
            $this->f_operator->TooltipValue = "";

            // f_datetime
            $this->f_datetime->HrefValue = "";
            $this->f_datetime->TooltipValue = "";

            // f_upload
            $this->f_upload->UploadPath = $this->f_upload->getUploadPath(); // PHP
            if (!EmptyValue($this->f_upload->Upload->DbValue)) {
                $this->f_upload->HrefValue = GetFileUploadUrl($this->f_upload, $this->f_upload->htmlDecode($this->f_upload->Upload->DbValue)); // Add prefix/suffix
                $this->f_upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->f_upload->HrefValue = FullUrl($this->f_upload->HrefValue, "href");
                }
            } else {
                $this->f_upload->HrefValue = "";
            }
            $this->f_upload->ExportHrefValue = $this->f_upload->UploadPath . $this->f_upload->Upload->DbValue;
            $this->f_upload->TooltipValue = "";
            if ($this->f_upload->UseColorbox) {
                if (EmptyValue($this->f_upload->TooltipValue)) {
                    $this->f_upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->f_upload->LinkAttrs["data-rel"] = "sample_req_cart_status_x_f_upload";
                $this->f_upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // fr_operator
            $this->fr_operator->HrefValue = "";
            $this->fr_operator->TooltipValue = "";

            // fr_datetime
            $this->fr_datetime->HrefValue = "";
            $this->fr_datetime->TooltipValue = "";

            // req_chat_id
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->req_chat_id->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->req_chat_id->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->req_chat_id->HrefValue = FullUrl($this->req_chat_id->HrefValue, "href");
                }
            } else {
                $this->req_chat_id->HrefValue = "";
            }
            $this->req_chat_id->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("samplereqcartstatuslist"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $pages->add(6);
        $pages->add(7);
        $pages->add(8);
        $pages->add(9);
        $pages->add(10);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_request_by":
                    break;
                case "x_company_id":
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_shipping_mode":
                    break;
                case "x_delivery_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_purpose":
                    break;
                case "x_label":
                    break;
                case "x_shipping_address":
                    break;
                case "x_a_operator":
                    break;
                case "x_app_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_app_operator":
                    break;
                case "x_po_operator":
                    break;
                case "x_pd_operator":
                    break;
                case "x_da_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_da_operator":
                    break;
                case "x_d_operator":
                    break;
                case "x_r_operator":
                    break;
                case "x_f_yn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_f_operator":
                    break;
                case "x_fr_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
    	$CUID = CurrentUserID();
    	$CDT = CurrentDateTime();
    	$ID = $_GET['id'];
    	isset($_GET['t']) ? $t = $_GET['t'] : $t = ''; 
    	if ($t == 'fbr')
    	{
    	ExecuteStatement("UPDATE `sample_req_cart` set `fr_operator` = $CUID, `fr_datetime` = '$CDT' where `id` = $ID");
    	header("location: sample_req_cart_statusview?id=" . $ID);
    	}
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'sample_request_cart_status');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
