<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SampleReqCartDispatchUpdate extends SampleReqCartDispatch
{
    use MessagesTrait;

    // Page ID
    public $PageID = "update";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SampleReqCartDispatchUpdate";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "samplereqcartdispatchupdate";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->company_id->Visible = false;
        $this->partner_id->Visible = false;
        $this->old_ref->setVisibility();
        $this->design->Visible = false;
        $this->color->Visible = false;
        $this->size->Visible = false;
        $this->quantity->Visible = false;
        $this->delivery_week->Visible = false;
        $this->status->Visible = false;
        $this->upload->Visible = false;
        $this->remarks->Visible = false;
        $this->sp_remarks->Visible = false;
        $this->pp_remarks->Visible = false;
        $this->po_remarks->Visible = false;
        $this->price->Visible = false;
        $this->declaration->Visible = false;
        $this->dispatch->setVisibility();
        $this->bom->Visible = false;
        $this->d_upload->setVisibility();
        $this->da_comments->setVisibility();
        $this->da_status->Visible = false;
        $this->d_operator->setVisibility();
        $this->d_datetime->setVisibility();
        $this->purpose->Visible = false;
        $this->label->Visible = false;
        $this->ssd->Visible = false;
        $this->shipping_address->Visible = false;
        $this->req_chat_id->Visible = false;
        $this->url->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sample_req_cart_dispatch';
        $this->TableName = 'sample_req_cart_dispatch';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-update-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (sample_req_cart_dispatch)
        if (!isset($GLOBALS["sample_req_cart_dispatch"]) || $GLOBALS["sample_req_cart_dispatch"]::class == PROJECT_NAMESPACE . "sample_req_cart_dispatch") {
            $GLOBALS["sample_req_cart_dispatch"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_dispatch');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "samplereqcartdispatchview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $this->d_upload->OldUploadPath = $this->d_upload->getUploadPath(); // PHP
                $this->d_upload->UploadPath = $this->d_upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-update-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $RecKeys;
    public $Disabled;
    public $UpdateCount = 0;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->delivery_week);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->da_status);
        $this->setupLookupOptions($this->purpose);
        $this->setupLookupOptions($this->label);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Try to load keys from list form
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        if (Post("action") !== null && Post("action") !== "") {
            // Get action
            $this->CurrentAction = Post("action");
            $this->loadFormValues(); // Get form values

            // Validate form
            if (!$this->validateForm()) {
                $this->CurrentAction = "show"; // Form error, reset action
                if (!$this->hasInvalidFields()) { // No fields selected
                    $this->setFailureMessage($Language->phrase("NoFieldSelected"));
                }
            }
        } else {
            $this->loadMultiUpdateValues(); // Load initial values to form
        }
        if (count($this->RecKeys) <= 0) {
            $this->terminate("samplereqcartdispatchlist"); // No records selected, return to list
            return;
        }
        if ($this->isUpdate()) {
                if ($this->updateRows()) { // Update Records based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
                    }

                    // Do not return Json for UseAjaxActions
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                    }
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson([
                        "success" => false,
                        "validation" => $this->getValidationErrors(),
                        "error" => $this->getFailureMessage()
                    ]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues(); // Restore form values
                }
        }

        // Render row
        $this->RowType = RowType::EDIT; // Render edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load initial values to form if field values are identical in all selected records
    protected function loadMultiUpdateValues()
    {
        $this->CurrentFilter = $this->getFilterFromRecordKeys();

        // Load result set
        if ($rs = $this->loadRecordset()) {
            $i = 1;
            while ($row = $rs->fetch()) {
                if ($i == 1) {
                    $this->old_ref->setDbValue($row['old_ref']);
                    $this->dispatch->setDbValue($row['dispatch']);
                    $this->da_comments->setDbValue($row['da_comments']);
                    $this->d_operator->setDbValue($row['d_operator']);
                    $this->d_datetime->setDbValue($row['d_datetime']);
                } else {
                    if (!CompareValue($this->old_ref->DbValue, $row['old_ref'])) {
                        $this->old_ref->CurrentValue = null;
                    }
                    if (!CompareValue($this->dispatch->DbValue, $row['dispatch'])) {
                        $this->dispatch->CurrentValue = null;
                    }
                    if (!CompareValue($this->da_comments->DbValue, $row['da_comments'])) {
                        $this->da_comments->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_operator->DbValue, $row['d_operator'])) {
                        $this->d_operator->CurrentValue = null;
                    }
                    if (!CompareValue($this->d_datetime->DbValue, $row['d_datetime'])) {
                        $this->d_datetime->CurrentValue = null;
                    }
                }
                $i++;
            }
            $rs->free();
        }
    }

    // Set up key value
    protected function setupKeyValues($key)
    {
        $keyFld = $key;
        if (!is_numeric($keyFld)) {
            return false;
        }
        $this->id->OldValue = $keyFld;
        return true;
    }

    // Update all selected rows
    protected function updateRows()
    {
        global $Language;
        $conn = $this->getConnection();
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Get old records
        $this->CurrentFilter = $this->getFilterFromRecordKeys(false);
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAllAssociative($sql);

        // Update all rows
        $successKeys = [];
        $failKeys = [];
        foreach ($this->RecKeys as $reckey) {
            if ($this->setupKeyValues($reckey)) {
                $thisKey = $reckey;
                $this->SendEmail = false; // Do not send email on update success
                $this->UpdateCount += 1; // Update record count for records being updated
                $rowUpdated = $this->editRow(); // Update this row
            } else {
                $rowUpdated = false;
            }
            if (!$rowUpdated) {
                if ($this->UseTransaction) { // Update failed
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                $successKeys[] = $thisKey;
            }
        }

        // Check if any rows updated
        if (count($successKeys) > 0) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if update some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("UpdateSomeRecordsFailed")));
            }

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);
            return true;
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            return false;
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->d_upload->Upload->Index = $CurrentForm->Index;
        $this->d_upload->Upload->uploadFile();
        $this->d_upload->CurrentValue = $this->d_upload->Upload->FileName;
        $this->d_upload->MultiUpdate = $CurrentForm->getValue("u_d_upload");
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'old_ref' first before field var 'x_old_ref'
        $val = $CurrentForm->hasValue("old_ref") ? $CurrentForm->getValue("old_ref") : $CurrentForm->getValue("x_old_ref");
        if (!$this->old_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->old_ref->Visible = false; // Disable update for API request
            } else {
                $this->old_ref->setFormValue($val);
            }
        }
        $this->old_ref->MultiUpdate = $CurrentForm->getValue("u_old_ref");

        // Check field name 'dispatch' first before field var 'x_dispatch'
        $val = $CurrentForm->hasValue("dispatch") ? $CurrentForm->getValue("dispatch") : $CurrentForm->getValue("x_dispatch");
        if (!$this->dispatch->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dispatch->Visible = false; // Disable update for API request
            } else {
                $this->dispatch->setFormValue($val);
            }
        }
        $this->dispatch->MultiUpdate = $CurrentForm->getValue("u_dispatch");

        // Check field name 'da_comments' first before field var 'x_da_comments'
        $val = $CurrentForm->hasValue("da_comments") ? $CurrentForm->getValue("da_comments") : $CurrentForm->getValue("x_da_comments");
        if (!$this->da_comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->da_comments->Visible = false; // Disable update for API request
            } else {
                $this->da_comments->setFormValue($val);
            }
        }
        $this->da_comments->MultiUpdate = $CurrentForm->getValue("u_da_comments");

        // Check field name 'd_operator' first before field var 'x_d_operator'
        $val = $CurrentForm->hasValue("d_operator") ? $CurrentForm->getValue("d_operator") : $CurrentForm->getValue("x_d_operator");
        if (!$this->d_operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_operator->Visible = false; // Disable update for API request
            } else {
                $this->d_operator->setFormValue($val);
            }
        }
        $this->d_operator->MultiUpdate = $CurrentForm->getValue("u_d_operator");

        // Check field name 'd_datetime' first before field var 'x_d_datetime'
        $val = $CurrentForm->hasValue("d_datetime") ? $CurrentForm->getValue("d_datetime") : $CurrentForm->getValue("x_d_datetime");
        if (!$this->d_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_datetime->Visible = false; // Disable update for API request
            } else {
                $this->d_datetime->setFormValue($val);
            }
            $this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern());
        }
        $this->d_datetime->MultiUpdate = $CurrentForm->getValue("u_d_datetime");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }
		$this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
		$this->upload->UploadPath = $this->upload->OldUploadPath;
		$this->d_upload->OldUploadPath = $this->d_upload->getUploadPath(); // PHP
		$this->d_upload->UploadPath = $this->d_upload->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->old_ref->CurrentValue = $this->old_ref->FormValue;
        $this->dispatch->CurrentValue = $this->dispatch->FormValue;
        $this->da_comments->CurrentValue = $this->da_comments->FormValue;
        $this->d_operator->CurrentValue = $this->d_operator->FormValue;
        $this->d_datetime->CurrentValue = $this->d_datetime->FormValue;
        $this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern());
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->old_ref->setDbValue($row['old_ref']);
        $this->design->setDbValue($row['design']);
        $this->color->setDbValue($row['color']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->delivery_week->setDbValue($row['delivery_week']);
        $this->status->setDbValue($row['status']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->upload->setDbValue($this->upload->Upload->DbValue);
        $this->remarks->setDbValue($row['remarks']);
        $this->sp_remarks->setDbValue($row['sp_remarks']);
        $this->pp_remarks->setDbValue($row['pp_remarks']);
        $this->po_remarks->setDbValue($row['po_remarks']);
        $this->price->setDbValue($row['price']);
        $this->declaration->setDbValue($row['declaration']);
        $this->dispatch->setDbValue($row['dispatch']);
        $this->bom->setDbValue($row['bom']);
        $this->d_upload->Upload->DbValue = $row['d_upload'];
        $this->d_upload->setDbValue($this->d_upload->Upload->DbValue);
        $this->da_comments->setDbValue($row['da_comments']);
        $this->da_status->setDbValue($row['da_status']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->purpose->setDbValue($row['purpose']);
        $this->label->setDbValue($row['label']);
        $this->ssd->setDbValue($row['ssd']);
        $this->shipping_address->setDbValue($row['shipping_address']);
        $this->req_chat_id->setDbValue($row['req_chat_id']);
        $this->url->setDbValue($row['url']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['old_ref'] = $this->old_ref->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['color'] = $this->color->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['delivery_week'] = $this->delivery_week->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['upload'] = $this->upload->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['sp_remarks'] = $this->sp_remarks->DefaultValue;
        $row['pp_remarks'] = $this->pp_remarks->DefaultValue;
        $row['po_remarks'] = $this->po_remarks->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['declaration'] = $this->declaration->DefaultValue;
        $row['dispatch'] = $this->dispatch->DefaultValue;
        $row['bom'] = $this->bom->DefaultValue;
        $row['d_upload'] = $this->d_upload->DefaultValue;
        $row['da_comments'] = $this->da_comments->DefaultValue;
        $row['da_status'] = $this->da_status->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['ssd'] = $this->ssd->DefaultValue;
        $row['shipping_address'] = $this->shipping_address->DefaultValue;
        $row['req_chat_id'] = $this->req_chat_id->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // old_ref
        $this->old_ref->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // color
        $this->color->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // delivery_week
        $this->delivery_week->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // sp_remarks
        $this->sp_remarks->RowCssClass = "row";

        // pp_remarks
        $this->pp_remarks->RowCssClass = "row";

        // po_remarks
        $this->po_remarks->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // declaration
        $this->declaration->RowCssClass = "row";

        // dispatch
        $this->dispatch->RowCssClass = "row";

        // bom
        $this->bom->RowCssClass = "row";

        // d_upload
        $this->d_upload->RowCssClass = "row";

        // da_comments
        $this->da_comments->RowCssClass = "row";

        // da_status
        $this->da_status->RowCssClass = "row";

        // d_operator
        $this->d_operator->RowCssClass = "row";

        // d_datetime
        $this->d_datetime->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // label
        $this->label->RowCssClass = "row";

        // ssd
        $this->ssd->RowCssClass = "row";

        // shipping_address
        $this->shipping_address->RowCssClass = "row";

        // req_chat_id
        $this->req_chat_id->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // old_ref
            $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // color
            $this->color->ViewValue = $this->color->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // delivery_week
            $curVal = strval($this->delivery_week->CurrentValue);
            if ($curVal != "") {
                $this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
                if ($this->delivery_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->delivery_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->delivery_week->Lookup->renderViewRow($rswrk[0]);
                        $this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
                    } else {
                        $this->delivery_week->ViewValue = FormatNumber($this->delivery_week->CurrentValue, $this->delivery_week->formatPattern());
                    }
                }
            } else {
                $this->delivery_week->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // pp_remarks
            $this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;

            // po_remarks
            $this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;

            // price
            $this->price->ViewValue = $this->price->CurrentValue;

            // declaration
            $this->declaration->ViewValue = $this->declaration->CurrentValue;

            // dispatch
            $this->dispatch->ViewValue = $this->dispatch->CurrentValue;

            // bom
            $this->bom->ViewValue = $this->bom->CurrentValue;

            // d_upload
            $this->d_upload->UploadPath = $this->d_upload->getUploadPath(); // PHP
            if (!EmptyValue($this->d_upload->Upload->DbValue)) {
                $this->d_upload->ViewValue = $this->d_upload->Upload->DbValue;
            } else {
                $this->d_upload->ViewValue = "";
            }

            // da_comments
            $this->da_comments->ViewValue = $this->da_comments->CurrentValue;

            // da_status
            $curVal = strval($this->da_status->CurrentValue);
            if ($curVal != "") {
                $this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
                if ($this->da_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->da_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->da_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->da_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->da_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->da_status->Lookup->renderViewRow($rswrk[0]);
                        $this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
                    } else {
                        $this->da_status->ViewValue = FormatNumber($this->da_status->CurrentValue, $this->da_status->formatPattern());
                    }
                }
            } else {
                $this->da_status->ViewValue = null;
            }

            // d_operator
            $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
            $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

            // d_datetime
            $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
            $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }
            $this->old_ref->TooltipValue = "";

            // dispatch
            $this->dispatch->HrefValue = "";
            $this->dispatch->TooltipValue = "";

            // d_upload
            $this->d_upload->HrefValue = "";
            $this->d_upload->ExportHrefValue = $this->d_upload->UploadPath . $this->d_upload->Upload->DbValue;
            $this->d_upload->TooltipValue = "";

            // da_comments
            $this->da_comments->HrefValue = "";
            $this->da_comments->TooltipValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";
            $this->d_operator->TooltipValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
            $this->d_datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // old_ref
            $this->old_ref->setupEditAttributes();
            if (!$this->old_ref->Raw) {
                $this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
            }
            $this->old_ref->EditValue = HtmlEncode($this->old_ref->CurrentValue);
            $this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

            // dispatch
            $this->dispatch->setupEditAttributes();
            if (!$this->dispatch->Raw) {
                $this->dispatch->CurrentValue = HtmlDecode($this->dispatch->CurrentValue);
            }
            $this->dispatch->EditValue = HtmlEncode($this->dispatch->CurrentValue);
            $this->dispatch->PlaceHolder = RemoveHtml($this->dispatch->caption());

            // d_upload
            $this->d_upload->setupEditAttributes();
            $this->d_upload->UploadPath = $this->d_upload->getUploadPath(); // PHP
            if (!EmptyValue($this->d_upload->Upload->DbValue)) {
                $this->d_upload->EditValue = $this->d_upload->Upload->DbValue;
            } else {
                $this->d_upload->EditValue = "";
            }
            if (!EmptyValue($this->d_upload->CurrentValue)) {
                $this->d_upload->Upload->FileName = $this->d_upload->CurrentValue;
            }

            // da_comments
            $this->da_comments->setupEditAttributes();
            $this->da_comments->EditValue = HtmlEncode($this->da_comments->CurrentValue);
            $this->da_comments->PlaceHolder = RemoveHtml($this->da_comments->caption());

            // d_operator

            // d_datetime

            // Edit refer script

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }

            // dispatch
            $this->dispatch->HrefValue = "";

            // d_upload
            $this->d_upload->HrefValue = "";
            $this->d_upload->ExportHrefValue = $this->d_upload->UploadPath . $this->d_upload->Upload->DbValue;

            // da_comments
            $this->da_comments->HrefValue = "";

            // d_operator
            $this->d_operator->HrefValue = "";

            // d_datetime
            $this->d_datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;
        $updateCnt = 0;
        if ($this->old_ref->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->dispatch->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_upload->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->da_comments->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_operator->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($this->d_datetime->multiUpdateSelected()) {
            $updateCnt++;
        }
        if ($updateCnt == 0) {
            return false;
        }

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->old_ref->Visible && $this->old_ref->Required) {
                if ($this->old_ref->MultiUpdate != "" && !$this->old_ref->IsDetailKey && EmptyValue($this->old_ref->FormValue)) {
                    $this->old_ref->addErrorMessage(str_replace("%s", $this->old_ref->caption(), $this->old_ref->RequiredErrorMessage));
                }
            }
            if ($this->dispatch->Visible && $this->dispatch->Required) {
                if ($this->dispatch->MultiUpdate != "" && !$this->dispatch->IsDetailKey && EmptyValue($this->dispatch->FormValue)) {
                    $this->dispatch->addErrorMessage(str_replace("%s", $this->dispatch->caption(), $this->dispatch->RequiredErrorMessage));
                }
            }
            if ($this->d_upload->Visible && $this->d_upload->Required) {
                if ($this->d_upload->MultiUpdate != "" && $this->d_upload->Upload->FileName == "" && !$this->d_upload->Upload->KeepFile) {
                    $this->d_upload->addErrorMessage(str_replace("%s", $this->d_upload->caption(), $this->d_upload->RequiredErrorMessage));
                }
            }
            if ($this->da_comments->Visible && $this->da_comments->Required) {
                if ($this->da_comments->MultiUpdate != "" && !$this->da_comments->IsDetailKey && EmptyValue($this->da_comments->FormValue)) {
                    $this->da_comments->addErrorMessage(str_replace("%s", $this->da_comments->caption(), $this->da_comments->RequiredErrorMessage));
                }
            }
            if ($this->d_operator->Visible && $this->d_operator->Required) {
                if ($this->d_operator->MultiUpdate != "" && !$this->d_operator->IsDetailKey && EmptyValue($this->d_operator->FormValue)) {
                    $this->d_operator->addErrorMessage(str_replace("%s", $this->d_operator->caption(), $this->d_operator->RequiredErrorMessage));
                }
            }
            if ($this->d_datetime->Visible && $this->d_datetime->Required) {
                if ($this->d_datetime->MultiUpdate != "" && !$this->d_datetime->IsDetailKey && EmptyValue($this->d_datetime->FormValue)) {
                    $this->d_datetime->addErrorMessage(str_replace("%s", $this->d_datetime->caption(), $this->d_datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->d_upload->Visible && !$this->d_upload->Upload->KeepFile) {
            $this->d_upload->UploadPath = $this->d_upload->getUploadPath();
            if (!EmptyValue($this->d_upload->Upload->FileName) && $this->UpdateCount == 1) {
                FixUploadFileNames($this->d_upload);
                $this->d_upload->setDbValueDef($rsnew, $this->d_upload->Upload->FileName, $this->d_upload->ReadOnly || $this->d_upload->MultiUpdate != "1");
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->d_upload->Visible && !$this->d_upload->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->d_upload, $rsnew['d_upload'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
        $this->upload->UploadPath = $this->upload->OldUploadPath;
        $this->d_upload->OldUploadPath = $this->d_upload->getUploadPath(); // PHP
        $this->d_upload->UploadPath = $this->d_upload->OldUploadPath;
        $rsnew = [];

        // old_ref
        $this->old_ref->setDbValueDef($rsnew, $this->old_ref->CurrentValue, $this->old_ref->ReadOnly || $this->old_ref->MultiUpdate != "1");

        // dispatch
        $this->dispatch->setDbValueDef($rsnew, $this->dispatch->CurrentValue, $this->dispatch->ReadOnly || $this->dispatch->MultiUpdate != "1");

        // d_upload
        if ($this->d_upload->Visible && !$this->d_upload->ReadOnly && strval($this->d_upload->MultiUpdate) == "1" && !$this->d_upload->Upload->KeepFile) {
            if ($this->d_upload->Upload->FileName == "") {
                $rsnew['d_upload'] = null;
            } else {
                FixUploadTempFileNames($this->d_upload);
                $rsnew['d_upload'] = $this->d_upload->Upload->FileName;
            }
            $this->d_upload->ImageWidth = 640; // Resize width
            $this->d_upload->ImageHeight = 640; // Resize height
        }

        // da_comments
        $this->da_comments->setDbValueDef($rsnew, $this->da_comments->CurrentValue, $this->da_comments->ReadOnly || $this->da_comments->MultiUpdate != "1");

        // d_operator
        $this->d_operator->CurrentValue = $this->d_operator->getAutoUpdateValue(); // PHP
        $this->d_operator->setDbValueDef($rsnew, $this->d_operator->CurrentValue, $this->d_operator->ReadOnly || $this->d_operator->MultiUpdate != "1");

        // d_datetime
        $this->d_datetime->CurrentValue = $this->d_datetime->getAutoUpdateValue(); // PHP
        $this->d_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern()), $this->d_datetime->ReadOnly || $this->d_datetime->MultiUpdate != "1");
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['old_ref'])) { // old_ref
            $this->old_ref->CurrentValue = $row['old_ref'];
        }
        if (isset($row['dispatch'])) { // dispatch
            $this->dispatch->CurrentValue = $row['dispatch'];
        }
        if (isset($row['d_upload'])) { // d_upload
            $this->d_upload->CurrentValue = $row['d_upload'];
        }
        if (isset($row['da_comments'])) { // da_comments
            $this->da_comments->CurrentValue = $row['da_comments'];
        }
        if (isset($row['d_operator'])) { // d_operator
            $this->d_operator->CurrentValue = $row['d_operator'];
        }
        if (isset($row['d_datetime'])) { // d_datetime
            $this->d_datetime->CurrentValue = $row['d_datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("samplereqcartdispatchlist"), "", $this->TableVar, true);
        $pageId = "update";
        $Breadcrumb->add("update", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_delivery_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_da_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_purpose":
                    break;
                case "x_label":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
