<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SampleReqCartDelete extends SampleReqCart
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SampleReqCartDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "samplereqcartdelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->request_by->setVisibility();
        $this->old_ref->setVisibility();
        $this->upload->setVisibility();
        $this->design->setVisibility();
        $this->color->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->comments->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->po_id->Visible = false;
        $this->status->setVisibility();
        $this->shipping_mode->Visible = false;
        $this->delivery_week->Visible = false;
        $this->purpose->Visible = false;
        $this->label->Visible = false;
        $this->ssd->Visible = false;
        $this->shipping_address->Visible = false;
        $this->shipping_address_2->Visible = false;
        $this->company_id->Visible = false;
        $this->partner_id->Visible = false;
        $this->sp_remarks->Visible = false;
        $this->pp_remarks->Visible = false;
        $this->po_remarks->Visible = false;
        $this->price->Visible = false;
        $this->declaration->Visible = false;
        $this->remarks->Visible = false;
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->app_operator->Visible = false;
        $this->app_datetime->Visible = false;
        $this->po_operator->Visible = false;
        $this->po_datetime->Visible = false;
        $this->bom->Visible = false;
        $this->dispatch->Visible = false;
        $this->pd_upload->Visible = false;
        $this->d_operator->Visible = false;
        $this->d_datetime->Visible = false;
        $this->r_comments->Visible = false;
        $this->r_operator->Visible = false;
        $this->r_datetime->Visible = false;
        $this->f_yn->Visible = false;
        $this->feedback->Visible = false;
        $this->f_upload->Visible = false;
        $this->f_operator->Visible = false;
        $this->f_datetime->Visible = false;
        $this->r_text->Visible = false;
        $this->_barcode->Visible = false;
        $this->fr_operator->Visible = false;
        $this->fr_datetime->Visible = false;
        $this->app_status->Visible = false;
        $this->da_comments->Visible = false;
        $this->da_status->Visible = false;
        $this->da_operator->Visible = false;
        $this->da_datetime->Visible = false;
        $this->req_chat_id->Visible = false;
        $this->pd_operator->Visible = false;
        $this->pd_comments->Visible = false;
        $this->pd_datetime->Visible = false;
        $this->d_upload->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sample_req_cart';
        $this->TableName = 'sample_req_cart';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (sample_req_cart)
        if (!isset($GLOBALS["sample_req_cart"]) || $GLOBALS["sample_req_cart"]::class == PROJECT_NAMESPACE . "sample_req_cart") {
            $GLOBALS["sample_req_cart"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->request_by);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->shipping_mode);
        $this->setupLookupOptions($this->delivery_week);
        $this->setupLookupOptions($this->purpose);
        $this->setupLookupOptions($this->label);
        $this->setupLookupOptions($this->shipping_address);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->app_status);
        $this->setupLookupOptions($this->da_status);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("samplereqcartlist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("samplereqcartlist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->request_by->setDbValue($row['request_by']);
        $this->old_ref->setDbValue($row['old_ref']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->upload->setDbValue($this->upload->Upload->DbValue);
        $this->design->setDbValue($row['design']);
        $this->color->setDbValue($row['color']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->comments->setDbValue($row['comments']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->po_id->setDbValue($row['po_id']);
        $this->status->setDbValue($row['status']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->delivery_week->setDbValue($row['delivery_week']);
        $this->purpose->setDbValue($row['purpose']);
        $this->label->setDbValue($row['label']);
        $this->ssd->setDbValue($row['ssd']);
        $this->shipping_address->setDbValue($row['shipping_address']);
        $this->shipping_address_2->setDbValue($row['shipping_address_2']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->sp_remarks->setDbValue($row['sp_remarks']);
        $this->pp_remarks->setDbValue($row['pp_remarks']);
        $this->po_remarks->setDbValue($row['po_remarks']);
        $this->price->setDbValue($row['price']);
        $this->declaration->setDbValue($row['declaration']);
        $this->remarks->setDbValue($row['remarks']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->po_operator->setDbValue($row['po_operator']);
        $this->po_datetime->setDbValue($row['po_datetime']);
        $this->bom->setDbValue($row['bom']);
        $this->dispatch->setDbValue($row['dispatch']);
        $this->pd_upload->setDbValue($row['pd_upload']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->r_comments->setDbValue($row['r_comments']);
        $this->r_operator->setDbValue($row['r_operator']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->f_yn->setDbValue($row['f_yn']);
        $this->feedback->setDbValue($row['feedback']);
        $this->f_upload->setDbValue($row['f_upload']);
        $this->f_operator->setDbValue($row['f_operator']);
        $this->f_datetime->setDbValue($row['f_datetime']);
        $this->r_text->setDbValue($row['r_text']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->fr_operator->setDbValue($row['fr_operator']);
        $this->fr_datetime->setDbValue($row['fr_datetime']);
        $this->app_status->setDbValue($row['app_status']);
        $this->da_comments->setDbValue($row['da_comments']);
        $this->da_status->setDbValue($row['da_status']);
        $this->da_operator->setDbValue($row['da_operator']);
        $this->da_datetime->setDbValue($row['da_datetime']);
        $this->req_chat_id->setDbValue($row['req_chat_id']);
        $this->pd_operator->setDbValue($row['pd_operator']);
        $this->pd_comments->setDbValue($row['pd_comments']);
        $this->pd_datetime->setDbValue($row['pd_datetime']);
        $this->d_upload->setDbValue($row['d_upload']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['request_by'] = $this->request_by->DefaultValue;
        $row['old_ref'] = $this->old_ref->DefaultValue;
        $row['upload'] = $this->upload->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['color'] = $this->color->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['comments'] = $this->comments->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['shipping_mode'] = $this->shipping_mode->DefaultValue;
        $row['delivery_week'] = $this->delivery_week->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['ssd'] = $this->ssd->DefaultValue;
        $row['shipping_address'] = $this->shipping_address->DefaultValue;
        $row['shipping_address_2'] = $this->shipping_address_2->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['sp_remarks'] = $this->sp_remarks->DefaultValue;
        $row['pp_remarks'] = $this->pp_remarks->DefaultValue;
        $row['po_remarks'] = $this->po_remarks->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['declaration'] = $this->declaration->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['app_operator'] = $this->app_operator->DefaultValue;
        $row['app_datetime'] = $this->app_datetime->DefaultValue;
        $row['po_operator'] = $this->po_operator->DefaultValue;
        $row['po_datetime'] = $this->po_datetime->DefaultValue;
        $row['bom'] = $this->bom->DefaultValue;
        $row['dispatch'] = $this->dispatch->DefaultValue;
        $row['pd_upload'] = $this->pd_upload->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['r_comments'] = $this->r_comments->DefaultValue;
        $row['r_operator'] = $this->r_operator->DefaultValue;
        $row['r_datetime'] = $this->r_datetime->DefaultValue;
        $row['f_yn'] = $this->f_yn->DefaultValue;
        $row['feedback'] = $this->feedback->DefaultValue;
        $row['f_upload'] = $this->f_upload->DefaultValue;
        $row['f_operator'] = $this->f_operator->DefaultValue;
        $row['f_datetime'] = $this->f_datetime->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['fr_operator'] = $this->fr_operator->DefaultValue;
        $row['fr_datetime'] = $this->fr_datetime->DefaultValue;
        $row['app_status'] = $this->app_status->DefaultValue;
        $row['da_comments'] = $this->da_comments->DefaultValue;
        $row['da_status'] = $this->da_status->DefaultValue;
        $row['da_operator'] = $this->da_operator->DefaultValue;
        $row['da_datetime'] = $this->da_datetime->DefaultValue;
        $row['req_chat_id'] = $this->req_chat_id->DefaultValue;
        $row['pd_operator'] = $this->pd_operator->DefaultValue;
        $row['pd_comments'] = $this->pd_comments->DefaultValue;
        $row['pd_datetime'] = $this->pd_datetime->DefaultValue;
        $row['d_upload'] = $this->d_upload->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // request_by

        // old_ref

        // upload

        // design

        // color

        // size

        // quantity

        // comments

        // operator

        // datetime

        // po_id
        $this->po_id->CellCssStyle = "white-space: nowrap;";

        // status
        $this->status->CellCssStyle = "white-space: nowrap;";

        // shipping_mode
        $this->shipping_mode->CellCssStyle = "white-space: nowrap;";

        // delivery_week
        $this->delivery_week->CellCssStyle = "white-space: nowrap;";

        // purpose
        $this->purpose->CellCssStyle = "white-space: nowrap;";

        // label
        $this->label->CellCssStyle = "white-space: nowrap;";

        // ssd
        $this->ssd->CellCssStyle = "white-space: nowrap;";

        // shipping_address
        $this->shipping_address->CellCssStyle = "white-space: nowrap;";

        // shipping_address_2
        $this->shipping_address_2->CellCssStyle = "white-space: nowrap;";

        // company_id
        $this->company_id->CellCssStyle = "white-space: nowrap;";

        // partner_id
        $this->partner_id->CellCssStyle = "white-space: nowrap;";

        // sp_remarks
        $this->sp_remarks->CellCssStyle = "white-space: nowrap;";

        // pp_remarks
        $this->pp_remarks->CellCssStyle = "white-space: nowrap;";

        // po_remarks
        $this->po_remarks->CellCssStyle = "white-space: nowrap;";

        // price
        $this->price->CellCssStyle = "white-space: nowrap;";

        // declaration
        $this->declaration->CellCssStyle = "white-space: nowrap;";

        // remarks
        $this->remarks->CellCssStyle = "white-space: nowrap;";

        // a_operator
        $this->a_operator->CellCssStyle = "white-space: nowrap;";

        // a_datetime
        $this->a_datetime->CellCssStyle = "white-space: nowrap;";

        // app_operator
        $this->app_operator->CellCssStyle = "white-space: nowrap;";

        // app_datetime
        $this->app_datetime->CellCssStyle = "white-space: nowrap;";

        // po_operator
        $this->po_operator->CellCssStyle = "white-space: nowrap;";

        // po_datetime
        $this->po_datetime->CellCssStyle = "white-space: nowrap;";

        // bom
        $this->bom->CellCssStyle = "white-space: nowrap;";

        // dispatch
        $this->dispatch->CellCssStyle = "white-space: nowrap;";

        // pd_upload
        $this->pd_upload->CellCssStyle = "white-space: nowrap;";

        // d_operator
        $this->d_operator->CellCssStyle = "white-space: nowrap;";

        // d_datetime
        $this->d_datetime->CellCssStyle = "white-space: nowrap;";

        // r_comments
        $this->r_comments->CellCssStyle = "white-space: nowrap;";

        // r_operator
        $this->r_operator->CellCssStyle = "white-space: nowrap;";

        // r_datetime
        $this->r_datetime->CellCssStyle = "white-space: nowrap;";

        // f_yn
        $this->f_yn->CellCssStyle = "white-space: nowrap;";

        // feedback
        $this->feedback->CellCssStyle = "white-space: nowrap;";

        // f_upload
        $this->f_upload->CellCssStyle = "white-space: nowrap;";

        // f_operator
        $this->f_operator->CellCssStyle = "white-space: nowrap;";

        // f_datetime
        $this->f_datetime->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // barcode
        $this->_barcode->CellCssStyle = "white-space: nowrap;";

        // fr_operator
        $this->fr_operator->CellCssStyle = "white-space: nowrap;";

        // fr_datetime
        $this->fr_datetime->CellCssStyle = "white-space: nowrap;";

        // app_status
        $this->app_status->CellCssStyle = "white-space: nowrap;";

        // da_comments
        $this->da_comments->CellCssStyle = "white-space: nowrap;";

        // da_status
        $this->da_status->CellCssStyle = "white-space: nowrap;";

        // da_operator
        $this->da_operator->CellCssStyle = "white-space: nowrap;";

        // da_datetime
        $this->da_datetime->CellCssStyle = "white-space: nowrap;";

        // req_chat_id
        $this->req_chat_id->CellCssStyle = "white-space: nowrap;";

        // pd_operator
        $this->pd_operator->CellCssStyle = "white-space: nowrap;";

        // pd_comments
        $this->pd_comments->CellCssStyle = "white-space: nowrap;";

        // pd_datetime
        $this->pd_datetime->CellCssStyle = "white-space: nowrap;";

        // d_upload
        $this->d_upload->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // request_by
            $curVal = strval($this->request_by->CurrentValue);
            if ($curVal != "") {
                $this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
                if ($this->request_by->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->request_by->getSelectFilter($this); // PHP
                    $sqlWrk = $this->request_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->request_by->Lookup->renderViewRow($rswrk[0]);
                        $this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
                    } else {
                        $this->request_by->ViewValue = FormatNumber($this->request_by->CurrentValue, $this->request_by->formatPattern());
                    }
                }
            } else {
                $this->request_by->ViewValue = null;
            }

            // old_ref
            $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // color
            $this->color->ViewValue = $this->color->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // comments
            $this->comments->ViewValue = $this->comments->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // request_by
            $this->request_by->HrefValue = "";
            $this->request_by->TooltipValue = "";

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }
            $this->old_ref->TooltipValue = "";

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
            $this->upload->TooltipValue = "";
            if ($this->upload->UseColorbox) {
                if (EmptyValue($this->upload->TooltipValue)) {
                    $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->upload->LinkAttrs["data-rel"] = "sample_req_cart_x" . $this->RowCount . "_upload";
                $this->upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // color
            $this->color->HrefValue = "";
            $this->color->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // comments
            $this->comments->HrefValue = "";
            $this->comments->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("samplereqcartlist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_request_by":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_mode":
                    break;
                case "x_delivery_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_purpose":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_label":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_address":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_a_operator":
                    break;
                case "x_app_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_da_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'sample_req_cart');		
    	if (($this->status->CurrentValue) >= 3)
    	{
    		$msg = 'Not Allowed';
    		header('Location: samplereqcartlist');
    		exit;
    	}	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
