<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SampleReqCartAuthSearch extends SampleReqCartAuth
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SampleReqCartAuthSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "samplereqcartauthsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->datetime->setVisibility();
        $this->r_text->setVisibility();
        $this->old_ref->setVisibility();
        $this->status->setVisibility();
        $this->request_by->Visible = false;
        $this->company_id->Visible = false;
        $this->partner_id->Visible = false;
        $this->upload->setVisibility();
        $this->req_chat_id->setVisibility();
        $this->operator->Visible = false;
        $this->design->setVisibility();
        $this->color->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->shipping_mode->setVisibility();
        $this->delivery_week->setVisibility();
        $this->purpose->Visible = false;
        $this->label->Visible = false;
        $this->ssd->Visible = false;
        $this->shipping_address_2->Visible = false;
        $this->remarks->setVisibility();
        $this->sp_remarks->setVisibility();
        $this->a_operator->Visible = false;
        $this->a_datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sample_req_cart_auth';
        $this->TableName = 'sample_req_cart_auth';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (sample_req_cart_auth)
        if (!isset($GLOBALS["sample_req_cart_auth"]) || $GLOBALS["sample_req_cart_auth"]::class == PROJECT_NAMESPACE . "sample_req_cart_auth") {
            $GLOBALS["sample_req_cart_auth"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_auth');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "samplereqcartauthview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->request_by);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->shipping_mode);
        $this->setupLookupOptions($this->delivery_week);
        $this->setupLookupOptions($this->purpose);
        $this->setupLookupOptions($this->label);
        $this->setupLookupOptions($this->a_operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "samplereqcartauthlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->r_text); // r_text
        $this->buildSearchUrl($srchUrl, $this->old_ref); // old_ref
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->upload); // upload
        $this->buildSearchUrl($srchUrl, $this->req_chat_id); // req_chat_id
        $this->buildSearchUrl($srchUrl, $this->design); // design
        $this->buildSearchUrl($srchUrl, $this->color); // color
        $this->buildSearchUrl($srchUrl, $this->size); // size
        $this->buildSearchUrl($srchUrl, $this->quantity); // quantity
        $this->buildSearchUrl($srchUrl, $this->shipping_mode); // shipping_mode
        $this->buildSearchUrl($srchUrl, $this->delivery_week); // delivery_week
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->sp_remarks); // sp_remarks
        $this->buildSearchUrl($srchUrl, $this->a_datetime); // a_datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_text
        if ($this->r_text->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // old_ref
        if ($this->old_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // upload
        if ($this->upload->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_chat_id
        if ($this->req_chat_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design
        if ($this->design->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // color
        if ($this->color->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size
        if ($this->size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // quantity
        if ($this->quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shipping_mode
        if ($this->shipping_mode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // delivery_week
        if ($this->delivery_week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sp_remarks
        if ($this->sp_remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_datetime
        if ($this->a_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // old_ref
        $this->old_ref->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // request_by
        $this->request_by->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // req_chat_id
        $this->req_chat_id->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // color
        $this->color->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // shipping_mode
        $this->shipping_mode->RowCssClass = "row";

        // delivery_week
        $this->delivery_week->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // label
        $this->label->RowCssClass = "row";

        // ssd
        $this->ssd->RowCssClass = "row";

        // shipping_address_2
        $this->shipping_address_2->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // sp_remarks
        $this->sp_remarks->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // r_text
            $this->r_text->ViewValue = $this->r_text->CurrentValue;

            // old_ref
            $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // request_by
            $this->request_by->ViewValue = $this->request_by->CurrentValue;
            $curVal = strval($this->request_by->CurrentValue);
            if ($curVal != "") {
                $this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
                if ($this->request_by->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->request_by->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->request_by->Lookup->renderViewRow($rswrk[0]);
                        $this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
                    } else {
                        $this->request_by->ViewValue = FormatNumber($this->request_by->CurrentValue, $this->request_by->formatPattern());
                    }
                }
            } else {
                $this->request_by->ViewValue = null;
            }

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // req_chat_id
            $this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // color
            $this->color->ViewValue = $this->color->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // shipping_mode
            if (strval($this->shipping_mode->CurrentValue) != "") {
                $this->shipping_mode->ViewValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
            } else {
                $this->shipping_mode->ViewValue = null;
            }

            // delivery_week
            $curVal = strval($this->delivery_week->CurrentValue);
            if ($curVal != "") {
                $this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
                if ($this->delivery_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->delivery_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->delivery_week->Lookup->renderViewRow($rswrk[0]);
                        $this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
                    } else {
                        $this->delivery_week->ViewValue = FormatNumber($this->delivery_week->CurrentValue, $this->delivery_week->formatPattern());
                    }
                }
            } else {
                $this->delivery_week->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // sp_remarks
            $this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // r_text
            $this->r_text->HrefValue = "";
            $this->r_text->TooltipValue = "";

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }
            $this->old_ref->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
            $this->upload->TooltipValue = "";
            if ($this->upload->UseColorbox) {
                if (EmptyValue($this->upload->TooltipValue)) {
                    $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->upload->LinkAttrs["data-rel"] = "sample_req_cart_auth_x_upload";
                $this->upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // req_chat_id
            $this->req_chat_id->HrefValue = "";
            $this->req_chat_id->TooltipValue = "";

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // color
            $this->color->HrefValue = "";
            $this->color->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";
            $this->shipping_mode->TooltipValue = "";

            // delivery_week
            $this->delivery_week->HrefValue = "";
            $this->delivery_week->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // sp_remarks
            $this->sp_remarks->HrefValue = "";
            $this->sp_remarks->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // r_text
            $this->r_text->setupEditAttributes();
            $this->r_text->EditValue = HtmlEncode($this->r_text->AdvancedSearch->SearchValue);
            $this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

            // old_ref
            $this->old_ref->setupEditAttributes();
            if (!$this->old_ref->Raw) {
                $this->old_ref->AdvancedSearch->SearchValue = HtmlDecode($this->old_ref->AdvancedSearch->SearchValue);
            }
            $this->old_ref->EditValue = HtmlEncode($this->old_ref->AdvancedSearch->SearchValue);
            $this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->AdvancedSearch->SearchValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // upload
            $this->upload->setupEditAttributes();
            if (!$this->upload->Raw) {
                $this->upload->AdvancedSearch->SearchValue = HtmlDecode($this->upload->AdvancedSearch->SearchValue);
            }
            $this->upload->EditValue = HtmlEncode($this->upload->AdvancedSearch->SearchValue);
            $this->upload->PlaceHolder = RemoveHtml($this->upload->caption());

            // req_chat_id
            $this->req_chat_id->setupEditAttributes();
            if (!$this->req_chat_id->Raw) {
                $this->req_chat_id->AdvancedSearch->SearchValue = HtmlDecode($this->req_chat_id->AdvancedSearch->SearchValue);
            }
            $this->req_chat_id->EditValue = HtmlEncode($this->req_chat_id->AdvancedSearch->SearchValue);
            $this->req_chat_id->PlaceHolder = RemoveHtml($this->req_chat_id->caption());

            // design
            $this->design->setupEditAttributes();
            if (!$this->design->Raw) {
                $this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
            }
            $this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
            $this->design->PlaceHolder = RemoveHtml($this->design->caption());

            // color
            $this->color->setupEditAttributes();
            if (!$this->color->Raw) {
                $this->color->AdvancedSearch->SearchValue = HtmlDecode($this->color->AdvancedSearch->SearchValue);
            }
            $this->color->EditValue = HtmlEncode($this->color->AdvancedSearch->SearchValue);
            $this->color->PlaceHolder = RemoveHtml($this->color->caption());

            // size
            $this->size->setupEditAttributes();
            if (!$this->size->Raw) {
                $this->size->AdvancedSearch->SearchValue = HtmlDecode($this->size->AdvancedSearch->SearchValue);
            }
            $this->size->EditValue = HtmlEncode($this->size->AdvancedSearch->SearchValue);
            $this->size->PlaceHolder = RemoveHtml($this->size->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->AdvancedSearch->SearchValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

            // shipping_mode
            $this->shipping_mode->setupEditAttributes();
            $this->shipping_mode->EditValue = $this->shipping_mode->options(true);
            $this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

            // delivery_week
            $this->delivery_week->setupEditAttributes();
            $curVal = trim(strval($this->delivery_week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->delivery_week->AdvancedSearch->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
            } else {
                $this->delivery_week->AdvancedSearch->ViewValue = $this->delivery_week->Lookup !== null && is_array($this->delivery_week->lookupOptions()) && count($this->delivery_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->delivery_week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->delivery_week->EditValue = array_values($this->delivery_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->delivery_week->AdvancedSearch->SearchValue, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->delivery_week->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->delivery_week->EditValue = $arwrk;
            }
            $this->delivery_week->PlaceHolder = RemoveHtml($this->delivery_week->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // sp_remarks
            $this->sp_remarks->setupEditAttributes();
            $this->sp_remarks->EditValue = HtmlEncode($this->sp_remarks->AdvancedSearch->SearchValue);
            $this->sp_remarks->PlaceHolder = RemoveHtml($this->sp_remarks->caption());

            // a_datetime
            $this->a_datetime->setupEditAttributes();
            $this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, $this->a_datetime->formatPattern()), $this->a_datetime->formatPattern()));
            $this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());
            $this->a_datetime->setupEditAttributes();
            $this->a_datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue2, $this->a_datetime->formatPattern()), $this->a_datetime->formatPattern()));
            $this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->req_chat_id->AdvancedSearch->SearchValue)) {
            $this->req_chat_id->addErrorMessage($this->req_chat_id->getErrorMessage(false));
        }
        if (!CheckInteger($this->quantity->AdvancedSearch->SearchValue)) {
            $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->r_text->AdvancedSearch->load();
        $this->old_ref->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->upload->AdvancedSearch->load();
        $this->req_chat_id->AdvancedSearch->load();
        $this->design->AdvancedSearch->load();
        $this->color->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->quantity->AdvancedSearch->load();
        $this->shipping_mode->AdvancedSearch->load();
        $this->delivery_week->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->sp_remarks->AdvancedSearch->load();
        $this->a_datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("samplereqcartauthlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_request_by":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_shipping_mode":
                    break;
                case "x_delivery_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_purpose":
                    break;
                case "x_label":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'sample_req_cart_auth');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
