<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SampleReqCartAppEdit extends SampleReqCartApp
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SampleReqCartAppEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "samplereqcartappedit";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->company_id->setVisibility();
        $this->partner_id->setVisibility();
        $this->old_ref->setVisibility();
        $this->upload->setVisibility();
        $this->design->setVisibility();
        $this->color->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->delivery_week->setVisibility();
        $this->status->Visible = false;
        $this->remarks->setVisibility();
        $this->sp_remarks->setVisibility();
        $this->pp_remarks->setVisibility();
        $this->price->setVisibility();
        $this->declaration->setVisibility();
        $this->app_status->setVisibility();
        $this->app_operator->setVisibility();
        $this->app_datetime->setVisibility();
        $this->operator->Visible = false;
        $this->req_chat_id->Visible = false;
        $this->url->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sample_req_cart_app';
        $this->TableName = 'sample_req_cart_app';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (sample_req_cart_app)
        if (!isset($GLOBALS["sample_req_cart_app"]) || $GLOBALS["sample_req_cart_app"]::class == PROJECT_NAMESPACE . "sample_req_cart_app") {
            $GLOBALS["sample_req_cart_app"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_app');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "samplereqcartappview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->partner_id->Required = false;
        $this->quantity->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->delivery_week);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->app_status);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("samplereqcartapplist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "samplereqcartapplist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "samplereqcartapplist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "samplereqcartapplist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->upload->Upload->Index = $CurrentForm->Index;
        $this->upload->Upload->uploadFile();
        $this->upload->CurrentValue = $this->upload->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'partner_id' first before field var 'x_partner_id'
        $val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
        if (!$this->partner_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->partner_id->Visible = false; // Disable update for API request
            } else {
                $this->partner_id->setFormValue($val);
            }
        }

        // Check field name 'old_ref' first before field var 'x_old_ref'
        $val = $CurrentForm->hasValue("old_ref") ? $CurrentForm->getValue("old_ref") : $CurrentForm->getValue("x_old_ref");
        if (!$this->old_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->old_ref->Visible = false; // Disable update for API request
            } else {
                $this->old_ref->setFormValue($val);
            }
        }

        // Check field name 'design' first before field var 'x_design'
        $val = $CurrentForm->hasValue("design") ? $CurrentForm->getValue("design") : $CurrentForm->getValue("x_design");
        if (!$this->design->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->design->Visible = false; // Disable update for API request
            } else {
                $this->design->setFormValue($val);
            }
        }

        // Check field name 'color' first before field var 'x_color'
        $val = $CurrentForm->hasValue("color") ? $CurrentForm->getValue("color") : $CurrentForm->getValue("x_color");
        if (!$this->color->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->color->Visible = false; // Disable update for API request
            } else {
                $this->color->setFormValue($val);
            }
        }

        // Check field name 'size' first before field var 'x_size'
        $val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
        if (!$this->size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size->Visible = false; // Disable update for API request
            } else {
                $this->size->setFormValue($val);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val);
            }
        }

        // Check field name 'delivery_week' first before field var 'x_delivery_week'
        $val = $CurrentForm->hasValue("delivery_week") ? $CurrentForm->getValue("delivery_week") : $CurrentForm->getValue("x_delivery_week");
        if (!$this->delivery_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_week->Visible = false; // Disable update for API request
            } else {
                $this->delivery_week->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'sp_remarks' first before field var 'x_sp_remarks'
        $val = $CurrentForm->hasValue("sp_remarks") ? $CurrentForm->getValue("sp_remarks") : $CurrentForm->getValue("x_sp_remarks");
        if (!$this->sp_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sp_remarks->Visible = false; // Disable update for API request
            } else {
                $this->sp_remarks->setFormValue($val);
            }
        }

        // Check field name 'pp_remarks' first before field var 'x_pp_remarks'
        $val = $CurrentForm->hasValue("pp_remarks") ? $CurrentForm->getValue("pp_remarks") : $CurrentForm->getValue("x_pp_remarks");
        if (!$this->pp_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->pp_remarks->Visible = false; // Disable update for API request
            } else {
                $this->pp_remarks->setFormValue($val);
            }
        }

        // Check field name 'price' first before field var 'x_price'
        $val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
        if (!$this->price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->price->Visible = false; // Disable update for API request
            } else {
                $this->price->setFormValue($val);
            }
        }

        // Check field name 'declaration' first before field var 'x_declaration'
        $val = $CurrentForm->hasValue("declaration") ? $CurrentForm->getValue("declaration") : $CurrentForm->getValue("x_declaration");
        if (!$this->declaration->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->declaration->Visible = false; // Disable update for API request
            } else {
                $this->declaration->setFormValue($val);
            }
        }

        // Check field name 'app_status' first before field var 'x_app_status'
        $val = $CurrentForm->hasValue("app_status") ? $CurrentForm->getValue("app_status") : $CurrentForm->getValue("x_app_status");
        if (!$this->app_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->app_status->Visible = false; // Disable update for API request
            } else {
                $this->app_status->setFormValue($val);
            }
        }

        // Check field name 'app_operator' first before field var 'x_app_operator'
        $val = $CurrentForm->hasValue("app_operator") ? $CurrentForm->getValue("app_operator") : $CurrentForm->getValue("x_app_operator");
        if (!$this->app_operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->app_operator->Visible = false; // Disable update for API request
            } else {
                $this->app_operator->setFormValue($val);
            }
        }

        // Check field name 'app_datetime' first before field var 'x_app_datetime'
        $val = $CurrentForm->hasValue("app_datetime") ? $CurrentForm->getValue("app_datetime") : $CurrentForm->getValue("x_app_datetime");
        if (!$this->app_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->app_datetime->Visible = false; // Disable update for API request
            } else {
                $this->app_datetime->setFormValue($val);
            }
            $this->app_datetime->CurrentValue = UnFormatDateTime($this->app_datetime->CurrentValue, $this->app_datetime->formatPattern());
        }
		$this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
		$this->upload->UploadPath = $this->upload->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->partner_id->CurrentValue = $this->partner_id->FormValue;
        $this->old_ref->CurrentValue = $this->old_ref->FormValue;
        $this->design->CurrentValue = $this->design->FormValue;
        $this->color->CurrentValue = $this->color->FormValue;
        $this->size->CurrentValue = $this->size->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->delivery_week->CurrentValue = $this->delivery_week->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->sp_remarks->CurrentValue = $this->sp_remarks->FormValue;
        $this->pp_remarks->CurrentValue = $this->pp_remarks->FormValue;
        $this->price->CurrentValue = $this->price->FormValue;
        $this->declaration->CurrentValue = $this->declaration->FormValue;
        $this->app_status->CurrentValue = $this->app_status->FormValue;
        $this->app_operator->CurrentValue = $this->app_operator->FormValue;
        $this->app_datetime->CurrentValue = $this->app_datetime->FormValue;
        $this->app_datetime->CurrentValue = UnFormatDateTime($this->app_datetime->CurrentValue, $this->app_datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->old_ref->setDbValue($row['old_ref']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->upload->setDbValue($this->upload->Upload->DbValue);
        $this->design->setDbValue($row['design']);
        $this->color->setDbValue($row['color']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->delivery_week->setDbValue($row['delivery_week']);
        $this->status->setDbValue($row['status']);
        $this->remarks->setDbValue($row['remarks']);
        $this->sp_remarks->setDbValue($row['sp_remarks']);
        $this->pp_remarks->setDbValue($row['pp_remarks']);
        $this->price->setDbValue($row['price']);
        $this->declaration->setDbValue($row['declaration']);
        $this->app_status->setDbValue($row['app_status']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->operator->setDbValue($row['operator']);
        $this->req_chat_id->setDbValue($row['req_chat_id']);
        $this->url->setDbValue($row['url']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['old_ref'] = $this->old_ref->DefaultValue;
        $row['upload'] = $this->upload->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['color'] = $this->color->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['delivery_week'] = $this->delivery_week->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['sp_remarks'] = $this->sp_remarks->DefaultValue;
        $row['pp_remarks'] = $this->pp_remarks->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['declaration'] = $this->declaration->DefaultValue;
        $row['app_status'] = $this->app_status->DefaultValue;
        $row['app_operator'] = $this->app_operator->DefaultValue;
        $row['app_datetime'] = $this->app_datetime->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['req_chat_id'] = $this->req_chat_id->DefaultValue;
        $row['url'] = $this->url->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // old_ref
        $this->old_ref->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // color
        $this->color->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // delivery_week
        $this->delivery_week->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // sp_remarks
        $this->sp_remarks->RowCssClass = "row";

        // pp_remarks
        $this->pp_remarks->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // declaration
        $this->declaration->RowCssClass = "row";

        // app_status
        $this->app_status->RowCssClass = "row";

        // app_operator
        $this->app_operator->RowCssClass = "row";

        // app_datetime
        $this->app_datetime->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // req_chat_id
        $this->req_chat_id->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // partner_id
            $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->ViewValue = null;
            }

            // old_ref
            $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // color
            $this->color->ViewValue = $this->color->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // delivery_week
            $curVal = strval($this->delivery_week->CurrentValue);
            if ($curVal != "") {
                $this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
                if ($this->delivery_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->delivery_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->delivery_week->Lookup->renderViewRow($rswrk[0]);
                        $this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
                    } else {
                        $this->delivery_week->ViewValue = FormatNumber($this->delivery_week->CurrentValue, $this->delivery_week->formatPattern());
                    }
                }
            } else {
                $this->delivery_week->ViewValue = null;
            }

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // sp_remarks
            $this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;

            // pp_remarks
            $this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;

            // price
            $this->price->ViewValue = $this->price->CurrentValue;

            // declaration
            $this->declaration->ViewValue = $this->declaration->CurrentValue;

            // app_status
            $curVal = strval($this->app_status->CurrentValue);
            if ($curVal != "") {
                $this->app_status->ViewValue = $this->app_status->lookupCacheOption($curVal);
                if ($this->app_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->app_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->app_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->app_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->app_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->app_status->Lookup->renderViewRow($rswrk[0]);
                        $this->app_status->ViewValue = $this->app_status->displayValue($arwrk);
                    } else {
                        $this->app_status->ViewValue = FormatNumber($this->app_status->CurrentValue, $this->app_status->formatPattern());
                    }
                }
            } else {
                $this->app_status->ViewValue = null;
            }

            // app_operator
            $this->app_operator->ViewValue = $this->app_operator->CurrentValue;
            $this->app_operator->ViewValue = FormatNumber($this->app_operator->ViewValue, $this->app_operator->formatPattern());

            // app_datetime
            $this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
            $this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, $this->app_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            if (!EmptyValue($this->partner_id->CurrentValue)) {
                $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
                $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
                }
            } else {
                $this->partner_id->HrefValue = "";
            }
            $this->partner_id->TooltipValue = "";

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
            $this->upload->TooltipValue = "";
            if ($this->upload->UseColorbox) {
                if (EmptyValue($this->upload->TooltipValue)) {
                    $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->upload->LinkAttrs["data-rel"] = "sample_req_cart_app_x_upload";
                $this->upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // color
            $this->color->HrefValue = "";
            $this->color->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // delivery_week
            $this->delivery_week->HrefValue = "";
            $this->delivery_week->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // sp_remarks
            $this->sp_remarks->HrefValue = "";
            $this->sp_remarks->TooltipValue = "";

            // pp_remarks
            $this->pp_remarks->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // declaration
            $this->declaration->HrefValue = "";
            $this->declaration->TooltipValue = "";

            // app_status
            $this->app_status->HrefValue = "";

            // app_operator
            $this->app_operator->HrefValue = "";

            // app_datetime
            $this->app_datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }

            // partner_id
            $this->partner_id->setupEditAttributes();
            $this->partner_id->EditValue = $this->partner_id->CurrentValue;
            $curVal = strval($this->partner_id->CurrentValue);
            if ($curVal != "") {
                $this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
                if ($this->partner_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                        $this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
                    } else {
                        $this->partner_id->EditValue = $this->partner_id->CurrentValue;
                    }
                }
            } else {
                $this->partner_id->EditValue = null;
            }

            // old_ref
            $this->old_ref->setupEditAttributes();
            if (!$this->old_ref->Raw) {
                $this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
            }
            $this->old_ref->EditValue = HtmlEncode($this->old_ref->CurrentValue);
            $this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

            // upload
            $this->upload->setupEditAttributes();
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->EditValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->EditValue = "";
            }

            // design
            $this->design->setupEditAttributes();
            $this->design->EditValue = $this->design->CurrentValue;

            // color
            $this->color->setupEditAttributes();
            $this->color->EditValue = $this->color->CurrentValue;

            // size
            $this->size->setupEditAttributes();
            $this->size->EditValue = $this->size->CurrentValue;

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, $this->quantity->formatPattern());

            // delivery_week
            $this->delivery_week->setupEditAttributes();
            $curVal = strval($this->delivery_week->CurrentValue);
            if ($curVal != "") {
                $this->delivery_week->EditValue = $this->delivery_week->lookupCacheOption($curVal);
                if ($this->delivery_week->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->delivery_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->delivery_week->Lookup->renderViewRow($rswrk[0]);
                        $this->delivery_week->EditValue = $this->delivery_week->displayValue($arwrk);
                    } else {
                        $this->delivery_week->EditValue = FormatNumber($this->delivery_week->CurrentValue, $this->delivery_week->formatPattern());
                    }
                }
            } else {
                $this->delivery_week->EditValue = null;
            }

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = $this->remarks->CurrentValue;

            // sp_remarks
            $this->sp_remarks->setupEditAttributes();
            $this->sp_remarks->EditValue = $this->sp_remarks->CurrentValue;

            // pp_remarks
            $this->pp_remarks->setupEditAttributes();
            $this->pp_remarks->EditValue = HtmlEncode($this->pp_remarks->CurrentValue);
            $this->pp_remarks->PlaceHolder = RemoveHtml($this->pp_remarks->caption());

            // price
            $this->price->setupEditAttributes();
            if (!$this->price->Raw) {
                $this->price->CurrentValue = HtmlDecode($this->price->CurrentValue);
            }
            $this->price->EditValue = HtmlEncode($this->price->CurrentValue);
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());

            // declaration
            $this->declaration->setupEditAttributes();
            $this->declaration->EditValue = $this->declaration->CurrentValue;

            // app_status
            $this->app_status->setupEditAttributes();
            $curVal = trim(strval($this->app_status->CurrentValue));
            if ($curVal != "") {
                $this->app_status->ViewValue = $this->app_status->lookupCacheOption($curVal);
            } else {
                $this->app_status->ViewValue = $this->app_status->Lookup !== null && is_array($this->app_status->lookupOptions()) && count($this->app_status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->app_status->ViewValue !== null) { // Load from cache
                $this->app_status->EditValue = array_values($this->app_status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->app_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->app_status->CurrentValue, $this->app_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->app_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->app_status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->app_status->EditValue = $arwrk;
            }
            $this->app_status->PlaceHolder = RemoveHtml($this->app_status->caption());

            // app_operator

            // app_datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // partner_id
            if (!EmptyValue($this->partner_id->CurrentValue)) {
                $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
                $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
                }
            } else {
                $this->partner_id->HrefValue = "";
            }
            $this->partner_id->TooltipValue = "";

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
            $this->upload->TooltipValue = "";
            if ($this->upload->UseColorbox) {
                if (EmptyValue($this->upload->TooltipValue)) {
                    $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->upload->LinkAttrs["data-rel"] = "sample_req_cart_app_x_upload";
                $this->upload->LinkAttrs->appendClass("ew-lightbox");
            }

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // color
            $this->color->HrefValue = "";
            $this->color->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // quantity
            $this->quantity->HrefValue = "";
            $this->quantity->TooltipValue = "";

            // delivery_week
            $this->delivery_week->HrefValue = "";
            $this->delivery_week->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // sp_remarks
            $this->sp_remarks->HrefValue = "";
            $this->sp_remarks->TooltipValue = "";

            // pp_remarks
            $this->pp_remarks->HrefValue = "";

            // price
            $this->price->HrefValue = "";

            // declaration
            $this->declaration->HrefValue = "";
            $this->declaration->TooltipValue = "";

            // app_status
            $this->app_status->HrefValue = "";

            // app_operator
            $this->app_operator->HrefValue = "";

            // app_datetime
            $this->app_datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->partner_id->Visible && $this->partner_id->Required) {
                if (!$this->partner_id->IsDetailKey && EmptyValue($this->partner_id->FormValue)) {
                    $this->partner_id->addErrorMessage(str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
                }
            }
            if ($this->old_ref->Visible && $this->old_ref->Required) {
                if (!$this->old_ref->IsDetailKey && EmptyValue($this->old_ref->FormValue)) {
                    $this->old_ref->addErrorMessage(str_replace("%s", $this->old_ref->caption(), $this->old_ref->RequiredErrorMessage));
                }
            }
            if ($this->upload->Visible && $this->upload->Required) {
                if ($this->upload->Upload->FileName == "" && !$this->upload->Upload->KeepFile) {
                    $this->upload->addErrorMessage(str_replace("%s", $this->upload->caption(), $this->upload->RequiredErrorMessage));
                }
            }
            if ($this->design->Visible && $this->design->Required) {
                if (!$this->design->IsDetailKey && EmptyValue($this->design->FormValue)) {
                    $this->design->addErrorMessage(str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
                }
            }
            if ($this->color->Visible && $this->color->Required) {
                if (!$this->color->IsDetailKey && EmptyValue($this->color->FormValue)) {
                    $this->color->addErrorMessage(str_replace("%s", $this->color->caption(), $this->color->RequiredErrorMessage));
                }
            }
            if ($this->size->Visible && $this->size->Required) {
                if (!$this->size->IsDetailKey && EmptyValue($this->size->FormValue)) {
                    $this->size->addErrorMessage(str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if ($this->delivery_week->Visible && $this->delivery_week->Required) {
                if (!$this->delivery_week->IsDetailKey && EmptyValue($this->delivery_week->FormValue)) {
                    $this->delivery_week->addErrorMessage(str_replace("%s", $this->delivery_week->caption(), $this->delivery_week->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->sp_remarks->Visible && $this->sp_remarks->Required) {
                if (!$this->sp_remarks->IsDetailKey && EmptyValue($this->sp_remarks->FormValue)) {
                    $this->sp_remarks->addErrorMessage(str_replace("%s", $this->sp_remarks->caption(), $this->sp_remarks->RequiredErrorMessage));
                }
            }
            if ($this->pp_remarks->Visible && $this->pp_remarks->Required) {
                if (!$this->pp_remarks->IsDetailKey && EmptyValue($this->pp_remarks->FormValue)) {
                    $this->pp_remarks->addErrorMessage(str_replace("%s", $this->pp_remarks->caption(), $this->pp_remarks->RequiredErrorMessage));
                }
            }
            if ($this->price->Visible && $this->price->Required) {
                if (!$this->price->IsDetailKey && EmptyValue($this->price->FormValue)) {
                    $this->price->addErrorMessage(str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
                }
            }
            if ($this->declaration->Visible && $this->declaration->Required) {
                if (!$this->declaration->IsDetailKey && EmptyValue($this->declaration->FormValue)) {
                    $this->declaration->addErrorMessage(str_replace("%s", $this->declaration->caption(), $this->declaration->RequiredErrorMessage));
                }
            }
            if ($this->app_status->Visible && $this->app_status->Required) {
                if (!$this->app_status->IsDetailKey && EmptyValue($this->app_status->FormValue)) {
                    $this->app_status->addErrorMessage(str_replace("%s", $this->app_status->caption(), $this->app_status->RequiredErrorMessage));
                }
            }
            if ($this->app_operator->Visible && $this->app_operator->Required) {
                if (!$this->app_operator->IsDetailKey && EmptyValue($this->app_operator->FormValue)) {
                    $this->app_operator->addErrorMessage(str_replace("%s", $this->app_operator->caption(), $this->app_operator->RequiredErrorMessage));
                }
            }
            if ($this->app_datetime->Visible && $this->app_datetime->Required) {
                if (!$this->app_datetime->IsDetailKey && EmptyValue($this->app_datetime->FormValue)) {
                    $this->app_datetime->addErrorMessage(str_replace("%s", $this->app_datetime->caption(), $this->app_datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
        $this->upload->UploadPath = $this->upload->OldUploadPath;
        $rsnew = [];

        // old_ref
        $this->old_ref->setDbValueDef($rsnew, $this->old_ref->CurrentValue, $this->old_ref->ReadOnly);

        // pp_remarks
        $this->pp_remarks->setDbValueDef($rsnew, $this->pp_remarks->CurrentValue, $this->pp_remarks->ReadOnly);

        // price
        $this->price->setDbValueDef($rsnew, $this->price->CurrentValue, $this->price->ReadOnly);

        // app_status
        $this->app_status->setDbValueDef($rsnew, $this->app_status->CurrentValue, $this->app_status->ReadOnly);

        // app_operator
        $this->app_operator->CurrentValue = $this->app_operator->getAutoUpdateValue(); // PHP
        $this->app_operator->setDbValueDef($rsnew, $this->app_operator->CurrentValue, $this->app_operator->ReadOnly);

        // app_datetime
        $this->app_datetime->CurrentValue = $this->app_datetime->getAutoUpdateValue(); // PHP
        $this->app_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->app_datetime->CurrentValue, $this->app_datetime->formatPattern()), $this->app_datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['old_ref'])) { // old_ref
            $this->old_ref->CurrentValue = $row['old_ref'];
        }
        if (isset($row['pp_remarks'])) { // pp_remarks
            $this->pp_remarks->CurrentValue = $row['pp_remarks'];
        }
        if (isset($row['price'])) { // price
            $this->price->CurrentValue = $row['price'];
        }
        if (isset($row['app_status'])) { // app_status
            $this->app_status->CurrentValue = $row['app_status'];
        }
        if (isset($row['app_operator'])) { // app_operator
            $this->app_operator->CurrentValue = $row['app_operator'];
        }
        if (isset($row['app_datetime'])) { // app_datetime
            $this->app_datetime->CurrentValue = $row['app_datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("samplereqcartapplist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_delivery_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_app_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
