<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SampleReqCartAdd extends SampleReqCart
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SampleReqCartAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "samplereqcartadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->request_by->setVisibility();
        $this->old_ref->setVisibility();
        $this->upload->setVisibility();
        $this->design->setVisibility();
        $this->color->setVisibility();
        $this->size->setVisibility();
        $this->quantity->setVisibility();
        $this->comments->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->po_id->Visible = false;
        $this->status->Visible = false;
        $this->shipping_mode->Visible = false;
        $this->delivery_week->Visible = false;
        $this->purpose->Visible = false;
        $this->label->Visible = false;
        $this->ssd->Visible = false;
        $this->shipping_address->Visible = false;
        $this->shipping_address_2->Visible = false;
        $this->company_id->Visible = false;
        $this->partner_id->Visible = false;
        $this->sp_remarks->Visible = false;
        $this->pp_remarks->Visible = false;
        $this->po_remarks->Visible = false;
        $this->price->Visible = false;
        $this->declaration->Visible = false;
        $this->remarks->Visible = false;
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->app_operator->Visible = false;
        $this->app_datetime->Visible = false;
        $this->po_operator->Visible = false;
        $this->po_datetime->Visible = false;
        $this->bom->Visible = false;
        $this->dispatch->Visible = false;
        $this->pd_upload->Visible = false;
        $this->d_operator->Visible = false;
        $this->d_datetime->Visible = false;
        $this->r_comments->Visible = false;
        $this->r_operator->Visible = false;
        $this->r_datetime->Visible = false;
        $this->f_yn->Visible = false;
        $this->feedback->Visible = false;
        $this->f_upload->Visible = false;
        $this->f_operator->Visible = false;
        $this->f_datetime->Visible = false;
        $this->r_text->Visible = false;
        $this->_barcode->Visible = false;
        $this->fr_operator->Visible = false;
        $this->fr_datetime->Visible = false;
        $this->app_status->Visible = false;
        $this->da_comments->Visible = false;
        $this->da_status->Visible = false;
        $this->da_operator->Visible = false;
        $this->da_datetime->Visible = false;
        $this->req_chat_id->Visible = false;
        $this->pd_operator->Visible = false;
        $this->pd_comments->Visible = false;
        $this->pd_datetime->Visible = false;
        $this->d_upload->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sample_req_cart';
        $this->TableName = 'sample_req_cart';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (sample_req_cart)
        if (!isset($GLOBALS["sample_req_cart"]) || $GLOBALS["sample_req_cart"]::class == PROJECT_NAMESPACE . "sample_req_cart") {
            $GLOBALS["sample_req_cart"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "samplereqcartview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
                $this->upload->UploadPath = $this->upload->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->request_by);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->shipping_mode);
        $this->setupLookupOptions($this->delivery_week);
        $this->setupLookupOptions($this->purpose);
        $this->setupLookupOptions($this->label);
        $this->setupLookupOptions($this->shipping_address);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->partner_id);
        $this->setupLookupOptions($this->a_operator);
        $this->setupLookupOptions($this->app_status);
        $this->setupLookupOptions($this->da_status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("samplereqcartlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = "samplereqcartlist";
                    if (GetPageName($returnUrl) == "samplereqcartlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "samplereqcartview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "samplereqcartlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "samplereqcartlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->upload->Upload->Index = $CurrentForm->Index;
        $this->upload->Upload->uploadFile();
        $this->upload->CurrentValue = $this->upload->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->request_by->DefaultValue = $this->request_by->getDefault(); // PHP
        $this->request_by->OldValue = $this->request_by->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->partner_id->DefaultValue = $this->partner_id->getDefault(); // PHP
        $this->partner_id->OldValue = $this->partner_id->DefaultValue;
        $this->bom->DefaultValue = $this->bom->getDefault(); // PHP
        $this->bom->OldValue = $this->bom->DefaultValue;
        $this->app_status->DefaultValue = $this->app_status->getDefault(); // PHP
        $this->app_status->OldValue = $this->app_status->DefaultValue;
        $this->da_status->DefaultValue = $this->da_status->getDefault(); // PHP
        $this->da_status->OldValue = $this->da_status->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'request_by' first before field var 'x_request_by'
        $val = $CurrentForm->hasValue("request_by") ? $CurrentForm->getValue("request_by") : $CurrentForm->getValue("x_request_by");
        if (!$this->request_by->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->request_by->Visible = false; // Disable update for API request
            } else {
                $this->request_by->setFormValue($val);
            }
        }

        // Check field name 'old_ref' first before field var 'x_old_ref'
        $val = $CurrentForm->hasValue("old_ref") ? $CurrentForm->getValue("old_ref") : $CurrentForm->getValue("x_old_ref");
        if (!$this->old_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->old_ref->Visible = false; // Disable update for API request
            } else {
                $this->old_ref->setFormValue($val);
            }
        }

        // Check field name 'design' first before field var 'x_design'
        $val = $CurrentForm->hasValue("design") ? $CurrentForm->getValue("design") : $CurrentForm->getValue("x_design");
        if (!$this->design->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->design->Visible = false; // Disable update for API request
            } else {
                $this->design->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'color' first before field var 'x_color'
        $val = $CurrentForm->hasValue("color") ? $CurrentForm->getValue("color") : $CurrentForm->getValue("x_color");
        if (!$this->color->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->color->Visible = false; // Disable update for API request
            } else {
                $this->color->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'size' first before field var 'x_size'
        $val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
        if (!$this->size->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size->Visible = false; // Disable update for API request
            } else {
                $this->size->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'quantity' first before field var 'x_quantity'
        $val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
        if (!$this->quantity->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->quantity->Visible = false; // Disable update for API request
            } else {
                $this->quantity->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'comments' first before field var 'x_comments'
        $val = $CurrentForm->hasValue("comments") ? $CurrentForm->getValue("comments") : $CurrentForm->getValue("x_comments");
        if (!$this->comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->comments->Visible = false; // Disable update for API request
            } else {
                $this->comments->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
		$this->upload->UploadPath = $this->upload->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->request_by->CurrentValue = $this->request_by->FormValue;
        $this->old_ref->CurrentValue = $this->old_ref->FormValue;
        $this->design->CurrentValue = $this->design->FormValue;
        $this->color->CurrentValue = $this->color->FormValue;
        $this->size->CurrentValue = $this->size->FormValue;
        $this->quantity->CurrentValue = $this->quantity->FormValue;
        $this->comments->CurrentValue = $this->comments->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->request_by->setDbValue($row['request_by']);
        $this->old_ref->setDbValue($row['old_ref']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->upload->setDbValue($this->upload->Upload->DbValue);
        $this->design->setDbValue($row['design']);
        $this->color->setDbValue($row['color']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->comments->setDbValue($row['comments']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->po_id->setDbValue($row['po_id']);
        $this->status->setDbValue($row['status']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->delivery_week->setDbValue($row['delivery_week']);
        $this->purpose->setDbValue($row['purpose']);
        $this->label->setDbValue($row['label']);
        $this->ssd->setDbValue($row['ssd']);
        $this->shipping_address->setDbValue($row['shipping_address']);
        $this->shipping_address_2->setDbValue($row['shipping_address_2']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->sp_remarks->setDbValue($row['sp_remarks']);
        $this->pp_remarks->setDbValue($row['pp_remarks']);
        $this->po_remarks->setDbValue($row['po_remarks']);
        $this->price->setDbValue($row['price']);
        $this->declaration->setDbValue($row['declaration']);
        $this->remarks->setDbValue($row['remarks']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->po_operator->setDbValue($row['po_operator']);
        $this->po_datetime->setDbValue($row['po_datetime']);
        $this->bom->setDbValue($row['bom']);
        $this->dispatch->setDbValue($row['dispatch']);
        $this->pd_upload->setDbValue($row['pd_upload']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->r_comments->setDbValue($row['r_comments']);
        $this->r_operator->setDbValue($row['r_operator']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->f_yn->setDbValue($row['f_yn']);
        $this->feedback->setDbValue($row['feedback']);
        $this->f_upload->setDbValue($row['f_upload']);
        $this->f_operator->setDbValue($row['f_operator']);
        $this->f_datetime->setDbValue($row['f_datetime']);
        $this->r_text->setDbValue($row['r_text']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->fr_operator->setDbValue($row['fr_operator']);
        $this->fr_datetime->setDbValue($row['fr_datetime']);
        $this->app_status->setDbValue($row['app_status']);
        $this->da_comments->setDbValue($row['da_comments']);
        $this->da_status->setDbValue($row['da_status']);
        $this->da_operator->setDbValue($row['da_operator']);
        $this->da_datetime->setDbValue($row['da_datetime']);
        $this->req_chat_id->setDbValue($row['req_chat_id']);
        $this->pd_operator->setDbValue($row['pd_operator']);
        $this->pd_comments->setDbValue($row['pd_comments']);
        $this->pd_datetime->setDbValue($row['pd_datetime']);
        $this->d_upload->setDbValue($row['d_upload']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['request_by'] = $this->request_by->DefaultValue;
        $row['old_ref'] = $this->old_ref->DefaultValue;
        $row['upload'] = $this->upload->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['color'] = $this->color->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['quantity'] = $this->quantity->DefaultValue;
        $row['comments'] = $this->comments->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['po_id'] = $this->po_id->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['shipping_mode'] = $this->shipping_mode->DefaultValue;
        $row['delivery_week'] = $this->delivery_week->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['ssd'] = $this->ssd->DefaultValue;
        $row['shipping_address'] = $this->shipping_address->DefaultValue;
        $row['shipping_address_2'] = $this->shipping_address_2->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['partner_id'] = $this->partner_id->DefaultValue;
        $row['sp_remarks'] = $this->sp_remarks->DefaultValue;
        $row['pp_remarks'] = $this->pp_remarks->DefaultValue;
        $row['po_remarks'] = $this->po_remarks->DefaultValue;
        $row['price'] = $this->price->DefaultValue;
        $row['declaration'] = $this->declaration->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['app_operator'] = $this->app_operator->DefaultValue;
        $row['app_datetime'] = $this->app_datetime->DefaultValue;
        $row['po_operator'] = $this->po_operator->DefaultValue;
        $row['po_datetime'] = $this->po_datetime->DefaultValue;
        $row['bom'] = $this->bom->DefaultValue;
        $row['dispatch'] = $this->dispatch->DefaultValue;
        $row['pd_upload'] = $this->pd_upload->DefaultValue;
        $row['d_operator'] = $this->d_operator->DefaultValue;
        $row['d_datetime'] = $this->d_datetime->DefaultValue;
        $row['r_comments'] = $this->r_comments->DefaultValue;
        $row['r_operator'] = $this->r_operator->DefaultValue;
        $row['r_datetime'] = $this->r_datetime->DefaultValue;
        $row['f_yn'] = $this->f_yn->DefaultValue;
        $row['feedback'] = $this->feedback->DefaultValue;
        $row['f_upload'] = $this->f_upload->DefaultValue;
        $row['f_operator'] = $this->f_operator->DefaultValue;
        $row['f_datetime'] = $this->f_datetime->DefaultValue;
        $row['r_text'] = $this->r_text->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['fr_operator'] = $this->fr_operator->DefaultValue;
        $row['fr_datetime'] = $this->fr_datetime->DefaultValue;
        $row['app_status'] = $this->app_status->DefaultValue;
        $row['da_comments'] = $this->da_comments->DefaultValue;
        $row['da_status'] = $this->da_status->DefaultValue;
        $row['da_operator'] = $this->da_operator->DefaultValue;
        $row['da_datetime'] = $this->da_datetime->DefaultValue;
        $row['req_chat_id'] = $this->req_chat_id->DefaultValue;
        $row['pd_operator'] = $this->pd_operator->DefaultValue;
        $row['pd_comments'] = $this->pd_comments->DefaultValue;
        $row['pd_datetime'] = $this->pd_datetime->DefaultValue;
        $row['d_upload'] = $this->d_upload->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // request_by
        $this->request_by->RowCssClass = "row";

        // old_ref
        $this->old_ref->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // color
        $this->color->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // quantity
        $this->quantity->RowCssClass = "row";

        // comments
        $this->comments->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // po_id
        $this->po_id->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // shipping_mode
        $this->shipping_mode->RowCssClass = "row";

        // delivery_week
        $this->delivery_week->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // label
        $this->label->RowCssClass = "row";

        // ssd
        $this->ssd->RowCssClass = "row";

        // shipping_address
        $this->shipping_address->RowCssClass = "row";

        // shipping_address_2
        $this->shipping_address_2->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // partner_id
        $this->partner_id->RowCssClass = "row";

        // sp_remarks
        $this->sp_remarks->RowCssClass = "row";

        // pp_remarks
        $this->pp_remarks->RowCssClass = "row";

        // po_remarks
        $this->po_remarks->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // declaration
        $this->declaration->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // app_operator
        $this->app_operator->RowCssClass = "row";

        // app_datetime
        $this->app_datetime->RowCssClass = "row";

        // po_operator
        $this->po_operator->RowCssClass = "row";

        // po_datetime
        $this->po_datetime->RowCssClass = "row";

        // bom
        $this->bom->RowCssClass = "row";

        // dispatch
        $this->dispatch->RowCssClass = "row";

        // pd_upload
        $this->pd_upload->RowCssClass = "row";

        // d_operator
        $this->d_operator->RowCssClass = "row";

        // d_datetime
        $this->d_datetime->RowCssClass = "row";

        // r_comments
        $this->r_comments->RowCssClass = "row";

        // r_operator
        $this->r_operator->RowCssClass = "row";

        // r_datetime
        $this->r_datetime->RowCssClass = "row";

        // f_yn
        $this->f_yn->RowCssClass = "row";

        // feedback
        $this->feedback->RowCssClass = "row";

        // f_upload
        $this->f_upload->RowCssClass = "row";

        // f_operator
        $this->f_operator->RowCssClass = "row";

        // f_datetime
        $this->f_datetime->RowCssClass = "row";

        // r_text
        $this->r_text->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // fr_operator
        $this->fr_operator->RowCssClass = "row";

        // fr_datetime
        $this->fr_datetime->RowCssClass = "row";

        // app_status
        $this->app_status->RowCssClass = "row";

        // da_comments
        $this->da_comments->RowCssClass = "row";

        // da_status
        $this->da_status->RowCssClass = "row";

        // da_operator
        $this->da_operator->RowCssClass = "row";

        // da_datetime
        $this->da_datetime->RowCssClass = "row";

        // req_chat_id
        $this->req_chat_id->RowCssClass = "row";

        // pd_operator
        $this->pd_operator->RowCssClass = "row";

        // pd_comments
        $this->pd_comments->RowCssClass = "row";

        // pd_datetime
        $this->pd_datetime->RowCssClass = "row";

        // d_upload
        $this->d_upload->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // request_by
            $curVal = strval($this->request_by->CurrentValue);
            if ($curVal != "") {
                $this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
                if ($this->request_by->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->request_by->getSelectFilter($this); // PHP
                    $sqlWrk = $this->request_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->request_by->Lookup->renderViewRow($rswrk[0]);
                        $this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
                    } else {
                        $this->request_by->ViewValue = FormatNumber($this->request_by->CurrentValue, $this->request_by->formatPattern());
                    }
                }
            } else {
                $this->request_by->ViewValue = null;
            }

            // old_ref
            $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->ViewValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->ViewValue = "";
            }

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // color
            $this->color->ViewValue = $this->color->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // quantity
            $this->quantity->ViewValue = $this->quantity->CurrentValue;
            $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

            // comments
            $this->comments->ViewValue = $this->comments->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // request_by
            $this->request_by->HrefValue = "";
            $this->request_by->TooltipValue = "";

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;

            // design
            $this->design->HrefValue = "";

            // color
            $this->color->HrefValue = "";

            // size
            $this->size->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // comments
            $this->comments->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // request_by
            $this->request_by->setupEditAttributes();
            $curVal = trim(strval($this->request_by->CurrentValue));
            if ($curVal != "") {
                $this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
            } else {
                $this->request_by->ViewValue = $this->request_by->Lookup !== null && is_array($this->request_by->lookupOptions()) && count($this->request_by->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->request_by->ViewValue !== null) { // Load from cache
                $this->request_by->EditValue = array_values($this->request_by->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->request_by->CurrentValue, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->request_by->getSelectFilter($this); // PHP
                $sqlWrk = $this->request_by->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->request_by->EditValue = $arwrk;
            }
            $this->request_by->PlaceHolder = RemoveHtml($this->request_by->caption());

            // old_ref
            $this->old_ref->setupEditAttributes();
            if (!$this->old_ref->Raw) {
                $this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
            }
            $this->old_ref->EditValue = HtmlEncode($this->old_ref->CurrentValue);
            $this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

            // upload
            $this->upload->setupEditAttributes();
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->ImageWidth = 0;
                $this->upload->ImageHeight = 50;
                $this->upload->ImageAlt = $this->upload->alt();
                $this->upload->ImageCssClass = "ew-image";
                $this->upload->EditValue = $this->upload->Upload->DbValue;
            } else {
                $this->upload->EditValue = "";
            }
            if (!EmptyValue($this->upload->CurrentValue)) {
                $this->upload->Upload->FileName = $this->upload->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->upload->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->upload);
            }

            // design
            $this->design->setupEditAttributes();
            if (!$this->design->Raw) {
                $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
            }
            $this->design->EditValue = HtmlEncode($this->design->CurrentValue);
            $this->design->PlaceHolder = RemoveHtml($this->design->caption());

            // color
            $this->color->setupEditAttributes();
            if (!$this->color->Raw) {
                $this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
            }
            $this->color->EditValue = HtmlEncode($this->color->CurrentValue);
            $this->color->PlaceHolder = RemoveHtml($this->color->caption());

            // size
            $this->size->setupEditAttributes();
            if (!$this->size->Raw) {
                $this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
            }
            $this->size->EditValue = HtmlEncode($this->size->CurrentValue);
            $this->size->PlaceHolder = RemoveHtml($this->size->caption());

            // quantity
            $this->quantity->setupEditAttributes();
            $this->quantity->EditValue = $this->quantity->CurrentValue;
            $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
            if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
                $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
            }

            // comments
            $this->comments->setupEditAttributes();
            $this->comments->EditValue = HtmlEncode($this->comments->CurrentValue);
            $this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

            // operator

            // datetime

            // Add refer script

            // request_by
            $this->request_by->HrefValue = "";

            // old_ref
            if (!EmptyValue($this->old_ref->CurrentValue)) {
                $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
                $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
                }
            } else {
                $this->old_ref->HrefValue = "";
            }

            // upload
            $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
            if (!EmptyValue($this->upload->Upload->DbValue)) {
                $this->upload->HrefValue = "%u"; // Add prefix/suffix
                $this->upload->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
                }
            } else {
                $this->upload->HrefValue = "";
            }
            $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;

            // design
            $this->design->HrefValue = "";

            // color
            $this->color->HrefValue = "";

            // size
            $this->size->HrefValue = "";

            // quantity
            $this->quantity->HrefValue = "";

            // comments
            $this->comments->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Render add option
    public function renderAddOpt($row)
    {
        global $Security, $Language, $CurrentLanguage;

        // Set up CurrentValue
        $this->request_by->CurrentValue = $row["request_by"] ?? null;
        $this->old_ref->CurrentValue = $row["old_ref"] ?? null;
        $this->upload->CurrentValue = $row["upload"] ?? null;
        $this->design->CurrentValue = $row["design"] ?? null;
        $this->color->CurrentValue = $row["color"] ?? null;
        $this->size->CurrentValue = $row["size"] ?? null;
        $this->quantity->CurrentValue = $row["quantity"] ?? null;
        $this->comments->CurrentValue = $row["comments"] ?? null;
        $this->operator->CurrentValue = $row["operator"] ?? null;
        $this->datetime->CurrentValue = $row["datetime"] ?? null;

        // request_by
        $curVal = strval($this->request_by->CurrentValue);
        if ($curVal != "") {
            $this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
            if ($this->request_by->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->request_by->getSelectFilter($this); // PHP
                $sqlWrk = $this->request_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->request_by->Lookup->renderViewRow($rswrk[0]);
                    $this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
                } else {
                    $this->request_by->ViewValue = FormatNumber($this->request_by->CurrentValue, $this->request_by->formatPattern());
                }
            }
        } else {
            $this->request_by->ViewValue = null;
        }

        // old_ref
        $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

        // upload
        $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
        if (!EmptyValue($this->upload->Upload->DbValue)) {
            $this->upload->ImageWidth = 0;
            $this->upload->ImageHeight = 50;
            $this->upload->ImageAlt = $this->upload->alt();
            $this->upload->ImageCssClass = "ew-image";
            $this->upload->ViewValue = $this->upload->Upload->DbValue;
        } else {
            $this->upload->ViewValue = "";
        }

        // design
        $this->design->ViewValue = $this->design->CurrentValue;

        // color
        $this->color->ViewValue = $this->color->CurrentValue;

        // size
        $this->size->ViewValue = $this->size->CurrentValue;

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // comments
        $this->comments->ViewValue = $this->comments->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // Set up $row
        $row["old_ref"] = $this->old_ref->ViewValue;
        $row["upload"] = $this->upload->ViewValue;
        $row["design"] = $this->design->ViewValue;
        $row["color"] = $this->color->ViewValue;
        $row["size"] = $this->size->ViewValue;
        $row["quantity"] = $this->quantity->ViewValue;
        $row["comments"] = $this->comments->ViewValue;
        $row["operator"] = $this->operator->ViewValue;
        $row["datetime"] = $this->datetime->ViewValue;
        return $row;
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->request_by->Visible && $this->request_by->Required) {
                if (!$this->request_by->IsDetailKey && EmptyValue($this->request_by->FormValue)) {
                    $this->request_by->addErrorMessage(str_replace("%s", $this->request_by->caption(), $this->request_by->RequiredErrorMessage));
                }
            }
            if ($this->old_ref->Visible && $this->old_ref->Required) {
                if (!$this->old_ref->IsDetailKey && EmptyValue($this->old_ref->FormValue)) {
                    $this->old_ref->addErrorMessage(str_replace("%s", $this->old_ref->caption(), $this->old_ref->RequiredErrorMessage));
                }
            }
            if ($this->upload->Visible && $this->upload->Required) {
                if ($this->upload->Upload->FileName == "" && !$this->upload->Upload->KeepFile) {
                    $this->upload->addErrorMessage(str_replace("%s", $this->upload->caption(), $this->upload->RequiredErrorMessage));
                }
            }
            if ($this->design->Visible && $this->design->Required) {
                if (!$this->design->IsDetailKey && EmptyValue($this->design->FormValue)) {
                    $this->design->addErrorMessage(str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
                }
            }
            if ($this->color->Visible && $this->color->Required) {
                if (!$this->color->IsDetailKey && EmptyValue($this->color->FormValue)) {
                    $this->color->addErrorMessage(str_replace("%s", $this->color->caption(), $this->color->RequiredErrorMessage));
                }
            }
            if ($this->size->Visible && $this->size->Required) {
                if (!$this->size->IsDetailKey && EmptyValue($this->size->FormValue)) {
                    $this->size->addErrorMessage(str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
                }
            }
            if ($this->quantity->Visible && $this->quantity->Required) {
                if (!$this->quantity->IsDetailKey && EmptyValue($this->quantity->FormValue)) {
                    $this->quantity->addErrorMessage(str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->quantity->FormValue)) {
                $this->quantity->addErrorMessage($this->quantity->getErrorMessage(false));
            }
            if ($this->comments->Visible && $this->comments->Required) {
                if (!$this->comments->IsDetailKey && EmptyValue($this->comments->FormValue)) {
                    $this->comments->addErrorMessage(str_replace("%s", $this->comments->caption(), $this->comments->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
            $this->upload->UploadPath = $this->upload->getUploadPath();
            if (!EmptyValue($this->upload->Upload->FileName)) {
                $this->upload->Upload->DbValue = null;
                FixUploadFileNames($this->upload);
                $this->upload->setDbValueDef($rsnew, $this->upload->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
        $this->upload->UploadPath = $this->upload->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
                    $this->upload->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->upload, $rsnew['upload'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            if (Post("addopt") == "1") { // Render for add option response
                $row = $this->renderAddOpt($row);
            }
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // request_by
        $this->request_by->setDbValueDef($rsnew, $this->request_by->CurrentValue, false);

        // old_ref
        $this->old_ref->setDbValueDef($rsnew, $this->old_ref->CurrentValue, false);

        // upload
        if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
            if ($this->upload->Upload->FileName == "") {
                $rsnew['upload'] = null;
            } else {
                FixUploadTempFileNames($this->upload);
                $rsnew['upload'] = $this->upload->Upload->FileName;
            }
            $this->upload->ImageWidth = 640; // Resize width
            $this->upload->ImageHeight = 640; // Resize height
        }

        // design
        $this->design->setDbValueDef($rsnew, $this->design->CurrentValue, strval($this->design->CurrentValue) == "");

        // color
        $this->color->setDbValueDef($rsnew, $this->color->CurrentValue, strval($this->color->CurrentValue) == "");

        // size
        $this->size->setDbValueDef($rsnew, $this->size->CurrentValue, strval($this->size->CurrentValue) == "");

        // quantity
        $this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, strval($this->quantity->CurrentValue) == "");

        // comments
        $this->comments->setDbValueDef($rsnew, $this->comments->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['request_by'])) { // request_by
            $this->request_by->setFormValue($row['request_by']);
        }
        if (isset($row['old_ref'])) { // old_ref
            $this->old_ref->setFormValue($row['old_ref']);
        }
        if (isset($row['upload'])) { // upload
            $this->upload->setFormValue($row['upload']);
        }
        if (isset($row['design'])) { // design
            $this->design->setFormValue($row['design']);
        }
        if (isset($row['color'])) { // color
            $this->color->setFormValue($row['color']);
        }
        if (isset($row['size'])) { // size
            $this->size->setFormValue($row['size']);
        }
        if (isset($row['quantity'])) { // quantity
            $this->quantity->setFormValue($row['quantity']);
        }
        if (isset($row['comments'])) { // comments
            $this->comments->setFormValue($row['comments']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("samplereqcartlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_request_by":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_mode":
                    break;
                case "x_delivery_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_purpose":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_label":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_address":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_partner_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_a_operator":
                    break;
                case "x_app_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_da_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'sample_req_cart');		
    	IF (CurrentUserLevel() <= 0)
    	{
    	$this->request_by->ReadOnly = True;
    	}
    	else
    	{
    	$this->request_by->ReadOnly = False;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
