<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for sample_req_cart
 */
class SampleReqCart extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $request_by;
    public $old_ref;
    public $upload;
    public $design;
    public $color;
    public $size;
    public $quantity;
    public $comments;
    public $operator;
    public $datetime;
    public $po_id;
    public $status;
    public $shipping_mode;
    public $delivery_week;
    public $purpose;
    public $label;
    public $ssd;
    public $shipping_address;
    public $shipping_address_2;
    public $company_id;
    public $partner_id;
    public $sp_remarks;
    public $pp_remarks;
    public $po_remarks;
    public $price;
    public $declaration;
    public $remarks;
    public $a_operator;
    public $a_datetime;
    public $app_operator;
    public $app_datetime;
    public $po_operator;
    public $po_datetime;
    public $bom;
    public $dispatch;
    public $pd_upload;
    public $d_operator;
    public $d_datetime;
    public $r_comments;
    public $r_operator;
    public $r_datetime;
    public $f_yn;
    public $feedback;
    public $f_upload;
    public $f_operator;
    public $f_datetime;
    public $r_text;
    public $_barcode;
    public $fr_operator;
    public $fr_datetime;
    public $app_status;
    public $da_comments;
    public $da_status;
    public $da_operator;
    public $da_datetime;
    public $req_chat_id;
    public $pd_operator;
    public $pd_comments;
    public $pd_datetime;
    public $d_upload;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "sample_req_cart";
        $this->TableName = 'sample_req_cart';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "sample_req_cart";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // request_by
        $this->request_by = new DbField(
            $this, // Table
            'x_request_by', // Variable name
            'request_by', // Name
            '`request_by`', // Expression
            '`request_by`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`request_by`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->request_by->addMethod("getSelectFilter", fn() => "`partner_type`=2");
        $this->request_by->addMethod("getDefault", fn() => ((isset($_COOKIE["buye"]))? $_COOKIE["buye"]:CurrentUserID()));
        $this->request_by->InputTextType = "text";
        $this->request_by->Raw = true;
        $this->request_by->Nullable = false; // NOT NULL field
        $this->request_by->Required = true; // Required field
        $this->request_by->setSelectMultiple(false); // Select one
        $this->request_by->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->request_by->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->request_by->Lookup = new Lookup($this->request_by, 'buyer_seller_view', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->request_by) . "',COALESCE(`code`,''))");
        $this->request_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->request_by->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['request_by'] = &$this->request_by;

        // old_ref
        $this->old_ref = new DbField(
            $this, // Table
            'x_old_ref', // Variable name
            'old_ref', // Name
            '`old_ref`', // Expression
            '`old_ref`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`old_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->old_ref->addMethod("getLinkPrefix", fn() => "samplereqcartstatuslist?x__barcode=");
        $this->old_ref->addMethod("getLinkSuffix", fn() => "&z__barcode=LIKE");
        $this->old_ref->InputTextType = "text";
        $this->old_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['old_ref'] = &$this->old_ref;

        // upload
        $this->upload = new DbField(
            $this, // Table
            'x_upload', // Variable name
            'upload', // Name
            '`upload`', // Expression
            '`upload`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`upload`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->upload->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/sample_cart/');
        $this->upload->InputTextType = "text";
        $this->upload->UploadMultiple = true;
        $this->upload->Upload->UploadMultiple = true;
        $this->upload->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['upload'] = &$this->upload;

        // design
        $this->design = new DbField(
            $this, // Table
            'x_design', // Variable name
            'design', // Name
            '`design`', // Expression
            '`design`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design->InputTextType = "text";
        $this->design->Nullable = false; // NOT NULL field
        $this->design->Required = true; // Required field
        $this->design->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->design->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['design'] = &$this->design;

        // color
        $this->color = new DbField(
            $this, // Table
            'x_color', // Variable name
            'color', // Name
            '`color`', // Expression
            '`color`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`color`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->color->InputTextType = "text";
        $this->color->Nullable = false; // NOT NULL field
        $this->color->Required = true; // Required field
        $this->color->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->color->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['color'] = &$this->color;

        // size
        $this->size = new DbField(
            $this, // Table
            'x_size', // Variable name
            'size', // Name
            '`size`', // Expression
            '`size`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size->InputTextType = "text";
        $this->size->Nullable = false; // NOT NULL field
        $this->size->Required = true; // Required field
        $this->size->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['size'] = &$this->size;

        // quantity
        $this->quantity = new DbField(
            $this, // Table
            'x_quantity', // Variable name
            'quantity', // Name
            '`quantity`', // Expression
            '`quantity`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->quantity->InputTextType = "text";
        $this->quantity->Raw = true;
        $this->quantity->Nullable = false; // NOT NULL field
        $this->quantity->Required = true; // Required field
        $this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['quantity'] = &$this->quantity;

        // comments
        $this->comments = new DbField(
            $this, // Table
            'x_comments', // Variable name
            'comments', // Name
            '`comments`', // Expression
            '`comments`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->comments->InputTextType = "text";
        $this->comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['comments'] = &$this->comments;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // po_id
        $this->po_id = new DbField(
            $this, // Table
            'x_po_id', // Variable name
            'po_id', // Name
            '`po_id`', // Expression
            '`po_id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_id->InputTextType = "text";
        $this->po_id->Raw = true;
        $this->po_id->Sortable = false; // Allow sort
        $this->po_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_id'] = &$this->po_id;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Sortable = false; // Allow sort
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'sample_request_status', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // shipping_mode
        $this->shipping_mode = new DbField(
            $this, // Table
            'x_shipping_mode', // Variable name
            'shipping_mode', // Name
            '`shipping_mode`', // Expression
            '`shipping_mode`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_mode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->shipping_mode->InputTextType = "text";
        $this->shipping_mode->Raw = true;
        $this->shipping_mode->Sortable = false; // Allow sort
        $this->shipping_mode->setSelectMultiple(false); // Select one
        $this->shipping_mode->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->shipping_mode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->shipping_mode->Lookup = new Lookup($this->shipping_mode, 'sample_req_cart', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->shipping_mode->OptionCount = 3;
        $this->shipping_mode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->shipping_mode->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_mode'] = &$this->shipping_mode;

        // delivery_week
        $this->delivery_week = new DbField(
            $this, // Table
            'x_delivery_week', // Variable name
            'delivery_week', // Name
            '`delivery_week`', // Expression
            '`delivery_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`delivery_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->delivery_week->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "");
        $this->delivery_week->InputTextType = "text";
        $this->delivery_week->Raw = true;
        $this->delivery_week->Sortable = false; // Allow sort
        $this->delivery_week->setSelectMultiple(false); // Select one
        $this->delivery_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->delivery_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->delivery_week->Lookup = new Lookup($this->delivery_week, 'not_week', false, 'id', ["wid","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`wid`, ''),'" . ValueSeparator(1, $this->delivery_week) . "',COALESCE(`wed`,''))");
        $this->delivery_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->delivery_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['delivery_week'] = &$this->delivery_week;

        // purpose
        $this->purpose = new DbField(
            $this, // Table
            'x_purpose', // Variable name
            'purpose', // Name
            '`purpose`', // Expression
            '`purpose`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`purpose`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->purpose->addMethod("getSelectFilter", fn() => "`grp`=3 and `status` = 1");
        $this->purpose->InputTextType = "text";
        $this->purpose->Raw = true;
        $this->purpose->Sortable = false; // Allow sort
        $this->purpose->setSelectMultiple(false); // Select one
        $this->purpose->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->purpose->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->purpose->Lookup = new Lookup($this->purpose, 'sample_req_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->purpose->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->purpose->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['purpose'] = &$this->purpose;

        // label
        $this->label = new DbField(
            $this, // Table
            'x_label', // Variable name
            'label', // Name
            '`label`', // Expression
            '`label`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`label`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->label->addMethod("getSelectFilter", fn() => "`grp`=3 and `status` = 1");
        $this->label->InputTextType = "text";
        $this->label->Sortable = false; // Allow sort
        $this->label->setSelectMultiple(false); // Select one
        $this->label->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->label->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->label->Lookup = new Lookup($this->label, 'sample_req_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->label->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['label'] = &$this->label;

        // ssd
        $this->ssd = new DbField(
            $this, // Table
            'x_ssd', // Variable name
            'ssd', // Name
            '`ssd`', // Expression
            CastDateFieldForLike("`ssd`", 111, "DB"), // Basic search expression
            133, // Type
            10, // Size
            111, // Date/Time format
            false, // Is upload field
            '`ssd`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ssd->InputTextType = "text";
        $this->ssd->Raw = true;
        $this->ssd->Sortable = false; // Allow sort
        $this->ssd->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->ssd->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ssd'] = &$this->ssd;

        // shipping_address
        $this->shipping_address = new DbField(
            $this, // Table
            'x_shipping_address', // Variable name
            'shipping_address', // Name
            '`shipping_address`', // Expression
            '`shipping_address`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_address`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->shipping_address->InputTextType = "text";
        $this->shipping_address->Raw = true;
        $this->shipping_address->Sortable = false; // Allow sort
        $this->shipping_address->setSelectMultiple(false); // Select one
        $this->shipping_address->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->shipping_address->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->shipping_address->Lookup = new Lookup($this->shipping_address, 'shipping_address', false, 'id', ["formal_name","address","city_name","gst_number"], '', '', [], [], [], [], ["r_text"], ["x_shipping_address_2"], false, '`name` ASC', '', "CONCAT(COALESCE(`formal_name`, ''),'" . ValueSeparator(1, $this->shipping_address) . "',COALESCE(`address`,''),'" . ValueSeparator(2, $this->shipping_address) . "',COALESCE(`city_name`,''),'" . ValueSeparator(3, $this->shipping_address) . "',COALESCE(`gst_number`,''))");
        $this->shipping_address->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->shipping_address->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_address'] = &$this->shipping_address;

        // shipping_address_2
        $this->shipping_address_2 = new DbField(
            $this, // Table
            'x_shipping_address_2', // Variable name
            'shipping_address_2', // Name
            '`shipping_address_2`', // Expression
            '`shipping_address_2`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_address_2`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->shipping_address_2->InputTextType = "text";
        $this->shipping_address_2->Sortable = false; // Allow sort
        $this->shipping_address_2->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_address_2'] = &$this->shipping_address_2;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => User_Company_ID() == 0 ? "`status`=1 and `partner_type`=2" : "id= ".  User_Company_ID() . "  and `partner_type`=2");
        $this->company_id->addMethod("getDefault", fn() => (isset($_GET["CID"]))? $_GET["CID"]:User_Company_ID());
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Sortable = false; // Allow sort
        $this->company_id->setSelectMultiple(false); // Select one
        $this->company_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // partner_id
        $this->partner_id = new DbField(
            $this, // Table
            'x_partner_id', // Variable name
            'partner_id', // Name
            '`partner_id`', // Expression
            '`partner_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`partner_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->partner_id->addMethod("getSelectFilter", fn() => "`status`=1 and `partner_type`=1");
        $this->partner_id->addMethod("getDefault", fn() => (isset($_GET["PID"]))? $_GET["PID"]:'');
        $this->partner_id->addMethod("getLinkPrefix", fn() => "poblist?x_partner_id=");
        $this->partner_id->InputTextType = "text";
        $this->partner_id->Raw = true;
        $this->partner_id->Required = true; // Required field
        $this->partner_id->Sortable = false; // Allow sort
        $this->partner_id->Lookup = new Lookup($this->partner_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->partner_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['partner_id'] = &$this->partner_id;

        // sp_remarks
        $this->sp_remarks = new DbField(
            $this, // Table
            'x_sp_remarks', // Variable name
            'sp_remarks', // Name
            '`sp_remarks`', // Expression
            '`sp_remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sp_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->sp_remarks->InputTextType = "text";
        $this->sp_remarks->Sortable = false; // Allow sort
        $this->sp_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['sp_remarks'] = &$this->sp_remarks;

        // pp_remarks
        $this->pp_remarks = new DbField(
            $this, // Table
            'x_pp_remarks', // Variable name
            'pp_remarks', // Name
            '`pp_remarks`', // Expression
            '`pp_remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pp_remarks->InputTextType = "text";
        $this->pp_remarks->Sortable = false; // Allow sort
        $this->pp_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pp_remarks'] = &$this->pp_remarks;

        // po_remarks
        $this->po_remarks = new DbField(
            $this, // Table
            'x_po_remarks', // Variable name
            'po_remarks', // Name
            '`po_remarks`', // Expression
            '`po_remarks`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_remarks->InputTextType = "text";
        $this->po_remarks->Sortable = false; // Allow sort
        $this->po_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_remarks'] = &$this->po_remarks;

        // price
        $this->price = new DbField(
            $this, // Table
            'x_price', // Variable name
            'price', // Name
            '`price`', // Expression
            '`price`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price->InputTextType = "text";
        $this->price->Sortable = false; // Allow sort
        $this->price->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['price'] = &$this->price;

        // declaration
        $this->declaration = new DbField(
            $this, // Table
            'x_declaration', // Variable name
            'declaration', // Name
            '`declaration`', // Expression
            '`declaration`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`declaration`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->declaration->InputTextType = "text";
        $this->declaration->Sortable = false; // Allow sort
        $this->declaration->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['declaration'] = &$this->declaration;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->Sortable = false; // Allow sort
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->a_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->Sortable = false; // Allow sort
        $this->a_operator->setSelectMultiple(false); // Select one
        $this->a_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->a_operator->Lookup = new Lookup($this->a_operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // a_datetime
        $this->a_datetime = new DbField(
            $this, // Table
            'x_a_datetime', // Variable name
            'a_datetime', // Name
            '`a_datetime`', // Expression
            CastDateFieldForLike("`a_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`a_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->a_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->a_datetime->InputTextType = "text";
        $this->a_datetime->Raw = true;
        $this->a_datetime->Sortable = false; // Allow sort
        $this->a_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_datetime'] = &$this->a_datetime;

        // app_operator
        $this->app_operator = new DbField(
            $this, // Table
            'x_app_operator', // Variable name
            'app_operator', // Name
            '`app_operator`', // Expression
            '`app_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`app_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->app_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->app_operator->InputTextType = "text";
        $this->app_operator->Raw = true;
        $this->app_operator->Sortable = false; // Allow sort
        $this->app_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->app_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['app_operator'] = &$this->app_operator;

        // app_datetime
        $this->app_datetime = new DbField(
            $this, // Table
            'x_app_datetime', // Variable name
            'app_datetime', // Name
            '`app_datetime`', // Expression
            CastDateFieldForLike("`app_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`app_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->app_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->app_datetime->InputTextType = "text";
        $this->app_datetime->Raw = true;
        $this->app_datetime->Sortable = false; // Allow sort
        $this->app_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->app_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['app_datetime'] = &$this->app_datetime;

        // po_operator
        $this->po_operator = new DbField(
            $this, // Table
            'x_po_operator', // Variable name
            'po_operator', // Name
            '`po_operator`', // Expression
            '`po_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->po_operator->InputTextType = "text";
        $this->po_operator->Raw = true;
        $this->po_operator->Sortable = false; // Allow sort
        $this->po_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_operator'] = &$this->po_operator;

        // po_datetime
        $this->po_datetime = new DbField(
            $this, // Table
            'x_po_datetime', // Variable name
            'po_datetime', // Name
            '`po_datetime`', // Expression
            CastDateFieldForLike("`po_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`po_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->po_datetime->InputTextType = "text";
        $this->po_datetime->Raw = true;
        $this->po_datetime->Sortable = false; // Allow sort
        $this->po_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->po_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_datetime'] = &$this->po_datetime;

        // bom
        $this->bom = new DbField(
            $this, // Table
            'x_bom', // Variable name
            'bom', // Name
            '`bom`', // Expression
            '`bom`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bom`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->bom->addMethod("getDefault", fn() => "Please Update Product Specification i.e. BOM, CBM, Weight/SQM, Price, MOQ etc");
        $this->bom->InputTextType = "text";
        $this->bom->Nullable = false; // NOT NULL field
        $this->bom->Sortable = false; // Allow sort
        $this->bom->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['bom'] = &$this->bom;

        // dispatch
        $this->dispatch = new DbField(
            $this, // Table
            'x_dispatch', // Variable name
            'dispatch', // Name
            '`dispatch`', // Expression
            '`dispatch`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`dispatch`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->dispatch->InputTextType = "text";
        $this->dispatch->Sortable = false; // Allow sort
        $this->dispatch->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['dispatch'] = &$this->dispatch;

        // pd_upload
        $this->pd_upload = new DbField(
            $this, // Table
            'x_pd_upload', // Variable name
            'pd_upload', // Name
            '`pd_upload`', // Expression
            '`pd_upload`', // Basic search expression
            200, // Type
            300, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pd_upload`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->pd_upload->InputTextType = "text";
        $this->pd_upload->Sortable = false; // Allow sort
        $this->pd_upload->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pd_upload'] = &$this->pd_upload;

        // d_operator
        $this->d_operator = new DbField(
            $this, // Table
            'x_d_operator', // Variable name
            'd_operator', // Name
            '`d_operator`', // Expression
            '`d_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_operator->InputTextType = "text";
        $this->d_operator->Raw = true;
        $this->d_operator->Sortable = false; // Allow sort
        $this->d_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->d_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_operator'] = &$this->d_operator;

        // d_datetime
        $this->d_datetime = new DbField(
            $this, // Table
            'x_d_datetime', // Variable name
            'd_datetime', // Name
            '`d_datetime`', // Expression
            CastDateFieldForLike("`d_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`d_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_datetime->InputTextType = "text";
        $this->d_datetime->Raw = true;
        $this->d_datetime->Sortable = false; // Allow sort
        $this->d_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->d_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_datetime'] = &$this->d_datetime;

        // r_comments
        $this->r_comments = new DbField(
            $this, // Table
            'x_r_comments', // Variable name
            'r_comments', // Name
            '`r_comments`', // Expression
            '`r_comments`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_comments->InputTextType = "text";
        $this->r_comments->Sortable = false; // Allow sort
        $this->r_comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_comments'] = &$this->r_comments;

        // r_operator
        $this->r_operator = new DbField(
            $this, // Table
            'x_r_operator', // Variable name
            'r_operator', // Name
            '`r_operator`', // Expression
            '`r_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_operator->InputTextType = "text";
        $this->r_operator->Raw = true;
        $this->r_operator->Sortable = false; // Allow sort
        $this->r_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->r_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_operator'] = &$this->r_operator;

        // r_datetime
        $this->r_datetime = new DbField(
            $this, // Table
            'x_r_datetime', // Variable name
            'r_datetime', // Name
            '`r_datetime`', // Expression
            CastDateFieldForLike("`r_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`r_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->r_datetime->InputTextType = "text";
        $this->r_datetime->Raw = true;
        $this->r_datetime->Sortable = false; // Allow sort
        $this->r_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->r_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_datetime'] = &$this->r_datetime;

        // f_yn
        $this->f_yn = new DbField(
            $this, // Table
            'x_f_yn', // Variable name
            'f_yn', // Name
            '`f_yn`', // Expression
            '`f_yn`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`f_yn`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->f_yn->InputTextType = "text";
        $this->f_yn->Raw = true;
        $this->f_yn->Sortable = false; // Allow sort
        $this->f_yn->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->f_yn->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['f_yn'] = &$this->f_yn;

        // feedback
        $this->feedback = new DbField(
            $this, // Table
            'x_feedback', // Variable name
            'feedback', // Name
            '`feedback`', // Expression
            '`feedback`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`feedback`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->feedback->InputTextType = "text";
        $this->feedback->Sortable = false; // Allow sort
        $this->feedback->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['feedback'] = &$this->feedback;

        // f_upload
        $this->f_upload = new DbField(
            $this, // Table
            'x_f_upload', // Variable name
            'f_upload', // Name
            '`f_upload`', // Expression
            '`f_upload`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`f_upload`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->f_upload->InputTextType = "text";
        $this->f_upload->Sortable = false; // Allow sort
        $this->f_upload->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['f_upload'] = &$this->f_upload;

        // f_operator
        $this->f_operator = new DbField(
            $this, // Table
            'x_f_operator', // Variable name
            'f_operator', // Name
            '`f_operator`', // Expression
            '`f_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`f_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->f_operator->InputTextType = "text";
        $this->f_operator->Raw = true;
        $this->f_operator->Sortable = false; // Allow sort
        $this->f_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->f_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['f_operator'] = &$this->f_operator;

        // f_datetime
        $this->f_datetime = new DbField(
            $this, // Table
            'x_f_datetime', // Variable name
            'f_datetime', // Name
            '`f_datetime`', // Expression
            CastDateFieldForLike("`f_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`f_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->f_datetime->InputTextType = "text";
        $this->f_datetime->Raw = true;
        $this->f_datetime->Sortable = false; // Allow sort
        $this->f_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->f_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['f_datetime'] = &$this->f_datetime;

        // r_text
        $this->r_text = new DbField(
            $this, // Table
            'x_r_text', // Variable name
            'r_text', // Name
            '`r_text`', // Expression
            '`r_text`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_text`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->r_text->InputTextType = "text";
        $this->r_text->Sortable = false; // Allow sort
        $this->r_text->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_text'] = &$this->r_text;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Sortable = false; // Allow sort
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // fr_operator
        $this->fr_operator = new DbField(
            $this, // Table
            'x_fr_operator', // Variable name
            'fr_operator', // Name
            '`fr_operator`', // Expression
            '`fr_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fr_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fr_operator->InputTextType = "text";
        $this->fr_operator->Raw = true;
        $this->fr_operator->Sortable = false; // Allow sort
        $this->fr_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->fr_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fr_operator'] = &$this->fr_operator;

        // fr_datetime
        $this->fr_datetime = new DbField(
            $this, // Table
            'x_fr_datetime', // Variable name
            'fr_datetime', // Name
            '`fr_datetime`', // Expression
            CastDateFieldForLike("`fr_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`fr_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fr_datetime->InputTextType = "text";
        $this->fr_datetime->Raw = true;
        $this->fr_datetime->Sortable = false; // Allow sort
        $this->fr_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->fr_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['fr_datetime'] = &$this->fr_datetime;

        // app_status
        $this->app_status = new DbField(
            $this, // Table
            'x_app_status', // Variable name
            'app_status', // Name
            '`app_status`', // Expression
            '`app_status`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`app_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->app_status->addMethod("getSelectFilter", fn() => "`grp` = 6 and `status` = 1 and (`id` = 602 || `id` = 609)");
        $this->app_status->addMethod("getDefault", fn() => 0);
        $this->app_status->InputTextType = "text";
        $this->app_status->Raw = true;
        $this->app_status->Nullable = false; // NOT NULL field
        $this->app_status->Required = true; // Required field
        $this->app_status->Sortable = false; // Allow sort
        $this->app_status->setSelectMultiple(false); // Select one
        $this->app_status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->app_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->app_status->Lookup = new Lookup($this->app_status, 'sample_req_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->app_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->app_status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['app_status'] = &$this->app_status;

        // da_comments
        $this->da_comments = new DbField(
            $this, // Table
            'x_da_comments', // Variable name
            'da_comments', // Name
            '`da_comments`', // Expression
            '`da_comments`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`da_comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->da_comments->InputTextType = "text";
        $this->da_comments->Sortable = false; // Allow sort
        $this->da_comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['da_comments'] = &$this->da_comments;

        // da_status
        $this->da_status = new DbField(
            $this, // Table
            'x_da_status', // Variable name
            'da_status', // Name
            '`da_status`', // Expression
            '`da_status`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`da_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->da_status->addMethod("getSelectFilter", fn() => "`grp` = 7 and `status` = 1");
        $this->da_status->addMethod("getDefault", fn() => 0);
        $this->da_status->InputTextType = "text";
        $this->da_status->Raw = true;
        $this->da_status->Sortable = false; // Allow sort
        $this->da_status->setSelectMultiple(false); // Select one
        $this->da_status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->da_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->da_status->Lookup = new Lookup($this->da_status, 'sample_req_misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->da_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->da_status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['da_status'] = &$this->da_status;

        // da_operator
        $this->da_operator = new DbField(
            $this, // Table
            'x_da_operator', // Variable name
            'da_operator', // Name
            '`da_operator`', // Expression
            '`da_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`da_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->da_operator->InputTextType = "text";
        $this->da_operator->Raw = true;
        $this->da_operator->Sortable = false; // Allow sort
        $this->da_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->da_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['da_operator'] = &$this->da_operator;

        // da_datetime
        $this->da_datetime = new DbField(
            $this, // Table
            'x_da_datetime', // Variable name
            'da_datetime', // Name
            '`da_datetime`', // Expression
            CastDateFieldForLike("`da_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`da_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->da_datetime->InputTextType = "text";
        $this->da_datetime->Raw = true;
        $this->da_datetime->Sortable = false; // Allow sort
        $this->da_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->da_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['da_datetime'] = &$this->da_datetime;

        // req_chat_id
        $this->req_chat_id = new DbField(
            $this, // Table
            'x_req_chat_id', // Variable name
            'req_chat_id', // Name
            '`req_chat_id`', // Expression
            '`req_chat_id`', // Basic search expression
            200, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_chat_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_chat_id->InputTextType = "text";
        $this->req_chat_id->Sortable = false; // Allow sort
        $this->req_chat_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_chat_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_chat_id'] = &$this->req_chat_id;

        // pd_operator
        $this->pd_operator = new DbField(
            $this, // Table
            'x_pd_operator', // Variable name
            'pd_operator', // Name
            '`pd_operator`', // Expression
            '`pd_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pd_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pd_operator->InputTextType = "text";
        $this->pd_operator->Raw = true;
        $this->pd_operator->Nullable = false; // NOT NULL field
        $this->pd_operator->Required = true; // Required field
        $this->pd_operator->Sortable = false; // Allow sort
        $this->pd_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pd_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['pd_operator'] = &$this->pd_operator;

        // pd_comments
        $this->pd_comments = new DbField(
            $this, // Table
            'x_pd_comments', // Variable name
            'pd_comments', // Name
            '`pd_comments`', // Expression
            '`pd_comments`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pd_comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->pd_comments->InputTextType = "text";
        $this->pd_comments->Sortable = false; // Allow sort
        $this->pd_comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pd_comments'] = &$this->pd_comments;

        // pd_datetime
        $this->pd_datetime = new DbField(
            $this, // Table
            'x_pd_datetime', // Variable name
            'pd_datetime', // Name
            '`pd_datetime`', // Expression
            CastDateFieldForLike("`pd_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`pd_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pd_datetime->InputTextType = "text";
        $this->pd_datetime->Raw = true;
        $this->pd_datetime->Sortable = false; // Allow sort
        $this->pd_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->pd_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pd_datetime'] = &$this->pd_datetime;

        // d_upload
        $this->d_upload = new DbField(
            $this, // Table
            'x_d_upload', // Variable name
            'd_upload', // Name
            '`d_upload`', // Expression
            '`d_upload`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_upload`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_upload->InputTextType = "text";
        $this->d_upload->Sortable = false; // Allow sort
        $this->d_upload->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_upload'] = &$this->d_upload;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "sample_req_cart";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = CurrentUserLevel() == 0 ? "`operator` = ".  CurrentUserID() : "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->request_by->DbValue = $row['request_by'];
        $this->old_ref->DbValue = $row['old_ref'];
        $this->upload->Upload->DbValue = $row['upload'];
        $this->design->DbValue = $row['design'];
        $this->color->DbValue = $row['color'];
        $this->size->DbValue = $row['size'];
        $this->quantity->DbValue = $row['quantity'];
        $this->comments->DbValue = $row['comments'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->po_id->DbValue = $row['po_id'];
        $this->status->DbValue = $row['status'];
        $this->shipping_mode->DbValue = $row['shipping_mode'];
        $this->delivery_week->DbValue = $row['delivery_week'];
        $this->purpose->DbValue = $row['purpose'];
        $this->label->DbValue = $row['label'];
        $this->ssd->DbValue = $row['ssd'];
        $this->shipping_address->DbValue = $row['shipping_address'];
        $this->shipping_address_2->DbValue = $row['shipping_address_2'];
        $this->company_id->DbValue = $row['company_id'];
        $this->partner_id->DbValue = $row['partner_id'];
        $this->sp_remarks->DbValue = $row['sp_remarks'];
        $this->pp_remarks->DbValue = $row['pp_remarks'];
        $this->po_remarks->DbValue = $row['po_remarks'];
        $this->price->DbValue = $row['price'];
        $this->declaration->DbValue = $row['declaration'];
        $this->remarks->DbValue = $row['remarks'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->a_datetime->DbValue = $row['a_datetime'];
        $this->app_operator->DbValue = $row['app_operator'];
        $this->app_datetime->DbValue = $row['app_datetime'];
        $this->po_operator->DbValue = $row['po_operator'];
        $this->po_datetime->DbValue = $row['po_datetime'];
        $this->bom->DbValue = $row['bom'];
        $this->dispatch->DbValue = $row['dispatch'];
        $this->pd_upload->DbValue = $row['pd_upload'];
        $this->d_operator->DbValue = $row['d_operator'];
        $this->d_datetime->DbValue = $row['d_datetime'];
        $this->r_comments->DbValue = $row['r_comments'];
        $this->r_operator->DbValue = $row['r_operator'];
        $this->r_datetime->DbValue = $row['r_datetime'];
        $this->f_yn->DbValue = $row['f_yn'];
        $this->feedback->DbValue = $row['feedback'];
        $this->f_upload->DbValue = $row['f_upload'];
        $this->f_operator->DbValue = $row['f_operator'];
        $this->f_datetime->DbValue = $row['f_datetime'];
        $this->r_text->DbValue = $row['r_text'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->fr_operator->DbValue = $row['fr_operator'];
        $this->fr_datetime->DbValue = $row['fr_datetime'];
        $this->app_status->DbValue = $row['app_status'];
        $this->da_comments->DbValue = $row['da_comments'];
        $this->da_status->DbValue = $row['da_status'];
        $this->da_operator->DbValue = $row['da_operator'];
        $this->da_datetime->DbValue = $row['da_datetime'];
        $this->req_chat_id->DbValue = $row['req_chat_id'];
        $this->pd_operator->DbValue = $row['pd_operator'];
        $this->pd_comments->DbValue = $row['pd_comments'];
        $this->pd_datetime->DbValue = $row['pd_datetime'];
        $this->d_upload->DbValue = $row['d_upload'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->upload->OldUploadPath = $this->upload->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['upload']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['upload']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->upload->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("samplereqcartlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "samplereqcartview" => $Language->phrase("View"),
            "samplereqcartedit" => $Language->phrase("Edit"),
            "samplereqcartadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "samplereqcartlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "SampleReqCartView",
            Config("API_ADD_ACTION") => "SampleReqCartAdd",
            Config("API_EDIT_ACTION") => "SampleReqCartEdit",
            Config("API_DELETE_ACTION") => "SampleReqCartDelete",
            Config("API_LIST_ACTION") => "SampleReqCartList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "samplereqcartlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("samplereqcartview", $parm);
        } else {
            $url = $this->keyUrl("samplereqcartview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "samplereqcartadd?" . $parm;
        } else {
            $url = "samplereqcartadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("samplereqcartedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("samplereqcartlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("samplereqcartadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("samplereqcartlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("samplereqcartdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->request_by->setDbValue($row['request_by']);
        $this->old_ref->setDbValue($row['old_ref']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->design->setDbValue($row['design']);
        $this->color->setDbValue($row['color']);
        $this->size->setDbValue($row['size']);
        $this->quantity->setDbValue($row['quantity']);
        $this->comments->setDbValue($row['comments']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->po_id->setDbValue($row['po_id']);
        $this->status->setDbValue($row['status']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->delivery_week->setDbValue($row['delivery_week']);
        $this->purpose->setDbValue($row['purpose']);
        $this->label->setDbValue($row['label']);
        $this->ssd->setDbValue($row['ssd']);
        $this->shipping_address->setDbValue($row['shipping_address']);
        $this->shipping_address_2->setDbValue($row['shipping_address_2']);
        $this->company_id->setDbValue($row['company_id']);
        $this->partner_id->setDbValue($row['partner_id']);
        $this->sp_remarks->setDbValue($row['sp_remarks']);
        $this->pp_remarks->setDbValue($row['pp_remarks']);
        $this->po_remarks->setDbValue($row['po_remarks']);
        $this->price->setDbValue($row['price']);
        $this->declaration->setDbValue($row['declaration']);
        $this->remarks->setDbValue($row['remarks']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->app_operator->setDbValue($row['app_operator']);
        $this->app_datetime->setDbValue($row['app_datetime']);
        $this->po_operator->setDbValue($row['po_operator']);
        $this->po_datetime->setDbValue($row['po_datetime']);
        $this->bom->setDbValue($row['bom']);
        $this->dispatch->setDbValue($row['dispatch']);
        $this->pd_upload->setDbValue($row['pd_upload']);
        $this->d_operator->setDbValue($row['d_operator']);
        $this->d_datetime->setDbValue($row['d_datetime']);
        $this->r_comments->setDbValue($row['r_comments']);
        $this->r_operator->setDbValue($row['r_operator']);
        $this->r_datetime->setDbValue($row['r_datetime']);
        $this->f_yn->setDbValue($row['f_yn']);
        $this->feedback->setDbValue($row['feedback']);
        $this->f_upload->setDbValue($row['f_upload']);
        $this->f_operator->setDbValue($row['f_operator']);
        $this->f_datetime->setDbValue($row['f_datetime']);
        $this->r_text->setDbValue($row['r_text']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->fr_operator->setDbValue($row['fr_operator']);
        $this->fr_datetime->setDbValue($row['fr_datetime']);
        $this->app_status->setDbValue($row['app_status']);
        $this->da_comments->setDbValue($row['da_comments']);
        $this->da_status->setDbValue($row['da_status']);
        $this->da_operator->setDbValue($row['da_operator']);
        $this->da_datetime->setDbValue($row['da_datetime']);
        $this->req_chat_id->setDbValue($row['req_chat_id']);
        $this->pd_operator->setDbValue($row['pd_operator']);
        $this->pd_comments->setDbValue($row['pd_comments']);
        $this->pd_datetime->setDbValue($row['pd_datetime']);
        $this->d_upload->setDbValue($row['d_upload']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "SampleReqCartList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // request_by

        // old_ref

        // upload

        // design

        // color

        // size

        // quantity

        // comments

        // operator

        // datetime

        // po_id
        $this->po_id->CellCssStyle = "white-space: nowrap;";

        // status
        $this->status->CellCssStyle = "white-space: nowrap;";

        // shipping_mode
        $this->shipping_mode->CellCssStyle = "white-space: nowrap;";

        // delivery_week
        $this->delivery_week->CellCssStyle = "white-space: nowrap;";

        // purpose
        $this->purpose->CellCssStyle = "white-space: nowrap;";

        // label
        $this->label->CellCssStyle = "white-space: nowrap;";

        // ssd
        $this->ssd->CellCssStyle = "white-space: nowrap;";

        // shipping_address
        $this->shipping_address->CellCssStyle = "white-space: nowrap;";

        // shipping_address_2
        $this->shipping_address_2->CellCssStyle = "white-space: nowrap;";

        // company_id
        $this->company_id->CellCssStyle = "white-space: nowrap;";

        // partner_id
        $this->partner_id->CellCssStyle = "white-space: nowrap;";

        // sp_remarks
        $this->sp_remarks->CellCssStyle = "white-space: nowrap;";

        // pp_remarks
        $this->pp_remarks->CellCssStyle = "white-space: nowrap;";

        // po_remarks
        $this->po_remarks->CellCssStyle = "white-space: nowrap;";

        // price
        $this->price->CellCssStyle = "white-space: nowrap;";

        // declaration
        $this->declaration->CellCssStyle = "white-space: nowrap;";

        // remarks
        $this->remarks->CellCssStyle = "white-space: nowrap;";

        // a_operator
        $this->a_operator->CellCssStyle = "white-space: nowrap;";

        // a_datetime
        $this->a_datetime->CellCssStyle = "white-space: nowrap;";

        // app_operator
        $this->app_operator->CellCssStyle = "white-space: nowrap;";

        // app_datetime
        $this->app_datetime->CellCssStyle = "white-space: nowrap;";

        // po_operator
        $this->po_operator->CellCssStyle = "white-space: nowrap;";

        // po_datetime
        $this->po_datetime->CellCssStyle = "white-space: nowrap;";

        // bom
        $this->bom->CellCssStyle = "white-space: nowrap;";

        // dispatch
        $this->dispatch->CellCssStyle = "white-space: nowrap;";

        // pd_upload
        $this->pd_upload->CellCssStyle = "white-space: nowrap;";

        // d_operator
        $this->d_operator->CellCssStyle = "white-space: nowrap;";

        // d_datetime
        $this->d_datetime->CellCssStyle = "white-space: nowrap;";

        // r_comments
        $this->r_comments->CellCssStyle = "white-space: nowrap;";

        // r_operator
        $this->r_operator->CellCssStyle = "white-space: nowrap;";

        // r_datetime
        $this->r_datetime->CellCssStyle = "white-space: nowrap;";

        // f_yn
        $this->f_yn->CellCssStyle = "white-space: nowrap;";

        // feedback
        $this->feedback->CellCssStyle = "white-space: nowrap;";

        // f_upload
        $this->f_upload->CellCssStyle = "white-space: nowrap;";

        // f_operator
        $this->f_operator->CellCssStyle = "white-space: nowrap;";

        // f_datetime
        $this->f_datetime->CellCssStyle = "white-space: nowrap;";

        // r_text
        $this->r_text->CellCssStyle = "white-space: nowrap;";

        // barcode
        $this->_barcode->CellCssStyle = "white-space: nowrap;";

        // fr_operator
        $this->fr_operator->CellCssStyle = "white-space: nowrap;";

        // fr_datetime
        $this->fr_datetime->CellCssStyle = "white-space: nowrap;";

        // app_status
        $this->app_status->CellCssStyle = "white-space: nowrap;";

        // da_comments
        $this->da_comments->CellCssStyle = "white-space: nowrap;";

        // da_status
        $this->da_status->CellCssStyle = "white-space: nowrap;";

        // da_operator
        $this->da_operator->CellCssStyle = "white-space: nowrap;";

        // da_datetime
        $this->da_datetime->CellCssStyle = "white-space: nowrap;";

        // req_chat_id
        $this->req_chat_id->CellCssStyle = "white-space: nowrap;";

        // pd_operator
        $this->pd_operator->CellCssStyle = "white-space: nowrap;";

        // pd_comments
        $this->pd_comments->CellCssStyle = "white-space: nowrap;";

        // pd_datetime
        $this->pd_datetime->CellCssStyle = "white-space: nowrap;";

        // d_upload
        $this->d_upload->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // request_by
        $curVal = strval($this->request_by->CurrentValue);
        if ($curVal != "") {
            $this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
            if ($this->request_by->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->request_by->getSelectFilter($this); // PHP
                $sqlWrk = $this->request_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->request_by->Lookup->renderViewRow($rswrk[0]);
                    $this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
                } else {
                    $this->request_by->ViewValue = FormatNumber($this->request_by->CurrentValue, $this->request_by->formatPattern());
                }
            }
        } else {
            $this->request_by->ViewValue = null;
        }

        // old_ref
        $this->old_ref->ViewValue = $this->old_ref->CurrentValue;

        // upload
        $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
        if (!EmptyValue($this->upload->Upload->DbValue)) {
            $this->upload->ImageWidth = 0;
            $this->upload->ImageHeight = 50;
            $this->upload->ImageAlt = $this->upload->alt();
            $this->upload->ImageCssClass = "ew-image";
            $this->upload->ViewValue = $this->upload->Upload->DbValue;
        } else {
            $this->upload->ViewValue = "";
        }

        // design
        $this->design->ViewValue = $this->design->CurrentValue;

        // color
        $this->color->ViewValue = $this->color->CurrentValue;

        // size
        $this->size->ViewValue = $this->size->CurrentValue;

        // quantity
        $this->quantity->ViewValue = $this->quantity->CurrentValue;
        $this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, $this->quantity->formatPattern());

        // comments
        $this->comments->ViewValue = $this->comments->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // po_id
        $this->po_id->ViewValue = $this->po_id->CurrentValue;
        $this->po_id->ViewValue = FormatNumber($this->po_id->ViewValue, $this->po_id->formatPattern());

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // shipping_mode
        if (strval($this->shipping_mode->CurrentValue) != "") {
            $this->shipping_mode->ViewValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
        } else {
            $this->shipping_mode->ViewValue = null;
        }

        // delivery_week
        $curVal = strval($this->delivery_week->CurrentValue);
        if ($curVal != "") {
            $this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
            if ($this->delivery_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->delivery_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->delivery_week->Lookup->renderViewRow($rswrk[0]);
                    $this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
                } else {
                    $this->delivery_week->ViewValue = FormatNumber($this->delivery_week->CurrentValue, $this->delivery_week->formatPattern());
                }
            }
        } else {
            $this->delivery_week->ViewValue = null;
        }

        // purpose
        $curVal = strval($this->purpose->CurrentValue);
        if ($curVal != "") {
            $this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
            if ($this->purpose->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->purpose->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->purpose->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->purpose->getSelectFilter($this); // PHP
                $sqlWrk = $this->purpose->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->purpose->Lookup->renderViewRow($rswrk[0]);
                    $this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
                } else {
                    $this->purpose->ViewValue = FormatNumber($this->purpose->CurrentValue, $this->purpose->formatPattern());
                }
            }
        } else {
            $this->purpose->ViewValue = null;
        }

        // label
        $curVal = strval($this->label->CurrentValue);
        if ($curVal != "") {
            $this->label->ViewValue = $this->label->lookupCacheOption($curVal);
            if ($this->label->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->label->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->label->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->label->getSelectFilter($this); // PHP
                $sqlWrk = $this->label->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->label->Lookup->renderViewRow($rswrk[0]);
                    $this->label->ViewValue = $this->label->displayValue($arwrk);
                } else {
                    $this->label->ViewValue = $this->label->CurrentValue;
                }
            }
        } else {
            $this->label->ViewValue = null;
        }

        // ssd
        $this->ssd->ViewValue = $this->ssd->CurrentValue;
        $this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, $this->ssd->formatPattern());

        // shipping_address
        $curVal = strval($this->shipping_address->CurrentValue);
        if ($curVal != "") {
            $this->shipping_address->ViewValue = $this->shipping_address->lookupCacheOption($curVal);
            if ($this->shipping_address->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->shipping_address->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shipping_address->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->shipping_address->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->shipping_address->Lookup->renderViewRow($rswrk[0]);
                    $this->shipping_address->ViewValue = $this->shipping_address->displayValue($arwrk);
                } else {
                    $this->shipping_address->ViewValue = FormatNumber($this->shipping_address->CurrentValue, $this->shipping_address->formatPattern());
                }
            }
        } else {
            $this->shipping_address->ViewValue = null;
        }

        // shipping_address_2
        $this->shipping_address_2->ViewValue = $this->shipping_address_2->CurrentValue;

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // partner_id
        $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
        $curVal = strval($this->partner_id->CurrentValue);
        if ($curVal != "") {
            $this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
            if ($this->partner_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->partner_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->partner_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->partner_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->partner_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->partner_id->Lookup->renderViewRow($rswrk[0]);
                    $this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
                } else {
                    $this->partner_id->ViewValue = $this->partner_id->CurrentValue;
                }
            }
        } else {
            $this->partner_id->ViewValue = null;
        }

        // sp_remarks
        $this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;

        // pp_remarks
        $this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;

        // po_remarks
        $this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;

        // price
        $this->price->ViewValue = $this->price->CurrentValue;

        // declaration
        $this->declaration->ViewValue = $this->declaration->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // a_operator
        $curVal = strval($this->a_operator->CurrentValue);
        if ($curVal != "") {
            $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            if ($this->a_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                } else {
                    $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                }
            }
        } else {
            $this->a_operator->ViewValue = null;
        }

        // a_datetime
        $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
        $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

        // app_operator
        $this->app_operator->ViewValue = $this->app_operator->CurrentValue;
        $this->app_operator->ViewValue = FormatNumber($this->app_operator->ViewValue, $this->app_operator->formatPattern());

        // app_datetime
        $this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
        $this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, $this->app_datetime->formatPattern());

        // po_operator
        $this->po_operator->ViewValue = $this->po_operator->CurrentValue;
        $this->po_operator->ViewValue = FormatNumber($this->po_operator->ViewValue, $this->po_operator->formatPattern());

        // po_datetime
        $this->po_datetime->ViewValue = $this->po_datetime->CurrentValue;
        $this->po_datetime->ViewValue = FormatDateTime($this->po_datetime->ViewValue, $this->po_datetime->formatPattern());

        // bom
        $this->bom->ViewValue = $this->bom->CurrentValue;

        // dispatch
        $this->dispatch->ViewValue = $this->dispatch->CurrentValue;

        // pd_upload
        $this->pd_upload->ViewValue = $this->pd_upload->CurrentValue;

        // d_operator
        $this->d_operator->ViewValue = $this->d_operator->CurrentValue;
        $this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, $this->d_operator->formatPattern());

        // d_datetime
        $this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
        $this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, $this->d_datetime->formatPattern());

        // r_comments
        $this->r_comments->ViewValue = $this->r_comments->CurrentValue;

        // r_operator
        $this->r_operator->ViewValue = $this->r_operator->CurrentValue;
        $this->r_operator->ViewValue = FormatNumber($this->r_operator->ViewValue, $this->r_operator->formatPattern());

        // r_datetime
        $this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
        $this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, $this->r_datetime->formatPattern());

        // f_yn
        $this->f_yn->ViewValue = $this->f_yn->CurrentValue;
        $this->f_yn->ViewValue = FormatNumber($this->f_yn->ViewValue, $this->f_yn->formatPattern());

        // feedback
        $this->feedback->ViewValue = $this->feedback->CurrentValue;

        // f_upload
        $this->f_upload->ViewValue = $this->f_upload->CurrentValue;

        // f_operator
        $this->f_operator->ViewValue = $this->f_operator->CurrentValue;
        $this->f_operator->ViewValue = FormatNumber($this->f_operator->ViewValue, $this->f_operator->formatPattern());

        // f_datetime
        $this->f_datetime->ViewValue = $this->f_datetime->CurrentValue;
        $this->f_datetime->ViewValue = FormatDateTime($this->f_datetime->ViewValue, $this->f_datetime->formatPattern());

        // r_text
        $this->r_text->ViewValue = $this->r_text->CurrentValue;

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // fr_operator
        $this->fr_operator->ViewValue = $this->fr_operator->CurrentValue;
        $this->fr_operator->ViewValue = FormatNumber($this->fr_operator->ViewValue, $this->fr_operator->formatPattern());

        // fr_datetime
        $this->fr_datetime->ViewValue = $this->fr_datetime->CurrentValue;
        $this->fr_datetime->ViewValue = FormatDateTime($this->fr_datetime->ViewValue, $this->fr_datetime->formatPattern());

        // app_status
        $curVal = strval($this->app_status->CurrentValue);
        if ($curVal != "") {
            $this->app_status->ViewValue = $this->app_status->lookupCacheOption($curVal);
            if ($this->app_status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->app_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->app_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->app_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->app_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->app_status->Lookup->renderViewRow($rswrk[0]);
                    $this->app_status->ViewValue = $this->app_status->displayValue($arwrk);
                } else {
                    $this->app_status->ViewValue = FormatNumber($this->app_status->CurrentValue, $this->app_status->formatPattern());
                }
            }
        } else {
            $this->app_status->ViewValue = null;
        }

        // da_comments
        $this->da_comments->ViewValue = $this->da_comments->CurrentValue;

        // da_status
        $curVal = strval($this->da_status->CurrentValue);
        if ($curVal != "") {
            $this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
            if ($this->da_status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->da_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->da_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->da_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->da_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->da_status->Lookup->renderViewRow($rswrk[0]);
                    $this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
                } else {
                    $this->da_status->ViewValue = FormatNumber($this->da_status->CurrentValue, $this->da_status->formatPattern());
                }
            }
        } else {
            $this->da_status->ViewValue = null;
        }

        // da_operator
        $this->da_operator->ViewValue = $this->da_operator->CurrentValue;
        $this->da_operator->ViewValue = FormatNumber($this->da_operator->ViewValue, $this->da_operator->formatPattern());

        // da_datetime
        $this->da_datetime->ViewValue = $this->da_datetime->CurrentValue;
        $this->da_datetime->ViewValue = FormatDateTime($this->da_datetime->ViewValue, $this->da_datetime->formatPattern());

        // req_chat_id
        $this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;

        // pd_operator
        $this->pd_operator->ViewValue = $this->pd_operator->CurrentValue;
        $this->pd_operator->ViewValue = FormatNumber($this->pd_operator->ViewValue, $this->pd_operator->formatPattern());

        // pd_comments
        $this->pd_comments->ViewValue = $this->pd_comments->CurrentValue;

        // pd_datetime
        $this->pd_datetime->ViewValue = $this->pd_datetime->CurrentValue;
        $this->pd_datetime->ViewValue = FormatDateTime($this->pd_datetime->ViewValue, $this->pd_datetime->formatPattern());

        // d_upload
        $this->d_upload->ViewValue = $this->d_upload->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // request_by
        $this->request_by->HrefValue = "";
        $this->request_by->TooltipValue = "";

        // old_ref
        if (!EmptyValue($this->old_ref->CurrentValue)) {
            $this->old_ref->HrefValue = $this->old_ref->getLinkPrefix() . $this->old_ref->CurrentValue . $this->old_ref->getLinkSuffix(); // Add prefix/suffix
            $this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
            }
        } else {
            $this->old_ref->HrefValue = "";
        }
        $this->old_ref->TooltipValue = "";

        // upload
        $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
        if (!EmptyValue($this->upload->Upload->DbValue)) {
            $this->upload->HrefValue = "%u"; // Add prefix/suffix
            $this->upload->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
            }
        } else {
            $this->upload->HrefValue = "";
        }
        $this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
        $this->upload->TooltipValue = "";
        if ($this->upload->UseColorbox) {
            if (EmptyValue($this->upload->TooltipValue)) {
                $this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->upload->LinkAttrs["data-rel"] = "sample_req_cart_x_upload";
            $this->upload->LinkAttrs->appendClass("ew-lightbox");
        }

        // design
        $this->design->HrefValue = "";
        $this->design->TooltipValue = "";

        // color
        $this->color->HrefValue = "";
        $this->color->TooltipValue = "";

        // size
        $this->size->HrefValue = "";
        $this->size->TooltipValue = "";

        // quantity
        $this->quantity->HrefValue = "";
        $this->quantity->TooltipValue = "";

        // comments
        $this->comments->HrefValue = "";
        $this->comments->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // po_id
        $this->po_id->HrefValue = "";
        $this->po_id->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // shipping_mode
        $this->shipping_mode->HrefValue = "";
        $this->shipping_mode->TooltipValue = "";

        // delivery_week
        $this->delivery_week->HrefValue = "";
        $this->delivery_week->TooltipValue = "";

        // purpose
        $this->purpose->HrefValue = "";
        $this->purpose->TooltipValue = "";

        // label
        $this->label->HrefValue = "";
        $this->label->TooltipValue = "";

        // ssd
        $this->ssd->HrefValue = "";
        $this->ssd->TooltipValue = "";

        // shipping_address
        $this->shipping_address->HrefValue = "";
        $this->shipping_address->TooltipValue = "";

        // shipping_address_2
        $this->shipping_address_2->HrefValue = "";
        $this->shipping_address_2->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // partner_id
        if (!EmptyValue($this->partner_id->CurrentValue)) {
            $this->partner_id->HrefValue = $this->partner_id->getLinkPrefix() . $this->partner_id->CurrentValue; // Add prefix/suffix
            $this->partner_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
            }
        } else {
            $this->partner_id->HrefValue = "";
        }
        $this->partner_id->TooltipValue = "";

        // sp_remarks
        $this->sp_remarks->HrefValue = "";
        $this->sp_remarks->TooltipValue = "";

        // pp_remarks
        $this->pp_remarks->HrefValue = "";
        $this->pp_remarks->TooltipValue = "";

        // po_remarks
        $this->po_remarks->HrefValue = "";
        $this->po_remarks->TooltipValue = "";

        // price
        $this->price->HrefValue = "";
        $this->price->TooltipValue = "";

        // declaration
        $this->declaration->HrefValue = "";
        $this->declaration->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // a_datetime
        $this->a_datetime->HrefValue = "";
        $this->a_datetime->TooltipValue = "";

        // app_operator
        $this->app_operator->HrefValue = "";
        $this->app_operator->TooltipValue = "";

        // app_datetime
        $this->app_datetime->HrefValue = "";
        $this->app_datetime->TooltipValue = "";

        // po_operator
        $this->po_operator->HrefValue = "";
        $this->po_operator->TooltipValue = "";

        // po_datetime
        $this->po_datetime->HrefValue = "";
        $this->po_datetime->TooltipValue = "";

        // bom
        $this->bom->HrefValue = "";
        $this->bom->TooltipValue = "";

        // dispatch
        $this->dispatch->HrefValue = "";
        $this->dispatch->TooltipValue = "";

        // pd_upload
        $this->pd_upload->HrefValue = "";
        $this->pd_upload->TooltipValue = "";

        // d_operator
        $this->d_operator->HrefValue = "";
        $this->d_operator->TooltipValue = "";

        // d_datetime
        $this->d_datetime->HrefValue = "";
        $this->d_datetime->TooltipValue = "";

        // r_comments
        $this->r_comments->HrefValue = "";
        $this->r_comments->TooltipValue = "";

        // r_operator
        $this->r_operator->HrefValue = "";
        $this->r_operator->TooltipValue = "";

        // r_datetime
        $this->r_datetime->HrefValue = "";
        $this->r_datetime->TooltipValue = "";

        // f_yn
        $this->f_yn->HrefValue = "";
        $this->f_yn->TooltipValue = "";

        // feedback
        $this->feedback->HrefValue = "";
        $this->feedback->TooltipValue = "";

        // f_upload
        $this->f_upload->HrefValue = "";
        $this->f_upload->TooltipValue = "";

        // f_operator
        $this->f_operator->HrefValue = "";
        $this->f_operator->TooltipValue = "";

        // f_datetime
        $this->f_datetime->HrefValue = "";
        $this->f_datetime->TooltipValue = "";

        // r_text
        $this->r_text->HrefValue = "";
        $this->r_text->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // fr_operator
        $this->fr_operator->HrefValue = "";
        $this->fr_operator->TooltipValue = "";

        // fr_datetime
        $this->fr_datetime->HrefValue = "";
        $this->fr_datetime->TooltipValue = "";

        // app_status
        $this->app_status->HrefValue = "";
        $this->app_status->TooltipValue = "";

        // da_comments
        $this->da_comments->HrefValue = "";
        $this->da_comments->TooltipValue = "";

        // da_status
        $this->da_status->HrefValue = "";
        $this->da_status->TooltipValue = "";

        // da_operator
        $this->da_operator->HrefValue = "";
        $this->da_operator->TooltipValue = "";

        // da_datetime
        $this->da_datetime->HrefValue = "";
        $this->da_datetime->TooltipValue = "";

        // req_chat_id
        $this->req_chat_id->HrefValue = "";
        $this->req_chat_id->TooltipValue = "";

        // pd_operator
        $this->pd_operator->HrefValue = "";
        $this->pd_operator->TooltipValue = "";

        // pd_comments
        $this->pd_comments->HrefValue = "";
        $this->pd_comments->TooltipValue = "";

        // pd_datetime
        $this->pd_datetime->HrefValue = "";
        $this->pd_datetime->TooltipValue = "";

        // d_upload
        $this->d_upload->HrefValue = "";
        $this->d_upload->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // request_by
        $this->request_by->setupEditAttributes();
        $curVal = strval($this->request_by->CurrentValue);
        if ($curVal != "") {
            $this->request_by->EditValue = $this->request_by->lookupCacheOption($curVal);
            if ($this->request_by->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->request_by->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->request_by->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->request_by->getSelectFilter($this); // PHP
                $sqlWrk = $this->request_by->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->request_by->Lookup->renderViewRow($rswrk[0]);
                    $this->request_by->EditValue = $this->request_by->displayValue($arwrk);
                } else {
                    $this->request_by->EditValue = FormatNumber($this->request_by->CurrentValue, $this->request_by->formatPattern());
                }
            }
        } else {
            $this->request_by->EditValue = null;
        }

        // old_ref
        $this->old_ref->setupEditAttributes();
        if (!$this->old_ref->Raw) {
            $this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
        }
        $this->old_ref->EditValue = $this->old_ref->CurrentValue;
        $this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

        // upload
        $this->upload->setupEditAttributes();
        $this->upload->UploadPath = $this->upload->getUploadPath(); // PHP
        if (!EmptyValue($this->upload->Upload->DbValue)) {
            $this->upload->ImageWidth = 0;
            $this->upload->ImageHeight = 50;
            $this->upload->ImageAlt = $this->upload->alt();
            $this->upload->ImageCssClass = "ew-image";
            $this->upload->EditValue = $this->upload->Upload->DbValue;
        } else {
            $this->upload->EditValue = "";
        }
        if (!EmptyValue($this->upload->CurrentValue)) {
            $this->upload->Upload->FileName = $this->upload->CurrentValue;
        }

        // design
        $this->design->setupEditAttributes();
        if (!$this->design->Raw) {
            $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
        }
        $this->design->EditValue = $this->design->CurrentValue;
        $this->design->PlaceHolder = RemoveHtml($this->design->caption());

        // color
        $this->color->setupEditAttributes();
        if (!$this->color->Raw) {
            $this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
        }
        $this->color->EditValue = $this->color->CurrentValue;
        $this->color->PlaceHolder = RemoveHtml($this->color->caption());

        // size
        $this->size->setupEditAttributes();
        if (!$this->size->Raw) {
            $this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
        }
        $this->size->EditValue = $this->size->CurrentValue;
        $this->size->PlaceHolder = RemoveHtml($this->size->caption());

        // quantity
        $this->quantity->setupEditAttributes();
        $this->quantity->EditValue = $this->quantity->CurrentValue;
        $this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
        if (strval($this->quantity->EditValue) != "" && is_numeric($this->quantity->EditValue)) {
            $this->quantity->EditValue = FormatNumber($this->quantity->EditValue, null);
        }

        // comments
        $this->comments->setupEditAttributes();
        $this->comments->EditValue = $this->comments->CurrentValue;
        $this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

        // operator

        // datetime

        // po_id
        $this->po_id->setupEditAttributes();
        $this->po_id->EditValue = $this->po_id->CurrentValue;
        $this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());
        if (strval($this->po_id->EditValue) != "" && is_numeric($this->po_id->EditValue)) {
            $this->po_id->EditValue = FormatNumber($this->po_id->EditValue, null);
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // shipping_mode
        $this->shipping_mode->setupEditAttributes();
        $this->shipping_mode->EditValue = $this->shipping_mode->options(true);
        $this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

        // delivery_week
        $this->delivery_week->setupEditAttributes();
        $this->delivery_week->PlaceHolder = RemoveHtml($this->delivery_week->caption());

        // purpose
        $this->purpose->setupEditAttributes();
        $this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

        // label
        $this->label->setupEditAttributes();
        $this->label->PlaceHolder = RemoveHtml($this->label->caption());

        // ssd
        $this->ssd->setupEditAttributes();
        $this->ssd->EditValue = FormatDateTime($this->ssd->CurrentValue, $this->ssd->formatPattern());
        $this->ssd->PlaceHolder = RemoveHtml($this->ssd->caption());

        // shipping_address
        $this->shipping_address->setupEditAttributes();
        $this->shipping_address->PlaceHolder = RemoveHtml($this->shipping_address->caption());

        // shipping_address_2
        $this->shipping_address_2->setupEditAttributes();
        $this->shipping_address_2->EditValue = $this->shipping_address_2->CurrentValue;
        $this->shipping_address_2->PlaceHolder = RemoveHtml($this->shipping_address_2->caption());

        // company_id
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // partner_id
        $this->partner_id->setupEditAttributes();
        $this->partner_id->EditValue = $this->partner_id->CurrentValue;
        $this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

        // sp_remarks
        $this->sp_remarks->setupEditAttributes();
        $this->sp_remarks->EditValue = $this->sp_remarks->CurrentValue;
        $this->sp_remarks->PlaceHolder = RemoveHtml($this->sp_remarks->caption());

        // pp_remarks
        $this->pp_remarks->setupEditAttributes();
        if (!$this->pp_remarks->Raw) {
            $this->pp_remarks->CurrentValue = HtmlDecode($this->pp_remarks->CurrentValue);
        }
        $this->pp_remarks->EditValue = $this->pp_remarks->CurrentValue;
        $this->pp_remarks->PlaceHolder = RemoveHtml($this->pp_remarks->caption());

        // po_remarks
        $this->po_remarks->setupEditAttributes();
        if (!$this->po_remarks->Raw) {
            $this->po_remarks->CurrentValue = HtmlDecode($this->po_remarks->CurrentValue);
        }
        $this->po_remarks->EditValue = $this->po_remarks->CurrentValue;
        $this->po_remarks->PlaceHolder = RemoveHtml($this->po_remarks->caption());

        // price
        $this->price->setupEditAttributes();
        if (!$this->price->Raw) {
            $this->price->CurrentValue = HtmlDecode($this->price->CurrentValue);
        }
        $this->price->EditValue = $this->price->CurrentValue;
        $this->price->PlaceHolder = RemoveHtml($this->price->caption());

        // declaration
        $this->declaration->setupEditAttributes();
        if (!$this->declaration->Raw) {
            $this->declaration->CurrentValue = HtmlDecode($this->declaration->CurrentValue);
        }
        $this->declaration->EditValue = $this->declaration->CurrentValue;
        $this->declaration->PlaceHolder = RemoveHtml($this->declaration->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // a_operator

        // a_datetime

        // app_operator

        // app_datetime

        // po_operator

        // po_datetime

        // bom
        $this->bom->setupEditAttributes();
        $this->bom->EditValue = $this->bom->CurrentValue;
        $this->bom->PlaceHolder = RemoveHtml($this->bom->caption());

        // dispatch
        $this->dispatch->setupEditAttributes();
        if (!$this->dispatch->Raw) {
            $this->dispatch->CurrentValue = HtmlDecode($this->dispatch->CurrentValue);
        }
        $this->dispatch->EditValue = $this->dispatch->CurrentValue;
        $this->dispatch->PlaceHolder = RemoveHtml($this->dispatch->caption());

        // pd_upload
        $this->pd_upload->setupEditAttributes();
        $this->pd_upload->EditValue = $this->pd_upload->CurrentValue;
        $this->pd_upload->PlaceHolder = RemoveHtml($this->pd_upload->caption());

        // d_operator
        $this->d_operator->setupEditAttributes();
        $this->d_operator->EditValue = $this->d_operator->CurrentValue;
        $this->d_operator->PlaceHolder = RemoveHtml($this->d_operator->caption());
        if (strval($this->d_operator->EditValue) != "" && is_numeric($this->d_operator->EditValue)) {
            $this->d_operator->EditValue = FormatNumber($this->d_operator->EditValue, null);
        }

        // d_datetime
        $this->d_datetime->setupEditAttributes();
        $this->d_datetime->EditValue = FormatDateTime($this->d_datetime->CurrentValue, $this->d_datetime->formatPattern());
        $this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());

        // r_comments
        $this->r_comments->setupEditAttributes();
        if (!$this->r_comments->Raw) {
            $this->r_comments->CurrentValue = HtmlDecode($this->r_comments->CurrentValue);
        }
        $this->r_comments->EditValue = $this->r_comments->CurrentValue;
        $this->r_comments->PlaceHolder = RemoveHtml($this->r_comments->caption());

        // r_operator
        $this->r_operator->setupEditAttributes();
        $this->r_operator->EditValue = $this->r_operator->CurrentValue;
        $this->r_operator->PlaceHolder = RemoveHtml($this->r_operator->caption());
        if (strval($this->r_operator->EditValue) != "" && is_numeric($this->r_operator->EditValue)) {
            $this->r_operator->EditValue = FormatNumber($this->r_operator->EditValue, null);
        }

        // r_datetime
        $this->r_datetime->setupEditAttributes();
        $this->r_datetime->EditValue = FormatDateTime($this->r_datetime->CurrentValue, $this->r_datetime->formatPattern());
        $this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

        // f_yn
        $this->f_yn->setupEditAttributes();
        $this->f_yn->EditValue = $this->f_yn->CurrentValue;
        $this->f_yn->PlaceHolder = RemoveHtml($this->f_yn->caption());
        if (strval($this->f_yn->EditValue) != "" && is_numeric($this->f_yn->EditValue)) {
            $this->f_yn->EditValue = FormatNumber($this->f_yn->EditValue, null);
        }

        // feedback
        $this->feedback->setupEditAttributes();
        $this->feedback->EditValue = $this->feedback->CurrentValue;
        $this->feedback->PlaceHolder = RemoveHtml($this->feedback->caption());

        // f_upload
        $this->f_upload->setupEditAttributes();
        if (!$this->f_upload->Raw) {
            $this->f_upload->CurrentValue = HtmlDecode($this->f_upload->CurrentValue);
        }
        $this->f_upload->EditValue = $this->f_upload->CurrentValue;
        $this->f_upload->PlaceHolder = RemoveHtml($this->f_upload->caption());

        // f_operator
        $this->f_operator->setupEditAttributes();
        $this->f_operator->EditValue = $this->f_operator->CurrentValue;
        $this->f_operator->PlaceHolder = RemoveHtml($this->f_operator->caption());
        if (strval($this->f_operator->EditValue) != "" && is_numeric($this->f_operator->EditValue)) {
            $this->f_operator->EditValue = FormatNumber($this->f_operator->EditValue, null);
        }

        // f_datetime
        $this->f_datetime->setupEditAttributes();
        $this->f_datetime->EditValue = FormatDateTime($this->f_datetime->CurrentValue, $this->f_datetime->formatPattern());
        $this->f_datetime->PlaceHolder = RemoveHtml($this->f_datetime->caption());

        // r_text
        $this->r_text->setupEditAttributes();
        $this->r_text->EditValue = $this->r_text->CurrentValue;
        $this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

        // fr_operator
        $this->fr_operator->setupEditAttributes();
        $this->fr_operator->EditValue = $this->fr_operator->CurrentValue;
        $this->fr_operator->PlaceHolder = RemoveHtml($this->fr_operator->caption());
        if (strval($this->fr_operator->EditValue) != "" && is_numeric($this->fr_operator->EditValue)) {
            $this->fr_operator->EditValue = FormatNumber($this->fr_operator->EditValue, null);
        }

        // fr_datetime
        $this->fr_datetime->setupEditAttributes();
        $this->fr_datetime->EditValue = FormatDateTime($this->fr_datetime->CurrentValue, $this->fr_datetime->formatPattern());
        $this->fr_datetime->PlaceHolder = RemoveHtml($this->fr_datetime->caption());

        // app_status
        $this->app_status->setupEditAttributes();
        $this->app_status->PlaceHolder = RemoveHtml($this->app_status->caption());

        // da_comments
        $this->da_comments->setupEditAttributes();
        $this->da_comments->EditValue = $this->da_comments->CurrentValue;
        $this->da_comments->PlaceHolder = RemoveHtml($this->da_comments->caption());

        // da_status
        $this->da_status->setupEditAttributes();
        $this->da_status->PlaceHolder = RemoveHtml($this->da_status->caption());

        // da_operator
        $this->da_operator->setupEditAttributes();
        $this->da_operator->EditValue = $this->da_operator->CurrentValue;
        $this->da_operator->PlaceHolder = RemoveHtml($this->da_operator->caption());
        if (strval($this->da_operator->EditValue) != "" && is_numeric($this->da_operator->EditValue)) {
            $this->da_operator->EditValue = FormatNumber($this->da_operator->EditValue, null);
        }

        // da_datetime
        $this->da_datetime->setupEditAttributes();
        $this->da_datetime->EditValue = FormatDateTime($this->da_datetime->CurrentValue, $this->da_datetime->formatPattern());
        $this->da_datetime->PlaceHolder = RemoveHtml($this->da_datetime->caption());

        // req_chat_id
        $this->req_chat_id->setupEditAttributes();
        if (!$this->req_chat_id->Raw) {
            $this->req_chat_id->CurrentValue = HtmlDecode($this->req_chat_id->CurrentValue);
        }
        $this->req_chat_id->EditValue = $this->req_chat_id->CurrentValue;
        $this->req_chat_id->PlaceHolder = RemoveHtml($this->req_chat_id->caption());

        // pd_operator
        $this->pd_operator->setupEditAttributes();
        $this->pd_operator->EditValue = $this->pd_operator->CurrentValue;
        $this->pd_operator->PlaceHolder = RemoveHtml($this->pd_operator->caption());
        if (strval($this->pd_operator->EditValue) != "" && is_numeric($this->pd_operator->EditValue)) {
            $this->pd_operator->EditValue = FormatNumber($this->pd_operator->EditValue, null);
        }

        // pd_comments
        $this->pd_comments->setupEditAttributes();
        $this->pd_comments->EditValue = $this->pd_comments->CurrentValue;
        $this->pd_comments->PlaceHolder = RemoveHtml($this->pd_comments->caption());

        // pd_datetime
        $this->pd_datetime->setupEditAttributes();
        $this->pd_datetime->EditValue = FormatDateTime($this->pd_datetime->CurrentValue, $this->pd_datetime->formatPattern());
        $this->pd_datetime->PlaceHolder = RemoveHtml($this->pd_datetime->caption());

        // d_upload
        $this->d_upload->setupEditAttributes();
        if (!$this->d_upload->Raw) {
            $this->d_upload->CurrentValue = HtmlDecode($this->d_upload->CurrentValue);
        }
        $this->d_upload->EditValue = $this->d_upload->CurrentValue;
        $this->d_upload->PlaceHolder = RemoveHtml($this->d_upload->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->request_by);
                    $doc->exportCaption($this->old_ref);
                    $doc->exportCaption($this->upload);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->color);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->comments);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->po_id);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->request_by);
                    $doc->exportCaption($this->old_ref);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->color);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->quantity);
                    $doc->exportCaption($this->comments);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->request_by);
                        $doc->exportField($this->old_ref);
                        $doc->exportField($this->upload);
                        $doc->exportField($this->design);
                        $doc->exportField($this->color);
                        $doc->exportField($this->size);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->comments);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->po_id);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->request_by);
                        $doc->exportField($this->old_ref);
                        $doc->exportField($this->design);
                        $doc->exportField($this->color);
                        $doc->exportField($this->size);
                        $doc->exportField($this->quantity);
                        $doc->exportField($this->comments);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'upload') {
            $fldName = "upload";
            $fileNameFld = "upload";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
