<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SampleReqAdd extends SampleReq
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SampleReqAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "samplereqadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->buyer_id->setVisibility();
        $this->sample_cart_id->setVisibility();
        $this->purpose->setVisibility();
        $this->label->setVisibility();
        $this->ssd->setVisibility();
        $this->shipping_mode->setVisibility();
        $this->delivery_week->setVisibility();
        $this->shipping_address->setVisibility();
        $this->remarks->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->status->Visible = false;
        $this->upload->Visible = false;
        $this->shipping_address_2->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'sample_req';
        $this->TableName = 'sample_req';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (sample_req)
        if (!isset($GLOBALS["sample_req"]) || $GLOBALS["sample_req"]::class == PROJECT_NAMESPACE . "sample_req") {
            $GLOBALS["sample_req"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "samplereqview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->sample_cart_id);
        $this->setupLookupOptions($this->purpose);
        $this->setupLookupOptions($this->label);
        $this->setupLookupOptions($this->shipping_mode);
        $this->setupLookupOptions($this->delivery_week);
        $this->setupLookupOptions($this->shipping_address);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("samplereqlist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = "samplereqlist";
                    if (GetPageName($returnUrl) == "samplereqlist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "samplereqview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "samplereqlist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "samplereqlist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->buyer_id->DefaultValue = $this->buyer_id->getDefault(); // PHP
        $this->buyer_id->OldValue = $this->buyer_id->DefaultValue;
        $this->sample_cart_id->DefaultValue = $this->sample_cart_id->getDefault(); // PHP
        $this->sample_cart_id->OldValue = $this->sample_cart_id->DefaultValue;
        $this->purpose->DefaultValue = $this->purpose->getDefault(); // PHP
        $this->purpose->OldValue = $this->purpose->DefaultValue;
        $this->label->DefaultValue = $this->label->getDefault(); // PHP
        $this->label->OldValue = $this->label->DefaultValue;
        $this->ssd->DefaultValue = $this->ssd->getDefault(); // PHP
        $this->ssd->OldValue = $this->ssd->DefaultValue;
        $this->shipping_mode->DefaultValue = $this->shipping_mode->getDefault(); // PHP
        $this->shipping_mode->OldValue = $this->shipping_mode->DefaultValue;
        $this->delivery_week->DefaultValue = $this->delivery_week->getDefault(); // PHP
        $this->delivery_week->OldValue = $this->delivery_week->DefaultValue;
        $this->shipping_address->DefaultValue = $this->shipping_address->getDefault(); // PHP
        $this->shipping_address->OldValue = $this->shipping_address->DefaultValue;
        $this->remarks->DefaultValue = $this->remarks->getDefault(); // PHP
        $this->remarks->OldValue = $this->remarks->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'buyer_id' first before field var 'x_buyer_id'
        $val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
        if (!$this->buyer_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_id->Visible = false; // Disable update for API request
            } else {
                $this->buyer_id->setFormValue($val);
            }
        }

        // Check field name 'sample_cart_id' first before field var 'x_sample_cart_id'
        $val = $CurrentForm->hasValue("sample_cart_id") ? $CurrentForm->getValue("sample_cart_id") : $CurrentForm->getValue("x_sample_cart_id");
        if (!$this->sample_cart_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sample_cart_id->Visible = false; // Disable update for API request
            } else {
                $this->sample_cart_id->setFormValue($val);
            }
        }

        // Check field name 'purpose' first before field var 'x_purpose'
        $val = $CurrentForm->hasValue("purpose") ? $CurrentForm->getValue("purpose") : $CurrentForm->getValue("x_purpose");
        if (!$this->purpose->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->purpose->Visible = false; // Disable update for API request
            } else {
                $this->purpose->setFormValue($val);
            }
        }

        // Check field name 'label' first before field var 'x_label'
        $val = $CurrentForm->hasValue("label") ? $CurrentForm->getValue("label") : $CurrentForm->getValue("x_label");
        if (!$this->label->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->label->Visible = false; // Disable update for API request
            } else {
                $this->label->setFormValue($val);
            }
        }

        // Check field name 'ssd' first before field var 'x_ssd'
        $val = $CurrentForm->hasValue("ssd") ? $CurrentForm->getValue("ssd") : $CurrentForm->getValue("x_ssd");
        if (!$this->ssd->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->ssd->Visible = false; // Disable update for API request
            } else {
                $this->ssd->setFormValue($val, true, $validate);
            }
            $this->ssd->CurrentValue = UnFormatDateTime($this->ssd->CurrentValue, $this->ssd->formatPattern());
        }

        // Check field name 'shipping_mode' first before field var 'x_shipping_mode'
        $val = $CurrentForm->hasValue("shipping_mode") ? $CurrentForm->getValue("shipping_mode") : $CurrentForm->getValue("x_shipping_mode");
        if (!$this->shipping_mode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_mode->Visible = false; // Disable update for API request
            } else {
                $this->shipping_mode->setFormValue($val);
            }
        }

        // Check field name 'delivery_week' first before field var 'x_delivery_week'
        $val = $CurrentForm->hasValue("delivery_week") ? $CurrentForm->getValue("delivery_week") : $CurrentForm->getValue("x_delivery_week");
        if (!$this->delivery_week->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->delivery_week->Visible = false; // Disable update for API request
            } else {
                $this->delivery_week->setFormValue($val);
            }
        }

        // Check field name 'shipping_address' first before field var 'x_shipping_address'
        $val = $CurrentForm->hasValue("shipping_address") ? $CurrentForm->getValue("shipping_address") : $CurrentForm->getValue("x_shipping_address");
        if (!$this->shipping_address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_address->Visible = false; // Disable update for API request
            } else {
                $this->shipping_address->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
        $this->sample_cart_id->CurrentValue = $this->sample_cart_id->FormValue;
        $this->purpose->CurrentValue = $this->purpose->FormValue;
        $this->label->CurrentValue = $this->label->FormValue;
        $this->ssd->CurrentValue = $this->ssd->FormValue;
        $this->ssd->CurrentValue = UnFormatDateTime($this->ssd->CurrentValue, $this->ssd->formatPattern());
        $this->shipping_mode->CurrentValue = $this->shipping_mode->FormValue;
        $this->delivery_week->CurrentValue = $this->delivery_week->FormValue;
        $this->shipping_address->CurrentValue = $this->shipping_address->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->sample_cart_id->setDbValue($row['sample_cart_id']);
        $this->purpose->setDbValue($row['purpose']);
        $this->label->setDbValue($row['label']);
        $this->ssd->setDbValue($row['ssd']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->delivery_week->setDbValue($row['delivery_week']);
        $this->shipping_address->setDbValue($row['shipping_address']);
        $this->remarks->setDbValue($row['remarks']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->status->setDbValue($row['status']);
        $this->upload->Upload->DbValue = $row['upload'];
        $this->upload->setDbValue($this->upload->Upload->DbValue);
        $this->shipping_address_2->setDbValue($row['shipping_address_2']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['buyer_id'] = $this->buyer_id->DefaultValue;
        $row['sample_cart_id'] = $this->sample_cart_id->DefaultValue;
        $row['purpose'] = $this->purpose->DefaultValue;
        $row['label'] = $this->label->DefaultValue;
        $row['ssd'] = $this->ssd->DefaultValue;
        $row['shipping_mode'] = $this->shipping_mode->DefaultValue;
        $row['delivery_week'] = $this->delivery_week->DefaultValue;
        $row['shipping_address'] = $this->shipping_address->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['upload'] = $this->upload->DefaultValue;
        $row['shipping_address_2'] = $this->shipping_address_2->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // sample_cart_id
        $this->sample_cart_id->RowCssClass = "row";

        // purpose
        $this->purpose->RowCssClass = "row";

        // label
        $this->label->RowCssClass = "row";

        // ssd
        $this->ssd->RowCssClass = "row";

        // shipping_mode
        $this->shipping_mode->RowCssClass = "row";

        // delivery_week
        $this->delivery_week->RowCssClass = "row";

        // shipping_address
        $this->shipping_address->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // upload
        $this->upload->RowCssClass = "row";

        // shipping_address_2
        $this->shipping_address_2->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = FormatNumber($this->buyer_id->CurrentValue, $this->buyer_id->formatPattern());
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // sample_cart_id
            $curVal = strval($this->sample_cart_id->CurrentValue);
            if ($curVal != "") {
                $this->sample_cart_id->ViewValue = $this->sample_cart_id->lookupCacheOption($curVal);
                if ($this->sample_cart_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->sample_cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->sample_cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->sample_cart_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->sample_cart_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->sample_cart_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->sample_cart_id->Lookup->renderViewRow($row);
                            $this->sample_cart_id->ViewValue->add($this->sample_cart_id->displayValue($arwrk));
                        }
                    } else {
                        $this->sample_cart_id->ViewValue = $this->sample_cart_id->CurrentValue;
                    }
                }
            } else {
                $this->sample_cart_id->ViewValue = null;
            }

            // purpose
            $curVal = strval($this->purpose->CurrentValue);
            if ($curVal != "") {
                $this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
                if ($this->purpose->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->purpose->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->purpose->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->purpose->getSelectFilter($this); // PHP
                    $sqlWrk = $this->purpose->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->purpose->Lookup->renderViewRow($rswrk[0]);
                        $this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
                    } else {
                        $this->purpose->ViewValue = FormatNumber($this->purpose->CurrentValue, $this->purpose->formatPattern());
                    }
                }
            } else {
                $this->purpose->ViewValue = null;
            }

            // label
            $curVal = strval($this->label->CurrentValue);
            if ($curVal != "") {
                $this->label->ViewValue = $this->label->lookupCacheOption($curVal);
                if ($this->label->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->label->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->label->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->label->getSelectFilter($this); // PHP
                    $sqlWrk = $this->label->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->label->Lookup->renderViewRow($rswrk[0]);
                        $this->label->ViewValue = $this->label->displayValue($arwrk);
                    } else {
                        $this->label->ViewValue = $this->label->CurrentValue;
                    }
                }
            } else {
                $this->label->ViewValue = null;
            }

            // ssd
            $this->ssd->ViewValue = $this->ssd->CurrentValue;
            $this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, $this->ssd->formatPattern());

            // shipping_mode
            if (strval($this->shipping_mode->CurrentValue) != "") {
                $this->shipping_mode->ViewValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
            } else {
                $this->shipping_mode->ViewValue = null;
            }

            // delivery_week
            $curVal = strval($this->delivery_week->CurrentValue);
            if ($curVal != "") {
                $this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
                if ($this->delivery_week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                    $sqlWrk = $this->delivery_week->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->delivery_week->Lookup->renderViewRow($rswrk[0]);
                        $this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
                    } else {
                        $this->delivery_week->ViewValue = FormatNumber($this->delivery_week->CurrentValue, $this->delivery_week->formatPattern());
                    }
                }
            } else {
                $this->delivery_week->ViewValue = null;
            }

            // shipping_address
            $curVal = strval($this->shipping_address->CurrentValue);
            if ($curVal != "") {
                $this->shipping_address->ViewValue = $this->shipping_address->lookupCacheOption($curVal);
                if ($this->shipping_address->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shipping_address->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shipping_address->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->shipping_address->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shipping_address->Lookup->renderViewRow($rswrk[0]);
                        $this->shipping_address->ViewValue = $this->shipping_address->displayValue($arwrk);
                    } else {
                        $this->shipping_address->ViewValue = FormatNumber($this->shipping_address->CurrentValue, $this->shipping_address->formatPattern());
                    }
                }
            } else {
                $this->shipping_address->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // buyer_id
            $this->buyer_id->HrefValue = "";
            $this->buyer_id->TooltipValue = "";

            // sample_cart_id
            $this->sample_cart_id->HrefValue = "";

            // purpose
            $this->purpose->HrefValue = "";

            // label
            $this->label->HrefValue = "";

            // ssd
            $this->ssd->HrefValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";

            // delivery_week
            $this->delivery_week->HrefValue = "";

            // shipping_address
            $this->shipping_address->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = trim(strval($this->buyer_id->CurrentValue));
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->CurrentValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->buyer_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // sample_cart_id
            $curVal = trim(strval($this->sample_cart_id->CurrentValue));
            if ($curVal != "") {
                $this->sample_cart_id->ViewValue = $this->sample_cart_id->lookupCacheOption($curVal);
            } else {
                $this->sample_cart_id->ViewValue = $this->sample_cart_id->Lookup !== null && is_array($this->sample_cart_id->lookupOptions()) && count($this->sample_cart_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->sample_cart_id->ViewValue !== null) { // Load from cache
                $this->sample_cart_id->EditValue = array_values($this->sample_cart_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->sample_cart_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->sample_cart_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->sample_cart_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->sample_cart_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->sample_cart_id->Lookup->renderViewRow($row);
                }
                $this->sample_cart_id->EditValue = $arwrk;
            }
            $this->sample_cart_id->PlaceHolder = RemoveHtml($this->sample_cart_id->caption());

            // purpose
            $this->purpose->setupEditAttributes();
            $curVal = trim(strval($this->purpose->CurrentValue));
            if ($curVal != "") {
                $this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
            } else {
                $this->purpose->ViewValue = $this->purpose->Lookup !== null && is_array($this->purpose->lookupOptions()) && count($this->purpose->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->purpose->ViewValue !== null) { // Load from cache
                $this->purpose->EditValue = array_values($this->purpose->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->purpose->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->purpose->CurrentValue, $this->purpose->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->purpose->getSelectFilter($this); // PHP
                $sqlWrk = $this->purpose->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->purpose->EditValue = $arwrk;
            }
            $this->purpose->PlaceHolder = RemoveHtml($this->purpose->caption());

            // label
            $this->label->setupEditAttributes();
            $curVal = trim(strval($this->label->CurrentValue));
            if ($curVal != "") {
                $this->label->ViewValue = $this->label->lookupCacheOption($curVal);
            } else {
                $this->label->ViewValue = $this->label->Lookup !== null && is_array($this->label->lookupOptions()) && count($this->label->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->label->ViewValue !== null) { // Load from cache
                $this->label->EditValue = array_values($this->label->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->label->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->label->CurrentValue, $this->label->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->label->getSelectFilter($this); // PHP
                $sqlWrk = $this->label->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->label->EditValue = $arwrk;
            }
            $this->label->PlaceHolder = RemoveHtml($this->label->caption());

            // ssd
            $this->ssd->setupEditAttributes();
            $this->ssd->EditValue = HtmlEncode(FormatDateTime($this->ssd->CurrentValue, $this->ssd->formatPattern()));
            $this->ssd->PlaceHolder = RemoveHtml($this->ssd->caption());

            // shipping_mode
            $this->shipping_mode->setupEditAttributes();
            $this->shipping_mode->EditValue = $this->shipping_mode->options(true);
            $this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

            // delivery_week
            $this->delivery_week->setupEditAttributes();
            $curVal = trim(strval($this->delivery_week->CurrentValue));
            if ($curVal != "") {
                $this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
            } else {
                $this->delivery_week->ViewValue = $this->delivery_week->Lookup !== null && is_array($this->delivery_week->lookupOptions()) && count($this->delivery_week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->delivery_week->ViewValue !== null) { // Load from cache
                $this->delivery_week->EditValue = array_values($this->delivery_week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->delivery_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->delivery_week->CurrentValue, $this->delivery_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->delivery_week->getSelectFilter($this); // PHP
                $sqlWrk = $this->delivery_week->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->delivery_week->EditValue = $arwrk;
            }
            $this->delivery_week->PlaceHolder = RemoveHtml($this->delivery_week->caption());

            // shipping_address
            $this->shipping_address->setupEditAttributes();
            $curVal = trim(strval($this->shipping_address->CurrentValue));
            if ($curVal != "") {
                $this->shipping_address->ViewValue = $this->shipping_address->lookupCacheOption($curVal);
            } else {
                $this->shipping_address->ViewValue = $this->shipping_address->Lookup !== null && is_array($this->shipping_address->lookupOptions()) && count($this->shipping_address->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shipping_address->ViewValue !== null) { // Load from cache
                $this->shipping_address->EditValue = array_values($this->shipping_address->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shipping_address->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shipping_address->CurrentValue, $this->shipping_address->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->shipping_address->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shipping_address->EditValue = $arwrk;
            }
            $this->shipping_address->PlaceHolder = RemoveHtml($this->shipping_address->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator

            // datetime

            // Add refer script

            // buyer_id
            $this->buyer_id->HrefValue = "";

            // sample_cart_id
            $this->sample_cart_id->HrefValue = "";

            // purpose
            $this->purpose->HrefValue = "";

            // label
            $this->label->HrefValue = "";

            // ssd
            $this->ssd->HrefValue = "";

            // shipping_mode
            $this->shipping_mode->HrefValue = "";

            // delivery_week
            $this->delivery_week->HrefValue = "";

            // shipping_address
            $this->shipping_address->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->buyer_id->Visible && $this->buyer_id->Required) {
                if (!$this->buyer_id->IsDetailKey && EmptyValue($this->buyer_id->FormValue)) {
                    $this->buyer_id->addErrorMessage(str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
                }
            }
            if ($this->sample_cart_id->Visible && $this->sample_cart_id->Required) {
                if ($this->sample_cart_id->FormValue == "") {
                    $this->sample_cart_id->addErrorMessage(str_replace("%s", $this->sample_cart_id->caption(), $this->sample_cart_id->RequiredErrorMessage));
                }
            }
            if ($this->purpose->Visible && $this->purpose->Required) {
                if (!$this->purpose->IsDetailKey && EmptyValue($this->purpose->FormValue)) {
                    $this->purpose->addErrorMessage(str_replace("%s", $this->purpose->caption(), $this->purpose->RequiredErrorMessage));
                }
            }
            if ($this->label->Visible && $this->label->Required) {
                if (!$this->label->IsDetailKey && EmptyValue($this->label->FormValue)) {
                    $this->label->addErrorMessage(str_replace("%s", $this->label->caption(), $this->label->RequiredErrorMessage));
                }
            }
            if ($this->ssd->Visible && $this->ssd->Required) {
                if (!$this->ssd->IsDetailKey && EmptyValue($this->ssd->FormValue)) {
                    $this->ssd->addErrorMessage(str_replace("%s", $this->ssd->caption(), $this->ssd->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->ssd->FormValue, $this->ssd->formatPattern())) {
                $this->ssd->addErrorMessage($this->ssd->getErrorMessage(false));
            }
            if ($this->shipping_mode->Visible && $this->shipping_mode->Required) {
                if (!$this->shipping_mode->IsDetailKey && EmptyValue($this->shipping_mode->FormValue)) {
                    $this->shipping_mode->addErrorMessage(str_replace("%s", $this->shipping_mode->caption(), $this->shipping_mode->RequiredErrorMessage));
                }
            }
            if ($this->delivery_week->Visible && $this->delivery_week->Required) {
                if (!$this->delivery_week->IsDetailKey && EmptyValue($this->delivery_week->FormValue)) {
                    $this->delivery_week->addErrorMessage(str_replace("%s", $this->delivery_week->caption(), $this->delivery_week->RequiredErrorMessage));
                }
            }
            if ($this->shipping_address->Visible && $this->shipping_address->Required) {
                if (!$this->shipping_address->IsDetailKey && EmptyValue($this->shipping_address->FormValue)) {
                    $this->shipping_address->addErrorMessage(str_replace("%s", $this->shipping_address->caption(), $this->shipping_address->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // buyer_id
        $this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, false);

        // sample_cart_id
        $this->sample_cart_id->setDbValueDef($rsnew, $this->sample_cart_id->CurrentValue, false);

        // purpose
        $this->purpose->setDbValueDef($rsnew, $this->purpose->CurrentValue, false);

        // label
        $this->label->setDbValueDef($rsnew, $this->label->CurrentValue, false);

        // ssd
        $this->ssd->setDbValueDef($rsnew, UnFormatDateTime($this->ssd->CurrentValue, $this->ssd->formatPattern()), false);

        // shipping_mode
        $this->shipping_mode->setDbValueDef($rsnew, $this->shipping_mode->CurrentValue, false);

        // delivery_week
        $this->delivery_week->setDbValueDef($rsnew, $this->delivery_week->CurrentValue, false);

        // shipping_address
        $this->shipping_address->setDbValueDef($rsnew, $this->shipping_address->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['buyer_id'])) { // buyer_id
            $this->buyer_id->setFormValue($row['buyer_id']);
        }
        if (isset($row['sample_cart_id'])) { // sample_cart_id
            $this->sample_cart_id->setFormValue($row['sample_cart_id']);
        }
        if (isset($row['purpose'])) { // purpose
            $this->purpose->setFormValue($row['purpose']);
        }
        if (isset($row['label'])) { // label
            $this->label->setFormValue($row['label']);
        }
        if (isset($row['ssd'])) { // ssd
            $this->ssd->setFormValue($row['ssd']);
        }
        if (isset($row['shipping_mode'])) { // shipping_mode
            $this->shipping_mode->setFormValue($row['shipping_mode']);
        }
        if (isset($row['delivery_week'])) { // delivery_week
            $this->delivery_week->setFormValue($row['delivery_week']);
        }
        if (isset($row['shipping_address'])) { // shipping_address
            $this->shipping_address->setFormValue($row['shipping_address']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("samplereqlist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyer_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_sample_cart_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_purpose":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_label":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_mode":
                    break;
                case "x_delivery_week":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_address":
                    break;
                case "x_operator":
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	IF (CurrentUserLevel() <= 0)
    	{
    	$this->buyer_id->ReadOnly = True;
    	}
    	else
    	{
    	$this->buyer_id->ReadOnly = False;
    	}
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
