<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SPersonalInfoSearch extends SPersonalInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SPersonalInfoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "spersonalinfosearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->image->setVisibility();
        $this->name->setVisibility();
        $this->sr_no->setVisibility();
        $this->faculty->Visible = false;
        $this->father_name->setVisibility();
        $this->mother_name->setVisibility();
        $this->address->setVisibility();
        $this->dob->setVisibility();
        $this->mobile->setVisibility();
        $this->m_type->setVisibility();
        $this->idcard_status->setVisibility();
        $this->status->setVisibility();
        $this->gender->setVisibility();
        $this->category->setVisibility();
        $this->mobile_other->setVisibility();
        $this->doj->setVisibility();
        $this->remarks->setVisibility();
        $this->epc->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->sr_uid->Visible = false;
        $this->updates->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 's_personal_info';
        $this->TableName = 's_personal_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_personal_info)
        if (!isset($GLOBALS["s_personal_info"]) || $GLOBALS["s_personal_info"]::class == PROJECT_NAMESPACE . "s_personal_info") {
            $GLOBALS["s_personal_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_personal_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "spersonalinfoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->faculty);
        $this->setupLookupOptions($this->m_type);
        $this->setupLookupOptions($this->idcard_status);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->mobile_other);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "spersonalinfolist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->image); // image
        $this->buildSearchUrl($srchUrl, $this->name); // name
        $this->buildSearchUrl($srchUrl, $this->sr_no); // sr_no
        $this->buildSearchUrl($srchUrl, $this->father_name); // father_name
        $this->buildSearchUrl($srchUrl, $this->mother_name); // mother_name
        $this->buildSearchUrl($srchUrl, $this->address); // address
        $this->buildSearchUrl($srchUrl, $this->dob); // dob
        $this->buildSearchUrl($srchUrl, $this->mobile); // mobile
        $this->buildSearchUrl($srchUrl, $this->m_type); // m_type
        $this->buildSearchUrl($srchUrl, $this->idcard_status); // idcard_status
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->gender); // gender
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->mobile_other); // mobile_other
        $this->buildSearchUrl($srchUrl, $this->doj); // doj
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->updates); // updates
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // image
        if ($this->image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // name
        if ($this->name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sr_no
        if ($this->sr_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // faculty
        if ($this->faculty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // father_name
        if ($this->father_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mother_name
        if ($this->mother_name->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // address
        if ($this->address->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dob
        if ($this->dob->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile
        if ($this->mobile->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_type
        if ($this->m_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // idcard_status
        if ($this->idcard_status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gender
        if ($this->gender->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // mobile_other
        if ($this->mobile_other->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // doj
        if ($this->doj->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // updates
        if ($this->updates->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // name
        $this->name->RowCssClass = "row";

        // sr_no
        $this->sr_no->RowCssClass = "row";

        // faculty
        $this->faculty->RowCssClass = "row";

        // father_name
        $this->father_name->RowCssClass = "row";

        // mother_name
        $this->mother_name->RowCssClass = "row";

        // address
        $this->address->RowCssClass = "row";

        // dob
        $this->dob->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // m_type
        $this->m_type->RowCssClass = "row";

        // idcard_status
        $this->idcard_status->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // gender
        $this->gender->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // mobile_other
        $this->mobile_other->RowCssClass = "row";

        // doj
        $this->doj->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // epc
        $this->epc->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // sr_uid
        $this->sr_uid->RowCssClass = "row";

        // updates
        $this->updates->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 40;
                $this->image->ImageHeight = 40;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // sr_no
            $this->sr_no->ViewValue = $this->sr_no->CurrentValue;

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // mother_name
            $this->mother_name->ViewValue = $this->mother_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // m_type
            $curVal = strval($this->m_type->CurrentValue);
            if ($curVal != "") {
                $this->m_type->ViewValue = $this->m_type->lookupCacheOption($curVal);
                if ($this->m_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_type->Lookup->renderViewRow($rswrk[0]);
                        $this->m_type->ViewValue = $this->m_type->displayValue($arwrk);
                    } else {
                        $this->m_type->ViewValue = FormatNumber($this->m_type->CurrentValue, $this->m_type->formatPattern());
                    }
                }
            } else {
                $this->m_type->ViewValue = null;
            }

            // idcard_status
            if (strval($this->idcard_status->CurrentValue) != "") {
                $this->idcard_status->ViewValue = $this->idcard_status->optionCaption($this->idcard_status->CurrentValue);
            } else {
                $this->idcard_status->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // doj
            $this->doj->ViewValue = $this->doj->CurrentValue;
            $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // updates
            $this->updates->ViewValue = $this->updates->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";

            // sr_no
            $this->sr_no->HrefValue = "";
            $this->sr_no->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";
            $this->mother_name->TooltipValue = "";

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";

            // m_type
            $this->m_type->HrefValue = "";
            $this->m_type->TooltipValue = "";

            // idcard_status
            $this->idcard_status->HrefValue = "";
            $this->idcard_status->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";
            $this->mobile_other->TooltipValue = "";

            // doj
            $this->doj->HrefValue = "";
            $this->doj->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // updates
            $this->updates->HrefValue = "";
            $this->updates->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // image
            $this->image->setupEditAttributes();
            if (!$this->image->Raw) {
                $this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
            }
            $this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
            $this->image->PlaceHolder = RemoveHtml($this->image->caption());

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->AdvancedSearch->SearchValue = HtmlDecode($this->name->AdvancedSearch->SearchValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->AdvancedSearch->SearchValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // sr_no
            $this->sr_no->setupEditAttributes();
            if (!$this->sr_no->Raw) {
                $this->sr_no->AdvancedSearch->SearchValue = HtmlDecode($this->sr_no->AdvancedSearch->SearchValue);
            }
            $this->sr_no->EditValue = HtmlEncode($this->sr_no->AdvancedSearch->SearchValue);
            $this->sr_no->PlaceHolder = RemoveHtml($this->sr_no->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->AdvancedSearch->SearchValue = HtmlDecode($this->father_name->AdvancedSearch->SearchValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->AdvancedSearch->SearchValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // mother_name
            $this->mother_name->setupEditAttributes();
            if (!$this->mother_name->Raw) {
                $this->mother_name->AdvancedSearch->SearchValue = HtmlDecode($this->mother_name->AdvancedSearch->SearchValue);
            }
            $this->mother_name->EditValue = HtmlEncode($this->mother_name->AdvancedSearch->SearchValue);
            $this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->AdvancedSearch->SearchValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->dob->AdvancedSearch->SearchValue, $this->dob->formatPattern()), $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->AdvancedSearch->SearchValue = HtmlDecode($this->mobile->AdvancedSearch->SearchValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->AdvancedSearch->SearchValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // m_type
            $this->m_type->setupEditAttributes();
            $curVal = trim(strval($this->m_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->m_type->AdvancedSearch->ViewValue = $this->m_type->lookupCacheOption($curVal);
            } else {
                $this->m_type->AdvancedSearch->ViewValue = $this->m_type->Lookup !== null && is_array($this->m_type->lookupOptions()) && count($this->m_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->m_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->m_type->EditValue = array_values($this->m_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->m_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->m_type->AdvancedSearch->SearchValue, $this->m_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->m_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->m_type->EditValue = $arwrk;
            }
            $this->m_type->PlaceHolder = RemoveHtml($this->m_type->caption());

            // idcard_status
            $this->idcard_status->setupEditAttributes();
            $this->idcard_status->EditValue = $this->idcard_status->options(true);
            $this->idcard_status->PlaceHolder = RemoveHtml($this->idcard_status->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->EditValue = $this->category->options(true);
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->AdvancedSearch->SearchValue = HtmlDecode($this->mobile_other->AdvancedSearch->SearchValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->AdvancedSearch->SearchValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // doj
            $this->doj->setupEditAttributes();
            $this->doj->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->doj->AdvancedSearch->SearchValue, $this->doj->formatPattern()), $this->doj->formatPattern()));
            $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->AdvancedSearch->SearchValue = HtmlDecode($this->remarks->AdvancedSearch->SearchValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->AdvancedSearch->SearchValue;
            $curVal = strval($this->operator->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->EditValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->EditValue = HtmlEncode(FormatNumber($this->operator->AdvancedSearch->SearchValue, $this->operator->formatPattern()));
                    }
                }
            } else {
                $this->operator->EditValue = null;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // updates
            $this->updates->setupEditAttributes();
            if (!$this->updates->Raw) {
                $this->updates->AdvancedSearch->SearchValue = HtmlDecode($this->updates->AdvancedSearch->SearchValue);
            }
            $this->updates->EditValue = HtmlEncode($this->updates->AdvancedSearch->SearchValue);
            $this->updates->PlaceHolder = RemoveHtml($this->updates->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->dob->AdvancedSearch->SearchValue, $this->dob->formatPattern())) {
            $this->dob->addErrorMessage($this->dob->getErrorMessage(false));
        }
        if (!CheckDate($this->doj->AdvancedSearch->SearchValue, $this->doj->formatPattern())) {
            $this->doj->addErrorMessage($this->doj->getErrorMessage(false));
        }
        if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
            $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->image->AdvancedSearch->load();
        $this->name->AdvancedSearch->load();
        $this->sr_no->AdvancedSearch->load();
        $this->father_name->AdvancedSearch->load();
        $this->mother_name->AdvancedSearch->load();
        $this->address->AdvancedSearch->load();
        $this->dob->AdvancedSearch->load();
        $this->mobile->AdvancedSearch->load();
        $this->m_type->AdvancedSearch->load();
        $this->idcard_status->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->gender->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->mobile_other->AdvancedSearch->load();
        $this->doj->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->updates->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("spersonalinfolist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_faculty":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_idcard_status":
                    break;
                case "x_status":
                    break;
                case "x_gender":
                    break;
                case "x_category":
                    break;
                case "x_mobile_other":
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
