<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SPersonalInfoGrid extends SPersonalInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "grid";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SPersonalInfoGrid";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fs_personal_infogrid";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "spersonalinfogrid";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->image->setVisibility();
        $this->name->setVisibility();
        $this->sr_no->setVisibility();
        $this->faculty->setVisibility();
        $this->father_name->setVisibility();
        $this->mother_name->setVisibility();
        $this->address->setVisibility();
        $this->dob->setVisibility();
        $this->mobile->setVisibility();
        $this->m_type->setVisibility();
        $this->idcard_status->setVisibility();
        $this->status->setVisibility();
        $this->gender->setVisibility();
        $this->category->setVisibility();
        $this->mobile_other->setVisibility();
        $this->doj->setVisibility();
        $this->remarks->setVisibility();
        $this->epc->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->sr_uid->setVisibility();
        $this->updates->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 's_personal_info';
        $this->TableName = 's_personal_info';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $this->FormActionName .= "_" . $this->FormName;
        $this->OldKeyName .= "_" . $this->FormName;
        $this->FormBlankRowName .= "_" . $this->FormName;
        $this->FormKeyCountName .= "_" . $this->FormName;
        $GLOBALS["Grid"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_personal_info)
        if (!isset($GLOBALS["s_personal_info"]) || $GLOBALS["s_personal_info"]::class == PROJECT_NAMESPACE . "s_personal_info") {
            $GLOBALS["s_personal_info"] = &$this;
        }
        $this->AddUrl = "spersonalinfoadd";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_personal_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;
        unset($GLOBALS["Grid"]);
        if ($url === "") {
            return;
        }
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $ShowOtherOptions = false;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        if (Param("export") !== null) {
            $this->Export = Param("export");
        }

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up master detail parameters
        $this->setupMasterParms();

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->faculty);
        $this->setupLookupOptions($this->m_type);
        $this->setupLookupOptions($this->idcard_status);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->gender);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->mobile_other);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fs_personal_infogrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Show grid delete link for grid add / grid edit
        if ($this->AllowAddDeleteRow) {
            if ($this->isGridAdd() || $this->isGridEdit()) {
                $item = $this->ListOptions["griddelete"];
                if ($item) {
                    $item->Visible = $Security->allowDelete(CurrentProjectID() . $this->TableName);
                }
            }
        }

        // Set up sorting order
        $this->setupSortOrder();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }

        // Restore master/detail filter from session
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Restore master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Restore detail filter from session
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Load master record
        if ($this->CurrentMode != "add" && $this->DbMasterFilter != "" && $this->getCurrentMasterTable() == "s_student_list") {
            $masterTbl = Container("s_student_list");
            $rsmaster = $masterTbl->loadRs($this->DbMasterFilter)->fetchAssociative();
            $this->MasterRecordExists = $rsmaster !== false;
            if (!$this->MasterRecordExists) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
                $this->terminate("sstudentlistlist"); // Return to master page
                return;
            } else {
                $masterTbl->loadListRowValues($rsmaster);
                $masterTbl->RowType = RowType::MASTER; // Master row
                $masterTbl->renderListRow();
            }
        }

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->TotalRecords = $this->listRecordCount();
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->TotalRecords;
                $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
            } else {
                $this->CurrentFilter = "0=1";
                $this->StartRecord = 1;
                $this->DisplayRecords = $this->GridAddRowCount;
            }
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->TotalRecords; // Display all records
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Exit inline mode
    protected function clearInlineMode()
    {
        $this->LastAction = $this->CurrentAction; // Save last action
        $this->CurrentAction = ""; // Clear action
        $_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
    }

    // Switch to grid add mode
    protected function gridAddMode()
    {
        $this->CurrentAction = "gridadd";
        $_SESSION[SESSION_INLINE_MODE] = "gridadd";
        $this->hideFieldsForAddEdit();
    }

    // Switch to grid edit mode
    protected function gridEditMode()
    {
        $this->CurrentAction = "gridedit";
        $_SESSION[SESSION_INLINE_MODE] = "gridedit";
        $this->hideFieldsForAddEdit();
    }

    // Perform update to grid
    public function gridUpdate()
    {
        global $Language, $CurrentForm;
        $gridUpdate = true;

        // Get old result set
        $this->CurrentFilter = $this->buildKeyFilter();
        if ($this->CurrentFilter == "") {
            $this->CurrentFilter = "0=1";
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        if ($rs = $conn->executeQuery($sql)) {
            $rsold = $rs->fetchAllAssociative();
        }

        // Call Grid Updating event
        if (!$this->gridUpdating($rsold)) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();
        if ($this->AuditTrailOnEdit) {
            $this->writeAuditTrailDummy($Language->phrase("BatchUpdateBegin")); // Batch update begin
        }
        $wrkfilter = "";
        $key = "";

        // Update row index and get row key
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Update all rows based on key
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            $CurrentForm->Index = $rowindex;
            $this->setKey($CurrentForm->getValue($this->OldKeyName));
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));

            // Load all values and keys
            if ($rowaction != "insertdelete" && $rowaction != "hide") { // Skip insert then deleted rows / hidden rows for grid edit
                $this->loadFormValues(); // Get form values
                if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
                    $gridUpdate = $this->OldKey != ""; // Key must not be empty
                } else {
                    $gridUpdate = true;
                }

                // Skip empty row
                if ($rowaction == "insert" && $this->emptyRow()) {
                // Validate form and insert/update/delete record
                } elseif ($gridUpdate) {
                    if ($rowaction == "delete") {
                        $this->CurrentFilter = $this->getRecordFilter();
                        $gridUpdate = $this->deleteRows(); // Delete this row
                    } else {
                        if ($rowaction == "insert") {
                            $gridUpdate = $this->addRow(); // Insert this row
                        } else {
                            if ($this->OldKey != "") {
                                $this->SendEmail = false; // Do not send email on update success
                                $gridUpdate = $this->editRow(); // Update this row
                            }
                        } // End update
                        if ($gridUpdate) { // Get inserted or updated filter
                            AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                        }
                    }
                }
                if ($gridUpdate) {
                    if ($key != "") {
                        $key .= ", ";
                    }
                    $key .= $this->OldKey;
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($gridUpdate) {
            $this->FilterForModalActions = $wrkfilter;

            // Get new records
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Updated event
            $this->gridUpdated($rsold, $rsnew);
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateSuccess")); // Batch update success
            }
            $this->clearInlineMode(); // Clear inline edit mode
        } else {
            if ($this->AuditTrailOnEdit) {
                $this->writeAuditTrailDummy($Language->phrase("BatchUpdateRollback")); // Batch update rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
            }
        }
        return $gridUpdate;
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Perform grid add
    public function gridInsert()
    {
        global $Language, $CurrentForm;
        $rowindex = 1;
        $gridInsert = false;
        $conn = $this->getConnection();

        // Call Grid Inserting event
        if (!$this->gridInserting()) {
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
            }
            $this->EventCancelled = true;
            return false;
        }
        $this->loadDefaultValues();

        // Init key filter
        $wrkfilter = "";
        $addcnt = 0;
        if ($this->AuditTrailOnAdd) {
            $this->writeAuditTrailDummy($Language->phrase("BatchInsertBegin")); // Batch insert begin
        }
        $key = "";

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Insert all rows
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "" && $rowaction != "insert") {
                continue; // Skip
            }
            $rsold = null;
            if ($rowaction == "insert") {
                $this->OldKey = strval($CurrentForm->getValue($this->OldKeyName));
                $rsold = $this->loadOldRecord(); // Load old record
            }
            $this->loadFormValues(); // Get form values
            if (!$this->emptyRow()) {
                $addcnt++;
                $this->SendEmail = false; // Do not send email on insert success
                $gridInsert = $this->addRow($rsold); // Insert row (already validated by validateGridForm())
                if ($gridInsert) {
                    if ($key != "") {
                        $key .= Config("COMPOSITE_KEY_SEPARATOR");
                    }
                    $key .= $this->id->CurrentValue;

                    // Add filter for this record
                    AddFilter($wrkfilter, $this->getRecordFilter(), "OR");
                } else {
                    $this->EventCancelled = true;
                    break;
                }
            }
        }
        if ($addcnt == 0) { // No record inserted
            $this->clearInlineMode(); // Clear grid add mode and return
            return true;
        }
        if ($gridInsert) {
            // Get new records
            $this->CurrentFilter = $wrkfilter;
            $this->FilterForModalActions = $wrkfilter;
            $sql = $this->getCurrentSql();
            $rsnew = $conn->fetchAllAssociative($sql);

            // Call Grid_Inserted event
            $this->gridInserted($rsnew);
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertSuccess")); // Batch insert success
            }
            $this->clearInlineMode(); // Clear grid add mode
        } else {
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailDummy($Language->phrase("BatchInsertRollback")); // Batch insert rollback
            }
            if ($this->getFailureMessage() == "") {
                $this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
            }
        }
        return $gridInsert;
    }

    // Check if empty row
    public function emptyRow()
    {
        global $CurrentForm;
        if (!EmptyValue($this->image->Upload->Value)) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_name") &&
            $CurrentForm->hasValue("o_name") &&
            $this->name->CurrentValue != $this->name->DefaultValue &&
            !($this->name->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->name->CurrentValue == $this->name->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_sr_no") &&
            $CurrentForm->hasValue("o_sr_no") &&
            $this->sr_no->CurrentValue != $this->sr_no->DefaultValue &&
            !($this->sr_no->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->sr_no->CurrentValue == $this->sr_no->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_faculty") &&
            $CurrentForm->hasValue("o_faculty") &&
            $this->faculty->CurrentValue != $this->faculty->DefaultValue &&
            !($this->faculty->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->faculty->CurrentValue == $this->faculty->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_father_name") &&
            $CurrentForm->hasValue("o_father_name") &&
            $this->father_name->CurrentValue != $this->father_name->DefaultValue &&
            !($this->father_name->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->father_name->CurrentValue == $this->father_name->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_mother_name") &&
            $CurrentForm->hasValue("o_mother_name") &&
            $this->mother_name->CurrentValue != $this->mother_name->DefaultValue &&
            !($this->mother_name->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->mother_name->CurrentValue == $this->mother_name->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_address") &&
            $CurrentForm->hasValue("o_address") &&
            $this->address->CurrentValue != $this->address->DefaultValue &&
            !($this->address->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->address->CurrentValue == $this->address->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_dob") &&
            $CurrentForm->hasValue("o_dob") &&
            $this->dob->CurrentValue != $this->dob->DefaultValue &&
            !($this->dob->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->dob->CurrentValue == $this->dob->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_mobile") &&
            $CurrentForm->hasValue("o_mobile") &&
            $this->mobile->CurrentValue != $this->mobile->DefaultValue &&
            !($this->mobile->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->mobile->CurrentValue == $this->mobile->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_m_type") &&
            $CurrentForm->hasValue("o_m_type") &&
            $this->m_type->CurrentValue != $this->m_type->DefaultValue &&
            !($this->m_type->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->m_type->CurrentValue == $this->m_type->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_idcard_status") &&
            $CurrentForm->hasValue("o_idcard_status") &&
            $this->idcard_status->CurrentValue != $this->idcard_status->DefaultValue &&
            !($this->idcard_status->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->idcard_status->CurrentValue == $this->idcard_status->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_status") &&
            $CurrentForm->hasValue("o_status") &&
            $this->status->CurrentValue != $this->status->DefaultValue &&
            !($this->status->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->status->CurrentValue == $this->status->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_gender") &&
            $CurrentForm->hasValue("o_gender") &&
            $this->gender->CurrentValue != $this->gender->DefaultValue &&
            !($this->gender->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->gender->CurrentValue == $this->gender->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_category") &&
            $CurrentForm->hasValue("o_category") &&
            $this->category->CurrentValue != $this->category->DefaultValue &&
            !($this->category->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->category->CurrentValue == $this->category->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_mobile_other") &&
            $CurrentForm->hasValue("o_mobile_other") &&
            $this->mobile_other->CurrentValue != $this->mobile_other->DefaultValue &&
            !($this->mobile_other->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->mobile_other->CurrentValue == $this->mobile_other->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_doj") &&
            $CurrentForm->hasValue("o_doj") &&
            $this->doj->CurrentValue != $this->doj->DefaultValue &&
            !($this->doj->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->doj->CurrentValue == $this->doj->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_remarks") &&
            $CurrentForm->hasValue("o_remarks") &&
            $this->remarks->CurrentValue != $this->remarks->DefaultValue &&
            !($this->remarks->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->remarks->CurrentValue == $this->remarks->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_sr_uid") &&
            $CurrentForm->hasValue("o_sr_uid") &&
            $this->sr_uid->CurrentValue != $this->sr_uid->DefaultValue &&
            !($this->sr_uid->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->sr_uid->CurrentValue == $this->sr_uid->getSessionValue())
        ) {
            return false;
        }
        if (
            $CurrentForm->hasValue("x_updates") &&
            $CurrentForm->hasValue("o_updates") &&
            $this->updates->CurrentValue != $this->updates->DefaultValue &&
            !($this->updates->IsForeignKey && $this->getCurrentMasterTable() != "" && $this->updates->CurrentValue == $this->updates->getSessionValue())
        ) {
            return false;
        }
        return true;
    }

    // Validate grid form
    public function validateGridForm()
    {
        global $CurrentForm;

        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }

        // Load default values for emptyRow checking
        $this->loadDefaultValues();

        // Validate all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete" && $rowaction != "hide") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } elseif (!$this->validateForm()) {
                    $this->ValidationErrors[$rowindex] = $this->getValidationErrors();
                    $this->EventCancelled = true;
                    return false;
                }
            }
        }
        return true;
    }

    // Get all form values of the grid
    public function getGridFormValues()
    {
        global $CurrentForm;
        // Get row count
        $CurrentForm->resetIndex();
        $rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
        if ($rowcnt == "" || !is_numeric($rowcnt)) {
            $rowcnt = 0;
        }
        $rows = [];

        // Loop through all records
        for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
            // Load current row values
            $CurrentForm->Index = $rowindex;
            $rowaction = strval($CurrentForm->getValue($this->FormActionName));
            if ($rowaction != "delete" && $rowaction != "insertdelete") {
                $this->loadFormValues(); // Get form values
                if ($rowaction == "insert" && $this->emptyRow()) {
                    // Ignore
                } else {
                    $rows[] = $this->getFieldValues("FormValue"); // Return row as array
                }
            }
        }
        return $rows; // Return as array of array
    }

    // Restore form values for current row
    public function restoreCurrentRowFormValues($idx)
    {
        global $CurrentForm;

        // Get row based on current index
        $CurrentForm->Index = $idx;
        $rowaction = strval($CurrentForm->getValue($this->FormActionName));
        $this->loadFormValues(); // Load form values
        // Set up invalid status correctly
        $this->resetFormError();
        if ($rowaction == "insert" && $this->emptyRow()) {
            // Ignore
        } else {
            $this->validateForm();
        }
    }

    // Reset form status
    public function resetFormError()
    {
        foreach ($this->Fields as $field) {
            $field->clearErrorMessage();
        }
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset master/detail keys
            if ($this->Command == "resetall") {
                $this->setCurrentMasterTable(""); // Clear master table
                $this->DbMasterFilter = "";
                $this->DbDetailFilter = "";
                        $this->id->setSessionValue("");
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // "griddelete"
        if ($this->AllowAddDeleteRow) {
            $item = &$this->ListOptions->add("griddelete");
            $item->CssClass = "text-nowrap";
            $item->OnLeft = true;
            $item->Visible = false; // Default hidden
        }

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // Set up row action and key
        if ($CurrentForm && is_numeric($this->RowIndex) && $this->RowType != "view") {
            $CurrentForm->Index = $this->RowIndex;
            $actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
            $oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->OldKeyName);
            $blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
            if ($this->RowAction != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
            }
            $oldKey = $this->getKey(false); // Get from OldValue
            if ($oldKeyName != "" && $oldKey != "") {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($oldKey) . "\">";
            }
            if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow()) {
                $this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
            }
        }

        // "delete"
        if ($this->AllowAddDeleteRow) {
            if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
                $options = &$this->ListOptions;
                $options->UseButtonGroup = true; // Use button group for grid delete button
                $opt = $options["griddelete"];
                if (!$Security->allowDelete(CurrentProjectID() . $this->TableName) && is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
                    $opt->Body = "&nbsp;";
                } else {
                    $opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-ew-action=\"delete-grid-row\" data-rowindex=\"" . $this->RowIndex . "\">" . $Language->phrase("DeleteLink") . "</a>";
                }
            }
        }
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"s_personal_info\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"s_personal_info\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"s_personal_info\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $option = $this->OtherOptions["addedit"];
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Add
        if ($this->CurrentMode == "view") { // Check view mode
            $item = &$option->add("add");
            $addcaption = HtmlTitle($Language->phrase("AddLink"));
            $this->AddUrl = $this->getAddUrl();
            if ($this->ModalAdd && !IsMobile()) {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"s_personal_info\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
            } else {
                $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
            }
            $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        }
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
            if (in_array($this->CurrentMode, ["add", "copy", "edit"]) && !$this->isConfirm()) { // Check add/copy/edit mode
                if ($this->AllowAddDeleteRow) {
                    $option = $options["addedit"];
                    $option->UseDropDownButton = false;
                    $item = &$option->add("addblankrow");
                    $item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-ew-action=\"add-grid-row\">" . $Language->phrase("AddBlankRow") . "</a>";
                    $item->Visible = $Security->canAdd();
                    $this->ShowOtherOptions = $item->Visible;
                }
            }
            if ($this->CurrentMode == "view") { // Check view mode
                $option = $options["addedit"];
                $item = $option["add"];
                $this->ShowOtherOptions = $item?->Visible ?? false;
            }
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        $this->StartRecord = 1;
        $this->StopRecord = $this->TotalRecords; // Show all records

        // Restore number of post back records
        if ($CurrentForm && ($this->isConfirm() || $this->EventCancelled)) {
            $CurrentForm->resetIndex();
            if ($CurrentForm->hasValue($this->FormKeyCountName) && ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm())) {
                $this->KeyCount = $CurrentForm->getValue($this->FormKeyCountName);
                $this->StopRecord = $this->StartRecord + $this->KeyCount - 1;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_s_personal_info", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }
        if ($this->isGridAdd() || $this->isGridEdit() || $this->isConfirm() || $this->isMultiEdit()) {
            $this->RowIndex++;
            $CurrentForm->Index = $this->RowIndex;
            if ($CurrentForm->hasValue($this->FormActionName) && ($this->isConfirm() || $this->EventCancelled)) {
                $this->RowAction = strval($CurrentForm->getValue($this->FormActionName));
            } elseif ($this->isGridAdd()) {
                $this->RowAction = "insert";
            } else {
                $this->RowAction = "";
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isGridAdd()) {
            if ($this->CurrentMode == "copy") {
                $this->loadRowValues($this->CurrentRow); // Load row values
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
            } else {
                $this->loadRowValues(); // Load default values
                $this->OldKey = "";
            }
        } else {
            $this->loadRowValues($this->CurrentRow); // Load row values
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
        }
        $this->setKey($this->OldKey);
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }
        if ($this->isGridAdd() && $this->EventCancelled && !$CurrentForm->hasValue($this->FormBlankRowName)) { // Insert failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isGridEdit()) { // Grid edit
            if ($this->EventCancelled) {
                $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
            }
            if ($this->RowAction == "insert") {
                $this->RowType = RowType::ADD; // Render add
            } else {
                $this->RowType = RowType::EDIT; // Render edit
            }
        }
        if ($this->isGridEdit() && ($this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) && $this->EventCancelled) { // Update failed
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }
        if ($this->isConfirm()) { // Confirm row
            $this->restoreCurrentRowFormValues($this->RowIndex); // Restore form values
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_s_personal_info",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->image->Upload->Index = $this->RowIndex;
        $this->m_type->DefaultValue = $this->m_type->getDefault(); // PHP
        $this->m_type->OldValue = $this->m_type->DefaultValue;
        $this->idcard_status->DefaultValue = $this->idcard_status->getDefault(); // PHP
        $this->idcard_status->OldValue = $this->idcard_status->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $CurrentForm->FormName = $this->FormName;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd()) {
            $this->id->setFormValue($val);
        }

        // Check field name 'name' first before field var 'x_name'
        $val = $CurrentForm->hasValue("name") ? $CurrentForm->getValue("name") : $CurrentForm->getValue("x_name");
        if (!$this->name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->name->Visible = false; // Disable update for API request
            } else {
                $this->name->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_name")) {
            $this->name->setOldValue($CurrentForm->getValue("o_name"));
        }

        // Check field name 'sr_no' first before field var 'x_sr_no'
        $val = $CurrentForm->hasValue("sr_no") ? $CurrentForm->getValue("sr_no") : $CurrentForm->getValue("x_sr_no");
        if (!$this->sr_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sr_no->Visible = false; // Disable update for API request
            } else {
                $this->sr_no->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_sr_no")) {
            $this->sr_no->setOldValue($CurrentForm->getValue("o_sr_no"));
        }

        // Check field name 'faculty' first before field var 'x_faculty'
        $val = $CurrentForm->hasValue("faculty") ? $CurrentForm->getValue("faculty") : $CurrentForm->getValue("x_faculty");
        if (!$this->faculty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->faculty->Visible = false; // Disable update for API request
            } else {
                $this->faculty->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_faculty")) {
            $this->faculty->setOldValue($CurrentForm->getValue("o_faculty"));
        }

        // Check field name 'father_name' first before field var 'x_father_name'
        $val = $CurrentForm->hasValue("father_name") ? $CurrentForm->getValue("father_name") : $CurrentForm->getValue("x_father_name");
        if (!$this->father_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->father_name->Visible = false; // Disable update for API request
            } else {
                $this->father_name->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_father_name")) {
            $this->father_name->setOldValue($CurrentForm->getValue("o_father_name"));
        }

        // Check field name 'mother_name' first before field var 'x_mother_name'
        $val = $CurrentForm->hasValue("mother_name") ? $CurrentForm->getValue("mother_name") : $CurrentForm->getValue("x_mother_name");
        if (!$this->mother_name->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mother_name->Visible = false; // Disable update for API request
            } else {
                $this->mother_name->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_mother_name")) {
            $this->mother_name->setOldValue($CurrentForm->getValue("o_mother_name"));
        }

        // Check field name 'address' first before field var 'x_address'
        $val = $CurrentForm->hasValue("address") ? $CurrentForm->getValue("address") : $CurrentForm->getValue("x_address");
        if (!$this->address->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->address->Visible = false; // Disable update for API request
            } else {
                $this->address->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_address")) {
            $this->address->setOldValue($CurrentForm->getValue("o_address"));
        }

        // Check field name 'dob' first before field var 'x_dob'
        $val = $CurrentForm->hasValue("dob") ? $CurrentForm->getValue("dob") : $CurrentForm->getValue("x_dob");
        if (!$this->dob->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dob->Visible = false; // Disable update for API request
            } else {
                $this->dob->setFormValue($val, true, $validate);
            }
            $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        }
        if ($CurrentForm->hasValue("o_dob")) {
            $this->dob->setOldValue($CurrentForm->getValue("o_dob"));
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_mobile")) {
            $this->mobile->setOldValue($CurrentForm->getValue("o_mobile"));
        }

        // Check field name 'm_type' first before field var 'x_m_type'
        $val = $CurrentForm->hasValue("m_type") ? $CurrentForm->getValue("m_type") : $CurrentForm->getValue("x_m_type");
        if (!$this->m_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_type->Visible = false; // Disable update for API request
            } else {
                $this->m_type->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_m_type")) {
            $this->m_type->setOldValue($CurrentForm->getValue("o_m_type"));
        }

        // Check field name 'idcard_status' first before field var 'x_idcard_status'
        $val = $CurrentForm->hasValue("idcard_status") ? $CurrentForm->getValue("idcard_status") : $CurrentForm->getValue("x_idcard_status");
        if (!$this->idcard_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->idcard_status->Visible = false; // Disable update for API request
            } else {
                $this->idcard_status->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_idcard_status")) {
            $this->idcard_status->setOldValue($CurrentForm->getValue("o_idcard_status"));
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_status")) {
            $this->status->setOldValue($CurrentForm->getValue("o_status"));
        }

        // Check field name 'gender' first before field var 'x_gender'
        $val = $CurrentForm->hasValue("gender") ? $CurrentForm->getValue("gender") : $CurrentForm->getValue("x_gender");
        if (!$this->gender->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gender->Visible = false; // Disable update for API request
            } else {
                $this->gender->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_gender")) {
            $this->gender->setOldValue($CurrentForm->getValue("o_gender"));
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_category")) {
            $this->category->setOldValue($CurrentForm->getValue("o_category"));
        }

        // Check field name 'mobile_other' first before field var 'x_mobile_other'
        $val = $CurrentForm->hasValue("mobile_other") ? $CurrentForm->getValue("mobile_other") : $CurrentForm->getValue("x_mobile_other");
        if (!$this->mobile_other->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile_other->Visible = false; // Disable update for API request
            } else {
                $this->mobile_other->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_mobile_other")) {
            $this->mobile_other->setOldValue($CurrentForm->getValue("o_mobile_other"));
        }

        // Check field name 'doj' first before field var 'x_doj'
        $val = $CurrentForm->hasValue("doj") ? $CurrentForm->getValue("doj") : $CurrentForm->getValue("x_doj");
        if (!$this->doj->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->doj->Visible = false; // Disable update for API request
            } else {
                $this->doj->setFormValue($val, true, $validate);
            }
            $this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern());
        }
        if ($CurrentForm->hasValue("o_doj")) {
            $this->doj->setOldValue($CurrentForm->getValue("o_doj"));
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_remarks")) {
            $this->remarks->setOldValue($CurrentForm->getValue("o_remarks"));
        }

        // Check field name 'sr_uid' first before field var 'x_sr_uid'
        $val = $CurrentForm->hasValue("sr_uid") ? $CurrentForm->getValue("sr_uid") : $CurrentForm->getValue("x_sr_uid");
        if (!$this->sr_uid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sr_uid->Visible = false; // Disable update for API request
            } else {
                $this->sr_uid->setFormValue($val, true, $validate);
            }
        }
        if ($CurrentForm->hasValue("o_sr_uid")) {
            $this->sr_uid->setOldValue($CurrentForm->getValue("o_sr_uid"));
        }

        // Check field name 'updates' first before field var 'x_updates'
        $val = $CurrentForm->hasValue("updates") ? $CurrentForm->getValue("updates") : $CurrentForm->getValue("x_updates");
        if (!$this->updates->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->updates->Visible = false; // Disable update for API request
            } else {
                $this->updates->setFormValue($val);
            }
        }
        if ($CurrentForm->hasValue("o_updates")) {
            $this->updates->setOldValue($CurrentForm->getValue("o_updates"));
        }
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        if (!$this->isGridAdd() && !$this->isAdd()) {
            $this->id->CurrentValue = $this->id->FormValue;
        }
        $this->name->CurrentValue = $this->name->FormValue;
        $this->sr_no->CurrentValue = $this->sr_no->FormValue;
        $this->faculty->CurrentValue = $this->faculty->FormValue;
        $this->father_name->CurrentValue = $this->father_name->FormValue;
        $this->mother_name->CurrentValue = $this->mother_name->FormValue;
        $this->address->CurrentValue = $this->address->FormValue;
        $this->dob->CurrentValue = $this->dob->FormValue;
        $this->dob->CurrentValue = UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern());
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->m_type->CurrentValue = $this->m_type->FormValue;
        $this->idcard_status->CurrentValue = $this->idcard_status->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->gender->CurrentValue = $this->gender->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->mobile_other->CurrentValue = $this->mobile_other->FormValue;
        $this->doj->CurrentValue = $this->doj->FormValue;
        $this->doj->CurrentValue = UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern());
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->sr_uid->CurrentValue = $this->sr_uid->FormValue;
        $this->updates->CurrentValue = $this->updates->FormValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->image->Upload->Index = $this->RowIndex;
        $this->name->setDbValue($row['name']);
        $this->sr_no->setDbValue($row['sr_no']);
        $this->faculty->setDbValue($row['faculty']);
        $this->father_name->setDbValue($row['father_name']);
        $this->mother_name->setDbValue($row['mother_name']);
        $this->address->setDbValue($row['address']);
        $this->dob->setDbValue($row['dob']);
        $this->mobile->setDbValue($row['mobile']);
        $this->m_type->setDbValue($row['m_type']);
        $this->idcard_status->setDbValue($row['idcard_status']);
        $this->status->setDbValue($row['status']);
        $this->gender->setDbValue($row['gender']);
        $this->category->setDbValue($row['category']);
        $this->mobile_other->setDbValue($row['mobile_other']);
        $this->doj->setDbValue($row['doj']);
        $this->remarks->setDbValue($row['remarks']);
        $this->epc->setDbValue($row['epc']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->sr_uid->setDbValue($row['sr_uid']);
        $this->updates->setDbValue($row['updates']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['name'] = $this->name->DefaultValue;
        $row['sr_no'] = $this->sr_no->DefaultValue;
        $row['faculty'] = $this->faculty->DefaultValue;
        $row['father_name'] = $this->father_name->DefaultValue;
        $row['mother_name'] = $this->mother_name->DefaultValue;
        $row['address'] = $this->address->DefaultValue;
        $row['dob'] = $this->dob->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['m_type'] = $this->m_type->DefaultValue;
        $row['idcard_status'] = $this->idcard_status->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['gender'] = $this->gender->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['mobile_other'] = $this->mobile_other->DefaultValue;
        $row['doj'] = $this->doj->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['epc'] = $this->epc->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['sr_uid'] = $this->sr_uid->DefaultValue;
        $row['updates'] = $this->updates->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // image

        // name

        // sr_no

        // faculty
        $this->faculty->CellCssStyle = "white-space: nowrap;";

        // father_name

        // mother_name

        // address

        // dob

        // mobile

        // m_type

        // idcard_status

        // status

        // gender

        // category

        // mobile_other

        // doj

        // remarks

        // epc
        $this->epc->CellCssStyle = "white-space: nowrap;";

        // operator
        $this->operator->CellCssStyle = "white-space: nowrap;";

        // datetime
        $this->datetime->CellCssStyle = "white-space: nowrap;";

        // sr_uid
        $this->sr_uid->CellCssStyle = "white-space: nowrap;";

        // updates

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 40;
                $this->image->ImageHeight = 40;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // name
            $this->name->ViewValue = $this->name->CurrentValue;

            // sr_no
            $this->sr_no->ViewValue = $this->sr_no->CurrentValue;

            // faculty
            $curVal = strval($this->faculty->CurrentValue);
            if ($curVal != "") {
                $this->faculty->ViewValue = $this->faculty->lookupCacheOption($curVal);
                if ($this->faculty->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->faculty->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->faculty->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->faculty->getSelectFilter($this); // PHP
                    $sqlWrk = $this->faculty->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->faculty->Lookup->renderViewRow($rswrk[0]);
                        $this->faculty->ViewValue = $this->faculty->displayValue($arwrk);
                    } else {
                        $this->faculty->ViewValue = $this->faculty->CurrentValue;
                    }
                }
            } else {
                $this->faculty->ViewValue = null;
            }

            // father_name
            $this->father_name->ViewValue = $this->father_name->CurrentValue;

            // mother_name
            $this->mother_name->ViewValue = $this->mother_name->CurrentValue;

            // address
            $this->address->ViewValue = $this->address->CurrentValue;

            // dob
            $this->dob->ViewValue = $this->dob->CurrentValue;
            $this->dob->ViewValue = FormatDateTime($this->dob->ViewValue, $this->dob->formatPattern());

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // m_type
            $curVal = strval($this->m_type->CurrentValue);
            if ($curVal != "") {
                $this->m_type->ViewValue = $this->m_type->lookupCacheOption($curVal);
                if ($this->m_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_type->Lookup->renderViewRow($rswrk[0]);
                        $this->m_type->ViewValue = $this->m_type->displayValue($arwrk);
                    } else {
                        $this->m_type->ViewValue = FormatNumber($this->m_type->CurrentValue, $this->m_type->formatPattern());
                    }
                }
            } else {
                $this->m_type->ViewValue = null;
            }

            // idcard_status
            if (strval($this->idcard_status->CurrentValue) != "") {
                $this->idcard_status->ViewValue = $this->idcard_status->optionCaption($this->idcard_status->CurrentValue);
            } else {
                $this->idcard_status->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // gender
            if (strval($this->gender->CurrentValue) != "") {
                $this->gender->ViewValue = $this->gender->optionCaption($this->gender->CurrentValue);
            } else {
                $this->gender->ViewValue = null;
            }

            // category
            if (strval($this->category->CurrentValue) != "") {
                $this->category->ViewValue = $this->category->optionCaption($this->category->CurrentValue);
            } else {
                $this->category->ViewValue = null;
            }

            // mobile_other
            $this->mobile_other->ViewValue = $this->mobile_other->CurrentValue;

            // doj
            $this->doj->ViewValue = $this->doj->CurrentValue;
            $this->doj->ViewValue = FormatDateTime($this->doj->ViewValue, $this->doj->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // sr_uid
            $this->sr_uid->ViewValue = $this->sr_uid->CurrentValue;
            $this->sr_uid->ViewValue = FormatNumber($this->sr_uid->ViewValue, $this->sr_uid->formatPattern());

            // updates
            $this->updates->ViewValue = $this->updates->CurrentValue;

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // name
            $this->name->HrefValue = "";
            $this->name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->name->ViewValue = $this->highlightValue($this->name);
            }

            // sr_no
            $this->sr_no->HrefValue = "";
            $this->sr_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->sr_no->ViewValue = $this->highlightValue($this->sr_no);
            }

            // faculty
            $this->faculty->HrefValue = "";
            $this->faculty->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";
            $this->father_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->father_name->ViewValue = $this->highlightValue($this->father_name);
            }

            // mother_name
            $this->mother_name->HrefValue = "";
            $this->mother_name->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mother_name->ViewValue = $this->highlightValue($this->mother_name);
            }

            // address
            $this->address->HrefValue = "";
            $this->address->TooltipValue = "";
            if (!$this->isExport()) {
                $this->address->ViewValue = $this->highlightValue($this->address);
            }

            // dob
            $this->dob->HrefValue = "";
            $this->dob->TooltipValue = "";
            if (!$this->isExport()) {
                $this->dob->ViewValue = $this->highlightValue($this->dob);
            }

            // mobile
            $this->mobile->HrefValue = "";
            $this->mobile->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mobile->ViewValue = $this->highlightValue($this->mobile);
            }

            // m_type
            $this->m_type->HrefValue = "";
            $this->m_type->TooltipValue = "";

            // idcard_status
            $this->idcard_status->HrefValue = "";
            $this->idcard_status->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // gender
            $this->gender->HrefValue = "";
            $this->gender->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";
            $this->mobile_other->TooltipValue = "";
            if (!$this->isExport()) {
                $this->mobile_other->ViewValue = $this->highlightValue($this->mobile_other);
            }

            // doj
            $this->doj->HrefValue = "";
            $this->doj->TooltipValue = "";
            if (!$this->isExport()) {
                $this->doj->ViewValue = $this->highlightValue($this->doj);
            }

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";
            if (!$this->isExport()) {
                $this->remarks->ViewValue = $this->highlightValue($this->remarks);
            }

            // sr_uid
            $this->sr_uid->HrefValue = "";
            $this->sr_uid->TooltipValue = "";

            // updates
            $this->updates->HrefValue = "";
            $this->updates->TooltipValue = "";
            if (!$this->isExport()) {
                $this->updates->ViewValue = $this->highlightValue($this->updates);
            }
        } elseif ($this->RowType == RowType::ADD) {
            // id

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 40;
                $this->image->ImageHeight = 40;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                if ($this->RowIndex == '$rowindex$') {
                    $this->image->Upload->FileName = "";
                } else {
                    $this->image->Upload->FileName = $this->image->CurrentValue;
                }
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->image->Upload->DbValue = null;
            }
            if (is_numeric($this->RowIndex)) {
                RenderUploadField($this->image, $this->RowIndex);
            }

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // sr_no
            $this->sr_no->setupEditAttributes();
            if (!$this->sr_no->Raw) {
                $this->sr_no->CurrentValue = HtmlDecode($this->sr_no->CurrentValue);
            }
            $this->sr_no->EditValue = HtmlEncode($this->sr_no->CurrentValue);
            $this->sr_no->PlaceHolder = RemoveHtml($this->sr_no->caption());

            // faculty
            $this->faculty->setupEditAttributes();
            $curVal = trim(strval($this->faculty->CurrentValue));
            if ($curVal != "") {
                $this->faculty->ViewValue = $this->faculty->lookupCacheOption($curVal);
            } else {
                $this->faculty->ViewValue = $this->faculty->Lookup !== null && is_array($this->faculty->lookupOptions()) && count($this->faculty->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->faculty->ViewValue !== null) { // Load from cache
                $this->faculty->EditValue = array_values($this->faculty->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->faculty->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->faculty->CurrentValue, $this->faculty->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->faculty->getSelectFilter($this); // PHP
                $sqlWrk = $this->faculty->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->faculty->EditValue = $arwrk;
            }
            $this->faculty->PlaceHolder = RemoveHtml($this->faculty->caption());

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // mother_name
            $this->mother_name->setupEditAttributes();
            if (!$this->mother_name->Raw) {
                $this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
            }
            $this->mother_name->EditValue = HtmlEncode($this->mother_name->CurrentValue);
            $this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // m_type
            $this->m_type->setupEditAttributes();
            $curVal = trim(strval($this->m_type->CurrentValue));
            if ($curVal != "") {
                $this->m_type->ViewValue = $this->m_type->lookupCacheOption($curVal);
            } else {
                $this->m_type->ViewValue = $this->m_type->Lookup !== null && is_array($this->m_type->lookupOptions()) && count($this->m_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->m_type->ViewValue !== null) { // Load from cache
                $this->m_type->EditValue = array_values($this->m_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->m_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->m_type->CurrentValue, $this->m_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->m_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->m_type->EditValue = $arwrk;
            }
            $this->m_type->PlaceHolder = RemoveHtml($this->m_type->caption());

            // idcard_status
            $this->idcard_status->setupEditAttributes();
            $this->idcard_status->EditValue = $this->idcard_status->options(true);
            $this->idcard_status->PlaceHolder = RemoveHtml($this->idcard_status->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->EditValue = $this->category->options(true);
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->CurrentValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // doj
            $this->doj->setupEditAttributes();
            $this->doj->EditValue = HtmlEncode(FormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern()));
            $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // sr_uid
            $this->sr_uid->setupEditAttributes();
            $this->sr_uid->EditValue = $this->sr_uid->CurrentValue;
            $this->sr_uid->PlaceHolder = RemoveHtml($this->sr_uid->caption());
            if (strval($this->sr_uid->EditValue) != "" && is_numeric($this->sr_uid->EditValue)) {
                $this->sr_uid->EditValue = FormatNumber($this->sr_uid->EditValue, null);
            }

            // updates
            $this->updates->setupEditAttributes();
            if (!$this->updates->Raw) {
                $this->updates->CurrentValue = HtmlDecode($this->updates->CurrentValue);
            }
            $this->updates->EditValue = HtmlEncode($this->updates->CurrentValue);
            $this->updates->PlaceHolder = RemoveHtml($this->updates->caption());

            // Add refer script

            // id
            $this->id->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // name
            $this->name->HrefValue = "";

            // sr_no
            $this->sr_no->HrefValue = "";

            // faculty
            $this->faculty->HrefValue = "";

            // father_name
            $this->father_name->HrefValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // m_type
            $this->m_type->HrefValue = "";

            // idcard_status
            $this->idcard_status->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";

            // doj
            $this->doj->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // sr_uid
            $this->sr_uid->HrefValue = "";

            // updates
            $this->updates->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 40;
                $this->image->ImageHeight = 40;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }

            // name
            $this->name->setupEditAttributes();
            if (!$this->name->Raw) {
                $this->name->CurrentValue = HtmlDecode($this->name->CurrentValue);
            }
            $this->name->EditValue = HtmlEncode($this->name->CurrentValue);
            $this->name->PlaceHolder = RemoveHtml($this->name->caption());

            // sr_no
            $this->sr_no->setupEditAttributes();
            if (!$this->sr_no->Raw) {
                $this->sr_no->CurrentValue = HtmlDecode($this->sr_no->CurrentValue);
            }
            $this->sr_no->EditValue = HtmlEncode($this->sr_no->CurrentValue);
            $this->sr_no->PlaceHolder = RemoveHtml($this->sr_no->caption());

            // faculty
            $this->faculty->setupEditAttributes();
            $curVal = strval($this->faculty->CurrentValue);
            if ($curVal != "") {
                $this->faculty->EditValue = $this->faculty->lookupCacheOption($curVal);
                if ($this->faculty->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->faculty->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->faculty->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->faculty->getSelectFilter($this); // PHP
                    $sqlWrk = $this->faculty->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->faculty->Lookup->renderViewRow($rswrk[0]);
                        $this->faculty->EditValue = $this->faculty->displayValue($arwrk);
                    } else {
                        $this->faculty->EditValue = $this->faculty->CurrentValue;
                    }
                }
            } else {
                $this->faculty->EditValue = null;
            }

            // father_name
            $this->father_name->setupEditAttributes();
            if (!$this->father_name->Raw) {
                $this->father_name->CurrentValue = HtmlDecode($this->father_name->CurrentValue);
            }
            $this->father_name->EditValue = HtmlEncode($this->father_name->CurrentValue);
            $this->father_name->PlaceHolder = RemoveHtml($this->father_name->caption());

            // mother_name
            $this->mother_name->setupEditAttributes();
            if (!$this->mother_name->Raw) {
                $this->mother_name->CurrentValue = HtmlDecode($this->mother_name->CurrentValue);
            }
            $this->mother_name->EditValue = HtmlEncode($this->mother_name->CurrentValue);
            $this->mother_name->PlaceHolder = RemoveHtml($this->mother_name->caption());

            // address
            $this->address->setupEditAttributes();
            $this->address->EditValue = HtmlEncode($this->address->CurrentValue);
            $this->address->PlaceHolder = RemoveHtml($this->address->caption());

            // dob
            $this->dob->setupEditAttributes();
            $this->dob->EditValue = HtmlEncode(FormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()));
            $this->dob->PlaceHolder = RemoveHtml($this->dob->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // m_type
            $this->m_type->setupEditAttributes();
            $curVal = trim(strval($this->m_type->CurrentValue));
            if ($curVal != "") {
                $this->m_type->ViewValue = $this->m_type->lookupCacheOption($curVal);
            } else {
                $this->m_type->ViewValue = $this->m_type->Lookup !== null && is_array($this->m_type->lookupOptions()) && count($this->m_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->m_type->ViewValue !== null) { // Load from cache
                $this->m_type->EditValue = array_values($this->m_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->m_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->m_type->CurrentValue, $this->m_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->m_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->m_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->m_type->EditValue = $arwrk;
            }
            $this->m_type->PlaceHolder = RemoveHtml($this->m_type->caption());

            // idcard_status
            $this->idcard_status->setupEditAttributes();
            $this->idcard_status->EditValue = $this->idcard_status->options(true);
            $this->idcard_status->PlaceHolder = RemoveHtml($this->idcard_status->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // gender
            $this->gender->setupEditAttributes();
            $this->gender->EditValue = $this->gender->options(true);
            $this->gender->PlaceHolder = RemoveHtml($this->gender->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->EditValue = $this->category->options(true);
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // mobile_other
            $this->mobile_other->setupEditAttributes();
            if (!$this->mobile_other->Raw) {
                $this->mobile_other->CurrentValue = HtmlDecode($this->mobile_other->CurrentValue);
            }
            $this->mobile_other->EditValue = HtmlEncode($this->mobile_other->CurrentValue);
            $this->mobile_other->PlaceHolder = RemoveHtml($this->mobile_other->caption());

            // doj
            $this->doj->setupEditAttributes();
            $this->doj->EditValue = HtmlEncode(FormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern()));
            $this->doj->PlaceHolder = RemoveHtml($this->doj->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // sr_uid
            $this->sr_uid->setupEditAttributes();
            $this->sr_uid->EditValue = $this->sr_uid->CurrentValue;
            $this->sr_uid->PlaceHolder = RemoveHtml($this->sr_uid->caption());
            if (strval($this->sr_uid->EditValue) != "" && is_numeric($this->sr_uid->EditValue)) {
                $this->sr_uid->EditValue = FormatNumber($this->sr_uid->EditValue, null);
            }

            // updates
            $this->updates->setupEditAttributes();
            if (!$this->updates->Raw) {
                $this->updates->CurrentValue = HtmlDecode($this->updates->CurrentValue);
            }
            $this->updates->EditValue = HtmlEncode($this->updates->CurrentValue);
            $this->updates->PlaceHolder = RemoveHtml($this->updates->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = GetFileUploadUrl($this->image, $this->image->htmlDecode($this->image->Upload->DbValue)); // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";

            // name
            $this->name->HrefValue = "";

            // sr_no
            $this->sr_no->HrefValue = "";

            // faculty
            $this->faculty->HrefValue = "";
            $this->faculty->TooltipValue = "";

            // father_name
            $this->father_name->HrefValue = "";

            // mother_name
            $this->mother_name->HrefValue = "";

            // address
            $this->address->HrefValue = "";

            // dob
            $this->dob->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // m_type
            $this->m_type->HrefValue = "";

            // idcard_status
            $this->idcard_status->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // gender
            $this->gender->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // mobile_other
            $this->mobile_other->HrefValue = "";

            // doj
            $this->doj->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // sr_uid
            $this->sr_uid->HrefValue = "";

            // updates
            $this->updates->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->name->Visible && $this->name->Required) {
                if (!$this->name->IsDetailKey && EmptyValue($this->name->FormValue)) {
                    $this->name->addErrorMessage(str_replace("%s", $this->name->caption(), $this->name->RequiredErrorMessage));
                }
            }
            if ($this->sr_no->Visible && $this->sr_no->Required) {
                if (!$this->sr_no->IsDetailKey && EmptyValue($this->sr_no->FormValue)) {
                    $this->sr_no->addErrorMessage(str_replace("%s", $this->sr_no->caption(), $this->sr_no->RequiredErrorMessage));
                }
            }
            if ($this->faculty->Visible && $this->faculty->Required) {
                if (!$this->faculty->IsDetailKey && EmptyValue($this->faculty->FormValue)) {
                    $this->faculty->addErrorMessage(str_replace("%s", $this->faculty->caption(), $this->faculty->RequiredErrorMessage));
                }
            }
            if ($this->father_name->Visible && $this->father_name->Required) {
                if (!$this->father_name->IsDetailKey && EmptyValue($this->father_name->FormValue)) {
                    $this->father_name->addErrorMessage(str_replace("%s", $this->father_name->caption(), $this->father_name->RequiredErrorMessage));
                }
            }
            if ($this->mother_name->Visible && $this->mother_name->Required) {
                if (!$this->mother_name->IsDetailKey && EmptyValue($this->mother_name->FormValue)) {
                    $this->mother_name->addErrorMessage(str_replace("%s", $this->mother_name->caption(), $this->mother_name->RequiredErrorMessage));
                }
            }
            if ($this->address->Visible && $this->address->Required) {
                if (!$this->address->IsDetailKey && EmptyValue($this->address->FormValue)) {
                    $this->address->addErrorMessage(str_replace("%s", $this->address->caption(), $this->address->RequiredErrorMessage));
                }
            }
            if ($this->dob->Visible && $this->dob->Required) {
                if (!$this->dob->IsDetailKey && EmptyValue($this->dob->FormValue)) {
                    $this->dob->addErrorMessage(str_replace("%s", $this->dob->caption(), $this->dob->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dob->FormValue, $this->dob->formatPattern())) {
                $this->dob->addErrorMessage($this->dob->getErrorMessage(false));
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->m_type->Visible && $this->m_type->Required) {
                if (!$this->m_type->IsDetailKey && EmptyValue($this->m_type->FormValue)) {
                    $this->m_type->addErrorMessage(str_replace("%s", $this->m_type->caption(), $this->m_type->RequiredErrorMessage));
                }
            }
            if ($this->idcard_status->Visible && $this->idcard_status->Required) {
                if (!$this->idcard_status->IsDetailKey && EmptyValue($this->idcard_status->FormValue)) {
                    $this->idcard_status->addErrorMessage(str_replace("%s", $this->idcard_status->caption(), $this->idcard_status->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->gender->Visible && $this->gender->Required) {
                if (!$this->gender->IsDetailKey && EmptyValue($this->gender->FormValue)) {
                    $this->gender->addErrorMessage(str_replace("%s", $this->gender->caption(), $this->gender->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->mobile_other->Visible && $this->mobile_other->Required) {
                if (!$this->mobile_other->IsDetailKey && EmptyValue($this->mobile_other->FormValue)) {
                    $this->mobile_other->addErrorMessage(str_replace("%s", $this->mobile_other->caption(), $this->mobile_other->RequiredErrorMessage));
                }
            }
            if ($this->doj->Visible && $this->doj->Required) {
                if (!$this->doj->IsDetailKey && EmptyValue($this->doj->FormValue)) {
                    $this->doj->addErrorMessage(str_replace("%s", $this->doj->caption(), $this->doj->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->doj->FormValue, $this->doj->formatPattern())) {
                $this->doj->addErrorMessage($this->doj->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->sr_uid->Visible && $this->sr_uid->Required) {
                if (!$this->sr_uid->IsDetailKey && EmptyValue($this->sr_uid->FormValue)) {
                    $this->sr_uid->addErrorMessage(str_replace("%s", $this->sr_uid->caption(), $this->sr_uid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->sr_uid->FormValue)) {
                $this->sr_uid->addErrorMessage($this->sr_uid->getErrorMessage(false));
            }
            if ($this->updates->Visible && $this->updates->Required) {
                if (!$this->updates->IsDetailKey && EmptyValue($this->updates->FormValue)) {
                    $this->updates->addErrorMessage(str_replace("%s", $this->updates->caption(), $this->updates->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        return $deleteRows;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (sr_no)
        if ($this->sr_no->CurrentValue != "") {
            $filterChk = "(`sr_no` = '" . AdjustSql($this->sr_no->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->sr_no->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->sr_no->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $rsnew = [];

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, $this->name->ReadOnly);

        // sr_no
        $this->sr_no->setDbValueDef($rsnew, $this->sr_no->CurrentValue, $this->sr_no->ReadOnly);

        // father_name
        $this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, $this->father_name->ReadOnly);

        // mother_name
        $this->mother_name->setDbValueDef($rsnew, $this->mother_name->CurrentValue, $this->mother_name->ReadOnly);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, $this->address->ReadOnly);

        // dob
        $this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()), $this->dob->ReadOnly);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, $this->mobile->ReadOnly);

        // m_type
        $this->m_type->setDbValueDef($rsnew, $this->m_type->CurrentValue, $this->m_type->ReadOnly);

        // idcard_status
        $this->idcard_status->setDbValueDef($rsnew, $this->idcard_status->CurrentValue, $this->idcard_status->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // gender
        $this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, $this->gender->ReadOnly);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, $this->category->ReadOnly);

        // mobile_other
        $this->mobile_other->setDbValueDef($rsnew, $this->mobile_other->CurrentValue, $this->mobile_other->ReadOnly);

        // doj
        $this->doj->setDbValueDef($rsnew, UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern()), $this->doj->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // sr_uid
        $this->sr_uid->setDbValueDef($rsnew, $this->sr_uid->CurrentValue, $this->sr_uid->ReadOnly);

        // updates
        $this->updates->setDbValueDef($rsnew, $this->updates->CurrentValue, $this->updates->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['name'])) { // name
            $this->name->CurrentValue = $row['name'];
        }
        if (isset($row['sr_no'])) { // sr_no
            $this->sr_no->CurrentValue = $row['sr_no'];
        }
        if (isset($row['father_name'])) { // father_name
            $this->father_name->CurrentValue = $row['father_name'];
        }
        if (isset($row['mother_name'])) { // mother_name
            $this->mother_name->CurrentValue = $row['mother_name'];
        }
        if (isset($row['address'])) { // address
            $this->address->CurrentValue = $row['address'];
        }
        if (isset($row['dob'])) { // dob
            $this->dob->CurrentValue = $row['dob'];
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->CurrentValue = $row['mobile'];
        }
        if (isset($row['m_type'])) { // m_type
            $this->m_type->CurrentValue = $row['m_type'];
        }
        if (isset($row['idcard_status'])) { // idcard_status
            $this->idcard_status->CurrentValue = $row['idcard_status'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['gender'])) { // gender
            $this->gender->CurrentValue = $row['gender'];
        }
        if (isset($row['category'])) { // category
            $this->category->CurrentValue = $row['category'];
        }
        if (isset($row['mobile_other'])) { // mobile_other
            $this->mobile_other->CurrentValue = $row['mobile_other'];
        }
        if (isset($row['doj'])) { // doj
            $this->doj->CurrentValue = $row['doj'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['sr_uid'])) { // sr_uid
            $this->sr_uid->CurrentValue = $row['sr_uid'];
        }
        if (isset($row['updates'])) { // updates
            $this->updates->CurrentValue = $row['updates'];
        }
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Set up foreign key field value from Session
        if ($this->getCurrentMasterTable() == "s_student_list") {
            $this->id->Visible = true; // Need to insert foreign key
            $this->id->CurrentValue = $this->id->getSessionValue();
        }

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            $this->image->UploadPath = $this->image->getUploadPath();
            if (!EmptyValue($this->image->Upload->FileName)) {
                $this->image->Upload->DbValue = null;
                FixUploadFileNames($this->image);
                $this->image->setDbValueDef($rsnew, $this->image->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->sr_no->CurrentValue != "") { // Check field with unique index
            $filter = "(`sr_no` = '" . AdjustSql($this->sr_no->CurrentValue, $this->Dbid) . "')";
            $rsChk = $this->loadRs($filter)->fetch();
            if ($rsChk !== false) {
                $idxErrMsg = str_replace("%f", $this->sr_no->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->sr_no->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->image->Visible && !$this->image->Upload->KeepFile) {
                    $this->image->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->image, $rsnew['image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // image
        if ($this->image->Visible && !$this->image->Upload->KeepFile) {
            if ($this->image->Upload->FileName == "") {
                $rsnew['image'] = null;
            } else {
                FixUploadTempFileNames($this->image);
                $rsnew['image'] = $this->image->Upload->FileName;
            }
            $this->image->ImageWidth = 320; // Resize width
            $this->image->ImageHeight = 320; // Resize height
        }

        // name
        $this->name->setDbValueDef($rsnew, $this->name->CurrentValue, false);

        // sr_no
        $this->sr_no->setDbValueDef($rsnew, $this->sr_no->CurrentValue, false);

        // faculty
        $this->faculty->setDbValueDef($rsnew, $this->faculty->CurrentValue, false);

        // father_name
        $this->father_name->setDbValueDef($rsnew, $this->father_name->CurrentValue, false);

        // mother_name
        $this->mother_name->setDbValueDef($rsnew, $this->mother_name->CurrentValue, false);

        // address
        $this->address->setDbValueDef($rsnew, $this->address->CurrentValue, false);

        // dob
        $this->dob->setDbValueDef($rsnew, UnFormatDateTime($this->dob->CurrentValue, $this->dob->formatPattern()), false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // m_type
        $this->m_type->setDbValueDef($rsnew, $this->m_type->CurrentValue, strval($this->m_type->CurrentValue) == "");

        // idcard_status
        $this->idcard_status->setDbValueDef($rsnew, $this->idcard_status->CurrentValue, strval($this->idcard_status->CurrentValue) == "");

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // gender
        $this->gender->setDbValueDef($rsnew, $this->gender->CurrentValue, false);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, false);

        // mobile_other
        $this->mobile_other->setDbValueDef($rsnew, $this->mobile_other->CurrentValue, false);

        // doj
        $this->doj->setDbValueDef($rsnew, UnFormatDateTime($this->doj->CurrentValue, $this->doj->formatPattern()), false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // sr_uid
        $this->sr_uid->setDbValueDef($rsnew, $this->sr_uid->CurrentValue, false);

        // updates
        $this->updates->setDbValueDef($rsnew, $this->updates->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['image'])) { // image
            $this->image->setFormValue($row['image']);
        }
        if (isset($row['name'])) { // name
            $this->name->setFormValue($row['name']);
        }
        if (isset($row['sr_no'])) { // sr_no
            $this->sr_no->setFormValue($row['sr_no']);
        }
        if (isset($row['faculty'])) { // faculty
            $this->faculty->setFormValue($row['faculty']);
        }
        if (isset($row['father_name'])) { // father_name
            $this->father_name->setFormValue($row['father_name']);
        }
        if (isset($row['mother_name'])) { // mother_name
            $this->mother_name->setFormValue($row['mother_name']);
        }
        if (isset($row['address'])) { // address
            $this->address->setFormValue($row['address']);
        }
        if (isset($row['dob'])) { // dob
            $this->dob->setFormValue($row['dob']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['m_type'])) { // m_type
            $this->m_type->setFormValue($row['m_type']);
        }
        if (isset($row['idcard_status'])) { // idcard_status
            $this->idcard_status->setFormValue($row['idcard_status']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['gender'])) { // gender
            $this->gender->setFormValue($row['gender']);
        }
        if (isset($row['category'])) { // category
            $this->category->setFormValue($row['category']);
        }
        if (isset($row['mobile_other'])) { // mobile_other
            $this->mobile_other->setFormValue($row['mobile_other']);
        }
        if (isset($row['doj'])) { // doj
            $this->doj->setFormValue($row['doj']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['sr_uid'])) { // sr_uid
            $this->sr_uid->setFormValue($row['sr_uid']);
        }
        if (isset($row['updates'])) { // updates
            $this->updates->setFormValue($row['updates']);
        }
    }

    // Set up master/detail based on QueryString
    protected function setupMasterParms()
    {
        // Hide foreign keys
        $masterTblVar = $this->getCurrentMasterTable();
        if ($masterTblVar == "s_student_list") {
            $masterTbl = Container("s_student_list");
            $this->id->Visible = false;
            if ($masterTbl->EventCancelled) {
                $this->EventCancelled = true;
            }
        }
        $this->DbMasterFilter = $this->getMasterFilterFromSession(); // Get master filter from session
        $this->DbDetailFilter = $this->getDetailFilterFromSession(); // Get detail filter from session
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_faculty":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_idcard_status":
                    break;
                case "x_status":
                    break;
                case "x_gender":
                    break;
                case "x_category":
                    break;
                case "x_mobile_other":
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
        if (CurrentUserID() < 100)
            $this->m_type->Visible = True;
        else
            $this->m_type->Visible = False;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }
}
