<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SOmrValueSearch extends SOmrValue
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SOmrValueSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "somrvaluesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->roll_no->setVisibility();
        $this->test_id->setVisibility();
        $this->total->setVisibility();
        $this->percent->setVisibility();
        $this->s_1->setVisibility();
        $this->s_2->setVisibility();
        $this->s_3->setVisibility();
        $this->s_4->setVisibility();
        $this->s_5->setVisibility();
        $this->omr_image->setVisibility();
        $this->_1->setVisibility();
        $this->m_1->setVisibility();
        $this->_2->setVisibility();
        $this->m_2->setVisibility();
        $this->_3->setVisibility();
        $this->m_3->setVisibility();
        $this->_4->setVisibility();
        $this->m_4->setVisibility();
        $this->_5->setVisibility();
        $this->m_5->setVisibility();
        $this->_6->setVisibility();
        $this->m_6->setVisibility();
        $this->_7->setVisibility();
        $this->m_7->setVisibility();
        $this->_8->setVisibility();
        $this->m_8->setVisibility();
        $this->_9->setVisibility();
        $this->m_9->setVisibility();
        $this->_10->setVisibility();
        $this->m_10->setVisibility();
        $this->_11->setVisibility();
        $this->m_11->setVisibility();
        $this->_12->setVisibility();
        $this->m_12->setVisibility();
        $this->_13->setVisibility();
        $this->m_13->setVisibility();
        $this->_14->setVisibility();
        $this->m_14->setVisibility();
        $this->_15->setVisibility();
        $this->m_15->setVisibility();
        $this->_16->setVisibility();
        $this->m_16->setVisibility();
        $this->_17->setVisibility();
        $this->m_17->setVisibility();
        $this->_18->setVisibility();
        $this->m_18->setVisibility();
        $this->_19->setVisibility();
        $this->m_19->setVisibility();
        $this->_20->setVisibility();
        $this->m_20->setVisibility();
        $this->_21->setVisibility();
        $this->m_21->setVisibility();
        $this->_22->setVisibility();
        $this->m_22->setVisibility();
        $this->_23->setVisibility();
        $this->m_23->setVisibility();
        $this->_24->setVisibility();
        $this->m_24->setVisibility();
        $this->_25->setVisibility();
        $this->m_25->setVisibility();
        $this->_26->setVisibility();
        $this->m_26->setVisibility();
        $this->_27->setVisibility();
        $this->m_27->setVisibility();
        $this->_28->setVisibility();
        $this->m_28->setVisibility();
        $this->_29->setVisibility();
        $this->m_29->setVisibility();
        $this->_30->setVisibility();
        $this->m_30->setVisibility();
        $this->_31->setVisibility();
        $this->m_31->setVisibility();
        $this->_32->setVisibility();
        $this->m_32->setVisibility();
        $this->_33->setVisibility();
        $this->m_33->setVisibility();
        $this->_34->setVisibility();
        $this->m_34->setVisibility();
        $this->_35->setVisibility();
        $this->m_35->setVisibility();
        $this->_36->setVisibility();
        $this->m_36->setVisibility();
        $this->_37->setVisibility();
        $this->m_37->setVisibility();
        $this->_38->setVisibility();
        $this->m_38->setVisibility();
        $this->_39->setVisibility();
        $this->m_39->setVisibility();
        $this->_40->setVisibility();
        $this->m_40->setVisibility();
        $this->_41->setVisibility();
        $this->m_41->setVisibility();
        $this->_42->setVisibility();
        $this->m_42->setVisibility();
        $this->_43->setVisibility();
        $this->m_43->setVisibility();
        $this->_44->setVisibility();
        $this->m_44->setVisibility();
        $this->_45->setVisibility();
        $this->m_45->setVisibility();
        $this->_46->setVisibility();
        $this->m_46->setVisibility();
        $this->_47->setVisibility();
        $this->m_47->setVisibility();
        $this->_48->setVisibility();
        $this->m_48->setVisibility();
        $this->_49->setVisibility();
        $this->m_49->setVisibility();
        $this->_50->setVisibility();
        $this->m_50->setVisibility();
        $this->_51->setVisibility();
        $this->m_51->setVisibility();
        $this->_52->setVisibility();
        $this->m_52->setVisibility();
        $this->_53->setVisibility();
        $this->m_53->setVisibility();
        $this->_54->setVisibility();
        $this->m_54->setVisibility();
        $this->_55->setVisibility();
        $this->m_55->setVisibility();
        $this->_56->setVisibility();
        $this->m_56->setVisibility();
        $this->_57->setVisibility();
        $this->m_57->setVisibility();
        $this->_58->setVisibility();
        $this->m_58->setVisibility();
        $this->_59->setVisibility();
        $this->m_59->setVisibility();
        $this->_60->setVisibility();
        $this->m_60->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 's_omr_value';
        $this->TableName = 's_omr_value';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_omr_value)
        if (!isset($GLOBALS["s_omr_value"]) || $GLOBALS["s_omr_value"]::class == PROJECT_NAMESPACE . "s_omr_value") {
            $GLOBALS["s_omr_value"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "somrvalueview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->omr_image->OldUploadPath = $this->omr_image->getUploadPath(); // PHP
                $this->omr_image->UploadPath = $this->omr_image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "somrvaluelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
        $this->buildSearchUrl($srchUrl, $this->test_id); // test_id
        $this->buildSearchUrl($srchUrl, $this->total); // total
        $this->buildSearchUrl($srchUrl, $this->percent); // percent
        $this->buildSearchUrl($srchUrl, $this->s_1); // s_1
        $this->buildSearchUrl($srchUrl, $this->s_2); // s_2
        $this->buildSearchUrl($srchUrl, $this->s_3); // s_3
        $this->buildSearchUrl($srchUrl, $this->s_4); // s_4
        $this->buildSearchUrl($srchUrl, $this->s_5); // s_5
        $this->buildSearchUrl($srchUrl, $this->omr_image); // omr_image
        $this->buildSearchUrl($srchUrl, $this->_1); // 1
        $this->buildSearchUrl($srchUrl, $this->m_1); // m_1
        $this->buildSearchUrl($srchUrl, $this->_2); // 2
        $this->buildSearchUrl($srchUrl, $this->m_2); // m_2
        $this->buildSearchUrl($srchUrl, $this->_3); // 3
        $this->buildSearchUrl($srchUrl, $this->m_3); // m_3
        $this->buildSearchUrl($srchUrl, $this->_4); // 4
        $this->buildSearchUrl($srchUrl, $this->m_4); // m_4
        $this->buildSearchUrl($srchUrl, $this->_5); // 5
        $this->buildSearchUrl($srchUrl, $this->m_5); // m_5
        $this->buildSearchUrl($srchUrl, $this->_6); // 6
        $this->buildSearchUrl($srchUrl, $this->m_6); // m_6
        $this->buildSearchUrl($srchUrl, $this->_7); // 7
        $this->buildSearchUrl($srchUrl, $this->m_7); // m_7
        $this->buildSearchUrl($srchUrl, $this->_8); // 8
        $this->buildSearchUrl($srchUrl, $this->m_8); // m_8
        $this->buildSearchUrl($srchUrl, $this->_9); // 9
        $this->buildSearchUrl($srchUrl, $this->m_9); // m_9
        $this->buildSearchUrl($srchUrl, $this->_10); // 10
        $this->buildSearchUrl($srchUrl, $this->m_10); // m_10
        $this->buildSearchUrl($srchUrl, $this->_11); // 11
        $this->buildSearchUrl($srchUrl, $this->m_11); // m_11
        $this->buildSearchUrl($srchUrl, $this->_12); // 12
        $this->buildSearchUrl($srchUrl, $this->m_12); // m_12
        $this->buildSearchUrl($srchUrl, $this->_13); // 13
        $this->buildSearchUrl($srchUrl, $this->m_13); // m_13
        $this->buildSearchUrl($srchUrl, $this->_14); // 14
        $this->buildSearchUrl($srchUrl, $this->m_14); // m_14
        $this->buildSearchUrl($srchUrl, $this->_15); // 15
        $this->buildSearchUrl($srchUrl, $this->m_15); // m_15
        $this->buildSearchUrl($srchUrl, $this->_16); // 16
        $this->buildSearchUrl($srchUrl, $this->m_16); // m_16
        $this->buildSearchUrl($srchUrl, $this->_17); // 17
        $this->buildSearchUrl($srchUrl, $this->m_17); // m_17
        $this->buildSearchUrl($srchUrl, $this->_18); // 18
        $this->buildSearchUrl($srchUrl, $this->m_18); // m_18
        $this->buildSearchUrl($srchUrl, $this->_19); // 19
        $this->buildSearchUrl($srchUrl, $this->m_19); // m_19
        $this->buildSearchUrl($srchUrl, $this->_20); // 20
        $this->buildSearchUrl($srchUrl, $this->m_20); // m_20
        $this->buildSearchUrl($srchUrl, $this->_21); // 21
        $this->buildSearchUrl($srchUrl, $this->m_21); // m_21
        $this->buildSearchUrl($srchUrl, $this->_22); // 22
        $this->buildSearchUrl($srchUrl, $this->m_22); // m_22
        $this->buildSearchUrl($srchUrl, $this->_23); // 23
        $this->buildSearchUrl($srchUrl, $this->m_23); // m_23
        $this->buildSearchUrl($srchUrl, $this->_24); // 24
        $this->buildSearchUrl($srchUrl, $this->m_24); // m_24
        $this->buildSearchUrl($srchUrl, $this->_25); // 25
        $this->buildSearchUrl($srchUrl, $this->m_25); // m_25
        $this->buildSearchUrl($srchUrl, $this->_26); // 26
        $this->buildSearchUrl($srchUrl, $this->m_26); // m_26
        $this->buildSearchUrl($srchUrl, $this->_27); // 27
        $this->buildSearchUrl($srchUrl, $this->m_27); // m_27
        $this->buildSearchUrl($srchUrl, $this->_28); // 28
        $this->buildSearchUrl($srchUrl, $this->m_28); // m_28
        $this->buildSearchUrl($srchUrl, $this->_29); // 29
        $this->buildSearchUrl($srchUrl, $this->m_29); // m_29
        $this->buildSearchUrl($srchUrl, $this->_30); // 30
        $this->buildSearchUrl($srchUrl, $this->m_30); // m_30
        $this->buildSearchUrl($srchUrl, $this->_31); // 31
        $this->buildSearchUrl($srchUrl, $this->m_31); // m_31
        $this->buildSearchUrl($srchUrl, $this->_32); // 32
        $this->buildSearchUrl($srchUrl, $this->m_32); // m_32
        $this->buildSearchUrl($srchUrl, $this->_33); // 33
        $this->buildSearchUrl($srchUrl, $this->m_33); // m_33
        $this->buildSearchUrl($srchUrl, $this->_34); // 34
        $this->buildSearchUrl($srchUrl, $this->m_34); // m_34
        $this->buildSearchUrl($srchUrl, $this->_35); // 35
        $this->buildSearchUrl($srchUrl, $this->m_35); // m_35
        $this->buildSearchUrl($srchUrl, $this->_36); // 36
        $this->buildSearchUrl($srchUrl, $this->m_36); // m_36
        $this->buildSearchUrl($srchUrl, $this->_37); // 37
        $this->buildSearchUrl($srchUrl, $this->m_37); // m_37
        $this->buildSearchUrl($srchUrl, $this->_38); // 38
        $this->buildSearchUrl($srchUrl, $this->m_38); // m_38
        $this->buildSearchUrl($srchUrl, $this->_39); // 39
        $this->buildSearchUrl($srchUrl, $this->m_39); // m_39
        $this->buildSearchUrl($srchUrl, $this->_40); // 40
        $this->buildSearchUrl($srchUrl, $this->m_40); // m_40
        $this->buildSearchUrl($srchUrl, $this->_41); // 41
        $this->buildSearchUrl($srchUrl, $this->m_41); // m_41
        $this->buildSearchUrl($srchUrl, $this->_42); // 42
        $this->buildSearchUrl($srchUrl, $this->m_42); // m_42
        $this->buildSearchUrl($srchUrl, $this->_43); // 43
        $this->buildSearchUrl($srchUrl, $this->m_43); // m_43
        $this->buildSearchUrl($srchUrl, $this->_44); // 44
        $this->buildSearchUrl($srchUrl, $this->m_44); // m_44
        $this->buildSearchUrl($srchUrl, $this->_45); // 45
        $this->buildSearchUrl($srchUrl, $this->m_45); // m_45
        $this->buildSearchUrl($srchUrl, $this->_46); // 46
        $this->buildSearchUrl($srchUrl, $this->m_46); // m_46
        $this->buildSearchUrl($srchUrl, $this->_47); // 47
        $this->buildSearchUrl($srchUrl, $this->m_47); // m_47
        $this->buildSearchUrl($srchUrl, $this->_48); // 48
        $this->buildSearchUrl($srchUrl, $this->m_48); // m_48
        $this->buildSearchUrl($srchUrl, $this->_49); // 49
        $this->buildSearchUrl($srchUrl, $this->m_49); // m_49
        $this->buildSearchUrl($srchUrl, $this->_50); // 50
        $this->buildSearchUrl($srchUrl, $this->m_50); // m_50
        $this->buildSearchUrl($srchUrl, $this->_51); // 51
        $this->buildSearchUrl($srchUrl, $this->m_51); // m_51
        $this->buildSearchUrl($srchUrl, $this->_52); // 52
        $this->buildSearchUrl($srchUrl, $this->m_52); // m_52
        $this->buildSearchUrl($srchUrl, $this->_53); // 53
        $this->buildSearchUrl($srchUrl, $this->m_53); // m_53
        $this->buildSearchUrl($srchUrl, $this->_54); // 54
        $this->buildSearchUrl($srchUrl, $this->m_54); // m_54
        $this->buildSearchUrl($srchUrl, $this->_55); // 55
        $this->buildSearchUrl($srchUrl, $this->m_55); // m_55
        $this->buildSearchUrl($srchUrl, $this->_56); // 56
        $this->buildSearchUrl($srchUrl, $this->m_56); // m_56
        $this->buildSearchUrl($srchUrl, $this->_57); // 57
        $this->buildSearchUrl($srchUrl, $this->m_57); // m_57
        $this->buildSearchUrl($srchUrl, $this->_58); // 58
        $this->buildSearchUrl($srchUrl, $this->m_58); // m_58
        $this->buildSearchUrl($srchUrl, $this->_59); // 59
        $this->buildSearchUrl($srchUrl, $this->m_59); // m_59
        $this->buildSearchUrl($srchUrl, $this->_60); // 60
        $this->buildSearchUrl($srchUrl, $this->m_60); // m_60
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // roll_no
        if ($this->roll_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // test_id
        if ($this->test_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // total
        if ($this->total->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // percent
        if ($this->percent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_1
        if ($this->s_1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_2
        if ($this->s_2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_3
        if ($this->s_3->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_4
        if ($this->s_4->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_5
        if ($this->s_5->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // omr_image
        if ($this->omr_image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 1
        if ($this->_1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_1
        if ($this->m_1->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 2
        if ($this->_2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_2
        if ($this->m_2->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 3
        if ($this->_3->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_3
        if ($this->m_3->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 4
        if ($this->_4->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_4
        if ($this->m_4->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 5
        if ($this->_5->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_5
        if ($this->m_5->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 6
        if ($this->_6->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_6
        if ($this->m_6->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 7
        if ($this->_7->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_7
        if ($this->m_7->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 8
        if ($this->_8->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_8
        if ($this->m_8->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 9
        if ($this->_9->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_9
        if ($this->m_9->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 10
        if ($this->_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_10
        if ($this->m_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 11
        if ($this->_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_11
        if ($this->m_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 12
        if ($this->_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_12
        if ($this->m_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 13
        if ($this->_13->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_13
        if ($this->m_13->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 14
        if ($this->_14->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_14
        if ($this->m_14->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 15
        if ($this->_15->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_15
        if ($this->m_15->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 16
        if ($this->_16->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_16
        if ($this->m_16->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 17
        if ($this->_17->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_17
        if ($this->m_17->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 18
        if ($this->_18->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_18
        if ($this->m_18->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 19
        if ($this->_19->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_19
        if ($this->m_19->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 20
        if ($this->_20->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_20
        if ($this->m_20->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 21
        if ($this->_21->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_21
        if ($this->m_21->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 22
        if ($this->_22->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_22
        if ($this->m_22->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 23
        if ($this->_23->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_23
        if ($this->m_23->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 24
        if ($this->_24->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_24
        if ($this->m_24->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 25
        if ($this->_25->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_25
        if ($this->m_25->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 26
        if ($this->_26->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_26
        if ($this->m_26->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 27
        if ($this->_27->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_27
        if ($this->m_27->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 28
        if ($this->_28->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_28
        if ($this->m_28->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 29
        if ($this->_29->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_29
        if ($this->m_29->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 30
        if ($this->_30->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_30
        if ($this->m_30->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 31
        if ($this->_31->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_31
        if ($this->m_31->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 32
        if ($this->_32->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_32
        if ($this->m_32->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 33
        if ($this->_33->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_33
        if ($this->m_33->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 34
        if ($this->_34->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_34
        if ($this->m_34->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 35
        if ($this->_35->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_35
        if ($this->m_35->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 36
        if ($this->_36->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_36
        if ($this->m_36->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 37
        if ($this->_37->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_37
        if ($this->m_37->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 38
        if ($this->_38->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_38
        if ($this->m_38->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 39
        if ($this->_39->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_39
        if ($this->m_39->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 40
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_40
        if ($this->m_40->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 41
        if ($this->_41->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_41
        if ($this->m_41->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 42
        if ($this->_42->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_42
        if ($this->m_42->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 43
        if ($this->_43->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_43
        if ($this->m_43->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 44
        if ($this->_44->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_44
        if ($this->m_44->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 45
        if ($this->_45->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_45
        if ($this->m_45->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 46
        if ($this->_46->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_46
        if ($this->m_46->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 47
        if ($this->_47->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_47
        if ($this->m_47->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 48
        if ($this->_48->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_48
        if ($this->m_48->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 49
        if ($this->_49->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_49
        if ($this->m_49->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 50
        if ($this->_50->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_50
        if ($this->m_50->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 51
        if ($this->_51->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_51
        if ($this->m_51->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 52
        if ($this->_52->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_52
        if ($this->m_52->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 53
        if ($this->_53->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_53
        if ($this->m_53->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 54
        if ($this->_54->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_54
        if ($this->m_54->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 55
        if ($this->_55->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_55
        if ($this->m_55->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 56
        if ($this->_56->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_56
        if ($this->m_56->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 57
        if ($this->_57->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_57
        if ($this->m_57->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 58
        if ($this->_58->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_58
        if ($this->m_58->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 59
        if ($this->_59->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_59
        if ($this->m_59->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // 60
        if ($this->_60->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // m_60
        if ($this->m_60->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // test_id
        $this->test_id->RowCssClass = "row";

        // total
        $this->total->RowCssClass = "row";

        // percent
        $this->percent->RowCssClass = "row";

        // s_1
        $this->s_1->RowCssClass = "row";

        // s_2
        $this->s_2->RowCssClass = "row";

        // s_3
        $this->s_3->RowCssClass = "row";

        // s_4
        $this->s_4->RowCssClass = "row";

        // s_5
        $this->s_5->RowCssClass = "row";

        // omr_image
        $this->omr_image->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // m_1
        $this->m_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // m_2
        $this->m_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // m_3
        $this->m_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // m_4
        $this->m_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // m_5
        $this->m_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // m_6
        $this->m_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // m_7
        $this->m_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // m_8
        $this->m_8->RowCssClass = "row";

        // 9
        $this->_9->RowCssClass = "row";

        // m_9
        $this->m_9->RowCssClass = "row";

        // 10
        $this->_10->RowCssClass = "row";

        // m_10
        $this->m_10->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // m_11
        $this->m_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // m_12
        $this->m_12->RowCssClass = "row";

        // 13
        $this->_13->RowCssClass = "row";

        // m_13
        $this->m_13->RowCssClass = "row";

        // 14
        $this->_14->RowCssClass = "row";

        // m_14
        $this->m_14->RowCssClass = "row";

        // 15
        $this->_15->RowCssClass = "row";

        // m_15
        $this->m_15->RowCssClass = "row";

        // 16
        $this->_16->RowCssClass = "row";

        // m_16
        $this->m_16->RowCssClass = "row";

        // 17
        $this->_17->RowCssClass = "row";

        // m_17
        $this->m_17->RowCssClass = "row";

        // 18
        $this->_18->RowCssClass = "row";

        // m_18
        $this->m_18->RowCssClass = "row";

        // 19
        $this->_19->RowCssClass = "row";

        // m_19
        $this->m_19->RowCssClass = "row";

        // 20
        $this->_20->RowCssClass = "row";

        // m_20
        $this->m_20->RowCssClass = "row";

        // 21
        $this->_21->RowCssClass = "row";

        // m_21
        $this->m_21->RowCssClass = "row";

        // 22
        $this->_22->RowCssClass = "row";

        // m_22
        $this->m_22->RowCssClass = "row";

        // 23
        $this->_23->RowCssClass = "row";

        // m_23
        $this->m_23->RowCssClass = "row";

        // 24
        $this->_24->RowCssClass = "row";

        // m_24
        $this->m_24->RowCssClass = "row";

        // 25
        $this->_25->RowCssClass = "row";

        // m_25
        $this->m_25->RowCssClass = "row";

        // 26
        $this->_26->RowCssClass = "row";

        // m_26
        $this->m_26->RowCssClass = "row";

        // 27
        $this->_27->RowCssClass = "row";

        // m_27
        $this->m_27->RowCssClass = "row";

        // 28
        $this->_28->RowCssClass = "row";

        // m_28
        $this->m_28->RowCssClass = "row";

        // 29
        $this->_29->RowCssClass = "row";

        // m_29
        $this->m_29->RowCssClass = "row";

        // 30
        $this->_30->RowCssClass = "row";

        // m_30
        $this->m_30->RowCssClass = "row";

        // 31
        $this->_31->RowCssClass = "row";

        // m_31
        $this->m_31->RowCssClass = "row";

        // 32
        $this->_32->RowCssClass = "row";

        // m_32
        $this->m_32->RowCssClass = "row";

        // 33
        $this->_33->RowCssClass = "row";

        // m_33
        $this->m_33->RowCssClass = "row";

        // 34
        $this->_34->RowCssClass = "row";

        // m_34
        $this->m_34->RowCssClass = "row";

        // 35
        $this->_35->RowCssClass = "row";

        // m_35
        $this->m_35->RowCssClass = "row";

        // 36
        $this->_36->RowCssClass = "row";

        // m_36
        $this->m_36->RowCssClass = "row";

        // 37
        $this->_37->RowCssClass = "row";

        // m_37
        $this->m_37->RowCssClass = "row";

        // 38
        $this->_38->RowCssClass = "row";

        // m_38
        $this->m_38->RowCssClass = "row";

        // 39
        $this->_39->RowCssClass = "row";

        // m_39
        $this->m_39->RowCssClass = "row";

        // 40
        $this->_40->RowCssClass = "row";

        // m_40
        $this->m_40->RowCssClass = "row";

        // 41
        $this->_41->RowCssClass = "row";

        // m_41
        $this->m_41->RowCssClass = "row";

        // 42
        $this->_42->RowCssClass = "row";

        // m_42
        $this->m_42->RowCssClass = "row";

        // 43
        $this->_43->RowCssClass = "row";

        // m_43
        $this->m_43->RowCssClass = "row";

        // 44
        $this->_44->RowCssClass = "row";

        // m_44
        $this->m_44->RowCssClass = "row";

        // 45
        $this->_45->RowCssClass = "row";

        // m_45
        $this->m_45->RowCssClass = "row";

        // 46
        $this->_46->RowCssClass = "row";

        // m_46
        $this->m_46->RowCssClass = "row";

        // 47
        $this->_47->RowCssClass = "row";

        // m_47
        $this->m_47->RowCssClass = "row";

        // 48
        $this->_48->RowCssClass = "row";

        // m_48
        $this->m_48->RowCssClass = "row";

        // 49
        $this->_49->RowCssClass = "row";

        // m_49
        $this->m_49->RowCssClass = "row";

        // 50
        $this->_50->RowCssClass = "row";

        // m_50
        $this->m_50->RowCssClass = "row";

        // 51
        $this->_51->RowCssClass = "row";

        // m_51
        $this->m_51->RowCssClass = "row";

        // 52
        $this->_52->RowCssClass = "row";

        // m_52
        $this->m_52->RowCssClass = "row";

        // 53
        $this->_53->RowCssClass = "row";

        // m_53
        $this->m_53->RowCssClass = "row";

        // 54
        $this->_54->RowCssClass = "row";

        // m_54
        $this->m_54->RowCssClass = "row";

        // 55
        $this->_55->RowCssClass = "row";

        // m_55
        $this->m_55->RowCssClass = "row";

        // 56
        $this->_56->RowCssClass = "row";

        // m_56
        $this->m_56->RowCssClass = "row";

        // 57
        $this->_57->RowCssClass = "row";

        // m_57
        $this->m_57->RowCssClass = "row";

        // 58
        $this->_58->RowCssClass = "row";

        // m_58
        $this->m_58->RowCssClass = "row";

        // 59
        $this->_59->RowCssClass = "row";

        // m_59
        $this->m_59->RowCssClass = "row";

        // 60
        $this->_60->RowCssClass = "row";

        // m_60
        $this->m_60->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;

            // test_id
            $this->test_id->ViewValue = $this->test_id->CurrentValue;

            // total
            $this->total->ViewValue = $this->total->CurrentValue;
            $this->total->ViewValue = FormatNumber($this->total->ViewValue, $this->total->formatPattern());

            // percent
            $this->percent->ViewValue = $this->percent->CurrentValue;
            $this->percent->ViewValue = FormatNumber($this->percent->ViewValue, $this->percent->formatPattern());

            // s_1
            $this->s_1->ViewValue = $this->s_1->CurrentValue;
            $this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, $this->s_1->formatPattern());

            // s_2
            $this->s_2->ViewValue = $this->s_2->CurrentValue;
            $this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, $this->s_2->formatPattern());

            // s_3
            $this->s_3->ViewValue = $this->s_3->CurrentValue;
            $this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, $this->s_3->formatPattern());

            // s_4
            $this->s_4->ViewValue = $this->s_4->CurrentValue;
            $this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, $this->s_4->formatPattern());

            // s_5
            $this->s_5->ViewValue = $this->s_5->CurrentValue;
            $this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, $this->s_5->formatPattern());

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->ImageWidth = 0;
                $this->omr_image->ImageHeight = 50;
                $this->omr_image->ImageAlt = $this->omr_image->alt();
                $this->omr_image->ImageCssClass = "ew-image";
                $this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
            } else {
                $this->omr_image->ViewValue = "";
            }

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // m_1
            $this->m_1->ViewValue = $this->m_1->CurrentValue;
            $this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, $this->m_1->formatPattern());

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // m_2
            $this->m_2->ViewValue = $this->m_2->CurrentValue;
            $this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, $this->m_2->formatPattern());

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // m_3
            $this->m_3->ViewValue = $this->m_3->CurrentValue;
            $this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, $this->m_3->formatPattern());

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // m_4
            $this->m_4->ViewValue = $this->m_4->CurrentValue;
            $this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, $this->m_4->formatPattern());

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // m_5
            $this->m_5->ViewValue = $this->m_5->CurrentValue;
            $this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, $this->m_5->formatPattern());

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // m_6
            $this->m_6->ViewValue = $this->m_6->CurrentValue;
            $this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, $this->m_6->formatPattern());

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // m_7
            $this->m_7->ViewValue = $this->m_7->CurrentValue;
            $this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, $this->m_7->formatPattern());

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // m_8
            $this->m_8->ViewValue = $this->m_8->CurrentValue;
            $this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, $this->m_8->formatPattern());

            // 9
            $this->_9->ViewValue = $this->_9->CurrentValue;

            // m_9
            $this->m_9->ViewValue = $this->m_9->CurrentValue;
            $this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, $this->m_9->formatPattern());

            // 10
            $this->_10->ViewValue = $this->_10->CurrentValue;

            // m_10
            $this->m_10->ViewValue = $this->m_10->CurrentValue;
            $this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, $this->m_10->formatPattern());

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // m_11
            $this->m_11->ViewValue = $this->m_11->CurrentValue;
            $this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, $this->m_11->formatPattern());

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // m_12
            $this->m_12->ViewValue = $this->m_12->CurrentValue;
            $this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, $this->m_12->formatPattern());

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // m_13
            $this->m_13->ViewValue = $this->m_13->CurrentValue;
            $this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, $this->m_13->formatPattern());

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // m_14
            $this->m_14->ViewValue = $this->m_14->CurrentValue;
            $this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, $this->m_14->formatPattern());

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // m_15
            $this->m_15->ViewValue = $this->m_15->CurrentValue;
            $this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, $this->m_15->formatPattern());

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // m_16
            $this->m_16->ViewValue = $this->m_16->CurrentValue;
            $this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, $this->m_16->formatPattern());

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // m_17
            $this->m_17->ViewValue = $this->m_17->CurrentValue;
            $this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, $this->m_17->formatPattern());

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // m_18
            $this->m_18->ViewValue = $this->m_18->CurrentValue;
            $this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, $this->m_18->formatPattern());

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // m_19
            $this->m_19->ViewValue = $this->m_19->CurrentValue;
            $this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, $this->m_19->formatPattern());

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // m_20
            $this->m_20->ViewValue = $this->m_20->CurrentValue;
            $this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, $this->m_20->formatPattern());

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // m_21
            $this->m_21->ViewValue = $this->m_21->CurrentValue;
            $this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, $this->m_21->formatPattern());

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // m_22
            $this->m_22->ViewValue = $this->m_22->CurrentValue;
            $this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, $this->m_22->formatPattern());

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // m_23
            $this->m_23->ViewValue = $this->m_23->CurrentValue;
            $this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, $this->m_23->formatPattern());

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // m_24
            $this->m_24->ViewValue = $this->m_24->CurrentValue;
            $this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, $this->m_24->formatPattern());

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // m_25
            $this->m_25->ViewValue = $this->m_25->CurrentValue;
            $this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, $this->m_25->formatPattern());

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // m_26
            $this->m_26->ViewValue = $this->m_26->CurrentValue;
            $this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, $this->m_26->formatPattern());

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // m_27
            $this->m_27->ViewValue = $this->m_27->CurrentValue;
            $this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, $this->m_27->formatPattern());

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // m_28
            $this->m_28->ViewValue = $this->m_28->CurrentValue;
            $this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, $this->m_28->formatPattern());

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // m_29
            $this->m_29->ViewValue = $this->m_29->CurrentValue;
            $this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, $this->m_29->formatPattern());

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // m_30
            $this->m_30->ViewValue = $this->m_30->CurrentValue;
            $this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, $this->m_30->formatPattern());

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // m_31
            $this->m_31->ViewValue = $this->m_31->CurrentValue;
            $this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, $this->m_31->formatPattern());

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // m_32
            $this->m_32->ViewValue = $this->m_32->CurrentValue;
            $this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, $this->m_32->formatPattern());

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // m_33
            $this->m_33->ViewValue = $this->m_33->CurrentValue;
            $this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, $this->m_33->formatPattern());

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // m_34
            $this->m_34->ViewValue = $this->m_34->CurrentValue;
            $this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, $this->m_34->formatPattern());

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // m_35
            $this->m_35->ViewValue = $this->m_35->CurrentValue;
            $this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, $this->m_35->formatPattern());

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // m_36
            $this->m_36->ViewValue = $this->m_36->CurrentValue;
            $this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, $this->m_36->formatPattern());

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // m_37
            $this->m_37->ViewValue = $this->m_37->CurrentValue;
            $this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, $this->m_37->formatPattern());

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // m_38
            $this->m_38->ViewValue = $this->m_38->CurrentValue;
            $this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, $this->m_38->formatPattern());

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // m_39
            $this->m_39->ViewValue = $this->m_39->CurrentValue;
            $this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, $this->m_39->formatPattern());

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // m_40
            $this->m_40->ViewValue = $this->m_40->CurrentValue;
            $this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, $this->m_40->formatPattern());

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // m_41
            $this->m_41->ViewValue = $this->m_41->CurrentValue;
            $this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, $this->m_41->formatPattern());

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // m_42
            $this->m_42->ViewValue = $this->m_42->CurrentValue;
            $this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, $this->m_42->formatPattern());

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // m_43
            $this->m_43->ViewValue = $this->m_43->CurrentValue;
            $this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, $this->m_43->formatPattern());

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // m_44
            $this->m_44->ViewValue = $this->m_44->CurrentValue;
            $this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, $this->m_44->formatPattern());

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // m_45
            $this->m_45->ViewValue = $this->m_45->CurrentValue;
            $this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, $this->m_45->formatPattern());

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // m_46
            $this->m_46->ViewValue = $this->m_46->CurrentValue;
            $this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, $this->m_46->formatPattern());

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // m_47
            $this->m_47->ViewValue = $this->m_47->CurrentValue;
            $this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, $this->m_47->formatPattern());

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // m_48
            $this->m_48->ViewValue = $this->m_48->CurrentValue;
            $this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, $this->m_48->formatPattern());

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // m_49
            $this->m_49->ViewValue = $this->m_49->CurrentValue;
            $this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, $this->m_49->formatPattern());

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // m_50
            $this->m_50->ViewValue = $this->m_50->CurrentValue;
            $this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, $this->m_50->formatPattern());

            // 51
            $this->_51->ViewValue = $this->_51->CurrentValue;

            // m_51
            $this->m_51->ViewValue = $this->m_51->CurrentValue;
            $this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, $this->m_51->formatPattern());

            // 52
            $this->_52->ViewValue = $this->_52->CurrentValue;

            // m_52
            $this->m_52->ViewValue = $this->m_52->CurrentValue;
            $this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, $this->m_52->formatPattern());

            // 53
            $this->_53->ViewValue = $this->_53->CurrentValue;

            // m_53
            $this->m_53->ViewValue = $this->m_53->CurrentValue;
            $this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, $this->m_53->formatPattern());

            // 54
            $this->_54->ViewValue = $this->_54->CurrentValue;

            // m_54
            $this->m_54->ViewValue = $this->m_54->CurrentValue;
            $this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, $this->m_54->formatPattern());

            // 55
            $this->_55->ViewValue = $this->_55->CurrentValue;

            // m_55
            $this->m_55->ViewValue = $this->m_55->CurrentValue;
            $this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, $this->m_55->formatPattern());

            // 56
            $this->_56->ViewValue = $this->_56->CurrentValue;

            // m_56
            $this->m_56->ViewValue = $this->m_56->CurrentValue;
            $this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, $this->m_56->formatPattern());

            // 57
            $this->_57->ViewValue = $this->_57->CurrentValue;

            // m_57
            $this->m_57->ViewValue = $this->m_57->CurrentValue;
            $this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, $this->m_57->formatPattern());

            // 58
            $this->_58->ViewValue = $this->_58->CurrentValue;

            // m_58
            $this->m_58->ViewValue = $this->m_58->CurrentValue;
            $this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, $this->m_58->formatPattern());

            // 59
            $this->_59->ViewValue = $this->_59->CurrentValue;

            // m_59
            $this->m_59->ViewValue = $this->m_59->CurrentValue;
            $this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, $this->m_59->formatPattern());

            // 60
            $this->_60->ViewValue = $this->_60->CurrentValue;

            // m_60
            $this->m_60->ViewValue = $this->m_60->CurrentValue;
            $this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, $this->m_60->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // test_id
            $this->test_id->HrefValue = "";
            $this->test_id->TooltipValue = "";

            // total
            $this->total->HrefValue = "";
            $this->total->TooltipValue = "";

            // percent
            $this->percent->HrefValue = "";
            $this->percent->TooltipValue = "";

            // s_1
            $this->s_1->HrefValue = "";
            $this->s_1->TooltipValue = "";

            // s_2
            $this->s_2->HrefValue = "";
            $this->s_2->TooltipValue = "";

            // s_3
            $this->s_3->HrefValue = "";
            $this->s_3->TooltipValue = "";

            // s_4
            $this->s_4->HrefValue = "";
            $this->s_4->TooltipValue = "";

            // s_5
            $this->s_5->HrefValue = "";
            $this->s_5->TooltipValue = "";

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->htmlDecode($this->omr_image->Upload->DbValue)); // Add prefix/suffix
                $this->omr_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
                }
            } else {
                $this->omr_image->HrefValue = "";
            }
            $this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;
            $this->omr_image->TooltipValue = "";
            if ($this->omr_image->UseColorbox) {
                if (EmptyValue($this->omr_image->TooltipValue)) {
                    $this->omr_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->omr_image->LinkAttrs["data-rel"] = "s_omr_value_x_omr_image";
                $this->omr_image->LinkAttrs->appendClass("ew-lightbox");
            }

            // 1
            $this->_1->HrefValue = "";
            $this->_1->TooltipValue = "";

            // m_1
            $this->m_1->HrefValue = "";
            $this->m_1->TooltipValue = "";

            // 2
            $this->_2->HrefValue = "";
            $this->_2->TooltipValue = "";

            // m_2
            $this->m_2->HrefValue = "";
            $this->m_2->TooltipValue = "";

            // 3
            $this->_3->HrefValue = "";
            $this->_3->TooltipValue = "";

            // m_3
            $this->m_3->HrefValue = "";
            $this->m_3->TooltipValue = "";

            // 4
            $this->_4->HrefValue = "";
            $this->_4->TooltipValue = "";

            // m_4
            $this->m_4->HrefValue = "";
            $this->m_4->TooltipValue = "";

            // 5
            $this->_5->HrefValue = "";
            $this->_5->TooltipValue = "";

            // m_5
            $this->m_5->HrefValue = "";
            $this->m_5->TooltipValue = "";

            // 6
            $this->_6->HrefValue = "";
            $this->_6->TooltipValue = "";

            // m_6
            $this->m_6->HrefValue = "";
            $this->m_6->TooltipValue = "";

            // 7
            $this->_7->HrefValue = "";
            $this->_7->TooltipValue = "";

            // m_7
            $this->m_7->HrefValue = "";
            $this->m_7->TooltipValue = "";

            // 8
            $this->_8->HrefValue = "";
            $this->_8->TooltipValue = "";

            // m_8
            $this->m_8->HrefValue = "";
            $this->m_8->TooltipValue = "";

            // 9
            $this->_9->HrefValue = "";
            $this->_9->TooltipValue = "";

            // m_9
            $this->m_9->HrefValue = "";
            $this->m_9->TooltipValue = "";

            // 10
            $this->_10->HrefValue = "";
            $this->_10->TooltipValue = "";

            // m_10
            $this->m_10->HrefValue = "";
            $this->m_10->TooltipValue = "";

            // 11
            $this->_11->HrefValue = "";
            $this->_11->TooltipValue = "";

            // m_11
            $this->m_11->HrefValue = "";
            $this->m_11->TooltipValue = "";

            // 12
            $this->_12->HrefValue = "";
            $this->_12->TooltipValue = "";

            // m_12
            $this->m_12->HrefValue = "";
            $this->m_12->TooltipValue = "";

            // 13
            $this->_13->HrefValue = "";
            $this->_13->TooltipValue = "";

            // m_13
            $this->m_13->HrefValue = "";
            $this->m_13->TooltipValue = "";

            // 14
            $this->_14->HrefValue = "";
            $this->_14->TooltipValue = "";

            // m_14
            $this->m_14->HrefValue = "";
            $this->m_14->TooltipValue = "";

            // 15
            $this->_15->HrefValue = "";
            $this->_15->TooltipValue = "";

            // m_15
            $this->m_15->HrefValue = "";
            $this->m_15->TooltipValue = "";

            // 16
            $this->_16->HrefValue = "";
            $this->_16->TooltipValue = "";

            // m_16
            $this->m_16->HrefValue = "";
            $this->m_16->TooltipValue = "";

            // 17
            $this->_17->HrefValue = "";
            $this->_17->TooltipValue = "";

            // m_17
            $this->m_17->HrefValue = "";
            $this->m_17->TooltipValue = "";

            // 18
            $this->_18->HrefValue = "";
            $this->_18->TooltipValue = "";

            // m_18
            $this->m_18->HrefValue = "";
            $this->m_18->TooltipValue = "";

            // 19
            $this->_19->HrefValue = "";
            $this->_19->TooltipValue = "";

            // m_19
            $this->m_19->HrefValue = "";
            $this->m_19->TooltipValue = "";

            // 20
            $this->_20->HrefValue = "";
            $this->_20->TooltipValue = "";

            // m_20
            $this->m_20->HrefValue = "";
            $this->m_20->TooltipValue = "";

            // 21
            $this->_21->HrefValue = "";
            $this->_21->TooltipValue = "";

            // m_21
            $this->m_21->HrefValue = "";
            $this->m_21->TooltipValue = "";

            // 22
            $this->_22->HrefValue = "";
            $this->_22->TooltipValue = "";

            // m_22
            $this->m_22->HrefValue = "";
            $this->m_22->TooltipValue = "";

            // 23
            $this->_23->HrefValue = "";
            $this->_23->TooltipValue = "";

            // m_23
            $this->m_23->HrefValue = "";
            $this->m_23->TooltipValue = "";

            // 24
            $this->_24->HrefValue = "";
            $this->_24->TooltipValue = "";

            // m_24
            $this->m_24->HrefValue = "";
            $this->m_24->TooltipValue = "";

            // 25
            $this->_25->HrefValue = "";
            $this->_25->TooltipValue = "";

            // m_25
            $this->m_25->HrefValue = "";
            $this->m_25->TooltipValue = "";

            // 26
            $this->_26->HrefValue = "";
            $this->_26->TooltipValue = "";

            // m_26
            $this->m_26->HrefValue = "";
            $this->m_26->TooltipValue = "";

            // 27
            $this->_27->HrefValue = "";
            $this->_27->TooltipValue = "";

            // m_27
            $this->m_27->HrefValue = "";
            $this->m_27->TooltipValue = "";

            // 28
            $this->_28->HrefValue = "";
            $this->_28->TooltipValue = "";

            // m_28
            $this->m_28->HrefValue = "";
            $this->m_28->TooltipValue = "";

            // 29
            $this->_29->HrefValue = "";
            $this->_29->TooltipValue = "";

            // m_29
            $this->m_29->HrefValue = "";
            $this->m_29->TooltipValue = "";

            // 30
            $this->_30->HrefValue = "";
            $this->_30->TooltipValue = "";

            // m_30
            $this->m_30->HrefValue = "";
            $this->m_30->TooltipValue = "";

            // 31
            $this->_31->HrefValue = "";
            $this->_31->TooltipValue = "";

            // m_31
            $this->m_31->HrefValue = "";
            $this->m_31->TooltipValue = "";

            // 32
            $this->_32->HrefValue = "";
            $this->_32->TooltipValue = "";

            // m_32
            $this->m_32->HrefValue = "";
            $this->m_32->TooltipValue = "";

            // 33
            $this->_33->HrefValue = "";
            $this->_33->TooltipValue = "";

            // m_33
            $this->m_33->HrefValue = "";
            $this->m_33->TooltipValue = "";

            // 34
            $this->_34->HrefValue = "";
            $this->_34->TooltipValue = "";

            // m_34
            $this->m_34->HrefValue = "";
            $this->m_34->TooltipValue = "";

            // 35
            $this->_35->HrefValue = "";
            $this->_35->TooltipValue = "";

            // m_35
            $this->m_35->HrefValue = "";
            $this->m_35->TooltipValue = "";

            // 36
            $this->_36->HrefValue = "";
            $this->_36->TooltipValue = "";

            // m_36
            $this->m_36->HrefValue = "";
            $this->m_36->TooltipValue = "";

            // 37
            $this->_37->HrefValue = "";
            $this->_37->TooltipValue = "";

            // m_37
            $this->m_37->HrefValue = "";
            $this->m_37->TooltipValue = "";

            // 38
            $this->_38->HrefValue = "";
            $this->_38->TooltipValue = "";

            // m_38
            $this->m_38->HrefValue = "";
            $this->m_38->TooltipValue = "";

            // 39
            $this->_39->HrefValue = "";
            $this->_39->TooltipValue = "";

            // m_39
            $this->m_39->HrefValue = "";
            $this->m_39->TooltipValue = "";

            // 40
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // m_40
            $this->m_40->HrefValue = "";
            $this->m_40->TooltipValue = "";

            // 41
            $this->_41->HrefValue = "";
            $this->_41->TooltipValue = "";

            // m_41
            $this->m_41->HrefValue = "";
            $this->m_41->TooltipValue = "";

            // 42
            $this->_42->HrefValue = "";
            $this->_42->TooltipValue = "";

            // m_42
            $this->m_42->HrefValue = "";
            $this->m_42->TooltipValue = "";

            // 43
            $this->_43->HrefValue = "";
            $this->_43->TooltipValue = "";

            // m_43
            $this->m_43->HrefValue = "";
            $this->m_43->TooltipValue = "";

            // 44
            $this->_44->HrefValue = "";
            $this->_44->TooltipValue = "";

            // m_44
            $this->m_44->HrefValue = "";
            $this->m_44->TooltipValue = "";

            // 45
            $this->_45->HrefValue = "";
            $this->_45->TooltipValue = "";

            // m_45
            $this->m_45->HrefValue = "";
            $this->m_45->TooltipValue = "";

            // 46
            $this->_46->HrefValue = "";
            $this->_46->TooltipValue = "";

            // m_46
            $this->m_46->HrefValue = "";
            $this->m_46->TooltipValue = "";

            // 47
            $this->_47->HrefValue = "";
            $this->_47->TooltipValue = "";

            // m_47
            $this->m_47->HrefValue = "";
            $this->m_47->TooltipValue = "";

            // 48
            $this->_48->HrefValue = "";
            $this->_48->TooltipValue = "";

            // m_48
            $this->m_48->HrefValue = "";
            $this->m_48->TooltipValue = "";

            // 49
            $this->_49->HrefValue = "";
            $this->_49->TooltipValue = "";

            // m_49
            $this->m_49->HrefValue = "";
            $this->m_49->TooltipValue = "";

            // 50
            $this->_50->HrefValue = "";
            $this->_50->TooltipValue = "";

            // m_50
            $this->m_50->HrefValue = "";
            $this->m_50->TooltipValue = "";

            // 51
            $this->_51->HrefValue = "";
            $this->_51->TooltipValue = "";

            // m_51
            $this->m_51->HrefValue = "";
            $this->m_51->TooltipValue = "";

            // 52
            $this->_52->HrefValue = "";
            $this->_52->TooltipValue = "";

            // m_52
            $this->m_52->HrefValue = "";
            $this->m_52->TooltipValue = "";

            // 53
            $this->_53->HrefValue = "";
            $this->_53->TooltipValue = "";

            // m_53
            $this->m_53->HrefValue = "";
            $this->m_53->TooltipValue = "";

            // 54
            $this->_54->HrefValue = "";
            $this->_54->TooltipValue = "";

            // m_54
            $this->m_54->HrefValue = "";
            $this->m_54->TooltipValue = "";

            // 55
            $this->_55->HrefValue = "";
            $this->_55->TooltipValue = "";

            // m_55
            $this->m_55->HrefValue = "";
            $this->m_55->TooltipValue = "";

            // 56
            $this->_56->HrefValue = "";
            $this->_56->TooltipValue = "";

            // m_56
            $this->m_56->HrefValue = "";
            $this->m_56->TooltipValue = "";

            // 57
            $this->_57->HrefValue = "";
            $this->_57->TooltipValue = "";

            // m_57
            $this->m_57->HrefValue = "";
            $this->m_57->TooltipValue = "";

            // 58
            $this->_58->HrefValue = "";
            $this->_58->TooltipValue = "";

            // m_58
            $this->m_58->HrefValue = "";
            $this->m_58->TooltipValue = "";

            // 59
            $this->_59->HrefValue = "";
            $this->_59->TooltipValue = "";

            // m_59
            $this->m_59->HrefValue = "";
            $this->m_59->TooltipValue = "";

            // 60
            $this->_60->HrefValue = "";
            $this->_60->TooltipValue = "";

            // m_60
            $this->m_60->HrefValue = "";
            $this->m_60->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // roll_no
            $this->roll_no->setupEditAttributes();
            if (!$this->roll_no->Raw) {
                $this->roll_no->AdvancedSearch->SearchValue = HtmlDecode($this->roll_no->AdvancedSearch->SearchValue);
            }
            $this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

            // test_id
            $this->test_id->setupEditAttributes();
            if (!$this->test_id->Raw) {
                $this->test_id->AdvancedSearch->SearchValue = HtmlDecode($this->test_id->AdvancedSearch->SearchValue);
            }
            $this->test_id->EditValue = HtmlEncode($this->test_id->AdvancedSearch->SearchValue);
            $this->test_id->PlaceHolder = RemoveHtml($this->test_id->caption());

            // total
            $this->total->setupEditAttributes();
            $this->total->EditValue = $this->total->AdvancedSearch->SearchValue;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());
            $this->total->setupEditAttributes();
            $this->total->EditValue2 = $this->total->AdvancedSearch->SearchValue2;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());

            // percent
            $this->percent->setupEditAttributes();
            $this->percent->EditValue = $this->percent->AdvancedSearch->SearchValue;
            $this->percent->PlaceHolder = RemoveHtml($this->percent->caption());
            $this->percent->setupEditAttributes();
            $this->percent->EditValue2 = $this->percent->AdvancedSearch->SearchValue2;
            $this->percent->PlaceHolder = RemoveHtml($this->percent->caption());

            // s_1
            $this->s_1->setupEditAttributes();
            $this->s_1->EditValue = $this->s_1->AdvancedSearch->SearchValue;
            $this->s_1->PlaceHolder = RemoveHtml($this->s_1->caption());

            // s_2
            $this->s_2->setupEditAttributes();
            $this->s_2->EditValue = $this->s_2->AdvancedSearch->SearchValue;
            $this->s_2->PlaceHolder = RemoveHtml($this->s_2->caption());

            // s_3
            $this->s_3->setupEditAttributes();
            $this->s_3->EditValue = $this->s_3->AdvancedSearch->SearchValue;
            $this->s_3->PlaceHolder = RemoveHtml($this->s_3->caption());

            // s_4
            $this->s_4->setupEditAttributes();
            $this->s_4->EditValue = $this->s_4->AdvancedSearch->SearchValue;
            $this->s_4->PlaceHolder = RemoveHtml($this->s_4->caption());

            // s_5
            $this->s_5->setupEditAttributes();
            $this->s_5->EditValue = $this->s_5->AdvancedSearch->SearchValue;
            $this->s_5->PlaceHolder = RemoveHtml($this->s_5->caption());

            // omr_image
            $this->omr_image->setupEditAttributes();
            if (!$this->omr_image->Raw) {
                $this->omr_image->AdvancedSearch->SearchValue = HtmlDecode($this->omr_image->AdvancedSearch->SearchValue);
            }
            $this->omr_image->EditValue = HtmlEncode($this->omr_image->AdvancedSearch->SearchValue);
            $this->omr_image->PlaceHolder = RemoveHtml($this->omr_image->caption());

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // m_1
            $this->m_1->setupEditAttributes();
            $this->m_1->EditValue = $this->m_1->AdvancedSearch->SearchValue;
            $this->m_1->PlaceHolder = RemoveHtml($this->m_1->caption());

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // m_2
            $this->m_2->setupEditAttributes();
            $this->m_2->EditValue = $this->m_2->AdvancedSearch->SearchValue;
            $this->m_2->PlaceHolder = RemoveHtml($this->m_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->AdvancedSearch->SearchValue = HtmlDecode($this->_3->AdvancedSearch->SearchValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->AdvancedSearch->SearchValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // m_3
            $this->m_3->setupEditAttributes();
            $this->m_3->EditValue = $this->m_3->AdvancedSearch->SearchValue;
            $this->m_3->PlaceHolder = RemoveHtml($this->m_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->AdvancedSearch->SearchValue = HtmlDecode($this->_4->AdvancedSearch->SearchValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->AdvancedSearch->SearchValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // m_4
            $this->m_4->setupEditAttributes();
            $this->m_4->EditValue = $this->m_4->AdvancedSearch->SearchValue;
            $this->m_4->PlaceHolder = RemoveHtml($this->m_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->AdvancedSearch->SearchValue = HtmlDecode($this->_5->AdvancedSearch->SearchValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->AdvancedSearch->SearchValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // m_5
            $this->m_5->setupEditAttributes();
            $this->m_5->EditValue = $this->m_5->AdvancedSearch->SearchValue;
            $this->m_5->PlaceHolder = RemoveHtml($this->m_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->AdvancedSearch->SearchValue = HtmlDecode($this->_6->AdvancedSearch->SearchValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->AdvancedSearch->SearchValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // m_6
            $this->m_6->setupEditAttributes();
            $this->m_6->EditValue = $this->m_6->AdvancedSearch->SearchValue;
            $this->m_6->PlaceHolder = RemoveHtml($this->m_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->AdvancedSearch->SearchValue = HtmlDecode($this->_7->AdvancedSearch->SearchValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->AdvancedSearch->SearchValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // m_7
            $this->m_7->setupEditAttributes();
            $this->m_7->EditValue = $this->m_7->AdvancedSearch->SearchValue;
            $this->m_7->PlaceHolder = RemoveHtml($this->m_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->AdvancedSearch->SearchValue = HtmlDecode($this->_8->AdvancedSearch->SearchValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->AdvancedSearch->SearchValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // m_8
            $this->m_8->setupEditAttributes();
            $this->m_8->EditValue = $this->m_8->AdvancedSearch->SearchValue;
            $this->m_8->PlaceHolder = RemoveHtml($this->m_8->caption());

            // 9
            $this->_9->setupEditAttributes();
            if (!$this->_9->Raw) {
                $this->_9->AdvancedSearch->SearchValue = HtmlDecode($this->_9->AdvancedSearch->SearchValue);
            }
            $this->_9->EditValue = HtmlEncode($this->_9->AdvancedSearch->SearchValue);
            $this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

            // m_9
            $this->m_9->setupEditAttributes();
            $this->m_9->EditValue = $this->m_9->AdvancedSearch->SearchValue;
            $this->m_9->PlaceHolder = RemoveHtml($this->m_9->caption());

            // 10
            $this->_10->setupEditAttributes();
            if (!$this->_10->Raw) {
                $this->_10->AdvancedSearch->SearchValue = HtmlDecode($this->_10->AdvancedSearch->SearchValue);
            }
            $this->_10->EditValue = HtmlEncode($this->_10->AdvancedSearch->SearchValue);
            $this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

            // m_10
            $this->m_10->setupEditAttributes();
            $this->m_10->EditValue = $this->m_10->AdvancedSearch->SearchValue;
            $this->m_10->PlaceHolder = RemoveHtml($this->m_10->caption());

            // 11
            $this->_11->setupEditAttributes();
            if (!$this->_11->Raw) {
                $this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
            }
            $this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
            $this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

            // m_11
            $this->m_11->setupEditAttributes();
            $this->m_11->EditValue = $this->m_11->AdvancedSearch->SearchValue;
            $this->m_11->PlaceHolder = RemoveHtml($this->m_11->caption());

            // 12
            $this->_12->setupEditAttributes();
            if (!$this->_12->Raw) {
                $this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
            }
            $this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
            $this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

            // m_12
            $this->m_12->setupEditAttributes();
            $this->m_12->EditValue = $this->m_12->AdvancedSearch->SearchValue;
            $this->m_12->PlaceHolder = RemoveHtml($this->m_12->caption());

            // 13
            $this->_13->setupEditAttributes();
            if (!$this->_13->Raw) {
                $this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
            }
            $this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
            $this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

            // m_13
            $this->m_13->setupEditAttributes();
            $this->m_13->EditValue = $this->m_13->AdvancedSearch->SearchValue;
            $this->m_13->PlaceHolder = RemoveHtml($this->m_13->caption());

            // 14
            $this->_14->setupEditAttributes();
            if (!$this->_14->Raw) {
                $this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
            }
            $this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
            $this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

            // m_14
            $this->m_14->setupEditAttributes();
            $this->m_14->EditValue = $this->m_14->AdvancedSearch->SearchValue;
            $this->m_14->PlaceHolder = RemoveHtml($this->m_14->caption());

            // 15
            $this->_15->setupEditAttributes();
            if (!$this->_15->Raw) {
                $this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
            }
            $this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
            $this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

            // m_15
            $this->m_15->setupEditAttributes();
            $this->m_15->EditValue = $this->m_15->AdvancedSearch->SearchValue;
            $this->m_15->PlaceHolder = RemoveHtml($this->m_15->caption());

            // 16
            $this->_16->setupEditAttributes();
            if (!$this->_16->Raw) {
                $this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
            }
            $this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
            $this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

            // m_16
            $this->m_16->setupEditAttributes();
            $this->m_16->EditValue = $this->m_16->AdvancedSearch->SearchValue;
            $this->m_16->PlaceHolder = RemoveHtml($this->m_16->caption());

            // 17
            $this->_17->setupEditAttributes();
            if (!$this->_17->Raw) {
                $this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
            }
            $this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
            $this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

            // m_17
            $this->m_17->setupEditAttributes();
            $this->m_17->EditValue = $this->m_17->AdvancedSearch->SearchValue;
            $this->m_17->PlaceHolder = RemoveHtml($this->m_17->caption());

            // 18
            $this->_18->setupEditAttributes();
            if (!$this->_18->Raw) {
                $this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
            }
            $this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
            $this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

            // m_18
            $this->m_18->setupEditAttributes();
            $this->m_18->EditValue = $this->m_18->AdvancedSearch->SearchValue;
            $this->m_18->PlaceHolder = RemoveHtml($this->m_18->caption());

            // 19
            $this->_19->setupEditAttributes();
            if (!$this->_19->Raw) {
                $this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
            }
            $this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
            $this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

            // m_19
            $this->m_19->setupEditAttributes();
            $this->m_19->EditValue = $this->m_19->AdvancedSearch->SearchValue;
            $this->m_19->PlaceHolder = RemoveHtml($this->m_19->caption());

            // 20
            $this->_20->setupEditAttributes();
            if (!$this->_20->Raw) {
                $this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
            }
            $this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
            $this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

            // m_20
            $this->m_20->setupEditAttributes();
            $this->m_20->EditValue = $this->m_20->AdvancedSearch->SearchValue;
            $this->m_20->PlaceHolder = RemoveHtml($this->m_20->caption());

            // 21
            $this->_21->setupEditAttributes();
            if (!$this->_21->Raw) {
                $this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
            }
            $this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
            $this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

            // m_21
            $this->m_21->setupEditAttributes();
            $this->m_21->EditValue = $this->m_21->AdvancedSearch->SearchValue;
            $this->m_21->PlaceHolder = RemoveHtml($this->m_21->caption());

            // 22
            $this->_22->setupEditAttributes();
            if (!$this->_22->Raw) {
                $this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
            }
            $this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
            $this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

            // m_22
            $this->m_22->setupEditAttributes();
            $this->m_22->EditValue = $this->m_22->AdvancedSearch->SearchValue;
            $this->m_22->PlaceHolder = RemoveHtml($this->m_22->caption());

            // 23
            $this->_23->setupEditAttributes();
            if (!$this->_23->Raw) {
                $this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
            }
            $this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
            $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

            // m_23
            $this->m_23->setupEditAttributes();
            $this->m_23->EditValue = $this->m_23->AdvancedSearch->SearchValue;
            $this->m_23->PlaceHolder = RemoveHtml($this->m_23->caption());

            // 24
            $this->_24->setupEditAttributes();
            if (!$this->_24->Raw) {
                $this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
            }
            $this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
            $this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

            // m_24
            $this->m_24->setupEditAttributes();
            $this->m_24->EditValue = $this->m_24->AdvancedSearch->SearchValue;
            $this->m_24->PlaceHolder = RemoveHtml($this->m_24->caption());

            // 25
            $this->_25->setupEditAttributes();
            if (!$this->_25->Raw) {
                $this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
            }
            $this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
            $this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

            // m_25
            $this->m_25->setupEditAttributes();
            $this->m_25->EditValue = $this->m_25->AdvancedSearch->SearchValue;
            $this->m_25->PlaceHolder = RemoveHtml($this->m_25->caption());

            // 26
            $this->_26->setupEditAttributes();
            if (!$this->_26->Raw) {
                $this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
            }
            $this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
            $this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

            // m_26
            $this->m_26->setupEditAttributes();
            $this->m_26->EditValue = $this->m_26->AdvancedSearch->SearchValue;
            $this->m_26->PlaceHolder = RemoveHtml($this->m_26->caption());

            // 27
            $this->_27->setupEditAttributes();
            if (!$this->_27->Raw) {
                $this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
            }
            $this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
            $this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

            // m_27
            $this->m_27->setupEditAttributes();
            $this->m_27->EditValue = $this->m_27->AdvancedSearch->SearchValue;
            $this->m_27->PlaceHolder = RemoveHtml($this->m_27->caption());

            // 28
            $this->_28->setupEditAttributes();
            if (!$this->_28->Raw) {
                $this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
            }
            $this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
            $this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

            // m_28
            $this->m_28->setupEditAttributes();
            $this->m_28->EditValue = $this->m_28->AdvancedSearch->SearchValue;
            $this->m_28->PlaceHolder = RemoveHtml($this->m_28->caption());

            // 29
            $this->_29->setupEditAttributes();
            if (!$this->_29->Raw) {
                $this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
            }
            $this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
            $this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

            // m_29
            $this->m_29->setupEditAttributes();
            $this->m_29->EditValue = $this->m_29->AdvancedSearch->SearchValue;
            $this->m_29->PlaceHolder = RemoveHtml($this->m_29->caption());

            // 30
            $this->_30->setupEditAttributes();
            if (!$this->_30->Raw) {
                $this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
            }
            $this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
            $this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

            // m_30
            $this->m_30->setupEditAttributes();
            $this->m_30->EditValue = $this->m_30->AdvancedSearch->SearchValue;
            $this->m_30->PlaceHolder = RemoveHtml($this->m_30->caption());

            // 31
            $this->_31->setupEditAttributes();
            if (!$this->_31->Raw) {
                $this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
            }
            $this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
            $this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

            // m_31
            $this->m_31->setupEditAttributes();
            $this->m_31->EditValue = $this->m_31->AdvancedSearch->SearchValue;
            $this->m_31->PlaceHolder = RemoveHtml($this->m_31->caption());

            // 32
            $this->_32->setupEditAttributes();
            if (!$this->_32->Raw) {
                $this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
            }
            $this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
            $this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

            // m_32
            $this->m_32->setupEditAttributes();
            $this->m_32->EditValue = $this->m_32->AdvancedSearch->SearchValue;
            $this->m_32->PlaceHolder = RemoveHtml($this->m_32->caption());

            // 33
            $this->_33->setupEditAttributes();
            if (!$this->_33->Raw) {
                $this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
            }
            $this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
            $this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

            // m_33
            $this->m_33->setupEditAttributes();
            $this->m_33->EditValue = $this->m_33->AdvancedSearch->SearchValue;
            $this->m_33->PlaceHolder = RemoveHtml($this->m_33->caption());

            // 34
            $this->_34->setupEditAttributes();
            if (!$this->_34->Raw) {
                $this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
            }
            $this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
            $this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

            // m_34
            $this->m_34->setupEditAttributes();
            $this->m_34->EditValue = $this->m_34->AdvancedSearch->SearchValue;
            $this->m_34->PlaceHolder = RemoveHtml($this->m_34->caption());

            // 35
            $this->_35->setupEditAttributes();
            if (!$this->_35->Raw) {
                $this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
            }
            $this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
            $this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

            // m_35
            $this->m_35->setupEditAttributes();
            $this->m_35->EditValue = $this->m_35->AdvancedSearch->SearchValue;
            $this->m_35->PlaceHolder = RemoveHtml($this->m_35->caption());

            // 36
            $this->_36->setupEditAttributes();
            if (!$this->_36->Raw) {
                $this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
            }
            $this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
            $this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

            // m_36
            $this->m_36->setupEditAttributes();
            $this->m_36->EditValue = $this->m_36->AdvancedSearch->SearchValue;
            $this->m_36->PlaceHolder = RemoveHtml($this->m_36->caption());

            // 37
            $this->_37->setupEditAttributes();
            if (!$this->_37->Raw) {
                $this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
            }
            $this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
            $this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

            // m_37
            $this->m_37->setupEditAttributes();
            $this->m_37->EditValue = $this->m_37->AdvancedSearch->SearchValue;
            $this->m_37->PlaceHolder = RemoveHtml($this->m_37->caption());

            // 38
            $this->_38->setupEditAttributes();
            if (!$this->_38->Raw) {
                $this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
            }
            $this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
            $this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

            // m_38
            $this->m_38->setupEditAttributes();
            $this->m_38->EditValue = $this->m_38->AdvancedSearch->SearchValue;
            $this->m_38->PlaceHolder = RemoveHtml($this->m_38->caption());

            // 39
            $this->_39->setupEditAttributes();
            if (!$this->_39->Raw) {
                $this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
            }
            $this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
            $this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

            // m_39
            $this->m_39->setupEditAttributes();
            $this->m_39->EditValue = $this->m_39->AdvancedSearch->SearchValue;
            $this->m_39->PlaceHolder = RemoveHtml($this->m_39->caption());

            // 40
            $this->_40->setupEditAttributes();
            if (!$this->_40->Raw) {
                $this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
            }
            $this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // m_40
            $this->m_40->setupEditAttributes();
            $this->m_40->EditValue = $this->m_40->AdvancedSearch->SearchValue;
            $this->m_40->PlaceHolder = RemoveHtml($this->m_40->caption());

            // 41
            $this->_41->setupEditAttributes();
            if (!$this->_41->Raw) {
                $this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
            }
            $this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
            $this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

            // m_41
            $this->m_41->setupEditAttributes();
            $this->m_41->EditValue = $this->m_41->AdvancedSearch->SearchValue;
            $this->m_41->PlaceHolder = RemoveHtml($this->m_41->caption());

            // 42
            $this->_42->setupEditAttributes();
            if (!$this->_42->Raw) {
                $this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
            }
            $this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
            $this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

            // m_42
            $this->m_42->setupEditAttributes();
            $this->m_42->EditValue = $this->m_42->AdvancedSearch->SearchValue;
            $this->m_42->PlaceHolder = RemoveHtml($this->m_42->caption());

            // 43
            $this->_43->setupEditAttributes();
            if (!$this->_43->Raw) {
                $this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
            }
            $this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
            $this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

            // m_43
            $this->m_43->setupEditAttributes();
            $this->m_43->EditValue = $this->m_43->AdvancedSearch->SearchValue;
            $this->m_43->PlaceHolder = RemoveHtml($this->m_43->caption());

            // 44
            $this->_44->setupEditAttributes();
            if (!$this->_44->Raw) {
                $this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
            }
            $this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
            $this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

            // m_44
            $this->m_44->setupEditAttributes();
            $this->m_44->EditValue = $this->m_44->AdvancedSearch->SearchValue;
            $this->m_44->PlaceHolder = RemoveHtml($this->m_44->caption());

            // 45
            $this->_45->setupEditAttributes();
            if (!$this->_45->Raw) {
                $this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
            }
            $this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
            $this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

            // m_45
            $this->m_45->setupEditAttributes();
            $this->m_45->EditValue = $this->m_45->AdvancedSearch->SearchValue;
            $this->m_45->PlaceHolder = RemoveHtml($this->m_45->caption());

            // 46
            $this->_46->setupEditAttributes();
            if (!$this->_46->Raw) {
                $this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
            }
            $this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
            $this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

            // m_46
            $this->m_46->setupEditAttributes();
            $this->m_46->EditValue = $this->m_46->AdvancedSearch->SearchValue;
            $this->m_46->PlaceHolder = RemoveHtml($this->m_46->caption());

            // 47
            $this->_47->setupEditAttributes();
            if (!$this->_47->Raw) {
                $this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
            }
            $this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
            $this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

            // m_47
            $this->m_47->setupEditAttributes();
            $this->m_47->EditValue = $this->m_47->AdvancedSearch->SearchValue;
            $this->m_47->PlaceHolder = RemoveHtml($this->m_47->caption());

            // 48
            $this->_48->setupEditAttributes();
            if (!$this->_48->Raw) {
                $this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
            }
            $this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
            $this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

            // m_48
            $this->m_48->setupEditAttributes();
            $this->m_48->EditValue = $this->m_48->AdvancedSearch->SearchValue;
            $this->m_48->PlaceHolder = RemoveHtml($this->m_48->caption());

            // 49
            $this->_49->setupEditAttributes();
            if (!$this->_49->Raw) {
                $this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
            }
            $this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
            $this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

            // m_49
            $this->m_49->setupEditAttributes();
            $this->m_49->EditValue = $this->m_49->AdvancedSearch->SearchValue;
            $this->m_49->PlaceHolder = RemoveHtml($this->m_49->caption());

            // 50
            $this->_50->setupEditAttributes();
            if (!$this->_50->Raw) {
                $this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
            }
            $this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
            $this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

            // m_50
            $this->m_50->setupEditAttributes();
            $this->m_50->EditValue = $this->m_50->AdvancedSearch->SearchValue;
            $this->m_50->PlaceHolder = RemoveHtml($this->m_50->caption());

            // 51
            $this->_51->setupEditAttributes();
            if (!$this->_51->Raw) {
                $this->_51->AdvancedSearch->SearchValue = HtmlDecode($this->_51->AdvancedSearch->SearchValue);
            }
            $this->_51->EditValue = HtmlEncode($this->_51->AdvancedSearch->SearchValue);
            $this->_51->PlaceHolder = RemoveHtml($this->_51->caption());

            // m_51
            $this->m_51->setupEditAttributes();
            $this->m_51->EditValue = $this->m_51->AdvancedSearch->SearchValue;
            $this->m_51->PlaceHolder = RemoveHtml($this->m_51->caption());

            // 52
            $this->_52->setupEditAttributes();
            if (!$this->_52->Raw) {
                $this->_52->AdvancedSearch->SearchValue = HtmlDecode($this->_52->AdvancedSearch->SearchValue);
            }
            $this->_52->EditValue = HtmlEncode($this->_52->AdvancedSearch->SearchValue);
            $this->_52->PlaceHolder = RemoveHtml($this->_52->caption());

            // m_52
            $this->m_52->setupEditAttributes();
            $this->m_52->EditValue = $this->m_52->AdvancedSearch->SearchValue;
            $this->m_52->PlaceHolder = RemoveHtml($this->m_52->caption());

            // 53
            $this->_53->setupEditAttributes();
            if (!$this->_53->Raw) {
                $this->_53->AdvancedSearch->SearchValue = HtmlDecode($this->_53->AdvancedSearch->SearchValue);
            }
            $this->_53->EditValue = HtmlEncode($this->_53->AdvancedSearch->SearchValue);
            $this->_53->PlaceHolder = RemoveHtml($this->_53->caption());

            // m_53
            $this->m_53->setupEditAttributes();
            $this->m_53->EditValue = $this->m_53->AdvancedSearch->SearchValue;
            $this->m_53->PlaceHolder = RemoveHtml($this->m_53->caption());

            // 54
            $this->_54->setupEditAttributes();
            if (!$this->_54->Raw) {
                $this->_54->AdvancedSearch->SearchValue = HtmlDecode($this->_54->AdvancedSearch->SearchValue);
            }
            $this->_54->EditValue = HtmlEncode($this->_54->AdvancedSearch->SearchValue);
            $this->_54->PlaceHolder = RemoveHtml($this->_54->caption());

            // m_54
            $this->m_54->setupEditAttributes();
            $this->m_54->EditValue = $this->m_54->AdvancedSearch->SearchValue;
            $this->m_54->PlaceHolder = RemoveHtml($this->m_54->caption());

            // 55
            $this->_55->setupEditAttributes();
            if (!$this->_55->Raw) {
                $this->_55->AdvancedSearch->SearchValue = HtmlDecode($this->_55->AdvancedSearch->SearchValue);
            }
            $this->_55->EditValue = HtmlEncode($this->_55->AdvancedSearch->SearchValue);
            $this->_55->PlaceHolder = RemoveHtml($this->_55->caption());

            // m_55
            $this->m_55->setupEditAttributes();
            $this->m_55->EditValue = $this->m_55->AdvancedSearch->SearchValue;
            $this->m_55->PlaceHolder = RemoveHtml($this->m_55->caption());

            // 56
            $this->_56->setupEditAttributes();
            if (!$this->_56->Raw) {
                $this->_56->AdvancedSearch->SearchValue = HtmlDecode($this->_56->AdvancedSearch->SearchValue);
            }
            $this->_56->EditValue = HtmlEncode($this->_56->AdvancedSearch->SearchValue);
            $this->_56->PlaceHolder = RemoveHtml($this->_56->caption());

            // m_56
            $this->m_56->setupEditAttributes();
            $this->m_56->EditValue = $this->m_56->AdvancedSearch->SearchValue;
            $this->m_56->PlaceHolder = RemoveHtml($this->m_56->caption());

            // 57
            $this->_57->setupEditAttributes();
            if (!$this->_57->Raw) {
                $this->_57->AdvancedSearch->SearchValue = HtmlDecode($this->_57->AdvancedSearch->SearchValue);
            }
            $this->_57->EditValue = HtmlEncode($this->_57->AdvancedSearch->SearchValue);
            $this->_57->PlaceHolder = RemoveHtml($this->_57->caption());

            // m_57
            $this->m_57->setupEditAttributes();
            $this->m_57->EditValue = $this->m_57->AdvancedSearch->SearchValue;
            $this->m_57->PlaceHolder = RemoveHtml($this->m_57->caption());

            // 58
            $this->_58->setupEditAttributes();
            if (!$this->_58->Raw) {
                $this->_58->AdvancedSearch->SearchValue = HtmlDecode($this->_58->AdvancedSearch->SearchValue);
            }
            $this->_58->EditValue = HtmlEncode($this->_58->AdvancedSearch->SearchValue);
            $this->_58->PlaceHolder = RemoveHtml($this->_58->caption());

            // m_58
            $this->m_58->setupEditAttributes();
            $this->m_58->EditValue = $this->m_58->AdvancedSearch->SearchValue;
            $this->m_58->PlaceHolder = RemoveHtml($this->m_58->caption());

            // 59
            $this->_59->setupEditAttributes();
            if (!$this->_59->Raw) {
                $this->_59->AdvancedSearch->SearchValue = HtmlDecode($this->_59->AdvancedSearch->SearchValue);
            }
            $this->_59->EditValue = HtmlEncode($this->_59->AdvancedSearch->SearchValue);
            $this->_59->PlaceHolder = RemoveHtml($this->_59->caption());

            // m_59
            $this->m_59->setupEditAttributes();
            $this->m_59->EditValue = $this->m_59->AdvancedSearch->SearchValue;
            $this->m_59->PlaceHolder = RemoveHtml($this->m_59->caption());

            // 60
            $this->_60->setupEditAttributes();
            if (!$this->_60->Raw) {
                $this->_60->AdvancedSearch->SearchValue = HtmlDecode($this->_60->AdvancedSearch->SearchValue);
            }
            $this->_60->EditValue = HtmlEncode($this->_60->AdvancedSearch->SearchValue);
            $this->_60->PlaceHolder = RemoveHtml($this->_60->caption());

            // m_60
            $this->m_60->setupEditAttributes();
            $this->m_60->EditValue = $this->m_60->AdvancedSearch->SearchValue;
            $this->m_60->PlaceHolder = RemoveHtml($this->m_60->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->total->AdvancedSearch->SearchValue)) {
            $this->total->addErrorMessage($this->total->getErrorMessage(false));
        }
        if (!CheckNumber($this->total->AdvancedSearch->SearchValue2)) {
            $this->total->addErrorMessage($this->total->getErrorMessage(false));
        }
        if (!CheckNumber($this->percent->AdvancedSearch->SearchValue)) {
            $this->percent->addErrorMessage($this->percent->getErrorMessage(false));
        }
        if (!CheckNumber($this->percent->AdvancedSearch->SearchValue2)) {
            $this->percent->addErrorMessage($this->percent->getErrorMessage(false));
        }
        if (!CheckNumber($this->s_1->AdvancedSearch->SearchValue)) {
            $this->s_1->addErrorMessage($this->s_1->getErrorMessage(false));
        }
        if (!CheckNumber($this->s_2->AdvancedSearch->SearchValue)) {
            $this->s_2->addErrorMessage($this->s_2->getErrorMessage(false));
        }
        if (!CheckNumber($this->s_3->AdvancedSearch->SearchValue)) {
            $this->s_3->addErrorMessage($this->s_3->getErrorMessage(false));
        }
        if (!CheckNumber($this->s_4->AdvancedSearch->SearchValue)) {
            $this->s_4->addErrorMessage($this->s_4->getErrorMessage(false));
        }
        if (!CheckNumber($this->s_5->AdvancedSearch->SearchValue)) {
            $this->s_5->addErrorMessage($this->s_5->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_1->AdvancedSearch->SearchValue)) {
            $this->m_1->addErrorMessage($this->m_1->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_2->AdvancedSearch->SearchValue)) {
            $this->m_2->addErrorMessage($this->m_2->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_3->AdvancedSearch->SearchValue)) {
            $this->m_3->addErrorMessage($this->m_3->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_4->AdvancedSearch->SearchValue)) {
            $this->m_4->addErrorMessage($this->m_4->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_5->AdvancedSearch->SearchValue)) {
            $this->m_5->addErrorMessage($this->m_5->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_6->AdvancedSearch->SearchValue)) {
            $this->m_6->addErrorMessage($this->m_6->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_7->AdvancedSearch->SearchValue)) {
            $this->m_7->addErrorMessage($this->m_7->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_8->AdvancedSearch->SearchValue)) {
            $this->m_8->addErrorMessage($this->m_8->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_9->AdvancedSearch->SearchValue)) {
            $this->m_9->addErrorMessage($this->m_9->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_10->AdvancedSearch->SearchValue)) {
            $this->m_10->addErrorMessage($this->m_10->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_11->AdvancedSearch->SearchValue)) {
            $this->m_11->addErrorMessage($this->m_11->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_12->AdvancedSearch->SearchValue)) {
            $this->m_12->addErrorMessage($this->m_12->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_13->AdvancedSearch->SearchValue)) {
            $this->m_13->addErrorMessage($this->m_13->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_14->AdvancedSearch->SearchValue)) {
            $this->m_14->addErrorMessage($this->m_14->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_15->AdvancedSearch->SearchValue)) {
            $this->m_15->addErrorMessage($this->m_15->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_16->AdvancedSearch->SearchValue)) {
            $this->m_16->addErrorMessage($this->m_16->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_17->AdvancedSearch->SearchValue)) {
            $this->m_17->addErrorMessage($this->m_17->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_18->AdvancedSearch->SearchValue)) {
            $this->m_18->addErrorMessage($this->m_18->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_19->AdvancedSearch->SearchValue)) {
            $this->m_19->addErrorMessage($this->m_19->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_20->AdvancedSearch->SearchValue)) {
            $this->m_20->addErrorMessage($this->m_20->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_21->AdvancedSearch->SearchValue)) {
            $this->m_21->addErrorMessage($this->m_21->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_22->AdvancedSearch->SearchValue)) {
            $this->m_22->addErrorMessage($this->m_22->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_23->AdvancedSearch->SearchValue)) {
            $this->m_23->addErrorMessage($this->m_23->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_24->AdvancedSearch->SearchValue)) {
            $this->m_24->addErrorMessage($this->m_24->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_25->AdvancedSearch->SearchValue)) {
            $this->m_25->addErrorMessage($this->m_25->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_26->AdvancedSearch->SearchValue)) {
            $this->m_26->addErrorMessage($this->m_26->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_27->AdvancedSearch->SearchValue)) {
            $this->m_27->addErrorMessage($this->m_27->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_28->AdvancedSearch->SearchValue)) {
            $this->m_28->addErrorMessage($this->m_28->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_29->AdvancedSearch->SearchValue)) {
            $this->m_29->addErrorMessage($this->m_29->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_30->AdvancedSearch->SearchValue)) {
            $this->m_30->addErrorMessage($this->m_30->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_31->AdvancedSearch->SearchValue)) {
            $this->m_31->addErrorMessage($this->m_31->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_32->AdvancedSearch->SearchValue)) {
            $this->m_32->addErrorMessage($this->m_32->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_33->AdvancedSearch->SearchValue)) {
            $this->m_33->addErrorMessage($this->m_33->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_34->AdvancedSearch->SearchValue)) {
            $this->m_34->addErrorMessage($this->m_34->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_35->AdvancedSearch->SearchValue)) {
            $this->m_35->addErrorMessage($this->m_35->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_36->AdvancedSearch->SearchValue)) {
            $this->m_36->addErrorMessage($this->m_36->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_37->AdvancedSearch->SearchValue)) {
            $this->m_37->addErrorMessage($this->m_37->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_38->AdvancedSearch->SearchValue)) {
            $this->m_38->addErrorMessage($this->m_38->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_39->AdvancedSearch->SearchValue)) {
            $this->m_39->addErrorMessage($this->m_39->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_40->AdvancedSearch->SearchValue)) {
            $this->m_40->addErrorMessage($this->m_40->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_41->AdvancedSearch->SearchValue)) {
            $this->m_41->addErrorMessage($this->m_41->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_42->AdvancedSearch->SearchValue)) {
            $this->m_42->addErrorMessage($this->m_42->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_43->AdvancedSearch->SearchValue)) {
            $this->m_43->addErrorMessage($this->m_43->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_44->AdvancedSearch->SearchValue)) {
            $this->m_44->addErrorMessage($this->m_44->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_45->AdvancedSearch->SearchValue)) {
            $this->m_45->addErrorMessage($this->m_45->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_46->AdvancedSearch->SearchValue)) {
            $this->m_46->addErrorMessage($this->m_46->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_47->AdvancedSearch->SearchValue)) {
            $this->m_47->addErrorMessage($this->m_47->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_48->AdvancedSearch->SearchValue)) {
            $this->m_48->addErrorMessage($this->m_48->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_49->AdvancedSearch->SearchValue)) {
            $this->m_49->addErrorMessage($this->m_49->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_50->AdvancedSearch->SearchValue)) {
            $this->m_50->addErrorMessage($this->m_50->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_51->AdvancedSearch->SearchValue)) {
            $this->m_51->addErrorMessage($this->m_51->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_52->AdvancedSearch->SearchValue)) {
            $this->m_52->addErrorMessage($this->m_52->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_53->AdvancedSearch->SearchValue)) {
            $this->m_53->addErrorMessage($this->m_53->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_54->AdvancedSearch->SearchValue)) {
            $this->m_54->addErrorMessage($this->m_54->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_55->AdvancedSearch->SearchValue)) {
            $this->m_55->addErrorMessage($this->m_55->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_56->AdvancedSearch->SearchValue)) {
            $this->m_56->addErrorMessage($this->m_56->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_57->AdvancedSearch->SearchValue)) {
            $this->m_57->addErrorMessage($this->m_57->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_58->AdvancedSearch->SearchValue)) {
            $this->m_58->addErrorMessage($this->m_58->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_59->AdvancedSearch->SearchValue)) {
            $this->m_59->addErrorMessage($this->m_59->getErrorMessage(false));
        }
        if (!CheckNumber($this->m_60->AdvancedSearch->SearchValue)) {
            $this->m_60->addErrorMessage($this->m_60->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->test_id->AdvancedSearch->load();
        $this->total->AdvancedSearch->load();
        $this->percent->AdvancedSearch->load();
        $this->s_1->AdvancedSearch->load();
        $this->s_2->AdvancedSearch->load();
        $this->s_3->AdvancedSearch->load();
        $this->s_4->AdvancedSearch->load();
        $this->s_5->AdvancedSearch->load();
        $this->omr_image->AdvancedSearch->load();
        $this->_1->AdvancedSearch->load();
        $this->m_1->AdvancedSearch->load();
        $this->_2->AdvancedSearch->load();
        $this->m_2->AdvancedSearch->load();
        $this->_3->AdvancedSearch->load();
        $this->m_3->AdvancedSearch->load();
        $this->_4->AdvancedSearch->load();
        $this->m_4->AdvancedSearch->load();
        $this->_5->AdvancedSearch->load();
        $this->m_5->AdvancedSearch->load();
        $this->_6->AdvancedSearch->load();
        $this->m_6->AdvancedSearch->load();
        $this->_7->AdvancedSearch->load();
        $this->m_7->AdvancedSearch->load();
        $this->_8->AdvancedSearch->load();
        $this->m_8->AdvancedSearch->load();
        $this->_9->AdvancedSearch->load();
        $this->m_9->AdvancedSearch->load();
        $this->_10->AdvancedSearch->load();
        $this->m_10->AdvancedSearch->load();
        $this->_11->AdvancedSearch->load();
        $this->m_11->AdvancedSearch->load();
        $this->_12->AdvancedSearch->load();
        $this->m_12->AdvancedSearch->load();
        $this->_13->AdvancedSearch->load();
        $this->m_13->AdvancedSearch->load();
        $this->_14->AdvancedSearch->load();
        $this->m_14->AdvancedSearch->load();
        $this->_15->AdvancedSearch->load();
        $this->m_15->AdvancedSearch->load();
        $this->_16->AdvancedSearch->load();
        $this->m_16->AdvancedSearch->load();
        $this->_17->AdvancedSearch->load();
        $this->m_17->AdvancedSearch->load();
        $this->_18->AdvancedSearch->load();
        $this->m_18->AdvancedSearch->load();
        $this->_19->AdvancedSearch->load();
        $this->m_19->AdvancedSearch->load();
        $this->_20->AdvancedSearch->load();
        $this->m_20->AdvancedSearch->load();
        $this->_21->AdvancedSearch->load();
        $this->m_21->AdvancedSearch->load();
        $this->_22->AdvancedSearch->load();
        $this->m_22->AdvancedSearch->load();
        $this->_23->AdvancedSearch->load();
        $this->m_23->AdvancedSearch->load();
        $this->_24->AdvancedSearch->load();
        $this->m_24->AdvancedSearch->load();
        $this->_25->AdvancedSearch->load();
        $this->m_25->AdvancedSearch->load();
        $this->_26->AdvancedSearch->load();
        $this->m_26->AdvancedSearch->load();
        $this->_27->AdvancedSearch->load();
        $this->m_27->AdvancedSearch->load();
        $this->_28->AdvancedSearch->load();
        $this->m_28->AdvancedSearch->load();
        $this->_29->AdvancedSearch->load();
        $this->m_29->AdvancedSearch->load();
        $this->_30->AdvancedSearch->load();
        $this->m_30->AdvancedSearch->load();
        $this->_31->AdvancedSearch->load();
        $this->m_31->AdvancedSearch->load();
        $this->_32->AdvancedSearch->load();
        $this->m_32->AdvancedSearch->load();
        $this->_33->AdvancedSearch->load();
        $this->m_33->AdvancedSearch->load();
        $this->_34->AdvancedSearch->load();
        $this->m_34->AdvancedSearch->load();
        $this->_35->AdvancedSearch->load();
        $this->m_35->AdvancedSearch->load();
        $this->_36->AdvancedSearch->load();
        $this->m_36->AdvancedSearch->load();
        $this->_37->AdvancedSearch->load();
        $this->m_37->AdvancedSearch->load();
        $this->_38->AdvancedSearch->load();
        $this->m_38->AdvancedSearch->load();
        $this->_39->AdvancedSearch->load();
        $this->m_39->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->m_40->AdvancedSearch->load();
        $this->_41->AdvancedSearch->load();
        $this->m_41->AdvancedSearch->load();
        $this->_42->AdvancedSearch->load();
        $this->m_42->AdvancedSearch->load();
        $this->_43->AdvancedSearch->load();
        $this->m_43->AdvancedSearch->load();
        $this->_44->AdvancedSearch->load();
        $this->m_44->AdvancedSearch->load();
        $this->_45->AdvancedSearch->load();
        $this->m_45->AdvancedSearch->load();
        $this->_46->AdvancedSearch->load();
        $this->m_46->AdvancedSearch->load();
        $this->_47->AdvancedSearch->load();
        $this->m_47->AdvancedSearch->load();
        $this->_48->AdvancedSearch->load();
        $this->m_48->AdvancedSearch->load();
        $this->_49->AdvancedSearch->load();
        $this->m_49->AdvancedSearch->load();
        $this->_50->AdvancedSearch->load();
        $this->m_50->AdvancedSearch->load();
        $this->_51->AdvancedSearch->load();
        $this->m_51->AdvancedSearch->load();
        $this->_52->AdvancedSearch->load();
        $this->m_52->AdvancedSearch->load();
        $this->_53->AdvancedSearch->load();
        $this->m_53->AdvancedSearch->load();
        $this->_54->AdvancedSearch->load();
        $this->m_54->AdvancedSearch->load();
        $this->_55->AdvancedSearch->load();
        $this->m_55->AdvancedSearch->load();
        $this->_56->AdvancedSearch->load();
        $this->m_56->AdvancedSearch->load();
        $this->_57->AdvancedSearch->load();
        $this->m_57->AdvancedSearch->load();
        $this->_58->AdvancedSearch->load();
        $this->m_58->AdvancedSearch->load();
        $this->_59->AdvancedSearch->load();
        $this->m_59->AdvancedSearch->load();
        $this->_60->AdvancedSearch->load();
        $this->m_60->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("somrvaluelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
