<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SOmrValueList extends SOmrValue
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SOmrValueList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fs_omr_valuelist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "somrvaluelist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->roll_no->setVisibility();
        $this->test_id->setVisibility();
        $this->total->setVisibility();
        $this->percent->setVisibility();
        $this->s_1->setVisibility();
        $this->s_2->setVisibility();
        $this->s_3->setVisibility();
        $this->s_4->setVisibility();
        $this->s_5->setVisibility();
        $this->omr_image->setVisibility();
        $this->_1->setVisibility();
        $this->m_1->setVisibility();
        $this->_2->setVisibility();
        $this->m_2->setVisibility();
        $this->_3->setVisibility();
        $this->m_3->setVisibility();
        $this->_4->setVisibility();
        $this->m_4->setVisibility();
        $this->_5->setVisibility();
        $this->m_5->setVisibility();
        $this->_6->setVisibility();
        $this->m_6->setVisibility();
        $this->_7->setVisibility();
        $this->m_7->setVisibility();
        $this->_8->setVisibility();
        $this->m_8->setVisibility();
        $this->_9->setVisibility();
        $this->m_9->setVisibility();
        $this->_10->setVisibility();
        $this->m_10->setVisibility();
        $this->_11->setVisibility();
        $this->m_11->setVisibility();
        $this->_12->setVisibility();
        $this->m_12->setVisibility();
        $this->_13->setVisibility();
        $this->m_13->setVisibility();
        $this->_14->setVisibility();
        $this->m_14->setVisibility();
        $this->_15->setVisibility();
        $this->m_15->setVisibility();
        $this->_16->setVisibility();
        $this->m_16->setVisibility();
        $this->_17->setVisibility();
        $this->m_17->setVisibility();
        $this->_18->setVisibility();
        $this->m_18->setVisibility();
        $this->_19->setVisibility();
        $this->m_19->setVisibility();
        $this->_20->setVisibility();
        $this->m_20->setVisibility();
        $this->_21->setVisibility();
        $this->m_21->setVisibility();
        $this->_22->setVisibility();
        $this->m_22->setVisibility();
        $this->_23->setVisibility();
        $this->m_23->setVisibility();
        $this->_24->setVisibility();
        $this->m_24->setVisibility();
        $this->_25->setVisibility();
        $this->m_25->setVisibility();
        $this->_26->setVisibility();
        $this->m_26->setVisibility();
        $this->_27->setVisibility();
        $this->m_27->setVisibility();
        $this->_28->setVisibility();
        $this->m_28->setVisibility();
        $this->_29->setVisibility();
        $this->m_29->setVisibility();
        $this->_30->setVisibility();
        $this->m_30->setVisibility();
        $this->_31->setVisibility();
        $this->m_31->setVisibility();
        $this->_32->setVisibility();
        $this->m_32->setVisibility();
        $this->_33->setVisibility();
        $this->m_33->setVisibility();
        $this->_34->setVisibility();
        $this->m_34->setVisibility();
        $this->_35->setVisibility();
        $this->m_35->setVisibility();
        $this->_36->setVisibility();
        $this->m_36->setVisibility();
        $this->_37->setVisibility();
        $this->m_37->setVisibility();
        $this->_38->setVisibility();
        $this->m_38->setVisibility();
        $this->_39->setVisibility();
        $this->m_39->setVisibility();
        $this->_40->setVisibility();
        $this->m_40->setVisibility();
        $this->_41->setVisibility();
        $this->m_41->setVisibility();
        $this->_42->setVisibility();
        $this->m_42->setVisibility();
        $this->_43->setVisibility();
        $this->m_43->setVisibility();
        $this->_44->setVisibility();
        $this->m_44->setVisibility();
        $this->_45->setVisibility();
        $this->m_45->setVisibility();
        $this->_46->setVisibility();
        $this->m_46->setVisibility();
        $this->_47->setVisibility();
        $this->m_47->setVisibility();
        $this->_48->setVisibility();
        $this->m_48->setVisibility();
        $this->_49->setVisibility();
        $this->m_49->setVisibility();
        $this->_50->setVisibility();
        $this->m_50->setVisibility();
        $this->_51->setVisibility();
        $this->m_51->setVisibility();
        $this->_52->setVisibility();
        $this->m_52->setVisibility();
        $this->_53->setVisibility();
        $this->m_53->setVisibility();
        $this->_54->setVisibility();
        $this->m_54->setVisibility();
        $this->_55->setVisibility();
        $this->m_55->setVisibility();
        $this->_56->setVisibility();
        $this->m_56->setVisibility();
        $this->_57->setVisibility();
        $this->m_57->setVisibility();
        $this->_58->setVisibility();
        $this->m_58->setVisibility();
        $this->_59->setVisibility();
        $this->m_59->setVisibility();
        $this->_60->setVisibility();
        $this->m_60->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 's_omr_value';
        $this->TableName = 's_omr_value';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_omr_value)
        if (!isset($GLOBALS["s_omr_value"]) || $GLOBALS["s_omr_value"]::class == PROJECT_NAMESPACE . "s_omr_value") {
            $GLOBALS["s_omr_value"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "somrvalueadd";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "somrvaluedelete";
        $this->MultiUpdateUrl = "somrvalueupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "somrvalueview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->omr_image->OldUploadPath = $this->omr_image->getUploadPath(); // PHP
                $this->omr_image->UploadPath = $this->omr_image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fs_omr_valuegrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("fs_omr_valuesrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->roll_no->AdvancedSearch->toJson(), ","); // Field roll_no
        $filterList = Concat($filterList, $this->test_id->AdvancedSearch->toJson(), ","); // Field test_id
        $filterList = Concat($filterList, $this->total->AdvancedSearch->toJson(), ","); // Field total
        $filterList = Concat($filterList, $this->percent->AdvancedSearch->toJson(), ","); // Field percent
        $filterList = Concat($filterList, $this->s_1->AdvancedSearch->toJson(), ","); // Field s_1
        $filterList = Concat($filterList, $this->s_2->AdvancedSearch->toJson(), ","); // Field s_2
        $filterList = Concat($filterList, $this->s_3->AdvancedSearch->toJson(), ","); // Field s_3
        $filterList = Concat($filterList, $this->s_4->AdvancedSearch->toJson(), ","); // Field s_4
        $filterList = Concat($filterList, $this->s_5->AdvancedSearch->toJson(), ","); // Field s_5
        $filterList = Concat($filterList, $this->omr_image->AdvancedSearch->toJson(), ","); // Field omr_image
        $filterList = Concat($filterList, $this->_1->AdvancedSearch->toJson(), ","); // Field 1
        $filterList = Concat($filterList, $this->m_1->AdvancedSearch->toJson(), ","); // Field m_1
        $filterList = Concat($filterList, $this->_2->AdvancedSearch->toJson(), ","); // Field 2
        $filterList = Concat($filterList, $this->m_2->AdvancedSearch->toJson(), ","); // Field m_2
        $filterList = Concat($filterList, $this->_3->AdvancedSearch->toJson(), ","); // Field 3
        $filterList = Concat($filterList, $this->m_3->AdvancedSearch->toJson(), ","); // Field m_3
        $filterList = Concat($filterList, $this->_4->AdvancedSearch->toJson(), ","); // Field 4
        $filterList = Concat($filterList, $this->m_4->AdvancedSearch->toJson(), ","); // Field m_4
        $filterList = Concat($filterList, $this->_5->AdvancedSearch->toJson(), ","); // Field 5
        $filterList = Concat($filterList, $this->m_5->AdvancedSearch->toJson(), ","); // Field m_5
        $filterList = Concat($filterList, $this->_6->AdvancedSearch->toJson(), ","); // Field 6
        $filterList = Concat($filterList, $this->m_6->AdvancedSearch->toJson(), ","); // Field m_6
        $filterList = Concat($filterList, $this->_7->AdvancedSearch->toJson(), ","); // Field 7
        $filterList = Concat($filterList, $this->m_7->AdvancedSearch->toJson(), ","); // Field m_7
        $filterList = Concat($filterList, $this->_8->AdvancedSearch->toJson(), ","); // Field 8
        $filterList = Concat($filterList, $this->m_8->AdvancedSearch->toJson(), ","); // Field m_8
        $filterList = Concat($filterList, $this->_9->AdvancedSearch->toJson(), ","); // Field 9
        $filterList = Concat($filterList, $this->m_9->AdvancedSearch->toJson(), ","); // Field m_9
        $filterList = Concat($filterList, $this->_10->AdvancedSearch->toJson(), ","); // Field 10
        $filterList = Concat($filterList, $this->m_10->AdvancedSearch->toJson(), ","); // Field m_10
        $filterList = Concat($filterList, $this->_11->AdvancedSearch->toJson(), ","); // Field 11
        $filterList = Concat($filterList, $this->m_11->AdvancedSearch->toJson(), ","); // Field m_11
        $filterList = Concat($filterList, $this->_12->AdvancedSearch->toJson(), ","); // Field 12
        $filterList = Concat($filterList, $this->m_12->AdvancedSearch->toJson(), ","); // Field m_12
        $filterList = Concat($filterList, $this->_13->AdvancedSearch->toJson(), ","); // Field 13
        $filterList = Concat($filterList, $this->m_13->AdvancedSearch->toJson(), ","); // Field m_13
        $filterList = Concat($filterList, $this->_14->AdvancedSearch->toJson(), ","); // Field 14
        $filterList = Concat($filterList, $this->m_14->AdvancedSearch->toJson(), ","); // Field m_14
        $filterList = Concat($filterList, $this->_15->AdvancedSearch->toJson(), ","); // Field 15
        $filterList = Concat($filterList, $this->m_15->AdvancedSearch->toJson(), ","); // Field m_15
        $filterList = Concat($filterList, $this->_16->AdvancedSearch->toJson(), ","); // Field 16
        $filterList = Concat($filterList, $this->m_16->AdvancedSearch->toJson(), ","); // Field m_16
        $filterList = Concat($filterList, $this->_17->AdvancedSearch->toJson(), ","); // Field 17
        $filterList = Concat($filterList, $this->m_17->AdvancedSearch->toJson(), ","); // Field m_17
        $filterList = Concat($filterList, $this->_18->AdvancedSearch->toJson(), ","); // Field 18
        $filterList = Concat($filterList, $this->m_18->AdvancedSearch->toJson(), ","); // Field m_18
        $filterList = Concat($filterList, $this->_19->AdvancedSearch->toJson(), ","); // Field 19
        $filterList = Concat($filterList, $this->m_19->AdvancedSearch->toJson(), ","); // Field m_19
        $filterList = Concat($filterList, $this->_20->AdvancedSearch->toJson(), ","); // Field 20
        $filterList = Concat($filterList, $this->m_20->AdvancedSearch->toJson(), ","); // Field m_20
        $filterList = Concat($filterList, $this->_21->AdvancedSearch->toJson(), ","); // Field 21
        $filterList = Concat($filterList, $this->m_21->AdvancedSearch->toJson(), ","); // Field m_21
        $filterList = Concat($filterList, $this->_22->AdvancedSearch->toJson(), ","); // Field 22
        $filterList = Concat($filterList, $this->m_22->AdvancedSearch->toJson(), ","); // Field m_22
        $filterList = Concat($filterList, $this->_23->AdvancedSearch->toJson(), ","); // Field 23
        $filterList = Concat($filterList, $this->m_23->AdvancedSearch->toJson(), ","); // Field m_23
        $filterList = Concat($filterList, $this->_24->AdvancedSearch->toJson(), ","); // Field 24
        $filterList = Concat($filterList, $this->m_24->AdvancedSearch->toJson(), ","); // Field m_24
        $filterList = Concat($filterList, $this->_25->AdvancedSearch->toJson(), ","); // Field 25
        $filterList = Concat($filterList, $this->m_25->AdvancedSearch->toJson(), ","); // Field m_25
        $filterList = Concat($filterList, $this->_26->AdvancedSearch->toJson(), ","); // Field 26
        $filterList = Concat($filterList, $this->m_26->AdvancedSearch->toJson(), ","); // Field m_26
        $filterList = Concat($filterList, $this->_27->AdvancedSearch->toJson(), ","); // Field 27
        $filterList = Concat($filterList, $this->m_27->AdvancedSearch->toJson(), ","); // Field m_27
        $filterList = Concat($filterList, $this->_28->AdvancedSearch->toJson(), ","); // Field 28
        $filterList = Concat($filterList, $this->m_28->AdvancedSearch->toJson(), ","); // Field m_28
        $filterList = Concat($filterList, $this->_29->AdvancedSearch->toJson(), ","); // Field 29
        $filterList = Concat($filterList, $this->m_29->AdvancedSearch->toJson(), ","); // Field m_29
        $filterList = Concat($filterList, $this->_30->AdvancedSearch->toJson(), ","); // Field 30
        $filterList = Concat($filterList, $this->m_30->AdvancedSearch->toJson(), ","); // Field m_30
        $filterList = Concat($filterList, $this->_31->AdvancedSearch->toJson(), ","); // Field 31
        $filterList = Concat($filterList, $this->m_31->AdvancedSearch->toJson(), ","); // Field m_31
        $filterList = Concat($filterList, $this->_32->AdvancedSearch->toJson(), ","); // Field 32
        $filterList = Concat($filterList, $this->m_32->AdvancedSearch->toJson(), ","); // Field m_32
        $filterList = Concat($filterList, $this->_33->AdvancedSearch->toJson(), ","); // Field 33
        $filterList = Concat($filterList, $this->m_33->AdvancedSearch->toJson(), ","); // Field m_33
        $filterList = Concat($filterList, $this->_34->AdvancedSearch->toJson(), ","); // Field 34
        $filterList = Concat($filterList, $this->m_34->AdvancedSearch->toJson(), ","); // Field m_34
        $filterList = Concat($filterList, $this->_35->AdvancedSearch->toJson(), ","); // Field 35
        $filterList = Concat($filterList, $this->m_35->AdvancedSearch->toJson(), ","); // Field m_35
        $filterList = Concat($filterList, $this->_36->AdvancedSearch->toJson(), ","); // Field 36
        $filterList = Concat($filterList, $this->m_36->AdvancedSearch->toJson(), ","); // Field m_36
        $filterList = Concat($filterList, $this->_37->AdvancedSearch->toJson(), ","); // Field 37
        $filterList = Concat($filterList, $this->m_37->AdvancedSearch->toJson(), ","); // Field m_37
        $filterList = Concat($filterList, $this->_38->AdvancedSearch->toJson(), ","); // Field 38
        $filterList = Concat($filterList, $this->m_38->AdvancedSearch->toJson(), ","); // Field m_38
        $filterList = Concat($filterList, $this->_39->AdvancedSearch->toJson(), ","); // Field 39
        $filterList = Concat($filterList, $this->m_39->AdvancedSearch->toJson(), ","); // Field m_39
        $filterList = Concat($filterList, $this->_40->AdvancedSearch->toJson(), ","); // Field 40
        $filterList = Concat($filterList, $this->m_40->AdvancedSearch->toJson(), ","); // Field m_40
        $filterList = Concat($filterList, $this->_41->AdvancedSearch->toJson(), ","); // Field 41
        $filterList = Concat($filterList, $this->m_41->AdvancedSearch->toJson(), ","); // Field m_41
        $filterList = Concat($filterList, $this->_42->AdvancedSearch->toJson(), ","); // Field 42
        $filterList = Concat($filterList, $this->m_42->AdvancedSearch->toJson(), ","); // Field m_42
        $filterList = Concat($filterList, $this->_43->AdvancedSearch->toJson(), ","); // Field 43
        $filterList = Concat($filterList, $this->m_43->AdvancedSearch->toJson(), ","); // Field m_43
        $filterList = Concat($filterList, $this->_44->AdvancedSearch->toJson(), ","); // Field 44
        $filterList = Concat($filterList, $this->m_44->AdvancedSearch->toJson(), ","); // Field m_44
        $filterList = Concat($filterList, $this->_45->AdvancedSearch->toJson(), ","); // Field 45
        $filterList = Concat($filterList, $this->m_45->AdvancedSearch->toJson(), ","); // Field m_45
        $filterList = Concat($filterList, $this->_46->AdvancedSearch->toJson(), ","); // Field 46
        $filterList = Concat($filterList, $this->m_46->AdvancedSearch->toJson(), ","); // Field m_46
        $filterList = Concat($filterList, $this->_47->AdvancedSearch->toJson(), ","); // Field 47
        $filterList = Concat($filterList, $this->m_47->AdvancedSearch->toJson(), ","); // Field m_47
        $filterList = Concat($filterList, $this->_48->AdvancedSearch->toJson(), ","); // Field 48
        $filterList = Concat($filterList, $this->m_48->AdvancedSearch->toJson(), ","); // Field m_48
        $filterList = Concat($filterList, $this->_49->AdvancedSearch->toJson(), ","); // Field 49
        $filterList = Concat($filterList, $this->m_49->AdvancedSearch->toJson(), ","); // Field m_49
        $filterList = Concat($filterList, $this->_50->AdvancedSearch->toJson(), ","); // Field 50
        $filterList = Concat($filterList, $this->m_50->AdvancedSearch->toJson(), ","); // Field m_50
        $filterList = Concat($filterList, $this->_51->AdvancedSearch->toJson(), ","); // Field 51
        $filterList = Concat($filterList, $this->m_51->AdvancedSearch->toJson(), ","); // Field m_51
        $filterList = Concat($filterList, $this->_52->AdvancedSearch->toJson(), ","); // Field 52
        $filterList = Concat($filterList, $this->m_52->AdvancedSearch->toJson(), ","); // Field m_52
        $filterList = Concat($filterList, $this->_53->AdvancedSearch->toJson(), ","); // Field 53
        $filterList = Concat($filterList, $this->m_53->AdvancedSearch->toJson(), ","); // Field m_53
        $filterList = Concat($filterList, $this->_54->AdvancedSearch->toJson(), ","); // Field 54
        $filterList = Concat($filterList, $this->m_54->AdvancedSearch->toJson(), ","); // Field m_54
        $filterList = Concat($filterList, $this->_55->AdvancedSearch->toJson(), ","); // Field 55
        $filterList = Concat($filterList, $this->m_55->AdvancedSearch->toJson(), ","); // Field m_55
        $filterList = Concat($filterList, $this->_56->AdvancedSearch->toJson(), ","); // Field 56
        $filterList = Concat($filterList, $this->m_56->AdvancedSearch->toJson(), ","); // Field m_56
        $filterList = Concat($filterList, $this->_57->AdvancedSearch->toJson(), ","); // Field 57
        $filterList = Concat($filterList, $this->m_57->AdvancedSearch->toJson(), ","); // Field m_57
        $filterList = Concat($filterList, $this->_58->AdvancedSearch->toJson(), ","); // Field 58
        $filterList = Concat($filterList, $this->m_58->AdvancedSearch->toJson(), ","); // Field m_58
        $filterList = Concat($filterList, $this->_59->AdvancedSearch->toJson(), ","); // Field 59
        $filterList = Concat($filterList, $this->m_59->AdvancedSearch->toJson(), ","); // Field m_59
        $filterList = Concat($filterList, $this->_60->AdvancedSearch->toJson(), ","); // Field 60
        $filterList = Concat($filterList, $this->m_60->AdvancedSearch->toJson(), ","); // Field m_60
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fs_omr_valuesrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field roll_no
        $this->roll_no->AdvancedSearch->SearchValue = @$filter["x_roll_no"];
        $this->roll_no->AdvancedSearch->SearchOperator = @$filter["z_roll_no"];
        $this->roll_no->AdvancedSearch->SearchCondition = @$filter["v_roll_no"];
        $this->roll_no->AdvancedSearch->SearchValue2 = @$filter["y_roll_no"];
        $this->roll_no->AdvancedSearch->SearchOperator2 = @$filter["w_roll_no"];
        $this->roll_no->AdvancedSearch->save();

        // Field test_id
        $this->test_id->AdvancedSearch->SearchValue = @$filter["x_test_id"];
        $this->test_id->AdvancedSearch->SearchOperator = @$filter["z_test_id"];
        $this->test_id->AdvancedSearch->SearchCondition = @$filter["v_test_id"];
        $this->test_id->AdvancedSearch->SearchValue2 = @$filter["y_test_id"];
        $this->test_id->AdvancedSearch->SearchOperator2 = @$filter["w_test_id"];
        $this->test_id->AdvancedSearch->save();

        // Field total
        $this->total->AdvancedSearch->SearchValue = @$filter["x_total"];
        $this->total->AdvancedSearch->SearchOperator = @$filter["z_total"];
        $this->total->AdvancedSearch->SearchCondition = @$filter["v_total"];
        $this->total->AdvancedSearch->SearchValue2 = @$filter["y_total"];
        $this->total->AdvancedSearch->SearchOperator2 = @$filter["w_total"];
        $this->total->AdvancedSearch->save();

        // Field percent
        $this->percent->AdvancedSearch->SearchValue = @$filter["x_percent"];
        $this->percent->AdvancedSearch->SearchOperator = @$filter["z_percent"];
        $this->percent->AdvancedSearch->SearchCondition = @$filter["v_percent"];
        $this->percent->AdvancedSearch->SearchValue2 = @$filter["y_percent"];
        $this->percent->AdvancedSearch->SearchOperator2 = @$filter["w_percent"];
        $this->percent->AdvancedSearch->save();

        // Field s_1
        $this->s_1->AdvancedSearch->SearchValue = @$filter["x_s_1"];
        $this->s_1->AdvancedSearch->SearchOperator = @$filter["z_s_1"];
        $this->s_1->AdvancedSearch->SearchCondition = @$filter["v_s_1"];
        $this->s_1->AdvancedSearch->SearchValue2 = @$filter["y_s_1"];
        $this->s_1->AdvancedSearch->SearchOperator2 = @$filter["w_s_1"];
        $this->s_1->AdvancedSearch->save();

        // Field s_2
        $this->s_2->AdvancedSearch->SearchValue = @$filter["x_s_2"];
        $this->s_2->AdvancedSearch->SearchOperator = @$filter["z_s_2"];
        $this->s_2->AdvancedSearch->SearchCondition = @$filter["v_s_2"];
        $this->s_2->AdvancedSearch->SearchValue2 = @$filter["y_s_2"];
        $this->s_2->AdvancedSearch->SearchOperator2 = @$filter["w_s_2"];
        $this->s_2->AdvancedSearch->save();

        // Field s_3
        $this->s_3->AdvancedSearch->SearchValue = @$filter["x_s_3"];
        $this->s_3->AdvancedSearch->SearchOperator = @$filter["z_s_3"];
        $this->s_3->AdvancedSearch->SearchCondition = @$filter["v_s_3"];
        $this->s_3->AdvancedSearch->SearchValue2 = @$filter["y_s_3"];
        $this->s_3->AdvancedSearch->SearchOperator2 = @$filter["w_s_3"];
        $this->s_3->AdvancedSearch->save();

        // Field s_4
        $this->s_4->AdvancedSearch->SearchValue = @$filter["x_s_4"];
        $this->s_4->AdvancedSearch->SearchOperator = @$filter["z_s_4"];
        $this->s_4->AdvancedSearch->SearchCondition = @$filter["v_s_4"];
        $this->s_4->AdvancedSearch->SearchValue2 = @$filter["y_s_4"];
        $this->s_4->AdvancedSearch->SearchOperator2 = @$filter["w_s_4"];
        $this->s_4->AdvancedSearch->save();

        // Field s_5
        $this->s_5->AdvancedSearch->SearchValue = @$filter["x_s_5"];
        $this->s_5->AdvancedSearch->SearchOperator = @$filter["z_s_5"];
        $this->s_5->AdvancedSearch->SearchCondition = @$filter["v_s_5"];
        $this->s_5->AdvancedSearch->SearchValue2 = @$filter["y_s_5"];
        $this->s_5->AdvancedSearch->SearchOperator2 = @$filter["w_s_5"];
        $this->s_5->AdvancedSearch->save();

        // Field omr_image
        $this->omr_image->AdvancedSearch->SearchValue = @$filter["x_omr_image"];
        $this->omr_image->AdvancedSearch->SearchOperator = @$filter["z_omr_image"];
        $this->omr_image->AdvancedSearch->SearchCondition = @$filter["v_omr_image"];
        $this->omr_image->AdvancedSearch->SearchValue2 = @$filter["y_omr_image"];
        $this->omr_image->AdvancedSearch->SearchOperator2 = @$filter["w_omr_image"];
        $this->omr_image->AdvancedSearch->save();

        // Field 1
        $this->_1->AdvancedSearch->SearchValue = @$filter["x__1"];
        $this->_1->AdvancedSearch->SearchOperator = @$filter["z__1"];
        $this->_1->AdvancedSearch->SearchCondition = @$filter["v__1"];
        $this->_1->AdvancedSearch->SearchValue2 = @$filter["y__1"];
        $this->_1->AdvancedSearch->SearchOperator2 = @$filter["w__1"];
        $this->_1->AdvancedSearch->save();

        // Field m_1
        $this->m_1->AdvancedSearch->SearchValue = @$filter["x_m_1"];
        $this->m_1->AdvancedSearch->SearchOperator = @$filter["z_m_1"];
        $this->m_1->AdvancedSearch->SearchCondition = @$filter["v_m_1"];
        $this->m_1->AdvancedSearch->SearchValue2 = @$filter["y_m_1"];
        $this->m_1->AdvancedSearch->SearchOperator2 = @$filter["w_m_1"];
        $this->m_1->AdvancedSearch->save();

        // Field 2
        $this->_2->AdvancedSearch->SearchValue = @$filter["x__2"];
        $this->_2->AdvancedSearch->SearchOperator = @$filter["z__2"];
        $this->_2->AdvancedSearch->SearchCondition = @$filter["v__2"];
        $this->_2->AdvancedSearch->SearchValue2 = @$filter["y__2"];
        $this->_2->AdvancedSearch->SearchOperator2 = @$filter["w__2"];
        $this->_2->AdvancedSearch->save();

        // Field m_2
        $this->m_2->AdvancedSearch->SearchValue = @$filter["x_m_2"];
        $this->m_2->AdvancedSearch->SearchOperator = @$filter["z_m_2"];
        $this->m_2->AdvancedSearch->SearchCondition = @$filter["v_m_2"];
        $this->m_2->AdvancedSearch->SearchValue2 = @$filter["y_m_2"];
        $this->m_2->AdvancedSearch->SearchOperator2 = @$filter["w_m_2"];
        $this->m_2->AdvancedSearch->save();

        // Field 3
        $this->_3->AdvancedSearch->SearchValue = @$filter["x__3"];
        $this->_3->AdvancedSearch->SearchOperator = @$filter["z__3"];
        $this->_3->AdvancedSearch->SearchCondition = @$filter["v__3"];
        $this->_3->AdvancedSearch->SearchValue2 = @$filter["y__3"];
        $this->_3->AdvancedSearch->SearchOperator2 = @$filter["w__3"];
        $this->_3->AdvancedSearch->save();

        // Field m_3
        $this->m_3->AdvancedSearch->SearchValue = @$filter["x_m_3"];
        $this->m_3->AdvancedSearch->SearchOperator = @$filter["z_m_3"];
        $this->m_3->AdvancedSearch->SearchCondition = @$filter["v_m_3"];
        $this->m_3->AdvancedSearch->SearchValue2 = @$filter["y_m_3"];
        $this->m_3->AdvancedSearch->SearchOperator2 = @$filter["w_m_3"];
        $this->m_3->AdvancedSearch->save();

        // Field 4
        $this->_4->AdvancedSearch->SearchValue = @$filter["x__4"];
        $this->_4->AdvancedSearch->SearchOperator = @$filter["z__4"];
        $this->_4->AdvancedSearch->SearchCondition = @$filter["v__4"];
        $this->_4->AdvancedSearch->SearchValue2 = @$filter["y__4"];
        $this->_4->AdvancedSearch->SearchOperator2 = @$filter["w__4"];
        $this->_4->AdvancedSearch->save();

        // Field m_4
        $this->m_4->AdvancedSearch->SearchValue = @$filter["x_m_4"];
        $this->m_4->AdvancedSearch->SearchOperator = @$filter["z_m_4"];
        $this->m_4->AdvancedSearch->SearchCondition = @$filter["v_m_4"];
        $this->m_4->AdvancedSearch->SearchValue2 = @$filter["y_m_4"];
        $this->m_4->AdvancedSearch->SearchOperator2 = @$filter["w_m_4"];
        $this->m_4->AdvancedSearch->save();

        // Field 5
        $this->_5->AdvancedSearch->SearchValue = @$filter["x__5"];
        $this->_5->AdvancedSearch->SearchOperator = @$filter["z__5"];
        $this->_5->AdvancedSearch->SearchCondition = @$filter["v__5"];
        $this->_5->AdvancedSearch->SearchValue2 = @$filter["y__5"];
        $this->_5->AdvancedSearch->SearchOperator2 = @$filter["w__5"];
        $this->_5->AdvancedSearch->save();

        // Field m_5
        $this->m_5->AdvancedSearch->SearchValue = @$filter["x_m_5"];
        $this->m_5->AdvancedSearch->SearchOperator = @$filter["z_m_5"];
        $this->m_5->AdvancedSearch->SearchCondition = @$filter["v_m_5"];
        $this->m_5->AdvancedSearch->SearchValue2 = @$filter["y_m_5"];
        $this->m_5->AdvancedSearch->SearchOperator2 = @$filter["w_m_5"];
        $this->m_5->AdvancedSearch->save();

        // Field 6
        $this->_6->AdvancedSearch->SearchValue = @$filter["x__6"];
        $this->_6->AdvancedSearch->SearchOperator = @$filter["z__6"];
        $this->_6->AdvancedSearch->SearchCondition = @$filter["v__6"];
        $this->_6->AdvancedSearch->SearchValue2 = @$filter["y__6"];
        $this->_6->AdvancedSearch->SearchOperator2 = @$filter["w__6"];
        $this->_6->AdvancedSearch->save();

        // Field m_6
        $this->m_6->AdvancedSearch->SearchValue = @$filter["x_m_6"];
        $this->m_6->AdvancedSearch->SearchOperator = @$filter["z_m_6"];
        $this->m_6->AdvancedSearch->SearchCondition = @$filter["v_m_6"];
        $this->m_6->AdvancedSearch->SearchValue2 = @$filter["y_m_6"];
        $this->m_6->AdvancedSearch->SearchOperator2 = @$filter["w_m_6"];
        $this->m_6->AdvancedSearch->save();

        // Field 7
        $this->_7->AdvancedSearch->SearchValue = @$filter["x__7"];
        $this->_7->AdvancedSearch->SearchOperator = @$filter["z__7"];
        $this->_7->AdvancedSearch->SearchCondition = @$filter["v__7"];
        $this->_7->AdvancedSearch->SearchValue2 = @$filter["y__7"];
        $this->_7->AdvancedSearch->SearchOperator2 = @$filter["w__7"];
        $this->_7->AdvancedSearch->save();

        // Field m_7
        $this->m_7->AdvancedSearch->SearchValue = @$filter["x_m_7"];
        $this->m_7->AdvancedSearch->SearchOperator = @$filter["z_m_7"];
        $this->m_7->AdvancedSearch->SearchCondition = @$filter["v_m_7"];
        $this->m_7->AdvancedSearch->SearchValue2 = @$filter["y_m_7"];
        $this->m_7->AdvancedSearch->SearchOperator2 = @$filter["w_m_7"];
        $this->m_7->AdvancedSearch->save();

        // Field 8
        $this->_8->AdvancedSearch->SearchValue = @$filter["x__8"];
        $this->_8->AdvancedSearch->SearchOperator = @$filter["z__8"];
        $this->_8->AdvancedSearch->SearchCondition = @$filter["v__8"];
        $this->_8->AdvancedSearch->SearchValue2 = @$filter["y__8"];
        $this->_8->AdvancedSearch->SearchOperator2 = @$filter["w__8"];
        $this->_8->AdvancedSearch->save();

        // Field m_8
        $this->m_8->AdvancedSearch->SearchValue = @$filter["x_m_8"];
        $this->m_8->AdvancedSearch->SearchOperator = @$filter["z_m_8"];
        $this->m_8->AdvancedSearch->SearchCondition = @$filter["v_m_8"];
        $this->m_8->AdvancedSearch->SearchValue2 = @$filter["y_m_8"];
        $this->m_8->AdvancedSearch->SearchOperator2 = @$filter["w_m_8"];
        $this->m_8->AdvancedSearch->save();

        // Field 9
        $this->_9->AdvancedSearch->SearchValue = @$filter["x__9"];
        $this->_9->AdvancedSearch->SearchOperator = @$filter["z__9"];
        $this->_9->AdvancedSearch->SearchCondition = @$filter["v__9"];
        $this->_9->AdvancedSearch->SearchValue2 = @$filter["y__9"];
        $this->_9->AdvancedSearch->SearchOperator2 = @$filter["w__9"];
        $this->_9->AdvancedSearch->save();

        // Field m_9
        $this->m_9->AdvancedSearch->SearchValue = @$filter["x_m_9"];
        $this->m_9->AdvancedSearch->SearchOperator = @$filter["z_m_9"];
        $this->m_9->AdvancedSearch->SearchCondition = @$filter["v_m_9"];
        $this->m_9->AdvancedSearch->SearchValue2 = @$filter["y_m_9"];
        $this->m_9->AdvancedSearch->SearchOperator2 = @$filter["w_m_9"];
        $this->m_9->AdvancedSearch->save();

        // Field 10
        $this->_10->AdvancedSearch->SearchValue = @$filter["x__10"];
        $this->_10->AdvancedSearch->SearchOperator = @$filter["z__10"];
        $this->_10->AdvancedSearch->SearchCondition = @$filter["v__10"];
        $this->_10->AdvancedSearch->SearchValue2 = @$filter["y__10"];
        $this->_10->AdvancedSearch->SearchOperator2 = @$filter["w__10"];
        $this->_10->AdvancedSearch->save();

        // Field m_10
        $this->m_10->AdvancedSearch->SearchValue = @$filter["x_m_10"];
        $this->m_10->AdvancedSearch->SearchOperator = @$filter["z_m_10"];
        $this->m_10->AdvancedSearch->SearchCondition = @$filter["v_m_10"];
        $this->m_10->AdvancedSearch->SearchValue2 = @$filter["y_m_10"];
        $this->m_10->AdvancedSearch->SearchOperator2 = @$filter["w_m_10"];
        $this->m_10->AdvancedSearch->save();

        // Field 11
        $this->_11->AdvancedSearch->SearchValue = @$filter["x__11"];
        $this->_11->AdvancedSearch->SearchOperator = @$filter["z__11"];
        $this->_11->AdvancedSearch->SearchCondition = @$filter["v__11"];
        $this->_11->AdvancedSearch->SearchValue2 = @$filter["y__11"];
        $this->_11->AdvancedSearch->SearchOperator2 = @$filter["w__11"];
        $this->_11->AdvancedSearch->save();

        // Field m_11
        $this->m_11->AdvancedSearch->SearchValue = @$filter["x_m_11"];
        $this->m_11->AdvancedSearch->SearchOperator = @$filter["z_m_11"];
        $this->m_11->AdvancedSearch->SearchCondition = @$filter["v_m_11"];
        $this->m_11->AdvancedSearch->SearchValue2 = @$filter["y_m_11"];
        $this->m_11->AdvancedSearch->SearchOperator2 = @$filter["w_m_11"];
        $this->m_11->AdvancedSearch->save();

        // Field 12
        $this->_12->AdvancedSearch->SearchValue = @$filter["x__12"];
        $this->_12->AdvancedSearch->SearchOperator = @$filter["z__12"];
        $this->_12->AdvancedSearch->SearchCondition = @$filter["v__12"];
        $this->_12->AdvancedSearch->SearchValue2 = @$filter["y__12"];
        $this->_12->AdvancedSearch->SearchOperator2 = @$filter["w__12"];
        $this->_12->AdvancedSearch->save();

        // Field m_12
        $this->m_12->AdvancedSearch->SearchValue = @$filter["x_m_12"];
        $this->m_12->AdvancedSearch->SearchOperator = @$filter["z_m_12"];
        $this->m_12->AdvancedSearch->SearchCondition = @$filter["v_m_12"];
        $this->m_12->AdvancedSearch->SearchValue2 = @$filter["y_m_12"];
        $this->m_12->AdvancedSearch->SearchOperator2 = @$filter["w_m_12"];
        $this->m_12->AdvancedSearch->save();

        // Field 13
        $this->_13->AdvancedSearch->SearchValue = @$filter["x__13"];
        $this->_13->AdvancedSearch->SearchOperator = @$filter["z__13"];
        $this->_13->AdvancedSearch->SearchCondition = @$filter["v__13"];
        $this->_13->AdvancedSearch->SearchValue2 = @$filter["y__13"];
        $this->_13->AdvancedSearch->SearchOperator2 = @$filter["w__13"];
        $this->_13->AdvancedSearch->save();

        // Field m_13
        $this->m_13->AdvancedSearch->SearchValue = @$filter["x_m_13"];
        $this->m_13->AdvancedSearch->SearchOperator = @$filter["z_m_13"];
        $this->m_13->AdvancedSearch->SearchCondition = @$filter["v_m_13"];
        $this->m_13->AdvancedSearch->SearchValue2 = @$filter["y_m_13"];
        $this->m_13->AdvancedSearch->SearchOperator2 = @$filter["w_m_13"];
        $this->m_13->AdvancedSearch->save();

        // Field 14
        $this->_14->AdvancedSearch->SearchValue = @$filter["x__14"];
        $this->_14->AdvancedSearch->SearchOperator = @$filter["z__14"];
        $this->_14->AdvancedSearch->SearchCondition = @$filter["v__14"];
        $this->_14->AdvancedSearch->SearchValue2 = @$filter["y__14"];
        $this->_14->AdvancedSearch->SearchOperator2 = @$filter["w__14"];
        $this->_14->AdvancedSearch->save();

        // Field m_14
        $this->m_14->AdvancedSearch->SearchValue = @$filter["x_m_14"];
        $this->m_14->AdvancedSearch->SearchOperator = @$filter["z_m_14"];
        $this->m_14->AdvancedSearch->SearchCondition = @$filter["v_m_14"];
        $this->m_14->AdvancedSearch->SearchValue2 = @$filter["y_m_14"];
        $this->m_14->AdvancedSearch->SearchOperator2 = @$filter["w_m_14"];
        $this->m_14->AdvancedSearch->save();

        // Field 15
        $this->_15->AdvancedSearch->SearchValue = @$filter["x__15"];
        $this->_15->AdvancedSearch->SearchOperator = @$filter["z__15"];
        $this->_15->AdvancedSearch->SearchCondition = @$filter["v__15"];
        $this->_15->AdvancedSearch->SearchValue2 = @$filter["y__15"];
        $this->_15->AdvancedSearch->SearchOperator2 = @$filter["w__15"];
        $this->_15->AdvancedSearch->save();

        // Field m_15
        $this->m_15->AdvancedSearch->SearchValue = @$filter["x_m_15"];
        $this->m_15->AdvancedSearch->SearchOperator = @$filter["z_m_15"];
        $this->m_15->AdvancedSearch->SearchCondition = @$filter["v_m_15"];
        $this->m_15->AdvancedSearch->SearchValue2 = @$filter["y_m_15"];
        $this->m_15->AdvancedSearch->SearchOperator2 = @$filter["w_m_15"];
        $this->m_15->AdvancedSearch->save();

        // Field 16
        $this->_16->AdvancedSearch->SearchValue = @$filter["x__16"];
        $this->_16->AdvancedSearch->SearchOperator = @$filter["z__16"];
        $this->_16->AdvancedSearch->SearchCondition = @$filter["v__16"];
        $this->_16->AdvancedSearch->SearchValue2 = @$filter["y__16"];
        $this->_16->AdvancedSearch->SearchOperator2 = @$filter["w__16"];
        $this->_16->AdvancedSearch->save();

        // Field m_16
        $this->m_16->AdvancedSearch->SearchValue = @$filter["x_m_16"];
        $this->m_16->AdvancedSearch->SearchOperator = @$filter["z_m_16"];
        $this->m_16->AdvancedSearch->SearchCondition = @$filter["v_m_16"];
        $this->m_16->AdvancedSearch->SearchValue2 = @$filter["y_m_16"];
        $this->m_16->AdvancedSearch->SearchOperator2 = @$filter["w_m_16"];
        $this->m_16->AdvancedSearch->save();

        // Field 17
        $this->_17->AdvancedSearch->SearchValue = @$filter["x__17"];
        $this->_17->AdvancedSearch->SearchOperator = @$filter["z__17"];
        $this->_17->AdvancedSearch->SearchCondition = @$filter["v__17"];
        $this->_17->AdvancedSearch->SearchValue2 = @$filter["y__17"];
        $this->_17->AdvancedSearch->SearchOperator2 = @$filter["w__17"];
        $this->_17->AdvancedSearch->save();

        // Field m_17
        $this->m_17->AdvancedSearch->SearchValue = @$filter["x_m_17"];
        $this->m_17->AdvancedSearch->SearchOperator = @$filter["z_m_17"];
        $this->m_17->AdvancedSearch->SearchCondition = @$filter["v_m_17"];
        $this->m_17->AdvancedSearch->SearchValue2 = @$filter["y_m_17"];
        $this->m_17->AdvancedSearch->SearchOperator2 = @$filter["w_m_17"];
        $this->m_17->AdvancedSearch->save();

        // Field 18
        $this->_18->AdvancedSearch->SearchValue = @$filter["x__18"];
        $this->_18->AdvancedSearch->SearchOperator = @$filter["z__18"];
        $this->_18->AdvancedSearch->SearchCondition = @$filter["v__18"];
        $this->_18->AdvancedSearch->SearchValue2 = @$filter["y__18"];
        $this->_18->AdvancedSearch->SearchOperator2 = @$filter["w__18"];
        $this->_18->AdvancedSearch->save();

        // Field m_18
        $this->m_18->AdvancedSearch->SearchValue = @$filter["x_m_18"];
        $this->m_18->AdvancedSearch->SearchOperator = @$filter["z_m_18"];
        $this->m_18->AdvancedSearch->SearchCondition = @$filter["v_m_18"];
        $this->m_18->AdvancedSearch->SearchValue2 = @$filter["y_m_18"];
        $this->m_18->AdvancedSearch->SearchOperator2 = @$filter["w_m_18"];
        $this->m_18->AdvancedSearch->save();

        // Field 19
        $this->_19->AdvancedSearch->SearchValue = @$filter["x__19"];
        $this->_19->AdvancedSearch->SearchOperator = @$filter["z__19"];
        $this->_19->AdvancedSearch->SearchCondition = @$filter["v__19"];
        $this->_19->AdvancedSearch->SearchValue2 = @$filter["y__19"];
        $this->_19->AdvancedSearch->SearchOperator2 = @$filter["w__19"];
        $this->_19->AdvancedSearch->save();

        // Field m_19
        $this->m_19->AdvancedSearch->SearchValue = @$filter["x_m_19"];
        $this->m_19->AdvancedSearch->SearchOperator = @$filter["z_m_19"];
        $this->m_19->AdvancedSearch->SearchCondition = @$filter["v_m_19"];
        $this->m_19->AdvancedSearch->SearchValue2 = @$filter["y_m_19"];
        $this->m_19->AdvancedSearch->SearchOperator2 = @$filter["w_m_19"];
        $this->m_19->AdvancedSearch->save();

        // Field 20
        $this->_20->AdvancedSearch->SearchValue = @$filter["x__20"];
        $this->_20->AdvancedSearch->SearchOperator = @$filter["z__20"];
        $this->_20->AdvancedSearch->SearchCondition = @$filter["v__20"];
        $this->_20->AdvancedSearch->SearchValue2 = @$filter["y__20"];
        $this->_20->AdvancedSearch->SearchOperator2 = @$filter["w__20"];
        $this->_20->AdvancedSearch->save();

        // Field m_20
        $this->m_20->AdvancedSearch->SearchValue = @$filter["x_m_20"];
        $this->m_20->AdvancedSearch->SearchOperator = @$filter["z_m_20"];
        $this->m_20->AdvancedSearch->SearchCondition = @$filter["v_m_20"];
        $this->m_20->AdvancedSearch->SearchValue2 = @$filter["y_m_20"];
        $this->m_20->AdvancedSearch->SearchOperator2 = @$filter["w_m_20"];
        $this->m_20->AdvancedSearch->save();

        // Field 21
        $this->_21->AdvancedSearch->SearchValue = @$filter["x__21"];
        $this->_21->AdvancedSearch->SearchOperator = @$filter["z__21"];
        $this->_21->AdvancedSearch->SearchCondition = @$filter["v__21"];
        $this->_21->AdvancedSearch->SearchValue2 = @$filter["y__21"];
        $this->_21->AdvancedSearch->SearchOperator2 = @$filter["w__21"];
        $this->_21->AdvancedSearch->save();

        // Field m_21
        $this->m_21->AdvancedSearch->SearchValue = @$filter["x_m_21"];
        $this->m_21->AdvancedSearch->SearchOperator = @$filter["z_m_21"];
        $this->m_21->AdvancedSearch->SearchCondition = @$filter["v_m_21"];
        $this->m_21->AdvancedSearch->SearchValue2 = @$filter["y_m_21"];
        $this->m_21->AdvancedSearch->SearchOperator2 = @$filter["w_m_21"];
        $this->m_21->AdvancedSearch->save();

        // Field 22
        $this->_22->AdvancedSearch->SearchValue = @$filter["x__22"];
        $this->_22->AdvancedSearch->SearchOperator = @$filter["z__22"];
        $this->_22->AdvancedSearch->SearchCondition = @$filter["v__22"];
        $this->_22->AdvancedSearch->SearchValue2 = @$filter["y__22"];
        $this->_22->AdvancedSearch->SearchOperator2 = @$filter["w__22"];
        $this->_22->AdvancedSearch->save();

        // Field m_22
        $this->m_22->AdvancedSearch->SearchValue = @$filter["x_m_22"];
        $this->m_22->AdvancedSearch->SearchOperator = @$filter["z_m_22"];
        $this->m_22->AdvancedSearch->SearchCondition = @$filter["v_m_22"];
        $this->m_22->AdvancedSearch->SearchValue2 = @$filter["y_m_22"];
        $this->m_22->AdvancedSearch->SearchOperator2 = @$filter["w_m_22"];
        $this->m_22->AdvancedSearch->save();

        // Field 23
        $this->_23->AdvancedSearch->SearchValue = @$filter["x__23"];
        $this->_23->AdvancedSearch->SearchOperator = @$filter["z__23"];
        $this->_23->AdvancedSearch->SearchCondition = @$filter["v__23"];
        $this->_23->AdvancedSearch->SearchValue2 = @$filter["y__23"];
        $this->_23->AdvancedSearch->SearchOperator2 = @$filter["w__23"];
        $this->_23->AdvancedSearch->save();

        // Field m_23
        $this->m_23->AdvancedSearch->SearchValue = @$filter["x_m_23"];
        $this->m_23->AdvancedSearch->SearchOperator = @$filter["z_m_23"];
        $this->m_23->AdvancedSearch->SearchCondition = @$filter["v_m_23"];
        $this->m_23->AdvancedSearch->SearchValue2 = @$filter["y_m_23"];
        $this->m_23->AdvancedSearch->SearchOperator2 = @$filter["w_m_23"];
        $this->m_23->AdvancedSearch->save();

        // Field 24
        $this->_24->AdvancedSearch->SearchValue = @$filter["x__24"];
        $this->_24->AdvancedSearch->SearchOperator = @$filter["z__24"];
        $this->_24->AdvancedSearch->SearchCondition = @$filter["v__24"];
        $this->_24->AdvancedSearch->SearchValue2 = @$filter["y__24"];
        $this->_24->AdvancedSearch->SearchOperator2 = @$filter["w__24"];
        $this->_24->AdvancedSearch->save();

        // Field m_24
        $this->m_24->AdvancedSearch->SearchValue = @$filter["x_m_24"];
        $this->m_24->AdvancedSearch->SearchOperator = @$filter["z_m_24"];
        $this->m_24->AdvancedSearch->SearchCondition = @$filter["v_m_24"];
        $this->m_24->AdvancedSearch->SearchValue2 = @$filter["y_m_24"];
        $this->m_24->AdvancedSearch->SearchOperator2 = @$filter["w_m_24"];
        $this->m_24->AdvancedSearch->save();

        // Field 25
        $this->_25->AdvancedSearch->SearchValue = @$filter["x__25"];
        $this->_25->AdvancedSearch->SearchOperator = @$filter["z__25"];
        $this->_25->AdvancedSearch->SearchCondition = @$filter["v__25"];
        $this->_25->AdvancedSearch->SearchValue2 = @$filter["y__25"];
        $this->_25->AdvancedSearch->SearchOperator2 = @$filter["w__25"];
        $this->_25->AdvancedSearch->save();

        // Field m_25
        $this->m_25->AdvancedSearch->SearchValue = @$filter["x_m_25"];
        $this->m_25->AdvancedSearch->SearchOperator = @$filter["z_m_25"];
        $this->m_25->AdvancedSearch->SearchCondition = @$filter["v_m_25"];
        $this->m_25->AdvancedSearch->SearchValue2 = @$filter["y_m_25"];
        $this->m_25->AdvancedSearch->SearchOperator2 = @$filter["w_m_25"];
        $this->m_25->AdvancedSearch->save();

        // Field 26
        $this->_26->AdvancedSearch->SearchValue = @$filter["x__26"];
        $this->_26->AdvancedSearch->SearchOperator = @$filter["z__26"];
        $this->_26->AdvancedSearch->SearchCondition = @$filter["v__26"];
        $this->_26->AdvancedSearch->SearchValue2 = @$filter["y__26"];
        $this->_26->AdvancedSearch->SearchOperator2 = @$filter["w__26"];
        $this->_26->AdvancedSearch->save();

        // Field m_26
        $this->m_26->AdvancedSearch->SearchValue = @$filter["x_m_26"];
        $this->m_26->AdvancedSearch->SearchOperator = @$filter["z_m_26"];
        $this->m_26->AdvancedSearch->SearchCondition = @$filter["v_m_26"];
        $this->m_26->AdvancedSearch->SearchValue2 = @$filter["y_m_26"];
        $this->m_26->AdvancedSearch->SearchOperator2 = @$filter["w_m_26"];
        $this->m_26->AdvancedSearch->save();

        // Field 27
        $this->_27->AdvancedSearch->SearchValue = @$filter["x__27"];
        $this->_27->AdvancedSearch->SearchOperator = @$filter["z__27"];
        $this->_27->AdvancedSearch->SearchCondition = @$filter["v__27"];
        $this->_27->AdvancedSearch->SearchValue2 = @$filter["y__27"];
        $this->_27->AdvancedSearch->SearchOperator2 = @$filter["w__27"];
        $this->_27->AdvancedSearch->save();

        // Field m_27
        $this->m_27->AdvancedSearch->SearchValue = @$filter["x_m_27"];
        $this->m_27->AdvancedSearch->SearchOperator = @$filter["z_m_27"];
        $this->m_27->AdvancedSearch->SearchCondition = @$filter["v_m_27"];
        $this->m_27->AdvancedSearch->SearchValue2 = @$filter["y_m_27"];
        $this->m_27->AdvancedSearch->SearchOperator2 = @$filter["w_m_27"];
        $this->m_27->AdvancedSearch->save();

        // Field 28
        $this->_28->AdvancedSearch->SearchValue = @$filter["x__28"];
        $this->_28->AdvancedSearch->SearchOperator = @$filter["z__28"];
        $this->_28->AdvancedSearch->SearchCondition = @$filter["v__28"];
        $this->_28->AdvancedSearch->SearchValue2 = @$filter["y__28"];
        $this->_28->AdvancedSearch->SearchOperator2 = @$filter["w__28"];
        $this->_28->AdvancedSearch->save();

        // Field m_28
        $this->m_28->AdvancedSearch->SearchValue = @$filter["x_m_28"];
        $this->m_28->AdvancedSearch->SearchOperator = @$filter["z_m_28"];
        $this->m_28->AdvancedSearch->SearchCondition = @$filter["v_m_28"];
        $this->m_28->AdvancedSearch->SearchValue2 = @$filter["y_m_28"];
        $this->m_28->AdvancedSearch->SearchOperator2 = @$filter["w_m_28"];
        $this->m_28->AdvancedSearch->save();

        // Field 29
        $this->_29->AdvancedSearch->SearchValue = @$filter["x__29"];
        $this->_29->AdvancedSearch->SearchOperator = @$filter["z__29"];
        $this->_29->AdvancedSearch->SearchCondition = @$filter["v__29"];
        $this->_29->AdvancedSearch->SearchValue2 = @$filter["y__29"];
        $this->_29->AdvancedSearch->SearchOperator2 = @$filter["w__29"];
        $this->_29->AdvancedSearch->save();

        // Field m_29
        $this->m_29->AdvancedSearch->SearchValue = @$filter["x_m_29"];
        $this->m_29->AdvancedSearch->SearchOperator = @$filter["z_m_29"];
        $this->m_29->AdvancedSearch->SearchCondition = @$filter["v_m_29"];
        $this->m_29->AdvancedSearch->SearchValue2 = @$filter["y_m_29"];
        $this->m_29->AdvancedSearch->SearchOperator2 = @$filter["w_m_29"];
        $this->m_29->AdvancedSearch->save();

        // Field 30
        $this->_30->AdvancedSearch->SearchValue = @$filter["x__30"];
        $this->_30->AdvancedSearch->SearchOperator = @$filter["z__30"];
        $this->_30->AdvancedSearch->SearchCondition = @$filter["v__30"];
        $this->_30->AdvancedSearch->SearchValue2 = @$filter["y__30"];
        $this->_30->AdvancedSearch->SearchOperator2 = @$filter["w__30"];
        $this->_30->AdvancedSearch->save();

        // Field m_30
        $this->m_30->AdvancedSearch->SearchValue = @$filter["x_m_30"];
        $this->m_30->AdvancedSearch->SearchOperator = @$filter["z_m_30"];
        $this->m_30->AdvancedSearch->SearchCondition = @$filter["v_m_30"];
        $this->m_30->AdvancedSearch->SearchValue2 = @$filter["y_m_30"];
        $this->m_30->AdvancedSearch->SearchOperator2 = @$filter["w_m_30"];
        $this->m_30->AdvancedSearch->save();

        // Field 31
        $this->_31->AdvancedSearch->SearchValue = @$filter["x__31"];
        $this->_31->AdvancedSearch->SearchOperator = @$filter["z__31"];
        $this->_31->AdvancedSearch->SearchCondition = @$filter["v__31"];
        $this->_31->AdvancedSearch->SearchValue2 = @$filter["y__31"];
        $this->_31->AdvancedSearch->SearchOperator2 = @$filter["w__31"];
        $this->_31->AdvancedSearch->save();

        // Field m_31
        $this->m_31->AdvancedSearch->SearchValue = @$filter["x_m_31"];
        $this->m_31->AdvancedSearch->SearchOperator = @$filter["z_m_31"];
        $this->m_31->AdvancedSearch->SearchCondition = @$filter["v_m_31"];
        $this->m_31->AdvancedSearch->SearchValue2 = @$filter["y_m_31"];
        $this->m_31->AdvancedSearch->SearchOperator2 = @$filter["w_m_31"];
        $this->m_31->AdvancedSearch->save();

        // Field 32
        $this->_32->AdvancedSearch->SearchValue = @$filter["x__32"];
        $this->_32->AdvancedSearch->SearchOperator = @$filter["z__32"];
        $this->_32->AdvancedSearch->SearchCondition = @$filter["v__32"];
        $this->_32->AdvancedSearch->SearchValue2 = @$filter["y__32"];
        $this->_32->AdvancedSearch->SearchOperator2 = @$filter["w__32"];
        $this->_32->AdvancedSearch->save();

        // Field m_32
        $this->m_32->AdvancedSearch->SearchValue = @$filter["x_m_32"];
        $this->m_32->AdvancedSearch->SearchOperator = @$filter["z_m_32"];
        $this->m_32->AdvancedSearch->SearchCondition = @$filter["v_m_32"];
        $this->m_32->AdvancedSearch->SearchValue2 = @$filter["y_m_32"];
        $this->m_32->AdvancedSearch->SearchOperator2 = @$filter["w_m_32"];
        $this->m_32->AdvancedSearch->save();

        // Field 33
        $this->_33->AdvancedSearch->SearchValue = @$filter["x__33"];
        $this->_33->AdvancedSearch->SearchOperator = @$filter["z__33"];
        $this->_33->AdvancedSearch->SearchCondition = @$filter["v__33"];
        $this->_33->AdvancedSearch->SearchValue2 = @$filter["y__33"];
        $this->_33->AdvancedSearch->SearchOperator2 = @$filter["w__33"];
        $this->_33->AdvancedSearch->save();

        // Field m_33
        $this->m_33->AdvancedSearch->SearchValue = @$filter["x_m_33"];
        $this->m_33->AdvancedSearch->SearchOperator = @$filter["z_m_33"];
        $this->m_33->AdvancedSearch->SearchCondition = @$filter["v_m_33"];
        $this->m_33->AdvancedSearch->SearchValue2 = @$filter["y_m_33"];
        $this->m_33->AdvancedSearch->SearchOperator2 = @$filter["w_m_33"];
        $this->m_33->AdvancedSearch->save();

        // Field 34
        $this->_34->AdvancedSearch->SearchValue = @$filter["x__34"];
        $this->_34->AdvancedSearch->SearchOperator = @$filter["z__34"];
        $this->_34->AdvancedSearch->SearchCondition = @$filter["v__34"];
        $this->_34->AdvancedSearch->SearchValue2 = @$filter["y__34"];
        $this->_34->AdvancedSearch->SearchOperator2 = @$filter["w__34"];
        $this->_34->AdvancedSearch->save();

        // Field m_34
        $this->m_34->AdvancedSearch->SearchValue = @$filter["x_m_34"];
        $this->m_34->AdvancedSearch->SearchOperator = @$filter["z_m_34"];
        $this->m_34->AdvancedSearch->SearchCondition = @$filter["v_m_34"];
        $this->m_34->AdvancedSearch->SearchValue2 = @$filter["y_m_34"];
        $this->m_34->AdvancedSearch->SearchOperator2 = @$filter["w_m_34"];
        $this->m_34->AdvancedSearch->save();

        // Field 35
        $this->_35->AdvancedSearch->SearchValue = @$filter["x__35"];
        $this->_35->AdvancedSearch->SearchOperator = @$filter["z__35"];
        $this->_35->AdvancedSearch->SearchCondition = @$filter["v__35"];
        $this->_35->AdvancedSearch->SearchValue2 = @$filter["y__35"];
        $this->_35->AdvancedSearch->SearchOperator2 = @$filter["w__35"];
        $this->_35->AdvancedSearch->save();

        // Field m_35
        $this->m_35->AdvancedSearch->SearchValue = @$filter["x_m_35"];
        $this->m_35->AdvancedSearch->SearchOperator = @$filter["z_m_35"];
        $this->m_35->AdvancedSearch->SearchCondition = @$filter["v_m_35"];
        $this->m_35->AdvancedSearch->SearchValue2 = @$filter["y_m_35"];
        $this->m_35->AdvancedSearch->SearchOperator2 = @$filter["w_m_35"];
        $this->m_35->AdvancedSearch->save();

        // Field 36
        $this->_36->AdvancedSearch->SearchValue = @$filter["x__36"];
        $this->_36->AdvancedSearch->SearchOperator = @$filter["z__36"];
        $this->_36->AdvancedSearch->SearchCondition = @$filter["v__36"];
        $this->_36->AdvancedSearch->SearchValue2 = @$filter["y__36"];
        $this->_36->AdvancedSearch->SearchOperator2 = @$filter["w__36"];
        $this->_36->AdvancedSearch->save();

        // Field m_36
        $this->m_36->AdvancedSearch->SearchValue = @$filter["x_m_36"];
        $this->m_36->AdvancedSearch->SearchOperator = @$filter["z_m_36"];
        $this->m_36->AdvancedSearch->SearchCondition = @$filter["v_m_36"];
        $this->m_36->AdvancedSearch->SearchValue2 = @$filter["y_m_36"];
        $this->m_36->AdvancedSearch->SearchOperator2 = @$filter["w_m_36"];
        $this->m_36->AdvancedSearch->save();

        // Field 37
        $this->_37->AdvancedSearch->SearchValue = @$filter["x__37"];
        $this->_37->AdvancedSearch->SearchOperator = @$filter["z__37"];
        $this->_37->AdvancedSearch->SearchCondition = @$filter["v__37"];
        $this->_37->AdvancedSearch->SearchValue2 = @$filter["y__37"];
        $this->_37->AdvancedSearch->SearchOperator2 = @$filter["w__37"];
        $this->_37->AdvancedSearch->save();

        // Field m_37
        $this->m_37->AdvancedSearch->SearchValue = @$filter["x_m_37"];
        $this->m_37->AdvancedSearch->SearchOperator = @$filter["z_m_37"];
        $this->m_37->AdvancedSearch->SearchCondition = @$filter["v_m_37"];
        $this->m_37->AdvancedSearch->SearchValue2 = @$filter["y_m_37"];
        $this->m_37->AdvancedSearch->SearchOperator2 = @$filter["w_m_37"];
        $this->m_37->AdvancedSearch->save();

        // Field 38
        $this->_38->AdvancedSearch->SearchValue = @$filter["x__38"];
        $this->_38->AdvancedSearch->SearchOperator = @$filter["z__38"];
        $this->_38->AdvancedSearch->SearchCondition = @$filter["v__38"];
        $this->_38->AdvancedSearch->SearchValue2 = @$filter["y__38"];
        $this->_38->AdvancedSearch->SearchOperator2 = @$filter["w__38"];
        $this->_38->AdvancedSearch->save();

        // Field m_38
        $this->m_38->AdvancedSearch->SearchValue = @$filter["x_m_38"];
        $this->m_38->AdvancedSearch->SearchOperator = @$filter["z_m_38"];
        $this->m_38->AdvancedSearch->SearchCondition = @$filter["v_m_38"];
        $this->m_38->AdvancedSearch->SearchValue2 = @$filter["y_m_38"];
        $this->m_38->AdvancedSearch->SearchOperator2 = @$filter["w_m_38"];
        $this->m_38->AdvancedSearch->save();

        // Field 39
        $this->_39->AdvancedSearch->SearchValue = @$filter["x__39"];
        $this->_39->AdvancedSearch->SearchOperator = @$filter["z__39"];
        $this->_39->AdvancedSearch->SearchCondition = @$filter["v__39"];
        $this->_39->AdvancedSearch->SearchValue2 = @$filter["y__39"];
        $this->_39->AdvancedSearch->SearchOperator2 = @$filter["w__39"];
        $this->_39->AdvancedSearch->save();

        // Field m_39
        $this->m_39->AdvancedSearch->SearchValue = @$filter["x_m_39"];
        $this->m_39->AdvancedSearch->SearchOperator = @$filter["z_m_39"];
        $this->m_39->AdvancedSearch->SearchCondition = @$filter["v_m_39"];
        $this->m_39->AdvancedSearch->SearchValue2 = @$filter["y_m_39"];
        $this->m_39->AdvancedSearch->SearchOperator2 = @$filter["w_m_39"];
        $this->m_39->AdvancedSearch->save();

        // Field 40
        $this->_40->AdvancedSearch->SearchValue = @$filter["x__40"];
        $this->_40->AdvancedSearch->SearchOperator = @$filter["z__40"];
        $this->_40->AdvancedSearch->SearchCondition = @$filter["v__40"];
        $this->_40->AdvancedSearch->SearchValue2 = @$filter["y__40"];
        $this->_40->AdvancedSearch->SearchOperator2 = @$filter["w__40"];
        $this->_40->AdvancedSearch->save();

        // Field m_40
        $this->m_40->AdvancedSearch->SearchValue = @$filter["x_m_40"];
        $this->m_40->AdvancedSearch->SearchOperator = @$filter["z_m_40"];
        $this->m_40->AdvancedSearch->SearchCondition = @$filter["v_m_40"];
        $this->m_40->AdvancedSearch->SearchValue2 = @$filter["y_m_40"];
        $this->m_40->AdvancedSearch->SearchOperator2 = @$filter["w_m_40"];
        $this->m_40->AdvancedSearch->save();

        // Field 41
        $this->_41->AdvancedSearch->SearchValue = @$filter["x__41"];
        $this->_41->AdvancedSearch->SearchOperator = @$filter["z__41"];
        $this->_41->AdvancedSearch->SearchCondition = @$filter["v__41"];
        $this->_41->AdvancedSearch->SearchValue2 = @$filter["y__41"];
        $this->_41->AdvancedSearch->SearchOperator2 = @$filter["w__41"];
        $this->_41->AdvancedSearch->save();

        // Field m_41
        $this->m_41->AdvancedSearch->SearchValue = @$filter["x_m_41"];
        $this->m_41->AdvancedSearch->SearchOperator = @$filter["z_m_41"];
        $this->m_41->AdvancedSearch->SearchCondition = @$filter["v_m_41"];
        $this->m_41->AdvancedSearch->SearchValue2 = @$filter["y_m_41"];
        $this->m_41->AdvancedSearch->SearchOperator2 = @$filter["w_m_41"];
        $this->m_41->AdvancedSearch->save();

        // Field 42
        $this->_42->AdvancedSearch->SearchValue = @$filter["x__42"];
        $this->_42->AdvancedSearch->SearchOperator = @$filter["z__42"];
        $this->_42->AdvancedSearch->SearchCondition = @$filter["v__42"];
        $this->_42->AdvancedSearch->SearchValue2 = @$filter["y__42"];
        $this->_42->AdvancedSearch->SearchOperator2 = @$filter["w__42"];
        $this->_42->AdvancedSearch->save();

        // Field m_42
        $this->m_42->AdvancedSearch->SearchValue = @$filter["x_m_42"];
        $this->m_42->AdvancedSearch->SearchOperator = @$filter["z_m_42"];
        $this->m_42->AdvancedSearch->SearchCondition = @$filter["v_m_42"];
        $this->m_42->AdvancedSearch->SearchValue2 = @$filter["y_m_42"];
        $this->m_42->AdvancedSearch->SearchOperator2 = @$filter["w_m_42"];
        $this->m_42->AdvancedSearch->save();

        // Field 43
        $this->_43->AdvancedSearch->SearchValue = @$filter["x__43"];
        $this->_43->AdvancedSearch->SearchOperator = @$filter["z__43"];
        $this->_43->AdvancedSearch->SearchCondition = @$filter["v__43"];
        $this->_43->AdvancedSearch->SearchValue2 = @$filter["y__43"];
        $this->_43->AdvancedSearch->SearchOperator2 = @$filter["w__43"];
        $this->_43->AdvancedSearch->save();

        // Field m_43
        $this->m_43->AdvancedSearch->SearchValue = @$filter["x_m_43"];
        $this->m_43->AdvancedSearch->SearchOperator = @$filter["z_m_43"];
        $this->m_43->AdvancedSearch->SearchCondition = @$filter["v_m_43"];
        $this->m_43->AdvancedSearch->SearchValue2 = @$filter["y_m_43"];
        $this->m_43->AdvancedSearch->SearchOperator2 = @$filter["w_m_43"];
        $this->m_43->AdvancedSearch->save();

        // Field 44
        $this->_44->AdvancedSearch->SearchValue = @$filter["x__44"];
        $this->_44->AdvancedSearch->SearchOperator = @$filter["z__44"];
        $this->_44->AdvancedSearch->SearchCondition = @$filter["v__44"];
        $this->_44->AdvancedSearch->SearchValue2 = @$filter["y__44"];
        $this->_44->AdvancedSearch->SearchOperator2 = @$filter["w__44"];
        $this->_44->AdvancedSearch->save();

        // Field m_44
        $this->m_44->AdvancedSearch->SearchValue = @$filter["x_m_44"];
        $this->m_44->AdvancedSearch->SearchOperator = @$filter["z_m_44"];
        $this->m_44->AdvancedSearch->SearchCondition = @$filter["v_m_44"];
        $this->m_44->AdvancedSearch->SearchValue2 = @$filter["y_m_44"];
        $this->m_44->AdvancedSearch->SearchOperator2 = @$filter["w_m_44"];
        $this->m_44->AdvancedSearch->save();

        // Field 45
        $this->_45->AdvancedSearch->SearchValue = @$filter["x__45"];
        $this->_45->AdvancedSearch->SearchOperator = @$filter["z__45"];
        $this->_45->AdvancedSearch->SearchCondition = @$filter["v__45"];
        $this->_45->AdvancedSearch->SearchValue2 = @$filter["y__45"];
        $this->_45->AdvancedSearch->SearchOperator2 = @$filter["w__45"];
        $this->_45->AdvancedSearch->save();

        // Field m_45
        $this->m_45->AdvancedSearch->SearchValue = @$filter["x_m_45"];
        $this->m_45->AdvancedSearch->SearchOperator = @$filter["z_m_45"];
        $this->m_45->AdvancedSearch->SearchCondition = @$filter["v_m_45"];
        $this->m_45->AdvancedSearch->SearchValue2 = @$filter["y_m_45"];
        $this->m_45->AdvancedSearch->SearchOperator2 = @$filter["w_m_45"];
        $this->m_45->AdvancedSearch->save();

        // Field 46
        $this->_46->AdvancedSearch->SearchValue = @$filter["x__46"];
        $this->_46->AdvancedSearch->SearchOperator = @$filter["z__46"];
        $this->_46->AdvancedSearch->SearchCondition = @$filter["v__46"];
        $this->_46->AdvancedSearch->SearchValue2 = @$filter["y__46"];
        $this->_46->AdvancedSearch->SearchOperator2 = @$filter["w__46"];
        $this->_46->AdvancedSearch->save();

        // Field m_46
        $this->m_46->AdvancedSearch->SearchValue = @$filter["x_m_46"];
        $this->m_46->AdvancedSearch->SearchOperator = @$filter["z_m_46"];
        $this->m_46->AdvancedSearch->SearchCondition = @$filter["v_m_46"];
        $this->m_46->AdvancedSearch->SearchValue2 = @$filter["y_m_46"];
        $this->m_46->AdvancedSearch->SearchOperator2 = @$filter["w_m_46"];
        $this->m_46->AdvancedSearch->save();

        // Field 47
        $this->_47->AdvancedSearch->SearchValue = @$filter["x__47"];
        $this->_47->AdvancedSearch->SearchOperator = @$filter["z__47"];
        $this->_47->AdvancedSearch->SearchCondition = @$filter["v__47"];
        $this->_47->AdvancedSearch->SearchValue2 = @$filter["y__47"];
        $this->_47->AdvancedSearch->SearchOperator2 = @$filter["w__47"];
        $this->_47->AdvancedSearch->save();

        // Field m_47
        $this->m_47->AdvancedSearch->SearchValue = @$filter["x_m_47"];
        $this->m_47->AdvancedSearch->SearchOperator = @$filter["z_m_47"];
        $this->m_47->AdvancedSearch->SearchCondition = @$filter["v_m_47"];
        $this->m_47->AdvancedSearch->SearchValue2 = @$filter["y_m_47"];
        $this->m_47->AdvancedSearch->SearchOperator2 = @$filter["w_m_47"];
        $this->m_47->AdvancedSearch->save();

        // Field 48
        $this->_48->AdvancedSearch->SearchValue = @$filter["x__48"];
        $this->_48->AdvancedSearch->SearchOperator = @$filter["z__48"];
        $this->_48->AdvancedSearch->SearchCondition = @$filter["v__48"];
        $this->_48->AdvancedSearch->SearchValue2 = @$filter["y__48"];
        $this->_48->AdvancedSearch->SearchOperator2 = @$filter["w__48"];
        $this->_48->AdvancedSearch->save();

        // Field m_48
        $this->m_48->AdvancedSearch->SearchValue = @$filter["x_m_48"];
        $this->m_48->AdvancedSearch->SearchOperator = @$filter["z_m_48"];
        $this->m_48->AdvancedSearch->SearchCondition = @$filter["v_m_48"];
        $this->m_48->AdvancedSearch->SearchValue2 = @$filter["y_m_48"];
        $this->m_48->AdvancedSearch->SearchOperator2 = @$filter["w_m_48"];
        $this->m_48->AdvancedSearch->save();

        // Field 49
        $this->_49->AdvancedSearch->SearchValue = @$filter["x__49"];
        $this->_49->AdvancedSearch->SearchOperator = @$filter["z__49"];
        $this->_49->AdvancedSearch->SearchCondition = @$filter["v__49"];
        $this->_49->AdvancedSearch->SearchValue2 = @$filter["y__49"];
        $this->_49->AdvancedSearch->SearchOperator2 = @$filter["w__49"];
        $this->_49->AdvancedSearch->save();

        // Field m_49
        $this->m_49->AdvancedSearch->SearchValue = @$filter["x_m_49"];
        $this->m_49->AdvancedSearch->SearchOperator = @$filter["z_m_49"];
        $this->m_49->AdvancedSearch->SearchCondition = @$filter["v_m_49"];
        $this->m_49->AdvancedSearch->SearchValue2 = @$filter["y_m_49"];
        $this->m_49->AdvancedSearch->SearchOperator2 = @$filter["w_m_49"];
        $this->m_49->AdvancedSearch->save();

        // Field 50
        $this->_50->AdvancedSearch->SearchValue = @$filter["x__50"];
        $this->_50->AdvancedSearch->SearchOperator = @$filter["z__50"];
        $this->_50->AdvancedSearch->SearchCondition = @$filter["v__50"];
        $this->_50->AdvancedSearch->SearchValue2 = @$filter["y__50"];
        $this->_50->AdvancedSearch->SearchOperator2 = @$filter["w__50"];
        $this->_50->AdvancedSearch->save();

        // Field m_50
        $this->m_50->AdvancedSearch->SearchValue = @$filter["x_m_50"];
        $this->m_50->AdvancedSearch->SearchOperator = @$filter["z_m_50"];
        $this->m_50->AdvancedSearch->SearchCondition = @$filter["v_m_50"];
        $this->m_50->AdvancedSearch->SearchValue2 = @$filter["y_m_50"];
        $this->m_50->AdvancedSearch->SearchOperator2 = @$filter["w_m_50"];
        $this->m_50->AdvancedSearch->save();

        // Field 51
        $this->_51->AdvancedSearch->SearchValue = @$filter["x__51"];
        $this->_51->AdvancedSearch->SearchOperator = @$filter["z__51"];
        $this->_51->AdvancedSearch->SearchCondition = @$filter["v__51"];
        $this->_51->AdvancedSearch->SearchValue2 = @$filter["y__51"];
        $this->_51->AdvancedSearch->SearchOperator2 = @$filter["w__51"];
        $this->_51->AdvancedSearch->save();

        // Field m_51
        $this->m_51->AdvancedSearch->SearchValue = @$filter["x_m_51"];
        $this->m_51->AdvancedSearch->SearchOperator = @$filter["z_m_51"];
        $this->m_51->AdvancedSearch->SearchCondition = @$filter["v_m_51"];
        $this->m_51->AdvancedSearch->SearchValue2 = @$filter["y_m_51"];
        $this->m_51->AdvancedSearch->SearchOperator2 = @$filter["w_m_51"];
        $this->m_51->AdvancedSearch->save();

        // Field 52
        $this->_52->AdvancedSearch->SearchValue = @$filter["x__52"];
        $this->_52->AdvancedSearch->SearchOperator = @$filter["z__52"];
        $this->_52->AdvancedSearch->SearchCondition = @$filter["v__52"];
        $this->_52->AdvancedSearch->SearchValue2 = @$filter["y__52"];
        $this->_52->AdvancedSearch->SearchOperator2 = @$filter["w__52"];
        $this->_52->AdvancedSearch->save();

        // Field m_52
        $this->m_52->AdvancedSearch->SearchValue = @$filter["x_m_52"];
        $this->m_52->AdvancedSearch->SearchOperator = @$filter["z_m_52"];
        $this->m_52->AdvancedSearch->SearchCondition = @$filter["v_m_52"];
        $this->m_52->AdvancedSearch->SearchValue2 = @$filter["y_m_52"];
        $this->m_52->AdvancedSearch->SearchOperator2 = @$filter["w_m_52"];
        $this->m_52->AdvancedSearch->save();

        // Field 53
        $this->_53->AdvancedSearch->SearchValue = @$filter["x__53"];
        $this->_53->AdvancedSearch->SearchOperator = @$filter["z__53"];
        $this->_53->AdvancedSearch->SearchCondition = @$filter["v__53"];
        $this->_53->AdvancedSearch->SearchValue2 = @$filter["y__53"];
        $this->_53->AdvancedSearch->SearchOperator2 = @$filter["w__53"];
        $this->_53->AdvancedSearch->save();

        // Field m_53
        $this->m_53->AdvancedSearch->SearchValue = @$filter["x_m_53"];
        $this->m_53->AdvancedSearch->SearchOperator = @$filter["z_m_53"];
        $this->m_53->AdvancedSearch->SearchCondition = @$filter["v_m_53"];
        $this->m_53->AdvancedSearch->SearchValue2 = @$filter["y_m_53"];
        $this->m_53->AdvancedSearch->SearchOperator2 = @$filter["w_m_53"];
        $this->m_53->AdvancedSearch->save();

        // Field 54
        $this->_54->AdvancedSearch->SearchValue = @$filter["x__54"];
        $this->_54->AdvancedSearch->SearchOperator = @$filter["z__54"];
        $this->_54->AdvancedSearch->SearchCondition = @$filter["v__54"];
        $this->_54->AdvancedSearch->SearchValue2 = @$filter["y__54"];
        $this->_54->AdvancedSearch->SearchOperator2 = @$filter["w__54"];
        $this->_54->AdvancedSearch->save();

        // Field m_54
        $this->m_54->AdvancedSearch->SearchValue = @$filter["x_m_54"];
        $this->m_54->AdvancedSearch->SearchOperator = @$filter["z_m_54"];
        $this->m_54->AdvancedSearch->SearchCondition = @$filter["v_m_54"];
        $this->m_54->AdvancedSearch->SearchValue2 = @$filter["y_m_54"];
        $this->m_54->AdvancedSearch->SearchOperator2 = @$filter["w_m_54"];
        $this->m_54->AdvancedSearch->save();

        // Field 55
        $this->_55->AdvancedSearch->SearchValue = @$filter["x__55"];
        $this->_55->AdvancedSearch->SearchOperator = @$filter["z__55"];
        $this->_55->AdvancedSearch->SearchCondition = @$filter["v__55"];
        $this->_55->AdvancedSearch->SearchValue2 = @$filter["y__55"];
        $this->_55->AdvancedSearch->SearchOperator2 = @$filter["w__55"];
        $this->_55->AdvancedSearch->save();

        // Field m_55
        $this->m_55->AdvancedSearch->SearchValue = @$filter["x_m_55"];
        $this->m_55->AdvancedSearch->SearchOperator = @$filter["z_m_55"];
        $this->m_55->AdvancedSearch->SearchCondition = @$filter["v_m_55"];
        $this->m_55->AdvancedSearch->SearchValue2 = @$filter["y_m_55"];
        $this->m_55->AdvancedSearch->SearchOperator2 = @$filter["w_m_55"];
        $this->m_55->AdvancedSearch->save();

        // Field 56
        $this->_56->AdvancedSearch->SearchValue = @$filter["x__56"];
        $this->_56->AdvancedSearch->SearchOperator = @$filter["z__56"];
        $this->_56->AdvancedSearch->SearchCondition = @$filter["v__56"];
        $this->_56->AdvancedSearch->SearchValue2 = @$filter["y__56"];
        $this->_56->AdvancedSearch->SearchOperator2 = @$filter["w__56"];
        $this->_56->AdvancedSearch->save();

        // Field m_56
        $this->m_56->AdvancedSearch->SearchValue = @$filter["x_m_56"];
        $this->m_56->AdvancedSearch->SearchOperator = @$filter["z_m_56"];
        $this->m_56->AdvancedSearch->SearchCondition = @$filter["v_m_56"];
        $this->m_56->AdvancedSearch->SearchValue2 = @$filter["y_m_56"];
        $this->m_56->AdvancedSearch->SearchOperator2 = @$filter["w_m_56"];
        $this->m_56->AdvancedSearch->save();

        // Field 57
        $this->_57->AdvancedSearch->SearchValue = @$filter["x__57"];
        $this->_57->AdvancedSearch->SearchOperator = @$filter["z__57"];
        $this->_57->AdvancedSearch->SearchCondition = @$filter["v__57"];
        $this->_57->AdvancedSearch->SearchValue2 = @$filter["y__57"];
        $this->_57->AdvancedSearch->SearchOperator2 = @$filter["w__57"];
        $this->_57->AdvancedSearch->save();

        // Field m_57
        $this->m_57->AdvancedSearch->SearchValue = @$filter["x_m_57"];
        $this->m_57->AdvancedSearch->SearchOperator = @$filter["z_m_57"];
        $this->m_57->AdvancedSearch->SearchCondition = @$filter["v_m_57"];
        $this->m_57->AdvancedSearch->SearchValue2 = @$filter["y_m_57"];
        $this->m_57->AdvancedSearch->SearchOperator2 = @$filter["w_m_57"];
        $this->m_57->AdvancedSearch->save();

        // Field 58
        $this->_58->AdvancedSearch->SearchValue = @$filter["x__58"];
        $this->_58->AdvancedSearch->SearchOperator = @$filter["z__58"];
        $this->_58->AdvancedSearch->SearchCondition = @$filter["v__58"];
        $this->_58->AdvancedSearch->SearchValue2 = @$filter["y__58"];
        $this->_58->AdvancedSearch->SearchOperator2 = @$filter["w__58"];
        $this->_58->AdvancedSearch->save();

        // Field m_58
        $this->m_58->AdvancedSearch->SearchValue = @$filter["x_m_58"];
        $this->m_58->AdvancedSearch->SearchOperator = @$filter["z_m_58"];
        $this->m_58->AdvancedSearch->SearchCondition = @$filter["v_m_58"];
        $this->m_58->AdvancedSearch->SearchValue2 = @$filter["y_m_58"];
        $this->m_58->AdvancedSearch->SearchOperator2 = @$filter["w_m_58"];
        $this->m_58->AdvancedSearch->save();

        // Field 59
        $this->_59->AdvancedSearch->SearchValue = @$filter["x__59"];
        $this->_59->AdvancedSearch->SearchOperator = @$filter["z__59"];
        $this->_59->AdvancedSearch->SearchCondition = @$filter["v__59"];
        $this->_59->AdvancedSearch->SearchValue2 = @$filter["y__59"];
        $this->_59->AdvancedSearch->SearchOperator2 = @$filter["w__59"];
        $this->_59->AdvancedSearch->save();

        // Field m_59
        $this->m_59->AdvancedSearch->SearchValue = @$filter["x_m_59"];
        $this->m_59->AdvancedSearch->SearchOperator = @$filter["z_m_59"];
        $this->m_59->AdvancedSearch->SearchCondition = @$filter["v_m_59"];
        $this->m_59->AdvancedSearch->SearchValue2 = @$filter["y_m_59"];
        $this->m_59->AdvancedSearch->SearchOperator2 = @$filter["w_m_59"];
        $this->m_59->AdvancedSearch->save();

        // Field 60
        $this->_60->AdvancedSearch->SearchValue = @$filter["x__60"];
        $this->_60->AdvancedSearch->SearchOperator = @$filter["z__60"];
        $this->_60->AdvancedSearch->SearchCondition = @$filter["v__60"];
        $this->_60->AdvancedSearch->SearchValue2 = @$filter["y__60"];
        $this->_60->AdvancedSearch->SearchOperator2 = @$filter["w__60"];
        $this->_60->AdvancedSearch->save();

        // Field m_60
        $this->m_60->AdvancedSearch->SearchValue = @$filter["x_m_60"];
        $this->m_60->AdvancedSearch->SearchOperator = @$filter["z_m_60"];
        $this->m_60->AdvancedSearch->SearchCondition = @$filter["v_m_60"];
        $this->m_60->AdvancedSearch->SearchValue2 = @$filter["y_m_60"];
        $this->m_60->AdvancedSearch->SearchOperator2 = @$filter["w_m_60"];
        $this->m_60->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->roll_no, $default, false); // roll_no
        $this->buildSearchSql($where, $this->test_id, $default, false); // test_id
        $this->buildSearchSql($where, $this->total, $default, false); // total
        $this->buildSearchSql($where, $this->percent, $default, false); // percent
        $this->buildSearchSql($where, $this->s_1, $default, false); // s_1
        $this->buildSearchSql($where, $this->s_2, $default, false); // s_2
        $this->buildSearchSql($where, $this->s_3, $default, false); // s_3
        $this->buildSearchSql($where, $this->s_4, $default, false); // s_4
        $this->buildSearchSql($where, $this->s_5, $default, false); // s_5
        $this->buildSearchSql($where, $this->omr_image, $default, false); // omr_image
        $this->buildSearchSql($where, $this->_1, $default, false); // 1
        $this->buildSearchSql($where, $this->m_1, $default, false); // m_1
        $this->buildSearchSql($where, $this->_2, $default, false); // 2
        $this->buildSearchSql($where, $this->m_2, $default, false); // m_2
        $this->buildSearchSql($where, $this->_3, $default, false); // 3
        $this->buildSearchSql($where, $this->m_3, $default, false); // m_3
        $this->buildSearchSql($where, $this->_4, $default, false); // 4
        $this->buildSearchSql($where, $this->m_4, $default, false); // m_4
        $this->buildSearchSql($where, $this->_5, $default, false); // 5
        $this->buildSearchSql($where, $this->m_5, $default, false); // m_5
        $this->buildSearchSql($where, $this->_6, $default, false); // 6
        $this->buildSearchSql($where, $this->m_6, $default, false); // m_6
        $this->buildSearchSql($where, $this->_7, $default, false); // 7
        $this->buildSearchSql($where, $this->m_7, $default, false); // m_7
        $this->buildSearchSql($where, $this->_8, $default, false); // 8
        $this->buildSearchSql($where, $this->m_8, $default, false); // m_8
        $this->buildSearchSql($where, $this->_9, $default, false); // 9
        $this->buildSearchSql($where, $this->m_9, $default, false); // m_9
        $this->buildSearchSql($where, $this->_10, $default, false); // 10
        $this->buildSearchSql($where, $this->m_10, $default, false); // m_10
        $this->buildSearchSql($where, $this->_11, $default, false); // 11
        $this->buildSearchSql($where, $this->m_11, $default, false); // m_11
        $this->buildSearchSql($where, $this->_12, $default, false); // 12
        $this->buildSearchSql($where, $this->m_12, $default, false); // m_12
        $this->buildSearchSql($where, $this->_13, $default, false); // 13
        $this->buildSearchSql($where, $this->m_13, $default, false); // m_13
        $this->buildSearchSql($where, $this->_14, $default, false); // 14
        $this->buildSearchSql($where, $this->m_14, $default, false); // m_14
        $this->buildSearchSql($where, $this->_15, $default, false); // 15
        $this->buildSearchSql($where, $this->m_15, $default, false); // m_15
        $this->buildSearchSql($where, $this->_16, $default, false); // 16
        $this->buildSearchSql($where, $this->m_16, $default, false); // m_16
        $this->buildSearchSql($where, $this->_17, $default, false); // 17
        $this->buildSearchSql($where, $this->m_17, $default, false); // m_17
        $this->buildSearchSql($where, $this->_18, $default, false); // 18
        $this->buildSearchSql($where, $this->m_18, $default, false); // m_18
        $this->buildSearchSql($where, $this->_19, $default, false); // 19
        $this->buildSearchSql($where, $this->m_19, $default, false); // m_19
        $this->buildSearchSql($where, $this->_20, $default, false); // 20
        $this->buildSearchSql($where, $this->m_20, $default, false); // m_20
        $this->buildSearchSql($where, $this->_21, $default, false); // 21
        $this->buildSearchSql($where, $this->m_21, $default, false); // m_21
        $this->buildSearchSql($where, $this->_22, $default, false); // 22
        $this->buildSearchSql($where, $this->m_22, $default, false); // m_22
        $this->buildSearchSql($where, $this->_23, $default, false); // 23
        $this->buildSearchSql($where, $this->m_23, $default, false); // m_23
        $this->buildSearchSql($where, $this->_24, $default, false); // 24
        $this->buildSearchSql($where, $this->m_24, $default, false); // m_24
        $this->buildSearchSql($where, $this->_25, $default, false); // 25
        $this->buildSearchSql($where, $this->m_25, $default, false); // m_25
        $this->buildSearchSql($where, $this->_26, $default, false); // 26
        $this->buildSearchSql($where, $this->m_26, $default, false); // m_26
        $this->buildSearchSql($where, $this->_27, $default, false); // 27
        $this->buildSearchSql($where, $this->m_27, $default, false); // m_27
        $this->buildSearchSql($where, $this->_28, $default, false); // 28
        $this->buildSearchSql($where, $this->m_28, $default, false); // m_28
        $this->buildSearchSql($where, $this->_29, $default, false); // 29
        $this->buildSearchSql($where, $this->m_29, $default, false); // m_29
        $this->buildSearchSql($where, $this->_30, $default, false); // 30
        $this->buildSearchSql($where, $this->m_30, $default, false); // m_30
        $this->buildSearchSql($where, $this->_31, $default, false); // 31
        $this->buildSearchSql($where, $this->m_31, $default, false); // m_31
        $this->buildSearchSql($where, $this->_32, $default, false); // 32
        $this->buildSearchSql($where, $this->m_32, $default, false); // m_32
        $this->buildSearchSql($where, $this->_33, $default, false); // 33
        $this->buildSearchSql($where, $this->m_33, $default, false); // m_33
        $this->buildSearchSql($where, $this->_34, $default, false); // 34
        $this->buildSearchSql($where, $this->m_34, $default, false); // m_34
        $this->buildSearchSql($where, $this->_35, $default, false); // 35
        $this->buildSearchSql($where, $this->m_35, $default, false); // m_35
        $this->buildSearchSql($where, $this->_36, $default, false); // 36
        $this->buildSearchSql($where, $this->m_36, $default, false); // m_36
        $this->buildSearchSql($where, $this->_37, $default, false); // 37
        $this->buildSearchSql($where, $this->m_37, $default, false); // m_37
        $this->buildSearchSql($where, $this->_38, $default, false); // 38
        $this->buildSearchSql($where, $this->m_38, $default, false); // m_38
        $this->buildSearchSql($where, $this->_39, $default, false); // 39
        $this->buildSearchSql($where, $this->m_39, $default, false); // m_39
        $this->buildSearchSql($where, $this->_40, $default, false); // 40
        $this->buildSearchSql($where, $this->m_40, $default, false); // m_40
        $this->buildSearchSql($where, $this->_41, $default, false); // 41
        $this->buildSearchSql($where, $this->m_41, $default, false); // m_41
        $this->buildSearchSql($where, $this->_42, $default, false); // 42
        $this->buildSearchSql($where, $this->m_42, $default, false); // m_42
        $this->buildSearchSql($where, $this->_43, $default, false); // 43
        $this->buildSearchSql($where, $this->m_43, $default, false); // m_43
        $this->buildSearchSql($where, $this->_44, $default, false); // 44
        $this->buildSearchSql($where, $this->m_44, $default, false); // m_44
        $this->buildSearchSql($where, $this->_45, $default, false); // 45
        $this->buildSearchSql($where, $this->m_45, $default, false); // m_45
        $this->buildSearchSql($where, $this->_46, $default, false); // 46
        $this->buildSearchSql($where, $this->m_46, $default, false); // m_46
        $this->buildSearchSql($where, $this->_47, $default, false); // 47
        $this->buildSearchSql($where, $this->m_47, $default, false); // m_47
        $this->buildSearchSql($where, $this->_48, $default, false); // 48
        $this->buildSearchSql($where, $this->m_48, $default, false); // m_48
        $this->buildSearchSql($where, $this->_49, $default, false); // 49
        $this->buildSearchSql($where, $this->m_49, $default, false); // m_49
        $this->buildSearchSql($where, $this->_50, $default, false); // 50
        $this->buildSearchSql($where, $this->m_50, $default, false); // m_50
        $this->buildSearchSql($where, $this->_51, $default, false); // 51
        $this->buildSearchSql($where, $this->m_51, $default, false); // m_51
        $this->buildSearchSql($where, $this->_52, $default, false); // 52
        $this->buildSearchSql($where, $this->m_52, $default, false); // m_52
        $this->buildSearchSql($where, $this->_53, $default, false); // 53
        $this->buildSearchSql($where, $this->m_53, $default, false); // m_53
        $this->buildSearchSql($where, $this->_54, $default, false); // 54
        $this->buildSearchSql($where, $this->m_54, $default, false); // m_54
        $this->buildSearchSql($where, $this->_55, $default, false); // 55
        $this->buildSearchSql($where, $this->m_55, $default, false); // m_55
        $this->buildSearchSql($where, $this->_56, $default, false); // 56
        $this->buildSearchSql($where, $this->m_56, $default, false); // m_56
        $this->buildSearchSql($where, $this->_57, $default, false); // 57
        $this->buildSearchSql($where, $this->m_57, $default, false); // m_57
        $this->buildSearchSql($where, $this->_58, $default, false); // 58
        $this->buildSearchSql($where, $this->m_58, $default, false); // m_58
        $this->buildSearchSql($where, $this->_59, $default, false); // 59
        $this->buildSearchSql($where, $this->m_59, $default, false); // m_59
        $this->buildSearchSql($where, $this->_60, $default, false); // 60
        $this->buildSearchSql($where, $this->m_60, $default, false); // m_60

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->roll_no->AdvancedSearch->save(); // roll_no
            $this->test_id->AdvancedSearch->save(); // test_id
            $this->total->AdvancedSearch->save(); // total
            $this->percent->AdvancedSearch->save(); // percent
            $this->s_1->AdvancedSearch->save(); // s_1
            $this->s_2->AdvancedSearch->save(); // s_2
            $this->s_3->AdvancedSearch->save(); // s_3
            $this->s_4->AdvancedSearch->save(); // s_4
            $this->s_5->AdvancedSearch->save(); // s_5
            $this->omr_image->AdvancedSearch->save(); // omr_image
            $this->_1->AdvancedSearch->save(); // 1
            $this->m_1->AdvancedSearch->save(); // m_1
            $this->_2->AdvancedSearch->save(); // 2
            $this->m_2->AdvancedSearch->save(); // m_2
            $this->_3->AdvancedSearch->save(); // 3
            $this->m_3->AdvancedSearch->save(); // m_3
            $this->_4->AdvancedSearch->save(); // 4
            $this->m_4->AdvancedSearch->save(); // m_4
            $this->_5->AdvancedSearch->save(); // 5
            $this->m_5->AdvancedSearch->save(); // m_5
            $this->_6->AdvancedSearch->save(); // 6
            $this->m_6->AdvancedSearch->save(); // m_6
            $this->_7->AdvancedSearch->save(); // 7
            $this->m_7->AdvancedSearch->save(); // m_7
            $this->_8->AdvancedSearch->save(); // 8
            $this->m_8->AdvancedSearch->save(); // m_8
            $this->_9->AdvancedSearch->save(); // 9
            $this->m_9->AdvancedSearch->save(); // m_9
            $this->_10->AdvancedSearch->save(); // 10
            $this->m_10->AdvancedSearch->save(); // m_10
            $this->_11->AdvancedSearch->save(); // 11
            $this->m_11->AdvancedSearch->save(); // m_11
            $this->_12->AdvancedSearch->save(); // 12
            $this->m_12->AdvancedSearch->save(); // m_12
            $this->_13->AdvancedSearch->save(); // 13
            $this->m_13->AdvancedSearch->save(); // m_13
            $this->_14->AdvancedSearch->save(); // 14
            $this->m_14->AdvancedSearch->save(); // m_14
            $this->_15->AdvancedSearch->save(); // 15
            $this->m_15->AdvancedSearch->save(); // m_15
            $this->_16->AdvancedSearch->save(); // 16
            $this->m_16->AdvancedSearch->save(); // m_16
            $this->_17->AdvancedSearch->save(); // 17
            $this->m_17->AdvancedSearch->save(); // m_17
            $this->_18->AdvancedSearch->save(); // 18
            $this->m_18->AdvancedSearch->save(); // m_18
            $this->_19->AdvancedSearch->save(); // 19
            $this->m_19->AdvancedSearch->save(); // m_19
            $this->_20->AdvancedSearch->save(); // 20
            $this->m_20->AdvancedSearch->save(); // m_20
            $this->_21->AdvancedSearch->save(); // 21
            $this->m_21->AdvancedSearch->save(); // m_21
            $this->_22->AdvancedSearch->save(); // 22
            $this->m_22->AdvancedSearch->save(); // m_22
            $this->_23->AdvancedSearch->save(); // 23
            $this->m_23->AdvancedSearch->save(); // m_23
            $this->_24->AdvancedSearch->save(); // 24
            $this->m_24->AdvancedSearch->save(); // m_24
            $this->_25->AdvancedSearch->save(); // 25
            $this->m_25->AdvancedSearch->save(); // m_25
            $this->_26->AdvancedSearch->save(); // 26
            $this->m_26->AdvancedSearch->save(); // m_26
            $this->_27->AdvancedSearch->save(); // 27
            $this->m_27->AdvancedSearch->save(); // m_27
            $this->_28->AdvancedSearch->save(); // 28
            $this->m_28->AdvancedSearch->save(); // m_28
            $this->_29->AdvancedSearch->save(); // 29
            $this->m_29->AdvancedSearch->save(); // m_29
            $this->_30->AdvancedSearch->save(); // 30
            $this->m_30->AdvancedSearch->save(); // m_30
            $this->_31->AdvancedSearch->save(); // 31
            $this->m_31->AdvancedSearch->save(); // m_31
            $this->_32->AdvancedSearch->save(); // 32
            $this->m_32->AdvancedSearch->save(); // m_32
            $this->_33->AdvancedSearch->save(); // 33
            $this->m_33->AdvancedSearch->save(); // m_33
            $this->_34->AdvancedSearch->save(); // 34
            $this->m_34->AdvancedSearch->save(); // m_34
            $this->_35->AdvancedSearch->save(); // 35
            $this->m_35->AdvancedSearch->save(); // m_35
            $this->_36->AdvancedSearch->save(); // 36
            $this->m_36->AdvancedSearch->save(); // m_36
            $this->_37->AdvancedSearch->save(); // 37
            $this->m_37->AdvancedSearch->save(); // m_37
            $this->_38->AdvancedSearch->save(); // 38
            $this->m_38->AdvancedSearch->save(); // m_38
            $this->_39->AdvancedSearch->save(); // 39
            $this->m_39->AdvancedSearch->save(); // m_39
            $this->_40->AdvancedSearch->save(); // 40
            $this->m_40->AdvancedSearch->save(); // m_40
            $this->_41->AdvancedSearch->save(); // 41
            $this->m_41->AdvancedSearch->save(); // m_41
            $this->_42->AdvancedSearch->save(); // 42
            $this->m_42->AdvancedSearch->save(); // m_42
            $this->_43->AdvancedSearch->save(); // 43
            $this->m_43->AdvancedSearch->save(); // m_43
            $this->_44->AdvancedSearch->save(); // 44
            $this->m_44->AdvancedSearch->save(); // m_44
            $this->_45->AdvancedSearch->save(); // 45
            $this->m_45->AdvancedSearch->save(); // m_45
            $this->_46->AdvancedSearch->save(); // 46
            $this->m_46->AdvancedSearch->save(); // m_46
            $this->_47->AdvancedSearch->save(); // 47
            $this->m_47->AdvancedSearch->save(); // m_47
            $this->_48->AdvancedSearch->save(); // 48
            $this->m_48->AdvancedSearch->save(); // m_48
            $this->_49->AdvancedSearch->save(); // 49
            $this->m_49->AdvancedSearch->save(); // m_49
            $this->_50->AdvancedSearch->save(); // 50
            $this->m_50->AdvancedSearch->save(); // m_50
            $this->_51->AdvancedSearch->save(); // 51
            $this->m_51->AdvancedSearch->save(); // m_51
            $this->_52->AdvancedSearch->save(); // 52
            $this->m_52->AdvancedSearch->save(); // m_52
            $this->_53->AdvancedSearch->save(); // 53
            $this->m_53->AdvancedSearch->save(); // m_53
            $this->_54->AdvancedSearch->save(); // 54
            $this->m_54->AdvancedSearch->save(); // m_54
            $this->_55->AdvancedSearch->save(); // 55
            $this->m_55->AdvancedSearch->save(); // m_55
            $this->_56->AdvancedSearch->save(); // 56
            $this->m_56->AdvancedSearch->save(); // m_56
            $this->_57->AdvancedSearch->save(); // 57
            $this->m_57->AdvancedSearch->save(); // m_57
            $this->_58->AdvancedSearch->save(); // 58
            $this->m_58->AdvancedSearch->save(); // m_58
            $this->_59->AdvancedSearch->save(); // 59
            $this->m_59->AdvancedSearch->save(); // m_59
            $this->_60->AdvancedSearch->save(); // 60
            $this->m_60->AdvancedSearch->save(); // m_60

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->roll_no->AdvancedSearch->save(); // roll_no
            $this->test_id->AdvancedSearch->save(); // test_id
            $this->total->AdvancedSearch->save(); // total
            $this->percent->AdvancedSearch->save(); // percent
            $this->s_1->AdvancedSearch->save(); // s_1
            $this->s_2->AdvancedSearch->save(); // s_2
            $this->s_3->AdvancedSearch->save(); // s_3
            $this->s_4->AdvancedSearch->save(); // s_4
            $this->s_5->AdvancedSearch->save(); // s_5
            $this->omr_image->AdvancedSearch->save(); // omr_image
            $this->_1->AdvancedSearch->save(); // 1
            $this->m_1->AdvancedSearch->save(); // m_1
            $this->_2->AdvancedSearch->save(); // 2
            $this->m_2->AdvancedSearch->save(); // m_2
            $this->_3->AdvancedSearch->save(); // 3
            $this->m_3->AdvancedSearch->save(); // m_3
            $this->_4->AdvancedSearch->save(); // 4
            $this->m_4->AdvancedSearch->save(); // m_4
            $this->_5->AdvancedSearch->save(); // 5
            $this->m_5->AdvancedSearch->save(); // m_5
            $this->_6->AdvancedSearch->save(); // 6
            $this->m_6->AdvancedSearch->save(); // m_6
            $this->_7->AdvancedSearch->save(); // 7
            $this->m_7->AdvancedSearch->save(); // m_7
            $this->_8->AdvancedSearch->save(); // 8
            $this->m_8->AdvancedSearch->save(); // m_8
            $this->_9->AdvancedSearch->save(); // 9
            $this->m_9->AdvancedSearch->save(); // m_9
            $this->_10->AdvancedSearch->save(); // 10
            $this->m_10->AdvancedSearch->save(); // m_10
            $this->_11->AdvancedSearch->save(); // 11
            $this->m_11->AdvancedSearch->save(); // m_11
            $this->_12->AdvancedSearch->save(); // 12
            $this->m_12->AdvancedSearch->save(); // m_12
            $this->_13->AdvancedSearch->save(); // 13
            $this->m_13->AdvancedSearch->save(); // m_13
            $this->_14->AdvancedSearch->save(); // 14
            $this->m_14->AdvancedSearch->save(); // m_14
            $this->_15->AdvancedSearch->save(); // 15
            $this->m_15->AdvancedSearch->save(); // m_15
            $this->_16->AdvancedSearch->save(); // 16
            $this->m_16->AdvancedSearch->save(); // m_16
            $this->_17->AdvancedSearch->save(); // 17
            $this->m_17->AdvancedSearch->save(); // m_17
            $this->_18->AdvancedSearch->save(); // 18
            $this->m_18->AdvancedSearch->save(); // m_18
            $this->_19->AdvancedSearch->save(); // 19
            $this->m_19->AdvancedSearch->save(); // m_19
            $this->_20->AdvancedSearch->save(); // 20
            $this->m_20->AdvancedSearch->save(); // m_20
            $this->_21->AdvancedSearch->save(); // 21
            $this->m_21->AdvancedSearch->save(); // m_21
            $this->_22->AdvancedSearch->save(); // 22
            $this->m_22->AdvancedSearch->save(); // m_22
            $this->_23->AdvancedSearch->save(); // 23
            $this->m_23->AdvancedSearch->save(); // m_23
            $this->_24->AdvancedSearch->save(); // 24
            $this->m_24->AdvancedSearch->save(); // m_24
            $this->_25->AdvancedSearch->save(); // 25
            $this->m_25->AdvancedSearch->save(); // m_25
            $this->_26->AdvancedSearch->save(); // 26
            $this->m_26->AdvancedSearch->save(); // m_26
            $this->_27->AdvancedSearch->save(); // 27
            $this->m_27->AdvancedSearch->save(); // m_27
            $this->_28->AdvancedSearch->save(); // 28
            $this->m_28->AdvancedSearch->save(); // m_28
            $this->_29->AdvancedSearch->save(); // 29
            $this->m_29->AdvancedSearch->save(); // m_29
            $this->_30->AdvancedSearch->save(); // 30
            $this->m_30->AdvancedSearch->save(); // m_30
            $this->_31->AdvancedSearch->save(); // 31
            $this->m_31->AdvancedSearch->save(); // m_31
            $this->_32->AdvancedSearch->save(); // 32
            $this->m_32->AdvancedSearch->save(); // m_32
            $this->_33->AdvancedSearch->save(); // 33
            $this->m_33->AdvancedSearch->save(); // m_33
            $this->_34->AdvancedSearch->save(); // 34
            $this->m_34->AdvancedSearch->save(); // m_34
            $this->_35->AdvancedSearch->save(); // 35
            $this->m_35->AdvancedSearch->save(); // m_35
            $this->_36->AdvancedSearch->save(); // 36
            $this->m_36->AdvancedSearch->save(); // m_36
            $this->_37->AdvancedSearch->save(); // 37
            $this->m_37->AdvancedSearch->save(); // m_37
            $this->_38->AdvancedSearch->save(); // 38
            $this->m_38->AdvancedSearch->save(); // m_38
            $this->_39->AdvancedSearch->save(); // 39
            $this->m_39->AdvancedSearch->save(); // m_39
            $this->_40->AdvancedSearch->save(); // 40
            $this->m_40->AdvancedSearch->save(); // m_40
            $this->_41->AdvancedSearch->save(); // 41
            $this->m_41->AdvancedSearch->save(); // m_41
            $this->_42->AdvancedSearch->save(); // 42
            $this->m_42->AdvancedSearch->save(); // m_42
            $this->_43->AdvancedSearch->save(); // 43
            $this->m_43->AdvancedSearch->save(); // m_43
            $this->_44->AdvancedSearch->save(); // 44
            $this->m_44->AdvancedSearch->save(); // m_44
            $this->_45->AdvancedSearch->save(); // 45
            $this->m_45->AdvancedSearch->save(); // m_45
            $this->_46->AdvancedSearch->save(); // 46
            $this->m_46->AdvancedSearch->save(); // m_46
            $this->_47->AdvancedSearch->save(); // 47
            $this->m_47->AdvancedSearch->save(); // m_47
            $this->_48->AdvancedSearch->save(); // 48
            $this->m_48->AdvancedSearch->save(); // m_48
            $this->_49->AdvancedSearch->save(); // 49
            $this->m_49->AdvancedSearch->save(); // m_49
            $this->_50->AdvancedSearch->save(); // 50
            $this->m_50->AdvancedSearch->save(); // m_50
            $this->_51->AdvancedSearch->save(); // 51
            $this->m_51->AdvancedSearch->save(); // m_51
            $this->_52->AdvancedSearch->save(); // 52
            $this->m_52->AdvancedSearch->save(); // m_52
            $this->_53->AdvancedSearch->save(); // 53
            $this->m_53->AdvancedSearch->save(); // m_53
            $this->_54->AdvancedSearch->save(); // 54
            $this->m_54->AdvancedSearch->save(); // m_54
            $this->_55->AdvancedSearch->save(); // 55
            $this->m_55->AdvancedSearch->save(); // m_55
            $this->_56->AdvancedSearch->save(); // 56
            $this->m_56->AdvancedSearch->save(); // m_56
            $this->_57->AdvancedSearch->save(); // 57
            $this->m_57->AdvancedSearch->save(); // m_57
            $this->_58->AdvancedSearch->save(); // 58
            $this->m_58->AdvancedSearch->save(); // m_58
            $this->_59->AdvancedSearch->save(); // 59
            $this->m_59->AdvancedSearch->save(); // m_59
            $this->_60->AdvancedSearch->save(); // 60
            $this->m_60->AdvancedSearch->save(); // m_60
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field roll_no
        $filter = $this->queryBuilderWhere("roll_no");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->roll_no, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->roll_no->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field test_id
        $filter = $this->queryBuilderWhere("test_id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->test_id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->test_id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field total
        $filter = $this->queryBuilderWhere("total");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->total, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->total->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field percent
        $filter = $this->queryBuilderWhere("percent");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->percent, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->percent->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_1
        $filter = $this->queryBuilderWhere("s_1");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_1, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_1->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_2
        $filter = $this->queryBuilderWhere("s_2");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_2, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_2->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_3
        $filter = $this->queryBuilderWhere("s_3");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_3, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_3->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_4
        $filter = $this->queryBuilderWhere("s_4");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_4, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_4->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_5
        $filter = $this->queryBuilderWhere("s_5");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_5, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_5->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field omr_image
        $filter = $this->queryBuilderWhere("omr_image");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->omr_image, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->omr_image->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 1
        $filter = $this->queryBuilderWhere("1");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_1, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_1->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_1
        $filter = $this->queryBuilderWhere("m_1");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_1, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_1->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 2
        $filter = $this->queryBuilderWhere("2");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_2, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_2->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_2
        $filter = $this->queryBuilderWhere("m_2");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_2, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_2->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 3
        $filter = $this->queryBuilderWhere("3");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_3, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_3->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_3
        $filter = $this->queryBuilderWhere("m_3");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_3, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_3->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 4
        $filter = $this->queryBuilderWhere("4");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_4, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_4->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_4
        $filter = $this->queryBuilderWhere("m_4");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_4, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_4->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 5
        $filter = $this->queryBuilderWhere("5");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_5, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_5->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_5
        $filter = $this->queryBuilderWhere("m_5");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_5, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_5->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 6
        $filter = $this->queryBuilderWhere("6");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_6, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_6->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_6
        $filter = $this->queryBuilderWhere("m_6");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_6, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_6->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 7
        $filter = $this->queryBuilderWhere("7");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_7, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_7->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_7
        $filter = $this->queryBuilderWhere("m_7");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_7, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_7->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 8
        $filter = $this->queryBuilderWhere("8");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_8, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_8->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_8
        $filter = $this->queryBuilderWhere("m_8");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_8, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_8->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 9
        $filter = $this->queryBuilderWhere("9");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_9, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_9->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_9
        $filter = $this->queryBuilderWhere("m_9");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_9, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_9->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 10
        $filter = $this->queryBuilderWhere("10");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_10, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_10->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_10
        $filter = $this->queryBuilderWhere("m_10");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_10, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_10->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 11
        $filter = $this->queryBuilderWhere("11");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_11, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_11->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_11
        $filter = $this->queryBuilderWhere("m_11");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_11, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_11->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 12
        $filter = $this->queryBuilderWhere("12");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_12, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_12->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_12
        $filter = $this->queryBuilderWhere("m_12");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_12, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_12->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 13
        $filter = $this->queryBuilderWhere("13");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_13, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_13->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_13
        $filter = $this->queryBuilderWhere("m_13");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_13, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_13->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 14
        $filter = $this->queryBuilderWhere("14");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_14, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_14->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_14
        $filter = $this->queryBuilderWhere("m_14");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_14, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_14->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 15
        $filter = $this->queryBuilderWhere("15");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_15, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_15->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_15
        $filter = $this->queryBuilderWhere("m_15");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_15, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_15->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 16
        $filter = $this->queryBuilderWhere("16");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_16, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_16->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_16
        $filter = $this->queryBuilderWhere("m_16");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_16, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_16->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 17
        $filter = $this->queryBuilderWhere("17");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_17, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_17->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_17
        $filter = $this->queryBuilderWhere("m_17");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_17, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_17->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 18
        $filter = $this->queryBuilderWhere("18");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_18, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_18->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_18
        $filter = $this->queryBuilderWhere("m_18");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_18, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_18->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 19
        $filter = $this->queryBuilderWhere("19");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_19, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_19->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_19
        $filter = $this->queryBuilderWhere("m_19");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_19, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_19->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 20
        $filter = $this->queryBuilderWhere("20");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_20, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_20->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_20
        $filter = $this->queryBuilderWhere("m_20");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_20, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_20->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 21
        $filter = $this->queryBuilderWhere("21");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_21, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_21->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_21
        $filter = $this->queryBuilderWhere("m_21");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_21, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_21->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 22
        $filter = $this->queryBuilderWhere("22");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_22, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_22->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_22
        $filter = $this->queryBuilderWhere("m_22");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_22, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_22->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 23
        $filter = $this->queryBuilderWhere("23");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_23, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_23->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_23
        $filter = $this->queryBuilderWhere("m_23");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_23, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_23->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 24
        $filter = $this->queryBuilderWhere("24");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_24, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_24->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_24
        $filter = $this->queryBuilderWhere("m_24");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_24, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_24->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 25
        $filter = $this->queryBuilderWhere("25");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_25, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_25->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_25
        $filter = $this->queryBuilderWhere("m_25");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_25, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_25->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 26
        $filter = $this->queryBuilderWhere("26");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_26, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_26->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_26
        $filter = $this->queryBuilderWhere("m_26");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_26, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_26->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 27
        $filter = $this->queryBuilderWhere("27");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_27, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_27->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_27
        $filter = $this->queryBuilderWhere("m_27");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_27, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_27->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 28
        $filter = $this->queryBuilderWhere("28");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_28, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_28->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_28
        $filter = $this->queryBuilderWhere("m_28");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_28, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_28->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 29
        $filter = $this->queryBuilderWhere("29");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_29, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_29->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_29
        $filter = $this->queryBuilderWhere("m_29");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_29, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_29->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 30
        $filter = $this->queryBuilderWhere("30");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_30, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_30->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_30
        $filter = $this->queryBuilderWhere("m_30");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_30, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_30->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 31
        $filter = $this->queryBuilderWhere("31");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_31, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_31->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_31
        $filter = $this->queryBuilderWhere("m_31");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_31, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_31->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 32
        $filter = $this->queryBuilderWhere("32");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_32, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_32->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_32
        $filter = $this->queryBuilderWhere("m_32");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_32, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_32->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 33
        $filter = $this->queryBuilderWhere("33");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_33, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_33->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_33
        $filter = $this->queryBuilderWhere("m_33");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_33, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_33->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 34
        $filter = $this->queryBuilderWhere("34");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_34, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_34->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_34
        $filter = $this->queryBuilderWhere("m_34");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_34, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_34->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 35
        $filter = $this->queryBuilderWhere("35");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_35, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_35->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_35
        $filter = $this->queryBuilderWhere("m_35");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_35, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_35->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 36
        $filter = $this->queryBuilderWhere("36");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_36, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_36->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_36
        $filter = $this->queryBuilderWhere("m_36");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_36, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_36->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 37
        $filter = $this->queryBuilderWhere("37");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_37, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_37->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_37
        $filter = $this->queryBuilderWhere("m_37");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_37, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_37->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 38
        $filter = $this->queryBuilderWhere("38");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_38, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_38->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_38
        $filter = $this->queryBuilderWhere("m_38");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_38, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_38->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 39
        $filter = $this->queryBuilderWhere("39");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_39, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_39->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_39
        $filter = $this->queryBuilderWhere("m_39");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_39, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_39->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 40
        $filter = $this->queryBuilderWhere("40");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_40, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_40->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_40
        $filter = $this->queryBuilderWhere("m_40");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_40, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_40->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 41
        $filter = $this->queryBuilderWhere("41");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_41, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_41->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_41
        $filter = $this->queryBuilderWhere("m_41");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_41, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_41->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 42
        $filter = $this->queryBuilderWhere("42");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_42, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_42->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_42
        $filter = $this->queryBuilderWhere("m_42");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_42, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_42->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 43
        $filter = $this->queryBuilderWhere("43");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_43, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_43->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_43
        $filter = $this->queryBuilderWhere("m_43");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_43, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_43->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 44
        $filter = $this->queryBuilderWhere("44");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_44, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_44->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_44
        $filter = $this->queryBuilderWhere("m_44");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_44, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_44->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 45
        $filter = $this->queryBuilderWhere("45");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_45, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_45->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_45
        $filter = $this->queryBuilderWhere("m_45");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_45, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_45->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 46
        $filter = $this->queryBuilderWhere("46");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_46, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_46->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_46
        $filter = $this->queryBuilderWhere("m_46");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_46, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_46->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 47
        $filter = $this->queryBuilderWhere("47");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_47, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_47->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_47
        $filter = $this->queryBuilderWhere("m_47");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_47, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_47->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 48
        $filter = $this->queryBuilderWhere("48");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_48, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_48->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_48
        $filter = $this->queryBuilderWhere("m_48");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_48, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_48->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 49
        $filter = $this->queryBuilderWhere("49");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_49, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_49->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_49
        $filter = $this->queryBuilderWhere("m_49");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_49, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_49->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 50
        $filter = $this->queryBuilderWhere("50");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_50, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_50->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_50
        $filter = $this->queryBuilderWhere("m_50");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_50, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_50->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 51
        $filter = $this->queryBuilderWhere("51");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_51, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_51->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_51
        $filter = $this->queryBuilderWhere("m_51");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_51, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_51->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 52
        $filter = $this->queryBuilderWhere("52");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_52, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_52->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_52
        $filter = $this->queryBuilderWhere("m_52");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_52, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_52->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 53
        $filter = $this->queryBuilderWhere("53");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_53, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_53->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_53
        $filter = $this->queryBuilderWhere("m_53");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_53, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_53->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 54
        $filter = $this->queryBuilderWhere("54");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_54, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_54->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_54
        $filter = $this->queryBuilderWhere("m_54");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_54, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_54->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 55
        $filter = $this->queryBuilderWhere("55");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_55, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_55->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_55
        $filter = $this->queryBuilderWhere("m_55");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_55, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_55->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 56
        $filter = $this->queryBuilderWhere("56");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_56, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_56->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_56
        $filter = $this->queryBuilderWhere("m_56");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_56, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_56->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 57
        $filter = $this->queryBuilderWhere("57");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_57, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_57->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_57
        $filter = $this->queryBuilderWhere("m_57");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_57, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_57->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 58
        $filter = $this->queryBuilderWhere("58");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_58, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_58->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_58
        $filter = $this->queryBuilderWhere("m_58");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_58, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_58->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 59
        $filter = $this->queryBuilderWhere("59");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_59, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_59->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_59
        $filter = $this->queryBuilderWhere("m_59");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_59, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_59->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field 60
        $filter = $this->queryBuilderWhere("60");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->_60, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->_60->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field m_60
        $filter = $this->queryBuilderWhere("m_60");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->m_60, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->m_60->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->roll_no;
        $searchFlds[] = &$this->test_id;
        $searchFlds[] = &$this->total;
        $searchFlds[] = &$this->percent;
        $searchFlds[] = &$this->s_1;
        $searchFlds[] = &$this->s_2;
        $searchFlds[] = &$this->s_3;
        $searchFlds[] = &$this->s_4;
        $searchFlds[] = &$this->s_5;
        $searchFlds[] = &$this->omr_image;
        $searchFlds[] = &$this->_1;
        $searchFlds[] = &$this->m_1;
        $searchFlds[] = &$this->_2;
        $searchFlds[] = &$this->m_2;
        $searchFlds[] = &$this->_3;
        $searchFlds[] = &$this->_4;
        $searchFlds[] = &$this->_5;
        $searchFlds[] = &$this->_6;
        $searchFlds[] = &$this->_7;
        $searchFlds[] = &$this->_8;
        $searchFlds[] = &$this->_9;
        $searchFlds[] = &$this->_10;
        $searchFlds[] = &$this->_11;
        $searchFlds[] = &$this->_12;
        $searchFlds[] = &$this->_13;
        $searchFlds[] = &$this->_14;
        $searchFlds[] = &$this->_15;
        $searchFlds[] = &$this->_16;
        $searchFlds[] = &$this->_17;
        $searchFlds[] = &$this->_18;
        $searchFlds[] = &$this->_19;
        $searchFlds[] = &$this->_20;
        $searchFlds[] = &$this->_21;
        $searchFlds[] = &$this->_22;
        $searchFlds[] = &$this->_23;
        $searchFlds[] = &$this->_24;
        $searchFlds[] = &$this->_25;
        $searchFlds[] = &$this->_26;
        $searchFlds[] = &$this->_27;
        $searchFlds[] = &$this->_28;
        $searchFlds[] = &$this->_29;
        $searchFlds[] = &$this->_30;
        $searchFlds[] = &$this->_31;
        $searchFlds[] = &$this->_32;
        $searchFlds[] = &$this->_33;
        $searchFlds[] = &$this->_34;
        $searchFlds[] = &$this->_35;
        $searchFlds[] = &$this->_36;
        $searchFlds[] = &$this->_37;
        $searchFlds[] = &$this->_38;
        $searchFlds[] = &$this->_39;
        $searchFlds[] = &$this->_40;
        $searchFlds[] = &$this->_41;
        $searchFlds[] = &$this->_42;
        $searchFlds[] = &$this->_43;
        $searchFlds[] = &$this->_44;
        $searchFlds[] = &$this->_45;
        $searchFlds[] = &$this->_46;
        $searchFlds[] = &$this->_47;
        $searchFlds[] = &$this->_48;
        $searchFlds[] = &$this->_49;
        $searchFlds[] = &$this->_50;
        $searchFlds[] = &$this->_51;
        $searchFlds[] = &$this->_52;
        $searchFlds[] = &$this->_53;
        $searchFlds[] = &$this->_54;
        $searchFlds[] = &$this->_55;
        $searchFlds[] = &$this->_56;
        $searchFlds[] = &$this->_57;
        $searchFlds[] = &$this->_58;
        $searchFlds[] = &$this->_59;
        $searchFlds[] = &$this->_60;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->roll_no->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->test_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->total->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->percent->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_1->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_2->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_3->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_4->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_5->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->omr_image->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_1->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_1->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_2->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_2->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_3->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_3->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_4->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_4->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_5->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_5->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_6->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_6->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_7->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_7->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_8->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_8->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_9->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_9->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_12->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_12->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_13->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_13->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_14->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_14->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_15->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_15->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_16->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_16->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_17->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_17->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_18->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_18->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_19->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_19->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_20->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_20->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_21->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_21->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_22->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_22->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_23->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_23->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_24->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_24->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_25->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_25->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_26->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_26->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_27->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_27->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_28->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_28->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_29->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_29->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_30->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_30->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_31->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_31->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_32->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_32->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_33->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_33->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_34->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_34->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_35->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_35->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_36->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_36->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_37->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_37->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_38->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_38->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_39->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_39->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_40->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_40->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_41->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_41->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_42->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_42->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_43->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_43->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_44->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_44->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_45->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_45->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_46->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_46->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_47->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_47->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_48->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_48->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_49->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_49->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_50->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_50->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_51->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_51->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_52->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_52->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_53->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_53->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_54->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_54->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_55->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_55->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_56->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_56->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_57->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_57->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_58->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_58->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_59->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_59->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->_60->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->m_60->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->roll_no->AdvancedSearch->unsetSession();
        $this->test_id->AdvancedSearch->unsetSession();
        $this->total->AdvancedSearch->unsetSession();
        $this->percent->AdvancedSearch->unsetSession();
        $this->s_1->AdvancedSearch->unsetSession();
        $this->s_2->AdvancedSearch->unsetSession();
        $this->s_3->AdvancedSearch->unsetSession();
        $this->s_4->AdvancedSearch->unsetSession();
        $this->s_5->AdvancedSearch->unsetSession();
        $this->omr_image->AdvancedSearch->unsetSession();
        $this->_1->AdvancedSearch->unsetSession();
        $this->m_1->AdvancedSearch->unsetSession();
        $this->_2->AdvancedSearch->unsetSession();
        $this->m_2->AdvancedSearch->unsetSession();
        $this->_3->AdvancedSearch->unsetSession();
        $this->m_3->AdvancedSearch->unsetSession();
        $this->_4->AdvancedSearch->unsetSession();
        $this->m_4->AdvancedSearch->unsetSession();
        $this->_5->AdvancedSearch->unsetSession();
        $this->m_5->AdvancedSearch->unsetSession();
        $this->_6->AdvancedSearch->unsetSession();
        $this->m_6->AdvancedSearch->unsetSession();
        $this->_7->AdvancedSearch->unsetSession();
        $this->m_7->AdvancedSearch->unsetSession();
        $this->_8->AdvancedSearch->unsetSession();
        $this->m_8->AdvancedSearch->unsetSession();
        $this->_9->AdvancedSearch->unsetSession();
        $this->m_9->AdvancedSearch->unsetSession();
        $this->_10->AdvancedSearch->unsetSession();
        $this->m_10->AdvancedSearch->unsetSession();
        $this->_11->AdvancedSearch->unsetSession();
        $this->m_11->AdvancedSearch->unsetSession();
        $this->_12->AdvancedSearch->unsetSession();
        $this->m_12->AdvancedSearch->unsetSession();
        $this->_13->AdvancedSearch->unsetSession();
        $this->m_13->AdvancedSearch->unsetSession();
        $this->_14->AdvancedSearch->unsetSession();
        $this->m_14->AdvancedSearch->unsetSession();
        $this->_15->AdvancedSearch->unsetSession();
        $this->m_15->AdvancedSearch->unsetSession();
        $this->_16->AdvancedSearch->unsetSession();
        $this->m_16->AdvancedSearch->unsetSession();
        $this->_17->AdvancedSearch->unsetSession();
        $this->m_17->AdvancedSearch->unsetSession();
        $this->_18->AdvancedSearch->unsetSession();
        $this->m_18->AdvancedSearch->unsetSession();
        $this->_19->AdvancedSearch->unsetSession();
        $this->m_19->AdvancedSearch->unsetSession();
        $this->_20->AdvancedSearch->unsetSession();
        $this->m_20->AdvancedSearch->unsetSession();
        $this->_21->AdvancedSearch->unsetSession();
        $this->m_21->AdvancedSearch->unsetSession();
        $this->_22->AdvancedSearch->unsetSession();
        $this->m_22->AdvancedSearch->unsetSession();
        $this->_23->AdvancedSearch->unsetSession();
        $this->m_23->AdvancedSearch->unsetSession();
        $this->_24->AdvancedSearch->unsetSession();
        $this->m_24->AdvancedSearch->unsetSession();
        $this->_25->AdvancedSearch->unsetSession();
        $this->m_25->AdvancedSearch->unsetSession();
        $this->_26->AdvancedSearch->unsetSession();
        $this->m_26->AdvancedSearch->unsetSession();
        $this->_27->AdvancedSearch->unsetSession();
        $this->m_27->AdvancedSearch->unsetSession();
        $this->_28->AdvancedSearch->unsetSession();
        $this->m_28->AdvancedSearch->unsetSession();
        $this->_29->AdvancedSearch->unsetSession();
        $this->m_29->AdvancedSearch->unsetSession();
        $this->_30->AdvancedSearch->unsetSession();
        $this->m_30->AdvancedSearch->unsetSession();
        $this->_31->AdvancedSearch->unsetSession();
        $this->m_31->AdvancedSearch->unsetSession();
        $this->_32->AdvancedSearch->unsetSession();
        $this->m_32->AdvancedSearch->unsetSession();
        $this->_33->AdvancedSearch->unsetSession();
        $this->m_33->AdvancedSearch->unsetSession();
        $this->_34->AdvancedSearch->unsetSession();
        $this->m_34->AdvancedSearch->unsetSession();
        $this->_35->AdvancedSearch->unsetSession();
        $this->m_35->AdvancedSearch->unsetSession();
        $this->_36->AdvancedSearch->unsetSession();
        $this->m_36->AdvancedSearch->unsetSession();
        $this->_37->AdvancedSearch->unsetSession();
        $this->m_37->AdvancedSearch->unsetSession();
        $this->_38->AdvancedSearch->unsetSession();
        $this->m_38->AdvancedSearch->unsetSession();
        $this->_39->AdvancedSearch->unsetSession();
        $this->m_39->AdvancedSearch->unsetSession();
        $this->_40->AdvancedSearch->unsetSession();
        $this->m_40->AdvancedSearch->unsetSession();
        $this->_41->AdvancedSearch->unsetSession();
        $this->m_41->AdvancedSearch->unsetSession();
        $this->_42->AdvancedSearch->unsetSession();
        $this->m_42->AdvancedSearch->unsetSession();
        $this->_43->AdvancedSearch->unsetSession();
        $this->m_43->AdvancedSearch->unsetSession();
        $this->_44->AdvancedSearch->unsetSession();
        $this->m_44->AdvancedSearch->unsetSession();
        $this->_45->AdvancedSearch->unsetSession();
        $this->m_45->AdvancedSearch->unsetSession();
        $this->_46->AdvancedSearch->unsetSession();
        $this->m_46->AdvancedSearch->unsetSession();
        $this->_47->AdvancedSearch->unsetSession();
        $this->m_47->AdvancedSearch->unsetSession();
        $this->_48->AdvancedSearch->unsetSession();
        $this->m_48->AdvancedSearch->unsetSession();
        $this->_49->AdvancedSearch->unsetSession();
        $this->m_49->AdvancedSearch->unsetSession();
        $this->_50->AdvancedSearch->unsetSession();
        $this->m_50->AdvancedSearch->unsetSession();
        $this->_51->AdvancedSearch->unsetSession();
        $this->m_51->AdvancedSearch->unsetSession();
        $this->_52->AdvancedSearch->unsetSession();
        $this->m_52->AdvancedSearch->unsetSession();
        $this->_53->AdvancedSearch->unsetSession();
        $this->m_53->AdvancedSearch->unsetSession();
        $this->_54->AdvancedSearch->unsetSession();
        $this->m_54->AdvancedSearch->unsetSession();
        $this->_55->AdvancedSearch->unsetSession();
        $this->m_55->AdvancedSearch->unsetSession();
        $this->_56->AdvancedSearch->unsetSession();
        $this->m_56->AdvancedSearch->unsetSession();
        $this->_57->AdvancedSearch->unsetSession();
        $this->m_57->AdvancedSearch->unsetSession();
        $this->_58->AdvancedSearch->unsetSession();
        $this->m_58->AdvancedSearch->unsetSession();
        $this->_59->AdvancedSearch->unsetSession();
        $this->m_59->AdvancedSearch->unsetSession();
        $this->_60->AdvancedSearch->unsetSession();
        $this->m_60->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->test_id->AdvancedSearch->load();
        $this->total->AdvancedSearch->load();
        $this->percent->AdvancedSearch->load();
        $this->s_1->AdvancedSearch->load();
        $this->s_2->AdvancedSearch->load();
        $this->s_3->AdvancedSearch->load();
        $this->s_4->AdvancedSearch->load();
        $this->s_5->AdvancedSearch->load();
        $this->omr_image->AdvancedSearch->load();
        $this->_1->AdvancedSearch->load();
        $this->m_1->AdvancedSearch->load();
        $this->_2->AdvancedSearch->load();
        $this->m_2->AdvancedSearch->load();
        $this->_3->AdvancedSearch->load();
        $this->m_3->AdvancedSearch->load();
        $this->_4->AdvancedSearch->load();
        $this->m_4->AdvancedSearch->load();
        $this->_5->AdvancedSearch->load();
        $this->m_5->AdvancedSearch->load();
        $this->_6->AdvancedSearch->load();
        $this->m_6->AdvancedSearch->load();
        $this->_7->AdvancedSearch->load();
        $this->m_7->AdvancedSearch->load();
        $this->_8->AdvancedSearch->load();
        $this->m_8->AdvancedSearch->load();
        $this->_9->AdvancedSearch->load();
        $this->m_9->AdvancedSearch->load();
        $this->_10->AdvancedSearch->load();
        $this->m_10->AdvancedSearch->load();
        $this->_11->AdvancedSearch->load();
        $this->m_11->AdvancedSearch->load();
        $this->_12->AdvancedSearch->load();
        $this->m_12->AdvancedSearch->load();
        $this->_13->AdvancedSearch->load();
        $this->m_13->AdvancedSearch->load();
        $this->_14->AdvancedSearch->load();
        $this->m_14->AdvancedSearch->load();
        $this->_15->AdvancedSearch->load();
        $this->m_15->AdvancedSearch->load();
        $this->_16->AdvancedSearch->load();
        $this->m_16->AdvancedSearch->load();
        $this->_17->AdvancedSearch->load();
        $this->m_17->AdvancedSearch->load();
        $this->_18->AdvancedSearch->load();
        $this->m_18->AdvancedSearch->load();
        $this->_19->AdvancedSearch->load();
        $this->m_19->AdvancedSearch->load();
        $this->_20->AdvancedSearch->load();
        $this->m_20->AdvancedSearch->load();
        $this->_21->AdvancedSearch->load();
        $this->m_21->AdvancedSearch->load();
        $this->_22->AdvancedSearch->load();
        $this->m_22->AdvancedSearch->load();
        $this->_23->AdvancedSearch->load();
        $this->m_23->AdvancedSearch->load();
        $this->_24->AdvancedSearch->load();
        $this->m_24->AdvancedSearch->load();
        $this->_25->AdvancedSearch->load();
        $this->m_25->AdvancedSearch->load();
        $this->_26->AdvancedSearch->load();
        $this->m_26->AdvancedSearch->load();
        $this->_27->AdvancedSearch->load();
        $this->m_27->AdvancedSearch->load();
        $this->_28->AdvancedSearch->load();
        $this->m_28->AdvancedSearch->load();
        $this->_29->AdvancedSearch->load();
        $this->m_29->AdvancedSearch->load();
        $this->_30->AdvancedSearch->load();
        $this->m_30->AdvancedSearch->load();
        $this->_31->AdvancedSearch->load();
        $this->m_31->AdvancedSearch->load();
        $this->_32->AdvancedSearch->load();
        $this->m_32->AdvancedSearch->load();
        $this->_33->AdvancedSearch->load();
        $this->m_33->AdvancedSearch->load();
        $this->_34->AdvancedSearch->load();
        $this->m_34->AdvancedSearch->load();
        $this->_35->AdvancedSearch->load();
        $this->m_35->AdvancedSearch->load();
        $this->_36->AdvancedSearch->load();
        $this->m_36->AdvancedSearch->load();
        $this->_37->AdvancedSearch->load();
        $this->m_37->AdvancedSearch->load();
        $this->_38->AdvancedSearch->load();
        $this->m_38->AdvancedSearch->load();
        $this->_39->AdvancedSearch->load();
        $this->m_39->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->m_40->AdvancedSearch->load();
        $this->_41->AdvancedSearch->load();
        $this->m_41->AdvancedSearch->load();
        $this->_42->AdvancedSearch->load();
        $this->m_42->AdvancedSearch->load();
        $this->_43->AdvancedSearch->load();
        $this->m_43->AdvancedSearch->load();
        $this->_44->AdvancedSearch->load();
        $this->m_44->AdvancedSearch->load();
        $this->_45->AdvancedSearch->load();
        $this->m_45->AdvancedSearch->load();
        $this->_46->AdvancedSearch->load();
        $this->m_46->AdvancedSearch->load();
        $this->_47->AdvancedSearch->load();
        $this->m_47->AdvancedSearch->load();
        $this->_48->AdvancedSearch->load();
        $this->m_48->AdvancedSearch->load();
        $this->_49->AdvancedSearch->load();
        $this->m_49->AdvancedSearch->load();
        $this->_50->AdvancedSearch->load();
        $this->m_50->AdvancedSearch->load();
        $this->_51->AdvancedSearch->load();
        $this->m_51->AdvancedSearch->load();
        $this->_52->AdvancedSearch->load();
        $this->m_52->AdvancedSearch->load();
        $this->_53->AdvancedSearch->load();
        $this->m_53->AdvancedSearch->load();
        $this->_54->AdvancedSearch->load();
        $this->m_54->AdvancedSearch->load();
        $this->_55->AdvancedSearch->load();
        $this->m_55->AdvancedSearch->load();
        $this->_56->AdvancedSearch->load();
        $this->m_56->AdvancedSearch->load();
        $this->_57->AdvancedSearch->load();
        $this->m_57->AdvancedSearch->load();
        $this->_58->AdvancedSearch->load();
        $this->m_58->AdvancedSearch->load();
        $this->_59->AdvancedSearch->load();
        $this->m_59->AdvancedSearch->load();
        $this->_60->AdvancedSearch->load();
        $this->m_60->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->roll_no, $ctrl); // roll_no
            $this->updateSort($this->test_id, $ctrl); // test_id
            $this->updateSort($this->total, $ctrl); // total
            $this->updateSort($this->percent, $ctrl); // percent
            $this->updateSort($this->s_1, $ctrl); // s_1
            $this->updateSort($this->s_2, $ctrl); // s_2
            $this->updateSort($this->s_3, $ctrl); // s_3
            $this->updateSort($this->s_4, $ctrl); // s_4
            $this->updateSort($this->s_5, $ctrl); // s_5
            $this->updateSort($this->omr_image, $ctrl); // omr_image
            $this->updateSort($this->_1, $ctrl); // 1
            $this->updateSort($this->m_1, $ctrl); // m_1
            $this->updateSort($this->_2, $ctrl); // 2
            $this->updateSort($this->m_2, $ctrl); // m_2
            $this->updateSort($this->_3, $ctrl); // 3
            $this->updateSort($this->m_3, $ctrl); // m_3
            $this->updateSort($this->_4, $ctrl); // 4
            $this->updateSort($this->m_4, $ctrl); // m_4
            $this->updateSort($this->_5, $ctrl); // 5
            $this->updateSort($this->m_5, $ctrl); // m_5
            $this->updateSort($this->_6, $ctrl); // 6
            $this->updateSort($this->m_6, $ctrl); // m_6
            $this->updateSort($this->_7, $ctrl); // 7
            $this->updateSort($this->m_7, $ctrl); // m_7
            $this->updateSort($this->_8, $ctrl); // 8
            $this->updateSort($this->m_8, $ctrl); // m_8
            $this->updateSort($this->_9, $ctrl); // 9
            $this->updateSort($this->m_9, $ctrl); // m_9
            $this->updateSort($this->_10, $ctrl); // 10
            $this->updateSort($this->m_10, $ctrl); // m_10
            $this->updateSort($this->_11, $ctrl); // 11
            $this->updateSort($this->m_11, $ctrl); // m_11
            $this->updateSort($this->_12, $ctrl); // 12
            $this->updateSort($this->m_12, $ctrl); // m_12
            $this->updateSort($this->_13, $ctrl); // 13
            $this->updateSort($this->m_13, $ctrl); // m_13
            $this->updateSort($this->_14, $ctrl); // 14
            $this->updateSort($this->m_14, $ctrl); // m_14
            $this->updateSort($this->_15, $ctrl); // 15
            $this->updateSort($this->m_15, $ctrl); // m_15
            $this->updateSort($this->_16, $ctrl); // 16
            $this->updateSort($this->m_16, $ctrl); // m_16
            $this->updateSort($this->_17, $ctrl); // 17
            $this->updateSort($this->m_17, $ctrl); // m_17
            $this->updateSort($this->_18, $ctrl); // 18
            $this->updateSort($this->m_18, $ctrl); // m_18
            $this->updateSort($this->_19, $ctrl); // 19
            $this->updateSort($this->m_19, $ctrl); // m_19
            $this->updateSort($this->_20, $ctrl); // 20
            $this->updateSort($this->m_20, $ctrl); // m_20
            $this->updateSort($this->_21, $ctrl); // 21
            $this->updateSort($this->m_21, $ctrl); // m_21
            $this->updateSort($this->_22, $ctrl); // 22
            $this->updateSort($this->m_22, $ctrl); // m_22
            $this->updateSort($this->_23, $ctrl); // 23
            $this->updateSort($this->m_23, $ctrl); // m_23
            $this->updateSort($this->_24, $ctrl); // 24
            $this->updateSort($this->m_24, $ctrl); // m_24
            $this->updateSort($this->_25, $ctrl); // 25
            $this->updateSort($this->m_25, $ctrl); // m_25
            $this->updateSort($this->_26, $ctrl); // 26
            $this->updateSort($this->m_26, $ctrl); // m_26
            $this->updateSort($this->_27, $ctrl); // 27
            $this->updateSort($this->m_27, $ctrl); // m_27
            $this->updateSort($this->_28, $ctrl); // 28
            $this->updateSort($this->m_28, $ctrl); // m_28
            $this->updateSort($this->_29, $ctrl); // 29
            $this->updateSort($this->m_29, $ctrl); // m_29
            $this->updateSort($this->_30, $ctrl); // 30
            $this->updateSort($this->m_30, $ctrl); // m_30
            $this->updateSort($this->_31, $ctrl); // 31
            $this->updateSort($this->m_31, $ctrl); // m_31
            $this->updateSort($this->_32, $ctrl); // 32
            $this->updateSort($this->m_32, $ctrl); // m_32
            $this->updateSort($this->_33, $ctrl); // 33
            $this->updateSort($this->m_33, $ctrl); // m_33
            $this->updateSort($this->_34, $ctrl); // 34
            $this->updateSort($this->m_34, $ctrl); // m_34
            $this->updateSort($this->_35, $ctrl); // 35
            $this->updateSort($this->m_35, $ctrl); // m_35
            $this->updateSort($this->_36, $ctrl); // 36
            $this->updateSort($this->m_36, $ctrl); // m_36
            $this->updateSort($this->_37, $ctrl); // 37
            $this->updateSort($this->m_37, $ctrl); // m_37
            $this->updateSort($this->_38, $ctrl); // 38
            $this->updateSort($this->m_38, $ctrl); // m_38
            $this->updateSort($this->_39, $ctrl); // 39
            $this->updateSort($this->m_39, $ctrl); // m_39
            $this->updateSort($this->_40, $ctrl); // 40
            $this->updateSort($this->m_40, $ctrl); // m_40
            $this->updateSort($this->_41, $ctrl); // 41
            $this->updateSort($this->m_41, $ctrl); // m_41
            $this->updateSort($this->_42, $ctrl); // 42
            $this->updateSort($this->m_42, $ctrl); // m_42
            $this->updateSort($this->_43, $ctrl); // 43
            $this->updateSort($this->m_43, $ctrl); // m_43
            $this->updateSort($this->_44, $ctrl); // 44
            $this->updateSort($this->m_44, $ctrl); // m_44
            $this->updateSort($this->_45, $ctrl); // 45
            $this->updateSort($this->m_45, $ctrl); // m_45
            $this->updateSort($this->_46, $ctrl); // 46
            $this->updateSort($this->m_46, $ctrl); // m_46
            $this->updateSort($this->_47, $ctrl); // 47
            $this->updateSort($this->m_47, $ctrl); // m_47
            $this->updateSort($this->_48, $ctrl); // 48
            $this->updateSort($this->m_48, $ctrl); // m_48
            $this->updateSort($this->_49, $ctrl); // 49
            $this->updateSort($this->m_49, $ctrl); // m_49
            $this->updateSort($this->_50, $ctrl); // 50
            $this->updateSort($this->m_50, $ctrl); // m_50
            $this->updateSort($this->_51, $ctrl); // 51
            $this->updateSort($this->m_51, $ctrl); // m_51
            $this->updateSort($this->_52, $ctrl); // 52
            $this->updateSort($this->m_52, $ctrl); // m_52
            $this->updateSort($this->_53, $ctrl); // 53
            $this->updateSort($this->m_53, $ctrl); // m_53
            $this->updateSort($this->_54, $ctrl); // 54
            $this->updateSort($this->m_54, $ctrl); // m_54
            $this->updateSort($this->_55, $ctrl); // 55
            $this->updateSort($this->m_55, $ctrl); // m_55
            $this->updateSort($this->_56, $ctrl); // 56
            $this->updateSort($this->m_56, $ctrl); // m_56
            $this->updateSort($this->_57, $ctrl); // 57
            $this->updateSort($this->m_57, $ctrl); // m_57
            $this->updateSort($this->_58, $ctrl); // 58
            $this->updateSort($this->m_58, $ctrl); // m_58
            $this->updateSort($this->_59, $ctrl); // 59
            $this->updateSort($this->m_59, $ctrl); // m_59
            $this->updateSort($this->_60, $ctrl); // 60
            $this->updateSort($this->m_60, $ctrl); // m_60
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->roll_no->setSort("");
                $this->test_id->setSort("");
                $this->total->setSort("");
                $this->percent->setSort("");
                $this->s_1->setSort("");
                $this->s_2->setSort("");
                $this->s_3->setSort("");
                $this->s_4->setSort("");
                $this->s_5->setSort("");
                $this->omr_image->setSort("");
                $this->_1->setSort("");
                $this->m_1->setSort("");
                $this->_2->setSort("");
                $this->m_2->setSort("");
                $this->_3->setSort("");
                $this->m_3->setSort("");
                $this->_4->setSort("");
                $this->m_4->setSort("");
                $this->_5->setSort("");
                $this->m_5->setSort("");
                $this->_6->setSort("");
                $this->m_6->setSort("");
                $this->_7->setSort("");
                $this->m_7->setSort("");
                $this->_8->setSort("");
                $this->m_8->setSort("");
                $this->_9->setSort("");
                $this->m_9->setSort("");
                $this->_10->setSort("");
                $this->m_10->setSort("");
                $this->_11->setSort("");
                $this->m_11->setSort("");
                $this->_12->setSort("");
                $this->m_12->setSort("");
                $this->_13->setSort("");
                $this->m_13->setSort("");
                $this->_14->setSort("");
                $this->m_14->setSort("");
                $this->_15->setSort("");
                $this->m_15->setSort("");
                $this->_16->setSort("");
                $this->m_16->setSort("");
                $this->_17->setSort("");
                $this->m_17->setSort("");
                $this->_18->setSort("");
                $this->m_18->setSort("");
                $this->_19->setSort("");
                $this->m_19->setSort("");
                $this->_20->setSort("");
                $this->m_20->setSort("");
                $this->_21->setSort("");
                $this->m_21->setSort("");
                $this->_22->setSort("");
                $this->m_22->setSort("");
                $this->_23->setSort("");
                $this->m_23->setSort("");
                $this->_24->setSort("");
                $this->m_24->setSort("");
                $this->_25->setSort("");
                $this->m_25->setSort("");
                $this->_26->setSort("");
                $this->m_26->setSort("");
                $this->_27->setSort("");
                $this->m_27->setSort("");
                $this->_28->setSort("");
                $this->m_28->setSort("");
                $this->_29->setSort("");
                $this->m_29->setSort("");
                $this->_30->setSort("");
                $this->m_30->setSort("");
                $this->_31->setSort("");
                $this->m_31->setSort("");
                $this->_32->setSort("");
                $this->m_32->setSort("");
                $this->_33->setSort("");
                $this->m_33->setSort("");
                $this->_34->setSort("");
                $this->m_34->setSort("");
                $this->_35->setSort("");
                $this->m_35->setSort("");
                $this->_36->setSort("");
                $this->m_36->setSort("");
                $this->_37->setSort("");
                $this->m_37->setSort("");
                $this->_38->setSort("");
                $this->m_38->setSort("");
                $this->_39->setSort("");
                $this->m_39->setSort("");
                $this->_40->setSort("");
                $this->m_40->setSort("");
                $this->_41->setSort("");
                $this->m_41->setSort("");
                $this->_42->setSort("");
                $this->m_42->setSort("");
                $this->_43->setSort("");
                $this->m_43->setSort("");
                $this->_44->setSort("");
                $this->m_44->setSort("");
                $this->_45->setSort("");
                $this->m_45->setSort("");
                $this->_46->setSort("");
                $this->m_46->setSort("");
                $this->_47->setSort("");
                $this->m_47->setSort("");
                $this->_48->setSort("");
                $this->m_48->setSort("");
                $this->_49->setSort("");
                $this->m_49->setSort("");
                $this->_50->setSort("");
                $this->m_50->setSort("");
                $this->_51->setSort("");
                $this->m_51->setSort("");
                $this->_52->setSort("");
                $this->m_52->setSort("");
                $this->_53->setSort("");
                $this->m_53->setSort("");
                $this->_54->setSort("");
                $this->m_54->setSort("");
                $this->_55->setSort("");
                $this->m_55->setSort("");
                $this->_56->setSort("");
                $this->m_56->setSort("");
                $this->_57->setSort("");
                $this->m_57->setSort("");
                $this->_58->setSort("");
                $this->m_58->setSort("");
                $this->_59->setSort("");
                $this->m_59->setSort("");
                $this->_60->setSort("");
                $this->m_60->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"s_omr_value\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"s_omr_value\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"s_omr_value\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fs_omr_valuelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fs_omr_valuelist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"s_omr_value\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "roll_no");
            $this->createColumnOption($option, "test_id");
            $this->createColumnOption($option, "total");
            $this->createColumnOption($option, "percent");
            $this->createColumnOption($option, "s_1");
            $this->createColumnOption($option, "s_2");
            $this->createColumnOption($option, "s_3");
            $this->createColumnOption($option, "s_4");
            $this->createColumnOption($option, "s_5");
            $this->createColumnOption($option, "omr_image");
            $this->createColumnOption($option, "1");
            $this->createColumnOption($option, "m_1");
            $this->createColumnOption($option, "2");
            $this->createColumnOption($option, "m_2");
            $this->createColumnOption($option, "3");
            $this->createColumnOption($option, "m_3");
            $this->createColumnOption($option, "4");
            $this->createColumnOption($option, "m_4");
            $this->createColumnOption($option, "5");
            $this->createColumnOption($option, "m_5");
            $this->createColumnOption($option, "6");
            $this->createColumnOption($option, "m_6");
            $this->createColumnOption($option, "7");
            $this->createColumnOption($option, "m_7");
            $this->createColumnOption($option, "8");
            $this->createColumnOption($option, "m_8");
            $this->createColumnOption($option, "9");
            $this->createColumnOption($option, "m_9");
            $this->createColumnOption($option, "10");
            $this->createColumnOption($option, "m_10");
            $this->createColumnOption($option, "11");
            $this->createColumnOption($option, "m_11");
            $this->createColumnOption($option, "12");
            $this->createColumnOption($option, "m_12");
            $this->createColumnOption($option, "13");
            $this->createColumnOption($option, "m_13");
            $this->createColumnOption($option, "14");
            $this->createColumnOption($option, "m_14");
            $this->createColumnOption($option, "15");
            $this->createColumnOption($option, "m_15");
            $this->createColumnOption($option, "16");
            $this->createColumnOption($option, "m_16");
            $this->createColumnOption($option, "17");
            $this->createColumnOption($option, "m_17");
            $this->createColumnOption($option, "18");
            $this->createColumnOption($option, "m_18");
            $this->createColumnOption($option, "19");
            $this->createColumnOption($option, "m_19");
            $this->createColumnOption($option, "20");
            $this->createColumnOption($option, "m_20");
            $this->createColumnOption($option, "21");
            $this->createColumnOption($option, "m_21");
            $this->createColumnOption($option, "22");
            $this->createColumnOption($option, "m_22");
            $this->createColumnOption($option, "23");
            $this->createColumnOption($option, "m_23");
            $this->createColumnOption($option, "24");
            $this->createColumnOption($option, "m_24");
            $this->createColumnOption($option, "25");
            $this->createColumnOption($option, "m_25");
            $this->createColumnOption($option, "26");
            $this->createColumnOption($option, "m_26");
            $this->createColumnOption($option, "27");
            $this->createColumnOption($option, "m_27");
            $this->createColumnOption($option, "28");
            $this->createColumnOption($option, "m_28");
            $this->createColumnOption($option, "29");
            $this->createColumnOption($option, "m_29");
            $this->createColumnOption($option, "30");
            $this->createColumnOption($option, "m_30");
            $this->createColumnOption($option, "31");
            $this->createColumnOption($option, "m_31");
            $this->createColumnOption($option, "32");
            $this->createColumnOption($option, "m_32");
            $this->createColumnOption($option, "33");
            $this->createColumnOption($option, "m_33");
            $this->createColumnOption($option, "34");
            $this->createColumnOption($option, "m_34");
            $this->createColumnOption($option, "35");
            $this->createColumnOption($option, "m_35");
            $this->createColumnOption($option, "36");
            $this->createColumnOption($option, "m_36");
            $this->createColumnOption($option, "37");
            $this->createColumnOption($option, "m_37");
            $this->createColumnOption($option, "38");
            $this->createColumnOption($option, "m_38");
            $this->createColumnOption($option, "39");
            $this->createColumnOption($option, "m_39");
            $this->createColumnOption($option, "40");
            $this->createColumnOption($option, "m_40");
            $this->createColumnOption($option, "41");
            $this->createColumnOption($option, "m_41");
            $this->createColumnOption($option, "42");
            $this->createColumnOption($option, "m_42");
            $this->createColumnOption($option, "43");
            $this->createColumnOption($option, "m_43");
            $this->createColumnOption($option, "44");
            $this->createColumnOption($option, "m_44");
            $this->createColumnOption($option, "45");
            $this->createColumnOption($option, "m_45");
            $this->createColumnOption($option, "46");
            $this->createColumnOption($option, "m_46");
            $this->createColumnOption($option, "47");
            $this->createColumnOption($option, "m_47");
            $this->createColumnOption($option, "48");
            $this->createColumnOption($option, "m_48");
            $this->createColumnOption($option, "49");
            $this->createColumnOption($option, "m_49");
            $this->createColumnOption($option, "50");
            $this->createColumnOption($option, "m_50");
            $this->createColumnOption($option, "51");
            $this->createColumnOption($option, "m_51");
            $this->createColumnOption($option, "52");
            $this->createColumnOption($option, "m_52");
            $this->createColumnOption($option, "53");
            $this->createColumnOption($option, "m_53");
            $this->createColumnOption($option, "54");
            $this->createColumnOption($option, "m_54");
            $this->createColumnOption($option, "55");
            $this->createColumnOption($option, "m_55");
            $this->createColumnOption($option, "56");
            $this->createColumnOption($option, "m_56");
            $this->createColumnOption($option, "57");
            $this->createColumnOption($option, "m_57");
            $this->createColumnOption($option, "58");
            $this->createColumnOption($option, "m_58");
            $this->createColumnOption($option, "59");
            $this->createColumnOption($option, "m_59");
            $this->createColumnOption($option, "60");
            $this->createColumnOption($option, "m_60");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fs_omr_valuesrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fs_omr_valuesrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fs_omr_valuelist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_s_omr_value", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_s_omr_value",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // roll_no
        if ($this->roll_no->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->roll_no->AdvancedSearch->SearchValue != "" || $this->roll_no->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // test_id
        if ($this->test_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->test_id->AdvancedSearch->SearchValue != "" || $this->test_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // total
        if ($this->total->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->total->AdvancedSearch->SearchValue != "" || $this->total->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // percent
        if ($this->percent->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->percent->AdvancedSearch->SearchValue != "" || $this->percent->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_1
        if ($this->s_1->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_1->AdvancedSearch->SearchValue != "" || $this->s_1->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_2
        if ($this->s_2->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_2->AdvancedSearch->SearchValue != "" || $this->s_2->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_3
        if ($this->s_3->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_3->AdvancedSearch->SearchValue != "" || $this->s_3->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_4
        if ($this->s_4->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_4->AdvancedSearch->SearchValue != "" || $this->s_4->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_5
        if ($this->s_5->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_5->AdvancedSearch->SearchValue != "" || $this->s_5->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // omr_image
        if ($this->omr_image->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->omr_image->AdvancedSearch->SearchValue != "" || $this->omr_image->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 1
        if ($this->_1->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_1->AdvancedSearch->SearchValue != "" || $this->_1->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_1
        if ($this->m_1->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_1->AdvancedSearch->SearchValue != "" || $this->m_1->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 2
        if ($this->_2->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_2->AdvancedSearch->SearchValue != "" || $this->_2->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_2
        if ($this->m_2->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_2->AdvancedSearch->SearchValue != "" || $this->m_2->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 3
        if ($this->_3->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_3->AdvancedSearch->SearchValue != "" || $this->_3->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_3
        if ($this->m_3->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_3->AdvancedSearch->SearchValue != "" || $this->m_3->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 4
        if ($this->_4->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_4->AdvancedSearch->SearchValue != "" || $this->_4->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_4
        if ($this->m_4->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_4->AdvancedSearch->SearchValue != "" || $this->m_4->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 5
        if ($this->_5->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_5->AdvancedSearch->SearchValue != "" || $this->_5->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_5
        if ($this->m_5->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_5->AdvancedSearch->SearchValue != "" || $this->m_5->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 6
        if ($this->_6->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_6->AdvancedSearch->SearchValue != "" || $this->_6->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_6
        if ($this->m_6->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_6->AdvancedSearch->SearchValue != "" || $this->m_6->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 7
        if ($this->_7->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_7->AdvancedSearch->SearchValue != "" || $this->_7->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_7
        if ($this->m_7->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_7->AdvancedSearch->SearchValue != "" || $this->m_7->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 8
        if ($this->_8->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_8->AdvancedSearch->SearchValue != "" || $this->_8->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_8
        if ($this->m_8->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_8->AdvancedSearch->SearchValue != "" || $this->m_8->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 9
        if ($this->_9->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_9->AdvancedSearch->SearchValue != "" || $this->_9->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_9
        if ($this->m_9->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_9->AdvancedSearch->SearchValue != "" || $this->m_9->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 10
        if ($this->_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_10->AdvancedSearch->SearchValue != "" || $this->_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_10
        if ($this->m_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_10->AdvancedSearch->SearchValue != "" || $this->m_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 11
        if ($this->_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_11->AdvancedSearch->SearchValue != "" || $this->_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_11
        if ($this->m_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_11->AdvancedSearch->SearchValue != "" || $this->m_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 12
        if ($this->_12->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_12->AdvancedSearch->SearchValue != "" || $this->_12->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_12
        if ($this->m_12->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_12->AdvancedSearch->SearchValue != "" || $this->m_12->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 13
        if ($this->_13->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_13->AdvancedSearch->SearchValue != "" || $this->_13->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_13
        if ($this->m_13->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_13->AdvancedSearch->SearchValue != "" || $this->m_13->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 14
        if ($this->_14->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_14->AdvancedSearch->SearchValue != "" || $this->_14->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_14
        if ($this->m_14->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_14->AdvancedSearch->SearchValue != "" || $this->m_14->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 15
        if ($this->_15->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_15->AdvancedSearch->SearchValue != "" || $this->_15->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_15
        if ($this->m_15->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_15->AdvancedSearch->SearchValue != "" || $this->m_15->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 16
        if ($this->_16->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_16->AdvancedSearch->SearchValue != "" || $this->_16->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_16
        if ($this->m_16->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_16->AdvancedSearch->SearchValue != "" || $this->m_16->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 17
        if ($this->_17->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_17->AdvancedSearch->SearchValue != "" || $this->_17->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_17
        if ($this->m_17->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_17->AdvancedSearch->SearchValue != "" || $this->m_17->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 18
        if ($this->_18->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_18->AdvancedSearch->SearchValue != "" || $this->_18->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_18
        if ($this->m_18->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_18->AdvancedSearch->SearchValue != "" || $this->m_18->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 19
        if ($this->_19->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_19->AdvancedSearch->SearchValue != "" || $this->_19->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_19
        if ($this->m_19->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_19->AdvancedSearch->SearchValue != "" || $this->m_19->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 20
        if ($this->_20->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_20->AdvancedSearch->SearchValue != "" || $this->_20->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_20
        if ($this->m_20->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_20->AdvancedSearch->SearchValue != "" || $this->m_20->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 21
        if ($this->_21->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_21->AdvancedSearch->SearchValue != "" || $this->_21->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_21
        if ($this->m_21->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_21->AdvancedSearch->SearchValue != "" || $this->m_21->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 22
        if ($this->_22->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_22->AdvancedSearch->SearchValue != "" || $this->_22->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_22
        if ($this->m_22->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_22->AdvancedSearch->SearchValue != "" || $this->m_22->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 23
        if ($this->_23->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_23->AdvancedSearch->SearchValue != "" || $this->_23->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_23
        if ($this->m_23->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_23->AdvancedSearch->SearchValue != "" || $this->m_23->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 24
        if ($this->_24->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_24->AdvancedSearch->SearchValue != "" || $this->_24->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_24
        if ($this->m_24->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_24->AdvancedSearch->SearchValue != "" || $this->m_24->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 25
        if ($this->_25->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_25->AdvancedSearch->SearchValue != "" || $this->_25->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_25
        if ($this->m_25->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_25->AdvancedSearch->SearchValue != "" || $this->m_25->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 26
        if ($this->_26->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_26->AdvancedSearch->SearchValue != "" || $this->_26->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_26
        if ($this->m_26->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_26->AdvancedSearch->SearchValue != "" || $this->m_26->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 27
        if ($this->_27->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_27->AdvancedSearch->SearchValue != "" || $this->_27->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_27
        if ($this->m_27->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_27->AdvancedSearch->SearchValue != "" || $this->m_27->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 28
        if ($this->_28->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_28->AdvancedSearch->SearchValue != "" || $this->_28->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_28
        if ($this->m_28->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_28->AdvancedSearch->SearchValue != "" || $this->m_28->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 29
        if ($this->_29->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_29->AdvancedSearch->SearchValue != "" || $this->_29->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_29
        if ($this->m_29->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_29->AdvancedSearch->SearchValue != "" || $this->m_29->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 30
        if ($this->_30->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_30->AdvancedSearch->SearchValue != "" || $this->_30->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_30
        if ($this->m_30->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_30->AdvancedSearch->SearchValue != "" || $this->m_30->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 31
        if ($this->_31->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_31->AdvancedSearch->SearchValue != "" || $this->_31->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_31
        if ($this->m_31->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_31->AdvancedSearch->SearchValue != "" || $this->m_31->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 32
        if ($this->_32->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_32->AdvancedSearch->SearchValue != "" || $this->_32->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_32
        if ($this->m_32->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_32->AdvancedSearch->SearchValue != "" || $this->m_32->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 33
        if ($this->_33->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_33->AdvancedSearch->SearchValue != "" || $this->_33->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_33
        if ($this->m_33->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_33->AdvancedSearch->SearchValue != "" || $this->m_33->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 34
        if ($this->_34->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_34->AdvancedSearch->SearchValue != "" || $this->_34->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_34
        if ($this->m_34->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_34->AdvancedSearch->SearchValue != "" || $this->m_34->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 35
        if ($this->_35->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_35->AdvancedSearch->SearchValue != "" || $this->_35->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_35
        if ($this->m_35->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_35->AdvancedSearch->SearchValue != "" || $this->m_35->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 36
        if ($this->_36->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_36->AdvancedSearch->SearchValue != "" || $this->_36->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_36
        if ($this->m_36->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_36->AdvancedSearch->SearchValue != "" || $this->m_36->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 37
        if ($this->_37->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_37->AdvancedSearch->SearchValue != "" || $this->_37->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_37
        if ($this->m_37->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_37->AdvancedSearch->SearchValue != "" || $this->m_37->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 38
        if ($this->_38->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_38->AdvancedSearch->SearchValue != "" || $this->_38->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_38
        if ($this->m_38->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_38->AdvancedSearch->SearchValue != "" || $this->m_38->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 39
        if ($this->_39->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_39->AdvancedSearch->SearchValue != "" || $this->_39->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_39
        if ($this->m_39->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_39->AdvancedSearch->SearchValue != "" || $this->m_39->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 40
        if ($this->_40->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_40->AdvancedSearch->SearchValue != "" || $this->_40->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_40
        if ($this->m_40->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_40->AdvancedSearch->SearchValue != "" || $this->m_40->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 41
        if ($this->_41->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_41->AdvancedSearch->SearchValue != "" || $this->_41->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_41
        if ($this->m_41->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_41->AdvancedSearch->SearchValue != "" || $this->m_41->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 42
        if ($this->_42->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_42->AdvancedSearch->SearchValue != "" || $this->_42->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_42
        if ($this->m_42->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_42->AdvancedSearch->SearchValue != "" || $this->m_42->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 43
        if ($this->_43->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_43->AdvancedSearch->SearchValue != "" || $this->_43->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_43
        if ($this->m_43->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_43->AdvancedSearch->SearchValue != "" || $this->m_43->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 44
        if ($this->_44->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_44->AdvancedSearch->SearchValue != "" || $this->_44->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_44
        if ($this->m_44->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_44->AdvancedSearch->SearchValue != "" || $this->m_44->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 45
        if ($this->_45->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_45->AdvancedSearch->SearchValue != "" || $this->_45->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_45
        if ($this->m_45->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_45->AdvancedSearch->SearchValue != "" || $this->m_45->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 46
        if ($this->_46->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_46->AdvancedSearch->SearchValue != "" || $this->_46->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_46
        if ($this->m_46->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_46->AdvancedSearch->SearchValue != "" || $this->m_46->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 47
        if ($this->_47->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_47->AdvancedSearch->SearchValue != "" || $this->_47->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_47
        if ($this->m_47->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_47->AdvancedSearch->SearchValue != "" || $this->m_47->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 48
        if ($this->_48->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_48->AdvancedSearch->SearchValue != "" || $this->_48->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_48
        if ($this->m_48->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_48->AdvancedSearch->SearchValue != "" || $this->m_48->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 49
        if ($this->_49->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_49->AdvancedSearch->SearchValue != "" || $this->_49->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_49
        if ($this->m_49->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_49->AdvancedSearch->SearchValue != "" || $this->m_49->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 50
        if ($this->_50->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_50->AdvancedSearch->SearchValue != "" || $this->_50->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_50
        if ($this->m_50->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_50->AdvancedSearch->SearchValue != "" || $this->m_50->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 51
        if ($this->_51->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_51->AdvancedSearch->SearchValue != "" || $this->_51->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_51
        if ($this->m_51->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_51->AdvancedSearch->SearchValue != "" || $this->m_51->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 52
        if ($this->_52->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_52->AdvancedSearch->SearchValue != "" || $this->_52->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_52
        if ($this->m_52->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_52->AdvancedSearch->SearchValue != "" || $this->m_52->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 53
        if ($this->_53->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_53->AdvancedSearch->SearchValue != "" || $this->_53->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_53
        if ($this->m_53->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_53->AdvancedSearch->SearchValue != "" || $this->m_53->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 54
        if ($this->_54->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_54->AdvancedSearch->SearchValue != "" || $this->_54->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_54
        if ($this->m_54->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_54->AdvancedSearch->SearchValue != "" || $this->m_54->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 55
        if ($this->_55->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_55->AdvancedSearch->SearchValue != "" || $this->_55->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_55
        if ($this->m_55->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_55->AdvancedSearch->SearchValue != "" || $this->m_55->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 56
        if ($this->_56->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_56->AdvancedSearch->SearchValue != "" || $this->_56->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_56
        if ($this->m_56->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_56->AdvancedSearch->SearchValue != "" || $this->m_56->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 57
        if ($this->_57->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_57->AdvancedSearch->SearchValue != "" || $this->_57->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_57
        if ($this->m_57->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_57->AdvancedSearch->SearchValue != "" || $this->m_57->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 58
        if ($this->_58->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_58->AdvancedSearch->SearchValue != "" || $this->_58->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_58
        if ($this->m_58->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_58->AdvancedSearch->SearchValue != "" || $this->m_58->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 59
        if ($this->_59->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_59->AdvancedSearch->SearchValue != "" || $this->_59->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_59
        if ($this->m_59->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_59->AdvancedSearch->SearchValue != "" || $this->m_59->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // 60
        if ($this->_60->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_60->AdvancedSearch->SearchValue != "" || $this->_60->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // m_60
        if ($this->m_60->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->m_60->AdvancedSearch->SearchValue != "" || $this->m_60->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->test_id->setDbValue($row['test_id']);
        $this->total->setDbValue($row['total']);
        $this->percent->setDbValue($row['percent']);
        $this->s_1->setDbValue($row['s_1']);
        $this->s_2->setDbValue($row['s_2']);
        $this->s_3->setDbValue($row['s_3']);
        $this->s_4->setDbValue($row['s_4']);
        $this->s_5->setDbValue($row['s_5']);
        $this->omr_image->Upload->DbValue = $row['omr_image'];
        $this->omr_image->setDbValue($this->omr_image->Upload->DbValue);
        $this->_1->setDbValue($row['1']);
        $this->m_1->setDbValue($row['m_1']);
        $this->_2->setDbValue($row['2']);
        $this->m_2->setDbValue($row['m_2']);
        $this->_3->setDbValue($row['3']);
        $this->m_3->setDbValue($row['m_3']);
        $this->_4->setDbValue($row['4']);
        $this->m_4->setDbValue($row['m_4']);
        $this->_5->setDbValue($row['5']);
        $this->m_5->setDbValue($row['m_5']);
        $this->_6->setDbValue($row['6']);
        $this->m_6->setDbValue($row['m_6']);
        $this->_7->setDbValue($row['7']);
        $this->m_7->setDbValue($row['m_7']);
        $this->_8->setDbValue($row['8']);
        $this->m_8->setDbValue($row['m_8']);
        $this->_9->setDbValue($row['9']);
        $this->m_9->setDbValue($row['m_9']);
        $this->_10->setDbValue($row['10']);
        $this->m_10->setDbValue($row['m_10']);
        $this->_11->setDbValue($row['11']);
        $this->m_11->setDbValue($row['m_11']);
        $this->_12->setDbValue($row['12']);
        $this->m_12->setDbValue($row['m_12']);
        $this->_13->setDbValue($row['13']);
        $this->m_13->setDbValue($row['m_13']);
        $this->_14->setDbValue($row['14']);
        $this->m_14->setDbValue($row['m_14']);
        $this->_15->setDbValue($row['15']);
        $this->m_15->setDbValue($row['m_15']);
        $this->_16->setDbValue($row['16']);
        $this->m_16->setDbValue($row['m_16']);
        $this->_17->setDbValue($row['17']);
        $this->m_17->setDbValue($row['m_17']);
        $this->_18->setDbValue($row['18']);
        $this->m_18->setDbValue($row['m_18']);
        $this->_19->setDbValue($row['19']);
        $this->m_19->setDbValue($row['m_19']);
        $this->_20->setDbValue($row['20']);
        $this->m_20->setDbValue($row['m_20']);
        $this->_21->setDbValue($row['21']);
        $this->m_21->setDbValue($row['m_21']);
        $this->_22->setDbValue($row['22']);
        $this->m_22->setDbValue($row['m_22']);
        $this->_23->setDbValue($row['23']);
        $this->m_23->setDbValue($row['m_23']);
        $this->_24->setDbValue($row['24']);
        $this->m_24->setDbValue($row['m_24']);
        $this->_25->setDbValue($row['25']);
        $this->m_25->setDbValue($row['m_25']);
        $this->_26->setDbValue($row['26']);
        $this->m_26->setDbValue($row['m_26']);
        $this->_27->setDbValue($row['27']);
        $this->m_27->setDbValue($row['m_27']);
        $this->_28->setDbValue($row['28']);
        $this->m_28->setDbValue($row['m_28']);
        $this->_29->setDbValue($row['29']);
        $this->m_29->setDbValue($row['m_29']);
        $this->_30->setDbValue($row['30']);
        $this->m_30->setDbValue($row['m_30']);
        $this->_31->setDbValue($row['31']);
        $this->m_31->setDbValue($row['m_31']);
        $this->_32->setDbValue($row['32']);
        $this->m_32->setDbValue($row['m_32']);
        $this->_33->setDbValue($row['33']);
        $this->m_33->setDbValue($row['m_33']);
        $this->_34->setDbValue($row['34']);
        $this->m_34->setDbValue($row['m_34']);
        $this->_35->setDbValue($row['35']);
        $this->m_35->setDbValue($row['m_35']);
        $this->_36->setDbValue($row['36']);
        $this->m_36->setDbValue($row['m_36']);
        $this->_37->setDbValue($row['37']);
        $this->m_37->setDbValue($row['m_37']);
        $this->_38->setDbValue($row['38']);
        $this->m_38->setDbValue($row['m_38']);
        $this->_39->setDbValue($row['39']);
        $this->m_39->setDbValue($row['m_39']);
        $this->_40->setDbValue($row['40']);
        $this->m_40->setDbValue($row['m_40']);
        $this->_41->setDbValue($row['41']);
        $this->m_41->setDbValue($row['m_41']);
        $this->_42->setDbValue($row['42']);
        $this->m_42->setDbValue($row['m_42']);
        $this->_43->setDbValue($row['43']);
        $this->m_43->setDbValue($row['m_43']);
        $this->_44->setDbValue($row['44']);
        $this->m_44->setDbValue($row['m_44']);
        $this->_45->setDbValue($row['45']);
        $this->m_45->setDbValue($row['m_45']);
        $this->_46->setDbValue($row['46']);
        $this->m_46->setDbValue($row['m_46']);
        $this->_47->setDbValue($row['47']);
        $this->m_47->setDbValue($row['m_47']);
        $this->_48->setDbValue($row['48']);
        $this->m_48->setDbValue($row['m_48']);
        $this->_49->setDbValue($row['49']);
        $this->m_49->setDbValue($row['m_49']);
        $this->_50->setDbValue($row['50']);
        $this->m_50->setDbValue($row['m_50']);
        $this->_51->setDbValue($row['51']);
        $this->m_51->setDbValue($row['m_51']);
        $this->_52->setDbValue($row['52']);
        $this->m_52->setDbValue($row['m_52']);
        $this->_53->setDbValue($row['53']);
        $this->m_53->setDbValue($row['m_53']);
        $this->_54->setDbValue($row['54']);
        $this->m_54->setDbValue($row['m_54']);
        $this->_55->setDbValue($row['55']);
        $this->m_55->setDbValue($row['m_55']);
        $this->_56->setDbValue($row['56']);
        $this->m_56->setDbValue($row['m_56']);
        $this->_57->setDbValue($row['57']);
        $this->m_57->setDbValue($row['m_57']);
        $this->_58->setDbValue($row['58']);
        $this->m_58->setDbValue($row['m_58']);
        $this->_59->setDbValue($row['59']);
        $this->m_59->setDbValue($row['m_59']);
        $this->_60->setDbValue($row['60']);
        $this->m_60->setDbValue($row['m_60']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['test_id'] = $this->test_id->DefaultValue;
        $row['total'] = $this->total->DefaultValue;
        $row['percent'] = $this->percent->DefaultValue;
        $row['s_1'] = $this->s_1->DefaultValue;
        $row['s_2'] = $this->s_2->DefaultValue;
        $row['s_3'] = $this->s_3->DefaultValue;
        $row['s_4'] = $this->s_4->DefaultValue;
        $row['s_5'] = $this->s_5->DefaultValue;
        $row['omr_image'] = $this->omr_image->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['m_1'] = $this->m_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['m_2'] = $this->m_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['m_3'] = $this->m_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['m_4'] = $this->m_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['m_5'] = $this->m_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['m_6'] = $this->m_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['m_7'] = $this->m_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['m_8'] = $this->m_8->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['m_9'] = $this->m_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['m_10'] = $this->m_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['m_11'] = $this->m_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['m_12'] = $this->m_12->DefaultValue;
        $row['13'] = $this->_13->DefaultValue;
        $row['m_13'] = $this->m_13->DefaultValue;
        $row['14'] = $this->_14->DefaultValue;
        $row['m_14'] = $this->m_14->DefaultValue;
        $row['15'] = $this->_15->DefaultValue;
        $row['m_15'] = $this->m_15->DefaultValue;
        $row['16'] = $this->_16->DefaultValue;
        $row['m_16'] = $this->m_16->DefaultValue;
        $row['17'] = $this->_17->DefaultValue;
        $row['m_17'] = $this->m_17->DefaultValue;
        $row['18'] = $this->_18->DefaultValue;
        $row['m_18'] = $this->m_18->DefaultValue;
        $row['19'] = $this->_19->DefaultValue;
        $row['m_19'] = $this->m_19->DefaultValue;
        $row['20'] = $this->_20->DefaultValue;
        $row['m_20'] = $this->m_20->DefaultValue;
        $row['21'] = $this->_21->DefaultValue;
        $row['m_21'] = $this->m_21->DefaultValue;
        $row['22'] = $this->_22->DefaultValue;
        $row['m_22'] = $this->m_22->DefaultValue;
        $row['23'] = $this->_23->DefaultValue;
        $row['m_23'] = $this->m_23->DefaultValue;
        $row['24'] = $this->_24->DefaultValue;
        $row['m_24'] = $this->m_24->DefaultValue;
        $row['25'] = $this->_25->DefaultValue;
        $row['m_25'] = $this->m_25->DefaultValue;
        $row['26'] = $this->_26->DefaultValue;
        $row['m_26'] = $this->m_26->DefaultValue;
        $row['27'] = $this->_27->DefaultValue;
        $row['m_27'] = $this->m_27->DefaultValue;
        $row['28'] = $this->_28->DefaultValue;
        $row['m_28'] = $this->m_28->DefaultValue;
        $row['29'] = $this->_29->DefaultValue;
        $row['m_29'] = $this->m_29->DefaultValue;
        $row['30'] = $this->_30->DefaultValue;
        $row['m_30'] = $this->m_30->DefaultValue;
        $row['31'] = $this->_31->DefaultValue;
        $row['m_31'] = $this->m_31->DefaultValue;
        $row['32'] = $this->_32->DefaultValue;
        $row['m_32'] = $this->m_32->DefaultValue;
        $row['33'] = $this->_33->DefaultValue;
        $row['m_33'] = $this->m_33->DefaultValue;
        $row['34'] = $this->_34->DefaultValue;
        $row['m_34'] = $this->m_34->DefaultValue;
        $row['35'] = $this->_35->DefaultValue;
        $row['m_35'] = $this->m_35->DefaultValue;
        $row['36'] = $this->_36->DefaultValue;
        $row['m_36'] = $this->m_36->DefaultValue;
        $row['37'] = $this->_37->DefaultValue;
        $row['m_37'] = $this->m_37->DefaultValue;
        $row['38'] = $this->_38->DefaultValue;
        $row['m_38'] = $this->m_38->DefaultValue;
        $row['39'] = $this->_39->DefaultValue;
        $row['m_39'] = $this->m_39->DefaultValue;
        $row['40'] = $this->_40->DefaultValue;
        $row['m_40'] = $this->m_40->DefaultValue;
        $row['41'] = $this->_41->DefaultValue;
        $row['m_41'] = $this->m_41->DefaultValue;
        $row['42'] = $this->_42->DefaultValue;
        $row['m_42'] = $this->m_42->DefaultValue;
        $row['43'] = $this->_43->DefaultValue;
        $row['m_43'] = $this->m_43->DefaultValue;
        $row['44'] = $this->_44->DefaultValue;
        $row['m_44'] = $this->m_44->DefaultValue;
        $row['45'] = $this->_45->DefaultValue;
        $row['m_45'] = $this->m_45->DefaultValue;
        $row['46'] = $this->_46->DefaultValue;
        $row['m_46'] = $this->m_46->DefaultValue;
        $row['47'] = $this->_47->DefaultValue;
        $row['m_47'] = $this->m_47->DefaultValue;
        $row['48'] = $this->_48->DefaultValue;
        $row['m_48'] = $this->m_48->DefaultValue;
        $row['49'] = $this->_49->DefaultValue;
        $row['m_49'] = $this->m_49->DefaultValue;
        $row['50'] = $this->_50->DefaultValue;
        $row['m_50'] = $this->m_50->DefaultValue;
        $row['51'] = $this->_51->DefaultValue;
        $row['m_51'] = $this->m_51->DefaultValue;
        $row['52'] = $this->_52->DefaultValue;
        $row['m_52'] = $this->m_52->DefaultValue;
        $row['53'] = $this->_53->DefaultValue;
        $row['m_53'] = $this->m_53->DefaultValue;
        $row['54'] = $this->_54->DefaultValue;
        $row['m_54'] = $this->m_54->DefaultValue;
        $row['55'] = $this->_55->DefaultValue;
        $row['m_55'] = $this->m_55->DefaultValue;
        $row['56'] = $this->_56->DefaultValue;
        $row['m_56'] = $this->m_56->DefaultValue;
        $row['57'] = $this->_57->DefaultValue;
        $row['m_57'] = $this->m_57->DefaultValue;
        $row['58'] = $this->_58->DefaultValue;
        $row['m_58'] = $this->m_58->DefaultValue;
        $row['59'] = $this->_59->DefaultValue;
        $row['m_59'] = $this->m_59->DefaultValue;
        $row['60'] = $this->_60->DefaultValue;
        $row['m_60'] = $this->m_60->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // roll_no

        // test_id

        // total

        // percent

        // s_1

        // s_2

        // s_3

        // s_4

        // s_5

        // omr_image

        // 1

        // m_1

        // 2

        // m_2

        // 3

        // m_3

        // 4

        // m_4

        // 5

        // m_5

        // 6

        // m_6

        // 7

        // m_7

        // 8

        // m_8

        // 9

        // m_9

        // 10

        // m_10

        // 11

        // m_11

        // 12

        // m_12

        // 13

        // m_13

        // 14

        // m_14

        // 15

        // m_15

        // 16

        // m_16

        // 17

        // m_17

        // 18

        // m_18

        // 19

        // m_19

        // 20

        // m_20

        // 21

        // m_21

        // 22

        // m_22

        // 23

        // m_23

        // 24

        // m_24

        // 25

        // m_25

        // 26

        // m_26

        // 27

        // m_27

        // 28

        // m_28

        // 29

        // m_29

        // 30

        // m_30

        // 31

        // m_31

        // 32

        // m_32

        // 33

        // m_33

        // 34

        // m_34

        // 35

        // m_35

        // 36

        // m_36

        // 37

        // m_37

        // 38

        // m_38

        // 39

        // m_39

        // 40

        // m_40

        // 41

        // m_41

        // 42

        // m_42

        // 43

        // m_43

        // 44

        // m_44

        // 45

        // m_45

        // 46

        // m_46

        // 47

        // m_47

        // 48

        // m_48

        // 49

        // m_49

        // 50

        // m_50

        // 51

        // m_51

        // 52

        // m_52

        // 53

        // m_53

        // 54

        // m_54

        // 55

        // m_55

        // 56

        // m_56

        // 57

        // m_57

        // 58

        // m_58

        // 59

        // m_59

        // 60

        // m_60

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;

            // test_id
            $this->test_id->ViewValue = $this->test_id->CurrentValue;

            // total
            $this->total->ViewValue = $this->total->CurrentValue;
            $this->total->ViewValue = FormatNumber($this->total->ViewValue, $this->total->formatPattern());

            // percent
            $this->percent->ViewValue = $this->percent->CurrentValue;
            $this->percent->ViewValue = FormatNumber($this->percent->ViewValue, $this->percent->formatPattern());

            // s_1
            $this->s_1->ViewValue = $this->s_1->CurrentValue;
            $this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, $this->s_1->formatPattern());

            // s_2
            $this->s_2->ViewValue = $this->s_2->CurrentValue;
            $this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, $this->s_2->formatPattern());

            // s_3
            $this->s_3->ViewValue = $this->s_3->CurrentValue;
            $this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, $this->s_3->formatPattern());

            // s_4
            $this->s_4->ViewValue = $this->s_4->CurrentValue;
            $this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, $this->s_4->formatPattern());

            // s_5
            $this->s_5->ViewValue = $this->s_5->CurrentValue;
            $this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, $this->s_5->formatPattern());

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->ImageWidth = 0;
                $this->omr_image->ImageHeight = 50;
                $this->omr_image->ImageAlt = $this->omr_image->alt();
                $this->omr_image->ImageCssClass = "ew-image";
                $this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
            } else {
                $this->omr_image->ViewValue = "";
            }

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // m_1
            $this->m_1->ViewValue = $this->m_1->CurrentValue;
            $this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, $this->m_1->formatPattern());

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // m_2
            $this->m_2->ViewValue = $this->m_2->CurrentValue;
            $this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, $this->m_2->formatPattern());

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // m_3
            $this->m_3->ViewValue = $this->m_3->CurrentValue;
            $this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, $this->m_3->formatPattern());

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // m_4
            $this->m_4->ViewValue = $this->m_4->CurrentValue;
            $this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, $this->m_4->formatPattern());

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // m_5
            $this->m_5->ViewValue = $this->m_5->CurrentValue;
            $this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, $this->m_5->formatPattern());

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // m_6
            $this->m_6->ViewValue = $this->m_6->CurrentValue;
            $this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, $this->m_6->formatPattern());

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // m_7
            $this->m_7->ViewValue = $this->m_7->CurrentValue;
            $this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, $this->m_7->formatPattern());

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // m_8
            $this->m_8->ViewValue = $this->m_8->CurrentValue;
            $this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, $this->m_8->formatPattern());

            // 9
            $this->_9->ViewValue = $this->_9->CurrentValue;

            // m_9
            $this->m_9->ViewValue = $this->m_9->CurrentValue;
            $this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, $this->m_9->formatPattern());

            // 10
            $this->_10->ViewValue = $this->_10->CurrentValue;

            // m_10
            $this->m_10->ViewValue = $this->m_10->CurrentValue;
            $this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, $this->m_10->formatPattern());

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // m_11
            $this->m_11->ViewValue = $this->m_11->CurrentValue;
            $this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, $this->m_11->formatPattern());

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // m_12
            $this->m_12->ViewValue = $this->m_12->CurrentValue;
            $this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, $this->m_12->formatPattern());

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // m_13
            $this->m_13->ViewValue = $this->m_13->CurrentValue;
            $this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, $this->m_13->formatPattern());

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // m_14
            $this->m_14->ViewValue = $this->m_14->CurrentValue;
            $this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, $this->m_14->formatPattern());

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // m_15
            $this->m_15->ViewValue = $this->m_15->CurrentValue;
            $this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, $this->m_15->formatPattern());

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // m_16
            $this->m_16->ViewValue = $this->m_16->CurrentValue;
            $this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, $this->m_16->formatPattern());

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // m_17
            $this->m_17->ViewValue = $this->m_17->CurrentValue;
            $this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, $this->m_17->formatPattern());

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // m_18
            $this->m_18->ViewValue = $this->m_18->CurrentValue;
            $this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, $this->m_18->formatPattern());

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // m_19
            $this->m_19->ViewValue = $this->m_19->CurrentValue;
            $this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, $this->m_19->formatPattern());

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // m_20
            $this->m_20->ViewValue = $this->m_20->CurrentValue;
            $this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, $this->m_20->formatPattern());

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // m_21
            $this->m_21->ViewValue = $this->m_21->CurrentValue;
            $this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, $this->m_21->formatPattern());

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // m_22
            $this->m_22->ViewValue = $this->m_22->CurrentValue;
            $this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, $this->m_22->formatPattern());

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // m_23
            $this->m_23->ViewValue = $this->m_23->CurrentValue;
            $this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, $this->m_23->formatPattern());

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // m_24
            $this->m_24->ViewValue = $this->m_24->CurrentValue;
            $this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, $this->m_24->formatPattern());

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // m_25
            $this->m_25->ViewValue = $this->m_25->CurrentValue;
            $this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, $this->m_25->formatPattern());

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // m_26
            $this->m_26->ViewValue = $this->m_26->CurrentValue;
            $this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, $this->m_26->formatPattern());

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // m_27
            $this->m_27->ViewValue = $this->m_27->CurrentValue;
            $this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, $this->m_27->formatPattern());

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // m_28
            $this->m_28->ViewValue = $this->m_28->CurrentValue;
            $this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, $this->m_28->formatPattern());

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // m_29
            $this->m_29->ViewValue = $this->m_29->CurrentValue;
            $this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, $this->m_29->formatPattern());

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // m_30
            $this->m_30->ViewValue = $this->m_30->CurrentValue;
            $this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, $this->m_30->formatPattern());

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // m_31
            $this->m_31->ViewValue = $this->m_31->CurrentValue;
            $this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, $this->m_31->formatPattern());

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // m_32
            $this->m_32->ViewValue = $this->m_32->CurrentValue;
            $this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, $this->m_32->formatPattern());

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // m_33
            $this->m_33->ViewValue = $this->m_33->CurrentValue;
            $this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, $this->m_33->formatPattern());

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // m_34
            $this->m_34->ViewValue = $this->m_34->CurrentValue;
            $this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, $this->m_34->formatPattern());

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // m_35
            $this->m_35->ViewValue = $this->m_35->CurrentValue;
            $this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, $this->m_35->formatPattern());

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // m_36
            $this->m_36->ViewValue = $this->m_36->CurrentValue;
            $this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, $this->m_36->formatPattern());

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // m_37
            $this->m_37->ViewValue = $this->m_37->CurrentValue;
            $this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, $this->m_37->formatPattern());

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // m_38
            $this->m_38->ViewValue = $this->m_38->CurrentValue;
            $this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, $this->m_38->formatPattern());

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // m_39
            $this->m_39->ViewValue = $this->m_39->CurrentValue;
            $this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, $this->m_39->formatPattern());

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // m_40
            $this->m_40->ViewValue = $this->m_40->CurrentValue;
            $this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, $this->m_40->formatPattern());

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // m_41
            $this->m_41->ViewValue = $this->m_41->CurrentValue;
            $this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, $this->m_41->formatPattern());

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // m_42
            $this->m_42->ViewValue = $this->m_42->CurrentValue;
            $this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, $this->m_42->formatPattern());

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // m_43
            $this->m_43->ViewValue = $this->m_43->CurrentValue;
            $this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, $this->m_43->formatPattern());

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // m_44
            $this->m_44->ViewValue = $this->m_44->CurrentValue;
            $this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, $this->m_44->formatPattern());

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // m_45
            $this->m_45->ViewValue = $this->m_45->CurrentValue;
            $this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, $this->m_45->formatPattern());

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // m_46
            $this->m_46->ViewValue = $this->m_46->CurrentValue;
            $this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, $this->m_46->formatPattern());

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // m_47
            $this->m_47->ViewValue = $this->m_47->CurrentValue;
            $this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, $this->m_47->formatPattern());

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // m_48
            $this->m_48->ViewValue = $this->m_48->CurrentValue;
            $this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, $this->m_48->formatPattern());

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // m_49
            $this->m_49->ViewValue = $this->m_49->CurrentValue;
            $this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, $this->m_49->formatPattern());

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // m_50
            $this->m_50->ViewValue = $this->m_50->CurrentValue;
            $this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, $this->m_50->formatPattern());

            // 51
            $this->_51->ViewValue = $this->_51->CurrentValue;

            // m_51
            $this->m_51->ViewValue = $this->m_51->CurrentValue;
            $this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, $this->m_51->formatPattern());

            // 52
            $this->_52->ViewValue = $this->_52->CurrentValue;

            // m_52
            $this->m_52->ViewValue = $this->m_52->CurrentValue;
            $this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, $this->m_52->formatPattern());

            // 53
            $this->_53->ViewValue = $this->_53->CurrentValue;

            // m_53
            $this->m_53->ViewValue = $this->m_53->CurrentValue;
            $this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, $this->m_53->formatPattern());

            // 54
            $this->_54->ViewValue = $this->_54->CurrentValue;

            // m_54
            $this->m_54->ViewValue = $this->m_54->CurrentValue;
            $this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, $this->m_54->formatPattern());

            // 55
            $this->_55->ViewValue = $this->_55->CurrentValue;

            // m_55
            $this->m_55->ViewValue = $this->m_55->CurrentValue;
            $this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, $this->m_55->formatPattern());

            // 56
            $this->_56->ViewValue = $this->_56->CurrentValue;

            // m_56
            $this->m_56->ViewValue = $this->m_56->CurrentValue;
            $this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, $this->m_56->formatPattern());

            // 57
            $this->_57->ViewValue = $this->_57->CurrentValue;

            // m_57
            $this->m_57->ViewValue = $this->m_57->CurrentValue;
            $this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, $this->m_57->formatPattern());

            // 58
            $this->_58->ViewValue = $this->_58->CurrentValue;

            // m_58
            $this->m_58->ViewValue = $this->m_58->CurrentValue;
            $this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, $this->m_58->formatPattern());

            // 59
            $this->_59->ViewValue = $this->_59->CurrentValue;

            // m_59
            $this->m_59->ViewValue = $this->m_59->CurrentValue;
            $this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, $this->m_59->formatPattern());

            // 60
            $this->_60->ViewValue = $this->_60->CurrentValue;

            // m_60
            $this->m_60->ViewValue = $this->m_60->CurrentValue;
            $this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, $this->m_60->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->id->ViewValue = $this->highlightValue($this->id);
            }

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";
            if (!$this->isExport()) {
                $this->roll_no->ViewValue = $this->highlightValue($this->roll_no);
            }

            // test_id
            $this->test_id->HrefValue = "";
            $this->test_id->TooltipValue = "";
            if (!$this->isExport()) {
                $this->test_id->ViewValue = $this->highlightValue($this->test_id);
            }

            // total
            $this->total->HrefValue = "";
            $this->total->TooltipValue = "";

            // percent
            $this->percent->HrefValue = "";
            $this->percent->TooltipValue = "";

            // s_1
            $this->s_1->HrefValue = "";
            $this->s_1->TooltipValue = "";

            // s_2
            $this->s_2->HrefValue = "";
            $this->s_2->TooltipValue = "";

            // s_3
            $this->s_3->HrefValue = "";
            $this->s_3->TooltipValue = "";

            // s_4
            $this->s_4->HrefValue = "";
            $this->s_4->TooltipValue = "";

            // s_5
            $this->s_5->HrefValue = "";
            $this->s_5->TooltipValue = "";

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->htmlDecode($this->omr_image->Upload->DbValue)); // Add prefix/suffix
                $this->omr_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
                }
            } else {
                $this->omr_image->HrefValue = "";
            }
            $this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;
            $this->omr_image->TooltipValue = "";
            if ($this->omr_image->UseColorbox) {
                if (EmptyValue($this->omr_image->TooltipValue)) {
                    $this->omr_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->omr_image->LinkAttrs["data-rel"] = "s_omr_value_x" . $this->RowCount . "_omr_image";
                $this->omr_image->LinkAttrs->appendClass("ew-lightbox");
            }

            // 1
            $this->_1->HrefValue = "";
            $this->_1->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_1->ViewValue = $this->highlightValue($this->_1);
            }

            // m_1
            $this->m_1->HrefValue = "";
            $this->m_1->TooltipValue = "";

            // 2
            $this->_2->HrefValue = "";
            $this->_2->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_2->ViewValue = $this->highlightValue($this->_2);
            }

            // m_2
            $this->m_2->HrefValue = "";
            $this->m_2->TooltipValue = "";

            // 3
            $this->_3->HrefValue = "";
            $this->_3->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_3->ViewValue = $this->highlightValue($this->_3);
            }

            // m_3
            $this->m_3->HrefValue = "";
            $this->m_3->TooltipValue = "";

            // 4
            $this->_4->HrefValue = "";
            $this->_4->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_4->ViewValue = $this->highlightValue($this->_4);
            }

            // m_4
            $this->m_4->HrefValue = "";
            $this->m_4->TooltipValue = "";

            // 5
            $this->_5->HrefValue = "";
            $this->_5->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_5->ViewValue = $this->highlightValue($this->_5);
            }

            // m_5
            $this->m_5->HrefValue = "";
            $this->m_5->TooltipValue = "";

            // 6
            $this->_6->HrefValue = "";
            $this->_6->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_6->ViewValue = $this->highlightValue($this->_6);
            }

            // m_6
            $this->m_6->HrefValue = "";
            $this->m_6->TooltipValue = "";

            // 7
            $this->_7->HrefValue = "";
            $this->_7->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_7->ViewValue = $this->highlightValue($this->_7);
            }

            // m_7
            $this->m_7->HrefValue = "";
            $this->m_7->TooltipValue = "";

            // 8
            $this->_8->HrefValue = "";
            $this->_8->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_8->ViewValue = $this->highlightValue($this->_8);
            }

            // m_8
            $this->m_8->HrefValue = "";
            $this->m_8->TooltipValue = "";

            // 9
            $this->_9->HrefValue = "";
            $this->_9->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_9->ViewValue = $this->highlightValue($this->_9);
            }

            // m_9
            $this->m_9->HrefValue = "";
            $this->m_9->TooltipValue = "";

            // 10
            $this->_10->HrefValue = "";
            $this->_10->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_10->ViewValue = $this->highlightValue($this->_10);
            }

            // m_10
            $this->m_10->HrefValue = "";
            $this->m_10->TooltipValue = "";

            // 11
            $this->_11->HrefValue = "";
            $this->_11->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_11->ViewValue = $this->highlightValue($this->_11);
            }

            // m_11
            $this->m_11->HrefValue = "";
            $this->m_11->TooltipValue = "";

            // 12
            $this->_12->HrefValue = "";
            $this->_12->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_12->ViewValue = $this->highlightValue($this->_12);
            }

            // m_12
            $this->m_12->HrefValue = "";
            $this->m_12->TooltipValue = "";

            // 13
            $this->_13->HrefValue = "";
            $this->_13->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_13->ViewValue = $this->highlightValue($this->_13);
            }

            // m_13
            $this->m_13->HrefValue = "";
            $this->m_13->TooltipValue = "";

            // 14
            $this->_14->HrefValue = "";
            $this->_14->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_14->ViewValue = $this->highlightValue($this->_14);
            }

            // m_14
            $this->m_14->HrefValue = "";
            $this->m_14->TooltipValue = "";

            // 15
            $this->_15->HrefValue = "";
            $this->_15->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_15->ViewValue = $this->highlightValue($this->_15);
            }

            // m_15
            $this->m_15->HrefValue = "";
            $this->m_15->TooltipValue = "";

            // 16
            $this->_16->HrefValue = "";
            $this->_16->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_16->ViewValue = $this->highlightValue($this->_16);
            }

            // m_16
            $this->m_16->HrefValue = "";
            $this->m_16->TooltipValue = "";

            // 17
            $this->_17->HrefValue = "";
            $this->_17->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_17->ViewValue = $this->highlightValue($this->_17);
            }

            // m_17
            $this->m_17->HrefValue = "";
            $this->m_17->TooltipValue = "";

            // 18
            $this->_18->HrefValue = "";
            $this->_18->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_18->ViewValue = $this->highlightValue($this->_18);
            }

            // m_18
            $this->m_18->HrefValue = "";
            $this->m_18->TooltipValue = "";

            // 19
            $this->_19->HrefValue = "";
            $this->_19->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_19->ViewValue = $this->highlightValue($this->_19);
            }

            // m_19
            $this->m_19->HrefValue = "";
            $this->m_19->TooltipValue = "";

            // 20
            $this->_20->HrefValue = "";
            $this->_20->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_20->ViewValue = $this->highlightValue($this->_20);
            }

            // m_20
            $this->m_20->HrefValue = "";
            $this->m_20->TooltipValue = "";

            // 21
            $this->_21->HrefValue = "";
            $this->_21->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_21->ViewValue = $this->highlightValue($this->_21);
            }

            // m_21
            $this->m_21->HrefValue = "";
            $this->m_21->TooltipValue = "";

            // 22
            $this->_22->HrefValue = "";
            $this->_22->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_22->ViewValue = $this->highlightValue($this->_22);
            }

            // m_22
            $this->m_22->HrefValue = "";
            $this->m_22->TooltipValue = "";

            // 23
            $this->_23->HrefValue = "";
            $this->_23->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_23->ViewValue = $this->highlightValue($this->_23);
            }

            // m_23
            $this->m_23->HrefValue = "";
            $this->m_23->TooltipValue = "";

            // 24
            $this->_24->HrefValue = "";
            $this->_24->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_24->ViewValue = $this->highlightValue($this->_24);
            }

            // m_24
            $this->m_24->HrefValue = "";
            $this->m_24->TooltipValue = "";

            // 25
            $this->_25->HrefValue = "";
            $this->_25->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_25->ViewValue = $this->highlightValue($this->_25);
            }

            // m_25
            $this->m_25->HrefValue = "";
            $this->m_25->TooltipValue = "";

            // 26
            $this->_26->HrefValue = "";
            $this->_26->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_26->ViewValue = $this->highlightValue($this->_26);
            }

            // m_26
            $this->m_26->HrefValue = "";
            $this->m_26->TooltipValue = "";

            // 27
            $this->_27->HrefValue = "";
            $this->_27->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_27->ViewValue = $this->highlightValue($this->_27);
            }

            // m_27
            $this->m_27->HrefValue = "";
            $this->m_27->TooltipValue = "";

            // 28
            $this->_28->HrefValue = "";
            $this->_28->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_28->ViewValue = $this->highlightValue($this->_28);
            }

            // m_28
            $this->m_28->HrefValue = "";
            $this->m_28->TooltipValue = "";

            // 29
            $this->_29->HrefValue = "";
            $this->_29->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_29->ViewValue = $this->highlightValue($this->_29);
            }

            // m_29
            $this->m_29->HrefValue = "";
            $this->m_29->TooltipValue = "";

            // 30
            $this->_30->HrefValue = "";
            $this->_30->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_30->ViewValue = $this->highlightValue($this->_30);
            }

            // m_30
            $this->m_30->HrefValue = "";
            $this->m_30->TooltipValue = "";

            // 31
            $this->_31->HrefValue = "";
            $this->_31->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_31->ViewValue = $this->highlightValue($this->_31);
            }

            // m_31
            $this->m_31->HrefValue = "";
            $this->m_31->TooltipValue = "";

            // 32
            $this->_32->HrefValue = "";
            $this->_32->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_32->ViewValue = $this->highlightValue($this->_32);
            }

            // m_32
            $this->m_32->HrefValue = "";
            $this->m_32->TooltipValue = "";

            // 33
            $this->_33->HrefValue = "";
            $this->_33->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_33->ViewValue = $this->highlightValue($this->_33);
            }

            // m_33
            $this->m_33->HrefValue = "";
            $this->m_33->TooltipValue = "";

            // 34
            $this->_34->HrefValue = "";
            $this->_34->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_34->ViewValue = $this->highlightValue($this->_34);
            }

            // m_34
            $this->m_34->HrefValue = "";
            $this->m_34->TooltipValue = "";

            // 35
            $this->_35->HrefValue = "";
            $this->_35->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_35->ViewValue = $this->highlightValue($this->_35);
            }

            // m_35
            $this->m_35->HrefValue = "";
            $this->m_35->TooltipValue = "";

            // 36
            $this->_36->HrefValue = "";
            $this->_36->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_36->ViewValue = $this->highlightValue($this->_36);
            }

            // m_36
            $this->m_36->HrefValue = "";
            $this->m_36->TooltipValue = "";

            // 37
            $this->_37->HrefValue = "";
            $this->_37->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_37->ViewValue = $this->highlightValue($this->_37);
            }

            // m_37
            $this->m_37->HrefValue = "";
            $this->m_37->TooltipValue = "";

            // 38
            $this->_38->HrefValue = "";
            $this->_38->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_38->ViewValue = $this->highlightValue($this->_38);
            }

            // m_38
            $this->m_38->HrefValue = "";
            $this->m_38->TooltipValue = "";

            // 39
            $this->_39->HrefValue = "";
            $this->_39->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_39->ViewValue = $this->highlightValue($this->_39);
            }

            // m_39
            $this->m_39->HrefValue = "";
            $this->m_39->TooltipValue = "";

            // 40
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_40->ViewValue = $this->highlightValue($this->_40);
            }

            // m_40
            $this->m_40->HrefValue = "";
            $this->m_40->TooltipValue = "";

            // 41
            $this->_41->HrefValue = "";
            $this->_41->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_41->ViewValue = $this->highlightValue($this->_41);
            }

            // m_41
            $this->m_41->HrefValue = "";
            $this->m_41->TooltipValue = "";

            // 42
            $this->_42->HrefValue = "";
            $this->_42->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_42->ViewValue = $this->highlightValue($this->_42);
            }

            // m_42
            $this->m_42->HrefValue = "";
            $this->m_42->TooltipValue = "";

            // 43
            $this->_43->HrefValue = "";
            $this->_43->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_43->ViewValue = $this->highlightValue($this->_43);
            }

            // m_43
            $this->m_43->HrefValue = "";
            $this->m_43->TooltipValue = "";

            // 44
            $this->_44->HrefValue = "";
            $this->_44->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_44->ViewValue = $this->highlightValue($this->_44);
            }

            // m_44
            $this->m_44->HrefValue = "";
            $this->m_44->TooltipValue = "";

            // 45
            $this->_45->HrefValue = "";
            $this->_45->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_45->ViewValue = $this->highlightValue($this->_45);
            }

            // m_45
            $this->m_45->HrefValue = "";
            $this->m_45->TooltipValue = "";

            // 46
            $this->_46->HrefValue = "";
            $this->_46->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_46->ViewValue = $this->highlightValue($this->_46);
            }

            // m_46
            $this->m_46->HrefValue = "";
            $this->m_46->TooltipValue = "";

            // 47
            $this->_47->HrefValue = "";
            $this->_47->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_47->ViewValue = $this->highlightValue($this->_47);
            }

            // m_47
            $this->m_47->HrefValue = "";
            $this->m_47->TooltipValue = "";

            // 48
            $this->_48->HrefValue = "";
            $this->_48->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_48->ViewValue = $this->highlightValue($this->_48);
            }

            // m_48
            $this->m_48->HrefValue = "";
            $this->m_48->TooltipValue = "";

            // 49
            $this->_49->HrefValue = "";
            $this->_49->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_49->ViewValue = $this->highlightValue($this->_49);
            }

            // m_49
            $this->m_49->HrefValue = "";
            $this->m_49->TooltipValue = "";

            // 50
            $this->_50->HrefValue = "";
            $this->_50->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_50->ViewValue = $this->highlightValue($this->_50);
            }

            // m_50
            $this->m_50->HrefValue = "";
            $this->m_50->TooltipValue = "";

            // 51
            $this->_51->HrefValue = "";
            $this->_51->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_51->ViewValue = $this->highlightValue($this->_51);
            }

            // m_51
            $this->m_51->HrefValue = "";
            $this->m_51->TooltipValue = "";

            // 52
            $this->_52->HrefValue = "";
            $this->_52->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_52->ViewValue = $this->highlightValue($this->_52);
            }

            // m_52
            $this->m_52->HrefValue = "";
            $this->m_52->TooltipValue = "";

            // 53
            $this->_53->HrefValue = "";
            $this->_53->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_53->ViewValue = $this->highlightValue($this->_53);
            }

            // m_53
            $this->m_53->HrefValue = "";
            $this->m_53->TooltipValue = "";

            // 54
            $this->_54->HrefValue = "";
            $this->_54->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_54->ViewValue = $this->highlightValue($this->_54);
            }

            // m_54
            $this->m_54->HrefValue = "";
            $this->m_54->TooltipValue = "";

            // 55
            $this->_55->HrefValue = "";
            $this->_55->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_55->ViewValue = $this->highlightValue($this->_55);
            }

            // m_55
            $this->m_55->HrefValue = "";
            $this->m_55->TooltipValue = "";

            // 56
            $this->_56->HrefValue = "";
            $this->_56->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_56->ViewValue = $this->highlightValue($this->_56);
            }

            // m_56
            $this->m_56->HrefValue = "";
            $this->m_56->TooltipValue = "";

            // 57
            $this->_57->HrefValue = "";
            $this->_57->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_57->ViewValue = $this->highlightValue($this->_57);
            }

            // m_57
            $this->m_57->HrefValue = "";
            $this->m_57->TooltipValue = "";

            // 58
            $this->_58->HrefValue = "";
            $this->_58->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_58->ViewValue = $this->highlightValue($this->_58);
            }

            // m_58
            $this->m_58->HrefValue = "";
            $this->m_58->TooltipValue = "";

            // 59
            $this->_59->HrefValue = "";
            $this->_59->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_59->ViewValue = $this->highlightValue($this->_59);
            }

            // m_59
            $this->m_59->HrefValue = "";
            $this->m_59->TooltipValue = "";

            // 60
            $this->_60->HrefValue = "";
            $this->_60->TooltipValue = "";
            if (!$this->isExport()) {
                $this->_60->ViewValue = $this->highlightValue($this->_60);
            }

            // m_60
            $this->m_60->HrefValue = "";
            $this->m_60->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // roll_no
            $this->roll_no->setupEditAttributes();
            if (!$this->roll_no->Raw) {
                $this->roll_no->AdvancedSearch->SearchValue = HtmlDecode($this->roll_no->AdvancedSearch->SearchValue);
            }
            $this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

            // test_id
            $this->test_id->setupEditAttributes();
            if (!$this->test_id->Raw) {
                $this->test_id->AdvancedSearch->SearchValue = HtmlDecode($this->test_id->AdvancedSearch->SearchValue);
            }
            $this->test_id->EditValue = HtmlEncode($this->test_id->AdvancedSearch->SearchValue);
            $this->test_id->PlaceHolder = RemoveHtml($this->test_id->caption());

            // total
            $this->total->setupEditAttributes();
            $this->total->EditValue = $this->total->AdvancedSearch->SearchValue;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());
            $this->total->setupEditAttributes();
            $this->total->EditValue2 = $this->total->AdvancedSearch->SearchValue2;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());

            // percent
            $this->percent->setupEditAttributes();
            $this->percent->EditValue = $this->percent->AdvancedSearch->SearchValue;
            $this->percent->PlaceHolder = RemoveHtml($this->percent->caption());
            $this->percent->setupEditAttributes();
            $this->percent->EditValue2 = $this->percent->AdvancedSearch->SearchValue2;
            $this->percent->PlaceHolder = RemoveHtml($this->percent->caption());

            // s_1
            $this->s_1->setupEditAttributes();
            $this->s_1->EditValue = $this->s_1->AdvancedSearch->SearchValue;
            $this->s_1->PlaceHolder = RemoveHtml($this->s_1->caption());

            // s_2
            $this->s_2->setupEditAttributes();
            $this->s_2->EditValue = $this->s_2->AdvancedSearch->SearchValue;
            $this->s_2->PlaceHolder = RemoveHtml($this->s_2->caption());

            // s_3
            $this->s_3->setupEditAttributes();
            $this->s_3->EditValue = $this->s_3->AdvancedSearch->SearchValue;
            $this->s_3->PlaceHolder = RemoveHtml($this->s_3->caption());

            // s_4
            $this->s_4->setupEditAttributes();
            $this->s_4->EditValue = $this->s_4->AdvancedSearch->SearchValue;
            $this->s_4->PlaceHolder = RemoveHtml($this->s_4->caption());

            // s_5
            $this->s_5->setupEditAttributes();
            $this->s_5->EditValue = $this->s_5->AdvancedSearch->SearchValue;
            $this->s_5->PlaceHolder = RemoveHtml($this->s_5->caption());

            // omr_image
            $this->omr_image->setupEditAttributes();
            if (!$this->omr_image->Raw) {
                $this->omr_image->AdvancedSearch->SearchValue = HtmlDecode($this->omr_image->AdvancedSearch->SearchValue);
            }
            $this->omr_image->EditValue = HtmlEncode($this->omr_image->AdvancedSearch->SearchValue);
            $this->omr_image->PlaceHolder = RemoveHtml($this->omr_image->caption());

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // m_1
            $this->m_1->setupEditAttributes();
            $this->m_1->EditValue = $this->m_1->AdvancedSearch->SearchValue;
            $this->m_1->PlaceHolder = RemoveHtml($this->m_1->caption());

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // m_2
            $this->m_2->setupEditAttributes();
            $this->m_2->EditValue = $this->m_2->AdvancedSearch->SearchValue;
            $this->m_2->PlaceHolder = RemoveHtml($this->m_2->caption());

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->AdvancedSearch->SearchValue = HtmlDecode($this->_3->AdvancedSearch->SearchValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->AdvancedSearch->SearchValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // m_3
            $this->m_3->setupEditAttributes();
            $this->m_3->EditValue = $this->m_3->AdvancedSearch->SearchValue;
            $this->m_3->PlaceHolder = RemoveHtml($this->m_3->caption());

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->AdvancedSearch->SearchValue = HtmlDecode($this->_4->AdvancedSearch->SearchValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->AdvancedSearch->SearchValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // m_4
            $this->m_4->setupEditAttributes();
            $this->m_4->EditValue = $this->m_4->AdvancedSearch->SearchValue;
            $this->m_4->PlaceHolder = RemoveHtml($this->m_4->caption());

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->AdvancedSearch->SearchValue = HtmlDecode($this->_5->AdvancedSearch->SearchValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->AdvancedSearch->SearchValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // m_5
            $this->m_5->setupEditAttributes();
            $this->m_5->EditValue = $this->m_5->AdvancedSearch->SearchValue;
            $this->m_5->PlaceHolder = RemoveHtml($this->m_5->caption());

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->AdvancedSearch->SearchValue = HtmlDecode($this->_6->AdvancedSearch->SearchValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->AdvancedSearch->SearchValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // m_6
            $this->m_6->setupEditAttributes();
            $this->m_6->EditValue = $this->m_6->AdvancedSearch->SearchValue;
            $this->m_6->PlaceHolder = RemoveHtml($this->m_6->caption());

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->AdvancedSearch->SearchValue = HtmlDecode($this->_7->AdvancedSearch->SearchValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->AdvancedSearch->SearchValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // m_7
            $this->m_7->setupEditAttributes();
            $this->m_7->EditValue = $this->m_7->AdvancedSearch->SearchValue;
            $this->m_7->PlaceHolder = RemoveHtml($this->m_7->caption());

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->AdvancedSearch->SearchValue = HtmlDecode($this->_8->AdvancedSearch->SearchValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->AdvancedSearch->SearchValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // m_8
            $this->m_8->setupEditAttributes();
            $this->m_8->EditValue = $this->m_8->AdvancedSearch->SearchValue;
            $this->m_8->PlaceHolder = RemoveHtml($this->m_8->caption());

            // 9
            $this->_9->setupEditAttributes();
            if (!$this->_9->Raw) {
                $this->_9->AdvancedSearch->SearchValue = HtmlDecode($this->_9->AdvancedSearch->SearchValue);
            }
            $this->_9->EditValue = HtmlEncode($this->_9->AdvancedSearch->SearchValue);
            $this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

            // m_9
            $this->m_9->setupEditAttributes();
            $this->m_9->EditValue = $this->m_9->AdvancedSearch->SearchValue;
            $this->m_9->PlaceHolder = RemoveHtml($this->m_9->caption());

            // 10
            $this->_10->setupEditAttributes();
            if (!$this->_10->Raw) {
                $this->_10->AdvancedSearch->SearchValue = HtmlDecode($this->_10->AdvancedSearch->SearchValue);
            }
            $this->_10->EditValue = HtmlEncode($this->_10->AdvancedSearch->SearchValue);
            $this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

            // m_10
            $this->m_10->setupEditAttributes();
            $this->m_10->EditValue = $this->m_10->AdvancedSearch->SearchValue;
            $this->m_10->PlaceHolder = RemoveHtml($this->m_10->caption());

            // 11
            $this->_11->setupEditAttributes();
            if (!$this->_11->Raw) {
                $this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
            }
            $this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
            $this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

            // m_11
            $this->m_11->setupEditAttributes();
            $this->m_11->EditValue = $this->m_11->AdvancedSearch->SearchValue;
            $this->m_11->PlaceHolder = RemoveHtml($this->m_11->caption());

            // 12
            $this->_12->setupEditAttributes();
            if (!$this->_12->Raw) {
                $this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
            }
            $this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
            $this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

            // m_12
            $this->m_12->setupEditAttributes();
            $this->m_12->EditValue = $this->m_12->AdvancedSearch->SearchValue;
            $this->m_12->PlaceHolder = RemoveHtml($this->m_12->caption());

            // 13
            $this->_13->setupEditAttributes();
            if (!$this->_13->Raw) {
                $this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
            }
            $this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
            $this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

            // m_13
            $this->m_13->setupEditAttributes();
            $this->m_13->EditValue = $this->m_13->AdvancedSearch->SearchValue;
            $this->m_13->PlaceHolder = RemoveHtml($this->m_13->caption());

            // 14
            $this->_14->setupEditAttributes();
            if (!$this->_14->Raw) {
                $this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
            }
            $this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
            $this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

            // m_14
            $this->m_14->setupEditAttributes();
            $this->m_14->EditValue = $this->m_14->AdvancedSearch->SearchValue;
            $this->m_14->PlaceHolder = RemoveHtml($this->m_14->caption());

            // 15
            $this->_15->setupEditAttributes();
            if (!$this->_15->Raw) {
                $this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
            }
            $this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
            $this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

            // m_15
            $this->m_15->setupEditAttributes();
            $this->m_15->EditValue = $this->m_15->AdvancedSearch->SearchValue;
            $this->m_15->PlaceHolder = RemoveHtml($this->m_15->caption());

            // 16
            $this->_16->setupEditAttributes();
            if (!$this->_16->Raw) {
                $this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
            }
            $this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
            $this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

            // m_16
            $this->m_16->setupEditAttributes();
            $this->m_16->EditValue = $this->m_16->AdvancedSearch->SearchValue;
            $this->m_16->PlaceHolder = RemoveHtml($this->m_16->caption());

            // 17
            $this->_17->setupEditAttributes();
            if (!$this->_17->Raw) {
                $this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
            }
            $this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
            $this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

            // m_17
            $this->m_17->setupEditAttributes();
            $this->m_17->EditValue = $this->m_17->AdvancedSearch->SearchValue;
            $this->m_17->PlaceHolder = RemoveHtml($this->m_17->caption());

            // 18
            $this->_18->setupEditAttributes();
            if (!$this->_18->Raw) {
                $this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
            }
            $this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
            $this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

            // m_18
            $this->m_18->setupEditAttributes();
            $this->m_18->EditValue = $this->m_18->AdvancedSearch->SearchValue;
            $this->m_18->PlaceHolder = RemoveHtml($this->m_18->caption());

            // 19
            $this->_19->setupEditAttributes();
            if (!$this->_19->Raw) {
                $this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
            }
            $this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
            $this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

            // m_19
            $this->m_19->setupEditAttributes();
            $this->m_19->EditValue = $this->m_19->AdvancedSearch->SearchValue;
            $this->m_19->PlaceHolder = RemoveHtml($this->m_19->caption());

            // 20
            $this->_20->setupEditAttributes();
            if (!$this->_20->Raw) {
                $this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
            }
            $this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
            $this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

            // m_20
            $this->m_20->setupEditAttributes();
            $this->m_20->EditValue = $this->m_20->AdvancedSearch->SearchValue;
            $this->m_20->PlaceHolder = RemoveHtml($this->m_20->caption());

            // 21
            $this->_21->setupEditAttributes();
            if (!$this->_21->Raw) {
                $this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
            }
            $this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
            $this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

            // m_21
            $this->m_21->setupEditAttributes();
            $this->m_21->EditValue = $this->m_21->AdvancedSearch->SearchValue;
            $this->m_21->PlaceHolder = RemoveHtml($this->m_21->caption());

            // 22
            $this->_22->setupEditAttributes();
            if (!$this->_22->Raw) {
                $this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
            }
            $this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
            $this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

            // m_22
            $this->m_22->setupEditAttributes();
            $this->m_22->EditValue = $this->m_22->AdvancedSearch->SearchValue;
            $this->m_22->PlaceHolder = RemoveHtml($this->m_22->caption());

            // 23
            $this->_23->setupEditAttributes();
            if (!$this->_23->Raw) {
                $this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
            }
            $this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
            $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

            // m_23
            $this->m_23->setupEditAttributes();
            $this->m_23->EditValue = $this->m_23->AdvancedSearch->SearchValue;
            $this->m_23->PlaceHolder = RemoveHtml($this->m_23->caption());

            // 24
            $this->_24->setupEditAttributes();
            if (!$this->_24->Raw) {
                $this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
            }
            $this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
            $this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

            // m_24
            $this->m_24->setupEditAttributes();
            $this->m_24->EditValue = $this->m_24->AdvancedSearch->SearchValue;
            $this->m_24->PlaceHolder = RemoveHtml($this->m_24->caption());

            // 25
            $this->_25->setupEditAttributes();
            if (!$this->_25->Raw) {
                $this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
            }
            $this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
            $this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

            // m_25
            $this->m_25->setupEditAttributes();
            $this->m_25->EditValue = $this->m_25->AdvancedSearch->SearchValue;
            $this->m_25->PlaceHolder = RemoveHtml($this->m_25->caption());

            // 26
            $this->_26->setupEditAttributes();
            if (!$this->_26->Raw) {
                $this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
            }
            $this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
            $this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

            // m_26
            $this->m_26->setupEditAttributes();
            $this->m_26->EditValue = $this->m_26->AdvancedSearch->SearchValue;
            $this->m_26->PlaceHolder = RemoveHtml($this->m_26->caption());

            // 27
            $this->_27->setupEditAttributes();
            if (!$this->_27->Raw) {
                $this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
            }
            $this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
            $this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

            // m_27
            $this->m_27->setupEditAttributes();
            $this->m_27->EditValue = $this->m_27->AdvancedSearch->SearchValue;
            $this->m_27->PlaceHolder = RemoveHtml($this->m_27->caption());

            // 28
            $this->_28->setupEditAttributes();
            if (!$this->_28->Raw) {
                $this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
            }
            $this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
            $this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

            // m_28
            $this->m_28->setupEditAttributes();
            $this->m_28->EditValue = $this->m_28->AdvancedSearch->SearchValue;
            $this->m_28->PlaceHolder = RemoveHtml($this->m_28->caption());

            // 29
            $this->_29->setupEditAttributes();
            if (!$this->_29->Raw) {
                $this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
            }
            $this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
            $this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

            // m_29
            $this->m_29->setupEditAttributes();
            $this->m_29->EditValue = $this->m_29->AdvancedSearch->SearchValue;
            $this->m_29->PlaceHolder = RemoveHtml($this->m_29->caption());

            // 30
            $this->_30->setupEditAttributes();
            if (!$this->_30->Raw) {
                $this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
            }
            $this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
            $this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

            // m_30
            $this->m_30->setupEditAttributes();
            $this->m_30->EditValue = $this->m_30->AdvancedSearch->SearchValue;
            $this->m_30->PlaceHolder = RemoveHtml($this->m_30->caption());

            // 31
            $this->_31->setupEditAttributes();
            if (!$this->_31->Raw) {
                $this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
            }
            $this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
            $this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

            // m_31
            $this->m_31->setupEditAttributes();
            $this->m_31->EditValue = $this->m_31->AdvancedSearch->SearchValue;
            $this->m_31->PlaceHolder = RemoveHtml($this->m_31->caption());

            // 32
            $this->_32->setupEditAttributes();
            if (!$this->_32->Raw) {
                $this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
            }
            $this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
            $this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

            // m_32
            $this->m_32->setupEditAttributes();
            $this->m_32->EditValue = $this->m_32->AdvancedSearch->SearchValue;
            $this->m_32->PlaceHolder = RemoveHtml($this->m_32->caption());

            // 33
            $this->_33->setupEditAttributes();
            if (!$this->_33->Raw) {
                $this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
            }
            $this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
            $this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

            // m_33
            $this->m_33->setupEditAttributes();
            $this->m_33->EditValue = $this->m_33->AdvancedSearch->SearchValue;
            $this->m_33->PlaceHolder = RemoveHtml($this->m_33->caption());

            // 34
            $this->_34->setupEditAttributes();
            if (!$this->_34->Raw) {
                $this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
            }
            $this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
            $this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

            // m_34
            $this->m_34->setupEditAttributes();
            $this->m_34->EditValue = $this->m_34->AdvancedSearch->SearchValue;
            $this->m_34->PlaceHolder = RemoveHtml($this->m_34->caption());

            // 35
            $this->_35->setupEditAttributes();
            if (!$this->_35->Raw) {
                $this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
            }
            $this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
            $this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

            // m_35
            $this->m_35->setupEditAttributes();
            $this->m_35->EditValue = $this->m_35->AdvancedSearch->SearchValue;
            $this->m_35->PlaceHolder = RemoveHtml($this->m_35->caption());

            // 36
            $this->_36->setupEditAttributes();
            if (!$this->_36->Raw) {
                $this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
            }
            $this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
            $this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

            // m_36
            $this->m_36->setupEditAttributes();
            $this->m_36->EditValue = $this->m_36->AdvancedSearch->SearchValue;
            $this->m_36->PlaceHolder = RemoveHtml($this->m_36->caption());

            // 37
            $this->_37->setupEditAttributes();
            if (!$this->_37->Raw) {
                $this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
            }
            $this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
            $this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

            // m_37
            $this->m_37->setupEditAttributes();
            $this->m_37->EditValue = $this->m_37->AdvancedSearch->SearchValue;
            $this->m_37->PlaceHolder = RemoveHtml($this->m_37->caption());

            // 38
            $this->_38->setupEditAttributes();
            if (!$this->_38->Raw) {
                $this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
            }
            $this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
            $this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

            // m_38
            $this->m_38->setupEditAttributes();
            $this->m_38->EditValue = $this->m_38->AdvancedSearch->SearchValue;
            $this->m_38->PlaceHolder = RemoveHtml($this->m_38->caption());

            // 39
            $this->_39->setupEditAttributes();
            if (!$this->_39->Raw) {
                $this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
            }
            $this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
            $this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

            // m_39
            $this->m_39->setupEditAttributes();
            $this->m_39->EditValue = $this->m_39->AdvancedSearch->SearchValue;
            $this->m_39->PlaceHolder = RemoveHtml($this->m_39->caption());

            // 40
            $this->_40->setupEditAttributes();
            if (!$this->_40->Raw) {
                $this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
            }
            $this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // m_40
            $this->m_40->setupEditAttributes();
            $this->m_40->EditValue = $this->m_40->AdvancedSearch->SearchValue;
            $this->m_40->PlaceHolder = RemoveHtml($this->m_40->caption());

            // 41
            $this->_41->setupEditAttributes();
            if (!$this->_41->Raw) {
                $this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
            }
            $this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
            $this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

            // m_41
            $this->m_41->setupEditAttributes();
            $this->m_41->EditValue = $this->m_41->AdvancedSearch->SearchValue;
            $this->m_41->PlaceHolder = RemoveHtml($this->m_41->caption());

            // 42
            $this->_42->setupEditAttributes();
            if (!$this->_42->Raw) {
                $this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
            }
            $this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
            $this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

            // m_42
            $this->m_42->setupEditAttributes();
            $this->m_42->EditValue = $this->m_42->AdvancedSearch->SearchValue;
            $this->m_42->PlaceHolder = RemoveHtml($this->m_42->caption());

            // 43
            $this->_43->setupEditAttributes();
            if (!$this->_43->Raw) {
                $this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
            }
            $this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
            $this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

            // m_43
            $this->m_43->setupEditAttributes();
            $this->m_43->EditValue = $this->m_43->AdvancedSearch->SearchValue;
            $this->m_43->PlaceHolder = RemoveHtml($this->m_43->caption());

            // 44
            $this->_44->setupEditAttributes();
            if (!$this->_44->Raw) {
                $this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
            }
            $this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
            $this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

            // m_44
            $this->m_44->setupEditAttributes();
            $this->m_44->EditValue = $this->m_44->AdvancedSearch->SearchValue;
            $this->m_44->PlaceHolder = RemoveHtml($this->m_44->caption());

            // 45
            $this->_45->setupEditAttributes();
            if (!$this->_45->Raw) {
                $this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
            }
            $this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
            $this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

            // m_45
            $this->m_45->setupEditAttributes();
            $this->m_45->EditValue = $this->m_45->AdvancedSearch->SearchValue;
            $this->m_45->PlaceHolder = RemoveHtml($this->m_45->caption());

            // 46
            $this->_46->setupEditAttributes();
            if (!$this->_46->Raw) {
                $this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
            }
            $this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
            $this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

            // m_46
            $this->m_46->setupEditAttributes();
            $this->m_46->EditValue = $this->m_46->AdvancedSearch->SearchValue;
            $this->m_46->PlaceHolder = RemoveHtml($this->m_46->caption());

            // 47
            $this->_47->setupEditAttributes();
            if (!$this->_47->Raw) {
                $this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
            }
            $this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
            $this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

            // m_47
            $this->m_47->setupEditAttributes();
            $this->m_47->EditValue = $this->m_47->AdvancedSearch->SearchValue;
            $this->m_47->PlaceHolder = RemoveHtml($this->m_47->caption());

            // 48
            $this->_48->setupEditAttributes();
            if (!$this->_48->Raw) {
                $this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
            }
            $this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
            $this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

            // m_48
            $this->m_48->setupEditAttributes();
            $this->m_48->EditValue = $this->m_48->AdvancedSearch->SearchValue;
            $this->m_48->PlaceHolder = RemoveHtml($this->m_48->caption());

            // 49
            $this->_49->setupEditAttributes();
            if (!$this->_49->Raw) {
                $this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
            }
            $this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
            $this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

            // m_49
            $this->m_49->setupEditAttributes();
            $this->m_49->EditValue = $this->m_49->AdvancedSearch->SearchValue;
            $this->m_49->PlaceHolder = RemoveHtml($this->m_49->caption());

            // 50
            $this->_50->setupEditAttributes();
            if (!$this->_50->Raw) {
                $this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
            }
            $this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
            $this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

            // m_50
            $this->m_50->setupEditAttributes();
            $this->m_50->EditValue = $this->m_50->AdvancedSearch->SearchValue;
            $this->m_50->PlaceHolder = RemoveHtml($this->m_50->caption());

            // 51
            $this->_51->setupEditAttributes();
            if (!$this->_51->Raw) {
                $this->_51->AdvancedSearch->SearchValue = HtmlDecode($this->_51->AdvancedSearch->SearchValue);
            }
            $this->_51->EditValue = HtmlEncode($this->_51->AdvancedSearch->SearchValue);
            $this->_51->PlaceHolder = RemoveHtml($this->_51->caption());

            // m_51
            $this->m_51->setupEditAttributes();
            $this->m_51->EditValue = $this->m_51->AdvancedSearch->SearchValue;
            $this->m_51->PlaceHolder = RemoveHtml($this->m_51->caption());

            // 52
            $this->_52->setupEditAttributes();
            if (!$this->_52->Raw) {
                $this->_52->AdvancedSearch->SearchValue = HtmlDecode($this->_52->AdvancedSearch->SearchValue);
            }
            $this->_52->EditValue = HtmlEncode($this->_52->AdvancedSearch->SearchValue);
            $this->_52->PlaceHolder = RemoveHtml($this->_52->caption());

            // m_52
            $this->m_52->setupEditAttributes();
            $this->m_52->EditValue = $this->m_52->AdvancedSearch->SearchValue;
            $this->m_52->PlaceHolder = RemoveHtml($this->m_52->caption());

            // 53
            $this->_53->setupEditAttributes();
            if (!$this->_53->Raw) {
                $this->_53->AdvancedSearch->SearchValue = HtmlDecode($this->_53->AdvancedSearch->SearchValue);
            }
            $this->_53->EditValue = HtmlEncode($this->_53->AdvancedSearch->SearchValue);
            $this->_53->PlaceHolder = RemoveHtml($this->_53->caption());

            // m_53
            $this->m_53->setupEditAttributes();
            $this->m_53->EditValue = $this->m_53->AdvancedSearch->SearchValue;
            $this->m_53->PlaceHolder = RemoveHtml($this->m_53->caption());

            // 54
            $this->_54->setupEditAttributes();
            if (!$this->_54->Raw) {
                $this->_54->AdvancedSearch->SearchValue = HtmlDecode($this->_54->AdvancedSearch->SearchValue);
            }
            $this->_54->EditValue = HtmlEncode($this->_54->AdvancedSearch->SearchValue);
            $this->_54->PlaceHolder = RemoveHtml($this->_54->caption());

            // m_54
            $this->m_54->setupEditAttributes();
            $this->m_54->EditValue = $this->m_54->AdvancedSearch->SearchValue;
            $this->m_54->PlaceHolder = RemoveHtml($this->m_54->caption());

            // 55
            $this->_55->setupEditAttributes();
            if (!$this->_55->Raw) {
                $this->_55->AdvancedSearch->SearchValue = HtmlDecode($this->_55->AdvancedSearch->SearchValue);
            }
            $this->_55->EditValue = HtmlEncode($this->_55->AdvancedSearch->SearchValue);
            $this->_55->PlaceHolder = RemoveHtml($this->_55->caption());

            // m_55
            $this->m_55->setupEditAttributes();
            $this->m_55->EditValue = $this->m_55->AdvancedSearch->SearchValue;
            $this->m_55->PlaceHolder = RemoveHtml($this->m_55->caption());

            // 56
            $this->_56->setupEditAttributes();
            if (!$this->_56->Raw) {
                $this->_56->AdvancedSearch->SearchValue = HtmlDecode($this->_56->AdvancedSearch->SearchValue);
            }
            $this->_56->EditValue = HtmlEncode($this->_56->AdvancedSearch->SearchValue);
            $this->_56->PlaceHolder = RemoveHtml($this->_56->caption());

            // m_56
            $this->m_56->setupEditAttributes();
            $this->m_56->EditValue = $this->m_56->AdvancedSearch->SearchValue;
            $this->m_56->PlaceHolder = RemoveHtml($this->m_56->caption());

            // 57
            $this->_57->setupEditAttributes();
            if (!$this->_57->Raw) {
                $this->_57->AdvancedSearch->SearchValue = HtmlDecode($this->_57->AdvancedSearch->SearchValue);
            }
            $this->_57->EditValue = HtmlEncode($this->_57->AdvancedSearch->SearchValue);
            $this->_57->PlaceHolder = RemoveHtml($this->_57->caption());

            // m_57
            $this->m_57->setupEditAttributes();
            $this->m_57->EditValue = $this->m_57->AdvancedSearch->SearchValue;
            $this->m_57->PlaceHolder = RemoveHtml($this->m_57->caption());

            // 58
            $this->_58->setupEditAttributes();
            if (!$this->_58->Raw) {
                $this->_58->AdvancedSearch->SearchValue = HtmlDecode($this->_58->AdvancedSearch->SearchValue);
            }
            $this->_58->EditValue = HtmlEncode($this->_58->AdvancedSearch->SearchValue);
            $this->_58->PlaceHolder = RemoveHtml($this->_58->caption());

            // m_58
            $this->m_58->setupEditAttributes();
            $this->m_58->EditValue = $this->m_58->AdvancedSearch->SearchValue;
            $this->m_58->PlaceHolder = RemoveHtml($this->m_58->caption());

            // 59
            $this->_59->setupEditAttributes();
            if (!$this->_59->Raw) {
                $this->_59->AdvancedSearch->SearchValue = HtmlDecode($this->_59->AdvancedSearch->SearchValue);
            }
            $this->_59->EditValue = HtmlEncode($this->_59->AdvancedSearch->SearchValue);
            $this->_59->PlaceHolder = RemoveHtml($this->_59->caption());

            // m_59
            $this->m_59->setupEditAttributes();
            $this->m_59->EditValue = $this->m_59->AdvancedSearch->SearchValue;
            $this->m_59->PlaceHolder = RemoveHtml($this->m_59->caption());

            // 60
            $this->_60->setupEditAttributes();
            if (!$this->_60->Raw) {
                $this->_60->AdvancedSearch->SearchValue = HtmlDecode($this->_60->AdvancedSearch->SearchValue);
            }
            $this->_60->EditValue = HtmlEncode($this->_60->AdvancedSearch->SearchValue);
            $this->_60->PlaceHolder = RemoveHtml($this->_60->caption());

            // m_60
            $this->m_60->setupEditAttributes();
            $this->m_60->EditValue = $this->m_60->AdvancedSearch->SearchValue;
            $this->m_60->PlaceHolder = RemoveHtml($this->m_60->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->roll_no->AdvancedSearch->load();
        $this->test_id->AdvancedSearch->load();
        $this->total->AdvancedSearch->load();
        $this->percent->AdvancedSearch->load();
        $this->s_1->AdvancedSearch->load();
        $this->s_2->AdvancedSearch->load();
        $this->s_3->AdvancedSearch->load();
        $this->s_4->AdvancedSearch->load();
        $this->s_5->AdvancedSearch->load();
        $this->omr_image->AdvancedSearch->load();
        $this->_1->AdvancedSearch->load();
        $this->m_1->AdvancedSearch->load();
        $this->_2->AdvancedSearch->load();
        $this->m_2->AdvancedSearch->load();
        $this->_3->AdvancedSearch->load();
        $this->m_3->AdvancedSearch->load();
        $this->_4->AdvancedSearch->load();
        $this->m_4->AdvancedSearch->load();
        $this->_5->AdvancedSearch->load();
        $this->m_5->AdvancedSearch->load();
        $this->_6->AdvancedSearch->load();
        $this->m_6->AdvancedSearch->load();
        $this->_7->AdvancedSearch->load();
        $this->m_7->AdvancedSearch->load();
        $this->_8->AdvancedSearch->load();
        $this->m_8->AdvancedSearch->load();
        $this->_9->AdvancedSearch->load();
        $this->m_9->AdvancedSearch->load();
        $this->_10->AdvancedSearch->load();
        $this->m_10->AdvancedSearch->load();
        $this->_11->AdvancedSearch->load();
        $this->m_11->AdvancedSearch->load();
        $this->_12->AdvancedSearch->load();
        $this->m_12->AdvancedSearch->load();
        $this->_13->AdvancedSearch->load();
        $this->m_13->AdvancedSearch->load();
        $this->_14->AdvancedSearch->load();
        $this->m_14->AdvancedSearch->load();
        $this->_15->AdvancedSearch->load();
        $this->m_15->AdvancedSearch->load();
        $this->_16->AdvancedSearch->load();
        $this->m_16->AdvancedSearch->load();
        $this->_17->AdvancedSearch->load();
        $this->m_17->AdvancedSearch->load();
        $this->_18->AdvancedSearch->load();
        $this->m_18->AdvancedSearch->load();
        $this->_19->AdvancedSearch->load();
        $this->m_19->AdvancedSearch->load();
        $this->_20->AdvancedSearch->load();
        $this->m_20->AdvancedSearch->load();
        $this->_21->AdvancedSearch->load();
        $this->m_21->AdvancedSearch->load();
        $this->_22->AdvancedSearch->load();
        $this->m_22->AdvancedSearch->load();
        $this->_23->AdvancedSearch->load();
        $this->m_23->AdvancedSearch->load();
        $this->_24->AdvancedSearch->load();
        $this->m_24->AdvancedSearch->load();
        $this->_25->AdvancedSearch->load();
        $this->m_25->AdvancedSearch->load();
        $this->_26->AdvancedSearch->load();
        $this->m_26->AdvancedSearch->load();
        $this->_27->AdvancedSearch->load();
        $this->m_27->AdvancedSearch->load();
        $this->_28->AdvancedSearch->load();
        $this->m_28->AdvancedSearch->load();
        $this->_29->AdvancedSearch->load();
        $this->m_29->AdvancedSearch->load();
        $this->_30->AdvancedSearch->load();
        $this->m_30->AdvancedSearch->load();
        $this->_31->AdvancedSearch->load();
        $this->m_31->AdvancedSearch->load();
        $this->_32->AdvancedSearch->load();
        $this->m_32->AdvancedSearch->load();
        $this->_33->AdvancedSearch->load();
        $this->m_33->AdvancedSearch->load();
        $this->_34->AdvancedSearch->load();
        $this->m_34->AdvancedSearch->load();
        $this->_35->AdvancedSearch->load();
        $this->m_35->AdvancedSearch->load();
        $this->_36->AdvancedSearch->load();
        $this->m_36->AdvancedSearch->load();
        $this->_37->AdvancedSearch->load();
        $this->m_37->AdvancedSearch->load();
        $this->_38->AdvancedSearch->load();
        $this->m_38->AdvancedSearch->load();
        $this->_39->AdvancedSearch->load();
        $this->m_39->AdvancedSearch->load();
        $this->_40->AdvancedSearch->load();
        $this->m_40->AdvancedSearch->load();
        $this->_41->AdvancedSearch->load();
        $this->m_41->AdvancedSearch->load();
        $this->_42->AdvancedSearch->load();
        $this->m_42->AdvancedSearch->load();
        $this->_43->AdvancedSearch->load();
        $this->m_43->AdvancedSearch->load();
        $this->_44->AdvancedSearch->load();
        $this->m_44->AdvancedSearch->load();
        $this->_45->AdvancedSearch->load();
        $this->m_45->AdvancedSearch->load();
        $this->_46->AdvancedSearch->load();
        $this->m_46->AdvancedSearch->load();
        $this->_47->AdvancedSearch->load();
        $this->m_47->AdvancedSearch->load();
        $this->_48->AdvancedSearch->load();
        $this->m_48->AdvancedSearch->load();
        $this->_49->AdvancedSearch->load();
        $this->m_49->AdvancedSearch->load();
        $this->_50->AdvancedSearch->load();
        $this->m_50->AdvancedSearch->load();
        $this->_51->AdvancedSearch->load();
        $this->m_51->AdvancedSearch->load();
        $this->_52->AdvancedSearch->load();
        $this->m_52->AdvancedSearch->load();
        $this->_53->AdvancedSearch->load();
        $this->m_53->AdvancedSearch->load();
        $this->_54->AdvancedSearch->load();
        $this->m_54->AdvancedSearch->load();
        $this->_55->AdvancedSearch->load();
        $this->m_55->AdvancedSearch->load();
        $this->_56->AdvancedSearch->load();
        $this->m_56->AdvancedSearch->load();
        $this->_57->AdvancedSearch->load();
        $this->m_57->AdvancedSearch->load();
        $this->_58->AdvancedSearch->load();
        $this->m_58->AdvancedSearch->load();
        $this->_59->AdvancedSearch->load();
        $this->m_59->AdvancedSearch->load();
        $this->_60->AdvancedSearch->load();
        $this->m_60->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fs_omr_valuelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fs_omr_valuelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fs_omr_valuelist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fs_omr_valuelist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fs_omr_valuesrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"s_omr_value\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"somrvaluesearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"somrvaluesearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Search highlight button
        $item = &$this->SearchOptions->add("searchhighlight");
        $item->Body = "<a class=\"btn btn-default ew-highlight active\" role=\"button\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-ew-action=\"highlight\" data-form=\"fs_omr_valuesrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</a>";
        $item->Visible = ($this->SearchWhere != "" && $this->TotalRecords > 0);

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
