<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SOmrValueDelete extends SOmrValue
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SOmrValueDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "somrvaluedelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->roll_no->setVisibility();
        $this->test_id->setVisibility();
        $this->total->setVisibility();
        $this->percent->setVisibility();
        $this->s_1->setVisibility();
        $this->s_2->setVisibility();
        $this->s_3->setVisibility();
        $this->s_4->setVisibility();
        $this->s_5->setVisibility();
        $this->omr_image->setVisibility();
        $this->_1->setVisibility();
        $this->m_1->setVisibility();
        $this->_2->setVisibility();
        $this->m_2->setVisibility();
        $this->_3->setVisibility();
        $this->m_3->setVisibility();
        $this->_4->setVisibility();
        $this->m_4->setVisibility();
        $this->_5->setVisibility();
        $this->m_5->setVisibility();
        $this->_6->setVisibility();
        $this->m_6->setVisibility();
        $this->_7->setVisibility();
        $this->m_7->setVisibility();
        $this->_8->setVisibility();
        $this->m_8->setVisibility();
        $this->_9->setVisibility();
        $this->m_9->setVisibility();
        $this->_10->setVisibility();
        $this->m_10->setVisibility();
        $this->_11->setVisibility();
        $this->m_11->setVisibility();
        $this->_12->setVisibility();
        $this->m_12->setVisibility();
        $this->_13->setVisibility();
        $this->m_13->setVisibility();
        $this->_14->setVisibility();
        $this->m_14->setVisibility();
        $this->_15->setVisibility();
        $this->m_15->setVisibility();
        $this->_16->setVisibility();
        $this->m_16->setVisibility();
        $this->_17->setVisibility();
        $this->m_17->setVisibility();
        $this->_18->setVisibility();
        $this->m_18->setVisibility();
        $this->_19->setVisibility();
        $this->m_19->setVisibility();
        $this->_20->setVisibility();
        $this->m_20->setVisibility();
        $this->_21->setVisibility();
        $this->m_21->setVisibility();
        $this->_22->setVisibility();
        $this->m_22->setVisibility();
        $this->_23->setVisibility();
        $this->m_23->setVisibility();
        $this->_24->setVisibility();
        $this->m_24->setVisibility();
        $this->_25->setVisibility();
        $this->m_25->setVisibility();
        $this->_26->setVisibility();
        $this->m_26->setVisibility();
        $this->_27->setVisibility();
        $this->m_27->setVisibility();
        $this->_28->setVisibility();
        $this->m_28->setVisibility();
        $this->_29->setVisibility();
        $this->m_29->setVisibility();
        $this->_30->setVisibility();
        $this->m_30->setVisibility();
        $this->_31->setVisibility();
        $this->m_31->setVisibility();
        $this->_32->setVisibility();
        $this->m_32->setVisibility();
        $this->_33->setVisibility();
        $this->m_33->setVisibility();
        $this->_34->setVisibility();
        $this->m_34->setVisibility();
        $this->_35->setVisibility();
        $this->m_35->setVisibility();
        $this->_36->setVisibility();
        $this->m_36->setVisibility();
        $this->_37->setVisibility();
        $this->m_37->setVisibility();
        $this->_38->setVisibility();
        $this->m_38->setVisibility();
        $this->_39->setVisibility();
        $this->m_39->setVisibility();
        $this->_40->setVisibility();
        $this->m_40->setVisibility();
        $this->_41->setVisibility();
        $this->m_41->setVisibility();
        $this->_42->setVisibility();
        $this->m_42->setVisibility();
        $this->_43->setVisibility();
        $this->m_43->setVisibility();
        $this->_44->setVisibility();
        $this->m_44->setVisibility();
        $this->_45->setVisibility();
        $this->m_45->setVisibility();
        $this->_46->setVisibility();
        $this->m_46->setVisibility();
        $this->_47->setVisibility();
        $this->m_47->setVisibility();
        $this->_48->setVisibility();
        $this->m_48->setVisibility();
        $this->_49->setVisibility();
        $this->m_49->setVisibility();
        $this->_50->setVisibility();
        $this->m_50->setVisibility();
        $this->_51->setVisibility();
        $this->m_51->setVisibility();
        $this->_52->setVisibility();
        $this->m_52->setVisibility();
        $this->_53->setVisibility();
        $this->m_53->setVisibility();
        $this->_54->setVisibility();
        $this->m_54->setVisibility();
        $this->_55->setVisibility();
        $this->m_55->setVisibility();
        $this->_56->setVisibility();
        $this->m_56->setVisibility();
        $this->_57->setVisibility();
        $this->m_57->setVisibility();
        $this->_58->setVisibility();
        $this->m_58->setVisibility();
        $this->_59->setVisibility();
        $this->m_59->setVisibility();
        $this->_60->setVisibility();
        $this->m_60->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 's_omr_value';
        $this->TableName = 's_omr_value';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_omr_value)
        if (!isset($GLOBALS["s_omr_value"]) || $GLOBALS["s_omr_value"]::class == PROJECT_NAMESPACE . "s_omr_value") {
            $GLOBALS["s_omr_value"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->omr_image->OldUploadPath = $this->omr_image->getUploadPath(); // PHP
                $this->omr_image->UploadPath = $this->omr_image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("somrvaluelist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("somrvaluelist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->test_id->setDbValue($row['test_id']);
        $this->total->setDbValue($row['total']);
        $this->percent->setDbValue($row['percent']);
        $this->s_1->setDbValue($row['s_1']);
        $this->s_2->setDbValue($row['s_2']);
        $this->s_3->setDbValue($row['s_3']);
        $this->s_4->setDbValue($row['s_4']);
        $this->s_5->setDbValue($row['s_5']);
        $this->omr_image->Upload->DbValue = $row['omr_image'];
        $this->omr_image->setDbValue($this->omr_image->Upload->DbValue);
        $this->_1->setDbValue($row['1']);
        $this->m_1->setDbValue($row['m_1']);
        $this->_2->setDbValue($row['2']);
        $this->m_2->setDbValue($row['m_2']);
        $this->_3->setDbValue($row['3']);
        $this->m_3->setDbValue($row['m_3']);
        $this->_4->setDbValue($row['4']);
        $this->m_4->setDbValue($row['m_4']);
        $this->_5->setDbValue($row['5']);
        $this->m_5->setDbValue($row['m_5']);
        $this->_6->setDbValue($row['6']);
        $this->m_6->setDbValue($row['m_6']);
        $this->_7->setDbValue($row['7']);
        $this->m_7->setDbValue($row['m_7']);
        $this->_8->setDbValue($row['8']);
        $this->m_8->setDbValue($row['m_8']);
        $this->_9->setDbValue($row['9']);
        $this->m_9->setDbValue($row['m_9']);
        $this->_10->setDbValue($row['10']);
        $this->m_10->setDbValue($row['m_10']);
        $this->_11->setDbValue($row['11']);
        $this->m_11->setDbValue($row['m_11']);
        $this->_12->setDbValue($row['12']);
        $this->m_12->setDbValue($row['m_12']);
        $this->_13->setDbValue($row['13']);
        $this->m_13->setDbValue($row['m_13']);
        $this->_14->setDbValue($row['14']);
        $this->m_14->setDbValue($row['m_14']);
        $this->_15->setDbValue($row['15']);
        $this->m_15->setDbValue($row['m_15']);
        $this->_16->setDbValue($row['16']);
        $this->m_16->setDbValue($row['m_16']);
        $this->_17->setDbValue($row['17']);
        $this->m_17->setDbValue($row['m_17']);
        $this->_18->setDbValue($row['18']);
        $this->m_18->setDbValue($row['m_18']);
        $this->_19->setDbValue($row['19']);
        $this->m_19->setDbValue($row['m_19']);
        $this->_20->setDbValue($row['20']);
        $this->m_20->setDbValue($row['m_20']);
        $this->_21->setDbValue($row['21']);
        $this->m_21->setDbValue($row['m_21']);
        $this->_22->setDbValue($row['22']);
        $this->m_22->setDbValue($row['m_22']);
        $this->_23->setDbValue($row['23']);
        $this->m_23->setDbValue($row['m_23']);
        $this->_24->setDbValue($row['24']);
        $this->m_24->setDbValue($row['m_24']);
        $this->_25->setDbValue($row['25']);
        $this->m_25->setDbValue($row['m_25']);
        $this->_26->setDbValue($row['26']);
        $this->m_26->setDbValue($row['m_26']);
        $this->_27->setDbValue($row['27']);
        $this->m_27->setDbValue($row['m_27']);
        $this->_28->setDbValue($row['28']);
        $this->m_28->setDbValue($row['m_28']);
        $this->_29->setDbValue($row['29']);
        $this->m_29->setDbValue($row['m_29']);
        $this->_30->setDbValue($row['30']);
        $this->m_30->setDbValue($row['m_30']);
        $this->_31->setDbValue($row['31']);
        $this->m_31->setDbValue($row['m_31']);
        $this->_32->setDbValue($row['32']);
        $this->m_32->setDbValue($row['m_32']);
        $this->_33->setDbValue($row['33']);
        $this->m_33->setDbValue($row['m_33']);
        $this->_34->setDbValue($row['34']);
        $this->m_34->setDbValue($row['m_34']);
        $this->_35->setDbValue($row['35']);
        $this->m_35->setDbValue($row['m_35']);
        $this->_36->setDbValue($row['36']);
        $this->m_36->setDbValue($row['m_36']);
        $this->_37->setDbValue($row['37']);
        $this->m_37->setDbValue($row['m_37']);
        $this->_38->setDbValue($row['38']);
        $this->m_38->setDbValue($row['m_38']);
        $this->_39->setDbValue($row['39']);
        $this->m_39->setDbValue($row['m_39']);
        $this->_40->setDbValue($row['40']);
        $this->m_40->setDbValue($row['m_40']);
        $this->_41->setDbValue($row['41']);
        $this->m_41->setDbValue($row['m_41']);
        $this->_42->setDbValue($row['42']);
        $this->m_42->setDbValue($row['m_42']);
        $this->_43->setDbValue($row['43']);
        $this->m_43->setDbValue($row['m_43']);
        $this->_44->setDbValue($row['44']);
        $this->m_44->setDbValue($row['m_44']);
        $this->_45->setDbValue($row['45']);
        $this->m_45->setDbValue($row['m_45']);
        $this->_46->setDbValue($row['46']);
        $this->m_46->setDbValue($row['m_46']);
        $this->_47->setDbValue($row['47']);
        $this->m_47->setDbValue($row['m_47']);
        $this->_48->setDbValue($row['48']);
        $this->m_48->setDbValue($row['m_48']);
        $this->_49->setDbValue($row['49']);
        $this->m_49->setDbValue($row['m_49']);
        $this->_50->setDbValue($row['50']);
        $this->m_50->setDbValue($row['m_50']);
        $this->_51->setDbValue($row['51']);
        $this->m_51->setDbValue($row['m_51']);
        $this->_52->setDbValue($row['52']);
        $this->m_52->setDbValue($row['m_52']);
        $this->_53->setDbValue($row['53']);
        $this->m_53->setDbValue($row['m_53']);
        $this->_54->setDbValue($row['54']);
        $this->m_54->setDbValue($row['m_54']);
        $this->_55->setDbValue($row['55']);
        $this->m_55->setDbValue($row['m_55']);
        $this->_56->setDbValue($row['56']);
        $this->m_56->setDbValue($row['m_56']);
        $this->_57->setDbValue($row['57']);
        $this->m_57->setDbValue($row['m_57']);
        $this->_58->setDbValue($row['58']);
        $this->m_58->setDbValue($row['m_58']);
        $this->_59->setDbValue($row['59']);
        $this->m_59->setDbValue($row['m_59']);
        $this->_60->setDbValue($row['60']);
        $this->m_60->setDbValue($row['m_60']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['test_id'] = $this->test_id->DefaultValue;
        $row['total'] = $this->total->DefaultValue;
        $row['percent'] = $this->percent->DefaultValue;
        $row['s_1'] = $this->s_1->DefaultValue;
        $row['s_2'] = $this->s_2->DefaultValue;
        $row['s_3'] = $this->s_3->DefaultValue;
        $row['s_4'] = $this->s_4->DefaultValue;
        $row['s_5'] = $this->s_5->DefaultValue;
        $row['omr_image'] = $this->omr_image->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['m_1'] = $this->m_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['m_2'] = $this->m_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['m_3'] = $this->m_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['m_4'] = $this->m_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['m_5'] = $this->m_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['m_6'] = $this->m_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['m_7'] = $this->m_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['m_8'] = $this->m_8->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['m_9'] = $this->m_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['m_10'] = $this->m_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['m_11'] = $this->m_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['m_12'] = $this->m_12->DefaultValue;
        $row['13'] = $this->_13->DefaultValue;
        $row['m_13'] = $this->m_13->DefaultValue;
        $row['14'] = $this->_14->DefaultValue;
        $row['m_14'] = $this->m_14->DefaultValue;
        $row['15'] = $this->_15->DefaultValue;
        $row['m_15'] = $this->m_15->DefaultValue;
        $row['16'] = $this->_16->DefaultValue;
        $row['m_16'] = $this->m_16->DefaultValue;
        $row['17'] = $this->_17->DefaultValue;
        $row['m_17'] = $this->m_17->DefaultValue;
        $row['18'] = $this->_18->DefaultValue;
        $row['m_18'] = $this->m_18->DefaultValue;
        $row['19'] = $this->_19->DefaultValue;
        $row['m_19'] = $this->m_19->DefaultValue;
        $row['20'] = $this->_20->DefaultValue;
        $row['m_20'] = $this->m_20->DefaultValue;
        $row['21'] = $this->_21->DefaultValue;
        $row['m_21'] = $this->m_21->DefaultValue;
        $row['22'] = $this->_22->DefaultValue;
        $row['m_22'] = $this->m_22->DefaultValue;
        $row['23'] = $this->_23->DefaultValue;
        $row['m_23'] = $this->m_23->DefaultValue;
        $row['24'] = $this->_24->DefaultValue;
        $row['m_24'] = $this->m_24->DefaultValue;
        $row['25'] = $this->_25->DefaultValue;
        $row['m_25'] = $this->m_25->DefaultValue;
        $row['26'] = $this->_26->DefaultValue;
        $row['m_26'] = $this->m_26->DefaultValue;
        $row['27'] = $this->_27->DefaultValue;
        $row['m_27'] = $this->m_27->DefaultValue;
        $row['28'] = $this->_28->DefaultValue;
        $row['m_28'] = $this->m_28->DefaultValue;
        $row['29'] = $this->_29->DefaultValue;
        $row['m_29'] = $this->m_29->DefaultValue;
        $row['30'] = $this->_30->DefaultValue;
        $row['m_30'] = $this->m_30->DefaultValue;
        $row['31'] = $this->_31->DefaultValue;
        $row['m_31'] = $this->m_31->DefaultValue;
        $row['32'] = $this->_32->DefaultValue;
        $row['m_32'] = $this->m_32->DefaultValue;
        $row['33'] = $this->_33->DefaultValue;
        $row['m_33'] = $this->m_33->DefaultValue;
        $row['34'] = $this->_34->DefaultValue;
        $row['m_34'] = $this->m_34->DefaultValue;
        $row['35'] = $this->_35->DefaultValue;
        $row['m_35'] = $this->m_35->DefaultValue;
        $row['36'] = $this->_36->DefaultValue;
        $row['m_36'] = $this->m_36->DefaultValue;
        $row['37'] = $this->_37->DefaultValue;
        $row['m_37'] = $this->m_37->DefaultValue;
        $row['38'] = $this->_38->DefaultValue;
        $row['m_38'] = $this->m_38->DefaultValue;
        $row['39'] = $this->_39->DefaultValue;
        $row['m_39'] = $this->m_39->DefaultValue;
        $row['40'] = $this->_40->DefaultValue;
        $row['m_40'] = $this->m_40->DefaultValue;
        $row['41'] = $this->_41->DefaultValue;
        $row['m_41'] = $this->m_41->DefaultValue;
        $row['42'] = $this->_42->DefaultValue;
        $row['m_42'] = $this->m_42->DefaultValue;
        $row['43'] = $this->_43->DefaultValue;
        $row['m_43'] = $this->m_43->DefaultValue;
        $row['44'] = $this->_44->DefaultValue;
        $row['m_44'] = $this->m_44->DefaultValue;
        $row['45'] = $this->_45->DefaultValue;
        $row['m_45'] = $this->m_45->DefaultValue;
        $row['46'] = $this->_46->DefaultValue;
        $row['m_46'] = $this->m_46->DefaultValue;
        $row['47'] = $this->_47->DefaultValue;
        $row['m_47'] = $this->m_47->DefaultValue;
        $row['48'] = $this->_48->DefaultValue;
        $row['m_48'] = $this->m_48->DefaultValue;
        $row['49'] = $this->_49->DefaultValue;
        $row['m_49'] = $this->m_49->DefaultValue;
        $row['50'] = $this->_50->DefaultValue;
        $row['m_50'] = $this->m_50->DefaultValue;
        $row['51'] = $this->_51->DefaultValue;
        $row['m_51'] = $this->m_51->DefaultValue;
        $row['52'] = $this->_52->DefaultValue;
        $row['m_52'] = $this->m_52->DefaultValue;
        $row['53'] = $this->_53->DefaultValue;
        $row['m_53'] = $this->m_53->DefaultValue;
        $row['54'] = $this->_54->DefaultValue;
        $row['m_54'] = $this->m_54->DefaultValue;
        $row['55'] = $this->_55->DefaultValue;
        $row['m_55'] = $this->m_55->DefaultValue;
        $row['56'] = $this->_56->DefaultValue;
        $row['m_56'] = $this->m_56->DefaultValue;
        $row['57'] = $this->_57->DefaultValue;
        $row['m_57'] = $this->m_57->DefaultValue;
        $row['58'] = $this->_58->DefaultValue;
        $row['m_58'] = $this->m_58->DefaultValue;
        $row['59'] = $this->_59->DefaultValue;
        $row['m_59'] = $this->m_59->DefaultValue;
        $row['60'] = $this->_60->DefaultValue;
        $row['m_60'] = $this->m_60->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // roll_no

        // test_id

        // total

        // percent

        // s_1

        // s_2

        // s_3

        // s_4

        // s_5

        // omr_image

        // 1

        // m_1

        // 2

        // m_2

        // 3

        // m_3

        // 4

        // m_4

        // 5

        // m_5

        // 6

        // m_6

        // 7

        // m_7

        // 8

        // m_8

        // 9

        // m_9

        // 10

        // m_10

        // 11

        // m_11

        // 12

        // m_12

        // 13

        // m_13

        // 14

        // m_14

        // 15

        // m_15

        // 16

        // m_16

        // 17

        // m_17

        // 18

        // m_18

        // 19

        // m_19

        // 20

        // m_20

        // 21

        // m_21

        // 22

        // m_22

        // 23

        // m_23

        // 24

        // m_24

        // 25

        // m_25

        // 26

        // m_26

        // 27

        // m_27

        // 28

        // m_28

        // 29

        // m_29

        // 30

        // m_30

        // 31

        // m_31

        // 32

        // m_32

        // 33

        // m_33

        // 34

        // m_34

        // 35

        // m_35

        // 36

        // m_36

        // 37

        // m_37

        // 38

        // m_38

        // 39

        // m_39

        // 40

        // m_40

        // 41

        // m_41

        // 42

        // m_42

        // 43

        // m_43

        // 44

        // m_44

        // 45

        // m_45

        // 46

        // m_46

        // 47

        // m_47

        // 48

        // m_48

        // 49

        // m_49

        // 50

        // m_50

        // 51

        // m_51

        // 52

        // m_52

        // 53

        // m_53

        // 54

        // m_54

        // 55

        // m_55

        // 56

        // m_56

        // 57

        // m_57

        // 58

        // m_58

        // 59

        // m_59

        // 60

        // m_60

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;

            // test_id
            $this->test_id->ViewValue = $this->test_id->CurrentValue;

            // total
            $this->total->ViewValue = $this->total->CurrentValue;
            $this->total->ViewValue = FormatNumber($this->total->ViewValue, $this->total->formatPattern());

            // percent
            $this->percent->ViewValue = $this->percent->CurrentValue;
            $this->percent->ViewValue = FormatNumber($this->percent->ViewValue, $this->percent->formatPattern());

            // s_1
            $this->s_1->ViewValue = $this->s_1->CurrentValue;
            $this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, $this->s_1->formatPattern());

            // s_2
            $this->s_2->ViewValue = $this->s_2->CurrentValue;
            $this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, $this->s_2->formatPattern());

            // s_3
            $this->s_3->ViewValue = $this->s_3->CurrentValue;
            $this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, $this->s_3->formatPattern());

            // s_4
            $this->s_4->ViewValue = $this->s_4->CurrentValue;
            $this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, $this->s_4->formatPattern());

            // s_5
            $this->s_5->ViewValue = $this->s_5->CurrentValue;
            $this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, $this->s_5->formatPattern());

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->ImageWidth = 0;
                $this->omr_image->ImageHeight = 50;
                $this->omr_image->ImageAlt = $this->omr_image->alt();
                $this->omr_image->ImageCssClass = "ew-image";
                $this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
            } else {
                $this->omr_image->ViewValue = "";
            }

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // m_1
            $this->m_1->ViewValue = $this->m_1->CurrentValue;
            $this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, $this->m_1->formatPattern());

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // m_2
            $this->m_2->ViewValue = $this->m_2->CurrentValue;
            $this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, $this->m_2->formatPattern());

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // m_3
            $this->m_3->ViewValue = $this->m_3->CurrentValue;
            $this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, $this->m_3->formatPattern());

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // m_4
            $this->m_4->ViewValue = $this->m_4->CurrentValue;
            $this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, $this->m_4->formatPattern());

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // m_5
            $this->m_5->ViewValue = $this->m_5->CurrentValue;
            $this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, $this->m_5->formatPattern());

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // m_6
            $this->m_6->ViewValue = $this->m_6->CurrentValue;
            $this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, $this->m_6->formatPattern());

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // m_7
            $this->m_7->ViewValue = $this->m_7->CurrentValue;
            $this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, $this->m_7->formatPattern());

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // m_8
            $this->m_8->ViewValue = $this->m_8->CurrentValue;
            $this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, $this->m_8->formatPattern());

            // 9
            $this->_9->ViewValue = $this->_9->CurrentValue;

            // m_9
            $this->m_9->ViewValue = $this->m_9->CurrentValue;
            $this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, $this->m_9->formatPattern());

            // 10
            $this->_10->ViewValue = $this->_10->CurrentValue;

            // m_10
            $this->m_10->ViewValue = $this->m_10->CurrentValue;
            $this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, $this->m_10->formatPattern());

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // m_11
            $this->m_11->ViewValue = $this->m_11->CurrentValue;
            $this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, $this->m_11->formatPattern());

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // m_12
            $this->m_12->ViewValue = $this->m_12->CurrentValue;
            $this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, $this->m_12->formatPattern());

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // m_13
            $this->m_13->ViewValue = $this->m_13->CurrentValue;
            $this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, $this->m_13->formatPattern());

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // m_14
            $this->m_14->ViewValue = $this->m_14->CurrentValue;
            $this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, $this->m_14->formatPattern());

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // m_15
            $this->m_15->ViewValue = $this->m_15->CurrentValue;
            $this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, $this->m_15->formatPattern());

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // m_16
            $this->m_16->ViewValue = $this->m_16->CurrentValue;
            $this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, $this->m_16->formatPattern());

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // m_17
            $this->m_17->ViewValue = $this->m_17->CurrentValue;
            $this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, $this->m_17->formatPattern());

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // m_18
            $this->m_18->ViewValue = $this->m_18->CurrentValue;
            $this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, $this->m_18->formatPattern());

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // m_19
            $this->m_19->ViewValue = $this->m_19->CurrentValue;
            $this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, $this->m_19->formatPattern());

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // m_20
            $this->m_20->ViewValue = $this->m_20->CurrentValue;
            $this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, $this->m_20->formatPattern());

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // m_21
            $this->m_21->ViewValue = $this->m_21->CurrentValue;
            $this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, $this->m_21->formatPattern());

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // m_22
            $this->m_22->ViewValue = $this->m_22->CurrentValue;
            $this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, $this->m_22->formatPattern());

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // m_23
            $this->m_23->ViewValue = $this->m_23->CurrentValue;
            $this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, $this->m_23->formatPattern());

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // m_24
            $this->m_24->ViewValue = $this->m_24->CurrentValue;
            $this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, $this->m_24->formatPattern());

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // m_25
            $this->m_25->ViewValue = $this->m_25->CurrentValue;
            $this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, $this->m_25->formatPattern());

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // m_26
            $this->m_26->ViewValue = $this->m_26->CurrentValue;
            $this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, $this->m_26->formatPattern());

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // m_27
            $this->m_27->ViewValue = $this->m_27->CurrentValue;
            $this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, $this->m_27->formatPattern());

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // m_28
            $this->m_28->ViewValue = $this->m_28->CurrentValue;
            $this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, $this->m_28->formatPattern());

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // m_29
            $this->m_29->ViewValue = $this->m_29->CurrentValue;
            $this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, $this->m_29->formatPattern());

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // m_30
            $this->m_30->ViewValue = $this->m_30->CurrentValue;
            $this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, $this->m_30->formatPattern());

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // m_31
            $this->m_31->ViewValue = $this->m_31->CurrentValue;
            $this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, $this->m_31->formatPattern());

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // m_32
            $this->m_32->ViewValue = $this->m_32->CurrentValue;
            $this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, $this->m_32->formatPattern());

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // m_33
            $this->m_33->ViewValue = $this->m_33->CurrentValue;
            $this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, $this->m_33->formatPattern());

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // m_34
            $this->m_34->ViewValue = $this->m_34->CurrentValue;
            $this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, $this->m_34->formatPattern());

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // m_35
            $this->m_35->ViewValue = $this->m_35->CurrentValue;
            $this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, $this->m_35->formatPattern());

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // m_36
            $this->m_36->ViewValue = $this->m_36->CurrentValue;
            $this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, $this->m_36->formatPattern());

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // m_37
            $this->m_37->ViewValue = $this->m_37->CurrentValue;
            $this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, $this->m_37->formatPattern());

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // m_38
            $this->m_38->ViewValue = $this->m_38->CurrentValue;
            $this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, $this->m_38->formatPattern());

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // m_39
            $this->m_39->ViewValue = $this->m_39->CurrentValue;
            $this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, $this->m_39->formatPattern());

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // m_40
            $this->m_40->ViewValue = $this->m_40->CurrentValue;
            $this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, $this->m_40->formatPattern());

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // m_41
            $this->m_41->ViewValue = $this->m_41->CurrentValue;
            $this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, $this->m_41->formatPattern());

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // m_42
            $this->m_42->ViewValue = $this->m_42->CurrentValue;
            $this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, $this->m_42->formatPattern());

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // m_43
            $this->m_43->ViewValue = $this->m_43->CurrentValue;
            $this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, $this->m_43->formatPattern());

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // m_44
            $this->m_44->ViewValue = $this->m_44->CurrentValue;
            $this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, $this->m_44->formatPattern());

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // m_45
            $this->m_45->ViewValue = $this->m_45->CurrentValue;
            $this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, $this->m_45->formatPattern());

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // m_46
            $this->m_46->ViewValue = $this->m_46->CurrentValue;
            $this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, $this->m_46->formatPattern());

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // m_47
            $this->m_47->ViewValue = $this->m_47->CurrentValue;
            $this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, $this->m_47->formatPattern());

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // m_48
            $this->m_48->ViewValue = $this->m_48->CurrentValue;
            $this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, $this->m_48->formatPattern());

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // m_49
            $this->m_49->ViewValue = $this->m_49->CurrentValue;
            $this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, $this->m_49->formatPattern());

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // m_50
            $this->m_50->ViewValue = $this->m_50->CurrentValue;
            $this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, $this->m_50->formatPattern());

            // 51
            $this->_51->ViewValue = $this->_51->CurrentValue;

            // m_51
            $this->m_51->ViewValue = $this->m_51->CurrentValue;
            $this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, $this->m_51->formatPattern());

            // 52
            $this->_52->ViewValue = $this->_52->CurrentValue;

            // m_52
            $this->m_52->ViewValue = $this->m_52->CurrentValue;
            $this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, $this->m_52->formatPattern());

            // 53
            $this->_53->ViewValue = $this->_53->CurrentValue;

            // m_53
            $this->m_53->ViewValue = $this->m_53->CurrentValue;
            $this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, $this->m_53->formatPattern());

            // 54
            $this->_54->ViewValue = $this->_54->CurrentValue;

            // m_54
            $this->m_54->ViewValue = $this->m_54->CurrentValue;
            $this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, $this->m_54->formatPattern());

            // 55
            $this->_55->ViewValue = $this->_55->CurrentValue;

            // m_55
            $this->m_55->ViewValue = $this->m_55->CurrentValue;
            $this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, $this->m_55->formatPattern());

            // 56
            $this->_56->ViewValue = $this->_56->CurrentValue;

            // m_56
            $this->m_56->ViewValue = $this->m_56->CurrentValue;
            $this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, $this->m_56->formatPattern());

            // 57
            $this->_57->ViewValue = $this->_57->CurrentValue;

            // m_57
            $this->m_57->ViewValue = $this->m_57->CurrentValue;
            $this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, $this->m_57->formatPattern());

            // 58
            $this->_58->ViewValue = $this->_58->CurrentValue;

            // m_58
            $this->m_58->ViewValue = $this->m_58->CurrentValue;
            $this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, $this->m_58->formatPattern());

            // 59
            $this->_59->ViewValue = $this->_59->CurrentValue;

            // m_59
            $this->m_59->ViewValue = $this->m_59->CurrentValue;
            $this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, $this->m_59->formatPattern());

            // 60
            $this->_60->ViewValue = $this->_60->CurrentValue;

            // m_60
            $this->m_60->ViewValue = $this->m_60->CurrentValue;
            $this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, $this->m_60->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // roll_no
            $this->roll_no->HrefValue = "";
            $this->roll_no->TooltipValue = "";

            // test_id
            $this->test_id->HrefValue = "";
            $this->test_id->TooltipValue = "";

            // total
            $this->total->HrefValue = "";
            $this->total->TooltipValue = "";

            // percent
            $this->percent->HrefValue = "";
            $this->percent->TooltipValue = "";

            // s_1
            $this->s_1->HrefValue = "";
            $this->s_1->TooltipValue = "";

            // s_2
            $this->s_2->HrefValue = "";
            $this->s_2->TooltipValue = "";

            // s_3
            $this->s_3->HrefValue = "";
            $this->s_3->TooltipValue = "";

            // s_4
            $this->s_4->HrefValue = "";
            $this->s_4->TooltipValue = "";

            // s_5
            $this->s_5->HrefValue = "";
            $this->s_5->TooltipValue = "";

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->htmlDecode($this->omr_image->Upload->DbValue)); // Add prefix/suffix
                $this->omr_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
                }
            } else {
                $this->omr_image->HrefValue = "";
            }
            $this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;
            $this->omr_image->TooltipValue = "";
            if ($this->omr_image->UseColorbox) {
                if (EmptyValue($this->omr_image->TooltipValue)) {
                    $this->omr_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->omr_image->LinkAttrs["data-rel"] = "s_omr_value_x" . $this->RowCount . "_omr_image";
                $this->omr_image->LinkAttrs->appendClass("ew-lightbox");
            }

            // 1
            $this->_1->HrefValue = "";
            $this->_1->TooltipValue = "";

            // m_1
            $this->m_1->HrefValue = "";
            $this->m_1->TooltipValue = "";

            // 2
            $this->_2->HrefValue = "";
            $this->_2->TooltipValue = "";

            // m_2
            $this->m_2->HrefValue = "";
            $this->m_2->TooltipValue = "";

            // 3
            $this->_3->HrefValue = "";
            $this->_3->TooltipValue = "";

            // m_3
            $this->m_3->HrefValue = "";
            $this->m_3->TooltipValue = "";

            // 4
            $this->_4->HrefValue = "";
            $this->_4->TooltipValue = "";

            // m_4
            $this->m_4->HrefValue = "";
            $this->m_4->TooltipValue = "";

            // 5
            $this->_5->HrefValue = "";
            $this->_5->TooltipValue = "";

            // m_5
            $this->m_5->HrefValue = "";
            $this->m_5->TooltipValue = "";

            // 6
            $this->_6->HrefValue = "";
            $this->_6->TooltipValue = "";

            // m_6
            $this->m_6->HrefValue = "";
            $this->m_6->TooltipValue = "";

            // 7
            $this->_7->HrefValue = "";
            $this->_7->TooltipValue = "";

            // m_7
            $this->m_7->HrefValue = "";
            $this->m_7->TooltipValue = "";

            // 8
            $this->_8->HrefValue = "";
            $this->_8->TooltipValue = "";

            // m_8
            $this->m_8->HrefValue = "";
            $this->m_8->TooltipValue = "";

            // 9
            $this->_9->HrefValue = "";
            $this->_9->TooltipValue = "";

            // m_9
            $this->m_9->HrefValue = "";
            $this->m_9->TooltipValue = "";

            // 10
            $this->_10->HrefValue = "";
            $this->_10->TooltipValue = "";

            // m_10
            $this->m_10->HrefValue = "";
            $this->m_10->TooltipValue = "";

            // 11
            $this->_11->HrefValue = "";
            $this->_11->TooltipValue = "";

            // m_11
            $this->m_11->HrefValue = "";
            $this->m_11->TooltipValue = "";

            // 12
            $this->_12->HrefValue = "";
            $this->_12->TooltipValue = "";

            // m_12
            $this->m_12->HrefValue = "";
            $this->m_12->TooltipValue = "";

            // 13
            $this->_13->HrefValue = "";
            $this->_13->TooltipValue = "";

            // m_13
            $this->m_13->HrefValue = "";
            $this->m_13->TooltipValue = "";

            // 14
            $this->_14->HrefValue = "";
            $this->_14->TooltipValue = "";

            // m_14
            $this->m_14->HrefValue = "";
            $this->m_14->TooltipValue = "";

            // 15
            $this->_15->HrefValue = "";
            $this->_15->TooltipValue = "";

            // m_15
            $this->m_15->HrefValue = "";
            $this->m_15->TooltipValue = "";

            // 16
            $this->_16->HrefValue = "";
            $this->_16->TooltipValue = "";

            // m_16
            $this->m_16->HrefValue = "";
            $this->m_16->TooltipValue = "";

            // 17
            $this->_17->HrefValue = "";
            $this->_17->TooltipValue = "";

            // m_17
            $this->m_17->HrefValue = "";
            $this->m_17->TooltipValue = "";

            // 18
            $this->_18->HrefValue = "";
            $this->_18->TooltipValue = "";

            // m_18
            $this->m_18->HrefValue = "";
            $this->m_18->TooltipValue = "";

            // 19
            $this->_19->HrefValue = "";
            $this->_19->TooltipValue = "";

            // m_19
            $this->m_19->HrefValue = "";
            $this->m_19->TooltipValue = "";

            // 20
            $this->_20->HrefValue = "";
            $this->_20->TooltipValue = "";

            // m_20
            $this->m_20->HrefValue = "";
            $this->m_20->TooltipValue = "";

            // 21
            $this->_21->HrefValue = "";
            $this->_21->TooltipValue = "";

            // m_21
            $this->m_21->HrefValue = "";
            $this->m_21->TooltipValue = "";

            // 22
            $this->_22->HrefValue = "";
            $this->_22->TooltipValue = "";

            // m_22
            $this->m_22->HrefValue = "";
            $this->m_22->TooltipValue = "";

            // 23
            $this->_23->HrefValue = "";
            $this->_23->TooltipValue = "";

            // m_23
            $this->m_23->HrefValue = "";
            $this->m_23->TooltipValue = "";

            // 24
            $this->_24->HrefValue = "";
            $this->_24->TooltipValue = "";

            // m_24
            $this->m_24->HrefValue = "";
            $this->m_24->TooltipValue = "";

            // 25
            $this->_25->HrefValue = "";
            $this->_25->TooltipValue = "";

            // m_25
            $this->m_25->HrefValue = "";
            $this->m_25->TooltipValue = "";

            // 26
            $this->_26->HrefValue = "";
            $this->_26->TooltipValue = "";

            // m_26
            $this->m_26->HrefValue = "";
            $this->m_26->TooltipValue = "";

            // 27
            $this->_27->HrefValue = "";
            $this->_27->TooltipValue = "";

            // m_27
            $this->m_27->HrefValue = "";
            $this->m_27->TooltipValue = "";

            // 28
            $this->_28->HrefValue = "";
            $this->_28->TooltipValue = "";

            // m_28
            $this->m_28->HrefValue = "";
            $this->m_28->TooltipValue = "";

            // 29
            $this->_29->HrefValue = "";
            $this->_29->TooltipValue = "";

            // m_29
            $this->m_29->HrefValue = "";
            $this->m_29->TooltipValue = "";

            // 30
            $this->_30->HrefValue = "";
            $this->_30->TooltipValue = "";

            // m_30
            $this->m_30->HrefValue = "";
            $this->m_30->TooltipValue = "";

            // 31
            $this->_31->HrefValue = "";
            $this->_31->TooltipValue = "";

            // m_31
            $this->m_31->HrefValue = "";
            $this->m_31->TooltipValue = "";

            // 32
            $this->_32->HrefValue = "";
            $this->_32->TooltipValue = "";

            // m_32
            $this->m_32->HrefValue = "";
            $this->m_32->TooltipValue = "";

            // 33
            $this->_33->HrefValue = "";
            $this->_33->TooltipValue = "";

            // m_33
            $this->m_33->HrefValue = "";
            $this->m_33->TooltipValue = "";

            // 34
            $this->_34->HrefValue = "";
            $this->_34->TooltipValue = "";

            // m_34
            $this->m_34->HrefValue = "";
            $this->m_34->TooltipValue = "";

            // 35
            $this->_35->HrefValue = "";
            $this->_35->TooltipValue = "";

            // m_35
            $this->m_35->HrefValue = "";
            $this->m_35->TooltipValue = "";

            // 36
            $this->_36->HrefValue = "";
            $this->_36->TooltipValue = "";

            // m_36
            $this->m_36->HrefValue = "";
            $this->m_36->TooltipValue = "";

            // 37
            $this->_37->HrefValue = "";
            $this->_37->TooltipValue = "";

            // m_37
            $this->m_37->HrefValue = "";
            $this->m_37->TooltipValue = "";

            // 38
            $this->_38->HrefValue = "";
            $this->_38->TooltipValue = "";

            // m_38
            $this->m_38->HrefValue = "";
            $this->m_38->TooltipValue = "";

            // 39
            $this->_39->HrefValue = "";
            $this->_39->TooltipValue = "";

            // m_39
            $this->m_39->HrefValue = "";
            $this->m_39->TooltipValue = "";

            // 40
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // m_40
            $this->m_40->HrefValue = "";
            $this->m_40->TooltipValue = "";

            // 41
            $this->_41->HrefValue = "";
            $this->_41->TooltipValue = "";

            // m_41
            $this->m_41->HrefValue = "";
            $this->m_41->TooltipValue = "";

            // 42
            $this->_42->HrefValue = "";
            $this->_42->TooltipValue = "";

            // m_42
            $this->m_42->HrefValue = "";
            $this->m_42->TooltipValue = "";

            // 43
            $this->_43->HrefValue = "";
            $this->_43->TooltipValue = "";

            // m_43
            $this->m_43->HrefValue = "";
            $this->m_43->TooltipValue = "";

            // 44
            $this->_44->HrefValue = "";
            $this->_44->TooltipValue = "";

            // m_44
            $this->m_44->HrefValue = "";
            $this->m_44->TooltipValue = "";

            // 45
            $this->_45->HrefValue = "";
            $this->_45->TooltipValue = "";

            // m_45
            $this->m_45->HrefValue = "";
            $this->m_45->TooltipValue = "";

            // 46
            $this->_46->HrefValue = "";
            $this->_46->TooltipValue = "";

            // m_46
            $this->m_46->HrefValue = "";
            $this->m_46->TooltipValue = "";

            // 47
            $this->_47->HrefValue = "";
            $this->_47->TooltipValue = "";

            // m_47
            $this->m_47->HrefValue = "";
            $this->m_47->TooltipValue = "";

            // 48
            $this->_48->HrefValue = "";
            $this->_48->TooltipValue = "";

            // m_48
            $this->m_48->HrefValue = "";
            $this->m_48->TooltipValue = "";

            // 49
            $this->_49->HrefValue = "";
            $this->_49->TooltipValue = "";

            // m_49
            $this->m_49->HrefValue = "";
            $this->m_49->TooltipValue = "";

            // 50
            $this->_50->HrefValue = "";
            $this->_50->TooltipValue = "";

            // m_50
            $this->m_50->HrefValue = "";
            $this->m_50->TooltipValue = "";

            // 51
            $this->_51->HrefValue = "";
            $this->_51->TooltipValue = "";

            // m_51
            $this->m_51->HrefValue = "";
            $this->m_51->TooltipValue = "";

            // 52
            $this->_52->HrefValue = "";
            $this->_52->TooltipValue = "";

            // m_52
            $this->m_52->HrefValue = "";
            $this->m_52->TooltipValue = "";

            // 53
            $this->_53->HrefValue = "";
            $this->_53->TooltipValue = "";

            // m_53
            $this->m_53->HrefValue = "";
            $this->m_53->TooltipValue = "";

            // 54
            $this->_54->HrefValue = "";
            $this->_54->TooltipValue = "";

            // m_54
            $this->m_54->HrefValue = "";
            $this->m_54->TooltipValue = "";

            // 55
            $this->_55->HrefValue = "";
            $this->_55->TooltipValue = "";

            // m_55
            $this->m_55->HrefValue = "";
            $this->m_55->TooltipValue = "";

            // 56
            $this->_56->HrefValue = "";
            $this->_56->TooltipValue = "";

            // m_56
            $this->m_56->HrefValue = "";
            $this->m_56->TooltipValue = "";

            // 57
            $this->_57->HrefValue = "";
            $this->_57->TooltipValue = "";

            // m_57
            $this->m_57->HrefValue = "";
            $this->m_57->TooltipValue = "";

            // 58
            $this->_58->HrefValue = "";
            $this->_58->TooltipValue = "";

            // m_58
            $this->m_58->HrefValue = "";
            $this->m_58->TooltipValue = "";

            // 59
            $this->_59->HrefValue = "";
            $this->_59->TooltipValue = "";

            // m_59
            $this->m_59->HrefValue = "";
            $this->m_59->TooltipValue = "";

            // 60
            $this->_60->HrefValue = "";
            $this->_60->TooltipValue = "";

            // m_60
            $this->m_60->HrefValue = "";
            $this->m_60->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("somrvaluelist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
