<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SOmrValueAdd extends SOmrValue
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SOmrValueAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "somrvalueadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->roll_no->setVisibility();
        $this->test_id->setVisibility();
        $this->total->setVisibility();
        $this->percent->setVisibility();
        $this->s_1->setVisibility();
        $this->s_2->setVisibility();
        $this->s_3->setVisibility();
        $this->s_4->setVisibility();
        $this->s_5->setVisibility();
        $this->omr_image->setVisibility();
        $this->_1->setVisibility();
        $this->m_1->setVisibility();
        $this->_2->setVisibility();
        $this->m_2->setVisibility();
        $this->_3->setVisibility();
        $this->m_3->setVisibility();
        $this->_4->setVisibility();
        $this->m_4->setVisibility();
        $this->_5->setVisibility();
        $this->m_5->setVisibility();
        $this->_6->setVisibility();
        $this->m_6->setVisibility();
        $this->_7->setVisibility();
        $this->m_7->setVisibility();
        $this->_8->setVisibility();
        $this->m_8->setVisibility();
        $this->_9->setVisibility();
        $this->m_9->setVisibility();
        $this->_10->setVisibility();
        $this->m_10->setVisibility();
        $this->_11->setVisibility();
        $this->m_11->setVisibility();
        $this->_12->setVisibility();
        $this->m_12->setVisibility();
        $this->_13->setVisibility();
        $this->m_13->setVisibility();
        $this->_14->setVisibility();
        $this->m_14->setVisibility();
        $this->_15->setVisibility();
        $this->m_15->setVisibility();
        $this->_16->setVisibility();
        $this->m_16->setVisibility();
        $this->_17->setVisibility();
        $this->m_17->setVisibility();
        $this->_18->setVisibility();
        $this->m_18->setVisibility();
        $this->_19->setVisibility();
        $this->m_19->setVisibility();
        $this->_20->setVisibility();
        $this->m_20->setVisibility();
        $this->_21->setVisibility();
        $this->m_21->setVisibility();
        $this->_22->setVisibility();
        $this->m_22->setVisibility();
        $this->_23->setVisibility();
        $this->m_23->setVisibility();
        $this->_24->setVisibility();
        $this->m_24->setVisibility();
        $this->_25->setVisibility();
        $this->m_25->setVisibility();
        $this->_26->setVisibility();
        $this->m_26->setVisibility();
        $this->_27->setVisibility();
        $this->m_27->setVisibility();
        $this->_28->setVisibility();
        $this->m_28->setVisibility();
        $this->_29->setVisibility();
        $this->m_29->setVisibility();
        $this->_30->setVisibility();
        $this->m_30->setVisibility();
        $this->_31->setVisibility();
        $this->m_31->setVisibility();
        $this->_32->setVisibility();
        $this->m_32->setVisibility();
        $this->_33->setVisibility();
        $this->m_33->setVisibility();
        $this->_34->setVisibility();
        $this->m_34->setVisibility();
        $this->_35->setVisibility();
        $this->m_35->setVisibility();
        $this->_36->setVisibility();
        $this->m_36->setVisibility();
        $this->_37->setVisibility();
        $this->m_37->setVisibility();
        $this->_38->setVisibility();
        $this->m_38->setVisibility();
        $this->_39->setVisibility();
        $this->m_39->setVisibility();
        $this->_40->setVisibility();
        $this->m_40->setVisibility();
        $this->_41->setVisibility();
        $this->m_41->setVisibility();
        $this->_42->setVisibility();
        $this->m_42->setVisibility();
        $this->_43->setVisibility();
        $this->m_43->setVisibility();
        $this->_44->setVisibility();
        $this->m_44->setVisibility();
        $this->_45->setVisibility();
        $this->m_45->setVisibility();
        $this->_46->setVisibility();
        $this->m_46->setVisibility();
        $this->_47->setVisibility();
        $this->m_47->setVisibility();
        $this->_48->setVisibility();
        $this->m_48->setVisibility();
        $this->_49->setVisibility();
        $this->m_49->setVisibility();
        $this->_50->setVisibility();
        $this->m_50->setVisibility();
        $this->_51->setVisibility();
        $this->m_51->setVisibility();
        $this->_52->setVisibility();
        $this->m_52->setVisibility();
        $this->_53->setVisibility();
        $this->m_53->setVisibility();
        $this->_54->setVisibility();
        $this->m_54->setVisibility();
        $this->_55->setVisibility();
        $this->m_55->setVisibility();
        $this->_56->setVisibility();
        $this->m_56->setVisibility();
        $this->_57->setVisibility();
        $this->m_57->setVisibility();
        $this->_58->setVisibility();
        $this->m_58->setVisibility();
        $this->_59->setVisibility();
        $this->m_59->setVisibility();
        $this->_60->setVisibility();
        $this->m_60->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 's_omr_value';
        $this->TableName = 's_omr_value';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_omr_value)
        if (!isset($GLOBALS["s_omr_value"]) || $GLOBALS["s_omr_value"]::class == PROJECT_NAMESPACE . "s_omr_value") {
            $GLOBALS["s_omr_value"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "somrvalueview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->omr_image->OldUploadPath = $this->omr_image->getUploadPath(); // PHP
                $this->omr_image->UploadPath = $this->omr_image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("somrvaluelist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "somrvaluelist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "somrvalueview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "somrvaluelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "somrvaluelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->omr_image->Upload->Index = $CurrentForm->Index;
        $this->omr_image->Upload->uploadFile();
        $this->omr_image->CurrentValue = $this->omr_image->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->m_1->DefaultValue = $this->m_1->getDefault(); // PHP
        $this->m_1->OldValue = $this->m_1->DefaultValue;
        $this->m_2->DefaultValue = $this->m_2->getDefault(); // PHP
        $this->m_2->OldValue = $this->m_2->DefaultValue;
        $this->m_3->DefaultValue = $this->m_3->getDefault(); // PHP
        $this->m_3->OldValue = $this->m_3->DefaultValue;
        $this->m_4->DefaultValue = $this->m_4->getDefault(); // PHP
        $this->m_4->OldValue = $this->m_4->DefaultValue;
        $this->m_5->DefaultValue = $this->m_5->getDefault(); // PHP
        $this->m_5->OldValue = $this->m_5->DefaultValue;
        $this->m_6->DefaultValue = $this->m_6->getDefault(); // PHP
        $this->m_6->OldValue = $this->m_6->DefaultValue;
        $this->m_7->DefaultValue = $this->m_7->getDefault(); // PHP
        $this->m_7->OldValue = $this->m_7->DefaultValue;
        $this->m_8->DefaultValue = $this->m_8->getDefault(); // PHP
        $this->m_8->OldValue = $this->m_8->DefaultValue;
        $this->m_9->DefaultValue = $this->m_9->getDefault(); // PHP
        $this->m_9->OldValue = $this->m_9->DefaultValue;
        $this->m_10->DefaultValue = $this->m_10->getDefault(); // PHP
        $this->m_10->OldValue = $this->m_10->DefaultValue;
        $this->m_11->DefaultValue = $this->m_11->getDefault(); // PHP
        $this->m_11->OldValue = $this->m_11->DefaultValue;
        $this->m_12->DefaultValue = $this->m_12->getDefault(); // PHP
        $this->m_12->OldValue = $this->m_12->DefaultValue;
        $this->m_13->DefaultValue = $this->m_13->getDefault(); // PHP
        $this->m_13->OldValue = $this->m_13->DefaultValue;
        $this->m_14->DefaultValue = $this->m_14->getDefault(); // PHP
        $this->m_14->OldValue = $this->m_14->DefaultValue;
        $this->m_15->DefaultValue = $this->m_15->getDefault(); // PHP
        $this->m_15->OldValue = $this->m_15->DefaultValue;
        $this->m_16->DefaultValue = $this->m_16->getDefault(); // PHP
        $this->m_16->OldValue = $this->m_16->DefaultValue;
        $this->m_17->DefaultValue = $this->m_17->getDefault(); // PHP
        $this->m_17->OldValue = $this->m_17->DefaultValue;
        $this->m_18->DefaultValue = $this->m_18->getDefault(); // PHP
        $this->m_18->OldValue = $this->m_18->DefaultValue;
        $this->m_19->DefaultValue = $this->m_19->getDefault(); // PHP
        $this->m_19->OldValue = $this->m_19->DefaultValue;
        $this->m_20->DefaultValue = $this->m_20->getDefault(); // PHP
        $this->m_20->OldValue = $this->m_20->DefaultValue;
        $this->m_21->DefaultValue = $this->m_21->getDefault(); // PHP
        $this->m_21->OldValue = $this->m_21->DefaultValue;
        $this->m_22->DefaultValue = $this->m_22->getDefault(); // PHP
        $this->m_22->OldValue = $this->m_22->DefaultValue;
        $this->m_23->DefaultValue = $this->m_23->getDefault(); // PHP
        $this->m_23->OldValue = $this->m_23->DefaultValue;
        $this->m_24->DefaultValue = $this->m_24->getDefault(); // PHP
        $this->m_24->OldValue = $this->m_24->DefaultValue;
        $this->m_25->DefaultValue = $this->m_25->getDefault(); // PHP
        $this->m_25->OldValue = $this->m_25->DefaultValue;
        $this->m_26->DefaultValue = $this->m_26->getDefault(); // PHP
        $this->m_26->OldValue = $this->m_26->DefaultValue;
        $this->m_27->DefaultValue = $this->m_27->getDefault(); // PHP
        $this->m_27->OldValue = $this->m_27->DefaultValue;
        $this->m_28->DefaultValue = $this->m_28->getDefault(); // PHP
        $this->m_28->OldValue = $this->m_28->DefaultValue;
        $this->m_29->DefaultValue = $this->m_29->getDefault(); // PHP
        $this->m_29->OldValue = $this->m_29->DefaultValue;
        $this->m_30->DefaultValue = $this->m_30->getDefault(); // PHP
        $this->m_30->OldValue = $this->m_30->DefaultValue;
        $this->m_31->DefaultValue = $this->m_31->getDefault(); // PHP
        $this->m_31->OldValue = $this->m_31->DefaultValue;
        $this->m_32->DefaultValue = $this->m_32->getDefault(); // PHP
        $this->m_32->OldValue = $this->m_32->DefaultValue;
        $this->m_33->DefaultValue = $this->m_33->getDefault(); // PHP
        $this->m_33->OldValue = $this->m_33->DefaultValue;
        $this->m_34->DefaultValue = $this->m_34->getDefault(); // PHP
        $this->m_34->OldValue = $this->m_34->DefaultValue;
        $this->m_35->DefaultValue = $this->m_35->getDefault(); // PHP
        $this->m_35->OldValue = $this->m_35->DefaultValue;
        $this->m_36->DefaultValue = $this->m_36->getDefault(); // PHP
        $this->m_36->OldValue = $this->m_36->DefaultValue;
        $this->m_37->DefaultValue = $this->m_37->getDefault(); // PHP
        $this->m_37->OldValue = $this->m_37->DefaultValue;
        $this->m_38->DefaultValue = $this->m_38->getDefault(); // PHP
        $this->m_38->OldValue = $this->m_38->DefaultValue;
        $this->m_39->DefaultValue = $this->m_39->getDefault(); // PHP
        $this->m_39->OldValue = $this->m_39->DefaultValue;
        $this->m_40->DefaultValue = $this->m_40->getDefault(); // PHP
        $this->m_40->OldValue = $this->m_40->DefaultValue;
        $this->m_41->DefaultValue = $this->m_41->getDefault(); // PHP
        $this->m_41->OldValue = $this->m_41->DefaultValue;
        $this->m_42->DefaultValue = $this->m_42->getDefault(); // PHP
        $this->m_42->OldValue = $this->m_42->DefaultValue;
        $this->m_43->DefaultValue = $this->m_43->getDefault(); // PHP
        $this->m_43->OldValue = $this->m_43->DefaultValue;
        $this->m_44->DefaultValue = $this->m_44->getDefault(); // PHP
        $this->m_44->OldValue = $this->m_44->DefaultValue;
        $this->m_45->DefaultValue = $this->m_45->getDefault(); // PHP
        $this->m_45->OldValue = $this->m_45->DefaultValue;
        $this->m_46->DefaultValue = $this->m_46->getDefault(); // PHP
        $this->m_46->OldValue = $this->m_46->DefaultValue;
        $this->m_47->DefaultValue = $this->m_47->getDefault(); // PHP
        $this->m_47->OldValue = $this->m_47->DefaultValue;
        $this->m_48->DefaultValue = $this->m_48->getDefault(); // PHP
        $this->m_48->OldValue = $this->m_48->DefaultValue;
        $this->m_49->DefaultValue = $this->m_49->getDefault(); // PHP
        $this->m_49->OldValue = $this->m_49->DefaultValue;
        $this->m_50->DefaultValue = $this->m_50->getDefault(); // PHP
        $this->m_50->OldValue = $this->m_50->DefaultValue;
        $this->m_51->DefaultValue = $this->m_51->getDefault(); // PHP
        $this->m_51->OldValue = $this->m_51->DefaultValue;
        $this->m_52->DefaultValue = $this->m_52->getDefault(); // PHP
        $this->m_52->OldValue = $this->m_52->DefaultValue;
        $this->m_53->DefaultValue = $this->m_53->getDefault(); // PHP
        $this->m_53->OldValue = $this->m_53->DefaultValue;
        $this->m_54->DefaultValue = $this->m_54->getDefault(); // PHP
        $this->m_54->OldValue = $this->m_54->DefaultValue;
        $this->m_55->DefaultValue = $this->m_55->getDefault(); // PHP
        $this->m_55->OldValue = $this->m_55->DefaultValue;
        $this->m_56->DefaultValue = $this->m_56->getDefault(); // PHP
        $this->m_56->OldValue = $this->m_56->DefaultValue;
        $this->m_57->DefaultValue = $this->m_57->getDefault(); // PHP
        $this->m_57->OldValue = $this->m_57->DefaultValue;
        $this->m_58->DefaultValue = $this->m_58->getDefault(); // PHP
        $this->m_58->OldValue = $this->m_58->DefaultValue;
        $this->m_59->DefaultValue = $this->m_59->getDefault(); // PHP
        $this->m_59->OldValue = $this->m_59->DefaultValue;
        $this->m_60->DefaultValue = $this->m_60->getDefault(); // PHP
        $this->m_60->OldValue = $this->m_60->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'roll_no' first before field var 'x_roll_no'
        $val = $CurrentForm->hasValue("roll_no") ? $CurrentForm->getValue("roll_no") : $CurrentForm->getValue("x_roll_no");
        if (!$this->roll_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->roll_no->Visible = false; // Disable update for API request
            } else {
                $this->roll_no->setFormValue($val);
            }
        }

        // Check field name 'test_id' first before field var 'x_test_id'
        $val = $CurrentForm->hasValue("test_id") ? $CurrentForm->getValue("test_id") : $CurrentForm->getValue("x_test_id");
        if (!$this->test_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->test_id->Visible = false; // Disable update for API request
            } else {
                $this->test_id->setFormValue($val);
            }
        }

        // Check field name 'total' first before field var 'x_total'
        $val = $CurrentForm->hasValue("total") ? $CurrentForm->getValue("total") : $CurrentForm->getValue("x_total");
        if (!$this->total->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->total->Visible = false; // Disable update for API request
            } else {
                $this->total->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'percent' first before field var 'x_percent'
        $val = $CurrentForm->hasValue("percent") ? $CurrentForm->getValue("percent") : $CurrentForm->getValue("x_percent");
        if (!$this->percent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->percent->Visible = false; // Disable update for API request
            } else {
                $this->percent->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_1' first before field var 'x_s_1'
        $val = $CurrentForm->hasValue("s_1") ? $CurrentForm->getValue("s_1") : $CurrentForm->getValue("x_s_1");
        if (!$this->s_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_1->Visible = false; // Disable update for API request
            } else {
                $this->s_1->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_2' first before field var 'x_s_2'
        $val = $CurrentForm->hasValue("s_2") ? $CurrentForm->getValue("s_2") : $CurrentForm->getValue("x_s_2");
        if (!$this->s_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_2->Visible = false; // Disable update for API request
            } else {
                $this->s_2->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_3' first before field var 'x_s_3'
        $val = $CurrentForm->hasValue("s_3") ? $CurrentForm->getValue("s_3") : $CurrentForm->getValue("x_s_3");
        if (!$this->s_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_3->Visible = false; // Disable update for API request
            } else {
                $this->s_3->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_4' first before field var 'x_s_4'
        $val = $CurrentForm->hasValue("s_4") ? $CurrentForm->getValue("s_4") : $CurrentForm->getValue("x_s_4");
        if (!$this->s_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_4->Visible = false; // Disable update for API request
            } else {
                $this->s_4->setFormValue($val, true, $validate);
            }
        }

        // Check field name 's_5' first before field var 'x_s_5'
        $val = $CurrentForm->hasValue("s_5") ? $CurrentForm->getValue("s_5") : $CurrentForm->getValue("x_s_5");
        if (!$this->s_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_5->Visible = false; // Disable update for API request
            } else {
                $this->s_5->setFormValue($val, true, $validate);
            }
        }

        // Check field name '1' first before field var 'x__1'
        $val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
        if (!$this->_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_1->Visible = false; // Disable update for API request
            } else {
                $this->_1->setFormValue($val);
            }
        }

        // Check field name 'm_1' first before field var 'x_m_1'
        $val = $CurrentForm->hasValue("m_1") ? $CurrentForm->getValue("m_1") : $CurrentForm->getValue("x_m_1");
        if (!$this->m_1->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_1->Visible = false; // Disable update for API request
            } else {
                $this->m_1->setFormValue($val, true, $validate);
            }
        }

        // Check field name '2' first before field var 'x__2'
        $val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
        if (!$this->_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_2->Visible = false; // Disable update for API request
            } else {
                $this->_2->setFormValue($val);
            }
        }

        // Check field name 'm_2' first before field var 'x_m_2'
        $val = $CurrentForm->hasValue("m_2") ? $CurrentForm->getValue("m_2") : $CurrentForm->getValue("x_m_2");
        if (!$this->m_2->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_2->Visible = false; // Disable update for API request
            } else {
                $this->m_2->setFormValue($val, true, $validate);
            }
        }

        // Check field name '3' first before field var 'x__3'
        $val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
        if (!$this->_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_3->Visible = false; // Disable update for API request
            } else {
                $this->_3->setFormValue($val);
            }
        }

        // Check field name 'm_3' first before field var 'x_m_3'
        $val = $CurrentForm->hasValue("m_3") ? $CurrentForm->getValue("m_3") : $CurrentForm->getValue("x_m_3");
        if (!$this->m_3->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_3->Visible = false; // Disable update for API request
            } else {
                $this->m_3->setFormValue($val, true, $validate);
            }
        }

        // Check field name '4' first before field var 'x__4'
        $val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
        if (!$this->_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_4->Visible = false; // Disable update for API request
            } else {
                $this->_4->setFormValue($val);
            }
        }

        // Check field name 'm_4' first before field var 'x_m_4'
        $val = $CurrentForm->hasValue("m_4") ? $CurrentForm->getValue("m_4") : $CurrentForm->getValue("x_m_4");
        if (!$this->m_4->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_4->Visible = false; // Disable update for API request
            } else {
                $this->m_4->setFormValue($val, true, $validate);
            }
        }

        // Check field name '5' first before field var 'x__5'
        $val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
        if (!$this->_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_5->Visible = false; // Disable update for API request
            } else {
                $this->_5->setFormValue($val);
            }
        }

        // Check field name 'm_5' first before field var 'x_m_5'
        $val = $CurrentForm->hasValue("m_5") ? $CurrentForm->getValue("m_5") : $CurrentForm->getValue("x_m_5");
        if (!$this->m_5->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_5->Visible = false; // Disable update for API request
            } else {
                $this->m_5->setFormValue($val, true, $validate);
            }
        }

        // Check field name '6' first before field var 'x__6'
        $val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
        if (!$this->_6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_6->Visible = false; // Disable update for API request
            } else {
                $this->_6->setFormValue($val);
            }
        }

        // Check field name 'm_6' first before field var 'x_m_6'
        $val = $CurrentForm->hasValue("m_6") ? $CurrentForm->getValue("m_6") : $CurrentForm->getValue("x_m_6");
        if (!$this->m_6->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_6->Visible = false; // Disable update for API request
            } else {
                $this->m_6->setFormValue($val, true, $validate);
            }
        }

        // Check field name '7' first before field var 'x__7'
        $val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
        if (!$this->_7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_7->Visible = false; // Disable update for API request
            } else {
                $this->_7->setFormValue($val);
            }
        }

        // Check field name 'm_7' first before field var 'x_m_7'
        $val = $CurrentForm->hasValue("m_7") ? $CurrentForm->getValue("m_7") : $CurrentForm->getValue("x_m_7");
        if (!$this->m_7->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_7->Visible = false; // Disable update for API request
            } else {
                $this->m_7->setFormValue($val, true, $validate);
            }
        }

        // Check field name '8' first before field var 'x__8'
        $val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
        if (!$this->_8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_8->Visible = false; // Disable update for API request
            } else {
                $this->_8->setFormValue($val);
            }
        }

        // Check field name 'm_8' first before field var 'x_m_8'
        $val = $CurrentForm->hasValue("m_8") ? $CurrentForm->getValue("m_8") : $CurrentForm->getValue("x_m_8");
        if (!$this->m_8->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_8->Visible = false; // Disable update for API request
            } else {
                $this->m_8->setFormValue($val, true, $validate);
            }
        }

        // Check field name '9' first before field var 'x__9'
        $val = $CurrentForm->hasValue("9") ? $CurrentForm->getValue("9") : $CurrentForm->getValue("x__9");
        if (!$this->_9->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_9->Visible = false; // Disable update for API request
            } else {
                $this->_9->setFormValue($val);
            }
        }

        // Check field name 'm_9' first before field var 'x_m_9'
        $val = $CurrentForm->hasValue("m_9") ? $CurrentForm->getValue("m_9") : $CurrentForm->getValue("x_m_9");
        if (!$this->m_9->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_9->Visible = false; // Disable update for API request
            } else {
                $this->m_9->setFormValue($val, true, $validate);
            }
        }

        // Check field name '10' first before field var 'x__10'
        $val = $CurrentForm->hasValue("10") ? $CurrentForm->getValue("10") : $CurrentForm->getValue("x__10");
        if (!$this->_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_10->Visible = false; // Disable update for API request
            } else {
                $this->_10->setFormValue($val);
            }
        }

        // Check field name 'm_10' first before field var 'x_m_10'
        $val = $CurrentForm->hasValue("m_10") ? $CurrentForm->getValue("m_10") : $CurrentForm->getValue("x_m_10");
        if (!$this->m_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_10->Visible = false; // Disable update for API request
            } else {
                $this->m_10->setFormValue($val, true, $validate);
            }
        }

        // Check field name '11' first before field var 'x__11'
        $val = $CurrentForm->hasValue("11") ? $CurrentForm->getValue("11") : $CurrentForm->getValue("x__11");
        if (!$this->_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_11->Visible = false; // Disable update for API request
            } else {
                $this->_11->setFormValue($val);
            }
        }

        // Check field name 'm_11' first before field var 'x_m_11'
        $val = $CurrentForm->hasValue("m_11") ? $CurrentForm->getValue("m_11") : $CurrentForm->getValue("x_m_11");
        if (!$this->m_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_11->Visible = false; // Disable update for API request
            } else {
                $this->m_11->setFormValue($val, true, $validate);
            }
        }

        // Check field name '12' first before field var 'x__12'
        $val = $CurrentForm->hasValue("12") ? $CurrentForm->getValue("12") : $CurrentForm->getValue("x__12");
        if (!$this->_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_12->Visible = false; // Disable update for API request
            } else {
                $this->_12->setFormValue($val);
            }
        }

        // Check field name 'm_12' first before field var 'x_m_12'
        $val = $CurrentForm->hasValue("m_12") ? $CurrentForm->getValue("m_12") : $CurrentForm->getValue("x_m_12");
        if (!$this->m_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_12->Visible = false; // Disable update for API request
            } else {
                $this->m_12->setFormValue($val, true, $validate);
            }
        }

        // Check field name '13' first before field var 'x__13'
        $val = $CurrentForm->hasValue("13") ? $CurrentForm->getValue("13") : $CurrentForm->getValue("x__13");
        if (!$this->_13->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_13->Visible = false; // Disable update for API request
            } else {
                $this->_13->setFormValue($val);
            }
        }

        // Check field name 'm_13' first before field var 'x_m_13'
        $val = $CurrentForm->hasValue("m_13") ? $CurrentForm->getValue("m_13") : $CurrentForm->getValue("x_m_13");
        if (!$this->m_13->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_13->Visible = false; // Disable update for API request
            } else {
                $this->m_13->setFormValue($val, true, $validate);
            }
        }

        // Check field name '14' first before field var 'x__14'
        $val = $CurrentForm->hasValue("14") ? $CurrentForm->getValue("14") : $CurrentForm->getValue("x__14");
        if (!$this->_14->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_14->Visible = false; // Disable update for API request
            } else {
                $this->_14->setFormValue($val);
            }
        }

        // Check field name 'm_14' first before field var 'x_m_14'
        $val = $CurrentForm->hasValue("m_14") ? $CurrentForm->getValue("m_14") : $CurrentForm->getValue("x_m_14");
        if (!$this->m_14->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_14->Visible = false; // Disable update for API request
            } else {
                $this->m_14->setFormValue($val, true, $validate);
            }
        }

        // Check field name '15' first before field var 'x__15'
        $val = $CurrentForm->hasValue("15") ? $CurrentForm->getValue("15") : $CurrentForm->getValue("x__15");
        if (!$this->_15->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_15->Visible = false; // Disable update for API request
            } else {
                $this->_15->setFormValue($val);
            }
        }

        // Check field name 'm_15' first before field var 'x_m_15'
        $val = $CurrentForm->hasValue("m_15") ? $CurrentForm->getValue("m_15") : $CurrentForm->getValue("x_m_15");
        if (!$this->m_15->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_15->Visible = false; // Disable update for API request
            } else {
                $this->m_15->setFormValue($val, true, $validate);
            }
        }

        // Check field name '16' first before field var 'x__16'
        $val = $CurrentForm->hasValue("16") ? $CurrentForm->getValue("16") : $CurrentForm->getValue("x__16");
        if (!$this->_16->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_16->Visible = false; // Disable update for API request
            } else {
                $this->_16->setFormValue($val);
            }
        }

        // Check field name 'm_16' first before field var 'x_m_16'
        $val = $CurrentForm->hasValue("m_16") ? $CurrentForm->getValue("m_16") : $CurrentForm->getValue("x_m_16");
        if (!$this->m_16->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_16->Visible = false; // Disable update for API request
            } else {
                $this->m_16->setFormValue($val, true, $validate);
            }
        }

        // Check field name '17' first before field var 'x__17'
        $val = $CurrentForm->hasValue("17") ? $CurrentForm->getValue("17") : $CurrentForm->getValue("x__17");
        if (!$this->_17->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_17->Visible = false; // Disable update for API request
            } else {
                $this->_17->setFormValue($val);
            }
        }

        // Check field name 'm_17' first before field var 'x_m_17'
        $val = $CurrentForm->hasValue("m_17") ? $CurrentForm->getValue("m_17") : $CurrentForm->getValue("x_m_17");
        if (!$this->m_17->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_17->Visible = false; // Disable update for API request
            } else {
                $this->m_17->setFormValue($val, true, $validate);
            }
        }

        // Check field name '18' first before field var 'x__18'
        $val = $CurrentForm->hasValue("18") ? $CurrentForm->getValue("18") : $CurrentForm->getValue("x__18");
        if (!$this->_18->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_18->Visible = false; // Disable update for API request
            } else {
                $this->_18->setFormValue($val);
            }
        }

        // Check field name 'm_18' first before field var 'x_m_18'
        $val = $CurrentForm->hasValue("m_18") ? $CurrentForm->getValue("m_18") : $CurrentForm->getValue("x_m_18");
        if (!$this->m_18->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_18->Visible = false; // Disable update for API request
            } else {
                $this->m_18->setFormValue($val, true, $validate);
            }
        }

        // Check field name '19' first before field var 'x__19'
        $val = $CurrentForm->hasValue("19") ? $CurrentForm->getValue("19") : $CurrentForm->getValue("x__19");
        if (!$this->_19->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_19->Visible = false; // Disable update for API request
            } else {
                $this->_19->setFormValue($val);
            }
        }

        // Check field name 'm_19' first before field var 'x_m_19'
        $val = $CurrentForm->hasValue("m_19") ? $CurrentForm->getValue("m_19") : $CurrentForm->getValue("x_m_19");
        if (!$this->m_19->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_19->Visible = false; // Disable update for API request
            } else {
                $this->m_19->setFormValue($val, true, $validate);
            }
        }

        // Check field name '20' first before field var 'x__20'
        $val = $CurrentForm->hasValue("20") ? $CurrentForm->getValue("20") : $CurrentForm->getValue("x__20");
        if (!$this->_20->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_20->Visible = false; // Disable update for API request
            } else {
                $this->_20->setFormValue($val);
            }
        }

        // Check field name 'm_20' first before field var 'x_m_20'
        $val = $CurrentForm->hasValue("m_20") ? $CurrentForm->getValue("m_20") : $CurrentForm->getValue("x_m_20");
        if (!$this->m_20->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_20->Visible = false; // Disable update for API request
            } else {
                $this->m_20->setFormValue($val, true, $validate);
            }
        }

        // Check field name '21' first before field var 'x__21'
        $val = $CurrentForm->hasValue("21") ? $CurrentForm->getValue("21") : $CurrentForm->getValue("x__21");
        if (!$this->_21->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_21->Visible = false; // Disable update for API request
            } else {
                $this->_21->setFormValue($val);
            }
        }

        // Check field name 'm_21' first before field var 'x_m_21'
        $val = $CurrentForm->hasValue("m_21") ? $CurrentForm->getValue("m_21") : $CurrentForm->getValue("x_m_21");
        if (!$this->m_21->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_21->Visible = false; // Disable update for API request
            } else {
                $this->m_21->setFormValue($val, true, $validate);
            }
        }

        // Check field name '22' first before field var 'x__22'
        $val = $CurrentForm->hasValue("22") ? $CurrentForm->getValue("22") : $CurrentForm->getValue("x__22");
        if (!$this->_22->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_22->Visible = false; // Disable update for API request
            } else {
                $this->_22->setFormValue($val);
            }
        }

        // Check field name 'm_22' first before field var 'x_m_22'
        $val = $CurrentForm->hasValue("m_22") ? $CurrentForm->getValue("m_22") : $CurrentForm->getValue("x_m_22");
        if (!$this->m_22->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_22->Visible = false; // Disable update for API request
            } else {
                $this->m_22->setFormValue($val, true, $validate);
            }
        }

        // Check field name '23' first before field var 'x__23'
        $val = $CurrentForm->hasValue("23") ? $CurrentForm->getValue("23") : $CurrentForm->getValue("x__23");
        if (!$this->_23->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_23->Visible = false; // Disable update for API request
            } else {
                $this->_23->setFormValue($val);
            }
        }

        // Check field name 'm_23' first before field var 'x_m_23'
        $val = $CurrentForm->hasValue("m_23") ? $CurrentForm->getValue("m_23") : $CurrentForm->getValue("x_m_23");
        if (!$this->m_23->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_23->Visible = false; // Disable update for API request
            } else {
                $this->m_23->setFormValue($val, true, $validate);
            }
        }

        // Check field name '24' first before field var 'x__24'
        $val = $CurrentForm->hasValue("24") ? $CurrentForm->getValue("24") : $CurrentForm->getValue("x__24");
        if (!$this->_24->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_24->Visible = false; // Disable update for API request
            } else {
                $this->_24->setFormValue($val);
            }
        }

        // Check field name 'm_24' first before field var 'x_m_24'
        $val = $CurrentForm->hasValue("m_24") ? $CurrentForm->getValue("m_24") : $CurrentForm->getValue("x_m_24");
        if (!$this->m_24->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_24->Visible = false; // Disable update for API request
            } else {
                $this->m_24->setFormValue($val, true, $validate);
            }
        }

        // Check field name '25' first before field var 'x__25'
        $val = $CurrentForm->hasValue("25") ? $CurrentForm->getValue("25") : $CurrentForm->getValue("x__25");
        if (!$this->_25->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_25->Visible = false; // Disable update for API request
            } else {
                $this->_25->setFormValue($val);
            }
        }

        // Check field name 'm_25' first before field var 'x_m_25'
        $val = $CurrentForm->hasValue("m_25") ? $CurrentForm->getValue("m_25") : $CurrentForm->getValue("x_m_25");
        if (!$this->m_25->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_25->Visible = false; // Disable update for API request
            } else {
                $this->m_25->setFormValue($val, true, $validate);
            }
        }

        // Check field name '26' first before field var 'x__26'
        $val = $CurrentForm->hasValue("26") ? $CurrentForm->getValue("26") : $CurrentForm->getValue("x__26");
        if (!$this->_26->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_26->Visible = false; // Disable update for API request
            } else {
                $this->_26->setFormValue($val);
            }
        }

        // Check field name 'm_26' first before field var 'x_m_26'
        $val = $CurrentForm->hasValue("m_26") ? $CurrentForm->getValue("m_26") : $CurrentForm->getValue("x_m_26");
        if (!$this->m_26->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_26->Visible = false; // Disable update for API request
            } else {
                $this->m_26->setFormValue($val, true, $validate);
            }
        }

        // Check field name '27' first before field var 'x__27'
        $val = $CurrentForm->hasValue("27") ? $CurrentForm->getValue("27") : $CurrentForm->getValue("x__27");
        if (!$this->_27->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_27->Visible = false; // Disable update for API request
            } else {
                $this->_27->setFormValue($val);
            }
        }

        // Check field name 'm_27' first before field var 'x_m_27'
        $val = $CurrentForm->hasValue("m_27") ? $CurrentForm->getValue("m_27") : $CurrentForm->getValue("x_m_27");
        if (!$this->m_27->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_27->Visible = false; // Disable update for API request
            } else {
                $this->m_27->setFormValue($val, true, $validate);
            }
        }

        // Check field name '28' first before field var 'x__28'
        $val = $CurrentForm->hasValue("28") ? $CurrentForm->getValue("28") : $CurrentForm->getValue("x__28");
        if (!$this->_28->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_28->Visible = false; // Disable update for API request
            } else {
                $this->_28->setFormValue($val);
            }
        }

        // Check field name 'm_28' first before field var 'x_m_28'
        $val = $CurrentForm->hasValue("m_28") ? $CurrentForm->getValue("m_28") : $CurrentForm->getValue("x_m_28");
        if (!$this->m_28->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_28->Visible = false; // Disable update for API request
            } else {
                $this->m_28->setFormValue($val, true, $validate);
            }
        }

        // Check field name '29' first before field var 'x__29'
        $val = $CurrentForm->hasValue("29") ? $CurrentForm->getValue("29") : $CurrentForm->getValue("x__29");
        if (!$this->_29->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_29->Visible = false; // Disable update for API request
            } else {
                $this->_29->setFormValue($val);
            }
        }

        // Check field name 'm_29' first before field var 'x_m_29'
        $val = $CurrentForm->hasValue("m_29") ? $CurrentForm->getValue("m_29") : $CurrentForm->getValue("x_m_29");
        if (!$this->m_29->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_29->Visible = false; // Disable update for API request
            } else {
                $this->m_29->setFormValue($val, true, $validate);
            }
        }

        // Check field name '30' first before field var 'x__30'
        $val = $CurrentForm->hasValue("30") ? $CurrentForm->getValue("30") : $CurrentForm->getValue("x__30");
        if (!$this->_30->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_30->Visible = false; // Disable update for API request
            } else {
                $this->_30->setFormValue($val);
            }
        }

        // Check field name 'm_30' first before field var 'x_m_30'
        $val = $CurrentForm->hasValue("m_30") ? $CurrentForm->getValue("m_30") : $CurrentForm->getValue("x_m_30");
        if (!$this->m_30->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_30->Visible = false; // Disable update for API request
            } else {
                $this->m_30->setFormValue($val, true, $validate);
            }
        }

        // Check field name '31' first before field var 'x__31'
        $val = $CurrentForm->hasValue("31") ? $CurrentForm->getValue("31") : $CurrentForm->getValue("x__31");
        if (!$this->_31->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_31->Visible = false; // Disable update for API request
            } else {
                $this->_31->setFormValue($val);
            }
        }

        // Check field name 'm_31' first before field var 'x_m_31'
        $val = $CurrentForm->hasValue("m_31") ? $CurrentForm->getValue("m_31") : $CurrentForm->getValue("x_m_31");
        if (!$this->m_31->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_31->Visible = false; // Disable update for API request
            } else {
                $this->m_31->setFormValue($val, true, $validate);
            }
        }

        // Check field name '32' first before field var 'x__32'
        $val = $CurrentForm->hasValue("32") ? $CurrentForm->getValue("32") : $CurrentForm->getValue("x__32");
        if (!$this->_32->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_32->Visible = false; // Disable update for API request
            } else {
                $this->_32->setFormValue($val);
            }
        }

        // Check field name 'm_32' first before field var 'x_m_32'
        $val = $CurrentForm->hasValue("m_32") ? $CurrentForm->getValue("m_32") : $CurrentForm->getValue("x_m_32");
        if (!$this->m_32->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_32->Visible = false; // Disable update for API request
            } else {
                $this->m_32->setFormValue($val, true, $validate);
            }
        }

        // Check field name '33' first before field var 'x__33'
        $val = $CurrentForm->hasValue("33") ? $CurrentForm->getValue("33") : $CurrentForm->getValue("x__33");
        if (!$this->_33->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_33->Visible = false; // Disable update for API request
            } else {
                $this->_33->setFormValue($val);
            }
        }

        // Check field name 'm_33' first before field var 'x_m_33'
        $val = $CurrentForm->hasValue("m_33") ? $CurrentForm->getValue("m_33") : $CurrentForm->getValue("x_m_33");
        if (!$this->m_33->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_33->Visible = false; // Disable update for API request
            } else {
                $this->m_33->setFormValue($val, true, $validate);
            }
        }

        // Check field name '34' first before field var 'x__34'
        $val = $CurrentForm->hasValue("34") ? $CurrentForm->getValue("34") : $CurrentForm->getValue("x__34");
        if (!$this->_34->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_34->Visible = false; // Disable update for API request
            } else {
                $this->_34->setFormValue($val);
            }
        }

        // Check field name 'm_34' first before field var 'x_m_34'
        $val = $CurrentForm->hasValue("m_34") ? $CurrentForm->getValue("m_34") : $CurrentForm->getValue("x_m_34");
        if (!$this->m_34->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_34->Visible = false; // Disable update for API request
            } else {
                $this->m_34->setFormValue($val, true, $validate);
            }
        }

        // Check field name '35' first before field var 'x__35'
        $val = $CurrentForm->hasValue("35") ? $CurrentForm->getValue("35") : $CurrentForm->getValue("x__35");
        if (!$this->_35->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_35->Visible = false; // Disable update for API request
            } else {
                $this->_35->setFormValue($val);
            }
        }

        // Check field name 'm_35' first before field var 'x_m_35'
        $val = $CurrentForm->hasValue("m_35") ? $CurrentForm->getValue("m_35") : $CurrentForm->getValue("x_m_35");
        if (!$this->m_35->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_35->Visible = false; // Disable update for API request
            } else {
                $this->m_35->setFormValue($val, true, $validate);
            }
        }

        // Check field name '36' first before field var 'x__36'
        $val = $CurrentForm->hasValue("36") ? $CurrentForm->getValue("36") : $CurrentForm->getValue("x__36");
        if (!$this->_36->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_36->Visible = false; // Disable update for API request
            } else {
                $this->_36->setFormValue($val);
            }
        }

        // Check field name 'm_36' first before field var 'x_m_36'
        $val = $CurrentForm->hasValue("m_36") ? $CurrentForm->getValue("m_36") : $CurrentForm->getValue("x_m_36");
        if (!$this->m_36->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_36->Visible = false; // Disable update for API request
            } else {
                $this->m_36->setFormValue($val, true, $validate);
            }
        }

        // Check field name '37' first before field var 'x__37'
        $val = $CurrentForm->hasValue("37") ? $CurrentForm->getValue("37") : $CurrentForm->getValue("x__37");
        if (!$this->_37->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_37->Visible = false; // Disable update for API request
            } else {
                $this->_37->setFormValue($val);
            }
        }

        // Check field name 'm_37' first before field var 'x_m_37'
        $val = $CurrentForm->hasValue("m_37") ? $CurrentForm->getValue("m_37") : $CurrentForm->getValue("x_m_37");
        if (!$this->m_37->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_37->Visible = false; // Disable update for API request
            } else {
                $this->m_37->setFormValue($val, true, $validate);
            }
        }

        // Check field name '38' first before field var 'x__38'
        $val = $CurrentForm->hasValue("38") ? $CurrentForm->getValue("38") : $CurrentForm->getValue("x__38");
        if (!$this->_38->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_38->Visible = false; // Disable update for API request
            } else {
                $this->_38->setFormValue($val);
            }
        }

        // Check field name 'm_38' first before field var 'x_m_38'
        $val = $CurrentForm->hasValue("m_38") ? $CurrentForm->getValue("m_38") : $CurrentForm->getValue("x_m_38");
        if (!$this->m_38->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_38->Visible = false; // Disable update for API request
            } else {
                $this->m_38->setFormValue($val, true, $validate);
            }
        }

        // Check field name '39' first before field var 'x__39'
        $val = $CurrentForm->hasValue("39") ? $CurrentForm->getValue("39") : $CurrentForm->getValue("x__39");
        if (!$this->_39->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_39->Visible = false; // Disable update for API request
            } else {
                $this->_39->setFormValue($val);
            }
        }

        // Check field name 'm_39' first before field var 'x_m_39'
        $val = $CurrentForm->hasValue("m_39") ? $CurrentForm->getValue("m_39") : $CurrentForm->getValue("x_m_39");
        if (!$this->m_39->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_39->Visible = false; // Disable update for API request
            } else {
                $this->m_39->setFormValue($val, true, $validate);
            }
        }

        // Check field name '40' first before field var 'x__40'
        $val = $CurrentForm->hasValue("40") ? $CurrentForm->getValue("40") : $CurrentForm->getValue("x__40");
        if (!$this->_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_40->Visible = false; // Disable update for API request
            } else {
                $this->_40->setFormValue($val);
            }
        }

        // Check field name 'm_40' first before field var 'x_m_40'
        $val = $CurrentForm->hasValue("m_40") ? $CurrentForm->getValue("m_40") : $CurrentForm->getValue("x_m_40");
        if (!$this->m_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_40->Visible = false; // Disable update for API request
            } else {
                $this->m_40->setFormValue($val, true, $validate);
            }
        }

        // Check field name '41' first before field var 'x__41'
        $val = $CurrentForm->hasValue("41") ? $CurrentForm->getValue("41") : $CurrentForm->getValue("x__41");
        if (!$this->_41->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_41->Visible = false; // Disable update for API request
            } else {
                $this->_41->setFormValue($val);
            }
        }

        // Check field name 'm_41' first before field var 'x_m_41'
        $val = $CurrentForm->hasValue("m_41") ? $CurrentForm->getValue("m_41") : $CurrentForm->getValue("x_m_41");
        if (!$this->m_41->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_41->Visible = false; // Disable update for API request
            } else {
                $this->m_41->setFormValue($val, true, $validate);
            }
        }

        // Check field name '42' first before field var 'x__42'
        $val = $CurrentForm->hasValue("42") ? $CurrentForm->getValue("42") : $CurrentForm->getValue("x__42");
        if (!$this->_42->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_42->Visible = false; // Disable update for API request
            } else {
                $this->_42->setFormValue($val);
            }
        }

        // Check field name 'm_42' first before field var 'x_m_42'
        $val = $CurrentForm->hasValue("m_42") ? $CurrentForm->getValue("m_42") : $CurrentForm->getValue("x_m_42");
        if (!$this->m_42->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_42->Visible = false; // Disable update for API request
            } else {
                $this->m_42->setFormValue($val, true, $validate);
            }
        }

        // Check field name '43' first before field var 'x__43'
        $val = $CurrentForm->hasValue("43") ? $CurrentForm->getValue("43") : $CurrentForm->getValue("x__43");
        if (!$this->_43->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_43->Visible = false; // Disable update for API request
            } else {
                $this->_43->setFormValue($val);
            }
        }

        // Check field name 'm_43' first before field var 'x_m_43'
        $val = $CurrentForm->hasValue("m_43") ? $CurrentForm->getValue("m_43") : $CurrentForm->getValue("x_m_43");
        if (!$this->m_43->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_43->Visible = false; // Disable update for API request
            } else {
                $this->m_43->setFormValue($val, true, $validate);
            }
        }

        // Check field name '44' first before field var 'x__44'
        $val = $CurrentForm->hasValue("44") ? $CurrentForm->getValue("44") : $CurrentForm->getValue("x__44");
        if (!$this->_44->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_44->Visible = false; // Disable update for API request
            } else {
                $this->_44->setFormValue($val);
            }
        }

        // Check field name 'm_44' first before field var 'x_m_44'
        $val = $CurrentForm->hasValue("m_44") ? $CurrentForm->getValue("m_44") : $CurrentForm->getValue("x_m_44");
        if (!$this->m_44->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_44->Visible = false; // Disable update for API request
            } else {
                $this->m_44->setFormValue($val, true, $validate);
            }
        }

        // Check field name '45' first before field var 'x__45'
        $val = $CurrentForm->hasValue("45") ? $CurrentForm->getValue("45") : $CurrentForm->getValue("x__45");
        if (!$this->_45->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_45->Visible = false; // Disable update for API request
            } else {
                $this->_45->setFormValue($val);
            }
        }

        // Check field name 'm_45' first before field var 'x_m_45'
        $val = $CurrentForm->hasValue("m_45") ? $CurrentForm->getValue("m_45") : $CurrentForm->getValue("x_m_45");
        if (!$this->m_45->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_45->Visible = false; // Disable update for API request
            } else {
                $this->m_45->setFormValue($val, true, $validate);
            }
        }

        // Check field name '46' first before field var 'x__46'
        $val = $CurrentForm->hasValue("46") ? $CurrentForm->getValue("46") : $CurrentForm->getValue("x__46");
        if (!$this->_46->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_46->Visible = false; // Disable update for API request
            } else {
                $this->_46->setFormValue($val);
            }
        }

        // Check field name 'm_46' first before field var 'x_m_46'
        $val = $CurrentForm->hasValue("m_46") ? $CurrentForm->getValue("m_46") : $CurrentForm->getValue("x_m_46");
        if (!$this->m_46->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_46->Visible = false; // Disable update for API request
            } else {
                $this->m_46->setFormValue($val, true, $validate);
            }
        }

        // Check field name '47' first before field var 'x__47'
        $val = $CurrentForm->hasValue("47") ? $CurrentForm->getValue("47") : $CurrentForm->getValue("x__47");
        if (!$this->_47->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_47->Visible = false; // Disable update for API request
            } else {
                $this->_47->setFormValue($val);
            }
        }

        // Check field name 'm_47' first before field var 'x_m_47'
        $val = $CurrentForm->hasValue("m_47") ? $CurrentForm->getValue("m_47") : $CurrentForm->getValue("x_m_47");
        if (!$this->m_47->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_47->Visible = false; // Disable update for API request
            } else {
                $this->m_47->setFormValue($val, true, $validate);
            }
        }

        // Check field name '48' first before field var 'x__48'
        $val = $CurrentForm->hasValue("48") ? $CurrentForm->getValue("48") : $CurrentForm->getValue("x__48");
        if (!$this->_48->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_48->Visible = false; // Disable update for API request
            } else {
                $this->_48->setFormValue($val);
            }
        }

        // Check field name 'm_48' first before field var 'x_m_48'
        $val = $CurrentForm->hasValue("m_48") ? $CurrentForm->getValue("m_48") : $CurrentForm->getValue("x_m_48");
        if (!$this->m_48->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_48->Visible = false; // Disable update for API request
            } else {
                $this->m_48->setFormValue($val, true, $validate);
            }
        }

        // Check field name '49' first before field var 'x__49'
        $val = $CurrentForm->hasValue("49") ? $CurrentForm->getValue("49") : $CurrentForm->getValue("x__49");
        if (!$this->_49->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_49->Visible = false; // Disable update for API request
            } else {
                $this->_49->setFormValue($val);
            }
        }

        // Check field name 'm_49' first before field var 'x_m_49'
        $val = $CurrentForm->hasValue("m_49") ? $CurrentForm->getValue("m_49") : $CurrentForm->getValue("x_m_49");
        if (!$this->m_49->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_49->Visible = false; // Disable update for API request
            } else {
                $this->m_49->setFormValue($val, true, $validate);
            }
        }

        // Check field name '50' first before field var 'x__50'
        $val = $CurrentForm->hasValue("50") ? $CurrentForm->getValue("50") : $CurrentForm->getValue("x__50");
        if (!$this->_50->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_50->Visible = false; // Disable update for API request
            } else {
                $this->_50->setFormValue($val);
            }
        }

        // Check field name 'm_50' first before field var 'x_m_50'
        $val = $CurrentForm->hasValue("m_50") ? $CurrentForm->getValue("m_50") : $CurrentForm->getValue("x_m_50");
        if (!$this->m_50->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_50->Visible = false; // Disable update for API request
            } else {
                $this->m_50->setFormValue($val, true, $validate);
            }
        }

        // Check field name '51' first before field var 'x__51'
        $val = $CurrentForm->hasValue("51") ? $CurrentForm->getValue("51") : $CurrentForm->getValue("x__51");
        if (!$this->_51->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_51->Visible = false; // Disable update for API request
            } else {
                $this->_51->setFormValue($val);
            }
        }

        // Check field name 'm_51' first before field var 'x_m_51'
        $val = $CurrentForm->hasValue("m_51") ? $CurrentForm->getValue("m_51") : $CurrentForm->getValue("x_m_51");
        if (!$this->m_51->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_51->Visible = false; // Disable update for API request
            } else {
                $this->m_51->setFormValue($val, true, $validate);
            }
        }

        // Check field name '52' first before field var 'x__52'
        $val = $CurrentForm->hasValue("52") ? $CurrentForm->getValue("52") : $CurrentForm->getValue("x__52");
        if (!$this->_52->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_52->Visible = false; // Disable update for API request
            } else {
                $this->_52->setFormValue($val);
            }
        }

        // Check field name 'm_52' first before field var 'x_m_52'
        $val = $CurrentForm->hasValue("m_52") ? $CurrentForm->getValue("m_52") : $CurrentForm->getValue("x_m_52");
        if (!$this->m_52->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_52->Visible = false; // Disable update for API request
            } else {
                $this->m_52->setFormValue($val, true, $validate);
            }
        }

        // Check field name '53' first before field var 'x__53'
        $val = $CurrentForm->hasValue("53") ? $CurrentForm->getValue("53") : $CurrentForm->getValue("x__53");
        if (!$this->_53->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_53->Visible = false; // Disable update for API request
            } else {
                $this->_53->setFormValue($val);
            }
        }

        // Check field name 'm_53' first before field var 'x_m_53'
        $val = $CurrentForm->hasValue("m_53") ? $CurrentForm->getValue("m_53") : $CurrentForm->getValue("x_m_53");
        if (!$this->m_53->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_53->Visible = false; // Disable update for API request
            } else {
                $this->m_53->setFormValue($val, true, $validate);
            }
        }

        // Check field name '54' first before field var 'x__54'
        $val = $CurrentForm->hasValue("54") ? $CurrentForm->getValue("54") : $CurrentForm->getValue("x__54");
        if (!$this->_54->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_54->Visible = false; // Disable update for API request
            } else {
                $this->_54->setFormValue($val);
            }
        }

        // Check field name 'm_54' first before field var 'x_m_54'
        $val = $CurrentForm->hasValue("m_54") ? $CurrentForm->getValue("m_54") : $CurrentForm->getValue("x_m_54");
        if (!$this->m_54->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_54->Visible = false; // Disable update for API request
            } else {
                $this->m_54->setFormValue($val, true, $validate);
            }
        }

        // Check field name '55' first before field var 'x__55'
        $val = $CurrentForm->hasValue("55") ? $CurrentForm->getValue("55") : $CurrentForm->getValue("x__55");
        if (!$this->_55->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_55->Visible = false; // Disable update for API request
            } else {
                $this->_55->setFormValue($val);
            }
        }

        // Check field name 'm_55' first before field var 'x_m_55'
        $val = $CurrentForm->hasValue("m_55") ? $CurrentForm->getValue("m_55") : $CurrentForm->getValue("x_m_55");
        if (!$this->m_55->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_55->Visible = false; // Disable update for API request
            } else {
                $this->m_55->setFormValue($val, true, $validate);
            }
        }

        // Check field name '56' first before field var 'x__56'
        $val = $CurrentForm->hasValue("56") ? $CurrentForm->getValue("56") : $CurrentForm->getValue("x__56");
        if (!$this->_56->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_56->Visible = false; // Disable update for API request
            } else {
                $this->_56->setFormValue($val);
            }
        }

        // Check field name 'm_56' first before field var 'x_m_56'
        $val = $CurrentForm->hasValue("m_56") ? $CurrentForm->getValue("m_56") : $CurrentForm->getValue("x_m_56");
        if (!$this->m_56->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_56->Visible = false; // Disable update for API request
            } else {
                $this->m_56->setFormValue($val, true, $validate);
            }
        }

        // Check field name '57' first before field var 'x__57'
        $val = $CurrentForm->hasValue("57") ? $CurrentForm->getValue("57") : $CurrentForm->getValue("x__57");
        if (!$this->_57->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_57->Visible = false; // Disable update for API request
            } else {
                $this->_57->setFormValue($val);
            }
        }

        // Check field name 'm_57' first before field var 'x_m_57'
        $val = $CurrentForm->hasValue("m_57") ? $CurrentForm->getValue("m_57") : $CurrentForm->getValue("x_m_57");
        if (!$this->m_57->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_57->Visible = false; // Disable update for API request
            } else {
                $this->m_57->setFormValue($val, true, $validate);
            }
        }

        // Check field name '58' first before field var 'x__58'
        $val = $CurrentForm->hasValue("58") ? $CurrentForm->getValue("58") : $CurrentForm->getValue("x__58");
        if (!$this->_58->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_58->Visible = false; // Disable update for API request
            } else {
                $this->_58->setFormValue($val);
            }
        }

        // Check field name 'm_58' first before field var 'x_m_58'
        $val = $CurrentForm->hasValue("m_58") ? $CurrentForm->getValue("m_58") : $CurrentForm->getValue("x_m_58");
        if (!$this->m_58->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_58->Visible = false; // Disable update for API request
            } else {
                $this->m_58->setFormValue($val, true, $validate);
            }
        }

        // Check field name '59' first before field var 'x__59'
        $val = $CurrentForm->hasValue("59") ? $CurrentForm->getValue("59") : $CurrentForm->getValue("x__59");
        if (!$this->_59->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_59->Visible = false; // Disable update for API request
            } else {
                $this->_59->setFormValue($val);
            }
        }

        // Check field name 'm_59' first before field var 'x_m_59'
        $val = $CurrentForm->hasValue("m_59") ? $CurrentForm->getValue("m_59") : $CurrentForm->getValue("x_m_59");
        if (!$this->m_59->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_59->Visible = false; // Disable update for API request
            } else {
                $this->m_59->setFormValue($val, true, $validate);
            }
        }

        // Check field name '60' first before field var 'x__60'
        $val = $CurrentForm->hasValue("60") ? $CurrentForm->getValue("60") : $CurrentForm->getValue("x__60");
        if (!$this->_60->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_60->Visible = false; // Disable update for API request
            } else {
                $this->_60->setFormValue($val);
            }
        }

        // Check field name 'm_60' first before field var 'x_m_60'
        $val = $CurrentForm->hasValue("m_60") ? $CurrentForm->getValue("m_60") : $CurrentForm->getValue("x_m_60");
        if (!$this->m_60->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_60->Visible = false; // Disable update for API request
            } else {
                $this->m_60->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->omr_image->OldUploadPath = $this->omr_image->getUploadPath(); // PHP
		$this->omr_image->UploadPath = $this->omr_image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->roll_no->CurrentValue = $this->roll_no->FormValue;
        $this->test_id->CurrentValue = $this->test_id->FormValue;
        $this->total->CurrentValue = $this->total->FormValue;
        $this->percent->CurrentValue = $this->percent->FormValue;
        $this->s_1->CurrentValue = $this->s_1->FormValue;
        $this->s_2->CurrentValue = $this->s_2->FormValue;
        $this->s_3->CurrentValue = $this->s_3->FormValue;
        $this->s_4->CurrentValue = $this->s_4->FormValue;
        $this->s_5->CurrentValue = $this->s_5->FormValue;
        $this->_1->CurrentValue = $this->_1->FormValue;
        $this->m_1->CurrentValue = $this->m_1->FormValue;
        $this->_2->CurrentValue = $this->_2->FormValue;
        $this->m_2->CurrentValue = $this->m_2->FormValue;
        $this->_3->CurrentValue = $this->_3->FormValue;
        $this->m_3->CurrentValue = $this->m_3->FormValue;
        $this->_4->CurrentValue = $this->_4->FormValue;
        $this->m_4->CurrentValue = $this->m_4->FormValue;
        $this->_5->CurrentValue = $this->_5->FormValue;
        $this->m_5->CurrentValue = $this->m_5->FormValue;
        $this->_6->CurrentValue = $this->_6->FormValue;
        $this->m_6->CurrentValue = $this->m_6->FormValue;
        $this->_7->CurrentValue = $this->_7->FormValue;
        $this->m_7->CurrentValue = $this->m_7->FormValue;
        $this->_8->CurrentValue = $this->_8->FormValue;
        $this->m_8->CurrentValue = $this->m_8->FormValue;
        $this->_9->CurrentValue = $this->_9->FormValue;
        $this->m_9->CurrentValue = $this->m_9->FormValue;
        $this->_10->CurrentValue = $this->_10->FormValue;
        $this->m_10->CurrentValue = $this->m_10->FormValue;
        $this->_11->CurrentValue = $this->_11->FormValue;
        $this->m_11->CurrentValue = $this->m_11->FormValue;
        $this->_12->CurrentValue = $this->_12->FormValue;
        $this->m_12->CurrentValue = $this->m_12->FormValue;
        $this->_13->CurrentValue = $this->_13->FormValue;
        $this->m_13->CurrentValue = $this->m_13->FormValue;
        $this->_14->CurrentValue = $this->_14->FormValue;
        $this->m_14->CurrentValue = $this->m_14->FormValue;
        $this->_15->CurrentValue = $this->_15->FormValue;
        $this->m_15->CurrentValue = $this->m_15->FormValue;
        $this->_16->CurrentValue = $this->_16->FormValue;
        $this->m_16->CurrentValue = $this->m_16->FormValue;
        $this->_17->CurrentValue = $this->_17->FormValue;
        $this->m_17->CurrentValue = $this->m_17->FormValue;
        $this->_18->CurrentValue = $this->_18->FormValue;
        $this->m_18->CurrentValue = $this->m_18->FormValue;
        $this->_19->CurrentValue = $this->_19->FormValue;
        $this->m_19->CurrentValue = $this->m_19->FormValue;
        $this->_20->CurrentValue = $this->_20->FormValue;
        $this->m_20->CurrentValue = $this->m_20->FormValue;
        $this->_21->CurrentValue = $this->_21->FormValue;
        $this->m_21->CurrentValue = $this->m_21->FormValue;
        $this->_22->CurrentValue = $this->_22->FormValue;
        $this->m_22->CurrentValue = $this->m_22->FormValue;
        $this->_23->CurrentValue = $this->_23->FormValue;
        $this->m_23->CurrentValue = $this->m_23->FormValue;
        $this->_24->CurrentValue = $this->_24->FormValue;
        $this->m_24->CurrentValue = $this->m_24->FormValue;
        $this->_25->CurrentValue = $this->_25->FormValue;
        $this->m_25->CurrentValue = $this->m_25->FormValue;
        $this->_26->CurrentValue = $this->_26->FormValue;
        $this->m_26->CurrentValue = $this->m_26->FormValue;
        $this->_27->CurrentValue = $this->_27->FormValue;
        $this->m_27->CurrentValue = $this->m_27->FormValue;
        $this->_28->CurrentValue = $this->_28->FormValue;
        $this->m_28->CurrentValue = $this->m_28->FormValue;
        $this->_29->CurrentValue = $this->_29->FormValue;
        $this->m_29->CurrentValue = $this->m_29->FormValue;
        $this->_30->CurrentValue = $this->_30->FormValue;
        $this->m_30->CurrentValue = $this->m_30->FormValue;
        $this->_31->CurrentValue = $this->_31->FormValue;
        $this->m_31->CurrentValue = $this->m_31->FormValue;
        $this->_32->CurrentValue = $this->_32->FormValue;
        $this->m_32->CurrentValue = $this->m_32->FormValue;
        $this->_33->CurrentValue = $this->_33->FormValue;
        $this->m_33->CurrentValue = $this->m_33->FormValue;
        $this->_34->CurrentValue = $this->_34->FormValue;
        $this->m_34->CurrentValue = $this->m_34->FormValue;
        $this->_35->CurrentValue = $this->_35->FormValue;
        $this->m_35->CurrentValue = $this->m_35->FormValue;
        $this->_36->CurrentValue = $this->_36->FormValue;
        $this->m_36->CurrentValue = $this->m_36->FormValue;
        $this->_37->CurrentValue = $this->_37->FormValue;
        $this->m_37->CurrentValue = $this->m_37->FormValue;
        $this->_38->CurrentValue = $this->_38->FormValue;
        $this->m_38->CurrentValue = $this->m_38->FormValue;
        $this->_39->CurrentValue = $this->_39->FormValue;
        $this->m_39->CurrentValue = $this->m_39->FormValue;
        $this->_40->CurrentValue = $this->_40->FormValue;
        $this->m_40->CurrentValue = $this->m_40->FormValue;
        $this->_41->CurrentValue = $this->_41->FormValue;
        $this->m_41->CurrentValue = $this->m_41->FormValue;
        $this->_42->CurrentValue = $this->_42->FormValue;
        $this->m_42->CurrentValue = $this->m_42->FormValue;
        $this->_43->CurrentValue = $this->_43->FormValue;
        $this->m_43->CurrentValue = $this->m_43->FormValue;
        $this->_44->CurrentValue = $this->_44->FormValue;
        $this->m_44->CurrentValue = $this->m_44->FormValue;
        $this->_45->CurrentValue = $this->_45->FormValue;
        $this->m_45->CurrentValue = $this->m_45->FormValue;
        $this->_46->CurrentValue = $this->_46->FormValue;
        $this->m_46->CurrentValue = $this->m_46->FormValue;
        $this->_47->CurrentValue = $this->_47->FormValue;
        $this->m_47->CurrentValue = $this->m_47->FormValue;
        $this->_48->CurrentValue = $this->_48->FormValue;
        $this->m_48->CurrentValue = $this->m_48->FormValue;
        $this->_49->CurrentValue = $this->_49->FormValue;
        $this->m_49->CurrentValue = $this->m_49->FormValue;
        $this->_50->CurrentValue = $this->_50->FormValue;
        $this->m_50->CurrentValue = $this->m_50->FormValue;
        $this->_51->CurrentValue = $this->_51->FormValue;
        $this->m_51->CurrentValue = $this->m_51->FormValue;
        $this->_52->CurrentValue = $this->_52->FormValue;
        $this->m_52->CurrentValue = $this->m_52->FormValue;
        $this->_53->CurrentValue = $this->_53->FormValue;
        $this->m_53->CurrentValue = $this->m_53->FormValue;
        $this->_54->CurrentValue = $this->_54->FormValue;
        $this->m_54->CurrentValue = $this->m_54->FormValue;
        $this->_55->CurrentValue = $this->_55->FormValue;
        $this->m_55->CurrentValue = $this->m_55->FormValue;
        $this->_56->CurrentValue = $this->_56->FormValue;
        $this->m_56->CurrentValue = $this->m_56->FormValue;
        $this->_57->CurrentValue = $this->_57->FormValue;
        $this->m_57->CurrentValue = $this->m_57->FormValue;
        $this->_58->CurrentValue = $this->_58->FormValue;
        $this->m_58->CurrentValue = $this->m_58->FormValue;
        $this->_59->CurrentValue = $this->_59->FormValue;
        $this->m_59->CurrentValue = $this->m_59->FormValue;
        $this->_60->CurrentValue = $this->_60->FormValue;
        $this->m_60->CurrentValue = $this->m_60->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->roll_no->setDbValue($row['roll_no']);
        $this->test_id->setDbValue($row['test_id']);
        $this->total->setDbValue($row['total']);
        $this->percent->setDbValue($row['percent']);
        $this->s_1->setDbValue($row['s_1']);
        $this->s_2->setDbValue($row['s_2']);
        $this->s_3->setDbValue($row['s_3']);
        $this->s_4->setDbValue($row['s_4']);
        $this->s_5->setDbValue($row['s_5']);
        $this->omr_image->Upload->DbValue = $row['omr_image'];
        $this->omr_image->setDbValue($this->omr_image->Upload->DbValue);
        $this->_1->setDbValue($row['1']);
        $this->m_1->setDbValue($row['m_1']);
        $this->_2->setDbValue($row['2']);
        $this->m_2->setDbValue($row['m_2']);
        $this->_3->setDbValue($row['3']);
        $this->m_3->setDbValue($row['m_3']);
        $this->_4->setDbValue($row['4']);
        $this->m_4->setDbValue($row['m_4']);
        $this->_5->setDbValue($row['5']);
        $this->m_5->setDbValue($row['m_5']);
        $this->_6->setDbValue($row['6']);
        $this->m_6->setDbValue($row['m_6']);
        $this->_7->setDbValue($row['7']);
        $this->m_7->setDbValue($row['m_7']);
        $this->_8->setDbValue($row['8']);
        $this->m_8->setDbValue($row['m_8']);
        $this->_9->setDbValue($row['9']);
        $this->m_9->setDbValue($row['m_9']);
        $this->_10->setDbValue($row['10']);
        $this->m_10->setDbValue($row['m_10']);
        $this->_11->setDbValue($row['11']);
        $this->m_11->setDbValue($row['m_11']);
        $this->_12->setDbValue($row['12']);
        $this->m_12->setDbValue($row['m_12']);
        $this->_13->setDbValue($row['13']);
        $this->m_13->setDbValue($row['m_13']);
        $this->_14->setDbValue($row['14']);
        $this->m_14->setDbValue($row['m_14']);
        $this->_15->setDbValue($row['15']);
        $this->m_15->setDbValue($row['m_15']);
        $this->_16->setDbValue($row['16']);
        $this->m_16->setDbValue($row['m_16']);
        $this->_17->setDbValue($row['17']);
        $this->m_17->setDbValue($row['m_17']);
        $this->_18->setDbValue($row['18']);
        $this->m_18->setDbValue($row['m_18']);
        $this->_19->setDbValue($row['19']);
        $this->m_19->setDbValue($row['m_19']);
        $this->_20->setDbValue($row['20']);
        $this->m_20->setDbValue($row['m_20']);
        $this->_21->setDbValue($row['21']);
        $this->m_21->setDbValue($row['m_21']);
        $this->_22->setDbValue($row['22']);
        $this->m_22->setDbValue($row['m_22']);
        $this->_23->setDbValue($row['23']);
        $this->m_23->setDbValue($row['m_23']);
        $this->_24->setDbValue($row['24']);
        $this->m_24->setDbValue($row['m_24']);
        $this->_25->setDbValue($row['25']);
        $this->m_25->setDbValue($row['m_25']);
        $this->_26->setDbValue($row['26']);
        $this->m_26->setDbValue($row['m_26']);
        $this->_27->setDbValue($row['27']);
        $this->m_27->setDbValue($row['m_27']);
        $this->_28->setDbValue($row['28']);
        $this->m_28->setDbValue($row['m_28']);
        $this->_29->setDbValue($row['29']);
        $this->m_29->setDbValue($row['m_29']);
        $this->_30->setDbValue($row['30']);
        $this->m_30->setDbValue($row['m_30']);
        $this->_31->setDbValue($row['31']);
        $this->m_31->setDbValue($row['m_31']);
        $this->_32->setDbValue($row['32']);
        $this->m_32->setDbValue($row['m_32']);
        $this->_33->setDbValue($row['33']);
        $this->m_33->setDbValue($row['m_33']);
        $this->_34->setDbValue($row['34']);
        $this->m_34->setDbValue($row['m_34']);
        $this->_35->setDbValue($row['35']);
        $this->m_35->setDbValue($row['m_35']);
        $this->_36->setDbValue($row['36']);
        $this->m_36->setDbValue($row['m_36']);
        $this->_37->setDbValue($row['37']);
        $this->m_37->setDbValue($row['m_37']);
        $this->_38->setDbValue($row['38']);
        $this->m_38->setDbValue($row['m_38']);
        $this->_39->setDbValue($row['39']);
        $this->m_39->setDbValue($row['m_39']);
        $this->_40->setDbValue($row['40']);
        $this->m_40->setDbValue($row['m_40']);
        $this->_41->setDbValue($row['41']);
        $this->m_41->setDbValue($row['m_41']);
        $this->_42->setDbValue($row['42']);
        $this->m_42->setDbValue($row['m_42']);
        $this->_43->setDbValue($row['43']);
        $this->m_43->setDbValue($row['m_43']);
        $this->_44->setDbValue($row['44']);
        $this->m_44->setDbValue($row['m_44']);
        $this->_45->setDbValue($row['45']);
        $this->m_45->setDbValue($row['m_45']);
        $this->_46->setDbValue($row['46']);
        $this->m_46->setDbValue($row['m_46']);
        $this->_47->setDbValue($row['47']);
        $this->m_47->setDbValue($row['m_47']);
        $this->_48->setDbValue($row['48']);
        $this->m_48->setDbValue($row['m_48']);
        $this->_49->setDbValue($row['49']);
        $this->m_49->setDbValue($row['m_49']);
        $this->_50->setDbValue($row['50']);
        $this->m_50->setDbValue($row['m_50']);
        $this->_51->setDbValue($row['51']);
        $this->m_51->setDbValue($row['m_51']);
        $this->_52->setDbValue($row['52']);
        $this->m_52->setDbValue($row['m_52']);
        $this->_53->setDbValue($row['53']);
        $this->m_53->setDbValue($row['m_53']);
        $this->_54->setDbValue($row['54']);
        $this->m_54->setDbValue($row['m_54']);
        $this->_55->setDbValue($row['55']);
        $this->m_55->setDbValue($row['m_55']);
        $this->_56->setDbValue($row['56']);
        $this->m_56->setDbValue($row['m_56']);
        $this->_57->setDbValue($row['57']);
        $this->m_57->setDbValue($row['m_57']);
        $this->_58->setDbValue($row['58']);
        $this->m_58->setDbValue($row['m_58']);
        $this->_59->setDbValue($row['59']);
        $this->m_59->setDbValue($row['m_59']);
        $this->_60->setDbValue($row['60']);
        $this->m_60->setDbValue($row['m_60']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['roll_no'] = $this->roll_no->DefaultValue;
        $row['test_id'] = $this->test_id->DefaultValue;
        $row['total'] = $this->total->DefaultValue;
        $row['percent'] = $this->percent->DefaultValue;
        $row['s_1'] = $this->s_1->DefaultValue;
        $row['s_2'] = $this->s_2->DefaultValue;
        $row['s_3'] = $this->s_3->DefaultValue;
        $row['s_4'] = $this->s_4->DefaultValue;
        $row['s_5'] = $this->s_5->DefaultValue;
        $row['omr_image'] = $this->omr_image->DefaultValue;
        $row['1'] = $this->_1->DefaultValue;
        $row['m_1'] = $this->m_1->DefaultValue;
        $row['2'] = $this->_2->DefaultValue;
        $row['m_2'] = $this->m_2->DefaultValue;
        $row['3'] = $this->_3->DefaultValue;
        $row['m_3'] = $this->m_3->DefaultValue;
        $row['4'] = $this->_4->DefaultValue;
        $row['m_4'] = $this->m_4->DefaultValue;
        $row['5'] = $this->_5->DefaultValue;
        $row['m_5'] = $this->m_5->DefaultValue;
        $row['6'] = $this->_6->DefaultValue;
        $row['m_6'] = $this->m_6->DefaultValue;
        $row['7'] = $this->_7->DefaultValue;
        $row['m_7'] = $this->m_7->DefaultValue;
        $row['8'] = $this->_8->DefaultValue;
        $row['m_8'] = $this->m_8->DefaultValue;
        $row['9'] = $this->_9->DefaultValue;
        $row['m_9'] = $this->m_9->DefaultValue;
        $row['10'] = $this->_10->DefaultValue;
        $row['m_10'] = $this->m_10->DefaultValue;
        $row['11'] = $this->_11->DefaultValue;
        $row['m_11'] = $this->m_11->DefaultValue;
        $row['12'] = $this->_12->DefaultValue;
        $row['m_12'] = $this->m_12->DefaultValue;
        $row['13'] = $this->_13->DefaultValue;
        $row['m_13'] = $this->m_13->DefaultValue;
        $row['14'] = $this->_14->DefaultValue;
        $row['m_14'] = $this->m_14->DefaultValue;
        $row['15'] = $this->_15->DefaultValue;
        $row['m_15'] = $this->m_15->DefaultValue;
        $row['16'] = $this->_16->DefaultValue;
        $row['m_16'] = $this->m_16->DefaultValue;
        $row['17'] = $this->_17->DefaultValue;
        $row['m_17'] = $this->m_17->DefaultValue;
        $row['18'] = $this->_18->DefaultValue;
        $row['m_18'] = $this->m_18->DefaultValue;
        $row['19'] = $this->_19->DefaultValue;
        $row['m_19'] = $this->m_19->DefaultValue;
        $row['20'] = $this->_20->DefaultValue;
        $row['m_20'] = $this->m_20->DefaultValue;
        $row['21'] = $this->_21->DefaultValue;
        $row['m_21'] = $this->m_21->DefaultValue;
        $row['22'] = $this->_22->DefaultValue;
        $row['m_22'] = $this->m_22->DefaultValue;
        $row['23'] = $this->_23->DefaultValue;
        $row['m_23'] = $this->m_23->DefaultValue;
        $row['24'] = $this->_24->DefaultValue;
        $row['m_24'] = $this->m_24->DefaultValue;
        $row['25'] = $this->_25->DefaultValue;
        $row['m_25'] = $this->m_25->DefaultValue;
        $row['26'] = $this->_26->DefaultValue;
        $row['m_26'] = $this->m_26->DefaultValue;
        $row['27'] = $this->_27->DefaultValue;
        $row['m_27'] = $this->m_27->DefaultValue;
        $row['28'] = $this->_28->DefaultValue;
        $row['m_28'] = $this->m_28->DefaultValue;
        $row['29'] = $this->_29->DefaultValue;
        $row['m_29'] = $this->m_29->DefaultValue;
        $row['30'] = $this->_30->DefaultValue;
        $row['m_30'] = $this->m_30->DefaultValue;
        $row['31'] = $this->_31->DefaultValue;
        $row['m_31'] = $this->m_31->DefaultValue;
        $row['32'] = $this->_32->DefaultValue;
        $row['m_32'] = $this->m_32->DefaultValue;
        $row['33'] = $this->_33->DefaultValue;
        $row['m_33'] = $this->m_33->DefaultValue;
        $row['34'] = $this->_34->DefaultValue;
        $row['m_34'] = $this->m_34->DefaultValue;
        $row['35'] = $this->_35->DefaultValue;
        $row['m_35'] = $this->m_35->DefaultValue;
        $row['36'] = $this->_36->DefaultValue;
        $row['m_36'] = $this->m_36->DefaultValue;
        $row['37'] = $this->_37->DefaultValue;
        $row['m_37'] = $this->m_37->DefaultValue;
        $row['38'] = $this->_38->DefaultValue;
        $row['m_38'] = $this->m_38->DefaultValue;
        $row['39'] = $this->_39->DefaultValue;
        $row['m_39'] = $this->m_39->DefaultValue;
        $row['40'] = $this->_40->DefaultValue;
        $row['m_40'] = $this->m_40->DefaultValue;
        $row['41'] = $this->_41->DefaultValue;
        $row['m_41'] = $this->m_41->DefaultValue;
        $row['42'] = $this->_42->DefaultValue;
        $row['m_42'] = $this->m_42->DefaultValue;
        $row['43'] = $this->_43->DefaultValue;
        $row['m_43'] = $this->m_43->DefaultValue;
        $row['44'] = $this->_44->DefaultValue;
        $row['m_44'] = $this->m_44->DefaultValue;
        $row['45'] = $this->_45->DefaultValue;
        $row['m_45'] = $this->m_45->DefaultValue;
        $row['46'] = $this->_46->DefaultValue;
        $row['m_46'] = $this->m_46->DefaultValue;
        $row['47'] = $this->_47->DefaultValue;
        $row['m_47'] = $this->m_47->DefaultValue;
        $row['48'] = $this->_48->DefaultValue;
        $row['m_48'] = $this->m_48->DefaultValue;
        $row['49'] = $this->_49->DefaultValue;
        $row['m_49'] = $this->m_49->DefaultValue;
        $row['50'] = $this->_50->DefaultValue;
        $row['m_50'] = $this->m_50->DefaultValue;
        $row['51'] = $this->_51->DefaultValue;
        $row['m_51'] = $this->m_51->DefaultValue;
        $row['52'] = $this->_52->DefaultValue;
        $row['m_52'] = $this->m_52->DefaultValue;
        $row['53'] = $this->_53->DefaultValue;
        $row['m_53'] = $this->m_53->DefaultValue;
        $row['54'] = $this->_54->DefaultValue;
        $row['m_54'] = $this->m_54->DefaultValue;
        $row['55'] = $this->_55->DefaultValue;
        $row['m_55'] = $this->m_55->DefaultValue;
        $row['56'] = $this->_56->DefaultValue;
        $row['m_56'] = $this->m_56->DefaultValue;
        $row['57'] = $this->_57->DefaultValue;
        $row['m_57'] = $this->m_57->DefaultValue;
        $row['58'] = $this->_58->DefaultValue;
        $row['m_58'] = $this->m_58->DefaultValue;
        $row['59'] = $this->_59->DefaultValue;
        $row['m_59'] = $this->m_59->DefaultValue;
        $row['60'] = $this->_60->DefaultValue;
        $row['m_60'] = $this->m_60->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // roll_no
        $this->roll_no->RowCssClass = "row";

        // test_id
        $this->test_id->RowCssClass = "row";

        // total
        $this->total->RowCssClass = "row";

        // percent
        $this->percent->RowCssClass = "row";

        // s_1
        $this->s_1->RowCssClass = "row";

        // s_2
        $this->s_2->RowCssClass = "row";

        // s_3
        $this->s_3->RowCssClass = "row";

        // s_4
        $this->s_4->RowCssClass = "row";

        // s_5
        $this->s_5->RowCssClass = "row";

        // omr_image
        $this->omr_image->RowCssClass = "row";

        // 1
        $this->_1->RowCssClass = "row";

        // m_1
        $this->m_1->RowCssClass = "row";

        // 2
        $this->_2->RowCssClass = "row";

        // m_2
        $this->m_2->RowCssClass = "row";

        // 3
        $this->_3->RowCssClass = "row";

        // m_3
        $this->m_3->RowCssClass = "row";

        // 4
        $this->_4->RowCssClass = "row";

        // m_4
        $this->m_4->RowCssClass = "row";

        // 5
        $this->_5->RowCssClass = "row";

        // m_5
        $this->m_5->RowCssClass = "row";

        // 6
        $this->_6->RowCssClass = "row";

        // m_6
        $this->m_6->RowCssClass = "row";

        // 7
        $this->_7->RowCssClass = "row";

        // m_7
        $this->m_7->RowCssClass = "row";

        // 8
        $this->_8->RowCssClass = "row";

        // m_8
        $this->m_8->RowCssClass = "row";

        // 9
        $this->_9->RowCssClass = "row";

        // m_9
        $this->m_9->RowCssClass = "row";

        // 10
        $this->_10->RowCssClass = "row";

        // m_10
        $this->m_10->RowCssClass = "row";

        // 11
        $this->_11->RowCssClass = "row";

        // m_11
        $this->m_11->RowCssClass = "row";

        // 12
        $this->_12->RowCssClass = "row";

        // m_12
        $this->m_12->RowCssClass = "row";

        // 13
        $this->_13->RowCssClass = "row";

        // m_13
        $this->m_13->RowCssClass = "row";

        // 14
        $this->_14->RowCssClass = "row";

        // m_14
        $this->m_14->RowCssClass = "row";

        // 15
        $this->_15->RowCssClass = "row";

        // m_15
        $this->m_15->RowCssClass = "row";

        // 16
        $this->_16->RowCssClass = "row";

        // m_16
        $this->m_16->RowCssClass = "row";

        // 17
        $this->_17->RowCssClass = "row";

        // m_17
        $this->m_17->RowCssClass = "row";

        // 18
        $this->_18->RowCssClass = "row";

        // m_18
        $this->m_18->RowCssClass = "row";

        // 19
        $this->_19->RowCssClass = "row";

        // m_19
        $this->m_19->RowCssClass = "row";

        // 20
        $this->_20->RowCssClass = "row";

        // m_20
        $this->m_20->RowCssClass = "row";

        // 21
        $this->_21->RowCssClass = "row";

        // m_21
        $this->m_21->RowCssClass = "row";

        // 22
        $this->_22->RowCssClass = "row";

        // m_22
        $this->m_22->RowCssClass = "row";

        // 23
        $this->_23->RowCssClass = "row";

        // m_23
        $this->m_23->RowCssClass = "row";

        // 24
        $this->_24->RowCssClass = "row";

        // m_24
        $this->m_24->RowCssClass = "row";

        // 25
        $this->_25->RowCssClass = "row";

        // m_25
        $this->m_25->RowCssClass = "row";

        // 26
        $this->_26->RowCssClass = "row";

        // m_26
        $this->m_26->RowCssClass = "row";

        // 27
        $this->_27->RowCssClass = "row";

        // m_27
        $this->m_27->RowCssClass = "row";

        // 28
        $this->_28->RowCssClass = "row";

        // m_28
        $this->m_28->RowCssClass = "row";

        // 29
        $this->_29->RowCssClass = "row";

        // m_29
        $this->m_29->RowCssClass = "row";

        // 30
        $this->_30->RowCssClass = "row";

        // m_30
        $this->m_30->RowCssClass = "row";

        // 31
        $this->_31->RowCssClass = "row";

        // m_31
        $this->m_31->RowCssClass = "row";

        // 32
        $this->_32->RowCssClass = "row";

        // m_32
        $this->m_32->RowCssClass = "row";

        // 33
        $this->_33->RowCssClass = "row";

        // m_33
        $this->m_33->RowCssClass = "row";

        // 34
        $this->_34->RowCssClass = "row";

        // m_34
        $this->m_34->RowCssClass = "row";

        // 35
        $this->_35->RowCssClass = "row";

        // m_35
        $this->m_35->RowCssClass = "row";

        // 36
        $this->_36->RowCssClass = "row";

        // m_36
        $this->m_36->RowCssClass = "row";

        // 37
        $this->_37->RowCssClass = "row";

        // m_37
        $this->m_37->RowCssClass = "row";

        // 38
        $this->_38->RowCssClass = "row";

        // m_38
        $this->m_38->RowCssClass = "row";

        // 39
        $this->_39->RowCssClass = "row";

        // m_39
        $this->m_39->RowCssClass = "row";

        // 40
        $this->_40->RowCssClass = "row";

        // m_40
        $this->m_40->RowCssClass = "row";

        // 41
        $this->_41->RowCssClass = "row";

        // m_41
        $this->m_41->RowCssClass = "row";

        // 42
        $this->_42->RowCssClass = "row";

        // m_42
        $this->m_42->RowCssClass = "row";

        // 43
        $this->_43->RowCssClass = "row";

        // m_43
        $this->m_43->RowCssClass = "row";

        // 44
        $this->_44->RowCssClass = "row";

        // m_44
        $this->m_44->RowCssClass = "row";

        // 45
        $this->_45->RowCssClass = "row";

        // m_45
        $this->m_45->RowCssClass = "row";

        // 46
        $this->_46->RowCssClass = "row";

        // m_46
        $this->m_46->RowCssClass = "row";

        // 47
        $this->_47->RowCssClass = "row";

        // m_47
        $this->m_47->RowCssClass = "row";

        // 48
        $this->_48->RowCssClass = "row";

        // m_48
        $this->m_48->RowCssClass = "row";

        // 49
        $this->_49->RowCssClass = "row";

        // m_49
        $this->m_49->RowCssClass = "row";

        // 50
        $this->_50->RowCssClass = "row";

        // m_50
        $this->m_50->RowCssClass = "row";

        // 51
        $this->_51->RowCssClass = "row";

        // m_51
        $this->m_51->RowCssClass = "row";

        // 52
        $this->_52->RowCssClass = "row";

        // m_52
        $this->m_52->RowCssClass = "row";

        // 53
        $this->_53->RowCssClass = "row";

        // m_53
        $this->m_53->RowCssClass = "row";

        // 54
        $this->_54->RowCssClass = "row";

        // m_54
        $this->m_54->RowCssClass = "row";

        // 55
        $this->_55->RowCssClass = "row";

        // m_55
        $this->m_55->RowCssClass = "row";

        // 56
        $this->_56->RowCssClass = "row";

        // m_56
        $this->m_56->RowCssClass = "row";

        // 57
        $this->_57->RowCssClass = "row";

        // m_57
        $this->m_57->RowCssClass = "row";

        // 58
        $this->_58->RowCssClass = "row";

        // m_58
        $this->m_58->RowCssClass = "row";

        // 59
        $this->_59->RowCssClass = "row";

        // m_59
        $this->m_59->RowCssClass = "row";

        // 60
        $this->_60->RowCssClass = "row";

        // m_60
        $this->m_60->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // roll_no
            $this->roll_no->ViewValue = $this->roll_no->CurrentValue;

            // test_id
            $this->test_id->ViewValue = $this->test_id->CurrentValue;

            // total
            $this->total->ViewValue = $this->total->CurrentValue;
            $this->total->ViewValue = FormatNumber($this->total->ViewValue, $this->total->formatPattern());

            // percent
            $this->percent->ViewValue = $this->percent->CurrentValue;
            $this->percent->ViewValue = FormatNumber($this->percent->ViewValue, $this->percent->formatPattern());

            // s_1
            $this->s_1->ViewValue = $this->s_1->CurrentValue;
            $this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, $this->s_1->formatPattern());

            // s_2
            $this->s_2->ViewValue = $this->s_2->CurrentValue;
            $this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, $this->s_2->formatPattern());

            // s_3
            $this->s_3->ViewValue = $this->s_3->CurrentValue;
            $this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, $this->s_3->formatPattern());

            // s_4
            $this->s_4->ViewValue = $this->s_4->CurrentValue;
            $this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, $this->s_4->formatPattern());

            // s_5
            $this->s_5->ViewValue = $this->s_5->CurrentValue;
            $this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, $this->s_5->formatPattern());

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->ImageWidth = 0;
                $this->omr_image->ImageHeight = 50;
                $this->omr_image->ImageAlt = $this->omr_image->alt();
                $this->omr_image->ImageCssClass = "ew-image";
                $this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
            } else {
                $this->omr_image->ViewValue = "";
            }

            // 1
            $this->_1->ViewValue = $this->_1->CurrentValue;

            // m_1
            $this->m_1->ViewValue = $this->m_1->CurrentValue;
            $this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, $this->m_1->formatPattern());

            // 2
            $this->_2->ViewValue = $this->_2->CurrentValue;

            // m_2
            $this->m_2->ViewValue = $this->m_2->CurrentValue;
            $this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, $this->m_2->formatPattern());

            // 3
            $this->_3->ViewValue = $this->_3->CurrentValue;

            // m_3
            $this->m_3->ViewValue = $this->m_3->CurrentValue;
            $this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, $this->m_3->formatPattern());

            // 4
            $this->_4->ViewValue = $this->_4->CurrentValue;

            // m_4
            $this->m_4->ViewValue = $this->m_4->CurrentValue;
            $this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, $this->m_4->formatPattern());

            // 5
            $this->_5->ViewValue = $this->_5->CurrentValue;

            // m_5
            $this->m_5->ViewValue = $this->m_5->CurrentValue;
            $this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, $this->m_5->formatPattern());

            // 6
            $this->_6->ViewValue = $this->_6->CurrentValue;

            // m_6
            $this->m_6->ViewValue = $this->m_6->CurrentValue;
            $this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, $this->m_6->formatPattern());

            // 7
            $this->_7->ViewValue = $this->_7->CurrentValue;

            // m_7
            $this->m_7->ViewValue = $this->m_7->CurrentValue;
            $this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, $this->m_7->formatPattern());

            // 8
            $this->_8->ViewValue = $this->_8->CurrentValue;

            // m_8
            $this->m_8->ViewValue = $this->m_8->CurrentValue;
            $this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, $this->m_8->formatPattern());

            // 9
            $this->_9->ViewValue = $this->_9->CurrentValue;

            // m_9
            $this->m_9->ViewValue = $this->m_9->CurrentValue;
            $this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, $this->m_9->formatPattern());

            // 10
            $this->_10->ViewValue = $this->_10->CurrentValue;

            // m_10
            $this->m_10->ViewValue = $this->m_10->CurrentValue;
            $this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, $this->m_10->formatPattern());

            // 11
            $this->_11->ViewValue = $this->_11->CurrentValue;

            // m_11
            $this->m_11->ViewValue = $this->m_11->CurrentValue;
            $this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, $this->m_11->formatPattern());

            // 12
            $this->_12->ViewValue = $this->_12->CurrentValue;

            // m_12
            $this->m_12->ViewValue = $this->m_12->CurrentValue;
            $this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, $this->m_12->formatPattern());

            // 13
            $this->_13->ViewValue = $this->_13->CurrentValue;

            // m_13
            $this->m_13->ViewValue = $this->m_13->CurrentValue;
            $this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, $this->m_13->formatPattern());

            // 14
            $this->_14->ViewValue = $this->_14->CurrentValue;

            // m_14
            $this->m_14->ViewValue = $this->m_14->CurrentValue;
            $this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, $this->m_14->formatPattern());

            // 15
            $this->_15->ViewValue = $this->_15->CurrentValue;

            // m_15
            $this->m_15->ViewValue = $this->m_15->CurrentValue;
            $this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, $this->m_15->formatPattern());

            // 16
            $this->_16->ViewValue = $this->_16->CurrentValue;

            // m_16
            $this->m_16->ViewValue = $this->m_16->CurrentValue;
            $this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, $this->m_16->formatPattern());

            // 17
            $this->_17->ViewValue = $this->_17->CurrentValue;

            // m_17
            $this->m_17->ViewValue = $this->m_17->CurrentValue;
            $this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, $this->m_17->formatPattern());

            // 18
            $this->_18->ViewValue = $this->_18->CurrentValue;

            // m_18
            $this->m_18->ViewValue = $this->m_18->CurrentValue;
            $this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, $this->m_18->formatPattern());

            // 19
            $this->_19->ViewValue = $this->_19->CurrentValue;

            // m_19
            $this->m_19->ViewValue = $this->m_19->CurrentValue;
            $this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, $this->m_19->formatPattern());

            // 20
            $this->_20->ViewValue = $this->_20->CurrentValue;

            // m_20
            $this->m_20->ViewValue = $this->m_20->CurrentValue;
            $this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, $this->m_20->formatPattern());

            // 21
            $this->_21->ViewValue = $this->_21->CurrentValue;

            // m_21
            $this->m_21->ViewValue = $this->m_21->CurrentValue;
            $this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, $this->m_21->formatPattern());

            // 22
            $this->_22->ViewValue = $this->_22->CurrentValue;

            // m_22
            $this->m_22->ViewValue = $this->m_22->CurrentValue;
            $this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, $this->m_22->formatPattern());

            // 23
            $this->_23->ViewValue = $this->_23->CurrentValue;

            // m_23
            $this->m_23->ViewValue = $this->m_23->CurrentValue;
            $this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, $this->m_23->formatPattern());

            // 24
            $this->_24->ViewValue = $this->_24->CurrentValue;

            // m_24
            $this->m_24->ViewValue = $this->m_24->CurrentValue;
            $this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, $this->m_24->formatPattern());

            // 25
            $this->_25->ViewValue = $this->_25->CurrentValue;

            // m_25
            $this->m_25->ViewValue = $this->m_25->CurrentValue;
            $this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, $this->m_25->formatPattern());

            // 26
            $this->_26->ViewValue = $this->_26->CurrentValue;

            // m_26
            $this->m_26->ViewValue = $this->m_26->CurrentValue;
            $this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, $this->m_26->formatPattern());

            // 27
            $this->_27->ViewValue = $this->_27->CurrentValue;

            // m_27
            $this->m_27->ViewValue = $this->m_27->CurrentValue;
            $this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, $this->m_27->formatPattern());

            // 28
            $this->_28->ViewValue = $this->_28->CurrentValue;

            // m_28
            $this->m_28->ViewValue = $this->m_28->CurrentValue;
            $this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, $this->m_28->formatPattern());

            // 29
            $this->_29->ViewValue = $this->_29->CurrentValue;

            // m_29
            $this->m_29->ViewValue = $this->m_29->CurrentValue;
            $this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, $this->m_29->formatPattern());

            // 30
            $this->_30->ViewValue = $this->_30->CurrentValue;

            // m_30
            $this->m_30->ViewValue = $this->m_30->CurrentValue;
            $this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, $this->m_30->formatPattern());

            // 31
            $this->_31->ViewValue = $this->_31->CurrentValue;

            // m_31
            $this->m_31->ViewValue = $this->m_31->CurrentValue;
            $this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, $this->m_31->formatPattern());

            // 32
            $this->_32->ViewValue = $this->_32->CurrentValue;

            // m_32
            $this->m_32->ViewValue = $this->m_32->CurrentValue;
            $this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, $this->m_32->formatPattern());

            // 33
            $this->_33->ViewValue = $this->_33->CurrentValue;

            // m_33
            $this->m_33->ViewValue = $this->m_33->CurrentValue;
            $this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, $this->m_33->formatPattern());

            // 34
            $this->_34->ViewValue = $this->_34->CurrentValue;

            // m_34
            $this->m_34->ViewValue = $this->m_34->CurrentValue;
            $this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, $this->m_34->formatPattern());

            // 35
            $this->_35->ViewValue = $this->_35->CurrentValue;

            // m_35
            $this->m_35->ViewValue = $this->m_35->CurrentValue;
            $this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, $this->m_35->formatPattern());

            // 36
            $this->_36->ViewValue = $this->_36->CurrentValue;

            // m_36
            $this->m_36->ViewValue = $this->m_36->CurrentValue;
            $this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, $this->m_36->formatPattern());

            // 37
            $this->_37->ViewValue = $this->_37->CurrentValue;

            // m_37
            $this->m_37->ViewValue = $this->m_37->CurrentValue;
            $this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, $this->m_37->formatPattern());

            // 38
            $this->_38->ViewValue = $this->_38->CurrentValue;

            // m_38
            $this->m_38->ViewValue = $this->m_38->CurrentValue;
            $this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, $this->m_38->formatPattern());

            // 39
            $this->_39->ViewValue = $this->_39->CurrentValue;

            // m_39
            $this->m_39->ViewValue = $this->m_39->CurrentValue;
            $this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, $this->m_39->formatPattern());

            // 40
            $this->_40->ViewValue = $this->_40->CurrentValue;

            // m_40
            $this->m_40->ViewValue = $this->m_40->CurrentValue;
            $this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, $this->m_40->formatPattern());

            // 41
            $this->_41->ViewValue = $this->_41->CurrentValue;

            // m_41
            $this->m_41->ViewValue = $this->m_41->CurrentValue;
            $this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, $this->m_41->formatPattern());

            // 42
            $this->_42->ViewValue = $this->_42->CurrentValue;

            // m_42
            $this->m_42->ViewValue = $this->m_42->CurrentValue;
            $this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, $this->m_42->formatPattern());

            // 43
            $this->_43->ViewValue = $this->_43->CurrentValue;

            // m_43
            $this->m_43->ViewValue = $this->m_43->CurrentValue;
            $this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, $this->m_43->formatPattern());

            // 44
            $this->_44->ViewValue = $this->_44->CurrentValue;

            // m_44
            $this->m_44->ViewValue = $this->m_44->CurrentValue;
            $this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, $this->m_44->formatPattern());

            // 45
            $this->_45->ViewValue = $this->_45->CurrentValue;

            // m_45
            $this->m_45->ViewValue = $this->m_45->CurrentValue;
            $this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, $this->m_45->formatPattern());

            // 46
            $this->_46->ViewValue = $this->_46->CurrentValue;

            // m_46
            $this->m_46->ViewValue = $this->m_46->CurrentValue;
            $this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, $this->m_46->formatPattern());

            // 47
            $this->_47->ViewValue = $this->_47->CurrentValue;

            // m_47
            $this->m_47->ViewValue = $this->m_47->CurrentValue;
            $this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, $this->m_47->formatPattern());

            // 48
            $this->_48->ViewValue = $this->_48->CurrentValue;

            // m_48
            $this->m_48->ViewValue = $this->m_48->CurrentValue;
            $this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, $this->m_48->formatPattern());

            // 49
            $this->_49->ViewValue = $this->_49->CurrentValue;

            // m_49
            $this->m_49->ViewValue = $this->m_49->CurrentValue;
            $this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, $this->m_49->formatPattern());

            // 50
            $this->_50->ViewValue = $this->_50->CurrentValue;

            // m_50
            $this->m_50->ViewValue = $this->m_50->CurrentValue;
            $this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, $this->m_50->formatPattern());

            // 51
            $this->_51->ViewValue = $this->_51->CurrentValue;

            // m_51
            $this->m_51->ViewValue = $this->m_51->CurrentValue;
            $this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, $this->m_51->formatPattern());

            // 52
            $this->_52->ViewValue = $this->_52->CurrentValue;

            // m_52
            $this->m_52->ViewValue = $this->m_52->CurrentValue;
            $this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, $this->m_52->formatPattern());

            // 53
            $this->_53->ViewValue = $this->_53->CurrentValue;

            // m_53
            $this->m_53->ViewValue = $this->m_53->CurrentValue;
            $this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, $this->m_53->formatPattern());

            // 54
            $this->_54->ViewValue = $this->_54->CurrentValue;

            // m_54
            $this->m_54->ViewValue = $this->m_54->CurrentValue;
            $this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, $this->m_54->formatPattern());

            // 55
            $this->_55->ViewValue = $this->_55->CurrentValue;

            // m_55
            $this->m_55->ViewValue = $this->m_55->CurrentValue;
            $this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, $this->m_55->formatPattern());

            // 56
            $this->_56->ViewValue = $this->_56->CurrentValue;

            // m_56
            $this->m_56->ViewValue = $this->m_56->CurrentValue;
            $this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, $this->m_56->formatPattern());

            // 57
            $this->_57->ViewValue = $this->_57->CurrentValue;

            // m_57
            $this->m_57->ViewValue = $this->m_57->CurrentValue;
            $this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, $this->m_57->formatPattern());

            // 58
            $this->_58->ViewValue = $this->_58->CurrentValue;

            // m_58
            $this->m_58->ViewValue = $this->m_58->CurrentValue;
            $this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, $this->m_58->formatPattern());

            // 59
            $this->_59->ViewValue = $this->_59->CurrentValue;

            // m_59
            $this->m_59->ViewValue = $this->m_59->CurrentValue;
            $this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, $this->m_59->formatPattern());

            // 60
            $this->_60->ViewValue = $this->_60->CurrentValue;

            // m_60
            $this->m_60->ViewValue = $this->m_60->CurrentValue;
            $this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, $this->m_60->formatPattern());

            // roll_no
            $this->roll_no->HrefValue = "";

            // test_id
            $this->test_id->HrefValue = "";

            // total
            $this->total->HrefValue = "";

            // percent
            $this->percent->HrefValue = "";

            // s_1
            $this->s_1->HrefValue = "";

            // s_2
            $this->s_2->HrefValue = "";

            // s_3
            $this->s_3->HrefValue = "";

            // s_4
            $this->s_4->HrefValue = "";

            // s_5
            $this->s_5->HrefValue = "";

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->htmlDecode($this->omr_image->Upload->DbValue)); // Add prefix/suffix
                $this->omr_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
                }
            } else {
                $this->omr_image->HrefValue = "";
            }
            $this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;

            // 1
            $this->_1->HrefValue = "";

            // m_1
            $this->m_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // m_2
            $this->m_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // m_3
            $this->m_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // m_4
            $this->m_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // m_5
            $this->m_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // m_6
            $this->m_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // m_7
            $this->m_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // m_8
            $this->m_8->HrefValue = "";

            // 9
            $this->_9->HrefValue = "";

            // m_9
            $this->m_9->HrefValue = "";

            // 10
            $this->_10->HrefValue = "";

            // m_10
            $this->m_10->HrefValue = "";

            // 11
            $this->_11->HrefValue = "";

            // m_11
            $this->m_11->HrefValue = "";

            // 12
            $this->_12->HrefValue = "";

            // m_12
            $this->m_12->HrefValue = "";

            // 13
            $this->_13->HrefValue = "";

            // m_13
            $this->m_13->HrefValue = "";

            // 14
            $this->_14->HrefValue = "";

            // m_14
            $this->m_14->HrefValue = "";

            // 15
            $this->_15->HrefValue = "";

            // m_15
            $this->m_15->HrefValue = "";

            // 16
            $this->_16->HrefValue = "";

            // m_16
            $this->m_16->HrefValue = "";

            // 17
            $this->_17->HrefValue = "";

            // m_17
            $this->m_17->HrefValue = "";

            // 18
            $this->_18->HrefValue = "";

            // m_18
            $this->m_18->HrefValue = "";

            // 19
            $this->_19->HrefValue = "";

            // m_19
            $this->m_19->HrefValue = "";

            // 20
            $this->_20->HrefValue = "";

            // m_20
            $this->m_20->HrefValue = "";

            // 21
            $this->_21->HrefValue = "";

            // m_21
            $this->m_21->HrefValue = "";

            // 22
            $this->_22->HrefValue = "";

            // m_22
            $this->m_22->HrefValue = "";

            // 23
            $this->_23->HrefValue = "";

            // m_23
            $this->m_23->HrefValue = "";

            // 24
            $this->_24->HrefValue = "";

            // m_24
            $this->m_24->HrefValue = "";

            // 25
            $this->_25->HrefValue = "";

            // m_25
            $this->m_25->HrefValue = "";

            // 26
            $this->_26->HrefValue = "";

            // m_26
            $this->m_26->HrefValue = "";

            // 27
            $this->_27->HrefValue = "";

            // m_27
            $this->m_27->HrefValue = "";

            // 28
            $this->_28->HrefValue = "";

            // m_28
            $this->m_28->HrefValue = "";

            // 29
            $this->_29->HrefValue = "";

            // m_29
            $this->m_29->HrefValue = "";

            // 30
            $this->_30->HrefValue = "";

            // m_30
            $this->m_30->HrefValue = "";

            // 31
            $this->_31->HrefValue = "";

            // m_31
            $this->m_31->HrefValue = "";

            // 32
            $this->_32->HrefValue = "";

            // m_32
            $this->m_32->HrefValue = "";

            // 33
            $this->_33->HrefValue = "";

            // m_33
            $this->m_33->HrefValue = "";

            // 34
            $this->_34->HrefValue = "";

            // m_34
            $this->m_34->HrefValue = "";

            // 35
            $this->_35->HrefValue = "";

            // m_35
            $this->m_35->HrefValue = "";

            // 36
            $this->_36->HrefValue = "";

            // m_36
            $this->m_36->HrefValue = "";

            // 37
            $this->_37->HrefValue = "";

            // m_37
            $this->m_37->HrefValue = "";

            // 38
            $this->_38->HrefValue = "";

            // m_38
            $this->m_38->HrefValue = "";

            // 39
            $this->_39->HrefValue = "";

            // m_39
            $this->m_39->HrefValue = "";

            // 40
            $this->_40->HrefValue = "";

            // m_40
            $this->m_40->HrefValue = "";

            // 41
            $this->_41->HrefValue = "";

            // m_41
            $this->m_41->HrefValue = "";

            // 42
            $this->_42->HrefValue = "";

            // m_42
            $this->m_42->HrefValue = "";

            // 43
            $this->_43->HrefValue = "";

            // m_43
            $this->m_43->HrefValue = "";

            // 44
            $this->_44->HrefValue = "";

            // m_44
            $this->m_44->HrefValue = "";

            // 45
            $this->_45->HrefValue = "";

            // m_45
            $this->m_45->HrefValue = "";

            // 46
            $this->_46->HrefValue = "";

            // m_46
            $this->m_46->HrefValue = "";

            // 47
            $this->_47->HrefValue = "";

            // m_47
            $this->m_47->HrefValue = "";

            // 48
            $this->_48->HrefValue = "";

            // m_48
            $this->m_48->HrefValue = "";

            // 49
            $this->_49->HrefValue = "";

            // m_49
            $this->m_49->HrefValue = "";

            // 50
            $this->_50->HrefValue = "";

            // m_50
            $this->m_50->HrefValue = "";

            // 51
            $this->_51->HrefValue = "";

            // m_51
            $this->m_51->HrefValue = "";

            // 52
            $this->_52->HrefValue = "";

            // m_52
            $this->m_52->HrefValue = "";

            // 53
            $this->_53->HrefValue = "";

            // m_53
            $this->m_53->HrefValue = "";

            // 54
            $this->_54->HrefValue = "";

            // m_54
            $this->m_54->HrefValue = "";

            // 55
            $this->_55->HrefValue = "";

            // m_55
            $this->m_55->HrefValue = "";

            // 56
            $this->_56->HrefValue = "";

            // m_56
            $this->m_56->HrefValue = "";

            // 57
            $this->_57->HrefValue = "";

            // m_57
            $this->m_57->HrefValue = "";

            // 58
            $this->_58->HrefValue = "";

            // m_58
            $this->m_58->HrefValue = "";

            // 59
            $this->_59->HrefValue = "";

            // m_59
            $this->m_59->HrefValue = "";

            // 60
            $this->_60->HrefValue = "";

            // m_60
            $this->m_60->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // roll_no
            $this->roll_no->setupEditAttributes();
            if (!$this->roll_no->Raw) {
                $this->roll_no->CurrentValue = HtmlDecode($this->roll_no->CurrentValue);
            }
            $this->roll_no->EditValue = HtmlEncode($this->roll_no->CurrentValue);
            $this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

            // test_id
            $this->test_id->setupEditAttributes();
            if (!$this->test_id->Raw) {
                $this->test_id->CurrentValue = HtmlDecode($this->test_id->CurrentValue);
            }
            $this->test_id->EditValue = HtmlEncode($this->test_id->CurrentValue);
            $this->test_id->PlaceHolder = RemoveHtml($this->test_id->caption());

            // total
            $this->total->setupEditAttributes();
            $this->total->EditValue = $this->total->CurrentValue;
            $this->total->PlaceHolder = RemoveHtml($this->total->caption());
            if (strval($this->total->EditValue) != "" && is_numeric($this->total->EditValue)) {
                $this->total->EditValue = FormatNumber($this->total->EditValue, null);
            }

            // percent
            $this->percent->setupEditAttributes();
            $this->percent->EditValue = $this->percent->CurrentValue;
            $this->percent->PlaceHolder = RemoveHtml($this->percent->caption());
            if (strval($this->percent->EditValue) != "" && is_numeric($this->percent->EditValue)) {
                $this->percent->EditValue = FormatNumber($this->percent->EditValue, null);
            }

            // s_1
            $this->s_1->setupEditAttributes();
            $this->s_1->EditValue = $this->s_1->CurrentValue;
            $this->s_1->PlaceHolder = RemoveHtml($this->s_1->caption());
            if (strval($this->s_1->EditValue) != "" && is_numeric($this->s_1->EditValue)) {
                $this->s_1->EditValue = FormatNumber($this->s_1->EditValue, null);
            }

            // s_2
            $this->s_2->setupEditAttributes();
            $this->s_2->EditValue = $this->s_2->CurrentValue;
            $this->s_2->PlaceHolder = RemoveHtml($this->s_2->caption());
            if (strval($this->s_2->EditValue) != "" && is_numeric($this->s_2->EditValue)) {
                $this->s_2->EditValue = FormatNumber($this->s_2->EditValue, null);
            }

            // s_3
            $this->s_3->setupEditAttributes();
            $this->s_3->EditValue = $this->s_3->CurrentValue;
            $this->s_3->PlaceHolder = RemoveHtml($this->s_3->caption());
            if (strval($this->s_3->EditValue) != "" && is_numeric($this->s_3->EditValue)) {
                $this->s_3->EditValue = FormatNumber($this->s_3->EditValue, null);
            }

            // s_4
            $this->s_4->setupEditAttributes();
            $this->s_4->EditValue = $this->s_4->CurrentValue;
            $this->s_4->PlaceHolder = RemoveHtml($this->s_4->caption());
            if (strval($this->s_4->EditValue) != "" && is_numeric($this->s_4->EditValue)) {
                $this->s_4->EditValue = FormatNumber($this->s_4->EditValue, null);
            }

            // s_5
            $this->s_5->setupEditAttributes();
            $this->s_5->EditValue = $this->s_5->CurrentValue;
            $this->s_5->PlaceHolder = RemoveHtml($this->s_5->caption());
            if (strval($this->s_5->EditValue) != "" && is_numeric($this->s_5->EditValue)) {
                $this->s_5->EditValue = FormatNumber($this->s_5->EditValue, null);
            }

            // omr_image
            $this->omr_image->setupEditAttributes();
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->ImageWidth = 0;
                $this->omr_image->ImageHeight = 50;
                $this->omr_image->ImageAlt = $this->omr_image->alt();
                $this->omr_image->ImageCssClass = "ew-image";
                $this->omr_image->EditValue = $this->omr_image->Upload->DbValue;
            } else {
                $this->omr_image->EditValue = "";
            }
            if (!EmptyValue($this->omr_image->CurrentValue)) {
                $this->omr_image->Upload->FileName = $this->omr_image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->omr_image->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->omr_image);
            }

            // 1
            $this->_1->setupEditAttributes();
            if (!$this->_1->Raw) {
                $this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
            }
            $this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
            $this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

            // m_1
            $this->m_1->setupEditAttributes();
            $this->m_1->EditValue = $this->m_1->CurrentValue;
            $this->m_1->PlaceHolder = RemoveHtml($this->m_1->caption());
            if (strval($this->m_1->EditValue) != "" && is_numeric($this->m_1->EditValue)) {
                $this->m_1->EditValue = FormatNumber($this->m_1->EditValue, null);
            }

            // 2
            $this->_2->setupEditAttributes();
            if (!$this->_2->Raw) {
                $this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
            }
            $this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
            $this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

            // m_2
            $this->m_2->setupEditAttributes();
            $this->m_2->EditValue = $this->m_2->CurrentValue;
            $this->m_2->PlaceHolder = RemoveHtml($this->m_2->caption());
            if (strval($this->m_2->EditValue) != "" && is_numeric($this->m_2->EditValue)) {
                $this->m_2->EditValue = FormatNumber($this->m_2->EditValue, null);
            }

            // 3
            $this->_3->setupEditAttributes();
            if (!$this->_3->Raw) {
                $this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
            }
            $this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
            $this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

            // m_3
            $this->m_3->setupEditAttributes();
            $this->m_3->EditValue = $this->m_3->CurrentValue;
            $this->m_3->PlaceHolder = RemoveHtml($this->m_3->caption());
            if (strval($this->m_3->EditValue) != "" && is_numeric($this->m_3->EditValue)) {
                $this->m_3->EditValue = FormatNumber($this->m_3->EditValue, null);
            }

            // 4
            $this->_4->setupEditAttributes();
            if (!$this->_4->Raw) {
                $this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
            }
            $this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
            $this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

            // m_4
            $this->m_4->setupEditAttributes();
            $this->m_4->EditValue = $this->m_4->CurrentValue;
            $this->m_4->PlaceHolder = RemoveHtml($this->m_4->caption());
            if (strval($this->m_4->EditValue) != "" && is_numeric($this->m_4->EditValue)) {
                $this->m_4->EditValue = FormatNumber($this->m_4->EditValue, null);
            }

            // 5
            $this->_5->setupEditAttributes();
            if (!$this->_5->Raw) {
                $this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
            }
            $this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
            $this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

            // m_5
            $this->m_5->setupEditAttributes();
            $this->m_5->EditValue = $this->m_5->CurrentValue;
            $this->m_5->PlaceHolder = RemoveHtml($this->m_5->caption());
            if (strval($this->m_5->EditValue) != "" && is_numeric($this->m_5->EditValue)) {
                $this->m_5->EditValue = FormatNumber($this->m_5->EditValue, null);
            }

            // 6
            $this->_6->setupEditAttributes();
            if (!$this->_6->Raw) {
                $this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
            }
            $this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
            $this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

            // m_6
            $this->m_6->setupEditAttributes();
            $this->m_6->EditValue = $this->m_6->CurrentValue;
            $this->m_6->PlaceHolder = RemoveHtml($this->m_6->caption());
            if (strval($this->m_6->EditValue) != "" && is_numeric($this->m_6->EditValue)) {
                $this->m_6->EditValue = FormatNumber($this->m_6->EditValue, null);
            }

            // 7
            $this->_7->setupEditAttributes();
            if (!$this->_7->Raw) {
                $this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
            }
            $this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
            $this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

            // m_7
            $this->m_7->setupEditAttributes();
            $this->m_7->EditValue = $this->m_7->CurrentValue;
            $this->m_7->PlaceHolder = RemoveHtml($this->m_7->caption());
            if (strval($this->m_7->EditValue) != "" && is_numeric($this->m_7->EditValue)) {
                $this->m_7->EditValue = FormatNumber($this->m_7->EditValue, null);
            }

            // 8
            $this->_8->setupEditAttributes();
            if (!$this->_8->Raw) {
                $this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
            }
            $this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
            $this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

            // m_8
            $this->m_8->setupEditAttributes();
            $this->m_8->EditValue = $this->m_8->CurrentValue;
            $this->m_8->PlaceHolder = RemoveHtml($this->m_8->caption());
            if (strval($this->m_8->EditValue) != "" && is_numeric($this->m_8->EditValue)) {
                $this->m_8->EditValue = FormatNumber($this->m_8->EditValue, null);
            }

            // 9
            $this->_9->setupEditAttributes();
            if (!$this->_9->Raw) {
                $this->_9->CurrentValue = HtmlDecode($this->_9->CurrentValue);
            }
            $this->_9->EditValue = HtmlEncode($this->_9->CurrentValue);
            $this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

            // m_9
            $this->m_9->setupEditAttributes();
            $this->m_9->EditValue = $this->m_9->CurrentValue;
            $this->m_9->PlaceHolder = RemoveHtml($this->m_9->caption());
            if (strval($this->m_9->EditValue) != "" && is_numeric($this->m_9->EditValue)) {
                $this->m_9->EditValue = FormatNumber($this->m_9->EditValue, null);
            }

            // 10
            $this->_10->setupEditAttributes();
            if (!$this->_10->Raw) {
                $this->_10->CurrentValue = HtmlDecode($this->_10->CurrentValue);
            }
            $this->_10->EditValue = HtmlEncode($this->_10->CurrentValue);
            $this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

            // m_10
            $this->m_10->setupEditAttributes();
            $this->m_10->EditValue = $this->m_10->CurrentValue;
            $this->m_10->PlaceHolder = RemoveHtml($this->m_10->caption());
            if (strval($this->m_10->EditValue) != "" && is_numeric($this->m_10->EditValue)) {
                $this->m_10->EditValue = FormatNumber($this->m_10->EditValue, null);
            }

            // 11
            $this->_11->setupEditAttributes();
            if (!$this->_11->Raw) {
                $this->_11->CurrentValue = HtmlDecode($this->_11->CurrentValue);
            }
            $this->_11->EditValue = HtmlEncode($this->_11->CurrentValue);
            $this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

            // m_11
            $this->m_11->setupEditAttributes();
            $this->m_11->EditValue = $this->m_11->CurrentValue;
            $this->m_11->PlaceHolder = RemoveHtml($this->m_11->caption());
            if (strval($this->m_11->EditValue) != "" && is_numeric($this->m_11->EditValue)) {
                $this->m_11->EditValue = FormatNumber($this->m_11->EditValue, null);
            }

            // 12
            $this->_12->setupEditAttributes();
            if (!$this->_12->Raw) {
                $this->_12->CurrentValue = HtmlDecode($this->_12->CurrentValue);
            }
            $this->_12->EditValue = HtmlEncode($this->_12->CurrentValue);
            $this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

            // m_12
            $this->m_12->setupEditAttributes();
            $this->m_12->EditValue = $this->m_12->CurrentValue;
            $this->m_12->PlaceHolder = RemoveHtml($this->m_12->caption());
            if (strval($this->m_12->EditValue) != "" && is_numeric($this->m_12->EditValue)) {
                $this->m_12->EditValue = FormatNumber($this->m_12->EditValue, null);
            }

            // 13
            $this->_13->setupEditAttributes();
            if (!$this->_13->Raw) {
                $this->_13->CurrentValue = HtmlDecode($this->_13->CurrentValue);
            }
            $this->_13->EditValue = HtmlEncode($this->_13->CurrentValue);
            $this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

            // m_13
            $this->m_13->setupEditAttributes();
            $this->m_13->EditValue = $this->m_13->CurrentValue;
            $this->m_13->PlaceHolder = RemoveHtml($this->m_13->caption());
            if (strval($this->m_13->EditValue) != "" && is_numeric($this->m_13->EditValue)) {
                $this->m_13->EditValue = FormatNumber($this->m_13->EditValue, null);
            }

            // 14
            $this->_14->setupEditAttributes();
            if (!$this->_14->Raw) {
                $this->_14->CurrentValue = HtmlDecode($this->_14->CurrentValue);
            }
            $this->_14->EditValue = HtmlEncode($this->_14->CurrentValue);
            $this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

            // m_14
            $this->m_14->setupEditAttributes();
            $this->m_14->EditValue = $this->m_14->CurrentValue;
            $this->m_14->PlaceHolder = RemoveHtml($this->m_14->caption());
            if (strval($this->m_14->EditValue) != "" && is_numeric($this->m_14->EditValue)) {
                $this->m_14->EditValue = FormatNumber($this->m_14->EditValue, null);
            }

            // 15
            $this->_15->setupEditAttributes();
            if (!$this->_15->Raw) {
                $this->_15->CurrentValue = HtmlDecode($this->_15->CurrentValue);
            }
            $this->_15->EditValue = HtmlEncode($this->_15->CurrentValue);
            $this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

            // m_15
            $this->m_15->setupEditAttributes();
            $this->m_15->EditValue = $this->m_15->CurrentValue;
            $this->m_15->PlaceHolder = RemoveHtml($this->m_15->caption());
            if (strval($this->m_15->EditValue) != "" && is_numeric($this->m_15->EditValue)) {
                $this->m_15->EditValue = FormatNumber($this->m_15->EditValue, null);
            }

            // 16
            $this->_16->setupEditAttributes();
            if (!$this->_16->Raw) {
                $this->_16->CurrentValue = HtmlDecode($this->_16->CurrentValue);
            }
            $this->_16->EditValue = HtmlEncode($this->_16->CurrentValue);
            $this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

            // m_16
            $this->m_16->setupEditAttributes();
            $this->m_16->EditValue = $this->m_16->CurrentValue;
            $this->m_16->PlaceHolder = RemoveHtml($this->m_16->caption());
            if (strval($this->m_16->EditValue) != "" && is_numeric($this->m_16->EditValue)) {
                $this->m_16->EditValue = FormatNumber($this->m_16->EditValue, null);
            }

            // 17
            $this->_17->setupEditAttributes();
            if (!$this->_17->Raw) {
                $this->_17->CurrentValue = HtmlDecode($this->_17->CurrentValue);
            }
            $this->_17->EditValue = HtmlEncode($this->_17->CurrentValue);
            $this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

            // m_17
            $this->m_17->setupEditAttributes();
            $this->m_17->EditValue = $this->m_17->CurrentValue;
            $this->m_17->PlaceHolder = RemoveHtml($this->m_17->caption());
            if (strval($this->m_17->EditValue) != "" && is_numeric($this->m_17->EditValue)) {
                $this->m_17->EditValue = FormatNumber($this->m_17->EditValue, null);
            }

            // 18
            $this->_18->setupEditAttributes();
            if (!$this->_18->Raw) {
                $this->_18->CurrentValue = HtmlDecode($this->_18->CurrentValue);
            }
            $this->_18->EditValue = HtmlEncode($this->_18->CurrentValue);
            $this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

            // m_18
            $this->m_18->setupEditAttributes();
            $this->m_18->EditValue = $this->m_18->CurrentValue;
            $this->m_18->PlaceHolder = RemoveHtml($this->m_18->caption());
            if (strval($this->m_18->EditValue) != "" && is_numeric($this->m_18->EditValue)) {
                $this->m_18->EditValue = FormatNumber($this->m_18->EditValue, null);
            }

            // 19
            $this->_19->setupEditAttributes();
            if (!$this->_19->Raw) {
                $this->_19->CurrentValue = HtmlDecode($this->_19->CurrentValue);
            }
            $this->_19->EditValue = HtmlEncode($this->_19->CurrentValue);
            $this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

            // m_19
            $this->m_19->setupEditAttributes();
            $this->m_19->EditValue = $this->m_19->CurrentValue;
            $this->m_19->PlaceHolder = RemoveHtml($this->m_19->caption());
            if (strval($this->m_19->EditValue) != "" && is_numeric($this->m_19->EditValue)) {
                $this->m_19->EditValue = FormatNumber($this->m_19->EditValue, null);
            }

            // 20
            $this->_20->setupEditAttributes();
            if (!$this->_20->Raw) {
                $this->_20->CurrentValue = HtmlDecode($this->_20->CurrentValue);
            }
            $this->_20->EditValue = HtmlEncode($this->_20->CurrentValue);
            $this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

            // m_20
            $this->m_20->setupEditAttributes();
            $this->m_20->EditValue = $this->m_20->CurrentValue;
            $this->m_20->PlaceHolder = RemoveHtml($this->m_20->caption());
            if (strval($this->m_20->EditValue) != "" && is_numeric($this->m_20->EditValue)) {
                $this->m_20->EditValue = FormatNumber($this->m_20->EditValue, null);
            }

            // 21
            $this->_21->setupEditAttributes();
            if (!$this->_21->Raw) {
                $this->_21->CurrentValue = HtmlDecode($this->_21->CurrentValue);
            }
            $this->_21->EditValue = HtmlEncode($this->_21->CurrentValue);
            $this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

            // m_21
            $this->m_21->setupEditAttributes();
            $this->m_21->EditValue = $this->m_21->CurrentValue;
            $this->m_21->PlaceHolder = RemoveHtml($this->m_21->caption());
            if (strval($this->m_21->EditValue) != "" && is_numeric($this->m_21->EditValue)) {
                $this->m_21->EditValue = FormatNumber($this->m_21->EditValue, null);
            }

            // 22
            $this->_22->setupEditAttributes();
            if (!$this->_22->Raw) {
                $this->_22->CurrentValue = HtmlDecode($this->_22->CurrentValue);
            }
            $this->_22->EditValue = HtmlEncode($this->_22->CurrentValue);
            $this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

            // m_22
            $this->m_22->setupEditAttributes();
            $this->m_22->EditValue = $this->m_22->CurrentValue;
            $this->m_22->PlaceHolder = RemoveHtml($this->m_22->caption());
            if (strval($this->m_22->EditValue) != "" && is_numeric($this->m_22->EditValue)) {
                $this->m_22->EditValue = FormatNumber($this->m_22->EditValue, null);
            }

            // 23
            $this->_23->setupEditAttributes();
            if (!$this->_23->Raw) {
                $this->_23->CurrentValue = HtmlDecode($this->_23->CurrentValue);
            }
            $this->_23->EditValue = HtmlEncode($this->_23->CurrentValue);
            $this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

            // m_23
            $this->m_23->setupEditAttributes();
            $this->m_23->EditValue = $this->m_23->CurrentValue;
            $this->m_23->PlaceHolder = RemoveHtml($this->m_23->caption());
            if (strval($this->m_23->EditValue) != "" && is_numeric($this->m_23->EditValue)) {
                $this->m_23->EditValue = FormatNumber($this->m_23->EditValue, null);
            }

            // 24
            $this->_24->setupEditAttributes();
            if (!$this->_24->Raw) {
                $this->_24->CurrentValue = HtmlDecode($this->_24->CurrentValue);
            }
            $this->_24->EditValue = HtmlEncode($this->_24->CurrentValue);
            $this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

            // m_24
            $this->m_24->setupEditAttributes();
            $this->m_24->EditValue = $this->m_24->CurrentValue;
            $this->m_24->PlaceHolder = RemoveHtml($this->m_24->caption());
            if (strval($this->m_24->EditValue) != "" && is_numeric($this->m_24->EditValue)) {
                $this->m_24->EditValue = FormatNumber($this->m_24->EditValue, null);
            }

            // 25
            $this->_25->setupEditAttributes();
            if (!$this->_25->Raw) {
                $this->_25->CurrentValue = HtmlDecode($this->_25->CurrentValue);
            }
            $this->_25->EditValue = HtmlEncode($this->_25->CurrentValue);
            $this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

            // m_25
            $this->m_25->setupEditAttributes();
            $this->m_25->EditValue = $this->m_25->CurrentValue;
            $this->m_25->PlaceHolder = RemoveHtml($this->m_25->caption());
            if (strval($this->m_25->EditValue) != "" && is_numeric($this->m_25->EditValue)) {
                $this->m_25->EditValue = FormatNumber($this->m_25->EditValue, null);
            }

            // 26
            $this->_26->setupEditAttributes();
            if (!$this->_26->Raw) {
                $this->_26->CurrentValue = HtmlDecode($this->_26->CurrentValue);
            }
            $this->_26->EditValue = HtmlEncode($this->_26->CurrentValue);
            $this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

            // m_26
            $this->m_26->setupEditAttributes();
            $this->m_26->EditValue = $this->m_26->CurrentValue;
            $this->m_26->PlaceHolder = RemoveHtml($this->m_26->caption());
            if (strval($this->m_26->EditValue) != "" && is_numeric($this->m_26->EditValue)) {
                $this->m_26->EditValue = FormatNumber($this->m_26->EditValue, null);
            }

            // 27
            $this->_27->setupEditAttributes();
            if (!$this->_27->Raw) {
                $this->_27->CurrentValue = HtmlDecode($this->_27->CurrentValue);
            }
            $this->_27->EditValue = HtmlEncode($this->_27->CurrentValue);
            $this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

            // m_27
            $this->m_27->setupEditAttributes();
            $this->m_27->EditValue = $this->m_27->CurrentValue;
            $this->m_27->PlaceHolder = RemoveHtml($this->m_27->caption());
            if (strval($this->m_27->EditValue) != "" && is_numeric($this->m_27->EditValue)) {
                $this->m_27->EditValue = FormatNumber($this->m_27->EditValue, null);
            }

            // 28
            $this->_28->setupEditAttributes();
            if (!$this->_28->Raw) {
                $this->_28->CurrentValue = HtmlDecode($this->_28->CurrentValue);
            }
            $this->_28->EditValue = HtmlEncode($this->_28->CurrentValue);
            $this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

            // m_28
            $this->m_28->setupEditAttributes();
            $this->m_28->EditValue = $this->m_28->CurrentValue;
            $this->m_28->PlaceHolder = RemoveHtml($this->m_28->caption());
            if (strval($this->m_28->EditValue) != "" && is_numeric($this->m_28->EditValue)) {
                $this->m_28->EditValue = FormatNumber($this->m_28->EditValue, null);
            }

            // 29
            $this->_29->setupEditAttributes();
            if (!$this->_29->Raw) {
                $this->_29->CurrentValue = HtmlDecode($this->_29->CurrentValue);
            }
            $this->_29->EditValue = HtmlEncode($this->_29->CurrentValue);
            $this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

            // m_29
            $this->m_29->setupEditAttributes();
            $this->m_29->EditValue = $this->m_29->CurrentValue;
            $this->m_29->PlaceHolder = RemoveHtml($this->m_29->caption());
            if (strval($this->m_29->EditValue) != "" && is_numeric($this->m_29->EditValue)) {
                $this->m_29->EditValue = FormatNumber($this->m_29->EditValue, null);
            }

            // 30
            $this->_30->setupEditAttributes();
            if (!$this->_30->Raw) {
                $this->_30->CurrentValue = HtmlDecode($this->_30->CurrentValue);
            }
            $this->_30->EditValue = HtmlEncode($this->_30->CurrentValue);
            $this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

            // m_30
            $this->m_30->setupEditAttributes();
            $this->m_30->EditValue = $this->m_30->CurrentValue;
            $this->m_30->PlaceHolder = RemoveHtml($this->m_30->caption());
            if (strval($this->m_30->EditValue) != "" && is_numeric($this->m_30->EditValue)) {
                $this->m_30->EditValue = FormatNumber($this->m_30->EditValue, null);
            }

            // 31
            $this->_31->setupEditAttributes();
            if (!$this->_31->Raw) {
                $this->_31->CurrentValue = HtmlDecode($this->_31->CurrentValue);
            }
            $this->_31->EditValue = HtmlEncode($this->_31->CurrentValue);
            $this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

            // m_31
            $this->m_31->setupEditAttributes();
            $this->m_31->EditValue = $this->m_31->CurrentValue;
            $this->m_31->PlaceHolder = RemoveHtml($this->m_31->caption());
            if (strval($this->m_31->EditValue) != "" && is_numeric($this->m_31->EditValue)) {
                $this->m_31->EditValue = FormatNumber($this->m_31->EditValue, null);
            }

            // 32
            $this->_32->setupEditAttributes();
            if (!$this->_32->Raw) {
                $this->_32->CurrentValue = HtmlDecode($this->_32->CurrentValue);
            }
            $this->_32->EditValue = HtmlEncode($this->_32->CurrentValue);
            $this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

            // m_32
            $this->m_32->setupEditAttributes();
            $this->m_32->EditValue = $this->m_32->CurrentValue;
            $this->m_32->PlaceHolder = RemoveHtml($this->m_32->caption());
            if (strval($this->m_32->EditValue) != "" && is_numeric($this->m_32->EditValue)) {
                $this->m_32->EditValue = FormatNumber($this->m_32->EditValue, null);
            }

            // 33
            $this->_33->setupEditAttributes();
            if (!$this->_33->Raw) {
                $this->_33->CurrentValue = HtmlDecode($this->_33->CurrentValue);
            }
            $this->_33->EditValue = HtmlEncode($this->_33->CurrentValue);
            $this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

            // m_33
            $this->m_33->setupEditAttributes();
            $this->m_33->EditValue = $this->m_33->CurrentValue;
            $this->m_33->PlaceHolder = RemoveHtml($this->m_33->caption());
            if (strval($this->m_33->EditValue) != "" && is_numeric($this->m_33->EditValue)) {
                $this->m_33->EditValue = FormatNumber($this->m_33->EditValue, null);
            }

            // 34
            $this->_34->setupEditAttributes();
            if (!$this->_34->Raw) {
                $this->_34->CurrentValue = HtmlDecode($this->_34->CurrentValue);
            }
            $this->_34->EditValue = HtmlEncode($this->_34->CurrentValue);
            $this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

            // m_34
            $this->m_34->setupEditAttributes();
            $this->m_34->EditValue = $this->m_34->CurrentValue;
            $this->m_34->PlaceHolder = RemoveHtml($this->m_34->caption());
            if (strval($this->m_34->EditValue) != "" && is_numeric($this->m_34->EditValue)) {
                $this->m_34->EditValue = FormatNumber($this->m_34->EditValue, null);
            }

            // 35
            $this->_35->setupEditAttributes();
            if (!$this->_35->Raw) {
                $this->_35->CurrentValue = HtmlDecode($this->_35->CurrentValue);
            }
            $this->_35->EditValue = HtmlEncode($this->_35->CurrentValue);
            $this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

            // m_35
            $this->m_35->setupEditAttributes();
            $this->m_35->EditValue = $this->m_35->CurrentValue;
            $this->m_35->PlaceHolder = RemoveHtml($this->m_35->caption());
            if (strval($this->m_35->EditValue) != "" && is_numeric($this->m_35->EditValue)) {
                $this->m_35->EditValue = FormatNumber($this->m_35->EditValue, null);
            }

            // 36
            $this->_36->setupEditAttributes();
            if (!$this->_36->Raw) {
                $this->_36->CurrentValue = HtmlDecode($this->_36->CurrentValue);
            }
            $this->_36->EditValue = HtmlEncode($this->_36->CurrentValue);
            $this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

            // m_36
            $this->m_36->setupEditAttributes();
            $this->m_36->EditValue = $this->m_36->CurrentValue;
            $this->m_36->PlaceHolder = RemoveHtml($this->m_36->caption());
            if (strval($this->m_36->EditValue) != "" && is_numeric($this->m_36->EditValue)) {
                $this->m_36->EditValue = FormatNumber($this->m_36->EditValue, null);
            }

            // 37
            $this->_37->setupEditAttributes();
            if (!$this->_37->Raw) {
                $this->_37->CurrentValue = HtmlDecode($this->_37->CurrentValue);
            }
            $this->_37->EditValue = HtmlEncode($this->_37->CurrentValue);
            $this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

            // m_37
            $this->m_37->setupEditAttributes();
            $this->m_37->EditValue = $this->m_37->CurrentValue;
            $this->m_37->PlaceHolder = RemoveHtml($this->m_37->caption());
            if (strval($this->m_37->EditValue) != "" && is_numeric($this->m_37->EditValue)) {
                $this->m_37->EditValue = FormatNumber($this->m_37->EditValue, null);
            }

            // 38
            $this->_38->setupEditAttributes();
            if (!$this->_38->Raw) {
                $this->_38->CurrentValue = HtmlDecode($this->_38->CurrentValue);
            }
            $this->_38->EditValue = HtmlEncode($this->_38->CurrentValue);
            $this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

            // m_38
            $this->m_38->setupEditAttributes();
            $this->m_38->EditValue = $this->m_38->CurrentValue;
            $this->m_38->PlaceHolder = RemoveHtml($this->m_38->caption());
            if (strval($this->m_38->EditValue) != "" && is_numeric($this->m_38->EditValue)) {
                $this->m_38->EditValue = FormatNumber($this->m_38->EditValue, null);
            }

            // 39
            $this->_39->setupEditAttributes();
            if (!$this->_39->Raw) {
                $this->_39->CurrentValue = HtmlDecode($this->_39->CurrentValue);
            }
            $this->_39->EditValue = HtmlEncode($this->_39->CurrentValue);
            $this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

            // m_39
            $this->m_39->setupEditAttributes();
            $this->m_39->EditValue = $this->m_39->CurrentValue;
            $this->m_39->PlaceHolder = RemoveHtml($this->m_39->caption());
            if (strval($this->m_39->EditValue) != "" && is_numeric($this->m_39->EditValue)) {
                $this->m_39->EditValue = FormatNumber($this->m_39->EditValue, null);
            }

            // 40
            $this->_40->setupEditAttributes();
            if (!$this->_40->Raw) {
                $this->_40->CurrentValue = HtmlDecode($this->_40->CurrentValue);
            }
            $this->_40->EditValue = HtmlEncode($this->_40->CurrentValue);
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

            // m_40
            $this->m_40->setupEditAttributes();
            $this->m_40->EditValue = $this->m_40->CurrentValue;
            $this->m_40->PlaceHolder = RemoveHtml($this->m_40->caption());
            if (strval($this->m_40->EditValue) != "" && is_numeric($this->m_40->EditValue)) {
                $this->m_40->EditValue = FormatNumber($this->m_40->EditValue, null);
            }

            // 41
            $this->_41->setupEditAttributes();
            if (!$this->_41->Raw) {
                $this->_41->CurrentValue = HtmlDecode($this->_41->CurrentValue);
            }
            $this->_41->EditValue = HtmlEncode($this->_41->CurrentValue);
            $this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

            // m_41
            $this->m_41->setupEditAttributes();
            $this->m_41->EditValue = $this->m_41->CurrentValue;
            $this->m_41->PlaceHolder = RemoveHtml($this->m_41->caption());
            if (strval($this->m_41->EditValue) != "" && is_numeric($this->m_41->EditValue)) {
                $this->m_41->EditValue = FormatNumber($this->m_41->EditValue, null);
            }

            // 42
            $this->_42->setupEditAttributes();
            if (!$this->_42->Raw) {
                $this->_42->CurrentValue = HtmlDecode($this->_42->CurrentValue);
            }
            $this->_42->EditValue = HtmlEncode($this->_42->CurrentValue);
            $this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

            // m_42
            $this->m_42->setupEditAttributes();
            $this->m_42->EditValue = $this->m_42->CurrentValue;
            $this->m_42->PlaceHolder = RemoveHtml($this->m_42->caption());
            if (strval($this->m_42->EditValue) != "" && is_numeric($this->m_42->EditValue)) {
                $this->m_42->EditValue = FormatNumber($this->m_42->EditValue, null);
            }

            // 43
            $this->_43->setupEditAttributes();
            if (!$this->_43->Raw) {
                $this->_43->CurrentValue = HtmlDecode($this->_43->CurrentValue);
            }
            $this->_43->EditValue = HtmlEncode($this->_43->CurrentValue);
            $this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

            // m_43
            $this->m_43->setupEditAttributes();
            $this->m_43->EditValue = $this->m_43->CurrentValue;
            $this->m_43->PlaceHolder = RemoveHtml($this->m_43->caption());
            if (strval($this->m_43->EditValue) != "" && is_numeric($this->m_43->EditValue)) {
                $this->m_43->EditValue = FormatNumber($this->m_43->EditValue, null);
            }

            // 44
            $this->_44->setupEditAttributes();
            if (!$this->_44->Raw) {
                $this->_44->CurrentValue = HtmlDecode($this->_44->CurrentValue);
            }
            $this->_44->EditValue = HtmlEncode($this->_44->CurrentValue);
            $this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

            // m_44
            $this->m_44->setupEditAttributes();
            $this->m_44->EditValue = $this->m_44->CurrentValue;
            $this->m_44->PlaceHolder = RemoveHtml($this->m_44->caption());
            if (strval($this->m_44->EditValue) != "" && is_numeric($this->m_44->EditValue)) {
                $this->m_44->EditValue = FormatNumber($this->m_44->EditValue, null);
            }

            // 45
            $this->_45->setupEditAttributes();
            if (!$this->_45->Raw) {
                $this->_45->CurrentValue = HtmlDecode($this->_45->CurrentValue);
            }
            $this->_45->EditValue = HtmlEncode($this->_45->CurrentValue);
            $this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

            // m_45
            $this->m_45->setupEditAttributes();
            $this->m_45->EditValue = $this->m_45->CurrentValue;
            $this->m_45->PlaceHolder = RemoveHtml($this->m_45->caption());
            if (strval($this->m_45->EditValue) != "" && is_numeric($this->m_45->EditValue)) {
                $this->m_45->EditValue = FormatNumber($this->m_45->EditValue, null);
            }

            // 46
            $this->_46->setupEditAttributes();
            if (!$this->_46->Raw) {
                $this->_46->CurrentValue = HtmlDecode($this->_46->CurrentValue);
            }
            $this->_46->EditValue = HtmlEncode($this->_46->CurrentValue);
            $this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

            // m_46
            $this->m_46->setupEditAttributes();
            $this->m_46->EditValue = $this->m_46->CurrentValue;
            $this->m_46->PlaceHolder = RemoveHtml($this->m_46->caption());
            if (strval($this->m_46->EditValue) != "" && is_numeric($this->m_46->EditValue)) {
                $this->m_46->EditValue = FormatNumber($this->m_46->EditValue, null);
            }

            // 47
            $this->_47->setupEditAttributes();
            if (!$this->_47->Raw) {
                $this->_47->CurrentValue = HtmlDecode($this->_47->CurrentValue);
            }
            $this->_47->EditValue = HtmlEncode($this->_47->CurrentValue);
            $this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

            // m_47
            $this->m_47->setupEditAttributes();
            $this->m_47->EditValue = $this->m_47->CurrentValue;
            $this->m_47->PlaceHolder = RemoveHtml($this->m_47->caption());
            if (strval($this->m_47->EditValue) != "" && is_numeric($this->m_47->EditValue)) {
                $this->m_47->EditValue = FormatNumber($this->m_47->EditValue, null);
            }

            // 48
            $this->_48->setupEditAttributes();
            if (!$this->_48->Raw) {
                $this->_48->CurrentValue = HtmlDecode($this->_48->CurrentValue);
            }
            $this->_48->EditValue = HtmlEncode($this->_48->CurrentValue);
            $this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

            // m_48
            $this->m_48->setupEditAttributes();
            $this->m_48->EditValue = $this->m_48->CurrentValue;
            $this->m_48->PlaceHolder = RemoveHtml($this->m_48->caption());
            if (strval($this->m_48->EditValue) != "" && is_numeric($this->m_48->EditValue)) {
                $this->m_48->EditValue = FormatNumber($this->m_48->EditValue, null);
            }

            // 49
            $this->_49->setupEditAttributes();
            if (!$this->_49->Raw) {
                $this->_49->CurrentValue = HtmlDecode($this->_49->CurrentValue);
            }
            $this->_49->EditValue = HtmlEncode($this->_49->CurrentValue);
            $this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

            // m_49
            $this->m_49->setupEditAttributes();
            $this->m_49->EditValue = $this->m_49->CurrentValue;
            $this->m_49->PlaceHolder = RemoveHtml($this->m_49->caption());
            if (strval($this->m_49->EditValue) != "" && is_numeric($this->m_49->EditValue)) {
                $this->m_49->EditValue = FormatNumber($this->m_49->EditValue, null);
            }

            // 50
            $this->_50->setupEditAttributes();
            if (!$this->_50->Raw) {
                $this->_50->CurrentValue = HtmlDecode($this->_50->CurrentValue);
            }
            $this->_50->EditValue = HtmlEncode($this->_50->CurrentValue);
            $this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

            // m_50
            $this->m_50->setupEditAttributes();
            $this->m_50->EditValue = $this->m_50->CurrentValue;
            $this->m_50->PlaceHolder = RemoveHtml($this->m_50->caption());
            if (strval($this->m_50->EditValue) != "" && is_numeric($this->m_50->EditValue)) {
                $this->m_50->EditValue = FormatNumber($this->m_50->EditValue, null);
            }

            // 51
            $this->_51->setupEditAttributes();
            if (!$this->_51->Raw) {
                $this->_51->CurrentValue = HtmlDecode($this->_51->CurrentValue);
            }
            $this->_51->EditValue = HtmlEncode($this->_51->CurrentValue);
            $this->_51->PlaceHolder = RemoveHtml($this->_51->caption());

            // m_51
            $this->m_51->setupEditAttributes();
            $this->m_51->EditValue = $this->m_51->CurrentValue;
            $this->m_51->PlaceHolder = RemoveHtml($this->m_51->caption());
            if (strval($this->m_51->EditValue) != "" && is_numeric($this->m_51->EditValue)) {
                $this->m_51->EditValue = FormatNumber($this->m_51->EditValue, null);
            }

            // 52
            $this->_52->setupEditAttributes();
            if (!$this->_52->Raw) {
                $this->_52->CurrentValue = HtmlDecode($this->_52->CurrentValue);
            }
            $this->_52->EditValue = HtmlEncode($this->_52->CurrentValue);
            $this->_52->PlaceHolder = RemoveHtml($this->_52->caption());

            // m_52
            $this->m_52->setupEditAttributes();
            $this->m_52->EditValue = $this->m_52->CurrentValue;
            $this->m_52->PlaceHolder = RemoveHtml($this->m_52->caption());
            if (strval($this->m_52->EditValue) != "" && is_numeric($this->m_52->EditValue)) {
                $this->m_52->EditValue = FormatNumber($this->m_52->EditValue, null);
            }

            // 53
            $this->_53->setupEditAttributes();
            if (!$this->_53->Raw) {
                $this->_53->CurrentValue = HtmlDecode($this->_53->CurrentValue);
            }
            $this->_53->EditValue = HtmlEncode($this->_53->CurrentValue);
            $this->_53->PlaceHolder = RemoveHtml($this->_53->caption());

            // m_53
            $this->m_53->setupEditAttributes();
            $this->m_53->EditValue = $this->m_53->CurrentValue;
            $this->m_53->PlaceHolder = RemoveHtml($this->m_53->caption());
            if (strval($this->m_53->EditValue) != "" && is_numeric($this->m_53->EditValue)) {
                $this->m_53->EditValue = FormatNumber($this->m_53->EditValue, null);
            }

            // 54
            $this->_54->setupEditAttributes();
            if (!$this->_54->Raw) {
                $this->_54->CurrentValue = HtmlDecode($this->_54->CurrentValue);
            }
            $this->_54->EditValue = HtmlEncode($this->_54->CurrentValue);
            $this->_54->PlaceHolder = RemoveHtml($this->_54->caption());

            // m_54
            $this->m_54->setupEditAttributes();
            $this->m_54->EditValue = $this->m_54->CurrentValue;
            $this->m_54->PlaceHolder = RemoveHtml($this->m_54->caption());
            if (strval($this->m_54->EditValue) != "" && is_numeric($this->m_54->EditValue)) {
                $this->m_54->EditValue = FormatNumber($this->m_54->EditValue, null);
            }

            // 55
            $this->_55->setupEditAttributes();
            if (!$this->_55->Raw) {
                $this->_55->CurrentValue = HtmlDecode($this->_55->CurrentValue);
            }
            $this->_55->EditValue = HtmlEncode($this->_55->CurrentValue);
            $this->_55->PlaceHolder = RemoveHtml($this->_55->caption());

            // m_55
            $this->m_55->setupEditAttributes();
            $this->m_55->EditValue = $this->m_55->CurrentValue;
            $this->m_55->PlaceHolder = RemoveHtml($this->m_55->caption());
            if (strval($this->m_55->EditValue) != "" && is_numeric($this->m_55->EditValue)) {
                $this->m_55->EditValue = FormatNumber($this->m_55->EditValue, null);
            }

            // 56
            $this->_56->setupEditAttributes();
            if (!$this->_56->Raw) {
                $this->_56->CurrentValue = HtmlDecode($this->_56->CurrentValue);
            }
            $this->_56->EditValue = HtmlEncode($this->_56->CurrentValue);
            $this->_56->PlaceHolder = RemoveHtml($this->_56->caption());

            // m_56
            $this->m_56->setupEditAttributes();
            $this->m_56->EditValue = $this->m_56->CurrentValue;
            $this->m_56->PlaceHolder = RemoveHtml($this->m_56->caption());
            if (strval($this->m_56->EditValue) != "" && is_numeric($this->m_56->EditValue)) {
                $this->m_56->EditValue = FormatNumber($this->m_56->EditValue, null);
            }

            // 57
            $this->_57->setupEditAttributes();
            if (!$this->_57->Raw) {
                $this->_57->CurrentValue = HtmlDecode($this->_57->CurrentValue);
            }
            $this->_57->EditValue = HtmlEncode($this->_57->CurrentValue);
            $this->_57->PlaceHolder = RemoveHtml($this->_57->caption());

            // m_57
            $this->m_57->setupEditAttributes();
            $this->m_57->EditValue = $this->m_57->CurrentValue;
            $this->m_57->PlaceHolder = RemoveHtml($this->m_57->caption());
            if (strval($this->m_57->EditValue) != "" && is_numeric($this->m_57->EditValue)) {
                $this->m_57->EditValue = FormatNumber($this->m_57->EditValue, null);
            }

            // 58
            $this->_58->setupEditAttributes();
            if (!$this->_58->Raw) {
                $this->_58->CurrentValue = HtmlDecode($this->_58->CurrentValue);
            }
            $this->_58->EditValue = HtmlEncode($this->_58->CurrentValue);
            $this->_58->PlaceHolder = RemoveHtml($this->_58->caption());

            // m_58
            $this->m_58->setupEditAttributes();
            $this->m_58->EditValue = $this->m_58->CurrentValue;
            $this->m_58->PlaceHolder = RemoveHtml($this->m_58->caption());
            if (strval($this->m_58->EditValue) != "" && is_numeric($this->m_58->EditValue)) {
                $this->m_58->EditValue = FormatNumber($this->m_58->EditValue, null);
            }

            // 59
            $this->_59->setupEditAttributes();
            if (!$this->_59->Raw) {
                $this->_59->CurrentValue = HtmlDecode($this->_59->CurrentValue);
            }
            $this->_59->EditValue = HtmlEncode($this->_59->CurrentValue);
            $this->_59->PlaceHolder = RemoveHtml($this->_59->caption());

            // m_59
            $this->m_59->setupEditAttributes();
            $this->m_59->EditValue = $this->m_59->CurrentValue;
            $this->m_59->PlaceHolder = RemoveHtml($this->m_59->caption());
            if (strval($this->m_59->EditValue) != "" && is_numeric($this->m_59->EditValue)) {
                $this->m_59->EditValue = FormatNumber($this->m_59->EditValue, null);
            }

            // 60
            $this->_60->setupEditAttributes();
            if (!$this->_60->Raw) {
                $this->_60->CurrentValue = HtmlDecode($this->_60->CurrentValue);
            }
            $this->_60->EditValue = HtmlEncode($this->_60->CurrentValue);
            $this->_60->PlaceHolder = RemoveHtml($this->_60->caption());

            // m_60
            $this->m_60->setupEditAttributes();
            $this->m_60->EditValue = $this->m_60->CurrentValue;
            $this->m_60->PlaceHolder = RemoveHtml($this->m_60->caption());
            if (strval($this->m_60->EditValue) != "" && is_numeric($this->m_60->EditValue)) {
                $this->m_60->EditValue = FormatNumber($this->m_60->EditValue, null);
            }

            // Add refer script

            // roll_no
            $this->roll_no->HrefValue = "";

            // test_id
            $this->test_id->HrefValue = "";

            // total
            $this->total->HrefValue = "";

            // percent
            $this->percent->HrefValue = "";

            // s_1
            $this->s_1->HrefValue = "";

            // s_2
            $this->s_2->HrefValue = "";

            // s_3
            $this->s_3->HrefValue = "";

            // s_4
            $this->s_4->HrefValue = "";

            // s_5
            $this->s_5->HrefValue = "";

            // omr_image
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath(); // PHP
            if (!EmptyValue($this->omr_image->Upload->DbValue)) {
                $this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->htmlDecode($this->omr_image->Upload->DbValue)); // Add prefix/suffix
                $this->omr_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
                }
            } else {
                $this->omr_image->HrefValue = "";
            }
            $this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;

            // 1
            $this->_1->HrefValue = "";

            // m_1
            $this->m_1->HrefValue = "";

            // 2
            $this->_2->HrefValue = "";

            // m_2
            $this->m_2->HrefValue = "";

            // 3
            $this->_3->HrefValue = "";

            // m_3
            $this->m_3->HrefValue = "";

            // 4
            $this->_4->HrefValue = "";

            // m_4
            $this->m_4->HrefValue = "";

            // 5
            $this->_5->HrefValue = "";

            // m_5
            $this->m_5->HrefValue = "";

            // 6
            $this->_6->HrefValue = "";

            // m_6
            $this->m_6->HrefValue = "";

            // 7
            $this->_7->HrefValue = "";

            // m_7
            $this->m_7->HrefValue = "";

            // 8
            $this->_8->HrefValue = "";

            // m_8
            $this->m_8->HrefValue = "";

            // 9
            $this->_9->HrefValue = "";

            // m_9
            $this->m_9->HrefValue = "";

            // 10
            $this->_10->HrefValue = "";

            // m_10
            $this->m_10->HrefValue = "";

            // 11
            $this->_11->HrefValue = "";

            // m_11
            $this->m_11->HrefValue = "";

            // 12
            $this->_12->HrefValue = "";

            // m_12
            $this->m_12->HrefValue = "";

            // 13
            $this->_13->HrefValue = "";

            // m_13
            $this->m_13->HrefValue = "";

            // 14
            $this->_14->HrefValue = "";

            // m_14
            $this->m_14->HrefValue = "";

            // 15
            $this->_15->HrefValue = "";

            // m_15
            $this->m_15->HrefValue = "";

            // 16
            $this->_16->HrefValue = "";

            // m_16
            $this->m_16->HrefValue = "";

            // 17
            $this->_17->HrefValue = "";

            // m_17
            $this->m_17->HrefValue = "";

            // 18
            $this->_18->HrefValue = "";

            // m_18
            $this->m_18->HrefValue = "";

            // 19
            $this->_19->HrefValue = "";

            // m_19
            $this->m_19->HrefValue = "";

            // 20
            $this->_20->HrefValue = "";

            // m_20
            $this->m_20->HrefValue = "";

            // 21
            $this->_21->HrefValue = "";

            // m_21
            $this->m_21->HrefValue = "";

            // 22
            $this->_22->HrefValue = "";

            // m_22
            $this->m_22->HrefValue = "";

            // 23
            $this->_23->HrefValue = "";

            // m_23
            $this->m_23->HrefValue = "";

            // 24
            $this->_24->HrefValue = "";

            // m_24
            $this->m_24->HrefValue = "";

            // 25
            $this->_25->HrefValue = "";

            // m_25
            $this->m_25->HrefValue = "";

            // 26
            $this->_26->HrefValue = "";

            // m_26
            $this->m_26->HrefValue = "";

            // 27
            $this->_27->HrefValue = "";

            // m_27
            $this->m_27->HrefValue = "";

            // 28
            $this->_28->HrefValue = "";

            // m_28
            $this->m_28->HrefValue = "";

            // 29
            $this->_29->HrefValue = "";

            // m_29
            $this->m_29->HrefValue = "";

            // 30
            $this->_30->HrefValue = "";

            // m_30
            $this->m_30->HrefValue = "";

            // 31
            $this->_31->HrefValue = "";

            // m_31
            $this->m_31->HrefValue = "";

            // 32
            $this->_32->HrefValue = "";

            // m_32
            $this->m_32->HrefValue = "";

            // 33
            $this->_33->HrefValue = "";

            // m_33
            $this->m_33->HrefValue = "";

            // 34
            $this->_34->HrefValue = "";

            // m_34
            $this->m_34->HrefValue = "";

            // 35
            $this->_35->HrefValue = "";

            // m_35
            $this->m_35->HrefValue = "";

            // 36
            $this->_36->HrefValue = "";

            // m_36
            $this->m_36->HrefValue = "";

            // 37
            $this->_37->HrefValue = "";

            // m_37
            $this->m_37->HrefValue = "";

            // 38
            $this->_38->HrefValue = "";

            // m_38
            $this->m_38->HrefValue = "";

            // 39
            $this->_39->HrefValue = "";

            // m_39
            $this->m_39->HrefValue = "";

            // 40
            $this->_40->HrefValue = "";

            // m_40
            $this->m_40->HrefValue = "";

            // 41
            $this->_41->HrefValue = "";

            // m_41
            $this->m_41->HrefValue = "";

            // 42
            $this->_42->HrefValue = "";

            // m_42
            $this->m_42->HrefValue = "";

            // 43
            $this->_43->HrefValue = "";

            // m_43
            $this->m_43->HrefValue = "";

            // 44
            $this->_44->HrefValue = "";

            // m_44
            $this->m_44->HrefValue = "";

            // 45
            $this->_45->HrefValue = "";

            // m_45
            $this->m_45->HrefValue = "";

            // 46
            $this->_46->HrefValue = "";

            // m_46
            $this->m_46->HrefValue = "";

            // 47
            $this->_47->HrefValue = "";

            // m_47
            $this->m_47->HrefValue = "";

            // 48
            $this->_48->HrefValue = "";

            // m_48
            $this->m_48->HrefValue = "";

            // 49
            $this->_49->HrefValue = "";

            // m_49
            $this->m_49->HrefValue = "";

            // 50
            $this->_50->HrefValue = "";

            // m_50
            $this->m_50->HrefValue = "";

            // 51
            $this->_51->HrefValue = "";

            // m_51
            $this->m_51->HrefValue = "";

            // 52
            $this->_52->HrefValue = "";

            // m_52
            $this->m_52->HrefValue = "";

            // 53
            $this->_53->HrefValue = "";

            // m_53
            $this->m_53->HrefValue = "";

            // 54
            $this->_54->HrefValue = "";

            // m_54
            $this->m_54->HrefValue = "";

            // 55
            $this->_55->HrefValue = "";

            // m_55
            $this->m_55->HrefValue = "";

            // 56
            $this->_56->HrefValue = "";

            // m_56
            $this->m_56->HrefValue = "";

            // 57
            $this->_57->HrefValue = "";

            // m_57
            $this->m_57->HrefValue = "";

            // 58
            $this->_58->HrefValue = "";

            // m_58
            $this->m_58->HrefValue = "";

            // 59
            $this->_59->HrefValue = "";

            // m_59
            $this->m_59->HrefValue = "";

            // 60
            $this->_60->HrefValue = "";

            // m_60
            $this->m_60->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->roll_no->Visible && $this->roll_no->Required) {
                if (!$this->roll_no->IsDetailKey && EmptyValue($this->roll_no->FormValue)) {
                    $this->roll_no->addErrorMessage(str_replace("%s", $this->roll_no->caption(), $this->roll_no->RequiredErrorMessage));
                }
            }
            if ($this->test_id->Visible && $this->test_id->Required) {
                if (!$this->test_id->IsDetailKey && EmptyValue($this->test_id->FormValue)) {
                    $this->test_id->addErrorMessage(str_replace("%s", $this->test_id->caption(), $this->test_id->RequiredErrorMessage));
                }
            }
            if ($this->total->Visible && $this->total->Required) {
                if (!$this->total->IsDetailKey && EmptyValue($this->total->FormValue)) {
                    $this->total->addErrorMessage(str_replace("%s", $this->total->caption(), $this->total->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->total->FormValue)) {
                $this->total->addErrorMessage($this->total->getErrorMessage(false));
            }
            if ($this->percent->Visible && $this->percent->Required) {
                if (!$this->percent->IsDetailKey && EmptyValue($this->percent->FormValue)) {
                    $this->percent->addErrorMessage(str_replace("%s", $this->percent->caption(), $this->percent->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->percent->FormValue)) {
                $this->percent->addErrorMessage($this->percent->getErrorMessage(false));
            }
            if ($this->s_1->Visible && $this->s_1->Required) {
                if (!$this->s_1->IsDetailKey && EmptyValue($this->s_1->FormValue)) {
                    $this->s_1->addErrorMessage(str_replace("%s", $this->s_1->caption(), $this->s_1->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->s_1->FormValue)) {
                $this->s_1->addErrorMessage($this->s_1->getErrorMessage(false));
            }
            if ($this->s_2->Visible && $this->s_2->Required) {
                if (!$this->s_2->IsDetailKey && EmptyValue($this->s_2->FormValue)) {
                    $this->s_2->addErrorMessage(str_replace("%s", $this->s_2->caption(), $this->s_2->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->s_2->FormValue)) {
                $this->s_2->addErrorMessage($this->s_2->getErrorMessage(false));
            }
            if ($this->s_3->Visible && $this->s_3->Required) {
                if (!$this->s_3->IsDetailKey && EmptyValue($this->s_3->FormValue)) {
                    $this->s_3->addErrorMessage(str_replace("%s", $this->s_3->caption(), $this->s_3->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->s_3->FormValue)) {
                $this->s_3->addErrorMessage($this->s_3->getErrorMessage(false));
            }
            if ($this->s_4->Visible && $this->s_4->Required) {
                if (!$this->s_4->IsDetailKey && EmptyValue($this->s_4->FormValue)) {
                    $this->s_4->addErrorMessage(str_replace("%s", $this->s_4->caption(), $this->s_4->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->s_4->FormValue)) {
                $this->s_4->addErrorMessage($this->s_4->getErrorMessage(false));
            }
            if ($this->s_5->Visible && $this->s_5->Required) {
                if (!$this->s_5->IsDetailKey && EmptyValue($this->s_5->FormValue)) {
                    $this->s_5->addErrorMessage(str_replace("%s", $this->s_5->caption(), $this->s_5->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->s_5->FormValue)) {
                $this->s_5->addErrorMessage($this->s_5->getErrorMessage(false));
            }
            if ($this->omr_image->Visible && $this->omr_image->Required) {
                if ($this->omr_image->Upload->FileName == "" && !$this->omr_image->Upload->KeepFile) {
                    $this->omr_image->addErrorMessage(str_replace("%s", $this->omr_image->caption(), $this->omr_image->RequiredErrorMessage));
                }
            }
            if ($this->_1->Visible && $this->_1->Required) {
                if (!$this->_1->IsDetailKey && EmptyValue($this->_1->FormValue)) {
                    $this->_1->addErrorMessage(str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
                }
            }
            if ($this->m_1->Visible && $this->m_1->Required) {
                if (!$this->m_1->IsDetailKey && EmptyValue($this->m_1->FormValue)) {
                    $this->m_1->addErrorMessage(str_replace("%s", $this->m_1->caption(), $this->m_1->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_1->FormValue)) {
                $this->m_1->addErrorMessage($this->m_1->getErrorMessage(false));
            }
            if ($this->_2->Visible && $this->_2->Required) {
                if (!$this->_2->IsDetailKey && EmptyValue($this->_2->FormValue)) {
                    $this->_2->addErrorMessage(str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
                }
            }
            if ($this->m_2->Visible && $this->m_2->Required) {
                if (!$this->m_2->IsDetailKey && EmptyValue($this->m_2->FormValue)) {
                    $this->m_2->addErrorMessage(str_replace("%s", $this->m_2->caption(), $this->m_2->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_2->FormValue)) {
                $this->m_2->addErrorMessage($this->m_2->getErrorMessage(false));
            }
            if ($this->_3->Visible && $this->_3->Required) {
                if (!$this->_3->IsDetailKey && EmptyValue($this->_3->FormValue)) {
                    $this->_3->addErrorMessage(str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
                }
            }
            if ($this->m_3->Visible && $this->m_3->Required) {
                if (!$this->m_3->IsDetailKey && EmptyValue($this->m_3->FormValue)) {
                    $this->m_3->addErrorMessage(str_replace("%s", $this->m_3->caption(), $this->m_3->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_3->FormValue)) {
                $this->m_3->addErrorMessage($this->m_3->getErrorMessage(false));
            }
            if ($this->_4->Visible && $this->_4->Required) {
                if (!$this->_4->IsDetailKey && EmptyValue($this->_4->FormValue)) {
                    $this->_4->addErrorMessage(str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
                }
            }
            if ($this->m_4->Visible && $this->m_4->Required) {
                if (!$this->m_4->IsDetailKey && EmptyValue($this->m_4->FormValue)) {
                    $this->m_4->addErrorMessage(str_replace("%s", $this->m_4->caption(), $this->m_4->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_4->FormValue)) {
                $this->m_4->addErrorMessage($this->m_4->getErrorMessage(false));
            }
            if ($this->_5->Visible && $this->_5->Required) {
                if (!$this->_5->IsDetailKey && EmptyValue($this->_5->FormValue)) {
                    $this->_5->addErrorMessage(str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
                }
            }
            if ($this->m_5->Visible && $this->m_5->Required) {
                if (!$this->m_5->IsDetailKey && EmptyValue($this->m_5->FormValue)) {
                    $this->m_5->addErrorMessage(str_replace("%s", $this->m_5->caption(), $this->m_5->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_5->FormValue)) {
                $this->m_5->addErrorMessage($this->m_5->getErrorMessage(false));
            }
            if ($this->_6->Visible && $this->_6->Required) {
                if (!$this->_6->IsDetailKey && EmptyValue($this->_6->FormValue)) {
                    $this->_6->addErrorMessage(str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
                }
            }
            if ($this->m_6->Visible && $this->m_6->Required) {
                if (!$this->m_6->IsDetailKey && EmptyValue($this->m_6->FormValue)) {
                    $this->m_6->addErrorMessage(str_replace("%s", $this->m_6->caption(), $this->m_6->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_6->FormValue)) {
                $this->m_6->addErrorMessage($this->m_6->getErrorMessage(false));
            }
            if ($this->_7->Visible && $this->_7->Required) {
                if (!$this->_7->IsDetailKey && EmptyValue($this->_7->FormValue)) {
                    $this->_7->addErrorMessage(str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
                }
            }
            if ($this->m_7->Visible && $this->m_7->Required) {
                if (!$this->m_7->IsDetailKey && EmptyValue($this->m_7->FormValue)) {
                    $this->m_7->addErrorMessage(str_replace("%s", $this->m_7->caption(), $this->m_7->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_7->FormValue)) {
                $this->m_7->addErrorMessage($this->m_7->getErrorMessage(false));
            }
            if ($this->_8->Visible && $this->_8->Required) {
                if (!$this->_8->IsDetailKey && EmptyValue($this->_8->FormValue)) {
                    $this->_8->addErrorMessage(str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
                }
            }
            if ($this->m_8->Visible && $this->m_8->Required) {
                if (!$this->m_8->IsDetailKey && EmptyValue($this->m_8->FormValue)) {
                    $this->m_8->addErrorMessage(str_replace("%s", $this->m_8->caption(), $this->m_8->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_8->FormValue)) {
                $this->m_8->addErrorMessage($this->m_8->getErrorMessage(false));
            }
            if ($this->_9->Visible && $this->_9->Required) {
                if (!$this->_9->IsDetailKey && EmptyValue($this->_9->FormValue)) {
                    $this->_9->addErrorMessage(str_replace("%s", $this->_9->caption(), $this->_9->RequiredErrorMessage));
                }
            }
            if ($this->m_9->Visible && $this->m_9->Required) {
                if (!$this->m_9->IsDetailKey && EmptyValue($this->m_9->FormValue)) {
                    $this->m_9->addErrorMessage(str_replace("%s", $this->m_9->caption(), $this->m_9->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_9->FormValue)) {
                $this->m_9->addErrorMessage($this->m_9->getErrorMessage(false));
            }
            if ($this->_10->Visible && $this->_10->Required) {
                if (!$this->_10->IsDetailKey && EmptyValue($this->_10->FormValue)) {
                    $this->_10->addErrorMessage(str_replace("%s", $this->_10->caption(), $this->_10->RequiredErrorMessage));
                }
            }
            if ($this->m_10->Visible && $this->m_10->Required) {
                if (!$this->m_10->IsDetailKey && EmptyValue($this->m_10->FormValue)) {
                    $this->m_10->addErrorMessage(str_replace("%s", $this->m_10->caption(), $this->m_10->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_10->FormValue)) {
                $this->m_10->addErrorMessage($this->m_10->getErrorMessage(false));
            }
            if ($this->_11->Visible && $this->_11->Required) {
                if (!$this->_11->IsDetailKey && EmptyValue($this->_11->FormValue)) {
                    $this->_11->addErrorMessage(str_replace("%s", $this->_11->caption(), $this->_11->RequiredErrorMessage));
                }
            }
            if ($this->m_11->Visible && $this->m_11->Required) {
                if (!$this->m_11->IsDetailKey && EmptyValue($this->m_11->FormValue)) {
                    $this->m_11->addErrorMessage(str_replace("%s", $this->m_11->caption(), $this->m_11->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_11->FormValue)) {
                $this->m_11->addErrorMessage($this->m_11->getErrorMessage(false));
            }
            if ($this->_12->Visible && $this->_12->Required) {
                if (!$this->_12->IsDetailKey && EmptyValue($this->_12->FormValue)) {
                    $this->_12->addErrorMessage(str_replace("%s", $this->_12->caption(), $this->_12->RequiredErrorMessage));
                }
            }
            if ($this->m_12->Visible && $this->m_12->Required) {
                if (!$this->m_12->IsDetailKey && EmptyValue($this->m_12->FormValue)) {
                    $this->m_12->addErrorMessage(str_replace("%s", $this->m_12->caption(), $this->m_12->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_12->FormValue)) {
                $this->m_12->addErrorMessage($this->m_12->getErrorMessage(false));
            }
            if ($this->_13->Visible && $this->_13->Required) {
                if (!$this->_13->IsDetailKey && EmptyValue($this->_13->FormValue)) {
                    $this->_13->addErrorMessage(str_replace("%s", $this->_13->caption(), $this->_13->RequiredErrorMessage));
                }
            }
            if ($this->m_13->Visible && $this->m_13->Required) {
                if (!$this->m_13->IsDetailKey && EmptyValue($this->m_13->FormValue)) {
                    $this->m_13->addErrorMessage(str_replace("%s", $this->m_13->caption(), $this->m_13->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_13->FormValue)) {
                $this->m_13->addErrorMessage($this->m_13->getErrorMessage(false));
            }
            if ($this->_14->Visible && $this->_14->Required) {
                if (!$this->_14->IsDetailKey && EmptyValue($this->_14->FormValue)) {
                    $this->_14->addErrorMessage(str_replace("%s", $this->_14->caption(), $this->_14->RequiredErrorMessage));
                }
            }
            if ($this->m_14->Visible && $this->m_14->Required) {
                if (!$this->m_14->IsDetailKey && EmptyValue($this->m_14->FormValue)) {
                    $this->m_14->addErrorMessage(str_replace("%s", $this->m_14->caption(), $this->m_14->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_14->FormValue)) {
                $this->m_14->addErrorMessage($this->m_14->getErrorMessage(false));
            }
            if ($this->_15->Visible && $this->_15->Required) {
                if (!$this->_15->IsDetailKey && EmptyValue($this->_15->FormValue)) {
                    $this->_15->addErrorMessage(str_replace("%s", $this->_15->caption(), $this->_15->RequiredErrorMessage));
                }
            }
            if ($this->m_15->Visible && $this->m_15->Required) {
                if (!$this->m_15->IsDetailKey && EmptyValue($this->m_15->FormValue)) {
                    $this->m_15->addErrorMessage(str_replace("%s", $this->m_15->caption(), $this->m_15->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_15->FormValue)) {
                $this->m_15->addErrorMessage($this->m_15->getErrorMessage(false));
            }
            if ($this->_16->Visible && $this->_16->Required) {
                if (!$this->_16->IsDetailKey && EmptyValue($this->_16->FormValue)) {
                    $this->_16->addErrorMessage(str_replace("%s", $this->_16->caption(), $this->_16->RequiredErrorMessage));
                }
            }
            if ($this->m_16->Visible && $this->m_16->Required) {
                if (!$this->m_16->IsDetailKey && EmptyValue($this->m_16->FormValue)) {
                    $this->m_16->addErrorMessage(str_replace("%s", $this->m_16->caption(), $this->m_16->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_16->FormValue)) {
                $this->m_16->addErrorMessage($this->m_16->getErrorMessage(false));
            }
            if ($this->_17->Visible && $this->_17->Required) {
                if (!$this->_17->IsDetailKey && EmptyValue($this->_17->FormValue)) {
                    $this->_17->addErrorMessage(str_replace("%s", $this->_17->caption(), $this->_17->RequiredErrorMessage));
                }
            }
            if ($this->m_17->Visible && $this->m_17->Required) {
                if (!$this->m_17->IsDetailKey && EmptyValue($this->m_17->FormValue)) {
                    $this->m_17->addErrorMessage(str_replace("%s", $this->m_17->caption(), $this->m_17->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_17->FormValue)) {
                $this->m_17->addErrorMessage($this->m_17->getErrorMessage(false));
            }
            if ($this->_18->Visible && $this->_18->Required) {
                if (!$this->_18->IsDetailKey && EmptyValue($this->_18->FormValue)) {
                    $this->_18->addErrorMessage(str_replace("%s", $this->_18->caption(), $this->_18->RequiredErrorMessage));
                }
            }
            if ($this->m_18->Visible && $this->m_18->Required) {
                if (!$this->m_18->IsDetailKey && EmptyValue($this->m_18->FormValue)) {
                    $this->m_18->addErrorMessage(str_replace("%s", $this->m_18->caption(), $this->m_18->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_18->FormValue)) {
                $this->m_18->addErrorMessage($this->m_18->getErrorMessage(false));
            }
            if ($this->_19->Visible && $this->_19->Required) {
                if (!$this->_19->IsDetailKey && EmptyValue($this->_19->FormValue)) {
                    $this->_19->addErrorMessage(str_replace("%s", $this->_19->caption(), $this->_19->RequiredErrorMessage));
                }
            }
            if ($this->m_19->Visible && $this->m_19->Required) {
                if (!$this->m_19->IsDetailKey && EmptyValue($this->m_19->FormValue)) {
                    $this->m_19->addErrorMessage(str_replace("%s", $this->m_19->caption(), $this->m_19->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_19->FormValue)) {
                $this->m_19->addErrorMessage($this->m_19->getErrorMessage(false));
            }
            if ($this->_20->Visible && $this->_20->Required) {
                if (!$this->_20->IsDetailKey && EmptyValue($this->_20->FormValue)) {
                    $this->_20->addErrorMessage(str_replace("%s", $this->_20->caption(), $this->_20->RequiredErrorMessage));
                }
            }
            if ($this->m_20->Visible && $this->m_20->Required) {
                if (!$this->m_20->IsDetailKey && EmptyValue($this->m_20->FormValue)) {
                    $this->m_20->addErrorMessage(str_replace("%s", $this->m_20->caption(), $this->m_20->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_20->FormValue)) {
                $this->m_20->addErrorMessage($this->m_20->getErrorMessage(false));
            }
            if ($this->_21->Visible && $this->_21->Required) {
                if (!$this->_21->IsDetailKey && EmptyValue($this->_21->FormValue)) {
                    $this->_21->addErrorMessage(str_replace("%s", $this->_21->caption(), $this->_21->RequiredErrorMessage));
                }
            }
            if ($this->m_21->Visible && $this->m_21->Required) {
                if (!$this->m_21->IsDetailKey && EmptyValue($this->m_21->FormValue)) {
                    $this->m_21->addErrorMessage(str_replace("%s", $this->m_21->caption(), $this->m_21->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_21->FormValue)) {
                $this->m_21->addErrorMessage($this->m_21->getErrorMessage(false));
            }
            if ($this->_22->Visible && $this->_22->Required) {
                if (!$this->_22->IsDetailKey && EmptyValue($this->_22->FormValue)) {
                    $this->_22->addErrorMessage(str_replace("%s", $this->_22->caption(), $this->_22->RequiredErrorMessage));
                }
            }
            if ($this->m_22->Visible && $this->m_22->Required) {
                if (!$this->m_22->IsDetailKey && EmptyValue($this->m_22->FormValue)) {
                    $this->m_22->addErrorMessage(str_replace("%s", $this->m_22->caption(), $this->m_22->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_22->FormValue)) {
                $this->m_22->addErrorMessage($this->m_22->getErrorMessage(false));
            }
            if ($this->_23->Visible && $this->_23->Required) {
                if (!$this->_23->IsDetailKey && EmptyValue($this->_23->FormValue)) {
                    $this->_23->addErrorMessage(str_replace("%s", $this->_23->caption(), $this->_23->RequiredErrorMessage));
                }
            }
            if ($this->m_23->Visible && $this->m_23->Required) {
                if (!$this->m_23->IsDetailKey && EmptyValue($this->m_23->FormValue)) {
                    $this->m_23->addErrorMessage(str_replace("%s", $this->m_23->caption(), $this->m_23->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_23->FormValue)) {
                $this->m_23->addErrorMessage($this->m_23->getErrorMessage(false));
            }
            if ($this->_24->Visible && $this->_24->Required) {
                if (!$this->_24->IsDetailKey && EmptyValue($this->_24->FormValue)) {
                    $this->_24->addErrorMessage(str_replace("%s", $this->_24->caption(), $this->_24->RequiredErrorMessage));
                }
            }
            if ($this->m_24->Visible && $this->m_24->Required) {
                if (!$this->m_24->IsDetailKey && EmptyValue($this->m_24->FormValue)) {
                    $this->m_24->addErrorMessage(str_replace("%s", $this->m_24->caption(), $this->m_24->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_24->FormValue)) {
                $this->m_24->addErrorMessage($this->m_24->getErrorMessage(false));
            }
            if ($this->_25->Visible && $this->_25->Required) {
                if (!$this->_25->IsDetailKey && EmptyValue($this->_25->FormValue)) {
                    $this->_25->addErrorMessage(str_replace("%s", $this->_25->caption(), $this->_25->RequiredErrorMessage));
                }
            }
            if ($this->m_25->Visible && $this->m_25->Required) {
                if (!$this->m_25->IsDetailKey && EmptyValue($this->m_25->FormValue)) {
                    $this->m_25->addErrorMessage(str_replace("%s", $this->m_25->caption(), $this->m_25->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_25->FormValue)) {
                $this->m_25->addErrorMessage($this->m_25->getErrorMessage(false));
            }
            if ($this->_26->Visible && $this->_26->Required) {
                if (!$this->_26->IsDetailKey && EmptyValue($this->_26->FormValue)) {
                    $this->_26->addErrorMessage(str_replace("%s", $this->_26->caption(), $this->_26->RequiredErrorMessage));
                }
            }
            if ($this->m_26->Visible && $this->m_26->Required) {
                if (!$this->m_26->IsDetailKey && EmptyValue($this->m_26->FormValue)) {
                    $this->m_26->addErrorMessage(str_replace("%s", $this->m_26->caption(), $this->m_26->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_26->FormValue)) {
                $this->m_26->addErrorMessage($this->m_26->getErrorMessage(false));
            }
            if ($this->_27->Visible && $this->_27->Required) {
                if (!$this->_27->IsDetailKey && EmptyValue($this->_27->FormValue)) {
                    $this->_27->addErrorMessage(str_replace("%s", $this->_27->caption(), $this->_27->RequiredErrorMessage));
                }
            }
            if ($this->m_27->Visible && $this->m_27->Required) {
                if (!$this->m_27->IsDetailKey && EmptyValue($this->m_27->FormValue)) {
                    $this->m_27->addErrorMessage(str_replace("%s", $this->m_27->caption(), $this->m_27->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_27->FormValue)) {
                $this->m_27->addErrorMessage($this->m_27->getErrorMessage(false));
            }
            if ($this->_28->Visible && $this->_28->Required) {
                if (!$this->_28->IsDetailKey && EmptyValue($this->_28->FormValue)) {
                    $this->_28->addErrorMessage(str_replace("%s", $this->_28->caption(), $this->_28->RequiredErrorMessage));
                }
            }
            if ($this->m_28->Visible && $this->m_28->Required) {
                if (!$this->m_28->IsDetailKey && EmptyValue($this->m_28->FormValue)) {
                    $this->m_28->addErrorMessage(str_replace("%s", $this->m_28->caption(), $this->m_28->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_28->FormValue)) {
                $this->m_28->addErrorMessage($this->m_28->getErrorMessage(false));
            }
            if ($this->_29->Visible && $this->_29->Required) {
                if (!$this->_29->IsDetailKey && EmptyValue($this->_29->FormValue)) {
                    $this->_29->addErrorMessage(str_replace("%s", $this->_29->caption(), $this->_29->RequiredErrorMessage));
                }
            }
            if ($this->m_29->Visible && $this->m_29->Required) {
                if (!$this->m_29->IsDetailKey && EmptyValue($this->m_29->FormValue)) {
                    $this->m_29->addErrorMessage(str_replace("%s", $this->m_29->caption(), $this->m_29->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_29->FormValue)) {
                $this->m_29->addErrorMessage($this->m_29->getErrorMessage(false));
            }
            if ($this->_30->Visible && $this->_30->Required) {
                if (!$this->_30->IsDetailKey && EmptyValue($this->_30->FormValue)) {
                    $this->_30->addErrorMessage(str_replace("%s", $this->_30->caption(), $this->_30->RequiredErrorMessage));
                }
            }
            if ($this->m_30->Visible && $this->m_30->Required) {
                if (!$this->m_30->IsDetailKey && EmptyValue($this->m_30->FormValue)) {
                    $this->m_30->addErrorMessage(str_replace("%s", $this->m_30->caption(), $this->m_30->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_30->FormValue)) {
                $this->m_30->addErrorMessage($this->m_30->getErrorMessage(false));
            }
            if ($this->_31->Visible && $this->_31->Required) {
                if (!$this->_31->IsDetailKey && EmptyValue($this->_31->FormValue)) {
                    $this->_31->addErrorMessage(str_replace("%s", $this->_31->caption(), $this->_31->RequiredErrorMessage));
                }
            }
            if ($this->m_31->Visible && $this->m_31->Required) {
                if (!$this->m_31->IsDetailKey && EmptyValue($this->m_31->FormValue)) {
                    $this->m_31->addErrorMessage(str_replace("%s", $this->m_31->caption(), $this->m_31->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_31->FormValue)) {
                $this->m_31->addErrorMessage($this->m_31->getErrorMessage(false));
            }
            if ($this->_32->Visible && $this->_32->Required) {
                if (!$this->_32->IsDetailKey && EmptyValue($this->_32->FormValue)) {
                    $this->_32->addErrorMessage(str_replace("%s", $this->_32->caption(), $this->_32->RequiredErrorMessage));
                }
            }
            if ($this->m_32->Visible && $this->m_32->Required) {
                if (!$this->m_32->IsDetailKey && EmptyValue($this->m_32->FormValue)) {
                    $this->m_32->addErrorMessage(str_replace("%s", $this->m_32->caption(), $this->m_32->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_32->FormValue)) {
                $this->m_32->addErrorMessage($this->m_32->getErrorMessage(false));
            }
            if ($this->_33->Visible && $this->_33->Required) {
                if (!$this->_33->IsDetailKey && EmptyValue($this->_33->FormValue)) {
                    $this->_33->addErrorMessage(str_replace("%s", $this->_33->caption(), $this->_33->RequiredErrorMessage));
                }
            }
            if ($this->m_33->Visible && $this->m_33->Required) {
                if (!$this->m_33->IsDetailKey && EmptyValue($this->m_33->FormValue)) {
                    $this->m_33->addErrorMessage(str_replace("%s", $this->m_33->caption(), $this->m_33->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_33->FormValue)) {
                $this->m_33->addErrorMessage($this->m_33->getErrorMessage(false));
            }
            if ($this->_34->Visible && $this->_34->Required) {
                if (!$this->_34->IsDetailKey && EmptyValue($this->_34->FormValue)) {
                    $this->_34->addErrorMessage(str_replace("%s", $this->_34->caption(), $this->_34->RequiredErrorMessage));
                }
            }
            if ($this->m_34->Visible && $this->m_34->Required) {
                if (!$this->m_34->IsDetailKey && EmptyValue($this->m_34->FormValue)) {
                    $this->m_34->addErrorMessage(str_replace("%s", $this->m_34->caption(), $this->m_34->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_34->FormValue)) {
                $this->m_34->addErrorMessage($this->m_34->getErrorMessage(false));
            }
            if ($this->_35->Visible && $this->_35->Required) {
                if (!$this->_35->IsDetailKey && EmptyValue($this->_35->FormValue)) {
                    $this->_35->addErrorMessage(str_replace("%s", $this->_35->caption(), $this->_35->RequiredErrorMessage));
                }
            }
            if ($this->m_35->Visible && $this->m_35->Required) {
                if (!$this->m_35->IsDetailKey && EmptyValue($this->m_35->FormValue)) {
                    $this->m_35->addErrorMessage(str_replace("%s", $this->m_35->caption(), $this->m_35->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_35->FormValue)) {
                $this->m_35->addErrorMessage($this->m_35->getErrorMessage(false));
            }
            if ($this->_36->Visible && $this->_36->Required) {
                if (!$this->_36->IsDetailKey && EmptyValue($this->_36->FormValue)) {
                    $this->_36->addErrorMessage(str_replace("%s", $this->_36->caption(), $this->_36->RequiredErrorMessage));
                }
            }
            if ($this->m_36->Visible && $this->m_36->Required) {
                if (!$this->m_36->IsDetailKey && EmptyValue($this->m_36->FormValue)) {
                    $this->m_36->addErrorMessage(str_replace("%s", $this->m_36->caption(), $this->m_36->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_36->FormValue)) {
                $this->m_36->addErrorMessage($this->m_36->getErrorMessage(false));
            }
            if ($this->_37->Visible && $this->_37->Required) {
                if (!$this->_37->IsDetailKey && EmptyValue($this->_37->FormValue)) {
                    $this->_37->addErrorMessage(str_replace("%s", $this->_37->caption(), $this->_37->RequiredErrorMessage));
                }
            }
            if ($this->m_37->Visible && $this->m_37->Required) {
                if (!$this->m_37->IsDetailKey && EmptyValue($this->m_37->FormValue)) {
                    $this->m_37->addErrorMessage(str_replace("%s", $this->m_37->caption(), $this->m_37->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_37->FormValue)) {
                $this->m_37->addErrorMessage($this->m_37->getErrorMessage(false));
            }
            if ($this->_38->Visible && $this->_38->Required) {
                if (!$this->_38->IsDetailKey && EmptyValue($this->_38->FormValue)) {
                    $this->_38->addErrorMessage(str_replace("%s", $this->_38->caption(), $this->_38->RequiredErrorMessage));
                }
            }
            if ($this->m_38->Visible && $this->m_38->Required) {
                if (!$this->m_38->IsDetailKey && EmptyValue($this->m_38->FormValue)) {
                    $this->m_38->addErrorMessage(str_replace("%s", $this->m_38->caption(), $this->m_38->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_38->FormValue)) {
                $this->m_38->addErrorMessage($this->m_38->getErrorMessage(false));
            }
            if ($this->_39->Visible && $this->_39->Required) {
                if (!$this->_39->IsDetailKey && EmptyValue($this->_39->FormValue)) {
                    $this->_39->addErrorMessage(str_replace("%s", $this->_39->caption(), $this->_39->RequiredErrorMessage));
                }
            }
            if ($this->m_39->Visible && $this->m_39->Required) {
                if (!$this->m_39->IsDetailKey && EmptyValue($this->m_39->FormValue)) {
                    $this->m_39->addErrorMessage(str_replace("%s", $this->m_39->caption(), $this->m_39->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_39->FormValue)) {
                $this->m_39->addErrorMessage($this->m_39->getErrorMessage(false));
            }
            if ($this->_40->Visible && $this->_40->Required) {
                if (!$this->_40->IsDetailKey && EmptyValue($this->_40->FormValue)) {
                    $this->_40->addErrorMessage(str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
                }
            }
            if ($this->m_40->Visible && $this->m_40->Required) {
                if (!$this->m_40->IsDetailKey && EmptyValue($this->m_40->FormValue)) {
                    $this->m_40->addErrorMessage(str_replace("%s", $this->m_40->caption(), $this->m_40->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_40->FormValue)) {
                $this->m_40->addErrorMessage($this->m_40->getErrorMessage(false));
            }
            if ($this->_41->Visible && $this->_41->Required) {
                if (!$this->_41->IsDetailKey && EmptyValue($this->_41->FormValue)) {
                    $this->_41->addErrorMessage(str_replace("%s", $this->_41->caption(), $this->_41->RequiredErrorMessage));
                }
            }
            if ($this->m_41->Visible && $this->m_41->Required) {
                if (!$this->m_41->IsDetailKey && EmptyValue($this->m_41->FormValue)) {
                    $this->m_41->addErrorMessage(str_replace("%s", $this->m_41->caption(), $this->m_41->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_41->FormValue)) {
                $this->m_41->addErrorMessage($this->m_41->getErrorMessage(false));
            }
            if ($this->_42->Visible && $this->_42->Required) {
                if (!$this->_42->IsDetailKey && EmptyValue($this->_42->FormValue)) {
                    $this->_42->addErrorMessage(str_replace("%s", $this->_42->caption(), $this->_42->RequiredErrorMessage));
                }
            }
            if ($this->m_42->Visible && $this->m_42->Required) {
                if (!$this->m_42->IsDetailKey && EmptyValue($this->m_42->FormValue)) {
                    $this->m_42->addErrorMessage(str_replace("%s", $this->m_42->caption(), $this->m_42->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_42->FormValue)) {
                $this->m_42->addErrorMessage($this->m_42->getErrorMessage(false));
            }
            if ($this->_43->Visible && $this->_43->Required) {
                if (!$this->_43->IsDetailKey && EmptyValue($this->_43->FormValue)) {
                    $this->_43->addErrorMessage(str_replace("%s", $this->_43->caption(), $this->_43->RequiredErrorMessage));
                }
            }
            if ($this->m_43->Visible && $this->m_43->Required) {
                if (!$this->m_43->IsDetailKey && EmptyValue($this->m_43->FormValue)) {
                    $this->m_43->addErrorMessage(str_replace("%s", $this->m_43->caption(), $this->m_43->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_43->FormValue)) {
                $this->m_43->addErrorMessage($this->m_43->getErrorMessage(false));
            }
            if ($this->_44->Visible && $this->_44->Required) {
                if (!$this->_44->IsDetailKey && EmptyValue($this->_44->FormValue)) {
                    $this->_44->addErrorMessage(str_replace("%s", $this->_44->caption(), $this->_44->RequiredErrorMessage));
                }
            }
            if ($this->m_44->Visible && $this->m_44->Required) {
                if (!$this->m_44->IsDetailKey && EmptyValue($this->m_44->FormValue)) {
                    $this->m_44->addErrorMessage(str_replace("%s", $this->m_44->caption(), $this->m_44->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_44->FormValue)) {
                $this->m_44->addErrorMessage($this->m_44->getErrorMessage(false));
            }
            if ($this->_45->Visible && $this->_45->Required) {
                if (!$this->_45->IsDetailKey && EmptyValue($this->_45->FormValue)) {
                    $this->_45->addErrorMessage(str_replace("%s", $this->_45->caption(), $this->_45->RequiredErrorMessage));
                }
            }
            if ($this->m_45->Visible && $this->m_45->Required) {
                if (!$this->m_45->IsDetailKey && EmptyValue($this->m_45->FormValue)) {
                    $this->m_45->addErrorMessage(str_replace("%s", $this->m_45->caption(), $this->m_45->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_45->FormValue)) {
                $this->m_45->addErrorMessage($this->m_45->getErrorMessage(false));
            }
            if ($this->_46->Visible && $this->_46->Required) {
                if (!$this->_46->IsDetailKey && EmptyValue($this->_46->FormValue)) {
                    $this->_46->addErrorMessage(str_replace("%s", $this->_46->caption(), $this->_46->RequiredErrorMessage));
                }
            }
            if ($this->m_46->Visible && $this->m_46->Required) {
                if (!$this->m_46->IsDetailKey && EmptyValue($this->m_46->FormValue)) {
                    $this->m_46->addErrorMessage(str_replace("%s", $this->m_46->caption(), $this->m_46->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_46->FormValue)) {
                $this->m_46->addErrorMessage($this->m_46->getErrorMessage(false));
            }
            if ($this->_47->Visible && $this->_47->Required) {
                if (!$this->_47->IsDetailKey && EmptyValue($this->_47->FormValue)) {
                    $this->_47->addErrorMessage(str_replace("%s", $this->_47->caption(), $this->_47->RequiredErrorMessage));
                }
            }
            if ($this->m_47->Visible && $this->m_47->Required) {
                if (!$this->m_47->IsDetailKey && EmptyValue($this->m_47->FormValue)) {
                    $this->m_47->addErrorMessage(str_replace("%s", $this->m_47->caption(), $this->m_47->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_47->FormValue)) {
                $this->m_47->addErrorMessage($this->m_47->getErrorMessage(false));
            }
            if ($this->_48->Visible && $this->_48->Required) {
                if (!$this->_48->IsDetailKey && EmptyValue($this->_48->FormValue)) {
                    $this->_48->addErrorMessage(str_replace("%s", $this->_48->caption(), $this->_48->RequiredErrorMessage));
                }
            }
            if ($this->m_48->Visible && $this->m_48->Required) {
                if (!$this->m_48->IsDetailKey && EmptyValue($this->m_48->FormValue)) {
                    $this->m_48->addErrorMessage(str_replace("%s", $this->m_48->caption(), $this->m_48->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_48->FormValue)) {
                $this->m_48->addErrorMessage($this->m_48->getErrorMessage(false));
            }
            if ($this->_49->Visible && $this->_49->Required) {
                if (!$this->_49->IsDetailKey && EmptyValue($this->_49->FormValue)) {
                    $this->_49->addErrorMessage(str_replace("%s", $this->_49->caption(), $this->_49->RequiredErrorMessage));
                }
            }
            if ($this->m_49->Visible && $this->m_49->Required) {
                if (!$this->m_49->IsDetailKey && EmptyValue($this->m_49->FormValue)) {
                    $this->m_49->addErrorMessage(str_replace("%s", $this->m_49->caption(), $this->m_49->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_49->FormValue)) {
                $this->m_49->addErrorMessage($this->m_49->getErrorMessage(false));
            }
            if ($this->_50->Visible && $this->_50->Required) {
                if (!$this->_50->IsDetailKey && EmptyValue($this->_50->FormValue)) {
                    $this->_50->addErrorMessage(str_replace("%s", $this->_50->caption(), $this->_50->RequiredErrorMessage));
                }
            }
            if ($this->m_50->Visible && $this->m_50->Required) {
                if (!$this->m_50->IsDetailKey && EmptyValue($this->m_50->FormValue)) {
                    $this->m_50->addErrorMessage(str_replace("%s", $this->m_50->caption(), $this->m_50->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_50->FormValue)) {
                $this->m_50->addErrorMessage($this->m_50->getErrorMessage(false));
            }
            if ($this->_51->Visible && $this->_51->Required) {
                if (!$this->_51->IsDetailKey && EmptyValue($this->_51->FormValue)) {
                    $this->_51->addErrorMessage(str_replace("%s", $this->_51->caption(), $this->_51->RequiredErrorMessage));
                }
            }
            if ($this->m_51->Visible && $this->m_51->Required) {
                if (!$this->m_51->IsDetailKey && EmptyValue($this->m_51->FormValue)) {
                    $this->m_51->addErrorMessage(str_replace("%s", $this->m_51->caption(), $this->m_51->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_51->FormValue)) {
                $this->m_51->addErrorMessage($this->m_51->getErrorMessage(false));
            }
            if ($this->_52->Visible && $this->_52->Required) {
                if (!$this->_52->IsDetailKey && EmptyValue($this->_52->FormValue)) {
                    $this->_52->addErrorMessage(str_replace("%s", $this->_52->caption(), $this->_52->RequiredErrorMessage));
                }
            }
            if ($this->m_52->Visible && $this->m_52->Required) {
                if (!$this->m_52->IsDetailKey && EmptyValue($this->m_52->FormValue)) {
                    $this->m_52->addErrorMessage(str_replace("%s", $this->m_52->caption(), $this->m_52->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_52->FormValue)) {
                $this->m_52->addErrorMessage($this->m_52->getErrorMessage(false));
            }
            if ($this->_53->Visible && $this->_53->Required) {
                if (!$this->_53->IsDetailKey && EmptyValue($this->_53->FormValue)) {
                    $this->_53->addErrorMessage(str_replace("%s", $this->_53->caption(), $this->_53->RequiredErrorMessage));
                }
            }
            if ($this->m_53->Visible && $this->m_53->Required) {
                if (!$this->m_53->IsDetailKey && EmptyValue($this->m_53->FormValue)) {
                    $this->m_53->addErrorMessage(str_replace("%s", $this->m_53->caption(), $this->m_53->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_53->FormValue)) {
                $this->m_53->addErrorMessage($this->m_53->getErrorMessage(false));
            }
            if ($this->_54->Visible && $this->_54->Required) {
                if (!$this->_54->IsDetailKey && EmptyValue($this->_54->FormValue)) {
                    $this->_54->addErrorMessage(str_replace("%s", $this->_54->caption(), $this->_54->RequiredErrorMessage));
                }
            }
            if ($this->m_54->Visible && $this->m_54->Required) {
                if (!$this->m_54->IsDetailKey && EmptyValue($this->m_54->FormValue)) {
                    $this->m_54->addErrorMessage(str_replace("%s", $this->m_54->caption(), $this->m_54->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_54->FormValue)) {
                $this->m_54->addErrorMessage($this->m_54->getErrorMessage(false));
            }
            if ($this->_55->Visible && $this->_55->Required) {
                if (!$this->_55->IsDetailKey && EmptyValue($this->_55->FormValue)) {
                    $this->_55->addErrorMessage(str_replace("%s", $this->_55->caption(), $this->_55->RequiredErrorMessage));
                }
            }
            if ($this->m_55->Visible && $this->m_55->Required) {
                if (!$this->m_55->IsDetailKey && EmptyValue($this->m_55->FormValue)) {
                    $this->m_55->addErrorMessage(str_replace("%s", $this->m_55->caption(), $this->m_55->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_55->FormValue)) {
                $this->m_55->addErrorMessage($this->m_55->getErrorMessage(false));
            }
            if ($this->_56->Visible && $this->_56->Required) {
                if (!$this->_56->IsDetailKey && EmptyValue($this->_56->FormValue)) {
                    $this->_56->addErrorMessage(str_replace("%s", $this->_56->caption(), $this->_56->RequiredErrorMessage));
                }
            }
            if ($this->m_56->Visible && $this->m_56->Required) {
                if (!$this->m_56->IsDetailKey && EmptyValue($this->m_56->FormValue)) {
                    $this->m_56->addErrorMessage(str_replace("%s", $this->m_56->caption(), $this->m_56->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_56->FormValue)) {
                $this->m_56->addErrorMessage($this->m_56->getErrorMessage(false));
            }
            if ($this->_57->Visible && $this->_57->Required) {
                if (!$this->_57->IsDetailKey && EmptyValue($this->_57->FormValue)) {
                    $this->_57->addErrorMessage(str_replace("%s", $this->_57->caption(), $this->_57->RequiredErrorMessage));
                }
            }
            if ($this->m_57->Visible && $this->m_57->Required) {
                if (!$this->m_57->IsDetailKey && EmptyValue($this->m_57->FormValue)) {
                    $this->m_57->addErrorMessage(str_replace("%s", $this->m_57->caption(), $this->m_57->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_57->FormValue)) {
                $this->m_57->addErrorMessage($this->m_57->getErrorMessage(false));
            }
            if ($this->_58->Visible && $this->_58->Required) {
                if (!$this->_58->IsDetailKey && EmptyValue($this->_58->FormValue)) {
                    $this->_58->addErrorMessage(str_replace("%s", $this->_58->caption(), $this->_58->RequiredErrorMessage));
                }
            }
            if ($this->m_58->Visible && $this->m_58->Required) {
                if (!$this->m_58->IsDetailKey && EmptyValue($this->m_58->FormValue)) {
                    $this->m_58->addErrorMessage(str_replace("%s", $this->m_58->caption(), $this->m_58->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_58->FormValue)) {
                $this->m_58->addErrorMessage($this->m_58->getErrorMessage(false));
            }
            if ($this->_59->Visible && $this->_59->Required) {
                if (!$this->_59->IsDetailKey && EmptyValue($this->_59->FormValue)) {
                    $this->_59->addErrorMessage(str_replace("%s", $this->_59->caption(), $this->_59->RequiredErrorMessage));
                }
            }
            if ($this->m_59->Visible && $this->m_59->Required) {
                if (!$this->m_59->IsDetailKey && EmptyValue($this->m_59->FormValue)) {
                    $this->m_59->addErrorMessage(str_replace("%s", $this->m_59->caption(), $this->m_59->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_59->FormValue)) {
                $this->m_59->addErrorMessage($this->m_59->getErrorMessage(false));
            }
            if ($this->_60->Visible && $this->_60->Required) {
                if (!$this->_60->IsDetailKey && EmptyValue($this->_60->FormValue)) {
                    $this->_60->addErrorMessage(str_replace("%s", $this->_60->caption(), $this->_60->RequiredErrorMessage));
                }
            }
            if ($this->m_60->Visible && $this->m_60->Required) {
                if (!$this->m_60->IsDetailKey && EmptyValue($this->m_60->FormValue)) {
                    $this->m_60->addErrorMessage(str_replace("%s", $this->m_60->caption(), $this->m_60->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->m_60->FormValue)) {
                $this->m_60->addErrorMessage($this->m_60->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->omr_image->Visible && !$this->omr_image->Upload->KeepFile) {
            $this->omr_image->UploadPath = $this->omr_image->getUploadPath();
            if (!EmptyValue($this->omr_image->Upload->FileName)) {
                $this->omr_image->Upload->DbValue = null;
                FixUploadFileNames($this->omr_image);
                $this->omr_image->setDbValueDef($rsnew, $this->omr_image->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->omr_image->OldUploadPath = $this->omr_image->getUploadPath(); // PHP
        $this->omr_image->UploadPath = $this->omr_image->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->omr_image->Visible && !$this->omr_image->Upload->KeepFile) {
                    $this->omr_image->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->omr_image, $rsnew['omr_image'], false)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // roll_no
        $this->roll_no->setDbValueDef($rsnew, $this->roll_no->CurrentValue, false);

        // test_id
        $this->test_id->setDbValueDef($rsnew, $this->test_id->CurrentValue, false);

        // total
        $this->total->setDbValueDef($rsnew, $this->total->CurrentValue, false);

        // percent
        $this->percent->setDbValueDef($rsnew, $this->percent->CurrentValue, false);

        // s_1
        $this->s_1->setDbValueDef($rsnew, $this->s_1->CurrentValue, false);

        // s_2
        $this->s_2->setDbValueDef($rsnew, $this->s_2->CurrentValue, false);

        // s_3
        $this->s_3->setDbValueDef($rsnew, $this->s_3->CurrentValue, false);

        // s_4
        $this->s_4->setDbValueDef($rsnew, $this->s_4->CurrentValue, false);

        // s_5
        $this->s_5->setDbValueDef($rsnew, $this->s_5->CurrentValue, false);

        // omr_image
        if ($this->omr_image->Visible && !$this->omr_image->Upload->KeepFile) {
            if ($this->omr_image->Upload->FileName == "") {
                $rsnew['omr_image'] = null;
            } else {
                FixUploadTempFileNames($this->omr_image);
                $rsnew['omr_image'] = $this->omr_image->Upload->FileName;
            }
        }

        // 1
        $this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, false);

        // m_1
        $this->m_1->setDbValueDef($rsnew, $this->m_1->CurrentValue, strval($this->m_1->CurrentValue) == "");

        // 2
        $this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, false);

        // m_2
        $this->m_2->setDbValueDef($rsnew, $this->m_2->CurrentValue, strval($this->m_2->CurrentValue) == "");

        // 3
        $this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, false);

        // m_3
        $this->m_3->setDbValueDef($rsnew, $this->m_3->CurrentValue, strval($this->m_3->CurrentValue) == "");

        // 4
        $this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, false);

        // m_4
        $this->m_4->setDbValueDef($rsnew, $this->m_4->CurrentValue, strval($this->m_4->CurrentValue) == "");

        // 5
        $this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, false);

        // m_5
        $this->m_5->setDbValueDef($rsnew, $this->m_5->CurrentValue, strval($this->m_5->CurrentValue) == "");

        // 6
        $this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, false);

        // m_6
        $this->m_6->setDbValueDef($rsnew, $this->m_6->CurrentValue, strval($this->m_6->CurrentValue) == "");

        // 7
        $this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, false);

        // m_7
        $this->m_7->setDbValueDef($rsnew, $this->m_7->CurrentValue, strval($this->m_7->CurrentValue) == "");

        // 8
        $this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, false);

        // m_8
        $this->m_8->setDbValueDef($rsnew, $this->m_8->CurrentValue, strval($this->m_8->CurrentValue) == "");

        // 9
        $this->_9->setDbValueDef($rsnew, $this->_9->CurrentValue, false);

        // m_9
        $this->m_9->setDbValueDef($rsnew, $this->m_9->CurrentValue, strval($this->m_9->CurrentValue) == "");

        // 10
        $this->_10->setDbValueDef($rsnew, $this->_10->CurrentValue, false);

        // m_10
        $this->m_10->setDbValueDef($rsnew, $this->m_10->CurrentValue, strval($this->m_10->CurrentValue) == "");

        // 11
        $this->_11->setDbValueDef($rsnew, $this->_11->CurrentValue, false);

        // m_11
        $this->m_11->setDbValueDef($rsnew, $this->m_11->CurrentValue, strval($this->m_11->CurrentValue) == "");

        // 12
        $this->_12->setDbValueDef($rsnew, $this->_12->CurrentValue, false);

        // m_12
        $this->m_12->setDbValueDef($rsnew, $this->m_12->CurrentValue, strval($this->m_12->CurrentValue) == "");

        // 13
        $this->_13->setDbValueDef($rsnew, $this->_13->CurrentValue, false);

        // m_13
        $this->m_13->setDbValueDef($rsnew, $this->m_13->CurrentValue, strval($this->m_13->CurrentValue) == "");

        // 14
        $this->_14->setDbValueDef($rsnew, $this->_14->CurrentValue, false);

        // m_14
        $this->m_14->setDbValueDef($rsnew, $this->m_14->CurrentValue, strval($this->m_14->CurrentValue) == "");

        // 15
        $this->_15->setDbValueDef($rsnew, $this->_15->CurrentValue, false);

        // m_15
        $this->m_15->setDbValueDef($rsnew, $this->m_15->CurrentValue, strval($this->m_15->CurrentValue) == "");

        // 16
        $this->_16->setDbValueDef($rsnew, $this->_16->CurrentValue, false);

        // m_16
        $this->m_16->setDbValueDef($rsnew, $this->m_16->CurrentValue, strval($this->m_16->CurrentValue) == "");

        // 17
        $this->_17->setDbValueDef($rsnew, $this->_17->CurrentValue, false);

        // m_17
        $this->m_17->setDbValueDef($rsnew, $this->m_17->CurrentValue, strval($this->m_17->CurrentValue) == "");

        // 18
        $this->_18->setDbValueDef($rsnew, $this->_18->CurrentValue, false);

        // m_18
        $this->m_18->setDbValueDef($rsnew, $this->m_18->CurrentValue, strval($this->m_18->CurrentValue) == "");

        // 19
        $this->_19->setDbValueDef($rsnew, $this->_19->CurrentValue, false);

        // m_19
        $this->m_19->setDbValueDef($rsnew, $this->m_19->CurrentValue, strval($this->m_19->CurrentValue) == "");

        // 20
        $this->_20->setDbValueDef($rsnew, $this->_20->CurrentValue, false);

        // m_20
        $this->m_20->setDbValueDef($rsnew, $this->m_20->CurrentValue, strval($this->m_20->CurrentValue) == "");

        // 21
        $this->_21->setDbValueDef($rsnew, $this->_21->CurrentValue, false);

        // m_21
        $this->m_21->setDbValueDef($rsnew, $this->m_21->CurrentValue, strval($this->m_21->CurrentValue) == "");

        // 22
        $this->_22->setDbValueDef($rsnew, $this->_22->CurrentValue, false);

        // m_22
        $this->m_22->setDbValueDef($rsnew, $this->m_22->CurrentValue, strval($this->m_22->CurrentValue) == "");

        // 23
        $this->_23->setDbValueDef($rsnew, $this->_23->CurrentValue, false);

        // m_23
        $this->m_23->setDbValueDef($rsnew, $this->m_23->CurrentValue, strval($this->m_23->CurrentValue) == "");

        // 24
        $this->_24->setDbValueDef($rsnew, $this->_24->CurrentValue, false);

        // m_24
        $this->m_24->setDbValueDef($rsnew, $this->m_24->CurrentValue, strval($this->m_24->CurrentValue) == "");

        // 25
        $this->_25->setDbValueDef($rsnew, $this->_25->CurrentValue, false);

        // m_25
        $this->m_25->setDbValueDef($rsnew, $this->m_25->CurrentValue, strval($this->m_25->CurrentValue) == "");

        // 26
        $this->_26->setDbValueDef($rsnew, $this->_26->CurrentValue, false);

        // m_26
        $this->m_26->setDbValueDef($rsnew, $this->m_26->CurrentValue, strval($this->m_26->CurrentValue) == "");

        // 27
        $this->_27->setDbValueDef($rsnew, $this->_27->CurrentValue, false);

        // m_27
        $this->m_27->setDbValueDef($rsnew, $this->m_27->CurrentValue, strval($this->m_27->CurrentValue) == "");

        // 28
        $this->_28->setDbValueDef($rsnew, $this->_28->CurrentValue, false);

        // m_28
        $this->m_28->setDbValueDef($rsnew, $this->m_28->CurrentValue, strval($this->m_28->CurrentValue) == "");

        // 29
        $this->_29->setDbValueDef($rsnew, $this->_29->CurrentValue, false);

        // m_29
        $this->m_29->setDbValueDef($rsnew, $this->m_29->CurrentValue, strval($this->m_29->CurrentValue) == "");

        // 30
        $this->_30->setDbValueDef($rsnew, $this->_30->CurrentValue, false);

        // m_30
        $this->m_30->setDbValueDef($rsnew, $this->m_30->CurrentValue, strval($this->m_30->CurrentValue) == "");

        // 31
        $this->_31->setDbValueDef($rsnew, $this->_31->CurrentValue, false);

        // m_31
        $this->m_31->setDbValueDef($rsnew, $this->m_31->CurrentValue, strval($this->m_31->CurrentValue) == "");

        // 32
        $this->_32->setDbValueDef($rsnew, $this->_32->CurrentValue, false);

        // m_32
        $this->m_32->setDbValueDef($rsnew, $this->m_32->CurrentValue, strval($this->m_32->CurrentValue) == "");

        // 33
        $this->_33->setDbValueDef($rsnew, $this->_33->CurrentValue, false);

        // m_33
        $this->m_33->setDbValueDef($rsnew, $this->m_33->CurrentValue, strval($this->m_33->CurrentValue) == "");

        // 34
        $this->_34->setDbValueDef($rsnew, $this->_34->CurrentValue, false);

        // m_34
        $this->m_34->setDbValueDef($rsnew, $this->m_34->CurrentValue, strval($this->m_34->CurrentValue) == "");

        // 35
        $this->_35->setDbValueDef($rsnew, $this->_35->CurrentValue, false);

        // m_35
        $this->m_35->setDbValueDef($rsnew, $this->m_35->CurrentValue, strval($this->m_35->CurrentValue) == "");

        // 36
        $this->_36->setDbValueDef($rsnew, $this->_36->CurrentValue, false);

        // m_36
        $this->m_36->setDbValueDef($rsnew, $this->m_36->CurrentValue, strval($this->m_36->CurrentValue) == "");

        // 37
        $this->_37->setDbValueDef($rsnew, $this->_37->CurrentValue, false);

        // m_37
        $this->m_37->setDbValueDef($rsnew, $this->m_37->CurrentValue, strval($this->m_37->CurrentValue) == "");

        // 38
        $this->_38->setDbValueDef($rsnew, $this->_38->CurrentValue, false);

        // m_38
        $this->m_38->setDbValueDef($rsnew, $this->m_38->CurrentValue, strval($this->m_38->CurrentValue) == "");

        // 39
        $this->_39->setDbValueDef($rsnew, $this->_39->CurrentValue, false);

        // m_39
        $this->m_39->setDbValueDef($rsnew, $this->m_39->CurrentValue, strval($this->m_39->CurrentValue) == "");

        // 40
        $this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, false);

        // m_40
        $this->m_40->setDbValueDef($rsnew, $this->m_40->CurrentValue, strval($this->m_40->CurrentValue) == "");

        // 41
        $this->_41->setDbValueDef($rsnew, $this->_41->CurrentValue, false);

        // m_41
        $this->m_41->setDbValueDef($rsnew, $this->m_41->CurrentValue, strval($this->m_41->CurrentValue) == "");

        // 42
        $this->_42->setDbValueDef($rsnew, $this->_42->CurrentValue, false);

        // m_42
        $this->m_42->setDbValueDef($rsnew, $this->m_42->CurrentValue, strval($this->m_42->CurrentValue) == "");

        // 43
        $this->_43->setDbValueDef($rsnew, $this->_43->CurrentValue, false);

        // m_43
        $this->m_43->setDbValueDef($rsnew, $this->m_43->CurrentValue, strval($this->m_43->CurrentValue) == "");

        // 44
        $this->_44->setDbValueDef($rsnew, $this->_44->CurrentValue, false);

        // m_44
        $this->m_44->setDbValueDef($rsnew, $this->m_44->CurrentValue, strval($this->m_44->CurrentValue) == "");

        // 45
        $this->_45->setDbValueDef($rsnew, $this->_45->CurrentValue, false);

        // m_45
        $this->m_45->setDbValueDef($rsnew, $this->m_45->CurrentValue, strval($this->m_45->CurrentValue) == "");

        // 46
        $this->_46->setDbValueDef($rsnew, $this->_46->CurrentValue, false);

        // m_46
        $this->m_46->setDbValueDef($rsnew, $this->m_46->CurrentValue, strval($this->m_46->CurrentValue) == "");

        // 47
        $this->_47->setDbValueDef($rsnew, $this->_47->CurrentValue, false);

        // m_47
        $this->m_47->setDbValueDef($rsnew, $this->m_47->CurrentValue, strval($this->m_47->CurrentValue) == "");

        // 48
        $this->_48->setDbValueDef($rsnew, $this->_48->CurrentValue, false);

        // m_48
        $this->m_48->setDbValueDef($rsnew, $this->m_48->CurrentValue, strval($this->m_48->CurrentValue) == "");

        // 49
        $this->_49->setDbValueDef($rsnew, $this->_49->CurrentValue, false);

        // m_49
        $this->m_49->setDbValueDef($rsnew, $this->m_49->CurrentValue, strval($this->m_49->CurrentValue) == "");

        // 50
        $this->_50->setDbValueDef($rsnew, $this->_50->CurrentValue, false);

        // m_50
        $this->m_50->setDbValueDef($rsnew, $this->m_50->CurrentValue, strval($this->m_50->CurrentValue) == "");

        // 51
        $this->_51->setDbValueDef($rsnew, $this->_51->CurrentValue, false);

        // m_51
        $this->m_51->setDbValueDef($rsnew, $this->m_51->CurrentValue, strval($this->m_51->CurrentValue) == "");

        // 52
        $this->_52->setDbValueDef($rsnew, $this->_52->CurrentValue, false);

        // m_52
        $this->m_52->setDbValueDef($rsnew, $this->m_52->CurrentValue, strval($this->m_52->CurrentValue) == "");

        // 53
        $this->_53->setDbValueDef($rsnew, $this->_53->CurrentValue, false);

        // m_53
        $this->m_53->setDbValueDef($rsnew, $this->m_53->CurrentValue, strval($this->m_53->CurrentValue) == "");

        // 54
        $this->_54->setDbValueDef($rsnew, $this->_54->CurrentValue, false);

        // m_54
        $this->m_54->setDbValueDef($rsnew, $this->m_54->CurrentValue, strval($this->m_54->CurrentValue) == "");

        // 55
        $this->_55->setDbValueDef($rsnew, $this->_55->CurrentValue, false);

        // m_55
        $this->m_55->setDbValueDef($rsnew, $this->m_55->CurrentValue, strval($this->m_55->CurrentValue) == "");

        // 56
        $this->_56->setDbValueDef($rsnew, $this->_56->CurrentValue, false);

        // m_56
        $this->m_56->setDbValueDef($rsnew, $this->m_56->CurrentValue, strval($this->m_56->CurrentValue) == "");

        // 57
        $this->_57->setDbValueDef($rsnew, $this->_57->CurrentValue, false);

        // m_57
        $this->m_57->setDbValueDef($rsnew, $this->m_57->CurrentValue, strval($this->m_57->CurrentValue) == "");

        // 58
        $this->_58->setDbValueDef($rsnew, $this->_58->CurrentValue, false);

        // m_58
        $this->m_58->setDbValueDef($rsnew, $this->m_58->CurrentValue, strval($this->m_58->CurrentValue) == "");

        // 59
        $this->_59->setDbValueDef($rsnew, $this->_59->CurrentValue, false);

        // m_59
        $this->m_59->setDbValueDef($rsnew, $this->m_59->CurrentValue, strval($this->m_59->CurrentValue) == "");

        // 60
        $this->_60->setDbValueDef($rsnew, $this->_60->CurrentValue, false);

        // m_60
        $this->m_60->setDbValueDef($rsnew, $this->m_60->CurrentValue, strval($this->m_60->CurrentValue) == "");
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['roll_no'])) { // roll_no
            $this->roll_no->setFormValue($row['roll_no']);
        }
        if (isset($row['test_id'])) { // test_id
            $this->test_id->setFormValue($row['test_id']);
        }
        if (isset($row['total'])) { // total
            $this->total->setFormValue($row['total']);
        }
        if (isset($row['percent'])) { // percent
            $this->percent->setFormValue($row['percent']);
        }
        if (isset($row['s_1'])) { // s_1
            $this->s_1->setFormValue($row['s_1']);
        }
        if (isset($row['s_2'])) { // s_2
            $this->s_2->setFormValue($row['s_2']);
        }
        if (isset($row['s_3'])) { // s_3
            $this->s_3->setFormValue($row['s_3']);
        }
        if (isset($row['s_4'])) { // s_4
            $this->s_4->setFormValue($row['s_4']);
        }
        if (isset($row['s_5'])) { // s_5
            $this->s_5->setFormValue($row['s_5']);
        }
        if (isset($row['omr_image'])) { // omr_image
            $this->omr_image->setFormValue($row['omr_image']);
        }
        if (isset($row['1'])) { // 1
            $this->_1->setFormValue($row['1']);
        }
        if (isset($row['m_1'])) { // m_1
            $this->m_1->setFormValue($row['m_1']);
        }
        if (isset($row['2'])) { // 2
            $this->_2->setFormValue($row['2']);
        }
        if (isset($row['m_2'])) { // m_2
            $this->m_2->setFormValue($row['m_2']);
        }
        if (isset($row['3'])) { // 3
            $this->_3->setFormValue($row['3']);
        }
        if (isset($row['m_3'])) { // m_3
            $this->m_3->setFormValue($row['m_3']);
        }
        if (isset($row['4'])) { // 4
            $this->_4->setFormValue($row['4']);
        }
        if (isset($row['m_4'])) { // m_4
            $this->m_4->setFormValue($row['m_4']);
        }
        if (isset($row['5'])) { // 5
            $this->_5->setFormValue($row['5']);
        }
        if (isset($row['m_5'])) { // m_5
            $this->m_5->setFormValue($row['m_5']);
        }
        if (isset($row['6'])) { // 6
            $this->_6->setFormValue($row['6']);
        }
        if (isset($row['m_6'])) { // m_6
            $this->m_6->setFormValue($row['m_6']);
        }
        if (isset($row['7'])) { // 7
            $this->_7->setFormValue($row['7']);
        }
        if (isset($row['m_7'])) { // m_7
            $this->m_7->setFormValue($row['m_7']);
        }
        if (isset($row['8'])) { // 8
            $this->_8->setFormValue($row['8']);
        }
        if (isset($row['m_8'])) { // m_8
            $this->m_8->setFormValue($row['m_8']);
        }
        if (isset($row['9'])) { // 9
            $this->_9->setFormValue($row['9']);
        }
        if (isset($row['m_9'])) { // m_9
            $this->m_9->setFormValue($row['m_9']);
        }
        if (isset($row['10'])) { // 10
            $this->_10->setFormValue($row['10']);
        }
        if (isset($row['m_10'])) { // m_10
            $this->m_10->setFormValue($row['m_10']);
        }
        if (isset($row['11'])) { // 11
            $this->_11->setFormValue($row['11']);
        }
        if (isset($row['m_11'])) { // m_11
            $this->m_11->setFormValue($row['m_11']);
        }
        if (isset($row['12'])) { // 12
            $this->_12->setFormValue($row['12']);
        }
        if (isset($row['m_12'])) { // m_12
            $this->m_12->setFormValue($row['m_12']);
        }
        if (isset($row['13'])) { // 13
            $this->_13->setFormValue($row['13']);
        }
        if (isset($row['m_13'])) { // m_13
            $this->m_13->setFormValue($row['m_13']);
        }
        if (isset($row['14'])) { // 14
            $this->_14->setFormValue($row['14']);
        }
        if (isset($row['m_14'])) { // m_14
            $this->m_14->setFormValue($row['m_14']);
        }
        if (isset($row['15'])) { // 15
            $this->_15->setFormValue($row['15']);
        }
        if (isset($row['m_15'])) { // m_15
            $this->m_15->setFormValue($row['m_15']);
        }
        if (isset($row['16'])) { // 16
            $this->_16->setFormValue($row['16']);
        }
        if (isset($row['m_16'])) { // m_16
            $this->m_16->setFormValue($row['m_16']);
        }
        if (isset($row['17'])) { // 17
            $this->_17->setFormValue($row['17']);
        }
        if (isset($row['m_17'])) { // m_17
            $this->m_17->setFormValue($row['m_17']);
        }
        if (isset($row['18'])) { // 18
            $this->_18->setFormValue($row['18']);
        }
        if (isset($row['m_18'])) { // m_18
            $this->m_18->setFormValue($row['m_18']);
        }
        if (isset($row['19'])) { // 19
            $this->_19->setFormValue($row['19']);
        }
        if (isset($row['m_19'])) { // m_19
            $this->m_19->setFormValue($row['m_19']);
        }
        if (isset($row['20'])) { // 20
            $this->_20->setFormValue($row['20']);
        }
        if (isset($row['m_20'])) { // m_20
            $this->m_20->setFormValue($row['m_20']);
        }
        if (isset($row['21'])) { // 21
            $this->_21->setFormValue($row['21']);
        }
        if (isset($row['m_21'])) { // m_21
            $this->m_21->setFormValue($row['m_21']);
        }
        if (isset($row['22'])) { // 22
            $this->_22->setFormValue($row['22']);
        }
        if (isset($row['m_22'])) { // m_22
            $this->m_22->setFormValue($row['m_22']);
        }
        if (isset($row['23'])) { // 23
            $this->_23->setFormValue($row['23']);
        }
        if (isset($row['m_23'])) { // m_23
            $this->m_23->setFormValue($row['m_23']);
        }
        if (isset($row['24'])) { // 24
            $this->_24->setFormValue($row['24']);
        }
        if (isset($row['m_24'])) { // m_24
            $this->m_24->setFormValue($row['m_24']);
        }
        if (isset($row['25'])) { // 25
            $this->_25->setFormValue($row['25']);
        }
        if (isset($row['m_25'])) { // m_25
            $this->m_25->setFormValue($row['m_25']);
        }
        if (isset($row['26'])) { // 26
            $this->_26->setFormValue($row['26']);
        }
        if (isset($row['m_26'])) { // m_26
            $this->m_26->setFormValue($row['m_26']);
        }
        if (isset($row['27'])) { // 27
            $this->_27->setFormValue($row['27']);
        }
        if (isset($row['m_27'])) { // m_27
            $this->m_27->setFormValue($row['m_27']);
        }
        if (isset($row['28'])) { // 28
            $this->_28->setFormValue($row['28']);
        }
        if (isset($row['m_28'])) { // m_28
            $this->m_28->setFormValue($row['m_28']);
        }
        if (isset($row['29'])) { // 29
            $this->_29->setFormValue($row['29']);
        }
        if (isset($row['m_29'])) { // m_29
            $this->m_29->setFormValue($row['m_29']);
        }
        if (isset($row['30'])) { // 30
            $this->_30->setFormValue($row['30']);
        }
        if (isset($row['m_30'])) { // m_30
            $this->m_30->setFormValue($row['m_30']);
        }
        if (isset($row['31'])) { // 31
            $this->_31->setFormValue($row['31']);
        }
        if (isset($row['m_31'])) { // m_31
            $this->m_31->setFormValue($row['m_31']);
        }
        if (isset($row['32'])) { // 32
            $this->_32->setFormValue($row['32']);
        }
        if (isset($row['m_32'])) { // m_32
            $this->m_32->setFormValue($row['m_32']);
        }
        if (isset($row['33'])) { // 33
            $this->_33->setFormValue($row['33']);
        }
        if (isset($row['m_33'])) { // m_33
            $this->m_33->setFormValue($row['m_33']);
        }
        if (isset($row['34'])) { // 34
            $this->_34->setFormValue($row['34']);
        }
        if (isset($row['m_34'])) { // m_34
            $this->m_34->setFormValue($row['m_34']);
        }
        if (isset($row['35'])) { // 35
            $this->_35->setFormValue($row['35']);
        }
        if (isset($row['m_35'])) { // m_35
            $this->m_35->setFormValue($row['m_35']);
        }
        if (isset($row['36'])) { // 36
            $this->_36->setFormValue($row['36']);
        }
        if (isset($row['m_36'])) { // m_36
            $this->m_36->setFormValue($row['m_36']);
        }
        if (isset($row['37'])) { // 37
            $this->_37->setFormValue($row['37']);
        }
        if (isset($row['m_37'])) { // m_37
            $this->m_37->setFormValue($row['m_37']);
        }
        if (isset($row['38'])) { // 38
            $this->_38->setFormValue($row['38']);
        }
        if (isset($row['m_38'])) { // m_38
            $this->m_38->setFormValue($row['m_38']);
        }
        if (isset($row['39'])) { // 39
            $this->_39->setFormValue($row['39']);
        }
        if (isset($row['m_39'])) { // m_39
            $this->m_39->setFormValue($row['m_39']);
        }
        if (isset($row['40'])) { // 40
            $this->_40->setFormValue($row['40']);
        }
        if (isset($row['m_40'])) { // m_40
            $this->m_40->setFormValue($row['m_40']);
        }
        if (isset($row['41'])) { // 41
            $this->_41->setFormValue($row['41']);
        }
        if (isset($row['m_41'])) { // m_41
            $this->m_41->setFormValue($row['m_41']);
        }
        if (isset($row['42'])) { // 42
            $this->_42->setFormValue($row['42']);
        }
        if (isset($row['m_42'])) { // m_42
            $this->m_42->setFormValue($row['m_42']);
        }
        if (isset($row['43'])) { // 43
            $this->_43->setFormValue($row['43']);
        }
        if (isset($row['m_43'])) { // m_43
            $this->m_43->setFormValue($row['m_43']);
        }
        if (isset($row['44'])) { // 44
            $this->_44->setFormValue($row['44']);
        }
        if (isset($row['m_44'])) { // m_44
            $this->m_44->setFormValue($row['m_44']);
        }
        if (isset($row['45'])) { // 45
            $this->_45->setFormValue($row['45']);
        }
        if (isset($row['m_45'])) { // m_45
            $this->m_45->setFormValue($row['m_45']);
        }
        if (isset($row['46'])) { // 46
            $this->_46->setFormValue($row['46']);
        }
        if (isset($row['m_46'])) { // m_46
            $this->m_46->setFormValue($row['m_46']);
        }
        if (isset($row['47'])) { // 47
            $this->_47->setFormValue($row['47']);
        }
        if (isset($row['m_47'])) { // m_47
            $this->m_47->setFormValue($row['m_47']);
        }
        if (isset($row['48'])) { // 48
            $this->_48->setFormValue($row['48']);
        }
        if (isset($row['m_48'])) { // m_48
            $this->m_48->setFormValue($row['m_48']);
        }
        if (isset($row['49'])) { // 49
            $this->_49->setFormValue($row['49']);
        }
        if (isset($row['m_49'])) { // m_49
            $this->m_49->setFormValue($row['m_49']);
        }
        if (isset($row['50'])) { // 50
            $this->_50->setFormValue($row['50']);
        }
        if (isset($row['m_50'])) { // m_50
            $this->m_50->setFormValue($row['m_50']);
        }
        if (isset($row['51'])) { // 51
            $this->_51->setFormValue($row['51']);
        }
        if (isset($row['m_51'])) { // m_51
            $this->m_51->setFormValue($row['m_51']);
        }
        if (isset($row['52'])) { // 52
            $this->_52->setFormValue($row['52']);
        }
        if (isset($row['m_52'])) { // m_52
            $this->m_52->setFormValue($row['m_52']);
        }
        if (isset($row['53'])) { // 53
            $this->_53->setFormValue($row['53']);
        }
        if (isset($row['m_53'])) { // m_53
            $this->m_53->setFormValue($row['m_53']);
        }
        if (isset($row['54'])) { // 54
            $this->_54->setFormValue($row['54']);
        }
        if (isset($row['m_54'])) { // m_54
            $this->m_54->setFormValue($row['m_54']);
        }
        if (isset($row['55'])) { // 55
            $this->_55->setFormValue($row['55']);
        }
        if (isset($row['m_55'])) { // m_55
            $this->m_55->setFormValue($row['m_55']);
        }
        if (isset($row['56'])) { // 56
            $this->_56->setFormValue($row['56']);
        }
        if (isset($row['m_56'])) { // m_56
            $this->m_56->setFormValue($row['m_56']);
        }
        if (isset($row['57'])) { // 57
            $this->_57->setFormValue($row['57']);
        }
        if (isset($row['m_57'])) { // m_57
            $this->m_57->setFormValue($row['m_57']);
        }
        if (isset($row['58'])) { // 58
            $this->_58->setFormValue($row['58']);
        }
        if (isset($row['m_58'])) { // m_58
            $this->m_58->setFormValue($row['m_58']);
        }
        if (isset($row['59'])) { // 59
            $this->_59->setFormValue($row['59']);
        }
        if (isset($row['m_59'])) { // m_59
            $this->m_59->setFormValue($row['m_59']);
        }
        if (isset($row['60'])) { // 60
            $this->_60->setFormValue($row['60']);
        }
        if (isset($row['m_60'])) { // m_60
            $this->m_60->setFormValue($row['m_60']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("somrvaluelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
