<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SEpcLiveAdd extends SEpcLive
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SEpcLiveAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "sepcliveadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->epc->Visible = false;
        $this->inout_datetime->setVisibility();
        $this->in_out->setVisibility();
        $this->unit_id->setVisibility();
        $this->s_pid->setVisibility();
        $this->faculty->setVisibility();
        $this->mobile->setVisibility();
        $this->m_type->setVisibility();
        $this->m_status->setVisibility();
        $this->m_datetime->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->remarks->setVisibility();
        $this->uid->Visible = false;
        $this->s_name->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 's_epc_live';
        $this->TableName = 's_epc_live';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_epc_live)
        if (!isset($GLOBALS["s_epc_live"]) || $GLOBALS["s_epc_live"]::class == PROJECT_NAMESPACE . "s_epc_live") {
            $GLOBALS["s_epc_live"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_epc_live');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "sepcliveview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->unit_id);
        $this->setupLookupOptions($this->s_pid);
        $this->setupLookupOptions($this->faculty);
        $this->setupLookupOptions($this->m_type);
        $this->setupLookupOptions($this->m_status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("sepclivelist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "sepclivelist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "sepcliveview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "sepclivelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "sepclivelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'inout_datetime' first before field var 'x_inout_datetime'
        $val = $CurrentForm->hasValue("inout_datetime") ? $CurrentForm->getValue("inout_datetime") : $CurrentForm->getValue("x_inout_datetime");
        if (!$this->inout_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->inout_datetime->Visible = false; // Disable update for API request
            } else {
                $this->inout_datetime->setFormValue($val, true, $validate);
            }
            $this->inout_datetime->CurrentValue = UnFormatDateTime($this->inout_datetime->CurrentValue, $this->inout_datetime->formatPattern());
        }

        // Check field name 'in_out' first before field var 'x_in_out'
        $val = $CurrentForm->hasValue("in_out") ? $CurrentForm->getValue("in_out") : $CurrentForm->getValue("x_in_out");
        if (!$this->in_out->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_out->Visible = false; // Disable update for API request
            } else {
                $this->in_out->setFormValue($val);
            }
        }

        // Check field name 'unit_id' first before field var 'x_unit_id'
        $val = $CurrentForm->hasValue("unit_id") ? $CurrentForm->getValue("unit_id") : $CurrentForm->getValue("x_unit_id");
        if (!$this->unit_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->unit_id->Visible = false; // Disable update for API request
            } else {
                $this->unit_id->setFormValue($val);
            }
        }

        // Check field name 's_pid' first before field var 'x_s_pid'
        $val = $CurrentForm->hasValue("s_pid") ? $CurrentForm->getValue("s_pid") : $CurrentForm->getValue("x_s_pid");
        if (!$this->s_pid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_pid->Visible = false; // Disable update for API request
            } else {
                $this->s_pid->setFormValue($val);
            }
        }

        // Check field name 'faculty' first before field var 'x_faculty'
        $val = $CurrentForm->hasValue("faculty") ? $CurrentForm->getValue("faculty") : $CurrentForm->getValue("x_faculty");
        if (!$this->faculty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->faculty->Visible = false; // Disable update for API request
            } else {
                $this->faculty->setFormValue($val);
            }
        }

        // Check field name 'mobile' first before field var 'x_mobile'
        $val = $CurrentForm->hasValue("mobile") ? $CurrentForm->getValue("mobile") : $CurrentForm->getValue("x_mobile");
        if (!$this->mobile->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->mobile->Visible = false; // Disable update for API request
            } else {
                $this->mobile->setFormValue($val);
            }
        }

        // Check field name 'm_type' first before field var 'x_m_type'
        $val = $CurrentForm->hasValue("m_type") ? $CurrentForm->getValue("m_type") : $CurrentForm->getValue("x_m_type");
        if (!$this->m_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_type->Visible = false; // Disable update for API request
            } else {
                $this->m_type->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'm_status' first before field var 'x_m_status'
        $val = $CurrentForm->hasValue("m_status") ? $CurrentForm->getValue("m_status") : $CurrentForm->getValue("x_m_status");
        if (!$this->m_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_status->Visible = false; // Disable update for API request
            } else {
                $this->m_status->setFormValue($val);
            }
        }

        // Check field name 'm_datetime' first before field var 'x_m_datetime'
        $val = $CurrentForm->hasValue("m_datetime") ? $CurrentForm->getValue("m_datetime") : $CurrentForm->getValue("x_m_datetime");
        if (!$this->m_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->m_datetime->Visible = false; // Disable update for API request
            } else {
                $this->m_datetime->setFormValue($val, true, $validate);
            }
            $this->m_datetime->CurrentValue = UnFormatDateTime($this->m_datetime->CurrentValue, $this->m_datetime->formatPattern());
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val, true, $validate);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->inout_datetime->CurrentValue = $this->inout_datetime->FormValue;
        $this->inout_datetime->CurrentValue = UnFormatDateTime($this->inout_datetime->CurrentValue, $this->inout_datetime->formatPattern());
        $this->in_out->CurrentValue = $this->in_out->FormValue;
        $this->unit_id->CurrentValue = $this->unit_id->FormValue;
        $this->s_pid->CurrentValue = $this->s_pid->FormValue;
        $this->faculty->CurrentValue = $this->faculty->FormValue;
        $this->mobile->CurrentValue = $this->mobile->FormValue;
        $this->m_type->CurrentValue = $this->m_type->FormValue;
        $this->m_status->CurrentValue = $this->m_status->FormValue;
        $this->m_datetime->CurrentValue = $this->m_datetime->FormValue;
        $this->m_datetime->CurrentValue = UnFormatDateTime($this->m_datetime->CurrentValue, $this->m_datetime->formatPattern());
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->remarks->CurrentValue = $this->remarks->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->epc->setDbValue($row['epc']);
        $this->inout_datetime->setDbValue($row['inout_datetime']);
        $this->in_out->setDbValue($row['in_out']);
        $this->unit_id->setDbValue($row['unit_id']);
        $this->s_pid->setDbValue($row['s_pid']);
        $this->faculty->setDbValue($row['faculty']);
        $this->mobile->setDbValue($row['mobile']);
        $this->m_type->setDbValue($row['m_type']);
        $this->m_status->setDbValue($row['m_status']);
        $this->m_datetime->setDbValue($row['m_datetime']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->remarks->setDbValue($row['remarks']);
        $this->uid->setDbValue($row['uid']);
        $this->s_name->setDbValue($row['s_name']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['epc'] = $this->epc->DefaultValue;
        $row['inout_datetime'] = $this->inout_datetime->DefaultValue;
        $row['in_out'] = $this->in_out->DefaultValue;
        $row['unit_id'] = $this->unit_id->DefaultValue;
        $row['s_pid'] = $this->s_pid->DefaultValue;
        $row['faculty'] = $this->faculty->DefaultValue;
        $row['mobile'] = $this->mobile->DefaultValue;
        $row['m_type'] = $this->m_type->DefaultValue;
        $row['m_status'] = $this->m_status->DefaultValue;
        $row['m_datetime'] = $this->m_datetime->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['s_name'] = $this->s_name->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // epc
        $this->epc->RowCssClass = "row";

        // inout_datetime
        $this->inout_datetime->RowCssClass = "row";

        // in_out
        $this->in_out->RowCssClass = "row";

        // unit_id
        $this->unit_id->RowCssClass = "row";

        // s_pid
        $this->s_pid->RowCssClass = "row";

        // faculty
        $this->faculty->RowCssClass = "row";

        // mobile
        $this->mobile->RowCssClass = "row";

        // m_type
        $this->m_type->RowCssClass = "row";

        // m_status
        $this->m_status->RowCssClass = "row";

        // m_datetime
        $this->m_datetime->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // s_name
        $this->s_name->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // inout_datetime
            $this->inout_datetime->ViewValue = $this->inout_datetime->CurrentValue;
            $this->inout_datetime->ViewValue = FormatDateTime($this->inout_datetime->ViewValue, $this->inout_datetime->formatPattern());

            // in_out
            $this->in_out->ViewValue = $this->in_out->CurrentValue;

            // unit_id
            if (strval($this->unit_id->CurrentValue) != "") {
                $this->unit_id->ViewValue = $this->unit_id->optionCaption($this->unit_id->CurrentValue);
            } else {
                $this->unit_id->ViewValue = null;
            }

            // s_pid
            $curVal = strval($this->s_pid->CurrentValue);
            if ($curVal != "") {
                $this->s_pid->ViewValue = $this->s_pid->lookupCacheOption($curVal);
                if ($this->s_pid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_pid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_pid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_pid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_pid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_pid->Lookup->renderViewRow($rswrk[0]);
                        $this->s_pid->ViewValue = $this->s_pid->displayValue($arwrk);
                    } else {
                        $this->s_pid->ViewValue = $this->s_pid->CurrentValue;
                    }
                }
            } else {
                $this->s_pid->ViewValue = null;
            }

            // faculty
            $this->faculty->ViewValue = $this->faculty->CurrentValue;
            $curVal = strval($this->faculty->CurrentValue);
            if ($curVal != "") {
                $this->faculty->ViewValue = $this->faculty->lookupCacheOption($curVal);
                if ($this->faculty->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->faculty->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->faculty->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->faculty->getSelectFilter($this); // PHP
                    $sqlWrk = $this->faculty->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->faculty->Lookup->renderViewRow($rswrk[0]);
                        $this->faculty->ViewValue = $this->faculty->displayValue($arwrk);
                    } else {
                        $this->faculty->ViewValue = $this->faculty->CurrentValue;
                    }
                }
            } else {
                $this->faculty->ViewValue = null;
            }

            // mobile
            $this->mobile->ViewValue = $this->mobile->CurrentValue;

            // m_type
            $this->m_type->ViewValue = $this->m_type->CurrentValue;
            $curVal = strval($this->m_type->CurrentValue);
            if ($curVal != "") {
                $this->m_type->ViewValue = $this->m_type->lookupCacheOption($curVal);
                if ($this->m_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_type->Lookup->renderViewRow($rswrk[0]);
                        $this->m_type->ViewValue = $this->m_type->displayValue($arwrk);
                    } else {
                        $this->m_type->ViewValue = FormatNumber($this->m_type->CurrentValue, $this->m_type->formatPattern());
                    }
                }
            } else {
                $this->m_type->ViewValue = null;
            }

            // m_status
            if (strval($this->m_status->CurrentValue) != "") {
                $this->m_status->ViewValue = $this->m_status->optionCaption($this->m_status->CurrentValue);
            } else {
                $this->m_status->ViewValue = null;
            }

            // m_datetime
            $this->m_datetime->ViewValue = $this->m_datetime->CurrentValue;
            $this->m_datetime->ViewValue = FormatDateTime($this->m_datetime->ViewValue, $this->m_datetime->formatPattern());

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // inout_datetime
            $this->inout_datetime->HrefValue = "";

            // in_out
            $this->in_out->HrefValue = "";

            // unit_id
            $this->unit_id->HrefValue = "";

            // s_pid
            $this->s_pid->HrefValue = "";

            // faculty
            $this->faculty->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // m_type
            $this->m_type->HrefValue = "";

            // m_status
            $this->m_status->HrefValue = "";

            // m_datetime
            $this->m_datetime->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // inout_datetime
            $this->inout_datetime->setupEditAttributes();
            $this->inout_datetime->EditValue = HtmlEncode(FormatDateTime($this->inout_datetime->CurrentValue, $this->inout_datetime->formatPattern()));
            $this->inout_datetime->PlaceHolder = RemoveHtml($this->inout_datetime->caption());

            // in_out
            $this->in_out->setupEditAttributes();
            if (!$this->in_out->Raw) {
                $this->in_out->CurrentValue = HtmlDecode($this->in_out->CurrentValue);
            }
            $this->in_out->EditValue = HtmlEncode($this->in_out->CurrentValue);
            $this->in_out->PlaceHolder = RemoveHtml($this->in_out->caption());

            // unit_id
            $this->unit_id->setupEditAttributes();
            $this->unit_id->EditValue = $this->unit_id->options(true);
            $this->unit_id->PlaceHolder = RemoveHtml($this->unit_id->caption());

            // s_pid
            $curVal = trim(strval($this->s_pid->CurrentValue));
            if ($curVal != "") {
                $this->s_pid->ViewValue = $this->s_pid->lookupCacheOption($curVal);
            } else {
                $this->s_pid->ViewValue = $this->s_pid->Lookup !== null && is_array($this->s_pid->lookupOptions()) && count($this->s_pid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_pid->ViewValue !== null) { // Load from cache
                $this->s_pid->EditValue = array_values($this->s_pid->lookupOptions());
                if ($this->s_pid->ViewValue == "") {
                    $this->s_pid->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_pid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_pid->CurrentValue, $this->s_pid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_pid->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_pid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_pid->Lookup->renderViewRow($rswrk[0]);
                    $this->s_pid->ViewValue = $this->s_pid->displayValue($arwrk);
                } else {
                    $this->s_pid->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->s_pid->EditValue = $arwrk;
            }
            $this->s_pid->PlaceHolder = RemoveHtml($this->s_pid->caption());

            // faculty
            $this->faculty->setupEditAttributes();
            $this->faculty->EditValue = $this->faculty->CurrentValue;
            $curVal = strval($this->faculty->CurrentValue);
            if ($curVal != "") {
                $this->faculty->EditValue = $this->faculty->lookupCacheOption($curVal);
                if ($this->faculty->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->faculty->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->faculty->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->faculty->getSelectFilter($this); // PHP
                    $sqlWrk = $this->faculty->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->faculty->Lookup->renderViewRow($rswrk[0]);
                        $this->faculty->EditValue = $this->faculty->displayValue($arwrk);
                    } else {
                        $this->faculty->EditValue = HtmlEncode($this->faculty->CurrentValue);
                    }
                }
            } else {
                $this->faculty->EditValue = null;
            }
            $this->faculty->PlaceHolder = RemoveHtml($this->faculty->caption());

            // mobile
            $this->mobile->setupEditAttributes();
            if (!$this->mobile->Raw) {
                $this->mobile->CurrentValue = HtmlDecode($this->mobile->CurrentValue);
            }
            $this->mobile->EditValue = HtmlEncode($this->mobile->CurrentValue);
            $this->mobile->PlaceHolder = RemoveHtml($this->mobile->caption());

            // m_type
            $this->m_type->setupEditAttributes();
            $this->m_type->EditValue = $this->m_type->CurrentValue;
            $curVal = strval($this->m_type->CurrentValue);
            if ($curVal != "") {
                $this->m_type->EditValue = $this->m_type->lookupCacheOption($curVal);
                if ($this->m_type->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->m_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->m_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->m_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->m_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->m_type->Lookup->renderViewRow($rswrk[0]);
                        $this->m_type->EditValue = $this->m_type->displayValue($arwrk);
                    } else {
                        $this->m_type->EditValue = HtmlEncode(FormatNumber($this->m_type->CurrentValue, $this->m_type->formatPattern()));
                    }
                }
            } else {
                $this->m_type->EditValue = null;
            }
            $this->m_type->PlaceHolder = RemoveHtml($this->m_type->caption());

            // m_status
            $this->m_status->setupEditAttributes();
            $this->m_status->EditValue = $this->m_status->options(true);
            $this->m_status->PlaceHolder = RemoveHtml($this->m_status->caption());

            // m_datetime
            $this->m_datetime->setupEditAttributes();
            $this->m_datetime->EditValue = HtmlEncode(FormatDateTime($this->m_datetime->CurrentValue, $this->m_datetime->formatPattern()));
            $this->m_datetime->PlaceHolder = RemoveHtml($this->m_datetime->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->EditValue = $this->operator->CurrentValue;
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());
            if (strval($this->operator->EditValue) != "" && is_numeric($this->operator->EditValue)) {
                $this->operator->EditValue = FormatNumber($this->operator->EditValue, null);
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // Add refer script

            // inout_datetime
            $this->inout_datetime->HrefValue = "";

            // in_out
            $this->in_out->HrefValue = "";

            // unit_id
            $this->unit_id->HrefValue = "";

            // s_pid
            $this->s_pid->HrefValue = "";

            // faculty
            $this->faculty->HrefValue = "";

            // mobile
            $this->mobile->HrefValue = "";

            // m_type
            $this->m_type->HrefValue = "";

            // m_status
            $this->m_status->HrefValue = "";

            // m_datetime
            $this->m_datetime->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->inout_datetime->Visible && $this->inout_datetime->Required) {
                if (!$this->inout_datetime->IsDetailKey && EmptyValue($this->inout_datetime->FormValue)) {
                    $this->inout_datetime->addErrorMessage(str_replace("%s", $this->inout_datetime->caption(), $this->inout_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->inout_datetime->FormValue, $this->inout_datetime->formatPattern())) {
                $this->inout_datetime->addErrorMessage($this->inout_datetime->getErrorMessage(false));
            }
            if ($this->in_out->Visible && $this->in_out->Required) {
                if (!$this->in_out->IsDetailKey && EmptyValue($this->in_out->FormValue)) {
                    $this->in_out->addErrorMessage(str_replace("%s", $this->in_out->caption(), $this->in_out->RequiredErrorMessage));
                }
            }
            if ($this->unit_id->Visible && $this->unit_id->Required) {
                if (!$this->unit_id->IsDetailKey && EmptyValue($this->unit_id->FormValue)) {
                    $this->unit_id->addErrorMessage(str_replace("%s", $this->unit_id->caption(), $this->unit_id->RequiredErrorMessage));
                }
            }
            if ($this->s_pid->Visible && $this->s_pid->Required) {
                if (!$this->s_pid->IsDetailKey && EmptyValue($this->s_pid->FormValue)) {
                    $this->s_pid->addErrorMessage(str_replace("%s", $this->s_pid->caption(), $this->s_pid->RequiredErrorMessage));
                }
            }
            if ($this->faculty->Visible && $this->faculty->Required) {
                if (!$this->faculty->IsDetailKey && EmptyValue($this->faculty->FormValue)) {
                    $this->faculty->addErrorMessage(str_replace("%s", $this->faculty->caption(), $this->faculty->RequiredErrorMessage));
                }
            }
            if ($this->mobile->Visible && $this->mobile->Required) {
                if (!$this->mobile->IsDetailKey && EmptyValue($this->mobile->FormValue)) {
                    $this->mobile->addErrorMessage(str_replace("%s", $this->mobile->caption(), $this->mobile->RequiredErrorMessage));
                }
            }
            if ($this->m_type->Visible && $this->m_type->Required) {
                if (!$this->m_type->IsDetailKey && EmptyValue($this->m_type->FormValue)) {
                    $this->m_type->addErrorMessage(str_replace("%s", $this->m_type->caption(), $this->m_type->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->m_type->FormValue)) {
                $this->m_type->addErrorMessage($this->m_type->getErrorMessage(false));
            }
            if ($this->m_status->Visible && $this->m_status->Required) {
                if (!$this->m_status->IsDetailKey && EmptyValue($this->m_status->FormValue)) {
                    $this->m_status->addErrorMessage(str_replace("%s", $this->m_status->caption(), $this->m_status->RequiredErrorMessage));
                }
            }
            if ($this->m_datetime->Visible && $this->m_datetime->Required) {
                if (!$this->m_datetime->IsDetailKey && EmptyValue($this->m_datetime->FormValue)) {
                    $this->m_datetime->addErrorMessage(str_replace("%s", $this->m_datetime->caption(), $this->m_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->m_datetime->FormValue, $this->m_datetime->formatPattern())) {
                $this->m_datetime->addErrorMessage($this->m_datetime->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->operator->FormValue)) {
                $this->operator->addErrorMessage($this->operator->getErrorMessage(false));
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->datetime->FormValue, $this->datetime->formatPattern())) {
                $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // inout_datetime
        $this->inout_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->inout_datetime->CurrentValue, $this->inout_datetime->formatPattern()), false);

        // in_out
        $this->in_out->setDbValueDef($rsnew, $this->in_out->CurrentValue, false);

        // unit_id
        $this->unit_id->setDbValueDef($rsnew, $this->unit_id->CurrentValue, false);

        // s_pid
        $this->s_pid->setDbValueDef($rsnew, $this->s_pid->CurrentValue, false);

        // faculty
        $this->faculty->setDbValueDef($rsnew, $this->faculty->CurrentValue, false);

        // mobile
        $this->mobile->setDbValueDef($rsnew, $this->mobile->CurrentValue, false);

        // m_type
        $this->m_type->setDbValueDef($rsnew, $this->m_type->CurrentValue, false);

        // m_status
        $this->m_status->setDbValueDef($rsnew, $this->m_status->CurrentValue, false);

        // m_datetime
        $this->m_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->m_datetime->CurrentValue, $this->m_datetime->formatPattern()), false);

        // operator
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, false);

        // datetime
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['inout_datetime'])) { // inout_datetime
            $this->inout_datetime->setFormValue($row['inout_datetime']);
        }
        if (isset($row['in_out'])) { // in_out
            $this->in_out->setFormValue($row['in_out']);
        }
        if (isset($row['unit_id'])) { // unit_id
            $this->unit_id->setFormValue($row['unit_id']);
        }
        if (isset($row['s_pid'])) { // s_pid
            $this->s_pid->setFormValue($row['s_pid']);
        }
        if (isset($row['faculty'])) { // faculty
            $this->faculty->setFormValue($row['faculty']);
        }
        if (isset($row['mobile'])) { // mobile
            $this->mobile->setFormValue($row['mobile']);
        }
        if (isset($row['m_type'])) { // m_type
            $this->m_type->setFormValue($row['m_type']);
        }
        if (isset($row['m_status'])) { // m_status
            $this->m_status->setFormValue($row['m_status']);
        }
        if (isset($row['m_datetime'])) { // m_datetime
            $this->m_datetime->setFormValue($row['m_datetime']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sepclivelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_unit_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_pid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_faculty":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_m_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
