<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class SAttendanceInfoAdd extends SAttendanceInfo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "SAttendanceInfoAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "sattendanceinfoadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->s_pid->setVisibility();
        $this->faculty->setVisibility();
        $this->dated->setVisibility();
        $this->in_time->setVisibility();
        $this->in_out_in->setVisibility();
        $this->in_m_status->setVisibility();
        $this->in_unit->setVisibility();
        $this->out_time->setVisibility();
        $this->in_out_out->setVisibility();
        $this->out_m_status->setVisibility();
        $this->out_unit->setVisibility();
        $this->remarks->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 's_attendance_info';
        $this->TableName = 's_attendance_info';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (s_attendance_info)
        if (!isset($GLOBALS["s_attendance_info"]) || $GLOBALS["s_attendance_info"]::class == PROJECT_NAMESPACE . "s_attendance_info") {
            $GLOBALS["s_attendance_info"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 's_attendance_info');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "sattendanceinfoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->s_pid);
        $this->setupLookupOptions($this->faculty);
        $this->setupLookupOptions($this->in_m_status);
        $this->setupLookupOptions($this->in_unit);
        $this->setupLookupOptions($this->out_m_status);
        $this->setupLookupOptions($this->out_unit);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("sattendanceinfolist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "sattendanceinfolist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "sattendanceinfoview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "sattendanceinfolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "sattendanceinfolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 's_pid' first before field var 'x_s_pid'
        $val = $CurrentForm->hasValue("s_pid") ? $CurrentForm->getValue("s_pid") : $CurrentForm->getValue("x_s_pid");
        if (!$this->s_pid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_pid->Visible = false; // Disable update for API request
            } else {
                $this->s_pid->setFormValue($val);
            }
        }

        // Check field name 'faculty' first before field var 'x_faculty'
        $val = $CurrentForm->hasValue("faculty") ? $CurrentForm->getValue("faculty") : $CurrentForm->getValue("x_faculty");
        if (!$this->faculty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->faculty->Visible = false; // Disable update for API request
            } else {
                $this->faculty->setFormValue($val);
            }
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'in_time' first before field var 'x_in_time'
        $val = $CurrentForm->hasValue("in_time") ? $CurrentForm->getValue("in_time") : $CurrentForm->getValue("x_in_time");
        if (!$this->in_time->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_time->Visible = false; // Disable update for API request
            } else {
                $this->in_time->setFormValue($val, true, $validate);
            }
            $this->in_time->CurrentValue = UnFormatDateTime($this->in_time->CurrentValue, $this->in_time->formatPattern());
        }

        // Check field name 'in_out_in' first before field var 'x_in_out_in'
        $val = $CurrentForm->hasValue("in_out_in") ? $CurrentForm->getValue("in_out_in") : $CurrentForm->getValue("x_in_out_in");
        if (!$this->in_out_in->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_out_in->Visible = false; // Disable update for API request
            } else {
                $this->in_out_in->setFormValue($val);
            }
        }

        // Check field name 'in_m_status' first before field var 'x_in_m_status'
        $val = $CurrentForm->hasValue("in_m_status") ? $CurrentForm->getValue("in_m_status") : $CurrentForm->getValue("x_in_m_status");
        if (!$this->in_m_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_m_status->Visible = false; // Disable update for API request
            } else {
                $this->in_m_status->setFormValue($val);
            }
        }

        // Check field name 'in_unit' first before field var 'x_in_unit'
        $val = $CurrentForm->hasValue("in_unit") ? $CurrentForm->getValue("in_unit") : $CurrentForm->getValue("x_in_unit");
        if (!$this->in_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_unit->Visible = false; // Disable update for API request
            } else {
                $this->in_unit->setFormValue($val);
            }
        }

        // Check field name 'out_time' first before field var 'x_out_time'
        $val = $CurrentForm->hasValue("out_time") ? $CurrentForm->getValue("out_time") : $CurrentForm->getValue("x_out_time");
        if (!$this->out_time->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->out_time->Visible = false; // Disable update for API request
            } else {
                $this->out_time->setFormValue($val, true, $validate);
            }
            $this->out_time->CurrentValue = UnFormatDateTime($this->out_time->CurrentValue, $this->out_time->formatPattern());
        }

        // Check field name 'in_out_out' first before field var 'x_in_out_out'
        $val = $CurrentForm->hasValue("in_out_out") ? $CurrentForm->getValue("in_out_out") : $CurrentForm->getValue("x_in_out_out");
        if (!$this->in_out_out->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->in_out_out->Visible = false; // Disable update for API request
            } else {
                $this->in_out_out->setFormValue($val);
            }
        }

        // Check field name 'out_m_status' first before field var 'x_out_m_status'
        $val = $CurrentForm->hasValue("out_m_status") ? $CurrentForm->getValue("out_m_status") : $CurrentForm->getValue("x_out_m_status");
        if (!$this->out_m_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->out_m_status->Visible = false; // Disable update for API request
            } else {
                $this->out_m_status->setFormValue($val);
            }
        }

        // Check field name 'out_unit' first before field var 'x_out_unit'
        $val = $CurrentForm->hasValue("out_unit") ? $CurrentForm->getValue("out_unit") : $CurrentForm->getValue("x_out_unit");
        if (!$this->out_unit->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->out_unit->Visible = false; // Disable update for API request
            } else {
                $this->out_unit->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->s_pid->CurrentValue = $this->s_pid->FormValue;
        $this->faculty->CurrentValue = $this->faculty->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->in_time->CurrentValue = $this->in_time->FormValue;
        $this->in_time->CurrentValue = UnFormatDateTime($this->in_time->CurrentValue, $this->in_time->formatPattern());
        $this->in_out_in->CurrentValue = $this->in_out_in->FormValue;
        $this->in_m_status->CurrentValue = $this->in_m_status->FormValue;
        $this->in_unit->CurrentValue = $this->in_unit->FormValue;
        $this->out_time->CurrentValue = $this->out_time->FormValue;
        $this->out_time->CurrentValue = UnFormatDateTime($this->out_time->CurrentValue, $this->out_time->formatPattern());
        $this->in_out_out->CurrentValue = $this->in_out_out->FormValue;
        $this->out_m_status->CurrentValue = $this->out_m_status->FormValue;
        $this->out_unit->CurrentValue = $this->out_unit->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->s_pid->setDbValue($row['s_pid']);
        $this->faculty->setDbValue($row['faculty']);
        $this->dated->setDbValue($row['dated']);
        $this->in_time->setDbValue($row['in_time']);
        $this->in_out_in->setDbValue($row['in_out_in']);
        $this->in_m_status->setDbValue($row['in_m_status']);
        $this->in_unit->setDbValue($row['in_unit']);
        $this->out_time->setDbValue($row['out_time']);
        $this->in_out_out->setDbValue($row['in_out_out']);
        $this->out_m_status->setDbValue($row['out_m_status']);
        $this->out_unit->setDbValue($row['out_unit']);
        $this->remarks->setDbValue($row['remarks']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['s_pid'] = $this->s_pid->DefaultValue;
        $row['faculty'] = $this->faculty->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['in_time'] = $this->in_time->DefaultValue;
        $row['in_out_in'] = $this->in_out_in->DefaultValue;
        $row['in_m_status'] = $this->in_m_status->DefaultValue;
        $row['in_unit'] = $this->in_unit->DefaultValue;
        $row['out_time'] = $this->out_time->DefaultValue;
        $row['in_out_out'] = $this->in_out_out->DefaultValue;
        $row['out_m_status'] = $this->out_m_status->DefaultValue;
        $row['out_unit'] = $this->out_unit->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // s_pid
        $this->s_pid->RowCssClass = "row";

        // faculty
        $this->faculty->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // in_time
        $this->in_time->RowCssClass = "row";

        // in_out_in
        $this->in_out_in->RowCssClass = "row";

        // in_m_status
        $this->in_m_status->RowCssClass = "row";

        // in_unit
        $this->in_unit->RowCssClass = "row";

        // out_time
        $this->out_time->RowCssClass = "row";

        // in_out_out
        $this->in_out_out->RowCssClass = "row";

        // out_m_status
        $this->out_m_status->RowCssClass = "row";

        // out_unit
        $this->out_unit->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // s_pid
            $curVal = strval($this->s_pid->CurrentValue);
            if ($curVal != "") {
                $this->s_pid->ViewValue = $this->s_pid->lookupCacheOption($curVal);
                if ($this->s_pid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_pid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_pid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_pid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_pid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_pid->Lookup->renderViewRow($rswrk[0]);
                        $this->s_pid->ViewValue = $this->s_pid->displayValue($arwrk);
                    } else {
                        $this->s_pid->ViewValue = FormatNumber($this->s_pid->CurrentValue, $this->s_pid->formatPattern());
                    }
                }
            } else {
                $this->s_pid->ViewValue = null;
            }

            // faculty
            $this->faculty->ViewValue = $this->faculty->CurrentValue;
            $curVal = strval($this->faculty->CurrentValue);
            if ($curVal != "") {
                $this->faculty->ViewValue = $this->faculty->lookupCacheOption($curVal);
                if ($this->faculty->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->faculty->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->faculty->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->faculty->getSelectFilter($this); // PHP
                    $sqlWrk = $this->faculty->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->faculty->Lookup->renderViewRow($rswrk[0]);
                        $this->faculty->ViewValue = $this->faculty->displayValue($arwrk);
                    } else {
                        $this->faculty->ViewValue = $this->faculty->CurrentValue;
                    }
                }
            } else {
                $this->faculty->ViewValue = null;
            }

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // in_time
            $this->in_time->ViewValue = $this->in_time->CurrentValue;
            $this->in_time->ViewValue = FormatDateTime($this->in_time->ViewValue, $this->in_time->formatPattern());

            // in_out_in
            $this->in_out_in->ViewValue = $this->in_out_in->CurrentValue;

            // in_m_status
            if (strval($this->in_m_status->CurrentValue) != "") {
                $this->in_m_status->ViewValue = $this->in_m_status->optionCaption($this->in_m_status->CurrentValue);
            } else {
                $this->in_m_status->ViewValue = null;
            }

            // in_unit
            if (strval($this->in_unit->CurrentValue) != "") {
                $this->in_unit->ViewValue = $this->in_unit->optionCaption($this->in_unit->CurrentValue);
            } else {
                $this->in_unit->ViewValue = null;
            }

            // out_time
            $this->out_time->ViewValue = $this->out_time->CurrentValue;
            $this->out_time->ViewValue = FormatDateTime($this->out_time->ViewValue, $this->out_time->formatPattern());

            // in_out_out
            $this->in_out_out->ViewValue = $this->in_out_out->CurrentValue;

            // out_m_status
            if (strval($this->out_m_status->CurrentValue) != "") {
                $this->out_m_status->ViewValue = $this->out_m_status->optionCaption($this->out_m_status->CurrentValue);
            } else {
                $this->out_m_status->ViewValue = null;
            }

            // out_unit
            if (strval($this->out_unit->CurrentValue) != "") {
                $this->out_unit->ViewValue = $this->out_unit->optionCaption($this->out_unit->CurrentValue);
            } else {
                $this->out_unit->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // s_pid
            $this->s_pid->HrefValue = "";

            // faculty
            $this->faculty->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // in_time
            $this->in_time->HrefValue = "";

            // in_out_in
            $this->in_out_in->HrefValue = "";

            // in_m_status
            $this->in_m_status->HrefValue = "";

            // in_unit
            $this->in_unit->HrefValue = "";

            // out_time
            $this->out_time->HrefValue = "";

            // in_out_out
            $this->in_out_out->HrefValue = "";

            // out_m_status
            $this->out_m_status->HrefValue = "";

            // out_unit
            $this->out_unit->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // s_pid
            $curVal = trim(strval($this->s_pid->CurrentValue));
            if ($curVal != "") {
                $this->s_pid->ViewValue = $this->s_pid->lookupCacheOption($curVal);
            } else {
                $this->s_pid->ViewValue = $this->s_pid->Lookup !== null && is_array($this->s_pid->lookupOptions()) && count($this->s_pid->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_pid->ViewValue !== null) { // Load from cache
                $this->s_pid->EditValue = array_values($this->s_pid->lookupOptions());
                if ($this->s_pid->ViewValue == "") {
                    $this->s_pid->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_pid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_pid->CurrentValue, $this->s_pid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_pid->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_pid->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_pid->Lookup->renderViewRow($rswrk[0]);
                    $this->s_pid->ViewValue = $this->s_pid->displayValue($arwrk);
                } else {
                    $this->s_pid->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->s_pid->EditValue = $arwrk;
            }
            $this->s_pid->PlaceHolder = RemoveHtml($this->s_pid->caption());

            // faculty
            $this->faculty->setupEditAttributes();
            $this->faculty->EditValue = $this->faculty->CurrentValue;
            $curVal = strval($this->faculty->CurrentValue);
            if ($curVal != "") {
                $this->faculty->EditValue = $this->faculty->lookupCacheOption($curVal);
                if ($this->faculty->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->faculty->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->faculty->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->faculty->getSelectFilter($this); // PHP
                    $sqlWrk = $this->faculty->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->faculty->Lookup->renderViewRow($rswrk[0]);
                        $this->faculty->EditValue = $this->faculty->displayValue($arwrk);
                    } else {
                        $this->faculty->EditValue = HtmlEncode($this->faculty->CurrentValue);
                    }
                }
            } else {
                $this->faculty->EditValue = null;
            }
            $this->faculty->PlaceHolder = RemoveHtml($this->faculty->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // in_time
            $this->in_time->setupEditAttributes();
            $this->in_time->EditValue = HtmlEncode(FormatDateTime($this->in_time->CurrentValue, $this->in_time->formatPattern()));
            $this->in_time->PlaceHolder = RemoveHtml($this->in_time->caption());

            // in_out_in
            $this->in_out_in->setupEditAttributes();
            if (!$this->in_out_in->Raw) {
                $this->in_out_in->CurrentValue = HtmlDecode($this->in_out_in->CurrentValue);
            }
            $this->in_out_in->EditValue = HtmlEncode($this->in_out_in->CurrentValue);
            $this->in_out_in->PlaceHolder = RemoveHtml($this->in_out_in->caption());

            // in_m_status
            $this->in_m_status->setupEditAttributes();
            $this->in_m_status->EditValue = $this->in_m_status->options(true);
            $this->in_m_status->PlaceHolder = RemoveHtml($this->in_m_status->caption());

            // in_unit
            $this->in_unit->setupEditAttributes();
            $this->in_unit->EditValue = $this->in_unit->options(true);
            $this->in_unit->PlaceHolder = RemoveHtml($this->in_unit->caption());

            // out_time
            $this->out_time->setupEditAttributes();
            $this->out_time->EditValue = HtmlEncode(FormatDateTime($this->out_time->CurrentValue, $this->out_time->formatPattern()));
            $this->out_time->PlaceHolder = RemoveHtml($this->out_time->caption());

            // in_out_out
            $this->in_out_out->setupEditAttributes();
            if (!$this->in_out_out->Raw) {
                $this->in_out_out->CurrentValue = HtmlDecode($this->in_out_out->CurrentValue);
            }
            $this->in_out_out->EditValue = HtmlEncode($this->in_out_out->CurrentValue);
            $this->in_out_out->PlaceHolder = RemoveHtml($this->in_out_out->caption());

            // out_m_status
            $this->out_m_status->setupEditAttributes();
            $this->out_m_status->EditValue = $this->out_m_status->options(true);
            $this->out_m_status->PlaceHolder = RemoveHtml($this->out_m_status->caption());

            // out_unit
            $this->out_unit->setupEditAttributes();
            $this->out_unit->EditValue = $this->out_unit->options(true);
            $this->out_unit->PlaceHolder = RemoveHtml($this->out_unit->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            if (!$this->remarks->Raw) {
                $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
            }
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // Add refer script

            // s_pid
            $this->s_pid->HrefValue = "";

            // faculty
            $this->faculty->HrefValue = "";

            // dated
            $this->dated->HrefValue = "";

            // in_time
            $this->in_time->HrefValue = "";

            // in_out_in
            $this->in_out_in->HrefValue = "";

            // in_m_status
            $this->in_m_status->HrefValue = "";

            // in_unit
            $this->in_unit->HrefValue = "";

            // out_time
            $this->out_time->HrefValue = "";

            // in_out_out
            $this->in_out_out->HrefValue = "";

            // out_m_status
            $this->out_m_status->HrefValue = "";

            // out_unit
            $this->out_unit->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->s_pid->Visible && $this->s_pid->Required) {
                if (!$this->s_pid->IsDetailKey && EmptyValue($this->s_pid->FormValue)) {
                    $this->s_pid->addErrorMessage(str_replace("%s", $this->s_pid->caption(), $this->s_pid->RequiredErrorMessage));
                }
            }
            if ($this->faculty->Visible && $this->faculty->Required) {
                if (!$this->faculty->IsDetailKey && EmptyValue($this->faculty->FormValue)) {
                    $this->faculty->addErrorMessage(str_replace("%s", $this->faculty->caption(), $this->faculty->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }
            if ($this->in_time->Visible && $this->in_time->Required) {
                if (!$this->in_time->IsDetailKey && EmptyValue($this->in_time->FormValue)) {
                    $this->in_time->addErrorMessage(str_replace("%s", $this->in_time->caption(), $this->in_time->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->in_time->FormValue, $this->in_time->formatPattern())) {
                $this->in_time->addErrorMessage($this->in_time->getErrorMessage(false));
            }
            if ($this->in_out_in->Visible && $this->in_out_in->Required) {
                if (!$this->in_out_in->IsDetailKey && EmptyValue($this->in_out_in->FormValue)) {
                    $this->in_out_in->addErrorMessage(str_replace("%s", $this->in_out_in->caption(), $this->in_out_in->RequiredErrorMessage));
                }
            }
            if ($this->in_m_status->Visible && $this->in_m_status->Required) {
                if (!$this->in_m_status->IsDetailKey && EmptyValue($this->in_m_status->FormValue)) {
                    $this->in_m_status->addErrorMessage(str_replace("%s", $this->in_m_status->caption(), $this->in_m_status->RequiredErrorMessage));
                }
            }
            if ($this->in_unit->Visible && $this->in_unit->Required) {
                if (!$this->in_unit->IsDetailKey && EmptyValue($this->in_unit->FormValue)) {
                    $this->in_unit->addErrorMessage(str_replace("%s", $this->in_unit->caption(), $this->in_unit->RequiredErrorMessage));
                }
            }
            if ($this->out_time->Visible && $this->out_time->Required) {
                if (!$this->out_time->IsDetailKey && EmptyValue($this->out_time->FormValue)) {
                    $this->out_time->addErrorMessage(str_replace("%s", $this->out_time->caption(), $this->out_time->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->out_time->FormValue, $this->out_time->formatPattern())) {
                $this->out_time->addErrorMessage($this->out_time->getErrorMessage(false));
            }
            if ($this->in_out_out->Visible && $this->in_out_out->Required) {
                if (!$this->in_out_out->IsDetailKey && EmptyValue($this->in_out_out->FormValue)) {
                    $this->in_out_out->addErrorMessage(str_replace("%s", $this->in_out_out->caption(), $this->in_out_out->RequiredErrorMessage));
                }
            }
            if ($this->out_m_status->Visible && $this->out_m_status->Required) {
                if (!$this->out_m_status->IsDetailKey && EmptyValue($this->out_m_status->FormValue)) {
                    $this->out_m_status->addErrorMessage(str_replace("%s", $this->out_m_status->caption(), $this->out_m_status->RequiredErrorMessage));
                }
            }
            if ($this->out_unit->Visible && $this->out_unit->Required) {
                if (!$this->out_unit->IsDetailKey && EmptyValue($this->out_unit->FormValue)) {
                    $this->out_unit->addErrorMessage(str_replace("%s", $this->out_unit->caption(), $this->out_unit->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // s_pid
        $this->s_pid->setDbValueDef($rsnew, $this->s_pid->CurrentValue, false);

        // faculty
        $this->faculty->setDbValueDef($rsnew, $this->faculty->CurrentValue, false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);

        // in_time
        $this->in_time->setDbValueDef($rsnew, UnFormatDateTime($this->in_time->CurrentValue, $this->in_time->formatPattern()), false);

        // in_out_in
        $this->in_out_in->setDbValueDef($rsnew, $this->in_out_in->CurrentValue, false);

        // in_m_status
        $this->in_m_status->setDbValueDef($rsnew, $this->in_m_status->CurrentValue, false);

        // in_unit
        $this->in_unit->setDbValueDef($rsnew, $this->in_unit->CurrentValue, false);

        // out_time
        $this->out_time->setDbValueDef($rsnew, UnFormatDateTime($this->out_time->CurrentValue, $this->out_time->formatPattern()), false);

        // in_out_out
        $this->in_out_out->setDbValueDef($rsnew, $this->in_out_out->CurrentValue, false);

        // out_m_status
        $this->out_m_status->setDbValueDef($rsnew, $this->out_m_status->CurrentValue, false);

        // out_unit
        $this->out_unit->setDbValueDef($rsnew, $this->out_unit->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['s_pid'])) { // s_pid
            $this->s_pid->setFormValue($row['s_pid']);
        }
        if (isset($row['faculty'])) { // faculty
            $this->faculty->setFormValue($row['faculty']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
        if (isset($row['in_time'])) { // in_time
            $this->in_time->setFormValue($row['in_time']);
        }
        if (isset($row['in_out_in'])) { // in_out_in
            $this->in_out_in->setFormValue($row['in_out_in']);
        }
        if (isset($row['in_m_status'])) { // in_m_status
            $this->in_m_status->setFormValue($row['in_m_status']);
        }
        if (isset($row['in_unit'])) { // in_unit
            $this->in_unit->setFormValue($row['in_unit']);
        }
        if (isset($row['out_time'])) { // out_time
            $this->out_time->setFormValue($row['out_time']);
        }
        if (isset($row['in_out_out'])) { // in_out_out
            $this->in_out_out->setFormValue($row['in_out_out']);
        }
        if (isset($row['out_m_status'])) { // out_m_status
            $this->out_m_status->setFormValue($row['out_m_status']);
        }
        if (isset($row['out_unit'])) { // out_unit
            $this->out_unit->setFormValue($row['out_unit']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sattendanceinfolist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_s_pid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_faculty":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_in_m_status":
                    break;
                case "x_in_unit":
                    break;
                case "x_out_m_status":
                    break;
                case "x_out_unit":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
