<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for required_material_overall_table
 */
class RequiredMaterialOverallTable extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $pending;
    public $req_material_grp;
    public $req_material_sgrp;
    public $req_material_product;
    public $req_material_rid;
    public $req_material_packing;
    public $batch_no;
    public $unit;
    public $mil;
    public $req_material_qty;
    public $po_s_pending;
    public $po_pending_wbc;
    public $not_loomcard;
    public $stock;
    public $company_id;
    public $last_supplier_id;
    public $internal_external;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "required_material_overall_table";
        $this->TableName = 'required_material_overall_table';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "required_material_overall_table";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // pending
        $this->pending = new DbField(
            $this, // Table
            'x_pending', // Variable name
            'pending', // Name
            '`pending`', // Expression
            '`pending`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending->addMethod("getSearchDefault", fn() => ">=1");
        $this->pending->InputTextType = "text";
        $this->pending->Raw = true;
        $this->pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pending->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->pending->AdvancedSearch->SearchValueDefault = $this->pending->getSearchDefault();
        $this->pending->AdvancedSearch->SearchOperatorDefault = "=";
        $this->pending->AdvancedSearch->SearchOperator2Default = "";
        $this->pending->AdvancedSearch->SearchConditionDefault = "AND";
        $this->Fields['pending'] = &$this->pending;

        // req_material_grp
        $this->req_material_grp = new DbField(
            $this, // Table
            'x_req_material_grp', // Variable name
            'req_material_grp', // Name
            '`req_material_grp`', // Expression
            '`req_material_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_grp->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->req_material_grp->InputTextType = "text";
        $this->req_material_grp->Raw = true;
        $this->req_material_grp->Sortable = false; // Allow sort
        $this->req_material_grp->setSelectMultiple(false); // Select one
        $this->req_material_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_grp->Lookup = new Lookup($this->req_material_grp, 'grp', false, 'id', ["grp","","",""], '', '', [], [], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->req_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_grp'] = &$this->req_material_grp;

        // req_material_sgrp
        $this->req_material_sgrp = new DbField(
            $this, // Table
            'x_req_material_sgrp', // Variable name
            'req_material_sgrp', // Name
            '`req_material_sgrp`', // Expression
            '`req_material_sgrp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_sgrp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_sgrp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->req_material_sgrp->addMethod("getLinkPrefix", fn() => "materialstatuslist?x_s_grp=");
        $this->req_material_sgrp->InputTextType = "text";
        $this->req_material_sgrp->Raw = true;
        $this->req_material_sgrp->Nullable = false; // NOT NULL field
        $this->req_material_sgrp->Required = true; // Required field
        $this->req_material_sgrp->Sortable = false; // Allow sort
        $this->req_material_sgrp->setSelectMultiple(false); // Select one
        $this->req_material_sgrp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_sgrp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_sgrp->Lookup = new Lookup($this->req_material_sgrp, 'product_group', false, 'id', ["product_group","","",""], '', '', [], [], [], [], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->req_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_sgrp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['req_material_sgrp'] = &$this->req_material_sgrp;

        // req_material_product
        $this->req_material_product = new DbField(
            $this, // Table
            'x_req_material_product', // Variable name
            'req_material_product', // Name
            '`req_material_product`', // Expression
            '`req_material_product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_product->addMethod("getSelectFilter", fn() => "`status` =1");
        $this->req_material_product->addMethod("getLinkPrefix", fn() => "requiredmaterialoveralltablelist?x_product=");
        $this->req_material_product->InputTextType = "text";
        $this->req_material_product->Raw = true;
        $this->req_material_product->setSelectMultiple(false); // Select one
        $this->req_material_product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_product->Lookup = new Lookup($this->req_material_product, 'product', false, 'id', ["product","","",""], '', '', [], [], [], [], [], [], false, '`product` ASC', '', "`product`");
        $this->req_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_product'] = &$this->req_material_product;

        // req_material_rid
        $this->req_material_rid = new DbField(
            $this, // Table
            'x_req_material_rid', // Variable name
            'req_material_rid', // Name
            '`req_material_rid`', // Expression
            '`req_material_rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_rid->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->req_material_rid->addMethod("getLinkPrefix", fn() => "requiredmaterialoveralltablelist?x_req_material_rid=");
        $this->req_material_rid->InputTextType = "text";
        $this->req_material_rid->Raw = true;
        $this->req_material_rid->Lookup = new Lookup($this->req_material_rid, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_rid'] = &$this->req_material_rid;

        // req_material_packing
        $this->req_material_packing = new DbField(
            $this, // Table
            'x_req_material_packing', // Variable name
            'req_material_packing', // Name
            '`req_material_packing`', // Expression
            '`req_material_packing`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_packing`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_packing->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->req_material_packing->addMethod("getLinkPrefix", fn() => "requiredmaterialoveralltablelist?x_req_material_rid=");
        $this->req_material_packing->InputTextType = "text";
        $this->req_material_packing->Raw = true;
        $this->req_material_packing->Required = true; // Required field
        $this->req_material_packing->setSelectMultiple(false); // Select one
        $this->req_material_packing->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_packing->Lookup = new Lookup($this->req_material_packing, 'packing_type', false, 'id', ["code","packing","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->req_material_packing) . "',COALESCE(`packing`,''))");
        $this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_packing->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_packing'] = &$this->req_material_packing;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->batch_no->addMethod("getLinkPrefix", fn() => "batchnolist?x_id=");
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["batch_no","","",""], '', '', [], [], [], [], [], [], false, '`batch_no` ASC', '', "`batch_no`");
        $this->batch_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->unit->InputTextType = "text";
        $this->unit->setSelectMultiple(false); // Select one
        $this->unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->unit->Lookup = new Lookup($this->unit, 'unit', false, 'id', ["sign","description","",""], '', '', [], [], [], [], [], [], false, '`sign` ASC', '', "CONCAT(COALESCE(`sign`, ''),'" . ValueSeparator(1, $this->unit) . "',COALESCE(`description`,''))");
        $this->unit->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // mil
        $this->mil = new DbField(
            $this, // Table
            'x_mil', // Variable name
            'mil', // Name
            '`mil`', // Expression
            '`mil`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`mil`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->mil->addMethod("getDefault", fn() => 0.000);
        $this->mil->InputTextType = "text";
        $this->mil->Raw = true;
        $this->mil->Required = true; // Required field
        $this->mil->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->mil->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['mil'] = &$this->mil;

        // req_material_qty
        $this->req_material_qty = new DbField(
            $this, // Table
            'x_req_material_qty', // Variable name
            'req_material_qty', // Name
            '`req_material_qty`', // Expression
            '`req_material_qty`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_qty->InputTextType = "text";
        $this->req_material_qty->Raw = true;
        $this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->req_material_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_qty'] = &$this->req_material_qty;

        // po_s_pending
        $this->po_s_pending = new DbField(
            $this, // Table
            'x_po_s_pending', // Variable name
            'po_s_pending', // Name
            '`po_s_pending`', // Expression
            '`po_s_pending`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_s_pending`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_s_pending->addMethod("getDefault", fn() => 0.000);
        $this->po_s_pending->InputTextType = "text";
        $this->po_s_pending->Raw = true;
        $this->po_s_pending->Required = true; // Required field
        $this->po_s_pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->po_s_pending->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_s_pending'] = &$this->po_s_pending;

        // po_pending_wbc
        $this->po_pending_wbc = new DbField(
            $this, // Table
            'x_po_pending_wbc', // Variable name
            'po_pending_wbc', // Name
            '`po_pending_wbc`', // Expression
            '`po_pending_wbc`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po_pending_wbc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po_pending_wbc->InputTextType = "text";
        $this->po_pending_wbc->Raw = true;
        $this->po_pending_wbc->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->po_pending_wbc->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po_pending_wbc'] = &$this->po_pending_wbc;

        // not_loomcard
        $this->not_loomcard = new DbField(
            $this, // Table
            'x_not_loomcard', // Variable name
            'not_loomcard', // Name
            '`not_loomcard`', // Expression
            '`not_loomcard`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`not_loomcard`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->not_loomcard->addMethod("getDefault", fn() => 0.000);
        $this->not_loomcard->InputTextType = "text";
        $this->not_loomcard->Raw = true;
        $this->not_loomcard->Required = true; // Required field
        $this->not_loomcard->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->not_loomcard->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['not_loomcard'] = &$this->not_loomcard;

        // stock
        $this->stock = new DbField(
            $this, // Table
            'x_stock', // Variable name
            'stock', // Name
            '`stock`', // Expression
            '`stock`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->stock->addMethod("getDefault", fn() => 0.000);
        $this->stock->InputTextType = "text";
        $this->stock->Raw = true;
        $this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['stock'] = &$this->stock;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Nullable = false; // NOT NULL field
        $this->company_id->Required = true; // Required field
        $this->company_id->setSelectMultiple(false); // Select one
        $this->company_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['company_id'] = &$this->company_id;

        // last_supplier_id
        $this->last_supplier_id = new DbField(
            $this, // Table
            'x_last_supplier_id', // Variable name
            'last_supplier_id', // Name
            '`last_supplier_id`', // Expression
            '`last_supplier_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`last_supplier_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->last_supplier_id->addMethod("getSelectFilter", fn() => "`partner_type`=1");
        $this->last_supplier_id->InputTextType = "text";
        $this->last_supplier_id->Raw = true;
        $this->last_supplier_id->Nullable = false; // NOT NULL field
        $this->last_supplier_id->Required = true; // Required field
        $this->last_supplier_id->Lookup = new Lookup($this->last_supplier_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->last_supplier_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['last_supplier_id'] = &$this->last_supplier_id;

        // internal_external
        $this->internal_external = new DbField(
            $this, // Table
            'x_internal_external', // Variable name
            'internal_external', // Name
            '`internal_external`', // Expression
            '`internal_external`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`internal_external`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->internal_external->addMethod("getDefault", fn() => 0);
        $this->internal_external->InputTextType = "text";
        $this->internal_external->Raw = true;
        $this->internal_external->setSelectMultiple(false); // Select one
        $this->internal_external->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->internal_external->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->internal_external->Lookup = new Lookup($this->internal_external, 'required_material_overall_table', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->internal_external->OptionCount = 3;
        $this->internal_external->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->internal_external->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['internal_external'] = &$this->internal_external;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "required_material_overall_table";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->pending->DbValue = $row['pending'];
        $this->req_material_grp->DbValue = $row['req_material_grp'];
        $this->req_material_sgrp->DbValue = $row['req_material_sgrp'];
        $this->req_material_product->DbValue = $row['req_material_product'];
        $this->req_material_rid->DbValue = $row['req_material_rid'];
        $this->req_material_packing->DbValue = $row['req_material_packing'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->unit->DbValue = $row['unit'];
        $this->mil->DbValue = $row['mil'];
        $this->req_material_qty->DbValue = $row['req_material_qty'];
        $this->po_s_pending->DbValue = $row['po_s_pending'];
        $this->po_pending_wbc->DbValue = $row['po_pending_wbc'];
        $this->not_loomcard->DbValue = $row['not_loomcard'];
        $this->stock->DbValue = $row['stock'];
        $this->company_id->DbValue = $row['company_id'];
        $this->last_supplier_id->DbValue = $row['last_supplier_id'];
        $this->internal_external->DbValue = $row['internal_external'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("requiredmaterialoveralltablelist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "requiredmaterialoveralltableview" => $Language->phrase("View"),
            "requiredmaterialoveralltableedit" => $Language->phrase("Edit"),
            "requiredmaterialoveralltableadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "requiredmaterialoveralltablelist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "RequiredMaterialOverallTableView",
            Config("API_ADD_ACTION") => "RequiredMaterialOverallTableAdd",
            Config("API_EDIT_ACTION") => "RequiredMaterialOverallTableEdit",
            Config("API_DELETE_ACTION") => "RequiredMaterialOverallTableDelete",
            Config("API_LIST_ACTION") => "RequiredMaterialOverallTableList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "requiredmaterialoveralltablelist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("requiredmaterialoveralltableview", $parm);
        } else {
            $url = $this->keyUrl("requiredmaterialoveralltableview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "requiredmaterialoveralltableadd?" . $parm;
        } else {
            $url = "requiredmaterialoveralltableadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("requiredmaterialoveralltableedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("requiredmaterialoveralltablelist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("requiredmaterialoveralltableadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("requiredmaterialoveralltablelist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("requiredmaterialoveralltabledelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->pending->setDbValue($row['pending']);
        $this->req_material_grp->setDbValue($row['req_material_grp']);
        $this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
        $this->req_material_product->setDbValue($row['req_material_product']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->unit->setDbValue($row['unit']);
        $this->mil->setDbValue($row['mil']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->po_s_pending->setDbValue($row['po_s_pending']);
        $this->po_pending_wbc->setDbValue($row['po_pending_wbc']);
        $this->not_loomcard->setDbValue($row['not_loomcard']);
        $this->stock->setDbValue($row['stock']);
        $this->company_id->setDbValue($row['company_id']);
        $this->last_supplier_id->setDbValue($row['last_supplier_id']);
        $this->internal_external->setDbValue($row['internal_external']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "RequiredMaterialOverallTableList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // pending

        // req_material_grp
        $this->req_material_grp->CellCssStyle = "white-space: nowrap;";

        // req_material_sgrp
        $this->req_material_sgrp->CellCssStyle = "white-space: nowrap;";

        // req_material_product

        // req_material_rid

        // req_material_packing

        // batch_no

        // unit

        // mil

        // req_material_qty

        // po_s_pending

        // po_pending_wbc

        // not_loomcard

        // stock

        // company_id

        // last_supplier_id

        // internal_external

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // pending
        $this->pending->ViewValue = $this->pending->CurrentValue;
        $this->pending->ViewValue = FormatNumber($this->pending->ViewValue, $this->pending->formatPattern());

        // req_material_grp
        $curVal = strval($this->req_material_grp->CurrentValue);
        if ($curVal != "") {
            $this->req_material_grp->ViewValue = $this->req_material_grp->lookupCacheOption($curVal);
            if ($this->req_material_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->req_material_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->req_material_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->req_material_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->req_material_grp->ViewValue = $this->req_material_grp->displayValue($arwrk);
                } else {
                    $this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->CurrentValue, $this->req_material_grp->formatPattern());
                }
            }
        } else {
            $this->req_material_grp->ViewValue = null;
        }

        // req_material_sgrp
        $curVal = strval($this->req_material_sgrp->CurrentValue);
        if ($curVal != "") {
            $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
            if ($this->req_material_sgrp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->req_material_sgrp->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_sgrp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->req_material_sgrp->Lookup->renderViewRow($rswrk[0]);
                    $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
                } else {
                    $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
                }
            }
        } else {
            $this->req_material_sgrp->ViewValue = null;
        }

        // req_material_product
        $curVal = strval($this->req_material_product->CurrentValue);
        if ($curVal != "") {
            $this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
            if ($this->req_material_product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->req_material_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->req_material_product->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->req_material_product->Lookup->renderViewRow($rswrk[0]);
                    $this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
                } else {
                    $this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
                }
            }
        } else {
            $this->req_material_product->ViewValue = null;
        }

        // req_material_rid
        $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
        $curVal = strval($this->req_material_rid->CurrentValue);
        if ($curVal != "") {
            $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
            if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->req_material_rid->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                    $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                } else {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                }
            }
        } else {
            $this->req_material_rid->ViewValue = null;
        }

        // req_material_packing
        $curVal = strval($this->req_material_packing->CurrentValue);
        if ($curVal != "") {
            $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
            if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                    $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                } else {
                    $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                }
            }
        } else {
            $this->req_material_packing->ViewValue = null;
        }

        // batch_no
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = $this->batch_no->CurrentValue;
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // unit
        $curVal = strval($this->unit->CurrentValue);
        if ($curVal != "") {
            $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            if ($this->unit->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                    $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                } else {
                    $this->unit->ViewValue = $this->unit->CurrentValue;
                }
            }
        } else {
            $this->unit->ViewValue = null;
        }

        // mil
        $this->mil->ViewValue = $this->mil->CurrentValue;
        $this->mil->ViewValue = FormatNumber($this->mil->ViewValue, $this->mil->formatPattern());

        // req_material_qty
        $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

        // po_s_pending
        $this->po_s_pending->ViewValue = $this->po_s_pending->CurrentValue;
        $this->po_s_pending->ViewValue = FormatNumber($this->po_s_pending->ViewValue, $this->po_s_pending->formatPattern());

        // po_pending_wbc
        $this->po_pending_wbc->ViewValue = $this->po_pending_wbc->CurrentValue;
        $this->po_pending_wbc->ViewValue = FormatNumber($this->po_pending_wbc->ViewValue, $this->po_pending_wbc->formatPattern());

        // not_loomcard
        $this->not_loomcard->ViewValue = $this->not_loomcard->CurrentValue;
        $this->not_loomcard->ViewValue = FormatNumber($this->not_loomcard->ViewValue, $this->not_loomcard->formatPattern());

        // stock
        $this->stock->ViewValue = $this->stock->CurrentValue;
        $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = $this->company_id->CurrentValue;
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // last_supplier_id
        $this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
        $curVal = strval($this->last_supplier_id->CurrentValue);
        if ($curVal != "") {
            $this->last_supplier_id->ViewValue = $this->last_supplier_id->lookupCacheOption($curVal);
            if ($this->last_supplier_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->last_supplier_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->last_supplier_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->last_supplier_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->last_supplier_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->last_supplier_id->Lookup->renderViewRow($rswrk[0]);
                    $this->last_supplier_id->ViewValue = $this->last_supplier_id->displayValue($arwrk);
                } else {
                    $this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
                }
            }
        } else {
            $this->last_supplier_id->ViewValue = null;
        }

        // internal_external
        if (strval($this->internal_external->CurrentValue) != "") {
            $this->internal_external->ViewValue = $this->internal_external->optionCaption($this->internal_external->CurrentValue);
        } else {
            $this->internal_external->ViewValue = null;
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // pending
        $this->pending->HrefValue = "";
        $this->pending->TooltipValue = "";

        // req_material_grp
        $this->req_material_grp->HrefValue = "";
        $this->req_material_grp->TooltipValue = "";

        // req_material_sgrp
        $this->req_material_sgrp->HrefValue = "";
        $this->req_material_sgrp->TooltipValue = "";

        // req_material_product
        $this->req_material_product->HrefValue = "";
        $this->req_material_product->TooltipValue = "";

        // req_material_rid
        if (!EmptyValue($this->req_material_rid->CurrentValue)) {
            $this->req_material_rid->HrefValue = $this->req_material_rid->getLinkPrefix() . $this->req_material_rid->CurrentValue; // Add prefix/suffix
            $this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
            }
        } else {
            $this->req_material_rid->HrefValue = "";
        }
        $this->req_material_rid->TooltipValue = "";

        // req_material_packing
        if (!EmptyValue($this->req_material_packing->CurrentValue)) {
            $this->req_material_packing->HrefValue = $this->req_material_packing->getLinkPrefix() . $this->req_material_packing->CurrentValue; // Add prefix/suffix
            $this->req_material_packing->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->req_material_packing->HrefValue = FullUrl($this->req_material_packing->HrefValue, "href");
            }
        } else {
            $this->req_material_packing->HrefValue = "";
        }
        $this->req_material_packing->TooltipValue = "";

        // batch_no
        if (!EmptyValue($this->batch_no->CurrentValue)) {
            $this->batch_no->HrefValue = $this->batch_no->getLinkPrefix() . $this->batch_no->CurrentValue; // Add prefix/suffix
            $this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
            }
        } else {
            $this->batch_no->HrefValue = "";
        }
        $this->batch_no->TooltipValue = "";

        // unit
        $this->unit->HrefValue = "";
        $this->unit->TooltipValue = "";

        // mil
        $this->mil->HrefValue = "";
        $this->mil->TooltipValue = "";

        // req_material_qty
        $this->req_material_qty->HrefValue = "";
        $this->req_material_qty->TooltipValue = "";

        // po_s_pending
        $this->po_s_pending->HrefValue = "";
        $this->po_s_pending->TooltipValue = "";

        // po_pending_wbc
        $this->po_pending_wbc->HrefValue = "";
        $this->po_pending_wbc->TooltipValue = "";

        // not_loomcard
        $this->not_loomcard->HrefValue = "";
        $this->not_loomcard->TooltipValue = "";

        // stock
        $this->stock->HrefValue = "";
        $this->stock->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // last_supplier_id
        $this->last_supplier_id->HrefValue = "";
        $this->last_supplier_id->TooltipValue = "";

        // internal_external
        $this->internal_external->HrefValue = "";
        $this->internal_external->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // pending
        $this->pending->setupEditAttributes();
        $this->pending->EditValue = $this->pending->CurrentValue;
        $this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
        if (strval($this->pending->EditValue) != "" && is_numeric($this->pending->EditValue)) {
            $this->pending->EditValue = FormatNumber($this->pending->EditValue, null);
        }

        // req_material_grp
        $this->req_material_grp->setupEditAttributes();
        $this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());

        // req_material_sgrp
        $this->req_material_sgrp->setupEditAttributes();
        $this->req_material_sgrp->PlaceHolder = RemoveHtml($this->req_material_sgrp->caption());

        // req_material_product
        $this->req_material_product->setupEditAttributes();
        $this->req_material_product->PlaceHolder = RemoveHtml($this->req_material_product->caption());

        // req_material_rid
        $this->req_material_rid->setupEditAttributes();
        $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
        $this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

        // req_material_packing
        $this->req_material_packing->setupEditAttributes();
        $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // unit
        $this->unit->setupEditAttributes();
        $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

        // mil
        $this->mil->setupEditAttributes();
        $this->mil->EditValue = $this->mil->CurrentValue;
        $this->mil->PlaceHolder = RemoveHtml($this->mil->caption());
        if (strval($this->mil->EditValue) != "" && is_numeric($this->mil->EditValue)) {
            $this->mil->EditValue = FormatNumber($this->mil->EditValue, null);
        }

        // req_material_qty
        $this->req_material_qty->setupEditAttributes();
        $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
        if (strval($this->req_material_qty->EditValue) != "" && is_numeric($this->req_material_qty->EditValue)) {
            $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, null);
        }

        // po_s_pending
        $this->po_s_pending->setupEditAttributes();
        $this->po_s_pending->EditValue = $this->po_s_pending->CurrentValue;
        $this->po_s_pending->PlaceHolder = RemoveHtml($this->po_s_pending->caption());
        if (strval($this->po_s_pending->EditValue) != "" && is_numeric($this->po_s_pending->EditValue)) {
            $this->po_s_pending->EditValue = FormatNumber($this->po_s_pending->EditValue, null);
        }

        // po_pending_wbc
        $this->po_pending_wbc->setupEditAttributes();
        $this->po_pending_wbc->EditValue = $this->po_pending_wbc->CurrentValue;
        $this->po_pending_wbc->PlaceHolder = RemoveHtml($this->po_pending_wbc->caption());
        if (strval($this->po_pending_wbc->EditValue) != "" && is_numeric($this->po_pending_wbc->EditValue)) {
            $this->po_pending_wbc->EditValue = FormatNumber($this->po_pending_wbc->EditValue, null);
        }

        // not_loomcard
        $this->not_loomcard->setupEditAttributes();
        $this->not_loomcard->EditValue = $this->not_loomcard->CurrentValue;
        $this->not_loomcard->PlaceHolder = RemoveHtml($this->not_loomcard->caption());
        if (strval($this->not_loomcard->EditValue) != "" && is_numeric($this->not_loomcard->EditValue)) {
            $this->not_loomcard->EditValue = FormatNumber($this->not_loomcard->EditValue, null);
        }

        // stock
        $this->stock->setupEditAttributes();
        $this->stock->EditValue = $this->stock->CurrentValue;
        $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
        if (strval($this->stock->EditValue) != "" && is_numeric($this->stock->EditValue)) {
            $this->stock->EditValue = FormatNumber($this->stock->EditValue, null);
        }

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // last_supplier_id
        $this->last_supplier_id->setupEditAttributes();
        $this->last_supplier_id->EditValue = $this->last_supplier_id->CurrentValue;
        $this->last_supplier_id->PlaceHolder = RemoveHtml($this->last_supplier_id->caption());

        // internal_external
        $this->internal_external->setupEditAttributes();
        $this->internal_external->EditValue = $this->internal_external->options(true);
        $this->internal_external->PlaceHolder = RemoveHtml($this->internal_external->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->pending->CurrentValue)) {
                $this->pending->Total += $this->pending->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->req_material_qty->CurrentValue)) {
                $this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->po_s_pending->CurrentValue)) {
                $this->po_s_pending->Total += $this->po_s_pending->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->po_pending_wbc->CurrentValue)) {
                $this->po_pending_wbc->Total += $this->po_pending_wbc->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->not_loomcard->CurrentValue)) {
                $this->not_loomcard->Total += $this->not_loomcard->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->stock->CurrentValue)) {
                $this->stock->Total += $this->stock->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->pending->CurrentValue = $this->pending->Total;
            $this->pending->ViewValue = $this->pending->CurrentValue;
            $this->pending->ViewValue = FormatNumber($this->pending->ViewValue, $this->pending->formatPattern());
            $this->pending->HrefValue = ""; // Clear href value
            $this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());
            $this->req_material_qty->HrefValue = ""; // Clear href value
            $this->po_s_pending->CurrentValue = $this->po_s_pending->Total;
            $this->po_s_pending->ViewValue = $this->po_s_pending->CurrentValue;
            $this->po_s_pending->ViewValue = FormatNumber($this->po_s_pending->ViewValue, $this->po_s_pending->formatPattern());
            $this->po_s_pending->HrefValue = ""; // Clear href value
            $this->po_pending_wbc->CurrentValue = $this->po_pending_wbc->Total;
            $this->po_pending_wbc->ViewValue = $this->po_pending_wbc->CurrentValue;
            $this->po_pending_wbc->ViewValue = FormatNumber($this->po_pending_wbc->ViewValue, $this->po_pending_wbc->formatPattern());
            $this->po_pending_wbc->HrefValue = ""; // Clear href value
            $this->not_loomcard->CurrentValue = $this->not_loomcard->Total;
            $this->not_loomcard->ViewValue = $this->not_loomcard->CurrentValue;
            $this->not_loomcard->ViewValue = FormatNumber($this->not_loomcard->ViewValue, $this->not_loomcard->formatPattern());
            $this->not_loomcard->HrefValue = ""; // Clear href value
            $this->stock->CurrentValue = $this->stock->Total;
            $this->stock->ViewValue = $this->stock->CurrentValue;
            $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());
            $this->stock->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pending);
                    $doc->exportCaption($this->req_material_product);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->mil);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->po_s_pending);
                    $doc->exportCaption($this->po_pending_wbc);
                    $doc->exportCaption($this->not_loomcard);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->last_supplier_id);
                    $doc->exportCaption($this->internal_external);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->pending);
                    $doc->exportCaption($this->req_material_product);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->mil);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->po_s_pending);
                    $doc->exportCaption($this->po_pending_wbc);
                    $doc->exportCaption($this->not_loomcard);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->last_supplier_id);
                    $doc->exportCaption($this->internal_external);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pending);
                        $doc->exportField($this->req_material_product);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->mil);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->po_s_pending);
                        $doc->exportField($this->po_pending_wbc);
                        $doc->exportField($this->not_loomcard);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->last_supplier_id);
                        $doc->exportField($this->internal_external);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->pending);
                        $doc->exportField($this->req_material_product);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->mil);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->po_s_pending);
                        $doc->exportField($this->po_pending_wbc);
                        $doc->exportField($this->not_loomcard);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->last_supplier_id);
                        $doc->exportField($this->internal_external);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->pending, 'TOTAL');
                $doc->exportAggregate($this->req_material_product, '');
                $doc->exportAggregate($this->req_material_rid, '');
                $doc->exportAggregate($this->req_material_packing, '');
                $doc->exportAggregate($this->batch_no, '');
                $doc->exportAggregate($this->unit, '');
                $doc->exportAggregate($this->mil, '');
                $doc->exportAggregate($this->req_material_qty, 'TOTAL');
                $doc->exportAggregate($this->po_s_pending, 'TOTAL');
                $doc->exportAggregate($this->po_pending_wbc, 'TOTAL');
                $doc->exportAggregate($this->not_loomcard, 'TOTAL');
                $doc->exportAggregate($this->stock, 'TOTAL');
                $doc->exportAggregate($this->last_supplier_id, '');
                $doc->exportAggregate($this->internal_external, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
