<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RequiredMaterialCompiledSearch extends RequiredMaterialCompiled
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RequiredMaterialCompiledSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "requiredmaterialcompiledsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->week->setVisibility();
        $this->po->setVisibility();
        $this->buyer_id->setVisibility();
        $this->req_material_sgrp->setVisibility();
        $this->req_material_product->setVisibility();
        $this->req_material_rid->setVisibility();
        $this->req_material_packing->setVisibility();
        $this->req_material_qty->setVisibility();
        $this->stock->setVisibility();
        $this->unit->setVisibility();
        $this->company_id->setVisibility();
        $this->url->Visible = false;
        $this->req_material_grp->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'required_material_compiled';
        $this->TableName = 'required_material_compiled';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (required_material_compiled)
        if (!isset($GLOBALS["required_material_compiled"]) || $GLOBALS["required_material_compiled"]::class == PROJECT_NAMESPACE . "required_material_compiled") {
            $GLOBALS["required_material_compiled"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'required_material_compiled');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "requiredmaterialcompiledview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->week->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->req_material_qty->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->stock->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->week);
        $this->setupLookupOptions($this->buyer_id);
        $this->setupLookupOptions($this->req_material_sgrp);
        $this->setupLookupOptions($this->req_material_product);
        $this->setupLookupOptions($this->req_material_rid);
        $this->setupLookupOptions($this->req_material_packing);
        $this->setupLookupOptions($this->unit);
        $this->setupLookupOptions($this->company_id);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "requiredmaterialcompiledlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->week); // week
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
        $this->buildSearchUrl($srchUrl, $this->req_material_sgrp); // req_material_sgrp
        $this->buildSearchUrl($srchUrl, $this->req_material_product); // req_material_product
        $this->buildSearchUrl($srchUrl, $this->req_material_rid); // req_material_rid
        $this->buildSearchUrl($srchUrl, $this->req_material_packing); // req_material_packing
        $this->buildSearchUrl($srchUrl, $this->req_material_qty); // req_material_qty
        $this->buildSearchUrl($srchUrl, $this->stock); // stock
        $this->buildSearchUrl($srchUrl, $this->unit); // unit
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // week
        if ($this->week->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_id
        if ($this->buyer_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_sgrp
        if ($this->req_material_sgrp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_product
        if ($this->req_material_product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_rid
        if ($this->req_material_rid->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_packing
        if ($this->req_material_packing->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // req_material_qty
        if ($this->req_material_qty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // stock
        if ($this->stock->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // unit
        if ($this->unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // week
        $this->week->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // buyer_id
        $this->buyer_id->RowCssClass = "row";

        // req_material_sgrp
        $this->req_material_sgrp->RowCssClass = "row";

        // req_material_product
        $this->req_material_product->RowCssClass = "row";

        // req_material_rid
        $this->req_material_rid->RowCssClass = "row";

        // req_material_packing
        $this->req_material_packing->RowCssClass = "row";

        // req_material_qty
        $this->req_material_qty->RowCssClass = "row";

        // stock
        $this->stock->RowCssClass = "row";

        // unit
        $this->unit->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // req_material_grp
        $this->req_material_grp->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // week
            $curVal = strval($this->week->CurrentValue);
            if ($curVal != "") {
                $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
                if ($this->week->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["wid"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["wid"]->searchDataType(), "");
                    $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                        $this->week->ViewValue = $this->week->displayValue($arwrk);
                    } else {
                        $this->week->ViewValue = $this->week->CurrentValue;
                    }
                }
            } else {
                $this->week->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // buyer_id
            $curVal = strval($this->buyer_id->CurrentValue);
            if ($curVal != "") {
                $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
                if ($this->buyer_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                    } else {
                        $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                    }
                }
            } else {
                $this->buyer_id->ViewValue = null;
            }

            // req_material_sgrp
            if ($this->req_material_sgrp->VirtualValue != "") {
                $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->VirtualValue;
            } else {
                $curVal = strval($this->req_material_sgrp->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
                    if ($this->req_material_sgrp->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_sgrp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_sgrp->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
                        } else {
                            $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_sgrp->ViewValue = null;
                }
            }

            // req_material_product
            if ($this->req_material_product->VirtualValue != "") {
                $this->req_material_product->ViewValue = $this->req_material_product->VirtualValue;
            } else {
                $curVal = strval($this->req_material_product->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
                    if ($this->req_material_product->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_product->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
                        } else {
                            $this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_product->ViewValue = null;
                }
            }

            // req_material_rid
            if ($this->req_material_rid->VirtualValue != "") {
                $this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
            } else {
                $curVal = strval($this->req_material_rid->CurrentValue);
                if ($curVal != "") {
                    $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                    if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                            $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                        } else {
                            $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                        }
                    }
                } else {
                    $this->req_material_rid->ViewValue = null;
                }
            }

            // req_material_packing
            $curVal = strval($this->req_material_packing->CurrentValue);
            if ($curVal != "") {
                $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
                if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                    $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                    } else {
                        $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                    }
                }
            } else {
                $this->req_material_packing->ViewValue = null;
            }

            // req_material_qty
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

            // stock
            $this->stock->ViewValue = $this->stock->CurrentValue;
            $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

            // unit
            $curVal = strval($this->unit->CurrentValue);
            if ($curVal != "") {
                $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
                if ($this->unit->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                        $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                    } else {
                        $this->unit->ViewValue = $this->unit->CurrentValue;
                    }
                }
            } else {
                $this->unit->ViewValue = null;
            }

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // week
            $this->week->HrefValue = "";
            $this->week->TooltipValue = "";

            // po
            if (!EmptyValue($this->po->CurrentValue)) {
                $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
                $this->po->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
                }
            } else {
                $this->po->HrefValue = "";
            }
            $this->po->TooltipValue = "";

            // buyer_id
            if (!EmptyValue($this->buyer_id->CurrentValue)) {
                $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
                $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
                }
            } else {
                $this->buyer_id->HrefValue = "";
            }
            $this->buyer_id->TooltipValue = "";

            // req_material_sgrp
            if (!EmptyValue($this->req_material_sgrp->CurrentValue)) {
                $this->req_material_sgrp->HrefValue = $this->req_material_sgrp->getLinkPrefix() . $this->req_material_sgrp->CurrentValue; // Add prefix/suffix
                $this->req_material_sgrp->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->req_material_sgrp->HrefValue = FullUrl($this->req_material_sgrp->HrefValue, "href");
                }
            } else {
                $this->req_material_sgrp->HrefValue = "";
            }
            $this->req_material_sgrp->TooltipValue = "";

            // req_material_product
            if (!EmptyValue($this->req_material_product->CurrentValue)) {
                $this->req_material_product->HrefValue = $this->req_material_product->getLinkPrefix() . $this->req_material_product->CurrentValue; // Add prefix/suffix
                $this->req_material_product->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->req_material_product->HrefValue = FullUrl($this->req_material_product->HrefValue, "href");
                }
            } else {
                $this->req_material_product->HrefValue = "";
            }
            $this->req_material_product->TooltipValue = "";

            // req_material_rid
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->req_material_rid->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->req_material_rid->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
                }
            } else {
                $this->req_material_rid->HrefValue = "";
            }
            $this->req_material_rid->TooltipValue = "";

            // req_material_packing
            $this->req_material_packing->HrefValue = "";
            $this->req_material_packing->TooltipValue = "";

            // req_material_qty
            $this->req_material_qty->HrefValue = "";
            $this->req_material_qty->TooltipValue = "";

            // stock
            $this->stock->HrefValue = "";
            $this->stock->TooltipValue = "";

            // unit
            if (!EmptyValue($this->unit->CurrentValue)) {
                $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
                $this->unit->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
                }
            } else {
                $this->unit->HrefValue = "";
            }
            $this->unit->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // week
            $this->week->setupEditAttributes();
            $this->week->EditCustomAttributes = $this->week->getEditCustomAttributes(); // PHP
            $curVal = trim(strval($this->week->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->week->AdvancedSearch->ViewValue = $this->week->lookupCacheOption($curVal);
            } else {
                $this->week->AdvancedSearch->ViewValue = $this->week->Lookup !== null && is_array($this->week->lookupOptions()) && count($this->week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->week->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->week->EditValue = array_values($this->week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["wid"]->searchExpression(), "=", $this->week->AdvancedSearch->SearchValue, $this->week->Lookup->getTable()->Fields["wid"]->searchDataType(), "");
                }
                $sqlWrk = $this->week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->week->EditValue = $arwrk;
            }
            $this->week->PlaceHolder = RemoveHtml($this->week->caption());
            $this->week->setupEditAttributes();
            $this->week->EditCustomAttributes = $this->week->getEditCustomAttributes(); // PHP
            $curVal = trim(strval($this->week->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->week->AdvancedSearch->ViewValue2 = $this->week->lookupCacheOption($curVal);
            } else {
                $this->week->AdvancedSearch->ViewValue2 = $this->week->Lookup !== null && is_array($this->week->lookupOptions()) && count($this->week->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->week->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->week->EditValue2 = array_values($this->week->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["wid"]->searchExpression(), "=", $this->week->AdvancedSearch->SearchValue2, $this->week->Lookup->getTable()->Fields["wid"]->searchDataType(), "");
                }
                $sqlWrk = $this->week->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->week->EditValue2 = $arwrk;
            }
            $this->week->PlaceHolder = RemoveHtml($this->week->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());
            $this->po->setupEditAttributes();
            $this->po->EditValue2 = $this->po->AdvancedSearch->SearchValue2;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // buyer_id
            $this->buyer_id->setupEditAttributes();
            $curVal = trim(strval($this->buyer_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            } else {
                $this->buyer_id->AdvancedSearch->ViewValue = $this->buyer_id->Lookup !== null && is_array($this->buyer_id->lookupOptions()) && count($this->buyer_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->buyer_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->buyer_id->EditValue = array_values($this->buyer_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->buyer_id->AdvancedSearch->SearchValue, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->buyer_id->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->buyer_id->EditValue = $arwrk;
            }
            $this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

            // req_material_sgrp
            $this->req_material_sgrp->setupEditAttributes();
            $this->req_material_sgrp->EditValue = $this->req_material_sgrp->AdvancedSearch->SearchValue;
            $this->req_material_sgrp->PlaceHolder = RemoveHtml($this->req_material_sgrp->caption());

            // req_material_product
            $this->req_material_product->setupEditAttributes();
            $this->req_material_product->EditValue = $this->req_material_product->AdvancedSearch->SearchValue;
            $this->req_material_product->PlaceHolder = RemoveHtml($this->req_material_product->caption());

            // req_material_rid
            $this->req_material_rid->setupEditAttributes();
            $this->req_material_rid->EditValue = $this->req_material_rid->AdvancedSearch->SearchValue;
            $this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

            // req_material_packing
            $this->req_material_packing->setupEditAttributes();
            $curVal = trim(strval($this->req_material_packing->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
            } else {
                $this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->Lookup !== null && is_array($this->req_material_packing->lookupOptions()) && count($this->req_material_packing->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->req_material_packing->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->req_material_packing->EditValue = array_values($this->req_material_packing->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->req_material_packing->AdvancedSearch->SearchValue, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_packing->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->req_material_packing->EditValue = $arwrk;
            }
            $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

            // req_material_qty
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue = $this->req_material_qty->AdvancedSearch->SearchValue;
            $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
            $this->req_material_qty->setupEditAttributes();
            $this->req_material_qty->EditValue2 = $this->req_material_qty->AdvancedSearch->SearchValue2;
            $this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());

            // stock
            $this->stock->setupEditAttributes();
            $this->stock->EditValue = $this->stock->AdvancedSearch->SearchValue;
            $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());

            // unit
            $this->unit->setupEditAttributes();
            $curVal = trim(strval($this->unit->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->unit->AdvancedSearch->ViewValue = $this->unit->lookupCacheOption($curVal);
            } else {
                $this->unit->AdvancedSearch->ViewValue = $this->unit->Lookup !== null && is_array($this->unit->lookupOptions()) && count($this->unit->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->unit->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->unit->EditValue = array_values($this->unit->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->unit->AdvancedSearch->SearchValue, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->unit->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->unit->EditValue = $arwrk;
            }
            $this->unit->PlaceHolder = RemoveHtml($this->unit->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->AdvancedSearch->SearchValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckInteger($this->po->AdvancedSearch->SearchValue2)) {
            $this->po->addErrorMessage($this->po->getErrorMessage(false));
        }
        if (!CheckNumber($this->req_material_qty->AdvancedSearch->SearchValue)) {
            $this->req_material_qty->addErrorMessage($this->req_material_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->req_material_qty->AdvancedSearch->SearchValue2)) {
            $this->req_material_qty->addErrorMessage($this->req_material_qty->getErrorMessage(false));
        }
        if (!CheckNumber($this->stock->AdvancedSearch->SearchValue)) {
            $this->stock->addErrorMessage($this->stock->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->week->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->buyer_id->AdvancedSearch->load();
        $this->req_material_sgrp->AdvancedSearch->load();
        $this->req_material_product->AdvancedSearch->load();
        $this->req_material_rid->AdvancedSearch->load();
        $this->req_material_packing->AdvancedSearch->load();
        $this->req_material_qty->AdvancedSearch->load();
        $this->stock->AdvancedSearch->load();
        $this->unit->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("requiredmaterialcompiledlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_week":
                    break;
                case "x_buyer_id":
                    break;
                case "x_req_material_sgrp":
                    break;
                case "x_req_material_product":
                    break;
                case "x_req_material_rid":
                    break;
                case "x_req_material_packing":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_unit":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
