<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for required_material_compiled
 */
class RequiredMaterialCompiled extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $week;
    public $po;
    public $buyer_id;
    public $req_material_sgrp;
    public $req_material_product;
    public $req_material_rid;
    public $req_material_packing;
    public $req_material_qty;
    public $stock;
    public $unit;
    public $company_id;
    public $url;
    public $req_material_grp;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "required_material_compiled";
        $this->TableName = 'required_material_compiled';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "required_material_compiled";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // week
        $this->week = new DbField(
            $this, // Table
            'x_week', // Variable name
            'week', // Name
            '`week`', // Expression
            '`week`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->week->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->week->InputTextType = "text";
        $this->week->Required = true; // Required field
        $this->week->setSelectMultiple(false); // Select one
        $this->week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->week->Lookup = new Lookup($this->week, 'not_week', false, 'wid', ["week","","",""], '', '', [], [], [], [], [], [], false, '`week` ASC', '', "`week`");
        $this->week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->week->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['week'] = &$this->week;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->po->addMethod("getLinkPrefix", fn() => "requiredmaterialcompiledlist?x_po=");
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->IsForeignKey = true; // Foreign key field
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // buyer_id
        $this->buyer_id = new DbField(
            $this, // Table
            'x_buyer_id', // Variable name
            'buyer_id', // Name
            '`buyer_id`', // Expression
            '`buyer_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyer_id->addMethod("getLinkPrefix", fn() => "requiredmaterialcompiledlist?x_buyer_id=");
        $this->buyer_id->InputTextType = "text";
        $this->buyer_id->Raw = true;
        $this->buyer_id->Nullable = false; // NOT NULL field
        $this->buyer_id->Required = true; // Required field
        $this->buyer_id->setSelectMultiple(false); // Select one
        $this->buyer_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyer_id->Lookup = new Lookup($this->buyer_id, 'buyer_seller_view', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyer_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['buyer_id'] = &$this->buyer_id;

        // req_material_sgrp
        $this->req_material_sgrp = new DbField(
            $this, // Table
            'x_req_material_sgrp', // Variable name
            'req_material_sgrp', // Name
            '`req_material_sgrp`', // Expression
            '`req_material_sgrp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__req_material_sgrp', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_sgrp->addMethod("getLinkPrefix", fn() => "requiredmaterialcompiledlist?x_required_material_sgrp=");
        $this->req_material_sgrp->InputTextType = "text";
        $this->req_material_sgrp->Raw = true;
        $this->req_material_sgrp->setSelectMultiple(false); // Select one
        $this->req_material_sgrp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_sgrp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_sgrp->Lookup = new Lookup($this->req_material_sgrp, 'product_group', false, 'id', ["product_group","","",""], '', '', [], ["x_req_material_product"], [], [], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->req_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_sgrp->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_sgrp'] = &$this->req_material_sgrp;

        // req_material_product
        $this->req_material_product = new DbField(
            $this, // Table
            'x_req_material_product', // Variable name
            'req_material_product', // Name
            '`req_material_product`', // Expression
            '`req_material_product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__req_material_product', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_product->addMethod("getLinkPrefix", fn() => "requiredmaterialcompiledlist?x_required_material_product=");
        $this->req_material_product->InputTextType = "text";
        $this->req_material_product->Raw = true;
        $this->req_material_product->setSelectMultiple(false); // Select one
        $this->req_material_product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_product->Lookup = new Lookup($this->req_material_product, 'product', false, 'id', ["product","","",""], '', '', ["x_req_material_sgrp"], ["x_req_material_rid"], ["s_grp"], ["x_s_grp[]"], [], [], false, '`product` ASC', '', "`product`");
        $this->req_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_product->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_product'] = &$this->req_material_product;

        // req_material_rid
        $this->req_material_rid = new DbField(
            $this, // Table
            'x_req_material_rid', // Variable name
            'req_material_rid', // Name
            '`req_material_rid`', // Expression
            '`req_material_rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__req_material_rid', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_rid->InputTextType = "text";
        $this->req_material_rid->Raw = true;
        $this->req_material_rid->IsForeignKey = true; // Foreign key field
        $this->req_material_rid->setSelectMultiple(false); // Select one
        $this->req_material_rid->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_rid->Lookup = new Lookup($this->req_material_rid, 'ref', false, 'id', ["product_code","","",""], '', '', ["x_req_material_product"], [], ["product"], ["x_product"], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_rid->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_rid'] = &$this->req_material_rid;

        // req_material_packing
        $this->req_material_packing = new DbField(
            $this, // Table
            'x_req_material_packing', // Variable name
            'req_material_packing', // Name
            '`req_material_packing`', // Expression
            '`req_material_packing`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_packing`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->req_material_packing->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->req_material_packing->InputTextType = "text";
        $this->req_material_packing->Raw = true;
        $this->req_material_packing->Nullable = false; // NOT NULL field
        $this->req_material_packing->Required = true; // Required field
        $this->req_material_packing->setSelectMultiple(false); // Select one
        $this->req_material_packing->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->req_material_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->req_material_packing->Lookup = new Lookup($this->req_material_packing, 'packing_type', false, 'id', ["packing","","",""], '', '', [], [], [], [], [], [], false, '`packing` ASC', '', "`packing`");
        $this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_packing->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['req_material_packing'] = &$this->req_material_packing;

        // req_material_qty
        $this->req_material_qty = new DbField(
            $this, // Table
            'x_req_material_qty', // Variable name
            'req_material_qty', // Name
            '`req_material_qty`', // Expression
            '`req_material_qty`', // Basic search expression
            131, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_qty->InputTextType = "text";
        $this->req_material_qty->Raw = true;
        $this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->req_material_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_qty'] = &$this->req_material_qty;

        // stock
        $this->stock = new DbField(
            $this, // Table
            'x_stock', // Variable name
            'stock', // Name
            '`stock`', // Expression
            '`stock`', // Basic search expression
            131, // Type
            67, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->stock->InputTextType = "text";
        $this->stock->Raw = true;
        $this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['stock'] = &$this->stock;

        // unit
        $this->unit = new DbField(
            $this, // Table
            'x_unit', // Variable name
            'unit', // Name
            '`unit`', // Expression
            '`unit`', // Basic search expression
            200, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->unit->addMethod("getLinkPrefix", fn() => "requiredmaterialcompiledlist?x_unit=");
        $this->unit->InputTextType = "text";
        $this->unit->Required = true; // Required field
        $this->unit->setSelectMultiple(false); // Select one
        $this->unit->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->unit->Lookup = new Lookup($this->unit, 'unit', false, 'id', ["description","","",""], '', '', [], [], [], [], [], [], false, '`description` ASC', '', "`description`");
        $this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->unit->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['unit'] = &$this->unit;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => "`category`=1 and `status` = 1");
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Nullable = false; // NOT NULL field
        $this->company_id->Required = true; // Required field
        $this->company_id->setSelectMultiple(false); // Select one
        $this->company_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->company_id->Lookup = new Lookup($this->company_id, 'production_partner', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['company_id'] = &$this->company_id;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            'concat(\'materialrequiredlist?x_po=\', `po`, \'&x_req_material_rid=\', `req_material_rid`)', // Expression
            'concat(\'materialrequiredlist?x_po=\', `po`, \'&x_req_material_rid=\', `req_material_rid`)', // Basic search expression
            200, // Type
            61, // Size
            -1, // Date/Time format
            false, // Is upload field
            'concat(\'materialrequiredlist?x_po=\', `po`, \'&x_req_material_rid=\', `req_material_rid`)', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->IsCustom = true; // Custom field
        $this->url->Sortable = false; // Allow sort
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['url'] = &$this->url;

        // req_material_grp
        $this->req_material_grp = new DbField(
            $this, // Table
            'x_req_material_grp', // Variable name
            'req_material_grp', // Name
            '`req_material_grp`', // Expression
            '`req_material_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`req_material_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->req_material_grp->InputTextType = "text";
        $this->req_material_grp->Raw = true;
        $this->req_material_grp->Sortable = false; // Allow sort
        $this->req_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->req_material_grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['req_material_grp'] = &$this->req_material_grp;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "material_required") {
            $detailUrl = Container("material_required")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_po", $this->po->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_req_material_rid", $this->req_material_rid->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "stock_lcgp") {
            $detailUrl = Container("stock_lcgp")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_req_material_rid", $this->req_material_rid->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "material_required_old") {
            $detailUrl = Container("material_required_old")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_po", $this->po->CurrentValue);
            $detailUrl .= "&" . GetForeignKeyUrl("fk_req_material_rid", $this->req_material_rid->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "requiredmaterialcompiledlist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "required_material_compiled";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, concat('materialrequiredlist?x_po=', `po`, '&x_req_material_rid=', `req_material_rid`) AS `url`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `product_code` FROM ref TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = required_material_compiled.req_material_rid LIMIT 1) AS EV__req_material_rid FROM required_material_compiled)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->req_material_sgrp->AdvancedSearch->SearchValue != "" ||
            $this->req_material_sgrp->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->req_material_sgrp->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->req_material_sgrp->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->req_material_product->AdvancedSearch->SearchValue != "" ||
            $this->req_material_product->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->req_material_product->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->req_material_product->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->req_material_rid->AdvancedSearch->SearchValue != "" ||
            $this->req_material_rid->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->req_material_rid->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->req_material_rid->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // Cascade Update detail table 'material_required'
        $cascadeUpdate = false;
        $rscascade = [];
        if ($rsold && (isset($rs['po']) && $rsold['po'] != $rs['po'])) { // Update detail field 'po'
            $cascadeUpdate = true;
            $rscascade['po'] = $rs['po'];
        }
        if ($rsold && (isset($rs['req_material_rid']) && $rsold['req_material_rid'] != $rs['req_material_rid'])) { // Update detail field 'req_material_rid'
            $cascadeUpdate = true;
            $rscascade['req_material_rid'] = $rs['req_material_rid'];
        }
        if ($cascadeUpdate) {
            $rswrk = Container("material_required")->loadRs("`po` = " . QuotedValue($rsold['po'], DataType::NUMBER, 'DB') . " AND " . "`req_material_rid` = " . QuotedValue($rsold['req_material_rid'], DataType::NUMBER, 'DB'))->fetchAllAssociative();
            foreach ($rswrk as $rsdtlold) {
                $rskey = [];
                $fldname = 'id';
                $rskey[$fldname] = $rsdtlold[$fldname];
                $rsdtlnew = array_merge($rsdtlold, $rscascade);
                // Call Row_Updating event
                $success = Container("material_required")->rowUpdating($rsdtlold, $rsdtlnew);
                if ($success) {
                    $success = Container("material_required")->update($rscascade, $rskey, $rsdtlold);
                }
                if (!$success) {
                    return false;
                }
                // Call Row_Updated event
                Container("material_required")->rowUpdated($rsdtlold, $rsdtlnew);
            }
        }

        // Cascade Update detail table 'material_required_old'
        $cascadeUpdate = false;
        $rscascade = [];
        if ($rsold && (isset($rs['po']) && $rsold['po'] != $rs['po'])) { // Update detail field 'po'
            $cascadeUpdate = true;
            $rscascade['po'] = $rs['po'];
        }
        if ($rsold && (isset($rs['req_material_rid']) && $rsold['req_material_rid'] != $rs['req_material_rid'])) { // Update detail field 'req_material_rid'
            $cascadeUpdate = true;
            $rscascade['req_material_rid'] = $rs['req_material_rid'];
        }
        if ($cascadeUpdate) {
            $rswrk = Container("material_required_old")->loadRs("`po` = " . QuotedValue($rsold['po'], DataType::NUMBER, 'DB') . " AND " . "`req_material_rid` = " . QuotedValue($rsold['req_material_rid'], DataType::NUMBER, 'DB'))->fetchAllAssociative();
            foreach ($rswrk as $rsdtlold) {
                $rskey = [];
                $fldname = 'id';
                $rskey[$fldname] = $rsdtlold[$fldname];
                $rsdtlnew = array_merge($rsdtlold, $rscascade);
                // Call Row_Updating event
                $success = Container("material_required_old")->rowUpdating($rsdtlold, $rsdtlnew);
                if ($success) {
                    $success = Container("material_required_old")->update($rscascade, $rskey, $rsdtlold);
                }
                if (!$success) {
                    return false;
                }
                // Call Row_Updated event
                Container("material_required_old")->rowUpdated($rsdtlold, $rsdtlnew);
            }
        }

        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;

        // Cascade delete detail table 'material_required'
        $dtlrows = Container("material_required")->loadRs("`po` = " . QuotedValue($rs['po'], DataType::NUMBER, "DB") . " AND " . "`req_material_rid` = " . QuotedValue($rs['req_material_rid'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("material_required")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("material_required")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("material_required")->rowDeleted($dtlrow);
            }
        }

        // Cascade delete detail table 'material_required_old'
        $dtlrows = Container("material_required_old")->loadRs("`po` = " . QuotedValue($rs['po'], DataType::NUMBER, "DB") . " AND " . "`req_material_rid` = " . QuotedValue($rs['req_material_rid'], DataType::NUMBER, "DB"))->fetchAllAssociative();
        // Call Row Deleting event
        foreach ($dtlrows as $dtlrow) {
            $success = Container("material_required_old")->rowDeleting($dtlrow);
            if (!$success) {
                break;
            }
        }
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                $success = Container("material_required_old")->delete($dtlrow); // Delete
                if (!$success) {
                    break;
                }
            }
        }
        // Call Row Deleted event
        if ($success) {
            foreach ($dtlrows as $dtlrow) {
                Container("material_required_old")->rowDeleted($dtlrow);
            }
        }
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->week->DbValue = $row['week'];
        $this->po->DbValue = $row['po'];
        $this->buyer_id->DbValue = $row['buyer_id'];
        $this->req_material_sgrp->DbValue = $row['req_material_sgrp'];
        $this->req_material_product->DbValue = $row['req_material_product'];
        $this->req_material_rid->DbValue = $row['req_material_rid'];
        $this->req_material_packing->DbValue = $row['req_material_packing'];
        $this->req_material_qty->DbValue = $row['req_material_qty'];
        $this->stock->DbValue = $row['stock'];
        $this->unit->DbValue = $row['unit'];
        $this->company_id->DbValue = $row['company_id'];
        $this->url->DbValue = $row['url'];
        $this->req_material_grp->DbValue = $row['req_material_grp'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("requiredmaterialcompiledlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "requiredmaterialcompiledview" => $Language->phrase("View"),
            "requiredmaterialcompilededit" => $Language->phrase("Edit"),
            "requiredmaterialcompiledadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "requiredmaterialcompiledlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "RequiredMaterialCompiledView",
            Config("API_ADD_ACTION") => "RequiredMaterialCompiledAdd",
            Config("API_EDIT_ACTION") => "RequiredMaterialCompiledEdit",
            Config("API_DELETE_ACTION") => "RequiredMaterialCompiledDelete",
            Config("API_LIST_ACTION") => "RequiredMaterialCompiledList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "requiredmaterialcompiledlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("requiredmaterialcompiledview", $parm);
        } else {
            $url = $this->keyUrl("requiredmaterialcompiledview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "requiredmaterialcompiledadd?" . $parm;
        } else {
            $url = "requiredmaterialcompiledadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("requiredmaterialcompilededit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("requiredmaterialcompiledlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("requiredmaterialcompiledadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("requiredmaterialcompiledlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("requiredmaterialcompileddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->week->setDbValue($row['week']);
        $this->po->setDbValue($row['po']);
        $this->buyer_id->setDbValue($row['buyer_id']);
        $this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
        $this->req_material_product->setDbValue($row['req_material_product']);
        $this->req_material_rid->setDbValue($row['req_material_rid']);
        $this->req_material_packing->setDbValue($row['req_material_packing']);
        $this->req_material_qty->setDbValue($row['req_material_qty']);
        $this->stock->setDbValue($row['stock']);
        $this->unit->setDbValue($row['unit']);
        $this->company_id->setDbValue($row['company_id']);
        $this->url->setDbValue($row['url']);
        $this->req_material_grp->setDbValue($row['req_material_grp']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "RequiredMaterialCompiledList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // week

        // po

        // buyer_id

        // req_material_sgrp

        // req_material_product

        // req_material_rid

        // req_material_packing

        // req_material_qty

        // stock

        // unit

        // company_id

        // url
        $this->url->CellCssStyle = "white-space: nowrap;";

        // req_material_grp
        $this->req_material_grp->CellCssStyle = "white-space: nowrap;";

        // week
        $curVal = strval($this->week->CurrentValue);
        if ($curVal != "") {
            $this->week->ViewValue = $this->week->lookupCacheOption($curVal);
            if ($this->week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["wid"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["wid"]->searchDataType(), "");
                $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                    $this->week->ViewValue = $this->week->displayValue($arwrk);
                } else {
                    $this->week->ViewValue = $this->week->CurrentValue;
                }
            }
        } else {
            $this->week->ViewValue = null;
        }

        // po
        $this->po->ViewValue = $this->po->CurrentValue;

        // buyer_id
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
                }
            }
        } else {
            $this->buyer_id->ViewValue = null;
        }

        // req_material_sgrp
        if ($this->req_material_sgrp->VirtualValue != "") {
            $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->VirtualValue;
        } else {
            $curVal = strval($this->req_material_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
                if ($this->req_material_sgrp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_sgrp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_sgrp->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
                    } else {
                        $this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->req_material_sgrp->ViewValue = null;
            }
        }

        // req_material_product
        if ($this->req_material_product->VirtualValue != "") {
            $this->req_material_product->ViewValue = $this->req_material_product->VirtualValue;
        } else {
            $curVal = strval($this->req_material_product->CurrentValue);
            if ($curVal != "") {
                $this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
                if ($this->req_material_product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_product->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
                    } else {
                        $this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
                    }
                }
            } else {
                $this->req_material_product->ViewValue = null;
            }
        }

        // req_material_rid
        if ($this->req_material_rid->VirtualValue != "") {
            $this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
        } else {
            $curVal = strval($this->req_material_rid->CurrentValue);
            if ($curVal != "") {
                $this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
                if ($this->req_material_rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
                    } else {
                        $this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
                    }
                }
            } else {
                $this->req_material_rid->ViewValue = null;
            }
        }

        // req_material_packing
        $curVal = strval($this->req_material_packing->CurrentValue);
        if ($curVal != "") {
            $this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
            if ($this->req_material_packing->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->req_material_packing->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_packing->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->req_material_packing->getSelectFilter($this); // PHP
                $sqlWrk = $this->req_material_packing->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->req_material_packing->Lookup->renderViewRow($rswrk[0]);
                    $this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
                } else {
                    $this->req_material_packing->ViewValue = FormatNumber($this->req_material_packing->CurrentValue, $this->req_material_packing->formatPattern());
                }
            }
        } else {
            $this->req_material_packing->ViewValue = null;
        }

        // req_material_qty
        $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());

        // stock
        $this->stock->ViewValue = $this->stock->CurrentValue;
        $this->stock->ViewValue = FormatNumber($this->stock->ViewValue, $this->stock->formatPattern());

        // unit
        $curVal = strval($this->unit->CurrentValue);
        if ($curVal != "") {
            $this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
            if ($this->unit->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                    $this->unit->ViewValue = $this->unit->displayValue($arwrk);
                } else {
                    $this->unit->ViewValue = $this->unit->CurrentValue;
                }
            }
        } else {
            $this->unit->ViewValue = null;
        }

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // req_material_grp
        $this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
        $this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, $this->req_material_grp->formatPattern());

        // week
        $this->week->HrefValue = "";
        $this->week->TooltipValue = "";

        // po
        if (!EmptyValue($this->po->CurrentValue)) {
            $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
            $this->po->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
            }
        } else {
            $this->po->HrefValue = "";
        }
        $this->po->TooltipValue = "";

        // buyer_id
        if (!EmptyValue($this->buyer_id->CurrentValue)) {
            $this->buyer_id->HrefValue = $this->buyer_id->getLinkPrefix() . $this->buyer_id->CurrentValue; // Add prefix/suffix
            $this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
            }
        } else {
            $this->buyer_id->HrefValue = "";
        }
        $this->buyer_id->TooltipValue = "";

        // req_material_sgrp
        if (!EmptyValue($this->req_material_sgrp->CurrentValue)) {
            $this->req_material_sgrp->HrefValue = $this->req_material_sgrp->getLinkPrefix() . $this->req_material_sgrp->CurrentValue; // Add prefix/suffix
            $this->req_material_sgrp->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->req_material_sgrp->HrefValue = FullUrl($this->req_material_sgrp->HrefValue, "href");
            }
        } else {
            $this->req_material_sgrp->HrefValue = "";
        }
        $this->req_material_sgrp->TooltipValue = "";

        // req_material_product
        if (!EmptyValue($this->req_material_product->CurrentValue)) {
            $this->req_material_product->HrefValue = $this->req_material_product->getLinkPrefix() . $this->req_material_product->CurrentValue; // Add prefix/suffix
            $this->req_material_product->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->req_material_product->HrefValue = FullUrl($this->req_material_product->HrefValue, "href");
            }
        } else {
            $this->req_material_product->HrefValue = "";
        }
        $this->req_material_product->TooltipValue = "";

        // req_material_rid
        if (!EmptyValue($this->url->CurrentValue)) {
            $this->req_material_rid->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
            $this->req_material_rid->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
            }
        } else {
            $this->req_material_rid->HrefValue = "";
        }
        $this->req_material_rid->TooltipValue = "";

        // req_material_packing
        $this->req_material_packing->HrefValue = "";
        $this->req_material_packing->TooltipValue = "";

        // req_material_qty
        $this->req_material_qty->HrefValue = "";
        $this->req_material_qty->TooltipValue = "";

        // stock
        $this->stock->HrefValue = "";
        $this->stock->TooltipValue = "";

        // unit
        if (!EmptyValue($this->unit->CurrentValue)) {
            $this->unit->HrefValue = $this->unit->getLinkPrefix() . $this->unit->CurrentValue; // Add prefix/suffix
            $this->unit->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
            }
        } else {
            $this->unit->HrefValue = "";
        }
        $this->unit->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // req_material_grp
        $this->req_material_grp->HrefValue = "";
        $this->req_material_grp->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // week
        $this->week->setupEditAttributes();
        $this->week->EditCustomAttributes = $this->week->getEditCustomAttributes(); // PHP
        $curVal = strval($this->week->CurrentValue);
        if ($curVal != "") {
            $this->week->EditValue = $this->week->lookupCacheOption($curVal);
            if ($this->week->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->week->Lookup->getTable()->Fields["wid"]->searchExpression(), "=", $curVal, $this->week->Lookup->getTable()->Fields["wid"]->searchDataType(), "");
                $sqlWrk = $this->week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->week->Lookup->renderViewRow($rswrk[0]);
                    $this->week->EditValue = $this->week->displayValue($arwrk);
                } else {
                    $this->week->EditValue = $this->week->CurrentValue;
                }
            }
        } else {
            $this->week->EditValue = null;
        }

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;

        // buyer_id
        $this->buyer_id->setupEditAttributes();
        $curVal = strval($this->buyer_id->CurrentValue);
        if ($curVal != "") {
            $this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
            if ($this->buyer_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyer_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
                } else {
                    $this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
                }
            }
        } else {
            $this->buyer_id->EditValue = null;
        }

        // req_material_sgrp
        $this->req_material_sgrp->setupEditAttributes();
        if ($this->req_material_sgrp->VirtualValue != "") {
            $this->req_material_sgrp->EditValue = $this->req_material_sgrp->VirtualValue;
        } else {
            $curVal = strval($this->req_material_sgrp->CurrentValue);
            if ($curVal != "") {
                $this->req_material_sgrp->EditValue = $this->req_material_sgrp->lookupCacheOption($curVal);
                if ($this->req_material_sgrp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_sgrp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_sgrp->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_sgrp->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_sgrp->EditValue = $this->req_material_sgrp->displayValue($arwrk);
                    } else {
                        $this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
                    }
                }
            } else {
                $this->req_material_sgrp->EditValue = null;
            }
        }

        // req_material_product
        $this->req_material_product->setupEditAttributes();
        if ($this->req_material_product->VirtualValue != "") {
            $this->req_material_product->EditValue = $this->req_material_product->VirtualValue;
        } else {
            $curVal = strval($this->req_material_product->CurrentValue);
            if ($curVal != "") {
                $this->req_material_product->EditValue = $this->req_material_product->lookupCacheOption($curVal);
                if ($this->req_material_product->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_product->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_product->EditValue = $this->req_material_product->displayValue($arwrk);
                    } else {
                        $this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
                    }
                }
            } else {
                $this->req_material_product->EditValue = null;
            }
        }

        // req_material_rid
        $this->req_material_rid->setupEditAttributes();
        if ($this->req_material_rid->VirtualValue != "") {
            $this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
        } else {
            $curVal = strval($this->req_material_rid->CurrentValue);
            if ($curVal != "") {
                $this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
                if ($this->req_material_rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->req_material_rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->req_material_rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->req_material_rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->req_material_rid->Lookup->renderViewRow($rswrk[0]);
                        $this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
                    } else {
                        $this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
                    }
                }
            } else {
                $this->req_material_rid->EditValue = null;
            }
        }

        // req_material_packing
        $this->req_material_packing->setupEditAttributes();
        $this->req_material_packing->PlaceHolder = RemoveHtml($this->req_material_packing->caption());

        // req_material_qty
        $this->req_material_qty->setupEditAttributes();
        $this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
        $this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, $this->req_material_qty->formatPattern());

        // stock
        $this->stock->setupEditAttributes();
        $this->stock->EditValue = $this->stock->CurrentValue;
        $this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
        if (strval($this->stock->EditValue) != "" && is_numeric($this->stock->EditValue)) {
            $this->stock->EditValue = FormatNumber($this->stock->EditValue, null);
        }

        // unit
        $this->unit->setupEditAttributes();
        $curVal = strval($this->unit->CurrentValue);
        if ($curVal != "") {
            $this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
            if ($this->unit->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->unit->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->unit->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->unit->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->unit->Lookup->renderViewRow($rswrk[0]);
                    $this->unit->EditValue = $this->unit->displayValue($arwrk);
                } else {
                    $this->unit->EditValue = $this->unit->CurrentValue;
                }
            }
        } else {
            $this->unit->EditValue = null;
        }

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // url
        $this->url->setupEditAttributes();
        if (!$this->url->Raw) {
            $this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
        }
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // req_material_grp
        $this->req_material_grp->setupEditAttributes();
        $this->req_material_grp->EditValue = $this->req_material_grp->CurrentValue;
        $this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());
        if (strval($this->req_material_grp->EditValue) != "" && is_numeric($this->req_material_grp->EditValue)) {
            $this->req_material_grp->EditValue = FormatNumber($this->req_material_grp->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->req_material_qty->CurrentValue)) {
                $this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
            $this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
            $this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, $this->req_material_qty->formatPattern());
            $this->req_material_qty->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->week);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->req_material_sgrp);
                    $doc->exportCaption($this->req_material_product);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->company_id);
                } else {
                    $doc->exportCaption($this->week);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_id);
                    $doc->exportCaption($this->req_material_sgrp);
                    $doc->exportCaption($this->req_material_product);
                    $doc->exportCaption($this->req_material_rid);
                    $doc->exportCaption($this->req_material_packing);
                    $doc->exportCaption($this->req_material_qty);
                    $doc->exportCaption($this->stock);
                    $doc->exportCaption($this->unit);
                    $doc->exportCaption($this->company_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->week);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->req_material_sgrp);
                        $doc->exportField($this->req_material_product);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->company_id);
                    } else {
                        $doc->exportField($this->week);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_id);
                        $doc->exportField($this->req_material_sgrp);
                        $doc->exportField($this->req_material_product);
                        $doc->exportField($this->req_material_rid);
                        $doc->exportField($this->req_material_packing);
                        $doc->exportField($this->req_material_qty);
                        $doc->exportField($this->stock);
                        $doc->exportField($this->unit);
                        $doc->exportField($this->company_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->week, '');
                $doc->exportAggregate($this->po, '');
                $doc->exportAggregate($this->buyer_id, '');
                $doc->exportAggregate($this->req_material_sgrp, '');
                $doc->exportAggregate($this->req_material_product, '');
                $doc->exportAggregate($this->req_material_rid, '');
                $doc->exportAggregate($this->req_material_packing, '');
                $doc->exportAggregate($this->req_material_qty, 'TOTAL');
                $doc->exportAggregate($this->stock, '');
                $doc->exportAggregate($this->unit, '');
                $doc->exportAggregate($this->company_id, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
