<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RequestArchiveSearch extends RequestArchive
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RequestArchiveSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "requestarchivesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->r_from->setVisibility();
        $this->r_to->setVisibility();
        $this->reference->setVisibility();
        $this->_message->setVisibility();
        $this->uploads->setVisibility();
        $this->lead_info->setVisibility();
        $this->status->setVisibility();
        $this->Subject->setVisibility();
        $this->datetime->setVisibility();
        $this->QueryGenerator->setVisibility();
        $this->forward_url->setVisibility();
        $this->lead_by->setVisibility();
        $this->lead_status->setVisibility();
        $this->lead_type->setVisibility();
        $this->type->setVisibility();
        $this->alert->Visible = false;
        $this->beep->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'request_archive';
        $this->TableName = 'request_archive';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (request_archive)
        if (!isset($GLOBALS["request_archive"]) || $GLOBALS["request_archive"]::class == PROJECT_NAMESPACE . "request_archive") {
            $GLOBALS["request_archive"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'request_archive');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "requestarchiveview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->r_from->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->r_to->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->reference->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->_message->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->uploads->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->QueryGenerator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->lead_status->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->lead_type->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->alert->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->lead_status);
        $this->setupLookupOptions($this->lead_type);
        $this->setupLookupOptions($this->type);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "requestarchivelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->r_from); // r_from
        $this->buildSearchUrl($srchUrl, $this->r_to); // r_to
        $this->buildSearchUrl($srchUrl, $this->reference); // reference
        $this->buildSearchUrl($srchUrl, $this->_message); // message
        $this->buildSearchUrl($srchUrl, $this->uploads); // uploads
        $this->buildSearchUrl($srchUrl, $this->lead_info); // lead_info
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->Subject); // Subject
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->QueryGenerator); // QueryGenerator
        $this->buildSearchUrl($srchUrl, $this->forward_url); // forward_url
        $this->buildSearchUrl($srchUrl, $this->lead_by); // lead_by
        $this->buildSearchUrl($srchUrl, $this->lead_status); // lead_status
        $this->buildSearchUrl($srchUrl, $this->lead_type); // lead_type
        $this->buildSearchUrl($srchUrl, $this->type); // type
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_from
        if ($this->r_from->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // r_to
        if ($this->r_to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reference
        if ($this->reference->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // message
        if ($this->_message->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // uploads
        if ($this->uploads->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lead_info
        if ($this->lead_info->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Subject
        if ($this->Subject->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // QueryGenerator
        if ($this->QueryGenerator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // forward_url
        if ($this->forward_url->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lead_by
        if ($this->lead_by->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lead_status
        if ($this->lead_status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lead_type
        if ($this->lead_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // type
        if ($this->type->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // r_from
        $this->r_from->RowCssClass = "row";

        // r_to
        $this->r_to->RowCssClass = "row";

        // reference
        $this->reference->RowCssClass = "row";

        // message
        $this->_message->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // lead_info
        $this->lead_info->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // Subject
        $this->Subject->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // QueryGenerator
        $this->QueryGenerator->RowCssClass = "row";

        // forward_url
        $this->forward_url->RowCssClass = "row";

        // lead_by
        $this->lead_by->RowCssClass = "row";

        // lead_status
        $this->lead_status->RowCssClass = "row";

        // lead_type
        $this->lead_type->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // alert
        $this->alert->RowCssClass = "row";

        // beep
        $this->beep->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // r_from
            $this->r_from->ViewValue = $this->r_from->CurrentValue;

            // r_to
            $this->r_to->ViewValue = $this->r_to->CurrentValue;

            // reference
            $this->reference->ViewValue = $this->reference->CurrentValue;
            $this->reference->ViewValue = FormatNumber($this->reference->ViewValue, $this->reference->formatPattern());

            // message
            $this->_message->ViewValue = $this->_message->CurrentValue;

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // lead_info
            $this->lead_info->ViewValue = $this->lead_info->CurrentValue;

            // status
            $this->status->ViewValue = $this->status->CurrentValue;
            $this->status->ViewValue = FormatNumber($this->status->ViewValue, $this->status->formatPattern());

            // Subject
            $this->Subject->ViewValue = $this->Subject->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // QueryGenerator
            $this->QueryGenerator->ViewValue = $this->QueryGenerator->CurrentValue;

            // forward_url
            $this->forward_url->ViewValue = $this->forward_url->CurrentValue;

            // lead_by
            $this->lead_by->ViewValue = $this->lead_by->CurrentValue;

            // lead_status
            $curVal = strval($this->lead_status->CurrentValue);
            if ($curVal != "") {
                $this->lead_status->ViewValue = $this->lead_status->lookupCacheOption($curVal);
                if ($this->lead_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lead_status->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $curVal, $this->lead_status->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                    $lookupFilter = $this->lead_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lead_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lead_status->Lookup->renderViewRow($rswrk[0]);
                        $this->lead_status->ViewValue = $this->lead_status->displayValue($arwrk);
                    } else {
                        $this->lead_status->ViewValue = FormatNumber($this->lead_status->CurrentValue, $this->lead_status->formatPattern());
                    }
                }
            } else {
                $this->lead_status->ViewValue = null;
            }

            // lead_type
            $curVal = strval($this->lead_type->CurrentValue);
            if ($curVal != "") {
                $this->lead_type->ViewValue = $this->lead_type->lookupCacheOption($curVal);
                if ($this->lead_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lead_type->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $curVal, $this->lead_type->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                    $lookupFilter = $this->lead_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lead_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lead_type->Lookup->renderViewRow($rswrk[0]);
                        $this->lead_type->ViewValue = $this->lead_type->displayValue($arwrk);
                    } else {
                        $this->lead_type->ViewValue = FormatNumber($this->lead_type->CurrentValue, $this->lead_type->formatPattern());
                    }
                }
            } else {
                $this->lead_type->ViewValue = null;
            }

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // r_from
            $this->r_from->HrefValue = "";
            $this->r_from->TooltipValue = "";

            // r_to
            $this->r_to->HrefValue = "";
            $this->r_to->TooltipValue = "";

            // reference
            $this->reference->HrefValue = "";
            $this->reference->TooltipValue = "";

            // message
            $this->_message->HrefValue = "";
            $this->_message->TooltipValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
            $this->uploads->TooltipValue = "";
            if ($this->uploads->UseColorbox) {
                if (EmptyValue($this->uploads->TooltipValue)) {
                    $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->uploads->LinkAttrs["data-rel"] = "request_archive_x_uploads";
                $this->uploads->LinkAttrs->appendClass("ew-lightbox");
            }

            // lead_info
            $this->lead_info->HrefValue = "";
            $this->lead_info->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // Subject
            $this->Subject->HrefValue = "";
            $this->Subject->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // QueryGenerator
            $this->QueryGenerator->HrefValue = "";
            $this->QueryGenerator->TooltipValue = "";

            // forward_url
            $this->forward_url->HrefValue = "";
            $this->forward_url->TooltipValue = "";

            // lead_by
            $this->lead_by->HrefValue = "";
            $this->lead_by->TooltipValue = "";

            // lead_status
            $this->lead_status->HrefValue = "";
            $this->lead_status->TooltipValue = "";

            // lead_type
            $this->lead_type->HrefValue = "";
            $this->lead_type->TooltipValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // r_from
            $this->r_from->setupEditAttributes();
            $this->r_from->EditValue = HtmlEncode($this->r_from->AdvancedSearch->SearchValue);
            $this->r_from->PlaceHolder = RemoveHtml($this->r_from->caption());

            // r_to
            $this->r_to->setupEditAttributes();
            $this->r_to->EditValue = HtmlEncode($this->r_to->AdvancedSearch->SearchValue);
            $this->r_to->PlaceHolder = RemoveHtml($this->r_to->caption());

            // reference
            $this->reference->setupEditAttributes();
            $this->reference->EditValue = $this->reference->AdvancedSearch->SearchValue;
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());

            // message
            $this->_message->setupEditAttributes();
            $this->_message->EditValue = HtmlEncode($this->_message->AdvancedSearch->SearchValue);
            $this->_message->PlaceHolder = RemoveHtml($this->_message->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            if (!$this->uploads->Raw) {
                $this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
            }
            $this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
            $this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

            // lead_info
            $this->lead_info->setupEditAttributes();
            if (!$this->lead_info->Raw) {
                $this->lead_info->AdvancedSearch->SearchValue = HtmlDecode($this->lead_info->AdvancedSearch->SearchValue);
            }
            $this->lead_info->EditValue = HtmlEncode($this->lead_info->AdvancedSearch->SearchValue);
            $this->lead_info->PlaceHolder = RemoveHtml($this->lead_info->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->AdvancedSearch->SearchValue;
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // Subject
            $this->Subject->setupEditAttributes();
            if (!$this->Subject->Raw) {
                $this->Subject->AdvancedSearch->SearchValue = HtmlDecode($this->Subject->AdvancedSearch->SearchValue);
            }
            $this->Subject->EditValue = HtmlEncode($this->Subject->AdvancedSearch->SearchValue);
            $this->Subject->PlaceHolder = RemoveHtml($this->Subject->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // QueryGenerator
            $this->QueryGenerator->setupEditAttributes();
            if (!$this->QueryGenerator->Raw) {
                $this->QueryGenerator->AdvancedSearch->SearchValue = HtmlDecode($this->QueryGenerator->AdvancedSearch->SearchValue);
            }
            $this->QueryGenerator->EditValue = HtmlEncode($this->QueryGenerator->AdvancedSearch->SearchValue);
            $this->QueryGenerator->PlaceHolder = RemoveHtml($this->QueryGenerator->caption());

            // forward_url
            $this->forward_url->setupEditAttributes();
            $this->forward_url->EditValue = HtmlEncode($this->forward_url->AdvancedSearch->SearchValue);
            $this->forward_url->PlaceHolder = RemoveHtml($this->forward_url->caption());

            // lead_by
            $this->lead_by->setupEditAttributes();
            if (!$this->lead_by->Raw) {
                $this->lead_by->AdvancedSearch->SearchValue = HtmlDecode($this->lead_by->AdvancedSearch->SearchValue);
            }
            $this->lead_by->EditValue = HtmlEncode($this->lead_by->AdvancedSearch->SearchValue);
            $this->lead_by->PlaceHolder = RemoveHtml($this->lead_by->caption());

            // lead_status
            $curVal = trim(strval($this->lead_status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->lead_status->AdvancedSearch->ViewValue = $this->lead_status->lookupCacheOption($curVal);
            } else {
                $this->lead_status->AdvancedSearch->ViewValue = $this->lead_status->Lookup !== null && is_array($this->lead_status->lookupOptions()) && count($this->lead_status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->lead_status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->lead_status->EditValue = array_values($this->lead_status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->lead_status->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $this->lead_status->AdvancedSearch->SearchValue, $this->lead_status->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                }
                $lookupFilter = $this->lead_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->lead_status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->lead_status->EditValue = $arwrk;
            }
            $this->lead_status->PlaceHolder = RemoveHtml($this->lead_status->caption());

            // lead_type
            $curVal = trim(strval($this->lead_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->lead_type->AdvancedSearch->ViewValue = $this->lead_type->lookupCacheOption($curVal);
            } else {
                $this->lead_type->AdvancedSearch->ViewValue = $this->lead_type->Lookup !== null && is_array($this->lead_type->lookupOptions()) && count($this->lead_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->lead_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->lead_type->EditValue = array_values($this->lead_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->lead_type->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $this->lead_type->AdvancedSearch->SearchValue, $this->lead_type->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                }
                $lookupFilter = $this->lead_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->lead_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->lead_type->EditValue = $arwrk;
            }
            $this->lead_type->PlaceHolder = RemoveHtml($this->lead_type->caption());

            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->options(true);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->reference->AdvancedSearch->SearchValue)) {
            $this->reference->addErrorMessage($this->reference->getErrorMessage(false));
        }
        if (!CheckInteger($this->status->AdvancedSearch->SearchValue)) {
            $this->status->addErrorMessage($this->status->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->r_from->AdvancedSearch->load();
        $this->r_to->AdvancedSearch->load();
        $this->reference->AdvancedSearch->load();
        $this->_message->AdvancedSearch->load();
        $this->uploads->AdvancedSearch->load();
        $this->lead_info->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->Subject->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->QueryGenerator->AdvancedSearch->load();
        $this->forward_url->AdvancedSearch->load();
        $this->lead_by->AdvancedSearch->load();
        $this->lead_status->AdvancedSearch->load();
        $this->lead_type->AdvancedSearch->load();
        $this->type->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("requestarchivelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_lead_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lead_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_type":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
