<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for request_archive
 */
class RequestArchive extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $r_from;
    public $r_to;
    public $reference;
    public $_message;
    public $uploads;
    public $lead_info;
    public $status;
    public $Subject;
    public $datetime;
    public $QueryGenerator;
    public $forward_url;
    public $lead_by;
    public $lead_status;
    public $lead_type;
    public $type;
    public $alert;
    public $beep;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "request_archive";
        $this->TableName = 'request_archive';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "request_archive";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // r_from
        $this->r_from = new DbField(
            $this, // Table
            'x_r_from', // Variable name
            'r_from', // Name
            '`r_from`', // Expression
            '`r_from`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_from`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->r_from->InputTextType = "text";
        $this->r_from->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_from'] = &$this->r_from;

        // r_to
        $this->r_to = new DbField(
            $this, // Table
            'x_r_to', // Variable name
            'r_to', // Name
            '`r_to`', // Expression
            '`r_to`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`r_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->r_to->InputTextType = "text";
        $this->r_to->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['r_to'] = &$this->r_to;

        // reference
        $this->reference = new DbField(
            $this, // Table
            'x_reference', // Variable name
            'reference', // Name
            '`reference`', // Expression
            '`reference`', // Basic search expression
            131, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reference`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->reference->addMethod("getDefault", fn() => 0);
        $this->reference->InputTextType = "text";
        $this->reference->Raw = true;
        $this->reference->Nullable = false; // NOT NULL field
        $this->reference->Required = true; // Required field
        $this->reference->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->reference->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['reference'] = &$this->reference;

        // message
        $this->_message = new DbField(
            $this, // Table
            'x__message', // Variable name
            'message', // Name
            '`message`', // Expression
            '`message`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`message`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->_message->InputTextType = "text";
        $this->_message->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['message'] = &$this->_message;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->addMethod("getUploadPath", fn() => ".p_uploads/request/");
        $this->uploads->InputTextType = "text";
        $this->uploads->ImageResize = true;
        $this->uploads->UploadMultiple = true;
        $this->uploads->Upload->UploadMultiple = true;
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // lead_info
        $this->lead_info = new DbField(
            $this, // Table
            'x_lead_info', // Variable name
            'lead_info', // Name
            'concat_WS(\'<br>\', concat(\'Lead Type : \', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_type`)), concat(\'Lead Status : \', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_status`)), concat(\'Lead By : \', `lead_by`))', // Expression
            'concat_WS(\'<br>\', concat(\'Lead Type : \', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_type`)), concat(\'Lead Status : \', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_status`)), concat(\'Lead By : \', `lead_by`))', // Basic search expression
            200, // Type
            236, // Size
            -1, // Date/Time format
            false, // Is upload field
            'concat_WS(\'<br>\', concat(\'Lead Type : \', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_type`)), concat(\'Lead Status : \', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_status`)), concat(\'Lead By : \', `lead_by`))', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lead_info->InputTextType = "text";
        $this->lead_info->IsCustom = true; // Custom field
        $this->lead_info->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lead_info'] = &$this->lead_info;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // Subject
        $this->Subject = new DbField(
            $this, // Table
            'x_Subject', // Variable name
            'Subject', // Name
            '`Subject`', // Expression
            '`Subject`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Subject`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Subject->InputTextType = "text";
        $this->Subject->Nullable = false; // NOT NULL field
        $this->Subject->Required = true; // Required field
        $this->Subject->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Subject'] = &$this->Subject;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->Required = true; // Required field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // QueryGenerator
        $this->QueryGenerator = new DbField(
            $this, // Table
            'x_QueryGenerator', // Variable name
            'QueryGenerator', // Name
            '`QueryGenerator`', // Expression
            '`QueryGenerator`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`QueryGenerator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->QueryGenerator->InputTextType = "text";
        $this->QueryGenerator->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['QueryGenerator'] = &$this->QueryGenerator;

        // forward_url
        $this->forward_url = new DbField(
            $this, // Table
            'x_forward_url', // Variable name
            'forward_url', // Name
            'Concat(\'request2add?ref=\', `reference`,  \'&sub=\', `Subject`,\'&to=\',`r_from`, \'&ltype=\',`lead_type`, \'&sta=\',`lead_status`,\'&leadby=\',`lead_by`,\'&type=\',`type`)', // Expression
            'Concat(\'request2add?ref=\', `reference`,  \'&sub=\', `Subject`,\'&to=\',`r_from`, \'&ltype=\',`lead_type`, \'&sta=\',`lead_status`,\'&leadby=\',`lead_by`,\'&type=\',`type`)', // Basic search expression
            201, // Type
            16777216, // Size
            -1, // Date/Time format
            false, // Is upload field
            'Concat(\'request2add?ref=\', `reference`,  \'&sub=\', `Subject`,\'&to=\',`r_from`, \'&ltype=\',`lead_type`, \'&sta=\',`lead_status`,\'&leadby=\',`lead_by`,\'&type=\',`type`)', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->forward_url->InputTextType = "text";
        $this->forward_url->IsCustom = true; // Custom field
        $this->forward_url->Sortable = false; // Allow sort
        $this->forward_url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['forward_url'] = &$this->forward_url;

        // lead_by
        $this->lead_by = new DbField(
            $this, // Table
            'x_lead_by', // Variable name
            'lead_by', // Name
            '`lead_by`', // Expression
            '`lead_by`', // Basic search expression
            200, // Type
            144, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lead_by`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lead_by->InputTextType = "text";
        $this->lead_by->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['lead_by'] = &$this->lead_by;

        // lead_status
        $this->lead_status = new DbField(
            $this, // Table
            'x_lead_status', // Variable name
            'lead_status', // Name
            '`lead_status`', // Expression
            '`lead_status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lead_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->lead_status->addMethod("getSelectFilter", fn() => "`grp`=12");
        $this->lead_status->InputTextType = "text";
        $this->lead_status->Raw = true;
        $this->lead_status->Lookup = new Lookup($this->lead_status, 'request_type', false, 'item', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->lead_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->lead_status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['lead_status'] = &$this->lead_status;

        // lead_type
        $this->lead_type = new DbField(
            $this, // Table
            'x_lead_type', // Variable name
            'lead_type', // Name
            '`lead_type`', // Expression
            '`lead_type`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lead_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->lead_type->addMethod("getSelectFilter", fn() => "`grp`=11");
        $this->lead_type->InputTextType = "text";
        $this->lead_type->Raw = true;
        $this->lead_type->Lookup = new Lookup($this->lead_type, 'request_type', false, 'item', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->lead_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->lead_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['lead_type'] = &$this->lead_type;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->type->addMethod("getDefault", fn() => 0);
        $this->type->InputTextType = "text";
        $this->type->Raw = true;
        $this->type->Nullable = false; // NOT NULL field
        $this->type->setSelectMultiple(false); // Select one
        $this->type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->type->Lookup = new Lookup($this->type, 'request_archive', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->type->OptionCount = 4;
        $this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['type'] = &$this->type;

        // alert
        $this->alert = new DbField(
            $this, // Table
            'x_alert', // Variable name
            'alert', // Name
            '`alert`', // Expression
            CastDateFieldForLike("`alert`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`alert`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->alert->InputTextType = "text";
        $this->alert->Raw = true;
        $this->alert->Sortable = false; // Allow sort
        $this->alert->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->alert->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['alert'] = &$this->alert;

        // beep
        $this->beep = new DbField(
            $this, // Table
            'x_beep', // Variable name
            'beep', // Name
            '`beep`', // Expression
            '`beep`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`beep`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->beep->InputTextType = "text";
        $this->beep->Sortable = false; // Allow sort
        $this->beep->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->beep->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['beep'] = &$this->beep;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "request_archive";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, concat_WS('<br>', concat('Lead Type : ', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_type`)), concat('Lead Status : ', (SELECT `item` from `request_type` where `request_type`.`id` = `lead_status`)), concat('Lead By : ', `lead_by`)) AS `lead_info`, Concat('request2add?ref=', `reference`,  '&sub=', `Subject`,'&to=',`r_from`, '&ltype=',`lead_type`, '&sta=',`lead_status`,'&leadby=',`lead_by`,'&type=',`type`) AS `forward_url`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (CurrentUserID() == -1) ? "`QueryGenerator` = 1 || FIND_IN_SET(1, `r_to`) || `r_from` = 1" : "`QueryGenerator` = " . CurrentUserID();
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->r_from->DbValue = $row['r_from'];
        $this->r_to->DbValue = $row['r_to'];
        $this->reference->DbValue = $row['reference'];
        $this->_message->DbValue = $row['message'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->lead_info->DbValue = $row['lead_info'];
        $this->status->DbValue = $row['status'];
        $this->Subject->DbValue = $row['Subject'];
        $this->datetime->DbValue = $row['datetime'];
        $this->QueryGenerator->DbValue = $row['QueryGenerator'];
        $this->forward_url->DbValue = $row['forward_url'];
        $this->lead_by->DbValue = $row['lead_by'];
        $this->lead_status->DbValue = $row['lead_status'];
        $this->lead_type->DbValue = $row['lead_type'];
        $this->type->DbValue = $row['type'];
        $this->alert->DbValue = $row['alert'];
        $this->beep->DbValue = $row['beep'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['uploads']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['uploads']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("requestarchivelist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "requestarchiveview" => $Language->phrase("View"),
            "requestarchiveedit" => $Language->phrase("Edit"),
            "requestarchiveadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "requestarchivelist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "RequestArchiveView",
            Config("API_ADD_ACTION") => "RequestArchiveAdd",
            Config("API_EDIT_ACTION") => "RequestArchiveEdit",
            Config("API_DELETE_ACTION") => "RequestArchiveDelete",
            Config("API_LIST_ACTION") => "RequestArchiveList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "requestarchivelist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("requestarchiveview", $parm);
        } else {
            $url = $this->keyUrl("requestarchiveview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "requestarchiveadd?" . $parm;
        } else {
            $url = "requestarchiveadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("requestarchiveedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("requestarchivelist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("requestarchiveadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("requestarchivelist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("requestarchivedelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->r_from->setDbValue($row['r_from']);
        $this->r_to->setDbValue($row['r_to']);
        $this->reference->setDbValue($row['reference']);
        $this->_message->setDbValue($row['message']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->lead_info->setDbValue($row['lead_info']);
        $this->status->setDbValue($row['status']);
        $this->Subject->setDbValue($row['Subject']);
        $this->datetime->setDbValue($row['datetime']);
        $this->QueryGenerator->setDbValue($row['QueryGenerator']);
        $this->forward_url->setDbValue($row['forward_url']);
        $this->lead_by->setDbValue($row['lead_by']);
        $this->lead_status->setDbValue($row['lead_status']);
        $this->lead_type->setDbValue($row['lead_type']);
        $this->type->setDbValue($row['type']);
        $this->alert->setDbValue($row['alert']);
        $this->beep->setDbValue($row['beep']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "RequestArchiveList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // r_from

        // r_to

        // reference

        // message

        // uploads

        // lead_info

        // status

        // Subject

        // datetime

        // QueryGenerator

        // forward_url
        $this->forward_url->CellCssStyle = "white-space: nowrap;";

        // lead_by

        // lead_status

        // lead_type

        // type

        // alert
        $this->alert->CellCssStyle = "white-space: nowrap;";

        // beep
        $this->beep->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // r_from
        $this->r_from->ViewValue = $this->r_from->CurrentValue;

        // r_to
        $this->r_to->ViewValue = $this->r_to->CurrentValue;

        // reference
        $this->reference->ViewValue = $this->reference->CurrentValue;
        $this->reference->ViewValue = FormatNumber($this->reference->ViewValue, $this->reference->formatPattern());

        // message
        $this->_message->ViewValue = $this->_message->CurrentValue;

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }

        // lead_info
        $this->lead_info->ViewValue = $this->lead_info->CurrentValue;

        // status
        $this->status->ViewValue = $this->status->CurrentValue;
        $this->status->ViewValue = FormatNumber($this->status->ViewValue, $this->status->formatPattern());

        // Subject
        $this->Subject->ViewValue = $this->Subject->CurrentValue;

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // QueryGenerator
        $this->QueryGenerator->ViewValue = $this->QueryGenerator->CurrentValue;

        // forward_url
        $this->forward_url->ViewValue = $this->forward_url->CurrentValue;

        // lead_by
        $this->lead_by->ViewValue = $this->lead_by->CurrentValue;

        // lead_status
        $curVal = strval($this->lead_status->CurrentValue);
        if ($curVal != "") {
            $this->lead_status->ViewValue = $this->lead_status->lookupCacheOption($curVal);
            if ($this->lead_status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->lead_status->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $curVal, $this->lead_status->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                $lookupFilter = $this->lead_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->lead_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->lead_status->Lookup->renderViewRow($rswrk[0]);
                    $this->lead_status->ViewValue = $this->lead_status->displayValue($arwrk);
                } else {
                    $this->lead_status->ViewValue = FormatNumber($this->lead_status->CurrentValue, $this->lead_status->formatPattern());
                }
            }
        } else {
            $this->lead_status->ViewValue = null;
        }

        // lead_type
        $curVal = strval($this->lead_type->CurrentValue);
        if ($curVal != "") {
            $this->lead_type->ViewValue = $this->lead_type->lookupCacheOption($curVal);
            if ($this->lead_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->lead_type->Lookup->getTable()->Fields["item"]->searchExpression(), "=", $curVal, $this->lead_type->Lookup->getTable()->Fields["item"]->searchDataType(), "");
                $lookupFilter = $this->lead_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->lead_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->lead_type->Lookup->renderViewRow($rswrk[0]);
                    $this->lead_type->ViewValue = $this->lead_type->displayValue($arwrk);
                } else {
                    $this->lead_type->ViewValue = FormatNumber($this->lead_type->CurrentValue, $this->lead_type->formatPattern());
                }
            }
        } else {
            $this->lead_type->ViewValue = null;
        }

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // alert
        $this->alert->ViewValue = $this->alert->CurrentValue;
        $this->alert->ViewValue = FormatDateTime($this->alert->ViewValue, $this->alert->formatPattern());

        // beep
        $this->beep->ViewValue = $this->beep->CurrentValue;

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // r_from
        $this->r_from->HrefValue = "";
        $this->r_from->TooltipValue = "";

        // r_to
        $this->r_to->HrefValue = "";
        $this->r_to->TooltipValue = "";

        // reference
        $this->reference->HrefValue = "";
        $this->reference->TooltipValue = "";

        // message
        $this->_message->HrefValue = "";
        $this->_message->TooltipValue = "";

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->HrefValue = "%u"; // Add prefix/suffix
            $this->uploads->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
            }
        } else {
            $this->uploads->HrefValue = "";
        }
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";
        if ($this->uploads->UseColorbox) {
            if (EmptyValue($this->uploads->TooltipValue)) {
                $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->uploads->LinkAttrs["data-rel"] = "request_archive_x_uploads";
            $this->uploads->LinkAttrs->appendClass("ew-lightbox");
        }

        // lead_info
        $this->lead_info->HrefValue = "";
        $this->lead_info->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // Subject
        $this->Subject->HrefValue = "";
        $this->Subject->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // QueryGenerator
        $this->QueryGenerator->HrefValue = "";
        $this->QueryGenerator->TooltipValue = "";

        // forward_url
        $this->forward_url->HrefValue = "";
        $this->forward_url->TooltipValue = "";

        // lead_by
        $this->lead_by->HrefValue = "";
        $this->lead_by->TooltipValue = "";

        // lead_status
        $this->lead_status->HrefValue = "";
        $this->lead_status->TooltipValue = "";

        // lead_type
        $this->lead_type->HrefValue = "";
        $this->lead_type->TooltipValue = "";

        // type
        $this->type->HrefValue = "";
        $this->type->TooltipValue = "";

        // alert
        $this->alert->HrefValue = "";
        $this->alert->TooltipValue = "";

        // beep
        $this->beep->HrefValue = "";
        $this->beep->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());
        if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
            $this->id->EditValue = FormatNumber($this->id->EditValue, null);
        }

        // r_from
        $this->r_from->setupEditAttributes();
        $this->r_from->EditValue = $this->r_from->CurrentValue;
        $this->r_from->PlaceHolder = RemoveHtml($this->r_from->caption());

        // r_to
        $this->r_to->setupEditAttributes();
        $this->r_to->EditValue = $this->r_to->CurrentValue;
        $this->r_to->PlaceHolder = RemoveHtml($this->r_to->caption());

        // reference
        $this->reference->setupEditAttributes();
        $this->reference->EditValue = $this->reference->CurrentValue;
        $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());
        if (strval($this->reference->EditValue) != "" && is_numeric($this->reference->EditValue)) {
            $this->reference->EditValue = FormatNumber($this->reference->EditValue, null);
        }

        // message
        $this->_message->setupEditAttributes();
        $this->_message->EditValue = $this->_message->CurrentValue;
        $this->_message->PlaceHolder = RemoveHtml($this->_message->caption());

        // uploads
        $this->uploads->setupEditAttributes();
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // lead_info
        $this->lead_info->setupEditAttributes();
        if (!$this->lead_info->Raw) {
            $this->lead_info->CurrentValue = HtmlDecode($this->lead_info->CurrentValue);
        }
        $this->lead_info->EditValue = $this->lead_info->CurrentValue;
        $this->lead_info->PlaceHolder = RemoveHtml($this->lead_info->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->CurrentValue;
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());
        if (strval($this->status->EditValue) != "" && is_numeric($this->status->EditValue)) {
            $this->status->EditValue = FormatNumber($this->status->EditValue, null);
        }

        // Subject
        $this->Subject->setupEditAttributes();
        if (!$this->Subject->Raw) {
            $this->Subject->CurrentValue = HtmlDecode($this->Subject->CurrentValue);
        }
        $this->Subject->EditValue = $this->Subject->CurrentValue;
        $this->Subject->PlaceHolder = RemoveHtml($this->Subject->caption());

        // datetime
        $this->datetime->setupEditAttributes();
        $this->datetime->EditValue = FormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

        // QueryGenerator
        $this->QueryGenerator->setupEditAttributes();
        if (!$this->QueryGenerator->Raw) {
            $this->QueryGenerator->CurrentValue = HtmlDecode($this->QueryGenerator->CurrentValue);
        }
        $this->QueryGenerator->EditValue = $this->QueryGenerator->CurrentValue;
        $this->QueryGenerator->PlaceHolder = RemoveHtml($this->QueryGenerator->caption());

        // forward_url
        $this->forward_url->setupEditAttributes();
        $this->forward_url->EditValue = $this->forward_url->CurrentValue;
        $this->forward_url->PlaceHolder = RemoveHtml($this->forward_url->caption());

        // lead_by
        $this->lead_by->setupEditAttributes();
        if (!$this->lead_by->Raw) {
            $this->lead_by->CurrentValue = HtmlDecode($this->lead_by->CurrentValue);
        }
        $this->lead_by->EditValue = $this->lead_by->CurrentValue;
        $this->lead_by->PlaceHolder = RemoveHtml($this->lead_by->caption());

        // lead_status
        $this->lead_status->PlaceHolder = RemoveHtml($this->lead_status->caption());

        // lead_type
        $this->lead_type->PlaceHolder = RemoveHtml($this->lead_type->caption());

        // type
        $this->type->setupEditAttributes();
        $this->type->EditValue = $this->type->options(true);
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());

        // alert
        $this->alert->setupEditAttributes();
        $this->alert->EditValue = FormatDateTime($this->alert->CurrentValue, $this->alert->formatPattern());
        $this->alert->PlaceHolder = RemoveHtml($this->alert->caption());

        // beep
        $this->beep->setupEditAttributes();
        if (!$this->beep->Raw) {
            $this->beep->CurrentValue = HtmlDecode($this->beep->CurrentValue);
        }
        $this->beep->EditValue = $this->beep->CurrentValue;
        $this->beep->PlaceHolder = RemoveHtml($this->beep->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->r_from);
                    $doc->exportCaption($this->r_to);
                    $doc->exportCaption($this->reference);
                    $doc->exportCaption($this->_message);
                    $doc->exportCaption($this->uploads);
                    $doc->exportCaption($this->lead_info);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->Subject);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->QueryGenerator);
                    $doc->exportCaption($this->forward_url);
                    $doc->exportCaption($this->lead_by);
                    $doc->exportCaption($this->lead_status);
                    $doc->exportCaption($this->lead_type);
                    $doc->exportCaption($this->type);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->reference);
                    $doc->exportCaption($this->lead_info);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->Subject);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->QueryGenerator);
                    $doc->exportCaption($this->lead_by);
                    $doc->exportCaption($this->lead_status);
                    $doc->exportCaption($this->lead_type);
                    $doc->exportCaption($this->type);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->r_from);
                        $doc->exportField($this->r_to);
                        $doc->exportField($this->reference);
                        $doc->exportField($this->_message);
                        $doc->exportField($this->uploads);
                        $doc->exportField($this->lead_info);
                        $doc->exportField($this->status);
                        $doc->exportField($this->Subject);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->QueryGenerator);
                        $doc->exportField($this->forward_url);
                        $doc->exportField($this->lead_by);
                        $doc->exportField($this->lead_status);
                        $doc->exportField($this->lead_type);
                        $doc->exportField($this->type);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->reference);
                        $doc->exportField($this->lead_info);
                        $doc->exportField($this->status);
                        $doc->exportField($this->Subject);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->QueryGenerator);
                        $doc->exportField($this->lead_by);
                        $doc->exportField($this->lead_status);
                        $doc->exportField($this->lead_type);
                        $doc->exportField($this->type);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 0) {
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
