<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class Request2Add extends Request2
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "Request2Add";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "request2add";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->type->setVisibility();
        $this->r_from->setVisibility();
        $this->r_to->setVisibility();
        $this->lead_type->setVisibility();
        $this->lead_status->setVisibility();
        $this->lead_by->setVisibility();
        $this->subject->setVisibility();
        $this->_message->setVisibility();
        $this->alert->setVisibility();
        $this->uploads->setVisibility();
        $this->reference->setVisibility();
        $this->status->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->beep->Visible = false;
        $this->c_message->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'request2';
        $this->TableName = 'request';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (request2)
        if (!isset($GLOBALS["request2"]) || $GLOBALS["request2"]::class == PROJECT_NAMESPACE . "request2") {
            $GLOBALS["request2"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'request');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "request2view"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->r_from);
        $this->setupLookupOptions($this->r_to);
        $this->setupLookupOptions($this->lead_type);
        $this->setupLookupOptions($this->lead_status);
        $this->setupLookupOptions($this->status);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("request2list"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = 'autoprogramme?apcid=98f13708210194c475687be6106a3b84';

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "request2list") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "request2list"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->type->DefaultValue = $this->type->getDefault(); // PHP
        $this->type->OldValue = $this->type->DefaultValue;
        $this->r_to->DefaultValue = $this->r_to->getDefault(); // PHP
        $this->r_to->OldValue = $this->r_to->DefaultValue;
        $this->lead_type->DefaultValue = $this->lead_type->getDefault(); // PHP
        $this->lead_type->OldValue = $this->lead_type->DefaultValue;
        $this->lead_status->DefaultValue = $this->lead_status->getDefault(); // PHP
        $this->lead_status->OldValue = $this->lead_status->DefaultValue;
        $this->lead_by->DefaultValue = $this->lead_by->getDefault(); // PHP
        $this->lead_by->OldValue = $this->lead_by->DefaultValue;
        $this->subject->DefaultValue = $this->subject->getDefault(); // PHP
        $this->subject->OldValue = $this->subject->DefaultValue;
        $this->reference->DefaultValue = $this->reference->getDefault(); // PHP
        $this->reference->OldValue = $this->reference->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->beep->DefaultValue = $this->beep->getDefault(); // PHP
        $this->beep->OldValue = $this->beep->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'r_from' first before field var 'x_r_from'
        $val = $CurrentForm->hasValue("r_from") ? $CurrentForm->getValue("r_from") : $CurrentForm->getValue("x_r_from");
        if (!$this->r_from->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_from->Visible = false; // Disable update for API request
            } else {
                $this->r_from->setFormValue($val);
            }
        }

        // Check field name 'r_to' first before field var 'x_r_to'
        $val = $CurrentForm->hasValue("r_to") ? $CurrentForm->getValue("r_to") : $CurrentForm->getValue("x_r_to");
        if (!$this->r_to->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->r_to->Visible = false; // Disable update for API request
            } else {
                $this->r_to->setFormValue($val);
            }
        }

        // Check field name 'lead_type' first before field var 'x_lead_type'
        $val = $CurrentForm->hasValue("lead_type") ? $CurrentForm->getValue("lead_type") : $CurrentForm->getValue("x_lead_type");
        if (!$this->lead_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lead_type->Visible = false; // Disable update for API request
            } else {
                $this->lead_type->setFormValue($val);
            }
        }

        // Check field name 'lead_status' first before field var 'x_lead_status'
        $val = $CurrentForm->hasValue("lead_status") ? $CurrentForm->getValue("lead_status") : $CurrentForm->getValue("x_lead_status");
        if (!$this->lead_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lead_status->Visible = false; // Disable update for API request
            } else {
                $this->lead_status->setFormValue($val);
            }
        }

        // Check field name 'lead_by' first before field var 'x_lead_by'
        $val = $CurrentForm->hasValue("lead_by") ? $CurrentForm->getValue("lead_by") : $CurrentForm->getValue("x_lead_by");
        if (!$this->lead_by->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lead_by->Visible = false; // Disable update for API request
            } else {
                $this->lead_by->setFormValue($val);
            }
        }

        // Check field name 'subject' first before field var 'x_subject'
        $val = $CurrentForm->hasValue("subject") ? $CurrentForm->getValue("subject") : $CurrentForm->getValue("x_subject");
        if (!$this->subject->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->subject->Visible = false; // Disable update for API request
            } else {
                $this->subject->setFormValue($val);
            }
        }

        // Check field name 'message' first before field var 'x__message'
        $val = $CurrentForm->hasValue("message") ? $CurrentForm->getValue("message") : $CurrentForm->getValue("x__message");
        if (!$this->_message->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_message->Visible = false; // Disable update for API request
            } else {
                $this->_message->setFormValue($val);
            }
        }

        // Check field name 'alert' first before field var 'x_alert'
        $val = $CurrentForm->hasValue("alert") ? $CurrentForm->getValue("alert") : $CurrentForm->getValue("x_alert");
        if (!$this->alert->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->alert->Visible = false; // Disable update for API request
            } else {
                $this->alert->setFormValue($val, true, $validate);
            }
            $this->alert->CurrentValue = UnFormatDateTime($this->alert->CurrentValue, $this->alert->formatPattern());
        }

        // Check field name 'reference' first before field var 'x_reference'
        $val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
        if (!$this->reference->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->reference->Visible = false; // Disable update for API request
            } else {
                $this->reference->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->r_from->CurrentValue = $this->r_from->FormValue;
        $this->r_to->CurrentValue = $this->r_to->FormValue;
        $this->lead_type->CurrentValue = $this->lead_type->FormValue;
        $this->lead_status->CurrentValue = $this->lead_status->FormValue;
        $this->lead_by->CurrentValue = $this->lead_by->FormValue;
        $this->subject->CurrentValue = $this->subject->FormValue;
        $this->_message->CurrentValue = $this->_message->FormValue;
        $this->alert->CurrentValue = $this->alert->FormValue;
        $this->alert->CurrentValue = UnFormatDateTime($this->alert->CurrentValue, $this->alert->formatPattern());
        $this->reference->CurrentValue = $this->reference->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->r_from->setDbValue($row['r_from']);
        $this->r_to->setDbValue($row['r_to']);
        $this->lead_type->setDbValue($row['lead_type']);
        $this->lead_status->setDbValue($row['lead_status']);
        $this->lead_by->setDbValue($row['lead_by']);
        $this->subject->setDbValue($row['subject']);
        $this->_message->setDbValue($row['message']);
        $this->alert->setDbValue($row['alert']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->reference->setDbValue($row['reference']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->beep->setDbValue($row['beep']);
        $this->c_message->setDbValue($row['c_message']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['r_from'] = $this->r_from->DefaultValue;
        $row['r_to'] = $this->r_to->DefaultValue;
        $row['lead_type'] = $this->lead_type->DefaultValue;
        $row['lead_status'] = $this->lead_status->DefaultValue;
        $row['lead_by'] = $this->lead_by->DefaultValue;
        $row['subject'] = $this->subject->DefaultValue;
        $row['message'] = $this->_message->DefaultValue;
        $row['alert'] = $this->alert->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['reference'] = $this->reference->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['beep'] = $this->beep->DefaultValue;
        $row['c_message'] = $this->c_message->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // r_from
        $this->r_from->RowCssClass = "row";

        // r_to
        $this->r_to->RowCssClass = "row";

        // lead_type
        $this->lead_type->RowCssClass = "row";

        // lead_status
        $this->lead_status->RowCssClass = "row";

        // lead_by
        $this->lead_by->RowCssClass = "row";

        // subject
        $this->subject->RowCssClass = "row";

        // message
        $this->_message->RowCssClass = "row";

        // alert
        $this->alert->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // reference
        $this->reference->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // beep
        $this->beep->RowCssClass = "row";

        // c_message
        $this->c_message->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // r_from
            $curVal = strval($this->r_from->CurrentValue);
            if ($curVal != "") {
                $this->r_from->ViewValue = $this->r_from->lookupCacheOption($curVal);
                if ($this->r_from->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->r_from->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->r_from->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->r_from->getSelectFilter($this); // PHP
                    $sqlWrk = $this->r_from->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->r_from->Lookup->renderViewRow($rswrk[0]);
                        $this->r_from->ViewValue = $this->r_from->displayValue($arwrk);
                    } else {
                        $this->r_from->ViewValue = $this->r_from->CurrentValue;
                    }
                }
            } else {
                $this->r_from->ViewValue = null;
            }

            // r_to
            $curVal = strval($this->r_to->CurrentValue);
            if ($curVal != "") {
                $this->r_to->ViewValue = $this->r_to->lookupCacheOption($curVal);
                if ($this->r_to->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->r_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->r_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->r_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->r_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->r_to->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->r_to->Lookup->renderViewRow($row);
                            $this->r_to->ViewValue->add($this->r_to->displayValue($arwrk));
                        }
                    } else {
                        $this->r_to->ViewValue = $this->r_to->CurrentValue;
                    }
                }
            } else {
                $this->r_to->ViewValue = null;
            }

            // lead_type
            $curVal = strval($this->lead_type->CurrentValue);
            if ($curVal != "") {
                $this->lead_type->ViewValue = $this->lead_type->lookupCacheOption($curVal);
                if ($this->lead_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lead_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->lead_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->lead_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lead_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lead_type->Lookup->renderViewRow($rswrk[0]);
                        $this->lead_type->ViewValue = $this->lead_type->displayValue($arwrk);
                    } else {
                        $this->lead_type->ViewValue = FormatNumber($this->lead_type->CurrentValue, $this->lead_type->formatPattern());
                    }
                }
            } else {
                $this->lead_type->ViewValue = null;
            }

            // lead_status
            $curVal = strval($this->lead_status->CurrentValue);
            if ($curVal != "") {
                $this->lead_status->ViewValue = $this->lead_status->lookupCacheOption($curVal);
                if ($this->lead_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->lead_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->lead_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->lead_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->lead_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->lead_status->Lookup->renderViewRow($rswrk[0]);
                        $this->lead_status->ViewValue = $this->lead_status->displayValue($arwrk);
                    } else {
                        $this->lead_status->ViewValue = FormatNumber($this->lead_status->CurrentValue, $this->lead_status->formatPattern());
                    }
                }
            } else {
                $this->lead_status->ViewValue = null;
            }

            // lead_by
            $this->lead_by->ViewValue = $this->lead_by->CurrentValue;

            // subject
            $this->subject->ViewValue = $this->subject->CurrentValue;

            // message
            $this->_message->ViewValue = $this->_message->CurrentValue;

            // alert
            $this->alert->ViewValue = $this->alert->CurrentValue;
            $this->alert->ViewValue = FormatDateTime($this->alert->ViewValue, $this->alert->formatPattern());

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }

            // reference
            $this->reference->ViewValue = $this->reference->CurrentValue;
            $this->reference->ViewValue = FormatNumber($this->reference->ViewValue, $this->reference->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $this->operator->ViewValue = $this->operator->CurrentValue;
            $this->operator->ViewValue = FormatNumber($this->operator->ViewValue, $this->operator->formatPattern());

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // beep
            $this->beep->ViewValue = $this->beep->CurrentValue;

            // type
            $this->type->HrefValue = "";

            // r_from
            $this->r_from->HrefValue = "";

            // r_to
            $this->r_to->HrefValue = "";

            // lead_type
            $this->lead_type->HrefValue = "";

            // lead_status
            $this->lead_status->HrefValue = "";

            // lead_by
            $this->lead_by->HrefValue = "";

            // subject
            $this->subject->HrefValue = "";

            // message
            $this->_message->HrefValue = "";

            // alert
            $this->alert->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // reference
            $this->reference->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->options(true);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // r_from

            // r_to
            $curVal = trim(strval($this->r_to->CurrentValue));
            if ($curVal != "") {
                $this->r_to->ViewValue = $this->r_to->lookupCacheOption($curVal);
            } else {
                $this->r_to->ViewValue = $this->r_to->Lookup !== null && is_array($this->r_to->lookupOptions()) && count($this->r_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->r_to->ViewValue !== null) { // Load from cache
                $this->r_to->EditValue = array_values($this->r_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->r_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->r_to->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->r_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->r_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->r_to->EditValue = $arwrk;
            }
            $this->r_to->PlaceHolder = RemoveHtml($this->r_to->caption());

            // lead_type
            $this->lead_type->setupEditAttributes();
            $curVal = trim(strval($this->lead_type->CurrentValue));
            if ($curVal != "") {
                $this->lead_type->ViewValue = $this->lead_type->lookupCacheOption($curVal);
            } else {
                $this->lead_type->ViewValue = $this->lead_type->Lookup !== null && is_array($this->lead_type->lookupOptions()) && count($this->lead_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->lead_type->ViewValue !== null) { // Load from cache
                $this->lead_type->EditValue = array_values($this->lead_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->lead_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->lead_type->CurrentValue, $this->lead_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->lead_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->lead_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->lead_type->EditValue = $arwrk;
            }
            $this->lead_type->PlaceHolder = RemoveHtml($this->lead_type->caption());

            // lead_status
            $this->lead_status->setupEditAttributes();
            $curVal = trim(strval($this->lead_status->CurrentValue));
            if ($curVal != "") {
                $this->lead_status->ViewValue = $this->lead_status->lookupCacheOption($curVal);
            } else {
                $this->lead_status->ViewValue = $this->lead_status->Lookup !== null && is_array($this->lead_status->lookupOptions()) && count($this->lead_status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->lead_status->ViewValue !== null) { // Load from cache
                $this->lead_status->EditValue = array_values($this->lead_status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->lead_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->lead_status->CurrentValue, $this->lead_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->lead_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->lead_status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->lead_status->EditValue = $arwrk;
            }
            $this->lead_status->PlaceHolder = RemoveHtml($this->lead_status->caption());

            // lead_by
            $this->lead_by->setupEditAttributes();
            if (!$this->lead_by->Raw) {
                $this->lead_by->CurrentValue = HtmlDecode($this->lead_by->CurrentValue);
            }
            $this->lead_by->EditValue = HtmlEncode($this->lead_by->CurrentValue);
            $this->lead_by->PlaceHolder = RemoveHtml($this->lead_by->caption());

            // subject
            $this->subject->setupEditAttributes();
            $this->subject->EditValue = HtmlEncode($this->subject->CurrentValue);
            $this->subject->PlaceHolder = RemoveHtml($this->subject->caption());

            // message
            $this->_message->setupEditAttributes();
            $this->_message->EditValue = HtmlEncode($this->_message->CurrentValue);
            $this->_message->PlaceHolder = RemoveHtml($this->_message->caption());

            // alert
            $this->alert->setupEditAttributes();
            $this->alert->EditValue = HtmlEncode(FormatDateTime($this->alert->CurrentValue, $this->alert->formatPattern()));
            $this->alert->PlaceHolder = RemoveHtml($this->alert->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // reference
            $this->reference->setupEditAttributes();
            $this->reference->EditCustomAttributes = $this->reference->getEditCustomAttributes(); // PHP
            $this->reference->EditValue = $this->reference->CurrentValue;
            $this->reference->PlaceHolder = RemoveHtml($this->reference->caption());
            if (strval($this->reference->EditValue) != "" && is_numeric($this->reference->EditValue)) {
                $this->reference->EditValue = FormatNumber($this->reference->EditValue, null);
            }

            // operator

            // datetime

            // Add refer script

            // type
            $this->type->HrefValue = "";

            // r_from
            $this->r_from->HrefValue = "";

            // r_to
            $this->r_to->HrefValue = "";

            // lead_type
            $this->lead_type->HrefValue = "";

            // lead_status
            $this->lead_status->HrefValue = "";

            // lead_by
            $this->lead_by->HrefValue = "";

            // subject
            $this->subject->HrefValue = "";

            // message
            $this->_message->HrefValue = "";

            // alert
            $this->alert->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // reference
            $this->reference->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->r_from->Visible && $this->r_from->Required) {
                if (!$this->r_from->IsDetailKey && EmptyValue($this->r_from->FormValue)) {
                    $this->r_from->addErrorMessage(str_replace("%s", $this->r_from->caption(), $this->r_from->RequiredErrorMessage));
                }
            }
            if ($this->r_to->Visible && $this->r_to->Required) {
                if ($this->r_to->FormValue == "") {
                    $this->r_to->addErrorMessage(str_replace("%s", $this->r_to->caption(), $this->r_to->RequiredErrorMessage));
                }
            }
            if ($this->lead_type->Visible && $this->lead_type->Required) {
                if (!$this->lead_type->IsDetailKey && EmptyValue($this->lead_type->FormValue)) {
                    $this->lead_type->addErrorMessage(str_replace("%s", $this->lead_type->caption(), $this->lead_type->RequiredErrorMessage));
                }
            }
            if ($this->lead_status->Visible && $this->lead_status->Required) {
                if (!$this->lead_status->IsDetailKey && EmptyValue($this->lead_status->FormValue)) {
                    $this->lead_status->addErrorMessage(str_replace("%s", $this->lead_status->caption(), $this->lead_status->RequiredErrorMessage));
                }
            }
            if ($this->lead_by->Visible && $this->lead_by->Required) {
                if (!$this->lead_by->IsDetailKey && EmptyValue($this->lead_by->FormValue)) {
                    $this->lead_by->addErrorMessage(str_replace("%s", $this->lead_by->caption(), $this->lead_by->RequiredErrorMessage));
                }
            }
            if ($this->subject->Visible && $this->subject->Required) {
                if (!$this->subject->IsDetailKey && EmptyValue($this->subject->FormValue)) {
                    $this->subject->addErrorMessage(str_replace("%s", $this->subject->caption(), $this->subject->RequiredErrorMessage));
                }
            }
            if ($this->_message->Visible && $this->_message->Required) {
                if (!$this->_message->IsDetailKey && EmptyValue($this->_message->FormValue)) {
                    $this->_message->addErrorMessage(str_replace("%s", $this->_message->caption(), $this->_message->RequiredErrorMessage));
                }
            }
            if ($this->alert->Visible && $this->alert->Required) {
                if (!$this->alert->IsDetailKey && EmptyValue($this->alert->FormValue)) {
                    $this->alert->addErrorMessage(str_replace("%s", $this->alert->caption(), $this->alert->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->alert->FormValue, $this->alert->formatPattern())) {
                $this->alert->addErrorMessage($this->alert->getErrorMessage(false));
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->reference->Visible && $this->reference->Required) {
                if (!$this->reference->IsDetailKey && EmptyValue($this->reference->FormValue)) {
                    $this->reference->addErrorMessage(str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->reference->FormValue)) {
                $this->reference->addErrorMessage($this->reference->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, strval($this->type->CurrentValue) == "");

        // r_from
        $this->r_from->CurrentValue = $this->r_from->getAutoUpdateValue(); // PHP
        $this->r_from->setDbValueDef($rsnew, $this->r_from->CurrentValue, false);

        // r_to
        $this->r_to->setDbValueDef($rsnew, $this->r_to->CurrentValue, false);

        // lead_type
        $this->lead_type->setDbValueDef($rsnew, $this->lead_type->CurrentValue, false);

        // lead_status
        $this->lead_status->setDbValueDef($rsnew, $this->lead_status->CurrentValue, false);

        // lead_by
        $this->lead_by->setDbValueDef($rsnew, $this->lead_by->CurrentValue, false);

        // subject
        $this->subject->setDbValueDef($rsnew, $this->subject->CurrentValue, false);

        // message
        $this->_message->setDbValueDef($rsnew, $this->_message->CurrentValue, false);

        // alert
        $this->alert->setDbValueDef($rsnew, UnFormatDateTime($this->alert->CurrentValue, $this->alert->formatPattern()), false);

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 640; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // reference
        $this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, strval($this->reference->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['type'])) { // type
            $this->type->setFormValue($row['type']);
        }
        if (isset($row['r_from'])) { // r_from
            $this->r_from->setFormValue($row['r_from']);
        }
        if (isset($row['r_to'])) { // r_to
            $this->r_to->setFormValue($row['r_to']);
        }
        if (isset($row['lead_type'])) { // lead_type
            $this->lead_type->setFormValue($row['lead_type']);
        }
        if (isset($row['lead_status'])) { // lead_status
            $this->lead_status->setFormValue($row['lead_status']);
        }
        if (isset($row['lead_by'])) { // lead_by
            $this->lead_by->setFormValue($row['lead_by']);
        }
        if (isset($row['subject'])) { // subject
            $this->subject->setFormValue($row['subject']);
        }
        if (isset($row['message'])) { // message
            $this->_message->setFormValue($row['message']);
        }
        if (isset($row['alert'])) { // alert
            $this->alert->setFormValue($row['alert']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['reference'])) { // reference
            $this->reference->setFormValue($row['reference']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("request2list"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_type":
                    break;
                case "x_r_from":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_r_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lead_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lead_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header) {
    	// Example:
    	//$header = "your header";
    	if(isset($_GET["sub"]))
    	{
    		$this->subject->ReadOnly = True;	
    	}
    	if(isset($_GET["type"]))
    	{
    		$this->type->ReadOnly = True;	
    	}
    	$this->reference->ReadOnly = True;	
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
