<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RentalPoView extends RentalPo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "view";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RentalPoView";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "rentalpoview";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->programme_datetime->setVisibility();
        $this->programme_end_datetime->setVisibility();
        $this->location->setVisibility();
        $this->item->setVisibility();
        $this->contact_person->setVisibility();
        $this->amount->setVisibility();
        $this->booking_ref->setVisibility();
        $this->company_id->setVisibility();
        $this->payment_terms->setVisibility();
        $this->job_category->setVisibility();
        $this->type->setVisibility();
        $this->buyer_instruction->setVisibility();
        $this->remarks->setVisibility();
        $this->eastimated_amount->setVisibility();
        $this->gst->setVisibility();
        $this->uploads->setVisibility();
        $this->reports_to->setVisibility();
        $this->description_01->setVisibility();
        $this->description_02->setVisibility();
        $this->description_03->setVisibility();
        $this->description_04->setVisibility();
        $this->description_05->setVisibility();
        $this->description_06->setVisibility();
        $this->description_07->setVisibility();
        $this->description_08->setVisibility();
        $this->description_09->setVisibility();
        $this->description_10->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'rental_po';
        $this->TableName = 'rental_po';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (rental_po)
        if (!isset($GLOBALS["rental_po"]) || $GLOBALS["rental_po"]::class == PROJECT_NAMESPACE . "rental_po") {
            $GLOBALS["rental_po"] = &$this;
        }

        // Set up record key
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->RecKey["id"] = $keyValue;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'rental_po');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "rentalpoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $ExportOptions; // Export options
    public $OtherOptions; // Other options
    public $DisplayRecords = 1;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecKey = [];
    public $IsModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->job_category);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->gst);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->description_01);
        $this->setupLookupOptions($this->description_02);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->description_06);
        $this->setupLookupOptions($this->description_07);
        $this->setupLookupOptions($this->description_08);
        $this->setupLookupOptions($this->description_09);
        $this->setupLookupOptions($this->description_10);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }

        // Load current record
        $loadCurrentRecord = false;
        $returnUrl = "";
        $matchRecord = false;
        if (($keyValue = Get("id") ?? Route("id")) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (Post("id") !== null) {
            $this->id->setFormValue(Post("id"));
            $this->RecKey["id"] = $this->id->FormValue;
        } elseif (IsApi() && ($keyValue = Key(0) ?? Route(2)) !== null) {
            $this->id->setQueryStringValue($keyValue);
            $this->RecKey["id"] = $this->id->QueryStringValue;
        } elseif (!$loadCurrentRecord) {
            $returnUrl = "rentalpolist"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display

                    // Load record based on key
                    if (IsApi()) {
                        $filter = $this->getRecordFilter();
                        $this->CurrentFilter = $filter;
                        $sql = $this->getCurrentSql();
                        $conn = $this->getConnection();
                        $res = ($this->Recordset = ExecuteQuery($sql, $conn));
                    } else {
                        $res = $this->loadRow();
                    }
                    if (!$res) { // Load record based on key
                        if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                        }
                        $returnUrl = "rentalpolist"; // No matching record, return to list
                    }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->RowType = RowType::VIEW;
        $this->resetAttributes();
        $this->renderRow();

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRecordsFromRecordset($this->Recordset, true); // Get current record only
                $this->Recordset?->free();
                WriteJson(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate(true);
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = &$this->OtherOptions;
        $option = $options["action"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();

        // Edit
        $item = &$option->add("edit");
        $editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
        }
        $item->Visible = $this->EditUrl != "" && $Security->canEdit();

        // Copy
        $item = &$option->add("copy");
        $copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
        }
        $item->Visible = $this->CopyUrl != "" && $Security->canAdd();

        // Delete
        $item = &$option->add("delete");
        $url = GetUrl($this->DeleteUrl);
        $item->Body = "<a class=\"ew-action ew-delete\"" .
            ($this->InlineDelete || $this->IsModal ? " data-ew-action=\"inline-delete\"" : "") .
            " title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) .
            "\" href=\"" . HtmlEncode($url) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
        $item->Visible = $this->DeleteUrl != "" && $Security->canDelete();

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = &$option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        if ($this->AuditTrailOnView) {
            $this->writeAuditTrailOnView($row);
        }
        $this->id->setDbValue($row['id']);
        $this->programme_datetime->setDbValue($row['programme_datetime']);
        $this->programme_end_datetime->setDbValue($row['programme_end_datetime']);
        $this->location->setDbValue($row['location']);
        if (array_key_exists('EV__location', $row)) {
            $this->location->VirtualValue = $row['EV__location']; // Set up virtual field value
        } else {
            $this->location->VirtualValue = ""; // Clear value
        }
        $this->item->setDbValue($row['item']);
        $this->contact_person->setDbValue($row['contact_person']);
        if (array_key_exists('EV__contact_person', $row)) {
            $this->contact_person->VirtualValue = $row['EV__contact_person']; // Set up virtual field value
        } else {
            $this->contact_person->VirtualValue = ""; // Clear value
        }
        $this->amount->setDbValue($row['amount']);
        $this->booking_ref->setDbValue($row['booking_ref']);
        if (array_key_exists('EV__booking_ref', $row)) {
            $this->booking_ref->VirtualValue = $row['EV__booking_ref']; // Set up virtual field value
        } else {
            $this->booking_ref->VirtualValue = ""; // Clear value
        }
        $this->company_id->setDbValue($row['company_id']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->job_category->setDbValue($row['job_category']);
        $this->type->setDbValue($row['type']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->remarks->setDbValue($row['remarks']);
        $this->eastimated_amount->setDbValue($row['eastimated_amount']);
        $this->gst->setDbValue($row['gst']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_08->setDbValue($row['description_08']);
        $this->description_09->setDbValue($row['description_09']);
        $this->description_10->setDbValue($row['description_10']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['programme_datetime'] = $this->programme_datetime->DefaultValue;
        $row['programme_end_datetime'] = $this->programme_end_datetime->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['contact_person'] = $this->contact_person->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['booking_ref'] = $this->booking_ref->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['job_category'] = $this->job_category->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['buyer_instruction'] = $this->buyer_instruction->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['eastimated_amount'] = $this->eastimated_amount->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['description_03'] = $this->description_03->DefaultValue;
        $row['description_04'] = $this->description_04->DefaultValue;
        $row['description_05'] = $this->description_05->DefaultValue;
        $row['description_06'] = $this->description_06->DefaultValue;
        $row['description_07'] = $this->description_07->DefaultValue;
        $row['description_08'] = $this->description_08->DefaultValue;
        $row['description_09'] = $this->description_09->DefaultValue;
        $row['description_10'] = $this->description_10->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // programme_datetime

        // programme_end_datetime

        // location

        // item

        // contact_person

        // amount

        // booking_ref

        // company_id

        // payment_terms

        // job_category

        // type

        // buyer_instruction

        // remarks

        // eastimated_amount

        // gst

        // uploads

        // reports_to

        // description_01

        // description_02

        // description_03

        // description_04

        // description_05

        // description_06

        // description_07

        // description_08

        // description_09

        // description_10

        // operator

        // datetime

        // a_operator

        // a_datetime

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // programme_datetime
            $this->programme_datetime->ViewValue = $this->programme_datetime->CurrentValue;
            $this->programme_datetime->ViewValue = FormatDateTime($this->programme_datetime->ViewValue, $this->programme_datetime->formatPattern());

            // programme_end_datetime
            $this->programme_end_datetime->ViewValue = $this->programme_end_datetime->CurrentValue;
            $this->programme_end_datetime->ViewValue = FormatDateTime($this->programme_end_datetime->ViewValue, $this->programme_end_datetime->formatPattern());

            // location
            if ($this->location->VirtualValue != "") {
                $this->location->ViewValue = $this->location->VirtualValue;
            } else {
                $this->location->ViewValue = $this->location->CurrentValue;
            }

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // contact_person
            if ($this->contact_person->VirtualValue != "") {
                $this->contact_person->ViewValue = $this->contact_person->VirtualValue;
            } else {
                $this->contact_person->ViewValue = $this->contact_person->CurrentValue;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;

            // booking_ref
            if ($this->booking_ref->VirtualValue != "") {
                $this->booking_ref->ViewValue = $this->booking_ref->VirtualValue;
            } else {
                $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // gst
            $curVal = strval($this->gst->CurrentValue);
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
                if ($this->gst->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                        $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                    } else {
                        $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                    }
                }
            } else {
                $this->gst->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // description_01
            $curVal = strval($this->description_01->CurrentValue);
            if ($curVal != "") {
                $this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
                if ($this->description_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_01->Lookup->renderViewRow($row);
                            $this->description_01->ViewValue->add($this->description_01->displayValue($arwrk));
                        }
                    } else {
                        $this->description_01->ViewValue = $this->description_01->CurrentValue;
                    }
                }
            } else {
                $this->description_01->ViewValue = null;
            }

            // description_02
            $curVal = strval($this->description_02->CurrentValue);
            if ($curVal != "") {
                $this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
                if ($this->description_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_02->Lookup->renderViewRow($row);
                            $this->description_02->ViewValue->add($this->description_02->displayValue($arwrk));
                        }
                    } else {
                        $this->description_02->ViewValue = $this->description_02->CurrentValue;
                    }
                }
            } else {
                $this->description_02->ViewValue = null;
            }

            // description_03
            $curVal = strval($this->description_03->CurrentValue);
            if ($curVal != "") {
                $this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
                if ($this->description_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_03->Lookup->renderViewRow($row);
                            $this->description_03->ViewValue->add($this->description_03->displayValue($arwrk));
                        }
                    } else {
                        $this->description_03->ViewValue = $this->description_03->CurrentValue;
                    }
                }
            } else {
                $this->description_03->ViewValue = null;
            }

            // description_04
            $curVal = strval($this->description_04->CurrentValue);
            if ($curVal != "") {
                $this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
                if ($this->description_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_04->Lookup->renderViewRow($row);
                            $this->description_04->ViewValue->add($this->description_04->displayValue($arwrk));
                        }
                    } else {
                        $this->description_04->ViewValue = $this->description_04->CurrentValue;
                    }
                }
            } else {
                $this->description_04->ViewValue = null;
            }

            // description_05
            $curVal = strval($this->description_05->CurrentValue);
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
                if ($this->description_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_05->Lookup->renderViewRow($row);
                            $this->description_05->ViewValue->add($this->description_05->displayValue($arwrk));
                        }
                    } else {
                        $this->description_05->ViewValue = $this->description_05->CurrentValue;
                    }
                }
            } else {
                $this->description_05->ViewValue = null;
            }

            // description_06
            $curVal = strval($this->description_06->CurrentValue);
            if ($curVal != "") {
                $this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
                if ($this->description_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_06->Lookup->renderViewRow($row);
                            $this->description_06->ViewValue->add($this->description_06->displayValue($arwrk));
                        }
                    } else {
                        $this->description_06->ViewValue = $this->description_06->CurrentValue;
                    }
                }
            } else {
                $this->description_06->ViewValue = null;
            }

            // description_07
            $curVal = strval($this->description_07->CurrentValue);
            if ($curVal != "") {
                $this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
                if ($this->description_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_07->Lookup->renderViewRow($row);
                            $this->description_07->ViewValue->add($this->description_07->displayValue($arwrk));
                        }
                    } else {
                        $this->description_07->ViewValue = $this->description_07->CurrentValue;
                    }
                }
            } else {
                $this->description_07->ViewValue = null;
            }

            // description_08
            $curVal = strval($this->description_08->CurrentValue);
            if ($curVal != "") {
                $this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
                if ($this->description_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_08->Lookup->renderViewRow($row);
                            $this->description_08->ViewValue->add($this->description_08->displayValue($arwrk));
                        }
                    } else {
                        $this->description_08->ViewValue = $this->description_08->CurrentValue;
                    }
                }
            } else {
                $this->description_08->ViewValue = null;
            }

            // description_09
            $curVal = strval($this->description_09->CurrentValue);
            if ($curVal != "") {
                $this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
                if ($this->description_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_09->Lookup->renderViewRow($row);
                            $this->description_09->ViewValue->add($this->description_09->displayValue($arwrk));
                        }
                    } else {
                        $this->description_09->ViewValue = $this->description_09->CurrentValue;
                    }
                }
            } else {
                $this->description_09->ViewValue = null;
            }

            // description_10
            $curVal = strval($this->description_10->CurrentValue);
            if ($curVal != "") {
                $this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
                if ($this->description_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_10->Lookup->renderViewRow($row);
                            $this->description_10->ViewValue->add($this->description_10->displayValue($arwrk));
                        }
                    } else {
                        $this->description_10->ViewValue = $this->description_10->CurrentValue;
                    }
                }
            } else {
                $this->description_10->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // programme_datetime
            $this->programme_datetime->HrefValue = "";
            $this->programme_datetime->TooltipValue = "";

            // programme_end_datetime
            $this->programme_end_datetime->HrefValue = "";
            $this->programme_end_datetime->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // item
            $this->item->HrefValue = "";
            $this->item->TooltipValue = "";

            // contact_person
            $this->contact_person->HrefValue = "";
            $this->contact_person->TooltipValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";
            $this->booking_ref->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // payment_terms
            if (!EmptyValue($this->payment_terms->CurrentValue)) {
                $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
                $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
                }
            } else {
                $this->payment_terms->HrefValue = "";
            }
            $this->payment_terms->TooltipValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";
            $this->buyer_instruction->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // description_01
            $this->description_01->HrefValue = "";
            $this->description_01->TooltipValue = "";

            // description_02
            $this->description_02->HrefValue = "";
            $this->description_02->TooltipValue = "";

            // description_03
            $this->description_03->HrefValue = "";
            $this->description_03->TooltipValue = "";

            // description_04
            $this->description_04->HrefValue = "";
            $this->description_04->TooltipValue = "";

            // description_05
            $this->description_05->HrefValue = "";
            $this->description_05->TooltipValue = "";

            // description_06
            $this->description_06->HrefValue = "";
            $this->description_06->TooltipValue = "";

            // description_07
            $this->description_07->HrefValue = "";
            $this->description_07->TooltipValue = "";

            // description_08
            $this->description_08->HrefValue = "";
            $this->description_08->TooltipValue = "";

            // description_09
            $this->description_09->HrefValue = "";
            $this->description_09->TooltipValue = "";

            // description_10
            $this->description_10->HrefValue = "";
            $this->description_10->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("rentalpolist"), "", $this->TableVar, true);
        $pageId = "view";
        $Breadcrumb->add("view", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    break;
                case "x_item":
                    break;
                case "x_contact_person":
                    break;
                case "x_booking_ref":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_job_category":
                    break;
                case "x_type":
                    break;
                case "x_gst":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
