<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RentalPoSearch extends RentalPo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RentalPoSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "rentalposearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->programme_datetime->setVisibility();
        $this->programme_end_datetime->setVisibility();
        $this->location->setVisibility();
        $this->item->Visible = false;
        $this->contact_person->setVisibility();
        $this->amount->setVisibility();
        $this->booking_ref->setVisibility();
        $this->company_id->setVisibility();
        $this->payment_terms->Visible = false;
        $this->job_category->Visible = false;
        $this->type->setVisibility();
        $this->buyer_instruction->setVisibility();
        $this->remarks->setVisibility();
        $this->eastimated_amount->Visible = false;
        $this->gst->setVisibility();
        $this->uploads->Visible = false;
        $this->reports_to->setVisibility();
        $this->description_01->setVisibility();
        $this->description_02->setVisibility();
        $this->description_03->setVisibility();
        $this->description_04->setVisibility();
        $this->description_05->setVisibility();
        $this->description_06->setVisibility();
        $this->description_07->setVisibility();
        $this->description_08->setVisibility();
        $this->description_09->setVisibility();
        $this->description_10->setVisibility();
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'rental_po';
        $this->TableName = 'rental_po';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (rental_po)
        if (!isset($GLOBALS["rental_po"]) || $GLOBALS["rental_po"]::class == PROJECT_NAMESPACE . "rental_po") {
            $GLOBALS["rental_po"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'rental_po');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "rentalpoview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->job_category);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->gst);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->description_01);
        $this->setupLookupOptions($this->description_02);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->description_06);
        $this->setupLookupOptions($this->description_07);
        $this->setupLookupOptions($this->description_08);
        $this->setupLookupOptions($this->description_09);
        $this->setupLookupOptions($this->description_10);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "rentalpolist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->programme_datetime); // programme_datetime
        $this->buildSearchUrl($srchUrl, $this->programme_end_datetime); // programme_end_datetime
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->contact_person); // contact_person
        $this->buildSearchUrl($srchUrl, $this->amount); // amount
        $this->buildSearchUrl($srchUrl, $this->booking_ref); // booking_ref
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->type); // type
        $this->buildSearchUrl($srchUrl, $this->buyer_instruction); // buyer_instruction
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->gst); // gst
        $this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
        $this->buildSearchUrl($srchUrl, $this->description_01); // description_01
        $this->buildSearchUrl($srchUrl, $this->description_02); // description_02
        $this->buildSearchUrl($srchUrl, $this->description_03); // description_03
        $this->buildSearchUrl($srchUrl, $this->description_04); // description_04
        $this->buildSearchUrl($srchUrl, $this->description_05); // description_05
        $this->buildSearchUrl($srchUrl, $this->description_06); // description_06
        $this->buildSearchUrl($srchUrl, $this->description_07); // description_07
        $this->buildSearchUrl($srchUrl, $this->description_08); // description_08
        $this->buildSearchUrl($srchUrl, $this->description_09); // description_09
        $this->buildSearchUrl($srchUrl, $this->description_10); // description_10
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // programme_datetime
        if ($this->programme_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // programme_end_datetime
        if ($this->programme_end_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // contact_person
        if ($this->contact_person->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // amount
        if ($this->amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // booking_ref
        if ($this->booking_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // type
        if ($this->type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_instruction
        if ($this->buyer_instruction->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gst
        if ($this->gst->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // reports_to
        if ($this->reports_to->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // description_01
        if ($this->description_01->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_01->AdvancedSearch->SearchValue)) {
            $this->description_01->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_01->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_01->AdvancedSearch->SearchValue2)) {
            $this->description_01->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_01->AdvancedSearch->SearchValue2);
        }

        // description_02
        if ($this->description_02->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_02->AdvancedSearch->SearchValue)) {
            $this->description_02->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_02->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_02->AdvancedSearch->SearchValue2)) {
            $this->description_02->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_02->AdvancedSearch->SearchValue2);
        }

        // description_03
        if ($this->description_03->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_03->AdvancedSearch->SearchValue)) {
            $this->description_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_03->AdvancedSearch->SearchValue2)) {
            $this->description_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_03->AdvancedSearch->SearchValue2);
        }

        // description_04
        if ($this->description_04->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_04->AdvancedSearch->SearchValue)) {
            $this->description_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_04->AdvancedSearch->SearchValue2)) {
            $this->description_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_04->AdvancedSearch->SearchValue2);
        }

        // description_05
        if ($this->description_05->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_05->AdvancedSearch->SearchValue)) {
            $this->description_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_05->AdvancedSearch->SearchValue2)) {
            $this->description_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_05->AdvancedSearch->SearchValue2);
        }

        // description_06
        if ($this->description_06->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_06->AdvancedSearch->SearchValue)) {
            $this->description_06->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_06->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_06->AdvancedSearch->SearchValue2)) {
            $this->description_06->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_06->AdvancedSearch->SearchValue2);
        }

        // description_07
        if ($this->description_07->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_07->AdvancedSearch->SearchValue)) {
            $this->description_07->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_07->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_07->AdvancedSearch->SearchValue2)) {
            $this->description_07->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_07->AdvancedSearch->SearchValue2);
        }

        // description_08
        if ($this->description_08->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_08->AdvancedSearch->SearchValue)) {
            $this->description_08->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_08->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_08->AdvancedSearch->SearchValue2)) {
            $this->description_08->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_08->AdvancedSearch->SearchValue2);
        }

        // description_09
        if ($this->description_09->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_09->AdvancedSearch->SearchValue)) {
            $this->description_09->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_09->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_09->AdvancedSearch->SearchValue2)) {
            $this->description_09->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_09->AdvancedSearch->SearchValue2);
        }

        // description_10
        if ($this->description_10->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->description_10->AdvancedSearch->SearchValue)) {
            $this->description_10->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_10->AdvancedSearch->SearchValue);
        }
        if (is_array($this->description_10->AdvancedSearch->SearchValue2)) {
            $this->description_10->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->description_10->AdvancedSearch->SearchValue2);
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // programme_datetime
        $this->programme_datetime->RowCssClass = "row";

        // programme_end_datetime
        $this->programme_end_datetime->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // contact_person
        $this->contact_person->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // booking_ref
        $this->booking_ref->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // job_category
        $this->job_category->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // buyer_instruction
        $this->buyer_instruction->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // eastimated_amount
        $this->eastimated_amount->RowCssClass = "row";

        // gst
        $this->gst->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // description_03
        $this->description_03->RowCssClass = "row";

        // description_04
        $this->description_04->RowCssClass = "row";

        // description_05
        $this->description_05->RowCssClass = "row";

        // description_06
        $this->description_06->RowCssClass = "row";

        // description_07
        $this->description_07->RowCssClass = "row";

        // description_08
        $this->description_08->RowCssClass = "row";

        // description_09
        $this->description_09->RowCssClass = "row";

        // description_10
        $this->description_10->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // programme_datetime
            $this->programme_datetime->ViewValue = $this->programme_datetime->CurrentValue;
            $this->programme_datetime->ViewValue = FormatDateTime($this->programme_datetime->ViewValue, $this->programme_datetime->formatPattern());

            // programme_end_datetime
            $this->programme_end_datetime->ViewValue = $this->programme_end_datetime->CurrentValue;
            $this->programme_end_datetime->ViewValue = FormatDateTime($this->programme_end_datetime->ViewValue, $this->programme_end_datetime->formatPattern());

            // location
            if ($this->location->VirtualValue != "") {
                $this->location->ViewValue = $this->location->VirtualValue;
            } else {
                $this->location->ViewValue = $this->location->CurrentValue;
            }

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // contact_person
            if ($this->contact_person->VirtualValue != "") {
                $this->contact_person->ViewValue = $this->contact_person->VirtualValue;
            } else {
                $this->contact_person->ViewValue = $this->contact_person->CurrentValue;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;

            // booking_ref
            if ($this->booking_ref->VirtualValue != "") {
                $this->booking_ref->ViewValue = $this->booking_ref->VirtualValue;
            } else {
                $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // gst
            $curVal = strval($this->gst->CurrentValue);
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
                if ($this->gst->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                        $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                    } else {
                        $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                    }
                }
            } else {
                $this->gst->ViewValue = null;
            }

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // description_01
            $curVal = strval($this->description_01->CurrentValue);
            if ($curVal != "") {
                $this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
                if ($this->description_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_01->Lookup->renderViewRow($row);
                            $this->description_01->ViewValue->add($this->description_01->displayValue($arwrk));
                        }
                    } else {
                        $this->description_01->ViewValue = $this->description_01->CurrentValue;
                    }
                }
            } else {
                $this->description_01->ViewValue = null;
            }

            // description_02
            $curVal = strval($this->description_02->CurrentValue);
            if ($curVal != "") {
                $this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
                if ($this->description_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_02->Lookup->renderViewRow($row);
                            $this->description_02->ViewValue->add($this->description_02->displayValue($arwrk));
                        }
                    } else {
                        $this->description_02->ViewValue = $this->description_02->CurrentValue;
                    }
                }
            } else {
                $this->description_02->ViewValue = null;
            }

            // description_03
            $curVal = strval($this->description_03->CurrentValue);
            if ($curVal != "") {
                $this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
                if ($this->description_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_03->Lookup->renderViewRow($row);
                            $this->description_03->ViewValue->add($this->description_03->displayValue($arwrk));
                        }
                    } else {
                        $this->description_03->ViewValue = $this->description_03->CurrentValue;
                    }
                }
            } else {
                $this->description_03->ViewValue = null;
            }

            // description_04
            $curVal = strval($this->description_04->CurrentValue);
            if ($curVal != "") {
                $this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
                if ($this->description_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_04->Lookup->renderViewRow($row);
                            $this->description_04->ViewValue->add($this->description_04->displayValue($arwrk));
                        }
                    } else {
                        $this->description_04->ViewValue = $this->description_04->CurrentValue;
                    }
                }
            } else {
                $this->description_04->ViewValue = null;
            }

            // description_05
            $curVal = strval($this->description_05->CurrentValue);
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
                if ($this->description_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_05->Lookup->renderViewRow($row);
                            $this->description_05->ViewValue->add($this->description_05->displayValue($arwrk));
                        }
                    } else {
                        $this->description_05->ViewValue = $this->description_05->CurrentValue;
                    }
                }
            } else {
                $this->description_05->ViewValue = null;
            }

            // description_06
            $curVal = strval($this->description_06->CurrentValue);
            if ($curVal != "") {
                $this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
                if ($this->description_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_06->Lookup->renderViewRow($row);
                            $this->description_06->ViewValue->add($this->description_06->displayValue($arwrk));
                        }
                    } else {
                        $this->description_06->ViewValue = $this->description_06->CurrentValue;
                    }
                }
            } else {
                $this->description_06->ViewValue = null;
            }

            // description_07
            $curVal = strval($this->description_07->CurrentValue);
            if ($curVal != "") {
                $this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
                if ($this->description_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_07->Lookup->renderViewRow($row);
                            $this->description_07->ViewValue->add($this->description_07->displayValue($arwrk));
                        }
                    } else {
                        $this->description_07->ViewValue = $this->description_07->CurrentValue;
                    }
                }
            } else {
                $this->description_07->ViewValue = null;
            }

            // description_08
            $curVal = strval($this->description_08->CurrentValue);
            if ($curVal != "") {
                $this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
                if ($this->description_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_08->Lookup->renderViewRow($row);
                            $this->description_08->ViewValue->add($this->description_08->displayValue($arwrk));
                        }
                    } else {
                        $this->description_08->ViewValue = $this->description_08->CurrentValue;
                    }
                }
            } else {
                $this->description_08->ViewValue = null;
            }

            // description_09
            $curVal = strval($this->description_09->CurrentValue);
            if ($curVal != "") {
                $this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
                if ($this->description_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_09->Lookup->renderViewRow($row);
                            $this->description_09->ViewValue->add($this->description_09->displayValue($arwrk));
                        }
                    } else {
                        $this->description_09->ViewValue = $this->description_09->CurrentValue;
                    }
                }
            } else {
                $this->description_09->ViewValue = null;
            }

            // description_10
            $curVal = strval($this->description_10->CurrentValue);
            if ($curVal != "") {
                $this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
                if ($this->description_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_10->Lookup->renderViewRow($row);
                            $this->description_10->ViewValue->add($this->description_10->displayValue($arwrk));
                        }
                    } else {
                        $this->description_10->ViewValue = $this->description_10->CurrentValue;
                    }
                }
            } else {
                $this->description_10->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // programme_datetime
            $this->programme_datetime->HrefValue = "";
            $this->programme_datetime->TooltipValue = "";

            // programme_end_datetime
            $this->programme_end_datetime->HrefValue = "";
            $this->programme_end_datetime->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // contact_person
            $this->contact_person->HrefValue = "";
            $this->contact_person->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";
            $this->booking_ref->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";
            $this->buyer_instruction->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // gst
            $this->gst->HrefValue = "";
            $this->gst->TooltipValue = "";

            // reports_to
            $this->reports_to->HrefValue = "";
            $this->reports_to->TooltipValue = "";

            // description_01
            $this->description_01->HrefValue = "";
            $this->description_01->TooltipValue = "";

            // description_02
            $this->description_02->HrefValue = "";
            $this->description_02->TooltipValue = "";

            // description_03
            $this->description_03->HrefValue = "";
            $this->description_03->TooltipValue = "";

            // description_04
            $this->description_04->HrefValue = "";
            $this->description_04->TooltipValue = "";

            // description_05
            $this->description_05->HrefValue = "";
            $this->description_05->TooltipValue = "";

            // description_06
            $this->description_06->HrefValue = "";
            $this->description_06->TooltipValue = "";

            // description_07
            $this->description_07->HrefValue = "";
            $this->description_07->TooltipValue = "";

            // description_08
            $this->description_08->HrefValue = "";
            $this->description_08->TooltipValue = "";

            // description_09
            $this->description_09->HrefValue = "";
            $this->description_09->TooltipValue = "";

            // description_10
            $this->description_10->HrefValue = "";
            $this->description_10->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // programme_datetime
            $this->programme_datetime->setupEditAttributes();
            $this->programme_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->programme_datetime->AdvancedSearch->SearchValue, $this->programme_datetime->formatPattern()), $this->programme_datetime->formatPattern()));
            $this->programme_datetime->PlaceHolder = RemoveHtml($this->programme_datetime->caption());

            // programme_end_datetime
            $this->programme_end_datetime->setupEditAttributes();
            $this->programme_end_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->programme_end_datetime->AdvancedSearch->SearchValue, $this->programme_end_datetime->formatPattern()), $this->programme_end_datetime->formatPattern()));
            $this->programme_end_datetime->PlaceHolder = RemoveHtml($this->programme_end_datetime->caption());
            $this->programme_end_datetime->setupEditAttributes();
            $this->programme_end_datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->programme_end_datetime->AdvancedSearch->SearchValue2, $this->programme_end_datetime->formatPattern()), $this->programme_end_datetime->formatPattern()));
            $this->programme_end_datetime->PlaceHolder = RemoveHtml($this->programme_end_datetime->caption());

            // location
            $this->location->setupEditAttributes();
            if (!$this->location->Raw) {
                $this->location->AdvancedSearch->SearchValue = HtmlDecode($this->location->AdvancedSearch->SearchValue);
            }
            $this->location->EditValue = HtmlEncode($this->location->AdvancedSearch->SearchValue);
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());
            $this->location->setupEditAttributes();
            if (!$this->location->Raw) {
                $this->location->AdvancedSearch->SearchValue2 = HtmlDecode($this->location->AdvancedSearch->SearchValue2);
            }
            $this->location->EditValue2 = HtmlEncode($this->location->AdvancedSearch->SearchValue2);
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // contact_person
            $this->contact_person->setupEditAttributes();
            if (!$this->contact_person->Raw) {
                $this->contact_person->AdvancedSearch->SearchValue = HtmlDecode($this->contact_person->AdvancedSearch->SearchValue);
            }
            $this->contact_person->EditValue = HtmlEncode($this->contact_person->AdvancedSearch->SearchValue);
            $this->contact_person->PlaceHolder = RemoveHtml($this->contact_person->caption());
            $this->contact_person->setupEditAttributes();
            if (!$this->contact_person->Raw) {
                $this->contact_person->AdvancedSearch->SearchValue2 = HtmlDecode($this->contact_person->AdvancedSearch->SearchValue2);
            }
            $this->contact_person->EditValue2 = HtmlEncode($this->contact_person->AdvancedSearch->SearchValue2);
            $this->contact_person->PlaceHolder = RemoveHtml($this->contact_person->caption());

            // amount
            $this->amount->setupEditAttributes();
            if (!$this->amount->Raw) {
                $this->amount->AdvancedSearch->SearchValue = HtmlDecode($this->amount->AdvancedSearch->SearchValue);
            }
            $this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // booking_ref
            $this->booking_ref->setupEditAttributes();
            if (!$this->booking_ref->Raw) {
                $this->booking_ref->AdvancedSearch->SearchValue = HtmlDecode($this->booking_ref->AdvancedSearch->SearchValue);
            }
            $this->booking_ref->EditValue = HtmlEncode($this->booking_ref->AdvancedSearch->SearchValue);
            $this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());
            $this->booking_ref->setupEditAttributes();
            if (!$this->booking_ref->Raw) {
                $this->booking_ref->AdvancedSearch->SearchValue2 = HtmlDecode($this->booking_ref->AdvancedSearch->SearchValue2);
            }
            $this->booking_ref->EditValue2 = HtmlEncode($this->booking_ref->AdvancedSearch->SearchValue2);
            $this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->AdvancedSearch->SearchValue;
            $curVal = strval($this->company_id->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->AdvancedSearch->SearchValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->options(true);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // buyer_instruction
            $this->buyer_instruction->setupEditAttributes();
            $this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->AdvancedSearch->SearchValue);
            $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // gst
            $this->gst->setupEditAttributes();
            $curVal = trim(strval($this->gst->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->gst->AdvancedSearch->ViewValue = $this->gst->lookupCacheOption($curVal);
            } else {
                $this->gst->AdvancedSearch->ViewValue = $this->gst->Lookup !== null && is_array($this->gst->lookupOptions()) && count($this->gst->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->gst->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->gst->EditValue = array_values($this->gst->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->gst->AdvancedSearch->SearchValue, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                $sqlWrk = $this->gst->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->gst->Lookup->renderViewRow($row);
                }
                $this->gst->EditValue = $arwrk;
            }
            $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

            // reports_to
            $this->reports_to->setupEditAttributes();
            $curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            } else {
                $this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== null && is_array($this->reports_to->lookupOptions()) && count($this->reports_to->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->reports_to->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->reports_to->EditValue = array_values($this->reports_to->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->reports_to->AdvancedSearch->SearchValue, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->reports_to->EditValue = $arwrk;
            }
            $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

            // description_01
            $curVal = trim(strval($this->description_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_01->AdvancedSearch->ViewValue = $this->description_01->lookupCacheOption($curVal);
            } else {
                $this->description_01->AdvancedSearch->ViewValue = $this->description_01->Lookup !== null && is_array($this->description_01->lookupOptions()) && count($this->description_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_01->EditValue = array_values($this->description_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_01->Lookup->renderViewRow($row);
                }
                $this->description_01->EditValue = $arwrk;
            }
            $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

            // description_02
            $curVal = trim(strval($this->description_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_02->AdvancedSearch->ViewValue = $this->description_02->lookupCacheOption($curVal);
            } else {
                $this->description_02->AdvancedSearch->ViewValue = $this->description_02->Lookup !== null && is_array($this->description_02->lookupOptions()) && count($this->description_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_02->EditValue = array_values($this->description_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_02->Lookup->renderViewRow($row);
                }
                $this->description_02->EditValue = $arwrk;
            }
            $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

            // description_03
            $curVal = trim(strval($this->description_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_03->AdvancedSearch->ViewValue = $this->description_03->lookupCacheOption($curVal);
            } else {
                $this->description_03->AdvancedSearch->ViewValue = $this->description_03->Lookup !== null && is_array($this->description_03->lookupOptions()) && count($this->description_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_03->EditValue = array_values($this->description_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_03->Lookup->renderViewRow($row);
                }
                $this->description_03->EditValue = $arwrk;
            }
            $this->description_03->PlaceHolder = RemoveHtml($this->description_03->caption());

            // description_04
            $curVal = trim(strval($this->description_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_04->AdvancedSearch->ViewValue = $this->description_04->lookupCacheOption($curVal);
            } else {
                $this->description_04->AdvancedSearch->ViewValue = $this->description_04->Lookup !== null && is_array($this->description_04->lookupOptions()) && count($this->description_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_04->EditValue = array_values($this->description_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_04->Lookup->renderViewRow($row);
                }
                $this->description_04->EditValue = $arwrk;
            }
            $this->description_04->PlaceHolder = RemoveHtml($this->description_04->caption());

            // description_05
            $curVal = trim(strval($this->description_05->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_05->AdvancedSearch->ViewValue = $this->description_05->lookupCacheOption($curVal);
            } else {
                $this->description_05->AdvancedSearch->ViewValue = $this->description_05->Lookup !== null && is_array($this->description_05->lookupOptions()) && count($this->description_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_05->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_05->EditValue = array_values($this->description_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_05->Lookup->renderViewRow($row);
                }
                $this->description_05->EditValue = $arwrk;
            }
            $this->description_05->PlaceHolder = RemoveHtml($this->description_05->caption());

            // description_06
            $curVal = trim(strval($this->description_06->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_06->AdvancedSearch->ViewValue = $this->description_06->lookupCacheOption($curVal);
            } else {
                $this->description_06->AdvancedSearch->ViewValue = $this->description_06->Lookup !== null && is_array($this->description_06->lookupOptions()) && count($this->description_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_06->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_06->EditValue = array_values($this->description_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_06->Lookup->renderViewRow($row);
                }
                $this->description_06->EditValue = $arwrk;
            }
            $this->description_06->PlaceHolder = RemoveHtml($this->description_06->caption());

            // description_07
            $curVal = trim(strval($this->description_07->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_07->AdvancedSearch->ViewValue = $this->description_07->lookupCacheOption($curVal);
            } else {
                $this->description_07->AdvancedSearch->ViewValue = $this->description_07->Lookup !== null && is_array($this->description_07->lookupOptions()) && count($this->description_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_07->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_07->EditValue = array_values($this->description_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_07->Lookup->renderViewRow($row);
                }
                $this->description_07->EditValue = $arwrk;
            }
            $this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

            // description_08
            $curVal = trim(strval($this->description_08->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_08->AdvancedSearch->ViewValue = $this->description_08->lookupCacheOption($curVal);
            } else {
                $this->description_08->AdvancedSearch->ViewValue = $this->description_08->Lookup !== null && is_array($this->description_08->lookupOptions()) && count($this->description_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_08->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_08->EditValue = array_values($this->description_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_08->Lookup->renderViewRow($row);
                }
                $this->description_08->EditValue = $arwrk;
            }
            $this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

            // description_09
            $curVal = trim(strval($this->description_09->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_09->AdvancedSearch->ViewValue = $this->description_09->lookupCacheOption($curVal);
            } else {
                $this->description_09->AdvancedSearch->ViewValue = $this->description_09->Lookup !== null && is_array($this->description_09->lookupOptions()) && count($this->description_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_09->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_09->EditValue = array_values($this->description_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_09->Lookup->renderViewRow($row);
                }
                $this->description_09->EditValue = $arwrk;
            }
            $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

            // description_10
            $curVal = trim(strval($this->description_10->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->description_10->AdvancedSearch->ViewValue = $this->description_10->lookupCacheOption($curVal);
            } else {
                $this->description_10->AdvancedSearch->ViewValue = $this->description_10->Lookup !== null && is_array($this->description_10->lookupOptions()) && count($this->description_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_10->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->description_10->EditValue = array_values($this->description_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_10->Lookup->renderViewRow($row);
                }
                $this->description_10->EditValue = $arwrk;
            }
            $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckDate($this->programme_datetime->AdvancedSearch->SearchValue, $this->programme_datetime->formatPattern())) {
            $this->programme_datetime->addErrorMessage($this->programme_datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->programme_end_datetime->AdvancedSearch->SearchValue, $this->programme_end_datetime->formatPattern())) {
            $this->programme_end_datetime->addErrorMessage($this->programme_end_datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->programme_end_datetime->AdvancedSearch->SearchValue2, $this->programme_end_datetime->formatPattern())) {
            $this->programme_end_datetime->addErrorMessage($this->programme_end_datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->company_id->AdvancedSearch->SearchValue)) {
            $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->programme_datetime->AdvancedSearch->load();
        $this->programme_end_datetime->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->contact_person->AdvancedSearch->load();
        $this->amount->AdvancedSearch->load();
        $this->booking_ref->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->type->AdvancedSearch->load();
        $this->buyer_instruction->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->gst->AdvancedSearch->load();
        $this->reports_to->AdvancedSearch->load();
        $this->description_01->AdvancedSearch->load();
        $this->description_02->AdvancedSearch->load();
        $this->description_03->AdvancedSearch->load();
        $this->description_04->AdvancedSearch->load();
        $this->description_05->AdvancedSearch->load();
        $this->description_06->AdvancedSearch->load();
        $this->description_07->AdvancedSearch->load();
        $this->description_08->AdvancedSearch->load();
        $this->description_09->AdvancedSearch->load();
        $this->description_10->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("rentalpolist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    break;
                case "x_item":
                    break;
                case "x_contact_person":
                    break;
                case "x_booking_ref":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_job_category":
                    break;
                case "x_type":
                    break;
                case "x_gst":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
