<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RentalPoAdd extends RentalPo
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RentalPoAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "rentalpoadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->programme_datetime->setVisibility();
        $this->programme_end_datetime->setVisibility();
        $this->location->setVisibility();
        $this->item->setVisibility();
        $this->contact_person->setVisibility();
        $this->amount->setVisibility();
        $this->booking_ref->setVisibility();
        $this->company_id->setVisibility();
        $this->payment_terms->setVisibility();
        $this->job_category->Visible = false;
        $this->type->setVisibility();
        $this->buyer_instruction->setVisibility();
        $this->remarks->setVisibility();
        $this->eastimated_amount->setVisibility();
        $this->gst->setVisibility();
        $this->uploads->setVisibility();
        $this->reports_to->Visible = false;
        $this->description_01->setVisibility();
        $this->description_02->setVisibility();
        $this->description_03->setVisibility();
        $this->description_04->setVisibility();
        $this->description_05->setVisibility();
        $this->description_06->setVisibility();
        $this->description_07->setVisibility();
        $this->description_08->setVisibility();
        $this->description_09->setVisibility();
        $this->description_10->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'rental_po';
        $this->TableName = 'rental_po';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (rental_po)
        if (!isset($GLOBALS["rental_po"]) || $GLOBALS["rental_po"]::class == PROJECT_NAMESPACE . "rental_po") {
            $GLOBALS["rental_po"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'rental_po');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "rentalpoview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
                $this->uploads->UploadPath = $this->uploads->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->payment_terms);
        $this->setupLookupOptions($this->job_category);
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->gst);
        $this->setupLookupOptions($this->reports_to);
        $this->setupLookupOptions($this->description_01);
        $this->setupLookupOptions($this->description_02);
        $this->setupLookupOptions($this->description_03);
        $this->setupLookupOptions($this->description_04);
        $this->setupLookupOptions($this->description_05);
        $this->setupLookupOptions($this->description_06);
        $this->setupLookupOptions($this->description_07);
        $this->setupLookupOptions($this->description_08);
        $this->setupLookupOptions($this->description_09);
        $this->setupLookupOptions($this->description_10);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->a_operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("rentalpolist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "rentalpolist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "rentalpoview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "rentalpolist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "rentalpolist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->uploads->Upload->Index = $CurrentForm->Index;
        $this->uploads->Upload->uploadFile();
        $this->uploads->CurrentValue = $this->uploads->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->programme_end_datetime->DefaultValue = $this->programme_end_datetime->getDefault(); // PHP
        $this->programme_end_datetime->OldValue = $this->programme_end_datetime->DefaultValue;
        $this->item->DefaultValue = $this->item->getDefault(); // PHP
        $this->item->OldValue = $this->item->DefaultValue;
        $this->amount->DefaultValue = $this->amount->getDefault(); // PHP
        $this->amount->OldValue = $this->amount->DefaultValue;
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->job_category->DefaultValue = $this->job_category->getDefault(); // PHP
        $this->job_category->OldValue = $this->job_category->DefaultValue;
        $this->type->DefaultValue = $this->type->getDefault(); // PHP
        $this->type->OldValue = $this->type->DefaultValue;
        $this->buyer_instruction->DefaultValue = $this->buyer_instruction->getDefault(); // PHP
        $this->buyer_instruction->OldValue = $this->buyer_instruction->DefaultValue;
        $this->remarks->DefaultValue = $this->remarks->getDefault(); // PHP
        $this->remarks->OldValue = $this->remarks->DefaultValue;
        $this->eastimated_amount->DefaultValue = $this->eastimated_amount->getDefault(); // PHP
        $this->eastimated_amount->OldValue = $this->eastimated_amount->DefaultValue;
        $this->gst->DefaultValue = $this->gst->getDefault(); // PHP
        $this->gst->OldValue = $this->gst->DefaultValue;
        $this->description_01->DefaultValue = $this->description_01->getDefault(); // PHP
        $this->description_01->OldValue = $this->description_01->DefaultValue;
        $this->description_02->DefaultValue = $this->description_02->getDefault(); // PHP
        $this->description_02->OldValue = $this->description_02->DefaultValue;
        $this->description_03->DefaultValue = $this->description_03->getDefault(); // PHP
        $this->description_03->OldValue = $this->description_03->DefaultValue;
        $this->description_04->DefaultValue = $this->description_04->getDefault(); // PHP
        $this->description_04->OldValue = $this->description_04->DefaultValue;
        $this->description_05->DefaultValue = $this->description_05->getDefault(); // PHP
        $this->description_05->OldValue = $this->description_05->DefaultValue;
        $this->description_06->DefaultValue = $this->description_06->getDefault(); // PHP
        $this->description_06->OldValue = $this->description_06->DefaultValue;
        $this->description_07->DefaultValue = $this->description_07->getDefault(); // PHP
        $this->description_07->OldValue = $this->description_07->DefaultValue;
        $this->description_08->DefaultValue = $this->description_08->getDefault(); // PHP
        $this->description_08->OldValue = $this->description_08->DefaultValue;
        $this->description_09->DefaultValue = $this->description_09->getDefault(); // PHP
        $this->description_09->OldValue = $this->description_09->DefaultValue;
        $this->description_10->DefaultValue = $this->description_10->getDefault(); // PHP
        $this->description_10->OldValue = $this->description_10->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'programme_datetime' first before field var 'x_programme_datetime'
        $val = $CurrentForm->hasValue("programme_datetime") ? $CurrentForm->getValue("programme_datetime") : $CurrentForm->getValue("x_programme_datetime");
        if (!$this->programme_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->programme_datetime->Visible = false; // Disable update for API request
            } else {
                $this->programme_datetime->setFormValue($val, true, $validate);
            }
            $this->programme_datetime->CurrentValue = UnFormatDateTime($this->programme_datetime->CurrentValue, $this->programme_datetime->formatPattern());
        }

        // Check field name 'programme_end_datetime' first before field var 'x_programme_end_datetime'
        $val = $CurrentForm->hasValue("programme_end_datetime") ? $CurrentForm->getValue("programme_end_datetime") : $CurrentForm->getValue("x_programme_end_datetime");
        if (!$this->programme_end_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->programme_end_datetime->Visible = false; // Disable update for API request
            } else {
                $this->programme_end_datetime->setFormValue($val, true, $validate);
            }
            $this->programme_end_datetime->CurrentValue = UnFormatDateTime($this->programme_end_datetime->CurrentValue, $this->programme_end_datetime->formatPattern());
        }

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'item' first before field var 'x_item'
        $val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
        if (!$this->item->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->item->Visible = false; // Disable update for API request
            } else {
                $this->item->setFormValue($val);
            }
        }

        // Check field name 'contact_person' first before field var 'x_contact_person'
        $val = $CurrentForm->hasValue("contact_person") ? $CurrentForm->getValue("contact_person") : $CurrentForm->getValue("x_contact_person");
        if (!$this->contact_person->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->contact_person->Visible = false; // Disable update for API request
            } else {
                $this->contact_person->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val);
            }
        }

        // Check field name 'booking_ref' first before field var 'x_booking_ref'
        $val = $CurrentForm->hasValue("booking_ref") ? $CurrentForm->getValue("booking_ref") : $CurrentForm->getValue("x_booking_ref");
        if (!$this->booking_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_ref->Visible = false; // Disable update for API request
            } else {
                $this->booking_ref->setFormValue($val);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'payment_terms' first before field var 'x_payment_terms'
        $val = $CurrentForm->hasValue("payment_terms") ? $CurrentForm->getValue("payment_terms") : $CurrentForm->getValue("x_payment_terms");
        if (!$this->payment_terms->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->payment_terms->Visible = false; // Disable update for API request
            } else {
                $this->payment_terms->setFormValue($val);
            }
        }

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'buyer_instruction' first before field var 'x_buyer_instruction'
        $val = $CurrentForm->hasValue("buyer_instruction") ? $CurrentForm->getValue("buyer_instruction") : $CurrentForm->getValue("x_buyer_instruction");
        if (!$this->buyer_instruction->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->buyer_instruction->Visible = false; // Disable update for API request
            } else {
                $this->buyer_instruction->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'eastimated_amount' first before field var 'x_eastimated_amount'
        $val = $CurrentForm->hasValue("eastimated_amount") ? $CurrentForm->getValue("eastimated_amount") : $CurrentForm->getValue("x_eastimated_amount");
        if (!$this->eastimated_amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->eastimated_amount->Visible = false; // Disable update for API request
            } else {
                $this->eastimated_amount->setFormValue($val);
            }
        }

        // Check field name 'gst' first before field var 'x_gst'
        $val = $CurrentForm->hasValue("gst") ? $CurrentForm->getValue("gst") : $CurrentForm->getValue("x_gst");
        if (!$this->gst->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gst->Visible = false; // Disable update for API request
            } else {
                $this->gst->setFormValue($val);
            }
        }

        // Check field name 'description_01' first before field var 'x_description_01'
        $val = $CurrentForm->hasValue("description_01") ? $CurrentForm->getValue("description_01") : $CurrentForm->getValue("x_description_01");
        if (!$this->description_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_01->Visible = false; // Disable update for API request
            } else {
                $this->description_01->setFormValue($val);
            }
        }

        // Check field name 'description_02' first before field var 'x_description_02'
        $val = $CurrentForm->hasValue("description_02") ? $CurrentForm->getValue("description_02") : $CurrentForm->getValue("x_description_02");
        if (!$this->description_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_02->Visible = false; // Disable update for API request
            } else {
                $this->description_02->setFormValue($val);
            }
        }

        // Check field name 'description_03' first before field var 'x_description_03'
        $val = $CurrentForm->hasValue("description_03") ? $CurrentForm->getValue("description_03") : $CurrentForm->getValue("x_description_03");
        if (!$this->description_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_03->Visible = false; // Disable update for API request
            } else {
                $this->description_03->setFormValue($val);
            }
        }

        // Check field name 'description_04' first before field var 'x_description_04'
        $val = $CurrentForm->hasValue("description_04") ? $CurrentForm->getValue("description_04") : $CurrentForm->getValue("x_description_04");
        if (!$this->description_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_04->Visible = false; // Disable update for API request
            } else {
                $this->description_04->setFormValue($val);
            }
        }

        // Check field name 'description_05' first before field var 'x_description_05'
        $val = $CurrentForm->hasValue("description_05") ? $CurrentForm->getValue("description_05") : $CurrentForm->getValue("x_description_05");
        if (!$this->description_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_05->Visible = false; // Disable update for API request
            } else {
                $this->description_05->setFormValue($val);
            }
        }

        // Check field name 'description_06' first before field var 'x_description_06'
        $val = $CurrentForm->hasValue("description_06") ? $CurrentForm->getValue("description_06") : $CurrentForm->getValue("x_description_06");
        if (!$this->description_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_06->Visible = false; // Disable update for API request
            } else {
                $this->description_06->setFormValue($val);
            }
        }

        // Check field name 'description_07' first before field var 'x_description_07'
        $val = $CurrentForm->hasValue("description_07") ? $CurrentForm->getValue("description_07") : $CurrentForm->getValue("x_description_07");
        if (!$this->description_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_07->Visible = false; // Disable update for API request
            } else {
                $this->description_07->setFormValue($val);
            }
        }

        // Check field name 'description_08' first before field var 'x_description_08'
        $val = $CurrentForm->hasValue("description_08") ? $CurrentForm->getValue("description_08") : $CurrentForm->getValue("x_description_08");
        if (!$this->description_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_08->Visible = false; // Disable update for API request
            } else {
                $this->description_08->setFormValue($val);
            }
        }

        // Check field name 'description_09' first before field var 'x_description_09'
        $val = $CurrentForm->hasValue("description_09") ? $CurrentForm->getValue("description_09") : $CurrentForm->getValue("x_description_09");
        if (!$this->description_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_09->Visible = false; // Disable update for API request
            } else {
                $this->description_09->setFormValue($val);
            }
        }

        // Check field name 'description_10' first before field var 'x_description_10'
        $val = $CurrentForm->hasValue("description_10") ? $CurrentForm->getValue("description_10") : $CurrentForm->getValue("x_description_10");
        if (!$this->description_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->description_10->Visible = false; // Disable update for API request
            } else {
                $this->description_10->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
		$this->uploads->UploadPath = $this->uploads->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->programme_datetime->CurrentValue = $this->programme_datetime->FormValue;
        $this->programme_datetime->CurrentValue = UnFormatDateTime($this->programme_datetime->CurrentValue, $this->programme_datetime->formatPattern());
        $this->programme_end_datetime->CurrentValue = $this->programme_end_datetime->FormValue;
        $this->programme_end_datetime->CurrentValue = UnFormatDateTime($this->programme_end_datetime->CurrentValue, $this->programme_end_datetime->formatPattern());
        $this->location->CurrentValue = $this->location->FormValue;
        $this->item->CurrentValue = $this->item->FormValue;
        $this->contact_person->CurrentValue = $this->contact_person->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->booking_ref->CurrentValue = $this->booking_ref->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->payment_terms->CurrentValue = $this->payment_terms->FormValue;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->buyer_instruction->CurrentValue = $this->buyer_instruction->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->eastimated_amount->CurrentValue = $this->eastimated_amount->FormValue;
        $this->gst->CurrentValue = $this->gst->FormValue;
        $this->description_01->CurrentValue = $this->description_01->FormValue;
        $this->description_02->CurrentValue = $this->description_02->FormValue;
        $this->description_03->CurrentValue = $this->description_03->FormValue;
        $this->description_04->CurrentValue = $this->description_04->FormValue;
        $this->description_05->CurrentValue = $this->description_05->FormValue;
        $this->description_06->CurrentValue = $this->description_06->FormValue;
        $this->description_07->CurrentValue = $this->description_07->FormValue;
        $this->description_08->CurrentValue = $this->description_08->FormValue;
        $this->description_09->CurrentValue = $this->description_09->FormValue;
        $this->description_10->CurrentValue = $this->description_10->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->programme_datetime->setDbValue($row['programme_datetime']);
        $this->programme_end_datetime->setDbValue($row['programme_end_datetime']);
        $this->location->setDbValue($row['location']);
        if (array_key_exists('EV__location', $row)) {
            $this->location->VirtualValue = $row['EV__location']; // Set up virtual field value
        } else {
            $this->location->VirtualValue = ""; // Clear value
        }
        $this->item->setDbValue($row['item']);
        $this->contact_person->setDbValue($row['contact_person']);
        if (array_key_exists('EV__contact_person', $row)) {
            $this->contact_person->VirtualValue = $row['EV__contact_person']; // Set up virtual field value
        } else {
            $this->contact_person->VirtualValue = ""; // Clear value
        }
        $this->amount->setDbValue($row['amount']);
        $this->booking_ref->setDbValue($row['booking_ref']);
        if (array_key_exists('EV__booking_ref', $row)) {
            $this->booking_ref->VirtualValue = $row['EV__booking_ref']; // Set up virtual field value
        } else {
            $this->booking_ref->VirtualValue = ""; // Clear value
        }
        $this->company_id->setDbValue($row['company_id']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->job_category->setDbValue($row['job_category']);
        $this->type->setDbValue($row['type']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->remarks->setDbValue($row['remarks']);
        $this->eastimated_amount->setDbValue($row['eastimated_amount']);
        $this->gst->setDbValue($row['gst']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->uploads->setDbValue($this->uploads->Upload->DbValue);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_08->setDbValue($row['description_08']);
        $this->description_09->setDbValue($row['description_09']);
        $this->description_10->setDbValue($row['description_10']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['programme_datetime'] = $this->programme_datetime->DefaultValue;
        $row['programme_end_datetime'] = $this->programme_end_datetime->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['item'] = $this->item->DefaultValue;
        $row['contact_person'] = $this->contact_person->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['booking_ref'] = $this->booking_ref->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['payment_terms'] = $this->payment_terms->DefaultValue;
        $row['job_category'] = $this->job_category->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['buyer_instruction'] = $this->buyer_instruction->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['eastimated_amount'] = $this->eastimated_amount->DefaultValue;
        $row['gst'] = $this->gst->DefaultValue;
        $row['uploads'] = $this->uploads->DefaultValue;
        $row['reports_to'] = $this->reports_to->DefaultValue;
        $row['description_01'] = $this->description_01->DefaultValue;
        $row['description_02'] = $this->description_02->DefaultValue;
        $row['description_03'] = $this->description_03->DefaultValue;
        $row['description_04'] = $this->description_04->DefaultValue;
        $row['description_05'] = $this->description_05->DefaultValue;
        $row['description_06'] = $this->description_06->DefaultValue;
        $row['description_07'] = $this->description_07->DefaultValue;
        $row['description_08'] = $this->description_08->DefaultValue;
        $row['description_09'] = $this->description_09->DefaultValue;
        $row['description_10'] = $this->description_10->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // programme_datetime
        $this->programme_datetime->RowCssClass = "row";

        // programme_end_datetime
        $this->programme_end_datetime->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // item
        $this->item->RowCssClass = "row";

        // contact_person
        $this->contact_person->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // booking_ref
        $this->booking_ref->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // payment_terms
        $this->payment_terms->RowCssClass = "row";

        // job_category
        $this->job_category->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // buyer_instruction
        $this->buyer_instruction->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // eastimated_amount
        $this->eastimated_amount->RowCssClass = "row";

        // gst
        $this->gst->RowCssClass = "row";

        // uploads
        $this->uploads->RowCssClass = "row";

        // reports_to
        $this->reports_to->RowCssClass = "row";

        // description_01
        $this->description_01->RowCssClass = "row";

        // description_02
        $this->description_02->RowCssClass = "row";

        // description_03
        $this->description_03->RowCssClass = "row";

        // description_04
        $this->description_04->RowCssClass = "row";

        // description_05
        $this->description_05->RowCssClass = "row";

        // description_06
        $this->description_06->RowCssClass = "row";

        // description_07
        $this->description_07->RowCssClass = "row";

        // description_08
        $this->description_08->RowCssClass = "row";

        // description_09
        $this->description_09->RowCssClass = "row";

        // description_10
        $this->description_10->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // programme_datetime
            $this->programme_datetime->ViewValue = $this->programme_datetime->CurrentValue;
            $this->programme_datetime->ViewValue = FormatDateTime($this->programme_datetime->ViewValue, $this->programme_datetime->formatPattern());

            // programme_end_datetime
            $this->programme_end_datetime->ViewValue = $this->programme_end_datetime->CurrentValue;
            $this->programme_end_datetime->ViewValue = FormatDateTime($this->programme_end_datetime->ViewValue, $this->programme_end_datetime->formatPattern());

            // location
            if ($this->location->VirtualValue != "") {
                $this->location->ViewValue = $this->location->VirtualValue;
            } else {
                $this->location->ViewValue = $this->location->CurrentValue;
            }

            // item
            $this->item->ViewValue = $this->item->CurrentValue;

            // contact_person
            if ($this->contact_person->VirtualValue != "") {
                $this->contact_person->ViewValue = $this->contact_person->VirtualValue;
            } else {
                $this->contact_person->ViewValue = $this->contact_person->CurrentValue;
            }

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;

            // booking_ref
            if ($this->booking_ref->VirtualValue != "") {
                $this->booking_ref->ViewValue = $this->booking_ref->VirtualValue;
            } else {
                $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
            }

            // company_id
            $this->company_id->ViewValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // payment_terms
            $curVal = strval($this->payment_terms->CurrentValue);
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
                if ($this->payment_terms->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                    $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                        $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                    } else {
                        $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                    }
                }
            } else {
                $this->payment_terms->ViewValue = null;
            }

            // type
            if (strval($this->type->CurrentValue) != "") {
                $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
            } else {
                $this->type->ViewValue = null;
            }

            // buyer_instruction
            $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // eastimated_amount
            $this->eastimated_amount->ViewValue = $this->eastimated_amount->CurrentValue;
            $this->eastimated_amount->ViewValue = FormatNumber($this->eastimated_amount->ViewValue, $this->eastimated_amount->formatPattern());

            // gst
            $curVal = strval($this->gst->CurrentValue);
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
                if ($this->gst->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                    $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                        $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                    } else {
                        $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                    }
                }
            } else {
                $this->gst->ViewValue = null;
            }

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->ViewValue = "";
            }
            $this->uploads->CssClass = "fst-italic";

            // reports_to
            $curVal = strval($this->reports_to->CurrentValue);
            if ($curVal != "") {
                $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
                if ($this->reports_to->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                    $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                        $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                    } else {
                        $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                    }
                }
            } else {
                $this->reports_to->ViewValue = null;
            }

            // description_01
            $curVal = strval($this->description_01->CurrentValue);
            if ($curVal != "") {
                $this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
                if ($this->description_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_01->Lookup->renderViewRow($row);
                            $this->description_01->ViewValue->add($this->description_01->displayValue($arwrk));
                        }
                    } else {
                        $this->description_01->ViewValue = $this->description_01->CurrentValue;
                    }
                }
            } else {
                $this->description_01->ViewValue = null;
            }

            // description_02
            $curVal = strval($this->description_02->CurrentValue);
            if ($curVal != "") {
                $this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
                if ($this->description_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_02->Lookup->renderViewRow($row);
                            $this->description_02->ViewValue->add($this->description_02->displayValue($arwrk));
                        }
                    } else {
                        $this->description_02->ViewValue = $this->description_02->CurrentValue;
                    }
                }
            } else {
                $this->description_02->ViewValue = null;
            }

            // description_03
            $curVal = strval($this->description_03->CurrentValue);
            if ($curVal != "") {
                $this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
                if ($this->description_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_03->Lookup->renderViewRow($row);
                            $this->description_03->ViewValue->add($this->description_03->displayValue($arwrk));
                        }
                    } else {
                        $this->description_03->ViewValue = $this->description_03->CurrentValue;
                    }
                }
            } else {
                $this->description_03->ViewValue = null;
            }

            // description_04
            $curVal = strval($this->description_04->CurrentValue);
            if ($curVal != "") {
                $this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
                if ($this->description_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_04->Lookup->renderViewRow($row);
                            $this->description_04->ViewValue->add($this->description_04->displayValue($arwrk));
                        }
                    } else {
                        $this->description_04->ViewValue = $this->description_04->CurrentValue;
                    }
                }
            } else {
                $this->description_04->ViewValue = null;
            }

            // description_05
            $curVal = strval($this->description_05->CurrentValue);
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
                if ($this->description_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_05->Lookup->renderViewRow($row);
                            $this->description_05->ViewValue->add($this->description_05->displayValue($arwrk));
                        }
                    } else {
                        $this->description_05->ViewValue = $this->description_05->CurrentValue;
                    }
                }
            } else {
                $this->description_05->ViewValue = null;
            }

            // description_06
            $curVal = strval($this->description_06->CurrentValue);
            if ($curVal != "") {
                $this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
                if ($this->description_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_06->Lookup->renderViewRow($row);
                            $this->description_06->ViewValue->add($this->description_06->displayValue($arwrk));
                        }
                    } else {
                        $this->description_06->ViewValue = $this->description_06->CurrentValue;
                    }
                }
            } else {
                $this->description_06->ViewValue = null;
            }

            // description_07
            $curVal = strval($this->description_07->CurrentValue);
            if ($curVal != "") {
                $this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
                if ($this->description_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_07->Lookup->renderViewRow($row);
                            $this->description_07->ViewValue->add($this->description_07->displayValue($arwrk));
                        }
                    } else {
                        $this->description_07->ViewValue = $this->description_07->CurrentValue;
                    }
                }
            } else {
                $this->description_07->ViewValue = null;
            }

            // description_08
            $curVal = strval($this->description_08->CurrentValue);
            if ($curVal != "") {
                $this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
                if ($this->description_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_08->Lookup->renderViewRow($row);
                            $this->description_08->ViewValue->add($this->description_08->displayValue($arwrk));
                        }
                    } else {
                        $this->description_08->ViewValue = $this->description_08->CurrentValue;
                    }
                }
            } else {
                $this->description_08->ViewValue = null;
            }

            // description_09
            $curVal = strval($this->description_09->CurrentValue);
            if ($curVal != "") {
                $this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
                if ($this->description_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_09->Lookup->renderViewRow($row);
                            $this->description_09->ViewValue->add($this->description_09->displayValue($arwrk));
                        }
                    } else {
                        $this->description_09->ViewValue = $this->description_09->CurrentValue;
                    }
                }
            } else {
                $this->description_09->ViewValue = null;
            }

            // description_10
            $curVal = strval($this->description_10->CurrentValue);
            if ($curVal != "") {
                $this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
                if ($this->description_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->description_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->description_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->description_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->description_10->Lookup->renderViewRow($row);
                            $this->description_10->ViewValue->add($this->description_10->displayValue($arwrk));
                        }
                    } else {
                        $this->description_10->ViewValue = $this->description_10->CurrentValue;
                    }
                }
            } else {
                $this->description_10->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // programme_datetime
            $this->programme_datetime->HrefValue = "";

            // programme_end_datetime
            $this->programme_end_datetime->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // item
            $this->item->HrefValue = "";

            // contact_person
            $this->contact_person->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // payment_terms
            if (!EmptyValue($this->payment_terms->CurrentValue)) {
                $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
                $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
                }
            } else {
                $this->payment_terms->HrefValue = "";
            }

            // type
            $this->type->HrefValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // eastimated_amount
            $this->eastimated_amount->HrefValue = "";

            // gst
            $this->gst->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // description_01
            $this->description_01->HrefValue = "";

            // description_02
            $this->description_02->HrefValue = "";

            // description_03
            $this->description_03->HrefValue = "";

            // description_04
            $this->description_04->HrefValue = "";

            // description_05
            $this->description_05->HrefValue = "";

            // description_06
            $this->description_06->HrefValue = "";

            // description_07
            $this->description_07->HrefValue = "";

            // description_08
            $this->description_08->HrefValue = "";

            // description_09
            $this->description_09->HrefValue = "";

            // description_10
            $this->description_10->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // programme_datetime
            $this->programme_datetime->setupEditAttributes();
            $this->programme_datetime->EditValue = HtmlEncode(FormatDateTime($this->programme_datetime->CurrentValue, $this->programme_datetime->formatPattern()));
            $this->programme_datetime->PlaceHolder = RemoveHtml($this->programme_datetime->caption());

            // programme_end_datetime
            $this->programme_end_datetime->setupEditAttributes();
            $this->programme_end_datetime->EditValue = HtmlEncode(FormatDateTime($this->programme_end_datetime->CurrentValue, $this->programme_end_datetime->formatPattern()));
            $this->programme_end_datetime->PlaceHolder = RemoveHtml($this->programme_end_datetime->caption());

            // location
            $this->location->setupEditAttributes();
            if (!$this->location->Raw) {
                $this->location->CurrentValue = HtmlDecode($this->location->CurrentValue);
            }
            $this->location->EditValue = HtmlEncode($this->location->CurrentValue);
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // item
            $this->item->setupEditAttributes();
            if (!$this->item->Raw) {
                $this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
            }
            $this->item->EditValue = HtmlEncode($this->item->CurrentValue);
            $arwrk = [];
            $arwrk["lf"] = $this->item->CurrentValue;
            $arwrk["df"] = $this->item->CurrentValue;
            $arwrk = $this->item->Lookup->renderViewRow($arwrk, $this);
            $dispVal = $this->item->displayValue($arwrk);
            if ($dispVal != "") {
                $this->item->EditValue = $dispVal;
            }
            $this->item->PlaceHolder = RemoveHtml($this->item->caption());

            // contact_person
            $this->contact_person->setupEditAttributes();
            if (!$this->contact_person->Raw) {
                $this->contact_person->CurrentValue = HtmlDecode($this->contact_person->CurrentValue);
            }
            $this->contact_person->EditValue = HtmlEncode($this->contact_person->CurrentValue);
            $this->contact_person->PlaceHolder = RemoveHtml($this->contact_person->caption());

            // amount
            $this->amount->setupEditAttributes();
            if (!$this->amount->Raw) {
                $this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
            }
            $this->amount->EditValue = HtmlEncode($this->amount->CurrentValue);
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

            // booking_ref
            $this->booking_ref->setupEditAttributes();
            if (!$this->booking_ref->Raw) {
                $this->booking_ref->CurrentValue = HtmlDecode($this->booking_ref->CurrentValue);
            }
            $this->booking_ref->EditValue = HtmlEncode($this->booking_ref->CurrentValue);
            $this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $this->company_id->EditValue = $this->company_id->CurrentValue;
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = HtmlEncode(FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern()));
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // payment_terms
            $this->payment_terms->setupEditAttributes();
            $curVal = trim(strval($this->payment_terms->CurrentValue));
            if ($curVal != "") {
                $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            } else {
                $this->payment_terms->ViewValue = $this->payment_terms->Lookup !== null && is_array($this->payment_terms->lookupOptions()) && count($this->payment_terms->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->payment_terms->ViewValue !== null) { // Load from cache
                $this->payment_terms->EditValue = array_values($this->payment_terms->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->payment_terms->CurrentValue, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->payment_terms->EditValue = $arwrk;
            }
            $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

            // type
            $this->type->setupEditAttributes();
            $this->type->EditValue = $this->type->options(true);
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // buyer_instruction
            $this->buyer_instruction->setupEditAttributes();
            $this->buyer_instruction->EditValue = HtmlEncode($this->buyer_instruction->CurrentValue);
            $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // eastimated_amount
            $this->eastimated_amount->setupEditAttributes();
            $this->eastimated_amount->EditCustomAttributes = $this->eastimated_amount->getEditCustomAttributes(); // PHP
            $this->eastimated_amount->EditValue = $this->eastimated_amount->CurrentValue;
            $this->eastimated_amount->PlaceHolder = RemoveHtml($this->eastimated_amount->caption());
            if (strval($this->eastimated_amount->EditValue) != "" && is_numeric($this->eastimated_amount->EditValue)) {
                $this->eastimated_amount->EditValue = FormatNumber($this->eastimated_amount->EditValue, null);
            }

            // gst
            $this->gst->setupEditAttributes();
            $curVal = trim(strval($this->gst->CurrentValue));
            if ($curVal != "") {
                $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
            } else {
                $this->gst->ViewValue = $this->gst->Lookup !== null && is_array($this->gst->lookupOptions()) && count($this->gst->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->gst->ViewValue !== null) { // Load from cache
                $this->gst->EditValue = array_values($this->gst->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->gst->CurrentValue, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                $sqlWrk = $this->gst->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->gst->Lookup->renderViewRow($row);
                }
                $this->gst->EditValue = $arwrk;
            }
            $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

            // uploads
            $this->uploads->setupEditAttributes();
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->ImageWidth = 0;
                $this->uploads->ImageHeight = 50;
                $this->uploads->ImageAlt = $this->uploads->alt();
                $this->uploads->ImageCssClass = "ew-image";
                $this->uploads->EditValue = $this->uploads->Upload->DbValue;
            } else {
                $this->uploads->EditValue = "";
            }
            if (!EmptyValue($this->uploads->CurrentValue)) {
                $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->uploads->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->uploads);
            }

            // description_01
            $curVal = trim(strval($this->description_01->CurrentValue));
            if ($curVal != "") {
                $this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
            } else {
                $this->description_01->ViewValue = $this->description_01->Lookup !== null && is_array($this->description_01->lookupOptions()) && count($this->description_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_01->ViewValue !== null) { // Load from cache
                $this->description_01->EditValue = array_values($this->description_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_01->Lookup->renderViewRow($row);
                }
                $this->description_01->EditValue = $arwrk;
            }
            $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

            // description_02
            $curVal = trim(strval($this->description_02->CurrentValue));
            if ($curVal != "") {
                $this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
            } else {
                $this->description_02->ViewValue = $this->description_02->Lookup !== null && is_array($this->description_02->lookupOptions()) && count($this->description_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_02->ViewValue !== null) { // Load from cache
                $this->description_02->EditValue = array_values($this->description_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_02->Lookup->renderViewRow($row);
                }
                $this->description_02->EditValue = $arwrk;
            }
            $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

            // description_03
            $curVal = trim(strval($this->description_03->CurrentValue));
            if ($curVal != "") {
                $this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
            } else {
                $this->description_03->ViewValue = $this->description_03->Lookup !== null && is_array($this->description_03->lookupOptions()) && count($this->description_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_03->ViewValue !== null) { // Load from cache
                $this->description_03->EditValue = array_values($this->description_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_03->Lookup->renderViewRow($row);
                }
                $this->description_03->EditValue = $arwrk;
            }
            $this->description_03->PlaceHolder = RemoveHtml($this->description_03->caption());

            // description_04
            $curVal = trim(strval($this->description_04->CurrentValue));
            if ($curVal != "") {
                $this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
            } else {
                $this->description_04->ViewValue = $this->description_04->Lookup !== null && is_array($this->description_04->lookupOptions()) && count($this->description_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_04->ViewValue !== null) { // Load from cache
                $this->description_04->EditValue = array_values($this->description_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_04->Lookup->renderViewRow($row);
                }
                $this->description_04->EditValue = $arwrk;
            }
            $this->description_04->PlaceHolder = RemoveHtml($this->description_04->caption());

            // description_05
            $curVal = trim(strval($this->description_05->CurrentValue));
            if ($curVal != "") {
                $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
            } else {
                $this->description_05->ViewValue = $this->description_05->Lookup !== null && is_array($this->description_05->lookupOptions()) && count($this->description_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_05->ViewValue !== null) { // Load from cache
                $this->description_05->EditValue = array_values($this->description_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_05->Lookup->renderViewRow($row);
                }
                $this->description_05->EditValue = $arwrk;
            }
            $this->description_05->PlaceHolder = RemoveHtml($this->description_05->caption());

            // description_06
            $curVal = trim(strval($this->description_06->CurrentValue));
            if ($curVal != "") {
                $this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
            } else {
                $this->description_06->ViewValue = $this->description_06->Lookup !== null && is_array($this->description_06->lookupOptions()) && count($this->description_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_06->ViewValue !== null) { // Load from cache
                $this->description_06->EditValue = array_values($this->description_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_06->Lookup->renderViewRow($row);
                }
                $this->description_06->EditValue = $arwrk;
            }
            $this->description_06->PlaceHolder = RemoveHtml($this->description_06->caption());

            // description_07
            $curVal = trim(strval($this->description_07->CurrentValue));
            if ($curVal != "") {
                $this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
            } else {
                $this->description_07->ViewValue = $this->description_07->Lookup !== null && is_array($this->description_07->lookupOptions()) && count($this->description_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_07->ViewValue !== null) { // Load from cache
                $this->description_07->EditValue = array_values($this->description_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_07->Lookup->renderViewRow($row);
                }
                $this->description_07->EditValue = $arwrk;
            }
            $this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

            // description_08
            $curVal = trim(strval($this->description_08->CurrentValue));
            if ($curVal != "") {
                $this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
            } else {
                $this->description_08->ViewValue = $this->description_08->Lookup !== null && is_array($this->description_08->lookupOptions()) && count($this->description_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_08->ViewValue !== null) { // Load from cache
                $this->description_08->EditValue = array_values($this->description_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_08->Lookup->renderViewRow($row);
                }
                $this->description_08->EditValue = $arwrk;
            }
            $this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

            // description_09
            $curVal = trim(strval($this->description_09->CurrentValue));
            if ($curVal != "") {
                $this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
            } else {
                $this->description_09->ViewValue = $this->description_09->Lookup !== null && is_array($this->description_09->lookupOptions()) && count($this->description_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_09->ViewValue !== null) { // Load from cache
                $this->description_09->EditValue = array_values($this->description_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_09->Lookup->renderViewRow($row);
                }
                $this->description_09->EditValue = $arwrk;
            }
            $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

            // description_10
            $curVal = trim(strval($this->description_10->CurrentValue));
            if ($curVal != "") {
                $this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
            } else {
                $this->description_10->ViewValue = $this->description_10->Lookup !== null && is_array($this->description_10->lookupOptions()) && count($this->description_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->description_10->ViewValue !== null) { // Load from cache
                $this->description_10->EditValue = array_values($this->description_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->description_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->description_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->description_10->Lookup->renderViewRow($row);
                }
                $this->description_10->EditValue = $arwrk;
            }
            $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

            // operator

            // datetime

            // Add refer script

            // programme_datetime
            $this->programme_datetime->HrefValue = "";

            // programme_end_datetime
            $this->programme_end_datetime->HrefValue = "";

            // location
            $this->location->HrefValue = "";

            // item
            $this->item->HrefValue = "";

            // contact_person
            $this->contact_person->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // booking_ref
            $this->booking_ref->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // payment_terms
            if (!EmptyValue($this->payment_terms->CurrentValue)) {
                $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
                $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
                }
            } else {
                $this->payment_terms->HrefValue = "";
            }

            // type
            $this->type->HrefValue = "";

            // buyer_instruction
            $this->buyer_instruction->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // eastimated_amount
            $this->eastimated_amount->HrefValue = "";

            // gst
            $this->gst->HrefValue = "";

            // uploads
            $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
            if (!EmptyValue($this->uploads->Upload->DbValue)) {
                $this->uploads->HrefValue = "%u"; // Add prefix/suffix
                $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
                }
            } else {
                $this->uploads->HrefValue = "";
            }
            $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

            // description_01
            $this->description_01->HrefValue = "";

            // description_02
            $this->description_02->HrefValue = "";

            // description_03
            $this->description_03->HrefValue = "";

            // description_04
            $this->description_04->HrefValue = "";

            // description_05
            $this->description_05->HrefValue = "";

            // description_06
            $this->description_06->HrefValue = "";

            // description_07
            $this->description_07->HrefValue = "";

            // description_08
            $this->description_08->HrefValue = "";

            // description_09
            $this->description_09->HrefValue = "";

            // description_10
            $this->description_10->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->programme_datetime->Visible && $this->programme_datetime->Required) {
                if (!$this->programme_datetime->IsDetailKey && EmptyValue($this->programme_datetime->FormValue)) {
                    $this->programme_datetime->addErrorMessage(str_replace("%s", $this->programme_datetime->caption(), $this->programme_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->programme_datetime->FormValue, $this->programme_datetime->formatPattern())) {
                $this->programme_datetime->addErrorMessage($this->programme_datetime->getErrorMessage(false));
            }
            if ($this->programme_end_datetime->Visible && $this->programme_end_datetime->Required) {
                if (!$this->programme_end_datetime->IsDetailKey && EmptyValue($this->programme_end_datetime->FormValue)) {
                    $this->programme_end_datetime->addErrorMessage(str_replace("%s", $this->programme_end_datetime->caption(), $this->programme_end_datetime->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->programme_end_datetime->FormValue, $this->programme_end_datetime->formatPattern())) {
                $this->programme_end_datetime->addErrorMessage($this->programme_end_datetime->getErrorMessage(false));
            }
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->item->Visible && $this->item->Required) {
                if (!$this->item->IsDetailKey && EmptyValue($this->item->FormValue)) {
                    $this->item->addErrorMessage(str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
                }
            }
            if ($this->contact_person->Visible && $this->contact_person->Required) {
                if (!$this->contact_person->IsDetailKey && EmptyValue($this->contact_person->FormValue)) {
                    $this->contact_person->addErrorMessage(str_replace("%s", $this->contact_person->caption(), $this->contact_person->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if ($this->booking_ref->Visible && $this->booking_ref->Required) {
                if (!$this->booking_ref->IsDetailKey && EmptyValue($this->booking_ref->FormValue)) {
                    $this->booking_ref->addErrorMessage(str_replace("%s", $this->booking_ref->caption(), $this->booking_ref->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->company_id->FormValue)) {
                $this->company_id->addErrorMessage($this->company_id->getErrorMessage(false));
            }
            if ($this->payment_terms->Visible && $this->payment_terms->Required) {
                if (!$this->payment_terms->IsDetailKey && EmptyValue($this->payment_terms->FormValue)) {
                    $this->payment_terms->addErrorMessage(str_replace("%s", $this->payment_terms->caption(), $this->payment_terms->RequiredErrorMessage));
                }
            }
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->buyer_instruction->Visible && $this->buyer_instruction->Required) {
                if (!$this->buyer_instruction->IsDetailKey && EmptyValue($this->buyer_instruction->FormValue)) {
                    $this->buyer_instruction->addErrorMessage(str_replace("%s", $this->buyer_instruction->caption(), $this->buyer_instruction->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->eastimated_amount->Visible && $this->eastimated_amount->Required) {
                if (!$this->eastimated_amount->IsDetailKey && EmptyValue($this->eastimated_amount->FormValue)) {
                    $this->eastimated_amount->addErrorMessage(str_replace("%s", $this->eastimated_amount->caption(), $this->eastimated_amount->RequiredErrorMessage));
                }
            }
            if ($this->gst->Visible && $this->gst->Required) {
                if (!$this->gst->IsDetailKey && EmptyValue($this->gst->FormValue)) {
                    $this->gst->addErrorMessage(str_replace("%s", $this->gst->caption(), $this->gst->RequiredErrorMessage));
                }
            }
            if ($this->uploads->Visible && $this->uploads->Required) {
                if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->addErrorMessage(str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
                }
            }
            if ($this->description_01->Visible && $this->description_01->Required) {
                if ($this->description_01->FormValue == "") {
                    $this->description_01->addErrorMessage(str_replace("%s", $this->description_01->caption(), $this->description_01->RequiredErrorMessage));
                }
            }
            if ($this->description_02->Visible && $this->description_02->Required) {
                if ($this->description_02->FormValue == "") {
                    $this->description_02->addErrorMessage(str_replace("%s", $this->description_02->caption(), $this->description_02->RequiredErrorMessage));
                }
            }
            if ($this->description_03->Visible && $this->description_03->Required) {
                if ($this->description_03->FormValue == "") {
                    $this->description_03->addErrorMessage(str_replace("%s", $this->description_03->caption(), $this->description_03->RequiredErrorMessage));
                }
            }
            if ($this->description_04->Visible && $this->description_04->Required) {
                if ($this->description_04->FormValue == "") {
                    $this->description_04->addErrorMessage(str_replace("%s", $this->description_04->caption(), $this->description_04->RequiredErrorMessage));
                }
            }
            if ($this->description_05->Visible && $this->description_05->Required) {
                if ($this->description_05->FormValue == "") {
                    $this->description_05->addErrorMessage(str_replace("%s", $this->description_05->caption(), $this->description_05->RequiredErrorMessage));
                }
            }
            if ($this->description_06->Visible && $this->description_06->Required) {
                if ($this->description_06->FormValue == "") {
                    $this->description_06->addErrorMessage(str_replace("%s", $this->description_06->caption(), $this->description_06->RequiredErrorMessage));
                }
            }
            if ($this->description_07->Visible && $this->description_07->Required) {
                if ($this->description_07->FormValue == "") {
                    $this->description_07->addErrorMessage(str_replace("%s", $this->description_07->caption(), $this->description_07->RequiredErrorMessage));
                }
            }
            if ($this->description_08->Visible && $this->description_08->Required) {
                if ($this->description_08->FormValue == "") {
                    $this->description_08->addErrorMessage(str_replace("%s", $this->description_08->caption(), $this->description_08->RequiredErrorMessage));
                }
            }
            if ($this->description_09->Visible && $this->description_09->Required) {
                if ($this->description_09->FormValue == "") {
                    $this->description_09->addErrorMessage(str_replace("%s", $this->description_09->caption(), $this->description_09->RequiredErrorMessage));
                }
            }
            if ($this->description_10->Visible && $this->description_10->Required) {
                if ($this->description_10->FormValue == "") {
                    $this->description_10->addErrorMessage(str_replace("%s", $this->description_10->caption(), $this->description_10->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            $this->uploads->UploadPath = $this->uploads->getUploadPath();
            if (!EmptyValue($this->uploads->Upload->FileName)) {
                $this->uploads->Upload->DbValue = null;
                FixUploadFileNames($this->uploads);
                $this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $this->uploads->UploadPath = $this->uploads->OldUploadPath;

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
                    $this->uploads->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->uploads, $rsnew['uploads'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // programme_datetime
        $this->programme_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->programme_datetime->CurrentValue, $this->programme_datetime->formatPattern()), false);

        // programme_end_datetime
        $this->programme_end_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->programme_end_datetime->CurrentValue, $this->programme_end_datetime->formatPattern()), false);

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, false);

        // item
        $this->item->setDbValueDef($rsnew, $this->item->CurrentValue, false);

        // contact_person
        $this->contact_person->setDbValueDef($rsnew, $this->contact_person->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, false);

        // booking_ref
        $this->booking_ref->setDbValueDef($rsnew, $this->booking_ref->CurrentValue, false);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // payment_terms
        $this->payment_terms->setDbValueDef($rsnew, $this->payment_terms->CurrentValue, false);

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, strval($this->type->CurrentValue) == "");

        // buyer_instruction
        $this->buyer_instruction->setDbValueDef($rsnew, $this->buyer_instruction->CurrentValue, false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // eastimated_amount
        $this->eastimated_amount->setDbValueDef($rsnew, $this->eastimated_amount->CurrentValue, false);

        // gst
        $this->gst->setDbValueDef($rsnew, $this->gst->CurrentValue, strval($this->gst->CurrentValue) == "");

        // uploads
        if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
            if ($this->uploads->Upload->FileName == "") {
                $rsnew['uploads'] = null;
            } else {
                FixUploadTempFileNames($this->uploads);
                $rsnew['uploads'] = $this->uploads->Upload->FileName;
            }
            $this->uploads->ImageWidth = 640; // Resize width
            $this->uploads->ImageHeight = 640; // Resize height
        }

        // description_01
        $this->description_01->setDbValueDef($rsnew, $this->description_01->CurrentValue, false);

        // description_02
        $this->description_02->setDbValueDef($rsnew, $this->description_02->CurrentValue, false);

        // description_03
        $this->description_03->setDbValueDef($rsnew, $this->description_03->CurrentValue, false);

        // description_04
        $this->description_04->setDbValueDef($rsnew, $this->description_04->CurrentValue, false);

        // description_05
        $this->description_05->setDbValueDef($rsnew, $this->description_05->CurrentValue, false);

        // description_06
        $this->description_06->setDbValueDef($rsnew, $this->description_06->CurrentValue, false);

        // description_07
        $this->description_07->setDbValueDef($rsnew, $this->description_07->CurrentValue, false);

        // description_08
        $this->description_08->setDbValueDef($rsnew, $this->description_08->CurrentValue, false);

        // description_09
        $this->description_09->setDbValueDef($rsnew, $this->description_09->CurrentValue, false);

        // description_10
        $this->description_10->setDbValueDef($rsnew, $this->description_10->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['programme_datetime'])) { // programme_datetime
            $this->programme_datetime->setFormValue($row['programme_datetime']);
        }
        if (isset($row['programme_end_datetime'])) { // programme_end_datetime
            $this->programme_end_datetime->setFormValue($row['programme_end_datetime']);
        }
        if (isset($row['location'])) { // location
            $this->location->setFormValue($row['location']);
        }
        if (isset($row['item'])) { // item
            $this->item->setFormValue($row['item']);
        }
        if (isset($row['contact_person'])) { // contact_person
            $this->contact_person->setFormValue($row['contact_person']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['booking_ref'])) { // booking_ref
            $this->booking_ref->setFormValue($row['booking_ref']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['payment_terms'])) { // payment_terms
            $this->payment_terms->setFormValue($row['payment_terms']);
        }
        if (isset($row['type'])) { // type
            $this->type->setFormValue($row['type']);
        }
        if (isset($row['buyer_instruction'])) { // buyer_instruction
            $this->buyer_instruction->setFormValue($row['buyer_instruction']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['eastimated_amount'])) { // eastimated_amount
            $this->eastimated_amount->setFormValue($row['eastimated_amount']);
        }
        if (isset($row['gst'])) { // gst
            $this->gst->setFormValue($row['gst']);
        }
        if (isset($row['uploads'])) { // uploads
            $this->uploads->setFormValue($row['uploads']);
        }
        if (isset($row['description_01'])) { // description_01
            $this->description_01->setFormValue($row['description_01']);
        }
        if (isset($row['description_02'])) { // description_02
            $this->description_02->setFormValue($row['description_02']);
        }
        if (isset($row['description_03'])) { // description_03
            $this->description_03->setFormValue($row['description_03']);
        }
        if (isset($row['description_04'])) { // description_04
            $this->description_04->setFormValue($row['description_04']);
        }
        if (isset($row['description_05'])) { // description_05
            $this->description_05->setFormValue($row['description_05']);
        }
        if (isset($row['description_06'])) { // description_06
            $this->description_06->setFormValue($row['description_06']);
        }
        if (isset($row['description_07'])) { // description_07
            $this->description_07->setFormValue($row['description_07']);
        }
        if (isset($row['description_08'])) { // description_08
            $this->description_08->setFormValue($row['description_08']);
        }
        if (isset($row['description_09'])) { // description_09
            $this->description_09->setFormValue($row['description_09']);
        }
        if (isset($row['description_10'])) { // description_10
            $this->description_10->setFormValue($row['description_10']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("rentalpolist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    break;
                case "x_item":
                    break;
                case "x_contact_person":
                    break;
                case "x_booking_ref":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_payment_terms":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_job_category":
                    break;
                case "x_type":
                    break;
                case "x_gst":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_reports_to":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_description_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
