<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for rental_po
 */
class RentalPo extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $programme_datetime;
    public $programme_end_datetime;
    public $location;
    public $item;
    public $contact_person;
    public $amount;
    public $booking_ref;
    public $company_id;
    public $payment_terms;
    public $job_category;
    public $type;
    public $buyer_instruction;
    public $remarks;
    public $eastimated_amount;
    public $gst;
    public $uploads;
    public $reports_to;
    public $description_01;
    public $description_02;
    public $description_03;
    public $description_04;
    public $description_05;
    public $description_06;
    public $description_07;
    public $description_08;
    public $description_09;
    public $description_10;
    public $operator;
    public $datetime;
    public $a_operator;
    public $a_datetime;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "rental_po";
        $this->TableName = 'rental_po';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "rental_po";
        $this->Dbid = 'DB';
        $this->ExportAll = false;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // programme_datetime
        $this->programme_datetime = new DbField(
            $this, // Table
            'x_programme_datetime', // Variable name
            'programme_datetime', // Name
            '`programme_datetime`', // Expression
            CastDateFieldForLike("`programme_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`programme_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->programme_datetime->InputTextType = "text";
        $this->programme_datetime->Raw = true;
        $this->programme_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->programme_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['programme_datetime'] = &$this->programme_datetime;

        // programme_end_datetime
        $this->programme_end_datetime = new DbField(
            $this, // Table
            'x_programme_end_datetime', // Variable name
            'programme_end_datetime', // Name
            '`programme_end_datetime`', // Expression
            CastDateFieldForLike("`programme_end_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`programme_end_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->programme_end_datetime->addMethod("getDefault", fn() => (isset($_COOKIE["DD"]))? $_COOKIE["DD"]:'');
        $this->programme_end_datetime->InputTextType = "text";
        $this->programme_end_datetime->Raw = true;
        $this->programme_end_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->programme_end_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['programme_end_datetime'] = &$this->programme_end_datetime;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__location', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->location->InputTextType = "text";
        $this->location->Lookup = new Lookup($this->location, 'rental_po', true, 'location', ["location","","",""], '', '', [], [], [], [], [], [], false, '`location` ASC', '', "`location`");
        $this->location->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['location'] = &$this->location;

        // item
        $this->item = new DbField(
            $this, // Table
            'x_item', // Variable name
            'item', // Name
            '`item`', // Expression
            '`item`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`item`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->item->addMethod("getDefault", fn() => (isset($_COOKIE["ITEM"]))? $_COOKIE["ITEM"]:'');
        $this->item->InputTextType = "text";
        $this->item->Nullable = false; // NOT NULL field
        $this->item->Required = true; // Required field
        $this->item->Lookup = new Lookup($this->item, 'rental_po', true, 'item', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->item->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['item'] = &$this->item;

        // contact_person
        $this->contact_person = new DbField(
            $this, // Table
            'x_contact_person', // Variable name
            'contact_person', // Name
            '`contact_person`', // Expression
            '`contact_person`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__contact_person', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->contact_person->InputTextType = "text";
        $this->contact_person->Nullable = false; // NOT NULL field
        $this->contact_person->Required = true; // Required field
        $this->contact_person->Lookup = new Lookup($this->contact_person, 'rental_po', true, 'contact_person', ["contact_person","","",""], '', '', [], [], [], [], [], [], false, '`contact_person` ASC', '', "`contact_person`");
        $this->contact_person->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['contact_person'] = &$this->contact_person;

        // amount
        $this->amount = new DbField(
            $this, // Table
            'x_amount', // Variable name
            'amount', // Name
            '`amount`', // Expression
            '`amount`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->amount->addMethod("getDefault", fn() => (isset($_COOKIE["AMT"]))? $_COOKIE["AMT"]:'0');
        $this->amount->InputTextType = "text";
        $this->amount->Nullable = false; // NOT NULL field
        $this->amount->Required = true; // Required field
        $this->amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['amount'] = &$this->amount;

        // booking_ref
        $this->booking_ref = new DbField(
            $this, // Table
            'x_booking_ref', // Variable name
            'booking_ref', // Name
            '`booking_ref`', // Expression
            '`booking_ref`', // Basic search expression
            200, // Type
            50, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__booking_ref', // Virtual expression
            true, // Is virtual
            false, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->booking_ref->InputTextType = "text";
        $this->booking_ref->Lookup = new Lookup($this->booking_ref, 'rental_po', true, 'booking_ref', ["booking_ref","","",""], '', '', [], [], [], [], [], [], false, '`booking_ref` ASC', '', "`booking_ref`");
        $this->booking_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['booking_ref'] = &$this->booking_ref;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2");
        $this->company_id->addMethod("getDefault", fn() => ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["CID"]))? $_COOKIE["CID"]:User_Company_ID())));
        $this->company_id->InputTextType = "text";
        $this->company_id->Raw = true;
        $this->company_id->Lookup = new Lookup($this->company_id, 'buyer', true, 'id', ["name","mobile","",""], '', '', [], ["x_description_01[]","x_description_02[]","x_description_03[]","x_description_04[]","x_description_05[]","x_description_07[]","x_description_08[]","x_description_09[]","x_description_10[]"], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->company_id) . "',COALESCE(`mobile`,''))");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // payment_terms
        $this->payment_terms = new DbField(
            $this, // Table
            'x_payment_terms', // Variable name
            'payment_terms', // Name
            '`payment_terms`', // Expression
            '`payment_terms`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`payment_terms`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->payment_terms->addMethod("getSelectFilter", fn() => "`grp` = 81");
        $this->payment_terms->addMethod("getLinkPrefix", fn() => "poblist?x_payment_terms=");
        $this->payment_terms->InputTextType = "text";
        $this->payment_terms->setSelectMultiple(false); // Select one
        $this->payment_terms->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->payment_terms->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->payment_terms->Lookup = new Lookup($this->payment_terms, 'misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->payment_terms->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['payment_terms'] = &$this->payment_terms;

        // job_category
        $this->job_category = new DbField(
            $this, // Table
            'x_job_category', // Variable name
            'job_category', // Name
            '`job_category`', // Expression
            '`job_category`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`job_category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'RADIO' // Edit Tag
        );
        $this->job_category->addMethod("getDefault", fn() => (isset($_COOKIE["CAT"]))? $_COOKIE["CAT"]:'');
        $this->job_category->InputTextType = "text";
        $this->job_category->Raw = true;
        $this->job_category->Nullable = false; // NOT NULL field
        $this->job_category->Sortable = false; // Allow sort
        $this->job_category->Lookup = new Lookup($this->job_category, 'rental_po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->job_category->OptionCount = 2;
        $this->job_category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->job_category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['job_category'] = &$this->job_category;

        // type
        $this->type = new DbField(
            $this, // Table
            'x_type', // Variable name
            'type', // Name
            '`type`', // Expression
            '`type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->type->addMethod("getDefault", fn() => 1);
        $this->type->InputTextType = "text";
        $this->type->Raw = true;
        $this->type->Nullable = false; // NOT NULL field
        $this->type->setSelectMultiple(false); // Select one
        $this->type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->type->Lookup = new Lookup($this->type, 'rental_po', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->type->OptionCount = 3;
        $this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['type'] = &$this->type;

        // buyer_instruction
        $this->buyer_instruction = new DbField(
            $this, // Table
            'x_buyer_instruction', // Variable name
            'buyer_instruction', // Name
            '`buyer_instruction`', // Expression
            '`buyer_instruction`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_instruction`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->buyer_instruction->addMethod("getDefault", fn() => (isset($_COOKIE["BI"]))? $_COOKIE["BI"]:'');
        $this->buyer_instruction->InputTextType = "text";
        $this->buyer_instruction->Sortable = false; // Allow sort
        $this->buyer_instruction->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_instruction'] = &$this->buyer_instruction;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->addMethod("getDefault", fn() => (isset($_COOKIE["REM"]))? $_COOKIE["REM"]:'');
        $this->remarks->InputTextType = "text";
        $this->remarks->Sortable = false; // Allow sort
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // eastimated_amount
        $this->eastimated_amount = new DbField(
            $this, // Table
            'x_eastimated_amount', // Variable name
            'eastimated_amount', // Name
            '`eastimated_amount`', // Expression
            '`eastimated_amount`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`eastimated_amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->eastimated_amount->addMethod("getEditCustomAttributes", fn() => 'ReadOnly');
        $this->eastimated_amount->addMethod("getDefault", fn() => 0);
        $this->eastimated_amount->InputTextType = "text";
        $this->eastimated_amount->Raw = true;
        $this->eastimated_amount->Sortable = false; // Allow sort
        $this->eastimated_amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['eastimated_amount'] = &$this->eastimated_amount;

        // gst
        $this->gst = new DbField(
            $this, // Table
            'x_gst', // Variable name
            'gst', // Name
            '`gst`', // Expression
            '`gst`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gst`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->gst->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->gst->addMethod("getDefault", fn() => (isset($_COOKIE["GST"]))? $_COOKIE["GST"]:'1');
        $this->gst->InputTextType = "text";
        $this->gst->Raw = true;
        $this->gst->Nullable = false; // NOT NULL field
        $this->gst->Required = true; // Required field
        $this->gst->setSelectMultiple(false); // Select one
        $this->gst->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->gst->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->gst->Lookup = new Lookup($this->gst, 'tax_category', false, 'id', ["item","tax_percent","hsn_code",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "CONCAT(COALESCE(`item`, ''),'" . ValueSeparator(1, $this->gst) . "',COALESCE(`tax_percent`,''),'" . ValueSeparator(2, $this->gst) . "',COALESCE(`hsn_code`,''))");
        $this->gst->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->gst->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['gst'] = &$this->gst;

        // uploads
        $this->uploads = new DbField(
            $this, // Table
            'x_uploads', // Variable name
            'uploads', // Name
            '`uploads`', // Expression
            '`uploads`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`uploads`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->uploads->addMethod("getUploadPath", fn() => '.p_uploads/rental/');
        $this->uploads->InputTextType = "text";
        $this->uploads->Sortable = false; // Allow sort
        $this->uploads->UploadMultiple = true;
        $this->uploads->Upload->UploadMultiple = true;
        $this->uploads->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uploads'] = &$this->uploads;

        // reports_to
        $this->reports_to = new DbField(
            $this, // Table
            'x_reports_to', // Variable name
            'reports_to', // Name
            '`reports_to`', // Expression
            '`reports_to`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reports_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->reports_to->addMethod("getSelectFilter", fn() => "`activated`=1");
        $this->reports_to->InputTextType = "text";
        $this->reports_to->Raw = true;
        $this->reports_to->setSelectMultiple(false); // Select one
        $this->reports_to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->reports_to->Lookup = new Lookup($this->reports_to, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->reports_to->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['reports_to'] = &$this->reports_to;

        // description_01
        $this->description_01 = new DbField(
            $this, // Table
            'x_description_01', // Variable name
            'description_01', // Name
            '`description_01`', // Expression
            '`description_01`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_01->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (17)" : "`s_grp` IN (17) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_01->addMethod("getDefault", fn() => (isset($_COOKIE["D01"]))? $_COOKIE["D01"]:'');
        $this->description_01->InputTextType = "text";
        $this->description_01->Sortable = false; // Allow sort
        $this->description_01->Lookup = new Lookup($this->description_01, 'rental_cart', true, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_01) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_01) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_01) . "',COALESCE(`amount`,''))");
        $this->description_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_01'] = &$this->description_01;

        // description_02
        $this->description_02 = new DbField(
            $this, // Table
            'x_description_02', // Variable name
            'description_02', // Name
            '`description_02`', // Expression
            '`description_02`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_02->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (18)" : "`s_grp` IN (18) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_02->addMethod("getDefault", fn() => (isset($_COOKIE["D02"]))? $_COOKIE["D02"]:'');
        $this->description_02->InputTextType = "text";
        $this->description_02->Sortable = false; // Allow sort
        $this->description_02->Lookup = new Lookup($this->description_02, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_02) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_02) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_02) . "',COALESCE(`amount`,''))");
        $this->description_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_02'] = &$this->description_02;

        // description_03
        $this->description_03 = new DbField(
            $this, // Table
            'x_description_03', // Variable name
            'description_03', // Name
            '`description_03`', // Expression
            '`description_03`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_03->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (19)" : "`s_grp` IN (19) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_03->addMethod("getDefault", fn() => (isset($_COOKIE["D03"]))? $_COOKIE["D03"]:'');
        $this->description_03->InputTextType = "text";
        $this->description_03->Sortable = false; // Allow sort
        $this->description_03->Lookup = new Lookup($this->description_03, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_03) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_03) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_03) . "',COALESCE(`amount`,''))");
        $this->description_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_03'] = &$this->description_03;

        // description_04
        $this->description_04 = new DbField(
            $this, // Table
            'x_description_04', // Variable name
            'description_04', // Name
            '`description_04`', // Expression
            '`description_04`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_04->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (20)" : "`s_grp` IN (20) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_04->addMethod("getDefault", fn() => (isset($_COOKIE["D04"]))? $_COOKIE["D04"]:'');
        $this->description_04->InputTextType = "text";
        $this->description_04->Sortable = false; // Allow sort
        $this->description_04->Lookup = new Lookup($this->description_04, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_04) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_04) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_04) . "',COALESCE(`amount`,''))");
        $this->description_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->description_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_04'] = &$this->description_04;

        // description_05
        $this->description_05 = new DbField(
            $this, // Table
            'x_description_05', // Variable name
            'description_05', // Name
            '`description_05`', // Expression
            '`description_05`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_05->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (21)" : "`s_grp` IN (21) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_05->addMethod("getDefault", fn() => (isset($_COOKIE["D05"]))? $_COOKIE["D05"]:'');
        $this->description_05->InputTextType = "text";
        $this->description_05->Sortable = false; // Allow sort
        $this->description_05->Lookup = new Lookup($this->description_05, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_05) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_05) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_05) . "',COALESCE(`amount`,''))");
        $this->description_05->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_05'] = &$this->description_05;

        // description_06
        $this->description_06 = new DbField(
            $this, // Table
            'x_description_06', // Variable name
            'description_06', // Name
            '`description_06`', // Expression
            '`description_06`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_06->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (22)" : "`s_grp` IN (22) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_06->addMethod("getDefault", fn() => (isset($_COOKIE["D06"]))? $_COOKIE["D06"]:'');
        $this->description_06->InputTextType = "text";
        $this->description_06->Sortable = false; // Allow sort
        $this->description_06->Lookup = new Lookup($this->description_06, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', [], [], [], [], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_06) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_06) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_06) . "',COALESCE(`amount`,''))");
        $this->description_06->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_06'] = &$this->description_06;

        // description_07
        $this->description_07 = new DbField(
            $this, // Table
            'x_description_07', // Variable name
            'description_07', // Name
            '`description_07`', // Expression
            '`description_07`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_07->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (23)" : "`s_grp` IN (23) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_07->addMethod("getDefault", fn() => (isset($_COOKIE["D07"]))? $_COOKIE["D07"]:'');
        $this->description_07->InputTextType = "text";
        $this->description_07->Sortable = false; // Allow sort
        $this->description_07->Lookup = new Lookup($this->description_07, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_07) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_07) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_07) . "',COALESCE(`amount`,''))");
        $this->description_07->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_07->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_07'] = &$this->description_07;

        // description_08
        $this->description_08 = new DbField(
            $this, // Table
            'x_description_08', // Variable name
            'description_08', // Name
            '`description_08`', // Expression
            '`description_08`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_08->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (24)" : "`s_grp` IN (24) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_08->addMethod("getDefault", fn() => (isset($_COOKIE["D08"]))? $_COOKIE["D08"]:'');
        $this->description_08->InputTextType = "text";
        $this->description_08->Sortable = false; // Allow sort
        $this->description_08->Lookup = new Lookup($this->description_08, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_08) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_08) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_08) . "',COALESCE(`amount`,''))");
        $this->description_08->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->description_08->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_08'] = &$this->description_08;

        // description_09
        $this->description_09 = new DbField(
            $this, // Table
            'x_description_09', // Variable name
            'description_09', // Name
            '`description_09`', // Expression
            '`description_09`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_09->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (25)" : "`s_grp` IN (25) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_09->addMethod("getDefault", fn() => (isset($_COOKIE["D09"]))? $_COOKIE["D09"]:'');
        $this->description_09->InputTextType = "text";
        $this->description_09->Sortable = false; // Allow sort
        $this->description_09->Lookup = new Lookup($this->description_09, 'rental_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_09) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_09) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_09) . "',COALESCE(`amount`,''))");
        $this->description_09->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_09'] = &$this->description_09;

        // description_10
        $this->description_10 = new DbField(
            $this, // Table
            'x_description_10', // Variable name
            'description_10', // Name
            '`description_10`', // Expression
            '`description_10`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`description_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->description_10->addMethod("getSelectFilter", fn() => (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` NOT IN (17,18,19,20,21,22,23,24,25)" : "`s_grp` NOT IN (17,18,19,20,21,22,23,24,25) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")");
        $this->description_10->addMethod("getDefault", fn() => (isset($_COOKIE["D10"]))? $_COOKIE["D10"]:'');
        $this->description_10->InputTextType = "text";
        $this->description_10->Sortable = false; // Allow sort
        $this->description_10->Lookup = new Lookup($this->description_10, 'p_cart', false, 'id', ["product_code","qty","price","amount"], '', '', ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], false, '`id` ASC', '<div><span class="text-info">Product : {{:df}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}}</span><span style="color:blue"><a data-table="rental_cart" data-caption="Edit" data-ew-action="modal" data-action="edit" data-ajax="false" data-url="/rentalcartedit/{{:lf}}" data-btn="SaveBtn" data-bs-original-title="Edit">Edit</a></span><span style="color:red"><a data-ew-action="inline-delete" href="/rentalcartdelete/{{:lf}}">Delete</a></span></div>', "CONCAT(COALESCE(`product_code`, ''),'" . ValueSeparator(1, $this->description_10) . "',COALESCE(`qty`,''),'" . ValueSeparator(2, $this->description_10) . "',COALESCE(`price`,''),'" . ValueSeparator(3, $this->description_10) . "',COALESCE(`amount`,''))");
        $this->description_10->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['description_10'] = &$this->description_10;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->a_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->Sortable = false; // Allow sort
        $this->a_operator->setSelectMultiple(false); // Select one
        $this->a_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->a_operator->Lookup = new Lookup($this->a_operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // a_datetime
        $this->a_datetime = new DbField(
            $this, // Table
            'x_a_datetime', // Variable name
            'a_datetime', // Name
            '`a_datetime`', // Expression
            CastDateFieldForLike("`a_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`a_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->a_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->a_datetime->InputTextType = "text";
        $this->a_datetime->Raw = true;
        $this->a_datetime->Sortable = false; // Allow sort
        $this->a_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_datetime'] = &$this->a_datetime;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "rental_po";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT DISTINCT `location` FROM rental_po TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.location = rental_po.location LIMIT 1) AS EV__location, (SELECT DISTINCT `contact_person` FROM rental_po TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.contact_person = rental_po.contact_person LIMIT 1) AS EV__contact_person, (SELECT DISTINCT `booking_ref` FROM rental_po TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.booking_ref = rental_po.booking_ref LIMIT 1) AS EV__booking_ref FROM rental_po)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->location->AdvancedSearch->SearchValue != "" ||
            $this->location->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->location->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->location->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->contact_person->AdvancedSearch->SearchValue != "" ||
            $this->contact_person->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->contact_person->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->contact_person->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->booking_ref->AdvancedSearch->SearchValue != "" ||
            $this->booking_ref->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->booking_ref->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->booking_ref->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->programme_datetime->DbValue = $row['programme_datetime'];
        $this->programme_end_datetime->DbValue = $row['programme_end_datetime'];
        $this->location->DbValue = $row['location'];
        $this->item->DbValue = $row['item'];
        $this->contact_person->DbValue = $row['contact_person'];
        $this->amount->DbValue = $row['amount'];
        $this->booking_ref->DbValue = $row['booking_ref'];
        $this->company_id->DbValue = $row['company_id'];
        $this->payment_terms->DbValue = $row['payment_terms'];
        $this->job_category->DbValue = $row['job_category'];
        $this->type->DbValue = $row['type'];
        $this->buyer_instruction->DbValue = $row['buyer_instruction'];
        $this->remarks->DbValue = $row['remarks'];
        $this->eastimated_amount->DbValue = $row['eastimated_amount'];
        $this->gst->DbValue = $row['gst'];
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->reports_to->DbValue = $row['reports_to'];
        $this->description_01->DbValue = $row['description_01'];
        $this->description_02->DbValue = $row['description_02'];
        $this->description_03->DbValue = $row['description_03'];
        $this->description_04->DbValue = $row['description_04'];
        $this->description_05->DbValue = $row['description_05'];
        $this->description_06->DbValue = $row['description_06'];
        $this->description_07->DbValue = $row['description_07'];
        $this->description_08->DbValue = $row['description_08'];
        $this->description_09->DbValue = $row['description_09'];
        $this->description_10->DbValue = $row['description_10'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->a_datetime->DbValue = $row['a_datetime'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->uploads->OldUploadPath = $this->uploads->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['uploads']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['uploads']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("rentalpolist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "rentalpoview" => $Language->phrase("View"),
            "rentalpoedit" => $Language->phrase("Edit"),
            "rentalpoadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "rentalpolist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "RentalPoView",
            Config("API_ADD_ACTION") => "RentalPoAdd",
            Config("API_EDIT_ACTION") => "RentalPoEdit",
            Config("API_DELETE_ACTION") => "RentalPoDelete",
            Config("API_LIST_ACTION") => "RentalPoList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "rentalpolist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("rentalpoview", $parm);
        } else {
            $url = $this->keyUrl("rentalpoview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "rentalpoadd?" . $parm;
        } else {
            $url = "rentalpoadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("rentalpoedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("rentalpolist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("rentalpoadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("rentalpolist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("rentalpodelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->programme_datetime->setDbValue($row['programme_datetime']);
        $this->programme_end_datetime->setDbValue($row['programme_end_datetime']);
        $this->location->setDbValue($row['location']);
        $this->item->setDbValue($row['item']);
        $this->contact_person->setDbValue($row['contact_person']);
        $this->amount->setDbValue($row['amount']);
        $this->booking_ref->setDbValue($row['booking_ref']);
        $this->company_id->setDbValue($row['company_id']);
        $this->payment_terms->setDbValue($row['payment_terms']);
        $this->job_category->setDbValue($row['job_category']);
        $this->type->setDbValue($row['type']);
        $this->buyer_instruction->setDbValue($row['buyer_instruction']);
        $this->remarks->setDbValue($row['remarks']);
        $this->eastimated_amount->setDbValue($row['eastimated_amount']);
        $this->gst->setDbValue($row['gst']);
        $this->uploads->Upload->DbValue = $row['uploads'];
        $this->reports_to->setDbValue($row['reports_to']);
        $this->description_01->setDbValue($row['description_01']);
        $this->description_02->setDbValue($row['description_02']);
        $this->description_03->setDbValue($row['description_03']);
        $this->description_04->setDbValue($row['description_04']);
        $this->description_05->setDbValue($row['description_05']);
        $this->description_06->setDbValue($row['description_06']);
        $this->description_07->setDbValue($row['description_07']);
        $this->description_08->setDbValue($row['description_08']);
        $this->description_09->setDbValue($row['description_09']);
        $this->description_10->setDbValue($row['description_10']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "RentalPoList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // programme_datetime

        // programme_end_datetime

        // location

        // item

        // contact_person

        // amount

        // booking_ref

        // company_id

        // payment_terms

        // job_category
        $this->job_category->CellCssStyle = "white-space: nowrap;";

        // type

        // buyer_instruction
        $this->buyer_instruction->CellCssStyle = "white-space: nowrap;";

        // remarks
        $this->remarks->CellCssStyle = "white-space: nowrap;";

        // eastimated_amount
        $this->eastimated_amount->CellCssStyle = "white-space: nowrap;";

        // gst

        // uploads
        $this->uploads->CellCssStyle = "white-space: nowrap;";

        // reports_to

        // description_01
        $this->description_01->CellCssStyle = "white-space: nowrap;";

        // description_02
        $this->description_02->CellCssStyle = "white-space: nowrap;";

        // description_03
        $this->description_03->CellCssStyle = "white-space: nowrap;";

        // description_04
        $this->description_04->CellCssStyle = "white-space: nowrap;";

        // description_05
        $this->description_05->CellCssStyle = "white-space: nowrap;";

        // description_06
        $this->description_06->CellCssStyle = "white-space: nowrap;";

        // description_07
        $this->description_07->CellCssStyle = "white-space: nowrap;";

        // description_08
        $this->description_08->CellCssStyle = "white-space: nowrap;";

        // description_09
        $this->description_09->CellCssStyle = "white-space: nowrap;";

        // description_10
        $this->description_10->CellCssStyle = "white-space: nowrap;";

        // operator

        // datetime

        // a_operator
        $this->a_operator->CellCssStyle = "white-space: nowrap;";

        // a_datetime
        $this->a_datetime->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // programme_datetime
        $this->programme_datetime->ViewValue = $this->programme_datetime->CurrentValue;
        $this->programme_datetime->ViewValue = FormatDateTime($this->programme_datetime->ViewValue, $this->programme_datetime->formatPattern());

        // programme_end_datetime
        $this->programme_end_datetime->ViewValue = $this->programme_end_datetime->CurrentValue;
        $this->programme_end_datetime->ViewValue = FormatDateTime($this->programme_end_datetime->ViewValue, $this->programme_end_datetime->formatPattern());

        // location
        if ($this->location->VirtualValue != "") {
            $this->location->ViewValue = $this->location->VirtualValue;
        } else {
            $this->location->ViewValue = $this->location->CurrentValue;
        }

        // item
        $this->item->ViewValue = $this->item->CurrentValue;

        // contact_person
        if ($this->contact_person->VirtualValue != "") {
            $this->contact_person->ViewValue = $this->contact_person->VirtualValue;
        } else {
            $this->contact_person->ViewValue = $this->contact_person->CurrentValue;
        }

        // amount
        $this->amount->ViewValue = $this->amount->CurrentValue;

        // booking_ref
        if ($this->booking_ref->VirtualValue != "") {
            $this->booking_ref->ViewValue = $this->booking_ref->VirtualValue;
        } else {
            $this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
        }

        // company_id
        $this->company_id->ViewValue = $this->company_id->CurrentValue;
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                    $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                } else {
                    $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // payment_terms
        $curVal = strval($this->payment_terms->CurrentValue);
        if ($curVal != "") {
            $this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
            if ($this->payment_terms->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->payment_terms->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->payment_terms->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->payment_terms->getSelectFilter($this); // PHP
                $sqlWrk = $this->payment_terms->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->payment_terms->Lookup->renderViewRow($rswrk[0]);
                    $this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
                } else {
                    $this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
                }
            }
        } else {
            $this->payment_terms->ViewValue = null;
        }

        // job_category
        if (strval($this->job_category->CurrentValue) != "") {
            $this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
        } else {
            $this->job_category->ViewValue = null;
        }

        // type
        if (strval($this->type->CurrentValue) != "") {
            $this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
        } else {
            $this->type->ViewValue = null;
        }

        // buyer_instruction
        $this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // eastimated_amount
        $this->eastimated_amount->ViewValue = $this->eastimated_amount->CurrentValue;
        $this->eastimated_amount->ViewValue = FormatNumber($this->eastimated_amount->ViewValue, $this->eastimated_amount->formatPattern());

        // gst
        $curVal = strval($this->gst->CurrentValue);
        if ($curVal != "") {
            $this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
            if ($this->gst->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->gst->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->gst->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->gst->getSelectFilter($this); // PHP
                $sqlWrk = $this->gst->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->gst->Lookup->renderViewRow($rswrk[0]);
                    $this->gst->ViewValue = $this->gst->displayValue($arwrk);
                } else {
                    $this->gst->ViewValue = FormatNumber($this->gst->CurrentValue, $this->gst->formatPattern());
                }
            }
        } else {
            $this->gst->ViewValue = null;
        }

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->ViewValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->ViewValue = "";
        }
        $this->uploads->CssClass = "fst-italic";

        // reports_to
        $curVal = strval($this->reports_to->CurrentValue);
        if ($curVal != "") {
            $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            if ($this->reports_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->reports_to->getSelectFilter($this); // PHP
                $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                    $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                } else {
                    $this->reports_to->ViewValue = FormatNumber($this->reports_to->CurrentValue, $this->reports_to->formatPattern());
                }
            }
        } else {
            $this->reports_to->ViewValue = null;
        }

        // description_01
        $curVal = strval($this->description_01->CurrentValue);
        if ($curVal != "") {
            $this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
            if ($this->description_01->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_01->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_01->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_01->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_01->Lookup->renderViewRow($row);
                        $this->description_01->ViewValue->add($this->description_01->displayValue($arwrk));
                    }
                } else {
                    $this->description_01->ViewValue = $this->description_01->CurrentValue;
                }
            }
        } else {
            $this->description_01->ViewValue = null;
        }

        // description_02
        $curVal = strval($this->description_02->CurrentValue);
        if ($curVal != "") {
            $this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
            if ($this->description_02->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_02->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_02->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_02->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_02->Lookup->renderViewRow($row);
                        $this->description_02->ViewValue->add($this->description_02->displayValue($arwrk));
                    }
                } else {
                    $this->description_02->ViewValue = $this->description_02->CurrentValue;
                }
            }
        } else {
            $this->description_02->ViewValue = null;
        }

        // description_03
        $curVal = strval($this->description_03->CurrentValue);
        if ($curVal != "") {
            $this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
            if ($this->description_03->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_03->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_03->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_03->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_03->Lookup->renderViewRow($row);
                        $this->description_03->ViewValue->add($this->description_03->displayValue($arwrk));
                    }
                } else {
                    $this->description_03->ViewValue = $this->description_03->CurrentValue;
                }
            }
        } else {
            $this->description_03->ViewValue = null;
        }

        // description_04
        $curVal = strval($this->description_04->CurrentValue);
        if ($curVal != "") {
            $this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
            if ($this->description_04->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_04->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_04->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_04->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_04->Lookup->renderViewRow($row);
                        $this->description_04->ViewValue->add($this->description_04->displayValue($arwrk));
                    }
                } else {
                    $this->description_04->ViewValue = $this->description_04->CurrentValue;
                }
            }
        } else {
            $this->description_04->ViewValue = null;
        }

        // description_05
        $curVal = strval($this->description_05->CurrentValue);
        if ($curVal != "") {
            $this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
            if ($this->description_05->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_05->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_05->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_05->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_05->Lookup->renderViewRow($row);
                        $this->description_05->ViewValue->add($this->description_05->displayValue($arwrk));
                    }
                } else {
                    $this->description_05->ViewValue = $this->description_05->CurrentValue;
                }
            }
        } else {
            $this->description_05->ViewValue = null;
        }

        // description_06
        $curVal = strval($this->description_06->CurrentValue);
        if ($curVal != "") {
            $this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
            if ($this->description_06->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_06->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_06->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_06->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_06->Lookup->renderViewRow($row);
                        $this->description_06->ViewValue->add($this->description_06->displayValue($arwrk));
                    }
                } else {
                    $this->description_06->ViewValue = $this->description_06->CurrentValue;
                }
            }
        } else {
            $this->description_06->ViewValue = null;
        }

        // description_07
        $curVal = strval($this->description_07->CurrentValue);
        if ($curVal != "") {
            $this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
            if ($this->description_07->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_07->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_07->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_07->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_07->Lookup->renderViewRow($row);
                        $this->description_07->ViewValue->add($this->description_07->displayValue($arwrk));
                    }
                } else {
                    $this->description_07->ViewValue = $this->description_07->CurrentValue;
                }
            }
        } else {
            $this->description_07->ViewValue = null;
        }

        // description_08
        $curVal = strval($this->description_08->CurrentValue);
        if ($curVal != "") {
            $this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
            if ($this->description_08->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_08->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_08->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_08->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_08->Lookup->renderViewRow($row);
                        $this->description_08->ViewValue->add($this->description_08->displayValue($arwrk));
                    }
                } else {
                    $this->description_08->ViewValue = $this->description_08->CurrentValue;
                }
            }
        } else {
            $this->description_08->ViewValue = null;
        }

        // description_09
        $curVal = strval($this->description_09->CurrentValue);
        if ($curVal != "") {
            $this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
            if ($this->description_09->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_09->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_09->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_09->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_09->Lookup->renderViewRow($row);
                        $this->description_09->ViewValue->add($this->description_09->displayValue($arwrk));
                    }
                } else {
                    $this->description_09->ViewValue = $this->description_09->CurrentValue;
                }
            }
        } else {
            $this->description_09->ViewValue = null;
        }

        // description_10
        $curVal = strval($this->description_10->CurrentValue);
        if ($curVal != "") {
            $this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
            if ($this->description_10->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->description_10->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->description_10->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->description_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->description_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->description_10->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->description_10->Lookup->renderViewRow($row);
                        $this->description_10->ViewValue->add($this->description_10->displayValue($arwrk));
                    }
                } else {
                    $this->description_10->ViewValue = $this->description_10->CurrentValue;
                }
            }
        } else {
            $this->description_10->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // a_operator
        $curVal = strval($this->a_operator->CurrentValue);
        if ($curVal != "") {
            $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            if ($this->a_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                } else {
                    $this->a_operator->ViewValue = $this->a_operator->CurrentValue;
                }
            }
        } else {
            $this->a_operator->ViewValue = null;
        }

        // a_datetime
        $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
        $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // programme_datetime
        $this->programme_datetime->HrefValue = "";
        $this->programme_datetime->TooltipValue = "";

        // programme_end_datetime
        $this->programme_end_datetime->HrefValue = "";
        $this->programme_end_datetime->TooltipValue = "";

        // location
        $this->location->HrefValue = "";
        $this->location->TooltipValue = "";

        // item
        $this->item->HrefValue = "";
        $this->item->TooltipValue = "";

        // contact_person
        $this->contact_person->HrefValue = "";
        $this->contact_person->TooltipValue = "";

        // amount
        $this->amount->HrefValue = "";
        $this->amount->TooltipValue = "";

        // booking_ref
        $this->booking_ref->HrefValue = "";
        $this->booking_ref->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // payment_terms
        if (!EmptyValue($this->payment_terms->CurrentValue)) {
            $this->payment_terms->HrefValue = $this->payment_terms->getLinkPrefix() . $this->payment_terms->CurrentValue; // Add prefix/suffix
            $this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
            }
        } else {
            $this->payment_terms->HrefValue = "";
        }
        $this->payment_terms->TooltipValue = "";

        // job_category
        $this->job_category->HrefValue = "";
        $this->job_category->TooltipValue = "";

        // type
        $this->type->HrefValue = "";
        $this->type->TooltipValue = "";

        // buyer_instruction
        $this->buyer_instruction->HrefValue = "";
        $this->buyer_instruction->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // eastimated_amount
        $this->eastimated_amount->HrefValue = "";
        $this->eastimated_amount->TooltipValue = "";

        // gst
        $this->gst->HrefValue = "";
        $this->gst->TooltipValue = "";

        // uploads
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->HrefValue = "%u"; // Add prefix/suffix
            $this->uploads->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
            }
        } else {
            $this->uploads->HrefValue = "";
        }
        $this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
        $this->uploads->TooltipValue = "";
        if ($this->uploads->UseColorbox) {
            if (EmptyValue($this->uploads->TooltipValue)) {
                $this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->uploads->LinkAttrs["data-rel"] = "rental_po_x_uploads";
            $this->uploads->LinkAttrs->appendClass("ew-lightbox");
        }

        // reports_to
        $this->reports_to->HrefValue = "";
        $this->reports_to->TooltipValue = "";

        // description_01
        $this->description_01->HrefValue = "";
        $this->description_01->TooltipValue = "";

        // description_02
        $this->description_02->HrefValue = "";
        $this->description_02->TooltipValue = "";

        // description_03
        $this->description_03->HrefValue = "";
        $this->description_03->TooltipValue = "";

        // description_04
        $this->description_04->HrefValue = "";
        $this->description_04->TooltipValue = "";

        // description_05
        $this->description_05->HrefValue = "";
        $this->description_05->TooltipValue = "";

        // description_06
        $this->description_06->HrefValue = "";
        $this->description_06->TooltipValue = "";

        // description_07
        $this->description_07->HrefValue = "";
        $this->description_07->TooltipValue = "";

        // description_08
        $this->description_08->HrefValue = "";
        $this->description_08->TooltipValue = "";

        // description_09
        $this->description_09->HrefValue = "";
        $this->description_09->TooltipValue = "";

        // description_10
        $this->description_10->HrefValue = "";
        $this->description_10->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // a_datetime
        $this->a_datetime->HrefValue = "";
        $this->a_datetime->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // programme_datetime
        $this->programme_datetime->setupEditAttributes();
        $this->programme_datetime->EditValue = FormatDateTime($this->programme_datetime->CurrentValue, $this->programme_datetime->formatPattern());
        $this->programme_datetime->PlaceHolder = RemoveHtml($this->programme_datetime->caption());

        // programme_end_datetime
        $this->programme_end_datetime->setupEditAttributes();
        $this->programme_end_datetime->EditValue = FormatDateTime($this->programme_end_datetime->CurrentValue, $this->programme_end_datetime->formatPattern());
        $this->programme_end_datetime->PlaceHolder = RemoveHtml($this->programme_end_datetime->caption());

        // location
        $this->location->setupEditAttributes();
        if (!$this->location->Raw) {
            $this->location->CurrentValue = HtmlDecode($this->location->CurrentValue);
        }
        $this->location->EditValue = $this->location->CurrentValue;
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());

        // item
        $this->item->setupEditAttributes();
        if (!$this->item->Raw) {
            $this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
        }
        $this->item->EditValue = $this->item->CurrentValue;
        $this->item->PlaceHolder = RemoveHtml($this->item->caption());

        // contact_person
        $this->contact_person->setupEditAttributes();
        if (!$this->contact_person->Raw) {
            $this->contact_person->CurrentValue = HtmlDecode($this->contact_person->CurrentValue);
        }
        $this->contact_person->EditValue = $this->contact_person->CurrentValue;
        $this->contact_person->PlaceHolder = RemoveHtml($this->contact_person->caption());

        // amount
        $this->amount->setupEditAttributes();
        if (!$this->amount->Raw) {
            $this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
        }
        $this->amount->EditValue = $this->amount->CurrentValue;
        $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

        // booking_ref
        $this->booking_ref->setupEditAttributes();
        if (!$this->booking_ref->Raw) {
            $this->booking_ref->CurrentValue = HtmlDecode($this->booking_ref->CurrentValue);
        }
        $this->booking_ref->EditValue = $this->booking_ref->CurrentValue;
        $this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->EditValue = $this->company_id->CurrentValue;
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // payment_terms
        $this->payment_terms->setupEditAttributes();
        $this->payment_terms->PlaceHolder = RemoveHtml($this->payment_terms->caption());

        // job_category
        $this->job_category->EditValue = $this->job_category->options(false);
        $this->job_category->PlaceHolder = RemoveHtml($this->job_category->caption());

        // type
        $this->type->setupEditAttributes();
        $this->type->EditValue = $this->type->options(true);
        $this->type->PlaceHolder = RemoveHtml($this->type->caption());

        // buyer_instruction
        $this->buyer_instruction->setupEditAttributes();
        $this->buyer_instruction->EditValue = $this->buyer_instruction->CurrentValue;
        $this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // eastimated_amount
        $this->eastimated_amount->setupEditAttributes();
        $this->eastimated_amount->EditCustomAttributes = $this->eastimated_amount->getEditCustomAttributes(); // PHP
        $this->eastimated_amount->EditValue = $this->eastimated_amount->CurrentValue;
        $this->eastimated_amount->PlaceHolder = RemoveHtml($this->eastimated_amount->caption());
        if (strval($this->eastimated_amount->EditValue) != "" && is_numeric($this->eastimated_amount->EditValue)) {
            $this->eastimated_amount->EditValue = FormatNumber($this->eastimated_amount->EditValue, null);
        }

        // gst
        $this->gst->setupEditAttributes();
        $this->gst->PlaceHolder = RemoveHtml($this->gst->caption());

        // uploads
        $this->uploads->setupEditAttributes();
        $this->uploads->UploadPath = $this->uploads->getUploadPath(); // PHP
        if (!EmptyValue($this->uploads->Upload->DbValue)) {
            $this->uploads->ImageWidth = 0;
            $this->uploads->ImageHeight = 50;
            $this->uploads->ImageAlt = $this->uploads->alt();
            $this->uploads->ImageCssClass = "ew-image";
            $this->uploads->EditValue = $this->uploads->Upload->DbValue;
        } else {
            $this->uploads->EditValue = "";
        }
        if (!EmptyValue($this->uploads->CurrentValue)) {
            $this->uploads->Upload->FileName = $this->uploads->CurrentValue;
        }

        // reports_to
        $this->reports_to->setupEditAttributes();
        $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

        // description_01
        $this->description_01->PlaceHolder = RemoveHtml($this->description_01->caption());

        // description_02
        $this->description_02->PlaceHolder = RemoveHtml($this->description_02->caption());

        // description_03
        $this->description_03->PlaceHolder = RemoveHtml($this->description_03->caption());

        // description_04
        $this->description_04->PlaceHolder = RemoveHtml($this->description_04->caption());

        // description_05
        $this->description_05->PlaceHolder = RemoveHtml($this->description_05->caption());

        // description_06
        $this->description_06->PlaceHolder = RemoveHtml($this->description_06->caption());

        // description_07
        $this->description_07->PlaceHolder = RemoveHtml($this->description_07->caption());

        // description_08
        $this->description_08->PlaceHolder = RemoveHtml($this->description_08->caption());

        // description_09
        $this->description_09->PlaceHolder = RemoveHtml($this->description_09->caption());

        // description_10
        $this->description_10->PlaceHolder = RemoveHtml($this->description_10->caption());

        // operator

        // datetime

        // a_operator

        // a_datetime

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->programme_datetime);
                    $doc->exportCaption($this->programme_end_datetime);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->item);
                    $doc->exportCaption($this->contact_person);
                    $doc->exportCaption($this->booking_ref);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->buyer_instruction);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->description_01);
                    $doc->exportCaption($this->description_02);
                    $doc->exportCaption($this->description_03);
                    $doc->exportCaption($this->description_04);
                    $doc->exportCaption($this->description_05);
                    $doc->exportCaption($this->description_06);
                    $doc->exportCaption($this->description_07);
                    $doc->exportCaption($this->description_08);
                    $doc->exportCaption($this->description_09);
                    $doc->exportCaption($this->description_10);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->programme_datetime);
                    $doc->exportCaption($this->programme_end_datetime);
                    $doc->exportCaption($this->item);
                    $doc->exportCaption($this->contact_person);
                    $doc->exportCaption($this->amount);
                    $doc->exportCaption($this->booking_ref);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->payment_terms);
                    $doc->exportCaption($this->type);
                    $doc->exportCaption($this->gst);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->programme_datetime);
                        $doc->exportField($this->programme_end_datetime);
                        $doc->exportField($this->location);
                        $doc->exportField($this->item);
                        $doc->exportField($this->contact_person);
                        $doc->exportField($this->booking_ref);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->type);
                        $doc->exportField($this->buyer_instruction);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->description_01);
                        $doc->exportField($this->description_02);
                        $doc->exportField($this->description_03);
                        $doc->exportField($this->description_04);
                        $doc->exportField($this->description_05);
                        $doc->exportField($this->description_06);
                        $doc->exportField($this->description_07);
                        $doc->exportField($this->description_08);
                        $doc->exportField($this->description_09);
                        $doc->exportField($this->description_10);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->programme_datetime);
                        $doc->exportField($this->programme_end_datetime);
                        $doc->exportField($this->item);
                        $doc->exportField($this->contact_person);
                        $doc->exportField($this->amount);
                        $doc->exportField($this->booking_ref);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->payment_terms);
                        $doc->exportField($this->type);
                        $doc->exportField($this->gst);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'uploads') {
            $fldName = "uploads";
            $fileNameFld = "uploads";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'rental_po');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'rental_po', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'rental_po', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'rental_po', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
