<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RefSearch extends Ref
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RefSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "refsearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->oid->Visible = false;
        $this->company_id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_type->setVisibility();
        $this->packing_type->setVisibility();
        $this->product_n->setVisibility();
        $this->_barcode->Visible = false;
        $this->product_code_type->setVisibility();
        $this->product_code->setVisibility();
        $this->print_name->Visible = false;
        $this->gcode->Visible = false;
        $this->code->Visible = false;
        $this->product_id->Visible = false;
        $this->batch_no->Visible = false;
        $this->set_ref->Visible = false;
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_02->setVisibility();
        $this->v_03->setVisibility();
        $this->v_04->setVisibility();
        $this->v_05->setVisibility();
        $this->v_06->setVisibility();
        $this->v_07->setVisibility();
        $this->v_08->setVisibility();
        $this->v_09->setVisibility();
        $this->v_10->setVisibility();
        $this->cbm->Visible = false;
        $this->sqm->Visible = false;
        $this->shape->Visible = false;
        $this->q_sku->setVisibility();
        $this->b_01->setVisibility();
        $this->b_02->setVisibility();
        $this->b_03->setVisibility();
        $this->b_04->setVisibility();
        $this->b_05->setVisibility();
        $this->b_06->setVisibility();
        $this->b_07->setVisibility();
        $this->b_08->setVisibility();
        $this->b_09->setVisibility();
        $this->b_10->setVisibility();
        $this->b_11->setVisibility();
        $this->b_12->setVisibility();
        $this->b_13->setVisibility();
        $this->b_14->setVisibility();
        $this->b_15->setVisibility();
        $this->t_01->setVisibility();
        $this->t_02->setVisibility();
        $this->t_03->setVisibility();
        $this->t_04->setVisibility();
        $this->t_05->setVisibility();
        $this->t_06->setVisibility();
        $this->t_07->setVisibility();
        $this->t_08->setVisibility();
        $this->t_09->setVisibility();
        $this->t_10->setVisibility();
        $this->t_11->setVisibility();
        $this->t_12->setVisibility();
        $this->t_13->setVisibility();
        $this->t_14->setVisibility();
        $this->t_15->setVisibility();
        $this->last_price->setVisibility();
        $this->currency->setVisibility();
        $this->hsn->setVisibility();
        $this->composition->setVisibility();
        $this->category->setVisibility();
        $this->moq->setVisibility();
        $this->status->setVisibility();
        $this->d_head_01->setVisibility();
        $this->d_description_01->setVisibility();
        $this->d_head_02->setVisibility();
        $this->d_description_02->setVisibility();
        $this->publish->setVisibility();
        $this->keywords->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->main_image->Visible = false;
        $this->top_view->Visible = false;
        $this->front_view->Visible = false;
        $this->corner_view->Visible = false;
        $this->back_view->Visible = false;
        $this->color_options->Visible = false;
        $this->other_options->Visible = false;
        $this->group_image->Visible = false;
        $this->video_url->Visible = false;
        $this->image->Visible = false;
        $this->in->Visible = false;
        $this->out->Visible = false;
        $this->required->Visible = false;
        $this->blocked->Visible = false;
        $this->ordered->Visible = false;
        $this->supplier->Visible = false;
        $this->country->Visible = false;
        $this->minimum_stock->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ref';
        $this->TableName = 'ref';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ref)
        if (!isset($GLOBALS["ref"]) || $GLOBALS["ref"]::class == PROJECT_NAMESPACE . "ref") {
            $GLOBALS["ref"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "refview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
                $this->main_image->UploadPath = $this->main_image->OldUploadPath;
                $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
                $this->top_view->UploadPath = $this->top_view->OldUploadPath;
                $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
                $this->front_view->UploadPath = $this->front_view->OldUploadPath;
                $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
                $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
                $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
                $this->back_view->UploadPath = $this->back_view->OldUploadPath;
                $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
                $this->color_options->UploadPath = $this->color_options->OldUploadPath;
                $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
                $this->other_options->UploadPath = $this->other_options->OldUploadPath;
                $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
                $this->group_image->UploadPath = $this->group_image->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code_type);
        $this->setupLookupOptions($this->set_ref);
        $this->setupLookupOptions($this->v_01);
        $this->setupLookupOptions($this->v_02);
        $this->setupLookupOptions($this->v_03);
        $this->setupLookupOptions($this->v_04);
        $this->setupLookupOptions($this->v_05);
        $this->setupLookupOptions($this->v_06);
        $this->setupLookupOptions($this->v_07);
        $this->setupLookupOptions($this->v_08);
        $this->setupLookupOptions($this->v_09);
        $this->setupLookupOptions($this->v_10);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->b_03);
        $this->setupLookupOptions($this->b_04);
        $this->setupLookupOptions($this->b_05);
        $this->setupLookupOptions($this->b_06);
        $this->setupLookupOptions($this->b_07);
        $this->setupLookupOptions($this->b_08);
        $this->setupLookupOptions($this->b_09);
        $this->setupLookupOptions($this->b_10);
        $this->setupLookupOptions($this->t_03);
        $this->setupLookupOptions($this->t_04);
        $this->setupLookupOptions($this->t_05);
        $this->setupLookupOptions($this->t_06);
        $this->setupLookupOptions($this->t_07);
        $this->setupLookupOptions($this->t_08);
        $this->setupLookupOptions($this->t_09);
        $this->setupLookupOptions($this->t_10);
        $this->setupLookupOptions($this->t_11);
        $this->setupLookupOptions($this->t_12);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->hsn);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->publish);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "reflist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->company_id); // company_id
        $this->buildSearchUrl($srchUrl, $this->grp); // grp
        $this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->product_type); // product_type
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->product_n); // product_n
        $this->buildSearchUrl($srchUrl, $this->product_code_type); // product_code_type
        $this->buildSearchUrl($srchUrl, $this->product_code); // product_code
        $this->buildSearchUrl($srchUrl, $this->v_00); // v_00
        $this->buildSearchUrl($srchUrl, $this->v_01); // v_01
        $this->buildSearchUrl($srchUrl, $this->v_02); // v_02
        $this->buildSearchUrl($srchUrl, $this->v_03); // v_03
        $this->buildSearchUrl($srchUrl, $this->v_04); // v_04
        $this->buildSearchUrl($srchUrl, $this->v_05); // v_05
        $this->buildSearchUrl($srchUrl, $this->v_06); // v_06
        $this->buildSearchUrl($srchUrl, $this->v_07); // v_07
        $this->buildSearchUrl($srchUrl, $this->v_08); // v_08
        $this->buildSearchUrl($srchUrl, $this->v_09); // v_09
        $this->buildSearchUrl($srchUrl, $this->v_10); // v_10
        $this->buildSearchUrl($srchUrl, $this->q_sku); // q_sku
        $this->buildSearchUrl($srchUrl, $this->b_01); // b_01
        $this->buildSearchUrl($srchUrl, $this->b_02); // b_02
        $this->buildSearchUrl($srchUrl, $this->b_03); // b_03
        $this->buildSearchUrl($srchUrl, $this->b_04); // b_04
        $this->buildSearchUrl($srchUrl, $this->b_05); // b_05
        $this->buildSearchUrl($srchUrl, $this->b_06); // b_06
        $this->buildSearchUrl($srchUrl, $this->b_07); // b_07
        $this->buildSearchUrl($srchUrl, $this->b_08); // b_08
        $this->buildSearchUrl($srchUrl, $this->b_09); // b_09
        $this->buildSearchUrl($srchUrl, $this->b_10); // b_10
        $this->buildSearchUrl($srchUrl, $this->b_11); // b_11
        $this->buildSearchUrl($srchUrl, $this->b_12); // b_12
        $this->buildSearchUrl($srchUrl, $this->b_13); // b_13
        $this->buildSearchUrl($srchUrl, $this->b_14); // b_14
        $this->buildSearchUrl($srchUrl, $this->b_15); // b_15
        $this->buildSearchUrl($srchUrl, $this->t_01); // t_01
        $this->buildSearchUrl($srchUrl, $this->t_02); // t_02
        $this->buildSearchUrl($srchUrl, $this->t_03); // t_03
        $this->buildSearchUrl($srchUrl, $this->t_04); // t_04
        $this->buildSearchUrl($srchUrl, $this->t_05); // t_05
        $this->buildSearchUrl($srchUrl, $this->t_06); // t_06
        $this->buildSearchUrl($srchUrl, $this->t_07); // t_07
        $this->buildSearchUrl($srchUrl, $this->t_08); // t_08
        $this->buildSearchUrl($srchUrl, $this->t_09); // t_09
        $this->buildSearchUrl($srchUrl, $this->t_10); // t_10
        $this->buildSearchUrl($srchUrl, $this->t_11); // t_11
        $this->buildSearchUrl($srchUrl, $this->t_12); // t_12
        $this->buildSearchUrl($srchUrl, $this->t_13); // t_13
        $this->buildSearchUrl($srchUrl, $this->t_14); // t_14
        $this->buildSearchUrl($srchUrl, $this->t_15); // t_15
        $this->buildSearchUrl($srchUrl, $this->last_price); // last_price
        $this->buildSearchUrl($srchUrl, $this->currency); // currency
        $this->buildSearchUrl($srchUrl, $this->hsn); // hsn
        $this->buildSearchUrl($srchUrl, $this->composition); // composition
        $this->buildSearchUrl($srchUrl, $this->category); // category
        $this->buildSearchUrl($srchUrl, $this->moq); // moq
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->d_head_01); // d_head_01
        $this->buildSearchUrl($srchUrl, $this->d_description_01); // d_description_01
        $this->buildSearchUrl($srchUrl, $this->d_head_02); // d_head_02
        $this->buildSearchUrl($srchUrl, $this->d_description_02); // d_description_02
        $this->buildSearchUrl($srchUrl, $this->publish); // publish
        $this->buildSearchUrl($srchUrl, $this->keywords); // keywords
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->company_id->AdvancedSearch->SearchValue)) {
            $this->company_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->company_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->company_id->AdvancedSearch->SearchValue2)) {
            $this->company_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->company_id->AdvancedSearch->SearchValue2);
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_n
        if ($this->product_n->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_code_type
        if ($this->product_code_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_00
        if ($this->v_00->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_01
        if ($this->v_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_02
        if ($this->v_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_03
        if ($this->v_03->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_04
        if ($this->v_04->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_05
        if ($this->v_05->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_06
        if ($this->v_06->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_07
        if ($this->v_07->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_08
        if ($this->v_08->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_09
        if ($this->v_09->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_10
        if ($this->v_10->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // q_sku
        if ($this->q_sku->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_01
        if ($this->b_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_02
        if ($this->b_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_03
        if ($this->b_03->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_03->AdvancedSearch->SearchValue)) {
            $this->b_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_03->AdvancedSearch->SearchValue2)) {
            $this->b_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_03->AdvancedSearch->SearchValue2);
        }

        // b_04
        if ($this->b_04->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_04->AdvancedSearch->SearchValue)) {
            $this->b_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_04->AdvancedSearch->SearchValue2)) {
            $this->b_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_04->AdvancedSearch->SearchValue2);
        }

        // b_05
        if ($this->b_05->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_05->AdvancedSearch->SearchValue)) {
            $this->b_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_05->AdvancedSearch->SearchValue2)) {
            $this->b_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_05->AdvancedSearch->SearchValue2);
        }

        // b_06
        if ($this->b_06->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_06->AdvancedSearch->SearchValue)) {
            $this->b_06->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_06->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_06->AdvancedSearch->SearchValue2)) {
            $this->b_06->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_06->AdvancedSearch->SearchValue2);
        }

        // b_07
        if ($this->b_07->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_07->AdvancedSearch->SearchValue)) {
            $this->b_07->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_07->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_07->AdvancedSearch->SearchValue2)) {
            $this->b_07->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_07->AdvancedSearch->SearchValue2);
        }

        // b_08
        if ($this->b_08->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_08->AdvancedSearch->SearchValue)) {
            $this->b_08->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_08->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_08->AdvancedSearch->SearchValue2)) {
            $this->b_08->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_08->AdvancedSearch->SearchValue2);
        }

        // b_09
        if ($this->b_09->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_09->AdvancedSearch->SearchValue)) {
            $this->b_09->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_09->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_09->AdvancedSearch->SearchValue2)) {
            $this->b_09->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_09->AdvancedSearch->SearchValue2);
        }

        // b_10
        if ($this->b_10->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->b_10->AdvancedSearch->SearchValue)) {
            $this->b_10->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_10->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_10->AdvancedSearch->SearchValue2)) {
            $this->b_10->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_10->AdvancedSearch->SearchValue2);
        }

        // b_11
        if ($this->b_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_12
        if ($this->b_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_13
        if ($this->b_13->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_14
        if ($this->b_14->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_15
        if ($this->b_15->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_01
        if ($this->t_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_02
        if ($this->t_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_03
        if ($this->t_03->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_03->AdvancedSearch->SearchValue)) {
            $this->t_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_03->AdvancedSearch->SearchValue2)) {
            $this->t_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_03->AdvancedSearch->SearchValue2);
        }

        // t_04
        if ($this->t_04->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_04->AdvancedSearch->SearchValue)) {
            $this->t_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_04->AdvancedSearch->SearchValue2)) {
            $this->t_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_04->AdvancedSearch->SearchValue2);
        }

        // t_05
        if ($this->t_05->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_05->AdvancedSearch->SearchValue)) {
            $this->t_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_05->AdvancedSearch->SearchValue2)) {
            $this->t_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_05->AdvancedSearch->SearchValue2);
        }

        // t_06
        if ($this->t_06->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_06->AdvancedSearch->SearchValue)) {
            $this->t_06->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_06->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_06->AdvancedSearch->SearchValue2)) {
            $this->t_06->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_06->AdvancedSearch->SearchValue2);
        }

        // t_07
        if ($this->t_07->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_07->AdvancedSearch->SearchValue)) {
            $this->t_07->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_07->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_07->AdvancedSearch->SearchValue2)) {
            $this->t_07->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_07->AdvancedSearch->SearchValue2);
        }

        // t_08
        if ($this->t_08->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_08->AdvancedSearch->SearchValue)) {
            $this->t_08->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_08->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_08->AdvancedSearch->SearchValue2)) {
            $this->t_08->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_08->AdvancedSearch->SearchValue2);
        }

        // t_09
        if ($this->t_09->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_09->AdvancedSearch->SearchValue)) {
            $this->t_09->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_09->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_09->AdvancedSearch->SearchValue2)) {
            $this->t_09->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_09->AdvancedSearch->SearchValue2);
        }

        // t_10
        if ($this->t_10->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->t_10->AdvancedSearch->SearchValue)) {
            $this->t_10->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_10->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_10->AdvancedSearch->SearchValue2)) {
            $this->t_10->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_10->AdvancedSearch->SearchValue2);
        }

        // t_11
        if ($this->t_11->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_12
        if ($this->t_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_13
        if ($this->t_13->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_14
        if ($this->t_14->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // t_15
        if ($this->t_15->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // last_price
        if ($this->last_price->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // hsn
        if ($this->hsn->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // composition
        if ($this->composition->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // moq
        if ($this->moq->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_head_01
        if ($this->d_head_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_description_01
        if ($this->d_description_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_head_02
        if ($this->d_head_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // d_description_02
        if ($this->d_description_02->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // publish
        if ($this->publish->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // keywords
        if ($this->keywords->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // oid
        $this->oid->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // product_n
        $this->product_n->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // product_code_type
        $this->product_code_type->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // print_name
        $this->print_name->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // product_id
        $this->product_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // set_ref
        $this->set_ref->RowCssClass = "row";

        // v_00
        $this->v_00->RowCssClass = "row";

        // v_01
        $this->v_01->RowCssClass = "row";

        // v_02
        $this->v_02->RowCssClass = "row";

        // v_03
        $this->v_03->RowCssClass = "row";

        // v_04
        $this->v_04->RowCssClass = "row";

        // v_05
        $this->v_05->RowCssClass = "row";

        // v_06
        $this->v_06->RowCssClass = "row";

        // v_07
        $this->v_07->RowCssClass = "row";

        // v_08
        $this->v_08->RowCssClass = "row";

        // v_09
        $this->v_09->RowCssClass = "row";

        // v_10
        $this->v_10->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // b_01
        $this->b_01->RowCssClass = "row";

        // b_02
        $this->b_02->RowCssClass = "row";

        // b_03
        $this->b_03->RowCssClass = "row";

        // b_04
        $this->b_04->RowCssClass = "row";

        // b_05
        $this->b_05->RowCssClass = "row";

        // b_06
        $this->b_06->RowCssClass = "row";

        // b_07
        $this->b_07->RowCssClass = "row";

        // b_08
        $this->b_08->RowCssClass = "row";

        // b_09
        $this->b_09->RowCssClass = "row";

        // b_10
        $this->b_10->RowCssClass = "row";

        // b_11
        $this->b_11->RowCssClass = "row";

        // b_12
        $this->b_12->RowCssClass = "row";

        // b_13
        $this->b_13->RowCssClass = "row";

        // b_14
        $this->b_14->RowCssClass = "row";

        // b_15
        $this->b_15->RowCssClass = "row";

        // t_01
        $this->t_01->RowCssClass = "row";

        // t_02
        $this->t_02->RowCssClass = "row";

        // t_03
        $this->t_03->RowCssClass = "row";

        // t_04
        $this->t_04->RowCssClass = "row";

        // t_05
        $this->t_05->RowCssClass = "row";

        // t_06
        $this->t_06->RowCssClass = "row";

        // t_07
        $this->t_07->RowCssClass = "row";

        // t_08
        $this->t_08->RowCssClass = "row";

        // t_09
        $this->t_09->RowCssClass = "row";

        // t_10
        $this->t_10->RowCssClass = "row";

        // t_11
        $this->t_11->RowCssClass = "row";

        // t_12
        $this->t_12->RowCssClass = "row";

        // t_13
        $this->t_13->RowCssClass = "row";

        // t_14
        $this->t_14->RowCssClass = "row";

        // t_15
        $this->t_15->RowCssClass = "row";

        // last_price
        $this->last_price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // hsn
        $this->hsn->RowCssClass = "row";

        // composition
        $this->composition->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // moq
        $this->moq->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // d_head_01
        $this->d_head_01->RowCssClass = "row";

        // d_description_01
        $this->d_description_01->RowCssClass = "row";

        // d_head_02
        $this->d_head_02->RowCssClass = "row";

        // d_description_02
        $this->d_description_02->RowCssClass = "row";

        // publish
        $this->publish->RowCssClass = "row";

        // keywords
        $this->keywords->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // main_image
        $this->main_image->RowCssClass = "row";

        // top_view
        $this->top_view->RowCssClass = "row";

        // front_view
        $this->front_view->RowCssClass = "row";

        // corner_view
        $this->corner_view->RowCssClass = "row";

        // back_view
        $this->back_view->RowCssClass = "row";

        // color_options
        $this->color_options->RowCssClass = "row";

        // other_options
        $this->other_options->RowCssClass = "row";

        // group_image
        $this->group_image->RowCssClass = "row";

        // video_url
        $this->video_url->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // in
        $this->in->RowCssClass = "row";

        // out
        $this->out->RowCssClass = "row";

        // required
        $this->required->RowCssClass = "row";

        // blocked
        $this->blocked->RowCssClass = "row";

        // ordered
        $this->ordered->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // minimum_stock
        $this->minimum_stock->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->company_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->company_id->Lookup->renderViewRow($row);
                            $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                        }
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_n
            $this->product_n->ViewValue = $this->product_n->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // product_code_type
            if (strval($this->product_code_type->CurrentValue) != "") {
                $this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
            } else {
                $this->product_code_type->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // set_ref
            $curVal = strval($this->set_ref->CurrentValue);
            if ($curVal != "") {
                $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
                if ($this->set_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->set_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->set_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                            $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->set_ref->ViewValue = $this->set_ref->CurrentValue;
                    }
                }
            } else {
                $this->set_ref->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $curVal = strval($this->v_01->CurrentValue);
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
                if ($this->v_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_01->Lookup->renderViewRow($rswrk[0]);
                        $this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
                    } else {
                        $this->v_01->ViewValue = $this->v_01->CurrentValue;
                    }
                }
            } else {
                $this->v_01->ViewValue = null;
            }

            // v_02
            $curVal = strval($this->v_02->CurrentValue);
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
                if ($this->v_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_02->Lookup->renderViewRow($rswrk[0]);
                        $this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
                    } else {
                        $this->v_02->ViewValue = $this->v_02->CurrentValue;
                    }
                }
            } else {
                $this->v_02->ViewValue = null;
            }

            // v_03
            $curVal = strval($this->v_03->CurrentValue);
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
                if ($this->v_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_03->Lookup->renderViewRow($rswrk[0]);
                        $this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
                    } else {
                        $this->v_03->ViewValue = $this->v_03->CurrentValue;
                    }
                }
            } else {
                $this->v_03->ViewValue = null;
            }

            // v_04
            $curVal = strval($this->v_04->CurrentValue);
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
                if ($this->v_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_04->Lookup->renderViewRow($rswrk[0]);
                        $this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
                    } else {
                        $this->v_04->ViewValue = $this->v_04->CurrentValue;
                    }
                }
            } else {
                $this->v_04->ViewValue = null;
            }

            // v_05
            $curVal = strval($this->v_05->CurrentValue);
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
                if ($this->v_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_05->Lookup->renderViewRow($rswrk[0]);
                        $this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
                    } else {
                        $this->v_05->ViewValue = $this->v_05->CurrentValue;
                    }
                }
            } else {
                $this->v_05->ViewValue = null;
            }

            // v_06
            $curVal = strval($this->v_06->CurrentValue);
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
                if ($this->v_06->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_06->Lookup->renderViewRow($rswrk[0]);
                        $this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
                    } else {
                        $this->v_06->ViewValue = $this->v_06->CurrentValue;
                    }
                }
            } else {
                $this->v_06->ViewValue = null;
            }

            // v_07
            $curVal = strval($this->v_07->CurrentValue);
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
                if ($this->v_07->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_07->Lookup->renderViewRow($rswrk[0]);
                        $this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
                    } else {
                        $this->v_07->ViewValue = $this->v_07->CurrentValue;
                    }
                }
            } else {
                $this->v_07->ViewValue = null;
            }

            // v_08
            $curVal = strval($this->v_08->CurrentValue);
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
                if ($this->v_08->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_08->Lookup->renderViewRow($rswrk[0]);
                        $this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
                    } else {
                        $this->v_08->ViewValue = $this->v_08->CurrentValue;
                    }
                }
            } else {
                $this->v_08->ViewValue = null;
            }

            // v_09
            $curVal = strval($this->v_09->CurrentValue);
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
                if ($this->v_09->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_09->Lookup->renderViewRow($rswrk[0]);
                        $this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
                    } else {
                        $this->v_09->ViewValue = $this->v_09->CurrentValue;
                    }
                }
            } else {
                $this->v_09->ViewValue = null;
            }

            // v_10
            $curVal = strval($this->v_10->CurrentValue);
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
                if ($this->v_10->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_10->Lookup->renderViewRow($rswrk[0]);
                        $this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
                    } else {
                        $this->v_10->ViewValue = $this->v_10->CurrentValue;
                    }
                }
            } else {
                $this->v_10->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // b_01
            $this->b_01->ViewValue = $this->b_01->CurrentValue;

            // b_02
            $this->b_02->ViewValue = $this->b_02->CurrentValue;

            // b_03
            $curVal = strval($this->b_03->CurrentValue);
            if ($curVal != "") {
                $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
                if ($this->b_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_03->Lookup->renderViewRow($row);
                            $this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
                        }
                    } else {
                        $this->b_03->ViewValue = $this->b_03->CurrentValue;
                    }
                }
            } else {
                $this->b_03->ViewValue = null;
            }

            // b_04
            $curVal = strval($this->b_04->CurrentValue);
            if ($curVal != "") {
                $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
                if ($this->b_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_04->Lookup->renderViewRow($row);
                            $this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
                        }
                    } else {
                        $this->b_04->ViewValue = $this->b_04->CurrentValue;
                    }
                }
            } else {
                $this->b_04->ViewValue = null;
            }

            // b_05
            $curVal = strval($this->b_05->CurrentValue);
            if ($curVal != "") {
                $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
                if ($this->b_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_05->Lookup->renderViewRow($row);
                            $this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
                        }
                    } else {
                        $this->b_05->ViewValue = $this->b_05->CurrentValue;
                    }
                }
            } else {
                $this->b_05->ViewValue = null;
            }

            // b_06
            $curVal = strval($this->b_06->CurrentValue);
            if ($curVal != "") {
                $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
                if ($this->b_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_06->Lookup->renderViewRow($row);
                            $this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
                        }
                    } else {
                        $this->b_06->ViewValue = $this->b_06->CurrentValue;
                    }
                }
            } else {
                $this->b_06->ViewValue = null;
            }

            // b_07
            $curVal = strval($this->b_07->CurrentValue);
            if ($curVal != "") {
                $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
                if ($this->b_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_07->Lookup->renderViewRow($row);
                            $this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
                        }
                    } else {
                        $this->b_07->ViewValue = $this->b_07->CurrentValue;
                    }
                }
            } else {
                $this->b_07->ViewValue = null;
            }

            // b_08
            $curVal = strval($this->b_08->CurrentValue);
            if ($curVal != "") {
                $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
                if ($this->b_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_08->Lookup->renderViewRow($row);
                            $this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
                        }
                    } else {
                        $this->b_08->ViewValue = $this->b_08->CurrentValue;
                    }
                }
            } else {
                $this->b_08->ViewValue = null;
            }

            // b_09
            $curVal = strval($this->b_09->CurrentValue);
            if ($curVal != "") {
                $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
                if ($this->b_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_09->Lookup->renderViewRow($row);
                            $this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
                        }
                    } else {
                        $this->b_09->ViewValue = $this->b_09->CurrentValue;
                    }
                }
            } else {
                $this->b_09->ViewValue = null;
            }

            // b_10
            $curVal = strval($this->b_10->CurrentValue);
            if ($curVal != "") {
                $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
                if ($this->b_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_10->Lookup->renderViewRow($row);
                            $this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
                        }
                    } else {
                        $this->b_10->ViewValue = $this->b_10->CurrentValue;
                    }
                }
            } else {
                $this->b_10->ViewValue = null;
            }

            // b_11
            $this->b_11->ViewValue = $this->b_11->CurrentValue;

            // b_12
            $this->b_12->ViewValue = $this->b_12->CurrentValue;

            // b_13
            $this->b_13->ViewValue = $this->b_13->CurrentValue;

            // b_14
            $this->b_14->ViewValue = $this->b_14->CurrentValue;

            // b_15
            $this->b_15->ViewValue = $this->b_15->CurrentValue;

            // t_01
            $this->t_01->ViewValue = $this->t_01->CurrentValue;

            // t_02
            $this->t_02->ViewValue = $this->t_02->CurrentValue;

            // t_03
            $curVal = strval($this->t_03->CurrentValue);
            if ($curVal != "") {
                $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
                if ($this->t_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_03->Lookup->renderViewRow($row);
                            $this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
                        }
                    } else {
                        $this->t_03->ViewValue = $this->t_03->CurrentValue;
                    }
                }
            } else {
                $this->t_03->ViewValue = null;
            }

            // t_04
            $curVal = strval($this->t_04->CurrentValue);
            if ($curVal != "") {
                $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
                if ($this->t_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_04->Lookup->renderViewRow($row);
                            $this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
                        }
                    } else {
                        $this->t_04->ViewValue = $this->t_04->CurrentValue;
                    }
                }
            } else {
                $this->t_04->ViewValue = null;
            }

            // t_05
            $curVal = strval($this->t_05->CurrentValue);
            if ($curVal != "") {
                $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
                if ($this->t_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_05->Lookup->renderViewRow($row);
                            $this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
                        }
                    } else {
                        $this->t_05->ViewValue = $this->t_05->CurrentValue;
                    }
                }
            } else {
                $this->t_05->ViewValue = null;
            }

            // t_06
            $curVal = strval($this->t_06->CurrentValue);
            if ($curVal != "") {
                $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
                if ($this->t_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_06->Lookup->renderViewRow($row);
                            $this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
                        }
                    } else {
                        $this->t_06->ViewValue = $this->t_06->CurrentValue;
                    }
                }
            } else {
                $this->t_06->ViewValue = null;
            }

            // t_07
            $curVal = strval($this->t_07->CurrentValue);
            if ($curVal != "") {
                $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
                if ($this->t_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_07->Lookup->renderViewRow($row);
                            $this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
                        }
                    } else {
                        $this->t_07->ViewValue = $this->t_07->CurrentValue;
                    }
                }
            } else {
                $this->t_07->ViewValue = null;
            }

            // t_08
            $curVal = strval($this->t_08->CurrentValue);
            if ($curVal != "") {
                $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
                if ($this->t_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_08->Lookup->renderViewRow($row);
                            $this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
                        }
                    } else {
                        $this->t_08->ViewValue = $this->t_08->CurrentValue;
                    }
                }
            } else {
                $this->t_08->ViewValue = null;
            }

            // t_09
            $curVal = strval($this->t_09->CurrentValue);
            if ($curVal != "") {
                $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
                if ($this->t_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_09->Lookup->renderViewRow($row);
                            $this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
                        }
                    } else {
                        $this->t_09->ViewValue = $this->t_09->CurrentValue;
                    }
                }
            } else {
                $this->t_09->ViewValue = null;
            }

            // t_10
            $curVal = strval($this->t_10->CurrentValue);
            if ($curVal != "") {
                $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
                if ($this->t_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_10->Lookup->renderViewRow($row);
                            $this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
                        }
                    } else {
                        $this->t_10->ViewValue = $this->t_10->CurrentValue;
                    }
                }
            } else {
                $this->t_10->ViewValue = null;
            }

            // t_11
            $this->t_11->ViewValue = $this->t_11->CurrentValue;
            $curVal = strval($this->t_11->CurrentValue);
            if ($curVal != "") {
                $this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->ViewValue = $this->t_11->CurrentValue;
                    }
                }
            } else {
                $this->t_11->ViewValue = null;
            }

            // t_12
            $this->t_12->ViewValue = $this->t_12->CurrentValue;
            $curVal = strval($this->t_12->CurrentValue);
            if ($curVal != "") {
                $this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->ViewValue = $this->t_12->CurrentValue;
                    }
                }
            } else {
                $this->t_12->ViewValue = null;
            }

            // t_13
            $this->t_13->ViewValue = $this->t_13->CurrentValue;

            // t_14
            $this->t_14->ViewValue = $this->t_14->CurrentValue;

            // t_15
            $this->t_15->ViewValue = $this->t_15->CurrentValue;

            // last_price
            $this->last_price->ViewValue = $this->last_price->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // hsn
            $curVal = strval($this->hsn->CurrentValue);
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
                if ($this->hsn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                        $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                    } else {
                        $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                    }
                }
            } else {
                $this->hsn->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // moq
            $this->moq->ViewValue = $this->moq->CurrentValue;
            $this->moq->ViewValue = FormatNumber($this->moq->ViewValue, $this->moq->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // d_head_01
            $this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;

            // d_description_01
            $this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;

            // d_head_02
            $this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;

            // d_description_02
            $this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;

            // publish
            if (strval($this->publish->CurrentValue) != "") {
                $this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
            } else {
                $this->publish->ViewValue = null;
            }

            // keywords
            $this->keywords->ViewValue = $this->keywords->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // product_n
            $this->product_n->HrefValue = "";
            $this->product_n->TooltipValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";
            $this->product_code_type->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // v_00
            $this->v_00->HrefValue = "";
            $this->v_00->TooltipValue = "";

            // v_01
            $this->v_01->HrefValue = "";
            $this->v_01->TooltipValue = "";

            // v_02
            $this->v_02->HrefValue = "";
            $this->v_02->TooltipValue = "";

            // v_03
            $this->v_03->HrefValue = "";
            $this->v_03->TooltipValue = "";

            // v_04
            $this->v_04->HrefValue = "";
            $this->v_04->TooltipValue = "";

            // v_05
            $this->v_05->HrefValue = "";
            $this->v_05->TooltipValue = "";

            // v_06
            $this->v_06->HrefValue = "";
            $this->v_06->TooltipValue = "";

            // v_07
            $this->v_07->HrefValue = "";
            $this->v_07->TooltipValue = "";

            // v_08
            $this->v_08->HrefValue = "";
            $this->v_08->TooltipValue = "";

            // v_09
            $this->v_09->HrefValue = "";
            $this->v_09->TooltipValue = "";

            // v_10
            $this->v_10->HrefValue = "";
            $this->v_10->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // b_01
            $this->b_01->HrefValue = "";
            $this->b_01->TooltipValue = "";

            // b_02
            $this->b_02->HrefValue = "";
            $this->b_02->TooltipValue = "";

            // b_03
            $this->b_03->HrefValue = "";
            $this->b_03->TooltipValue = "";

            // b_04
            $this->b_04->HrefValue = "";
            $this->b_04->TooltipValue = "";

            // b_05
            $this->b_05->HrefValue = "";
            $this->b_05->TooltipValue = "";

            // b_06
            $this->b_06->HrefValue = "";
            $this->b_06->TooltipValue = "";

            // b_07
            $this->b_07->HrefValue = "";
            $this->b_07->TooltipValue = "";

            // b_08
            $this->b_08->HrefValue = "";
            $this->b_08->TooltipValue = "";

            // b_09
            $this->b_09->HrefValue = "";
            $this->b_09->TooltipValue = "";

            // b_10
            $this->b_10->HrefValue = "";
            $this->b_10->TooltipValue = "";

            // b_11
            $this->b_11->HrefValue = "";
            $this->b_11->TooltipValue = "";

            // b_12
            $this->b_12->HrefValue = "";
            $this->b_12->TooltipValue = "";

            // b_13
            $this->b_13->HrefValue = "";
            $this->b_13->TooltipValue = "";

            // b_14
            $this->b_14->HrefValue = "";
            $this->b_14->TooltipValue = "";

            // b_15
            $this->b_15->HrefValue = "";
            $this->b_15->TooltipValue = "";

            // t_01
            $this->t_01->HrefValue = "";
            $this->t_01->TooltipValue = "";

            // t_02
            $this->t_02->HrefValue = "";
            $this->t_02->TooltipValue = "";

            // t_03
            $this->t_03->HrefValue = "";
            $this->t_03->TooltipValue = "";

            // t_04
            $this->t_04->HrefValue = "";
            $this->t_04->TooltipValue = "";

            // t_05
            $this->t_05->HrefValue = "";
            $this->t_05->TooltipValue = "";

            // t_06
            $this->t_06->HrefValue = "";
            $this->t_06->TooltipValue = "";

            // t_07
            $this->t_07->HrefValue = "";
            $this->t_07->TooltipValue = "";

            // t_08
            $this->t_08->HrefValue = "";
            $this->t_08->TooltipValue = "";

            // t_09
            $this->t_09->HrefValue = "";
            $this->t_09->TooltipValue = "";

            // t_10
            $this->t_10->HrefValue = "";
            $this->t_10->TooltipValue = "";

            // t_11
            $this->t_11->HrefValue = "";
            $this->t_11->TooltipValue = "";

            // t_12
            $this->t_12->HrefValue = "";
            $this->t_12->TooltipValue = "";

            // t_13
            $this->t_13->HrefValue = "";
            $this->t_13->TooltipValue = "";

            // t_14
            $this->t_14->HrefValue = "";
            $this->t_14->TooltipValue = "";

            // t_15
            $this->t_15->HrefValue = "";
            $this->t_15->TooltipValue = "";

            // last_price
            $this->last_price->HrefValue = "";
            $this->last_price->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // hsn
            $this->hsn->HrefValue = "";
            $this->hsn->TooltipValue = "";

            // composition
            $this->composition->HrefValue = "";
            $this->composition->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // moq
            $this->moq->HrefValue = "";
            $this->moq->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // d_head_01
            $this->d_head_01->HrefValue = "";
            $this->d_head_01->TooltipValue = "";

            // d_description_01
            $this->d_description_01->HrefValue = "";
            $this->d_description_01->TooltipValue = "";

            // d_head_02
            $this->d_head_02->HrefValue = "";
            $this->d_head_02->TooltipValue = "";

            // d_description_02
            $this->d_description_02->HrefValue = "";
            $this->d_description_02->TooltipValue = "";

            // publish
            $this->publish->HrefValue = "";
            $this->publish->TooltipValue = "";

            // keywords
            $this->keywords->HrefValue = "";
            $this->keywords->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // company_id
            $curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
                if ($this->company_id->AdvancedSearch->ViewValue == "") {
                    $this->company_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->company_id->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->company_id->Lookup->renderViewRow($row);
                        $this->company_id->AdvancedSearch->ViewValue->add($this->company_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->company_id->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product_type->AdvancedSearch->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->AdvancedSearch->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->AdvancedSearch->SearchValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // product_n
            $this->product_n->setupEditAttributes();
            if (!$this->product_n->Raw) {
                $this->product_n->AdvancedSearch->SearchValue = HtmlDecode($this->product_n->AdvancedSearch->SearchValue);
            }
            $this->product_n->EditValue = HtmlEncode($this->product_n->AdvancedSearch->SearchValue);
            $this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

            // product_code_type
            $this->product_code_type->setupEditAttributes();
            $this->product_code_type->EditValue = $this->product_code_type->options(true);
            $this->product_code_type->PlaceHolder = RemoveHtml($this->product_code_type->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            $this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->AdvancedSearch->SearchValue = HtmlDecode($this->v_00->AdvancedSearch->SearchValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->AdvancedSearch->SearchValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // v_01
            $this->v_01->setupEditAttributes();
            $curVal = trim(strval($this->v_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_01->AdvancedSearch->ViewValue = $this->v_01->lookupCacheOption($curVal);
            } else {
                $this->v_01->AdvancedSearch->ViewValue = $this->v_01->Lookup !== null && is_array($this->v_01->lookupOptions()) && count($this->v_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_01->EditValue = array_values($this->v_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_01->AdvancedSearch->SearchValue, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_01->EditValue = $arwrk;
            }
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_02
            $this->v_02->setupEditAttributes();
            $curVal = trim(strval($this->v_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_02->AdvancedSearch->ViewValue = $this->v_02->lookupCacheOption($curVal);
            } else {
                $this->v_02->AdvancedSearch->ViewValue = $this->v_02->Lookup !== null && is_array($this->v_02->lookupOptions()) && count($this->v_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_02->EditValue = array_values($this->v_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_02->AdvancedSearch->SearchValue, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_02->EditValue = $arwrk;
            }
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_03
            $this->v_03->setupEditAttributes();
            $curVal = trim(strval($this->v_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_03->AdvancedSearch->ViewValue = $this->v_03->lookupCacheOption($curVal);
            } else {
                $this->v_03->AdvancedSearch->ViewValue = $this->v_03->Lookup !== null && is_array($this->v_03->lookupOptions()) && count($this->v_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_03->EditValue = array_values($this->v_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_03->AdvancedSearch->SearchValue, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_03->EditValue = $arwrk;
            }
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_04
            $this->v_04->setupEditAttributes();
            $curVal = trim(strval($this->v_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_04->AdvancedSearch->ViewValue = $this->v_04->lookupCacheOption($curVal);
            } else {
                $this->v_04->AdvancedSearch->ViewValue = $this->v_04->Lookup !== null && is_array($this->v_04->lookupOptions()) && count($this->v_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_04->EditValue = array_values($this->v_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_04->AdvancedSearch->SearchValue, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_04->EditValue = $arwrk;
            }
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_05
            $this->v_05->setupEditAttributes();
            $curVal = trim(strval($this->v_05->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_05->AdvancedSearch->ViewValue = $this->v_05->lookupCacheOption($curVal);
            } else {
                $this->v_05->AdvancedSearch->ViewValue = $this->v_05->Lookup !== null && is_array($this->v_05->lookupOptions()) && count($this->v_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_05->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_05->EditValue = array_values($this->v_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_05->AdvancedSearch->SearchValue, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_05->EditValue = $arwrk;
            }
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // v_06
            $this->v_06->setupEditAttributes();
            $curVal = trim(strval($this->v_06->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_06->AdvancedSearch->ViewValue = $this->v_06->lookupCacheOption($curVal);
            } else {
                $this->v_06->AdvancedSearch->ViewValue = $this->v_06->Lookup !== null && is_array($this->v_06->lookupOptions()) && count($this->v_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_06->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_06->EditValue = array_values($this->v_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_06->AdvancedSearch->SearchValue, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_06->EditValue = $arwrk;
            }
            $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

            // v_07
            $this->v_07->setupEditAttributes();
            $curVal = trim(strval($this->v_07->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_07->AdvancedSearch->ViewValue = $this->v_07->lookupCacheOption($curVal);
            } else {
                $this->v_07->AdvancedSearch->ViewValue = $this->v_07->Lookup !== null && is_array($this->v_07->lookupOptions()) && count($this->v_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_07->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_07->EditValue = array_values($this->v_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_07->AdvancedSearch->SearchValue, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_07->EditValue = $arwrk;
            }
            $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

            // v_08
            $this->v_08->setupEditAttributes();
            $curVal = trim(strval($this->v_08->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_08->AdvancedSearch->ViewValue = $this->v_08->lookupCacheOption($curVal);
            } else {
                $this->v_08->AdvancedSearch->ViewValue = $this->v_08->Lookup !== null && is_array($this->v_08->lookupOptions()) && count($this->v_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_08->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_08->EditValue = array_values($this->v_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_08->AdvancedSearch->SearchValue, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_08->EditValue = $arwrk;
            }
            $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

            // v_09
            $this->v_09->setupEditAttributes();
            $curVal = trim(strval($this->v_09->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_09->AdvancedSearch->ViewValue = $this->v_09->lookupCacheOption($curVal);
            } else {
                $this->v_09->AdvancedSearch->ViewValue = $this->v_09->Lookup !== null && is_array($this->v_09->lookupOptions()) && count($this->v_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_09->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_09->EditValue = array_values($this->v_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_09->AdvancedSearch->SearchValue, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_09->EditValue = $arwrk;
            }
            $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

            // v_10
            $this->v_10->setupEditAttributes();
            $curVal = trim(strval($this->v_10->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_10->AdvancedSearch->ViewValue = $this->v_10->lookupCacheOption($curVal);
            } else {
                $this->v_10->AdvancedSearch->ViewValue = $this->v_10->Lookup !== null && is_array($this->v_10->lookupOptions()) && count($this->v_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_10->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_10->EditValue = array_values($this->v_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_10->AdvancedSearch->SearchValue, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_10->EditValue = $arwrk;
            }
            $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            $this->q_sku->EditValue = $this->q_sku->AdvancedSearch->SearchValue;
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

            // b_01
            $this->b_01->setupEditAttributes();
            if (!$this->b_01->Raw) {
                $this->b_01->AdvancedSearch->SearchValue = HtmlDecode($this->b_01->AdvancedSearch->SearchValue);
            }
            $this->b_01->EditValue = HtmlEncode($this->b_01->AdvancedSearch->SearchValue);
            $this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

            // b_02
            $this->b_02->setupEditAttributes();
            if (!$this->b_02->Raw) {
                $this->b_02->AdvancedSearch->SearchValue = HtmlDecode($this->b_02->AdvancedSearch->SearchValue);
            }
            $this->b_02->EditValue = HtmlEncode($this->b_02->AdvancedSearch->SearchValue);
            $this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

            // b_03
            $curVal = trim(strval($this->b_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_03->AdvancedSearch->ViewValue = $this->b_03->lookupCacheOption($curVal);
            } else {
                $this->b_03->AdvancedSearch->ViewValue = $this->b_03->Lookup !== null && is_array($this->b_03->lookupOptions()) && count($this->b_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_03->EditValue = array_values($this->b_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_03->EditValue = $arwrk;
            }
            $this->b_03->PlaceHolder = RemoveHtml($this->b_03->caption());

            // b_04
            $curVal = trim(strval($this->b_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_04->AdvancedSearch->ViewValue = $this->b_04->lookupCacheOption($curVal);
            } else {
                $this->b_04->AdvancedSearch->ViewValue = $this->b_04->Lookup !== null && is_array($this->b_04->lookupOptions()) && count($this->b_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_04->EditValue = array_values($this->b_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_04->EditValue = $arwrk;
            }
            $this->b_04->PlaceHolder = RemoveHtml($this->b_04->caption());

            // b_05
            $curVal = trim(strval($this->b_05->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_05->AdvancedSearch->ViewValue = $this->b_05->lookupCacheOption($curVal);
            } else {
                $this->b_05->AdvancedSearch->ViewValue = $this->b_05->Lookup !== null && is_array($this->b_05->lookupOptions()) && count($this->b_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_05->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_05->EditValue = array_values($this->b_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_05->EditValue = $arwrk;
            }
            $this->b_05->PlaceHolder = RemoveHtml($this->b_05->caption());

            // b_06
            $curVal = trim(strval($this->b_06->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_06->AdvancedSearch->ViewValue = $this->b_06->lookupCacheOption($curVal);
            } else {
                $this->b_06->AdvancedSearch->ViewValue = $this->b_06->Lookup !== null && is_array($this->b_06->lookupOptions()) && count($this->b_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_06->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_06->EditValue = array_values($this->b_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_06->EditValue = $arwrk;
            }
            $this->b_06->PlaceHolder = RemoveHtml($this->b_06->caption());

            // b_07
            $curVal = trim(strval($this->b_07->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_07->AdvancedSearch->ViewValue = $this->b_07->lookupCacheOption($curVal);
            } else {
                $this->b_07->AdvancedSearch->ViewValue = $this->b_07->Lookup !== null && is_array($this->b_07->lookupOptions()) && count($this->b_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_07->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_07->EditValue = array_values($this->b_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_07->EditValue = $arwrk;
            }
            $this->b_07->PlaceHolder = RemoveHtml($this->b_07->caption());

            // b_08
            $curVal = trim(strval($this->b_08->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_08->AdvancedSearch->ViewValue = $this->b_08->lookupCacheOption($curVal);
            } else {
                $this->b_08->AdvancedSearch->ViewValue = $this->b_08->Lookup !== null && is_array($this->b_08->lookupOptions()) && count($this->b_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_08->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_08->EditValue = array_values($this->b_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_08->EditValue = $arwrk;
            }
            $this->b_08->PlaceHolder = RemoveHtml($this->b_08->caption());

            // b_09
            $curVal = trim(strval($this->b_09->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_09->AdvancedSearch->ViewValue = $this->b_09->lookupCacheOption($curVal);
            } else {
                $this->b_09->AdvancedSearch->ViewValue = $this->b_09->Lookup !== null && is_array($this->b_09->lookupOptions()) && count($this->b_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_09->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_09->EditValue = array_values($this->b_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_09->EditValue = $arwrk;
            }
            $this->b_09->PlaceHolder = RemoveHtml($this->b_09->caption());

            // b_10
            $curVal = trim(strval($this->b_10->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->b_10->AdvancedSearch->ViewValue = $this->b_10->lookupCacheOption($curVal);
            } else {
                $this->b_10->AdvancedSearch->ViewValue = $this->b_10->Lookup !== null && is_array($this->b_10->lookupOptions()) && count($this->b_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_10->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->b_10->EditValue = array_values($this->b_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_10->EditValue = $arwrk;
            }
            $this->b_10->PlaceHolder = RemoveHtml($this->b_10->caption());

            // b_11
            $this->b_11->setupEditAttributes();
            if (!$this->b_11->Raw) {
                $this->b_11->AdvancedSearch->SearchValue = HtmlDecode($this->b_11->AdvancedSearch->SearchValue);
            }
            $this->b_11->EditValue = HtmlEncode($this->b_11->AdvancedSearch->SearchValue);
            $this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

            // b_12
            $this->b_12->setupEditAttributes();
            if (!$this->b_12->Raw) {
                $this->b_12->AdvancedSearch->SearchValue = HtmlDecode($this->b_12->AdvancedSearch->SearchValue);
            }
            $this->b_12->EditValue = HtmlEncode($this->b_12->AdvancedSearch->SearchValue);
            $this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

            // b_13
            $this->b_13->setupEditAttributes();
            if (!$this->b_13->Raw) {
                $this->b_13->AdvancedSearch->SearchValue = HtmlDecode($this->b_13->AdvancedSearch->SearchValue);
            }
            $this->b_13->EditValue = HtmlEncode($this->b_13->AdvancedSearch->SearchValue);
            $this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

            // b_14
            $this->b_14->setupEditAttributes();
            if (!$this->b_14->Raw) {
                $this->b_14->AdvancedSearch->SearchValue = HtmlDecode($this->b_14->AdvancedSearch->SearchValue);
            }
            $this->b_14->EditValue = HtmlEncode($this->b_14->AdvancedSearch->SearchValue);
            $this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

            // b_15
            $this->b_15->setupEditAttributes();
            if (!$this->b_15->Raw) {
                $this->b_15->AdvancedSearch->SearchValue = HtmlDecode($this->b_15->AdvancedSearch->SearchValue);
            }
            $this->b_15->EditValue = HtmlEncode($this->b_15->AdvancedSearch->SearchValue);
            $this->b_15->PlaceHolder = RemoveHtml($this->b_15->caption());

            // t_01
            $this->t_01->setupEditAttributes();
            if (!$this->t_01->Raw) {
                $this->t_01->AdvancedSearch->SearchValue = HtmlDecode($this->t_01->AdvancedSearch->SearchValue);
            }
            $this->t_01->EditValue = HtmlEncode($this->t_01->AdvancedSearch->SearchValue);
            $this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

            // t_02
            $this->t_02->setupEditAttributes();
            if (!$this->t_02->Raw) {
                $this->t_02->AdvancedSearch->SearchValue = HtmlDecode($this->t_02->AdvancedSearch->SearchValue);
            }
            $this->t_02->EditValue = HtmlEncode($this->t_02->AdvancedSearch->SearchValue);
            $this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

            // t_03
            $curVal = trim(strval($this->t_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_03->AdvancedSearch->ViewValue = $this->t_03->lookupCacheOption($curVal);
            } else {
                $this->t_03->AdvancedSearch->ViewValue = $this->t_03->Lookup !== null && is_array($this->t_03->lookupOptions()) && count($this->t_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_03->EditValue = array_values($this->t_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_03->EditValue = $arwrk;
            }
            $this->t_03->PlaceHolder = RemoveHtml($this->t_03->caption());

            // t_04
            $curVal = trim(strval($this->t_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_04->AdvancedSearch->ViewValue = $this->t_04->lookupCacheOption($curVal);
            } else {
                $this->t_04->AdvancedSearch->ViewValue = $this->t_04->Lookup !== null && is_array($this->t_04->lookupOptions()) && count($this->t_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_04->EditValue = array_values($this->t_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_04->EditValue = $arwrk;
            }
            $this->t_04->PlaceHolder = RemoveHtml($this->t_04->caption());

            // t_05
            $curVal = trim(strval($this->t_05->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_05->AdvancedSearch->ViewValue = $this->t_05->lookupCacheOption($curVal);
            } else {
                $this->t_05->AdvancedSearch->ViewValue = $this->t_05->Lookup !== null && is_array($this->t_05->lookupOptions()) && count($this->t_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_05->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_05->EditValue = array_values($this->t_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_05->EditValue = $arwrk;
            }
            $this->t_05->PlaceHolder = RemoveHtml($this->t_05->caption());

            // t_06
            $curVal = trim(strval($this->t_06->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_06->AdvancedSearch->ViewValue = $this->t_06->lookupCacheOption($curVal);
            } else {
                $this->t_06->AdvancedSearch->ViewValue = $this->t_06->Lookup !== null && is_array($this->t_06->lookupOptions()) && count($this->t_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_06->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_06->EditValue = array_values($this->t_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_06->EditValue = $arwrk;
            }
            $this->t_06->PlaceHolder = RemoveHtml($this->t_06->caption());

            // t_07
            $curVal = trim(strval($this->t_07->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_07->AdvancedSearch->ViewValue = $this->t_07->lookupCacheOption($curVal);
            } else {
                $this->t_07->AdvancedSearch->ViewValue = $this->t_07->Lookup !== null && is_array($this->t_07->lookupOptions()) && count($this->t_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_07->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_07->EditValue = array_values($this->t_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_07->EditValue = $arwrk;
            }
            $this->t_07->PlaceHolder = RemoveHtml($this->t_07->caption());

            // t_08
            $curVal = trim(strval($this->t_08->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_08->AdvancedSearch->ViewValue = $this->t_08->lookupCacheOption($curVal);
            } else {
                $this->t_08->AdvancedSearch->ViewValue = $this->t_08->Lookup !== null && is_array($this->t_08->lookupOptions()) && count($this->t_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_08->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_08->EditValue = array_values($this->t_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_08->EditValue = $arwrk;
            }
            $this->t_08->PlaceHolder = RemoveHtml($this->t_08->caption());

            // t_09
            $curVal = trim(strval($this->t_09->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_09->AdvancedSearch->ViewValue = $this->t_09->lookupCacheOption($curVal);
            } else {
                $this->t_09->AdvancedSearch->ViewValue = $this->t_09->Lookup !== null && is_array($this->t_09->lookupOptions()) && count($this->t_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_09->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_09->EditValue = array_values($this->t_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_09->EditValue = $arwrk;
            }
            $this->t_09->PlaceHolder = RemoveHtml($this->t_09->caption());

            // t_10
            $curVal = trim(strval($this->t_10->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->t_10->AdvancedSearch->ViewValue = $this->t_10->lookupCacheOption($curVal);
            } else {
                $this->t_10->AdvancedSearch->ViewValue = $this->t_10->Lookup !== null && is_array($this->t_10->lookupOptions()) && count($this->t_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_10->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->t_10->EditValue = array_values($this->t_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_10->EditValue = $arwrk;
            }
            $this->t_10->PlaceHolder = RemoveHtml($this->t_10->caption());

            // t_11
            $this->t_11->setupEditAttributes();
            if (!$this->t_11->Raw) {
                $this->t_11->AdvancedSearch->SearchValue = HtmlDecode($this->t_11->AdvancedSearch->SearchValue);
            }
            $this->t_11->EditValue = HtmlEncode($this->t_11->AdvancedSearch->SearchValue);
            $curVal = strval($this->t_11->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->t_11->EditValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->EditValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->EditValue = HtmlEncode($this->t_11->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->t_11->EditValue = null;
            }
            $this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

            // t_12
            $this->t_12->setupEditAttributes();
            if (!$this->t_12->Raw) {
                $this->t_12->AdvancedSearch->SearchValue = HtmlDecode($this->t_12->AdvancedSearch->SearchValue);
            }
            $this->t_12->EditValue = HtmlEncode($this->t_12->AdvancedSearch->SearchValue);
            $curVal = strval($this->t_12->AdvancedSearch->SearchValue);
            if ($curVal != "") {
                $this->t_12->EditValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->EditValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->EditValue = HtmlEncode($this->t_12->AdvancedSearch->SearchValue);
                    }
                }
            } else {
                $this->t_12->EditValue = null;
            }
            $this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

            // t_13
            $this->t_13->setupEditAttributes();
            if (!$this->t_13->Raw) {
                $this->t_13->AdvancedSearch->SearchValue = HtmlDecode($this->t_13->AdvancedSearch->SearchValue);
            }
            $this->t_13->EditValue = HtmlEncode($this->t_13->AdvancedSearch->SearchValue);
            $this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

            // t_14
            $this->t_14->setupEditAttributes();
            if (!$this->t_14->Raw) {
                $this->t_14->AdvancedSearch->SearchValue = HtmlDecode($this->t_14->AdvancedSearch->SearchValue);
            }
            $this->t_14->EditValue = HtmlEncode($this->t_14->AdvancedSearch->SearchValue);
            $this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

            // t_15
            $this->t_15->setupEditAttributes();
            if (!$this->t_15->Raw) {
                $this->t_15->AdvancedSearch->SearchValue = HtmlDecode($this->t_15->AdvancedSearch->SearchValue);
            }
            $this->t_15->EditValue = HtmlEncode($this->t_15->AdvancedSearch->SearchValue);
            $this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

            // last_price
            $this->last_price->setupEditAttributes();
            if (!$this->last_price->Raw) {
                $this->last_price->AdvancedSearch->SearchValue = HtmlDecode($this->last_price->AdvancedSearch->SearchValue);
            }
            $this->last_price->EditValue = HtmlEncode($this->last_price->AdvancedSearch->SearchValue);
            $this->last_price->PlaceHolder = RemoveHtml($this->last_price->caption());

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->currency->AdvancedSearch->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->AdvancedSearch->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->AdvancedSearch->SearchValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // hsn
            $this->hsn->setupEditAttributes();
            $curVal = trim(strval($this->hsn->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->hsn->AdvancedSearch->ViewValue = $this->hsn->lookupCacheOption($curVal);
            } else {
                $this->hsn->AdvancedSearch->ViewValue = $this->hsn->Lookup !== null && is_array($this->hsn->lookupOptions()) && count($this->hsn->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->hsn->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->hsn->EditValue = array_values($this->hsn->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->hsn->AdvancedSearch->SearchValue, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                $sqlWrk = $this->hsn->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->hsn->Lookup->renderViewRow($row);
                }
                $this->hsn->EditValue = $arwrk;
            }
            $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

            // composition
            $this->composition->setupEditAttributes();
            $curVal = trim(strval($this->composition->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->composition->AdvancedSearch->ViewValue = $this->composition->lookupCacheOption($curVal);
            } else {
                $this->composition->AdvancedSearch->ViewValue = $this->composition->Lookup !== null && is_array($this->composition->lookupOptions()) && count($this->composition->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->composition->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->composition->EditValue = array_values($this->composition->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->composition->AdvancedSearch->SearchValue, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->composition->EditValue = $arwrk;
            }
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->category->AdvancedSearch->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->AdvancedSearch->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->AdvancedSearch->SearchValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // moq
            $this->moq->setupEditAttributes();
            $this->moq->EditValue = $this->moq->AdvancedSearch->SearchValue;
            $this->moq->PlaceHolder = RemoveHtml($this->moq->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // d_head_01
            $this->d_head_01->setupEditAttributes();
            if (!$this->d_head_01->Raw) {
                $this->d_head_01->AdvancedSearch->SearchValue = HtmlDecode($this->d_head_01->AdvancedSearch->SearchValue);
            }
            $this->d_head_01->EditValue = HtmlEncode($this->d_head_01->AdvancedSearch->SearchValue);
            $this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

            // d_description_01
            $this->d_description_01->setupEditAttributes();
            $this->d_description_01->EditValue = HtmlEncode($this->d_description_01->AdvancedSearch->SearchValue);
            $this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

            // d_head_02
            $this->d_head_02->setupEditAttributes();
            if (!$this->d_head_02->Raw) {
                $this->d_head_02->AdvancedSearch->SearchValue = HtmlDecode($this->d_head_02->AdvancedSearch->SearchValue);
            }
            $this->d_head_02->EditValue = HtmlEncode($this->d_head_02->AdvancedSearch->SearchValue);
            $this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

            // d_description_02
            $this->d_description_02->setupEditAttributes();
            $this->d_description_02->EditValue = HtmlEncode($this->d_description_02->AdvancedSearch->SearchValue);
            $this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

            // publish
            $this->publish->setupEditAttributes();
            $this->publish->EditValue = $this->publish->options(true);
            $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());

            // keywords
            $this->keywords->setupEditAttributes();
            $this->keywords->EditValue = HtmlEncode($this->keywords->AdvancedSearch->SearchValue);
            $this->keywords->PlaceHolder = RemoveHtml($this->keywords->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->q_sku->AdvancedSearch->SearchValue)) {
            $this->q_sku->addErrorMessage($this->q_sku->getErrorMessage(false));
        }
        if (!CheckNumber($this->last_price->AdvancedSearch->SearchValue)) {
            $this->last_price->addErrorMessage($this->last_price->getErrorMessage(false));
        }
        if (!CheckNumber($this->moq->AdvancedSearch->SearchValue)) {
            $this->moq->addErrorMessage($this->moq->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->product_n->AdvancedSearch->load();
        $this->product_code_type->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->v_00->AdvancedSearch->load();
        $this->v_01->AdvancedSearch->load();
        $this->v_02->AdvancedSearch->load();
        $this->v_03->AdvancedSearch->load();
        $this->v_04->AdvancedSearch->load();
        $this->v_05->AdvancedSearch->load();
        $this->v_06->AdvancedSearch->load();
        $this->v_07->AdvancedSearch->load();
        $this->v_08->AdvancedSearch->load();
        $this->v_09->AdvancedSearch->load();
        $this->v_10->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->b_01->AdvancedSearch->load();
        $this->b_02->AdvancedSearch->load();
        $this->b_03->AdvancedSearch->load();
        $this->b_04->AdvancedSearch->load();
        $this->b_05->AdvancedSearch->load();
        $this->b_06->AdvancedSearch->load();
        $this->b_07->AdvancedSearch->load();
        $this->b_08->AdvancedSearch->load();
        $this->b_09->AdvancedSearch->load();
        $this->b_10->AdvancedSearch->load();
        $this->b_11->AdvancedSearch->load();
        $this->b_12->AdvancedSearch->load();
        $this->b_13->AdvancedSearch->load();
        $this->b_14->AdvancedSearch->load();
        $this->b_15->AdvancedSearch->load();
        $this->t_01->AdvancedSearch->load();
        $this->t_02->AdvancedSearch->load();
        $this->t_03->AdvancedSearch->load();
        $this->t_04->AdvancedSearch->load();
        $this->t_05->AdvancedSearch->load();
        $this->t_06->AdvancedSearch->load();
        $this->t_07->AdvancedSearch->load();
        $this->t_08->AdvancedSearch->load();
        $this->t_09->AdvancedSearch->load();
        $this->t_10->AdvancedSearch->load();
        $this->t_11->AdvancedSearch->load();
        $this->t_12->AdvancedSearch->load();
        $this->t_13->AdvancedSearch->load();
        $this->t_14->AdvancedSearch->load();
        $this->t_15->AdvancedSearch->load();
        $this->last_price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->hsn->AdvancedSearch->load();
        $this->composition->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->moq->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->d_head_01->AdvancedSearch->load();
        $this->d_description_01->AdvancedSearch->load();
        $this->d_head_02->AdvancedSearch->load();
        $this->d_description_02->AdvancedSearch->load();
        $this->publish->AdvancedSearch->load();
        $this->keywords->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("reflist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code_type":
                    break;
                case "x_set_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_11":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_12":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hsn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_publish":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'ref');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
