<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RefList extends Ref
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RefList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "freflist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "reflist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->oid->Visible = false;
        $this->company_id->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_type->Visible = false;
        $this->packing_type->setVisibility();
        $this->product_n->setVisibility();
        $this->_barcode->Visible = false;
        $this->product_code_type->setVisibility();
        $this->product_code->setVisibility();
        $this->print_name->Visible = false;
        $this->gcode->Visible = false;
        $this->code->Visible = false;
        $this->product_id->Visible = false;
        $this->batch_no->Visible = false;
        $this->set_ref->Visible = false;
        $this->v_00->setVisibility();
        $this->v_01->Visible = false;
        $this->v_02->Visible = false;
        $this->v_03->Visible = false;
        $this->v_04->Visible = false;
        $this->v_05->Visible = false;
        $this->v_06->Visible = false;
        $this->v_07->Visible = false;
        $this->v_08->Visible = false;
        $this->v_09->Visible = false;
        $this->v_10->Visible = false;
        $this->cbm->Visible = false;
        $this->sqm->Visible = false;
        $this->shape->Visible = false;
        $this->q_sku->setVisibility();
        $this->b_01->Visible = false;
        $this->b_02->Visible = false;
        $this->b_03->Visible = false;
        $this->b_04->Visible = false;
        $this->b_05->Visible = false;
        $this->b_06->Visible = false;
        $this->b_07->Visible = false;
        $this->b_08->Visible = false;
        $this->b_09->Visible = false;
        $this->b_10->Visible = false;
        $this->b_11->Visible = false;
        $this->b_12->Visible = false;
        $this->b_13->Visible = false;
        $this->b_14->Visible = false;
        $this->b_15->Visible = false;
        $this->t_01->Visible = false;
        $this->t_02->Visible = false;
        $this->t_03->Visible = false;
        $this->t_04->Visible = false;
        $this->t_05->Visible = false;
        $this->t_06->Visible = false;
        $this->t_07->Visible = false;
        $this->t_08->Visible = false;
        $this->t_09->Visible = false;
        $this->t_10->Visible = false;
        $this->t_11->Visible = false;
        $this->t_12->Visible = false;
        $this->t_13->Visible = false;
        $this->t_14->Visible = false;
        $this->t_15->Visible = false;
        $this->last_price->Visible = false;
        $this->currency->Visible = false;
        $this->hsn->Visible = false;
        $this->composition->setVisibility();
        $this->category->setVisibility();
        $this->moq->Visible = false;
        $this->status->setVisibility();
        $this->d_head_01->Visible = false;
        $this->d_description_01->Visible = false;
        $this->d_head_02->Visible = false;
        $this->d_description_02->Visible = false;
        $this->publish->Visible = false;
        $this->keywords->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->main_image->Visible = false;
        $this->top_view->Visible = false;
        $this->front_view->Visible = false;
        $this->corner_view->Visible = false;
        $this->back_view->Visible = false;
        $this->color_options->Visible = false;
        $this->other_options->Visible = false;
        $this->group_image->Visible = false;
        $this->video_url->Visible = false;
        $this->image->Visible = false;
        $this->in->Visible = false;
        $this->out->Visible = false;
        $this->required->Visible = false;
        $this->blocked->Visible = false;
        $this->ordered->Visible = false;
        $this->supplier->Visible = false;
        $this->country->Visible = false;
        $this->minimum_stock->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'ref';
        $this->TableName = 'ref';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ref)
        if (!isset($GLOBALS["ref"]) || $GLOBALS["ref"]::class == PROJECT_NAMESPACE . "ref") {
            $GLOBALS["ref"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "refadd?" . Config("TABLE_SHOW_DETAIL") . "=";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "refdelete";
        $this->MultiUpdateUrl = "refupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "refview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
                $this->main_image->UploadPath = $this->main_image->OldUploadPath;
                $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
                $this->top_view->UploadPath = $this->top_view->OldUploadPath;
                $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
                $this->front_view->UploadPath = $this->front_view->OldUploadPath;
                $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
                $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
                $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
                $this->back_view->UploadPath = $this->back_view->OldUploadPath;
                $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
                $this->color_options->UploadPath = $this->color_options->OldUploadPath;
                $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
                $this->other_options->UploadPath = $this->other_options->OldUploadPath;
                $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
                $this->group_image->UploadPath = $this->group_image->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->operator->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->datetime->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 20;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,100,250,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 3; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code_type);
        $this->setupLookupOptions($this->set_ref);
        $this->setupLookupOptions($this->v_01);
        $this->setupLookupOptions($this->v_02);
        $this->setupLookupOptions($this->v_03);
        $this->setupLookupOptions($this->v_04);
        $this->setupLookupOptions($this->v_05);
        $this->setupLookupOptions($this->v_06);
        $this->setupLookupOptions($this->v_07);
        $this->setupLookupOptions($this->v_08);
        $this->setupLookupOptions($this->v_09);
        $this->setupLookupOptions($this->v_10);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->b_03);
        $this->setupLookupOptions($this->b_04);
        $this->setupLookupOptions($this->b_05);
        $this->setupLookupOptions($this->b_06);
        $this->setupLookupOptions($this->b_07);
        $this->setupLookupOptions($this->b_08);
        $this->setupLookupOptions($this->b_09);
        $this->setupLookupOptions($this->b_10);
        $this->setupLookupOptions($this->t_03);
        $this->setupLookupOptions($this->t_04);
        $this->setupLookupOptions($this->t_05);
        $this->setupLookupOptions($this->t_06);
        $this->setupLookupOptions($this->t_07);
        $this->setupLookupOptions($this->t_08);
        $this->setupLookupOptions($this->t_09);
        $this->setupLookupOptions($this->t_10);
        $this->setupLookupOptions($this->t_11);
        $this->setupLookupOptions($this->t_12);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->hsn);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->publish);
        $this->setupLookupOptions($this->operator);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "frefgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 20; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }

            // Audit trail on search
            if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
                $searchParm = ServerVar("QUERY_STRING");
                $searchSql = $this->getSessionWhere();
                $this->writeAuditTrailOnSearch($searchParm, $searchSql);
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 20; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Load server side filters
        if (Config("SEARCH_FILTER_OPTION") == "Server") {
            $savedFilterList = Profile()->getSearchFilters("frefsrch");
        }
        $filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
        $filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
        $filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
        $filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
        $filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
        $filterList = Concat($filterList, $this->product_type->AdvancedSearch->toJson(), ","); // Field product_type
        $filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
        $filterList = Concat($filterList, $this->product_n->AdvancedSearch->toJson(), ","); // Field product_n
        $filterList = Concat($filterList, $this->product_code_type->AdvancedSearch->toJson(), ","); // Field product_code_type
        $filterList = Concat($filterList, $this->product_code->AdvancedSearch->toJson(), ","); // Field product_code
        $filterList = Concat($filterList, $this->v_00->AdvancedSearch->toJson(), ","); // Field v_00
        $filterList = Concat($filterList, $this->v_01->AdvancedSearch->toJson(), ","); // Field v_01
        $filterList = Concat($filterList, $this->v_02->AdvancedSearch->toJson(), ","); // Field v_02
        $filterList = Concat($filterList, $this->v_03->AdvancedSearch->toJson(), ","); // Field v_03
        $filterList = Concat($filterList, $this->v_04->AdvancedSearch->toJson(), ","); // Field v_04
        $filterList = Concat($filterList, $this->v_05->AdvancedSearch->toJson(), ","); // Field v_05
        $filterList = Concat($filterList, $this->v_06->AdvancedSearch->toJson(), ","); // Field v_06
        $filterList = Concat($filterList, $this->v_07->AdvancedSearch->toJson(), ","); // Field v_07
        $filterList = Concat($filterList, $this->v_08->AdvancedSearch->toJson(), ","); // Field v_08
        $filterList = Concat($filterList, $this->v_09->AdvancedSearch->toJson(), ","); // Field v_09
        $filterList = Concat($filterList, $this->v_10->AdvancedSearch->toJson(), ","); // Field v_10
        $filterList = Concat($filterList, $this->q_sku->AdvancedSearch->toJson(), ","); // Field q_sku
        $filterList = Concat($filterList, $this->b_01->AdvancedSearch->toJson(), ","); // Field b_01
        $filterList = Concat($filterList, $this->b_02->AdvancedSearch->toJson(), ","); // Field b_02
        $filterList = Concat($filterList, $this->b_03->AdvancedSearch->toJson(), ","); // Field b_03
        $filterList = Concat($filterList, $this->b_04->AdvancedSearch->toJson(), ","); // Field b_04
        $filterList = Concat($filterList, $this->b_05->AdvancedSearch->toJson(), ","); // Field b_05
        $filterList = Concat($filterList, $this->b_06->AdvancedSearch->toJson(), ","); // Field b_06
        $filterList = Concat($filterList, $this->b_07->AdvancedSearch->toJson(), ","); // Field b_07
        $filterList = Concat($filterList, $this->b_08->AdvancedSearch->toJson(), ","); // Field b_08
        $filterList = Concat($filterList, $this->b_09->AdvancedSearch->toJson(), ","); // Field b_09
        $filterList = Concat($filterList, $this->b_10->AdvancedSearch->toJson(), ","); // Field b_10
        $filterList = Concat($filterList, $this->b_11->AdvancedSearch->toJson(), ","); // Field b_11
        $filterList = Concat($filterList, $this->b_12->AdvancedSearch->toJson(), ","); // Field b_12
        $filterList = Concat($filterList, $this->b_13->AdvancedSearch->toJson(), ","); // Field b_13
        $filterList = Concat($filterList, $this->b_14->AdvancedSearch->toJson(), ","); // Field b_14
        $filterList = Concat($filterList, $this->b_15->AdvancedSearch->toJson(), ","); // Field b_15
        $filterList = Concat($filterList, $this->t_01->AdvancedSearch->toJson(), ","); // Field t_01
        $filterList = Concat($filterList, $this->t_02->AdvancedSearch->toJson(), ","); // Field t_02
        $filterList = Concat($filterList, $this->t_03->AdvancedSearch->toJson(), ","); // Field t_03
        $filterList = Concat($filterList, $this->t_04->AdvancedSearch->toJson(), ","); // Field t_04
        $filterList = Concat($filterList, $this->t_05->AdvancedSearch->toJson(), ","); // Field t_05
        $filterList = Concat($filterList, $this->t_06->AdvancedSearch->toJson(), ","); // Field t_06
        $filterList = Concat($filterList, $this->t_07->AdvancedSearch->toJson(), ","); // Field t_07
        $filterList = Concat($filterList, $this->t_08->AdvancedSearch->toJson(), ","); // Field t_08
        $filterList = Concat($filterList, $this->t_09->AdvancedSearch->toJson(), ","); // Field t_09
        $filterList = Concat($filterList, $this->t_10->AdvancedSearch->toJson(), ","); // Field t_10
        $filterList = Concat($filterList, $this->t_11->AdvancedSearch->toJson(), ","); // Field t_11
        $filterList = Concat($filterList, $this->t_12->AdvancedSearch->toJson(), ","); // Field t_12
        $filterList = Concat($filterList, $this->t_13->AdvancedSearch->toJson(), ","); // Field t_13
        $filterList = Concat($filterList, $this->t_14->AdvancedSearch->toJson(), ","); // Field t_14
        $filterList = Concat($filterList, $this->t_15->AdvancedSearch->toJson(), ","); // Field t_15
        $filterList = Concat($filterList, $this->last_price->AdvancedSearch->toJson(), ","); // Field last_price
        $filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
        $filterList = Concat($filterList, $this->hsn->AdvancedSearch->toJson(), ","); // Field hsn
        $filterList = Concat($filterList, $this->composition->AdvancedSearch->toJson(), ","); // Field composition
        $filterList = Concat($filterList, $this->category->AdvancedSearch->toJson(), ","); // Field category
        $filterList = Concat($filterList, $this->moq->AdvancedSearch->toJson(), ","); // Field moq
        $filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
        $filterList = Concat($filterList, $this->d_head_01->AdvancedSearch->toJson(), ","); // Field d_head_01
        $filterList = Concat($filterList, $this->d_description_01->AdvancedSearch->toJson(), ","); // Field d_description_01
        $filterList = Concat($filterList, $this->d_head_02->AdvancedSearch->toJson(), ","); // Field d_head_02
        $filterList = Concat($filterList, $this->d_description_02->AdvancedSearch->toJson(), ","); // Field d_description_02
        $filterList = Concat($filterList, $this->publish->AdvancedSearch->toJson(), ","); // Field publish
        $filterList = Concat($filterList, $this->keywords->AdvancedSearch->toJson(), ","); // Field keywords
        $filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
        $filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("frefsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field id
        $this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
        $this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
        $this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
        $this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
        $this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
        $this->id->AdvancedSearch->save();

        // Field company_id
        $this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
        $this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
        $this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
        $this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
        $this->company_id->AdvancedSearch->save();

        // Field grp
        $this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
        $this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
        $this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
        $this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
        $this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
        $this->grp->AdvancedSearch->save();

        // Field s_grp
        $this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
        $this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
        $this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
        $this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
        $this->s_grp->AdvancedSearch->save();

        // Field product
        $this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
        $this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
        $this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
        $this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
        $this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
        $this->product->AdvancedSearch->save();

        // Field product_type
        $this->product_type->AdvancedSearch->SearchValue = @$filter["x_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator = @$filter["z_product_type"];
        $this->product_type->AdvancedSearch->SearchCondition = @$filter["v_product_type"];
        $this->product_type->AdvancedSearch->SearchValue2 = @$filter["y_product_type"];
        $this->product_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_type"];
        $this->product_type->AdvancedSearch->save();

        // Field packing_type
        $this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
        $this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
        $this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
        $this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
        $this->packing_type->AdvancedSearch->save();

        // Field product_n
        $this->product_n->AdvancedSearch->SearchValue = @$filter["x_product_n"];
        $this->product_n->AdvancedSearch->SearchOperator = @$filter["z_product_n"];
        $this->product_n->AdvancedSearch->SearchCondition = @$filter["v_product_n"];
        $this->product_n->AdvancedSearch->SearchValue2 = @$filter["y_product_n"];
        $this->product_n->AdvancedSearch->SearchOperator2 = @$filter["w_product_n"];
        $this->product_n->AdvancedSearch->save();

        // Field product_code_type
        $this->product_code_type->AdvancedSearch->SearchValue = @$filter["x_product_code_type"];
        $this->product_code_type->AdvancedSearch->SearchOperator = @$filter["z_product_code_type"];
        $this->product_code_type->AdvancedSearch->SearchCondition = @$filter["v_product_code_type"];
        $this->product_code_type->AdvancedSearch->SearchValue2 = @$filter["y_product_code_type"];
        $this->product_code_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_code_type"];
        $this->product_code_type->AdvancedSearch->save();

        // Field product_code
        $this->product_code->AdvancedSearch->SearchValue = @$filter["x_product_code"];
        $this->product_code->AdvancedSearch->SearchOperator = @$filter["z_product_code"];
        $this->product_code->AdvancedSearch->SearchCondition = @$filter["v_product_code"];
        $this->product_code->AdvancedSearch->SearchValue2 = @$filter["y_product_code"];
        $this->product_code->AdvancedSearch->SearchOperator2 = @$filter["w_product_code"];
        $this->product_code->AdvancedSearch->save();

        // Field v_00
        $this->v_00->AdvancedSearch->SearchValue = @$filter["x_v_00"];
        $this->v_00->AdvancedSearch->SearchOperator = @$filter["z_v_00"];
        $this->v_00->AdvancedSearch->SearchCondition = @$filter["v_v_00"];
        $this->v_00->AdvancedSearch->SearchValue2 = @$filter["y_v_00"];
        $this->v_00->AdvancedSearch->SearchOperator2 = @$filter["w_v_00"];
        $this->v_00->AdvancedSearch->save();

        // Field v_01
        $this->v_01->AdvancedSearch->SearchValue = @$filter["x_v_01"];
        $this->v_01->AdvancedSearch->SearchOperator = @$filter["z_v_01"];
        $this->v_01->AdvancedSearch->SearchCondition = @$filter["v_v_01"];
        $this->v_01->AdvancedSearch->SearchValue2 = @$filter["y_v_01"];
        $this->v_01->AdvancedSearch->SearchOperator2 = @$filter["w_v_01"];
        $this->v_01->AdvancedSearch->save();

        // Field v_02
        $this->v_02->AdvancedSearch->SearchValue = @$filter["x_v_02"];
        $this->v_02->AdvancedSearch->SearchOperator = @$filter["z_v_02"];
        $this->v_02->AdvancedSearch->SearchCondition = @$filter["v_v_02"];
        $this->v_02->AdvancedSearch->SearchValue2 = @$filter["y_v_02"];
        $this->v_02->AdvancedSearch->SearchOperator2 = @$filter["w_v_02"];
        $this->v_02->AdvancedSearch->save();

        // Field v_03
        $this->v_03->AdvancedSearch->SearchValue = @$filter["x_v_03"];
        $this->v_03->AdvancedSearch->SearchOperator = @$filter["z_v_03"];
        $this->v_03->AdvancedSearch->SearchCondition = @$filter["v_v_03"];
        $this->v_03->AdvancedSearch->SearchValue2 = @$filter["y_v_03"];
        $this->v_03->AdvancedSearch->SearchOperator2 = @$filter["w_v_03"];
        $this->v_03->AdvancedSearch->save();

        // Field v_04
        $this->v_04->AdvancedSearch->SearchValue = @$filter["x_v_04"];
        $this->v_04->AdvancedSearch->SearchOperator = @$filter["z_v_04"];
        $this->v_04->AdvancedSearch->SearchCondition = @$filter["v_v_04"];
        $this->v_04->AdvancedSearch->SearchValue2 = @$filter["y_v_04"];
        $this->v_04->AdvancedSearch->SearchOperator2 = @$filter["w_v_04"];
        $this->v_04->AdvancedSearch->save();

        // Field v_05
        $this->v_05->AdvancedSearch->SearchValue = @$filter["x_v_05"];
        $this->v_05->AdvancedSearch->SearchOperator = @$filter["z_v_05"];
        $this->v_05->AdvancedSearch->SearchCondition = @$filter["v_v_05"];
        $this->v_05->AdvancedSearch->SearchValue2 = @$filter["y_v_05"];
        $this->v_05->AdvancedSearch->SearchOperator2 = @$filter["w_v_05"];
        $this->v_05->AdvancedSearch->save();

        // Field v_06
        $this->v_06->AdvancedSearch->SearchValue = @$filter["x_v_06"];
        $this->v_06->AdvancedSearch->SearchOperator = @$filter["z_v_06"];
        $this->v_06->AdvancedSearch->SearchCondition = @$filter["v_v_06"];
        $this->v_06->AdvancedSearch->SearchValue2 = @$filter["y_v_06"];
        $this->v_06->AdvancedSearch->SearchOperator2 = @$filter["w_v_06"];
        $this->v_06->AdvancedSearch->save();

        // Field v_07
        $this->v_07->AdvancedSearch->SearchValue = @$filter["x_v_07"];
        $this->v_07->AdvancedSearch->SearchOperator = @$filter["z_v_07"];
        $this->v_07->AdvancedSearch->SearchCondition = @$filter["v_v_07"];
        $this->v_07->AdvancedSearch->SearchValue2 = @$filter["y_v_07"];
        $this->v_07->AdvancedSearch->SearchOperator2 = @$filter["w_v_07"];
        $this->v_07->AdvancedSearch->save();

        // Field v_08
        $this->v_08->AdvancedSearch->SearchValue = @$filter["x_v_08"];
        $this->v_08->AdvancedSearch->SearchOperator = @$filter["z_v_08"];
        $this->v_08->AdvancedSearch->SearchCondition = @$filter["v_v_08"];
        $this->v_08->AdvancedSearch->SearchValue2 = @$filter["y_v_08"];
        $this->v_08->AdvancedSearch->SearchOperator2 = @$filter["w_v_08"];
        $this->v_08->AdvancedSearch->save();

        // Field v_09
        $this->v_09->AdvancedSearch->SearchValue = @$filter["x_v_09"];
        $this->v_09->AdvancedSearch->SearchOperator = @$filter["z_v_09"];
        $this->v_09->AdvancedSearch->SearchCondition = @$filter["v_v_09"];
        $this->v_09->AdvancedSearch->SearchValue2 = @$filter["y_v_09"];
        $this->v_09->AdvancedSearch->SearchOperator2 = @$filter["w_v_09"];
        $this->v_09->AdvancedSearch->save();

        // Field v_10
        $this->v_10->AdvancedSearch->SearchValue = @$filter["x_v_10"];
        $this->v_10->AdvancedSearch->SearchOperator = @$filter["z_v_10"];
        $this->v_10->AdvancedSearch->SearchCondition = @$filter["v_v_10"];
        $this->v_10->AdvancedSearch->SearchValue2 = @$filter["y_v_10"];
        $this->v_10->AdvancedSearch->SearchOperator2 = @$filter["w_v_10"];
        $this->v_10->AdvancedSearch->save();

        // Field q_sku
        $this->q_sku->AdvancedSearch->SearchValue = @$filter["x_q_sku"];
        $this->q_sku->AdvancedSearch->SearchOperator = @$filter["z_q_sku"];
        $this->q_sku->AdvancedSearch->SearchCondition = @$filter["v_q_sku"];
        $this->q_sku->AdvancedSearch->SearchValue2 = @$filter["y_q_sku"];
        $this->q_sku->AdvancedSearch->SearchOperator2 = @$filter["w_q_sku"];
        $this->q_sku->AdvancedSearch->save();

        // Field b_01
        $this->b_01->AdvancedSearch->SearchValue = @$filter["x_b_01"];
        $this->b_01->AdvancedSearch->SearchOperator = @$filter["z_b_01"];
        $this->b_01->AdvancedSearch->SearchCondition = @$filter["v_b_01"];
        $this->b_01->AdvancedSearch->SearchValue2 = @$filter["y_b_01"];
        $this->b_01->AdvancedSearch->SearchOperator2 = @$filter["w_b_01"];
        $this->b_01->AdvancedSearch->save();

        // Field b_02
        $this->b_02->AdvancedSearch->SearchValue = @$filter["x_b_02"];
        $this->b_02->AdvancedSearch->SearchOperator = @$filter["z_b_02"];
        $this->b_02->AdvancedSearch->SearchCondition = @$filter["v_b_02"];
        $this->b_02->AdvancedSearch->SearchValue2 = @$filter["y_b_02"];
        $this->b_02->AdvancedSearch->SearchOperator2 = @$filter["w_b_02"];
        $this->b_02->AdvancedSearch->save();

        // Field b_03
        $this->b_03->AdvancedSearch->SearchValue = @$filter["x_b_03"];
        $this->b_03->AdvancedSearch->SearchOperator = @$filter["z_b_03"];
        $this->b_03->AdvancedSearch->SearchCondition = @$filter["v_b_03"];
        $this->b_03->AdvancedSearch->SearchValue2 = @$filter["y_b_03"];
        $this->b_03->AdvancedSearch->SearchOperator2 = @$filter["w_b_03"];
        $this->b_03->AdvancedSearch->save();

        // Field b_04
        $this->b_04->AdvancedSearch->SearchValue = @$filter["x_b_04"];
        $this->b_04->AdvancedSearch->SearchOperator = @$filter["z_b_04"];
        $this->b_04->AdvancedSearch->SearchCondition = @$filter["v_b_04"];
        $this->b_04->AdvancedSearch->SearchValue2 = @$filter["y_b_04"];
        $this->b_04->AdvancedSearch->SearchOperator2 = @$filter["w_b_04"];
        $this->b_04->AdvancedSearch->save();

        // Field b_05
        $this->b_05->AdvancedSearch->SearchValue = @$filter["x_b_05"];
        $this->b_05->AdvancedSearch->SearchOperator = @$filter["z_b_05"];
        $this->b_05->AdvancedSearch->SearchCondition = @$filter["v_b_05"];
        $this->b_05->AdvancedSearch->SearchValue2 = @$filter["y_b_05"];
        $this->b_05->AdvancedSearch->SearchOperator2 = @$filter["w_b_05"];
        $this->b_05->AdvancedSearch->save();

        // Field b_06
        $this->b_06->AdvancedSearch->SearchValue = @$filter["x_b_06"];
        $this->b_06->AdvancedSearch->SearchOperator = @$filter["z_b_06"];
        $this->b_06->AdvancedSearch->SearchCondition = @$filter["v_b_06"];
        $this->b_06->AdvancedSearch->SearchValue2 = @$filter["y_b_06"];
        $this->b_06->AdvancedSearch->SearchOperator2 = @$filter["w_b_06"];
        $this->b_06->AdvancedSearch->save();

        // Field b_07
        $this->b_07->AdvancedSearch->SearchValue = @$filter["x_b_07"];
        $this->b_07->AdvancedSearch->SearchOperator = @$filter["z_b_07"];
        $this->b_07->AdvancedSearch->SearchCondition = @$filter["v_b_07"];
        $this->b_07->AdvancedSearch->SearchValue2 = @$filter["y_b_07"];
        $this->b_07->AdvancedSearch->SearchOperator2 = @$filter["w_b_07"];
        $this->b_07->AdvancedSearch->save();

        // Field b_08
        $this->b_08->AdvancedSearch->SearchValue = @$filter["x_b_08"];
        $this->b_08->AdvancedSearch->SearchOperator = @$filter["z_b_08"];
        $this->b_08->AdvancedSearch->SearchCondition = @$filter["v_b_08"];
        $this->b_08->AdvancedSearch->SearchValue2 = @$filter["y_b_08"];
        $this->b_08->AdvancedSearch->SearchOperator2 = @$filter["w_b_08"];
        $this->b_08->AdvancedSearch->save();

        // Field b_09
        $this->b_09->AdvancedSearch->SearchValue = @$filter["x_b_09"];
        $this->b_09->AdvancedSearch->SearchOperator = @$filter["z_b_09"];
        $this->b_09->AdvancedSearch->SearchCondition = @$filter["v_b_09"];
        $this->b_09->AdvancedSearch->SearchValue2 = @$filter["y_b_09"];
        $this->b_09->AdvancedSearch->SearchOperator2 = @$filter["w_b_09"];
        $this->b_09->AdvancedSearch->save();

        // Field b_10
        $this->b_10->AdvancedSearch->SearchValue = @$filter["x_b_10"];
        $this->b_10->AdvancedSearch->SearchOperator = @$filter["z_b_10"];
        $this->b_10->AdvancedSearch->SearchCondition = @$filter["v_b_10"];
        $this->b_10->AdvancedSearch->SearchValue2 = @$filter["y_b_10"];
        $this->b_10->AdvancedSearch->SearchOperator2 = @$filter["w_b_10"];
        $this->b_10->AdvancedSearch->save();

        // Field b_11
        $this->b_11->AdvancedSearch->SearchValue = @$filter["x_b_11"];
        $this->b_11->AdvancedSearch->SearchOperator = @$filter["z_b_11"];
        $this->b_11->AdvancedSearch->SearchCondition = @$filter["v_b_11"];
        $this->b_11->AdvancedSearch->SearchValue2 = @$filter["y_b_11"];
        $this->b_11->AdvancedSearch->SearchOperator2 = @$filter["w_b_11"];
        $this->b_11->AdvancedSearch->save();

        // Field b_12
        $this->b_12->AdvancedSearch->SearchValue = @$filter["x_b_12"];
        $this->b_12->AdvancedSearch->SearchOperator = @$filter["z_b_12"];
        $this->b_12->AdvancedSearch->SearchCondition = @$filter["v_b_12"];
        $this->b_12->AdvancedSearch->SearchValue2 = @$filter["y_b_12"];
        $this->b_12->AdvancedSearch->SearchOperator2 = @$filter["w_b_12"];
        $this->b_12->AdvancedSearch->save();

        // Field b_13
        $this->b_13->AdvancedSearch->SearchValue = @$filter["x_b_13"];
        $this->b_13->AdvancedSearch->SearchOperator = @$filter["z_b_13"];
        $this->b_13->AdvancedSearch->SearchCondition = @$filter["v_b_13"];
        $this->b_13->AdvancedSearch->SearchValue2 = @$filter["y_b_13"];
        $this->b_13->AdvancedSearch->SearchOperator2 = @$filter["w_b_13"];
        $this->b_13->AdvancedSearch->save();

        // Field b_14
        $this->b_14->AdvancedSearch->SearchValue = @$filter["x_b_14"];
        $this->b_14->AdvancedSearch->SearchOperator = @$filter["z_b_14"];
        $this->b_14->AdvancedSearch->SearchCondition = @$filter["v_b_14"];
        $this->b_14->AdvancedSearch->SearchValue2 = @$filter["y_b_14"];
        $this->b_14->AdvancedSearch->SearchOperator2 = @$filter["w_b_14"];
        $this->b_14->AdvancedSearch->save();

        // Field b_15
        $this->b_15->AdvancedSearch->SearchValue = @$filter["x_b_15"];
        $this->b_15->AdvancedSearch->SearchOperator = @$filter["z_b_15"];
        $this->b_15->AdvancedSearch->SearchCondition = @$filter["v_b_15"];
        $this->b_15->AdvancedSearch->SearchValue2 = @$filter["y_b_15"];
        $this->b_15->AdvancedSearch->SearchOperator2 = @$filter["w_b_15"];
        $this->b_15->AdvancedSearch->save();

        // Field t_01
        $this->t_01->AdvancedSearch->SearchValue = @$filter["x_t_01"];
        $this->t_01->AdvancedSearch->SearchOperator = @$filter["z_t_01"];
        $this->t_01->AdvancedSearch->SearchCondition = @$filter["v_t_01"];
        $this->t_01->AdvancedSearch->SearchValue2 = @$filter["y_t_01"];
        $this->t_01->AdvancedSearch->SearchOperator2 = @$filter["w_t_01"];
        $this->t_01->AdvancedSearch->save();

        // Field t_02
        $this->t_02->AdvancedSearch->SearchValue = @$filter["x_t_02"];
        $this->t_02->AdvancedSearch->SearchOperator = @$filter["z_t_02"];
        $this->t_02->AdvancedSearch->SearchCondition = @$filter["v_t_02"];
        $this->t_02->AdvancedSearch->SearchValue2 = @$filter["y_t_02"];
        $this->t_02->AdvancedSearch->SearchOperator2 = @$filter["w_t_02"];
        $this->t_02->AdvancedSearch->save();

        // Field t_03
        $this->t_03->AdvancedSearch->SearchValue = @$filter["x_t_03"];
        $this->t_03->AdvancedSearch->SearchOperator = @$filter["z_t_03"];
        $this->t_03->AdvancedSearch->SearchCondition = @$filter["v_t_03"];
        $this->t_03->AdvancedSearch->SearchValue2 = @$filter["y_t_03"];
        $this->t_03->AdvancedSearch->SearchOperator2 = @$filter["w_t_03"];
        $this->t_03->AdvancedSearch->save();

        // Field t_04
        $this->t_04->AdvancedSearch->SearchValue = @$filter["x_t_04"];
        $this->t_04->AdvancedSearch->SearchOperator = @$filter["z_t_04"];
        $this->t_04->AdvancedSearch->SearchCondition = @$filter["v_t_04"];
        $this->t_04->AdvancedSearch->SearchValue2 = @$filter["y_t_04"];
        $this->t_04->AdvancedSearch->SearchOperator2 = @$filter["w_t_04"];
        $this->t_04->AdvancedSearch->save();

        // Field t_05
        $this->t_05->AdvancedSearch->SearchValue = @$filter["x_t_05"];
        $this->t_05->AdvancedSearch->SearchOperator = @$filter["z_t_05"];
        $this->t_05->AdvancedSearch->SearchCondition = @$filter["v_t_05"];
        $this->t_05->AdvancedSearch->SearchValue2 = @$filter["y_t_05"];
        $this->t_05->AdvancedSearch->SearchOperator2 = @$filter["w_t_05"];
        $this->t_05->AdvancedSearch->save();

        // Field t_06
        $this->t_06->AdvancedSearch->SearchValue = @$filter["x_t_06"];
        $this->t_06->AdvancedSearch->SearchOperator = @$filter["z_t_06"];
        $this->t_06->AdvancedSearch->SearchCondition = @$filter["v_t_06"];
        $this->t_06->AdvancedSearch->SearchValue2 = @$filter["y_t_06"];
        $this->t_06->AdvancedSearch->SearchOperator2 = @$filter["w_t_06"];
        $this->t_06->AdvancedSearch->save();

        // Field t_07
        $this->t_07->AdvancedSearch->SearchValue = @$filter["x_t_07"];
        $this->t_07->AdvancedSearch->SearchOperator = @$filter["z_t_07"];
        $this->t_07->AdvancedSearch->SearchCondition = @$filter["v_t_07"];
        $this->t_07->AdvancedSearch->SearchValue2 = @$filter["y_t_07"];
        $this->t_07->AdvancedSearch->SearchOperator2 = @$filter["w_t_07"];
        $this->t_07->AdvancedSearch->save();

        // Field t_08
        $this->t_08->AdvancedSearch->SearchValue = @$filter["x_t_08"];
        $this->t_08->AdvancedSearch->SearchOperator = @$filter["z_t_08"];
        $this->t_08->AdvancedSearch->SearchCondition = @$filter["v_t_08"];
        $this->t_08->AdvancedSearch->SearchValue2 = @$filter["y_t_08"];
        $this->t_08->AdvancedSearch->SearchOperator2 = @$filter["w_t_08"];
        $this->t_08->AdvancedSearch->save();

        // Field t_09
        $this->t_09->AdvancedSearch->SearchValue = @$filter["x_t_09"];
        $this->t_09->AdvancedSearch->SearchOperator = @$filter["z_t_09"];
        $this->t_09->AdvancedSearch->SearchCondition = @$filter["v_t_09"];
        $this->t_09->AdvancedSearch->SearchValue2 = @$filter["y_t_09"];
        $this->t_09->AdvancedSearch->SearchOperator2 = @$filter["w_t_09"];
        $this->t_09->AdvancedSearch->save();

        // Field t_10
        $this->t_10->AdvancedSearch->SearchValue = @$filter["x_t_10"];
        $this->t_10->AdvancedSearch->SearchOperator = @$filter["z_t_10"];
        $this->t_10->AdvancedSearch->SearchCondition = @$filter["v_t_10"];
        $this->t_10->AdvancedSearch->SearchValue2 = @$filter["y_t_10"];
        $this->t_10->AdvancedSearch->SearchOperator2 = @$filter["w_t_10"];
        $this->t_10->AdvancedSearch->save();

        // Field t_11
        $this->t_11->AdvancedSearch->SearchValue = @$filter["x_t_11"];
        $this->t_11->AdvancedSearch->SearchOperator = @$filter["z_t_11"];
        $this->t_11->AdvancedSearch->SearchCondition = @$filter["v_t_11"];
        $this->t_11->AdvancedSearch->SearchValue2 = @$filter["y_t_11"];
        $this->t_11->AdvancedSearch->SearchOperator2 = @$filter["w_t_11"];
        $this->t_11->AdvancedSearch->save();

        // Field t_12
        $this->t_12->AdvancedSearch->SearchValue = @$filter["x_t_12"];
        $this->t_12->AdvancedSearch->SearchOperator = @$filter["z_t_12"];
        $this->t_12->AdvancedSearch->SearchCondition = @$filter["v_t_12"];
        $this->t_12->AdvancedSearch->SearchValue2 = @$filter["y_t_12"];
        $this->t_12->AdvancedSearch->SearchOperator2 = @$filter["w_t_12"];
        $this->t_12->AdvancedSearch->save();

        // Field t_13
        $this->t_13->AdvancedSearch->SearchValue = @$filter["x_t_13"];
        $this->t_13->AdvancedSearch->SearchOperator = @$filter["z_t_13"];
        $this->t_13->AdvancedSearch->SearchCondition = @$filter["v_t_13"];
        $this->t_13->AdvancedSearch->SearchValue2 = @$filter["y_t_13"];
        $this->t_13->AdvancedSearch->SearchOperator2 = @$filter["w_t_13"];
        $this->t_13->AdvancedSearch->save();

        // Field t_14
        $this->t_14->AdvancedSearch->SearchValue = @$filter["x_t_14"];
        $this->t_14->AdvancedSearch->SearchOperator = @$filter["z_t_14"];
        $this->t_14->AdvancedSearch->SearchCondition = @$filter["v_t_14"];
        $this->t_14->AdvancedSearch->SearchValue2 = @$filter["y_t_14"];
        $this->t_14->AdvancedSearch->SearchOperator2 = @$filter["w_t_14"];
        $this->t_14->AdvancedSearch->save();

        // Field t_15
        $this->t_15->AdvancedSearch->SearchValue = @$filter["x_t_15"];
        $this->t_15->AdvancedSearch->SearchOperator = @$filter["z_t_15"];
        $this->t_15->AdvancedSearch->SearchCondition = @$filter["v_t_15"];
        $this->t_15->AdvancedSearch->SearchValue2 = @$filter["y_t_15"];
        $this->t_15->AdvancedSearch->SearchOperator2 = @$filter["w_t_15"];
        $this->t_15->AdvancedSearch->save();

        // Field last_price
        $this->last_price->AdvancedSearch->SearchValue = @$filter["x_last_price"];
        $this->last_price->AdvancedSearch->SearchOperator = @$filter["z_last_price"];
        $this->last_price->AdvancedSearch->SearchCondition = @$filter["v_last_price"];
        $this->last_price->AdvancedSearch->SearchValue2 = @$filter["y_last_price"];
        $this->last_price->AdvancedSearch->SearchOperator2 = @$filter["w_last_price"];
        $this->last_price->AdvancedSearch->save();

        // Field currency
        $this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
        $this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
        $this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
        $this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
        $this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
        $this->currency->AdvancedSearch->save();

        // Field hsn
        $this->hsn->AdvancedSearch->SearchValue = @$filter["x_hsn"];
        $this->hsn->AdvancedSearch->SearchOperator = @$filter["z_hsn"];
        $this->hsn->AdvancedSearch->SearchCondition = @$filter["v_hsn"];
        $this->hsn->AdvancedSearch->SearchValue2 = @$filter["y_hsn"];
        $this->hsn->AdvancedSearch->SearchOperator2 = @$filter["w_hsn"];
        $this->hsn->AdvancedSearch->save();

        // Field composition
        $this->composition->AdvancedSearch->SearchValue = @$filter["x_composition"];
        $this->composition->AdvancedSearch->SearchOperator = @$filter["z_composition"];
        $this->composition->AdvancedSearch->SearchCondition = @$filter["v_composition"];
        $this->composition->AdvancedSearch->SearchValue2 = @$filter["y_composition"];
        $this->composition->AdvancedSearch->SearchOperator2 = @$filter["w_composition"];
        $this->composition->AdvancedSearch->save();

        // Field category
        $this->category->AdvancedSearch->SearchValue = @$filter["x_category"];
        $this->category->AdvancedSearch->SearchOperator = @$filter["z_category"];
        $this->category->AdvancedSearch->SearchCondition = @$filter["v_category"];
        $this->category->AdvancedSearch->SearchValue2 = @$filter["y_category"];
        $this->category->AdvancedSearch->SearchOperator2 = @$filter["w_category"];
        $this->category->AdvancedSearch->save();

        // Field moq
        $this->moq->AdvancedSearch->SearchValue = @$filter["x_moq"];
        $this->moq->AdvancedSearch->SearchOperator = @$filter["z_moq"];
        $this->moq->AdvancedSearch->SearchCondition = @$filter["v_moq"];
        $this->moq->AdvancedSearch->SearchValue2 = @$filter["y_moq"];
        $this->moq->AdvancedSearch->SearchOperator2 = @$filter["w_moq"];
        $this->moq->AdvancedSearch->save();

        // Field status
        $this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
        $this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
        $this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
        $this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
        $this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
        $this->status->AdvancedSearch->save();

        // Field d_head_01
        $this->d_head_01->AdvancedSearch->SearchValue = @$filter["x_d_head_01"];
        $this->d_head_01->AdvancedSearch->SearchOperator = @$filter["z_d_head_01"];
        $this->d_head_01->AdvancedSearch->SearchCondition = @$filter["v_d_head_01"];
        $this->d_head_01->AdvancedSearch->SearchValue2 = @$filter["y_d_head_01"];
        $this->d_head_01->AdvancedSearch->SearchOperator2 = @$filter["w_d_head_01"];
        $this->d_head_01->AdvancedSearch->save();

        // Field d_description_01
        $this->d_description_01->AdvancedSearch->SearchValue = @$filter["x_d_description_01"];
        $this->d_description_01->AdvancedSearch->SearchOperator = @$filter["z_d_description_01"];
        $this->d_description_01->AdvancedSearch->SearchCondition = @$filter["v_d_description_01"];
        $this->d_description_01->AdvancedSearch->SearchValue2 = @$filter["y_d_description_01"];
        $this->d_description_01->AdvancedSearch->SearchOperator2 = @$filter["w_d_description_01"];
        $this->d_description_01->AdvancedSearch->save();

        // Field d_head_02
        $this->d_head_02->AdvancedSearch->SearchValue = @$filter["x_d_head_02"];
        $this->d_head_02->AdvancedSearch->SearchOperator = @$filter["z_d_head_02"];
        $this->d_head_02->AdvancedSearch->SearchCondition = @$filter["v_d_head_02"];
        $this->d_head_02->AdvancedSearch->SearchValue2 = @$filter["y_d_head_02"];
        $this->d_head_02->AdvancedSearch->SearchOperator2 = @$filter["w_d_head_02"];
        $this->d_head_02->AdvancedSearch->save();

        // Field d_description_02
        $this->d_description_02->AdvancedSearch->SearchValue = @$filter["x_d_description_02"];
        $this->d_description_02->AdvancedSearch->SearchOperator = @$filter["z_d_description_02"];
        $this->d_description_02->AdvancedSearch->SearchCondition = @$filter["v_d_description_02"];
        $this->d_description_02->AdvancedSearch->SearchValue2 = @$filter["y_d_description_02"];
        $this->d_description_02->AdvancedSearch->SearchOperator2 = @$filter["w_d_description_02"];
        $this->d_description_02->AdvancedSearch->save();

        // Field publish
        $this->publish->AdvancedSearch->SearchValue = @$filter["x_publish"];
        $this->publish->AdvancedSearch->SearchOperator = @$filter["z_publish"];
        $this->publish->AdvancedSearch->SearchCondition = @$filter["v_publish"];
        $this->publish->AdvancedSearch->SearchValue2 = @$filter["y_publish"];
        $this->publish->AdvancedSearch->SearchOperator2 = @$filter["w_publish"];
        $this->publish->AdvancedSearch->save();

        // Field keywords
        $this->keywords->AdvancedSearch->SearchValue = @$filter["x_keywords"];
        $this->keywords->AdvancedSearch->SearchOperator = @$filter["z_keywords"];
        $this->keywords->AdvancedSearch->SearchCondition = @$filter["v_keywords"];
        $this->keywords->AdvancedSearch->SearchValue2 = @$filter["y_keywords"];
        $this->keywords->AdvancedSearch->SearchOperator2 = @$filter["w_keywords"];
        $this->keywords->AdvancedSearch->save();

        // Field operator
        $this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
        $this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
        $this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
        $this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
        $this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
        $this->operator->AdvancedSearch->save();

        // Field datetime
        $this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
        $this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
        $this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
        $this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
        $this->datetime->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->id, $default, false); // id
        $this->buildSearchSql($where, $this->company_id, $default, true); // company_id
        $this->buildSearchSql($where, $this->grp, $default, false); // grp
        $this->buildSearchSql($where, $this->s_grp, $default, false); // s_grp
        $this->buildSearchSql($where, $this->product, $default, false); // product
        $this->buildSearchSql($where, $this->product_type, $default, false); // product_type
        $this->buildSearchSql($where, $this->packing_type, $default, false); // packing_type
        $this->buildSearchSql($where, $this->product_n, $default, false); // product_n
        $this->buildSearchSql($where, $this->product_code_type, $default, false); // product_code_type
        $this->buildSearchSql($where, $this->product_code, $default, false); // product_code
        $this->buildSearchSql($where, $this->v_00, $default, false); // v_00
        $this->buildSearchSql($where, $this->v_01, $default, false); // v_01
        $this->buildSearchSql($where, $this->v_02, $default, false); // v_02
        $this->buildSearchSql($where, $this->v_03, $default, false); // v_03
        $this->buildSearchSql($where, $this->v_04, $default, false); // v_04
        $this->buildSearchSql($where, $this->v_05, $default, false); // v_05
        $this->buildSearchSql($where, $this->v_06, $default, false); // v_06
        $this->buildSearchSql($where, $this->v_07, $default, false); // v_07
        $this->buildSearchSql($where, $this->v_08, $default, false); // v_08
        $this->buildSearchSql($where, $this->v_09, $default, false); // v_09
        $this->buildSearchSql($where, $this->v_10, $default, false); // v_10
        $this->buildSearchSql($where, $this->q_sku, $default, false); // q_sku
        $this->buildSearchSql($where, $this->b_01, $default, false); // b_01
        $this->buildSearchSql($where, $this->b_02, $default, false); // b_02
        $this->buildSearchSql($where, $this->b_03, $default, true); // b_03
        $this->buildSearchSql($where, $this->b_04, $default, true); // b_04
        $this->buildSearchSql($where, $this->b_05, $default, true); // b_05
        $this->buildSearchSql($where, $this->b_06, $default, true); // b_06
        $this->buildSearchSql($where, $this->b_07, $default, true); // b_07
        $this->buildSearchSql($where, $this->b_08, $default, true); // b_08
        $this->buildSearchSql($where, $this->b_09, $default, true); // b_09
        $this->buildSearchSql($where, $this->b_10, $default, true); // b_10
        $this->buildSearchSql($where, $this->b_11, $default, false); // b_11
        $this->buildSearchSql($where, $this->b_12, $default, false); // b_12
        $this->buildSearchSql($where, $this->b_13, $default, false); // b_13
        $this->buildSearchSql($where, $this->b_14, $default, false); // b_14
        $this->buildSearchSql($where, $this->b_15, $default, false); // b_15
        $this->buildSearchSql($where, $this->t_01, $default, false); // t_01
        $this->buildSearchSql($where, $this->t_02, $default, false); // t_02
        $this->buildSearchSql($where, $this->t_03, $default, true); // t_03
        $this->buildSearchSql($where, $this->t_04, $default, true); // t_04
        $this->buildSearchSql($where, $this->t_05, $default, true); // t_05
        $this->buildSearchSql($where, $this->t_06, $default, true); // t_06
        $this->buildSearchSql($where, $this->t_07, $default, true); // t_07
        $this->buildSearchSql($where, $this->t_08, $default, true); // t_08
        $this->buildSearchSql($where, $this->t_09, $default, true); // t_09
        $this->buildSearchSql($where, $this->t_10, $default, true); // t_10
        $this->buildSearchSql($where, $this->t_11, $default, false); // t_11
        $this->buildSearchSql($where, $this->t_12, $default, false); // t_12
        $this->buildSearchSql($where, $this->t_13, $default, false); // t_13
        $this->buildSearchSql($where, $this->t_14, $default, false); // t_14
        $this->buildSearchSql($where, $this->t_15, $default, false); // t_15
        $this->buildSearchSql($where, $this->last_price, $default, false); // last_price
        $this->buildSearchSql($where, $this->currency, $default, false); // currency
        $this->buildSearchSql($where, $this->hsn, $default, false); // hsn
        $this->buildSearchSql($where, $this->composition, $default, false); // composition
        $this->buildSearchSql($where, $this->category, $default, false); // category
        $this->buildSearchSql($where, $this->moq, $default, false); // moq
        $this->buildSearchSql($where, $this->status, $default, false); // status
        $this->buildSearchSql($where, $this->d_head_01, $default, false); // d_head_01
        $this->buildSearchSql($where, $this->d_description_01, $default, false); // d_description_01
        $this->buildSearchSql($where, $this->d_head_02, $default, false); // d_head_02
        $this->buildSearchSql($where, $this->d_description_02, $default, false); // d_description_02
        $this->buildSearchSql($where, $this->publish, $default, false); // publish
        $this->buildSearchSql($where, $this->keywords, $default, false); // keywords
        $this->buildSearchSql($where, $this->operator, $default, false); // operator
        $this->buildSearchSql($where, $this->datetime, $default, false); // datetime

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->id->AdvancedSearch->save(); // id
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->product_n->AdvancedSearch->save(); // product_n
            $this->product_code_type->AdvancedSearch->save(); // product_code_type
            $this->product_code->AdvancedSearch->save(); // product_code
            $this->v_00->AdvancedSearch->save(); // v_00
            $this->v_01->AdvancedSearch->save(); // v_01
            $this->v_02->AdvancedSearch->save(); // v_02
            $this->v_03->AdvancedSearch->save(); // v_03
            $this->v_04->AdvancedSearch->save(); // v_04
            $this->v_05->AdvancedSearch->save(); // v_05
            $this->v_06->AdvancedSearch->save(); // v_06
            $this->v_07->AdvancedSearch->save(); // v_07
            $this->v_08->AdvancedSearch->save(); // v_08
            $this->v_09->AdvancedSearch->save(); // v_09
            $this->v_10->AdvancedSearch->save(); // v_10
            $this->q_sku->AdvancedSearch->save(); // q_sku
            $this->b_01->AdvancedSearch->save(); // b_01
            $this->b_02->AdvancedSearch->save(); // b_02
            $this->b_03->AdvancedSearch->save(); // b_03
            $this->b_04->AdvancedSearch->save(); // b_04
            $this->b_05->AdvancedSearch->save(); // b_05
            $this->b_06->AdvancedSearch->save(); // b_06
            $this->b_07->AdvancedSearch->save(); // b_07
            $this->b_08->AdvancedSearch->save(); // b_08
            $this->b_09->AdvancedSearch->save(); // b_09
            $this->b_10->AdvancedSearch->save(); // b_10
            $this->b_11->AdvancedSearch->save(); // b_11
            $this->b_12->AdvancedSearch->save(); // b_12
            $this->b_13->AdvancedSearch->save(); // b_13
            $this->b_14->AdvancedSearch->save(); // b_14
            $this->b_15->AdvancedSearch->save(); // b_15
            $this->t_01->AdvancedSearch->save(); // t_01
            $this->t_02->AdvancedSearch->save(); // t_02
            $this->t_03->AdvancedSearch->save(); // t_03
            $this->t_04->AdvancedSearch->save(); // t_04
            $this->t_05->AdvancedSearch->save(); // t_05
            $this->t_06->AdvancedSearch->save(); // t_06
            $this->t_07->AdvancedSearch->save(); // t_07
            $this->t_08->AdvancedSearch->save(); // t_08
            $this->t_09->AdvancedSearch->save(); // t_09
            $this->t_10->AdvancedSearch->save(); // t_10
            $this->t_11->AdvancedSearch->save(); // t_11
            $this->t_12->AdvancedSearch->save(); // t_12
            $this->t_13->AdvancedSearch->save(); // t_13
            $this->t_14->AdvancedSearch->save(); // t_14
            $this->t_15->AdvancedSearch->save(); // t_15
            $this->last_price->AdvancedSearch->save(); // last_price
            $this->currency->AdvancedSearch->save(); // currency
            $this->hsn->AdvancedSearch->save(); // hsn
            $this->composition->AdvancedSearch->save(); // composition
            $this->category->AdvancedSearch->save(); // category
            $this->moq->AdvancedSearch->save(); // moq
            $this->status->AdvancedSearch->save(); // status
            $this->d_head_01->AdvancedSearch->save(); // d_head_01
            $this->d_description_01->AdvancedSearch->save(); // d_description_01
            $this->d_head_02->AdvancedSearch->save(); // d_head_02
            $this->d_description_02->AdvancedSearch->save(); // d_description_02
            $this->publish->AdvancedSearch->save(); // publish
            $this->keywords->AdvancedSearch->save(); // keywords
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->id->AdvancedSearch->save(); // id
            $this->company_id->AdvancedSearch->save(); // company_id
            $this->grp->AdvancedSearch->save(); // grp
            $this->s_grp->AdvancedSearch->save(); // s_grp
            $this->product->AdvancedSearch->save(); // product
            $this->product_type->AdvancedSearch->save(); // product_type
            $this->packing_type->AdvancedSearch->save(); // packing_type
            $this->product_n->AdvancedSearch->save(); // product_n
            $this->product_code_type->AdvancedSearch->save(); // product_code_type
            $this->product_code->AdvancedSearch->save(); // product_code
            $this->v_00->AdvancedSearch->save(); // v_00
            $this->v_01->AdvancedSearch->save(); // v_01
            $this->v_02->AdvancedSearch->save(); // v_02
            $this->v_03->AdvancedSearch->save(); // v_03
            $this->v_04->AdvancedSearch->save(); // v_04
            $this->v_05->AdvancedSearch->save(); // v_05
            $this->v_06->AdvancedSearch->save(); // v_06
            $this->v_07->AdvancedSearch->save(); // v_07
            $this->v_08->AdvancedSearch->save(); // v_08
            $this->v_09->AdvancedSearch->save(); // v_09
            $this->v_10->AdvancedSearch->save(); // v_10
            $this->q_sku->AdvancedSearch->save(); // q_sku
            $this->b_01->AdvancedSearch->save(); // b_01
            $this->b_02->AdvancedSearch->save(); // b_02
            $this->b_03->AdvancedSearch->save(); // b_03
            $this->b_04->AdvancedSearch->save(); // b_04
            $this->b_05->AdvancedSearch->save(); // b_05
            $this->b_06->AdvancedSearch->save(); // b_06
            $this->b_07->AdvancedSearch->save(); // b_07
            $this->b_08->AdvancedSearch->save(); // b_08
            $this->b_09->AdvancedSearch->save(); // b_09
            $this->b_10->AdvancedSearch->save(); // b_10
            $this->b_11->AdvancedSearch->save(); // b_11
            $this->b_12->AdvancedSearch->save(); // b_12
            $this->b_13->AdvancedSearch->save(); // b_13
            $this->b_14->AdvancedSearch->save(); // b_14
            $this->b_15->AdvancedSearch->save(); // b_15
            $this->t_01->AdvancedSearch->save(); // t_01
            $this->t_02->AdvancedSearch->save(); // t_02
            $this->t_03->AdvancedSearch->save(); // t_03
            $this->t_04->AdvancedSearch->save(); // t_04
            $this->t_05->AdvancedSearch->save(); // t_05
            $this->t_06->AdvancedSearch->save(); // t_06
            $this->t_07->AdvancedSearch->save(); // t_07
            $this->t_08->AdvancedSearch->save(); // t_08
            $this->t_09->AdvancedSearch->save(); // t_09
            $this->t_10->AdvancedSearch->save(); // t_10
            $this->t_11->AdvancedSearch->save(); // t_11
            $this->t_12->AdvancedSearch->save(); // t_12
            $this->t_13->AdvancedSearch->save(); // t_13
            $this->t_14->AdvancedSearch->save(); // t_14
            $this->t_15->AdvancedSearch->save(); // t_15
            $this->last_price->AdvancedSearch->save(); // last_price
            $this->currency->AdvancedSearch->save(); // currency
            $this->hsn->AdvancedSearch->save(); // hsn
            $this->composition->AdvancedSearch->save(); // composition
            $this->category->AdvancedSearch->save(); // category
            $this->moq->AdvancedSearch->save(); // moq
            $this->status->AdvancedSearch->save(); // status
            $this->d_head_01->AdvancedSearch->save(); // d_head_01
            $this->d_description_01->AdvancedSearch->save(); // d_description_01
            $this->d_head_02->AdvancedSearch->save(); // d_head_02
            $this->d_description_02->AdvancedSearch->save(); // d_description_02
            $this->publish->AdvancedSearch->save(); // publish
            $this->keywords->AdvancedSearch->save(); // keywords
            $this->operator->AdvancedSearch->save(); // operator
            $this->datetime->AdvancedSearch->save(); // datetime
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field id
        $filter = $this->queryBuilderWhere("id");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->id, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->id->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field grp
        $filter = $this->queryBuilderWhere("grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field s_grp
        $filter = $this->queryBuilderWhere("s_grp");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->s_grp, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->s_grp->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product
        $filter = $this->queryBuilderWhere("product");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field packing_type
        $filter = $this->queryBuilderWhere("packing_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->packing_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->packing_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_n
        $filter = $this->queryBuilderWhere("product_n");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_n, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_n->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_code_type
        $filter = $this->queryBuilderWhere("product_code_type");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_code_type, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_code_type->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field product_code
        $filter = $this->queryBuilderWhere("product_code");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->product_code, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->product_code->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field v_00
        $filter = $this->queryBuilderWhere("v_00");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->v_00, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->v_00->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field q_sku
        $filter = $this->queryBuilderWhere("q_sku");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->q_sku, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->q_sku->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field composition
        $filter = $this->queryBuilderWhere("composition");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->composition, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->composition->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field category
        $filter = $this->queryBuilderWhere("category");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->category, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->category->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field status
        $filter = $this->queryBuilderWhere("status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->status, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->id;
        $searchFlds[] = &$this->company_id;
        $searchFlds[] = &$this->grp;
        $searchFlds[] = &$this->s_grp;
        $searchFlds[] = &$this->product;
        $searchFlds[] = &$this->product_type;
        $searchFlds[] = &$this->product_n;
        $searchFlds[] = &$this->_barcode;
        $searchFlds[] = &$this->product_code;
        $searchFlds[] = &$this->v_00;
        $searchFlds[] = &$this->v_01;
        $searchFlds[] = &$this->v_02;
        $searchFlds[] = &$this->v_03;
        $searchFlds[] = &$this->v_04;
        $searchFlds[] = &$this->v_05;
        $searchFlds[] = &$this->v_06;
        $searchFlds[] = &$this->v_07;
        $searchFlds[] = &$this->v_08;
        $searchFlds[] = &$this->v_09;
        $searchFlds[] = &$this->v_10;
        $searchFlds[] = &$this->cbm;
        $searchFlds[] = &$this->sqm;
        $searchFlds[] = &$this->shape;
        $searchFlds[] = &$this->b_01;
        $searchFlds[] = &$this->b_02;
        $searchFlds[] = &$this->b_03;
        $searchFlds[] = &$this->b_04;
        $searchFlds[] = &$this->b_05;
        $searchFlds[] = &$this->b_06;
        $searchFlds[] = &$this->b_07;
        $searchFlds[] = &$this->b_08;
        $searchFlds[] = &$this->b_09;
        $searchFlds[] = &$this->b_10;
        $searchFlds[] = &$this->b_11;
        $searchFlds[] = &$this->b_12;
        $searchFlds[] = &$this->b_13;
        $searchFlds[] = &$this->b_14;
        $searchFlds[] = &$this->b_15;
        $searchFlds[] = &$this->t_01;
        $searchFlds[] = &$this->t_02;
        $searchFlds[] = &$this->t_03;
        $searchFlds[] = &$this->t_04;
        $searchFlds[] = &$this->t_05;
        $searchFlds[] = &$this->t_06;
        $searchFlds[] = &$this->t_07;
        $searchFlds[] = &$this->t_08;
        $searchFlds[] = &$this->t_09;
        $searchFlds[] = &$this->t_10;
        $searchFlds[] = &$this->t_11;
        $searchFlds[] = &$this->t_12;
        $searchFlds[] = &$this->t_13;
        $searchFlds[] = &$this->t_14;
        $searchFlds[] = &$this->t_15;
        $searchFlds[] = &$this->last_price;
        $searchFlds[] = &$this->hsn;
        $searchFlds[] = &$this->status;
        $searchFlds[] = &$this->d_head_01;
        $searchFlds[] = &$this->d_description_01;
        $searchFlds[] = &$this->d_head_02;
        $searchFlds[] = &$this->d_description_02;
        $searchFlds[] = &$this->publish;
        $searchFlds[] = &$this->keywords;
        $searchFlds[] = &$this->operator;
        $searchFlds[] = &$this->datetime;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->company_id->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->s_grp->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->packing_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_n->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_code_type->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->product_code->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_00->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_06->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_07->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_08->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_09->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->v_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->q_sku->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_06->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_07->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_08->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_09->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_12->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_13->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_14->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->b_15->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_03->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_04->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_05->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_06->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_07->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_08->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_09->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_10->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_11->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_12->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_13->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_14->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->t_15->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->last_price->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->currency->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->hsn->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->composition->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->category->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->moq->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_head_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_description_01->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_head_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->d_description_02->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->publish->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->keywords->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->operator->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->datetime->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->id->AdvancedSearch->unsetSession();
        $this->company_id->AdvancedSearch->unsetSession();
        $this->grp->AdvancedSearch->unsetSession();
        $this->s_grp->AdvancedSearch->unsetSession();
        $this->product->AdvancedSearch->unsetSession();
        $this->product_type->AdvancedSearch->unsetSession();
        $this->packing_type->AdvancedSearch->unsetSession();
        $this->product_n->AdvancedSearch->unsetSession();
        $this->product_code_type->AdvancedSearch->unsetSession();
        $this->product_code->AdvancedSearch->unsetSession();
        $this->v_00->AdvancedSearch->unsetSession();
        $this->v_01->AdvancedSearch->unsetSession();
        $this->v_02->AdvancedSearch->unsetSession();
        $this->v_03->AdvancedSearch->unsetSession();
        $this->v_04->AdvancedSearch->unsetSession();
        $this->v_05->AdvancedSearch->unsetSession();
        $this->v_06->AdvancedSearch->unsetSession();
        $this->v_07->AdvancedSearch->unsetSession();
        $this->v_08->AdvancedSearch->unsetSession();
        $this->v_09->AdvancedSearch->unsetSession();
        $this->v_10->AdvancedSearch->unsetSession();
        $this->q_sku->AdvancedSearch->unsetSession();
        $this->b_01->AdvancedSearch->unsetSession();
        $this->b_02->AdvancedSearch->unsetSession();
        $this->b_03->AdvancedSearch->unsetSession();
        $this->b_04->AdvancedSearch->unsetSession();
        $this->b_05->AdvancedSearch->unsetSession();
        $this->b_06->AdvancedSearch->unsetSession();
        $this->b_07->AdvancedSearch->unsetSession();
        $this->b_08->AdvancedSearch->unsetSession();
        $this->b_09->AdvancedSearch->unsetSession();
        $this->b_10->AdvancedSearch->unsetSession();
        $this->b_11->AdvancedSearch->unsetSession();
        $this->b_12->AdvancedSearch->unsetSession();
        $this->b_13->AdvancedSearch->unsetSession();
        $this->b_14->AdvancedSearch->unsetSession();
        $this->b_15->AdvancedSearch->unsetSession();
        $this->t_01->AdvancedSearch->unsetSession();
        $this->t_02->AdvancedSearch->unsetSession();
        $this->t_03->AdvancedSearch->unsetSession();
        $this->t_04->AdvancedSearch->unsetSession();
        $this->t_05->AdvancedSearch->unsetSession();
        $this->t_06->AdvancedSearch->unsetSession();
        $this->t_07->AdvancedSearch->unsetSession();
        $this->t_08->AdvancedSearch->unsetSession();
        $this->t_09->AdvancedSearch->unsetSession();
        $this->t_10->AdvancedSearch->unsetSession();
        $this->t_11->AdvancedSearch->unsetSession();
        $this->t_12->AdvancedSearch->unsetSession();
        $this->t_13->AdvancedSearch->unsetSession();
        $this->t_14->AdvancedSearch->unsetSession();
        $this->t_15->AdvancedSearch->unsetSession();
        $this->last_price->AdvancedSearch->unsetSession();
        $this->currency->AdvancedSearch->unsetSession();
        $this->hsn->AdvancedSearch->unsetSession();
        $this->composition->AdvancedSearch->unsetSession();
        $this->category->AdvancedSearch->unsetSession();
        $this->moq->AdvancedSearch->unsetSession();
        $this->status->AdvancedSearch->unsetSession();
        $this->d_head_01->AdvancedSearch->unsetSession();
        $this->d_description_01->AdvancedSearch->unsetSession();
        $this->d_head_02->AdvancedSearch->unsetSession();
        $this->d_description_02->AdvancedSearch->unsetSession();
        $this->publish->AdvancedSearch->unsetSession();
        $this->keywords->AdvancedSearch->unsetSession();
        $this->operator->AdvancedSearch->unsetSession();
        $this->datetime->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->id->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->product_n->AdvancedSearch->load();
        $this->product_code_type->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->v_00->AdvancedSearch->load();
        $this->v_01->AdvancedSearch->load();
        $this->v_02->AdvancedSearch->load();
        $this->v_03->AdvancedSearch->load();
        $this->v_04->AdvancedSearch->load();
        $this->v_05->AdvancedSearch->load();
        $this->v_06->AdvancedSearch->load();
        $this->v_07->AdvancedSearch->load();
        $this->v_08->AdvancedSearch->load();
        $this->v_09->AdvancedSearch->load();
        $this->v_10->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->b_01->AdvancedSearch->load();
        $this->b_02->AdvancedSearch->load();
        $this->b_03->AdvancedSearch->load();
        $this->b_04->AdvancedSearch->load();
        $this->b_05->AdvancedSearch->load();
        $this->b_06->AdvancedSearch->load();
        $this->b_07->AdvancedSearch->load();
        $this->b_08->AdvancedSearch->load();
        $this->b_09->AdvancedSearch->load();
        $this->b_10->AdvancedSearch->load();
        $this->b_11->AdvancedSearch->load();
        $this->b_12->AdvancedSearch->load();
        $this->b_13->AdvancedSearch->load();
        $this->b_14->AdvancedSearch->load();
        $this->b_15->AdvancedSearch->load();
        $this->t_01->AdvancedSearch->load();
        $this->t_02->AdvancedSearch->load();
        $this->t_03->AdvancedSearch->load();
        $this->t_04->AdvancedSearch->load();
        $this->t_05->AdvancedSearch->load();
        $this->t_06->AdvancedSearch->load();
        $this->t_07->AdvancedSearch->load();
        $this->t_08->AdvancedSearch->load();
        $this->t_09->AdvancedSearch->load();
        $this->t_10->AdvancedSearch->load();
        $this->t_11->AdvancedSearch->load();
        $this->t_12->AdvancedSearch->load();
        $this->t_13->AdvancedSearch->load();
        $this->t_14->AdvancedSearch->load();
        $this->t_15->AdvancedSearch->load();
        $this->last_price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->hsn->AdvancedSearch->load();
        $this->composition->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->moq->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->d_head_01->AdvancedSearch->load();
        $this->d_description_01->AdvancedSearch->load();
        $this->d_head_02->AdvancedSearch->load();
        $this->d_description_02->AdvancedSearch->load();
        $this->publish->AdvancedSearch->load();
        $this->keywords->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = $this->id->Expression . " DESC"; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for Ctrl pressed
        $ctrl = Get("ctrl") !== null;

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->id, $ctrl); // id
            $this->updateSort($this->grp, $ctrl); // grp
            $this->updateSort($this->s_grp, $ctrl); // s_grp
            $this->updateSort($this->product, $ctrl); // product
            $this->updateSort($this->packing_type, $ctrl); // packing_type
            $this->updateSort($this->product_n, $ctrl); // product_n
            $this->updateSort($this->product_code_type, $ctrl); // product_code_type
            $this->updateSort($this->product_code, $ctrl); // product_code
            $this->updateSort($this->v_00, $ctrl); // v_00
            $this->updateSort($this->q_sku, $ctrl); // q_sku
            $this->updateSort($this->composition, $ctrl); // composition
            $this->updateSort($this->category, $ctrl); // category
            $this->updateSort($this->status, $ctrl); // status
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->id->setSort("");
                $this->oid->setSort("");
                $this->company_id->setSort("");
                $this->grp->setSort("");
                $this->s_grp->setSort("");
                $this->product->setSort("");
                $this->product_type->setSort("");
                $this->packing_type->setSort("");
                $this->product_n->setSort("");
                $this->_barcode->setSort("");
                $this->product_code_type->setSort("");
                $this->product_code->setSort("");
                $this->print_name->setSort("");
                $this->gcode->setSort("");
                $this->code->setSort("");
                $this->product_id->setSort("");
                $this->batch_no->setSort("");
                $this->set_ref->setSort("");
                $this->v_00->setSort("");
                $this->v_01->setSort("");
                $this->v_02->setSort("");
                $this->v_03->setSort("");
                $this->v_04->setSort("");
                $this->v_05->setSort("");
                $this->v_06->setSort("");
                $this->v_07->setSort("");
                $this->v_08->setSort("");
                $this->v_09->setSort("");
                $this->v_10->setSort("");
                $this->cbm->setSort("");
                $this->sqm->setSort("");
                $this->shape->setSort("");
                $this->q_sku->setSort("");
                $this->b_01->setSort("");
                $this->b_02->setSort("");
                $this->b_03->setSort("");
                $this->b_04->setSort("");
                $this->b_05->setSort("");
                $this->b_06->setSort("");
                $this->b_07->setSort("");
                $this->b_08->setSort("");
                $this->b_09->setSort("");
                $this->b_10->setSort("");
                $this->b_11->setSort("");
                $this->b_12->setSort("");
                $this->b_13->setSort("");
                $this->b_14->setSort("");
                $this->b_15->setSort("");
                $this->t_01->setSort("");
                $this->t_02->setSort("");
                $this->t_03->setSort("");
                $this->t_04->setSort("");
                $this->t_05->setSort("");
                $this->t_06->setSort("");
                $this->t_07->setSort("");
                $this->t_08->setSort("");
                $this->t_09->setSort("");
                $this->t_10->setSort("");
                $this->t_11->setSort("");
                $this->t_12->setSort("");
                $this->t_13->setSort("");
                $this->t_14->setSort("");
                $this->t_15->setSort("");
                $this->last_price->setSort("");
                $this->currency->setSort("");
                $this->hsn->setSort("");
                $this->composition->setSort("");
                $this->category->setSort("");
                $this->moq->setSort("");
                $this->status->setSort("");
                $this->d_head_01->setSort("");
                $this->d_description_01->setSort("");
                $this->d_head_02->setSort("");
                $this->d_description_02->setSort("");
                $this->publish->setSort("");
                $this->keywords->setSort("");
                $this->operator->setSort("");
                $this->datetime->setSort("");
                $this->main_image->setSort("");
                $this->top_view->setSort("");
                $this->front_view->setSort("");
                $this->corner_view->setSort("");
                $this->back_view->setSort("");
                $this->color_options->setSort("");
                $this->other_options->setSort("");
                $this->group_image->setSort("");
                $this->video_url->setSort("");
                $this->image->setSort("");
                $this->in->setSort("");
                $this->out->setSort("");
                $this->required->setSort("");
                $this->blocked->setSort("");
                $this->ordered->setSort("");
                $this->supplier->setSort("");
                $this->country->setSort("");
                $this->minimum_stock->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "delete"
        $item = &$this->ListOptions->add("delete");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canDelete();
        $item->OnLeft = true;

        // "detail_multiple_price"
        $item = &$this->ListOptions->add("detail_multiple_price");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'multiple_price');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_partner_product_ref"
        $item = &$this->ListOptions->add("detail_partner_product_ref");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'partner_product_ref');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$this->ListOptions->add("details");
            $item->CssClass = "text-nowrap";
            $item->Visible = $this->ShowMultipleDetails && $this->ListOptions->detailVisible();
            $item->OnLeft = true;
            $item->ShowInButtonGroup = false;
            $this->ListOptions->hideDetailItems();
        }

        // Set up detail pages
        $pages = new SubPages();
        $pages->add("multiple_price");
        $pages->add("partner_product_ref");
        $this->DetailPages = $pages;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = false;
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = false;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"ref\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"ref\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"ref\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "delete"
            $opt = $this->ListOptions["delete"];
            if ($Security->canDelete()) {
                $deleteCaption = $Language->phrase("DeleteLink");
                $deleteTitle = HtmlTitle($deleteCaption);
                if ($this->UseAjaxActions) {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\" data-ew-action=\"inline\" data-action=\"delete\" title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" data-key= \"" . HtmlEncode($this->getKey(true)) . "\" data-url=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-delete\"" .
                        ($this->InlineDelete ? " data-ew-action=\"inline-delete\"" : "") .
                        " title=\"" . $deleteTitle . "\" data-caption=\"" . $deleteTitle . "\" href=\"" . HtmlEncode(GetUrl($this->DeleteUrl)) . "\">" . $deleteCaption . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"freflist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"freflist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttributes() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = implode(array_map(fn($link) => "<li>" . $link . "</li>", $links));
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_multiple_price"
        $opt = $this->ListOptions["detail_multiple_price"];
        if ($Security->allowList(CurrentProjectID() . 'multiple_price')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("multiple_price", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("multiplepricelist?" . Config("TABLE_SHOW_MASTER") . "=ref&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("MultiplePriceGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=multiple_price");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "multiple_price";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=multiple_price");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "multiple_price";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=multiple_price");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "multiple_price";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_partner_product_ref"
        $opt = $this->ListOptions["detail_partner_product_ref"];
        if ($Security->allowList(CurrentProjectID() . 'partner_product_ref')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("partner_product_ref", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("partnerproductreflist?" . Config("TABLE_SHOW_MASTER") . "=ref&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("PartnerProductRefGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=partner_product_ref");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "partner_product_ref";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=partner_product_ref");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "partner_product_ref";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=partner_product_ref");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "partner_product_ref";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $opt = $this->ListOptions["details"];
            $opt->Body = $body;
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;

        // Preview extension
        $links = "";
        $detailFilters = [];
        $masterKeys = []; // Reset
        $masterKeys["id"] = strval($this->id->DbValue);

        // Column "detail_multiple_price"
        if ($this->DetailPages?->getItem("multiple_price")?->Visible && $Security->allowList(CurrentProjectID() . 'multiple_price')) {
            $link = "";
            $option = $this->ListOptions["detail_multiple_price"];
            $detailTbl = Container("multiple_price");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "multiplepricepreview?t=ref&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"multiple_price\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'ref')) {
                $label = $Language->tablePhrase("multiple_price", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"multiple_price\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("multiplepricelist?" . Config("TABLE_SHOW_MASTER") . "=ref");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("multiple_price", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $title . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("MultiplePriceGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailViewLink");
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=multiple_price"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailEditLink");
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=multiple_price"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailCopyLink");
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=multiple_price"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["id"] = strval($this->id->DbValue);

        // Column "detail_partner_product_ref"
        if ($this->DetailPages?->getItem("partner_product_ref")?->Visible && $Security->allowList(CurrentProjectID() . 'partner_product_ref')) {
            $link = "";
            $option = $this->ListOptions["detail_partner_product_ref"];
            $detailTbl = Container("partner_product_ref");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "partnerproductrefpreview?t=ref&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"partner_product_ref\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'ref')) {
                $label = $Language->tablePhrase("partner_product_ref", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"partner_product_ref\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("partnerproductreflist?" . Config("TABLE_SHOW_MASTER") . "=ref");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("partner_product_ref", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $title . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("PartnerProductRefGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailViewLink");
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=partner_product_ref"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailEditLink");
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=partner_product_ref"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'ref')) {
                $caption = $Language->phrase("MasterDetailCopyLink");
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=partner_product_ref"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }

        // Add row attributes for expandable row
        if ($this->RowType == RowType::VIEW) {
            $this->RowAttrs["data-widget"] = "expandable-table";
            $this->RowAttrs["aria-expanded"] = "false";
        }

        // Column "preview"
        $option = $this->ListOptions["preview"];
        if (!$option) { // Add preview column
            $option = &$this->ListOptions->add("preview");
            $option->OnLeft = true;
            $checkboxPos = $this->ListOptions->itemPos("checkbox");
            $pos = $checkboxPos === false
                ? ($option->OnLeft ? 0 : -1)
                : ($option->OnLeft ? $checkboxPos + 1 : $checkboxPos);
            $option->moveTo($pos);
            $option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit());
            $option->ShowInDropDown = false;
            $option->ShowInButtonGroup = false;
        }
        if ($option) {
            $icon = "fa-solid fa-caret-right fa-fw"; // Right
            if (property_exists($this, "MultiColumnLayout") && $this->MultiColumnLayout == "table") {
                $option->CssStyle = "width: 1%;";
                if (!$option->OnLeft) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            if (IsRTL()) { // Reverse
                if (preg_match('/\\bleft\\b/', $icon)) {
                    $icon = preg_replace('/\\bleft\\b/', "right", $icon);
                } elseif (preg_match('/\\bright\\b/', $icon)) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            $option->Body = "<i role=\"button\" class=\"ew-preview-btn expandable-table-caret ew-icon " . $icon . "\"></i>" .
                "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }

        // Column "details" (Multiple details)
        $option = $this->ListOptions["details"];
        if ($option) {
            $option->Body .= "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"ref\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["detail"];
        $detailTableLink = "";
        $item = &$option->add("detailadd_multiple_price");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=multiple_price");
        $detailPage = Container("MultiplePriceGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'ref') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "multiple_price";
        }
        $item = &$option->add("detailadd_partner_product_ref");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=partner_product_ref");
        $detailPage = Container("PartnerProductRefGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'ref') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "partner_product_ref";
        }

        // Add multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$option->add("detailsadd");
            $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailTableLink);
            $caption = $Language->phrase("AddMasterDetailLink");
            $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
            $item->Visible = $detailTableLink != "" && $Security->canAdd();
            // Hide single master/detail items
            $ar = explode(",", $detailTableLink);
            $cnt = count($ar);
            for ($i = 0; $i < $cnt; $i++) {
                if ($item = $option["detailadd_" . $ar[$i]]) {
                    $item->Visible = false;
                }
            }
        }
        $option = $options["action"];

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "id");
            $this->createColumnOption($option, "grp");
            $this->createColumnOption($option, "s_grp");
            $this->createColumnOption($option, "product");
            $this->createColumnOption($option, "packing_type");
            $this->createColumnOption($option, "product_n");
            $this->createColumnOption($option, "product_code_type");
            $this->createColumnOption($option, "product_code");
            $this->createColumnOption($option, "v_00");
            $this->createColumnOption($option, "q_sku");
            $this->createColumnOption($option, "composition");
            $this->createColumnOption($option, "category");
            $this->createColumnOption($option, "status");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"frefsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"frefsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="freflist"' . $listAction->toDataAttributes() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_ref", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_ref",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->id->AdvancedSearch->SearchValue != "" || $this->id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // company_id
        if ($this->company_id->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->company_id->AdvancedSearch->SearchValue != "" || $this->company_id->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->company_id->AdvancedSearch->SearchValue)) {
            $this->company_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->company_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->company_id->AdvancedSearch->SearchValue2)) {
            $this->company_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->company_id->AdvancedSearch->SearchValue2);
        }

        // grp
        if ($this->grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->grp->AdvancedSearch->SearchValue != "" || $this->grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // s_grp
        if ($this->s_grp->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->s_grp->AdvancedSearch->SearchValue != "" || $this->s_grp->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product->AdvancedSearch->SearchValue != "" || $this->product->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_type
        if ($this->product_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_type->AdvancedSearch->SearchValue != "" || $this->product_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->packing_type->AdvancedSearch->SearchValue != "" || $this->packing_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_n
        if ($this->product_n->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_n->AdvancedSearch->SearchValue != "" || $this->product_n->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_code_type
        if ($this->product_code_type->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_code_type->AdvancedSearch->SearchValue != "" || $this->product_code_type->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->product_code->AdvancedSearch->SearchValue != "" || $this->product_code->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_00
        if ($this->v_00->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_00->AdvancedSearch->SearchValue != "" || $this->v_00->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_01
        if ($this->v_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_01->AdvancedSearch->SearchValue != "" || $this->v_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_02
        if ($this->v_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_02->AdvancedSearch->SearchValue != "" || $this->v_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_03
        if ($this->v_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_03->AdvancedSearch->SearchValue != "" || $this->v_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_04
        if ($this->v_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_04->AdvancedSearch->SearchValue != "" || $this->v_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_05
        if ($this->v_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_05->AdvancedSearch->SearchValue != "" || $this->v_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_06
        if ($this->v_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_06->AdvancedSearch->SearchValue != "" || $this->v_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_07
        if ($this->v_07->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_07->AdvancedSearch->SearchValue != "" || $this->v_07->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_08
        if ($this->v_08->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_08->AdvancedSearch->SearchValue != "" || $this->v_08->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_09
        if ($this->v_09->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_09->AdvancedSearch->SearchValue != "" || $this->v_09->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // v_10
        if ($this->v_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->v_10->AdvancedSearch->SearchValue != "" || $this->v_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // q_sku
        if ($this->q_sku->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->q_sku->AdvancedSearch->SearchValue != "" || $this->q_sku->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_01
        if ($this->b_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_01->AdvancedSearch->SearchValue != "" || $this->b_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_02
        if ($this->b_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_02->AdvancedSearch->SearchValue != "" || $this->b_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_03
        if ($this->b_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_03->AdvancedSearch->SearchValue != "" || $this->b_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_03->AdvancedSearch->SearchValue)) {
            $this->b_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_03->AdvancedSearch->SearchValue2)) {
            $this->b_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_03->AdvancedSearch->SearchValue2);
        }

        // b_04
        if ($this->b_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_04->AdvancedSearch->SearchValue != "" || $this->b_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_04->AdvancedSearch->SearchValue)) {
            $this->b_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_04->AdvancedSearch->SearchValue2)) {
            $this->b_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_04->AdvancedSearch->SearchValue2);
        }

        // b_05
        if ($this->b_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_05->AdvancedSearch->SearchValue != "" || $this->b_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_05->AdvancedSearch->SearchValue)) {
            $this->b_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_05->AdvancedSearch->SearchValue2)) {
            $this->b_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_05->AdvancedSearch->SearchValue2);
        }

        // b_06
        if ($this->b_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_06->AdvancedSearch->SearchValue != "" || $this->b_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_06->AdvancedSearch->SearchValue)) {
            $this->b_06->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_06->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_06->AdvancedSearch->SearchValue2)) {
            $this->b_06->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_06->AdvancedSearch->SearchValue2);
        }

        // b_07
        if ($this->b_07->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_07->AdvancedSearch->SearchValue != "" || $this->b_07->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_07->AdvancedSearch->SearchValue)) {
            $this->b_07->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_07->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_07->AdvancedSearch->SearchValue2)) {
            $this->b_07->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_07->AdvancedSearch->SearchValue2);
        }

        // b_08
        if ($this->b_08->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_08->AdvancedSearch->SearchValue != "" || $this->b_08->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_08->AdvancedSearch->SearchValue)) {
            $this->b_08->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_08->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_08->AdvancedSearch->SearchValue2)) {
            $this->b_08->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_08->AdvancedSearch->SearchValue2);
        }

        // b_09
        if ($this->b_09->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_09->AdvancedSearch->SearchValue != "" || $this->b_09->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_09->AdvancedSearch->SearchValue)) {
            $this->b_09->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_09->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_09->AdvancedSearch->SearchValue2)) {
            $this->b_09->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_09->AdvancedSearch->SearchValue2);
        }

        // b_10
        if ($this->b_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_10->AdvancedSearch->SearchValue != "" || $this->b_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->b_10->AdvancedSearch->SearchValue)) {
            $this->b_10->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_10->AdvancedSearch->SearchValue);
        }
        if (is_array($this->b_10->AdvancedSearch->SearchValue2)) {
            $this->b_10->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->b_10->AdvancedSearch->SearchValue2);
        }

        // b_11
        if ($this->b_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_11->AdvancedSearch->SearchValue != "" || $this->b_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_12
        if ($this->b_12->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_12->AdvancedSearch->SearchValue != "" || $this->b_12->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_13
        if ($this->b_13->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_13->AdvancedSearch->SearchValue != "" || $this->b_13->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_14
        if ($this->b_14->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_14->AdvancedSearch->SearchValue != "" || $this->b_14->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // b_15
        if ($this->b_15->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->b_15->AdvancedSearch->SearchValue != "" || $this->b_15->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_01
        if ($this->t_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_01->AdvancedSearch->SearchValue != "" || $this->t_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_02
        if ($this->t_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_02->AdvancedSearch->SearchValue != "" || $this->t_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_03
        if ($this->t_03->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_03->AdvancedSearch->SearchValue != "" || $this->t_03->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_03->AdvancedSearch->SearchValue)) {
            $this->t_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_03->AdvancedSearch->SearchValue2)) {
            $this->t_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_03->AdvancedSearch->SearchValue2);
        }

        // t_04
        if ($this->t_04->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_04->AdvancedSearch->SearchValue != "" || $this->t_04->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_04->AdvancedSearch->SearchValue)) {
            $this->t_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_04->AdvancedSearch->SearchValue2)) {
            $this->t_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_04->AdvancedSearch->SearchValue2);
        }

        // t_05
        if ($this->t_05->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_05->AdvancedSearch->SearchValue != "" || $this->t_05->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_05->AdvancedSearch->SearchValue)) {
            $this->t_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_05->AdvancedSearch->SearchValue2)) {
            $this->t_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_05->AdvancedSearch->SearchValue2);
        }

        // t_06
        if ($this->t_06->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_06->AdvancedSearch->SearchValue != "" || $this->t_06->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_06->AdvancedSearch->SearchValue)) {
            $this->t_06->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_06->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_06->AdvancedSearch->SearchValue2)) {
            $this->t_06->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_06->AdvancedSearch->SearchValue2);
        }

        // t_07
        if ($this->t_07->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_07->AdvancedSearch->SearchValue != "" || $this->t_07->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_07->AdvancedSearch->SearchValue)) {
            $this->t_07->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_07->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_07->AdvancedSearch->SearchValue2)) {
            $this->t_07->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_07->AdvancedSearch->SearchValue2);
        }

        // t_08
        if ($this->t_08->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_08->AdvancedSearch->SearchValue != "" || $this->t_08->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_08->AdvancedSearch->SearchValue)) {
            $this->t_08->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_08->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_08->AdvancedSearch->SearchValue2)) {
            $this->t_08->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_08->AdvancedSearch->SearchValue2);
        }

        // t_09
        if ($this->t_09->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_09->AdvancedSearch->SearchValue != "" || $this->t_09->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_09->AdvancedSearch->SearchValue)) {
            $this->t_09->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_09->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_09->AdvancedSearch->SearchValue2)) {
            $this->t_09->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_09->AdvancedSearch->SearchValue2);
        }

        // t_10
        if ($this->t_10->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_10->AdvancedSearch->SearchValue != "" || $this->t_10->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->t_10->AdvancedSearch->SearchValue)) {
            $this->t_10->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_10->AdvancedSearch->SearchValue);
        }
        if (is_array($this->t_10->AdvancedSearch->SearchValue2)) {
            $this->t_10->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->t_10->AdvancedSearch->SearchValue2);
        }

        // t_11
        if ($this->t_11->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_11->AdvancedSearch->SearchValue != "" || $this->t_11->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_12
        if ($this->t_12->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_12->AdvancedSearch->SearchValue != "" || $this->t_12->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_13
        if ($this->t_13->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_13->AdvancedSearch->SearchValue != "" || $this->t_13->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_14
        if ($this->t_14->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_14->AdvancedSearch->SearchValue != "" || $this->t_14->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // t_15
        if ($this->t_15->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->t_15->AdvancedSearch->SearchValue != "" || $this->t_15->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // last_price
        if ($this->last_price->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->last_price->AdvancedSearch->SearchValue != "" || $this->last_price->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // currency
        if ($this->currency->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->currency->AdvancedSearch->SearchValue != "" || $this->currency->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // hsn
        if ($this->hsn->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->hsn->AdvancedSearch->SearchValue != "" || $this->hsn->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // composition
        if ($this->composition->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->composition->AdvancedSearch->SearchValue != "" || $this->composition->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // category
        if ($this->category->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->category->AdvancedSearch->SearchValue != "" || $this->category->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // moq
        if ($this->moq->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->moq->AdvancedSearch->SearchValue != "" || $this->moq->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->status->AdvancedSearch->SearchValue != "" || $this->status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_head_01
        if ($this->d_head_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_head_01->AdvancedSearch->SearchValue != "" || $this->d_head_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_description_01
        if ($this->d_description_01->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_description_01->AdvancedSearch->SearchValue != "" || $this->d_description_01->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_head_02
        if ($this->d_head_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_head_02->AdvancedSearch->SearchValue != "" || $this->d_head_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // d_description_02
        if ($this->d_description_02->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->d_description_02->AdvancedSearch->SearchValue != "" || $this->d_description_02->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // publish
        if ($this->publish->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->publish->AdvancedSearch->SearchValue != "" || $this->publish->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // keywords
        if ($this->keywords->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->keywords->AdvancedSearch->SearchValue != "" || $this->keywords->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->operator->AdvancedSearch->SearchValue != "" || $this->operator->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->datetime->AdvancedSearch->SearchValue != "" || $this->datetime->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->oid->setDbValue($row['oid']);
        $this->company_id->setDbValue($row['company_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_type->setDbValue($row['product_type']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_n->setDbValue($row['product_n']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->product_code_type->setDbValue($row['product_code_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->print_name->setDbValue($row['print_name']);
        $this->gcode->setDbValue($row['gcode']);
        $this->code->setDbValue($row['code']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->set_ref->setDbValue($row['set_ref']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_10->setDbValue($row['v_10']);
        $this->cbm->setDbValue($row['cbm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->shape->setDbValue($row['shape']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->b_01->setDbValue($row['b_01']);
        $this->b_02->setDbValue($row['b_02']);
        $this->b_03->setDbValue($row['b_03']);
        $this->b_04->setDbValue($row['b_04']);
        $this->b_05->setDbValue($row['b_05']);
        $this->b_06->setDbValue($row['b_06']);
        $this->b_07->setDbValue($row['b_07']);
        $this->b_08->setDbValue($row['b_08']);
        $this->b_09->setDbValue($row['b_09']);
        $this->b_10->setDbValue($row['b_10']);
        $this->b_11->setDbValue($row['b_11']);
        $this->b_12->setDbValue($row['b_12']);
        $this->b_13->setDbValue($row['b_13']);
        $this->b_14->setDbValue($row['b_14']);
        $this->b_15->setDbValue($row['b_15']);
        $this->t_01->setDbValue($row['t_01']);
        $this->t_02->setDbValue($row['t_02']);
        $this->t_03->setDbValue($row['t_03']);
        $this->t_04->setDbValue($row['t_04']);
        $this->t_05->setDbValue($row['t_05']);
        $this->t_06->setDbValue($row['t_06']);
        $this->t_07->setDbValue($row['t_07']);
        $this->t_08->setDbValue($row['t_08']);
        $this->t_09->setDbValue($row['t_09']);
        $this->t_10->setDbValue($row['t_10']);
        $this->t_11->setDbValue($row['t_11']);
        $this->t_12->setDbValue($row['t_12']);
        $this->t_13->setDbValue($row['t_13']);
        $this->t_14->setDbValue($row['t_14']);
        $this->t_15->setDbValue($row['t_15']);
        $this->last_price->setDbValue($row['last_price']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->category->setDbValue($row['category']);
        $this->moq->setDbValue($row['moq']);
        $this->status->setDbValue($row['status']);
        $this->d_head_01->setDbValue($row['d_head_01']);
        $this->d_description_01->setDbValue($row['d_description_01']);
        $this->d_head_02->setDbValue($row['d_head_02']);
        $this->d_description_02->setDbValue($row['d_description_02']);
        $this->publish->setDbValue($row['publish']);
        $this->keywords->setDbValue($row['keywords']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->main_image->setDbValue($this->main_image->Upload->DbValue);
        $this->top_view->Upload->DbValue = $row['top_view'];
        $this->top_view->setDbValue($this->top_view->Upload->DbValue);
        $this->front_view->Upload->DbValue = $row['front_view'];
        $this->front_view->setDbValue($this->front_view->Upload->DbValue);
        $this->corner_view->Upload->DbValue = $row['corner_view'];
        $this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
        $this->back_view->Upload->DbValue = $row['back_view'];
        $this->back_view->setDbValue($this->back_view->Upload->DbValue);
        $this->color_options->Upload->DbValue = $row['color_options'];
        $this->color_options->setDbValue($this->color_options->Upload->DbValue);
        $this->other_options->Upload->DbValue = $row['other_options'];
        $this->other_options->setDbValue($this->other_options->Upload->DbValue);
        $this->group_image->Upload->DbValue = $row['group_image'];
        $this->group_image->setDbValue($this->group_image->Upload->DbValue);
        $this->video_url->setDbValue($row['video_url']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->in->setDbValue($row['in']);
        $this->out->setDbValue($row['out']);
        $this->required->setDbValue($row['required']);
        $this->blocked->setDbValue($row['blocked']);
        $this->ordered->setDbValue($row['ordered']);
        $this->supplier->setDbValue($row['supplier']);
        $this->country->setDbValue($row['country']);
        $this->minimum_stock->setDbValue($row['minimum_stock']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['oid'] = $this->oid->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['product_n'] = $this->product_n->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['product_code_type'] = $this->product_code_type->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['print_name'] = $this->print_name->DefaultValue;
        $row['gcode'] = $this->gcode->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['set_ref'] = $this->set_ref->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['b_01'] = $this->b_01->DefaultValue;
        $row['b_02'] = $this->b_02->DefaultValue;
        $row['b_03'] = $this->b_03->DefaultValue;
        $row['b_04'] = $this->b_04->DefaultValue;
        $row['b_05'] = $this->b_05->DefaultValue;
        $row['b_06'] = $this->b_06->DefaultValue;
        $row['b_07'] = $this->b_07->DefaultValue;
        $row['b_08'] = $this->b_08->DefaultValue;
        $row['b_09'] = $this->b_09->DefaultValue;
        $row['b_10'] = $this->b_10->DefaultValue;
        $row['b_11'] = $this->b_11->DefaultValue;
        $row['b_12'] = $this->b_12->DefaultValue;
        $row['b_13'] = $this->b_13->DefaultValue;
        $row['b_14'] = $this->b_14->DefaultValue;
        $row['b_15'] = $this->b_15->DefaultValue;
        $row['t_01'] = $this->t_01->DefaultValue;
        $row['t_02'] = $this->t_02->DefaultValue;
        $row['t_03'] = $this->t_03->DefaultValue;
        $row['t_04'] = $this->t_04->DefaultValue;
        $row['t_05'] = $this->t_05->DefaultValue;
        $row['t_06'] = $this->t_06->DefaultValue;
        $row['t_07'] = $this->t_07->DefaultValue;
        $row['t_08'] = $this->t_08->DefaultValue;
        $row['t_09'] = $this->t_09->DefaultValue;
        $row['t_10'] = $this->t_10->DefaultValue;
        $row['t_11'] = $this->t_11->DefaultValue;
        $row['t_12'] = $this->t_12->DefaultValue;
        $row['t_13'] = $this->t_13->DefaultValue;
        $row['t_14'] = $this->t_14->DefaultValue;
        $row['t_15'] = $this->t_15->DefaultValue;
        $row['last_price'] = $this->last_price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['hsn'] = $this->hsn->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['moq'] = $this->moq->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['d_head_01'] = $this->d_head_01->DefaultValue;
        $row['d_description_01'] = $this->d_description_01->DefaultValue;
        $row['d_head_02'] = $this->d_head_02->DefaultValue;
        $row['d_description_02'] = $this->d_description_02->DefaultValue;
        $row['publish'] = $this->publish->DefaultValue;
        $row['keywords'] = $this->keywords->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['main_image'] = $this->main_image->DefaultValue;
        $row['top_view'] = $this->top_view->DefaultValue;
        $row['front_view'] = $this->front_view->DefaultValue;
        $row['corner_view'] = $this->corner_view->DefaultValue;
        $row['back_view'] = $this->back_view->DefaultValue;
        $row['color_options'] = $this->color_options->DefaultValue;
        $row['other_options'] = $this->other_options->DefaultValue;
        $row['group_image'] = $this->group_image->DefaultValue;
        $row['video_url'] = $this->video_url->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['in'] = $this->in->DefaultValue;
        $row['out'] = $this->out->DefaultValue;
        $row['required'] = $this->required->DefaultValue;
        $row['blocked'] = $this->blocked->DefaultValue;
        $row['ordered'] = $this->ordered->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['minimum_stock'] = $this->minimum_stock->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // oid
        $this->oid->CellCssStyle = "white-space: nowrap;";

        // company_id

        // grp

        // s_grp

        // product

        // product_type

        // packing_type

        // product_n

        // barcode

        // product_code_type

        // product_code

        // print_name
        $this->print_name->CellCssStyle = "white-space: nowrap;";

        // gcode
        $this->gcode->CellCssStyle = "white-space: nowrap;";

        // code
        $this->code->CellCssStyle = "white-space: nowrap;";

        // product_id
        $this->product_id->CellCssStyle = "white-space: nowrap;";

        // batch_no
        $this->batch_no->CellCssStyle = "white-space: nowrap;";

        // set_ref
        $this->set_ref->CellCssStyle = "white-space: nowrap;";

        // v_00

        // v_01

        // v_02

        // v_03

        // v_04

        // v_05

        // v_06

        // v_07

        // v_08

        // v_09

        // v_10

        // cbm

        // sqm

        // shape

        // q_sku

        // b_01

        // b_02

        // b_03

        // b_04

        // b_05

        // b_06

        // b_07

        // b_08

        // b_09

        // b_10

        // b_11

        // b_12

        // b_13

        // b_14

        // b_15

        // t_01

        // t_02

        // t_03

        // t_04

        // t_05

        // t_06

        // t_07

        // t_08

        // t_09

        // t_10

        // t_11

        // t_12

        // t_13

        // t_14

        // t_15

        // last_price

        // currency

        // hsn

        // composition

        // category

        // moq
        $this->moq->CellCssStyle = "white-space: nowrap;";

        // status

        // d_head_01

        // d_description_01

        // d_head_02

        // d_description_02

        // publish

        // keywords

        // operator

        // datetime

        // main_image
        $this->main_image->CellCssStyle = "white-space: nowrap;";

        // top_view
        $this->top_view->CellCssStyle = "white-space: nowrap;";

        // front_view
        $this->front_view->CellCssStyle = "white-space: nowrap;";

        // corner_view
        $this->corner_view->CellCssStyle = "white-space: nowrap;";

        // back_view
        $this->back_view->CellCssStyle = "white-space: nowrap;";

        // color_options
        $this->color_options->CellCssStyle = "white-space: nowrap;";

        // other_options
        $this->other_options->CellCssStyle = "white-space: nowrap;";

        // group_image
        $this->group_image->CellCssStyle = "white-space: nowrap;";

        // video_url
        $this->video_url->CellCssStyle = "white-space: nowrap;";

        // image
        $this->image->CellCssStyle = "white-space: nowrap;";

        // in
        $this->in->CellCssStyle = "white-space: nowrap;";

        // out
        $this->out->CellCssStyle = "white-space: nowrap;";

        // required
        $this->required->CellCssStyle = "white-space: nowrap;";

        // blocked
        $this->blocked->CellCssStyle = "white-space: nowrap;";

        // ordered
        $this->ordered->CellCssStyle = "white-space: nowrap;";

        // supplier
        $this->supplier->CellCssStyle = "white-space: nowrap;";

        // country
        $this->country->CellCssStyle = "white-space: nowrap;";

        // minimum_stock
        $this->minimum_stock->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->company_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->company_id->Lookup->renderViewRow($row);
                            $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                        }
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_n
            $this->product_n->ViewValue = $this->product_n->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // product_code_type
            if (strval($this->product_code_type->CurrentValue) != "") {
                $this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
            } else {
                $this->product_code_type->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // set_ref
            $curVal = strval($this->set_ref->CurrentValue);
            if ($curVal != "") {
                $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
                if ($this->set_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->set_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->set_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                            $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->set_ref->ViewValue = $this->set_ref->CurrentValue;
                    }
                }
            } else {
                $this->set_ref->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $curVal = strval($this->v_01->CurrentValue);
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
                if ($this->v_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_01->Lookup->renderViewRow($rswrk[0]);
                        $this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
                    } else {
                        $this->v_01->ViewValue = $this->v_01->CurrentValue;
                    }
                }
            } else {
                $this->v_01->ViewValue = null;
            }

            // v_02
            $curVal = strval($this->v_02->CurrentValue);
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
                if ($this->v_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_02->Lookup->renderViewRow($rswrk[0]);
                        $this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
                    } else {
                        $this->v_02->ViewValue = $this->v_02->CurrentValue;
                    }
                }
            } else {
                $this->v_02->ViewValue = null;
            }

            // v_03
            $curVal = strval($this->v_03->CurrentValue);
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
                if ($this->v_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_03->Lookup->renderViewRow($rswrk[0]);
                        $this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
                    } else {
                        $this->v_03->ViewValue = $this->v_03->CurrentValue;
                    }
                }
            } else {
                $this->v_03->ViewValue = null;
            }

            // v_04
            $curVal = strval($this->v_04->CurrentValue);
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
                if ($this->v_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_04->Lookup->renderViewRow($rswrk[0]);
                        $this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
                    } else {
                        $this->v_04->ViewValue = $this->v_04->CurrentValue;
                    }
                }
            } else {
                $this->v_04->ViewValue = null;
            }

            // v_05
            $curVal = strval($this->v_05->CurrentValue);
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
                if ($this->v_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_05->Lookup->renderViewRow($rswrk[0]);
                        $this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
                    } else {
                        $this->v_05->ViewValue = $this->v_05->CurrentValue;
                    }
                }
            } else {
                $this->v_05->ViewValue = null;
            }

            // v_06
            $curVal = strval($this->v_06->CurrentValue);
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
                if ($this->v_06->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_06->Lookup->renderViewRow($rswrk[0]);
                        $this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
                    } else {
                        $this->v_06->ViewValue = $this->v_06->CurrentValue;
                    }
                }
            } else {
                $this->v_06->ViewValue = null;
            }

            // v_07
            $curVal = strval($this->v_07->CurrentValue);
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
                if ($this->v_07->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_07->Lookup->renderViewRow($rswrk[0]);
                        $this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
                    } else {
                        $this->v_07->ViewValue = $this->v_07->CurrentValue;
                    }
                }
            } else {
                $this->v_07->ViewValue = null;
            }

            // v_08
            $curVal = strval($this->v_08->CurrentValue);
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
                if ($this->v_08->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_08->Lookup->renderViewRow($rswrk[0]);
                        $this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
                    } else {
                        $this->v_08->ViewValue = $this->v_08->CurrentValue;
                    }
                }
            } else {
                $this->v_08->ViewValue = null;
            }

            // v_09
            $curVal = strval($this->v_09->CurrentValue);
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
                if ($this->v_09->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_09->Lookup->renderViewRow($rswrk[0]);
                        $this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
                    } else {
                        $this->v_09->ViewValue = $this->v_09->CurrentValue;
                    }
                }
            } else {
                $this->v_09->ViewValue = null;
            }

            // v_10
            $curVal = strval($this->v_10->CurrentValue);
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
                if ($this->v_10->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_10->Lookup->renderViewRow($rswrk[0]);
                        $this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
                    } else {
                        $this->v_10->ViewValue = $this->v_10->CurrentValue;
                    }
                }
            } else {
                $this->v_10->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // b_01
            $this->b_01->ViewValue = $this->b_01->CurrentValue;

            // b_02
            $this->b_02->ViewValue = $this->b_02->CurrentValue;

            // b_03
            $curVal = strval($this->b_03->CurrentValue);
            if ($curVal != "") {
                $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
                if ($this->b_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_03->Lookup->renderViewRow($row);
                            $this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
                        }
                    } else {
                        $this->b_03->ViewValue = $this->b_03->CurrentValue;
                    }
                }
            } else {
                $this->b_03->ViewValue = null;
            }

            // b_04
            $curVal = strval($this->b_04->CurrentValue);
            if ($curVal != "") {
                $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
                if ($this->b_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_04->Lookup->renderViewRow($row);
                            $this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
                        }
                    } else {
                        $this->b_04->ViewValue = $this->b_04->CurrentValue;
                    }
                }
            } else {
                $this->b_04->ViewValue = null;
            }

            // b_05
            $curVal = strval($this->b_05->CurrentValue);
            if ($curVal != "") {
                $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
                if ($this->b_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_05->Lookup->renderViewRow($row);
                            $this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
                        }
                    } else {
                        $this->b_05->ViewValue = $this->b_05->CurrentValue;
                    }
                }
            } else {
                $this->b_05->ViewValue = null;
            }

            // b_06
            $curVal = strval($this->b_06->CurrentValue);
            if ($curVal != "") {
                $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
                if ($this->b_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_06->Lookup->renderViewRow($row);
                            $this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
                        }
                    } else {
                        $this->b_06->ViewValue = $this->b_06->CurrentValue;
                    }
                }
            } else {
                $this->b_06->ViewValue = null;
            }

            // b_07
            $curVal = strval($this->b_07->CurrentValue);
            if ($curVal != "") {
                $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
                if ($this->b_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_07->Lookup->renderViewRow($row);
                            $this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
                        }
                    } else {
                        $this->b_07->ViewValue = $this->b_07->CurrentValue;
                    }
                }
            } else {
                $this->b_07->ViewValue = null;
            }

            // b_08
            $curVal = strval($this->b_08->CurrentValue);
            if ($curVal != "") {
                $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
                if ($this->b_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_08->Lookup->renderViewRow($row);
                            $this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
                        }
                    } else {
                        $this->b_08->ViewValue = $this->b_08->CurrentValue;
                    }
                }
            } else {
                $this->b_08->ViewValue = null;
            }

            // b_09
            $curVal = strval($this->b_09->CurrentValue);
            if ($curVal != "") {
                $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
                if ($this->b_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_09->Lookup->renderViewRow($row);
                            $this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
                        }
                    } else {
                        $this->b_09->ViewValue = $this->b_09->CurrentValue;
                    }
                }
            } else {
                $this->b_09->ViewValue = null;
            }

            // b_10
            $curVal = strval($this->b_10->CurrentValue);
            if ($curVal != "") {
                $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
                if ($this->b_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_10->Lookup->renderViewRow($row);
                            $this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
                        }
                    } else {
                        $this->b_10->ViewValue = $this->b_10->CurrentValue;
                    }
                }
            } else {
                $this->b_10->ViewValue = null;
            }

            // b_11
            $this->b_11->ViewValue = $this->b_11->CurrentValue;

            // b_12
            $this->b_12->ViewValue = $this->b_12->CurrentValue;

            // b_13
            $this->b_13->ViewValue = $this->b_13->CurrentValue;

            // b_14
            $this->b_14->ViewValue = $this->b_14->CurrentValue;

            // b_15
            $this->b_15->ViewValue = $this->b_15->CurrentValue;

            // t_01
            $this->t_01->ViewValue = $this->t_01->CurrentValue;

            // t_02
            $this->t_02->ViewValue = $this->t_02->CurrentValue;

            // t_03
            $curVal = strval($this->t_03->CurrentValue);
            if ($curVal != "") {
                $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
                if ($this->t_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_03->Lookup->renderViewRow($row);
                            $this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
                        }
                    } else {
                        $this->t_03->ViewValue = $this->t_03->CurrentValue;
                    }
                }
            } else {
                $this->t_03->ViewValue = null;
            }

            // t_04
            $curVal = strval($this->t_04->CurrentValue);
            if ($curVal != "") {
                $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
                if ($this->t_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_04->Lookup->renderViewRow($row);
                            $this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
                        }
                    } else {
                        $this->t_04->ViewValue = $this->t_04->CurrentValue;
                    }
                }
            } else {
                $this->t_04->ViewValue = null;
            }

            // t_05
            $curVal = strval($this->t_05->CurrentValue);
            if ($curVal != "") {
                $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
                if ($this->t_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_05->Lookup->renderViewRow($row);
                            $this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
                        }
                    } else {
                        $this->t_05->ViewValue = $this->t_05->CurrentValue;
                    }
                }
            } else {
                $this->t_05->ViewValue = null;
            }

            // t_06
            $curVal = strval($this->t_06->CurrentValue);
            if ($curVal != "") {
                $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
                if ($this->t_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_06->Lookup->renderViewRow($row);
                            $this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
                        }
                    } else {
                        $this->t_06->ViewValue = $this->t_06->CurrentValue;
                    }
                }
            } else {
                $this->t_06->ViewValue = null;
            }

            // t_07
            $curVal = strval($this->t_07->CurrentValue);
            if ($curVal != "") {
                $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
                if ($this->t_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_07->Lookup->renderViewRow($row);
                            $this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
                        }
                    } else {
                        $this->t_07->ViewValue = $this->t_07->CurrentValue;
                    }
                }
            } else {
                $this->t_07->ViewValue = null;
            }

            // t_08
            $curVal = strval($this->t_08->CurrentValue);
            if ($curVal != "") {
                $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
                if ($this->t_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_08->Lookup->renderViewRow($row);
                            $this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
                        }
                    } else {
                        $this->t_08->ViewValue = $this->t_08->CurrentValue;
                    }
                }
            } else {
                $this->t_08->ViewValue = null;
            }

            // t_09
            $curVal = strval($this->t_09->CurrentValue);
            if ($curVal != "") {
                $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
                if ($this->t_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_09->Lookup->renderViewRow($row);
                            $this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
                        }
                    } else {
                        $this->t_09->ViewValue = $this->t_09->CurrentValue;
                    }
                }
            } else {
                $this->t_09->ViewValue = null;
            }

            // t_10
            $curVal = strval($this->t_10->CurrentValue);
            if ($curVal != "") {
                $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
                if ($this->t_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_10->Lookup->renderViewRow($row);
                            $this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
                        }
                    } else {
                        $this->t_10->ViewValue = $this->t_10->CurrentValue;
                    }
                }
            } else {
                $this->t_10->ViewValue = null;
            }

            // t_11
            $this->t_11->ViewValue = $this->t_11->CurrentValue;
            $curVal = strval($this->t_11->CurrentValue);
            if ($curVal != "") {
                $this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->ViewValue = $this->t_11->CurrentValue;
                    }
                }
            } else {
                $this->t_11->ViewValue = null;
            }

            // t_12
            $this->t_12->ViewValue = $this->t_12->CurrentValue;
            $curVal = strval($this->t_12->CurrentValue);
            if ($curVal != "") {
                $this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->ViewValue = $this->t_12->CurrentValue;
                    }
                }
            } else {
                $this->t_12->ViewValue = null;
            }

            // t_13
            $this->t_13->ViewValue = $this->t_13->CurrentValue;

            // t_14
            $this->t_14->ViewValue = $this->t_14->CurrentValue;

            // t_15
            $this->t_15->ViewValue = $this->t_15->CurrentValue;

            // last_price
            $this->last_price->ViewValue = $this->last_price->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // hsn
            $curVal = strval($this->hsn->CurrentValue);
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
                if ($this->hsn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                        $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                    } else {
                        $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                    }
                }
            } else {
                $this->hsn->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // d_head_01
            $this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;

            // d_description_01
            $this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;

            // d_head_02
            $this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;

            // d_description_02
            $this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;

            // publish
            if (strval($this->publish->CurrentValue) != "") {
                $this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
            } else {
                $this->publish->ViewValue = null;
            }

            // keywords
            $this->keywords->ViewValue = $this->keywords->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // product_n
            $this->product_n->HrefValue = "";
            $this->product_n->TooltipValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";
            $this->product_code_type->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // v_00
            $this->v_00->HrefValue = "";
            $this->v_00->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // composition
            $this->composition->HrefValue = "";
            $this->composition->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->AdvancedSearch->SearchValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->AdvancedSearch->SearchValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // product_n
            $this->product_n->setupEditAttributes();
            if (!$this->product_n->Raw) {
                $this->product_n->AdvancedSearch->SearchValue = HtmlDecode($this->product_n->AdvancedSearch->SearchValue);
            }
            $this->product_n->EditValue = HtmlEncode($this->product_n->AdvancedSearch->SearchValue);
            $this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

            // product_code_type
            $this->product_code_type->setupEditAttributes();
            $this->product_code_type->EditValue = $this->product_code_type->options(true);
            $this->product_code_type->PlaceHolder = RemoveHtml($this->product_code_type->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            $this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->AdvancedSearch->SearchValue = HtmlDecode($this->v_00->AdvancedSearch->SearchValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->AdvancedSearch->SearchValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            $this->q_sku->EditValue = $this->q_sku->AdvancedSearch->SearchValue;
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());

            // composition
            $this->composition->setupEditAttributes();
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // category
            $this->category->setupEditAttributes();
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->company_id->AdvancedSearch->load();
        $this->grp->AdvancedSearch->load();
        $this->s_grp->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->product_type->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->product_n->AdvancedSearch->load();
        $this->product_code_type->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->v_00->AdvancedSearch->load();
        $this->v_01->AdvancedSearch->load();
        $this->v_02->AdvancedSearch->load();
        $this->v_03->AdvancedSearch->load();
        $this->v_04->AdvancedSearch->load();
        $this->v_05->AdvancedSearch->load();
        $this->v_06->AdvancedSearch->load();
        $this->v_07->AdvancedSearch->load();
        $this->v_08->AdvancedSearch->load();
        $this->v_09->AdvancedSearch->load();
        $this->v_10->AdvancedSearch->load();
        $this->q_sku->AdvancedSearch->load();
        $this->b_01->AdvancedSearch->load();
        $this->b_02->AdvancedSearch->load();
        $this->b_03->AdvancedSearch->load();
        $this->b_04->AdvancedSearch->load();
        $this->b_05->AdvancedSearch->load();
        $this->b_06->AdvancedSearch->load();
        $this->b_07->AdvancedSearch->load();
        $this->b_08->AdvancedSearch->load();
        $this->b_09->AdvancedSearch->load();
        $this->b_10->AdvancedSearch->load();
        $this->b_11->AdvancedSearch->load();
        $this->b_12->AdvancedSearch->load();
        $this->b_13->AdvancedSearch->load();
        $this->b_14->AdvancedSearch->load();
        $this->b_15->AdvancedSearch->load();
        $this->t_01->AdvancedSearch->load();
        $this->t_02->AdvancedSearch->load();
        $this->t_03->AdvancedSearch->load();
        $this->t_04->AdvancedSearch->load();
        $this->t_05->AdvancedSearch->load();
        $this->t_06->AdvancedSearch->load();
        $this->t_07->AdvancedSearch->load();
        $this->t_08->AdvancedSearch->load();
        $this->t_09->AdvancedSearch->load();
        $this->t_10->AdvancedSearch->load();
        $this->t_11->AdvancedSearch->load();
        $this->t_12->AdvancedSearch->load();
        $this->t_13->AdvancedSearch->load();
        $this->t_14->AdvancedSearch->load();
        $this->t_15->AdvancedSearch->load();
        $this->last_price->AdvancedSearch->load();
        $this->currency->AdvancedSearch->load();
        $this->hsn->AdvancedSearch->load();
        $this->composition->AdvancedSearch->load();
        $this->category->AdvancedSearch->load();
        $this->moq->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->d_head_01->AdvancedSearch->load();
        $this->d_description_01->AdvancedSearch->load();
        $this->d_head_02->AdvancedSearch->load();
        $this->d_description_02->AdvancedSearch->load();
        $this->publish->AdvancedSearch->load();
        $this->keywords->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"freflist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"freflist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"freflist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="freflist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : "";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"frefsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"ref\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"refsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"refsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code_type":
                    break;
                case "x_set_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_11":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_12":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hsn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_publish":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && isset($rule["value"]) && !EmptyValue($rule["value"]) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $fld->AdvancedSearch->SearchValue = ConvertSearchValue($fldVal, $fldOpr, $fld);
                                    $fld->AdvancedSearch->SearchValue2 = ConvertSearchValue($fldVal2, $fldOpr, $fld);
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        $fld->AdvancedSearch->SearchValue, // SearchValue
                                        $fldOpr,
                                        "", // $fldCond not used
                                        $fld->AdvancedSearch->SearchValue2, // SearchValue2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'ref');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered() {
    	// Example:
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    	//$this->ListOptions->Items["new"]->Body = "xxx";
    	$this->ListOptions->Add("Print"); 
    	$this->ListOptions->Items["Print"]->Body =
    		'<a href="printpd?rid=' . $this->id->CurrentValue . '" data-bs-original-title ="Print"><i data-phrase="Print"  class="fa fa-print fa-2x ew-icon" ></i></a>';
    	$this->ListOptions->Add("Label"); 
    	$this->ListOptions->Items["Label"]->Body =
    		'<a href="printsplabel?rid=' . $this->id->CurrentValue . '" data-bs-original-title ="Label"><i data-phrase="Label"  class="fa fa-tag fa-2x ew-icon" ></i></a>';
    	if (($this->product_type->CurrentValue == 9 ))
    	{
    		$this->ListOptions->Items['edit']->Visible=False;
    		$this->ListOptions->Items['copy']->Visible=True;
    		$this->ListOptions->Items['delete']->Visible=False;
    	} else {
    		$this->ListOptions->Items['edit']->Visible=True;
    		$this->ListOptions->Items['copy']->Visible=True;
    		$this->ListOptions->Items['delete']->Visible=True;
    	}
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
