<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RefImageEdit extends RefImage
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RefImageEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "refimageedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_code->setVisibility();
        $this->main_image->setVisibility();
        $this->top_view->setVisibility();
        $this->front_view->setVisibility();
        $this->corner_view->setVisibility();
        $this->back_view->setVisibility();
        $this->color_options->setVisibility();
        $this->other_options->setVisibility();
        $this->video_url->setVisibility();
        $this->group_image->setVisibility();
        $this->status->setVisibility();
        $this->company_id->setVisibility();
        $this->product_type->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ref_image';
        $this->TableName = 'ref_image';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ref_image)
        if (!isset($GLOBALS["ref_image"]) || $GLOBALS["ref_image"]::class == PROJECT_NAMESPACE . "ref_image") {
            $GLOBALS["ref_image"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_image');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "refimageview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
                $this->main_image->UploadPath = $this->main_image->OldUploadPath;
                $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
                $this->top_view->UploadPath = $this->top_view->OldUploadPath;
                $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
                $this->front_view->UploadPath = $this->front_view->OldUploadPath;
                $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
                $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
                $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
                $this->back_view->UploadPath = $this->back_view->OldUploadPath;
                $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
                $this->color_options->UploadPath = $this->color_options->OldUploadPath;
                $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
                $this->other_options->UploadPath = $this->other_options->OldUploadPath;
                $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
                $this->group_image->UploadPath = $this->group_image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->grp->Required = false;
        $this->s_grp->Required = false;
        $this->status->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("refimagelist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "refimagelist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "refimagelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "refimagelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->main_image->Upload->Index = $CurrentForm->Index;
        $this->main_image->Upload->uploadFile();
        $this->main_image->CurrentValue = $this->main_image->Upload->FileName;
        $this->top_view->Upload->Index = $CurrentForm->Index;
        $this->top_view->Upload->uploadFile();
        $this->top_view->CurrentValue = $this->top_view->Upload->FileName;
        $this->front_view->Upload->Index = $CurrentForm->Index;
        $this->front_view->Upload->uploadFile();
        $this->front_view->CurrentValue = $this->front_view->Upload->FileName;
        $this->corner_view->Upload->Index = $CurrentForm->Index;
        $this->corner_view->Upload->uploadFile();
        $this->corner_view->CurrentValue = $this->corner_view->Upload->FileName;
        $this->back_view->Upload->Index = $CurrentForm->Index;
        $this->back_view->Upload->uploadFile();
        $this->back_view->CurrentValue = $this->back_view->Upload->FileName;
        $this->color_options->Upload->Index = $CurrentForm->Index;
        $this->color_options->Upload->uploadFile();
        $this->color_options->CurrentValue = $this->color_options->Upload->FileName;
        $this->other_options->Upload->Index = $CurrentForm->Index;
        $this->other_options->Upload->uploadFile();
        $this->other_options->CurrentValue = $this->other_options->Upload->FileName;
        $this->group_image->Upload->Index = $CurrentForm->Index;
        $this->group_image->Upload->uploadFile();
        $this->group_image->CurrentValue = $this->group_image->Upload->FileName;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'product_code' first before field var 'x_product_code'
        $val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
        if (!$this->product_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code->Visible = false; // Disable update for API request
            } else {
                $this->product_code->setFormValue($val);
            }
        }

        // Check field name 'video_url' first before field var 'x_video_url'
        $val = $CurrentForm->hasValue("video_url") ? $CurrentForm->getValue("video_url") : $CurrentForm->getValue("x_video_url");
        if (!$this->video_url->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->video_url->Visible = false; // Disable update for API request
            } else {
                $this->video_url->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
		$this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
		$this->main_image->UploadPath = $this->main_image->OldUploadPath;
		$this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
		$this->top_view->UploadPath = $this->top_view->OldUploadPath;
		$this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
		$this->front_view->UploadPath = $this->front_view->OldUploadPath;
		$this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
		$this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
		$this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
		$this->back_view->UploadPath = $this->back_view->OldUploadPath;
		$this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
		$this->color_options->UploadPath = $this->color_options->OldUploadPath;
		$this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
		$this->other_options->UploadPath = $this->other_options->OldUploadPath;
		$this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
		$this->group_image->UploadPath = $this->group_image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->product_code->CurrentValue = $this->product_code->FormValue;
        $this->video_url->CurrentValue = $this->video_url->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_code->setDbValue($row['product_code']);
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->main_image->setDbValue($this->main_image->Upload->DbValue);
        $this->top_view->Upload->DbValue = $row['top_view'];
        $this->top_view->setDbValue($this->top_view->Upload->DbValue);
        $this->front_view->Upload->DbValue = $row['front_view'];
        $this->front_view->setDbValue($this->front_view->Upload->DbValue);
        $this->corner_view->Upload->DbValue = $row['corner_view'];
        $this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
        $this->back_view->Upload->DbValue = $row['back_view'];
        $this->back_view->setDbValue($this->back_view->Upload->DbValue);
        $this->color_options->Upload->DbValue = $row['color_options'];
        $this->color_options->setDbValue($this->color_options->Upload->DbValue);
        $this->other_options->Upload->DbValue = $row['other_options'];
        $this->other_options->setDbValue($this->other_options->Upload->DbValue);
        $this->video_url->setDbValue($row['video_url']);
        $this->group_image->Upload->DbValue = $row['group_image'];
        $this->group_image->setDbValue($this->group_image->Upload->DbValue);
        $this->status->setDbValue($row['status']);
        $this->company_id->setDbValue($row['company_id']);
        $this->product_type->setDbValue($row['product_type']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['main_image'] = $this->main_image->DefaultValue;
        $row['top_view'] = $this->top_view->DefaultValue;
        $row['front_view'] = $this->front_view->DefaultValue;
        $row['corner_view'] = $this->corner_view->DefaultValue;
        $row['back_view'] = $this->back_view->DefaultValue;
        $row['color_options'] = $this->color_options->DefaultValue;
        $row['other_options'] = $this->other_options->DefaultValue;
        $row['video_url'] = $this->video_url->DefaultValue;
        $row['group_image'] = $this->group_image->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // main_image
        $this->main_image->RowCssClass = "row";

        // top_view
        $this->top_view->RowCssClass = "row";

        // front_view
        $this->front_view->RowCssClass = "row";

        // corner_view
        $this->corner_view->RowCssClass = "row";

        // back_view
        $this->back_view->RowCssClass = "row";

        // color_options
        $this->color_options->RowCssClass = "row";

        // other_options
        $this->other_options->RowCssClass = "row";

        // video_url
        $this->video_url->RowCssClass = "row";

        // group_image
        $this->group_image->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->ImageWidth = 0;
                $this->main_image->ImageHeight = 40;
                $this->main_image->ImageAlt = $this->main_image->alt();
                $this->main_image->ImageCssClass = "ew-image";
                $this->main_image->ViewValue = $this->main_image->Upload->DbValue;
            } else {
                $this->main_image->ViewValue = "";
            }

            // top_view
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->ImageWidth = 0;
                $this->top_view->ImageHeight = 40;
                $this->top_view->ImageAlt = $this->top_view->alt();
                $this->top_view->ImageCssClass = "ew-image";
                $this->top_view->ViewValue = $this->top_view->Upload->DbValue;
            } else {
                $this->top_view->ViewValue = "";
            }

            // front_view
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->ImageWidth = 0;
                $this->front_view->ImageHeight = 40;
                $this->front_view->ImageAlt = $this->front_view->alt();
                $this->front_view->ImageCssClass = "ew-image";
                $this->front_view->ViewValue = $this->front_view->Upload->DbValue;
            } else {
                $this->front_view->ViewValue = "";
            }

            // corner_view
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->ImageWidth = 0;
                $this->corner_view->ImageHeight = 40;
                $this->corner_view->ImageAlt = $this->corner_view->alt();
                $this->corner_view->ImageCssClass = "ew-image";
                $this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
            } else {
                $this->corner_view->ViewValue = "";
            }

            // back_view
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->ImageWidth = 0;
                $this->back_view->ImageHeight = 40;
                $this->back_view->ImageAlt = $this->back_view->alt();
                $this->back_view->ImageCssClass = "ew-image";
                $this->back_view->ViewValue = $this->back_view->Upload->DbValue;
            } else {
                $this->back_view->ViewValue = "";
            }

            // color_options
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->ImageWidth = 0;
                $this->color_options->ImageHeight = 40;
                $this->color_options->ImageAlt = $this->color_options->alt();
                $this->color_options->ImageCssClass = "ew-image";
                $this->color_options->ViewValue = $this->color_options->Upload->DbValue;
            } else {
                $this->color_options->ViewValue = "";
            }

            // other_options
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->ImageWidth = 0;
                $this->other_options->ImageHeight = 40;
                $this->other_options->ImageAlt = $this->other_options->alt();
                $this->other_options->ImageCssClass = "ew-image";
                $this->other_options->ViewValue = $this->other_options->Upload->DbValue;
            } else {
                $this->other_options->ViewValue = "";
            }

            // video_url
            $this->video_url->ViewValue = $this->video_url->CurrentValue;

            // group_image
            $this->group_image->UploadPath = $this->group_image->getUploadPath(); // PHP
            if (!EmptyValue($this->group_image->Upload->DbValue)) {
                $this->group_image->ViewValue = $this->group_image->Upload->DbValue;
            } else {
                $this->group_image->ViewValue = "";
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // product_code
            if (!EmptyValue($this->product_code->CurrentValue)) {
                $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue; // Add prefix/suffix
                $this->product_code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
                }
            } else {
                $this->product_code->HrefValue = "";
            }
            $this->product_code->TooltipValue = "";

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->htmlDecode($this->main_image->Upload->DbValue)); // Add prefix/suffix
                $this->main_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
                }
            } else {
                $this->main_image->HrefValue = "";
            }
            $this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;

            // top_view
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->HrefValue = "%u"; // Add prefix/suffix
                $this->top_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
                }
            } else {
                $this->top_view->HrefValue = "";
            }
            $this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;

            // front_view
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->HrefValue = "%u"; // Add prefix/suffix
                $this->front_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
                }
            } else {
                $this->front_view->HrefValue = "";
            }
            $this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;

            // corner_view
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->HrefValue = "%u"; // Add prefix/suffix
                $this->corner_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
                }
            } else {
                $this->corner_view->HrefValue = "";
            }
            $this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;

            // back_view
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->HrefValue = "%u"; // Add prefix/suffix
                $this->back_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
                }
            } else {
                $this->back_view->HrefValue = "";
            }
            $this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;

            // color_options
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->HrefValue = "%u"; // Add prefix/suffix
                $this->color_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
                }
            } else {
                $this->color_options->HrefValue = "";
            }
            $this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;

            // other_options
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->HrefValue = "%u"; // Add prefix/suffix
                $this->other_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
                }
            } else {
                $this->other_options->HrefValue = "";
            }
            $this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;

            // video_url
            $this->video_url->HrefValue = "";

            // group_image
            $this->group_image->HrefValue = "";
            $this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // company_id
            if (!EmptyValue($this->company_id->CurrentValue)) {
                $this->company_id->HrefValue = $this->company_id->getLinkPrefix() . $this->company_id->CurrentValue; // Add prefix/suffix
                $this->company_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->company_id->HrefValue = FullUrl($this->company_id->HrefValue, "href");
                }
            } else {
                $this->company_id->HrefValue = "";
            }
            $this->company_id->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->getLinkPrefix() . $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // grp
            $this->grp->setupEditAttributes();
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->EditValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->EditValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->EditValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->EditValue = null;
            }

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->EditValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->EditValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->EditValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->EditValue = null;
            }

            // product
            $this->product->setupEditAttributes();
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->EditValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->EditValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->EditValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->EditValue = null;
            }

            // product_code
            $this->product_code->setupEditAttributes();
            $this->product_code->EditValue = $this->product_code->CurrentValue;

            // main_image
            $this->main_image->setupEditAttributes();
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->ImageWidth = 0;
                $this->main_image->ImageHeight = 40;
                $this->main_image->ImageAlt = $this->main_image->alt();
                $this->main_image->ImageCssClass = "ew-image";
                $this->main_image->EditValue = $this->main_image->Upload->DbValue;
            } else {
                $this->main_image->EditValue = "";
            }
            if (!EmptyValue($this->main_image->CurrentValue)) {
                $this->main_image->Upload->FileName = $this->main_image->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->main_image);
            }

            // top_view
            $this->top_view->setupEditAttributes();
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->ImageWidth = 0;
                $this->top_view->ImageHeight = 40;
                $this->top_view->ImageAlt = $this->top_view->alt();
                $this->top_view->ImageCssClass = "ew-image";
                $this->top_view->EditValue = $this->top_view->Upload->DbValue;
            } else {
                $this->top_view->EditValue = "";
            }
            if (!EmptyValue($this->top_view->CurrentValue)) {
                $this->top_view->Upload->FileName = $this->top_view->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->top_view);
            }

            // front_view
            $this->front_view->setupEditAttributes();
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->ImageWidth = 0;
                $this->front_view->ImageHeight = 40;
                $this->front_view->ImageAlt = $this->front_view->alt();
                $this->front_view->ImageCssClass = "ew-image";
                $this->front_view->EditValue = $this->front_view->Upload->DbValue;
            } else {
                $this->front_view->EditValue = "";
            }
            if (!EmptyValue($this->front_view->CurrentValue)) {
                $this->front_view->Upload->FileName = $this->front_view->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->front_view);
            }

            // corner_view
            $this->corner_view->setupEditAttributes();
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->ImageWidth = 0;
                $this->corner_view->ImageHeight = 40;
                $this->corner_view->ImageAlt = $this->corner_view->alt();
                $this->corner_view->ImageCssClass = "ew-image";
                $this->corner_view->EditValue = $this->corner_view->Upload->DbValue;
            } else {
                $this->corner_view->EditValue = "";
            }
            if (!EmptyValue($this->corner_view->CurrentValue)) {
                $this->corner_view->Upload->FileName = $this->corner_view->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->corner_view);
            }

            // back_view
            $this->back_view->setupEditAttributes();
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->ImageWidth = 0;
                $this->back_view->ImageHeight = 40;
                $this->back_view->ImageAlt = $this->back_view->alt();
                $this->back_view->ImageCssClass = "ew-image";
                $this->back_view->EditValue = $this->back_view->Upload->DbValue;
            } else {
                $this->back_view->EditValue = "";
            }
            if (!EmptyValue($this->back_view->CurrentValue)) {
                $this->back_view->Upload->FileName = $this->back_view->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->back_view);
            }

            // color_options
            $this->color_options->setupEditAttributes();
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->ImageWidth = 0;
                $this->color_options->ImageHeight = 40;
                $this->color_options->ImageAlt = $this->color_options->alt();
                $this->color_options->ImageCssClass = "ew-image";
                $this->color_options->EditValue = $this->color_options->Upload->DbValue;
            } else {
                $this->color_options->EditValue = "";
            }
            if (!EmptyValue($this->color_options->CurrentValue)) {
                $this->color_options->Upload->FileName = $this->color_options->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->color_options);
            }

            // other_options
            $this->other_options->setupEditAttributes();
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->ImageWidth = 0;
                $this->other_options->ImageHeight = 40;
                $this->other_options->ImageAlt = $this->other_options->alt();
                $this->other_options->ImageCssClass = "ew-image";
                $this->other_options->EditValue = $this->other_options->Upload->DbValue;
            } else {
                $this->other_options->EditValue = "";
            }
            if (!EmptyValue($this->other_options->CurrentValue)) {
                $this->other_options->Upload->FileName = $this->other_options->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->other_options);
            }

            // video_url
            $this->video_url->setupEditAttributes();
            if (!$this->video_url->Raw) {
                $this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
            }
            $this->video_url->EditValue = HtmlEncode($this->video_url->CurrentValue);
            $this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

            // group_image
            $this->group_image->setupEditAttributes();
            $this->group_image->UploadPath = $this->group_image->getUploadPath(); // PHP
            if (!EmptyValue($this->group_image->Upload->DbValue)) {
                $this->group_image->EditValue = $this->group_image->Upload->DbValue;
            } else {
                $this->group_image->EditValue = "";
            }
            if (!EmptyValue($this->group_image->CurrentValue)) {
                $this->group_image->Upload->FileName = $this->group_image->CurrentValue;
            }
            if ($this->isShow()) {
                RenderUploadField($this->group_image);
            }

            // status
            $this->status->setupEditAttributes();
            if (strval($this->status->CurrentValue) != "") {
                $this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->EditValue = null;
            }

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->EditValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->EditValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->EditValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->EditValue = null;
            }

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // grp
            if (!EmptyValue($this->grp->CurrentValue)) {
                $this->grp->HrefValue = $this->grp->getLinkPrefix() . $this->grp->CurrentValue; // Add prefix/suffix
                $this->grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
                }
            } else {
                $this->grp->HrefValue = "";
            }
            $this->grp->TooltipValue = "";

            // s_grp
            if (!EmptyValue($this->s_grp->CurrentValue)) {
                $this->s_grp->HrefValue = $this->s_grp->getLinkPrefix() . $this->s_grp->CurrentValue; // Add prefix/suffix
                $this->s_grp->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->s_grp->HrefValue = FullUrl($this->s_grp->HrefValue, "href");
                }
            } else {
                $this->s_grp->HrefValue = "";
            }
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // product_code
            if (!EmptyValue($this->product_code->CurrentValue)) {
                $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue; // Add prefix/suffix
                $this->product_code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
                }
            } else {
                $this->product_code->HrefValue = "";
            }
            $this->product_code->TooltipValue = "";

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->htmlDecode($this->main_image->Upload->DbValue)); // Add prefix/suffix
                $this->main_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
                }
            } else {
                $this->main_image->HrefValue = "";
            }
            $this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;

            // top_view
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->HrefValue = "%u"; // Add prefix/suffix
                $this->top_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
                }
            } else {
                $this->top_view->HrefValue = "";
            }
            $this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;

            // front_view
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->HrefValue = "%u"; // Add prefix/suffix
                $this->front_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
                }
            } else {
                $this->front_view->HrefValue = "";
            }
            $this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;

            // corner_view
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->HrefValue = "%u"; // Add prefix/suffix
                $this->corner_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
                }
            } else {
                $this->corner_view->HrefValue = "";
            }
            $this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;

            // back_view
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->HrefValue = "%u"; // Add prefix/suffix
                $this->back_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
                }
            } else {
                $this->back_view->HrefValue = "";
            }
            $this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;

            // color_options
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->HrefValue = "%u"; // Add prefix/suffix
                $this->color_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
                }
            } else {
                $this->color_options->HrefValue = "";
            }
            $this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;

            // other_options
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->HrefValue = "%u"; // Add prefix/suffix
                $this->other_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
                }
            } else {
                $this->other_options->HrefValue = "";
            }
            $this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;

            // video_url
            $this->video_url->HrefValue = "";

            // group_image
            $this->group_image->HrefValue = "";
            $this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // company_id
            if (!EmptyValue($this->company_id->CurrentValue)) {
                $this->company_id->HrefValue = $this->company_id->getLinkPrefix() . $this->company_id->CurrentValue; // Add prefix/suffix
                $this->company_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->company_id->HrefValue = FullUrl($this->company_id->HrefValue, "href");
                }
            } else {
                $this->company_id->HrefValue = "";
            }
            $this->company_id->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // operator
            if (!EmptyValue($this->operator->CurrentValue)) {
                $this->operator->HrefValue = $this->operator->getLinkPrefix() . $this->operator->CurrentValue; // Add prefix/suffix
                $this->operator->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->operator->HrefValue = FullUrl($this->operator->HrefValue, "href");
                }
            } else {
                $this->operator->HrefValue = "";
            }

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->product_code->Visible && $this->product_code->Required) {
                if (!$this->product_code->IsDetailKey && EmptyValue($this->product_code->FormValue)) {
                    $this->product_code->addErrorMessage(str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
                }
            }
            if ($this->main_image->Visible && $this->main_image->Required) {
                if ($this->main_image->Upload->FileName == "" && !$this->main_image->Upload->KeepFile) {
                    $this->main_image->addErrorMessage(str_replace("%s", $this->main_image->caption(), $this->main_image->RequiredErrorMessage));
                }
            }
            if ($this->top_view->Visible && $this->top_view->Required) {
                if ($this->top_view->Upload->FileName == "" && !$this->top_view->Upload->KeepFile) {
                    $this->top_view->addErrorMessage(str_replace("%s", $this->top_view->caption(), $this->top_view->RequiredErrorMessage));
                }
            }
            if ($this->front_view->Visible && $this->front_view->Required) {
                if ($this->front_view->Upload->FileName == "" && !$this->front_view->Upload->KeepFile) {
                    $this->front_view->addErrorMessage(str_replace("%s", $this->front_view->caption(), $this->front_view->RequiredErrorMessage));
                }
            }
            if ($this->corner_view->Visible && $this->corner_view->Required) {
                if ($this->corner_view->Upload->FileName == "" && !$this->corner_view->Upload->KeepFile) {
                    $this->corner_view->addErrorMessage(str_replace("%s", $this->corner_view->caption(), $this->corner_view->RequiredErrorMessage));
                }
            }
            if ($this->back_view->Visible && $this->back_view->Required) {
                if ($this->back_view->Upload->FileName == "" && !$this->back_view->Upload->KeepFile) {
                    $this->back_view->addErrorMessage(str_replace("%s", $this->back_view->caption(), $this->back_view->RequiredErrorMessage));
                }
            }
            if ($this->color_options->Visible && $this->color_options->Required) {
                if ($this->color_options->Upload->FileName == "" && !$this->color_options->Upload->KeepFile) {
                    $this->color_options->addErrorMessage(str_replace("%s", $this->color_options->caption(), $this->color_options->RequiredErrorMessage));
                }
            }
            if ($this->other_options->Visible && $this->other_options->Required) {
                if ($this->other_options->Upload->FileName == "" && !$this->other_options->Upload->KeepFile) {
                    $this->other_options->addErrorMessage(str_replace("%s", $this->other_options->caption(), $this->other_options->RequiredErrorMessage));
                }
            }
            if ($this->video_url->Visible && $this->video_url->Required) {
                if (!$this->video_url->IsDetailKey && EmptyValue($this->video_url->FormValue)) {
                    $this->video_url->addErrorMessage(str_replace("%s", $this->video_url->caption(), $this->video_url->RequiredErrorMessage));
                }
            }
            if ($this->group_image->Visible && $this->group_image->Required) {
                if ($this->group_image->Upload->FileName == "" && !$this->group_image->Upload->KeepFile) {
                    $this->group_image->addErrorMessage(str_replace("%s", $this->group_image->caption(), $this->group_image->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);
        if ($this->main_image->Visible && !$this->main_image->Upload->KeepFile) {
            $this->main_image->UploadPath = $this->main_image->getUploadPath();
            if (!EmptyValue($this->main_image->Upload->FileName)) {
                FixUploadFileNames($this->main_image);
                $this->main_image->setDbValueDef($rsnew, $this->main_image->Upload->FileName, $this->main_image->ReadOnly);
            }
        }
        if ($this->top_view->Visible && !$this->top_view->Upload->KeepFile) {
            $this->top_view->UploadPath = $this->top_view->getUploadPath();
            if (!EmptyValue($this->top_view->Upload->FileName)) {
                FixUploadFileNames($this->top_view);
                $this->top_view->setDbValueDef($rsnew, $this->top_view->Upload->FileName, $this->top_view->ReadOnly);
            }
        }
        if ($this->front_view->Visible && !$this->front_view->Upload->KeepFile) {
            $this->front_view->UploadPath = $this->front_view->getUploadPath();
            if (!EmptyValue($this->front_view->Upload->FileName)) {
                FixUploadFileNames($this->front_view);
                $this->front_view->setDbValueDef($rsnew, $this->front_view->Upload->FileName, $this->front_view->ReadOnly);
            }
        }
        if ($this->corner_view->Visible && !$this->corner_view->Upload->KeepFile) {
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath();
            if (!EmptyValue($this->corner_view->Upload->FileName)) {
                FixUploadFileNames($this->corner_view);
                $this->corner_view->setDbValueDef($rsnew, $this->corner_view->Upload->FileName, $this->corner_view->ReadOnly);
            }
        }
        if ($this->back_view->Visible && !$this->back_view->Upload->KeepFile) {
            $this->back_view->UploadPath = $this->back_view->getUploadPath();
            if (!EmptyValue($this->back_view->Upload->FileName)) {
                FixUploadFileNames($this->back_view);
                $this->back_view->setDbValueDef($rsnew, $this->back_view->Upload->FileName, $this->back_view->ReadOnly);
            }
        }
        if ($this->color_options->Visible && !$this->color_options->Upload->KeepFile) {
            $this->color_options->UploadPath = $this->color_options->getUploadPath();
            if (!EmptyValue($this->color_options->Upload->FileName)) {
                FixUploadFileNames($this->color_options);
                $this->color_options->setDbValueDef($rsnew, $this->color_options->Upload->FileName, $this->color_options->ReadOnly);
            }
        }
        if ($this->other_options->Visible && !$this->other_options->Upload->KeepFile) {
            $this->other_options->UploadPath = $this->other_options->getUploadPath();
            if (!EmptyValue($this->other_options->Upload->FileName)) {
                FixUploadFileNames($this->other_options);
                $this->other_options->setDbValueDef($rsnew, $this->other_options->Upload->FileName, $this->other_options->ReadOnly);
            }
        }
        if ($this->group_image->Visible && !$this->group_image->Upload->KeepFile) {
            $this->group_image->UploadPath = $this->group_image->getUploadPath();
            if (!EmptyValue($this->group_image->Upload->FileName)) {
                FixUploadFileNames($this->group_image);
                $this->group_image->setDbValueDef($rsnew, $this->group_image->Upload->FileName, $this->group_image->ReadOnly);
            }
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
                if ($this->main_image->Visible && !$this->main_image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->main_image, $rsnew['main_image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->top_view->Visible && !$this->top_view->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->top_view, $rsnew['top_view'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->front_view->Visible && !$this->front_view->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->front_view, $rsnew['front_view'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->corner_view->Visible && !$this->corner_view->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->corner_view, $rsnew['corner_view'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->back_view->Visible && !$this->back_view->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->back_view, $rsnew['back_view'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->color_options->Visible && !$this->color_options->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->color_options, $rsnew['color_options'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->other_options->Visible && !$this->other_options->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->other_options, $rsnew['other_options'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
                if ($this->group_image->Visible && !$this->group_image->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->group_image, $rsnew['group_image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
        $this->main_image->UploadPath = $this->main_image->OldUploadPath;
        $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
        $this->top_view->UploadPath = $this->top_view->OldUploadPath;
        $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
        $this->front_view->UploadPath = $this->front_view->OldUploadPath;
        $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
        $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
        $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
        $this->back_view->UploadPath = $this->back_view->OldUploadPath;
        $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
        $this->color_options->UploadPath = $this->color_options->OldUploadPath;
        $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
        $this->other_options->UploadPath = $this->other_options->OldUploadPath;
        $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
        $this->group_image->UploadPath = $this->group_image->OldUploadPath;
        $rsnew = [];

        // main_image
        if ($this->main_image->Visible && !$this->main_image->ReadOnly && !$this->main_image->Upload->KeepFile) {
            if ($this->main_image->Upload->FileName == "") {
                $rsnew['main_image'] = null;
            } else {
                FixUploadTempFileNames($this->main_image);
                $rsnew['main_image'] = $this->main_image->Upload->FileName;
            }
            $this->main_image->ImageWidth = 640; // Resize width
            $this->main_image->ImageHeight = 640; // Resize height
        }

        // top_view
        if ($this->top_view->Visible && !$this->top_view->ReadOnly && !$this->top_view->Upload->KeepFile) {
            if ($this->top_view->Upload->FileName == "") {
                $rsnew['top_view'] = null;
            } else {
                FixUploadTempFileNames($this->top_view);
                $rsnew['top_view'] = $this->top_view->Upload->FileName;
            }
            $this->top_view->ImageWidth = 640; // Resize width
            $this->top_view->ImageHeight = 640; // Resize height
        }

        // front_view
        if ($this->front_view->Visible && !$this->front_view->ReadOnly && !$this->front_view->Upload->KeepFile) {
            if ($this->front_view->Upload->FileName == "") {
                $rsnew['front_view'] = null;
            } else {
                FixUploadTempFileNames($this->front_view);
                $rsnew['front_view'] = $this->front_view->Upload->FileName;
            }
            $this->front_view->ImageWidth = 640; // Resize width
            $this->front_view->ImageHeight = 640; // Resize height
        }

        // corner_view
        if ($this->corner_view->Visible && !$this->corner_view->ReadOnly && !$this->corner_view->Upload->KeepFile) {
            if ($this->corner_view->Upload->FileName == "") {
                $rsnew['corner_view'] = null;
            } else {
                FixUploadTempFileNames($this->corner_view);
                $rsnew['corner_view'] = $this->corner_view->Upload->FileName;
            }
            $this->corner_view->ImageWidth = 640; // Resize width
            $this->corner_view->ImageHeight = 640; // Resize height
        }

        // back_view
        if ($this->back_view->Visible && !$this->back_view->ReadOnly && !$this->back_view->Upload->KeepFile) {
            if ($this->back_view->Upload->FileName == "") {
                $rsnew['back_view'] = null;
            } else {
                FixUploadTempFileNames($this->back_view);
                $rsnew['back_view'] = $this->back_view->Upload->FileName;
            }
            $this->back_view->ImageWidth = 640; // Resize width
            $this->back_view->ImageHeight = 640; // Resize height
        }

        // color_options
        if ($this->color_options->Visible && !$this->color_options->ReadOnly && !$this->color_options->Upload->KeepFile) {
            if ($this->color_options->Upload->FileName == "") {
                $rsnew['color_options'] = null;
            } else {
                FixUploadTempFileNames($this->color_options);
                $rsnew['color_options'] = $this->color_options->Upload->FileName;
            }
            $this->color_options->ImageWidth = 640; // Resize width
            $this->color_options->ImageHeight = 640; // Resize height
        }

        // other_options
        if ($this->other_options->Visible && !$this->other_options->ReadOnly && !$this->other_options->Upload->KeepFile) {
            if ($this->other_options->Upload->FileName == "") {
                $rsnew['other_options'] = null;
            } else {
                FixUploadTempFileNames($this->other_options);
                $rsnew['other_options'] = $this->other_options->Upload->FileName;
            }
            $this->other_options->ImageWidth = 640; // Resize width
            $this->other_options->ImageHeight = 640; // Resize height
        }

        // video_url
        $this->video_url->setDbValueDef($rsnew, $this->video_url->CurrentValue, $this->video_url->ReadOnly);

        // group_image
        if ($this->group_image->Visible && !$this->group_image->ReadOnly && !$this->group_image->Upload->KeepFile) {
            if ($this->group_image->Upload->FileName == "") {
                $rsnew['group_image'] = null;
            } else {
                FixUploadTempFileNames($this->group_image);
                $rsnew['group_image'] = $this->group_image->Upload->FileName;
            }
            $this->group_image->ImageWidth = 700; // Resize width
            $this->group_image->ImageHeight = 700; // Resize height
        }

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['main_image'])) { // main_image
            $this->main_image->CurrentValue = $row['main_image'];
        }
        if (isset($row['top_view'])) { // top_view
            $this->top_view->CurrentValue = $row['top_view'];
        }
        if (isset($row['front_view'])) { // front_view
            $this->front_view->CurrentValue = $row['front_view'];
        }
        if (isset($row['corner_view'])) { // corner_view
            $this->corner_view->CurrentValue = $row['corner_view'];
        }
        if (isset($row['back_view'])) { // back_view
            $this->back_view->CurrentValue = $row['back_view'];
        }
        if (isset($row['color_options'])) { // color_options
            $this->color_options->CurrentValue = $row['color_options'];
        }
        if (isset($row['other_options'])) { // other_options
            $this->other_options->CurrentValue = $row['other_options'];
        }
        if (isset($row['video_url'])) { // video_url
            $this->video_url->CurrentValue = $row['video_url'];
        }
        if (isset($row['group_image'])) { // group_image
            $this->group_image->CurrentValue = $row['group_image'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("refimagelist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_status":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	$this->company_id->ReadOnly = True;
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
