<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RefEdit extends Ref
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RefEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "refedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->oid->Visible = false;
        $this->company_id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_type->setVisibility();
        $this->packing_type->setVisibility();
        $this->product_n->setVisibility();
        $this->_barcode->setVisibility();
        $this->product_code_type->setVisibility();
        $this->product_code->setVisibility();
        $this->print_name->Visible = false;
        $this->gcode->Visible = false;
        $this->code->Visible = false;
        $this->product_id->Visible = false;
        $this->batch_no->Visible = false;
        $this->set_ref->setVisibility();
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_02->setVisibility();
        $this->v_03->setVisibility();
        $this->v_04->setVisibility();
        $this->v_05->setVisibility();
        $this->v_06->setVisibility();
        $this->v_07->setVisibility();
        $this->v_08->setVisibility();
        $this->v_09->setVisibility();
        $this->v_10->setVisibility();
        $this->cbm->setVisibility();
        $this->sqm->setVisibility();
        $this->shape->setVisibility();
        $this->q_sku->setVisibility();
        $this->b_01->setVisibility();
        $this->b_02->setVisibility();
        $this->b_03->setVisibility();
        $this->b_04->setVisibility();
        $this->b_05->setVisibility();
        $this->b_06->setVisibility();
        $this->b_07->setVisibility();
        $this->b_08->setVisibility();
        $this->b_09->setVisibility();
        $this->b_10->setVisibility();
        $this->b_11->setVisibility();
        $this->b_12->setVisibility();
        $this->b_13->setVisibility();
        $this->b_14->setVisibility();
        $this->b_15->setVisibility();
        $this->t_01->setVisibility();
        $this->t_02->setVisibility();
        $this->t_03->setVisibility();
        $this->t_04->setVisibility();
        $this->t_05->setVisibility();
        $this->t_06->setVisibility();
        $this->t_07->setVisibility();
        $this->t_08->setVisibility();
        $this->t_09->setVisibility();
        $this->t_10->setVisibility();
        $this->t_11->setVisibility();
        $this->t_12->setVisibility();
        $this->t_13->setVisibility();
        $this->t_14->setVisibility();
        $this->t_15->setVisibility();
        $this->last_price->setVisibility();
        $this->currency->setVisibility();
        $this->hsn->setVisibility();
        $this->composition->setVisibility();
        $this->category->setVisibility();
        $this->moq->setVisibility();
        $this->status->setVisibility();
        $this->d_head_01->setVisibility();
        $this->d_description_01->setVisibility();
        $this->d_head_02->setVisibility();
        $this->d_description_02->setVisibility();
        $this->publish->setVisibility();
        $this->keywords->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->main_image->Visible = false;
        $this->top_view->Visible = false;
        $this->front_view->Visible = false;
        $this->corner_view->Visible = false;
        $this->back_view->Visible = false;
        $this->color_options->Visible = false;
        $this->other_options->Visible = false;
        $this->group_image->Visible = false;
        $this->video_url->setVisibility();
        $this->image->Visible = false;
        $this->in->Visible = false;
        $this->out->Visible = false;
        $this->required->Visible = false;
        $this->blocked->Visible = false;
        $this->ordered->Visible = false;
        $this->supplier->Visible = false;
        $this->country->Visible = false;
        $this->minimum_stock->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ref';
        $this->TableName = 'ref';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ref)
        if (!isset($GLOBALS["ref"]) || $GLOBALS["ref"]::class == PROJECT_NAMESPACE . "ref") {
            $GLOBALS["ref"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "refview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
                $this->main_image->UploadPath = $this->main_image->OldUploadPath;
                $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
                $this->top_view->UploadPath = $this->top_view->OldUploadPath;
                $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
                $this->front_view->UploadPath = $this->front_view->OldUploadPath;
                $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
                $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
                $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
                $this->back_view->UploadPath = $this->back_view->OldUploadPath;
                $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
                $this->color_options->UploadPath = $this->color_options->OldUploadPath;
                $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
                $this->other_options->UploadPath = $this->other_options->OldUploadPath;
                $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
                $this->group_image->UploadPath = $this->group_image->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code_type);
        $this->setupLookupOptions($this->set_ref);
        $this->setupLookupOptions($this->v_01);
        $this->setupLookupOptions($this->v_02);
        $this->setupLookupOptions($this->v_03);
        $this->setupLookupOptions($this->v_04);
        $this->setupLookupOptions($this->v_05);
        $this->setupLookupOptions($this->v_06);
        $this->setupLookupOptions($this->v_07);
        $this->setupLookupOptions($this->v_08);
        $this->setupLookupOptions($this->v_09);
        $this->setupLookupOptions($this->v_10);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->b_03);
        $this->setupLookupOptions($this->b_04);
        $this->setupLookupOptions($this->b_05);
        $this->setupLookupOptions($this->b_06);
        $this->setupLookupOptions($this->b_07);
        $this->setupLookupOptions($this->b_08);
        $this->setupLookupOptions($this->b_09);
        $this->setupLookupOptions($this->b_10);
        $this->setupLookupOptions($this->t_03);
        $this->setupLookupOptions($this->t_04);
        $this->setupLookupOptions($this->t_05);
        $this->setupLookupOptions($this->t_06);
        $this->setupLookupOptions($this->t_07);
        $this->setupLookupOptions($this->t_08);
        $this->setupLookupOptions($this->t_09);
        $this->setupLookupOptions($this->t_10);
        $this->setupLookupOptions($this->t_11);
        $this->setupLookupOptions($this->t_12);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->hsn);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->publish);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values

            // Set up detail parameters
            $this->setupDetailParms();
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("reflist"); // No matching record, return to list
                        return;
                    }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "update": // Update
                if ($this->getCurrentDetailTable() != "") { // Master/detail edit
                    $returnUrl = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
                } else {
                    $returnUrl = $this->getReturnUrl();
                }
                if (GetPageName($returnUrl) == "reflist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "reflist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "reflist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'product_n' first before field var 'x_product_n'
        $val = $CurrentForm->hasValue("product_n") ? $CurrentForm->getValue("product_n") : $CurrentForm->getValue("x_product_n");
        if (!$this->product_n->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_n->Visible = false; // Disable update for API request
            } else {
                $this->product_n->setFormValue($val);
            }
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val);
            }
        }

        // Check field name 'product_code_type' first before field var 'x_product_code_type'
        $val = $CurrentForm->hasValue("product_code_type") ? $CurrentForm->getValue("product_code_type") : $CurrentForm->getValue("x_product_code_type");
        if (!$this->product_code_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code_type->Visible = false; // Disable update for API request
            } else {
                $this->product_code_type->setFormValue($val);
            }
        }

        // Check field name 'product_code' first before field var 'x_product_code'
        $val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
        if (!$this->product_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code->Visible = false; // Disable update for API request
            } else {
                $this->product_code->setFormValue($val);
            }
        }

        // Check field name 'set_ref' first before field var 'x_set_ref'
        $val = $CurrentForm->hasValue("set_ref") ? $CurrentForm->getValue("set_ref") : $CurrentForm->getValue("x_set_ref");
        if (!$this->set_ref->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->set_ref->Visible = false; // Disable update for API request
            } else {
                $this->set_ref->setFormValue($val);
            }
        }

        // Check field name 'v_00' first before field var 'x_v_00'
        $val = $CurrentForm->hasValue("v_00") ? $CurrentForm->getValue("v_00") : $CurrentForm->getValue("x_v_00");
        if (!$this->v_00->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_00->Visible = false; // Disable update for API request
            } else {
                $this->v_00->setFormValue($val);
            }
        }

        // Check field name 'v_01' first before field var 'x_v_01'
        $val = $CurrentForm->hasValue("v_01") ? $CurrentForm->getValue("v_01") : $CurrentForm->getValue("x_v_01");
        if (!$this->v_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_01->Visible = false; // Disable update for API request
            } else {
                $this->v_01->setFormValue($val);
            }
        }

        // Check field name 'v_02' first before field var 'x_v_02'
        $val = $CurrentForm->hasValue("v_02") ? $CurrentForm->getValue("v_02") : $CurrentForm->getValue("x_v_02");
        if (!$this->v_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_02->Visible = false; // Disable update for API request
            } else {
                $this->v_02->setFormValue($val);
            }
        }

        // Check field name 'v_03' first before field var 'x_v_03'
        $val = $CurrentForm->hasValue("v_03") ? $CurrentForm->getValue("v_03") : $CurrentForm->getValue("x_v_03");
        if (!$this->v_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_03->Visible = false; // Disable update for API request
            } else {
                $this->v_03->setFormValue($val);
            }
        }

        // Check field name 'v_04' first before field var 'x_v_04'
        $val = $CurrentForm->hasValue("v_04") ? $CurrentForm->getValue("v_04") : $CurrentForm->getValue("x_v_04");
        if (!$this->v_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_04->Visible = false; // Disable update for API request
            } else {
                $this->v_04->setFormValue($val);
            }
        }

        // Check field name 'v_05' first before field var 'x_v_05'
        $val = $CurrentForm->hasValue("v_05") ? $CurrentForm->getValue("v_05") : $CurrentForm->getValue("x_v_05");
        if (!$this->v_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_05->Visible = false; // Disable update for API request
            } else {
                $this->v_05->setFormValue($val);
            }
        }

        // Check field name 'v_06' first before field var 'x_v_06'
        $val = $CurrentForm->hasValue("v_06") ? $CurrentForm->getValue("v_06") : $CurrentForm->getValue("x_v_06");
        if (!$this->v_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_06->Visible = false; // Disable update for API request
            } else {
                $this->v_06->setFormValue($val);
            }
        }

        // Check field name 'v_07' first before field var 'x_v_07'
        $val = $CurrentForm->hasValue("v_07") ? $CurrentForm->getValue("v_07") : $CurrentForm->getValue("x_v_07");
        if (!$this->v_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_07->Visible = false; // Disable update for API request
            } else {
                $this->v_07->setFormValue($val);
            }
        }

        // Check field name 'v_08' first before field var 'x_v_08'
        $val = $CurrentForm->hasValue("v_08") ? $CurrentForm->getValue("v_08") : $CurrentForm->getValue("x_v_08");
        if (!$this->v_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_08->Visible = false; // Disable update for API request
            } else {
                $this->v_08->setFormValue($val);
            }
        }

        // Check field name 'v_09' first before field var 'x_v_09'
        $val = $CurrentForm->hasValue("v_09") ? $CurrentForm->getValue("v_09") : $CurrentForm->getValue("x_v_09");
        if (!$this->v_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_09->Visible = false; // Disable update for API request
            } else {
                $this->v_09->setFormValue($val);
            }
        }

        // Check field name 'v_10' first before field var 'x_v_10'
        $val = $CurrentForm->hasValue("v_10") ? $CurrentForm->getValue("v_10") : $CurrentForm->getValue("x_v_10");
        if (!$this->v_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_10->Visible = false; // Disable update for API request
            } else {
                $this->v_10->setFormValue($val);
            }
        }

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cbm->Visible = false; // Disable update for API request
            } else {
                $this->cbm->setFormValue($val);
            }
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->sqm->Visible = false; // Disable update for API request
            } else {
                $this->sqm->setFormValue($val);
            }
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shape->Visible = false; // Disable update for API request
            } else {
                $this->shape->setFormValue($val);
            }
        }

        // Check field name 'q_sku' first before field var 'x_q_sku'
        $val = $CurrentForm->hasValue("q_sku") ? $CurrentForm->getValue("q_sku") : $CurrentForm->getValue("x_q_sku");
        if (!$this->q_sku->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->q_sku->Visible = false; // Disable update for API request
            } else {
                $this->q_sku->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'b_01' first before field var 'x_b_01'
        $val = $CurrentForm->hasValue("b_01") ? $CurrentForm->getValue("b_01") : $CurrentForm->getValue("x_b_01");
        if (!$this->b_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_01->Visible = false; // Disable update for API request
            } else {
                $this->b_01->setFormValue($val);
            }
        }

        // Check field name 'b_02' first before field var 'x_b_02'
        $val = $CurrentForm->hasValue("b_02") ? $CurrentForm->getValue("b_02") : $CurrentForm->getValue("x_b_02");
        if (!$this->b_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_02->Visible = false; // Disable update for API request
            } else {
                $this->b_02->setFormValue($val);
            }
        }

        // Check field name 'b_03' first before field var 'x_b_03'
        $val = $CurrentForm->hasValue("b_03") ? $CurrentForm->getValue("b_03") : $CurrentForm->getValue("x_b_03");
        if (!$this->b_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_03->Visible = false; // Disable update for API request
            } else {
                $this->b_03->setFormValue($val);
            }
        }

        // Check field name 'b_04' first before field var 'x_b_04'
        $val = $CurrentForm->hasValue("b_04") ? $CurrentForm->getValue("b_04") : $CurrentForm->getValue("x_b_04");
        if (!$this->b_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_04->Visible = false; // Disable update for API request
            } else {
                $this->b_04->setFormValue($val);
            }
        }

        // Check field name 'b_05' first before field var 'x_b_05'
        $val = $CurrentForm->hasValue("b_05") ? $CurrentForm->getValue("b_05") : $CurrentForm->getValue("x_b_05");
        if (!$this->b_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_05->Visible = false; // Disable update for API request
            } else {
                $this->b_05->setFormValue($val);
            }
        }

        // Check field name 'b_06' first before field var 'x_b_06'
        $val = $CurrentForm->hasValue("b_06") ? $CurrentForm->getValue("b_06") : $CurrentForm->getValue("x_b_06");
        if (!$this->b_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_06->Visible = false; // Disable update for API request
            } else {
                $this->b_06->setFormValue($val);
            }
        }

        // Check field name 'b_07' first before field var 'x_b_07'
        $val = $CurrentForm->hasValue("b_07") ? $CurrentForm->getValue("b_07") : $CurrentForm->getValue("x_b_07");
        if (!$this->b_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_07->Visible = false; // Disable update for API request
            } else {
                $this->b_07->setFormValue($val);
            }
        }

        // Check field name 'b_08' first before field var 'x_b_08'
        $val = $CurrentForm->hasValue("b_08") ? $CurrentForm->getValue("b_08") : $CurrentForm->getValue("x_b_08");
        if (!$this->b_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_08->Visible = false; // Disable update for API request
            } else {
                $this->b_08->setFormValue($val);
            }
        }

        // Check field name 'b_09' first before field var 'x_b_09'
        $val = $CurrentForm->hasValue("b_09") ? $CurrentForm->getValue("b_09") : $CurrentForm->getValue("x_b_09");
        if (!$this->b_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_09->Visible = false; // Disable update for API request
            } else {
                $this->b_09->setFormValue($val);
            }
        }

        // Check field name 'b_10' first before field var 'x_b_10'
        $val = $CurrentForm->hasValue("b_10") ? $CurrentForm->getValue("b_10") : $CurrentForm->getValue("x_b_10");
        if (!$this->b_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_10->Visible = false; // Disable update for API request
            } else {
                $this->b_10->setFormValue($val);
            }
        }

        // Check field name 'b_11' first before field var 'x_b_11'
        $val = $CurrentForm->hasValue("b_11") ? $CurrentForm->getValue("b_11") : $CurrentForm->getValue("x_b_11");
        if (!$this->b_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_11->Visible = false; // Disable update for API request
            } else {
                $this->b_11->setFormValue($val);
            }
        }

        // Check field name 'b_12' first before field var 'x_b_12'
        $val = $CurrentForm->hasValue("b_12") ? $CurrentForm->getValue("b_12") : $CurrentForm->getValue("x_b_12");
        if (!$this->b_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_12->Visible = false; // Disable update for API request
            } else {
                $this->b_12->setFormValue($val);
            }
        }

        // Check field name 'b_13' first before field var 'x_b_13'
        $val = $CurrentForm->hasValue("b_13") ? $CurrentForm->getValue("b_13") : $CurrentForm->getValue("x_b_13");
        if (!$this->b_13->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_13->Visible = false; // Disable update for API request
            } else {
                $this->b_13->setFormValue($val);
            }
        }

        // Check field name 'b_14' first before field var 'x_b_14'
        $val = $CurrentForm->hasValue("b_14") ? $CurrentForm->getValue("b_14") : $CurrentForm->getValue("x_b_14");
        if (!$this->b_14->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_14->Visible = false; // Disable update for API request
            } else {
                $this->b_14->setFormValue($val);
            }
        }

        // Check field name 'b_15' first before field var 'x_b_15'
        $val = $CurrentForm->hasValue("b_15") ? $CurrentForm->getValue("b_15") : $CurrentForm->getValue("x_b_15");
        if (!$this->b_15->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->b_15->Visible = false; // Disable update for API request
            } else {
                $this->b_15->setFormValue($val);
            }
        }

        // Check field name 't_01' first before field var 'x_t_01'
        $val = $CurrentForm->hasValue("t_01") ? $CurrentForm->getValue("t_01") : $CurrentForm->getValue("x_t_01");
        if (!$this->t_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_01->Visible = false; // Disable update for API request
            } else {
                $this->t_01->setFormValue($val);
            }
        }

        // Check field name 't_02' first before field var 'x_t_02'
        $val = $CurrentForm->hasValue("t_02") ? $CurrentForm->getValue("t_02") : $CurrentForm->getValue("x_t_02");
        if (!$this->t_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_02->Visible = false; // Disable update for API request
            } else {
                $this->t_02->setFormValue($val);
            }
        }

        // Check field name 't_03' first before field var 'x_t_03'
        $val = $CurrentForm->hasValue("t_03") ? $CurrentForm->getValue("t_03") : $CurrentForm->getValue("x_t_03");
        if (!$this->t_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_03->Visible = false; // Disable update for API request
            } else {
                $this->t_03->setFormValue($val);
            }
        }

        // Check field name 't_04' first before field var 'x_t_04'
        $val = $CurrentForm->hasValue("t_04") ? $CurrentForm->getValue("t_04") : $CurrentForm->getValue("x_t_04");
        if (!$this->t_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_04->Visible = false; // Disable update for API request
            } else {
                $this->t_04->setFormValue($val);
            }
        }

        // Check field name 't_05' first before field var 'x_t_05'
        $val = $CurrentForm->hasValue("t_05") ? $CurrentForm->getValue("t_05") : $CurrentForm->getValue("x_t_05");
        if (!$this->t_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_05->Visible = false; // Disable update for API request
            } else {
                $this->t_05->setFormValue($val);
            }
        }

        // Check field name 't_06' first before field var 'x_t_06'
        $val = $CurrentForm->hasValue("t_06") ? $CurrentForm->getValue("t_06") : $CurrentForm->getValue("x_t_06");
        if (!$this->t_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_06->Visible = false; // Disable update for API request
            } else {
                $this->t_06->setFormValue($val);
            }
        }

        // Check field name 't_07' first before field var 'x_t_07'
        $val = $CurrentForm->hasValue("t_07") ? $CurrentForm->getValue("t_07") : $CurrentForm->getValue("x_t_07");
        if (!$this->t_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_07->Visible = false; // Disable update for API request
            } else {
                $this->t_07->setFormValue($val);
            }
        }

        // Check field name 't_08' first before field var 'x_t_08'
        $val = $CurrentForm->hasValue("t_08") ? $CurrentForm->getValue("t_08") : $CurrentForm->getValue("x_t_08");
        if (!$this->t_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_08->Visible = false; // Disable update for API request
            } else {
                $this->t_08->setFormValue($val);
            }
        }

        // Check field name 't_09' first before field var 'x_t_09'
        $val = $CurrentForm->hasValue("t_09") ? $CurrentForm->getValue("t_09") : $CurrentForm->getValue("x_t_09");
        if (!$this->t_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_09->Visible = false; // Disable update for API request
            } else {
                $this->t_09->setFormValue($val);
            }
        }

        // Check field name 't_10' first before field var 'x_t_10'
        $val = $CurrentForm->hasValue("t_10") ? $CurrentForm->getValue("t_10") : $CurrentForm->getValue("x_t_10");
        if (!$this->t_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_10->Visible = false; // Disable update for API request
            } else {
                $this->t_10->setFormValue($val);
            }
        }

        // Check field name 't_11' first before field var 'x_t_11'
        $val = $CurrentForm->hasValue("t_11") ? $CurrentForm->getValue("t_11") : $CurrentForm->getValue("x_t_11");
        if (!$this->t_11->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_11->Visible = false; // Disable update for API request
            } else {
                $this->t_11->setFormValue($val);
            }
        }

        // Check field name 't_12' first before field var 'x_t_12'
        $val = $CurrentForm->hasValue("t_12") ? $CurrentForm->getValue("t_12") : $CurrentForm->getValue("x_t_12");
        if (!$this->t_12->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_12->Visible = false; // Disable update for API request
            } else {
                $this->t_12->setFormValue($val);
            }
        }

        // Check field name 't_13' first before field var 'x_t_13'
        $val = $CurrentForm->hasValue("t_13") ? $CurrentForm->getValue("t_13") : $CurrentForm->getValue("x_t_13");
        if (!$this->t_13->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_13->Visible = false; // Disable update for API request
            } else {
                $this->t_13->setFormValue($val);
            }
        }

        // Check field name 't_14' first before field var 'x_t_14'
        $val = $CurrentForm->hasValue("t_14") ? $CurrentForm->getValue("t_14") : $CurrentForm->getValue("x_t_14");
        if (!$this->t_14->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_14->Visible = false; // Disable update for API request
            } else {
                $this->t_14->setFormValue($val);
            }
        }

        // Check field name 't_15' first before field var 'x_t_15'
        $val = $CurrentForm->hasValue("t_15") ? $CurrentForm->getValue("t_15") : $CurrentForm->getValue("x_t_15");
        if (!$this->t_15->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->t_15->Visible = false; // Disable update for API request
            } else {
                $this->t_15->setFormValue($val);
            }
        }

        // Check field name 'last_price' first before field var 'x_last_price'
        $val = $CurrentForm->hasValue("last_price") ? $CurrentForm->getValue("last_price") : $CurrentForm->getValue("x_last_price");
        if (!$this->last_price->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->last_price->Visible = false; // Disable update for API request
            } else {
                $this->last_price->setFormValue($val);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'hsn' first before field var 'x_hsn'
        $val = $CurrentForm->hasValue("hsn") ? $CurrentForm->getValue("hsn") : $CurrentForm->getValue("x_hsn");
        if (!$this->hsn->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->hsn->Visible = false; // Disable update for API request
            } else {
                $this->hsn->setFormValue($val);
            }
        }

        // Check field name 'composition' first before field var 'x_composition'
        $val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
        if (!$this->composition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->composition->Visible = false; // Disable update for API request
            } else {
                $this->composition->setFormValue($val);
            }
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->category->Visible = false; // Disable update for API request
            } else {
                $this->category->setFormValue($val);
            }
        }

        // Check field name 'moq' first before field var 'x_moq'
        $val = $CurrentForm->hasValue("moq") ? $CurrentForm->getValue("moq") : $CurrentForm->getValue("x_moq");
        if (!$this->moq->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->moq->Visible = false; // Disable update for API request
            } else {
                $this->moq->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'd_head_01' first before field var 'x_d_head_01'
        $val = $CurrentForm->hasValue("d_head_01") ? $CurrentForm->getValue("d_head_01") : $CurrentForm->getValue("x_d_head_01");
        if (!$this->d_head_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_head_01->Visible = false; // Disable update for API request
            } else {
                $this->d_head_01->setFormValue($val);
            }
        }

        // Check field name 'd_description_01' first before field var 'x_d_description_01'
        $val = $CurrentForm->hasValue("d_description_01") ? $CurrentForm->getValue("d_description_01") : $CurrentForm->getValue("x_d_description_01");
        if (!$this->d_description_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_description_01->Visible = false; // Disable update for API request
            } else {
                $this->d_description_01->setFormValue($val);
            }
        }

        // Check field name 'd_head_02' first before field var 'x_d_head_02'
        $val = $CurrentForm->hasValue("d_head_02") ? $CurrentForm->getValue("d_head_02") : $CurrentForm->getValue("x_d_head_02");
        if (!$this->d_head_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_head_02->Visible = false; // Disable update for API request
            } else {
                $this->d_head_02->setFormValue($val);
            }
        }

        // Check field name 'd_description_02' first before field var 'x_d_description_02'
        $val = $CurrentForm->hasValue("d_description_02") ? $CurrentForm->getValue("d_description_02") : $CurrentForm->getValue("x_d_description_02");
        if (!$this->d_description_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->d_description_02->Visible = false; // Disable update for API request
            } else {
                $this->d_description_02->setFormValue($val);
            }
        }

        // Check field name 'publish' first before field var 'x_publish'
        $val = $CurrentForm->hasValue("publish") ? $CurrentForm->getValue("publish") : $CurrentForm->getValue("x_publish");
        if (!$this->publish->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->publish->Visible = false; // Disable update for API request
            } else {
                $this->publish->setFormValue($val);
            }
        }

        // Check field name 'keywords' first before field var 'x_keywords'
        $val = $CurrentForm->hasValue("keywords") ? $CurrentForm->getValue("keywords") : $CurrentForm->getValue("x_keywords");
        if (!$this->keywords->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->keywords->Visible = false; // Disable update for API request
            } else {
                $this->keywords->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'video_url' first before field var 'x_video_url'
        $val = $CurrentForm->hasValue("video_url") ? $CurrentForm->getValue("video_url") : $CurrentForm->getValue("x_video_url");
        if (!$this->video_url->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->video_url->Visible = false; // Disable update for API request
            } else {
                $this->video_url->setFormValue($val);
            }
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->product_n->CurrentValue = $this->product_n->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->product_code_type->CurrentValue = $this->product_code_type->FormValue;
        $this->product_code->CurrentValue = $this->product_code->FormValue;
        $this->set_ref->CurrentValue = $this->set_ref->FormValue;
        $this->v_00->CurrentValue = $this->v_00->FormValue;
        $this->v_01->CurrentValue = $this->v_01->FormValue;
        $this->v_02->CurrentValue = $this->v_02->FormValue;
        $this->v_03->CurrentValue = $this->v_03->FormValue;
        $this->v_04->CurrentValue = $this->v_04->FormValue;
        $this->v_05->CurrentValue = $this->v_05->FormValue;
        $this->v_06->CurrentValue = $this->v_06->FormValue;
        $this->v_07->CurrentValue = $this->v_07->FormValue;
        $this->v_08->CurrentValue = $this->v_08->FormValue;
        $this->v_09->CurrentValue = $this->v_09->FormValue;
        $this->v_10->CurrentValue = $this->v_10->FormValue;
        $this->cbm->CurrentValue = $this->cbm->FormValue;
        $this->sqm->CurrentValue = $this->sqm->FormValue;
        $this->shape->CurrentValue = $this->shape->FormValue;
        $this->q_sku->CurrentValue = $this->q_sku->FormValue;
        $this->b_01->CurrentValue = $this->b_01->FormValue;
        $this->b_02->CurrentValue = $this->b_02->FormValue;
        $this->b_03->CurrentValue = $this->b_03->FormValue;
        $this->b_04->CurrentValue = $this->b_04->FormValue;
        $this->b_05->CurrentValue = $this->b_05->FormValue;
        $this->b_06->CurrentValue = $this->b_06->FormValue;
        $this->b_07->CurrentValue = $this->b_07->FormValue;
        $this->b_08->CurrentValue = $this->b_08->FormValue;
        $this->b_09->CurrentValue = $this->b_09->FormValue;
        $this->b_10->CurrentValue = $this->b_10->FormValue;
        $this->b_11->CurrentValue = $this->b_11->FormValue;
        $this->b_12->CurrentValue = $this->b_12->FormValue;
        $this->b_13->CurrentValue = $this->b_13->FormValue;
        $this->b_14->CurrentValue = $this->b_14->FormValue;
        $this->b_15->CurrentValue = $this->b_15->FormValue;
        $this->t_01->CurrentValue = $this->t_01->FormValue;
        $this->t_02->CurrentValue = $this->t_02->FormValue;
        $this->t_03->CurrentValue = $this->t_03->FormValue;
        $this->t_04->CurrentValue = $this->t_04->FormValue;
        $this->t_05->CurrentValue = $this->t_05->FormValue;
        $this->t_06->CurrentValue = $this->t_06->FormValue;
        $this->t_07->CurrentValue = $this->t_07->FormValue;
        $this->t_08->CurrentValue = $this->t_08->FormValue;
        $this->t_09->CurrentValue = $this->t_09->FormValue;
        $this->t_10->CurrentValue = $this->t_10->FormValue;
        $this->t_11->CurrentValue = $this->t_11->FormValue;
        $this->t_12->CurrentValue = $this->t_12->FormValue;
        $this->t_13->CurrentValue = $this->t_13->FormValue;
        $this->t_14->CurrentValue = $this->t_14->FormValue;
        $this->t_15->CurrentValue = $this->t_15->FormValue;
        $this->last_price->CurrentValue = $this->last_price->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->hsn->CurrentValue = $this->hsn->FormValue;
        $this->composition->CurrentValue = $this->composition->FormValue;
        $this->category->CurrentValue = $this->category->FormValue;
        $this->moq->CurrentValue = $this->moq->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->d_head_01->CurrentValue = $this->d_head_01->FormValue;
        $this->d_description_01->CurrentValue = $this->d_description_01->FormValue;
        $this->d_head_02->CurrentValue = $this->d_head_02->FormValue;
        $this->d_description_02->CurrentValue = $this->d_description_02->FormValue;
        $this->publish->CurrentValue = $this->publish->FormValue;
        $this->keywords->CurrentValue = $this->keywords->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->video_url->CurrentValue = $this->video_url->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->oid->setDbValue($row['oid']);
        $this->company_id->setDbValue($row['company_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_type->setDbValue($row['product_type']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_n->setDbValue($row['product_n']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->product_code_type->setDbValue($row['product_code_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->print_name->setDbValue($row['print_name']);
        $this->gcode->setDbValue($row['gcode']);
        $this->code->setDbValue($row['code']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->set_ref->setDbValue($row['set_ref']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_10->setDbValue($row['v_10']);
        $this->cbm->setDbValue($row['cbm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->shape->setDbValue($row['shape']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->b_01->setDbValue($row['b_01']);
        $this->b_02->setDbValue($row['b_02']);
        $this->b_03->setDbValue($row['b_03']);
        $this->b_04->setDbValue($row['b_04']);
        $this->b_05->setDbValue($row['b_05']);
        $this->b_06->setDbValue($row['b_06']);
        $this->b_07->setDbValue($row['b_07']);
        $this->b_08->setDbValue($row['b_08']);
        $this->b_09->setDbValue($row['b_09']);
        $this->b_10->setDbValue($row['b_10']);
        $this->b_11->setDbValue($row['b_11']);
        $this->b_12->setDbValue($row['b_12']);
        $this->b_13->setDbValue($row['b_13']);
        $this->b_14->setDbValue($row['b_14']);
        $this->b_15->setDbValue($row['b_15']);
        $this->t_01->setDbValue($row['t_01']);
        $this->t_02->setDbValue($row['t_02']);
        $this->t_03->setDbValue($row['t_03']);
        $this->t_04->setDbValue($row['t_04']);
        $this->t_05->setDbValue($row['t_05']);
        $this->t_06->setDbValue($row['t_06']);
        $this->t_07->setDbValue($row['t_07']);
        $this->t_08->setDbValue($row['t_08']);
        $this->t_09->setDbValue($row['t_09']);
        $this->t_10->setDbValue($row['t_10']);
        $this->t_11->setDbValue($row['t_11']);
        $this->t_12->setDbValue($row['t_12']);
        $this->t_13->setDbValue($row['t_13']);
        $this->t_14->setDbValue($row['t_14']);
        $this->t_15->setDbValue($row['t_15']);
        $this->last_price->setDbValue($row['last_price']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->category->setDbValue($row['category']);
        $this->moq->setDbValue($row['moq']);
        $this->status->setDbValue($row['status']);
        $this->d_head_01->setDbValue($row['d_head_01']);
        $this->d_description_01->setDbValue($row['d_description_01']);
        $this->d_head_02->setDbValue($row['d_head_02']);
        $this->d_description_02->setDbValue($row['d_description_02']);
        $this->publish->setDbValue($row['publish']);
        $this->keywords->setDbValue($row['keywords']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->main_image->setDbValue($this->main_image->Upload->DbValue);
        $this->top_view->Upload->DbValue = $row['top_view'];
        $this->top_view->setDbValue($this->top_view->Upload->DbValue);
        $this->front_view->Upload->DbValue = $row['front_view'];
        $this->front_view->setDbValue($this->front_view->Upload->DbValue);
        $this->corner_view->Upload->DbValue = $row['corner_view'];
        $this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
        $this->back_view->Upload->DbValue = $row['back_view'];
        $this->back_view->setDbValue($this->back_view->Upload->DbValue);
        $this->color_options->Upload->DbValue = $row['color_options'];
        $this->color_options->setDbValue($this->color_options->Upload->DbValue);
        $this->other_options->Upload->DbValue = $row['other_options'];
        $this->other_options->setDbValue($this->other_options->Upload->DbValue);
        $this->group_image->Upload->DbValue = $row['group_image'];
        $this->group_image->setDbValue($this->group_image->Upload->DbValue);
        $this->video_url->setDbValue($row['video_url']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->in->setDbValue($row['in']);
        $this->out->setDbValue($row['out']);
        $this->required->setDbValue($row['required']);
        $this->blocked->setDbValue($row['blocked']);
        $this->ordered->setDbValue($row['ordered']);
        $this->supplier->setDbValue($row['supplier']);
        $this->country->setDbValue($row['country']);
        $this->minimum_stock->setDbValue($row['minimum_stock']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['oid'] = $this->oid->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['product_n'] = $this->product_n->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['product_code_type'] = $this->product_code_type->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['print_name'] = $this->print_name->DefaultValue;
        $row['gcode'] = $this->gcode->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['set_ref'] = $this->set_ref->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['b_01'] = $this->b_01->DefaultValue;
        $row['b_02'] = $this->b_02->DefaultValue;
        $row['b_03'] = $this->b_03->DefaultValue;
        $row['b_04'] = $this->b_04->DefaultValue;
        $row['b_05'] = $this->b_05->DefaultValue;
        $row['b_06'] = $this->b_06->DefaultValue;
        $row['b_07'] = $this->b_07->DefaultValue;
        $row['b_08'] = $this->b_08->DefaultValue;
        $row['b_09'] = $this->b_09->DefaultValue;
        $row['b_10'] = $this->b_10->DefaultValue;
        $row['b_11'] = $this->b_11->DefaultValue;
        $row['b_12'] = $this->b_12->DefaultValue;
        $row['b_13'] = $this->b_13->DefaultValue;
        $row['b_14'] = $this->b_14->DefaultValue;
        $row['b_15'] = $this->b_15->DefaultValue;
        $row['t_01'] = $this->t_01->DefaultValue;
        $row['t_02'] = $this->t_02->DefaultValue;
        $row['t_03'] = $this->t_03->DefaultValue;
        $row['t_04'] = $this->t_04->DefaultValue;
        $row['t_05'] = $this->t_05->DefaultValue;
        $row['t_06'] = $this->t_06->DefaultValue;
        $row['t_07'] = $this->t_07->DefaultValue;
        $row['t_08'] = $this->t_08->DefaultValue;
        $row['t_09'] = $this->t_09->DefaultValue;
        $row['t_10'] = $this->t_10->DefaultValue;
        $row['t_11'] = $this->t_11->DefaultValue;
        $row['t_12'] = $this->t_12->DefaultValue;
        $row['t_13'] = $this->t_13->DefaultValue;
        $row['t_14'] = $this->t_14->DefaultValue;
        $row['t_15'] = $this->t_15->DefaultValue;
        $row['last_price'] = $this->last_price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['hsn'] = $this->hsn->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['moq'] = $this->moq->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['d_head_01'] = $this->d_head_01->DefaultValue;
        $row['d_description_01'] = $this->d_description_01->DefaultValue;
        $row['d_head_02'] = $this->d_head_02->DefaultValue;
        $row['d_description_02'] = $this->d_description_02->DefaultValue;
        $row['publish'] = $this->publish->DefaultValue;
        $row['keywords'] = $this->keywords->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['main_image'] = $this->main_image->DefaultValue;
        $row['top_view'] = $this->top_view->DefaultValue;
        $row['front_view'] = $this->front_view->DefaultValue;
        $row['corner_view'] = $this->corner_view->DefaultValue;
        $row['back_view'] = $this->back_view->DefaultValue;
        $row['color_options'] = $this->color_options->DefaultValue;
        $row['other_options'] = $this->other_options->DefaultValue;
        $row['group_image'] = $this->group_image->DefaultValue;
        $row['video_url'] = $this->video_url->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['in'] = $this->in->DefaultValue;
        $row['out'] = $this->out->DefaultValue;
        $row['required'] = $this->required->DefaultValue;
        $row['blocked'] = $this->blocked->DefaultValue;
        $row['ordered'] = $this->ordered->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['minimum_stock'] = $this->minimum_stock->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // oid
        $this->oid->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // product_n
        $this->product_n->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // product_code_type
        $this->product_code_type->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // print_name
        $this->print_name->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // product_id
        $this->product_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // set_ref
        $this->set_ref->RowCssClass = "row";

        // v_00
        $this->v_00->RowCssClass = "row";

        // v_01
        $this->v_01->RowCssClass = "row";

        // v_02
        $this->v_02->RowCssClass = "row";

        // v_03
        $this->v_03->RowCssClass = "row";

        // v_04
        $this->v_04->RowCssClass = "row";

        // v_05
        $this->v_05->RowCssClass = "row";

        // v_06
        $this->v_06->RowCssClass = "row";

        // v_07
        $this->v_07->RowCssClass = "row";

        // v_08
        $this->v_08->RowCssClass = "row";

        // v_09
        $this->v_09->RowCssClass = "row";

        // v_10
        $this->v_10->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // b_01
        $this->b_01->RowCssClass = "row";

        // b_02
        $this->b_02->RowCssClass = "row";

        // b_03
        $this->b_03->RowCssClass = "row";

        // b_04
        $this->b_04->RowCssClass = "row";

        // b_05
        $this->b_05->RowCssClass = "row";

        // b_06
        $this->b_06->RowCssClass = "row";

        // b_07
        $this->b_07->RowCssClass = "row";

        // b_08
        $this->b_08->RowCssClass = "row";

        // b_09
        $this->b_09->RowCssClass = "row";

        // b_10
        $this->b_10->RowCssClass = "row";

        // b_11
        $this->b_11->RowCssClass = "row";

        // b_12
        $this->b_12->RowCssClass = "row";

        // b_13
        $this->b_13->RowCssClass = "row";

        // b_14
        $this->b_14->RowCssClass = "row";

        // b_15
        $this->b_15->RowCssClass = "row";

        // t_01
        $this->t_01->RowCssClass = "row";

        // t_02
        $this->t_02->RowCssClass = "row";

        // t_03
        $this->t_03->RowCssClass = "row";

        // t_04
        $this->t_04->RowCssClass = "row";

        // t_05
        $this->t_05->RowCssClass = "row";

        // t_06
        $this->t_06->RowCssClass = "row";

        // t_07
        $this->t_07->RowCssClass = "row";

        // t_08
        $this->t_08->RowCssClass = "row";

        // t_09
        $this->t_09->RowCssClass = "row";

        // t_10
        $this->t_10->RowCssClass = "row";

        // t_11
        $this->t_11->RowCssClass = "row";

        // t_12
        $this->t_12->RowCssClass = "row";

        // t_13
        $this->t_13->RowCssClass = "row";

        // t_14
        $this->t_14->RowCssClass = "row";

        // t_15
        $this->t_15->RowCssClass = "row";

        // last_price
        $this->last_price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // hsn
        $this->hsn->RowCssClass = "row";

        // composition
        $this->composition->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // moq
        $this->moq->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // d_head_01
        $this->d_head_01->RowCssClass = "row";

        // d_description_01
        $this->d_description_01->RowCssClass = "row";

        // d_head_02
        $this->d_head_02->RowCssClass = "row";

        // d_description_02
        $this->d_description_02->RowCssClass = "row";

        // publish
        $this->publish->RowCssClass = "row";

        // keywords
        $this->keywords->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // main_image
        $this->main_image->RowCssClass = "row";

        // top_view
        $this->top_view->RowCssClass = "row";

        // front_view
        $this->front_view->RowCssClass = "row";

        // corner_view
        $this->corner_view->RowCssClass = "row";

        // back_view
        $this->back_view->RowCssClass = "row";

        // color_options
        $this->color_options->RowCssClass = "row";

        // other_options
        $this->other_options->RowCssClass = "row";

        // group_image
        $this->group_image->RowCssClass = "row";

        // video_url
        $this->video_url->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // in
        $this->in->RowCssClass = "row";

        // out
        $this->out->RowCssClass = "row";

        // required
        $this->required->RowCssClass = "row";

        // blocked
        $this->blocked->RowCssClass = "row";

        // ordered
        $this->ordered->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // minimum_stock
        $this->minimum_stock->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->company_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->company_id->Lookup->renderViewRow($row);
                            $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                        }
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_n
            $this->product_n->ViewValue = $this->product_n->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // product_code_type
            if (strval($this->product_code_type->CurrentValue) != "") {
                $this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
            } else {
                $this->product_code_type->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // set_ref
            $curVal = strval($this->set_ref->CurrentValue);
            if ($curVal != "") {
                $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
                if ($this->set_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->set_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->set_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                            $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->set_ref->ViewValue = $this->set_ref->CurrentValue;
                    }
                }
            } else {
                $this->set_ref->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $curVal = strval($this->v_01->CurrentValue);
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
                if ($this->v_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_01->Lookup->renderViewRow($rswrk[0]);
                        $this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
                    } else {
                        $this->v_01->ViewValue = $this->v_01->CurrentValue;
                    }
                }
            } else {
                $this->v_01->ViewValue = null;
            }

            // v_02
            $curVal = strval($this->v_02->CurrentValue);
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
                if ($this->v_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_02->Lookup->renderViewRow($rswrk[0]);
                        $this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
                    } else {
                        $this->v_02->ViewValue = $this->v_02->CurrentValue;
                    }
                }
            } else {
                $this->v_02->ViewValue = null;
            }

            // v_03
            $curVal = strval($this->v_03->CurrentValue);
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
                if ($this->v_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_03->Lookup->renderViewRow($rswrk[0]);
                        $this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
                    } else {
                        $this->v_03->ViewValue = $this->v_03->CurrentValue;
                    }
                }
            } else {
                $this->v_03->ViewValue = null;
            }

            // v_04
            $curVal = strval($this->v_04->CurrentValue);
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
                if ($this->v_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_04->Lookup->renderViewRow($rswrk[0]);
                        $this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
                    } else {
                        $this->v_04->ViewValue = $this->v_04->CurrentValue;
                    }
                }
            } else {
                $this->v_04->ViewValue = null;
            }

            // v_05
            $curVal = strval($this->v_05->CurrentValue);
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
                if ($this->v_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_05->Lookup->renderViewRow($rswrk[0]);
                        $this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
                    } else {
                        $this->v_05->ViewValue = $this->v_05->CurrentValue;
                    }
                }
            } else {
                $this->v_05->ViewValue = null;
            }

            // v_06
            $curVal = strval($this->v_06->CurrentValue);
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
                if ($this->v_06->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_06->Lookup->renderViewRow($rswrk[0]);
                        $this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
                    } else {
                        $this->v_06->ViewValue = $this->v_06->CurrentValue;
                    }
                }
            } else {
                $this->v_06->ViewValue = null;
            }

            // v_07
            $curVal = strval($this->v_07->CurrentValue);
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
                if ($this->v_07->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_07->Lookup->renderViewRow($rswrk[0]);
                        $this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
                    } else {
                        $this->v_07->ViewValue = $this->v_07->CurrentValue;
                    }
                }
            } else {
                $this->v_07->ViewValue = null;
            }

            // v_08
            $curVal = strval($this->v_08->CurrentValue);
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
                if ($this->v_08->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_08->Lookup->renderViewRow($rswrk[0]);
                        $this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
                    } else {
                        $this->v_08->ViewValue = $this->v_08->CurrentValue;
                    }
                }
            } else {
                $this->v_08->ViewValue = null;
            }

            // v_09
            $curVal = strval($this->v_09->CurrentValue);
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
                if ($this->v_09->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_09->Lookup->renderViewRow($rswrk[0]);
                        $this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
                    } else {
                        $this->v_09->ViewValue = $this->v_09->CurrentValue;
                    }
                }
            } else {
                $this->v_09->ViewValue = null;
            }

            // v_10
            $curVal = strval($this->v_10->CurrentValue);
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
                if ($this->v_10->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_10->Lookup->renderViewRow($rswrk[0]);
                        $this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
                    } else {
                        $this->v_10->ViewValue = $this->v_10->CurrentValue;
                    }
                }
            } else {
                $this->v_10->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // b_01
            $this->b_01->ViewValue = $this->b_01->CurrentValue;

            // b_02
            $this->b_02->ViewValue = $this->b_02->CurrentValue;

            // b_03
            $curVal = strval($this->b_03->CurrentValue);
            if ($curVal != "") {
                $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
                if ($this->b_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_03->Lookup->renderViewRow($row);
                            $this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
                        }
                    } else {
                        $this->b_03->ViewValue = $this->b_03->CurrentValue;
                    }
                }
            } else {
                $this->b_03->ViewValue = null;
            }

            // b_04
            $curVal = strval($this->b_04->CurrentValue);
            if ($curVal != "") {
                $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
                if ($this->b_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_04->Lookup->renderViewRow($row);
                            $this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
                        }
                    } else {
                        $this->b_04->ViewValue = $this->b_04->CurrentValue;
                    }
                }
            } else {
                $this->b_04->ViewValue = null;
            }

            // b_05
            $curVal = strval($this->b_05->CurrentValue);
            if ($curVal != "") {
                $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
                if ($this->b_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_05->Lookup->renderViewRow($row);
                            $this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
                        }
                    } else {
                        $this->b_05->ViewValue = $this->b_05->CurrentValue;
                    }
                }
            } else {
                $this->b_05->ViewValue = null;
            }

            // b_06
            $curVal = strval($this->b_06->CurrentValue);
            if ($curVal != "") {
                $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
                if ($this->b_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_06->Lookup->renderViewRow($row);
                            $this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
                        }
                    } else {
                        $this->b_06->ViewValue = $this->b_06->CurrentValue;
                    }
                }
            } else {
                $this->b_06->ViewValue = null;
            }

            // b_07
            $curVal = strval($this->b_07->CurrentValue);
            if ($curVal != "") {
                $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
                if ($this->b_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_07->Lookup->renderViewRow($row);
                            $this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
                        }
                    } else {
                        $this->b_07->ViewValue = $this->b_07->CurrentValue;
                    }
                }
            } else {
                $this->b_07->ViewValue = null;
            }

            // b_08
            $curVal = strval($this->b_08->CurrentValue);
            if ($curVal != "") {
                $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
                if ($this->b_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_08->Lookup->renderViewRow($row);
                            $this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
                        }
                    } else {
                        $this->b_08->ViewValue = $this->b_08->CurrentValue;
                    }
                }
            } else {
                $this->b_08->ViewValue = null;
            }

            // b_09
            $curVal = strval($this->b_09->CurrentValue);
            if ($curVal != "") {
                $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
                if ($this->b_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_09->Lookup->renderViewRow($row);
                            $this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
                        }
                    } else {
                        $this->b_09->ViewValue = $this->b_09->CurrentValue;
                    }
                }
            } else {
                $this->b_09->ViewValue = null;
            }

            // b_10
            $curVal = strval($this->b_10->CurrentValue);
            if ($curVal != "") {
                $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
                if ($this->b_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_10->Lookup->renderViewRow($row);
                            $this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
                        }
                    } else {
                        $this->b_10->ViewValue = $this->b_10->CurrentValue;
                    }
                }
            } else {
                $this->b_10->ViewValue = null;
            }

            // b_11
            $this->b_11->ViewValue = $this->b_11->CurrentValue;

            // b_12
            $this->b_12->ViewValue = $this->b_12->CurrentValue;

            // b_13
            $this->b_13->ViewValue = $this->b_13->CurrentValue;

            // b_14
            $this->b_14->ViewValue = $this->b_14->CurrentValue;

            // b_15
            $this->b_15->ViewValue = $this->b_15->CurrentValue;

            // t_01
            $this->t_01->ViewValue = $this->t_01->CurrentValue;

            // t_02
            $this->t_02->ViewValue = $this->t_02->CurrentValue;

            // t_03
            $curVal = strval($this->t_03->CurrentValue);
            if ($curVal != "") {
                $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
                if ($this->t_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_03->Lookup->renderViewRow($row);
                            $this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
                        }
                    } else {
                        $this->t_03->ViewValue = $this->t_03->CurrentValue;
                    }
                }
            } else {
                $this->t_03->ViewValue = null;
            }

            // t_04
            $curVal = strval($this->t_04->CurrentValue);
            if ($curVal != "") {
                $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
                if ($this->t_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_04->Lookup->renderViewRow($row);
                            $this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
                        }
                    } else {
                        $this->t_04->ViewValue = $this->t_04->CurrentValue;
                    }
                }
            } else {
                $this->t_04->ViewValue = null;
            }

            // t_05
            $curVal = strval($this->t_05->CurrentValue);
            if ($curVal != "") {
                $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
                if ($this->t_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_05->Lookup->renderViewRow($row);
                            $this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
                        }
                    } else {
                        $this->t_05->ViewValue = $this->t_05->CurrentValue;
                    }
                }
            } else {
                $this->t_05->ViewValue = null;
            }

            // t_06
            $curVal = strval($this->t_06->CurrentValue);
            if ($curVal != "") {
                $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
                if ($this->t_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_06->Lookup->renderViewRow($row);
                            $this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
                        }
                    } else {
                        $this->t_06->ViewValue = $this->t_06->CurrentValue;
                    }
                }
            } else {
                $this->t_06->ViewValue = null;
            }

            // t_07
            $curVal = strval($this->t_07->CurrentValue);
            if ($curVal != "") {
                $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
                if ($this->t_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_07->Lookup->renderViewRow($row);
                            $this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
                        }
                    } else {
                        $this->t_07->ViewValue = $this->t_07->CurrentValue;
                    }
                }
            } else {
                $this->t_07->ViewValue = null;
            }

            // t_08
            $curVal = strval($this->t_08->CurrentValue);
            if ($curVal != "") {
                $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
                if ($this->t_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_08->Lookup->renderViewRow($row);
                            $this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
                        }
                    } else {
                        $this->t_08->ViewValue = $this->t_08->CurrentValue;
                    }
                }
            } else {
                $this->t_08->ViewValue = null;
            }

            // t_09
            $curVal = strval($this->t_09->CurrentValue);
            if ($curVal != "") {
                $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
                if ($this->t_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_09->Lookup->renderViewRow($row);
                            $this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
                        }
                    } else {
                        $this->t_09->ViewValue = $this->t_09->CurrentValue;
                    }
                }
            } else {
                $this->t_09->ViewValue = null;
            }

            // t_10
            $curVal = strval($this->t_10->CurrentValue);
            if ($curVal != "") {
                $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
                if ($this->t_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_10->Lookup->renderViewRow($row);
                            $this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
                        }
                    } else {
                        $this->t_10->ViewValue = $this->t_10->CurrentValue;
                    }
                }
            } else {
                $this->t_10->ViewValue = null;
            }

            // t_11
            $this->t_11->ViewValue = $this->t_11->CurrentValue;
            $curVal = strval($this->t_11->CurrentValue);
            if ($curVal != "") {
                $this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->ViewValue = $this->t_11->CurrentValue;
                    }
                }
            } else {
                $this->t_11->ViewValue = null;
            }

            // t_12
            $this->t_12->ViewValue = $this->t_12->CurrentValue;
            $curVal = strval($this->t_12->CurrentValue);
            if ($curVal != "") {
                $this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->ViewValue = $this->t_12->CurrentValue;
                    }
                }
            } else {
                $this->t_12->ViewValue = null;
            }

            // t_13
            $this->t_13->ViewValue = $this->t_13->CurrentValue;

            // t_14
            $this->t_14->ViewValue = $this->t_14->CurrentValue;

            // t_15
            $this->t_15->ViewValue = $this->t_15->CurrentValue;

            // last_price
            $this->last_price->ViewValue = $this->last_price->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // hsn
            $curVal = strval($this->hsn->CurrentValue);
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
                if ($this->hsn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                        $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                    } else {
                        $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                    }
                }
            } else {
                $this->hsn->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // moq
            $this->moq->ViewValue = $this->moq->CurrentValue;
            $this->moq->ViewValue = FormatNumber($this->moq->ViewValue, $this->moq->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // d_head_01
            $this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;

            // d_description_01
            $this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;

            // d_head_02
            $this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;

            // d_description_02
            $this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;

            // publish
            if (strval($this->publish->CurrentValue) != "") {
                $this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
            } else {
                $this->publish->ViewValue = null;
            }

            // keywords
            $this->keywords->ViewValue = $this->keywords->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // video_url
            $this->video_url->ViewValue = $this->video_url->CurrentValue;

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // product_type
            $this->product_type->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // product_n
            $this->product_n->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // set_ref
            $this->set_ref->HrefValue = "";

            // v_00
            $this->v_00->HrefValue = "";

            // v_01
            $this->v_01->HrefValue = "";

            // v_02
            $this->v_02->HrefValue = "";

            // v_03
            $this->v_03->HrefValue = "";

            // v_04
            $this->v_04->HrefValue = "";

            // v_05
            $this->v_05->HrefValue = "";

            // v_06
            $this->v_06->HrefValue = "";

            // v_07
            $this->v_07->HrefValue = "";

            // v_08
            $this->v_08->HrefValue = "";

            // v_09
            $this->v_09->HrefValue = "";

            // v_10
            $this->v_10->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";

            // b_01
            $this->b_01->HrefValue = "";

            // b_02
            $this->b_02->HrefValue = "";

            // b_03
            $this->b_03->HrefValue = "";

            // b_04
            $this->b_04->HrefValue = "";

            // b_05
            $this->b_05->HrefValue = "";

            // b_06
            $this->b_06->HrefValue = "";

            // b_07
            $this->b_07->HrefValue = "";

            // b_08
            $this->b_08->HrefValue = "";

            // b_09
            $this->b_09->HrefValue = "";

            // b_10
            $this->b_10->HrefValue = "";

            // b_11
            $this->b_11->HrefValue = "";

            // b_12
            $this->b_12->HrefValue = "";

            // b_13
            $this->b_13->HrefValue = "";

            // b_14
            $this->b_14->HrefValue = "";

            // b_15
            $this->b_15->HrefValue = "";

            // t_01
            $this->t_01->HrefValue = "";

            // t_02
            $this->t_02->HrefValue = "";

            // t_03
            $this->t_03->HrefValue = "";

            // t_04
            $this->t_04->HrefValue = "";

            // t_05
            $this->t_05->HrefValue = "";

            // t_06
            $this->t_06->HrefValue = "";

            // t_07
            $this->t_07->HrefValue = "";

            // t_08
            $this->t_08->HrefValue = "";

            // t_09
            $this->t_09->HrefValue = "";

            // t_10
            $this->t_10->HrefValue = "";

            // t_11
            $this->t_11->HrefValue = "";

            // t_12
            $this->t_12->HrefValue = "";

            // t_13
            $this->t_13->HrefValue = "";

            // t_14
            $this->t_14->HrefValue = "";

            // t_15
            $this->t_15->HrefValue = "";

            // last_price
            $this->last_price->HrefValue = "";
            $this->last_price->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";

            // hsn
            $this->hsn->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // moq
            $this->moq->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // d_head_01
            $this->d_head_01->HrefValue = "";

            // d_description_01
            $this->d_description_01->HrefValue = "";

            // d_head_02
            $this->d_head_02->HrefValue = "";

            // d_description_02
            $this->d_description_02->HrefValue = "";

            // publish
            $this->publish->HrefValue = "";

            // keywords
            $this->keywords->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // video_url
            $this->video_url->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // company_id
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
                if ($this->company_id->ViewValue == "") {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->company_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->company_id->Lookup->renderViewRow($row);
                        $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->CurrentValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // product_n
            $this->product_n->setupEditAttributes();
            if (!$this->product_n->Raw) {
                $this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
            }
            $this->product_n->EditValue = HtmlEncode($this->product_n->CurrentValue);
            $this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            if (!$this->_barcode->Raw) {
                $this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
            }
            $this->_barcode->EditValue = HtmlEncode($this->_barcode->CurrentValue);
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // product_code_type
            $this->product_code_type->setupEditAttributes();
            $this->product_code_type->EditValue = $this->product_code_type->options(true);
            $this->product_code_type->PlaceHolder = RemoveHtml($this->product_code_type->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            $this->product_code->EditValue = HtmlEncode($this->product_code->CurrentValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // set_ref
            $curVal = trim(strval($this->set_ref->CurrentValue));
            if ($curVal != "") {
                $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
            } else {
                $this->set_ref->ViewValue = $this->set_ref->Lookup !== null && is_array($this->set_ref->lookupOptions()) && count($this->set_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->set_ref->ViewValue !== null) { // Load from cache
                $this->set_ref->EditValue = array_values($this->set_ref->lookupOptions());
                if ($this->set_ref->ViewValue == "") {
                    $this->set_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->set_ref->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->set_ref->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                        $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->set_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->set_ref->EditValue = $arwrk;
            }
            $this->set_ref->PlaceHolder = RemoveHtml($this->set_ref->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->CurrentValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // v_01
            $this->v_01->setupEditAttributes();
            $curVal = trim(strval($this->v_01->CurrentValue));
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
            } else {
                $this->v_01->ViewValue = $this->v_01->Lookup !== null && is_array($this->v_01->lookupOptions()) && count($this->v_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_01->ViewValue !== null) { // Load from cache
                $this->v_01->EditValue = array_values($this->v_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_01->CurrentValue, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_01->EditValue = $arwrk;
            }
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_02
            $this->v_02->setupEditAttributes();
            $curVal = trim(strval($this->v_02->CurrentValue));
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
            } else {
                $this->v_02->ViewValue = $this->v_02->Lookup !== null && is_array($this->v_02->lookupOptions()) && count($this->v_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_02->ViewValue !== null) { // Load from cache
                $this->v_02->EditValue = array_values($this->v_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_02->CurrentValue, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_02->EditValue = $arwrk;
            }
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_03
            $this->v_03->setupEditAttributes();
            $curVal = trim(strval($this->v_03->CurrentValue));
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
            } else {
                $this->v_03->ViewValue = $this->v_03->Lookup !== null && is_array($this->v_03->lookupOptions()) && count($this->v_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_03->ViewValue !== null) { // Load from cache
                $this->v_03->EditValue = array_values($this->v_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_03->CurrentValue, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_03->EditValue = $arwrk;
            }
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_04
            $this->v_04->setupEditAttributes();
            $curVal = trim(strval($this->v_04->CurrentValue));
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
            } else {
                $this->v_04->ViewValue = $this->v_04->Lookup !== null && is_array($this->v_04->lookupOptions()) && count($this->v_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_04->ViewValue !== null) { // Load from cache
                $this->v_04->EditValue = array_values($this->v_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_04->CurrentValue, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_04->EditValue = $arwrk;
            }
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_05
            $this->v_05->setupEditAttributes();
            $curVal = trim(strval($this->v_05->CurrentValue));
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
            } else {
                $this->v_05->ViewValue = $this->v_05->Lookup !== null && is_array($this->v_05->lookupOptions()) && count($this->v_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_05->ViewValue !== null) { // Load from cache
                $this->v_05->EditValue = array_values($this->v_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_05->CurrentValue, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_05->EditValue = $arwrk;
            }
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // v_06
            $this->v_06->setupEditAttributes();
            $curVal = trim(strval($this->v_06->CurrentValue));
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
            } else {
                $this->v_06->ViewValue = $this->v_06->Lookup !== null && is_array($this->v_06->lookupOptions()) && count($this->v_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_06->ViewValue !== null) { // Load from cache
                $this->v_06->EditValue = array_values($this->v_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_06->CurrentValue, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_06->EditValue = $arwrk;
            }
            $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

            // v_07
            $this->v_07->setupEditAttributes();
            $curVal = trim(strval($this->v_07->CurrentValue));
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
            } else {
                $this->v_07->ViewValue = $this->v_07->Lookup !== null && is_array($this->v_07->lookupOptions()) && count($this->v_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_07->ViewValue !== null) { // Load from cache
                $this->v_07->EditValue = array_values($this->v_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_07->CurrentValue, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_07->EditValue = $arwrk;
            }
            $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

            // v_08
            $this->v_08->setupEditAttributes();
            $curVal = trim(strval($this->v_08->CurrentValue));
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
            } else {
                $this->v_08->ViewValue = $this->v_08->Lookup !== null && is_array($this->v_08->lookupOptions()) && count($this->v_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_08->ViewValue !== null) { // Load from cache
                $this->v_08->EditValue = array_values($this->v_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_08->CurrentValue, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_08->EditValue = $arwrk;
            }
            $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

            // v_09
            $this->v_09->setupEditAttributes();
            $curVal = trim(strval($this->v_09->CurrentValue));
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
            } else {
                $this->v_09->ViewValue = $this->v_09->Lookup !== null && is_array($this->v_09->lookupOptions()) && count($this->v_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_09->ViewValue !== null) { // Load from cache
                $this->v_09->EditValue = array_values($this->v_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_09->CurrentValue, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_09->EditValue = $arwrk;
            }
            $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

            // v_10
            $this->v_10->setupEditAttributes();
            $curVal = trim(strval($this->v_10->CurrentValue));
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
            } else {
                $this->v_10->ViewValue = $this->v_10->Lookup !== null && is_array($this->v_10->lookupOptions()) && count($this->v_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_10->ViewValue !== null) { // Load from cache
                $this->v_10->EditValue = array_values($this->v_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_10->CurrentValue, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_10->EditValue = $arwrk;
            }
            $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditValue = $this->cbm->CurrentValue;
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
            if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
                $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
            }

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
                $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
            }

            // shape
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            $this->q_sku->EditValue = $this->q_sku->CurrentValue;
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
            if (strval($this->q_sku->EditValue) != "" && is_numeric($this->q_sku->EditValue)) {
                $this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, null);
            }

            // b_01
            $this->b_01->setupEditAttributes();
            if (!$this->b_01->Raw) {
                $this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
            }
            $this->b_01->EditValue = HtmlEncode($this->b_01->CurrentValue);
            $this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

            // b_02
            $this->b_02->setupEditAttributes();
            if (!$this->b_02->Raw) {
                $this->b_02->CurrentValue = HtmlDecode($this->b_02->CurrentValue);
            }
            $this->b_02->EditValue = HtmlEncode($this->b_02->CurrentValue);
            $this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

            // b_03
            $curVal = trim(strval($this->b_03->CurrentValue));
            if ($curVal != "") {
                $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
            } else {
                $this->b_03->ViewValue = $this->b_03->Lookup !== null && is_array($this->b_03->lookupOptions()) && count($this->b_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_03->ViewValue !== null) { // Load from cache
                $this->b_03->EditValue = array_values($this->b_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_03->EditValue = $arwrk;
            }
            $this->b_03->PlaceHolder = RemoveHtml($this->b_03->caption());

            // b_04
            $curVal = trim(strval($this->b_04->CurrentValue));
            if ($curVal != "") {
                $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
            } else {
                $this->b_04->ViewValue = $this->b_04->Lookup !== null && is_array($this->b_04->lookupOptions()) && count($this->b_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_04->ViewValue !== null) { // Load from cache
                $this->b_04->EditValue = array_values($this->b_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_04->EditValue = $arwrk;
            }
            $this->b_04->PlaceHolder = RemoveHtml($this->b_04->caption());

            // b_05
            $curVal = trim(strval($this->b_05->CurrentValue));
            if ($curVal != "") {
                $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
            } else {
                $this->b_05->ViewValue = $this->b_05->Lookup !== null && is_array($this->b_05->lookupOptions()) && count($this->b_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_05->ViewValue !== null) { // Load from cache
                $this->b_05->EditValue = array_values($this->b_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_05->EditValue = $arwrk;
            }
            $this->b_05->PlaceHolder = RemoveHtml($this->b_05->caption());

            // b_06
            $curVal = trim(strval($this->b_06->CurrentValue));
            if ($curVal != "") {
                $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
            } else {
                $this->b_06->ViewValue = $this->b_06->Lookup !== null && is_array($this->b_06->lookupOptions()) && count($this->b_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_06->ViewValue !== null) { // Load from cache
                $this->b_06->EditValue = array_values($this->b_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_06->EditValue = $arwrk;
            }
            $this->b_06->PlaceHolder = RemoveHtml($this->b_06->caption());

            // b_07
            $curVal = trim(strval($this->b_07->CurrentValue));
            if ($curVal != "") {
                $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
            } else {
                $this->b_07->ViewValue = $this->b_07->Lookup !== null && is_array($this->b_07->lookupOptions()) && count($this->b_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_07->ViewValue !== null) { // Load from cache
                $this->b_07->EditValue = array_values($this->b_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_07->EditValue = $arwrk;
            }
            $this->b_07->PlaceHolder = RemoveHtml($this->b_07->caption());

            // b_08
            $curVal = trim(strval($this->b_08->CurrentValue));
            if ($curVal != "") {
                $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
            } else {
                $this->b_08->ViewValue = $this->b_08->Lookup !== null && is_array($this->b_08->lookupOptions()) && count($this->b_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_08->ViewValue !== null) { // Load from cache
                $this->b_08->EditValue = array_values($this->b_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_08->EditValue = $arwrk;
            }
            $this->b_08->PlaceHolder = RemoveHtml($this->b_08->caption());

            // b_09
            $curVal = trim(strval($this->b_09->CurrentValue));
            if ($curVal != "") {
                $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
            } else {
                $this->b_09->ViewValue = $this->b_09->Lookup !== null && is_array($this->b_09->lookupOptions()) && count($this->b_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_09->ViewValue !== null) { // Load from cache
                $this->b_09->EditValue = array_values($this->b_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_09->EditValue = $arwrk;
            }
            $this->b_09->PlaceHolder = RemoveHtml($this->b_09->caption());

            // b_10
            $curVal = trim(strval($this->b_10->CurrentValue));
            if ($curVal != "") {
                $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
            } else {
                $this->b_10->ViewValue = $this->b_10->Lookup !== null && is_array($this->b_10->lookupOptions()) && count($this->b_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_10->ViewValue !== null) { // Load from cache
                $this->b_10->EditValue = array_values($this->b_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_10->EditValue = $arwrk;
            }
            $this->b_10->PlaceHolder = RemoveHtml($this->b_10->caption());

            // b_11
            $this->b_11->setupEditAttributes();
            if (!$this->b_11->Raw) {
                $this->b_11->CurrentValue = HtmlDecode($this->b_11->CurrentValue);
            }
            $this->b_11->EditValue = HtmlEncode($this->b_11->CurrentValue);
            $this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

            // b_12
            $this->b_12->setupEditAttributes();
            if (!$this->b_12->Raw) {
                $this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
            }
            $this->b_12->EditValue = HtmlEncode($this->b_12->CurrentValue);
            $this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

            // b_13
            $this->b_13->setupEditAttributes();
            if (!$this->b_13->Raw) {
                $this->b_13->CurrentValue = HtmlDecode($this->b_13->CurrentValue);
            }
            $this->b_13->EditValue = HtmlEncode($this->b_13->CurrentValue);
            $this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

            // b_14
            $this->b_14->setupEditAttributes();
            if (!$this->b_14->Raw) {
                $this->b_14->CurrentValue = HtmlDecode($this->b_14->CurrentValue);
            }
            $this->b_14->EditValue = HtmlEncode($this->b_14->CurrentValue);
            $this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

            // b_15
            $this->b_15->setupEditAttributes();
            if (!$this->b_15->Raw) {
                $this->b_15->CurrentValue = HtmlDecode($this->b_15->CurrentValue);
            }
            $this->b_15->EditValue = HtmlEncode($this->b_15->CurrentValue);
            $this->b_15->PlaceHolder = RemoveHtml($this->b_15->caption());

            // t_01
            $this->t_01->setupEditAttributes();
            if (!$this->t_01->Raw) {
                $this->t_01->CurrentValue = HtmlDecode($this->t_01->CurrentValue);
            }
            $this->t_01->EditValue = HtmlEncode($this->t_01->CurrentValue);
            $this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

            // t_02
            $this->t_02->setupEditAttributes();
            if (!$this->t_02->Raw) {
                $this->t_02->CurrentValue = HtmlDecode($this->t_02->CurrentValue);
            }
            $this->t_02->EditValue = HtmlEncode($this->t_02->CurrentValue);
            $this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

            // t_03
            $curVal = trim(strval($this->t_03->CurrentValue));
            if ($curVal != "") {
                $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
            } else {
                $this->t_03->ViewValue = $this->t_03->Lookup !== null && is_array($this->t_03->lookupOptions()) && count($this->t_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_03->ViewValue !== null) { // Load from cache
                $this->t_03->EditValue = array_values($this->t_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_03->EditValue = $arwrk;
            }
            $this->t_03->PlaceHolder = RemoveHtml($this->t_03->caption());

            // t_04
            $curVal = trim(strval($this->t_04->CurrentValue));
            if ($curVal != "") {
                $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
            } else {
                $this->t_04->ViewValue = $this->t_04->Lookup !== null && is_array($this->t_04->lookupOptions()) && count($this->t_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_04->ViewValue !== null) { // Load from cache
                $this->t_04->EditValue = array_values($this->t_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_04->EditValue = $arwrk;
            }
            $this->t_04->PlaceHolder = RemoveHtml($this->t_04->caption());

            // t_05
            $curVal = trim(strval($this->t_05->CurrentValue));
            if ($curVal != "") {
                $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
            } else {
                $this->t_05->ViewValue = $this->t_05->Lookup !== null && is_array($this->t_05->lookupOptions()) && count($this->t_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_05->ViewValue !== null) { // Load from cache
                $this->t_05->EditValue = array_values($this->t_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_05->EditValue = $arwrk;
            }
            $this->t_05->PlaceHolder = RemoveHtml($this->t_05->caption());

            // t_06
            $curVal = trim(strval($this->t_06->CurrentValue));
            if ($curVal != "") {
                $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
            } else {
                $this->t_06->ViewValue = $this->t_06->Lookup !== null && is_array($this->t_06->lookupOptions()) && count($this->t_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_06->ViewValue !== null) { // Load from cache
                $this->t_06->EditValue = array_values($this->t_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_06->EditValue = $arwrk;
            }
            $this->t_06->PlaceHolder = RemoveHtml($this->t_06->caption());

            // t_07
            $curVal = trim(strval($this->t_07->CurrentValue));
            if ($curVal != "") {
                $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
            } else {
                $this->t_07->ViewValue = $this->t_07->Lookup !== null && is_array($this->t_07->lookupOptions()) && count($this->t_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_07->ViewValue !== null) { // Load from cache
                $this->t_07->EditValue = array_values($this->t_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_07->EditValue = $arwrk;
            }
            $this->t_07->PlaceHolder = RemoveHtml($this->t_07->caption());

            // t_08
            $curVal = trim(strval($this->t_08->CurrentValue));
            if ($curVal != "") {
                $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
            } else {
                $this->t_08->ViewValue = $this->t_08->Lookup !== null && is_array($this->t_08->lookupOptions()) && count($this->t_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_08->ViewValue !== null) { // Load from cache
                $this->t_08->EditValue = array_values($this->t_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_08->EditValue = $arwrk;
            }
            $this->t_08->PlaceHolder = RemoveHtml($this->t_08->caption());

            // t_09
            $curVal = trim(strval($this->t_09->CurrentValue));
            if ($curVal != "") {
                $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
            } else {
                $this->t_09->ViewValue = $this->t_09->Lookup !== null && is_array($this->t_09->lookupOptions()) && count($this->t_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_09->ViewValue !== null) { // Load from cache
                $this->t_09->EditValue = array_values($this->t_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_09->EditValue = $arwrk;
            }
            $this->t_09->PlaceHolder = RemoveHtml($this->t_09->caption());

            // t_10
            $curVal = trim(strval($this->t_10->CurrentValue));
            if ($curVal != "") {
                $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
            } else {
                $this->t_10->ViewValue = $this->t_10->Lookup !== null && is_array($this->t_10->lookupOptions()) && count($this->t_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_10->ViewValue !== null) { // Load from cache
                $this->t_10->EditValue = array_values($this->t_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_10->EditValue = $arwrk;
            }
            $this->t_10->PlaceHolder = RemoveHtml($this->t_10->caption());

            // t_11
            $this->t_11->setupEditAttributes();
            if (!$this->t_11->Raw) {
                $this->t_11->CurrentValue = HtmlDecode($this->t_11->CurrentValue);
            }
            $this->t_11->EditValue = HtmlEncode($this->t_11->CurrentValue);
            $curVal = strval($this->t_11->CurrentValue);
            if ($curVal != "") {
                $this->t_11->EditValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->EditValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->EditValue = HtmlEncode($this->t_11->CurrentValue);
                    }
                }
            } else {
                $this->t_11->EditValue = null;
            }
            $this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

            // t_12
            $this->t_12->setupEditAttributes();
            if (!$this->t_12->Raw) {
                $this->t_12->CurrentValue = HtmlDecode($this->t_12->CurrentValue);
            }
            $this->t_12->EditValue = HtmlEncode($this->t_12->CurrentValue);
            $curVal = strval($this->t_12->CurrentValue);
            if ($curVal != "") {
                $this->t_12->EditValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->EditValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->EditValue = HtmlEncode($this->t_12->CurrentValue);
                    }
                }
            } else {
                $this->t_12->EditValue = null;
            }
            $this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

            // t_13
            $this->t_13->setupEditAttributes();
            if (!$this->t_13->Raw) {
                $this->t_13->CurrentValue = HtmlDecode($this->t_13->CurrentValue);
            }
            $this->t_13->EditValue = HtmlEncode($this->t_13->CurrentValue);
            $this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

            // t_14
            $this->t_14->setupEditAttributes();
            if (!$this->t_14->Raw) {
                $this->t_14->CurrentValue = HtmlDecode($this->t_14->CurrentValue);
            }
            $this->t_14->EditValue = HtmlEncode($this->t_14->CurrentValue);
            $this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

            // t_15
            $this->t_15->setupEditAttributes();
            if (!$this->t_15->Raw) {
                $this->t_15->CurrentValue = HtmlDecode($this->t_15->CurrentValue);
            }
            $this->t_15->EditValue = HtmlEncode($this->t_15->CurrentValue);
            $this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

            // last_price
            $this->last_price->setupEditAttributes();
            $this->last_price->EditValue = $this->last_price->CurrentValue;

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // hsn
            $this->hsn->setupEditAttributes();
            $curVal = trim(strval($this->hsn->CurrentValue));
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
            } else {
                $this->hsn->ViewValue = $this->hsn->Lookup !== null && is_array($this->hsn->lookupOptions()) && count($this->hsn->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->hsn->ViewValue !== null) { // Load from cache
                $this->hsn->EditValue = array_values($this->hsn->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->hsn->CurrentValue, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                $sqlWrk = $this->hsn->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->hsn->Lookup->renderViewRow($row);
                }
                $this->hsn->EditValue = $arwrk;
            }
            $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

            // composition
            $this->composition->setupEditAttributes();
            $curVal = trim(strval($this->composition->CurrentValue));
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
            } else {
                $this->composition->ViewValue = $this->composition->Lookup !== null && is_array($this->composition->lookupOptions()) && count($this->composition->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->composition->ViewValue !== null) { // Load from cache
                $this->composition->EditValue = array_values($this->composition->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->composition->CurrentValue, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->composition->EditValue = $arwrk;
            }
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // moq
            $this->moq->setupEditAttributes();
            $this->moq->EditValue = $this->moq->CurrentValue;
            $this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
            if (strval($this->moq->EditValue) != "" && is_numeric($this->moq->EditValue)) {
                $this->moq->EditValue = FormatNumber($this->moq->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // d_head_01
            $this->d_head_01->setupEditAttributes();
            if (!$this->d_head_01->Raw) {
                $this->d_head_01->CurrentValue = HtmlDecode($this->d_head_01->CurrentValue);
            }
            $this->d_head_01->EditValue = HtmlEncode($this->d_head_01->CurrentValue);
            $this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

            // d_description_01
            $this->d_description_01->setupEditAttributes();
            $this->d_description_01->EditValue = HtmlEncode($this->d_description_01->CurrentValue);
            $this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

            // d_head_02
            $this->d_head_02->setupEditAttributes();
            if (!$this->d_head_02->Raw) {
                $this->d_head_02->CurrentValue = HtmlDecode($this->d_head_02->CurrentValue);
            }
            $this->d_head_02->EditValue = HtmlEncode($this->d_head_02->CurrentValue);
            $this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

            // d_description_02
            $this->d_description_02->setupEditAttributes();
            $this->d_description_02->EditValue = HtmlEncode($this->d_description_02->CurrentValue);
            $this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

            // publish
            $this->publish->setupEditAttributes();
            $this->publish->EditValue = $this->publish->options(true);
            $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());

            // keywords
            $this->keywords->setupEditAttributes();
            $this->keywords->EditValue = HtmlEncode($this->keywords->CurrentValue);
            $this->keywords->PlaceHolder = RemoveHtml($this->keywords->caption());

            // operator

            // datetime

            // video_url
            $this->video_url->setupEditAttributes();
            if (!$this->video_url->Raw) {
                $this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
            }
            $this->video_url->EditValue = HtmlEncode($this->video_url->CurrentValue);
            $this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // product_type
            $this->product_type->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // product_n
            $this->product_n->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // set_ref
            $this->set_ref->HrefValue = "";

            // v_00
            $this->v_00->HrefValue = "";

            // v_01
            $this->v_01->HrefValue = "";

            // v_02
            $this->v_02->HrefValue = "";

            // v_03
            $this->v_03->HrefValue = "";

            // v_04
            $this->v_04->HrefValue = "";

            // v_05
            $this->v_05->HrefValue = "";

            // v_06
            $this->v_06->HrefValue = "";

            // v_07
            $this->v_07->HrefValue = "";

            // v_08
            $this->v_08->HrefValue = "";

            // v_09
            $this->v_09->HrefValue = "";

            // v_10
            $this->v_10->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";

            // b_01
            $this->b_01->HrefValue = "";

            // b_02
            $this->b_02->HrefValue = "";

            // b_03
            $this->b_03->HrefValue = "";

            // b_04
            $this->b_04->HrefValue = "";

            // b_05
            $this->b_05->HrefValue = "";

            // b_06
            $this->b_06->HrefValue = "";

            // b_07
            $this->b_07->HrefValue = "";

            // b_08
            $this->b_08->HrefValue = "";

            // b_09
            $this->b_09->HrefValue = "";

            // b_10
            $this->b_10->HrefValue = "";

            // b_11
            $this->b_11->HrefValue = "";

            // b_12
            $this->b_12->HrefValue = "";

            // b_13
            $this->b_13->HrefValue = "";

            // b_14
            $this->b_14->HrefValue = "";

            // b_15
            $this->b_15->HrefValue = "";

            // t_01
            $this->t_01->HrefValue = "";

            // t_02
            $this->t_02->HrefValue = "";

            // t_03
            $this->t_03->HrefValue = "";

            // t_04
            $this->t_04->HrefValue = "";

            // t_05
            $this->t_05->HrefValue = "";

            // t_06
            $this->t_06->HrefValue = "";

            // t_07
            $this->t_07->HrefValue = "";

            // t_08
            $this->t_08->HrefValue = "";

            // t_09
            $this->t_09->HrefValue = "";

            // t_10
            $this->t_10->HrefValue = "";

            // t_11
            $this->t_11->HrefValue = "";

            // t_12
            $this->t_12->HrefValue = "";

            // t_13
            $this->t_13->HrefValue = "";

            // t_14
            $this->t_14->HrefValue = "";

            // t_15
            $this->t_15->HrefValue = "";

            // last_price
            $this->last_price->HrefValue = "";
            $this->last_price->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";

            // hsn
            $this->hsn->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // moq
            $this->moq->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // d_head_01
            $this->d_head_01->HrefValue = "";

            // d_description_01
            $this->d_description_01->HrefValue = "";

            // d_head_02
            $this->d_head_02->HrefValue = "";

            // d_description_02
            $this->d_description_02->HrefValue = "";

            // publish
            $this->publish->HrefValue = "";

            // keywords
            $this->keywords->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // video_url
            $this->video_url->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if ($this->company_id->FormValue == "") {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->product_n->Visible && $this->product_n->Required) {
                if (!$this->product_n->IsDetailKey && EmptyValue($this->product_n->FormValue)) {
                    $this->product_n->addErrorMessage(str_replace("%s", $this->product_n->caption(), $this->product_n->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->product_code_type->Visible && $this->product_code_type->Required) {
                if (!$this->product_code_type->IsDetailKey && EmptyValue($this->product_code_type->FormValue)) {
                    $this->product_code_type->addErrorMessage(str_replace("%s", $this->product_code_type->caption(), $this->product_code_type->RequiredErrorMessage));
                }
            }
            if ($this->product_code->Visible && $this->product_code->Required) {
                if (!$this->product_code->IsDetailKey && EmptyValue($this->product_code->FormValue)) {
                    $this->product_code->addErrorMessage(str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
                }
            }
            if ($this->set_ref->Visible && $this->set_ref->Required) {
                if ($this->set_ref->FormValue == "") {
                    $this->set_ref->addErrorMessage(str_replace("%s", $this->set_ref->caption(), $this->set_ref->RequiredErrorMessage));
                }
            }
            if ($this->v_00->Visible && $this->v_00->Required) {
                if (!$this->v_00->IsDetailKey && EmptyValue($this->v_00->FormValue)) {
                    $this->v_00->addErrorMessage(str_replace("%s", $this->v_00->caption(), $this->v_00->RequiredErrorMessage));
                }
            }
            if ($this->v_01->Visible && $this->v_01->Required) {
                if (!$this->v_01->IsDetailKey && EmptyValue($this->v_01->FormValue)) {
                    $this->v_01->addErrorMessage(str_replace("%s", $this->v_01->caption(), $this->v_01->RequiredErrorMessage));
                }
            }
            if ($this->v_02->Visible && $this->v_02->Required) {
                if (!$this->v_02->IsDetailKey && EmptyValue($this->v_02->FormValue)) {
                    $this->v_02->addErrorMessage(str_replace("%s", $this->v_02->caption(), $this->v_02->RequiredErrorMessage));
                }
            }
            if ($this->v_03->Visible && $this->v_03->Required) {
                if (!$this->v_03->IsDetailKey && EmptyValue($this->v_03->FormValue)) {
                    $this->v_03->addErrorMessage(str_replace("%s", $this->v_03->caption(), $this->v_03->RequiredErrorMessage));
                }
            }
            if ($this->v_04->Visible && $this->v_04->Required) {
                if (!$this->v_04->IsDetailKey && EmptyValue($this->v_04->FormValue)) {
                    $this->v_04->addErrorMessage(str_replace("%s", $this->v_04->caption(), $this->v_04->RequiredErrorMessage));
                }
            }
            if ($this->v_05->Visible && $this->v_05->Required) {
                if (!$this->v_05->IsDetailKey && EmptyValue($this->v_05->FormValue)) {
                    $this->v_05->addErrorMessage(str_replace("%s", $this->v_05->caption(), $this->v_05->RequiredErrorMessage));
                }
            }
            if ($this->v_06->Visible && $this->v_06->Required) {
                if (!$this->v_06->IsDetailKey && EmptyValue($this->v_06->FormValue)) {
                    $this->v_06->addErrorMessage(str_replace("%s", $this->v_06->caption(), $this->v_06->RequiredErrorMessage));
                }
            }
            if ($this->v_07->Visible && $this->v_07->Required) {
                if (!$this->v_07->IsDetailKey && EmptyValue($this->v_07->FormValue)) {
                    $this->v_07->addErrorMessage(str_replace("%s", $this->v_07->caption(), $this->v_07->RequiredErrorMessage));
                }
            }
            if ($this->v_08->Visible && $this->v_08->Required) {
                if (!$this->v_08->IsDetailKey && EmptyValue($this->v_08->FormValue)) {
                    $this->v_08->addErrorMessage(str_replace("%s", $this->v_08->caption(), $this->v_08->RequiredErrorMessage));
                }
            }
            if ($this->v_09->Visible && $this->v_09->Required) {
                if (!$this->v_09->IsDetailKey && EmptyValue($this->v_09->FormValue)) {
                    $this->v_09->addErrorMessage(str_replace("%s", $this->v_09->caption(), $this->v_09->RequiredErrorMessage));
                }
            }
            if ($this->v_10->Visible && $this->v_10->Required) {
                if (!$this->v_10->IsDetailKey && EmptyValue($this->v_10->FormValue)) {
                    $this->v_10->addErrorMessage(str_replace("%s", $this->v_10->caption(), $this->v_10->RequiredErrorMessage));
                }
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if (!$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if ($this->shape->FormValue == "") {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->q_sku->Visible && $this->q_sku->Required) {
                if (!$this->q_sku->IsDetailKey && EmptyValue($this->q_sku->FormValue)) {
                    $this->q_sku->addErrorMessage(str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->q_sku->FormValue)) {
                $this->q_sku->addErrorMessage($this->q_sku->getErrorMessage(false));
            }
            if ($this->b_01->Visible && $this->b_01->Required) {
                if (!$this->b_01->IsDetailKey && EmptyValue($this->b_01->FormValue)) {
                    $this->b_01->addErrorMessage(str_replace("%s", $this->b_01->caption(), $this->b_01->RequiredErrorMessage));
                }
            }
            if ($this->b_02->Visible && $this->b_02->Required) {
                if (!$this->b_02->IsDetailKey && EmptyValue($this->b_02->FormValue)) {
                    $this->b_02->addErrorMessage(str_replace("%s", $this->b_02->caption(), $this->b_02->RequiredErrorMessage));
                }
            }
            if ($this->b_03->Visible && $this->b_03->Required) {
                if ($this->b_03->FormValue == "") {
                    $this->b_03->addErrorMessage(str_replace("%s", $this->b_03->caption(), $this->b_03->RequiredErrorMessage));
                }
            }
            if ($this->b_04->Visible && $this->b_04->Required) {
                if ($this->b_04->FormValue == "") {
                    $this->b_04->addErrorMessage(str_replace("%s", $this->b_04->caption(), $this->b_04->RequiredErrorMessage));
                }
            }
            if ($this->b_05->Visible && $this->b_05->Required) {
                if ($this->b_05->FormValue == "") {
                    $this->b_05->addErrorMessage(str_replace("%s", $this->b_05->caption(), $this->b_05->RequiredErrorMessage));
                }
            }
            if ($this->b_06->Visible && $this->b_06->Required) {
                if ($this->b_06->FormValue == "") {
                    $this->b_06->addErrorMessage(str_replace("%s", $this->b_06->caption(), $this->b_06->RequiredErrorMessage));
                }
            }
            if ($this->b_07->Visible && $this->b_07->Required) {
                if ($this->b_07->FormValue == "") {
                    $this->b_07->addErrorMessage(str_replace("%s", $this->b_07->caption(), $this->b_07->RequiredErrorMessage));
                }
            }
            if ($this->b_08->Visible && $this->b_08->Required) {
                if ($this->b_08->FormValue == "") {
                    $this->b_08->addErrorMessage(str_replace("%s", $this->b_08->caption(), $this->b_08->RequiredErrorMessage));
                }
            }
            if ($this->b_09->Visible && $this->b_09->Required) {
                if ($this->b_09->FormValue == "") {
                    $this->b_09->addErrorMessage(str_replace("%s", $this->b_09->caption(), $this->b_09->RequiredErrorMessage));
                }
            }
            if ($this->b_10->Visible && $this->b_10->Required) {
                if ($this->b_10->FormValue == "") {
                    $this->b_10->addErrorMessage(str_replace("%s", $this->b_10->caption(), $this->b_10->RequiredErrorMessage));
                }
            }
            if ($this->b_11->Visible && $this->b_11->Required) {
                if (!$this->b_11->IsDetailKey && EmptyValue($this->b_11->FormValue)) {
                    $this->b_11->addErrorMessage(str_replace("%s", $this->b_11->caption(), $this->b_11->RequiredErrorMessage));
                }
            }
            if ($this->b_12->Visible && $this->b_12->Required) {
                if (!$this->b_12->IsDetailKey && EmptyValue($this->b_12->FormValue)) {
                    $this->b_12->addErrorMessage(str_replace("%s", $this->b_12->caption(), $this->b_12->RequiredErrorMessage));
                }
            }
            if ($this->b_13->Visible && $this->b_13->Required) {
                if (!$this->b_13->IsDetailKey && EmptyValue($this->b_13->FormValue)) {
                    $this->b_13->addErrorMessage(str_replace("%s", $this->b_13->caption(), $this->b_13->RequiredErrorMessage));
                }
            }
            if ($this->b_14->Visible && $this->b_14->Required) {
                if (!$this->b_14->IsDetailKey && EmptyValue($this->b_14->FormValue)) {
                    $this->b_14->addErrorMessage(str_replace("%s", $this->b_14->caption(), $this->b_14->RequiredErrorMessage));
                }
            }
            if ($this->b_15->Visible && $this->b_15->Required) {
                if (!$this->b_15->IsDetailKey && EmptyValue($this->b_15->FormValue)) {
                    $this->b_15->addErrorMessage(str_replace("%s", $this->b_15->caption(), $this->b_15->RequiredErrorMessage));
                }
            }
            if ($this->t_01->Visible && $this->t_01->Required) {
                if (!$this->t_01->IsDetailKey && EmptyValue($this->t_01->FormValue)) {
                    $this->t_01->addErrorMessage(str_replace("%s", $this->t_01->caption(), $this->t_01->RequiredErrorMessage));
                }
            }
            if ($this->t_02->Visible && $this->t_02->Required) {
                if (!$this->t_02->IsDetailKey && EmptyValue($this->t_02->FormValue)) {
                    $this->t_02->addErrorMessage(str_replace("%s", $this->t_02->caption(), $this->t_02->RequiredErrorMessage));
                }
            }
            if ($this->t_03->Visible && $this->t_03->Required) {
                if ($this->t_03->FormValue == "") {
                    $this->t_03->addErrorMessage(str_replace("%s", $this->t_03->caption(), $this->t_03->RequiredErrorMessage));
                }
            }
            if ($this->t_04->Visible && $this->t_04->Required) {
                if ($this->t_04->FormValue == "") {
                    $this->t_04->addErrorMessage(str_replace("%s", $this->t_04->caption(), $this->t_04->RequiredErrorMessage));
                }
            }
            if ($this->t_05->Visible && $this->t_05->Required) {
                if ($this->t_05->FormValue == "") {
                    $this->t_05->addErrorMessage(str_replace("%s", $this->t_05->caption(), $this->t_05->RequiredErrorMessage));
                }
            }
            if ($this->t_06->Visible && $this->t_06->Required) {
                if ($this->t_06->FormValue == "") {
                    $this->t_06->addErrorMessage(str_replace("%s", $this->t_06->caption(), $this->t_06->RequiredErrorMessage));
                }
            }
            if ($this->t_07->Visible && $this->t_07->Required) {
                if ($this->t_07->FormValue == "") {
                    $this->t_07->addErrorMessage(str_replace("%s", $this->t_07->caption(), $this->t_07->RequiredErrorMessage));
                }
            }
            if ($this->t_08->Visible && $this->t_08->Required) {
                if ($this->t_08->FormValue == "") {
                    $this->t_08->addErrorMessage(str_replace("%s", $this->t_08->caption(), $this->t_08->RequiredErrorMessage));
                }
            }
            if ($this->t_09->Visible && $this->t_09->Required) {
                if ($this->t_09->FormValue == "") {
                    $this->t_09->addErrorMessage(str_replace("%s", $this->t_09->caption(), $this->t_09->RequiredErrorMessage));
                }
            }
            if ($this->t_10->Visible && $this->t_10->Required) {
                if ($this->t_10->FormValue == "") {
                    $this->t_10->addErrorMessage(str_replace("%s", $this->t_10->caption(), $this->t_10->RequiredErrorMessage));
                }
            }
            if ($this->t_11->Visible && $this->t_11->Required) {
                if (!$this->t_11->IsDetailKey && EmptyValue($this->t_11->FormValue)) {
                    $this->t_11->addErrorMessage(str_replace("%s", $this->t_11->caption(), $this->t_11->RequiredErrorMessage));
                }
            }
            if ($this->t_12->Visible && $this->t_12->Required) {
                if (!$this->t_12->IsDetailKey && EmptyValue($this->t_12->FormValue)) {
                    $this->t_12->addErrorMessage(str_replace("%s", $this->t_12->caption(), $this->t_12->RequiredErrorMessage));
                }
            }
            if ($this->t_13->Visible && $this->t_13->Required) {
                if (!$this->t_13->IsDetailKey && EmptyValue($this->t_13->FormValue)) {
                    $this->t_13->addErrorMessage(str_replace("%s", $this->t_13->caption(), $this->t_13->RequiredErrorMessage));
                }
            }
            if ($this->t_14->Visible && $this->t_14->Required) {
                if (!$this->t_14->IsDetailKey && EmptyValue($this->t_14->FormValue)) {
                    $this->t_14->addErrorMessage(str_replace("%s", $this->t_14->caption(), $this->t_14->RequiredErrorMessage));
                }
            }
            if ($this->t_15->Visible && $this->t_15->Required) {
                if (!$this->t_15->IsDetailKey && EmptyValue($this->t_15->FormValue)) {
                    $this->t_15->addErrorMessage(str_replace("%s", $this->t_15->caption(), $this->t_15->RequiredErrorMessage));
                }
            }
            if ($this->last_price->Visible && $this->last_price->Required) {
                if (!$this->last_price->IsDetailKey && EmptyValue($this->last_price->FormValue)) {
                    $this->last_price->addErrorMessage(str_replace("%s", $this->last_price->caption(), $this->last_price->RequiredErrorMessage));
                }
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->hsn->Visible && $this->hsn->Required) {
                if (!$this->hsn->IsDetailKey && EmptyValue($this->hsn->FormValue)) {
                    $this->hsn->addErrorMessage(str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
                }
            }
            if ($this->composition->Visible && $this->composition->Required) {
                if (!$this->composition->IsDetailKey && EmptyValue($this->composition->FormValue)) {
                    $this->composition->addErrorMessage(str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->moq->Visible && $this->moq->Required) {
                if (!$this->moq->IsDetailKey && EmptyValue($this->moq->FormValue)) {
                    $this->moq->addErrorMessage(str_replace("%s", $this->moq->caption(), $this->moq->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->moq->FormValue)) {
                $this->moq->addErrorMessage($this->moq->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->d_head_01->Visible && $this->d_head_01->Required) {
                if (!$this->d_head_01->IsDetailKey && EmptyValue($this->d_head_01->FormValue)) {
                    $this->d_head_01->addErrorMessage(str_replace("%s", $this->d_head_01->caption(), $this->d_head_01->RequiredErrorMessage));
                }
            }
            if ($this->d_description_01->Visible && $this->d_description_01->Required) {
                if (!$this->d_description_01->IsDetailKey && EmptyValue($this->d_description_01->FormValue)) {
                    $this->d_description_01->addErrorMessage(str_replace("%s", $this->d_description_01->caption(), $this->d_description_01->RequiredErrorMessage));
                }
            }
            if ($this->d_head_02->Visible && $this->d_head_02->Required) {
                if (!$this->d_head_02->IsDetailKey && EmptyValue($this->d_head_02->FormValue)) {
                    $this->d_head_02->addErrorMessage(str_replace("%s", $this->d_head_02->caption(), $this->d_head_02->RequiredErrorMessage));
                }
            }
            if ($this->d_description_02->Visible && $this->d_description_02->Required) {
                if (!$this->d_description_02->IsDetailKey && EmptyValue($this->d_description_02->FormValue)) {
                    $this->d_description_02->addErrorMessage(str_replace("%s", $this->d_description_02->caption(), $this->d_description_02->RequiredErrorMessage));
                }
            }
            if ($this->publish->Visible && $this->publish->Required) {
                if (!$this->publish->IsDetailKey && EmptyValue($this->publish->FormValue)) {
                    $this->publish->addErrorMessage(str_replace("%s", $this->publish->caption(), $this->publish->RequiredErrorMessage));
                }
            }
            if ($this->keywords->Visible && $this->keywords->Required) {
                if (!$this->keywords->IsDetailKey && EmptyValue($this->keywords->FormValue)) {
                    $this->keywords->addErrorMessage(str_replace("%s", $this->keywords->caption(), $this->keywords->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->video_url->Visible && $this->video_url->Required) {
                if (!$this->video_url->IsDetailKey && EmptyValue($this->video_url->FormValue)) {
                    $this->video_url->addErrorMessage(str_replace("%s", $this->video_url->caption(), $this->video_url->RequiredErrorMessage));
                }
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("MultiplePriceGrid");
        if (in_array("multiple_price", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("PartnerProductRefGrid");
        if (in_array("partner_product_ref", $detailTblVar) && $detailPage->DetailEdit) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Check field with unique index (product_code)
        if ($this->product_code->CurrentValue != "") {
            $filterChk = "(`product_code` = '" . AdjustSql($this->product_code->CurrentValue, $this->Dbid) . "')";
            $filterChk .= " AND NOT (" . $filter . ")";
            $this->CurrentFilter = $filterChk;
            $sqlChk = $this->getCurrentSql();
            $rsChk = $conn->executeQuery($sqlChk);
            if (!$rsChk) {
                return false;
            }
            if ($rsChk->fetch()) {
                $idxErrMsg = str_replace("%f", $this->product_code->caption(), $Language->phrase("DupIndex"));
                $idxErrMsg = str_replace("%v", $this->product_code->CurrentValue, $idxErrMsg);
                $this->setFailureMessage($idxErrMsg);
                return false;
            }
        }

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }

            // Update detail records
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("MultiplePriceGrid");
            if (in_array("multiple_price", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "multiple_price"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }
            $detailPage = Container("PartnerProductRefGrid");
            if (in_array("partner_product_ref", $detailTblVar) && $detailPage->DetailEdit && $editRow) {
                $Security->loadCurrentUserLevel($this->ProjectID . "partner_product_ref"); // Load user level of detail table
                $editRow = $detailPage->gridUpdate();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
            }

            // Commit/Rollback transaction
            if ($this->getCurrentDetailTable() != "") {
                if ($editRow) {
                    if ($this->UseTransaction) { // Commit transaction
                        if ($conn->isTransactionActive()) {
                            $conn->commit();
                        }
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        if ($conn->isTransactionActive()) {
                            $conn->rollback();
                        }
                    }
                }
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
        $this->main_image->UploadPath = $this->main_image->OldUploadPath;
        $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
        $this->top_view->UploadPath = $this->top_view->OldUploadPath;
        $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
        $this->front_view->UploadPath = $this->front_view->OldUploadPath;
        $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
        $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
        $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
        $this->back_view->UploadPath = $this->back_view->OldUploadPath;
        $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
        $this->color_options->UploadPath = $this->color_options->OldUploadPath;
        $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
        $this->other_options->UploadPath = $this->other_options->OldUploadPath;
        $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
        $this->group_image->UploadPath = $this->group_image->OldUploadPath;
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $this->image->UploadPath = $this->image->OldUploadPath;
        $rsnew = [];

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, $this->company_id->ReadOnly);

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, $this->grp->ReadOnly);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, $this->s_grp->ReadOnly);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, $this->product->ReadOnly);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, $this->product_type->ReadOnly);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly);

        // product_n
        $this->product_n->setDbValueDef($rsnew, $this->product_n->CurrentValue, $this->product_n->ReadOnly);

        // barcode
        $this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, $this->_barcode->ReadOnly);

        // product_code_type
        $this->product_code_type->setDbValueDef($rsnew, $this->product_code_type->CurrentValue, $this->product_code_type->ReadOnly);

        // product_code
        $this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, $this->product_code->ReadOnly);

        // set_ref
        $this->set_ref->setDbValueDef($rsnew, $this->set_ref->CurrentValue, $this->set_ref->ReadOnly);

        // v_00
        $this->v_00->setDbValueDef($rsnew, $this->v_00->CurrentValue, $this->v_00->ReadOnly);

        // v_01
        $this->v_01->setDbValueDef($rsnew, $this->v_01->CurrentValue, $this->v_01->ReadOnly);

        // v_02
        $this->v_02->setDbValueDef($rsnew, $this->v_02->CurrentValue, $this->v_02->ReadOnly);

        // v_03
        $this->v_03->setDbValueDef($rsnew, $this->v_03->CurrentValue, $this->v_03->ReadOnly);

        // v_04
        $this->v_04->setDbValueDef($rsnew, $this->v_04->CurrentValue, $this->v_04->ReadOnly);

        // v_05
        $this->v_05->setDbValueDef($rsnew, $this->v_05->CurrentValue, $this->v_05->ReadOnly);

        // v_06
        $this->v_06->setDbValueDef($rsnew, $this->v_06->CurrentValue, $this->v_06->ReadOnly);

        // v_07
        $this->v_07->setDbValueDef($rsnew, $this->v_07->CurrentValue, $this->v_07->ReadOnly);

        // v_08
        $this->v_08->setDbValueDef($rsnew, $this->v_08->CurrentValue, $this->v_08->ReadOnly);

        // v_09
        $this->v_09->setDbValueDef($rsnew, $this->v_09->CurrentValue, $this->v_09->ReadOnly);

        // v_10
        $this->v_10->setDbValueDef($rsnew, $this->v_10->CurrentValue, $this->v_10->ReadOnly);

        // cbm
        $this->cbm->setDbValueDef($rsnew, $this->cbm->CurrentValue, $this->cbm->ReadOnly);

        // sqm
        $this->sqm->setDbValueDef($rsnew, $this->sqm->CurrentValue, $this->sqm->ReadOnly);

        // shape
        $this->shape->setDbValueDef($rsnew, $this->shape->CurrentValue, $this->shape->ReadOnly);

        // q_sku
        $this->q_sku->setDbValueDef($rsnew, $this->q_sku->CurrentValue, $this->q_sku->ReadOnly);

        // b_01
        $this->b_01->setDbValueDef($rsnew, $this->b_01->CurrentValue, $this->b_01->ReadOnly);

        // b_02
        $this->b_02->setDbValueDef($rsnew, $this->b_02->CurrentValue, $this->b_02->ReadOnly);

        // b_03
        $this->b_03->setDbValueDef($rsnew, $this->b_03->CurrentValue, $this->b_03->ReadOnly);

        // b_04
        $this->b_04->setDbValueDef($rsnew, $this->b_04->CurrentValue, $this->b_04->ReadOnly);

        // b_05
        $this->b_05->setDbValueDef($rsnew, $this->b_05->CurrentValue, $this->b_05->ReadOnly);

        // b_06
        $this->b_06->setDbValueDef($rsnew, $this->b_06->CurrentValue, $this->b_06->ReadOnly);

        // b_07
        $this->b_07->setDbValueDef($rsnew, $this->b_07->CurrentValue, $this->b_07->ReadOnly);

        // b_08
        $this->b_08->setDbValueDef($rsnew, $this->b_08->CurrentValue, $this->b_08->ReadOnly);

        // b_09
        $this->b_09->setDbValueDef($rsnew, $this->b_09->CurrentValue, $this->b_09->ReadOnly);

        // b_10
        $this->b_10->setDbValueDef($rsnew, $this->b_10->CurrentValue, $this->b_10->ReadOnly);

        // b_11
        $this->b_11->setDbValueDef($rsnew, $this->b_11->CurrentValue, $this->b_11->ReadOnly);

        // b_12
        $this->b_12->setDbValueDef($rsnew, $this->b_12->CurrentValue, $this->b_12->ReadOnly);

        // b_13
        $this->b_13->setDbValueDef($rsnew, $this->b_13->CurrentValue, $this->b_13->ReadOnly);

        // b_14
        $this->b_14->setDbValueDef($rsnew, $this->b_14->CurrentValue, $this->b_14->ReadOnly);

        // b_15
        $this->b_15->setDbValueDef($rsnew, $this->b_15->CurrentValue, $this->b_15->ReadOnly);

        // t_01
        $this->t_01->setDbValueDef($rsnew, $this->t_01->CurrentValue, $this->t_01->ReadOnly);

        // t_02
        $this->t_02->setDbValueDef($rsnew, $this->t_02->CurrentValue, $this->t_02->ReadOnly);

        // t_03
        $this->t_03->setDbValueDef($rsnew, $this->t_03->CurrentValue, $this->t_03->ReadOnly);

        // t_04
        $this->t_04->setDbValueDef($rsnew, $this->t_04->CurrentValue, $this->t_04->ReadOnly);

        // t_05
        $this->t_05->setDbValueDef($rsnew, $this->t_05->CurrentValue, $this->t_05->ReadOnly);

        // t_06
        $this->t_06->setDbValueDef($rsnew, $this->t_06->CurrentValue, $this->t_06->ReadOnly);

        // t_07
        $this->t_07->setDbValueDef($rsnew, $this->t_07->CurrentValue, $this->t_07->ReadOnly);

        // t_08
        $this->t_08->setDbValueDef($rsnew, $this->t_08->CurrentValue, $this->t_08->ReadOnly);

        // t_09
        $this->t_09->setDbValueDef($rsnew, $this->t_09->CurrentValue, $this->t_09->ReadOnly);

        // t_10
        $this->t_10->setDbValueDef($rsnew, $this->t_10->CurrentValue, $this->t_10->ReadOnly);

        // t_11
        $this->t_11->setDbValueDef($rsnew, $this->t_11->CurrentValue, $this->t_11->ReadOnly);

        // t_12
        $this->t_12->setDbValueDef($rsnew, $this->t_12->CurrentValue, $this->t_12->ReadOnly);

        // t_13
        $this->t_13->setDbValueDef($rsnew, $this->t_13->CurrentValue, $this->t_13->ReadOnly);

        // t_14
        $this->t_14->setDbValueDef($rsnew, $this->t_14->CurrentValue, $this->t_14->ReadOnly);

        // t_15
        $this->t_15->setDbValueDef($rsnew, $this->t_15->CurrentValue, $this->t_15->ReadOnly);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, $this->currency->ReadOnly);

        // hsn
        $this->hsn->setDbValueDef($rsnew, $this->hsn->CurrentValue, $this->hsn->ReadOnly);

        // composition
        $this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, $this->composition->ReadOnly);

        // category
        $this->category->setDbValueDef($rsnew, $this->category->CurrentValue, $this->category->ReadOnly);

        // moq
        $this->moq->setDbValueDef($rsnew, $this->moq->CurrentValue, $this->moq->ReadOnly);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, $this->status->ReadOnly);

        // d_head_01
        $this->d_head_01->setDbValueDef($rsnew, $this->d_head_01->CurrentValue, $this->d_head_01->ReadOnly);

        // d_description_01
        $this->d_description_01->setDbValueDef($rsnew, $this->d_description_01->CurrentValue, $this->d_description_01->ReadOnly);

        // d_head_02
        $this->d_head_02->setDbValueDef($rsnew, $this->d_head_02->CurrentValue, $this->d_head_02->ReadOnly);

        // d_description_02
        $this->d_description_02->setDbValueDef($rsnew, $this->d_description_02->CurrentValue, $this->d_description_02->ReadOnly);

        // publish
        $this->publish->setDbValueDef($rsnew, $this->publish->CurrentValue, $this->publish->ReadOnly);

        // keywords
        $this->keywords->setDbValueDef($rsnew, $this->keywords->CurrentValue, $this->keywords->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);

        // video_url
        $this->video_url->setDbValueDef($rsnew, $this->video_url->CurrentValue, $this->video_url->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['company_id'])) { // company_id
            $this->company_id->CurrentValue = $row['company_id'];
        }
        if (isset($row['grp'])) { // grp
            $this->grp->CurrentValue = $row['grp'];
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->CurrentValue = $row['s_grp'];
        }
        if (isset($row['product'])) { // product
            $this->product->CurrentValue = $row['product'];
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->CurrentValue = $row['product_type'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['product_n'])) { // product_n
            $this->product_n->CurrentValue = $row['product_n'];
        }
        if (isset($row['barcode'])) { // barcode
            $this->_barcode->CurrentValue = $row['barcode'];
        }
        if (isset($row['product_code_type'])) { // product_code_type
            $this->product_code_type->CurrentValue = $row['product_code_type'];
        }
        if (isset($row['product_code'])) { // product_code
            $this->product_code->CurrentValue = $row['product_code'];
        }
        if (isset($row['set_ref'])) { // set_ref
            $this->set_ref->CurrentValue = $row['set_ref'];
        }
        if (isset($row['v_00'])) { // v_00
            $this->v_00->CurrentValue = $row['v_00'];
        }
        if (isset($row['v_01'])) { // v_01
            $this->v_01->CurrentValue = $row['v_01'];
        }
        if (isset($row['v_02'])) { // v_02
            $this->v_02->CurrentValue = $row['v_02'];
        }
        if (isset($row['v_03'])) { // v_03
            $this->v_03->CurrentValue = $row['v_03'];
        }
        if (isset($row['v_04'])) { // v_04
            $this->v_04->CurrentValue = $row['v_04'];
        }
        if (isset($row['v_05'])) { // v_05
            $this->v_05->CurrentValue = $row['v_05'];
        }
        if (isset($row['v_06'])) { // v_06
            $this->v_06->CurrentValue = $row['v_06'];
        }
        if (isset($row['v_07'])) { // v_07
            $this->v_07->CurrentValue = $row['v_07'];
        }
        if (isset($row['v_08'])) { // v_08
            $this->v_08->CurrentValue = $row['v_08'];
        }
        if (isset($row['v_09'])) { // v_09
            $this->v_09->CurrentValue = $row['v_09'];
        }
        if (isset($row['v_10'])) { // v_10
            $this->v_10->CurrentValue = $row['v_10'];
        }
        if (isset($row['cbm'])) { // cbm
            $this->cbm->CurrentValue = $row['cbm'];
        }
        if (isset($row['sqm'])) { // sqm
            $this->sqm->CurrentValue = $row['sqm'];
        }
        if (isset($row['shape'])) { // shape
            $this->shape->CurrentValue = $row['shape'];
        }
        if (isset($row['q_sku'])) { // q_sku
            $this->q_sku->CurrentValue = $row['q_sku'];
        }
        if (isset($row['b_01'])) { // b_01
            $this->b_01->CurrentValue = $row['b_01'];
        }
        if (isset($row['b_02'])) { // b_02
            $this->b_02->CurrentValue = $row['b_02'];
        }
        if (isset($row['b_03'])) { // b_03
            $this->b_03->CurrentValue = $row['b_03'];
        }
        if (isset($row['b_04'])) { // b_04
            $this->b_04->CurrentValue = $row['b_04'];
        }
        if (isset($row['b_05'])) { // b_05
            $this->b_05->CurrentValue = $row['b_05'];
        }
        if (isset($row['b_06'])) { // b_06
            $this->b_06->CurrentValue = $row['b_06'];
        }
        if (isset($row['b_07'])) { // b_07
            $this->b_07->CurrentValue = $row['b_07'];
        }
        if (isset($row['b_08'])) { // b_08
            $this->b_08->CurrentValue = $row['b_08'];
        }
        if (isset($row['b_09'])) { // b_09
            $this->b_09->CurrentValue = $row['b_09'];
        }
        if (isset($row['b_10'])) { // b_10
            $this->b_10->CurrentValue = $row['b_10'];
        }
        if (isset($row['b_11'])) { // b_11
            $this->b_11->CurrentValue = $row['b_11'];
        }
        if (isset($row['b_12'])) { // b_12
            $this->b_12->CurrentValue = $row['b_12'];
        }
        if (isset($row['b_13'])) { // b_13
            $this->b_13->CurrentValue = $row['b_13'];
        }
        if (isset($row['b_14'])) { // b_14
            $this->b_14->CurrentValue = $row['b_14'];
        }
        if (isset($row['b_15'])) { // b_15
            $this->b_15->CurrentValue = $row['b_15'];
        }
        if (isset($row['t_01'])) { // t_01
            $this->t_01->CurrentValue = $row['t_01'];
        }
        if (isset($row['t_02'])) { // t_02
            $this->t_02->CurrentValue = $row['t_02'];
        }
        if (isset($row['t_03'])) { // t_03
            $this->t_03->CurrentValue = $row['t_03'];
        }
        if (isset($row['t_04'])) { // t_04
            $this->t_04->CurrentValue = $row['t_04'];
        }
        if (isset($row['t_05'])) { // t_05
            $this->t_05->CurrentValue = $row['t_05'];
        }
        if (isset($row['t_06'])) { // t_06
            $this->t_06->CurrentValue = $row['t_06'];
        }
        if (isset($row['t_07'])) { // t_07
            $this->t_07->CurrentValue = $row['t_07'];
        }
        if (isset($row['t_08'])) { // t_08
            $this->t_08->CurrentValue = $row['t_08'];
        }
        if (isset($row['t_09'])) { // t_09
            $this->t_09->CurrentValue = $row['t_09'];
        }
        if (isset($row['t_10'])) { // t_10
            $this->t_10->CurrentValue = $row['t_10'];
        }
        if (isset($row['t_11'])) { // t_11
            $this->t_11->CurrentValue = $row['t_11'];
        }
        if (isset($row['t_12'])) { // t_12
            $this->t_12->CurrentValue = $row['t_12'];
        }
        if (isset($row['t_13'])) { // t_13
            $this->t_13->CurrentValue = $row['t_13'];
        }
        if (isset($row['t_14'])) { // t_14
            $this->t_14->CurrentValue = $row['t_14'];
        }
        if (isset($row['t_15'])) { // t_15
            $this->t_15->CurrentValue = $row['t_15'];
        }
        if (isset($row['currency'])) { // currency
            $this->currency->CurrentValue = $row['currency'];
        }
        if (isset($row['hsn'])) { // hsn
            $this->hsn->CurrentValue = $row['hsn'];
        }
        if (isset($row['composition'])) { // composition
            $this->composition->CurrentValue = $row['composition'];
        }
        if (isset($row['category'])) { // category
            $this->category->CurrentValue = $row['category'];
        }
        if (isset($row['moq'])) { // moq
            $this->moq->CurrentValue = $row['moq'];
        }
        if (isset($row['status'])) { // status
            $this->status->CurrentValue = $row['status'];
        }
        if (isset($row['d_head_01'])) { // d_head_01
            $this->d_head_01->CurrentValue = $row['d_head_01'];
        }
        if (isset($row['d_description_01'])) { // d_description_01
            $this->d_description_01->CurrentValue = $row['d_description_01'];
        }
        if (isset($row['d_head_02'])) { // d_head_02
            $this->d_head_02->CurrentValue = $row['d_head_02'];
        }
        if (isset($row['d_description_02'])) { // d_description_02
            $this->d_description_02->CurrentValue = $row['d_description_02'];
        }
        if (isset($row['publish'])) { // publish
            $this->publish->CurrentValue = $row['publish'];
        }
        if (isset($row['keywords'])) { // keywords
            $this->keywords->CurrentValue = $row['keywords'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
        if (isset($row['video_url'])) { // video_url
            $this->video_url->CurrentValue = $row['video_url'];
        }
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("multiple_price", $detailTblVar)) {
                $detailPageObj = Container("MultiplePriceGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->code->IsDetailKey = true;
                    $detailPageObj->code->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->code->setSessionValue($detailPageObj->code->CurrentValue);
                }
            }
            if (in_array("partner_product_ref", $detailTblVar)) {
                $detailPageObj = Container("PartnerProductRefGrid");
                if ($detailPageObj->DetailEdit) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    $detailPageObj->CurrentMode = "edit";
                    $detailPageObj->CurrentAction = "gridedit";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->rid->IsDetailKey = true;
                    $detailPageObj->rid->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->rid->setSessionValue($detailPageObj->rid->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("reflist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $pages->add(3);
        $pages->add(4);
        $pages->add(5);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code_type":
                    break;
                case "x_set_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_11":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_12":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hsn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_publish":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'ref');
        //print_r($this);
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) {
    	// Return error message in CustomError
    extract($_POST,EXTR_OVERWRITE);
    	$Head = ExecuteRow("SELECT `v_01`, `v_02`, `v_03`, `v_04`, `v_05`, `v_06`, `v_07`, `v_08`, `v_09`, `v_10`, `b_01_head`, `b_02_head`, `b_03_head`, `b_04_head`, `b_05_head`, `b_06_head`, `b_07_head`, `b_08_head`,`b_09_head`,`b_10_head`,`b_11_head`,`b_12_head`, `b_13_head`,`b_14_head`,`b_15_head`, `t_01_head`, `t_02_head`, `t_03_head`, `t_04_head`, `t_05_head`, `t_06_head`, `t_07_head`,  `t_08_head`, `t_09_head`,`t_10_head`,`t_11_head`,`t_12_head`, `t_13_head`,`t_14_head`,`t_15_head` FROM `product_group` WHERE `id` = $x_s_grp LIMIT 1");
    $_SESSION[SESSION_WARNING_MESSAGE] = '';
    		if  ($Head['v_01'] != '--NA--' && ($x_v_01 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_01']. "<br>";
    		}
    		if  ($Head['v_02'] != '--NA--' && ($x_v_02 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_02']. "<br>";
    		}
    		if  ($Head['v_03'] != '--NA--' && ($x_v_03 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_03']. "<br>";
    		}
    		if  ($Head['v_04'] != '--NA--' && ($x_v_04 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_04']. "<br>";
    		}
    		if  ($Head['v_05'] != '--NA--' && ($x_v_05 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_05']. "<br>";
    		}
    		if  ($Head['v_06'] != '--NA--' && ($x_v_06 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_06']. "<br>";
    		}
    		if  ($Head['v_07'] != '--NA--' && ($x_v_07 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_07']. "<br>";
    		}
    		if  ($Head['v_08'] != '--NA--' && ($x_v_08 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_08']. "<br>";
    		}
    		if  ($Head['v_09'] != '--NA--' && ($x_v_09 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_09']. "<br>";
    		}
    		if  ($Head['v_10'] != '--NA--' && ($x_v_10 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_10']. "<br>";
    		}
    		if (($x_product_type) == 9)
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Selection of Product Specification is not Allowed. <br>";
    		}
    		if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    		{return TRUE;}
    		else
    		{return FALSE;}
    }
}
