<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RefDelete extends Ref
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RefDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "refdelete";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->oid->Visible = false;
        $this->company_id->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_type->Visible = false;
        $this->packing_type->setVisibility();
        $this->product_n->setVisibility();
        $this->_barcode->Visible = false;
        $this->product_code_type->setVisibility();
        $this->product_code->setVisibility();
        $this->print_name->Visible = false;
        $this->gcode->Visible = false;
        $this->code->Visible = false;
        $this->product_id->Visible = false;
        $this->batch_no->Visible = false;
        $this->set_ref->Visible = false;
        $this->v_00->setVisibility();
        $this->v_01->Visible = false;
        $this->v_02->Visible = false;
        $this->v_03->Visible = false;
        $this->v_04->Visible = false;
        $this->v_05->Visible = false;
        $this->v_06->Visible = false;
        $this->v_07->Visible = false;
        $this->v_08->Visible = false;
        $this->v_09->Visible = false;
        $this->v_10->Visible = false;
        $this->cbm->Visible = false;
        $this->sqm->Visible = false;
        $this->shape->Visible = false;
        $this->q_sku->setVisibility();
        $this->b_01->Visible = false;
        $this->b_02->Visible = false;
        $this->b_03->Visible = false;
        $this->b_04->Visible = false;
        $this->b_05->Visible = false;
        $this->b_06->Visible = false;
        $this->b_07->Visible = false;
        $this->b_08->Visible = false;
        $this->b_09->Visible = false;
        $this->b_10->Visible = false;
        $this->b_11->Visible = false;
        $this->b_12->Visible = false;
        $this->b_13->Visible = false;
        $this->b_14->Visible = false;
        $this->b_15->Visible = false;
        $this->t_01->Visible = false;
        $this->t_02->Visible = false;
        $this->t_03->Visible = false;
        $this->t_04->Visible = false;
        $this->t_05->Visible = false;
        $this->t_06->Visible = false;
        $this->t_07->Visible = false;
        $this->t_08->Visible = false;
        $this->t_09->Visible = false;
        $this->t_10->Visible = false;
        $this->t_11->Visible = false;
        $this->t_12->Visible = false;
        $this->t_13->Visible = false;
        $this->t_14->Visible = false;
        $this->t_15->Visible = false;
        $this->last_price->Visible = false;
        $this->currency->Visible = false;
        $this->hsn->Visible = false;
        $this->composition->setVisibility();
        $this->category->setVisibility();
        $this->moq->Visible = false;
        $this->status->setVisibility();
        $this->d_head_01->Visible = false;
        $this->d_description_01->Visible = false;
        $this->d_head_02->Visible = false;
        $this->d_description_02->Visible = false;
        $this->publish->Visible = false;
        $this->keywords->Visible = false;
        $this->operator->Visible = false;
        $this->datetime->Visible = false;
        $this->main_image->Visible = false;
        $this->top_view->Visible = false;
        $this->front_view->Visible = false;
        $this->corner_view->Visible = false;
        $this->back_view->Visible = false;
        $this->color_options->Visible = false;
        $this->other_options->Visible = false;
        $this->group_image->Visible = false;
        $this->video_url->Visible = false;
        $this->image->Visible = false;
        $this->in->Visible = false;
        $this->out->Visible = false;
        $this->required->Visible = false;
        $this->blocked->Visible = false;
        $this->ordered->Visible = false;
        $this->supplier->Visible = false;
        $this->country->Visible = false;
        $this->minimum_stock->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ref';
        $this->TableName = 'ref';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ref)
        if (!isset($GLOBALS["ref"]) || $GLOBALS["ref"]::class == PROJECT_NAMESPACE . "ref") {
            $GLOBALS["ref"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
                $this->main_image->UploadPath = $this->main_image->OldUploadPath;
                $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
                $this->top_view->UploadPath = $this->top_view->OldUploadPath;
                $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
                $this->front_view->UploadPath = $this->front_view->OldUploadPath;
                $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
                $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
                $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
                $this->back_view->UploadPath = $this->back_view->OldUploadPath;
                $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
                $this->color_options->UploadPath = $this->color_options->OldUploadPath;
                $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
                $this->other_options->UploadPath = $this->other_options->OldUploadPath;
                $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
                $this->group_image->UploadPath = $this->group_image->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code_type);
        $this->setupLookupOptions($this->set_ref);
        $this->setupLookupOptions($this->v_01);
        $this->setupLookupOptions($this->v_02);
        $this->setupLookupOptions($this->v_03);
        $this->setupLookupOptions($this->v_04);
        $this->setupLookupOptions($this->v_05);
        $this->setupLookupOptions($this->v_06);
        $this->setupLookupOptions($this->v_07);
        $this->setupLookupOptions($this->v_08);
        $this->setupLookupOptions($this->v_09);
        $this->setupLookupOptions($this->v_10);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->b_03);
        $this->setupLookupOptions($this->b_04);
        $this->setupLookupOptions($this->b_05);
        $this->setupLookupOptions($this->b_06);
        $this->setupLookupOptions($this->b_07);
        $this->setupLookupOptions($this->b_08);
        $this->setupLookupOptions($this->b_09);
        $this->setupLookupOptions($this->b_10);
        $this->setupLookupOptions($this->t_03);
        $this->setupLookupOptions($this->t_04);
        $this->setupLookupOptions($this->t_05);
        $this->setupLookupOptions($this->t_06);
        $this->setupLookupOptions($this->t_07);
        $this->setupLookupOptions($this->t_08);
        $this->setupLookupOptions($this->t_09);
        $this->setupLookupOptions($this->t_10);
        $this->setupLookupOptions($this->t_11);
        $this->setupLookupOptions($this->t_12);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->hsn);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->publish);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("reflist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("reflist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->oid->setDbValue($row['oid']);
        $this->company_id->setDbValue($row['company_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_type->setDbValue($row['product_type']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_n->setDbValue($row['product_n']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->product_code_type->setDbValue($row['product_code_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->print_name->setDbValue($row['print_name']);
        $this->gcode->setDbValue($row['gcode']);
        $this->code->setDbValue($row['code']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->set_ref->setDbValue($row['set_ref']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_10->setDbValue($row['v_10']);
        $this->cbm->setDbValue($row['cbm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->shape->setDbValue($row['shape']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->b_01->setDbValue($row['b_01']);
        $this->b_02->setDbValue($row['b_02']);
        $this->b_03->setDbValue($row['b_03']);
        $this->b_04->setDbValue($row['b_04']);
        $this->b_05->setDbValue($row['b_05']);
        $this->b_06->setDbValue($row['b_06']);
        $this->b_07->setDbValue($row['b_07']);
        $this->b_08->setDbValue($row['b_08']);
        $this->b_09->setDbValue($row['b_09']);
        $this->b_10->setDbValue($row['b_10']);
        $this->b_11->setDbValue($row['b_11']);
        $this->b_12->setDbValue($row['b_12']);
        $this->b_13->setDbValue($row['b_13']);
        $this->b_14->setDbValue($row['b_14']);
        $this->b_15->setDbValue($row['b_15']);
        $this->t_01->setDbValue($row['t_01']);
        $this->t_02->setDbValue($row['t_02']);
        $this->t_03->setDbValue($row['t_03']);
        $this->t_04->setDbValue($row['t_04']);
        $this->t_05->setDbValue($row['t_05']);
        $this->t_06->setDbValue($row['t_06']);
        $this->t_07->setDbValue($row['t_07']);
        $this->t_08->setDbValue($row['t_08']);
        $this->t_09->setDbValue($row['t_09']);
        $this->t_10->setDbValue($row['t_10']);
        $this->t_11->setDbValue($row['t_11']);
        $this->t_12->setDbValue($row['t_12']);
        $this->t_13->setDbValue($row['t_13']);
        $this->t_14->setDbValue($row['t_14']);
        $this->t_15->setDbValue($row['t_15']);
        $this->last_price->setDbValue($row['last_price']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->category->setDbValue($row['category']);
        $this->moq->setDbValue($row['moq']);
        $this->status->setDbValue($row['status']);
        $this->d_head_01->setDbValue($row['d_head_01']);
        $this->d_description_01->setDbValue($row['d_description_01']);
        $this->d_head_02->setDbValue($row['d_head_02']);
        $this->d_description_02->setDbValue($row['d_description_02']);
        $this->publish->setDbValue($row['publish']);
        $this->keywords->setDbValue($row['keywords']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->main_image->setDbValue($this->main_image->Upload->DbValue);
        $this->top_view->Upload->DbValue = $row['top_view'];
        $this->top_view->setDbValue($this->top_view->Upload->DbValue);
        $this->front_view->Upload->DbValue = $row['front_view'];
        $this->front_view->setDbValue($this->front_view->Upload->DbValue);
        $this->corner_view->Upload->DbValue = $row['corner_view'];
        $this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
        $this->back_view->Upload->DbValue = $row['back_view'];
        $this->back_view->setDbValue($this->back_view->Upload->DbValue);
        $this->color_options->Upload->DbValue = $row['color_options'];
        $this->color_options->setDbValue($this->color_options->Upload->DbValue);
        $this->other_options->Upload->DbValue = $row['other_options'];
        $this->other_options->setDbValue($this->other_options->Upload->DbValue);
        $this->group_image->Upload->DbValue = $row['group_image'];
        $this->group_image->setDbValue($this->group_image->Upload->DbValue);
        $this->video_url->setDbValue($row['video_url']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->in->setDbValue($row['in']);
        $this->out->setDbValue($row['out']);
        $this->required->setDbValue($row['required']);
        $this->blocked->setDbValue($row['blocked']);
        $this->ordered->setDbValue($row['ordered']);
        $this->supplier->setDbValue($row['supplier']);
        $this->country->setDbValue($row['country']);
        $this->minimum_stock->setDbValue($row['minimum_stock']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['oid'] = $this->oid->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['product_n'] = $this->product_n->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['product_code_type'] = $this->product_code_type->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['print_name'] = $this->print_name->DefaultValue;
        $row['gcode'] = $this->gcode->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['set_ref'] = $this->set_ref->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['b_01'] = $this->b_01->DefaultValue;
        $row['b_02'] = $this->b_02->DefaultValue;
        $row['b_03'] = $this->b_03->DefaultValue;
        $row['b_04'] = $this->b_04->DefaultValue;
        $row['b_05'] = $this->b_05->DefaultValue;
        $row['b_06'] = $this->b_06->DefaultValue;
        $row['b_07'] = $this->b_07->DefaultValue;
        $row['b_08'] = $this->b_08->DefaultValue;
        $row['b_09'] = $this->b_09->DefaultValue;
        $row['b_10'] = $this->b_10->DefaultValue;
        $row['b_11'] = $this->b_11->DefaultValue;
        $row['b_12'] = $this->b_12->DefaultValue;
        $row['b_13'] = $this->b_13->DefaultValue;
        $row['b_14'] = $this->b_14->DefaultValue;
        $row['b_15'] = $this->b_15->DefaultValue;
        $row['t_01'] = $this->t_01->DefaultValue;
        $row['t_02'] = $this->t_02->DefaultValue;
        $row['t_03'] = $this->t_03->DefaultValue;
        $row['t_04'] = $this->t_04->DefaultValue;
        $row['t_05'] = $this->t_05->DefaultValue;
        $row['t_06'] = $this->t_06->DefaultValue;
        $row['t_07'] = $this->t_07->DefaultValue;
        $row['t_08'] = $this->t_08->DefaultValue;
        $row['t_09'] = $this->t_09->DefaultValue;
        $row['t_10'] = $this->t_10->DefaultValue;
        $row['t_11'] = $this->t_11->DefaultValue;
        $row['t_12'] = $this->t_12->DefaultValue;
        $row['t_13'] = $this->t_13->DefaultValue;
        $row['t_14'] = $this->t_14->DefaultValue;
        $row['t_15'] = $this->t_15->DefaultValue;
        $row['last_price'] = $this->last_price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['hsn'] = $this->hsn->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['moq'] = $this->moq->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['d_head_01'] = $this->d_head_01->DefaultValue;
        $row['d_description_01'] = $this->d_description_01->DefaultValue;
        $row['d_head_02'] = $this->d_head_02->DefaultValue;
        $row['d_description_02'] = $this->d_description_02->DefaultValue;
        $row['publish'] = $this->publish->DefaultValue;
        $row['keywords'] = $this->keywords->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['main_image'] = $this->main_image->DefaultValue;
        $row['top_view'] = $this->top_view->DefaultValue;
        $row['front_view'] = $this->front_view->DefaultValue;
        $row['corner_view'] = $this->corner_view->DefaultValue;
        $row['back_view'] = $this->back_view->DefaultValue;
        $row['color_options'] = $this->color_options->DefaultValue;
        $row['other_options'] = $this->other_options->DefaultValue;
        $row['group_image'] = $this->group_image->DefaultValue;
        $row['video_url'] = $this->video_url->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['in'] = $this->in->DefaultValue;
        $row['out'] = $this->out->DefaultValue;
        $row['required'] = $this->required->DefaultValue;
        $row['blocked'] = $this->blocked->DefaultValue;
        $row['ordered'] = $this->ordered->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['minimum_stock'] = $this->minimum_stock->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // oid
        $this->oid->CellCssStyle = "white-space: nowrap;";

        // company_id

        // grp

        // s_grp

        // product

        // product_type

        // packing_type

        // product_n

        // barcode

        // product_code_type

        // product_code

        // print_name
        $this->print_name->CellCssStyle = "white-space: nowrap;";

        // gcode
        $this->gcode->CellCssStyle = "white-space: nowrap;";

        // code
        $this->code->CellCssStyle = "white-space: nowrap;";

        // product_id
        $this->product_id->CellCssStyle = "white-space: nowrap;";

        // batch_no
        $this->batch_no->CellCssStyle = "white-space: nowrap;";

        // set_ref
        $this->set_ref->CellCssStyle = "white-space: nowrap;";

        // v_00

        // v_01

        // v_02

        // v_03

        // v_04

        // v_05

        // v_06

        // v_07

        // v_08

        // v_09

        // v_10

        // cbm

        // sqm

        // shape

        // q_sku

        // b_01

        // b_02

        // b_03

        // b_04

        // b_05

        // b_06

        // b_07

        // b_08

        // b_09

        // b_10

        // b_11

        // b_12

        // b_13

        // b_14

        // b_15

        // t_01

        // t_02

        // t_03

        // t_04

        // t_05

        // t_06

        // t_07

        // t_08

        // t_09

        // t_10

        // t_11

        // t_12

        // t_13

        // t_14

        // t_15

        // last_price

        // currency

        // hsn

        // composition

        // category

        // moq
        $this->moq->CellCssStyle = "white-space: nowrap;";

        // status

        // d_head_01

        // d_description_01

        // d_head_02

        // d_description_02

        // publish

        // keywords

        // operator

        // datetime

        // main_image
        $this->main_image->CellCssStyle = "white-space: nowrap;";

        // top_view
        $this->top_view->CellCssStyle = "white-space: nowrap;";

        // front_view
        $this->front_view->CellCssStyle = "white-space: nowrap;";

        // corner_view
        $this->corner_view->CellCssStyle = "white-space: nowrap;";

        // back_view
        $this->back_view->CellCssStyle = "white-space: nowrap;";

        // color_options
        $this->color_options->CellCssStyle = "white-space: nowrap;";

        // other_options
        $this->other_options->CellCssStyle = "white-space: nowrap;";

        // group_image
        $this->group_image->CellCssStyle = "white-space: nowrap;";

        // video_url
        $this->video_url->CellCssStyle = "white-space: nowrap;";

        // image
        $this->image->CellCssStyle = "white-space: nowrap;";

        // in
        $this->in->CellCssStyle = "white-space: nowrap;";

        // out
        $this->out->CellCssStyle = "white-space: nowrap;";

        // required
        $this->required->CellCssStyle = "white-space: nowrap;";

        // blocked
        $this->blocked->CellCssStyle = "white-space: nowrap;";

        // ordered
        $this->ordered->CellCssStyle = "white-space: nowrap;";

        // supplier
        $this->supplier->CellCssStyle = "white-space: nowrap;";

        // country
        $this->country->CellCssStyle = "white-space: nowrap;";

        // minimum_stock
        $this->minimum_stock->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->company_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->company_id->Lookup->renderViewRow($row);
                            $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                        }
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_n
            $this->product_n->ViewValue = $this->product_n->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // product_code_type
            if (strval($this->product_code_type->CurrentValue) != "") {
                $this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
            } else {
                $this->product_code_type->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // set_ref
            $curVal = strval($this->set_ref->CurrentValue);
            if ($curVal != "") {
                $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
                if ($this->set_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->set_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->set_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                            $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->set_ref->ViewValue = $this->set_ref->CurrentValue;
                    }
                }
            } else {
                $this->set_ref->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $curVal = strval($this->v_01->CurrentValue);
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
                if ($this->v_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_01->Lookup->renderViewRow($rswrk[0]);
                        $this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
                    } else {
                        $this->v_01->ViewValue = $this->v_01->CurrentValue;
                    }
                }
            } else {
                $this->v_01->ViewValue = null;
            }

            // v_02
            $curVal = strval($this->v_02->CurrentValue);
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
                if ($this->v_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_02->Lookup->renderViewRow($rswrk[0]);
                        $this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
                    } else {
                        $this->v_02->ViewValue = $this->v_02->CurrentValue;
                    }
                }
            } else {
                $this->v_02->ViewValue = null;
            }

            // v_03
            $curVal = strval($this->v_03->CurrentValue);
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
                if ($this->v_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_03->Lookup->renderViewRow($rswrk[0]);
                        $this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
                    } else {
                        $this->v_03->ViewValue = $this->v_03->CurrentValue;
                    }
                }
            } else {
                $this->v_03->ViewValue = null;
            }

            // v_04
            $curVal = strval($this->v_04->CurrentValue);
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
                if ($this->v_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_04->Lookup->renderViewRow($rswrk[0]);
                        $this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
                    } else {
                        $this->v_04->ViewValue = $this->v_04->CurrentValue;
                    }
                }
            } else {
                $this->v_04->ViewValue = null;
            }

            // v_05
            $curVal = strval($this->v_05->CurrentValue);
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
                if ($this->v_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_05->Lookup->renderViewRow($rswrk[0]);
                        $this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
                    } else {
                        $this->v_05->ViewValue = $this->v_05->CurrentValue;
                    }
                }
            } else {
                $this->v_05->ViewValue = null;
            }

            // v_06
            $curVal = strval($this->v_06->CurrentValue);
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
                if ($this->v_06->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_06->Lookup->renderViewRow($rswrk[0]);
                        $this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
                    } else {
                        $this->v_06->ViewValue = $this->v_06->CurrentValue;
                    }
                }
            } else {
                $this->v_06->ViewValue = null;
            }

            // v_07
            $curVal = strval($this->v_07->CurrentValue);
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
                if ($this->v_07->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_07->Lookup->renderViewRow($rswrk[0]);
                        $this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
                    } else {
                        $this->v_07->ViewValue = $this->v_07->CurrentValue;
                    }
                }
            } else {
                $this->v_07->ViewValue = null;
            }

            // v_08
            $curVal = strval($this->v_08->CurrentValue);
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
                if ($this->v_08->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_08->Lookup->renderViewRow($rswrk[0]);
                        $this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
                    } else {
                        $this->v_08->ViewValue = $this->v_08->CurrentValue;
                    }
                }
            } else {
                $this->v_08->ViewValue = null;
            }

            // v_09
            $curVal = strval($this->v_09->CurrentValue);
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
                if ($this->v_09->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_09->Lookup->renderViewRow($rswrk[0]);
                        $this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
                    } else {
                        $this->v_09->ViewValue = $this->v_09->CurrentValue;
                    }
                }
            } else {
                $this->v_09->ViewValue = null;
            }

            // v_10
            $curVal = strval($this->v_10->CurrentValue);
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
                if ($this->v_10->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_10->Lookup->renderViewRow($rswrk[0]);
                        $this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
                    } else {
                        $this->v_10->ViewValue = $this->v_10->CurrentValue;
                    }
                }
            } else {
                $this->v_10->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // b_01
            $this->b_01->ViewValue = $this->b_01->CurrentValue;

            // b_02
            $this->b_02->ViewValue = $this->b_02->CurrentValue;

            // b_03
            $curVal = strval($this->b_03->CurrentValue);
            if ($curVal != "") {
                $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
                if ($this->b_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_03->Lookup->renderViewRow($row);
                            $this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
                        }
                    } else {
                        $this->b_03->ViewValue = $this->b_03->CurrentValue;
                    }
                }
            } else {
                $this->b_03->ViewValue = null;
            }

            // b_04
            $curVal = strval($this->b_04->CurrentValue);
            if ($curVal != "") {
                $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
                if ($this->b_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_04->Lookup->renderViewRow($row);
                            $this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
                        }
                    } else {
                        $this->b_04->ViewValue = $this->b_04->CurrentValue;
                    }
                }
            } else {
                $this->b_04->ViewValue = null;
            }

            // b_05
            $curVal = strval($this->b_05->CurrentValue);
            if ($curVal != "") {
                $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
                if ($this->b_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_05->Lookup->renderViewRow($row);
                            $this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
                        }
                    } else {
                        $this->b_05->ViewValue = $this->b_05->CurrentValue;
                    }
                }
            } else {
                $this->b_05->ViewValue = null;
            }

            // b_06
            $curVal = strval($this->b_06->CurrentValue);
            if ($curVal != "") {
                $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
                if ($this->b_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_06->Lookup->renderViewRow($row);
                            $this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
                        }
                    } else {
                        $this->b_06->ViewValue = $this->b_06->CurrentValue;
                    }
                }
            } else {
                $this->b_06->ViewValue = null;
            }

            // b_07
            $curVal = strval($this->b_07->CurrentValue);
            if ($curVal != "") {
                $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
                if ($this->b_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_07->Lookup->renderViewRow($row);
                            $this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
                        }
                    } else {
                        $this->b_07->ViewValue = $this->b_07->CurrentValue;
                    }
                }
            } else {
                $this->b_07->ViewValue = null;
            }

            // b_08
            $curVal = strval($this->b_08->CurrentValue);
            if ($curVal != "") {
                $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
                if ($this->b_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_08->Lookup->renderViewRow($row);
                            $this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
                        }
                    } else {
                        $this->b_08->ViewValue = $this->b_08->CurrentValue;
                    }
                }
            } else {
                $this->b_08->ViewValue = null;
            }

            // b_09
            $curVal = strval($this->b_09->CurrentValue);
            if ($curVal != "") {
                $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
                if ($this->b_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_09->Lookup->renderViewRow($row);
                            $this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
                        }
                    } else {
                        $this->b_09->ViewValue = $this->b_09->CurrentValue;
                    }
                }
            } else {
                $this->b_09->ViewValue = null;
            }

            // b_10
            $curVal = strval($this->b_10->CurrentValue);
            if ($curVal != "") {
                $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
                if ($this->b_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_10->Lookup->renderViewRow($row);
                            $this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
                        }
                    } else {
                        $this->b_10->ViewValue = $this->b_10->CurrentValue;
                    }
                }
            } else {
                $this->b_10->ViewValue = null;
            }

            // b_11
            $this->b_11->ViewValue = $this->b_11->CurrentValue;

            // b_12
            $this->b_12->ViewValue = $this->b_12->CurrentValue;

            // b_13
            $this->b_13->ViewValue = $this->b_13->CurrentValue;

            // b_14
            $this->b_14->ViewValue = $this->b_14->CurrentValue;

            // b_15
            $this->b_15->ViewValue = $this->b_15->CurrentValue;

            // t_01
            $this->t_01->ViewValue = $this->t_01->CurrentValue;

            // t_02
            $this->t_02->ViewValue = $this->t_02->CurrentValue;

            // t_03
            $curVal = strval($this->t_03->CurrentValue);
            if ($curVal != "") {
                $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
                if ($this->t_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_03->Lookup->renderViewRow($row);
                            $this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
                        }
                    } else {
                        $this->t_03->ViewValue = $this->t_03->CurrentValue;
                    }
                }
            } else {
                $this->t_03->ViewValue = null;
            }

            // t_04
            $curVal = strval($this->t_04->CurrentValue);
            if ($curVal != "") {
                $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
                if ($this->t_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_04->Lookup->renderViewRow($row);
                            $this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
                        }
                    } else {
                        $this->t_04->ViewValue = $this->t_04->CurrentValue;
                    }
                }
            } else {
                $this->t_04->ViewValue = null;
            }

            // t_05
            $curVal = strval($this->t_05->CurrentValue);
            if ($curVal != "") {
                $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
                if ($this->t_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_05->Lookup->renderViewRow($row);
                            $this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
                        }
                    } else {
                        $this->t_05->ViewValue = $this->t_05->CurrentValue;
                    }
                }
            } else {
                $this->t_05->ViewValue = null;
            }

            // t_06
            $curVal = strval($this->t_06->CurrentValue);
            if ($curVal != "") {
                $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
                if ($this->t_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_06->Lookup->renderViewRow($row);
                            $this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
                        }
                    } else {
                        $this->t_06->ViewValue = $this->t_06->CurrentValue;
                    }
                }
            } else {
                $this->t_06->ViewValue = null;
            }

            // t_07
            $curVal = strval($this->t_07->CurrentValue);
            if ($curVal != "") {
                $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
                if ($this->t_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_07->Lookup->renderViewRow($row);
                            $this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
                        }
                    } else {
                        $this->t_07->ViewValue = $this->t_07->CurrentValue;
                    }
                }
            } else {
                $this->t_07->ViewValue = null;
            }

            // t_08
            $curVal = strval($this->t_08->CurrentValue);
            if ($curVal != "") {
                $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
                if ($this->t_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_08->Lookup->renderViewRow($row);
                            $this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
                        }
                    } else {
                        $this->t_08->ViewValue = $this->t_08->CurrentValue;
                    }
                }
            } else {
                $this->t_08->ViewValue = null;
            }

            // t_09
            $curVal = strval($this->t_09->CurrentValue);
            if ($curVal != "") {
                $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
                if ($this->t_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_09->Lookup->renderViewRow($row);
                            $this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
                        }
                    } else {
                        $this->t_09->ViewValue = $this->t_09->CurrentValue;
                    }
                }
            } else {
                $this->t_09->ViewValue = null;
            }

            // t_10
            $curVal = strval($this->t_10->CurrentValue);
            if ($curVal != "") {
                $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
                if ($this->t_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_10->Lookup->renderViewRow($row);
                            $this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
                        }
                    } else {
                        $this->t_10->ViewValue = $this->t_10->CurrentValue;
                    }
                }
            } else {
                $this->t_10->ViewValue = null;
            }

            // t_11
            $this->t_11->ViewValue = $this->t_11->CurrentValue;
            $curVal = strval($this->t_11->CurrentValue);
            if ($curVal != "") {
                $this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->ViewValue = $this->t_11->CurrentValue;
                    }
                }
            } else {
                $this->t_11->ViewValue = null;
            }

            // t_12
            $this->t_12->ViewValue = $this->t_12->CurrentValue;
            $curVal = strval($this->t_12->CurrentValue);
            if ($curVal != "") {
                $this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->ViewValue = $this->t_12->CurrentValue;
                    }
                }
            } else {
                $this->t_12->ViewValue = null;
            }

            // t_13
            $this->t_13->ViewValue = $this->t_13->CurrentValue;

            // t_14
            $this->t_14->ViewValue = $this->t_14->CurrentValue;

            // t_15
            $this->t_15->ViewValue = $this->t_15->CurrentValue;

            // last_price
            $this->last_price->ViewValue = $this->last_price->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // hsn
            $curVal = strval($this->hsn->CurrentValue);
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
                if ($this->hsn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                        $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                    } else {
                        $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                    }
                }
            } else {
                $this->hsn->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // d_head_01
            $this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;

            // d_description_01
            $this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;

            // d_head_02
            $this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;

            // d_description_02
            $this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;

            // publish
            if (strval($this->publish->CurrentValue) != "") {
                $this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
            } else {
                $this->publish->ViewValue = null;
            }

            // keywords
            $this->keywords->ViewValue = $this->keywords->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // product_n
            $this->product_n->HrefValue = "";
            $this->product_n->TooltipValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";
            $this->product_code_type->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // v_00
            $this->v_00->HrefValue = "";
            $this->v_00->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // composition
            $this->composition->HrefValue = "";
            $this->composition->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }
        if ($this->AuditTrailOnDelete) {
            $this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
            if ($this->AuditTrailOnDelete) {
                $this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("reflist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code_type":
                    break;
                case "x_set_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_11":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_12":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hsn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_publish":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'ref');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
