<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RefCodeAdd extends RefCode
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RefCodeAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "refcodeadd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_type->setVisibility();
        $this->packing_type->setVisibility();
        $this->product_code_type->setVisibility();
        $this->product_code->setVisibility();
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_02->setVisibility();
        $this->v_03->setVisibility();
        $this->v_04->setVisibility();
        $this->v_05->setVisibility();
        $this->v_06->setVisibility();
        $this->v_07->setVisibility();
        $this->v_08->setVisibility();
        $this->v_09->setVisibility();
        $this->v_10->setVisibility();
        $this->last_price->Visible = false;
        $this->currency->setVisibility();
        $this->composition->setVisibility();
        $this->moq->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ref_code';
        $this->TableName = 'ref_code';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ref_code)
        if (!isset($GLOBALS["ref_code"]) || $GLOBALS["ref_code"]::class == PROJECT_NAMESPACE . "ref_code") {
            $GLOBALS["ref_code"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_code');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "refcodeview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;
    public $MultiPages; // Multi pages object

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Set up multi page object
        $this->setupMultiPages();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code_type);
        $this->setupLookupOptions($this->v_01);
        $this->setupLookupOptions($this->v_02);
        $this->setupLookupOptions($this->v_03);
        $this->setupLookupOptions($this->v_04);
        $this->setupLookupOptions($this->v_05);
        $this->setupLookupOptions($this->v_06);
        $this->setupLookupOptions($this->v_07);
        $this->setupLookupOptions($this->v_08);
        $this->setupLookupOptions($this->v_09);
        $this->setupLookupOptions($this->v_10);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Set up detail parameters
        $this->setupDetailParms();

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("refcodelist"); // No matching record, return to list
                    return;
                }

                // Set up detail parameters
                $this->setupDetailParms();
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    if ($this->getCurrentDetailTable() != "") { // Master/detail add
                        $returnUrl = $this->getDetailUrl();
                    } else {
                        $returnUrl = $this->getReturnUrl();
                    }
                    if (GetPageName($returnUrl) == "refcodelist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "refcodeview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "refcodelist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "refcodelist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values

                    // Set up detail parameters
                    $this->setupDetailParms();
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->product_type->DefaultValue = $this->product_type->getDefault(); // PHP
        $this->product_type->OldValue = $this->product_type->DefaultValue;
        $this->packing_type->DefaultValue = $this->packing_type->getDefault(); // PHP
        $this->packing_type->OldValue = $this->packing_type->DefaultValue;
        $this->product_code_type->DefaultValue = $this->product_code_type->getDefault(); // PHP
        $this->product_code_type->OldValue = $this->product_code_type->DefaultValue;
        $this->currency->DefaultValue = $this->currency->getDefault(); // PHP
        $this->currency->OldValue = $this->currency->DefaultValue;
        $this->moq->DefaultValue = $this->moq->getDefault(); // PHP
        $this->moq->OldValue = $this->moq->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->grp->Visible = false; // Disable update for API request
            } else {
                $this->grp->setFormValue($val);
            }
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->s_grp->Visible = false; // Disable update for API request
            } else {
                $this->s_grp->setFormValue($val);
            }
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product->Visible = false; // Disable update for API request
            } else {
                $this->product->setFormValue($val);
            }
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_type->Visible = false; // Disable update for API request
            } else {
                $this->product_type->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'product_code_type' first before field var 'x_product_code_type'
        $val = $CurrentForm->hasValue("product_code_type") ? $CurrentForm->getValue("product_code_type") : $CurrentForm->getValue("x_product_code_type");
        if (!$this->product_code_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code_type->Visible = false; // Disable update for API request
            } else {
                $this->product_code_type->setFormValue($val);
            }
        }

        // Check field name 'product_code' first before field var 'x_product_code'
        $val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
        if (!$this->product_code->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->product_code->Visible = false; // Disable update for API request
            } else {
                $this->product_code->setFormValue($val);
            }
        }

        // Check field name 'v_00' first before field var 'x_v_00'
        $val = $CurrentForm->hasValue("v_00") ? $CurrentForm->getValue("v_00") : $CurrentForm->getValue("x_v_00");
        if (!$this->v_00->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_00->Visible = false; // Disable update for API request
            } else {
                $this->v_00->setFormValue($val);
            }
        }

        // Check field name 'v_01' first before field var 'x_v_01'
        $val = $CurrentForm->hasValue("v_01") ? $CurrentForm->getValue("v_01") : $CurrentForm->getValue("x_v_01");
        if (!$this->v_01->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_01->Visible = false; // Disable update for API request
            } else {
                $this->v_01->setFormValue($val);
            }
        }

        // Check field name 'v_02' first before field var 'x_v_02'
        $val = $CurrentForm->hasValue("v_02") ? $CurrentForm->getValue("v_02") : $CurrentForm->getValue("x_v_02");
        if (!$this->v_02->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_02->Visible = false; // Disable update for API request
            } else {
                $this->v_02->setFormValue($val);
            }
        }

        // Check field name 'v_03' first before field var 'x_v_03'
        $val = $CurrentForm->hasValue("v_03") ? $CurrentForm->getValue("v_03") : $CurrentForm->getValue("x_v_03");
        if (!$this->v_03->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_03->Visible = false; // Disable update for API request
            } else {
                $this->v_03->setFormValue($val);
            }
        }

        // Check field name 'v_04' first before field var 'x_v_04'
        $val = $CurrentForm->hasValue("v_04") ? $CurrentForm->getValue("v_04") : $CurrentForm->getValue("x_v_04");
        if (!$this->v_04->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_04->Visible = false; // Disable update for API request
            } else {
                $this->v_04->setFormValue($val);
            }
        }

        // Check field name 'v_05' first before field var 'x_v_05'
        $val = $CurrentForm->hasValue("v_05") ? $CurrentForm->getValue("v_05") : $CurrentForm->getValue("x_v_05");
        if (!$this->v_05->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_05->Visible = false; // Disable update for API request
            } else {
                $this->v_05->setFormValue($val);
            }
        }

        // Check field name 'v_06' first before field var 'x_v_06'
        $val = $CurrentForm->hasValue("v_06") ? $CurrentForm->getValue("v_06") : $CurrentForm->getValue("x_v_06");
        if (!$this->v_06->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_06->Visible = false; // Disable update for API request
            } else {
                $this->v_06->setFormValue($val);
            }
        }

        // Check field name 'v_07' first before field var 'x_v_07'
        $val = $CurrentForm->hasValue("v_07") ? $CurrentForm->getValue("v_07") : $CurrentForm->getValue("x_v_07");
        if (!$this->v_07->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_07->Visible = false; // Disable update for API request
            } else {
                $this->v_07->setFormValue($val);
            }
        }

        // Check field name 'v_08' first before field var 'x_v_08'
        $val = $CurrentForm->hasValue("v_08") ? $CurrentForm->getValue("v_08") : $CurrentForm->getValue("x_v_08");
        if (!$this->v_08->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_08->Visible = false; // Disable update for API request
            } else {
                $this->v_08->setFormValue($val);
            }
        }

        // Check field name 'v_09' first before field var 'x_v_09'
        $val = $CurrentForm->hasValue("v_09") ? $CurrentForm->getValue("v_09") : $CurrentForm->getValue("x_v_09");
        if (!$this->v_09->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_09->Visible = false; // Disable update for API request
            } else {
                $this->v_09->setFormValue($val);
            }
        }

        // Check field name 'v_10' first before field var 'x_v_10'
        $val = $CurrentForm->hasValue("v_10") ? $CurrentForm->getValue("v_10") : $CurrentForm->getValue("x_v_10");
        if (!$this->v_10->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->v_10->Visible = false; // Disable update for API request
            } else {
                $this->v_10->setFormValue($val);
            }
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency->Visible = false; // Disable update for API request
            } else {
                $this->currency->setFormValue($val);
            }
        }

        // Check field name 'composition' first before field var 'x_composition'
        $val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
        if (!$this->composition->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->composition->Visible = false; // Disable update for API request
            } else {
                $this->composition->setFormValue($val);
            }
        }

        // Check field name 'moq' first before field var 'x_moq'
        $val = $CurrentForm->hasValue("moq") ? $CurrentForm->getValue("moq") : $CurrentForm->getValue("x_moq");
        if (!$this->moq->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->moq->Visible = false; // Disable update for API request
            } else {
                $this->moq->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->grp->CurrentValue = $this->grp->FormValue;
        $this->s_grp->CurrentValue = $this->s_grp->FormValue;
        $this->product->CurrentValue = $this->product->FormValue;
        $this->product_type->CurrentValue = $this->product_type->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->product_code_type->CurrentValue = $this->product_code_type->FormValue;
        $this->product_code->CurrentValue = $this->product_code->FormValue;
        $this->v_00->CurrentValue = $this->v_00->FormValue;
        $this->v_01->CurrentValue = $this->v_01->FormValue;
        $this->v_02->CurrentValue = $this->v_02->FormValue;
        $this->v_03->CurrentValue = $this->v_03->FormValue;
        $this->v_04->CurrentValue = $this->v_04->FormValue;
        $this->v_05->CurrentValue = $this->v_05->FormValue;
        $this->v_06->CurrentValue = $this->v_06->FormValue;
        $this->v_07->CurrentValue = $this->v_07->FormValue;
        $this->v_08->CurrentValue = $this->v_08->FormValue;
        $this->v_09->CurrentValue = $this->v_09->FormValue;
        $this->v_10->CurrentValue = $this->v_10->FormValue;
        $this->currency->CurrentValue = $this->currency->FormValue;
        $this->composition->CurrentValue = $this->composition->FormValue;
        $this->moq->CurrentValue = $this->moq->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_type->setDbValue($row['product_type']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_code_type->setDbValue($row['product_code_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_10->setDbValue($row['v_10']);
        $this->last_price->setDbValue($row['last_price']);
        $this->currency->setDbValue($row['currency']);
        $this->composition->setDbValue($row['composition']);
        $this->moq->setDbValue($row['moq']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['product_code_type'] = $this->product_code_type->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['last_price'] = $this->last_price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['moq'] = $this->moq->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // product_code_type
        $this->product_code_type->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // v_00
        $this->v_00->RowCssClass = "row";

        // v_01
        $this->v_01->RowCssClass = "row";

        // v_02
        $this->v_02->RowCssClass = "row";

        // v_03
        $this->v_03->RowCssClass = "row";

        // v_04
        $this->v_04->RowCssClass = "row";

        // v_05
        $this->v_05->RowCssClass = "row";

        // v_06
        $this->v_06->RowCssClass = "row";

        // v_07
        $this->v_07->RowCssClass = "row";

        // v_08
        $this->v_08->RowCssClass = "row";

        // v_09
        $this->v_09->RowCssClass = "row";

        // v_10
        $this->v_10->RowCssClass = "row";

        // last_price
        $this->last_price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // composition
        $this->composition->RowCssClass = "row";

        // moq
        $this->moq->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_code_type
            if (strval($this->product_code_type->CurrentValue) != "") {
                $this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
            } else {
                $this->product_code_type->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $curVal = strval($this->v_01->CurrentValue);
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
                if ($this->v_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_01->Lookup->renderViewRow($rswrk[0]);
                        $this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
                    } else {
                        $this->v_01->ViewValue = $this->v_01->CurrentValue;
                    }
                }
            } else {
                $this->v_01->ViewValue = null;
            }

            // v_02
            $curVal = strval($this->v_02->CurrentValue);
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
                if ($this->v_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_02->Lookup->renderViewRow($rswrk[0]);
                        $this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
                    } else {
                        $this->v_02->ViewValue = $this->v_02->CurrentValue;
                    }
                }
            } else {
                $this->v_02->ViewValue = null;
            }

            // v_03
            $curVal = strval($this->v_03->CurrentValue);
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
                if ($this->v_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_03->Lookup->renderViewRow($rswrk[0]);
                        $this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
                    } else {
                        $this->v_03->ViewValue = $this->v_03->CurrentValue;
                    }
                }
            } else {
                $this->v_03->ViewValue = null;
            }

            // v_04
            $curVal = strval($this->v_04->CurrentValue);
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
                if ($this->v_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_04->Lookup->renderViewRow($rswrk[0]);
                        $this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
                    } else {
                        $this->v_04->ViewValue = $this->v_04->CurrentValue;
                    }
                }
            } else {
                $this->v_04->ViewValue = null;
            }

            // v_05
            $curVal = strval($this->v_05->CurrentValue);
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
                if ($this->v_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_05->Lookup->renderViewRow($rswrk[0]);
                        $this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
                    } else {
                        $this->v_05->ViewValue = $this->v_05->CurrentValue;
                    }
                }
            } else {
                $this->v_05->ViewValue = null;
            }

            // v_06
            $curVal = strval($this->v_06->CurrentValue);
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
                if ($this->v_06->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_06->Lookup->renderViewRow($rswrk[0]);
                        $this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
                    } else {
                        $this->v_06->ViewValue = $this->v_06->CurrentValue;
                    }
                }
            } else {
                $this->v_06->ViewValue = null;
            }

            // v_07
            $curVal = strval($this->v_07->CurrentValue);
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
                if ($this->v_07->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_07->Lookup->renderViewRow($rswrk[0]);
                        $this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
                    } else {
                        $this->v_07->ViewValue = $this->v_07->CurrentValue;
                    }
                }
            } else {
                $this->v_07->ViewValue = null;
            }

            // v_08
            $curVal = strval($this->v_08->CurrentValue);
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
                if ($this->v_08->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_08->Lookup->renderViewRow($rswrk[0]);
                        $this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
                    } else {
                        $this->v_08->ViewValue = $this->v_08->CurrentValue;
                    }
                }
            } else {
                $this->v_08->ViewValue = null;
            }

            // v_09
            $curVal = strval($this->v_09->CurrentValue);
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
                if ($this->v_09->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_09->Lookup->renderViewRow($rswrk[0]);
                        $this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
                    } else {
                        $this->v_09->ViewValue = $this->v_09->CurrentValue;
                    }
                }
            } else {
                $this->v_09->ViewValue = null;
            }

            // v_10
            $curVal = strval($this->v_10->CurrentValue);
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
                if ($this->v_10->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_10->Lookup->renderViewRow($rswrk[0]);
                        $this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
                    } else {
                        $this->v_10->ViewValue = $this->v_10->CurrentValue;
                    }
                }
            } else {
                $this->v_10->ViewValue = null;
            }

            // last_price
            $this->last_price->ViewValue = $this->last_price->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // moq
            $this->moq->ViewValue = $this->moq->CurrentValue;
            $this->moq->ViewValue = FormatNumber($this->moq->ViewValue, $this->moq->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // product_type
            $this->product_type->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // v_00
            $this->v_00->HrefValue = "";

            // v_01
            $this->v_01->HrefValue = "";

            // v_02
            $this->v_02->HrefValue = "";

            // v_03
            $this->v_03->HrefValue = "";

            // v_04
            $this->v_04->HrefValue = "";

            // v_05
            $this->v_05->HrefValue = "";

            // v_06
            $this->v_06->HrefValue = "";

            // v_07
            $this->v_07->HrefValue = "";

            // v_08
            $this->v_08->HrefValue = "";

            // v_09
            $this->v_09->HrefValue = "";

            // v_10
            $this->v_10->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // moq
            $this->moq->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->CurrentValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // product_code_type
            $this->product_code_type->setupEditAttributes();
            $this->product_code_type->EditValue = $this->product_code_type->options(true);
            $this->product_code_type->PlaceHolder = RemoveHtml($this->product_code_type->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            $this->product_code->EditValue = HtmlEncode($this->product_code->CurrentValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->CurrentValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // v_01
            $this->v_01->setupEditAttributes();
            $curVal = trim(strval($this->v_01->CurrentValue));
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
            } else {
                $this->v_01->ViewValue = $this->v_01->Lookup !== null && is_array($this->v_01->lookupOptions()) && count($this->v_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_01->ViewValue !== null) { // Load from cache
                $this->v_01->EditValue = array_values($this->v_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_01->CurrentValue, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_01->EditValue = $arwrk;
            }
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_02
            $this->v_02->setupEditAttributes();
            $curVal = trim(strval($this->v_02->CurrentValue));
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
            } else {
                $this->v_02->ViewValue = $this->v_02->Lookup !== null && is_array($this->v_02->lookupOptions()) && count($this->v_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_02->ViewValue !== null) { // Load from cache
                $this->v_02->EditValue = array_values($this->v_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_02->CurrentValue, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_02->EditValue = $arwrk;
            }
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_03
            $this->v_03->setupEditAttributes();
            $curVal = trim(strval($this->v_03->CurrentValue));
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
            } else {
                $this->v_03->ViewValue = $this->v_03->Lookup !== null && is_array($this->v_03->lookupOptions()) && count($this->v_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_03->ViewValue !== null) { // Load from cache
                $this->v_03->EditValue = array_values($this->v_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_03->CurrentValue, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_03->EditValue = $arwrk;
            }
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_04
            $this->v_04->setupEditAttributes();
            $curVal = trim(strval($this->v_04->CurrentValue));
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
            } else {
                $this->v_04->ViewValue = $this->v_04->Lookup !== null && is_array($this->v_04->lookupOptions()) && count($this->v_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_04->ViewValue !== null) { // Load from cache
                $this->v_04->EditValue = array_values($this->v_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_04->CurrentValue, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_04->EditValue = $arwrk;
            }
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_05
            $this->v_05->setupEditAttributes();
            $curVal = trim(strval($this->v_05->CurrentValue));
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
            } else {
                $this->v_05->ViewValue = $this->v_05->Lookup !== null && is_array($this->v_05->lookupOptions()) && count($this->v_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_05->ViewValue !== null) { // Load from cache
                $this->v_05->EditValue = array_values($this->v_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_05->CurrentValue, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_05->EditValue = $arwrk;
            }
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // v_06
            $this->v_06->setupEditAttributes();
            $curVal = trim(strval($this->v_06->CurrentValue));
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
            } else {
                $this->v_06->ViewValue = $this->v_06->Lookup !== null && is_array($this->v_06->lookupOptions()) && count($this->v_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_06->ViewValue !== null) { // Load from cache
                $this->v_06->EditValue = array_values($this->v_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_06->CurrentValue, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_06->EditValue = $arwrk;
            }
            $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

            // v_07
            $this->v_07->setupEditAttributes();
            $curVal = trim(strval($this->v_07->CurrentValue));
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
            } else {
                $this->v_07->ViewValue = $this->v_07->Lookup !== null && is_array($this->v_07->lookupOptions()) && count($this->v_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_07->ViewValue !== null) { // Load from cache
                $this->v_07->EditValue = array_values($this->v_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_07->CurrentValue, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_07->EditValue = $arwrk;
            }
            $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

            // v_08
            $this->v_08->setupEditAttributes();
            $curVal = trim(strval($this->v_08->CurrentValue));
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
            } else {
                $this->v_08->ViewValue = $this->v_08->Lookup !== null && is_array($this->v_08->lookupOptions()) && count($this->v_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_08->ViewValue !== null) { // Load from cache
                $this->v_08->EditValue = array_values($this->v_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_08->CurrentValue, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_08->EditValue = $arwrk;
            }
            $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

            // v_09
            $this->v_09->setupEditAttributes();
            $curVal = trim(strval($this->v_09->CurrentValue));
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
            } else {
                $this->v_09->ViewValue = $this->v_09->Lookup !== null && is_array($this->v_09->lookupOptions()) && count($this->v_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_09->ViewValue !== null) { // Load from cache
                $this->v_09->EditValue = array_values($this->v_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_09->CurrentValue, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_09->EditValue = $arwrk;
            }
            $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

            // v_10
            $this->v_10->setupEditAttributes();
            $curVal = trim(strval($this->v_10->CurrentValue));
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
            } else {
                $this->v_10->ViewValue = $this->v_10->Lookup !== null && is_array($this->v_10->lookupOptions()) && count($this->v_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_10->ViewValue !== null) { // Load from cache
                $this->v_10->EditValue = array_values($this->v_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_10->CurrentValue, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_10->EditValue = $arwrk;
            }
            $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // composition
            $this->composition->setupEditAttributes();
            $curVal = trim(strval($this->composition->CurrentValue));
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
            } else {
                $this->composition->ViewValue = $this->composition->Lookup !== null && is_array($this->composition->lookupOptions()) && count($this->composition->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->composition->ViewValue !== null) { // Load from cache
                $this->composition->EditValue = array_values($this->composition->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->composition->CurrentValue, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->composition->EditValue = $arwrk;
            }
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // moq
            $this->moq->setupEditAttributes();
            $this->moq->EditValue = $this->moq->CurrentValue;
            $this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
            if (strval($this->moq->EditValue) != "" && is_numeric($this->moq->EditValue)) {
                $this->moq->EditValue = FormatNumber($this->moq->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // Add refer script

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // product_type
            $this->product_type->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // v_00
            $this->v_00->HrefValue = "";

            // v_01
            $this->v_01->HrefValue = "";

            // v_02
            $this->v_02->HrefValue = "";

            // v_03
            $this->v_03->HrefValue = "";

            // v_04
            $this->v_04->HrefValue = "";

            // v_05
            $this->v_05->HrefValue = "";

            // v_06
            $this->v_06->HrefValue = "";

            // v_07
            $this->v_07->HrefValue = "";

            // v_08
            $this->v_08->HrefValue = "";

            // v_09
            $this->v_09->HrefValue = "";

            // v_10
            $this->v_10->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // moq
            $this->moq->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->product_code_type->Visible && $this->product_code_type->Required) {
                if (!$this->product_code_type->IsDetailKey && EmptyValue($this->product_code_type->FormValue)) {
                    $this->product_code_type->addErrorMessage(str_replace("%s", $this->product_code_type->caption(), $this->product_code_type->RequiredErrorMessage));
                }
            }
            if ($this->product_code->Visible && $this->product_code->Required) {
                if (!$this->product_code->IsDetailKey && EmptyValue($this->product_code->FormValue)) {
                    $this->product_code->addErrorMessage(str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
                }
            }
            if ($this->v_00->Visible && $this->v_00->Required) {
                if (!$this->v_00->IsDetailKey && EmptyValue($this->v_00->FormValue)) {
                    $this->v_00->addErrorMessage(str_replace("%s", $this->v_00->caption(), $this->v_00->RequiredErrorMessage));
                }
            }
            if ($this->v_01->Visible && $this->v_01->Required) {
                if (!$this->v_01->IsDetailKey && EmptyValue($this->v_01->FormValue)) {
                    $this->v_01->addErrorMessage(str_replace("%s", $this->v_01->caption(), $this->v_01->RequiredErrorMessage));
                }
            }
            if ($this->v_02->Visible && $this->v_02->Required) {
                if (!$this->v_02->IsDetailKey && EmptyValue($this->v_02->FormValue)) {
                    $this->v_02->addErrorMessage(str_replace("%s", $this->v_02->caption(), $this->v_02->RequiredErrorMessage));
                }
            }
            if ($this->v_03->Visible && $this->v_03->Required) {
                if (!$this->v_03->IsDetailKey && EmptyValue($this->v_03->FormValue)) {
                    $this->v_03->addErrorMessage(str_replace("%s", $this->v_03->caption(), $this->v_03->RequiredErrorMessage));
                }
            }
            if ($this->v_04->Visible && $this->v_04->Required) {
                if (!$this->v_04->IsDetailKey && EmptyValue($this->v_04->FormValue)) {
                    $this->v_04->addErrorMessage(str_replace("%s", $this->v_04->caption(), $this->v_04->RequiredErrorMessage));
                }
            }
            if ($this->v_05->Visible && $this->v_05->Required) {
                if (!$this->v_05->IsDetailKey && EmptyValue($this->v_05->FormValue)) {
                    $this->v_05->addErrorMessage(str_replace("%s", $this->v_05->caption(), $this->v_05->RequiredErrorMessage));
                }
            }
            if ($this->v_06->Visible && $this->v_06->Required) {
                if (!$this->v_06->IsDetailKey && EmptyValue($this->v_06->FormValue)) {
                    $this->v_06->addErrorMessage(str_replace("%s", $this->v_06->caption(), $this->v_06->RequiredErrorMessage));
                }
            }
            if ($this->v_07->Visible && $this->v_07->Required) {
                if (!$this->v_07->IsDetailKey && EmptyValue($this->v_07->FormValue)) {
                    $this->v_07->addErrorMessage(str_replace("%s", $this->v_07->caption(), $this->v_07->RequiredErrorMessage));
                }
            }
            if ($this->v_08->Visible && $this->v_08->Required) {
                if (!$this->v_08->IsDetailKey && EmptyValue($this->v_08->FormValue)) {
                    $this->v_08->addErrorMessage(str_replace("%s", $this->v_08->caption(), $this->v_08->RequiredErrorMessage));
                }
            }
            if ($this->v_09->Visible && $this->v_09->Required) {
                if (!$this->v_09->IsDetailKey && EmptyValue($this->v_09->FormValue)) {
                    $this->v_09->addErrorMessage(str_replace("%s", $this->v_09->caption(), $this->v_09->RequiredErrorMessage));
                }
            }
            if ($this->v_10->Visible && $this->v_10->Required) {
                if (!$this->v_10->IsDetailKey && EmptyValue($this->v_10->FormValue)) {
                    $this->v_10->addErrorMessage(str_replace("%s", $this->v_10->caption(), $this->v_10->RequiredErrorMessage));
                }
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->composition->Visible && $this->composition->Required) {
                if (!$this->composition->IsDetailKey && EmptyValue($this->composition->FormValue)) {
                    $this->composition->addErrorMessage(str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
                }
            }
            if ($this->moq->Visible && $this->moq->Required) {
                if (!$this->moq->IsDetailKey && EmptyValue($this->moq->FormValue)) {
                    $this->moq->addErrorMessage(str_replace("%s", $this->moq->caption(), $this->moq->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->moq->FormValue)) {
                $this->moq->addErrorMessage($this->moq->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Validate detail grid
        $detailTblVar = explode(",", $this->getCurrentDetailTable());
        $detailPage = Container("MultiplePriceGrid");
        if (in_array("multiple_price", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }
        $detailPage = Container("PartnerProductRefGrid");
        if (in_array("partner_product_ref", $detailTblVar) && $detailPage->DetailAdd) {
            $detailPage->run();
            $validateForm = $validateForm && $detailPage->validateGridForm();
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Begin transaction
        if ($this->getCurrentDetailTable() != "" && $this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }

        // Add detail records
        if ($addRow) {
            $detailTblVar = explode(",", $this->getCurrentDetailTable());
            $detailPage = Container("MultiplePriceGrid");
            if (in_array("multiple_price", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->code->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "multiple_price"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->code->setSessionValue(""); // Clear master key if insert failed
                }
            }
            $detailPage = Container("PartnerProductRefGrid");
            if (in_array("partner_product_ref", $detailTblVar) && $detailPage->DetailAdd && $addRow) {
                $detailPage->rid->setSessionValue($this->id->CurrentValue); // Set master key
                $Security->loadCurrentUserLevel($this->ProjectID . "partner_product_ref"); // Load user level of detail table
                $addRow = $detailPage->gridInsert();
                $Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
                if (!$addRow) {
                $detailPage->rid->setSessionValue(""); // Clear master key if insert failed
                }
            }
        }

        // Commit/Rollback transaction
        if ($this->getCurrentDetailTable() != "") {
            if ($addRow) {
                if ($this->UseTransaction) { // Commit transaction
                    if ($conn->isTransactionActive()) {
                        $conn->commit();
                    }
                }
            } else {
                if ($this->UseTransaction) { // Rollback transaction
                    if ($conn->isTransactionActive()) {
                        $conn->rollback();
                    }
                }
            }
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // grp
        $this->grp->setDbValueDef($rsnew, $this->grp->CurrentValue, false);

        // s_grp
        $this->s_grp->setDbValueDef($rsnew, $this->s_grp->CurrentValue, false);

        // product
        $this->product->setDbValueDef($rsnew, $this->product->CurrentValue, false);

        // product_type
        $this->product_type->setDbValueDef($rsnew, $this->product_type->CurrentValue, strval($this->product_type->CurrentValue) == "");

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, strval($this->packing_type->CurrentValue) == "");

        // product_code_type
        $this->product_code_type->setDbValueDef($rsnew, $this->product_code_type->CurrentValue, strval($this->product_code_type->CurrentValue) == "");

        // product_code
        $this->product_code->setDbValueDef($rsnew, $this->product_code->CurrentValue, false);

        // v_00
        $this->v_00->setDbValueDef($rsnew, $this->v_00->CurrentValue, false);

        // v_01
        $this->v_01->setDbValueDef($rsnew, $this->v_01->CurrentValue, false);

        // v_02
        $this->v_02->setDbValueDef($rsnew, $this->v_02->CurrentValue, false);

        // v_03
        $this->v_03->setDbValueDef($rsnew, $this->v_03->CurrentValue, false);

        // v_04
        $this->v_04->setDbValueDef($rsnew, $this->v_04->CurrentValue, false);

        // v_05
        $this->v_05->setDbValueDef($rsnew, $this->v_05->CurrentValue, false);

        // v_06
        $this->v_06->setDbValueDef($rsnew, $this->v_06->CurrentValue, false);

        // v_07
        $this->v_07->setDbValueDef($rsnew, $this->v_07->CurrentValue, false);

        // v_08
        $this->v_08->setDbValueDef($rsnew, $this->v_08->CurrentValue, false);

        // v_09
        $this->v_09->setDbValueDef($rsnew, $this->v_09->CurrentValue, false);

        // v_10
        $this->v_10->setDbValueDef($rsnew, $this->v_10->CurrentValue, false);

        // currency
        $this->currency->setDbValueDef($rsnew, $this->currency->CurrentValue, strval($this->currency->CurrentValue) == "");

        // composition
        $this->composition->setDbValueDef($rsnew, $this->composition->CurrentValue, strval($this->composition->CurrentValue) == "");

        // moq
        $this->moq->setDbValueDef($rsnew, $this->moq->CurrentValue, strval($this->moq->CurrentValue) == "");

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['grp'])) { // grp
            $this->grp->setFormValue($row['grp']);
        }
        if (isset($row['s_grp'])) { // s_grp
            $this->s_grp->setFormValue($row['s_grp']);
        }
        if (isset($row['product'])) { // product
            $this->product->setFormValue($row['product']);
        }
        if (isset($row['product_type'])) { // product_type
            $this->product_type->setFormValue($row['product_type']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['product_code_type'])) { // product_code_type
            $this->product_code_type->setFormValue($row['product_code_type']);
        }
        if (isset($row['product_code'])) { // product_code
            $this->product_code->setFormValue($row['product_code']);
        }
        if (isset($row['v_00'])) { // v_00
            $this->v_00->setFormValue($row['v_00']);
        }
        if (isset($row['v_01'])) { // v_01
            $this->v_01->setFormValue($row['v_01']);
        }
        if (isset($row['v_02'])) { // v_02
            $this->v_02->setFormValue($row['v_02']);
        }
        if (isset($row['v_03'])) { // v_03
            $this->v_03->setFormValue($row['v_03']);
        }
        if (isset($row['v_04'])) { // v_04
            $this->v_04->setFormValue($row['v_04']);
        }
        if (isset($row['v_05'])) { // v_05
            $this->v_05->setFormValue($row['v_05']);
        }
        if (isset($row['v_06'])) { // v_06
            $this->v_06->setFormValue($row['v_06']);
        }
        if (isset($row['v_07'])) { // v_07
            $this->v_07->setFormValue($row['v_07']);
        }
        if (isset($row['v_08'])) { // v_08
            $this->v_08->setFormValue($row['v_08']);
        }
        if (isset($row['v_09'])) { // v_09
            $this->v_09->setFormValue($row['v_09']);
        }
        if (isset($row['v_10'])) { // v_10
            $this->v_10->setFormValue($row['v_10']);
        }
        if (isset($row['currency'])) { // currency
            $this->currency->setFormValue($row['currency']);
        }
        if (isset($row['composition'])) { // composition
            $this->composition->setFormValue($row['composition']);
        }
        if (isset($row['moq'])) { // moq
            $this->moq->setFormValue($row['moq']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
    }

    // Set up detail parms based on QueryString
    protected function setupDetailParms()
    {
        // Get the keys for master table
        $detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
        if ($detailTblVar !== null) {
            $this->setCurrentDetailTable($detailTblVar);
        } else {
            $detailTblVar = $this->getCurrentDetailTable();
        }
        if ($detailTblVar != "") {
            $detailTblVar = explode(",", $detailTblVar);
            if (in_array("multiple_price", $detailTblVar)) {
                $detailPageObj = Container("MultiplePriceGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->code->IsDetailKey = true;
                    $detailPageObj->code->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->code->setSessionValue($detailPageObj->code->CurrentValue);
                }
            }
            if (in_array("partner_product_ref", $detailTblVar)) {
                $detailPageObj = Container("PartnerProductRefGrid");
                if ($detailPageObj->DetailAdd) {
                    $detailPageObj->EventCancelled = $this->EventCancelled;
                    if ($this->CopyRecord) {
                        $detailPageObj->CurrentMode = "copy";
                    } else {
                        $detailPageObj->CurrentMode = "add";
                    }
                    $detailPageObj->CurrentAction = "gridadd";

                    // Save current master table to detail table
                    $detailPageObj->setCurrentMasterTable($this->TableVar);
                    $detailPageObj->setStartRecordNumber(1);
                    $detailPageObj->rid->IsDetailKey = true;
                    $detailPageObj->rid->CurrentValue = $this->id->CurrentValue;
                    $detailPageObj->rid->setSessionValue($detailPageObj->rid->CurrentValue);
                }
            }
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("refcodelist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Set up multi pages
    protected function setupMultiPages()
    {
        $pages = new SubPages();
        $pages->Style = "accordion";
        if ($pages->isAccordion()) {
            $pages->Parent = "#accordion_" . $this->PageObjName;
        }
        $pages->add(0);
        $pages->add(1);
        $pages->add(2);
        $this->MultiPages = $pages;
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code_type":
                    break;
                case "x_v_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'ref_code');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) {
    	// Return error message in CustomError
    extract($_POST,EXTR_OVERWRITE);
    	$Head = ExecuteRow("SELECT `v_01`, `v_02`, `v_03`, `v_04`, `v_05`, `v_06`, `v_07`, `v_08`, `v_09`, `v_10`, `b_01_head`, `b_02_head`, `b_03_head`, `b_04_head`, `b_05_head`, `b_06_head`, `b_07_head`, `b_08_head`,`b_09_head`,`b_10_head`,`b_11_head`,`b_12_head`, `b_13_head`,`b_14_head`,`b_15_head`, `t_01_head`, `t_02_head`, `t_03_head`, `t_04_head`, `t_05_head`, `t_06_head`, `t_07_head`,  `t_08_head`, `t_09_head`,`t_10_head`,`t_11_head`,`t_12_head`, `t_13_head`,`t_14_head`,`t_15_head` FROM `product_group` WHERE `id` = $x_s_grp LIMIT 1");
    $_SESSION[SESSION_WARNING_MESSAGE] = '';
    		if  ($Head['v_01'] != '--NA--' && ($x_v_01 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_01']. "<br>";
    		}
    		if  ($Head['v_02'] != '--NA--' && ($x_v_02 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_02']. "<br>";
    		}
    		if  ($Head['v_03'] != '--NA--' && ($x_v_03 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_03']. "<br>";
    		}
    		if  ($Head['v_04'] != '--NA--' && ($x_v_04 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_04']. "<br>";
    		}
    		if  ($Head['v_05'] != '--NA--' && ($x_v_05 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_05']. "<br>";
    		}
    		if  ($Head['v_06'] != '--NA--' && ($x_v_06 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_06']. "<br>";
    		}
    		if  ($Head['v_07'] != '--NA--' && ($x_v_07 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_07']. "<br>";
    		}
    		if  ($Head['v_08'] != '--NA--' && ($x_v_08 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_08']. "<br>";
    		}
    		if  ($Head['v_09'] != '--NA--' && ($x_v_09 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_09']. "<br>";
    		}
    		if  ($Head['v_10'] != '--NA--' && ($x_v_10 == null))
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Please Select Value for " .$Head['v_10']. "<br>";
    		}
    		if (($x_product_type) == 9)
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= "Selection of Product Specification is not Allowed. <br>";
    		}
    		if ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    		{return TRUE;}
    		else
    		{return FALSE;}
    }
}
