<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class RefAddopt extends Ref
{
    use MessagesTrait;

    // Page ID
    public $PageID = "addopt";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "RefAddopt";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "refaddopt";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->oid->setVisibility();
        $this->company_id->setVisibility();
        $this->grp->setVisibility();
        $this->s_grp->setVisibility();
        $this->product->setVisibility();
        $this->product_type->setVisibility();
        $this->packing_type->setVisibility();
        $this->product_n->Visible = false;
        $this->_barcode->setVisibility();
        $this->product_code_type->setVisibility();
        $this->product_code->setVisibility();
        $this->print_name->setVisibility();
        $this->gcode->setVisibility();
        $this->code->setVisibility();
        $this->product_id->setVisibility();
        $this->batch_no->setVisibility();
        $this->set_ref->setVisibility();
        $this->v_00->setVisibility();
        $this->v_01->setVisibility();
        $this->v_02->setVisibility();
        $this->v_03->setVisibility();
        $this->v_04->setVisibility();
        $this->v_05->setVisibility();
        $this->v_06->setVisibility();
        $this->v_07->setVisibility();
        $this->v_08->setVisibility();
        $this->v_09->setVisibility();
        $this->v_10->setVisibility();
        $this->cbm->setVisibility();
        $this->sqm->setVisibility();
        $this->shape->setVisibility();
        $this->q_sku->setVisibility();
        $this->b_01->setVisibility();
        $this->b_02->setVisibility();
        $this->b_03->setVisibility();
        $this->b_04->setVisibility();
        $this->b_05->setVisibility();
        $this->b_06->setVisibility();
        $this->b_07->setVisibility();
        $this->b_08->setVisibility();
        $this->b_09->setVisibility();
        $this->b_10->setVisibility();
        $this->b_11->setVisibility();
        $this->b_12->setVisibility();
        $this->b_13->setVisibility();
        $this->b_14->setVisibility();
        $this->b_15->setVisibility();
        $this->t_01->setVisibility();
        $this->t_02->setVisibility();
        $this->t_03->setVisibility();
        $this->t_04->setVisibility();
        $this->t_05->setVisibility();
        $this->t_06->setVisibility();
        $this->t_07->setVisibility();
        $this->t_08->setVisibility();
        $this->t_09->setVisibility();
        $this->t_10->setVisibility();
        $this->t_11->setVisibility();
        $this->t_12->setVisibility();
        $this->t_13->setVisibility();
        $this->t_14->setVisibility();
        $this->t_15->setVisibility();
        $this->last_price->setVisibility();
        $this->currency->setVisibility();
        $this->hsn->setVisibility();
        $this->composition->setVisibility();
        $this->category->setVisibility();
        $this->moq->setVisibility();
        $this->status->setVisibility();
        $this->d_head_01->setVisibility();
        $this->d_description_01->setVisibility();
        $this->d_head_02->setVisibility();
        $this->d_description_02->setVisibility();
        $this->publish->setVisibility();
        $this->keywords->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->main_image->setVisibility();
        $this->top_view->setVisibility();
        $this->front_view->setVisibility();
        $this->corner_view->setVisibility();
        $this->back_view->setVisibility();
        $this->color_options->setVisibility();
        $this->other_options->setVisibility();
        $this->group_image->setVisibility();
        $this->video_url->setVisibility();
        $this->image->setVisibility();
        $this->in->setVisibility();
        $this->out->setVisibility();
        $this->required->setVisibility();
        $this->blocked->setVisibility();
        $this->ordered->setVisibility();
        $this->supplier->setVisibility();
        $this->country->setVisibility();
        $this->minimum_stock->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'ref';
        $this->TableName = 'ref';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (ref)
        if (!isset($GLOBALS["ref"]) || $GLOBALS["ref"]::class == PROJECT_NAMESPACE . "ref") {
            $GLOBALS["ref"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
                $this->main_image->UploadPath = $this->main_image->OldUploadPath;
                $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
                $this->top_view->UploadPath = $this->top_view->OldUploadPath;
                $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
                $this->front_view->UploadPath = $this->front_view->OldUploadPath;
                $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
                $this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
                $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
                $this->back_view->UploadPath = $this->back_view->OldUploadPath;
                $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
                $this->color_options->UploadPath = $this->color_options->OldUploadPath;
                $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
                $this->other_options->UploadPath = $this->other_options->OldUploadPath;
                $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
                $this->group_image->UploadPath = $this->group_image->OldUploadPath;
                $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
                $this->image->UploadPath = $this->image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $IsModal = false;
    public $IsMobileOrModal = true; // Add option page is always modal

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->product_type);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->product_code_type);
        $this->setupLookupOptions($this->set_ref);
        $this->setupLookupOptions($this->v_01);
        $this->setupLookupOptions($this->v_02);
        $this->setupLookupOptions($this->v_03);
        $this->setupLookupOptions($this->v_04);
        $this->setupLookupOptions($this->v_05);
        $this->setupLookupOptions($this->v_06);
        $this->setupLookupOptions($this->v_07);
        $this->setupLookupOptions($this->v_08);
        $this->setupLookupOptions($this->v_09);
        $this->setupLookupOptions($this->v_10);
        $this->setupLookupOptions($this->shape);
        $this->setupLookupOptions($this->b_03);
        $this->setupLookupOptions($this->b_04);
        $this->setupLookupOptions($this->b_05);
        $this->setupLookupOptions($this->b_06);
        $this->setupLookupOptions($this->b_07);
        $this->setupLookupOptions($this->b_08);
        $this->setupLookupOptions($this->b_09);
        $this->setupLookupOptions($this->b_10);
        $this->setupLookupOptions($this->t_03);
        $this->setupLookupOptions($this->t_04);
        $this->setupLookupOptions($this->t_05);
        $this->setupLookupOptions($this->t_06);
        $this->setupLookupOptions($this->t_07);
        $this->setupLookupOptions($this->t_08);
        $this->setupLookupOptions($this->t_09);
        $this->setupLookupOptions($this->t_10);
        $this->setupLookupOptions($this->t_11);
        $this->setupLookupOptions($this->t_12);
        $this->setupLookupOptions($this->currency);
        $this->setupLookupOptions($this->hsn);
        $this->setupLookupOptions($this->composition);
        $this->setupLookupOptions($this->category);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->publish);
        $this->setupLookupOptions($this->operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Set up Breadcrumb
        // $this->setupBreadcrumb(); // Not used
        $this->loadRowValues(); // Load default values

        // Render row
        $this->RowType = RowType::ADD; // Render add type
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->main_image->Upload->Index = $CurrentForm->Index;
        $this->main_image->Upload->uploadFile();
        $this->main_image->CurrentValue = $this->main_image->Upload->FileName;
        $this->top_view->Upload->Index = $CurrentForm->Index;
        $this->top_view->Upload->uploadFile();
        $this->top_view->CurrentValue = $this->top_view->Upload->FileName;
        $this->front_view->Upload->Index = $CurrentForm->Index;
        $this->front_view->Upload->uploadFile();
        $this->front_view->CurrentValue = $this->front_view->Upload->FileName;
        $this->corner_view->Upload->Index = $CurrentForm->Index;
        $this->corner_view->Upload->uploadFile();
        $this->corner_view->CurrentValue = $this->corner_view->Upload->FileName;
        $this->back_view->Upload->Index = $CurrentForm->Index;
        $this->back_view->Upload->uploadFile();
        $this->back_view->CurrentValue = $this->back_view->Upload->FileName;
        $this->color_options->Upload->Index = $CurrentForm->Index;
        $this->color_options->Upload->uploadFile();
        $this->color_options->CurrentValue = $this->color_options->Upload->FileName;
        $this->other_options->Upload->Index = $CurrentForm->Index;
        $this->other_options->Upload->uploadFile();
        $this->other_options->CurrentValue = $this->other_options->Upload->FileName;
        $this->group_image->Upload->Index = $CurrentForm->Index;
        $this->group_image->Upload->uploadFile();
        $this->group_image->CurrentValue = $this->group_image->Upload->FileName;
        $this->image->Upload->Index = $CurrentForm->Index;
        $this->image->Upload->uploadFile();
        $this->image->CurrentValue = $this->image->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->company_id->DefaultValue = $this->company_id->getDefault(); // PHP
        $this->company_id->OldValue = $this->company_id->DefaultValue;
        $this->product_type->DefaultValue = $this->product_type->getDefault(); // PHP
        $this->product_type->OldValue = $this->product_type->DefaultValue;
        $this->packing_type->DefaultValue = $this->packing_type->getDefault(); // PHP
        $this->packing_type->OldValue = $this->packing_type->DefaultValue;
        $this->product_code_type->DefaultValue = $this->product_code_type->getDefault(); // PHP
        $this->product_code_type->OldValue = $this->product_code_type->DefaultValue;
        $this->q_sku->DefaultValue = $this->q_sku->getDefault(); // PHP
        $this->q_sku->OldValue = $this->q_sku->DefaultValue;
        $this->currency->DefaultValue = $this->currency->getDefault(); // PHP
        $this->currency->OldValue = $this->currency->DefaultValue;
        $this->moq->DefaultValue = $this->moq->getDefault(); // PHP
        $this->moq->OldValue = $this->moq->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->publish->DefaultValue = $this->publish->getDefault(); // PHP
        $this->publish->OldValue = $this->publish->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->minimum_stock->DefaultValue = $this->minimum_stock->getDefault(); // PHP
        $this->minimum_stock->OldValue = $this->minimum_stock->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'oid' first before field var 'x_oid'
        $val = $CurrentForm->hasValue("oid") ? $CurrentForm->getValue("oid") : $CurrentForm->getValue("x_oid");
        if (!$this->oid->IsDetailKey) {
            $this->oid->setFormValue($val, true, $validate);
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            $this->company_id->setFormValue($val);
        }

        // Check field name 'grp' first before field var 'x_grp'
        $val = $CurrentForm->hasValue("grp") ? $CurrentForm->getValue("grp") : $CurrentForm->getValue("x_grp");
        if (!$this->grp->IsDetailKey) {
            $this->grp->setFormValue($val);
        }

        // Check field name 's_grp' first before field var 'x_s_grp'
        $val = $CurrentForm->hasValue("s_grp") ? $CurrentForm->getValue("s_grp") : $CurrentForm->getValue("x_s_grp");
        if (!$this->s_grp->IsDetailKey) {
            $this->s_grp->setFormValue($val);
        }

        // Check field name 'product' first before field var 'x_product'
        $val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
        if (!$this->product->IsDetailKey) {
            $this->product->setFormValue($val);
        }

        // Check field name 'product_type' first before field var 'x_product_type'
        $val = $CurrentForm->hasValue("product_type") ? $CurrentForm->getValue("product_type") : $CurrentForm->getValue("x_product_type");
        if (!$this->product_type->IsDetailKey) {
            $this->product_type->setFormValue($val);
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            $this->packing_type->setFormValue($val);
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            $this->_barcode->setFormValue($val);
        }

        // Check field name 'product_code_type' first before field var 'x_product_code_type'
        $val = $CurrentForm->hasValue("product_code_type") ? $CurrentForm->getValue("product_code_type") : $CurrentForm->getValue("x_product_code_type");
        if (!$this->product_code_type->IsDetailKey) {
            $this->product_code_type->setFormValue($val);
        }

        // Check field name 'product_code' first before field var 'x_product_code'
        $val = $CurrentForm->hasValue("product_code") ? $CurrentForm->getValue("product_code") : $CurrentForm->getValue("x_product_code");
        if (!$this->product_code->IsDetailKey) {
            $this->product_code->setFormValue($val);
        }

        // Check field name 'print_name' first before field var 'x_print_name'
        $val = $CurrentForm->hasValue("print_name") ? $CurrentForm->getValue("print_name") : $CurrentForm->getValue("x_print_name");
        if (!$this->print_name->IsDetailKey) {
            $this->print_name->setFormValue($val, true, $validate);
        }

        // Check field name 'gcode' first before field var 'x_gcode'
        $val = $CurrentForm->hasValue("gcode") ? $CurrentForm->getValue("gcode") : $CurrentForm->getValue("x_gcode");
        if (!$this->gcode->IsDetailKey) {
            $this->gcode->setFormValue($val);
        }

        // Check field name 'code' first before field var 'x_code'
        $val = $CurrentForm->hasValue("code") ? $CurrentForm->getValue("code") : $CurrentForm->getValue("x_code");
        if (!$this->code->IsDetailKey) {
            $this->code->setFormValue($val);
        }

        // Check field name 'product_id' first before field var 'x_product_id'
        $val = $CurrentForm->hasValue("product_id") ? $CurrentForm->getValue("product_id") : $CurrentForm->getValue("x_product_id");
        if (!$this->product_id->IsDetailKey) {
            $this->product_id->setFormValue($val);
        }

        // Check field name 'batch_no' first before field var 'x_batch_no'
        $val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
        if (!$this->batch_no->IsDetailKey) {
            $this->batch_no->setFormValue($val);
        }

        // Check field name 'set_ref' first before field var 'x_set_ref'
        $val = $CurrentForm->hasValue("set_ref") ? $CurrentForm->getValue("set_ref") : $CurrentForm->getValue("x_set_ref");
        if (!$this->set_ref->IsDetailKey) {
            $this->set_ref->setFormValue($val);
        }

        // Check field name 'v_00' first before field var 'x_v_00'
        $val = $CurrentForm->hasValue("v_00") ? $CurrentForm->getValue("v_00") : $CurrentForm->getValue("x_v_00");
        if (!$this->v_00->IsDetailKey) {
            $this->v_00->setFormValue($val);
        }

        // Check field name 'v_01' first before field var 'x_v_01'
        $val = $CurrentForm->hasValue("v_01") ? $CurrentForm->getValue("v_01") : $CurrentForm->getValue("x_v_01");
        if (!$this->v_01->IsDetailKey) {
            $this->v_01->setFormValue($val);
        }

        // Check field name 'v_02' first before field var 'x_v_02'
        $val = $CurrentForm->hasValue("v_02") ? $CurrentForm->getValue("v_02") : $CurrentForm->getValue("x_v_02");
        if (!$this->v_02->IsDetailKey) {
            $this->v_02->setFormValue($val);
        }

        // Check field name 'v_03' first before field var 'x_v_03'
        $val = $CurrentForm->hasValue("v_03") ? $CurrentForm->getValue("v_03") : $CurrentForm->getValue("x_v_03");
        if (!$this->v_03->IsDetailKey) {
            $this->v_03->setFormValue($val);
        }

        // Check field name 'v_04' first before field var 'x_v_04'
        $val = $CurrentForm->hasValue("v_04") ? $CurrentForm->getValue("v_04") : $CurrentForm->getValue("x_v_04");
        if (!$this->v_04->IsDetailKey) {
            $this->v_04->setFormValue($val);
        }

        // Check field name 'v_05' first before field var 'x_v_05'
        $val = $CurrentForm->hasValue("v_05") ? $CurrentForm->getValue("v_05") : $CurrentForm->getValue("x_v_05");
        if (!$this->v_05->IsDetailKey) {
            $this->v_05->setFormValue($val);
        }

        // Check field name 'v_06' first before field var 'x_v_06'
        $val = $CurrentForm->hasValue("v_06") ? $CurrentForm->getValue("v_06") : $CurrentForm->getValue("x_v_06");
        if (!$this->v_06->IsDetailKey) {
            $this->v_06->setFormValue($val);
        }

        // Check field name 'v_07' first before field var 'x_v_07'
        $val = $CurrentForm->hasValue("v_07") ? $CurrentForm->getValue("v_07") : $CurrentForm->getValue("x_v_07");
        if (!$this->v_07->IsDetailKey) {
            $this->v_07->setFormValue($val);
        }

        // Check field name 'v_08' first before field var 'x_v_08'
        $val = $CurrentForm->hasValue("v_08") ? $CurrentForm->getValue("v_08") : $CurrentForm->getValue("x_v_08");
        if (!$this->v_08->IsDetailKey) {
            $this->v_08->setFormValue($val);
        }

        // Check field name 'v_09' first before field var 'x_v_09'
        $val = $CurrentForm->hasValue("v_09") ? $CurrentForm->getValue("v_09") : $CurrentForm->getValue("x_v_09");
        if (!$this->v_09->IsDetailKey) {
            $this->v_09->setFormValue($val);
        }

        // Check field name 'v_10' first before field var 'x_v_10'
        $val = $CurrentForm->hasValue("v_10") ? $CurrentForm->getValue("v_10") : $CurrentForm->getValue("x_v_10");
        if (!$this->v_10->IsDetailKey) {
            $this->v_10->setFormValue($val);
        }

        // Check field name 'cbm' first before field var 'x_cbm'
        $val = $CurrentForm->hasValue("cbm") ? $CurrentForm->getValue("cbm") : $CurrentForm->getValue("x_cbm");
        if (!$this->cbm->IsDetailKey) {
            $this->cbm->setFormValue($val);
        }

        // Check field name 'sqm' first before field var 'x_sqm'
        $val = $CurrentForm->hasValue("sqm") ? $CurrentForm->getValue("sqm") : $CurrentForm->getValue("x_sqm");
        if (!$this->sqm->IsDetailKey) {
            $this->sqm->setFormValue($val);
        }

        // Check field name 'shape' first before field var 'x_shape'
        $val = $CurrentForm->hasValue("shape") ? $CurrentForm->getValue("shape") : $CurrentForm->getValue("x_shape");
        if (!$this->shape->IsDetailKey) {
            $this->shape->setFormValue($val);
        }

        // Check field name 'q_sku' first before field var 'x_q_sku'
        $val = $CurrentForm->hasValue("q_sku") ? $CurrentForm->getValue("q_sku") : $CurrentForm->getValue("x_q_sku");
        if (!$this->q_sku->IsDetailKey) {
            $this->q_sku->setFormValue($val, true, $validate);
        }

        // Check field name 'b_01' first before field var 'x_b_01'
        $val = $CurrentForm->hasValue("b_01") ? $CurrentForm->getValue("b_01") : $CurrentForm->getValue("x_b_01");
        if (!$this->b_01->IsDetailKey) {
            $this->b_01->setFormValue($val);
        }

        // Check field name 'b_02' first before field var 'x_b_02'
        $val = $CurrentForm->hasValue("b_02") ? $CurrentForm->getValue("b_02") : $CurrentForm->getValue("x_b_02");
        if (!$this->b_02->IsDetailKey) {
            $this->b_02->setFormValue($val);
        }

        // Check field name 'b_03' first before field var 'x_b_03'
        $val = $CurrentForm->hasValue("b_03") ? $CurrentForm->getValue("b_03") : $CurrentForm->getValue("x_b_03");
        if (!$this->b_03->IsDetailKey) {
            $this->b_03->setFormValue($val);
        }

        // Check field name 'b_04' first before field var 'x_b_04'
        $val = $CurrentForm->hasValue("b_04") ? $CurrentForm->getValue("b_04") : $CurrentForm->getValue("x_b_04");
        if (!$this->b_04->IsDetailKey) {
            $this->b_04->setFormValue($val);
        }

        // Check field name 'b_05' first before field var 'x_b_05'
        $val = $CurrentForm->hasValue("b_05") ? $CurrentForm->getValue("b_05") : $CurrentForm->getValue("x_b_05");
        if (!$this->b_05->IsDetailKey) {
            $this->b_05->setFormValue($val);
        }

        // Check field name 'b_06' first before field var 'x_b_06'
        $val = $CurrentForm->hasValue("b_06") ? $CurrentForm->getValue("b_06") : $CurrentForm->getValue("x_b_06");
        if (!$this->b_06->IsDetailKey) {
            $this->b_06->setFormValue($val);
        }

        // Check field name 'b_07' first before field var 'x_b_07'
        $val = $CurrentForm->hasValue("b_07") ? $CurrentForm->getValue("b_07") : $CurrentForm->getValue("x_b_07");
        if (!$this->b_07->IsDetailKey) {
            $this->b_07->setFormValue($val);
        }

        // Check field name 'b_08' first before field var 'x_b_08'
        $val = $CurrentForm->hasValue("b_08") ? $CurrentForm->getValue("b_08") : $CurrentForm->getValue("x_b_08");
        if (!$this->b_08->IsDetailKey) {
            $this->b_08->setFormValue($val);
        }

        // Check field name 'b_09' first before field var 'x_b_09'
        $val = $CurrentForm->hasValue("b_09") ? $CurrentForm->getValue("b_09") : $CurrentForm->getValue("x_b_09");
        if (!$this->b_09->IsDetailKey) {
            $this->b_09->setFormValue($val);
        }

        // Check field name 'b_10' first before field var 'x_b_10'
        $val = $CurrentForm->hasValue("b_10") ? $CurrentForm->getValue("b_10") : $CurrentForm->getValue("x_b_10");
        if (!$this->b_10->IsDetailKey) {
            $this->b_10->setFormValue($val);
        }

        // Check field name 'b_11' first before field var 'x_b_11'
        $val = $CurrentForm->hasValue("b_11") ? $CurrentForm->getValue("b_11") : $CurrentForm->getValue("x_b_11");
        if (!$this->b_11->IsDetailKey) {
            $this->b_11->setFormValue($val);
        }

        // Check field name 'b_12' first before field var 'x_b_12'
        $val = $CurrentForm->hasValue("b_12") ? $CurrentForm->getValue("b_12") : $CurrentForm->getValue("x_b_12");
        if (!$this->b_12->IsDetailKey) {
            $this->b_12->setFormValue($val);
        }

        // Check field name 'b_13' first before field var 'x_b_13'
        $val = $CurrentForm->hasValue("b_13") ? $CurrentForm->getValue("b_13") : $CurrentForm->getValue("x_b_13");
        if (!$this->b_13->IsDetailKey) {
            $this->b_13->setFormValue($val);
        }

        // Check field name 'b_14' first before field var 'x_b_14'
        $val = $CurrentForm->hasValue("b_14") ? $CurrentForm->getValue("b_14") : $CurrentForm->getValue("x_b_14");
        if (!$this->b_14->IsDetailKey) {
            $this->b_14->setFormValue($val);
        }

        // Check field name 'b_15' first before field var 'x_b_15'
        $val = $CurrentForm->hasValue("b_15") ? $CurrentForm->getValue("b_15") : $CurrentForm->getValue("x_b_15");
        if (!$this->b_15->IsDetailKey) {
            $this->b_15->setFormValue($val);
        }

        // Check field name 't_01' first before field var 'x_t_01'
        $val = $CurrentForm->hasValue("t_01") ? $CurrentForm->getValue("t_01") : $CurrentForm->getValue("x_t_01");
        if (!$this->t_01->IsDetailKey) {
            $this->t_01->setFormValue($val);
        }

        // Check field name 't_02' first before field var 'x_t_02'
        $val = $CurrentForm->hasValue("t_02") ? $CurrentForm->getValue("t_02") : $CurrentForm->getValue("x_t_02");
        if (!$this->t_02->IsDetailKey) {
            $this->t_02->setFormValue($val);
        }

        // Check field name 't_03' first before field var 'x_t_03'
        $val = $CurrentForm->hasValue("t_03") ? $CurrentForm->getValue("t_03") : $CurrentForm->getValue("x_t_03");
        if (!$this->t_03->IsDetailKey) {
            $this->t_03->setFormValue($val);
        }

        // Check field name 't_04' first before field var 'x_t_04'
        $val = $CurrentForm->hasValue("t_04") ? $CurrentForm->getValue("t_04") : $CurrentForm->getValue("x_t_04");
        if (!$this->t_04->IsDetailKey) {
            $this->t_04->setFormValue($val);
        }

        // Check field name 't_05' first before field var 'x_t_05'
        $val = $CurrentForm->hasValue("t_05") ? $CurrentForm->getValue("t_05") : $CurrentForm->getValue("x_t_05");
        if (!$this->t_05->IsDetailKey) {
            $this->t_05->setFormValue($val);
        }

        // Check field name 't_06' first before field var 'x_t_06'
        $val = $CurrentForm->hasValue("t_06") ? $CurrentForm->getValue("t_06") : $CurrentForm->getValue("x_t_06");
        if (!$this->t_06->IsDetailKey) {
            $this->t_06->setFormValue($val);
        }

        // Check field name 't_07' first before field var 'x_t_07'
        $val = $CurrentForm->hasValue("t_07") ? $CurrentForm->getValue("t_07") : $CurrentForm->getValue("x_t_07");
        if (!$this->t_07->IsDetailKey) {
            $this->t_07->setFormValue($val);
        }

        // Check field name 't_08' first before field var 'x_t_08'
        $val = $CurrentForm->hasValue("t_08") ? $CurrentForm->getValue("t_08") : $CurrentForm->getValue("x_t_08");
        if (!$this->t_08->IsDetailKey) {
            $this->t_08->setFormValue($val);
        }

        // Check field name 't_09' first before field var 'x_t_09'
        $val = $CurrentForm->hasValue("t_09") ? $CurrentForm->getValue("t_09") : $CurrentForm->getValue("x_t_09");
        if (!$this->t_09->IsDetailKey) {
            $this->t_09->setFormValue($val);
        }

        // Check field name 't_10' first before field var 'x_t_10'
        $val = $CurrentForm->hasValue("t_10") ? $CurrentForm->getValue("t_10") : $CurrentForm->getValue("x_t_10");
        if (!$this->t_10->IsDetailKey) {
            $this->t_10->setFormValue($val);
        }

        // Check field name 't_11' first before field var 'x_t_11'
        $val = $CurrentForm->hasValue("t_11") ? $CurrentForm->getValue("t_11") : $CurrentForm->getValue("x_t_11");
        if (!$this->t_11->IsDetailKey) {
            $this->t_11->setFormValue($val);
        }

        // Check field name 't_12' first before field var 'x_t_12'
        $val = $CurrentForm->hasValue("t_12") ? $CurrentForm->getValue("t_12") : $CurrentForm->getValue("x_t_12");
        if (!$this->t_12->IsDetailKey) {
            $this->t_12->setFormValue($val);
        }

        // Check field name 't_13' first before field var 'x_t_13'
        $val = $CurrentForm->hasValue("t_13") ? $CurrentForm->getValue("t_13") : $CurrentForm->getValue("x_t_13");
        if (!$this->t_13->IsDetailKey) {
            $this->t_13->setFormValue($val);
        }

        // Check field name 't_14' first before field var 'x_t_14'
        $val = $CurrentForm->hasValue("t_14") ? $CurrentForm->getValue("t_14") : $CurrentForm->getValue("x_t_14");
        if (!$this->t_14->IsDetailKey) {
            $this->t_14->setFormValue($val);
        }

        // Check field name 't_15' first before field var 'x_t_15'
        $val = $CurrentForm->hasValue("t_15") ? $CurrentForm->getValue("t_15") : $CurrentForm->getValue("x_t_15");
        if (!$this->t_15->IsDetailKey) {
            $this->t_15->setFormValue($val);
        }

        // Check field name 'last_price' first before field var 'x_last_price'
        $val = $CurrentForm->hasValue("last_price") ? $CurrentForm->getValue("last_price") : $CurrentForm->getValue("x_last_price");
        if (!$this->last_price->IsDetailKey) {
            $this->last_price->setFormValue($val, true, $validate);
        }

        // Check field name 'currency' first before field var 'x_currency'
        $val = $CurrentForm->hasValue("currency") ? $CurrentForm->getValue("currency") : $CurrentForm->getValue("x_currency");
        if (!$this->currency->IsDetailKey) {
            $this->currency->setFormValue($val);
        }

        // Check field name 'hsn' first before field var 'x_hsn'
        $val = $CurrentForm->hasValue("hsn") ? $CurrentForm->getValue("hsn") : $CurrentForm->getValue("x_hsn");
        if (!$this->hsn->IsDetailKey) {
            $this->hsn->setFormValue($val);
        }

        // Check field name 'composition' first before field var 'x_composition'
        $val = $CurrentForm->hasValue("composition") ? $CurrentForm->getValue("composition") : $CurrentForm->getValue("x_composition");
        if (!$this->composition->IsDetailKey) {
            $this->composition->setFormValue($val);
        }

        // Check field name 'category' first before field var 'x_category'
        $val = $CurrentForm->hasValue("category") ? $CurrentForm->getValue("category") : $CurrentForm->getValue("x_category");
        if (!$this->category->IsDetailKey) {
            $this->category->setFormValue($val);
        }

        // Check field name 'moq' first before field var 'x_moq'
        $val = $CurrentForm->hasValue("moq") ? $CurrentForm->getValue("moq") : $CurrentForm->getValue("x_moq");
        if (!$this->moq->IsDetailKey) {
            $this->moq->setFormValue($val, true, $validate);
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            $this->status->setFormValue($val);
        }

        // Check field name 'd_head_01' first before field var 'x_d_head_01'
        $val = $CurrentForm->hasValue("d_head_01") ? $CurrentForm->getValue("d_head_01") : $CurrentForm->getValue("x_d_head_01");
        if (!$this->d_head_01->IsDetailKey) {
            $this->d_head_01->setFormValue($val);
        }

        // Check field name 'd_description_01' first before field var 'x_d_description_01'
        $val = $CurrentForm->hasValue("d_description_01") ? $CurrentForm->getValue("d_description_01") : $CurrentForm->getValue("x_d_description_01");
        if (!$this->d_description_01->IsDetailKey) {
            $this->d_description_01->setFormValue($val);
        }

        // Check field name 'd_head_02' first before field var 'x_d_head_02'
        $val = $CurrentForm->hasValue("d_head_02") ? $CurrentForm->getValue("d_head_02") : $CurrentForm->getValue("x_d_head_02");
        if (!$this->d_head_02->IsDetailKey) {
            $this->d_head_02->setFormValue($val);
        }

        // Check field name 'd_description_02' first before field var 'x_d_description_02'
        $val = $CurrentForm->hasValue("d_description_02") ? $CurrentForm->getValue("d_description_02") : $CurrentForm->getValue("x_d_description_02");
        if (!$this->d_description_02->IsDetailKey) {
            $this->d_description_02->setFormValue($val);
        }

        // Check field name 'publish' first before field var 'x_publish'
        $val = $CurrentForm->hasValue("publish") ? $CurrentForm->getValue("publish") : $CurrentForm->getValue("x_publish");
        if (!$this->publish->IsDetailKey) {
            $this->publish->setFormValue($val);
        }

        // Check field name 'keywords' first before field var 'x_keywords'
        $val = $CurrentForm->hasValue("keywords") ? $CurrentForm->getValue("keywords") : $CurrentForm->getValue("x_keywords");
        if (!$this->keywords->IsDetailKey) {
            $this->keywords->setFormValue($val);
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            $this->operator->setFormValue($val);
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            $this->datetime->setFormValue($val);
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'video_url' first before field var 'x_video_url'
        $val = $CurrentForm->hasValue("video_url") ? $CurrentForm->getValue("video_url") : $CurrentForm->getValue("x_video_url");
        if (!$this->video_url->IsDetailKey) {
            $this->video_url->setFormValue($val);
        }

        // Check field name 'in' first before field var 'x_in'
        $val = $CurrentForm->hasValue("in") ? $CurrentForm->getValue("in") : $CurrentForm->getValue("x_in");
        if (!$this->in->IsDetailKey) {
            $this->in->setFormValue($val, true, $validate);
        }

        // Check field name 'out' first before field var 'x_out'
        $val = $CurrentForm->hasValue("out") ? $CurrentForm->getValue("out") : $CurrentForm->getValue("x_out");
        if (!$this->out->IsDetailKey) {
            $this->out->setFormValue($val, true, $validate);
        }

        // Check field name 'required' first before field var 'x_required'
        $val = $CurrentForm->hasValue("required") ? $CurrentForm->getValue("required") : $CurrentForm->getValue("x_required");
        if (!$this->required->IsDetailKey) {
            $this->required->setFormValue($val, true, $validate);
        }

        // Check field name 'blocked' first before field var 'x_blocked'
        $val = $CurrentForm->hasValue("blocked") ? $CurrentForm->getValue("blocked") : $CurrentForm->getValue("x_blocked");
        if (!$this->blocked->IsDetailKey) {
            $this->blocked->setFormValue($val, true, $validate);
        }

        // Check field name 'ordered' first before field var 'x_ordered'
        $val = $CurrentForm->hasValue("ordered") ? $CurrentForm->getValue("ordered") : $CurrentForm->getValue("x_ordered");
        if (!$this->ordered->IsDetailKey) {
            $this->ordered->setFormValue($val, true, $validate);
        }

        // Check field name 'supplier' first before field var 'x_supplier'
        $val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
        if (!$this->supplier->IsDetailKey) {
            $this->supplier->setFormValue($val);
        }

        // Check field name 'country' first before field var 'x_country'
        $val = $CurrentForm->hasValue("country") ? $CurrentForm->getValue("country") : $CurrentForm->getValue("x_country");
        if (!$this->country->IsDetailKey) {
            $this->country->setFormValue($val);
        }

        // Check field name 'minimum_stock' first before field var 'x_minimum_stock'
        $val = $CurrentForm->hasValue("minimum_stock") ? $CurrentForm->getValue("minimum_stock") : $CurrentForm->getValue("x_minimum_stock");
        if (!$this->minimum_stock->IsDetailKey) {
            $this->minimum_stock->setFormValue($val, true, $validate);
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		$this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
		$this->main_image->UploadPath = $this->main_image->OldUploadPath;
		$this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
		$this->top_view->UploadPath = $this->top_view->OldUploadPath;
		$this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
		$this->front_view->UploadPath = $this->front_view->OldUploadPath;
		$this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
		$this->corner_view->UploadPath = $this->corner_view->OldUploadPath;
		$this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
		$this->back_view->UploadPath = $this->back_view->OldUploadPath;
		$this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
		$this->color_options->UploadPath = $this->color_options->OldUploadPath;
		$this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
		$this->other_options->UploadPath = $this->other_options->OldUploadPath;
		$this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
		$this->group_image->UploadPath = $this->group_image->OldUploadPath;
		$this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
		$this->image->UploadPath = $this->image->OldUploadPath;
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->oid->CurrentValue = ConvertToUtf8($this->oid->FormValue);
        $this->company_id->CurrentValue = ConvertToUtf8($this->company_id->FormValue);
        $this->grp->CurrentValue = ConvertToUtf8($this->grp->FormValue);
        $this->s_grp->CurrentValue = ConvertToUtf8($this->s_grp->FormValue);
        $this->product->CurrentValue = ConvertToUtf8($this->product->FormValue);
        $this->product_type->CurrentValue = ConvertToUtf8($this->product_type->FormValue);
        $this->packing_type->CurrentValue = ConvertToUtf8($this->packing_type->FormValue);
        $this->_barcode->CurrentValue = ConvertToUtf8($this->_barcode->FormValue);
        $this->product_code_type->CurrentValue = ConvertToUtf8($this->product_code_type->FormValue);
        $this->product_code->CurrentValue = ConvertToUtf8($this->product_code->FormValue);
        $this->print_name->CurrentValue = ConvertToUtf8($this->print_name->FormValue);
        $this->gcode->CurrentValue = ConvertToUtf8($this->gcode->FormValue);
        $this->code->CurrentValue = ConvertToUtf8($this->code->FormValue);
        $this->product_id->CurrentValue = ConvertToUtf8($this->product_id->FormValue);
        $this->batch_no->CurrentValue = ConvertToUtf8($this->batch_no->FormValue);
        $this->set_ref->CurrentValue = ConvertToUtf8($this->set_ref->FormValue);
        $this->v_00->CurrentValue = ConvertToUtf8($this->v_00->FormValue);
        $this->v_01->CurrentValue = ConvertToUtf8($this->v_01->FormValue);
        $this->v_02->CurrentValue = ConvertToUtf8($this->v_02->FormValue);
        $this->v_03->CurrentValue = ConvertToUtf8($this->v_03->FormValue);
        $this->v_04->CurrentValue = ConvertToUtf8($this->v_04->FormValue);
        $this->v_05->CurrentValue = ConvertToUtf8($this->v_05->FormValue);
        $this->v_06->CurrentValue = ConvertToUtf8($this->v_06->FormValue);
        $this->v_07->CurrentValue = ConvertToUtf8($this->v_07->FormValue);
        $this->v_08->CurrentValue = ConvertToUtf8($this->v_08->FormValue);
        $this->v_09->CurrentValue = ConvertToUtf8($this->v_09->FormValue);
        $this->v_10->CurrentValue = ConvertToUtf8($this->v_10->FormValue);
        $this->cbm->CurrentValue = ConvertToUtf8($this->cbm->FormValue);
        $this->sqm->CurrentValue = ConvertToUtf8($this->sqm->FormValue);
        $this->shape->CurrentValue = ConvertToUtf8($this->shape->FormValue);
        $this->q_sku->CurrentValue = ConvertToUtf8($this->q_sku->FormValue);
        $this->b_01->CurrentValue = ConvertToUtf8($this->b_01->FormValue);
        $this->b_02->CurrentValue = ConvertToUtf8($this->b_02->FormValue);
        $this->b_03->CurrentValue = ConvertToUtf8($this->b_03->FormValue);
        $this->b_04->CurrentValue = ConvertToUtf8($this->b_04->FormValue);
        $this->b_05->CurrentValue = ConvertToUtf8($this->b_05->FormValue);
        $this->b_06->CurrentValue = ConvertToUtf8($this->b_06->FormValue);
        $this->b_07->CurrentValue = ConvertToUtf8($this->b_07->FormValue);
        $this->b_08->CurrentValue = ConvertToUtf8($this->b_08->FormValue);
        $this->b_09->CurrentValue = ConvertToUtf8($this->b_09->FormValue);
        $this->b_10->CurrentValue = ConvertToUtf8($this->b_10->FormValue);
        $this->b_11->CurrentValue = ConvertToUtf8($this->b_11->FormValue);
        $this->b_12->CurrentValue = ConvertToUtf8($this->b_12->FormValue);
        $this->b_13->CurrentValue = ConvertToUtf8($this->b_13->FormValue);
        $this->b_14->CurrentValue = ConvertToUtf8($this->b_14->FormValue);
        $this->b_15->CurrentValue = ConvertToUtf8($this->b_15->FormValue);
        $this->t_01->CurrentValue = ConvertToUtf8($this->t_01->FormValue);
        $this->t_02->CurrentValue = ConvertToUtf8($this->t_02->FormValue);
        $this->t_03->CurrentValue = ConvertToUtf8($this->t_03->FormValue);
        $this->t_04->CurrentValue = ConvertToUtf8($this->t_04->FormValue);
        $this->t_05->CurrentValue = ConvertToUtf8($this->t_05->FormValue);
        $this->t_06->CurrentValue = ConvertToUtf8($this->t_06->FormValue);
        $this->t_07->CurrentValue = ConvertToUtf8($this->t_07->FormValue);
        $this->t_08->CurrentValue = ConvertToUtf8($this->t_08->FormValue);
        $this->t_09->CurrentValue = ConvertToUtf8($this->t_09->FormValue);
        $this->t_10->CurrentValue = ConvertToUtf8($this->t_10->FormValue);
        $this->t_11->CurrentValue = ConvertToUtf8($this->t_11->FormValue);
        $this->t_12->CurrentValue = ConvertToUtf8($this->t_12->FormValue);
        $this->t_13->CurrentValue = ConvertToUtf8($this->t_13->FormValue);
        $this->t_14->CurrentValue = ConvertToUtf8($this->t_14->FormValue);
        $this->t_15->CurrentValue = ConvertToUtf8($this->t_15->FormValue);
        $this->last_price->CurrentValue = ConvertToUtf8($this->last_price->FormValue);
        $this->currency->CurrentValue = ConvertToUtf8($this->currency->FormValue);
        $this->hsn->CurrentValue = ConvertToUtf8($this->hsn->FormValue);
        $this->composition->CurrentValue = ConvertToUtf8($this->composition->FormValue);
        $this->category->CurrentValue = ConvertToUtf8($this->category->FormValue);
        $this->moq->CurrentValue = ConvertToUtf8($this->moq->FormValue);
        $this->status->CurrentValue = ConvertToUtf8($this->status->FormValue);
        $this->d_head_01->CurrentValue = ConvertToUtf8($this->d_head_01->FormValue);
        $this->d_description_01->CurrentValue = ConvertToUtf8($this->d_description_01->FormValue);
        $this->d_head_02->CurrentValue = ConvertToUtf8($this->d_head_02->FormValue);
        $this->d_description_02->CurrentValue = ConvertToUtf8($this->d_description_02->FormValue);
        $this->publish->CurrentValue = ConvertToUtf8($this->publish->FormValue);
        $this->keywords->CurrentValue = ConvertToUtf8($this->keywords->FormValue);
        $this->operator->CurrentValue = ConvertToUtf8($this->operator->FormValue);
        $this->datetime->CurrentValue = ConvertToUtf8($this->datetime->FormValue);
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->video_url->CurrentValue = ConvertToUtf8($this->video_url->FormValue);
        $this->in->CurrentValue = ConvertToUtf8($this->in->FormValue);
        $this->out->CurrentValue = ConvertToUtf8($this->out->FormValue);
        $this->required->CurrentValue = ConvertToUtf8($this->required->FormValue);
        $this->blocked->CurrentValue = ConvertToUtf8($this->blocked->FormValue);
        $this->ordered->CurrentValue = ConvertToUtf8($this->ordered->FormValue);
        $this->supplier->CurrentValue = ConvertToUtf8($this->supplier->FormValue);
        $this->country->CurrentValue = ConvertToUtf8($this->country->FormValue);
        $this->minimum_stock->CurrentValue = ConvertToUtf8($this->minimum_stock->FormValue);
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->oid->setDbValue($row['oid']);
        $this->company_id->setDbValue($row['company_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_type->setDbValue($row['product_type']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_n->setDbValue($row['product_n']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->product_code_type->setDbValue($row['product_code_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->print_name->setDbValue($row['print_name']);
        $this->gcode->setDbValue($row['gcode']);
        $this->code->setDbValue($row['code']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->set_ref->setDbValue($row['set_ref']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_10->setDbValue($row['v_10']);
        $this->cbm->setDbValue($row['cbm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->shape->setDbValue($row['shape']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->b_01->setDbValue($row['b_01']);
        $this->b_02->setDbValue($row['b_02']);
        $this->b_03->setDbValue($row['b_03']);
        $this->b_04->setDbValue($row['b_04']);
        $this->b_05->setDbValue($row['b_05']);
        $this->b_06->setDbValue($row['b_06']);
        $this->b_07->setDbValue($row['b_07']);
        $this->b_08->setDbValue($row['b_08']);
        $this->b_09->setDbValue($row['b_09']);
        $this->b_10->setDbValue($row['b_10']);
        $this->b_11->setDbValue($row['b_11']);
        $this->b_12->setDbValue($row['b_12']);
        $this->b_13->setDbValue($row['b_13']);
        $this->b_14->setDbValue($row['b_14']);
        $this->b_15->setDbValue($row['b_15']);
        $this->t_01->setDbValue($row['t_01']);
        $this->t_02->setDbValue($row['t_02']);
        $this->t_03->setDbValue($row['t_03']);
        $this->t_04->setDbValue($row['t_04']);
        $this->t_05->setDbValue($row['t_05']);
        $this->t_06->setDbValue($row['t_06']);
        $this->t_07->setDbValue($row['t_07']);
        $this->t_08->setDbValue($row['t_08']);
        $this->t_09->setDbValue($row['t_09']);
        $this->t_10->setDbValue($row['t_10']);
        $this->t_11->setDbValue($row['t_11']);
        $this->t_12->setDbValue($row['t_12']);
        $this->t_13->setDbValue($row['t_13']);
        $this->t_14->setDbValue($row['t_14']);
        $this->t_15->setDbValue($row['t_15']);
        $this->last_price->setDbValue($row['last_price']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->category->setDbValue($row['category']);
        $this->moq->setDbValue($row['moq']);
        $this->status->setDbValue($row['status']);
        $this->d_head_01->setDbValue($row['d_head_01']);
        $this->d_description_01->setDbValue($row['d_description_01']);
        $this->d_head_02->setDbValue($row['d_head_02']);
        $this->d_description_02->setDbValue($row['d_description_02']);
        $this->publish->setDbValue($row['publish']);
        $this->keywords->setDbValue($row['keywords']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->main_image->setDbValue($this->main_image->Upload->DbValue);
        $this->top_view->Upload->DbValue = $row['top_view'];
        $this->top_view->setDbValue($this->top_view->Upload->DbValue);
        $this->front_view->Upload->DbValue = $row['front_view'];
        $this->front_view->setDbValue($this->front_view->Upload->DbValue);
        $this->corner_view->Upload->DbValue = $row['corner_view'];
        $this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
        $this->back_view->Upload->DbValue = $row['back_view'];
        $this->back_view->setDbValue($this->back_view->Upload->DbValue);
        $this->color_options->Upload->DbValue = $row['color_options'];
        $this->color_options->setDbValue($this->color_options->Upload->DbValue);
        $this->other_options->Upload->DbValue = $row['other_options'];
        $this->other_options->setDbValue($this->other_options->Upload->DbValue);
        $this->group_image->Upload->DbValue = $row['group_image'];
        $this->group_image->setDbValue($this->group_image->Upload->DbValue);
        $this->video_url->setDbValue($row['video_url']);
        $this->image->Upload->DbValue = $row['image'];
        $this->image->setDbValue($this->image->Upload->DbValue);
        $this->in->setDbValue($row['in']);
        $this->out->setDbValue($row['out']);
        $this->required->setDbValue($row['required']);
        $this->blocked->setDbValue($row['blocked']);
        $this->ordered->setDbValue($row['ordered']);
        $this->supplier->setDbValue($row['supplier']);
        $this->country->setDbValue($row['country']);
        $this->minimum_stock->setDbValue($row['minimum_stock']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['oid'] = $this->oid->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['product_type'] = $this->product_type->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['product_n'] = $this->product_n->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['product_code_type'] = $this->product_code_type->DefaultValue;
        $row['product_code'] = $this->product_code->DefaultValue;
        $row['print_name'] = $this->print_name->DefaultValue;
        $row['gcode'] = $this->gcode->DefaultValue;
        $row['code'] = $this->code->DefaultValue;
        $row['product_id'] = $this->product_id->DefaultValue;
        $row['batch_no'] = $this->batch_no->DefaultValue;
        $row['set_ref'] = $this->set_ref->DefaultValue;
        $row['v_00'] = $this->v_00->DefaultValue;
        $row['v_01'] = $this->v_01->DefaultValue;
        $row['v_02'] = $this->v_02->DefaultValue;
        $row['v_03'] = $this->v_03->DefaultValue;
        $row['v_04'] = $this->v_04->DefaultValue;
        $row['v_05'] = $this->v_05->DefaultValue;
        $row['v_06'] = $this->v_06->DefaultValue;
        $row['v_07'] = $this->v_07->DefaultValue;
        $row['v_08'] = $this->v_08->DefaultValue;
        $row['v_09'] = $this->v_09->DefaultValue;
        $row['v_10'] = $this->v_10->DefaultValue;
        $row['cbm'] = $this->cbm->DefaultValue;
        $row['sqm'] = $this->sqm->DefaultValue;
        $row['shape'] = $this->shape->DefaultValue;
        $row['q_sku'] = $this->q_sku->DefaultValue;
        $row['b_01'] = $this->b_01->DefaultValue;
        $row['b_02'] = $this->b_02->DefaultValue;
        $row['b_03'] = $this->b_03->DefaultValue;
        $row['b_04'] = $this->b_04->DefaultValue;
        $row['b_05'] = $this->b_05->DefaultValue;
        $row['b_06'] = $this->b_06->DefaultValue;
        $row['b_07'] = $this->b_07->DefaultValue;
        $row['b_08'] = $this->b_08->DefaultValue;
        $row['b_09'] = $this->b_09->DefaultValue;
        $row['b_10'] = $this->b_10->DefaultValue;
        $row['b_11'] = $this->b_11->DefaultValue;
        $row['b_12'] = $this->b_12->DefaultValue;
        $row['b_13'] = $this->b_13->DefaultValue;
        $row['b_14'] = $this->b_14->DefaultValue;
        $row['b_15'] = $this->b_15->DefaultValue;
        $row['t_01'] = $this->t_01->DefaultValue;
        $row['t_02'] = $this->t_02->DefaultValue;
        $row['t_03'] = $this->t_03->DefaultValue;
        $row['t_04'] = $this->t_04->DefaultValue;
        $row['t_05'] = $this->t_05->DefaultValue;
        $row['t_06'] = $this->t_06->DefaultValue;
        $row['t_07'] = $this->t_07->DefaultValue;
        $row['t_08'] = $this->t_08->DefaultValue;
        $row['t_09'] = $this->t_09->DefaultValue;
        $row['t_10'] = $this->t_10->DefaultValue;
        $row['t_11'] = $this->t_11->DefaultValue;
        $row['t_12'] = $this->t_12->DefaultValue;
        $row['t_13'] = $this->t_13->DefaultValue;
        $row['t_14'] = $this->t_14->DefaultValue;
        $row['t_15'] = $this->t_15->DefaultValue;
        $row['last_price'] = $this->last_price->DefaultValue;
        $row['currency'] = $this->currency->DefaultValue;
        $row['hsn'] = $this->hsn->DefaultValue;
        $row['composition'] = $this->composition->DefaultValue;
        $row['category'] = $this->category->DefaultValue;
        $row['moq'] = $this->moq->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['d_head_01'] = $this->d_head_01->DefaultValue;
        $row['d_description_01'] = $this->d_description_01->DefaultValue;
        $row['d_head_02'] = $this->d_head_02->DefaultValue;
        $row['d_description_02'] = $this->d_description_02->DefaultValue;
        $row['publish'] = $this->publish->DefaultValue;
        $row['keywords'] = $this->keywords->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['main_image'] = $this->main_image->DefaultValue;
        $row['top_view'] = $this->top_view->DefaultValue;
        $row['front_view'] = $this->front_view->DefaultValue;
        $row['corner_view'] = $this->corner_view->DefaultValue;
        $row['back_view'] = $this->back_view->DefaultValue;
        $row['color_options'] = $this->color_options->DefaultValue;
        $row['other_options'] = $this->other_options->DefaultValue;
        $row['group_image'] = $this->group_image->DefaultValue;
        $row['video_url'] = $this->video_url->DefaultValue;
        $row['image'] = $this->image->DefaultValue;
        $row['in'] = $this->in->DefaultValue;
        $row['out'] = $this->out->DefaultValue;
        $row['required'] = $this->required->DefaultValue;
        $row['blocked'] = $this->blocked->DefaultValue;
        $row['ordered'] = $this->ordered->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['minimum_stock'] = $this->minimum_stock->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // oid
        $this->oid->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_type
        $this->product_type->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // product_n
        $this->product_n->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // product_code_type
        $this->product_code_type->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // print_name
        $this->print_name->RowCssClass = "row";

        // gcode
        $this->gcode->RowCssClass = "row";

        // code
        $this->code->RowCssClass = "row";

        // product_id
        $this->product_id->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // set_ref
        $this->set_ref->RowCssClass = "row";

        // v_00
        $this->v_00->RowCssClass = "row";

        // v_01
        $this->v_01->RowCssClass = "row";

        // v_02
        $this->v_02->RowCssClass = "row";

        // v_03
        $this->v_03->RowCssClass = "row";

        // v_04
        $this->v_04->RowCssClass = "row";

        // v_05
        $this->v_05->RowCssClass = "row";

        // v_06
        $this->v_06->RowCssClass = "row";

        // v_07
        $this->v_07->RowCssClass = "row";

        // v_08
        $this->v_08->RowCssClass = "row";

        // v_09
        $this->v_09->RowCssClass = "row";

        // v_10
        $this->v_10->RowCssClass = "row";

        // cbm
        $this->cbm->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // shape
        $this->shape->RowCssClass = "row";

        // q_sku
        $this->q_sku->RowCssClass = "row";

        // b_01
        $this->b_01->RowCssClass = "row";

        // b_02
        $this->b_02->RowCssClass = "row";

        // b_03
        $this->b_03->RowCssClass = "row";

        // b_04
        $this->b_04->RowCssClass = "row";

        // b_05
        $this->b_05->RowCssClass = "row";

        // b_06
        $this->b_06->RowCssClass = "row";

        // b_07
        $this->b_07->RowCssClass = "row";

        // b_08
        $this->b_08->RowCssClass = "row";

        // b_09
        $this->b_09->RowCssClass = "row";

        // b_10
        $this->b_10->RowCssClass = "row";

        // b_11
        $this->b_11->RowCssClass = "row";

        // b_12
        $this->b_12->RowCssClass = "row";

        // b_13
        $this->b_13->RowCssClass = "row";

        // b_14
        $this->b_14->RowCssClass = "row";

        // b_15
        $this->b_15->RowCssClass = "row";

        // t_01
        $this->t_01->RowCssClass = "row";

        // t_02
        $this->t_02->RowCssClass = "row";

        // t_03
        $this->t_03->RowCssClass = "row";

        // t_04
        $this->t_04->RowCssClass = "row";

        // t_05
        $this->t_05->RowCssClass = "row";

        // t_06
        $this->t_06->RowCssClass = "row";

        // t_07
        $this->t_07->RowCssClass = "row";

        // t_08
        $this->t_08->RowCssClass = "row";

        // t_09
        $this->t_09->RowCssClass = "row";

        // t_10
        $this->t_10->RowCssClass = "row";

        // t_11
        $this->t_11->RowCssClass = "row";

        // t_12
        $this->t_12->RowCssClass = "row";

        // t_13
        $this->t_13->RowCssClass = "row";

        // t_14
        $this->t_14->RowCssClass = "row";

        // t_15
        $this->t_15->RowCssClass = "row";

        // last_price
        $this->last_price->RowCssClass = "row";

        // currency
        $this->currency->RowCssClass = "row";

        // hsn
        $this->hsn->RowCssClass = "row";

        // composition
        $this->composition->RowCssClass = "row";

        // category
        $this->category->RowCssClass = "row";

        // moq
        $this->moq->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // d_head_01
        $this->d_head_01->RowCssClass = "row";

        // d_description_01
        $this->d_description_01->RowCssClass = "row";

        // d_head_02
        $this->d_head_02->RowCssClass = "row";

        // d_description_02
        $this->d_description_02->RowCssClass = "row";

        // publish
        $this->publish->RowCssClass = "row";

        // keywords
        $this->keywords->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // main_image
        $this->main_image->RowCssClass = "row";

        // top_view
        $this->top_view->RowCssClass = "row";

        // front_view
        $this->front_view->RowCssClass = "row";

        // corner_view
        $this->corner_view->RowCssClass = "row";

        // back_view
        $this->back_view->RowCssClass = "row";

        // color_options
        $this->color_options->RowCssClass = "row";

        // other_options
        $this->other_options->RowCssClass = "row";

        // group_image
        $this->group_image->RowCssClass = "row";

        // video_url
        $this->video_url->RowCssClass = "row";

        // image
        $this->image->RowCssClass = "row";

        // in
        $this->in->RowCssClass = "row";

        // out
        $this->out->RowCssClass = "row";

        // required
        $this->required->RowCssClass = "row";

        // blocked
        $this->blocked->RowCssClass = "row";

        // ordered
        $this->ordered->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // minimum_stock
        $this->minimum_stock->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // oid
            $this->oid->ViewValue = $this->oid->CurrentValue;

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->company_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->company_id->Lookup->renderViewRow($row);
                            $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                        }
                    } else {
                        $this->company_id->ViewValue = $this->company_id->CurrentValue;
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // grp
            $curVal = strval($this->grp->CurrentValue);
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
                if ($this->grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                        $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                    } else {
                        $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                    }
                }
            } else {
                $this->grp->ViewValue = null;
            }

            // s_grp
            $curVal = strval($this->s_grp->CurrentValue);
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
                if ($this->s_grp->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                    $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                        $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                    } else {
                        $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                    }
                }
            } else {
                $this->s_grp->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_type
            $curVal = strval($this->product_type->CurrentValue);
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
                if ($this->product_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                        $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                    } else {
                        $this->product_type->ViewValue = $this->product_type->CurrentValue;
                    }
                }
            } else {
                $this->product_type->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // product_n
            $this->product_n->ViewValue = $this->product_n->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // product_code_type
            if (strval($this->product_code_type->CurrentValue) != "") {
                $this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
            } else {
                $this->product_code_type->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // print_name
            $this->print_name->ViewValue = $this->print_name->CurrentValue;

            // gcode
            $this->gcode->ViewValue = $this->gcode->CurrentValue;

            // code
            $this->code->ViewValue = $this->code->CurrentValue;

            // product_id
            $this->product_id->ViewValue = $this->product_id->CurrentValue;

            // batch_no
            $this->batch_no->ViewValue = $this->batch_no->CurrentValue;

            // set_ref
            $curVal = strval($this->set_ref->CurrentValue);
            if ($curVal != "") {
                $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
                if ($this->set_ref->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                    $sqlWrk = $this->set_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->set_ref->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                            $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                        }
                    } else {
                        $this->set_ref->ViewValue = $this->set_ref->CurrentValue;
                    }
                }
            } else {
                $this->set_ref->ViewValue = null;
            }

            // v_00
            $this->v_00->ViewValue = $this->v_00->CurrentValue;

            // v_01
            $curVal = strval($this->v_01->CurrentValue);
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
                if ($this->v_01->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_01->Lookup->renderViewRow($rswrk[0]);
                        $this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
                    } else {
                        $this->v_01->ViewValue = $this->v_01->CurrentValue;
                    }
                }
            } else {
                $this->v_01->ViewValue = null;
            }

            // v_02
            $curVal = strval($this->v_02->CurrentValue);
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
                if ($this->v_02->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_02->Lookup->renderViewRow($rswrk[0]);
                        $this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
                    } else {
                        $this->v_02->ViewValue = $this->v_02->CurrentValue;
                    }
                }
            } else {
                $this->v_02->ViewValue = null;
            }

            // v_03
            $curVal = strval($this->v_03->CurrentValue);
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
                if ($this->v_03->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_03->Lookup->renderViewRow($rswrk[0]);
                        $this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
                    } else {
                        $this->v_03->ViewValue = $this->v_03->CurrentValue;
                    }
                }
            } else {
                $this->v_03->ViewValue = null;
            }

            // v_04
            $curVal = strval($this->v_04->CurrentValue);
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
                if ($this->v_04->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_04->Lookup->renderViewRow($rswrk[0]);
                        $this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
                    } else {
                        $this->v_04->ViewValue = $this->v_04->CurrentValue;
                    }
                }
            } else {
                $this->v_04->ViewValue = null;
            }

            // v_05
            $curVal = strval($this->v_05->CurrentValue);
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
                if ($this->v_05->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_05->Lookup->renderViewRow($rswrk[0]);
                        $this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
                    } else {
                        $this->v_05->ViewValue = $this->v_05->CurrentValue;
                    }
                }
            } else {
                $this->v_05->ViewValue = null;
            }

            // v_06
            $curVal = strval($this->v_06->CurrentValue);
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
                if ($this->v_06->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_06->Lookup->renderViewRow($rswrk[0]);
                        $this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
                    } else {
                        $this->v_06->ViewValue = $this->v_06->CurrentValue;
                    }
                }
            } else {
                $this->v_06->ViewValue = null;
            }

            // v_07
            $curVal = strval($this->v_07->CurrentValue);
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
                if ($this->v_07->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_07->Lookup->renderViewRow($rswrk[0]);
                        $this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
                    } else {
                        $this->v_07->ViewValue = $this->v_07->CurrentValue;
                    }
                }
            } else {
                $this->v_07->ViewValue = null;
            }

            // v_08
            $curVal = strval($this->v_08->CurrentValue);
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
                if ($this->v_08->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_08->Lookup->renderViewRow($rswrk[0]);
                        $this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
                    } else {
                        $this->v_08->ViewValue = $this->v_08->CurrentValue;
                    }
                }
            } else {
                $this->v_08->ViewValue = null;
            }

            // v_09
            $curVal = strval($this->v_09->CurrentValue);
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
                if ($this->v_09->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_09->Lookup->renderViewRow($rswrk[0]);
                        $this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
                    } else {
                        $this->v_09->ViewValue = $this->v_09->CurrentValue;
                    }
                }
            } else {
                $this->v_09->ViewValue = null;
            }

            // v_10
            $curVal = strval($this->v_10->CurrentValue);
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
                if ($this->v_10->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                    $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->v_10->Lookup->renderViewRow($rswrk[0]);
                        $this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
                    } else {
                        $this->v_10->ViewValue = $this->v_10->CurrentValue;
                    }
                }
            } else {
                $this->v_10->ViewValue = null;
            }

            // cbm
            $this->cbm->ViewValue = $this->cbm->CurrentValue;
            $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // shape
            $curVal = strval($this->shape->CurrentValue);
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
                if ($this->shape->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                    $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->shape->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->shape->Lookup->renderViewRow($row);
                            $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                        }
                    } else {
                        $this->shape->ViewValue = $this->shape->CurrentValue;
                    }
                }
            } else {
                $this->shape->ViewValue = null;
            }

            // q_sku
            $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
            $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

            // b_01
            $this->b_01->ViewValue = $this->b_01->CurrentValue;

            // b_02
            $this->b_02->ViewValue = $this->b_02->CurrentValue;

            // b_03
            $curVal = strval($this->b_03->CurrentValue);
            if ($curVal != "") {
                $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
                if ($this->b_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_03->Lookup->renderViewRow($row);
                            $this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
                        }
                    } else {
                        $this->b_03->ViewValue = $this->b_03->CurrentValue;
                    }
                }
            } else {
                $this->b_03->ViewValue = null;
            }

            // b_04
            $curVal = strval($this->b_04->CurrentValue);
            if ($curVal != "") {
                $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
                if ($this->b_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_04->Lookup->renderViewRow($row);
                            $this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
                        }
                    } else {
                        $this->b_04->ViewValue = $this->b_04->CurrentValue;
                    }
                }
            } else {
                $this->b_04->ViewValue = null;
            }

            // b_05
            $curVal = strval($this->b_05->CurrentValue);
            if ($curVal != "") {
                $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
                if ($this->b_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_05->Lookup->renderViewRow($row);
                            $this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
                        }
                    } else {
                        $this->b_05->ViewValue = $this->b_05->CurrentValue;
                    }
                }
            } else {
                $this->b_05->ViewValue = null;
            }

            // b_06
            $curVal = strval($this->b_06->CurrentValue);
            if ($curVal != "") {
                $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
                if ($this->b_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_06->Lookup->renderViewRow($row);
                            $this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
                        }
                    } else {
                        $this->b_06->ViewValue = $this->b_06->CurrentValue;
                    }
                }
            } else {
                $this->b_06->ViewValue = null;
            }

            // b_07
            $curVal = strval($this->b_07->CurrentValue);
            if ($curVal != "") {
                $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
                if ($this->b_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_07->Lookup->renderViewRow($row);
                            $this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
                        }
                    } else {
                        $this->b_07->ViewValue = $this->b_07->CurrentValue;
                    }
                }
            } else {
                $this->b_07->ViewValue = null;
            }

            // b_08
            $curVal = strval($this->b_08->CurrentValue);
            if ($curVal != "") {
                $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
                if ($this->b_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_08->Lookup->renderViewRow($row);
                            $this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
                        }
                    } else {
                        $this->b_08->ViewValue = $this->b_08->CurrentValue;
                    }
                }
            } else {
                $this->b_08->ViewValue = null;
            }

            // b_09
            $curVal = strval($this->b_09->CurrentValue);
            if ($curVal != "") {
                $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
                if ($this->b_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_09->Lookup->renderViewRow($row);
                            $this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
                        }
                    } else {
                        $this->b_09->ViewValue = $this->b_09->CurrentValue;
                    }
                }
            } else {
                $this->b_09->ViewValue = null;
            }

            // b_10
            $curVal = strval($this->b_10->CurrentValue);
            if ($curVal != "") {
                $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
                if ($this->b_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->b_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->b_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->b_10->Lookup->renderViewRow($row);
                            $this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
                        }
                    } else {
                        $this->b_10->ViewValue = $this->b_10->CurrentValue;
                    }
                }
            } else {
                $this->b_10->ViewValue = null;
            }

            // b_11
            $this->b_11->ViewValue = $this->b_11->CurrentValue;

            // b_12
            $this->b_12->ViewValue = $this->b_12->CurrentValue;

            // b_13
            $this->b_13->ViewValue = $this->b_13->CurrentValue;

            // b_14
            $this->b_14->ViewValue = $this->b_14->CurrentValue;

            // b_15
            $this->b_15->ViewValue = $this->b_15->CurrentValue;

            // t_01
            $this->t_01->ViewValue = $this->t_01->CurrentValue;

            // t_02
            $this->t_02->ViewValue = $this->t_02->CurrentValue;

            // t_03
            $curVal = strval($this->t_03->CurrentValue);
            if ($curVal != "") {
                $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
                if ($this->t_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_03->Lookup->renderViewRow($row);
                            $this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
                        }
                    } else {
                        $this->t_03->ViewValue = $this->t_03->CurrentValue;
                    }
                }
            } else {
                $this->t_03->ViewValue = null;
            }

            // t_04
            $curVal = strval($this->t_04->CurrentValue);
            if ($curVal != "") {
                $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
                if ($this->t_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_04->Lookup->renderViewRow($row);
                            $this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
                        }
                    } else {
                        $this->t_04->ViewValue = $this->t_04->CurrentValue;
                    }
                }
            } else {
                $this->t_04->ViewValue = null;
            }

            // t_05
            $curVal = strval($this->t_05->CurrentValue);
            if ($curVal != "") {
                $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
                if ($this->t_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_05->Lookup->renderViewRow($row);
                            $this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
                        }
                    } else {
                        $this->t_05->ViewValue = $this->t_05->CurrentValue;
                    }
                }
            } else {
                $this->t_05->ViewValue = null;
            }

            // t_06
            $curVal = strval($this->t_06->CurrentValue);
            if ($curVal != "") {
                $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
                if ($this->t_06->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_06->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_06->Lookup->renderViewRow($row);
                            $this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
                        }
                    } else {
                        $this->t_06->ViewValue = $this->t_06->CurrentValue;
                    }
                }
            } else {
                $this->t_06->ViewValue = null;
            }

            // t_07
            $curVal = strval($this->t_07->CurrentValue);
            if ($curVal != "") {
                $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
                if ($this->t_07->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_07->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_07->Lookup->renderViewRow($row);
                            $this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
                        }
                    } else {
                        $this->t_07->ViewValue = $this->t_07->CurrentValue;
                    }
                }
            } else {
                $this->t_07->ViewValue = null;
            }

            // t_08
            $curVal = strval($this->t_08->CurrentValue);
            if ($curVal != "") {
                $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
                if ($this->t_08->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_08->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_08->Lookup->renderViewRow($row);
                            $this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
                        }
                    } else {
                        $this->t_08->ViewValue = $this->t_08->CurrentValue;
                    }
                }
            } else {
                $this->t_08->ViewValue = null;
            }

            // t_09
            $curVal = strval($this->t_09->CurrentValue);
            if ($curVal != "") {
                $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
                if ($this->t_09->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_09->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_09->Lookup->renderViewRow($row);
                            $this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
                        }
                    } else {
                        $this->t_09->ViewValue = $this->t_09->CurrentValue;
                    }
                }
            } else {
                $this->t_09->ViewValue = null;
            }

            // t_10
            $curVal = strval($this->t_10->CurrentValue);
            if ($curVal != "") {
                $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
                if ($this->t_10->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->t_10->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->t_10->Lookup->renderViewRow($row);
                            $this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
                        }
                    } else {
                        $this->t_10->ViewValue = $this->t_10->CurrentValue;
                    }
                }
            } else {
                $this->t_10->ViewValue = null;
            }

            // t_11
            $this->t_11->ViewValue = $this->t_11->CurrentValue;
            $curVal = strval($this->t_11->CurrentValue);
            if ($curVal != "") {
                $this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->ViewValue = $this->t_11->CurrentValue;
                    }
                }
            } else {
                $this->t_11->ViewValue = null;
            }

            // t_12
            $this->t_12->ViewValue = $this->t_12->CurrentValue;
            $curVal = strval($this->t_12->CurrentValue);
            if ($curVal != "") {
                $this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->ViewValue = $this->t_12->CurrentValue;
                    }
                }
            } else {
                $this->t_12->ViewValue = null;
            }

            // t_13
            $this->t_13->ViewValue = $this->t_13->CurrentValue;

            // t_14
            $this->t_14->ViewValue = $this->t_14->CurrentValue;

            // t_15
            $this->t_15->ViewValue = $this->t_15->CurrentValue;

            // last_price
            $this->last_price->ViewValue = $this->last_price->CurrentValue;

            // currency
            $curVal = strval($this->currency->CurrentValue);
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
                if ($this->currency->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                    $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                        $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                    } else {
                        $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                    }
                }
            } else {
                $this->currency->ViewValue = null;
            }

            // hsn
            $curVal = strval($this->hsn->CurrentValue);
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
                if ($this->hsn->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                    $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                        $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                    } else {
                        $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                    }
                }
            } else {
                $this->hsn->ViewValue = null;
            }

            // composition
            $curVal = strval($this->composition->CurrentValue);
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
                if ($this->composition->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                    $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                        $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                    } else {
                        $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                    }
                }
            } else {
                $this->composition->ViewValue = null;
            }

            // category
            $curVal = strval($this->category->CurrentValue);
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
                if ($this->category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                        $this->category->ViewValue = $this->category->displayValue($arwrk);
                    } else {
                        $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                    }
                }
            } else {
                $this->category->ViewValue = null;
            }

            // moq
            $this->moq->ViewValue = $this->moq->CurrentValue;
            $this->moq->ViewValue = FormatNumber($this->moq->ViewValue, $this->moq->formatPattern());

            // status
            if (strval($this->status->CurrentValue) != "") {
                $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
            } else {
                $this->status->ViewValue = null;
            }

            // d_head_01
            $this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;

            // d_description_01
            $this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;

            // d_head_02
            $this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;

            // d_description_02
            $this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;

            // publish
            if (strval($this->publish->CurrentValue) != "") {
                $this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
            } else {
                $this->publish->ViewValue = null;
            }

            // keywords
            $this->keywords->ViewValue = $this->keywords->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->ImageWidth = 0;
                $this->main_image->ImageHeight = 40;
                $this->main_image->ImageAlt = $this->main_image->alt();
                $this->main_image->ImageCssClass = "ew-image";
                $this->main_image->ViewValue = $this->main_image->Upload->DbValue;
            } else {
                $this->main_image->ViewValue = "";
            }

            // top_view
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->ImageWidth = 0;
                $this->top_view->ImageHeight = 40;
                $this->top_view->ImageAlt = $this->top_view->alt();
                $this->top_view->ImageCssClass = "ew-image";
                $this->top_view->ViewValue = $this->top_view->Upload->DbValue;
            } else {
                $this->top_view->ViewValue = "";
            }

            // front_view
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->ImageWidth = 0;
                $this->front_view->ImageHeight = 40;
                $this->front_view->ImageAlt = $this->front_view->alt();
                $this->front_view->ImageCssClass = "ew-image";
                $this->front_view->ViewValue = $this->front_view->Upload->DbValue;
            } else {
                $this->front_view->ViewValue = "";
            }

            // corner_view
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->ImageWidth = 0;
                $this->corner_view->ImageHeight = 40;
                $this->corner_view->ImageAlt = $this->corner_view->alt();
                $this->corner_view->ImageCssClass = "ew-image";
                $this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
            } else {
                $this->corner_view->ViewValue = "";
            }

            // back_view
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->ImageWidth = 0;
                $this->back_view->ImageHeight = 40;
                $this->back_view->ImageAlt = $this->back_view->alt();
                $this->back_view->ImageCssClass = "ew-image";
                $this->back_view->ViewValue = $this->back_view->Upload->DbValue;
            } else {
                $this->back_view->ViewValue = "";
            }

            // color_options
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->ImageWidth = 0;
                $this->color_options->ImageHeight = 40;
                $this->color_options->ImageAlt = $this->color_options->alt();
                $this->color_options->ImageCssClass = "ew-image";
                $this->color_options->ViewValue = $this->color_options->Upload->DbValue;
            } else {
                $this->color_options->ViewValue = "";
            }

            // other_options
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->ImageWidth = 0;
                $this->other_options->ImageHeight = 40;
                $this->other_options->ImageAlt = $this->other_options->alt();
                $this->other_options->ImageCssClass = "ew-image";
                $this->other_options->ViewValue = $this->other_options->Upload->DbValue;
            } else {
                $this->other_options->ViewValue = "";
            }

            // group_image
            $this->group_image->UploadPath = $this->group_image->getUploadPath(); // PHP
            if (!EmptyValue($this->group_image->Upload->DbValue)) {
                $this->group_image->ViewValue = $this->group_image->Upload->DbValue;
            } else {
                $this->group_image->ViewValue = "";
            }

            // video_url
            $this->video_url->ViewValue = $this->video_url->CurrentValue;

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->ViewValue = $this->image->Upload->DbValue;
            } else {
                $this->image->ViewValue = "";
            }

            // in
            $this->in->ViewValue = $this->in->CurrentValue;
            $this->in->ViewValue = FormatNumber($this->in->ViewValue, $this->in->formatPattern());

            // out
            $this->out->ViewValue = $this->out->CurrentValue;
            $this->out->ViewValue = FormatNumber($this->out->ViewValue, $this->out->formatPattern());

            // required
            $this->required->ViewValue = $this->required->CurrentValue;
            $this->required->ViewValue = FormatNumber($this->required->ViewValue, $this->required->formatPattern());

            // blocked
            $this->blocked->ViewValue = $this->blocked->CurrentValue;
            $this->blocked->ViewValue = FormatNumber($this->blocked->ViewValue, $this->blocked->formatPattern());

            // ordered
            $this->ordered->ViewValue = $this->ordered->CurrentValue;
            $this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, $this->ordered->formatPattern());

            // supplier
            $this->supplier->ViewValue = $this->supplier->CurrentValue;

            // country
            $this->country->ViewValue = $this->country->CurrentValue;

            // minimum_stock
            $this->minimum_stock->ViewValue = $this->minimum_stock->CurrentValue;
            $this->minimum_stock->ViewValue = FormatNumber($this->minimum_stock->ViewValue, $this->minimum_stock->formatPattern());

            // oid
            $this->oid->HrefValue = "";
            $this->oid->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // grp
            $this->grp->HrefValue = "";
            $this->grp->TooltipValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";
            $this->s_grp->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // product_type
            $this->product_type->HrefValue = "";
            $this->product_type->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";
            $this->product_code_type->TooltipValue = "";

            // product_code
            $this->product_code->HrefValue = "";
            $this->product_code->TooltipValue = "";

            // print_name
            $this->print_name->HrefValue = "";
            $this->print_name->TooltipValue = "";

            // gcode
            $this->gcode->HrefValue = "";
            $this->gcode->TooltipValue = "";

            // code
            $this->code->HrefValue = "";
            $this->code->TooltipValue = "";

            // product_id
            $this->product_id->HrefValue = "";
            $this->product_id->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";

            // set_ref
            $this->set_ref->HrefValue = "";
            $this->set_ref->TooltipValue = "";

            // v_00
            $this->v_00->HrefValue = "";
            $this->v_00->TooltipValue = "";

            // v_01
            $this->v_01->HrefValue = "";
            $this->v_01->TooltipValue = "";

            // v_02
            $this->v_02->HrefValue = "";
            $this->v_02->TooltipValue = "";

            // v_03
            $this->v_03->HrefValue = "";
            $this->v_03->TooltipValue = "";

            // v_04
            $this->v_04->HrefValue = "";
            $this->v_04->TooltipValue = "";

            // v_05
            $this->v_05->HrefValue = "";
            $this->v_05->TooltipValue = "";

            // v_06
            $this->v_06->HrefValue = "";
            $this->v_06->TooltipValue = "";

            // v_07
            $this->v_07->HrefValue = "";
            $this->v_07->TooltipValue = "";

            // v_08
            $this->v_08->HrefValue = "";
            $this->v_08->TooltipValue = "";

            // v_09
            $this->v_09->HrefValue = "";
            $this->v_09->TooltipValue = "";

            // v_10
            $this->v_10->HrefValue = "";
            $this->v_10->TooltipValue = "";

            // cbm
            $this->cbm->HrefValue = "";
            $this->cbm->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // shape
            $this->shape->HrefValue = "";
            $this->shape->TooltipValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";
            $this->q_sku->TooltipValue = "";

            // b_01
            $this->b_01->HrefValue = "";
            $this->b_01->TooltipValue = "";

            // b_02
            $this->b_02->HrefValue = "";
            $this->b_02->TooltipValue = "";

            // b_03
            $this->b_03->HrefValue = "";
            $this->b_03->TooltipValue = "";

            // b_04
            $this->b_04->HrefValue = "";
            $this->b_04->TooltipValue = "";

            // b_05
            $this->b_05->HrefValue = "";
            $this->b_05->TooltipValue = "";

            // b_06
            $this->b_06->HrefValue = "";
            $this->b_06->TooltipValue = "";

            // b_07
            $this->b_07->HrefValue = "";
            $this->b_07->TooltipValue = "";

            // b_08
            $this->b_08->HrefValue = "";
            $this->b_08->TooltipValue = "";

            // b_09
            $this->b_09->HrefValue = "";
            $this->b_09->TooltipValue = "";

            // b_10
            $this->b_10->HrefValue = "";
            $this->b_10->TooltipValue = "";

            // b_11
            $this->b_11->HrefValue = "";
            $this->b_11->TooltipValue = "";

            // b_12
            $this->b_12->HrefValue = "";
            $this->b_12->TooltipValue = "";

            // b_13
            $this->b_13->HrefValue = "";
            $this->b_13->TooltipValue = "";

            // b_14
            $this->b_14->HrefValue = "";
            $this->b_14->TooltipValue = "";

            // b_15
            $this->b_15->HrefValue = "";
            $this->b_15->TooltipValue = "";

            // t_01
            $this->t_01->HrefValue = "";
            $this->t_01->TooltipValue = "";

            // t_02
            $this->t_02->HrefValue = "";
            $this->t_02->TooltipValue = "";

            // t_03
            $this->t_03->HrefValue = "";
            $this->t_03->TooltipValue = "";

            // t_04
            $this->t_04->HrefValue = "";
            $this->t_04->TooltipValue = "";

            // t_05
            $this->t_05->HrefValue = "";
            $this->t_05->TooltipValue = "";

            // t_06
            $this->t_06->HrefValue = "";
            $this->t_06->TooltipValue = "";

            // t_07
            $this->t_07->HrefValue = "";
            $this->t_07->TooltipValue = "";

            // t_08
            $this->t_08->HrefValue = "";
            $this->t_08->TooltipValue = "";

            // t_09
            $this->t_09->HrefValue = "";
            $this->t_09->TooltipValue = "";

            // t_10
            $this->t_10->HrefValue = "";
            $this->t_10->TooltipValue = "";

            // t_11
            $this->t_11->HrefValue = "";
            $this->t_11->TooltipValue = "";

            // t_12
            $this->t_12->HrefValue = "";
            $this->t_12->TooltipValue = "";

            // t_13
            $this->t_13->HrefValue = "";
            $this->t_13->TooltipValue = "";

            // t_14
            $this->t_14->HrefValue = "";
            $this->t_14->TooltipValue = "";

            // t_15
            $this->t_15->HrefValue = "";
            $this->t_15->TooltipValue = "";

            // last_price
            $this->last_price->HrefValue = "";
            $this->last_price->TooltipValue = "";

            // currency
            $this->currency->HrefValue = "";
            $this->currency->TooltipValue = "";

            // hsn
            $this->hsn->HrefValue = "";
            $this->hsn->TooltipValue = "";

            // composition
            $this->composition->HrefValue = "";
            $this->composition->TooltipValue = "";

            // category
            $this->category->HrefValue = "";
            $this->category->TooltipValue = "";

            // moq
            $this->moq->HrefValue = "";
            $this->moq->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // d_head_01
            $this->d_head_01->HrefValue = "";
            $this->d_head_01->TooltipValue = "";

            // d_description_01
            $this->d_description_01->HrefValue = "";
            $this->d_description_01->TooltipValue = "";

            // d_head_02
            $this->d_head_02->HrefValue = "";
            $this->d_head_02->TooltipValue = "";

            // d_description_02
            $this->d_description_02->HrefValue = "";
            $this->d_description_02->TooltipValue = "";

            // publish
            $this->publish->HrefValue = "";
            $this->publish->TooltipValue = "";

            // keywords
            $this->keywords->HrefValue = "";
            $this->keywords->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->htmlDecode($this->main_image->Upload->DbValue)); // Add prefix/suffix
                $this->main_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
                }
            } else {
                $this->main_image->HrefValue = "";
            }
            $this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
            $this->main_image->TooltipValue = "";
            if ($this->main_image->UseColorbox) {
                if (EmptyValue($this->main_image->TooltipValue)) {
                    $this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->main_image->LinkAttrs["data-rel"] = "ref_x_main_image";
                $this->main_image->LinkAttrs->appendClass("ew-lightbox");
            }

            // top_view
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->HrefValue = "%u"; // Add prefix/suffix
                $this->top_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
                }
            } else {
                $this->top_view->HrefValue = "";
            }
            $this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
            $this->top_view->TooltipValue = "";
            if ($this->top_view->UseColorbox) {
                if (EmptyValue($this->top_view->TooltipValue)) {
                    $this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->top_view->LinkAttrs["data-rel"] = "ref_x_top_view";
                $this->top_view->LinkAttrs->appendClass("ew-lightbox");
            }

            // front_view
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->HrefValue = "%u"; // Add prefix/suffix
                $this->front_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
                }
            } else {
                $this->front_view->HrefValue = "";
            }
            $this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
            $this->front_view->TooltipValue = "";
            if ($this->front_view->UseColorbox) {
                if (EmptyValue($this->front_view->TooltipValue)) {
                    $this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->front_view->LinkAttrs["data-rel"] = "ref_x_front_view";
                $this->front_view->LinkAttrs->appendClass("ew-lightbox");
            }

            // corner_view
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->HrefValue = "%u"; // Add prefix/suffix
                $this->corner_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
                }
            } else {
                $this->corner_view->HrefValue = "";
            }
            $this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
            $this->corner_view->TooltipValue = "";
            if ($this->corner_view->UseColorbox) {
                if (EmptyValue($this->corner_view->TooltipValue)) {
                    $this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->corner_view->LinkAttrs["data-rel"] = "ref_x_corner_view";
                $this->corner_view->LinkAttrs->appendClass("ew-lightbox");
            }

            // back_view
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->HrefValue = "%u"; // Add prefix/suffix
                $this->back_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
                }
            } else {
                $this->back_view->HrefValue = "";
            }
            $this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
            $this->back_view->TooltipValue = "";
            if ($this->back_view->UseColorbox) {
                if (EmptyValue($this->back_view->TooltipValue)) {
                    $this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->back_view->LinkAttrs["data-rel"] = "ref_x_back_view";
                $this->back_view->LinkAttrs->appendClass("ew-lightbox");
            }

            // color_options
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->HrefValue = "%u"; // Add prefix/suffix
                $this->color_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
                }
            } else {
                $this->color_options->HrefValue = "";
            }
            $this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
            $this->color_options->TooltipValue = "";
            if ($this->color_options->UseColorbox) {
                if (EmptyValue($this->color_options->TooltipValue)) {
                    $this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->color_options->LinkAttrs["data-rel"] = "ref_x_color_options";
                $this->color_options->LinkAttrs->appendClass("ew-lightbox");
            }

            // other_options
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->HrefValue = "%u"; // Add prefix/suffix
                $this->other_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
                }
            } else {
                $this->other_options->HrefValue = "";
            }
            $this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
            $this->other_options->TooltipValue = "";
            if ($this->other_options->UseColorbox) {
                if (EmptyValue($this->other_options->TooltipValue)) {
                    $this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->other_options->LinkAttrs["data-rel"] = "ref_x_other_options";
                $this->other_options->LinkAttrs->appendClass("ew-lightbox");
            }

            // group_image
            $this->group_image->HrefValue = "";
            $this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;
            $this->group_image->TooltipValue = "";

            // video_url
            $this->video_url->HrefValue = "";
            $this->video_url->TooltipValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = "%u"; // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
            $this->image->TooltipValue = "";
            if ($this->image->UseColorbox) {
                if (EmptyValue($this->image->TooltipValue)) {
                    $this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->image->LinkAttrs["data-rel"] = "ref_x_image";
                $this->image->LinkAttrs->appendClass("ew-lightbox");
            }

            // in
            $this->in->HrefValue = "";
            $this->in->TooltipValue = "";

            // out
            $this->out->HrefValue = "";
            $this->out->TooltipValue = "";

            // required
            $this->required->HrefValue = "";
            $this->required->TooltipValue = "";

            // blocked
            $this->blocked->HrefValue = "";
            $this->blocked->TooltipValue = "";

            // ordered
            $this->ordered->HrefValue = "";
            $this->ordered->TooltipValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // country
            if (!EmptyValue($this->country->CurrentValue)) {
                $this->country->HrefValue = $this->country->getLinkPrefix() . $this->country->CurrentValue; // Add prefix/suffix
                $this->country->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->country->HrefValue = FullUrl($this->country->HrefValue, "href");
                }
            } else {
                $this->country->HrefValue = "";
            }
            $this->country->TooltipValue = "";

            // minimum_stock
            $this->minimum_stock->HrefValue = "";
            $this->minimum_stock->TooltipValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // oid
            $this->oid->setupEditAttributes();
            if (!$this->oid->Raw) {
                $this->oid->CurrentValue = HtmlDecode($this->oid->CurrentValue);
            }
            $this->oid->EditValue = HtmlEncode($this->oid->CurrentValue);
            $this->oid->PlaceHolder = RemoveHtml($this->oid->caption());

            // company_id
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
                if ($this->company_id->ViewValue == "") {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->company_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->company_id->Lookup->renderViewRow($row);
                        $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->company_id->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // grp
            $this->grp->setupEditAttributes();
            $curVal = trim(strval($this->grp->CurrentValue));
            if ($curVal != "") {
                $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            } else {
                $this->grp->ViewValue = $this->grp->Lookup !== null && is_array($this->grp->lookupOptions()) && count($this->grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->grp->ViewValue !== null) { // Load from cache
                $this->grp->EditValue = array_values($this->grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->grp->CurrentValue, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->grp->EditValue = $arwrk;
            }
            $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

            // s_grp
            $this->s_grp->setupEditAttributes();
            $curVal = trim(strval($this->s_grp->CurrentValue));
            if ($curVal != "") {
                $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            } else {
                $this->s_grp->ViewValue = $this->s_grp->Lookup !== null && is_array($this->s_grp->lookupOptions()) && count($this->s_grp->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->s_grp->ViewValue !== null) { // Load from cache
                $this->s_grp->EditValue = array_values($this->s_grp->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->s_grp->CurrentValue, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->s_grp->EditValue = $arwrk;
            }
            $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->CurrentValue));
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->CurrentValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // product_type
            $this->product_type->setupEditAttributes();
            $curVal = trim(strval($this->product_type->CurrentValue));
            if ($curVal != "") {
                $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            } else {
                $this->product_type->ViewValue = $this->product_type->Lookup !== null && is_array($this->product_type->lookupOptions()) && count($this->product_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product_type->ViewValue !== null) { // Load from cache
                $this->product_type->EditValue = array_values($this->product_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product_type->CurrentValue, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product_type->EditValue = $arwrk;
            }
            $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            if (!$this->_barcode->Raw) {
                $this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
            }
            $this->_barcode->EditValue = HtmlEncode($this->_barcode->CurrentValue);
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // product_code_type
            $this->product_code_type->setupEditAttributes();
            $this->product_code_type->EditValue = $this->product_code_type->options(true);
            $this->product_code_type->PlaceHolder = RemoveHtml($this->product_code_type->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            $this->product_code->EditValue = HtmlEncode($this->product_code->CurrentValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // print_name
            $this->print_name->setupEditAttributes();
            $this->print_name->EditCustomAttributes = $this->print_name->getEditCustomAttributes(); // PHP
            if (!$this->print_name->Raw) {
                $this->print_name->CurrentValue = HtmlDecode($this->print_name->CurrentValue);
            }
            $this->print_name->EditValue = HtmlEncode($this->print_name->CurrentValue);
            $this->print_name->PlaceHolder = RemoveHtml($this->print_name->caption());

            // gcode
            $this->gcode->setupEditAttributes();
            if (!$this->gcode->Raw) {
                $this->gcode->CurrentValue = HtmlDecode($this->gcode->CurrentValue);
            }
            $this->gcode->EditValue = HtmlEncode($this->gcode->CurrentValue);
            $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

            // code
            $this->code->setupEditAttributes();
            if (!$this->code->Raw) {
                $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
            }
            $this->code->EditValue = HtmlEncode($this->code->CurrentValue);
            $this->code->PlaceHolder = RemoveHtml($this->code->caption());

            // product_id
            $this->product_id->setupEditAttributes();
            if (!$this->product_id->Raw) {
                $this->product_id->CurrentValue = HtmlDecode($this->product_id->CurrentValue);
            }
            $this->product_id->EditValue = HtmlEncode($this->product_id->CurrentValue);
            $this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            if (!$this->batch_no->Raw) {
                $this->batch_no->CurrentValue = HtmlDecode($this->batch_no->CurrentValue);
            }
            $this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // set_ref
            $curVal = trim(strval($this->set_ref->CurrentValue));
            if ($curVal != "") {
                $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
            } else {
                $this->set_ref->ViewValue = $this->set_ref->Lookup !== null && is_array($this->set_ref->lookupOptions()) && count($this->set_ref->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->set_ref->ViewValue !== null) { // Load from cache
                $this->set_ref->EditValue = array_values($this->set_ref->lookupOptions());
                if ($this->set_ref->ViewValue == "") {
                    $this->set_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->set_ref->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->set_ref->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                        $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->set_ref->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->set_ref->EditValue = $arwrk;
            }
            $this->set_ref->PlaceHolder = RemoveHtml($this->set_ref->caption());

            // v_00
            $this->v_00->setupEditAttributes();
            if (!$this->v_00->Raw) {
                $this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
            }
            $this->v_00->EditValue = HtmlEncode($this->v_00->CurrentValue);
            $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

            // v_01
            $this->v_01->setupEditAttributes();
            $curVal = trim(strval($this->v_01->CurrentValue));
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
            } else {
                $this->v_01->ViewValue = $this->v_01->Lookup !== null && is_array($this->v_01->lookupOptions()) && count($this->v_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_01->ViewValue !== null) { // Load from cache
                $this->v_01->EditValue = array_values($this->v_01->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_01->CurrentValue, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_01->EditValue = $arwrk;
            }
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_02
            $this->v_02->setupEditAttributes();
            $curVal = trim(strval($this->v_02->CurrentValue));
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
            } else {
                $this->v_02->ViewValue = $this->v_02->Lookup !== null && is_array($this->v_02->lookupOptions()) && count($this->v_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_02->ViewValue !== null) { // Load from cache
                $this->v_02->EditValue = array_values($this->v_02->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_02->CurrentValue, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_02->EditValue = $arwrk;
            }
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_03
            $this->v_03->setupEditAttributes();
            $curVal = trim(strval($this->v_03->CurrentValue));
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
            } else {
                $this->v_03->ViewValue = $this->v_03->Lookup !== null && is_array($this->v_03->lookupOptions()) && count($this->v_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_03->ViewValue !== null) { // Load from cache
                $this->v_03->EditValue = array_values($this->v_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_03->CurrentValue, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_03->EditValue = $arwrk;
            }
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_04
            $this->v_04->setupEditAttributes();
            $curVal = trim(strval($this->v_04->CurrentValue));
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
            } else {
                $this->v_04->ViewValue = $this->v_04->Lookup !== null && is_array($this->v_04->lookupOptions()) && count($this->v_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_04->ViewValue !== null) { // Load from cache
                $this->v_04->EditValue = array_values($this->v_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_04->CurrentValue, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_04->EditValue = $arwrk;
            }
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_05
            $this->v_05->setupEditAttributes();
            $curVal = trim(strval($this->v_05->CurrentValue));
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
            } else {
                $this->v_05->ViewValue = $this->v_05->Lookup !== null && is_array($this->v_05->lookupOptions()) && count($this->v_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_05->ViewValue !== null) { // Load from cache
                $this->v_05->EditValue = array_values($this->v_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_05->CurrentValue, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_05->EditValue = $arwrk;
            }
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // v_06
            $this->v_06->setupEditAttributes();
            $curVal = trim(strval($this->v_06->CurrentValue));
            if ($curVal != "") {
                $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
            } else {
                $this->v_06->ViewValue = $this->v_06->Lookup !== null && is_array($this->v_06->lookupOptions()) && count($this->v_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_06->ViewValue !== null) { // Load from cache
                $this->v_06->EditValue = array_values($this->v_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_06->CurrentValue, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_06->EditValue = $arwrk;
            }
            $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

            // v_07
            $this->v_07->setupEditAttributes();
            $curVal = trim(strval($this->v_07->CurrentValue));
            if ($curVal != "") {
                $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
            } else {
                $this->v_07->ViewValue = $this->v_07->Lookup !== null && is_array($this->v_07->lookupOptions()) && count($this->v_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_07->ViewValue !== null) { // Load from cache
                $this->v_07->EditValue = array_values($this->v_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_07->CurrentValue, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_07->EditValue = $arwrk;
            }
            $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

            // v_08
            $this->v_08->setupEditAttributes();
            $curVal = trim(strval($this->v_08->CurrentValue));
            if ($curVal != "") {
                $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
            } else {
                $this->v_08->ViewValue = $this->v_08->Lookup !== null && is_array($this->v_08->lookupOptions()) && count($this->v_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_08->ViewValue !== null) { // Load from cache
                $this->v_08->EditValue = array_values($this->v_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_08->CurrentValue, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_08->EditValue = $arwrk;
            }
            $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

            // v_09
            $this->v_09->setupEditAttributes();
            $curVal = trim(strval($this->v_09->CurrentValue));
            if ($curVal != "") {
                $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
            } else {
                $this->v_09->ViewValue = $this->v_09->Lookup !== null && is_array($this->v_09->lookupOptions()) && count($this->v_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_09->ViewValue !== null) { // Load from cache
                $this->v_09->EditValue = array_values($this->v_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_09->CurrentValue, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_09->EditValue = $arwrk;
            }
            $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

            // v_10
            $this->v_10->setupEditAttributes();
            $curVal = trim(strval($this->v_10->CurrentValue));
            if ($curVal != "") {
                $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
            } else {
                $this->v_10->ViewValue = $this->v_10->Lookup !== null && is_array($this->v_10->lookupOptions()) && count($this->v_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_10->ViewValue !== null) { // Load from cache
                $this->v_10->EditValue = array_values($this->v_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $this->v_10->CurrentValue, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                }
                $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->v_10->EditValue = $arwrk;
            }
            $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

            // cbm
            $this->cbm->setupEditAttributes();
            $this->cbm->EditValue = $this->cbm->CurrentValue;
            $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
            if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
                $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
            }

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->CurrentValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
                $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
            }

            // shape
            $curVal = trim(strval($this->shape->CurrentValue));
            if ($curVal != "") {
                $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            } else {
                $this->shape->ViewValue = $this->shape->Lookup !== null && is_array($this->shape->lookupOptions()) && count($this->shape->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shape->ViewValue !== null) { // Load from cache
                $this->shape->EditValue = array_values($this->shape->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shape->EditValue = $arwrk;
            }
            $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

            // q_sku
            $this->q_sku->setupEditAttributes();
            $this->q_sku->EditValue = $this->q_sku->CurrentValue;
            $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
            if (strval($this->q_sku->EditValue) != "" && is_numeric($this->q_sku->EditValue)) {
                $this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, null);
            }

            // b_01
            $this->b_01->setupEditAttributes();
            if (!$this->b_01->Raw) {
                $this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
            }
            $this->b_01->EditValue = HtmlEncode($this->b_01->CurrentValue);
            $this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

            // b_02
            $this->b_02->setupEditAttributes();
            if (!$this->b_02->Raw) {
                $this->b_02->CurrentValue = HtmlDecode($this->b_02->CurrentValue);
            }
            $this->b_02->EditValue = HtmlEncode($this->b_02->CurrentValue);
            $this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

            // b_03
            $curVal = trim(strval($this->b_03->CurrentValue));
            if ($curVal != "") {
                $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
            } else {
                $this->b_03->ViewValue = $this->b_03->Lookup !== null && is_array($this->b_03->lookupOptions()) && count($this->b_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_03->ViewValue !== null) { // Load from cache
                $this->b_03->EditValue = array_values($this->b_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_03->EditValue = $arwrk;
            }
            $this->b_03->PlaceHolder = RemoveHtml($this->b_03->caption());

            // b_04
            $curVal = trim(strval($this->b_04->CurrentValue));
            if ($curVal != "") {
                $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
            } else {
                $this->b_04->ViewValue = $this->b_04->Lookup !== null && is_array($this->b_04->lookupOptions()) && count($this->b_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_04->ViewValue !== null) { // Load from cache
                $this->b_04->EditValue = array_values($this->b_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_04->EditValue = $arwrk;
            }
            $this->b_04->PlaceHolder = RemoveHtml($this->b_04->caption());

            // b_05
            $curVal = trim(strval($this->b_05->CurrentValue));
            if ($curVal != "") {
                $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
            } else {
                $this->b_05->ViewValue = $this->b_05->Lookup !== null && is_array($this->b_05->lookupOptions()) && count($this->b_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_05->ViewValue !== null) { // Load from cache
                $this->b_05->EditValue = array_values($this->b_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_05->EditValue = $arwrk;
            }
            $this->b_05->PlaceHolder = RemoveHtml($this->b_05->caption());

            // b_06
            $curVal = trim(strval($this->b_06->CurrentValue));
            if ($curVal != "") {
                $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
            } else {
                $this->b_06->ViewValue = $this->b_06->Lookup !== null && is_array($this->b_06->lookupOptions()) && count($this->b_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_06->ViewValue !== null) { // Load from cache
                $this->b_06->EditValue = array_values($this->b_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_06->EditValue = $arwrk;
            }
            $this->b_06->PlaceHolder = RemoveHtml($this->b_06->caption());

            // b_07
            $curVal = trim(strval($this->b_07->CurrentValue));
            if ($curVal != "") {
                $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
            } else {
                $this->b_07->ViewValue = $this->b_07->Lookup !== null && is_array($this->b_07->lookupOptions()) && count($this->b_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_07->ViewValue !== null) { // Load from cache
                $this->b_07->EditValue = array_values($this->b_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_07->EditValue = $arwrk;
            }
            $this->b_07->PlaceHolder = RemoveHtml($this->b_07->caption());

            // b_08
            $curVal = trim(strval($this->b_08->CurrentValue));
            if ($curVal != "") {
                $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
            } else {
                $this->b_08->ViewValue = $this->b_08->Lookup !== null && is_array($this->b_08->lookupOptions()) && count($this->b_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_08->ViewValue !== null) { // Load from cache
                $this->b_08->EditValue = array_values($this->b_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_08->EditValue = $arwrk;
            }
            $this->b_08->PlaceHolder = RemoveHtml($this->b_08->caption());

            // b_09
            $curVal = trim(strval($this->b_09->CurrentValue));
            if ($curVal != "") {
                $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
            } else {
                $this->b_09->ViewValue = $this->b_09->Lookup !== null && is_array($this->b_09->lookupOptions()) && count($this->b_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_09->ViewValue !== null) { // Load from cache
                $this->b_09->EditValue = array_values($this->b_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_09->EditValue = $arwrk;
            }
            $this->b_09->PlaceHolder = RemoveHtml($this->b_09->caption());

            // b_10
            $curVal = trim(strval($this->b_10->CurrentValue));
            if ($curVal != "") {
                $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
            } else {
                $this->b_10->ViewValue = $this->b_10->Lookup !== null && is_array($this->b_10->lookupOptions()) && count($this->b_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->b_10->ViewValue !== null) { // Load from cache
                $this->b_10->EditValue = array_values($this->b_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->b_10->EditValue = $arwrk;
            }
            $this->b_10->PlaceHolder = RemoveHtml($this->b_10->caption());

            // b_11
            $this->b_11->setupEditAttributes();
            if (!$this->b_11->Raw) {
                $this->b_11->CurrentValue = HtmlDecode($this->b_11->CurrentValue);
            }
            $this->b_11->EditValue = HtmlEncode($this->b_11->CurrentValue);
            $this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

            // b_12
            $this->b_12->setupEditAttributes();
            if (!$this->b_12->Raw) {
                $this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
            }
            $this->b_12->EditValue = HtmlEncode($this->b_12->CurrentValue);
            $this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

            // b_13
            $this->b_13->setupEditAttributes();
            if (!$this->b_13->Raw) {
                $this->b_13->CurrentValue = HtmlDecode($this->b_13->CurrentValue);
            }
            $this->b_13->EditValue = HtmlEncode($this->b_13->CurrentValue);
            $this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

            // b_14
            $this->b_14->setupEditAttributes();
            if (!$this->b_14->Raw) {
                $this->b_14->CurrentValue = HtmlDecode($this->b_14->CurrentValue);
            }
            $this->b_14->EditValue = HtmlEncode($this->b_14->CurrentValue);
            $this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

            // b_15
            $this->b_15->setupEditAttributes();
            if (!$this->b_15->Raw) {
                $this->b_15->CurrentValue = HtmlDecode($this->b_15->CurrentValue);
            }
            $this->b_15->EditValue = HtmlEncode($this->b_15->CurrentValue);
            $this->b_15->PlaceHolder = RemoveHtml($this->b_15->caption());

            // t_01
            $this->t_01->setupEditAttributes();
            if (!$this->t_01->Raw) {
                $this->t_01->CurrentValue = HtmlDecode($this->t_01->CurrentValue);
            }
            $this->t_01->EditValue = HtmlEncode($this->t_01->CurrentValue);
            $this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

            // t_02
            $this->t_02->setupEditAttributes();
            if (!$this->t_02->Raw) {
                $this->t_02->CurrentValue = HtmlDecode($this->t_02->CurrentValue);
            }
            $this->t_02->EditValue = HtmlEncode($this->t_02->CurrentValue);
            $this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

            // t_03
            $curVal = trim(strval($this->t_03->CurrentValue));
            if ($curVal != "") {
                $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
            } else {
                $this->t_03->ViewValue = $this->t_03->Lookup !== null && is_array($this->t_03->lookupOptions()) && count($this->t_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_03->ViewValue !== null) { // Load from cache
                $this->t_03->EditValue = array_values($this->t_03->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_03->EditValue = $arwrk;
            }
            $this->t_03->PlaceHolder = RemoveHtml($this->t_03->caption());

            // t_04
            $curVal = trim(strval($this->t_04->CurrentValue));
            if ($curVal != "") {
                $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
            } else {
                $this->t_04->ViewValue = $this->t_04->Lookup !== null && is_array($this->t_04->lookupOptions()) && count($this->t_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_04->ViewValue !== null) { // Load from cache
                $this->t_04->EditValue = array_values($this->t_04->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_04->EditValue = $arwrk;
            }
            $this->t_04->PlaceHolder = RemoveHtml($this->t_04->caption());

            // t_05
            $curVal = trim(strval($this->t_05->CurrentValue));
            if ($curVal != "") {
                $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
            } else {
                $this->t_05->ViewValue = $this->t_05->Lookup !== null && is_array($this->t_05->lookupOptions()) && count($this->t_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_05->ViewValue !== null) { // Load from cache
                $this->t_05->EditValue = array_values($this->t_05->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_05->EditValue = $arwrk;
            }
            $this->t_05->PlaceHolder = RemoveHtml($this->t_05->caption());

            // t_06
            $curVal = trim(strval($this->t_06->CurrentValue));
            if ($curVal != "") {
                $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
            } else {
                $this->t_06->ViewValue = $this->t_06->Lookup !== null && is_array($this->t_06->lookupOptions()) && count($this->t_06->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_06->ViewValue !== null) { // Load from cache
                $this->t_06->EditValue = array_values($this->t_06->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_06->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_06->EditValue = $arwrk;
            }
            $this->t_06->PlaceHolder = RemoveHtml($this->t_06->caption());

            // t_07
            $curVal = trim(strval($this->t_07->CurrentValue));
            if ($curVal != "") {
                $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
            } else {
                $this->t_07->ViewValue = $this->t_07->Lookup !== null && is_array($this->t_07->lookupOptions()) && count($this->t_07->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_07->ViewValue !== null) { // Load from cache
                $this->t_07->EditValue = array_values($this->t_07->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_07->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_07->EditValue = $arwrk;
            }
            $this->t_07->PlaceHolder = RemoveHtml($this->t_07->caption());

            // t_08
            $curVal = trim(strval($this->t_08->CurrentValue));
            if ($curVal != "") {
                $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
            } else {
                $this->t_08->ViewValue = $this->t_08->Lookup !== null && is_array($this->t_08->lookupOptions()) && count($this->t_08->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_08->ViewValue !== null) { // Load from cache
                $this->t_08->EditValue = array_values($this->t_08->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_08->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_08->EditValue = $arwrk;
            }
            $this->t_08->PlaceHolder = RemoveHtml($this->t_08->caption());

            // t_09
            $curVal = trim(strval($this->t_09->CurrentValue));
            if ($curVal != "") {
                $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
            } else {
                $this->t_09->ViewValue = $this->t_09->Lookup !== null && is_array($this->t_09->lookupOptions()) && count($this->t_09->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_09->ViewValue !== null) { // Load from cache
                $this->t_09->EditValue = array_values($this->t_09->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_09->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_09->EditValue = $arwrk;
            }
            $this->t_09->PlaceHolder = RemoveHtml($this->t_09->caption());

            // t_10
            $curVal = trim(strval($this->t_10->CurrentValue));
            if ($curVal != "") {
                $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
            } else {
                $this->t_10->ViewValue = $this->t_10->Lookup !== null && is_array($this->t_10->lookupOptions()) && count($this->t_10->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->t_10->ViewValue !== null) { // Load from cache
                $this->t_10->EditValue = array_values($this->t_10->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_10->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->t_10->EditValue = $arwrk;
            }
            $this->t_10->PlaceHolder = RemoveHtml($this->t_10->caption());

            // t_11
            $this->t_11->setupEditAttributes();
            if (!$this->t_11->Raw) {
                $this->t_11->CurrentValue = HtmlDecode($this->t_11->CurrentValue);
            }
            $this->t_11->EditValue = HtmlEncode($this->t_11->CurrentValue);
            $curVal = strval($this->t_11->CurrentValue);
            if ($curVal != "") {
                $this->t_11->EditValue = $this->t_11->lookupCacheOption($curVal);
                if ($this->t_11->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                        $this->t_11->EditValue = $this->t_11->displayValue($arwrk);
                    } else {
                        $this->t_11->EditValue = HtmlEncode($this->t_11->CurrentValue);
                    }
                }
            } else {
                $this->t_11->EditValue = null;
            }
            $this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

            // t_12
            $this->t_12->setupEditAttributes();
            if (!$this->t_12->Raw) {
                $this->t_12->CurrentValue = HtmlDecode($this->t_12->CurrentValue);
            }
            $this->t_12->EditValue = HtmlEncode($this->t_12->CurrentValue);
            $curVal = strval($this->t_12->CurrentValue);
            if ($curVal != "") {
                $this->t_12->EditValue = $this->t_12->lookupCacheOption($curVal);
                if ($this->t_12->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                    $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                        $this->t_12->EditValue = $this->t_12->displayValue($arwrk);
                    } else {
                        $this->t_12->EditValue = HtmlEncode($this->t_12->CurrentValue);
                    }
                }
            } else {
                $this->t_12->EditValue = null;
            }
            $this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

            // t_13
            $this->t_13->setupEditAttributes();
            if (!$this->t_13->Raw) {
                $this->t_13->CurrentValue = HtmlDecode($this->t_13->CurrentValue);
            }
            $this->t_13->EditValue = HtmlEncode($this->t_13->CurrentValue);
            $this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

            // t_14
            $this->t_14->setupEditAttributes();
            if (!$this->t_14->Raw) {
                $this->t_14->CurrentValue = HtmlDecode($this->t_14->CurrentValue);
            }
            $this->t_14->EditValue = HtmlEncode($this->t_14->CurrentValue);
            $this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

            // t_15
            $this->t_15->setupEditAttributes();
            if (!$this->t_15->Raw) {
                $this->t_15->CurrentValue = HtmlDecode($this->t_15->CurrentValue);
            }
            $this->t_15->EditValue = HtmlEncode($this->t_15->CurrentValue);
            $this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

            // last_price
            $this->last_price->setupEditAttributes();
            if (!$this->last_price->Raw) {
                $this->last_price->CurrentValue = HtmlDecode($this->last_price->CurrentValue);
            }
            $this->last_price->EditValue = HtmlEncode($this->last_price->CurrentValue);
            $this->last_price->PlaceHolder = RemoveHtml($this->last_price->caption());

            // currency
            $this->currency->setupEditAttributes();
            $curVal = trim(strval($this->currency->CurrentValue));
            if ($curVal != "") {
                $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            } else {
                $this->currency->ViewValue = $this->currency->Lookup !== null && is_array($this->currency->lookupOptions()) && count($this->currency->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->currency->ViewValue !== null) { // Load from cache
                $this->currency->EditValue = array_values($this->currency->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->currency->CurrentValue, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->currency->EditValue = $arwrk;
            }
            $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

            // hsn
            $this->hsn->setupEditAttributes();
            $curVal = trim(strval($this->hsn->CurrentValue));
            if ($curVal != "") {
                $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
            } else {
                $this->hsn->ViewValue = $this->hsn->Lookup !== null && is_array($this->hsn->lookupOptions()) && count($this->hsn->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->hsn->ViewValue !== null) { // Load from cache
                $this->hsn->EditValue = array_values($this->hsn->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->hsn->CurrentValue, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                $sqlWrk = $this->hsn->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                foreach ($arwrk as &$row) {
                    $row = $this->hsn->Lookup->renderViewRow($row);
                }
                $this->hsn->EditValue = $arwrk;
            }
            $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

            // composition
            $this->composition->setupEditAttributes();
            $curVal = trim(strval($this->composition->CurrentValue));
            if ($curVal != "") {
                $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
            } else {
                $this->composition->ViewValue = $this->composition->Lookup !== null && is_array($this->composition->lookupOptions()) && count($this->composition->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->composition->ViewValue !== null) { // Load from cache
                $this->composition->EditValue = array_values($this->composition->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->composition->CurrentValue, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->composition->EditValue = $arwrk;
            }
            $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

            // category
            $this->category->setupEditAttributes();
            $curVal = trim(strval($this->category->CurrentValue));
            if ($curVal != "") {
                $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            } else {
                $this->category->ViewValue = $this->category->Lookup !== null && is_array($this->category->lookupOptions()) && count($this->category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->category->ViewValue !== null) { // Load from cache
                $this->category->EditValue = array_values($this->category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->category->CurrentValue, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->category->EditValue = $arwrk;
            }
            $this->category->PlaceHolder = RemoveHtml($this->category->caption());

            // moq
            $this->moq->setupEditAttributes();
            $this->moq->EditValue = $this->moq->CurrentValue;
            $this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
            if (strval($this->moq->EditValue) != "" && is_numeric($this->moq->EditValue)) {
                $this->moq->EditValue = FormatNumber($this->moq->EditValue, null);
            }

            // status
            $this->status->setupEditAttributes();
            $this->status->EditValue = $this->status->options(true);
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // d_head_01
            $this->d_head_01->setupEditAttributes();
            if (!$this->d_head_01->Raw) {
                $this->d_head_01->CurrentValue = HtmlDecode($this->d_head_01->CurrentValue);
            }
            $this->d_head_01->EditValue = HtmlEncode($this->d_head_01->CurrentValue);
            $this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

            // d_description_01
            $this->d_description_01->setupEditAttributes();
            $this->d_description_01->EditValue = HtmlEncode($this->d_description_01->CurrentValue);
            $this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

            // d_head_02
            $this->d_head_02->setupEditAttributes();
            if (!$this->d_head_02->Raw) {
                $this->d_head_02->CurrentValue = HtmlDecode($this->d_head_02->CurrentValue);
            }
            $this->d_head_02->EditValue = HtmlEncode($this->d_head_02->CurrentValue);
            $this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

            // d_description_02
            $this->d_description_02->setupEditAttributes();
            $this->d_description_02->EditValue = HtmlEncode($this->d_description_02->CurrentValue);
            $this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

            // publish
            $this->publish->setupEditAttributes();
            $this->publish->EditValue = $this->publish->options(true);
            $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());

            // keywords
            $this->keywords->setupEditAttributes();
            $this->keywords->EditValue = HtmlEncode($this->keywords->CurrentValue);
            $this->keywords->PlaceHolder = RemoveHtml($this->keywords->caption());

            // operator
            $this->operator->setupEditAttributes();
            $this->operator->CurrentValue = CurrentUserID();

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->CurrentValue = FormatDateTime(CurrentDateTime(), $this->datetime->formatPattern());

            // main_image
            $this->main_image->setupEditAttributes();
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->ImageWidth = 0;
                $this->main_image->ImageHeight = 40;
                $this->main_image->ImageAlt = $this->main_image->alt();
                $this->main_image->ImageCssClass = "ew-image";
                $this->main_image->EditValue = $this->main_image->Upload->DbValue;
            } else {
                $this->main_image->EditValue = "";
            }
            if (!EmptyValue($this->main_image->CurrentValue)) {
                $this->main_image->Upload->FileName = $this->main_image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->main_image->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->main_image);
            }

            // top_view
            $this->top_view->setupEditAttributes();
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->ImageWidth = 0;
                $this->top_view->ImageHeight = 40;
                $this->top_view->ImageAlt = $this->top_view->alt();
                $this->top_view->ImageCssClass = "ew-image";
                $this->top_view->EditValue = $this->top_view->Upload->DbValue;
            } else {
                $this->top_view->EditValue = "";
            }
            if (!EmptyValue($this->top_view->CurrentValue)) {
                $this->top_view->Upload->FileName = $this->top_view->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->top_view->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->top_view);
            }

            // front_view
            $this->front_view->setupEditAttributes();
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->ImageWidth = 0;
                $this->front_view->ImageHeight = 40;
                $this->front_view->ImageAlt = $this->front_view->alt();
                $this->front_view->ImageCssClass = "ew-image";
                $this->front_view->EditValue = $this->front_view->Upload->DbValue;
            } else {
                $this->front_view->EditValue = "";
            }
            if (!EmptyValue($this->front_view->CurrentValue)) {
                $this->front_view->Upload->FileName = $this->front_view->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->front_view->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->front_view);
            }

            // corner_view
            $this->corner_view->setupEditAttributes();
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->ImageWidth = 0;
                $this->corner_view->ImageHeight = 40;
                $this->corner_view->ImageAlt = $this->corner_view->alt();
                $this->corner_view->ImageCssClass = "ew-image";
                $this->corner_view->EditValue = $this->corner_view->Upload->DbValue;
            } else {
                $this->corner_view->EditValue = "";
            }
            if (!EmptyValue($this->corner_view->CurrentValue)) {
                $this->corner_view->Upload->FileName = $this->corner_view->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->corner_view->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->corner_view);
            }

            // back_view
            $this->back_view->setupEditAttributes();
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->ImageWidth = 0;
                $this->back_view->ImageHeight = 40;
                $this->back_view->ImageAlt = $this->back_view->alt();
                $this->back_view->ImageCssClass = "ew-image";
                $this->back_view->EditValue = $this->back_view->Upload->DbValue;
            } else {
                $this->back_view->EditValue = "";
            }
            if (!EmptyValue($this->back_view->CurrentValue)) {
                $this->back_view->Upload->FileName = $this->back_view->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->back_view->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->back_view);
            }

            // color_options
            $this->color_options->setupEditAttributes();
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->ImageWidth = 0;
                $this->color_options->ImageHeight = 40;
                $this->color_options->ImageAlt = $this->color_options->alt();
                $this->color_options->ImageCssClass = "ew-image";
                $this->color_options->EditValue = $this->color_options->Upload->DbValue;
            } else {
                $this->color_options->EditValue = "";
            }
            if (!EmptyValue($this->color_options->CurrentValue)) {
                $this->color_options->Upload->FileName = $this->color_options->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->color_options->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->color_options);
            }

            // other_options
            $this->other_options->setupEditAttributes();
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->ImageWidth = 0;
                $this->other_options->ImageHeight = 40;
                $this->other_options->ImageAlt = $this->other_options->alt();
                $this->other_options->ImageCssClass = "ew-image";
                $this->other_options->EditValue = $this->other_options->Upload->DbValue;
            } else {
                $this->other_options->EditValue = "";
            }
            if (!EmptyValue($this->other_options->CurrentValue)) {
                $this->other_options->Upload->FileName = $this->other_options->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->other_options->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->other_options);
            }

            // group_image
            $this->group_image->setupEditAttributes();
            $this->group_image->UploadPath = $this->group_image->getUploadPath(); // PHP
            if (!EmptyValue($this->group_image->Upload->DbValue)) {
                $this->group_image->EditValue = $this->group_image->Upload->DbValue;
            } else {
                $this->group_image->EditValue = "";
            }
            if (!EmptyValue($this->group_image->CurrentValue)) {
                $this->group_image->Upload->FileName = $this->group_image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->group_image->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->group_image);
            }

            // video_url
            $this->video_url->setupEditAttributes();
            if (!$this->video_url->Raw) {
                $this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
            }
            $this->video_url->EditValue = HtmlEncode($this->video_url->CurrentValue);
            $this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

            // image
            $this->image->setupEditAttributes();
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->ImageWidth = 0;
                $this->image->ImageHeight = 50;
                $this->image->ImageAlt = $this->image->alt();
                $this->image->ImageCssClass = "ew-image";
                $this->image->EditValue = $this->image->Upload->DbValue;
            } else {
                $this->image->EditValue = "";
            }
            if (!EmptyValue($this->image->CurrentValue)) {
                $this->image->Upload->FileName = $this->image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->image->Upload->DbValue = null;
            }
            if ($this->isShow()) {
                RenderUploadField($this->image);
            }

            // in
            $this->in->setupEditAttributes();
            $this->in->EditValue = $this->in->CurrentValue;
            $this->in->PlaceHolder = RemoveHtml($this->in->caption());
            if (strval($this->in->EditValue) != "" && is_numeric($this->in->EditValue)) {
                $this->in->EditValue = FormatNumber($this->in->EditValue, null);
            }

            // out
            $this->out->setupEditAttributes();
            $this->out->EditValue = $this->out->CurrentValue;
            $this->out->PlaceHolder = RemoveHtml($this->out->caption());
            if (strval($this->out->EditValue) != "" && is_numeric($this->out->EditValue)) {
                $this->out->EditValue = FormatNumber($this->out->EditValue, null);
            }

            // required
            $this->required->setupEditAttributes();
            $this->required->EditValue = $this->required->CurrentValue;
            $this->required->PlaceHolder = RemoveHtml($this->required->caption());
            if (strval($this->required->EditValue) != "" && is_numeric($this->required->EditValue)) {
                $this->required->EditValue = FormatNumber($this->required->EditValue, null);
            }

            // blocked
            $this->blocked->setupEditAttributes();
            $this->blocked->EditValue = $this->blocked->CurrentValue;
            $this->blocked->PlaceHolder = RemoveHtml($this->blocked->caption());
            if (strval($this->blocked->EditValue) != "" && is_numeric($this->blocked->EditValue)) {
                $this->blocked->EditValue = FormatNumber($this->blocked->EditValue, null);
            }

            // ordered
            $this->ordered->setupEditAttributes();
            $this->ordered->EditValue = $this->ordered->CurrentValue;
            $this->ordered->PlaceHolder = RemoveHtml($this->ordered->caption());
            if (strval($this->ordered->EditValue) != "" && is_numeric($this->ordered->EditValue)) {
                $this->ordered->EditValue = FormatNumber($this->ordered->EditValue, null);
            }

            // supplier
            $this->supplier->setupEditAttributes();
            $this->supplier->EditValue = $this->supplier->CurrentValue;
            $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());
            if (strval($this->supplier->EditValue) != "" && is_numeric($this->supplier->EditValue)) {
                $this->supplier->EditValue = $this->supplier->EditValue;
            }

            // country
            $this->country->setupEditAttributes();
            $this->country->EditValue = $this->country->CurrentValue;
            $this->country->PlaceHolder = RemoveHtml($this->country->caption());
            if (strval($this->country->EditValue) != "" && is_numeric($this->country->EditValue)) {
                $this->country->EditValue = $this->country->EditValue;
            }

            // minimum_stock
            $this->minimum_stock->setupEditAttributes();
            $this->minimum_stock->EditValue = $this->minimum_stock->CurrentValue;
            $this->minimum_stock->PlaceHolder = RemoveHtml($this->minimum_stock->caption());
            if (strval($this->minimum_stock->EditValue) != "" && is_numeric($this->minimum_stock->EditValue)) {
                $this->minimum_stock->EditValue = FormatNumber($this->minimum_stock->EditValue, null);
            }

            // Add refer script

            // oid
            $this->oid->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // grp
            $this->grp->HrefValue = "";

            // s_grp
            $this->s_grp->HrefValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }

            // product_type
            $this->product_type->HrefValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // product_code_type
            $this->product_code_type->HrefValue = "";

            // product_code
            $this->product_code->HrefValue = "";

            // print_name
            $this->print_name->HrefValue = "";

            // gcode
            $this->gcode->HrefValue = "";

            // code
            $this->code->HrefValue = "";

            // product_id
            $this->product_id->HrefValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";

            // set_ref
            $this->set_ref->HrefValue = "";

            // v_00
            $this->v_00->HrefValue = "";

            // v_01
            $this->v_01->HrefValue = "";

            // v_02
            $this->v_02->HrefValue = "";

            // v_03
            $this->v_03->HrefValue = "";

            // v_04
            $this->v_04->HrefValue = "";

            // v_05
            $this->v_05->HrefValue = "";

            // v_06
            $this->v_06->HrefValue = "";

            // v_07
            $this->v_07->HrefValue = "";

            // v_08
            $this->v_08->HrefValue = "";

            // v_09
            $this->v_09->HrefValue = "";

            // v_10
            $this->v_10->HrefValue = "";

            // cbm
            $this->cbm->HrefValue = "";

            // sqm
            $this->sqm->HrefValue = "";

            // shape
            $this->shape->HrefValue = "";

            // q_sku
            $this->q_sku->HrefValue = "";

            // b_01
            $this->b_01->HrefValue = "";

            // b_02
            $this->b_02->HrefValue = "";

            // b_03
            $this->b_03->HrefValue = "";

            // b_04
            $this->b_04->HrefValue = "";

            // b_05
            $this->b_05->HrefValue = "";

            // b_06
            $this->b_06->HrefValue = "";

            // b_07
            $this->b_07->HrefValue = "";

            // b_08
            $this->b_08->HrefValue = "";

            // b_09
            $this->b_09->HrefValue = "";

            // b_10
            $this->b_10->HrefValue = "";

            // b_11
            $this->b_11->HrefValue = "";

            // b_12
            $this->b_12->HrefValue = "";

            // b_13
            $this->b_13->HrefValue = "";

            // b_14
            $this->b_14->HrefValue = "";

            // b_15
            $this->b_15->HrefValue = "";

            // t_01
            $this->t_01->HrefValue = "";

            // t_02
            $this->t_02->HrefValue = "";

            // t_03
            $this->t_03->HrefValue = "";

            // t_04
            $this->t_04->HrefValue = "";

            // t_05
            $this->t_05->HrefValue = "";

            // t_06
            $this->t_06->HrefValue = "";

            // t_07
            $this->t_07->HrefValue = "";

            // t_08
            $this->t_08->HrefValue = "";

            // t_09
            $this->t_09->HrefValue = "";

            // t_10
            $this->t_10->HrefValue = "";

            // t_11
            $this->t_11->HrefValue = "";

            // t_12
            $this->t_12->HrefValue = "";

            // t_13
            $this->t_13->HrefValue = "";

            // t_14
            $this->t_14->HrefValue = "";

            // t_15
            $this->t_15->HrefValue = "";

            // last_price
            $this->last_price->HrefValue = "";

            // currency
            $this->currency->HrefValue = "";

            // hsn
            $this->hsn->HrefValue = "";

            // composition
            $this->composition->HrefValue = "";

            // category
            $this->category->HrefValue = "";

            // moq
            $this->moq->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // d_head_01
            $this->d_head_01->HrefValue = "";

            // d_description_01
            $this->d_description_01->HrefValue = "";

            // d_head_02
            $this->d_head_02->HrefValue = "";

            // d_description_02
            $this->d_description_02->HrefValue = "";

            // publish
            $this->publish->HrefValue = "";

            // keywords
            $this->keywords->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->htmlDecode($this->main_image->Upload->DbValue)); // Add prefix/suffix
                $this->main_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
                }
            } else {
                $this->main_image->HrefValue = "";
            }
            $this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;

            // top_view
            $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
            if (!EmptyValue($this->top_view->Upload->DbValue)) {
                $this->top_view->HrefValue = "%u"; // Add prefix/suffix
                $this->top_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
                }
            } else {
                $this->top_view->HrefValue = "";
            }
            $this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;

            // front_view
            $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
            if (!EmptyValue($this->front_view->Upload->DbValue)) {
                $this->front_view->HrefValue = "%u"; // Add prefix/suffix
                $this->front_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
                }
            } else {
                $this->front_view->HrefValue = "";
            }
            $this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;

            // corner_view
            $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
            if (!EmptyValue($this->corner_view->Upload->DbValue)) {
                $this->corner_view->HrefValue = "%u"; // Add prefix/suffix
                $this->corner_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
                }
            } else {
                $this->corner_view->HrefValue = "";
            }
            $this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;

            // back_view
            $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
            if (!EmptyValue($this->back_view->Upload->DbValue)) {
                $this->back_view->HrefValue = "%u"; // Add prefix/suffix
                $this->back_view->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
                }
            } else {
                $this->back_view->HrefValue = "";
            }
            $this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;

            // color_options
            $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
            if (!EmptyValue($this->color_options->Upload->DbValue)) {
                $this->color_options->HrefValue = "%u"; // Add prefix/suffix
                $this->color_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
                }
            } else {
                $this->color_options->HrefValue = "";
            }
            $this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;

            // other_options
            $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
            if (!EmptyValue($this->other_options->Upload->DbValue)) {
                $this->other_options->HrefValue = "%u"; // Add prefix/suffix
                $this->other_options->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
                }
            } else {
                $this->other_options->HrefValue = "";
            }
            $this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;

            // group_image
            $this->group_image->HrefValue = "";
            $this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;

            // video_url
            $this->video_url->HrefValue = "";

            // image
            $this->image->UploadPath = $this->image->getUploadPath(); // PHP
            if (!EmptyValue($this->image->Upload->DbValue)) {
                $this->image->HrefValue = "%u"; // Add prefix/suffix
                $this->image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
                }
            } else {
                $this->image->HrefValue = "";
            }
            $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;

            // in
            $this->in->HrefValue = "";

            // out
            $this->out->HrefValue = "";

            // required
            $this->required->HrefValue = "";

            // blocked
            $this->blocked->HrefValue = "";

            // ordered
            $this->ordered->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }

            // country
            if (!EmptyValue($this->country->CurrentValue)) {
                $this->country->HrefValue = $this->country->getLinkPrefix() . $this->country->CurrentValue; // Add prefix/suffix
                $this->country->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->country->HrefValue = FullUrl($this->country->HrefValue, "href");
                }
            } else {
                $this->country->HrefValue = "";
            }

            // minimum_stock
            $this->minimum_stock->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->oid->Visible && $this->oid->Required) {
                if (!$this->oid->IsDetailKey && EmptyValue($this->oid->FormValue)) {
                    $this->oid->addErrorMessage(str_replace("%s", $this->oid->caption(), $this->oid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->oid->FormValue)) {
                $this->oid->addErrorMessage($this->oid->getErrorMessage(false));
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if ($this->company_id->FormValue == "") {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->grp->Visible && $this->grp->Required) {
                if (!$this->grp->IsDetailKey && EmptyValue($this->grp->FormValue)) {
                    $this->grp->addErrorMessage(str_replace("%s", $this->grp->caption(), $this->grp->RequiredErrorMessage));
                }
            }
            if ($this->s_grp->Visible && $this->s_grp->Required) {
                if (!$this->s_grp->IsDetailKey && EmptyValue($this->s_grp->FormValue)) {
                    $this->s_grp->addErrorMessage(str_replace("%s", $this->s_grp->caption(), $this->s_grp->RequiredErrorMessage));
                }
            }
            if ($this->product->Visible && $this->product->Required) {
                if (!$this->product->IsDetailKey && EmptyValue($this->product->FormValue)) {
                    $this->product->addErrorMessage(str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
                }
            }
            if ($this->product_type->Visible && $this->product_type->Required) {
                if (!$this->product_type->IsDetailKey && EmptyValue($this->product_type->FormValue)) {
                    $this->product_type->addErrorMessage(str_replace("%s", $this->product_type->caption(), $this->product_type->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->product_code_type->Visible && $this->product_code_type->Required) {
                if (!$this->product_code_type->IsDetailKey && EmptyValue($this->product_code_type->FormValue)) {
                    $this->product_code_type->addErrorMessage(str_replace("%s", $this->product_code_type->caption(), $this->product_code_type->RequiredErrorMessage));
                }
            }
            if ($this->product_code->Visible && $this->product_code->Required) {
                if (!$this->product_code->IsDetailKey && EmptyValue($this->product_code->FormValue)) {
                    $this->product_code->addErrorMessage(str_replace("%s", $this->product_code->caption(), $this->product_code->RequiredErrorMessage));
                }
            }
            if ($this->print_name->Visible && $this->print_name->Required) {
                if (!$this->print_name->IsDetailKey && EmptyValue($this->print_name->FormValue)) {
                    $this->print_name->addErrorMessage(str_replace("%s", $this->print_name->caption(), $this->print_name->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->print_name->FormValue)) {
                $this->print_name->addErrorMessage($this->print_name->getErrorMessage(false));
            }
            if ($this->gcode->Visible && $this->gcode->Required) {
                if (!$this->gcode->IsDetailKey && EmptyValue($this->gcode->FormValue)) {
                    $this->gcode->addErrorMessage(str_replace("%s", $this->gcode->caption(), $this->gcode->RequiredErrorMessage));
                }
            }
            if ($this->code->Visible && $this->code->Required) {
                if (!$this->code->IsDetailKey && EmptyValue($this->code->FormValue)) {
                    $this->code->addErrorMessage(str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
                }
            }
            if ($this->product_id->Visible && $this->product_id->Required) {
                if (!$this->product_id->IsDetailKey && EmptyValue($this->product_id->FormValue)) {
                    $this->product_id->addErrorMessage(str_replace("%s", $this->product_id->caption(), $this->product_id->RequiredErrorMessage));
                }
            }
            if ($this->batch_no->Visible && $this->batch_no->Required) {
                if (!$this->batch_no->IsDetailKey && EmptyValue($this->batch_no->FormValue)) {
                    $this->batch_no->addErrorMessage(str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
                }
            }
            if ($this->set_ref->Visible && $this->set_ref->Required) {
                if ($this->set_ref->FormValue == "") {
                    $this->set_ref->addErrorMessage(str_replace("%s", $this->set_ref->caption(), $this->set_ref->RequiredErrorMessage));
                }
            }
            if ($this->v_00->Visible && $this->v_00->Required) {
                if (!$this->v_00->IsDetailKey && EmptyValue($this->v_00->FormValue)) {
                    $this->v_00->addErrorMessage(str_replace("%s", $this->v_00->caption(), $this->v_00->RequiredErrorMessage));
                }
            }
            if ($this->v_01->Visible && $this->v_01->Required) {
                if (!$this->v_01->IsDetailKey && EmptyValue($this->v_01->FormValue)) {
                    $this->v_01->addErrorMessage(str_replace("%s", $this->v_01->caption(), $this->v_01->RequiredErrorMessage));
                }
            }
            if ($this->v_02->Visible && $this->v_02->Required) {
                if (!$this->v_02->IsDetailKey && EmptyValue($this->v_02->FormValue)) {
                    $this->v_02->addErrorMessage(str_replace("%s", $this->v_02->caption(), $this->v_02->RequiredErrorMessage));
                }
            }
            if ($this->v_03->Visible && $this->v_03->Required) {
                if (!$this->v_03->IsDetailKey && EmptyValue($this->v_03->FormValue)) {
                    $this->v_03->addErrorMessage(str_replace("%s", $this->v_03->caption(), $this->v_03->RequiredErrorMessage));
                }
            }
            if ($this->v_04->Visible && $this->v_04->Required) {
                if (!$this->v_04->IsDetailKey && EmptyValue($this->v_04->FormValue)) {
                    $this->v_04->addErrorMessage(str_replace("%s", $this->v_04->caption(), $this->v_04->RequiredErrorMessage));
                }
            }
            if ($this->v_05->Visible && $this->v_05->Required) {
                if (!$this->v_05->IsDetailKey && EmptyValue($this->v_05->FormValue)) {
                    $this->v_05->addErrorMessage(str_replace("%s", $this->v_05->caption(), $this->v_05->RequiredErrorMessage));
                }
            }
            if ($this->v_06->Visible && $this->v_06->Required) {
                if (!$this->v_06->IsDetailKey && EmptyValue($this->v_06->FormValue)) {
                    $this->v_06->addErrorMessage(str_replace("%s", $this->v_06->caption(), $this->v_06->RequiredErrorMessage));
                }
            }
            if ($this->v_07->Visible && $this->v_07->Required) {
                if (!$this->v_07->IsDetailKey && EmptyValue($this->v_07->FormValue)) {
                    $this->v_07->addErrorMessage(str_replace("%s", $this->v_07->caption(), $this->v_07->RequiredErrorMessage));
                }
            }
            if ($this->v_08->Visible && $this->v_08->Required) {
                if (!$this->v_08->IsDetailKey && EmptyValue($this->v_08->FormValue)) {
                    $this->v_08->addErrorMessage(str_replace("%s", $this->v_08->caption(), $this->v_08->RequiredErrorMessage));
                }
            }
            if ($this->v_09->Visible && $this->v_09->Required) {
                if (!$this->v_09->IsDetailKey && EmptyValue($this->v_09->FormValue)) {
                    $this->v_09->addErrorMessage(str_replace("%s", $this->v_09->caption(), $this->v_09->RequiredErrorMessage));
                }
            }
            if ($this->v_10->Visible && $this->v_10->Required) {
                if (!$this->v_10->IsDetailKey && EmptyValue($this->v_10->FormValue)) {
                    $this->v_10->addErrorMessage(str_replace("%s", $this->v_10->caption(), $this->v_10->RequiredErrorMessage));
                }
            }
            if ($this->cbm->Visible && $this->cbm->Required) {
                if (!$this->cbm->IsDetailKey && EmptyValue($this->cbm->FormValue)) {
                    $this->cbm->addErrorMessage(str_replace("%s", $this->cbm->caption(), $this->cbm->RequiredErrorMessage));
                }
            }
            if ($this->sqm->Visible && $this->sqm->Required) {
                if (!$this->sqm->IsDetailKey && EmptyValue($this->sqm->FormValue)) {
                    $this->sqm->addErrorMessage(str_replace("%s", $this->sqm->caption(), $this->sqm->RequiredErrorMessage));
                }
            }
            if ($this->shape->Visible && $this->shape->Required) {
                if ($this->shape->FormValue == "") {
                    $this->shape->addErrorMessage(str_replace("%s", $this->shape->caption(), $this->shape->RequiredErrorMessage));
                }
            }
            if ($this->q_sku->Visible && $this->q_sku->Required) {
                if (!$this->q_sku->IsDetailKey && EmptyValue($this->q_sku->FormValue)) {
                    $this->q_sku->addErrorMessage(str_replace("%s", $this->q_sku->caption(), $this->q_sku->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->q_sku->FormValue)) {
                $this->q_sku->addErrorMessage($this->q_sku->getErrorMessage(false));
            }
            if ($this->b_01->Visible && $this->b_01->Required) {
                if (!$this->b_01->IsDetailKey && EmptyValue($this->b_01->FormValue)) {
                    $this->b_01->addErrorMessage(str_replace("%s", $this->b_01->caption(), $this->b_01->RequiredErrorMessage));
                }
            }
            if ($this->b_02->Visible && $this->b_02->Required) {
                if (!$this->b_02->IsDetailKey && EmptyValue($this->b_02->FormValue)) {
                    $this->b_02->addErrorMessage(str_replace("%s", $this->b_02->caption(), $this->b_02->RequiredErrorMessage));
                }
            }
            if ($this->b_03->Visible && $this->b_03->Required) {
                if ($this->b_03->FormValue == "") {
                    $this->b_03->addErrorMessage(str_replace("%s", $this->b_03->caption(), $this->b_03->RequiredErrorMessage));
                }
            }
            if ($this->b_04->Visible && $this->b_04->Required) {
                if ($this->b_04->FormValue == "") {
                    $this->b_04->addErrorMessage(str_replace("%s", $this->b_04->caption(), $this->b_04->RequiredErrorMessage));
                }
            }
            if ($this->b_05->Visible && $this->b_05->Required) {
                if ($this->b_05->FormValue == "") {
                    $this->b_05->addErrorMessage(str_replace("%s", $this->b_05->caption(), $this->b_05->RequiredErrorMessage));
                }
            }
            if ($this->b_06->Visible && $this->b_06->Required) {
                if ($this->b_06->FormValue == "") {
                    $this->b_06->addErrorMessage(str_replace("%s", $this->b_06->caption(), $this->b_06->RequiredErrorMessage));
                }
            }
            if ($this->b_07->Visible && $this->b_07->Required) {
                if ($this->b_07->FormValue == "") {
                    $this->b_07->addErrorMessage(str_replace("%s", $this->b_07->caption(), $this->b_07->RequiredErrorMessage));
                }
            }
            if ($this->b_08->Visible && $this->b_08->Required) {
                if ($this->b_08->FormValue == "") {
                    $this->b_08->addErrorMessage(str_replace("%s", $this->b_08->caption(), $this->b_08->RequiredErrorMessage));
                }
            }
            if ($this->b_09->Visible && $this->b_09->Required) {
                if ($this->b_09->FormValue == "") {
                    $this->b_09->addErrorMessage(str_replace("%s", $this->b_09->caption(), $this->b_09->RequiredErrorMessage));
                }
            }
            if ($this->b_10->Visible && $this->b_10->Required) {
                if ($this->b_10->FormValue == "") {
                    $this->b_10->addErrorMessage(str_replace("%s", $this->b_10->caption(), $this->b_10->RequiredErrorMessage));
                }
            }
            if ($this->b_11->Visible && $this->b_11->Required) {
                if (!$this->b_11->IsDetailKey && EmptyValue($this->b_11->FormValue)) {
                    $this->b_11->addErrorMessage(str_replace("%s", $this->b_11->caption(), $this->b_11->RequiredErrorMessage));
                }
            }
            if ($this->b_12->Visible && $this->b_12->Required) {
                if (!$this->b_12->IsDetailKey && EmptyValue($this->b_12->FormValue)) {
                    $this->b_12->addErrorMessage(str_replace("%s", $this->b_12->caption(), $this->b_12->RequiredErrorMessage));
                }
            }
            if ($this->b_13->Visible && $this->b_13->Required) {
                if (!$this->b_13->IsDetailKey && EmptyValue($this->b_13->FormValue)) {
                    $this->b_13->addErrorMessage(str_replace("%s", $this->b_13->caption(), $this->b_13->RequiredErrorMessage));
                }
            }
            if ($this->b_14->Visible && $this->b_14->Required) {
                if (!$this->b_14->IsDetailKey && EmptyValue($this->b_14->FormValue)) {
                    $this->b_14->addErrorMessage(str_replace("%s", $this->b_14->caption(), $this->b_14->RequiredErrorMessage));
                }
            }
            if ($this->b_15->Visible && $this->b_15->Required) {
                if (!$this->b_15->IsDetailKey && EmptyValue($this->b_15->FormValue)) {
                    $this->b_15->addErrorMessage(str_replace("%s", $this->b_15->caption(), $this->b_15->RequiredErrorMessage));
                }
            }
            if ($this->t_01->Visible && $this->t_01->Required) {
                if (!$this->t_01->IsDetailKey && EmptyValue($this->t_01->FormValue)) {
                    $this->t_01->addErrorMessage(str_replace("%s", $this->t_01->caption(), $this->t_01->RequiredErrorMessage));
                }
            }
            if ($this->t_02->Visible && $this->t_02->Required) {
                if (!$this->t_02->IsDetailKey && EmptyValue($this->t_02->FormValue)) {
                    $this->t_02->addErrorMessage(str_replace("%s", $this->t_02->caption(), $this->t_02->RequiredErrorMessage));
                }
            }
            if ($this->t_03->Visible && $this->t_03->Required) {
                if ($this->t_03->FormValue == "") {
                    $this->t_03->addErrorMessage(str_replace("%s", $this->t_03->caption(), $this->t_03->RequiredErrorMessage));
                }
            }
            if ($this->t_04->Visible && $this->t_04->Required) {
                if ($this->t_04->FormValue == "") {
                    $this->t_04->addErrorMessage(str_replace("%s", $this->t_04->caption(), $this->t_04->RequiredErrorMessage));
                }
            }
            if ($this->t_05->Visible && $this->t_05->Required) {
                if ($this->t_05->FormValue == "") {
                    $this->t_05->addErrorMessage(str_replace("%s", $this->t_05->caption(), $this->t_05->RequiredErrorMessage));
                }
            }
            if ($this->t_06->Visible && $this->t_06->Required) {
                if ($this->t_06->FormValue == "") {
                    $this->t_06->addErrorMessage(str_replace("%s", $this->t_06->caption(), $this->t_06->RequiredErrorMessage));
                }
            }
            if ($this->t_07->Visible && $this->t_07->Required) {
                if ($this->t_07->FormValue == "") {
                    $this->t_07->addErrorMessage(str_replace("%s", $this->t_07->caption(), $this->t_07->RequiredErrorMessage));
                }
            }
            if ($this->t_08->Visible && $this->t_08->Required) {
                if ($this->t_08->FormValue == "") {
                    $this->t_08->addErrorMessage(str_replace("%s", $this->t_08->caption(), $this->t_08->RequiredErrorMessage));
                }
            }
            if ($this->t_09->Visible && $this->t_09->Required) {
                if ($this->t_09->FormValue == "") {
                    $this->t_09->addErrorMessage(str_replace("%s", $this->t_09->caption(), $this->t_09->RequiredErrorMessage));
                }
            }
            if ($this->t_10->Visible && $this->t_10->Required) {
                if ($this->t_10->FormValue == "") {
                    $this->t_10->addErrorMessage(str_replace("%s", $this->t_10->caption(), $this->t_10->RequiredErrorMessage));
                }
            }
            if ($this->t_11->Visible && $this->t_11->Required) {
                if (!$this->t_11->IsDetailKey && EmptyValue($this->t_11->FormValue)) {
                    $this->t_11->addErrorMessage(str_replace("%s", $this->t_11->caption(), $this->t_11->RequiredErrorMessage));
                }
            }
            if ($this->t_12->Visible && $this->t_12->Required) {
                if (!$this->t_12->IsDetailKey && EmptyValue($this->t_12->FormValue)) {
                    $this->t_12->addErrorMessage(str_replace("%s", $this->t_12->caption(), $this->t_12->RequiredErrorMessage));
                }
            }
            if ($this->t_13->Visible && $this->t_13->Required) {
                if (!$this->t_13->IsDetailKey && EmptyValue($this->t_13->FormValue)) {
                    $this->t_13->addErrorMessage(str_replace("%s", $this->t_13->caption(), $this->t_13->RequiredErrorMessage));
                }
            }
            if ($this->t_14->Visible && $this->t_14->Required) {
                if (!$this->t_14->IsDetailKey && EmptyValue($this->t_14->FormValue)) {
                    $this->t_14->addErrorMessage(str_replace("%s", $this->t_14->caption(), $this->t_14->RequiredErrorMessage));
                }
            }
            if ($this->t_15->Visible && $this->t_15->Required) {
                if (!$this->t_15->IsDetailKey && EmptyValue($this->t_15->FormValue)) {
                    $this->t_15->addErrorMessage(str_replace("%s", $this->t_15->caption(), $this->t_15->RequiredErrorMessage));
                }
            }
            if ($this->last_price->Visible && $this->last_price->Required) {
                if (!$this->last_price->IsDetailKey && EmptyValue($this->last_price->FormValue)) {
                    $this->last_price->addErrorMessage(str_replace("%s", $this->last_price->caption(), $this->last_price->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->last_price->FormValue)) {
                $this->last_price->addErrorMessage($this->last_price->getErrorMessage(false));
            }
            if ($this->currency->Visible && $this->currency->Required) {
                if (!$this->currency->IsDetailKey && EmptyValue($this->currency->FormValue)) {
                    $this->currency->addErrorMessage(str_replace("%s", $this->currency->caption(), $this->currency->RequiredErrorMessage));
                }
            }
            if ($this->hsn->Visible && $this->hsn->Required) {
                if (!$this->hsn->IsDetailKey && EmptyValue($this->hsn->FormValue)) {
                    $this->hsn->addErrorMessage(str_replace("%s", $this->hsn->caption(), $this->hsn->RequiredErrorMessage));
                }
            }
            if ($this->composition->Visible && $this->composition->Required) {
                if (!$this->composition->IsDetailKey && EmptyValue($this->composition->FormValue)) {
                    $this->composition->addErrorMessage(str_replace("%s", $this->composition->caption(), $this->composition->RequiredErrorMessage));
                }
            }
            if ($this->category->Visible && $this->category->Required) {
                if (!$this->category->IsDetailKey && EmptyValue($this->category->FormValue)) {
                    $this->category->addErrorMessage(str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
                }
            }
            if ($this->moq->Visible && $this->moq->Required) {
                if (!$this->moq->IsDetailKey && EmptyValue($this->moq->FormValue)) {
                    $this->moq->addErrorMessage(str_replace("%s", $this->moq->caption(), $this->moq->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->moq->FormValue)) {
                $this->moq->addErrorMessage($this->moq->getErrorMessage(false));
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->d_head_01->Visible && $this->d_head_01->Required) {
                if (!$this->d_head_01->IsDetailKey && EmptyValue($this->d_head_01->FormValue)) {
                    $this->d_head_01->addErrorMessage(str_replace("%s", $this->d_head_01->caption(), $this->d_head_01->RequiredErrorMessage));
                }
            }
            if ($this->d_description_01->Visible && $this->d_description_01->Required) {
                if (!$this->d_description_01->IsDetailKey && EmptyValue($this->d_description_01->FormValue)) {
                    $this->d_description_01->addErrorMessage(str_replace("%s", $this->d_description_01->caption(), $this->d_description_01->RequiredErrorMessage));
                }
            }
            if ($this->d_head_02->Visible && $this->d_head_02->Required) {
                if (!$this->d_head_02->IsDetailKey && EmptyValue($this->d_head_02->FormValue)) {
                    $this->d_head_02->addErrorMessage(str_replace("%s", $this->d_head_02->caption(), $this->d_head_02->RequiredErrorMessage));
                }
            }
            if ($this->d_description_02->Visible && $this->d_description_02->Required) {
                if (!$this->d_description_02->IsDetailKey && EmptyValue($this->d_description_02->FormValue)) {
                    $this->d_description_02->addErrorMessage(str_replace("%s", $this->d_description_02->caption(), $this->d_description_02->RequiredErrorMessage));
                }
            }
            if ($this->publish->Visible && $this->publish->Required) {
                if (!$this->publish->IsDetailKey && EmptyValue($this->publish->FormValue)) {
                    $this->publish->addErrorMessage(str_replace("%s", $this->publish->caption(), $this->publish->RequiredErrorMessage));
                }
            }
            if ($this->keywords->Visible && $this->keywords->Required) {
                if (!$this->keywords->IsDetailKey && EmptyValue($this->keywords->FormValue)) {
                    $this->keywords->addErrorMessage(str_replace("%s", $this->keywords->caption(), $this->keywords->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->main_image->Visible && $this->main_image->Required) {
                if ($this->main_image->Upload->FileName == "" && !$this->main_image->Upload->KeepFile) {
                    $this->main_image->addErrorMessage(str_replace("%s", $this->main_image->caption(), $this->main_image->RequiredErrorMessage));
                }
            }
            if ($this->top_view->Visible && $this->top_view->Required) {
                if ($this->top_view->Upload->FileName == "" && !$this->top_view->Upload->KeepFile) {
                    $this->top_view->addErrorMessage(str_replace("%s", $this->top_view->caption(), $this->top_view->RequiredErrorMessage));
                }
            }
            if ($this->front_view->Visible && $this->front_view->Required) {
                if ($this->front_view->Upload->FileName == "" && !$this->front_view->Upload->KeepFile) {
                    $this->front_view->addErrorMessage(str_replace("%s", $this->front_view->caption(), $this->front_view->RequiredErrorMessage));
                }
            }
            if ($this->corner_view->Visible && $this->corner_view->Required) {
                if ($this->corner_view->Upload->FileName == "" && !$this->corner_view->Upload->KeepFile) {
                    $this->corner_view->addErrorMessage(str_replace("%s", $this->corner_view->caption(), $this->corner_view->RequiredErrorMessage));
                }
            }
            if ($this->back_view->Visible && $this->back_view->Required) {
                if ($this->back_view->Upload->FileName == "" && !$this->back_view->Upload->KeepFile) {
                    $this->back_view->addErrorMessage(str_replace("%s", $this->back_view->caption(), $this->back_view->RequiredErrorMessage));
                }
            }
            if ($this->color_options->Visible && $this->color_options->Required) {
                if ($this->color_options->Upload->FileName == "" && !$this->color_options->Upload->KeepFile) {
                    $this->color_options->addErrorMessage(str_replace("%s", $this->color_options->caption(), $this->color_options->RequiredErrorMessage));
                }
            }
            if ($this->other_options->Visible && $this->other_options->Required) {
                if ($this->other_options->Upload->FileName == "" && !$this->other_options->Upload->KeepFile) {
                    $this->other_options->addErrorMessage(str_replace("%s", $this->other_options->caption(), $this->other_options->RequiredErrorMessage));
                }
            }
            if ($this->group_image->Visible && $this->group_image->Required) {
                if ($this->group_image->Upload->FileName == "" && !$this->group_image->Upload->KeepFile) {
                    $this->group_image->addErrorMessage(str_replace("%s", $this->group_image->caption(), $this->group_image->RequiredErrorMessage));
                }
            }
            if ($this->video_url->Visible && $this->video_url->Required) {
                if (!$this->video_url->IsDetailKey && EmptyValue($this->video_url->FormValue)) {
                    $this->video_url->addErrorMessage(str_replace("%s", $this->video_url->caption(), $this->video_url->RequiredErrorMessage));
                }
            }
            if ($this->image->Visible && $this->image->Required) {
                if ($this->image->Upload->FileName == "" && !$this->image->Upload->KeepFile) {
                    $this->image->addErrorMessage(str_replace("%s", $this->image->caption(), $this->image->RequiredErrorMessage));
                }
            }
            if ($this->in->Visible && $this->in->Required) {
                if (!$this->in->IsDetailKey && EmptyValue($this->in->FormValue)) {
                    $this->in->addErrorMessage(str_replace("%s", $this->in->caption(), $this->in->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->in->FormValue)) {
                $this->in->addErrorMessage($this->in->getErrorMessage(false));
            }
            if ($this->out->Visible && $this->out->Required) {
                if (!$this->out->IsDetailKey && EmptyValue($this->out->FormValue)) {
                    $this->out->addErrorMessage(str_replace("%s", $this->out->caption(), $this->out->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->out->FormValue)) {
                $this->out->addErrorMessage($this->out->getErrorMessage(false));
            }
            if ($this->required->Visible && $this->required->Required) {
                if (!$this->required->IsDetailKey && EmptyValue($this->required->FormValue)) {
                    $this->required->addErrorMessage(str_replace("%s", $this->required->caption(), $this->required->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->required->FormValue)) {
                $this->required->addErrorMessage($this->required->getErrorMessage(false));
            }
            if ($this->blocked->Visible && $this->blocked->Required) {
                if (!$this->blocked->IsDetailKey && EmptyValue($this->blocked->FormValue)) {
                    $this->blocked->addErrorMessage(str_replace("%s", $this->blocked->caption(), $this->blocked->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->blocked->FormValue)) {
                $this->blocked->addErrorMessage($this->blocked->getErrorMessage(false));
            }
            if ($this->ordered->Visible && $this->ordered->Required) {
                if (!$this->ordered->IsDetailKey && EmptyValue($this->ordered->FormValue)) {
                    $this->ordered->addErrorMessage(str_replace("%s", $this->ordered->caption(), $this->ordered->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->ordered->FormValue)) {
                $this->ordered->addErrorMessage($this->ordered->getErrorMessage(false));
            }
            if ($this->supplier->Visible && $this->supplier->Required) {
                if (!$this->supplier->IsDetailKey && EmptyValue($this->supplier->FormValue)) {
                    $this->supplier->addErrorMessage(str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
                }
            }
            if ($this->country->Visible && $this->country->Required) {
                if (!$this->country->IsDetailKey && EmptyValue($this->country->FormValue)) {
                    $this->country->addErrorMessage(str_replace("%s", $this->country->caption(), $this->country->RequiredErrorMessage));
                }
            }
            if ($this->minimum_stock->Visible && $this->minimum_stock->Required) {
                if (!$this->minimum_stock->IsDetailKey && EmptyValue($this->minimum_stock->FormValue)) {
                    $this->minimum_stock->addErrorMessage(str_replace("%s", $this->minimum_stock->caption(), $this->minimum_stock->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->minimum_stock->FormValue)) {
                $this->minimum_stock->addErrorMessage($this->minimum_stock->getErrorMessage(false));
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("reflist"), "", $this->TableVar, true);
        $pageId = "addopt";
        $Breadcrumb->add("addopt", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product_code_type":
                    break;
                case "x_set_ref":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shape":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_b_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_06":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_07":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_08":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_09":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_10":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_11":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_t_12":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_currency":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_hsn":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_composition":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    break;
                case "x_publish":
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'ref');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
