<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for ref
 */
class Ref extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $oid;
    public $company_id;
    public $grp;
    public $s_grp;
    public $product;
    public $product_type;
    public $packing_type;
    public $product_n;
    public $_barcode;
    public $product_code_type;
    public $product_code;
    public $print_name;
    public $gcode;
    public $code;
    public $product_id;
    public $batch_no;
    public $set_ref;
    public $v_00;
    public $v_01;
    public $v_02;
    public $v_03;
    public $v_04;
    public $v_05;
    public $v_06;
    public $v_07;
    public $v_08;
    public $v_09;
    public $v_10;
    public $cbm;
    public $sqm;
    public $shape;
    public $q_sku;
    public $b_01;
    public $b_02;
    public $b_03;
    public $b_04;
    public $b_05;
    public $b_06;
    public $b_07;
    public $b_08;
    public $b_09;
    public $b_10;
    public $b_11;
    public $b_12;
    public $b_13;
    public $b_14;
    public $b_15;
    public $t_01;
    public $t_02;
    public $t_03;
    public $t_04;
    public $t_05;
    public $t_06;
    public $t_07;
    public $t_08;
    public $t_09;
    public $t_10;
    public $t_11;
    public $t_12;
    public $t_13;
    public $t_14;
    public $t_15;
    public $last_price;
    public $currency;
    public $hsn;
    public $composition;
    public $category;
    public $moq;
    public $status;
    public $d_head_01;
    public $d_description_01;
    public $d_head_02;
    public $d_description_02;
    public $publish;
    public $keywords;
    public $operator;
    public $datetime;
    public $main_image;
    public $top_view;
    public $front_view;
    public $corner_view;
    public $back_view;
    public $color_options;
    public $other_options;
    public $group_image;
    public $video_url;
    public $image;
    public $in;
    public $out;
    public $required;
    public $blocked;
    public $ordered;
    public $supplier;
    public $country;
    public $minimum_stock;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "ref";
        $this->TableName = 'ref';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "ref";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = true; // Allow detail add
        $this->DetailEdit = true; // Allow detail edit
        $this->DetailView = true; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UseColumnVisibility = true;
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->IsForeignKey = true; // Foreign key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // oid
        $this->oid = new DbField(
            $this, // Table
            'x_oid', // Variable name
            'oid', // Name
            '`oid`', // Expression
            '`oid`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`oid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->oid->InputTextType = "text";
        $this->oid->Sortable = false; // Allow sort
        $this->oid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->oid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['oid'] = &$this->oid;

        // company_id
        $this->company_id = new DbField(
            $this, // Table
            'x_company_id', // Variable name
            'company_id', // Name
            '`company_id`', // Expression
            '`company_id`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`company_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->company_id->addMethod("getSelectFilter", fn() => (User_Company_ID() == 0) ? "`status` = 1 and `id` >= 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` >= 200000");
        $this->company_id->addMethod("getDefault", fn() => User_Company_ID());
        $this->company_id->InputTextType = "text";
        $this->company_id->setSelectMultiple(true); // Select multiple
        $this->company_id->Lookup = new Lookup($this->company_id, 'production_partner', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->company_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['company_id'] = &$this->company_id;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->grp->addMethod("getLinkPrefix", fn() => "reflist?x_grp=");
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->setSelectMultiple(false); // Select one
        $this->grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->grp->Lookup = new Lookup($this->grp, 'grp', false, 'id', ["grp","","",""], '', '', [], ["x_s_grp","x_set_ref[]","x_hsn","x_composition"], [], [], [], [], false, '`grp` ASC', '', "`grp`");
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // s_grp
        $this->s_grp = new DbField(
            $this, // Table
            'x_s_grp', // Variable name
            's_grp', // Name
            '`s_grp`', // Expression
            '`s_grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`s_grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->s_grp->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->s_grp->addMethod("getLinkPrefix", fn() => "reflist?x_s_grp=");
        $this->s_grp->InputTextType = "text";
        $this->s_grp->Raw = true;
        $this->s_grp->Nullable = false; // NOT NULL field
        $this->s_grp->Required = true; // Required field
        $this->s_grp->setSelectMultiple(false); // Select one
        $this->s_grp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->s_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->s_grp->Lookup = new Lookup($this->s_grp, 'product_group', false, 'id', ["product_group","","",""], '', '', ["x_grp"], ["x_product","x_v_01","x_v_02","x_v_03","x_v_04","x_v_05","x_v_06","x_v_07","x_v_08","x_v_09","x_v_10","x_b_03[]","x_b_04[]","x_b_05[]","x_b_06[]","x_b_07[]","x_b_08[]","x_b_09[]","x_b_10[]","x_t_03[]","x_t_04[]","x_t_05[]","x_t_06[]","x_t_07[]","x_t_08[]","x_t_09[]","x_t_10[]"], ["grp"], ["x_grp"], [], [], false, '`product_group` ASC', '', "`product_group`");
        $this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->s_grp->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['s_grp'] = &$this->s_grp;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getSelectFilter", fn() => "`status` =1");
        $this->product->addMethod("getLinkPrefix", fn() => "reflist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Required = true; // Required field
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product_view2', false, 'id', ["product","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // product_type
        $this->product_type = new DbField(
            $this, // Table
            'x_product_type', // Variable name
            'product_type', // Name
            '`product_type`', // Expression
            '`product_type`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_type->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->product_type->addMethod("getDefault", fn() => "0");
        $this->product_type->InputTextType = "text";
        $this->product_type->Required = true; // Required field
        $this->product_type->setSelectMultiple(false); // Select one
        $this->product_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_type->Lookup = new Lookup($this->product_type, 'product_type', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->product_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_type'] = &$this->product_type;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->packing_type->addMethod("getDefault", fn() => 0);
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Required = true; // Required field
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', true, 'id', ["code","packing","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`packing`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // product_n
        $this->product_n = new DbField(
            $this, // Table
            'x_product_n', // Variable name
            'product_n', // Name
            '`product_n`', // Expression
            '`product_n`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_n`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_n->InputTextType = "text";
        $this->product_n->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_n'] = &$this->product_n;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->InputTextType = "text";
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // product_code_type
        $this->product_code_type = new DbField(
            $this, // Table
            'x_product_code_type', // Variable name
            'product_code_type', // Name
            '`product_code_type`', // Expression
            '`product_code_type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product_code_type->addMethod("getDefault", fn() => 0);
        $this->product_code_type->InputTextType = "text";
        $this->product_code_type->Raw = true;
        $this->product_code_type->Nullable = false; // NOT NULL field
        $this->product_code_type->setSelectMultiple(false); // Select one
        $this->product_code_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product_code_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product_code_type->Lookup = new Lookup($this->product_code_type, 'ref', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->product_code_type->OptionCount = 2;
        $this->product_code_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product_code_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['product_code_type'] = &$this->product_code_type;

        // product_code
        $this->product_code = new DbField(
            $this, // Table
            'x_product_code', // Variable name
            'product_code', // Name
            '`product_code`', // Expression
            '`product_code`', // Basic search expression
            200, // Type
            300, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->product_code->InputTextType = "text";
        $this->product_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code'] = &$this->product_code;

        // print_name
        $this->print_name = new DbField(
            $this, // Table
            'x_print_name', // Variable name
            'print_name', // Name
            '`print_name`', // Expression
            '`print_name`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`print_name`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->print_name->addMethod("getEditCustomAttributes", fn() => "ReadOnly");
        $this->print_name->InputTextType = "text";
        $this->print_name->Sortable = false; // Allow sort
        $this->print_name->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->print_name->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['print_name'] = &$this->print_name;

        // gcode
        $this->gcode = new DbField(
            $this, // Table
            'x_gcode', // Variable name
            'gcode', // Name
            '`gcode`', // Expression
            '`gcode`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gcode->InputTextType = "text";
        $this->gcode->Sortable = false; // Allow sort
        $this->gcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['gcode'] = &$this->gcode;

        // code
        $this->code = new DbField(
            $this, // Table
            'x_code', // Variable name
            'code', // Name
            '`code`', // Expression
            '`code`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->code->InputTextType = "text";
        $this->code->Sortable = false; // Allow sort
        $this->code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['code'] = &$this->code;

        // product_id
        $this->product_id = new DbField(
            $this, // Table
            'x_product_id', // Variable name
            'product_id', // Name
            '`product_id`', // Expression
            '`product_id`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_id->InputTextType = "text";
        $this->product_id->Sortable = false; // Allow sort
        $this->product_id->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_id'] = &$this->product_id;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Sortable = false; // Allow sort
        $this->batch_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // set_ref
        $this->set_ref = new DbField(
            $this, // Table
            'x_set_ref', // Variable name
            'set_ref', // Name
            '`set_ref`', // Expression
            '`set_ref`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`set_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->set_ref->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->set_ref->InputTextType = "text";
        $this->set_ref->Lookup = new Lookup($this->set_ref, 'ref', true, 'id', ["product_code","","",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->set_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->set_ref->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['set_ref'] = &$this->set_ref;

        // v_00
        $this->v_00 = new DbField(
            $this, // Table
            'x_v_00', // Variable name
            'v_00', // Name
            '`v_00`', // Expression
            '`v_00`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_00`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->v_00->InputTextType = "text";
        $this->v_00->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_00'] = &$this->v_00;

        // v_01
        $this->v_01 = new DbField(
            $this, // Table
            'x_v_01', // Variable name
            'v_01', // Name
            '`v_01`', // Expression
            '`v_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_01->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 101 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_01->addMethod("getLinkPrefix", fn() => "reflist?x_country=");
        $this->v_01->InputTextType = "text";
        $this->v_01->setSelectMultiple(false); // Select one
        $this->v_01->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_01->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_01->Lookup = new Lookup($this->v_01, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_01) . "',COALESCE(`name`,''))");
        $this->v_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_01'] = &$this->v_01;

        // v_02
        $this->v_02 = new DbField(
            $this, // Table
            'x_v_02', // Variable name
            'v_02', // Name
            '`v_02`', // Expression
            '`v_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_02->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 102 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_02->addMethod("getLinkPrefix", fn() => "reflist?x_supplier=");
        $this->v_02->InputTextType = "text";
        $this->v_02->setSelectMultiple(false); // Select one
        $this->v_02->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_02->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_02->Lookup = new Lookup($this->v_02, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_02) . "',COALESCE(`name`,''))");
        $this->v_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_02'] = &$this->v_02;

        // v_03
        $this->v_03 = new DbField(
            $this, // Table
            'x_v_03', // Variable name
            'v_03', // Name
            '`v_03`', // Expression
            '`v_03`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_03->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 103 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_03->addMethod("getLinkPrefix", fn() => "reflist?x_wool_type=");
        $this->v_03->InputTextType = "text";
        $this->v_03->setSelectMultiple(false); // Select one
        $this->v_03->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_03->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_03->Lookup = new Lookup($this->v_03, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_03) . "',COALESCE(`name`,''))");
        $this->v_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_03'] = &$this->v_03;

        // v_04
        $this->v_04 = new DbField(
            $this, // Table
            'x_v_04', // Variable name
            'v_04', // Name
            '`v_04`', // Expression
            '`v_04`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_04->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 104 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_04->addMethod("getLinkPrefix", fn() => "reflist?x_quality=");
        $this->v_04->InputTextType = "text";
        $this->v_04->setSelectMultiple(false); // Select one
        $this->v_04->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_04->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_04->Lookup = new Lookup($this->v_04, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_04) . "',COALESCE(`name`,''))");
        $this->v_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_04'] = &$this->v_04;

        // v_05
        $this->v_05 = new DbField(
            $this, // Table
            'x_v_05', // Variable name
            'v_05', // Name
            '`v_05`', // Expression
            '`v_05`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_05->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 105 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_05->addMethod("getLinkPrefix", fn() => "reflist?x_grade=");
        $this->v_05->InputTextType = "text";
        $this->v_05->setSelectMultiple(false); // Select one
        $this->v_05->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_05->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_05->Lookup = new Lookup($this->v_05, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_05) . "',COALESCE(`name`,''))");
        $this->v_05->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_05'] = &$this->v_05;

        // v_06
        $this->v_06 = new DbField(
            $this, // Table
            'x_v_06', // Variable name
            'v_06', // Name
            '`v_06`', // Expression
            '`v_06`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_06->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 106 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_06->InputTextType = "text";
        $this->v_06->setSelectMultiple(false); // Select one
        $this->v_06->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_06->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_06->Lookup = new Lookup($this->v_06, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_06) . "',COALESCE(`name`,''))");
        $this->v_06->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_06'] = &$this->v_06;

        // v_07
        $this->v_07 = new DbField(
            $this, // Table
            'x_v_07', // Variable name
            'v_07', // Name
            '`v_07`', // Expression
            '`v_07`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_07->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 107 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_07->InputTextType = "text";
        $this->v_07->setSelectMultiple(false); // Select one
        $this->v_07->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_07->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_07->Lookup = new Lookup($this->v_07, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_07) . "',COALESCE(`name`,''))");
        $this->v_07->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_07'] = &$this->v_07;

        // v_08
        $this->v_08 = new DbField(
            $this, // Table
            'x_v_08', // Variable name
            'v_08', // Name
            '`v_08`', // Expression
            '`v_08`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_08->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 108 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_08->InputTextType = "text";
        $this->v_08->setSelectMultiple(false); // Select one
        $this->v_08->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_08->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_08->Lookup = new Lookup($this->v_08, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_08) . "',COALESCE(`name`,''))");
        $this->v_08->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_08'] = &$this->v_08;

        // v_09
        $this->v_09 = new DbField(
            $this, // Table
            'x_v_09', // Variable name
            'v_09', // Name
            '`v_09`', // Expression
            '`v_09`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_09->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 109 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_09->InputTextType = "text";
        $this->v_09->setSelectMultiple(false); // Select one
        $this->v_09->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_09->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_09->Lookup = new Lookup($this->v_09, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_09) . "',COALESCE(`name`,''))");
        $this->v_09->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_09'] = &$this->v_09;

        // v_10
        $this->v_10 = new DbField(
            $this, // Table
            'x_v_10', // Variable name
            'v_10', // Name
            '`v_10`', // Expression
            '`v_10`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->v_10->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 110 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->v_10->InputTextType = "text";
        $this->v_10->setSelectMultiple(false); // Select one
        $this->v_10->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->v_10->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->v_10->Lookup = new Lookup($this->v_10, 'varient_view2', true, 'code', ["code","name","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_10) . "',COALESCE(`name`,''))");
        $this->v_10->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_10'] = &$this->v_10;

        // cbm
        $this->cbm = new DbField(
            $this, // Table
            'x_cbm', // Variable name
            'cbm', // Name
            '`cbm`', // Expression
            '`cbm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cbm->InputTextType = "text";
        $this->cbm->Raw = true;
        $this->cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cbm'] = &$this->cbm;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            4, // Type
            12, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm'] = &$this->sqm;

        // shape
        $this->shape = new DbField(
            $this, // Table
            'x_shape', // Variable name
            'shape', // Name
            '`shape`', // Expression
            '`shape`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shape`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->shape->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->shape->InputTextType = "text";
        $this->shape->Lookup = new Lookup($this->shape, 'shape', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->shape->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['shape'] = &$this->shape;

        // q_sku
        $this->q_sku = new DbField(
            $this, // Table
            'x_q_sku', // Variable name
            'q_sku', // Name
            '`q_sku`', // Expression
            '`q_sku`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`q_sku`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->q_sku->addMethod("getDefault", fn() => 1.00);
        $this->q_sku->InputTextType = "text";
        $this->q_sku->Raw = true;
        $this->q_sku->Nullable = false; // NOT NULL field
        $this->q_sku->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->q_sku->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['q_sku'] = &$this->q_sku;

        // b_01
        $this->b_01 = new DbField(
            $this, // Table
            'x_b_01', // Variable name
            'b_01', // Name
            '`b_01`', // Expression
            '`b_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_01->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 201");
        $this->b_01->InputTextType = "text";
        $this->b_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_01'] = &$this->b_01;

        // b_02
        $this->b_02 = new DbField(
            $this, // Table
            'x_b_02', // Variable name
            'b_02', // Name
            '`b_02`', // Expression
            '`b_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_02->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 202");
        $this->b_02->InputTextType = "text";
        $this->b_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_02'] = &$this->b_02;

        // b_03
        $this->b_03 = new DbField(
            $this, // Table
            'x_b_03', // Variable name
            'b_03', // Name
            '`b_03`', // Expression
            '`b_03`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_03->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 203 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_03->InputTextType = "text";
        $this->b_03->Lookup = new Lookup($this->b_03, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_03'] = &$this->b_03;

        // b_04
        $this->b_04 = new DbField(
            $this, // Table
            'x_b_04', // Variable name
            'b_04', // Name
            '`b_04`', // Expression
            '`b_04`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_04->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 204 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_04->InputTextType = "text";
        $this->b_04->Lookup = new Lookup($this->b_04, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_04'] = &$this->b_04;

        // b_05
        $this->b_05 = new DbField(
            $this, // Table
            'x_b_05', // Variable name
            'b_05', // Name
            '`b_05`', // Expression
            '`b_05`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_05->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 205 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_05->InputTextType = "text";
        $this->b_05->Lookup = new Lookup($this->b_05, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_05->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_05'] = &$this->b_05;

        // b_06
        $this->b_06 = new DbField(
            $this, // Table
            'x_b_06', // Variable name
            'b_06', // Name
            '`b_06`', // Expression
            '`b_06`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_06->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 206 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_06->InputTextType = "text";
        $this->b_06->Lookup = new Lookup($this->b_06, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_06->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_06'] = &$this->b_06;

        // b_07
        $this->b_07 = new DbField(
            $this, // Table
            'x_b_07', // Variable name
            'b_07', // Name
            '`b_07`', // Expression
            '`b_07`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_07->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 207 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_07->InputTextType = "text";
        $this->b_07->Lookup = new Lookup($this->b_07, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_07->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_07'] = &$this->b_07;

        // b_08
        $this->b_08 = new DbField(
            $this, // Table
            'x_b_08', // Variable name
            'b_08', // Name
            '`b_08`', // Expression
            '`b_08`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_08->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 208 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_08->InputTextType = "text";
        $this->b_08->Lookup = new Lookup($this->b_08, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_08->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_08'] = &$this->b_08;

        // b_09
        $this->b_09 = new DbField(
            $this, // Table
            'x_b_09', // Variable name
            'b_09', // Name
            '`b_09`', // Expression
            '`b_09`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_09->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 209 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_09->InputTextType = "text";
        $this->b_09->Lookup = new Lookup($this->b_09, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_09->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_09'] = &$this->b_09;

        // b_10
        $this->b_10 = new DbField(
            $this, // Table
            'x_b_10', // Variable name
            'b_10', // Name
            '`b_10`', // Expression
            '`b_10`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->b_10->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 210 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->b_10->InputTextType = "text";
        $this->b_10->Lookup = new Lookup($this->b_10, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->b_10->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_10'] = &$this->b_10;

        // b_11
        $this->b_11 = new DbField(
            $this, // Table
            'x_b_11', // Variable name
            'b_11', // Name
            '`b_11`', // Expression
            '`b_11`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_11->addMethod("getSelectFilter", fn() =>  "`status` = 1 and `no` = 211");
        $this->b_11->InputTextType = "text";
        $this->b_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_11'] = &$this->b_11;

        // b_12
        $this->b_12 = new DbField(
            $this, // Table
            'x_b_12', // Variable name
            'b_12', // Name
            '`b_12`', // Expression
            '`b_12`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_12->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 212");
        $this->b_12->InputTextType = "text";
        $this->b_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_12'] = &$this->b_12;

        // b_13
        $this->b_13 = new DbField(
            $this, // Table
            'x_b_13', // Variable name
            'b_13', // Name
            '`b_13`', // Expression
            '`b_13`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_13`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_13->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 213");
        $this->b_13->InputTextType = "text";
        $this->b_13->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_13'] = &$this->b_13;

        // b_14
        $this->b_14 = new DbField(
            $this, // Table
            'x_b_14', // Variable name
            'b_14', // Name
            '`b_14`', // Expression
            '`b_14`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_14`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_14->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 214");
        $this->b_14->InputTextType = "text";
        $this->b_14->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_14'] = &$this->b_14;

        // b_15
        $this->b_15 = new DbField(
            $this, // Table
            'x_b_15', // Variable name
            'b_15', // Name
            '`b_15`', // Expression
            '`b_15`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_15`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_15->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 215");
        $this->b_15->InputTextType = "text";
        $this->b_15->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_15'] = &$this->b_15;

        // t_01
        $this->t_01 = new DbField(
            $this, // Table
            'x_t_01', // Variable name
            't_01', // Name
            '`t_01`', // Expression
            '`t_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_01->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 301");
        $this->t_01->InputTextType = "text";
        $this->t_01->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_01'] = &$this->t_01;

        // t_02
        $this->t_02 = new DbField(
            $this, // Table
            'x_t_02', // Variable name
            't_02', // Name
            '`t_02`', // Expression
            '`t_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_02->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 302");
        $this->t_02->InputTextType = "text";
        $this->t_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_02'] = &$this->t_02;

        // t_03
        $this->t_03 = new DbField(
            $this, // Table
            'x_t_03', // Variable name
            't_03', // Name
            '`t_03`', // Expression
            '`t_03`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_03->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 303 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_03->InputTextType = "text";
        $this->t_03->Lookup = new Lookup($this->t_03, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_03'] = &$this->t_03;

        // t_04
        $this->t_04 = new DbField(
            $this, // Table
            'x_t_04', // Variable name
            't_04', // Name
            '`t_04`', // Expression
            '`t_04`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_04->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 304 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_04->InputTextType = "text";
        $this->t_04->Lookup = new Lookup($this->t_04, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_04'] = &$this->t_04;

        // t_05
        $this->t_05 = new DbField(
            $this, // Table
            'x_t_05', // Variable name
            't_05', // Name
            '`t_05`', // Expression
            '`t_05`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_05->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 305 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_05->InputTextType = "text";
        $this->t_05->Lookup = new Lookup($this->t_05, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_05->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_05'] = &$this->t_05;

        // t_06
        $this->t_06 = new DbField(
            $this, // Table
            'x_t_06', // Variable name
            't_06', // Name
            '`t_06`', // Expression
            '`t_06`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_06`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_06->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 306 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_06->InputTextType = "text";
        $this->t_06->Lookup = new Lookup($this->t_06, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_06->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_06'] = &$this->t_06;

        // t_07
        $this->t_07 = new DbField(
            $this, // Table
            'x_t_07', // Variable name
            't_07', // Name
            '`t_07`', // Expression
            '`t_07`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_07`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_07->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 307 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_07->InputTextType = "text";
        $this->t_07->Lookup = new Lookup($this->t_07, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_07->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_07'] = &$this->t_07;

        // t_08
        $this->t_08 = new DbField(
            $this, // Table
            'x_t_08', // Variable name
            't_08', // Name
            '`t_08`', // Expression
            '`t_08`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_08`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_08->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 308 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_08->InputTextType = "text";
        $this->t_08->Lookup = new Lookup($this->t_08, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_08->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_08'] = &$this->t_08;

        // t_09
        $this->t_09 = new DbField(
            $this, // Table
            'x_t_09', // Variable name
            't_09', // Name
            '`t_09`', // Expression
            '`t_09`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_09`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_09->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 309 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_09->InputTextType = "text";
        $this->t_09->Lookup = new Lookup($this->t_09, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_09->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_09'] = &$this->t_09;

        // t_10
        $this->t_10 = new DbField(
            $this, // Table
            'x_t_10', // Variable name
            't_10', // Name
            '`t_10`', // Expression
            '`t_10`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_10`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->t_10->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 310 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_10->InputTextType = "text";
        $this->t_10->Lookup = new Lookup($this->t_10, 'varient_view2', true, 'name', ["name","","",""], '', '', ["x_s_grp"], [], ["s_grp"], ["x_s_grp"], [], [], false, '`name` ASC', '', "`name`");
        $this->t_10->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_10'] = &$this->t_10;

        // t_11
        $this->t_11 = new DbField(
            $this, // Table
            'x_t_11', // Variable name
            't_11', // Name
            '`t_11`', // Expression
            '`t_11`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_11`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_11->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 311 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_11->InputTextType = "text";
        $this->t_11->Lookup = new Lookup($this->t_11, 'varient_view2', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->t_11->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_11'] = &$this->t_11;

        // t_12
        $this->t_12 = new DbField(
            $this, // Table
            'x_t_12', // Variable name
            't_12', // Name
            '`t_12`', // Expression
            '`t_12`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_12->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 312 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))");
        $this->t_12->InputTextType = "text";
        $this->t_12->Lookup = new Lookup($this->t_12, 'varient_view2', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->t_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_12'] = &$this->t_12;

        // t_13
        $this->t_13 = new DbField(
            $this, // Table
            'x_t_13', // Variable name
            't_13', // Name
            '`t_13`', // Expression
            '`t_13`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_13`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_13->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 313");
        $this->t_13->InputTextType = "text";
        $this->t_13->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_13'] = &$this->t_13;

        // t_14
        $this->t_14 = new DbField(
            $this, // Table
            'x_t_14', // Variable name
            't_14', // Name
            '`t_14`', // Expression
            '`t_14`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_14`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_14->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 314");
        $this->t_14->InputTextType = "text";
        $this->t_14->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_14'] = &$this->t_14;

        // t_15
        $this->t_15 = new DbField(
            $this, // Table
            'x_t_15', // Variable name
            't_15', // Name
            '`t_15`', // Expression
            '`t_15`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`t_15`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->t_15->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 315");
        $this->t_15->InputTextType = "text";
        $this->t_15->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['t_15'] = &$this->t_15;

        // last_price
        $this->last_price = new DbField(
            $this, // Table
            'x_last_price', // Variable name
            'last_price', // Name
            '`last_price`', // Expression
            '`last_price`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`last_price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->last_price->InputTextType = "text";
        $this->last_price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->last_price->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['last_price'] = &$this->last_price;

        // currency
        $this->currency = new DbField(
            $this, // Table
            'x_currency', // Variable name
            'currency', // Name
            '`currency`', // Expression
            '`currency`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->currency->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->currency->addMethod("getDefault", fn() => 1);
        $this->currency->InputTextType = "text";
        $this->currency->Raw = true;
        $this->currency->Nullable = false; // NOT NULL field
        $this->currency->Required = true; // Required field
        $this->currency->setSelectMultiple(false); // Select one
        $this->currency->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->currency->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->currency->Lookup = new Lookup($this->currency, 'currency', false, 'id', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->currency) . "',COALESCE(`name`,''))");
        $this->currency->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->currency->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['currency'] = &$this->currency;

        // hsn
        $this->hsn = new DbField(
            $this, // Table
            'x_hsn', // Variable name
            'hsn', // Name
            '`hsn`', // Expression
            '`hsn`', // Basic search expression
            3, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`hsn`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->hsn->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->hsn->InputTextType = "text";
        $this->hsn->Raw = true;
        $this->hsn->Required = true; // Required field
        $this->hsn->setSelectMultiple(false); // Select one
        $this->hsn->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->hsn->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->hsn->Lookup = new Lookup($this->hsn, 'tax_category', true, 'id', ["item","hsn_code","tax_percent",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`item` ASC', '', "CONCAT(COALESCE(`item`, ''),'" . ValueSeparator(1, $this->hsn) . "',COALESCE(`hsn_code`,''),'" . ValueSeparator(2, $this->hsn) . "',COALESCE(`tax_percent`,''))");
        $this->hsn->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->hsn->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['hsn'] = &$this->hsn;

        // composition
        $this->composition = new DbField(
            $this, // Table
            'x_composition', // Variable name
            'composition', // Name
            '`composition`', // Expression
            '`composition`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`composition`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->composition->addMethod("getSelectFilter", fn() => "`status` = 1");
        $this->composition->InputTextType = "text";
        $this->composition->Raw = true;
        $this->composition->setSelectMultiple(false); // Select one
        $this->composition->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->composition->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->composition->Lookup = new Lookup($this->composition, 'composition', true, 'id', ["composition","","",""], '', '', ["x_grp"], [], ["grp"], ["x_grp"], [], [], false, '`id` ASC', '', "`composition`");
        $this->composition->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->composition->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['composition'] = &$this->composition;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->category->InputTextType = "text";
        $this->category->Raw = true;
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'product_category', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->category->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['category'] = &$this->category;

        // moq
        $this->moq = new DbField(
            $this, // Table
            'x_moq', // Variable name
            'moq', // Name
            '`moq`', // Expression
            '`moq`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`moq`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->moq->addMethod("getDefault", fn() => 0.000);
        $this->moq->InputTextType = "text";
        $this->moq->Raw = true;
        $this->moq->Sortable = false; // Allow sort
        $this->moq->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->moq->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['moq'] = &$this->moq;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getDefault", fn() => 1);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'ref', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['status'] = &$this->status;

        // d_head_01
        $this->d_head_01 = new DbField(
            $this, // Table
            'x_d_head_01', // Variable name
            'd_head_01', // Name
            '`d_head_01`', // Expression
            '`d_head_01`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_head_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_head_01->InputTextType = "text";
        $this->d_head_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_head_01'] = &$this->d_head_01;

        // d_description_01
        $this->d_description_01 = new DbField(
            $this, // Table
            'x_d_description_01', // Variable name
            'd_description_01', // Name
            '`d_description_01`', // Expression
            '`d_description_01`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_description_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->d_description_01->InputTextType = "text";
        $this->d_description_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_description_01'] = &$this->d_description_01;

        // d_head_02
        $this->d_head_02 = new DbField(
            $this, // Table
            'x_d_head_02', // Variable name
            'd_head_02', // Name
            '`d_head_02`', // Expression
            '`d_head_02`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_head_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_head_02->InputTextType = "text";
        $this->d_head_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_head_02'] = &$this->d_head_02;

        // d_description_02
        $this->d_description_02 = new DbField(
            $this, // Table
            'x_d_description_02', // Variable name
            'd_description_02', // Name
            '`d_description_02`', // Expression
            '`d_description_02`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_description_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->d_description_02->InputTextType = "text";
        $this->d_description_02->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_description_02'] = &$this->d_description_02;

        // publish
        $this->publish = new DbField(
            $this, // Table
            'x_publish', // Variable name
            'publish', // Name
            '`publish`', // Expression
            '`publish`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`publish`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->publish->addMethod("getDefault", fn() => 0);
        $this->publish->InputTextType = "text";
        $this->publish->Raw = true;
        $this->publish->setSelectMultiple(false); // Select one
        $this->publish->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->publish->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->publish->Lookup = new Lookup($this->publish, 'ref', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->publish->OptionCount = 2;
        $this->publish->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['publish'] = &$this->publish;

        // keywords
        $this->keywords = new DbField(
            $this, // Table
            'x_keywords', // Variable name
            'keywords', // Name
            '`keywords`', // Expression
            '`keywords`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`keywords`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->keywords->InputTextType = "text";
        $this->keywords->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['keywords'] = &$this->keywords;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // main_image
        $this->main_image = new DbField(
            $this, // Table
            'x_main_image', // Variable name
            'main_image', // Name
            '`main_image`', // Expression
            '`main_image`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`main_image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->main_image->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->main_image->InputTextType = "text";
        $this->main_image->Sortable = false; // Allow sort
        $this->main_image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['main_image'] = &$this->main_image;

        // top_view
        $this->top_view = new DbField(
            $this, // Table
            'x_top_view', // Variable name
            'top_view', // Name
            '`top_view`', // Expression
            '`top_view`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`top_view`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->top_view->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->top_view->InputTextType = "text";
        $this->top_view->Sortable = false; // Allow sort
        $this->top_view->UploadMultiple = true;
        $this->top_view->Upload->UploadMultiple = true;
        $this->top_view->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['top_view'] = &$this->top_view;

        // front_view
        $this->front_view = new DbField(
            $this, // Table
            'x_front_view', // Variable name
            'front_view', // Name
            '`front_view`', // Expression
            '`front_view`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`front_view`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->front_view->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->front_view->InputTextType = "text";
        $this->front_view->Sortable = false; // Allow sort
        $this->front_view->UploadMultiple = true;
        $this->front_view->Upload->UploadMultiple = true;
        $this->front_view->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['front_view'] = &$this->front_view;

        // corner_view
        $this->corner_view = new DbField(
            $this, // Table
            'x_corner_view', // Variable name
            'corner_view', // Name
            '`corner_view`', // Expression
            '`corner_view`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`corner_view`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->corner_view->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->corner_view->InputTextType = "text";
        $this->corner_view->Sortable = false; // Allow sort
        $this->corner_view->UploadMultiple = true;
        $this->corner_view->Upload->UploadMultiple = true;
        $this->corner_view->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['corner_view'] = &$this->corner_view;

        // back_view
        $this->back_view = new DbField(
            $this, // Table
            'x_back_view', // Variable name
            'back_view', // Name
            '`back_view`', // Expression
            '`back_view`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`back_view`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->back_view->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->back_view->InputTextType = "text";
        $this->back_view->Sortable = false; // Allow sort
        $this->back_view->UploadMultiple = true;
        $this->back_view->Upload->UploadMultiple = true;
        $this->back_view->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['back_view'] = &$this->back_view;

        // color_options
        $this->color_options = new DbField(
            $this, // Table
            'x_color_options', // Variable name
            'color_options', // Name
            '`color_options`', // Expression
            '`color_options`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`color_options`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->color_options->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->color_options->InputTextType = "text";
        $this->color_options->Sortable = false; // Allow sort
        $this->color_options->UploadMultiple = true;
        $this->color_options->Upload->UploadMultiple = true;
        $this->color_options->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['color_options'] = &$this->color_options;

        // other_options
        $this->other_options = new DbField(
            $this, // Table
            'x_other_options', // Variable name
            'other_options', // Name
            '`other_options`', // Expression
            '`other_options`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`other_options`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->other_options->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->other_options->InputTextType = "text";
        $this->other_options->Sortable = false; // Allow sort
        $this->other_options->UploadMultiple = true;
        $this->other_options->Upload->UploadMultiple = true;
        $this->other_options->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['other_options'] = &$this->other_options;

        // group_image
        $this->group_image = new DbField(
            $this, // Table
            'x_group_image', // Variable name
            'group_image', // Name
            '`group_image`', // Expression
            '`group_image`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`group_image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'FILE' // Edit Tag
        );
        $this->group_image->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/group_image/' );
        $this->group_image->InputTextType = "text";
        $this->group_image->Sortable = false; // Allow sort
        $this->group_image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['group_image'] = &$this->group_image;

        // video_url
        $this->video_url = new DbField(
            $this, // Table
            'x_video_url', // Variable name
            'video_url', // Name
            '`video_url`', // Expression
            '`video_url`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`video_url`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->video_url->InputTextType = "text";
        $this->video_url->Sortable = false; // Allow sort
        $this->video_url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['video_url'] = &$this->video_url;

        // image
        $this->image = new DbField(
            $this, // Table
            'x_image', // Variable name
            'image', // Name
            '`image`', // Expression
            '`image`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->image->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->image->InputTextType = "text";
        $this->image->Sortable = false; // Allow sort
        $this->image->ImageResize = true;
        $this->image->UploadMultiple = true;
        $this->image->Upload->UploadMultiple = true;
        $this->image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['image'] = &$this->image;

        // in
        $this->in = new DbField(
            $this, // Table
            'x_in', // Variable name
            'in', // Name
            '`in`', // Expression
            '`in`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`in`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->in->InputTextType = "text";
        $this->in->Raw = true;
        $this->in->Nullable = false; // NOT NULL field
        $this->in->Required = true; // Required field
        $this->in->Sortable = false; // Allow sort
        $this->in->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->in->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['in'] = &$this->in;

        // out
        $this->out = new DbField(
            $this, // Table
            'x_out', // Variable name
            'out', // Name
            '`out`', // Expression
            '`out`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`out`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->out->InputTextType = "text";
        $this->out->Raw = true;
        $this->out->Nullable = false; // NOT NULL field
        $this->out->Required = true; // Required field
        $this->out->Sortable = false; // Allow sort
        $this->out->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->out->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['out'] = &$this->out;

        // required
        $this->required = new DbField(
            $this, // Table
            'x_required', // Variable name
            'required', // Name
            '`required`', // Expression
            '`required`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`required`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->required->InputTextType = "text";
        $this->required->Raw = true;
        $this->required->Nullable = false; // NOT NULL field
        $this->required->Required = true; // Required field
        $this->required->Sortable = false; // Allow sort
        $this->required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->required->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['required'] = &$this->required;

        // blocked
        $this->blocked = new DbField(
            $this, // Table
            'x_blocked', // Variable name
            'blocked', // Name
            '`blocked`', // Expression
            '`blocked`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`blocked`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->blocked->InputTextType = "text";
        $this->blocked->Raw = true;
        $this->blocked->Nullable = false; // NOT NULL field
        $this->blocked->Required = true; // Required field
        $this->blocked->Sortable = false; // Allow sort
        $this->blocked->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->blocked->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['blocked'] = &$this->blocked;

        // ordered
        $this->ordered = new DbField(
            $this, // Table
            'x_ordered', // Variable name
            'ordered', // Name
            '`ordered`', // Expression
            '`ordered`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ordered`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->ordered->InputTextType = "text";
        $this->ordered->Raw = true;
        $this->ordered->Nullable = false; // NOT NULL field
        $this->ordered->Required = true; // Required field
        $this->ordered->Sortable = false; // Allow sort
        $this->ordered->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->ordered->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['ordered'] = &$this->ordered;

        // supplier
        $this->supplier = new DbField(
            $this, // Table
            'x_supplier', // Variable name
            'supplier', // Name
            '`supplier`', // Expression
            '`supplier`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`supplier`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->supplier->addMethod("getSelectFilter", fn() => "`status` = 1 and `grp` = 1");
        $this->supplier->addMethod("getLinkPrefix", fn() => "reflist?x_supplier=");
        $this->supplier->InputTextType = "text";
        $this->supplier->Raw = true;
        $this->supplier->Sortable = false; // Allow sort
        $this->supplier->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['supplier'] = &$this->supplier;

        // country
        $this->country = new DbField(
            $this, // Table
            'x_country', // Variable name
            'country', // Name
            '`country`', // Expression
            '`country`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`country`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->country->addMethod("getSelectFilter", fn() => "`status` = 1 and `grp` = 1");
        $this->country->addMethod("getLinkPrefix", fn() => "reflist?x_country=");
        $this->country->InputTextType = "text";
        $this->country->Raw = true;
        $this->country->Sortable = false; // Allow sort
        $this->country->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['country'] = &$this->country;

        // minimum_stock
        $this->minimum_stock = new DbField(
            $this, // Table
            'x_minimum_stock', // Variable name
            'minimum_stock', // Name
            '`minimum_stock`', // Expression
            '`minimum_stock`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`minimum_stock`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->minimum_stock->addMethod("getDefault", fn() => 0.000);
        $this->minimum_stock->InputTextType = "text";
        $this->minimum_stock->Raw = true;
        $this->minimum_stock->Nullable = false; // NOT NULL field
        $this->minimum_stock->Sortable = false; // Allow sort
        $this->minimum_stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->minimum_stock->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['minimum_stock'] = &$this->minimum_stock;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Current detail table name
    public function getCurrentDetailTable()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")) ?? "";
    }

    public function setCurrentDetailTable($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
    }

    // Get detail url
    public function getDetailUrl()
    {
        // Detail url
        $detailUrl = "";
        if ($this->getCurrentDetailTable() == "multiple_price") {
            $detailUrl = Container("multiple_price")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($this->getCurrentDetailTable() == "partner_product_ref") {
            $detailUrl = Container("partner_product_ref")->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
            $detailUrl .= "&" . GetForeignKeyUrl("fk_id", $this->id->CurrentValue);
        }
        if ($detailUrl == "") {
            $detailUrl = "reflist";
        }
        return $detailUrl;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "ref";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = (User_Company_ID() == 0) ? "`product_type` != 9" : "`company_id` = " .  User_Company_ID()  . " and `product_type` != 9";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->oid->DbValue = $row['oid'];
        $this->company_id->DbValue = $row['company_id'];
        $this->grp->DbValue = $row['grp'];
        $this->s_grp->DbValue = $row['s_grp'];
        $this->product->DbValue = $row['product'];
        $this->product_type->DbValue = $row['product_type'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->product_n->DbValue = $row['product_n'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->product_code_type->DbValue = $row['product_code_type'];
        $this->product_code->DbValue = $row['product_code'];
        $this->print_name->DbValue = $row['print_name'];
        $this->gcode->DbValue = $row['gcode'];
        $this->code->DbValue = $row['code'];
        $this->product_id->DbValue = $row['product_id'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->set_ref->DbValue = $row['set_ref'];
        $this->v_00->DbValue = $row['v_00'];
        $this->v_01->DbValue = $row['v_01'];
        $this->v_02->DbValue = $row['v_02'];
        $this->v_03->DbValue = $row['v_03'];
        $this->v_04->DbValue = $row['v_04'];
        $this->v_05->DbValue = $row['v_05'];
        $this->v_06->DbValue = $row['v_06'];
        $this->v_07->DbValue = $row['v_07'];
        $this->v_08->DbValue = $row['v_08'];
        $this->v_09->DbValue = $row['v_09'];
        $this->v_10->DbValue = $row['v_10'];
        $this->cbm->DbValue = $row['cbm'];
        $this->sqm->DbValue = $row['sqm'];
        $this->shape->DbValue = $row['shape'];
        $this->q_sku->DbValue = $row['q_sku'];
        $this->b_01->DbValue = $row['b_01'];
        $this->b_02->DbValue = $row['b_02'];
        $this->b_03->DbValue = $row['b_03'];
        $this->b_04->DbValue = $row['b_04'];
        $this->b_05->DbValue = $row['b_05'];
        $this->b_06->DbValue = $row['b_06'];
        $this->b_07->DbValue = $row['b_07'];
        $this->b_08->DbValue = $row['b_08'];
        $this->b_09->DbValue = $row['b_09'];
        $this->b_10->DbValue = $row['b_10'];
        $this->b_11->DbValue = $row['b_11'];
        $this->b_12->DbValue = $row['b_12'];
        $this->b_13->DbValue = $row['b_13'];
        $this->b_14->DbValue = $row['b_14'];
        $this->b_15->DbValue = $row['b_15'];
        $this->t_01->DbValue = $row['t_01'];
        $this->t_02->DbValue = $row['t_02'];
        $this->t_03->DbValue = $row['t_03'];
        $this->t_04->DbValue = $row['t_04'];
        $this->t_05->DbValue = $row['t_05'];
        $this->t_06->DbValue = $row['t_06'];
        $this->t_07->DbValue = $row['t_07'];
        $this->t_08->DbValue = $row['t_08'];
        $this->t_09->DbValue = $row['t_09'];
        $this->t_10->DbValue = $row['t_10'];
        $this->t_11->DbValue = $row['t_11'];
        $this->t_12->DbValue = $row['t_12'];
        $this->t_13->DbValue = $row['t_13'];
        $this->t_14->DbValue = $row['t_14'];
        $this->t_15->DbValue = $row['t_15'];
        $this->last_price->DbValue = $row['last_price'];
        $this->currency->DbValue = $row['currency'];
        $this->hsn->DbValue = $row['hsn'];
        $this->composition->DbValue = $row['composition'];
        $this->category->DbValue = $row['category'];
        $this->moq->DbValue = $row['moq'];
        $this->status->DbValue = $row['status'];
        $this->d_head_01->DbValue = $row['d_head_01'];
        $this->d_description_01->DbValue = $row['d_description_01'];
        $this->d_head_02->DbValue = $row['d_head_02'];
        $this->d_description_02->DbValue = $row['d_description_02'];
        $this->publish->DbValue = $row['publish'];
        $this->keywords->DbValue = $row['keywords'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->top_view->Upload->DbValue = $row['top_view'];
        $this->front_view->Upload->DbValue = $row['front_view'];
        $this->corner_view->Upload->DbValue = $row['corner_view'];
        $this->back_view->Upload->DbValue = $row['back_view'];
        $this->color_options->Upload->DbValue = $row['color_options'];
        $this->other_options->Upload->DbValue = $row['other_options'];
        $this->group_image->Upload->DbValue = $row['group_image'];
        $this->video_url->DbValue = $row['video_url'];
        $this->image->Upload->DbValue = $row['image'];
        $this->in->DbValue = $row['in'];
        $this->out->DbValue = $row['out'];
        $this->required->DbValue = $row['required'];
        $this->blocked->DbValue = $row['blocked'];
        $this->ordered->DbValue = $row['ordered'];
        $this->supplier->DbValue = $row['supplier'];
        $this->country->DbValue = $row['country'];
        $this->minimum_stock->DbValue = $row['minimum_stock'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['main_image']) ? [] : [$row['main_image']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->main_image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->main_image->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->top_view->OldUploadPath = $this->top_view->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['top_view']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['top_view']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->top_view->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->top_view->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->front_view->OldUploadPath = $this->front_view->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['front_view']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['front_view']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->front_view->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->front_view->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->corner_view->OldUploadPath = $this->corner_view->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['corner_view']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['corner_view']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->corner_view->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->corner_view->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->back_view->OldUploadPath = $this->back_view->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['back_view']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['back_view']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->back_view->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->back_view->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->color_options->OldUploadPath = $this->color_options->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['color_options']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['color_options']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->color_options->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->color_options->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->other_options->OldUploadPath = $this->other_options->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['other_options']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['other_options']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->other_options->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->other_options->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->group_image->OldUploadPath = $this->group_image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['group_image']) ? [] : [$row['group_image']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->group_image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->group_image->oldPhysicalUploadPath() . $oldFile);
            }
        }
        $this->image->OldUploadPath = $this->image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['image']) ? [] : explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $row['image']);
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->image->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("reflist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "refview" => $Language->phrase("View"),
            "refedit" => $Language->phrase("Edit"),
            "refadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "reflist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "RefView",
            Config("API_ADD_ACTION") => "RefAdd",
            Config("API_EDIT_ACTION") => "RefEdit",
            Config("API_DELETE_ACTION") => "RefDelete",
            Config("API_LIST_ACTION") => "RefList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "reflist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("refview", $parm);
        } else {
            $url = $this->keyUrl("refview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "refadd?" . $parm;
        } else {
            $url = "refadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("refedit", $parm);
        } else {
            $url = $this->keyUrl("refedit", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("reflist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("refadd", $parm);
        } else {
            $url = $this->keyUrl("refadd", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("reflist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("refdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->oid->setDbValue($row['oid']);
        $this->company_id->setDbValue($row['company_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->product_type->setDbValue($row['product_type']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->product_n->setDbValue($row['product_n']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->product_code_type->setDbValue($row['product_code_type']);
        $this->product_code->setDbValue($row['product_code']);
        $this->print_name->setDbValue($row['print_name']);
        $this->gcode->setDbValue($row['gcode']);
        $this->code->setDbValue($row['code']);
        $this->product_id->setDbValue($row['product_id']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->set_ref->setDbValue($row['set_ref']);
        $this->v_00->setDbValue($row['v_00']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_05->setDbValue($row['v_05']);
        $this->v_06->setDbValue($row['v_06']);
        $this->v_07->setDbValue($row['v_07']);
        $this->v_08->setDbValue($row['v_08']);
        $this->v_09->setDbValue($row['v_09']);
        $this->v_10->setDbValue($row['v_10']);
        $this->cbm->setDbValue($row['cbm']);
        $this->sqm->setDbValue($row['sqm']);
        $this->shape->setDbValue($row['shape']);
        $this->q_sku->setDbValue($row['q_sku']);
        $this->b_01->setDbValue($row['b_01']);
        $this->b_02->setDbValue($row['b_02']);
        $this->b_03->setDbValue($row['b_03']);
        $this->b_04->setDbValue($row['b_04']);
        $this->b_05->setDbValue($row['b_05']);
        $this->b_06->setDbValue($row['b_06']);
        $this->b_07->setDbValue($row['b_07']);
        $this->b_08->setDbValue($row['b_08']);
        $this->b_09->setDbValue($row['b_09']);
        $this->b_10->setDbValue($row['b_10']);
        $this->b_11->setDbValue($row['b_11']);
        $this->b_12->setDbValue($row['b_12']);
        $this->b_13->setDbValue($row['b_13']);
        $this->b_14->setDbValue($row['b_14']);
        $this->b_15->setDbValue($row['b_15']);
        $this->t_01->setDbValue($row['t_01']);
        $this->t_02->setDbValue($row['t_02']);
        $this->t_03->setDbValue($row['t_03']);
        $this->t_04->setDbValue($row['t_04']);
        $this->t_05->setDbValue($row['t_05']);
        $this->t_06->setDbValue($row['t_06']);
        $this->t_07->setDbValue($row['t_07']);
        $this->t_08->setDbValue($row['t_08']);
        $this->t_09->setDbValue($row['t_09']);
        $this->t_10->setDbValue($row['t_10']);
        $this->t_11->setDbValue($row['t_11']);
        $this->t_12->setDbValue($row['t_12']);
        $this->t_13->setDbValue($row['t_13']);
        $this->t_14->setDbValue($row['t_14']);
        $this->t_15->setDbValue($row['t_15']);
        $this->last_price->setDbValue($row['last_price']);
        $this->currency->setDbValue($row['currency']);
        $this->hsn->setDbValue($row['hsn']);
        $this->composition->setDbValue($row['composition']);
        $this->category->setDbValue($row['category']);
        $this->moq->setDbValue($row['moq']);
        $this->status->setDbValue($row['status']);
        $this->d_head_01->setDbValue($row['d_head_01']);
        $this->d_description_01->setDbValue($row['d_description_01']);
        $this->d_head_02->setDbValue($row['d_head_02']);
        $this->d_description_02->setDbValue($row['d_description_02']);
        $this->publish->setDbValue($row['publish']);
        $this->keywords->setDbValue($row['keywords']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->top_view->Upload->DbValue = $row['top_view'];
        $this->front_view->Upload->DbValue = $row['front_view'];
        $this->corner_view->Upload->DbValue = $row['corner_view'];
        $this->back_view->Upload->DbValue = $row['back_view'];
        $this->color_options->Upload->DbValue = $row['color_options'];
        $this->other_options->Upload->DbValue = $row['other_options'];
        $this->group_image->Upload->DbValue = $row['group_image'];
        $this->video_url->setDbValue($row['video_url']);
        $this->image->Upload->DbValue = $row['image'];
        $this->in->setDbValue($row['in']);
        $this->out->setDbValue($row['out']);
        $this->required->setDbValue($row['required']);
        $this->blocked->setDbValue($row['blocked']);
        $this->ordered->setDbValue($row['ordered']);
        $this->supplier->setDbValue($row['supplier']);
        $this->country->setDbValue($row['country']);
        $this->minimum_stock->setDbValue($row['minimum_stock']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "RefList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // oid
        $this->oid->CellCssStyle = "white-space: nowrap;";

        // company_id

        // grp

        // s_grp

        // product

        // product_type

        // packing_type

        // product_n

        // barcode

        // product_code_type

        // product_code

        // print_name
        $this->print_name->CellCssStyle = "white-space: nowrap;";

        // gcode
        $this->gcode->CellCssStyle = "white-space: nowrap;";

        // code
        $this->code->CellCssStyle = "white-space: nowrap;";

        // product_id
        $this->product_id->CellCssStyle = "white-space: nowrap;";

        // batch_no
        $this->batch_no->CellCssStyle = "white-space: nowrap;";

        // set_ref
        $this->set_ref->CellCssStyle = "white-space: nowrap;";

        // v_00

        // v_01

        // v_02

        // v_03

        // v_04

        // v_05

        // v_06

        // v_07

        // v_08

        // v_09

        // v_10

        // cbm

        // sqm

        // shape

        // q_sku

        // b_01

        // b_02

        // b_03

        // b_04

        // b_05

        // b_06

        // b_07

        // b_08

        // b_09

        // b_10

        // b_11

        // b_12

        // b_13

        // b_14

        // b_15

        // t_01

        // t_02

        // t_03

        // t_04

        // t_05

        // t_06

        // t_07

        // t_08

        // t_09

        // t_10

        // t_11

        // t_12

        // t_13

        // t_14

        // t_15

        // last_price

        // currency

        // hsn

        // composition

        // category

        // moq
        $this->moq->CellCssStyle = "white-space: nowrap;";

        // status

        // d_head_01

        // d_description_01

        // d_head_02

        // d_description_02

        // publish

        // keywords

        // operator

        // datetime

        // main_image
        $this->main_image->CellCssStyle = "white-space: nowrap;";

        // top_view
        $this->top_view->CellCssStyle = "white-space: nowrap;";

        // front_view
        $this->front_view->CellCssStyle = "white-space: nowrap;";

        // corner_view
        $this->corner_view->CellCssStyle = "white-space: nowrap;";

        // back_view
        $this->back_view->CellCssStyle = "white-space: nowrap;";

        // color_options
        $this->color_options->CellCssStyle = "white-space: nowrap;";

        // other_options
        $this->other_options->CellCssStyle = "white-space: nowrap;";

        // group_image
        $this->group_image->CellCssStyle = "white-space: nowrap;";

        // video_url
        $this->video_url->CellCssStyle = "white-space: nowrap;";

        // image
        $this->image->CellCssStyle = "white-space: nowrap;";

        // in
        $this->in->CellCssStyle = "white-space: nowrap;";

        // out
        $this->out->CellCssStyle = "white-space: nowrap;";

        // required
        $this->required->CellCssStyle = "white-space: nowrap;";

        // blocked
        $this->blocked->CellCssStyle = "white-space: nowrap;";

        // ordered
        $this->ordered->CellCssStyle = "white-space: nowrap;";

        // supplier
        $this->supplier->CellCssStyle = "white-space: nowrap;";

        // country
        $this->country->CellCssStyle = "white-space: nowrap;";

        // minimum_stock
        $this->minimum_stock->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // oid
        $this->oid->ViewValue = $this->oid->CurrentValue;

        // company_id
        $curVal = strval($this->company_id->CurrentValue);
        if ($curVal != "") {
            $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            if ($this->company_id->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->company_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->company_id->Lookup->renderViewRow($row);
                        $this->company_id->ViewValue->add($this->company_id->displayValue($arwrk));
                    }
                } else {
                    $this->company_id->ViewValue = $this->company_id->CurrentValue;
                }
            }
        } else {
            $this->company_id->ViewValue = null;
        }

        // grp
        $curVal = strval($this->grp->CurrentValue);
        if ($curVal != "") {
            $this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
            if ($this->grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->grp->Lookup->renderViewRow($rswrk[0]);
                    $this->grp->ViewValue = $this->grp->displayValue($arwrk);
                } else {
                    $this->grp->ViewValue = FormatNumber($this->grp->CurrentValue, $this->grp->formatPattern());
                }
            }
        } else {
            $this->grp->ViewValue = null;
        }

        // s_grp
        $curVal = strval($this->s_grp->CurrentValue);
        if ($curVal != "") {
            $this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
            if ($this->s_grp->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->s_grp->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->s_grp->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->s_grp->getSelectFilter($this); // PHP
                $sqlWrk = $this->s_grp->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->s_grp->Lookup->renderViewRow($rswrk[0]);
                    $this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
                } else {
                    $this->s_grp->ViewValue = $this->s_grp->CurrentValue;
                }
            }
        } else {
            $this->s_grp->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product->getSelectFilter($this); // PHP
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // product_type
        $curVal = strval($this->product_type->CurrentValue);
        if ($curVal != "") {
            $this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
            if ($this->product_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->product_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->product_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product_type->Lookup->renderViewRow($rswrk[0]);
                    $this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
                } else {
                    $this->product_type->ViewValue = $this->product_type->CurrentValue;
                }
            }
        } else {
            $this->product_type->ViewValue = null;
        }

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = FormatNumber($this->packing_type->CurrentValue, $this->packing_type->formatPattern());
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // product_n
        $this->product_n->ViewValue = $this->product_n->CurrentValue;

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // product_code_type
        if (strval($this->product_code_type->CurrentValue) != "") {
            $this->product_code_type->ViewValue = $this->product_code_type->optionCaption($this->product_code_type->CurrentValue);
        } else {
            $this->product_code_type->ViewValue = null;
        }

        // product_code
        $this->product_code->ViewValue = $this->product_code->CurrentValue;

        // print_name
        $this->print_name->ViewValue = $this->print_name->CurrentValue;

        // gcode
        $this->gcode->ViewValue = $this->gcode->CurrentValue;

        // code
        $this->code->ViewValue = $this->code->CurrentValue;

        // product_id
        $this->product_id->ViewValue = $this->product_id->CurrentValue;

        // batch_no
        $this->batch_no->ViewValue = $this->batch_no->CurrentValue;

        // set_ref
        $curVal = strval($this->set_ref->CurrentValue);
        if ($curVal != "") {
            $this->set_ref->ViewValue = $this->set_ref->lookupCacheOption($curVal);
            if ($this->set_ref->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->set_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->set_ref->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->set_ref->getSelectFilter($this); // PHP
                $sqlWrk = $this->set_ref->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->set_ref->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->set_ref->Lookup->renderViewRow($row);
                        $this->set_ref->ViewValue->add($this->set_ref->displayValue($arwrk));
                    }
                } else {
                    $this->set_ref->ViewValue = $this->set_ref->CurrentValue;
                }
            }
        } else {
            $this->set_ref->ViewValue = null;
        }

        // v_00
        $this->v_00->ViewValue = $this->v_00->CurrentValue;

        // v_01
        $curVal = strval($this->v_01->CurrentValue);
        if ($curVal != "") {
            $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
            if ($this->v_01->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_01->Lookup->renderViewRow($rswrk[0]);
                    $this->v_01->ViewValue = $this->v_01->displayValue($arwrk);
                } else {
                    $this->v_01->ViewValue = $this->v_01->CurrentValue;
                }
            }
        } else {
            $this->v_01->ViewValue = null;
        }

        // v_02
        $curVal = strval($this->v_02->CurrentValue);
        if ($curVal != "") {
            $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
            if ($this->v_02->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_02->Lookup->renderViewRow($rswrk[0]);
                    $this->v_02->ViewValue = $this->v_02->displayValue($arwrk);
                } else {
                    $this->v_02->ViewValue = $this->v_02->CurrentValue;
                }
            }
        } else {
            $this->v_02->ViewValue = null;
        }

        // v_03
        $curVal = strval($this->v_03->CurrentValue);
        if ($curVal != "") {
            $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
            if ($this->v_03->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_03->Lookup->renderViewRow($rswrk[0]);
                    $this->v_03->ViewValue = $this->v_03->displayValue($arwrk);
                } else {
                    $this->v_03->ViewValue = $this->v_03->CurrentValue;
                }
            }
        } else {
            $this->v_03->ViewValue = null;
        }

        // v_04
        $curVal = strval($this->v_04->CurrentValue);
        if ($curVal != "") {
            $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
            if ($this->v_04->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_04->Lookup->renderViewRow($rswrk[0]);
                    $this->v_04->ViewValue = $this->v_04->displayValue($arwrk);
                } else {
                    $this->v_04->ViewValue = $this->v_04->CurrentValue;
                }
            }
        } else {
            $this->v_04->ViewValue = null;
        }

        // v_05
        $curVal = strval($this->v_05->CurrentValue);
        if ($curVal != "") {
            $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
            if ($this->v_05->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_05->Lookup->renderViewRow($rswrk[0]);
                    $this->v_05->ViewValue = $this->v_05->displayValue($arwrk);
                } else {
                    $this->v_05->ViewValue = $this->v_05->CurrentValue;
                }
            }
        } else {
            $this->v_05->ViewValue = null;
        }

        // v_06
        $curVal = strval($this->v_06->CurrentValue);
        if ($curVal != "") {
            $this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
            if ($this->v_06->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_06->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_06->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_06->Lookup->renderViewRow($rswrk[0]);
                    $this->v_06->ViewValue = $this->v_06->displayValue($arwrk);
                } else {
                    $this->v_06->ViewValue = $this->v_06->CurrentValue;
                }
            }
        } else {
            $this->v_06->ViewValue = null;
        }

        // v_07
        $curVal = strval($this->v_07->CurrentValue);
        if ($curVal != "") {
            $this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
            if ($this->v_07->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_07->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_07->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_07->Lookup->renderViewRow($rswrk[0]);
                    $this->v_07->ViewValue = $this->v_07->displayValue($arwrk);
                } else {
                    $this->v_07->ViewValue = $this->v_07->CurrentValue;
                }
            }
        } else {
            $this->v_07->ViewValue = null;
        }

        // v_08
        $curVal = strval($this->v_08->CurrentValue);
        if ($curVal != "") {
            $this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
            if ($this->v_08->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_08->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_08->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_08->Lookup->renderViewRow($rswrk[0]);
                    $this->v_08->ViewValue = $this->v_08->displayValue($arwrk);
                } else {
                    $this->v_08->ViewValue = $this->v_08->CurrentValue;
                }
            }
        } else {
            $this->v_08->ViewValue = null;
        }

        // v_09
        $curVal = strval($this->v_09->CurrentValue);
        if ($curVal != "") {
            $this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
            if ($this->v_09->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_09->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_09->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_09->Lookup->renderViewRow($rswrk[0]);
                    $this->v_09->ViewValue = $this->v_09->displayValue($arwrk);
                } else {
                    $this->v_09->ViewValue = $this->v_09->CurrentValue;
                }
            }
        } else {
            $this->v_09->ViewValue = null;
        }

        // v_10
        $curVal = strval($this->v_10->CurrentValue);
        if ($curVal != "") {
            $this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
            if ($this->v_10->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->v_10->Lookup->getTable()->Fields["code"]->searchExpression(), "=", $curVal, $this->v_10->Lookup->getTable()->Fields["code"]->searchDataType(), "");
                $lookupFilter = $this->v_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->v_10->Lookup->renderViewRow($rswrk[0]);
                    $this->v_10->ViewValue = $this->v_10->displayValue($arwrk);
                } else {
                    $this->v_10->ViewValue = $this->v_10->CurrentValue;
                }
            }
        } else {
            $this->v_10->ViewValue = null;
        }

        // cbm
        $this->cbm->ViewValue = $this->cbm->CurrentValue;
        $this->cbm->ViewValue = FormatNumber($this->cbm->ViewValue, $this->cbm->formatPattern());

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // shape
        $curVal = strval($this->shape->CurrentValue);
        if ($curVal != "") {
            $this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
            if ($this->shape->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->shape->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->shape->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->shape->getSelectFilter($this); // PHP
                $sqlWrk = $this->shape->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->shape->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->shape->Lookup->renderViewRow($row);
                        $this->shape->ViewValue->add($this->shape->displayValue($arwrk));
                    }
                } else {
                    $this->shape->ViewValue = $this->shape->CurrentValue;
                }
            }
        } else {
            $this->shape->ViewValue = null;
        }

        // q_sku
        $this->q_sku->ViewValue = $this->q_sku->CurrentValue;
        $this->q_sku->ViewValue = FormatNumber($this->q_sku->ViewValue, $this->q_sku->formatPattern());

        // b_01
        $this->b_01->ViewValue = $this->b_01->CurrentValue;

        // b_02
        $this->b_02->ViewValue = $this->b_02->CurrentValue;

        // b_03
        $curVal = strval($this->b_03->CurrentValue);
        if ($curVal != "") {
            $this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
            if ($this->b_03->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_03->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_03->Lookup->renderViewRow($row);
                        $this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
                    }
                } else {
                    $this->b_03->ViewValue = $this->b_03->CurrentValue;
                }
            }
        } else {
            $this->b_03->ViewValue = null;
        }

        // b_04
        $curVal = strval($this->b_04->CurrentValue);
        if ($curVal != "") {
            $this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
            if ($this->b_04->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_04->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_04->Lookup->renderViewRow($row);
                        $this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
                    }
                } else {
                    $this->b_04->ViewValue = $this->b_04->CurrentValue;
                }
            }
        } else {
            $this->b_04->ViewValue = null;
        }

        // b_05
        $curVal = strval($this->b_05->CurrentValue);
        if ($curVal != "") {
            $this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
            if ($this->b_05->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_05->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_05->Lookup->renderViewRow($row);
                        $this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
                    }
                } else {
                    $this->b_05->ViewValue = $this->b_05->CurrentValue;
                }
            }
        } else {
            $this->b_05->ViewValue = null;
        }

        // b_06
        $curVal = strval($this->b_06->CurrentValue);
        if ($curVal != "") {
            $this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
            if ($this->b_06->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_06->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_06->Lookup->renderViewRow($row);
                        $this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
                    }
                } else {
                    $this->b_06->ViewValue = $this->b_06->CurrentValue;
                }
            }
        } else {
            $this->b_06->ViewValue = null;
        }

        // b_07
        $curVal = strval($this->b_07->CurrentValue);
        if ($curVal != "") {
            $this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
            if ($this->b_07->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_07->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_07->Lookup->renderViewRow($row);
                        $this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
                    }
                } else {
                    $this->b_07->ViewValue = $this->b_07->CurrentValue;
                }
            }
        } else {
            $this->b_07->ViewValue = null;
        }

        // b_08
        $curVal = strval($this->b_08->CurrentValue);
        if ($curVal != "") {
            $this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
            if ($this->b_08->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_08->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_08->Lookup->renderViewRow($row);
                        $this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
                    }
                } else {
                    $this->b_08->ViewValue = $this->b_08->CurrentValue;
                }
            }
        } else {
            $this->b_08->ViewValue = null;
        }

        // b_09
        $curVal = strval($this->b_09->CurrentValue);
        if ($curVal != "") {
            $this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
            if ($this->b_09->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_09->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_09->Lookup->renderViewRow($row);
                        $this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
                    }
                } else {
                    $this->b_09->ViewValue = $this->b_09->CurrentValue;
                }
            }
        } else {
            $this->b_09->ViewValue = null;
        }

        // b_10
        $curVal = strval($this->b_10->CurrentValue);
        if ($curVal != "") {
            $this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
            if ($this->b_10->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->b_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->b_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->b_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->b_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->b_10->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->b_10->Lookup->renderViewRow($row);
                        $this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
                    }
                } else {
                    $this->b_10->ViewValue = $this->b_10->CurrentValue;
                }
            }
        } else {
            $this->b_10->ViewValue = null;
        }

        // b_11
        $this->b_11->ViewValue = $this->b_11->CurrentValue;

        // b_12
        $this->b_12->ViewValue = $this->b_12->CurrentValue;

        // b_13
        $this->b_13->ViewValue = $this->b_13->CurrentValue;

        // b_14
        $this->b_14->ViewValue = $this->b_14->CurrentValue;

        // b_15
        $this->b_15->ViewValue = $this->b_15->CurrentValue;

        // t_01
        $this->t_01->ViewValue = $this->t_01->CurrentValue;

        // t_02
        $this->t_02->ViewValue = $this->t_02->CurrentValue;

        // t_03
        $curVal = strval($this->t_03->CurrentValue);
        if ($curVal != "") {
            $this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
            if ($this->t_03->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_03->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_03->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_03->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_03->Lookup->renderViewRow($row);
                        $this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
                    }
                } else {
                    $this->t_03->ViewValue = $this->t_03->CurrentValue;
                }
            }
        } else {
            $this->t_03->ViewValue = null;
        }

        // t_04
        $curVal = strval($this->t_04->CurrentValue);
        if ($curVal != "") {
            $this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
            if ($this->t_04->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_04->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_04->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_04->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_04->Lookup->renderViewRow($row);
                        $this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
                    }
                } else {
                    $this->t_04->ViewValue = $this->t_04->CurrentValue;
                }
            }
        } else {
            $this->t_04->ViewValue = null;
        }

        // t_05
        $curVal = strval($this->t_05->CurrentValue);
        if ($curVal != "") {
            $this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
            if ($this->t_05->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_05->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_05->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_05->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_05->Lookup->renderViewRow($row);
                        $this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
                    }
                } else {
                    $this->t_05->ViewValue = $this->t_05->CurrentValue;
                }
            }
        } else {
            $this->t_05->ViewValue = null;
        }

        // t_06
        $curVal = strval($this->t_06->CurrentValue);
        if ($curVal != "") {
            $this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
            if ($this->t_06->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_06->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_06->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_06->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_06->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_06->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_06->Lookup->renderViewRow($row);
                        $this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
                    }
                } else {
                    $this->t_06->ViewValue = $this->t_06->CurrentValue;
                }
            }
        } else {
            $this->t_06->ViewValue = null;
        }

        // t_07
        $curVal = strval($this->t_07->CurrentValue);
        if ($curVal != "") {
            $this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
            if ($this->t_07->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_07->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_07->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_07->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_07->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_07->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_07->Lookup->renderViewRow($row);
                        $this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
                    }
                } else {
                    $this->t_07->ViewValue = $this->t_07->CurrentValue;
                }
            }
        } else {
            $this->t_07->ViewValue = null;
        }

        // t_08
        $curVal = strval($this->t_08->CurrentValue);
        if ($curVal != "") {
            $this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
            if ($this->t_08->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_08->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_08->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_08->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_08->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_08->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_08->Lookup->renderViewRow($row);
                        $this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
                    }
                } else {
                    $this->t_08->ViewValue = $this->t_08->CurrentValue;
                }
            }
        } else {
            $this->t_08->ViewValue = null;
        }

        // t_09
        $curVal = strval($this->t_09->CurrentValue);
        if ($curVal != "") {
            $this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
            if ($this->t_09->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_09->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_09->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_09->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_09->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_09->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_09->Lookup->renderViewRow($row);
                        $this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
                    }
                } else {
                    $this->t_09->ViewValue = $this->t_09->CurrentValue;
                }
            }
        } else {
            $this->t_09->ViewValue = null;
        }

        // t_10
        $curVal = strval($this->t_10->CurrentValue);
        if ($curVal != "") {
            $this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
            if ($this->t_10->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->t_10->Lookup->getTable()->Fields["name"]->searchExpression(), "=", trim($wrk), $this->t_10->Lookup->getTable()->Fields["name"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->t_10->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_10->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->t_10->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->t_10->Lookup->renderViewRow($row);
                        $this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
                    }
                } else {
                    $this->t_10->ViewValue = $this->t_10->CurrentValue;
                }
            }
        } else {
            $this->t_10->ViewValue = null;
        }

        // t_11
        $this->t_11->ViewValue = $this->t_11->CurrentValue;
        $curVal = strval($this->t_11->CurrentValue);
        if ($curVal != "") {
            $this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
            if ($this->t_11->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->t_11->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_11->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->t_11->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_11->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->t_11->Lookup->renderViewRow($rswrk[0]);
                    $this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
                } else {
                    $this->t_11->ViewValue = $this->t_11->CurrentValue;
                }
            }
        } else {
            $this->t_11->ViewValue = null;
        }

        // t_12
        $this->t_12->ViewValue = $this->t_12->CurrentValue;
        $curVal = strval($this->t_12->CurrentValue);
        if ($curVal != "") {
            $this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
            if ($this->t_12->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->t_12->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->t_12->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->t_12->getSelectFilter($this); // PHP
                $sqlWrk = $this->t_12->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->t_12->Lookup->renderViewRow($rswrk[0]);
                    $this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
                } else {
                    $this->t_12->ViewValue = $this->t_12->CurrentValue;
                }
            }
        } else {
            $this->t_12->ViewValue = null;
        }

        // t_13
        $this->t_13->ViewValue = $this->t_13->CurrentValue;

        // t_14
        $this->t_14->ViewValue = $this->t_14->CurrentValue;

        // t_15
        $this->t_15->ViewValue = $this->t_15->CurrentValue;

        // last_price
        $this->last_price->ViewValue = $this->last_price->CurrentValue;

        // currency
        $curVal = strval($this->currency->CurrentValue);
        if ($curVal != "") {
            $this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
            if ($this->currency->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->currency->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->currency->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->currency->getSelectFilter($this); // PHP
                $sqlWrk = $this->currency->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->currency->Lookup->renderViewRow($rswrk[0]);
                    $this->currency->ViewValue = $this->currency->displayValue($arwrk);
                } else {
                    $this->currency->ViewValue = FormatNumber($this->currency->CurrentValue, $this->currency->formatPattern());
                }
            }
        } else {
            $this->currency->ViewValue = null;
        }

        // hsn
        $curVal = strval($this->hsn->CurrentValue);
        if ($curVal != "") {
            $this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
            if ($this->hsn->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->hsn->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->hsn->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->hsn->getSelectFilter($this); // PHP
                $sqlWrk = $this->hsn->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->hsn->Lookup->renderViewRow($rswrk[0]);
                    $this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
                } else {
                    $this->hsn->ViewValue = FormatNumber($this->hsn->CurrentValue, $this->hsn->formatPattern());
                }
            }
        } else {
            $this->hsn->ViewValue = null;
        }

        // composition
        $curVal = strval($this->composition->CurrentValue);
        if ($curVal != "") {
            $this->composition->ViewValue = $this->composition->lookupCacheOption($curVal);
            if ($this->composition->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->composition->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->composition->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->composition->getSelectFilter($this); // PHP
                $sqlWrk = $this->composition->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->composition->Lookup->renderViewRow($rswrk[0]);
                    $this->composition->ViewValue = $this->composition->displayValue($arwrk);
                } else {
                    $this->composition->ViewValue = FormatNumber($this->composition->CurrentValue, $this->composition->formatPattern());
                }
            }
        } else {
            $this->composition->ViewValue = null;
        }

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = FormatNumber($this->category->CurrentValue, $this->category->formatPattern());
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // moq
        $this->moq->ViewValue = $this->moq->CurrentValue;
        $this->moq->ViewValue = FormatNumber($this->moq->ViewValue, $this->moq->formatPattern());

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }

        // d_head_01
        $this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;

        // d_description_01
        $this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;

        // d_head_02
        $this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;

        // d_description_02
        $this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;

        // publish
        if (strval($this->publish->CurrentValue) != "") {
            $this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
        } else {
            $this->publish->ViewValue = null;
        }

        // keywords
        $this->keywords->ViewValue = $this->keywords->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // main_image
        $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
        if (!EmptyValue($this->main_image->Upload->DbValue)) {
            $this->main_image->ImageWidth = 0;
            $this->main_image->ImageHeight = 40;
            $this->main_image->ImageAlt = $this->main_image->alt();
            $this->main_image->ImageCssClass = "ew-image";
            $this->main_image->ViewValue = $this->main_image->Upload->DbValue;
        } else {
            $this->main_image->ViewValue = "";
        }

        // top_view
        $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
        if (!EmptyValue($this->top_view->Upload->DbValue)) {
            $this->top_view->ImageWidth = 0;
            $this->top_view->ImageHeight = 40;
            $this->top_view->ImageAlt = $this->top_view->alt();
            $this->top_view->ImageCssClass = "ew-image";
            $this->top_view->ViewValue = $this->top_view->Upload->DbValue;
        } else {
            $this->top_view->ViewValue = "";
        }

        // front_view
        $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
        if (!EmptyValue($this->front_view->Upload->DbValue)) {
            $this->front_view->ImageWidth = 0;
            $this->front_view->ImageHeight = 40;
            $this->front_view->ImageAlt = $this->front_view->alt();
            $this->front_view->ImageCssClass = "ew-image";
            $this->front_view->ViewValue = $this->front_view->Upload->DbValue;
        } else {
            $this->front_view->ViewValue = "";
        }

        // corner_view
        $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
        if (!EmptyValue($this->corner_view->Upload->DbValue)) {
            $this->corner_view->ImageWidth = 0;
            $this->corner_view->ImageHeight = 40;
            $this->corner_view->ImageAlt = $this->corner_view->alt();
            $this->corner_view->ImageCssClass = "ew-image";
            $this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
        } else {
            $this->corner_view->ViewValue = "";
        }

        // back_view
        $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
        if (!EmptyValue($this->back_view->Upload->DbValue)) {
            $this->back_view->ImageWidth = 0;
            $this->back_view->ImageHeight = 40;
            $this->back_view->ImageAlt = $this->back_view->alt();
            $this->back_view->ImageCssClass = "ew-image";
            $this->back_view->ViewValue = $this->back_view->Upload->DbValue;
        } else {
            $this->back_view->ViewValue = "";
        }

        // color_options
        $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
        if (!EmptyValue($this->color_options->Upload->DbValue)) {
            $this->color_options->ImageWidth = 0;
            $this->color_options->ImageHeight = 40;
            $this->color_options->ImageAlt = $this->color_options->alt();
            $this->color_options->ImageCssClass = "ew-image";
            $this->color_options->ViewValue = $this->color_options->Upload->DbValue;
        } else {
            $this->color_options->ViewValue = "";
        }

        // other_options
        $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
        if (!EmptyValue($this->other_options->Upload->DbValue)) {
            $this->other_options->ImageWidth = 0;
            $this->other_options->ImageHeight = 40;
            $this->other_options->ImageAlt = $this->other_options->alt();
            $this->other_options->ImageCssClass = "ew-image";
            $this->other_options->ViewValue = $this->other_options->Upload->DbValue;
        } else {
            $this->other_options->ViewValue = "";
        }

        // group_image
        $this->group_image->UploadPath = $this->group_image->getUploadPath(); // PHP
        if (!EmptyValue($this->group_image->Upload->DbValue)) {
            $this->group_image->ViewValue = $this->group_image->Upload->DbValue;
        } else {
            $this->group_image->ViewValue = "";
        }

        // video_url
        $this->video_url->ViewValue = $this->video_url->CurrentValue;

        // image
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->ImageWidth = 0;
            $this->image->ImageHeight = 50;
            $this->image->ImageAlt = $this->image->alt();
            $this->image->ImageCssClass = "ew-image";
            $this->image->ViewValue = $this->image->Upload->DbValue;
        } else {
            $this->image->ViewValue = "";
        }

        // in
        $this->in->ViewValue = $this->in->CurrentValue;
        $this->in->ViewValue = FormatNumber($this->in->ViewValue, $this->in->formatPattern());

        // out
        $this->out->ViewValue = $this->out->CurrentValue;
        $this->out->ViewValue = FormatNumber($this->out->ViewValue, $this->out->formatPattern());

        // required
        $this->required->ViewValue = $this->required->CurrentValue;
        $this->required->ViewValue = FormatNumber($this->required->ViewValue, $this->required->formatPattern());

        // blocked
        $this->blocked->ViewValue = $this->blocked->CurrentValue;
        $this->blocked->ViewValue = FormatNumber($this->blocked->ViewValue, $this->blocked->formatPattern());

        // ordered
        $this->ordered->ViewValue = $this->ordered->CurrentValue;
        $this->ordered->ViewValue = FormatNumber($this->ordered->ViewValue, $this->ordered->formatPattern());

        // supplier
        $this->supplier->ViewValue = $this->supplier->CurrentValue;

        // country
        $this->country->ViewValue = $this->country->CurrentValue;

        // minimum_stock
        $this->minimum_stock->ViewValue = $this->minimum_stock->CurrentValue;
        $this->minimum_stock->ViewValue = FormatNumber($this->minimum_stock->ViewValue, $this->minimum_stock->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // oid
        $this->oid->HrefValue = "";
        $this->oid->TooltipValue = "";

        // company_id
        $this->company_id->HrefValue = "";
        $this->company_id->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // s_grp
        $this->s_grp->HrefValue = "";
        $this->s_grp->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // product_type
        $this->product_type->HrefValue = "";
        $this->product_type->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // product_n
        $this->product_n->HrefValue = "";
        $this->product_n->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // product_code_type
        $this->product_code_type->HrefValue = "";
        $this->product_code_type->TooltipValue = "";

        // product_code
        $this->product_code->HrefValue = "";
        $this->product_code->TooltipValue = "";

        // print_name
        $this->print_name->HrefValue = "";
        $this->print_name->TooltipValue = "";

        // gcode
        $this->gcode->HrefValue = "";
        $this->gcode->TooltipValue = "";

        // code
        $this->code->HrefValue = "";
        $this->code->TooltipValue = "";

        // product_id
        $this->product_id->HrefValue = "";
        $this->product_id->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // set_ref
        $this->set_ref->HrefValue = "";
        $this->set_ref->TooltipValue = "";

        // v_00
        $this->v_00->HrefValue = "";
        $this->v_00->TooltipValue = "";

        // v_01
        $this->v_01->HrefValue = "";
        $this->v_01->TooltipValue = "";

        // v_02
        $this->v_02->HrefValue = "";
        $this->v_02->TooltipValue = "";

        // v_03
        $this->v_03->HrefValue = "";
        $this->v_03->TooltipValue = "";

        // v_04
        $this->v_04->HrefValue = "";
        $this->v_04->TooltipValue = "";

        // v_05
        $this->v_05->HrefValue = "";
        $this->v_05->TooltipValue = "";

        // v_06
        $this->v_06->HrefValue = "";
        $this->v_06->TooltipValue = "";

        // v_07
        $this->v_07->HrefValue = "";
        $this->v_07->TooltipValue = "";

        // v_08
        $this->v_08->HrefValue = "";
        $this->v_08->TooltipValue = "";

        // v_09
        $this->v_09->HrefValue = "";
        $this->v_09->TooltipValue = "";

        // v_10
        $this->v_10->HrefValue = "";
        $this->v_10->TooltipValue = "";

        // cbm
        $this->cbm->HrefValue = "";
        $this->cbm->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // shape
        $this->shape->HrefValue = "";
        $this->shape->TooltipValue = "";

        // q_sku
        $this->q_sku->HrefValue = "";
        $this->q_sku->TooltipValue = "";

        // b_01
        $this->b_01->HrefValue = "";
        $this->b_01->TooltipValue = "";

        // b_02
        $this->b_02->HrefValue = "";
        $this->b_02->TooltipValue = "";

        // b_03
        $this->b_03->HrefValue = "";
        $this->b_03->TooltipValue = "";

        // b_04
        $this->b_04->HrefValue = "";
        $this->b_04->TooltipValue = "";

        // b_05
        $this->b_05->HrefValue = "";
        $this->b_05->TooltipValue = "";

        // b_06
        $this->b_06->HrefValue = "";
        $this->b_06->TooltipValue = "";

        // b_07
        $this->b_07->HrefValue = "";
        $this->b_07->TooltipValue = "";

        // b_08
        $this->b_08->HrefValue = "";
        $this->b_08->TooltipValue = "";

        // b_09
        $this->b_09->HrefValue = "";
        $this->b_09->TooltipValue = "";

        // b_10
        $this->b_10->HrefValue = "";
        $this->b_10->TooltipValue = "";

        // b_11
        $this->b_11->HrefValue = "";
        $this->b_11->TooltipValue = "";

        // b_12
        $this->b_12->HrefValue = "";
        $this->b_12->TooltipValue = "";

        // b_13
        $this->b_13->HrefValue = "";
        $this->b_13->TooltipValue = "";

        // b_14
        $this->b_14->HrefValue = "";
        $this->b_14->TooltipValue = "";

        // b_15
        $this->b_15->HrefValue = "";
        $this->b_15->TooltipValue = "";

        // t_01
        $this->t_01->HrefValue = "";
        $this->t_01->TooltipValue = "";

        // t_02
        $this->t_02->HrefValue = "";
        $this->t_02->TooltipValue = "";

        // t_03
        $this->t_03->HrefValue = "";
        $this->t_03->TooltipValue = "";

        // t_04
        $this->t_04->HrefValue = "";
        $this->t_04->TooltipValue = "";

        // t_05
        $this->t_05->HrefValue = "";
        $this->t_05->TooltipValue = "";

        // t_06
        $this->t_06->HrefValue = "";
        $this->t_06->TooltipValue = "";

        // t_07
        $this->t_07->HrefValue = "";
        $this->t_07->TooltipValue = "";

        // t_08
        $this->t_08->HrefValue = "";
        $this->t_08->TooltipValue = "";

        // t_09
        $this->t_09->HrefValue = "";
        $this->t_09->TooltipValue = "";

        // t_10
        $this->t_10->HrefValue = "";
        $this->t_10->TooltipValue = "";

        // t_11
        $this->t_11->HrefValue = "";
        $this->t_11->TooltipValue = "";

        // t_12
        $this->t_12->HrefValue = "";
        $this->t_12->TooltipValue = "";

        // t_13
        $this->t_13->HrefValue = "";
        $this->t_13->TooltipValue = "";

        // t_14
        $this->t_14->HrefValue = "";
        $this->t_14->TooltipValue = "";

        // t_15
        $this->t_15->HrefValue = "";
        $this->t_15->TooltipValue = "";

        // last_price
        $this->last_price->HrefValue = "";
        $this->last_price->TooltipValue = "";

        // currency
        $this->currency->HrefValue = "";
        $this->currency->TooltipValue = "";

        // hsn
        $this->hsn->HrefValue = "";
        $this->hsn->TooltipValue = "";

        // composition
        $this->composition->HrefValue = "";
        $this->composition->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // moq
        $this->moq->HrefValue = "";
        $this->moq->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // d_head_01
        $this->d_head_01->HrefValue = "";
        $this->d_head_01->TooltipValue = "";

        // d_description_01
        $this->d_description_01->HrefValue = "";
        $this->d_description_01->TooltipValue = "";

        // d_head_02
        $this->d_head_02->HrefValue = "";
        $this->d_head_02->TooltipValue = "";

        // d_description_02
        $this->d_description_02->HrefValue = "";
        $this->d_description_02->TooltipValue = "";

        // publish
        $this->publish->HrefValue = "";
        $this->publish->TooltipValue = "";

        // keywords
        $this->keywords->HrefValue = "";
        $this->keywords->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // main_image
        $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
        if (!EmptyValue($this->main_image->Upload->DbValue)) {
            $this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->htmlDecode($this->main_image->Upload->DbValue)); // Add prefix/suffix
            $this->main_image->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
            }
        } else {
            $this->main_image->HrefValue = "";
        }
        $this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
        $this->main_image->TooltipValue = "";
        if ($this->main_image->UseColorbox) {
            if (EmptyValue($this->main_image->TooltipValue)) {
                $this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->main_image->LinkAttrs["data-rel"] = "ref_x_main_image";
            $this->main_image->LinkAttrs->appendClass("ew-lightbox");
        }

        // top_view
        $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
        if (!EmptyValue($this->top_view->Upload->DbValue)) {
            $this->top_view->HrefValue = "%u"; // Add prefix/suffix
            $this->top_view->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
            }
        } else {
            $this->top_view->HrefValue = "";
        }
        $this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
        $this->top_view->TooltipValue = "";
        if ($this->top_view->UseColorbox) {
            if (EmptyValue($this->top_view->TooltipValue)) {
                $this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->top_view->LinkAttrs["data-rel"] = "ref_x_top_view";
            $this->top_view->LinkAttrs->appendClass("ew-lightbox");
        }

        // front_view
        $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
        if (!EmptyValue($this->front_view->Upload->DbValue)) {
            $this->front_view->HrefValue = "%u"; // Add prefix/suffix
            $this->front_view->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
            }
        } else {
            $this->front_view->HrefValue = "";
        }
        $this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
        $this->front_view->TooltipValue = "";
        if ($this->front_view->UseColorbox) {
            if (EmptyValue($this->front_view->TooltipValue)) {
                $this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->front_view->LinkAttrs["data-rel"] = "ref_x_front_view";
            $this->front_view->LinkAttrs->appendClass("ew-lightbox");
        }

        // corner_view
        $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
        if (!EmptyValue($this->corner_view->Upload->DbValue)) {
            $this->corner_view->HrefValue = "%u"; // Add prefix/suffix
            $this->corner_view->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
            }
        } else {
            $this->corner_view->HrefValue = "";
        }
        $this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
        $this->corner_view->TooltipValue = "";
        if ($this->corner_view->UseColorbox) {
            if (EmptyValue($this->corner_view->TooltipValue)) {
                $this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->corner_view->LinkAttrs["data-rel"] = "ref_x_corner_view";
            $this->corner_view->LinkAttrs->appendClass("ew-lightbox");
        }

        // back_view
        $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
        if (!EmptyValue($this->back_view->Upload->DbValue)) {
            $this->back_view->HrefValue = "%u"; // Add prefix/suffix
            $this->back_view->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
            }
        } else {
            $this->back_view->HrefValue = "";
        }
        $this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
        $this->back_view->TooltipValue = "";
        if ($this->back_view->UseColorbox) {
            if (EmptyValue($this->back_view->TooltipValue)) {
                $this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->back_view->LinkAttrs["data-rel"] = "ref_x_back_view";
            $this->back_view->LinkAttrs->appendClass("ew-lightbox");
        }

        // color_options
        $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
        if (!EmptyValue($this->color_options->Upload->DbValue)) {
            $this->color_options->HrefValue = "%u"; // Add prefix/suffix
            $this->color_options->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
            }
        } else {
            $this->color_options->HrefValue = "";
        }
        $this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
        $this->color_options->TooltipValue = "";
        if ($this->color_options->UseColorbox) {
            if (EmptyValue($this->color_options->TooltipValue)) {
                $this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->color_options->LinkAttrs["data-rel"] = "ref_x_color_options";
            $this->color_options->LinkAttrs->appendClass("ew-lightbox");
        }

        // other_options
        $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
        if (!EmptyValue($this->other_options->Upload->DbValue)) {
            $this->other_options->HrefValue = "%u"; // Add prefix/suffix
            $this->other_options->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
            }
        } else {
            $this->other_options->HrefValue = "";
        }
        $this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
        $this->other_options->TooltipValue = "";
        if ($this->other_options->UseColorbox) {
            if (EmptyValue($this->other_options->TooltipValue)) {
                $this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->other_options->LinkAttrs["data-rel"] = "ref_x_other_options";
            $this->other_options->LinkAttrs->appendClass("ew-lightbox");
        }

        // group_image
        $this->group_image->HrefValue = "";
        $this->group_image->ExportHrefValue = $this->group_image->UploadPath . $this->group_image->Upload->DbValue;
        $this->group_image->TooltipValue = "";

        // video_url
        $this->video_url->HrefValue = "";
        $this->video_url->TooltipValue = "";

        // image
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->HrefValue = "%u"; // Add prefix/suffix
            $this->image->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
            }
        } else {
            $this->image->HrefValue = "";
        }
        $this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
        $this->image->TooltipValue = "";
        if ($this->image->UseColorbox) {
            if (EmptyValue($this->image->TooltipValue)) {
                $this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->image->LinkAttrs["data-rel"] = "ref_x_image";
            $this->image->LinkAttrs->appendClass("ew-lightbox");
        }

        // in
        $this->in->HrefValue = "";
        $this->in->TooltipValue = "";

        // out
        $this->out->HrefValue = "";
        $this->out->TooltipValue = "";

        // required
        $this->required->HrefValue = "";
        $this->required->TooltipValue = "";

        // blocked
        $this->blocked->HrefValue = "";
        $this->blocked->TooltipValue = "";

        // ordered
        $this->ordered->HrefValue = "";
        $this->ordered->TooltipValue = "";

        // supplier
        if (!EmptyValue($this->supplier->CurrentValue)) {
            $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
            $this->supplier->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
            }
        } else {
            $this->supplier->HrefValue = "";
        }
        $this->supplier->TooltipValue = "";

        // country
        if (!EmptyValue($this->country->CurrentValue)) {
            $this->country->HrefValue = $this->country->getLinkPrefix() . $this->country->CurrentValue; // Add prefix/suffix
            $this->country->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->country->HrefValue = FullUrl($this->country->HrefValue, "href");
            }
        } else {
            $this->country->HrefValue = "";
        }
        $this->country->TooltipValue = "";

        // minimum_stock
        $this->minimum_stock->HrefValue = "";
        $this->minimum_stock->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // oid
        $this->oid->setupEditAttributes();
        if (!$this->oid->Raw) {
            $this->oid->CurrentValue = HtmlDecode($this->oid->CurrentValue);
        }
        $this->oid->EditValue = $this->oid->CurrentValue;
        $this->oid->PlaceHolder = RemoveHtml($this->oid->caption());

        // company_id
        $this->company_id->setupEditAttributes();
        $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

        // s_grp
        $this->s_grp->setupEditAttributes();
        $this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // product_type
        $this->product_type->setupEditAttributes();
        $this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // product_n
        $this->product_n->setupEditAttributes();
        if (!$this->product_n->Raw) {
            $this->product_n->CurrentValue = HtmlDecode($this->product_n->CurrentValue);
        }
        $this->product_n->EditValue = $this->product_n->CurrentValue;
        $this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

        // barcode
        $this->_barcode->setupEditAttributes();
        if (!$this->_barcode->Raw) {
            $this->_barcode->CurrentValue = HtmlDecode($this->_barcode->CurrentValue);
        }
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

        // product_code_type
        $this->product_code_type->setupEditAttributes();
        $this->product_code_type->EditValue = $this->product_code_type->options(true);
        $this->product_code_type->PlaceHolder = RemoveHtml($this->product_code_type->caption());

        // product_code
        $this->product_code->setupEditAttributes();
        $this->product_code->EditValue = $this->product_code->CurrentValue;
        $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

        // print_name
        $this->print_name->setupEditAttributes();
        $this->print_name->EditCustomAttributes = $this->print_name->getEditCustomAttributes(); // PHP
        if (!$this->print_name->Raw) {
            $this->print_name->CurrentValue = HtmlDecode($this->print_name->CurrentValue);
        }
        $this->print_name->EditValue = $this->print_name->CurrentValue;
        $this->print_name->PlaceHolder = RemoveHtml($this->print_name->caption());

        // gcode
        $this->gcode->setupEditAttributes();
        if (!$this->gcode->Raw) {
            $this->gcode->CurrentValue = HtmlDecode($this->gcode->CurrentValue);
        }
        $this->gcode->EditValue = $this->gcode->CurrentValue;
        $this->gcode->PlaceHolder = RemoveHtml($this->gcode->caption());

        // code
        $this->code->setupEditAttributes();
        if (!$this->code->Raw) {
            $this->code->CurrentValue = HtmlDecode($this->code->CurrentValue);
        }
        $this->code->EditValue = $this->code->CurrentValue;
        $this->code->PlaceHolder = RemoveHtml($this->code->caption());

        // product_id
        $this->product_id->setupEditAttributes();
        if (!$this->product_id->Raw) {
            $this->product_id->CurrentValue = HtmlDecode($this->product_id->CurrentValue);
        }
        $this->product_id->EditValue = $this->product_id->CurrentValue;
        $this->product_id->PlaceHolder = RemoveHtml($this->product_id->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        if (!$this->batch_no->Raw) {
            $this->batch_no->CurrentValue = HtmlDecode($this->batch_no->CurrentValue);
        }
        $this->batch_no->EditValue = $this->batch_no->CurrentValue;
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // set_ref
        $this->set_ref->PlaceHolder = RemoveHtml($this->set_ref->caption());

        // v_00
        $this->v_00->setupEditAttributes();
        if (!$this->v_00->Raw) {
            $this->v_00->CurrentValue = HtmlDecode($this->v_00->CurrentValue);
        }
        $this->v_00->EditValue = $this->v_00->CurrentValue;
        $this->v_00->PlaceHolder = RemoveHtml($this->v_00->caption());

        // v_01
        $this->v_01->setupEditAttributes();
        $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

        // v_02
        $this->v_02->setupEditAttributes();
        $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

        // v_03
        $this->v_03->setupEditAttributes();
        $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

        // v_04
        $this->v_04->setupEditAttributes();
        $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

        // v_05
        $this->v_05->setupEditAttributes();
        $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

        // v_06
        $this->v_06->setupEditAttributes();
        $this->v_06->PlaceHolder = RemoveHtml($this->v_06->caption());

        // v_07
        $this->v_07->setupEditAttributes();
        $this->v_07->PlaceHolder = RemoveHtml($this->v_07->caption());

        // v_08
        $this->v_08->setupEditAttributes();
        $this->v_08->PlaceHolder = RemoveHtml($this->v_08->caption());

        // v_09
        $this->v_09->setupEditAttributes();
        $this->v_09->PlaceHolder = RemoveHtml($this->v_09->caption());

        // v_10
        $this->v_10->setupEditAttributes();
        $this->v_10->PlaceHolder = RemoveHtml($this->v_10->caption());

        // cbm
        $this->cbm->setupEditAttributes();
        $this->cbm->EditValue = $this->cbm->CurrentValue;
        $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
        if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
            $this->cbm->EditValue = FormatNumber($this->cbm->EditValue, null);
        }

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // shape
        $this->shape->PlaceHolder = RemoveHtml($this->shape->caption());

        // q_sku
        $this->q_sku->setupEditAttributes();
        $this->q_sku->EditValue = $this->q_sku->CurrentValue;
        $this->q_sku->PlaceHolder = RemoveHtml($this->q_sku->caption());
        if (strval($this->q_sku->EditValue) != "" && is_numeric($this->q_sku->EditValue)) {
            $this->q_sku->EditValue = FormatNumber($this->q_sku->EditValue, null);
        }

        // b_01
        $this->b_01->setupEditAttributes();
        if (!$this->b_01->Raw) {
            $this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
        }
        $this->b_01->EditValue = $this->b_01->CurrentValue;
        $this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

        // b_02
        $this->b_02->setupEditAttributes();
        if (!$this->b_02->Raw) {
            $this->b_02->CurrentValue = HtmlDecode($this->b_02->CurrentValue);
        }
        $this->b_02->EditValue = $this->b_02->CurrentValue;
        $this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

        // b_03
        $this->b_03->PlaceHolder = RemoveHtml($this->b_03->caption());

        // b_04
        $this->b_04->PlaceHolder = RemoveHtml($this->b_04->caption());

        // b_05
        $this->b_05->PlaceHolder = RemoveHtml($this->b_05->caption());

        // b_06
        $this->b_06->PlaceHolder = RemoveHtml($this->b_06->caption());

        // b_07
        $this->b_07->PlaceHolder = RemoveHtml($this->b_07->caption());

        // b_08
        $this->b_08->PlaceHolder = RemoveHtml($this->b_08->caption());

        // b_09
        $this->b_09->PlaceHolder = RemoveHtml($this->b_09->caption());

        // b_10
        $this->b_10->PlaceHolder = RemoveHtml($this->b_10->caption());

        // b_11
        $this->b_11->setupEditAttributes();
        if (!$this->b_11->Raw) {
            $this->b_11->CurrentValue = HtmlDecode($this->b_11->CurrentValue);
        }
        $this->b_11->EditValue = $this->b_11->CurrentValue;
        $this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

        // b_12
        $this->b_12->setupEditAttributes();
        if (!$this->b_12->Raw) {
            $this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
        }
        $this->b_12->EditValue = $this->b_12->CurrentValue;
        $this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

        // b_13
        $this->b_13->setupEditAttributes();
        if (!$this->b_13->Raw) {
            $this->b_13->CurrentValue = HtmlDecode($this->b_13->CurrentValue);
        }
        $this->b_13->EditValue = $this->b_13->CurrentValue;
        $this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

        // b_14
        $this->b_14->setupEditAttributes();
        if (!$this->b_14->Raw) {
            $this->b_14->CurrentValue = HtmlDecode($this->b_14->CurrentValue);
        }
        $this->b_14->EditValue = $this->b_14->CurrentValue;
        $this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

        // b_15
        $this->b_15->setupEditAttributes();
        if (!$this->b_15->Raw) {
            $this->b_15->CurrentValue = HtmlDecode($this->b_15->CurrentValue);
        }
        $this->b_15->EditValue = $this->b_15->CurrentValue;
        $this->b_15->PlaceHolder = RemoveHtml($this->b_15->caption());

        // t_01
        $this->t_01->setupEditAttributes();
        if (!$this->t_01->Raw) {
            $this->t_01->CurrentValue = HtmlDecode($this->t_01->CurrentValue);
        }
        $this->t_01->EditValue = $this->t_01->CurrentValue;
        $this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

        // t_02
        $this->t_02->setupEditAttributes();
        if (!$this->t_02->Raw) {
            $this->t_02->CurrentValue = HtmlDecode($this->t_02->CurrentValue);
        }
        $this->t_02->EditValue = $this->t_02->CurrentValue;
        $this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

        // t_03
        $this->t_03->PlaceHolder = RemoveHtml($this->t_03->caption());

        // t_04
        $this->t_04->PlaceHolder = RemoveHtml($this->t_04->caption());

        // t_05
        $this->t_05->PlaceHolder = RemoveHtml($this->t_05->caption());

        // t_06
        $this->t_06->PlaceHolder = RemoveHtml($this->t_06->caption());

        // t_07
        $this->t_07->PlaceHolder = RemoveHtml($this->t_07->caption());

        // t_08
        $this->t_08->PlaceHolder = RemoveHtml($this->t_08->caption());

        // t_09
        $this->t_09->PlaceHolder = RemoveHtml($this->t_09->caption());

        // t_10
        $this->t_10->PlaceHolder = RemoveHtml($this->t_10->caption());

        // t_11
        $this->t_11->setupEditAttributes();
        if (!$this->t_11->Raw) {
            $this->t_11->CurrentValue = HtmlDecode($this->t_11->CurrentValue);
        }
        $this->t_11->EditValue = $this->t_11->CurrentValue;
        $this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

        // t_12
        $this->t_12->setupEditAttributes();
        if (!$this->t_12->Raw) {
            $this->t_12->CurrentValue = HtmlDecode($this->t_12->CurrentValue);
        }
        $this->t_12->EditValue = $this->t_12->CurrentValue;
        $this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

        // t_13
        $this->t_13->setupEditAttributes();
        if (!$this->t_13->Raw) {
            $this->t_13->CurrentValue = HtmlDecode($this->t_13->CurrentValue);
        }
        $this->t_13->EditValue = $this->t_13->CurrentValue;
        $this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

        // t_14
        $this->t_14->setupEditAttributes();
        if (!$this->t_14->Raw) {
            $this->t_14->CurrentValue = HtmlDecode($this->t_14->CurrentValue);
        }
        $this->t_14->EditValue = $this->t_14->CurrentValue;
        $this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

        // t_15
        $this->t_15->setupEditAttributes();
        if (!$this->t_15->Raw) {
            $this->t_15->CurrentValue = HtmlDecode($this->t_15->CurrentValue);
        }
        $this->t_15->EditValue = $this->t_15->CurrentValue;
        $this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

        // last_price
        $this->last_price->setupEditAttributes();
        $this->last_price->EditValue = $this->last_price->CurrentValue;

        // currency
        $this->currency->setupEditAttributes();
        $this->currency->PlaceHolder = RemoveHtml($this->currency->caption());

        // hsn
        $this->hsn->setupEditAttributes();
        $this->hsn->PlaceHolder = RemoveHtml($this->hsn->caption());

        // composition
        $this->composition->setupEditAttributes();
        $this->composition->PlaceHolder = RemoveHtml($this->composition->caption());

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // moq
        $this->moq->setupEditAttributes();
        $this->moq->EditValue = $this->moq->CurrentValue;
        $this->moq->PlaceHolder = RemoveHtml($this->moq->caption());
        if (strval($this->moq->EditValue) != "" && is_numeric($this->moq->EditValue)) {
            $this->moq->EditValue = FormatNumber($this->moq->EditValue, null);
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // d_head_01
        $this->d_head_01->setupEditAttributes();
        if (!$this->d_head_01->Raw) {
            $this->d_head_01->CurrentValue = HtmlDecode($this->d_head_01->CurrentValue);
        }
        $this->d_head_01->EditValue = $this->d_head_01->CurrentValue;
        $this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

        // d_description_01
        $this->d_description_01->setupEditAttributes();
        $this->d_description_01->EditValue = $this->d_description_01->CurrentValue;
        $this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

        // d_head_02
        $this->d_head_02->setupEditAttributes();
        if (!$this->d_head_02->Raw) {
            $this->d_head_02->CurrentValue = HtmlDecode($this->d_head_02->CurrentValue);
        }
        $this->d_head_02->EditValue = $this->d_head_02->CurrentValue;
        $this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

        // d_description_02
        $this->d_description_02->setupEditAttributes();
        $this->d_description_02->EditValue = $this->d_description_02->CurrentValue;
        $this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

        // publish
        $this->publish->setupEditAttributes();
        $this->publish->EditValue = $this->publish->options(true);
        $this->publish->PlaceHolder = RemoveHtml($this->publish->caption());

        // keywords
        $this->keywords->setupEditAttributes();
        $this->keywords->EditValue = $this->keywords->CurrentValue;
        $this->keywords->PlaceHolder = RemoveHtml($this->keywords->caption());

        // operator

        // datetime

        // main_image
        $this->main_image->setupEditAttributes();
        $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
        if (!EmptyValue($this->main_image->Upload->DbValue)) {
            $this->main_image->ImageWidth = 0;
            $this->main_image->ImageHeight = 40;
            $this->main_image->ImageAlt = $this->main_image->alt();
            $this->main_image->ImageCssClass = "ew-image";
            $this->main_image->EditValue = $this->main_image->Upload->DbValue;
        } else {
            $this->main_image->EditValue = "";
        }
        if (!EmptyValue($this->main_image->CurrentValue)) {
            $this->main_image->Upload->FileName = $this->main_image->CurrentValue;
        }

        // top_view
        $this->top_view->setupEditAttributes();
        $this->top_view->UploadPath = $this->top_view->getUploadPath(); // PHP
        if (!EmptyValue($this->top_view->Upload->DbValue)) {
            $this->top_view->ImageWidth = 0;
            $this->top_view->ImageHeight = 40;
            $this->top_view->ImageAlt = $this->top_view->alt();
            $this->top_view->ImageCssClass = "ew-image";
            $this->top_view->EditValue = $this->top_view->Upload->DbValue;
        } else {
            $this->top_view->EditValue = "";
        }
        if (!EmptyValue($this->top_view->CurrentValue)) {
            $this->top_view->Upload->FileName = $this->top_view->CurrentValue;
        }

        // front_view
        $this->front_view->setupEditAttributes();
        $this->front_view->UploadPath = $this->front_view->getUploadPath(); // PHP
        if (!EmptyValue($this->front_view->Upload->DbValue)) {
            $this->front_view->ImageWidth = 0;
            $this->front_view->ImageHeight = 40;
            $this->front_view->ImageAlt = $this->front_view->alt();
            $this->front_view->ImageCssClass = "ew-image";
            $this->front_view->EditValue = $this->front_view->Upload->DbValue;
        } else {
            $this->front_view->EditValue = "";
        }
        if (!EmptyValue($this->front_view->CurrentValue)) {
            $this->front_view->Upload->FileName = $this->front_view->CurrentValue;
        }

        // corner_view
        $this->corner_view->setupEditAttributes();
        $this->corner_view->UploadPath = $this->corner_view->getUploadPath(); // PHP
        if (!EmptyValue($this->corner_view->Upload->DbValue)) {
            $this->corner_view->ImageWidth = 0;
            $this->corner_view->ImageHeight = 40;
            $this->corner_view->ImageAlt = $this->corner_view->alt();
            $this->corner_view->ImageCssClass = "ew-image";
            $this->corner_view->EditValue = $this->corner_view->Upload->DbValue;
        } else {
            $this->corner_view->EditValue = "";
        }
        if (!EmptyValue($this->corner_view->CurrentValue)) {
            $this->corner_view->Upload->FileName = $this->corner_view->CurrentValue;
        }

        // back_view
        $this->back_view->setupEditAttributes();
        $this->back_view->UploadPath = $this->back_view->getUploadPath(); // PHP
        if (!EmptyValue($this->back_view->Upload->DbValue)) {
            $this->back_view->ImageWidth = 0;
            $this->back_view->ImageHeight = 40;
            $this->back_view->ImageAlt = $this->back_view->alt();
            $this->back_view->ImageCssClass = "ew-image";
            $this->back_view->EditValue = $this->back_view->Upload->DbValue;
        } else {
            $this->back_view->EditValue = "";
        }
        if (!EmptyValue($this->back_view->CurrentValue)) {
            $this->back_view->Upload->FileName = $this->back_view->CurrentValue;
        }

        // color_options
        $this->color_options->setupEditAttributes();
        $this->color_options->UploadPath = $this->color_options->getUploadPath(); // PHP
        if (!EmptyValue($this->color_options->Upload->DbValue)) {
            $this->color_options->ImageWidth = 0;
            $this->color_options->ImageHeight = 40;
            $this->color_options->ImageAlt = $this->color_options->alt();
            $this->color_options->ImageCssClass = "ew-image";
            $this->color_options->EditValue = $this->color_options->Upload->DbValue;
        } else {
            $this->color_options->EditValue = "";
        }
        if (!EmptyValue($this->color_options->CurrentValue)) {
            $this->color_options->Upload->FileName = $this->color_options->CurrentValue;
        }

        // other_options
        $this->other_options->setupEditAttributes();
        $this->other_options->UploadPath = $this->other_options->getUploadPath(); // PHP
        if (!EmptyValue($this->other_options->Upload->DbValue)) {
            $this->other_options->ImageWidth = 0;
            $this->other_options->ImageHeight = 40;
            $this->other_options->ImageAlt = $this->other_options->alt();
            $this->other_options->ImageCssClass = "ew-image";
            $this->other_options->EditValue = $this->other_options->Upload->DbValue;
        } else {
            $this->other_options->EditValue = "";
        }
        if (!EmptyValue($this->other_options->CurrentValue)) {
            $this->other_options->Upload->FileName = $this->other_options->CurrentValue;
        }

        // group_image
        $this->group_image->setupEditAttributes();
        $this->group_image->UploadPath = $this->group_image->getUploadPath(); // PHP
        if (!EmptyValue($this->group_image->Upload->DbValue)) {
            $this->group_image->EditValue = $this->group_image->Upload->DbValue;
        } else {
            $this->group_image->EditValue = "";
        }
        if (!EmptyValue($this->group_image->CurrentValue)) {
            $this->group_image->Upload->FileName = $this->group_image->CurrentValue;
        }

        // video_url
        $this->video_url->setupEditAttributes();
        if (!$this->video_url->Raw) {
            $this->video_url->CurrentValue = HtmlDecode($this->video_url->CurrentValue);
        }
        $this->video_url->EditValue = $this->video_url->CurrentValue;
        $this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

        // image
        $this->image->setupEditAttributes();
        $this->image->UploadPath = $this->image->getUploadPath(); // PHP
        if (!EmptyValue($this->image->Upload->DbValue)) {
            $this->image->ImageWidth = 0;
            $this->image->ImageHeight = 50;
            $this->image->ImageAlt = $this->image->alt();
            $this->image->ImageCssClass = "ew-image";
            $this->image->EditValue = $this->image->Upload->DbValue;
        } else {
            $this->image->EditValue = "";
        }
        if (!EmptyValue($this->image->CurrentValue)) {
            $this->image->Upload->FileName = $this->image->CurrentValue;
        }

        // in
        $this->in->setupEditAttributes();
        $this->in->EditValue = $this->in->CurrentValue;
        $this->in->PlaceHolder = RemoveHtml($this->in->caption());
        if (strval($this->in->EditValue) != "" && is_numeric($this->in->EditValue)) {
            $this->in->EditValue = FormatNumber($this->in->EditValue, null);
        }

        // out
        $this->out->setupEditAttributes();
        $this->out->EditValue = $this->out->CurrentValue;
        $this->out->PlaceHolder = RemoveHtml($this->out->caption());
        if (strval($this->out->EditValue) != "" && is_numeric($this->out->EditValue)) {
            $this->out->EditValue = FormatNumber($this->out->EditValue, null);
        }

        // required
        $this->required->setupEditAttributes();
        $this->required->EditValue = $this->required->CurrentValue;
        $this->required->PlaceHolder = RemoveHtml($this->required->caption());
        if (strval($this->required->EditValue) != "" && is_numeric($this->required->EditValue)) {
            $this->required->EditValue = FormatNumber($this->required->EditValue, null);
        }

        // blocked
        $this->blocked->setupEditAttributes();
        $this->blocked->EditValue = $this->blocked->CurrentValue;
        $this->blocked->PlaceHolder = RemoveHtml($this->blocked->caption());
        if (strval($this->blocked->EditValue) != "" && is_numeric($this->blocked->EditValue)) {
            $this->blocked->EditValue = FormatNumber($this->blocked->EditValue, null);
        }

        // ordered
        $this->ordered->setupEditAttributes();
        $this->ordered->EditValue = $this->ordered->CurrentValue;
        $this->ordered->PlaceHolder = RemoveHtml($this->ordered->caption());
        if (strval($this->ordered->EditValue) != "" && is_numeric($this->ordered->EditValue)) {
            $this->ordered->EditValue = FormatNumber($this->ordered->EditValue, null);
        }

        // supplier
        $this->supplier->setupEditAttributes();
        $this->supplier->EditValue = $this->supplier->CurrentValue;
        $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());
        if (strval($this->supplier->EditValue) != "" && is_numeric($this->supplier->EditValue)) {
            $this->supplier->EditValue = $this->supplier->EditValue;
        }

        // country
        $this->country->setupEditAttributes();
        $this->country->EditValue = $this->country->CurrentValue;
        $this->country->PlaceHolder = RemoveHtml($this->country->caption());
        if (strval($this->country->EditValue) != "" && is_numeric($this->country->EditValue)) {
            $this->country->EditValue = $this->country->EditValue;
        }

        // minimum_stock
        $this->minimum_stock->setupEditAttributes();
        $this->minimum_stock->EditValue = $this->minimum_stock->CurrentValue;
        $this->minimum_stock->PlaceHolder = RemoveHtml($this->minimum_stock->caption());
        if (strval($this->minimum_stock->EditValue) != "" && is_numeric($this->minimum_stock->EditValue)) {
            $this->minimum_stock->EditValue = FormatNumber($this->minimum_stock->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->product_n);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->product_code_type);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->set_ref);
                    $doc->exportCaption($this->v_00);
                    $doc->exportCaption($this->v_01);
                    $doc->exportCaption($this->v_02);
                    $doc->exportCaption($this->v_03);
                    $doc->exportCaption($this->v_04);
                    $doc->exportCaption($this->v_05);
                    $doc->exportCaption($this->v_06);
                    $doc->exportCaption($this->v_07);
                    $doc->exportCaption($this->v_08);
                    $doc->exportCaption($this->v_09);
                    $doc->exportCaption($this->v_10);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->q_sku);
                    $doc->exportCaption($this->b_01);
                    $doc->exportCaption($this->b_02);
                    $doc->exportCaption($this->b_03);
                    $doc->exportCaption($this->b_04);
                    $doc->exportCaption($this->b_05);
                    $doc->exportCaption($this->b_06);
                    $doc->exportCaption($this->b_07);
                    $doc->exportCaption($this->b_08);
                    $doc->exportCaption($this->b_09);
                    $doc->exportCaption($this->b_10);
                    $doc->exportCaption($this->b_11);
                    $doc->exportCaption($this->b_12);
                    $doc->exportCaption($this->b_13);
                    $doc->exportCaption($this->b_14);
                    $doc->exportCaption($this->b_15);
                    $doc->exportCaption($this->t_01);
                    $doc->exportCaption($this->t_02);
                    $doc->exportCaption($this->t_03);
                    $doc->exportCaption($this->t_04);
                    $doc->exportCaption($this->t_05);
                    $doc->exportCaption($this->t_06);
                    $doc->exportCaption($this->t_07);
                    $doc->exportCaption($this->t_08);
                    $doc->exportCaption($this->t_09);
                    $doc->exportCaption($this->t_10);
                    $doc->exportCaption($this->t_11);
                    $doc->exportCaption($this->t_12);
                    $doc->exportCaption($this->t_13);
                    $doc->exportCaption($this->t_14);
                    $doc->exportCaption($this->t_15);
                    $doc->exportCaption($this->last_price);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->hsn);
                    $doc->exportCaption($this->composition);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->moq);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->d_head_01);
                    $doc->exportCaption($this->d_description_01);
                    $doc->exportCaption($this->d_head_02);
                    $doc->exportCaption($this->d_description_02);
                    $doc->exportCaption($this->publish);
                    $doc->exportCaption($this->keywords);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->company_id);
                    $doc->exportCaption($this->grp);
                    $doc->exportCaption($this->s_grp);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_type);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->product_n);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->product_code_type);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->set_ref);
                    $doc->exportCaption($this->v_00);
                    $doc->exportCaption($this->v_01);
                    $doc->exportCaption($this->v_02);
                    $doc->exportCaption($this->v_03);
                    $doc->exportCaption($this->v_04);
                    $doc->exportCaption($this->v_05);
                    $doc->exportCaption($this->v_06);
                    $doc->exportCaption($this->v_07);
                    $doc->exportCaption($this->v_08);
                    $doc->exportCaption($this->v_09);
                    $doc->exportCaption($this->v_10);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->shape);
                    $doc->exportCaption($this->q_sku);
                    $doc->exportCaption($this->b_01);
                    $doc->exportCaption($this->b_02);
                    $doc->exportCaption($this->b_03);
                    $doc->exportCaption($this->b_04);
                    $doc->exportCaption($this->b_05);
                    $doc->exportCaption($this->b_06);
                    $doc->exportCaption($this->b_07);
                    $doc->exportCaption($this->b_08);
                    $doc->exportCaption($this->b_09);
                    $doc->exportCaption($this->b_10);
                    $doc->exportCaption($this->b_11);
                    $doc->exportCaption($this->b_12);
                    $doc->exportCaption($this->b_13);
                    $doc->exportCaption($this->b_14);
                    $doc->exportCaption($this->b_15);
                    $doc->exportCaption($this->t_01);
                    $doc->exportCaption($this->t_02);
                    $doc->exportCaption($this->t_03);
                    $doc->exportCaption($this->t_04);
                    $doc->exportCaption($this->t_05);
                    $doc->exportCaption($this->t_06);
                    $doc->exportCaption($this->t_07);
                    $doc->exportCaption($this->t_08);
                    $doc->exportCaption($this->t_09);
                    $doc->exportCaption($this->t_10);
                    $doc->exportCaption($this->t_11);
                    $doc->exportCaption($this->t_12);
                    $doc->exportCaption($this->t_13);
                    $doc->exportCaption($this->t_14);
                    $doc->exportCaption($this->t_15);
                    $doc->exportCaption($this->last_price);
                    $doc->exportCaption($this->currency);
                    $doc->exportCaption($this->hsn);
                    $doc->exportCaption($this->composition);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->d_head_01);
                    $doc->exportCaption($this->d_description_01);
                    $doc->exportCaption($this->d_head_02);
                    $doc->exportCaption($this->d_description_02);
                    $doc->exportCaption($this->publish);
                    $doc->exportCaption($this->keywords);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->product_n);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->product_code_type);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->set_ref);
                        $doc->exportField($this->v_00);
                        $doc->exportField($this->v_01);
                        $doc->exportField($this->v_02);
                        $doc->exportField($this->v_03);
                        $doc->exportField($this->v_04);
                        $doc->exportField($this->v_05);
                        $doc->exportField($this->v_06);
                        $doc->exportField($this->v_07);
                        $doc->exportField($this->v_08);
                        $doc->exportField($this->v_09);
                        $doc->exportField($this->v_10);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->q_sku);
                        $doc->exportField($this->b_01);
                        $doc->exportField($this->b_02);
                        $doc->exportField($this->b_03);
                        $doc->exportField($this->b_04);
                        $doc->exportField($this->b_05);
                        $doc->exportField($this->b_06);
                        $doc->exportField($this->b_07);
                        $doc->exportField($this->b_08);
                        $doc->exportField($this->b_09);
                        $doc->exportField($this->b_10);
                        $doc->exportField($this->b_11);
                        $doc->exportField($this->b_12);
                        $doc->exportField($this->b_13);
                        $doc->exportField($this->b_14);
                        $doc->exportField($this->b_15);
                        $doc->exportField($this->t_01);
                        $doc->exportField($this->t_02);
                        $doc->exportField($this->t_03);
                        $doc->exportField($this->t_04);
                        $doc->exportField($this->t_05);
                        $doc->exportField($this->t_06);
                        $doc->exportField($this->t_07);
                        $doc->exportField($this->t_08);
                        $doc->exportField($this->t_09);
                        $doc->exportField($this->t_10);
                        $doc->exportField($this->t_11);
                        $doc->exportField($this->t_12);
                        $doc->exportField($this->t_13);
                        $doc->exportField($this->t_14);
                        $doc->exportField($this->t_15);
                        $doc->exportField($this->last_price);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->hsn);
                        $doc->exportField($this->composition);
                        $doc->exportField($this->category);
                        $doc->exportField($this->moq);
                        $doc->exportField($this->status);
                        $doc->exportField($this->d_head_01);
                        $doc->exportField($this->d_description_01);
                        $doc->exportField($this->d_head_02);
                        $doc->exportField($this->d_description_02);
                        $doc->exportField($this->publish);
                        $doc->exportField($this->keywords);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->company_id);
                        $doc->exportField($this->grp);
                        $doc->exportField($this->s_grp);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_type);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->product_n);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->product_code_type);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->set_ref);
                        $doc->exportField($this->v_00);
                        $doc->exportField($this->v_01);
                        $doc->exportField($this->v_02);
                        $doc->exportField($this->v_03);
                        $doc->exportField($this->v_04);
                        $doc->exportField($this->v_05);
                        $doc->exportField($this->v_06);
                        $doc->exportField($this->v_07);
                        $doc->exportField($this->v_08);
                        $doc->exportField($this->v_09);
                        $doc->exportField($this->v_10);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->shape);
                        $doc->exportField($this->q_sku);
                        $doc->exportField($this->b_01);
                        $doc->exportField($this->b_02);
                        $doc->exportField($this->b_03);
                        $doc->exportField($this->b_04);
                        $doc->exportField($this->b_05);
                        $doc->exportField($this->b_06);
                        $doc->exportField($this->b_07);
                        $doc->exportField($this->b_08);
                        $doc->exportField($this->b_09);
                        $doc->exportField($this->b_10);
                        $doc->exportField($this->b_11);
                        $doc->exportField($this->b_12);
                        $doc->exportField($this->b_13);
                        $doc->exportField($this->b_14);
                        $doc->exportField($this->b_15);
                        $doc->exportField($this->t_01);
                        $doc->exportField($this->t_02);
                        $doc->exportField($this->t_03);
                        $doc->exportField($this->t_04);
                        $doc->exportField($this->t_05);
                        $doc->exportField($this->t_06);
                        $doc->exportField($this->t_07);
                        $doc->exportField($this->t_08);
                        $doc->exportField($this->t_09);
                        $doc->exportField($this->t_10);
                        $doc->exportField($this->t_11);
                        $doc->exportField($this->t_12);
                        $doc->exportField($this->t_13);
                        $doc->exportField($this->t_14);
                        $doc->exportField($this->t_15);
                        $doc->exportField($this->last_price);
                        $doc->exportField($this->currency);
                        $doc->exportField($this->hsn);
                        $doc->exportField($this->composition);
                        $doc->exportField($this->category);
                        $doc->exportField($this->status);
                        $doc->exportField($this->d_head_01);
                        $doc->exportField($this->d_description_01);
                        $doc->exportField($this->d_head_02);
                        $doc->exportField($this->d_description_02);
                        $doc->exportField($this->publish);
                        $doc->exportField($this->keywords);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'main_image') {
            $fldName = "main_image";
            $fileNameFld = "main_image";
        } elseif ($fldparm == 'top_view') {
            $fldName = "top_view";
            $fileNameFld = "top_view";
        } elseif ($fldparm == 'front_view') {
            $fldName = "front_view";
            $fileNameFld = "front_view";
        } elseif ($fldparm == 'corner_view') {
            $fldName = "corner_view";
            $fileNameFld = "corner_view";
        } elseif ($fldparm == 'back_view') {
            $fldName = "back_view";
            $fileNameFld = "back_view";
        } elseif ($fldparm == 'color_options') {
            $fldName = "color_options";
            $fileNameFld = "color_options";
        } elseif ($fldparm == 'other_options') {
            $fldName = "other_options";
            $fileNameFld = "other_options";
        } elseif ($fldparm == 'group_image') {
            $fldName = "group_image";
            $fileNameFld = "group_image";
        } elseif ($fldparm == 'image') {
            $fldName = "image";
            $fileNameFld = "image";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'ref');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'ref', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'ref', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'ref', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
