<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class QuotationSearch extends Quotation
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "QuotationSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "quotationsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->main_image->setVisibility();
        $this->godown_id->setVisibility();
        $this->product->setVisibility();
        $this->product_code->setVisibility();
        $this->Balance->setVisibility();
        $this->price->setVisibility();
        $this->price_kg->setVisibility();
        $this->price_unit->setVisibility();
        $this->b_12->setVisibility();
        $this->b_01->setVisibility();
        $this->v_01->setVisibility();
        $this->v_02->setVisibility();
        $this->v_03->setVisibility();
        $this->v_04->setVisibility();
        $this->v_05->setVisibility();
        $this->Amount->setVisibility();
        $this->packing_type->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'quotation';
        $this->TableName = 'quotation';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (quotation)
        if (!isset($GLOBALS["quotation"]) || $GLOBALS["quotation"]::class == PROJECT_NAMESPACE . "quotation") {
            $GLOBALS["quotation"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'quotation');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "quotationview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
                $this->main_image->UploadPath = $this->main_image->OldUploadPath;
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAddOrEdit()) {
            $this->godown_id->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Balance->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->price_kg->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->price_unit->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Amount->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->packing_type->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->godown_id);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->v_01);
        $this->setupLookupOptions($this->v_02);
        $this->setupLookupOptions($this->v_03);
        $this->setupLookupOptions($this->v_04);
        $this->setupLookupOptions($this->v_05);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "quotationlist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->main_image); // main_image
        $this->buildSearchUrl($srchUrl, $this->godown_id); // godown_id
        $this->buildSearchUrl($srchUrl, $this->product); // product
        $this->buildSearchUrl($srchUrl, $this->product_code); // product_code
        $this->buildSearchUrl($srchUrl, $this->Balance); // Balance
        $this->buildSearchUrl($srchUrl, $this->price); // price
        $this->buildSearchUrl($srchUrl, $this->price_kg); // price_kg
        $this->buildSearchUrl($srchUrl, $this->price_unit); // price_unit
        $this->buildSearchUrl($srchUrl, $this->b_12); // b_12
        $this->buildSearchUrl($srchUrl, $this->b_01); // b_01
        $this->buildSearchUrl($srchUrl, $this->v_01); // v_01
        $this->buildSearchUrl($srchUrl, $this->v_02); // v_02
        $this->buildSearchUrl($srchUrl, $this->v_03); // v_03
        $this->buildSearchUrl($srchUrl, $this->v_04); // v_04
        $this->buildSearchUrl($srchUrl, $this->v_05); // v_05
        $this->buildSearchUrl($srchUrl, $this->Amount); // Amount
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // main_image
        if ($this->main_image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // godown_id
        if ($this->godown_id->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->godown_id->AdvancedSearch->SearchValue)) {
            $this->godown_id->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->godown_id->AdvancedSearch->SearchValue);
        }
        if (is_array($this->godown_id->AdvancedSearch->SearchValue2)) {
            $this->godown_id->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->godown_id->AdvancedSearch->SearchValue2);
        }

        // product
        if ($this->product->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_code
        if ($this->product_code->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Balance
        if ($this->Balance->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // price
        if ($this->price->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // price_kg
        if ($this->price_kg->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // price_unit
        if ($this->price_unit->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_12
        if ($this->b_12->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // b_01
        if ($this->b_01->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // v_01
        if ($this->v_01->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->v_01->AdvancedSearch->SearchValue)) {
            $this->v_01->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_01->AdvancedSearch->SearchValue);
        }
        if (is_array($this->v_01->AdvancedSearch->SearchValue2)) {
            $this->v_01->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_01->AdvancedSearch->SearchValue2);
        }

        // v_02
        if ($this->v_02->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->v_02->AdvancedSearch->SearchValue)) {
            $this->v_02->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_02->AdvancedSearch->SearchValue);
        }
        if (is_array($this->v_02->AdvancedSearch->SearchValue2)) {
            $this->v_02->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_02->AdvancedSearch->SearchValue2);
        }

        // v_03
        if ($this->v_03->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->v_03->AdvancedSearch->SearchValue)) {
            $this->v_03->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_03->AdvancedSearch->SearchValue);
        }
        if (is_array($this->v_03->AdvancedSearch->SearchValue2)) {
            $this->v_03->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_03->AdvancedSearch->SearchValue2);
        }

        // v_04
        if ($this->v_04->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->v_04->AdvancedSearch->SearchValue)) {
            $this->v_04->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_04->AdvancedSearch->SearchValue);
        }
        if (is_array($this->v_04->AdvancedSearch->SearchValue2)) {
            $this->v_04->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_04->AdvancedSearch->SearchValue2);
        }

        // v_05
        if ($this->v_05->AdvancedSearch->get()) {
            $hasValue = true;
        }
        if (is_array($this->v_05->AdvancedSearch->SearchValue)) {
            $this->v_05->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_05->AdvancedSearch->SearchValue);
        }
        if (is_array($this->v_05->AdvancedSearch->SearchValue2)) {
            $this->v_05->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->v_05->AdvancedSearch->SearchValue2);
        }

        // Amount
        if ($this->Amount->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // main_image
        $this->main_image->RowCssClass = "row";

        // godown_id
        $this->godown_id->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // product_code
        $this->product_code->RowCssClass = "row";

        // Balance
        $this->Balance->RowCssClass = "row";

        // price
        $this->price->RowCssClass = "row";

        // price_kg
        $this->price_kg->RowCssClass = "row";

        // price_unit
        $this->price_unit->RowCssClass = "row";

        // b_12
        $this->b_12->RowCssClass = "row";

        // b_01
        $this->b_01->RowCssClass = "row";

        // v_01
        $this->v_01->RowCssClass = "row";

        // v_02
        $this->v_02->RowCssClass = "row";

        // v_03
        $this->v_03->RowCssClass = "row";

        // v_04
        $this->v_04->RowCssClass = "row";

        // v_05
        $this->v_05->RowCssClass = "row";

        // Amount
        $this->Amount->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;
            $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->ImageWidth = 0;
                $this->main_image->ImageHeight = 50;
                $this->main_image->ImageAlt = $this->main_image->alt();
                $this->main_image->ImageCssClass = "ew-image";
                $this->main_image->ViewValue = $this->main_image->Upload->DbValue;
            } else {
                $this->main_image->ViewValue = "";
            }

            // godown_id
            $curVal = strval($this->godown_id->CurrentValue);
            if ($curVal != "") {
                $this->godown_id->ViewValue = $this->godown_id->lookupCacheOption($curVal);
                if ($this->godown_id->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->godown_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->godown_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->godown_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->godown_id->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->godown_id->Lookup->renderViewRow($row);
                            $this->godown_id->ViewValue->add($this->godown_id->displayValue($arwrk));
                        }
                    } else {
                        $this->godown_id->ViewValue = FormatNumber($this->godown_id->CurrentValue, $this->godown_id->formatPattern());
                    }
                }
            } else {
                $this->godown_id->ViewValue = null;
            }

            // product
            $curVal = strval($this->product->CurrentValue);
            if ($curVal != "") {
                $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
                if ($this->product->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                        $this->product->ViewValue = $this->product->displayValue($arwrk);
                    } else {
                        $this->product->ViewValue = $this->product->CurrentValue;
                    }
                }
            } else {
                $this->product->ViewValue = null;
            }

            // product_code
            $this->product_code->ViewValue = $this->product_code->CurrentValue;

            // Balance
            $this->Balance->ViewValue = $this->Balance->CurrentValue;

            // price
            $this->price->ViewValue = $this->price->CurrentValue;
            $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

            // price_kg
            $this->price_kg->ViewValue = $this->price_kg->CurrentValue;
            $this->price_kg->ViewValue = FormatNumber($this->price_kg->ViewValue, $this->price_kg->formatPattern());

            // price_unit
            $this->price_unit->ViewValue = $this->price_unit->CurrentValue;
            $this->price_unit->ViewValue = FormatNumber($this->price_unit->ViewValue, $this->price_unit->formatPattern());

            // b_12
            $this->b_12->ViewValue = $this->b_12->CurrentValue;

            // b_01
            $this->b_01->ViewValue = $this->b_01->CurrentValue;

            // v_01
            $curVal = strval($this->v_01->CurrentValue);
            if ($curVal != "") {
                $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
                if ($this->v_01->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->v_01->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->v_01->Lookup->renderViewRow($row);
                            $this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
                        }
                    } else {
                        $this->v_01->ViewValue = $this->v_01->CurrentValue;
                    }
                }
            } else {
                $this->v_01->ViewValue = null;
            }

            // v_02
            $curVal = strval($this->v_02->CurrentValue);
            if ($curVal != "") {
                $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
                if ($this->v_02->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->v_02->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->v_02->Lookup->renderViewRow($row);
                            $this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
                        }
                    } else {
                        $this->v_02->ViewValue = $this->v_02->CurrentValue;
                    }
                }
            } else {
                $this->v_02->ViewValue = null;
            }

            // v_03
            $curVal = strval($this->v_03->CurrentValue);
            if ($curVal != "") {
                $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
                if ($this->v_03->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->v_03->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->v_03->Lookup->renderViewRow($row);
                            $this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
                        }
                    } else {
                        $this->v_03->ViewValue = $this->v_03->CurrentValue;
                    }
                }
            } else {
                $this->v_03->ViewValue = null;
            }

            // v_04
            $curVal = strval($this->v_04->CurrentValue);
            if ($curVal != "") {
                $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
                if ($this->v_04->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->v_04->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->v_04->Lookup->renderViewRow($row);
                            $this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
                        }
                    } else {
                        $this->v_04->ViewValue = $this->v_04->CurrentValue;
                    }
                }
            } else {
                $this->v_04->ViewValue = null;
            }

            // v_05
            $curVal = strval($this->v_05->CurrentValue);
            if ($curVal != "") {
                $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
                if ($this->v_05->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                    $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                    $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->v_05->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->v_05->Lookup->renderViewRow($row);
                            $this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
                        }
                    } else {
                        $this->v_05->ViewValue = $this->v_05->CurrentValue;
                    }
                }
            } else {
                $this->v_05->ViewValue = null;
            }

            // Amount
            $this->Amount->ViewValue = $this->Amount->CurrentValue;
            $this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, $this->Amount->formatPattern());

            // packing_type
            $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
            $this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, $this->packing_type->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // main_image
            $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
            if (!EmptyValue($this->main_image->Upload->DbValue)) {
                $this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->htmlDecode($this->main_image->Upload->DbValue)); // Add prefix/suffix
                $this->main_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
                }
            } else {
                $this->main_image->HrefValue = "";
            }
            $this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
            $this->main_image->TooltipValue = "";
            if ($this->main_image->UseColorbox) {
                if (EmptyValue($this->main_image->TooltipValue)) {
                    $this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->main_image->LinkAttrs["data-rel"] = "quotation_x_main_image";
                $this->main_image->LinkAttrs->appendClass("ew-lightbox");
            }

            // godown_id
            if (!EmptyValue($this->godown_id->CurrentValue)) {
                $this->godown_id->HrefValue = $this->godown_id->getLinkPrefix() . $this->godown_id->CurrentValue; // Add prefix/suffix
                $this->godown_id->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown_id->HrefValue = FullUrl($this->godown_id->HrefValue, "href");
                }
            } else {
                $this->godown_id->HrefValue = "";
            }
            $this->godown_id->TooltipValue = "";

            // product
            if (!EmptyValue($this->product->CurrentValue)) {
                $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
                $this->product->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
                }
            } else {
                $this->product->HrefValue = "";
            }
            $this->product->TooltipValue = "";

            // product_code
            if (!EmptyValue($this->product_code->CurrentValue)) {
                $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue; // Add prefix/suffix
                $this->product_code->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
                }
            } else {
                $this->product_code->HrefValue = "";
            }
            $this->product_code->TooltipValue = "";

            // Balance
            $this->Balance->HrefValue = "";
            $this->Balance->TooltipValue = "";

            // price
            $this->price->HrefValue = "";
            $this->price->TooltipValue = "";

            // price_kg
            $this->price_kg->HrefValue = "";
            $this->price_kg->TooltipValue = "";

            // price_unit
            $this->price_unit->HrefValue = "";
            $this->price_unit->TooltipValue = "";

            // b_12
            $this->b_12->HrefValue = "";
            $this->b_12->TooltipValue = "";

            // b_01
            $this->b_01->HrefValue = "";
            $this->b_01->TooltipValue = "";

            // v_01
            if (!EmptyValue($this->v_01->CurrentValue)) {
                $this->v_01->HrefValue = $this->v_01->getLinkPrefix() . $this->v_01->CurrentValue; // Add prefix/suffix
                $this->v_01->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->v_01->HrefValue = FullUrl($this->v_01->HrefValue, "href");
                }
            } else {
                $this->v_01->HrefValue = "";
            }
            $this->v_01->TooltipValue = "";

            // v_02
            if (!EmptyValue($this->v_02->CurrentValue)) {
                $this->v_02->HrefValue = $this->v_02->getLinkPrefix() . $this->v_02->CurrentValue; // Add prefix/suffix
                $this->v_02->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->v_02->HrefValue = FullUrl($this->v_02->HrefValue, "href");
                }
            } else {
                $this->v_02->HrefValue = "";
            }
            $this->v_02->TooltipValue = "";

            // v_03
            if (!EmptyValue($this->v_03->CurrentValue)) {
                $this->v_03->HrefValue = $this->v_03->getLinkPrefix() . $this->v_03->CurrentValue; // Add prefix/suffix
                $this->v_03->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->v_03->HrefValue = FullUrl($this->v_03->HrefValue, "href");
                }
            } else {
                $this->v_03->HrefValue = "";
            }
            $this->v_03->TooltipValue = "";

            // v_04
            if (!EmptyValue($this->v_04->CurrentValue)) {
                $this->v_04->HrefValue = $this->v_04->getLinkPrefix() . $this->v_04->CurrentValue; // Add prefix/suffix
                $this->v_04->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->v_04->HrefValue = FullUrl($this->v_04->HrefValue, "href");
                }
            } else {
                $this->v_04->HrefValue = "";
            }
            $this->v_04->TooltipValue = "";

            // v_05
            if (!EmptyValue($this->v_05->CurrentValue)) {
                $this->v_05->HrefValue = $this->v_05->getLinkPrefix() . $this->v_05->CurrentValue; // Add prefix/suffix
                $this->v_05->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->v_05->HrefValue = FullUrl($this->v_05->HrefValue, "href");
                }
            } else {
                $this->v_05->HrefValue = "";
            }
            $this->v_05->TooltipValue = "";

            // Amount
            $this->Amount->HrefValue = "";
            $this->Amount->TooltipValue = "";

            // packing_type
            $this->packing_type->HrefValue = "";
            $this->packing_type->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // main_image
            $this->main_image->setupEditAttributes();
            if (!$this->main_image->Raw) {
                $this->main_image->AdvancedSearch->SearchValue = HtmlDecode($this->main_image->AdvancedSearch->SearchValue);
            }
            $this->main_image->EditValue = HtmlEncode($this->main_image->AdvancedSearch->SearchValue);
            $this->main_image->PlaceHolder = RemoveHtml($this->main_image->caption());

            // godown_id
            $curVal = trim(strval($this->godown_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->godown_id->AdvancedSearch->ViewValue = $this->godown_id->lookupCacheOption($curVal);
            } else {
                $this->godown_id->AdvancedSearch->ViewValue = $this->godown_id->Lookup !== null && is_array($this->godown_id->lookupOptions()) && count($this->godown_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->godown_id->EditValue = array_values($this->godown_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->godown_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->godown_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->godown_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown_id->EditValue = $arwrk;
            }
            $this->godown_id->PlaceHolder = RemoveHtml($this->godown_id->caption());

            // product
            $this->product->setupEditAttributes();
            $curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
            } else {
                $this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== null && is_array($this->product->lookupOptions()) && count($this->product->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->product->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->product->EditValue = array_values($this->product->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->product->AdvancedSearch->SearchValue, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->product->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->product->EditValue = $arwrk;
            }
            $this->product->PlaceHolder = RemoveHtml($this->product->caption());

            // product_code
            $this->product_code->setupEditAttributes();
            if (!$this->product_code->Raw) {
                $this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
            }
            $this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
            $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

            // Balance
            $this->Balance->setupEditAttributes();
            if (!$this->Balance->Raw) {
                $this->Balance->AdvancedSearch->SearchValue = HtmlDecode($this->Balance->AdvancedSearch->SearchValue);
            }
            $this->Balance->EditValue = HtmlEncode($this->Balance->AdvancedSearch->SearchValue);
            $this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());

            // price
            $this->price->setupEditAttributes();
            $this->price->EditValue = $this->price->AdvancedSearch->SearchValue;
            $this->price->PlaceHolder = RemoveHtml($this->price->caption());

            // price_kg
            $this->price_kg->setupEditAttributes();
            $this->price_kg->EditValue = $this->price_kg->AdvancedSearch->SearchValue;
            $this->price_kg->PlaceHolder = RemoveHtml($this->price_kg->caption());

            // price_unit
            $this->price_unit->setupEditAttributes();
            $this->price_unit->EditValue = $this->price_unit->AdvancedSearch->SearchValue;
            $this->price_unit->PlaceHolder = RemoveHtml($this->price_unit->caption());

            // b_12
            $this->b_12->setupEditAttributes();
            if (!$this->b_12->Raw) {
                $this->b_12->AdvancedSearch->SearchValue = HtmlDecode($this->b_12->AdvancedSearch->SearchValue);
            }
            $this->b_12->EditValue = HtmlEncode($this->b_12->AdvancedSearch->SearchValue);
            $this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

            // b_01
            $this->b_01->setupEditAttributes();
            if (!$this->b_01->Raw) {
                $this->b_01->AdvancedSearch->SearchValue = HtmlDecode($this->b_01->AdvancedSearch->SearchValue);
            }
            $this->b_01->EditValue = HtmlEncode($this->b_01->AdvancedSearch->SearchValue);
            $this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

            // v_01
            $curVal = trim(strval($this->v_01->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_01->AdvancedSearch->ViewValue = $this->v_01->lookupCacheOption($curVal);
            } else {
                $this->v_01->AdvancedSearch->ViewValue = $this->v_01->Lookup !== null && is_array($this->v_01->lookupOptions()) && count($this->v_01->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_01->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_01->EditValue = array_values($this->v_01->lookupOptions());
                if ($this->v_01->AdvancedSearch->ViewValue == "") {
                    $this->v_01->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_01->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_01->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_01->Lookup->renderViewRow($row);
                        $this->v_01->AdvancedSearch->ViewValue->add($this->v_01->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->v_01->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->v_01->EditValue = $arwrk;
            }
            $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

            // v_02
            $curVal = trim(strval($this->v_02->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_02->AdvancedSearch->ViewValue = $this->v_02->lookupCacheOption($curVal);
            } else {
                $this->v_02->AdvancedSearch->ViewValue = $this->v_02->Lookup !== null && is_array($this->v_02->lookupOptions()) && count($this->v_02->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_02->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_02->EditValue = array_values($this->v_02->lookupOptions());
                if ($this->v_02->AdvancedSearch->ViewValue == "") {
                    $this->v_02->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_02->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_02->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_02->Lookup->renderViewRow($row);
                        $this->v_02->AdvancedSearch->ViewValue->add($this->v_02->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->v_02->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->v_02->EditValue = $arwrk;
            }
            $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

            // v_03
            $curVal = trim(strval($this->v_03->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_03->AdvancedSearch->ViewValue = $this->v_03->lookupCacheOption($curVal);
            } else {
                $this->v_03->AdvancedSearch->ViewValue = $this->v_03->Lookup !== null && is_array($this->v_03->lookupOptions()) && count($this->v_03->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_03->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_03->EditValue = array_values($this->v_03->lookupOptions());
                if ($this->v_03->AdvancedSearch->ViewValue == "") {
                    $this->v_03->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_03->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_03->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_03->Lookup->renderViewRow($row);
                        $this->v_03->AdvancedSearch->ViewValue->add($this->v_03->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->v_03->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->v_03->EditValue = $arwrk;
            }
            $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

            // v_04
            $curVal = trim(strval($this->v_04->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_04->AdvancedSearch->ViewValue = $this->v_04->lookupCacheOption($curVal);
            } else {
                $this->v_04->AdvancedSearch->ViewValue = $this->v_04->Lookup !== null && is_array($this->v_04->lookupOptions()) && count($this->v_04->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_04->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_04->EditValue = array_values($this->v_04->lookupOptions());
                if ($this->v_04->AdvancedSearch->ViewValue == "") {
                    $this->v_04->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_04->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_04->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_04->Lookup->renderViewRow($row);
                        $this->v_04->AdvancedSearch->ViewValue->add($this->v_04->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->v_04->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->v_04->EditValue = $arwrk;
            }
            $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

            // v_05
            $curVal = trim(strval($this->v_05->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->v_05->AdvancedSearch->ViewValue = $this->v_05->lookupCacheOption($curVal);
            } else {
                $this->v_05->AdvancedSearch->ViewValue = $this->v_05->Lookup !== null && is_array($this->v_05->lookupOptions()) && count($this->v_05->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->v_05->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->v_05->EditValue = array_values($this->v_05->lookupOptions());
                if ($this->v_05->AdvancedSearch->ViewValue == "") {
                    $this->v_05->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                    }
                }
                $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_05->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_05->AdvancedSearch->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_05->Lookup->renderViewRow($row);
                        $this->v_05->AdvancedSearch->ViewValue->add($this->v_05->displayValue($arwrk));
                        $ari++;
                    }
                } else {
                    $this->v_05->AdvancedSearch->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->v_05->EditValue = $arwrk;
            }
            $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

            // Amount
            $this->Amount->setupEditAttributes();
            $this->Amount->EditValue = $this->Amount->AdvancedSearch->SearchValue;
            $this->Amount->PlaceHolder = RemoveHtml($this->Amount->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $this->packing_type->EditValue = $this->packing_type->AdvancedSearch->SearchValue;
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->Balance->AdvancedSearch->SearchValue)) {
            $this->Balance->addErrorMessage($this->Balance->getErrorMessage(false));
        }
        if (!CheckNumber($this->price->AdvancedSearch->SearchValue)) {
            $this->price->addErrorMessage($this->price->getErrorMessage(false));
        }
        if (!CheckNumber($this->price_kg->AdvancedSearch->SearchValue)) {
            $this->price_kg->addErrorMessage($this->price_kg->getErrorMessage(false));
        }
        if (!CheckNumber($this->price_unit->AdvancedSearch->SearchValue)) {
            $this->price_unit->addErrorMessage($this->price_unit->getErrorMessage(false));
        }
        if (!CheckNumber($this->Amount->AdvancedSearch->SearchValue)) {
            $this->Amount->addErrorMessage($this->Amount->getErrorMessage(false));
        }
        if (!CheckNumber($this->packing_type->AdvancedSearch->SearchValue)) {
            $this->packing_type->addErrorMessage($this->packing_type->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->main_image->AdvancedSearch->load();
        $this->godown_id->AdvancedSearch->load();
        $this->product->AdvancedSearch->load();
        $this->product_code->AdvancedSearch->load();
        $this->Balance->AdvancedSearch->load();
        $this->price->AdvancedSearch->load();
        $this->price_kg->AdvancedSearch->load();
        $this->price_unit->AdvancedSearch->load();
        $this->b_12->AdvancedSearch->load();
        $this->b_01->AdvancedSearch->load();
        $this->v_01->AdvancedSearch->load();
        $this->v_02->AdvancedSearch->load();
        $this->v_03->AdvancedSearch->load();
        $this->v_04->AdvancedSearch->load();
        $this->v_05->AdvancedSearch->load();
        $this->Amount->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("quotationlist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_godown_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_v_01":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_02":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_03":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_04":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_v_05":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
