<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for quotation
 */
class Quotation extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $main_image;
    public $godown_id;
    public $product;
    public $product_code;
    public $Balance;
    public $price;
    public $price_kg;
    public $price_unit;
    public $b_12;
    public $b_01;
    public $v_01;
    public $v_02;
    public $v_03;
    public $v_04;
    public $v_05;
    public $Amount;
    public $packing_type;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "quotation";
        $this->TableName = 'quotation';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "quotation";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->Nullable = false; // NOT NULL field
        $this->id->Required = true; // Required field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // main_image
        $this->main_image = new DbField(
            $this, // Table
            'x_main_image', // Variable name
            'main_image', // Name
            '`main_image`', // Expression
            '`main_image`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`main_image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->main_image->addMethod("getUploadPath", fn() => '.p_uploads/product_images/o/' . $this->id->CurrentValue . '/' );
        $this->main_image->InputTextType = "text";
        $this->main_image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['main_image'] = &$this->main_image;

        // godown_id
        $this->godown_id = new DbField(
            $this, // Table
            'x_godown_id', // Variable name
            'godown_id', // Name
            '`godown_id`', // Expression
            '`godown_id`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->godown_id->addMethod("getSelectFilter", fn() => "`id` > 0");
        $this->godown_id->addMethod("getSearchDefault", fn() => 1);
        $this->godown_id->addMethod("getLinkPrefix", fn() => "quotationlist?x_godown_id=");
        $this->godown_id->InputTextType = "text";
        $this->godown_id->Raw = true;
        $this->godown_id->Lookup = new Lookup($this->godown_id, 'godown_table', true, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->godown_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->godown_id->AdvancedSearch->SearchValueDefault = $this->godown_id->getSearchDefault();
        $this->godown_id->AdvancedSearch->SearchOperatorDefault = "=";
        $this->godown_id->AdvancedSearch->SearchOperator2Default = "";
        $this->godown_id->AdvancedSearch->SearchConditionDefault = "AND";
        $this->Fields['godown_id'] = &$this->godown_id;

        // product
        $this->product = new DbField(
            $this, // Table
            'x_product', // Variable name
            'product', // Name
            '`product`', // Expression
            '`product`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->product->addMethod("getLinkPrefix", fn() => "quotationlist?x_product=");
        $this->product->InputTextType = "text";
        $this->product->Raw = true;
        $this->product->Required = true; // Required field
        $this->product->setSelectMultiple(false); // Select one
        $this->product->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->product->Lookup = new Lookup($this->product, 'product_g', true, 'id', ["product","","",""], '', '', [], [], [], [], [], [], false, '`product` ASC', '', "`product`");
        $this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->product->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['product'] = &$this->product;

        // product_code
        $this->product_code = new DbField(
            $this, // Table
            'x_product_code', // Variable name
            'product_code', // Name
            '`product_code`', // Expression
            '`product_code`', // Basic search expression
            200, // Type
            300, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`product_code`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->product_code->addMethod("getLinkPrefix", fn() => "quotationlist?x_product_code=");
        $this->product_code->InputTextType = "text";
        $this->product_code->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_code'] = &$this->product_code;

        // Balance
        $this->Balance = new DbField(
            $this, // Table
            'x_Balance', // Variable name
            'Balance', // Name
            '`Balance`', // Expression
            '`Balance`', // Basic search expression
            200, // Type
            85, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Balance`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Balance->InputTextType = "text";
        $this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Balance->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['Balance'] = &$this->Balance;

        // price
        $this->price = new DbField(
            $this, // Table
            'x_price', // Variable name
            'price', // Name
            '`price`', // Expression
            '`price`', // Basic search expression
            131, // Type
            9, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price->InputTextType = "text";
        $this->price->Raw = true;
        $this->price->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price'] = &$this->price;

        // price_kg
        $this->price_kg = new DbField(
            $this, // Table
            'x_price_kg', // Variable name
            'price_kg', // Name
            '`price_kg`', // Expression
            '`price_kg`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price_kg`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price_kg->InputTextType = "text";
        $this->price_kg->Raw = true;
        $this->price_kg->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price_kg->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price_kg'] = &$this->price_kg;

        // price_unit
        $this->price_unit = new DbField(
            $this, // Table
            'x_price_unit', // Variable name
            'price_unit', // Name
            '`price_unit`', // Expression
            '`price_unit`', // Basic search expression
            5, // Type
            19, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`price_unit`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->price_unit->InputTextType = "text";
        $this->price_unit->Raw = true;
        $this->price_unit->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->price_unit->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['price_unit'] = &$this->price_unit;

        // b_12
        $this->b_12 = new DbField(
            $this, // Table
            'x_b_12', // Variable name
            'b_12', // Name
            '`b_12`', // Expression
            '`b_12`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_12`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_12->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 212");
        $this->b_12->InputTextType = "text";
        $this->b_12->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_12'] = &$this->b_12;

        // b_01
        $this->b_01 = new DbField(
            $this, // Table
            'x_b_01', // Variable name
            'b_01', // Name
            '`b_01`', // Expression
            '`b_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`b_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->b_01->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 201");
        $this->b_01->InputTextType = "text";
        $this->b_01->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['b_01'] = &$this->b_01;

        // v_01
        $this->v_01 = new DbField(
            $this, // Table
            'x_v_01', // Variable name
            'v_01', // Name
            '`v_01`', // Expression
            '`v_01`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_01`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->v_01->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 101");
        $this->v_01->addMethod("getLinkPrefix", fn() => "quotationlist?x_v_01=");
        $this->v_01->InputTextType = "text";
        $this->v_01->Required = true; // Required field
        $this->v_01->Lookup = new Lookup($this->v_01, 'varient_view2', true, 'code', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_01) . "',COALESCE(`name`,''))");
        $this->v_01->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_01'] = &$this->v_01;

        // v_02
        $this->v_02 = new DbField(
            $this, // Table
            'x_v_02', // Variable name
            'v_02', // Name
            '`v_02`', // Expression
            '`v_02`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_02`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->v_02->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 102");
        $this->v_02->addMethod("getLinkPrefix", fn() => "quotationlist?x_v_02=");
        $this->v_02->InputTextType = "text";
        $this->v_02->Required = true; // Required field
        $this->v_02->Lookup = new Lookup($this->v_02, 'varient_view2', true, 'code', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_02) . "',COALESCE(`name`,''))");
        $this->v_02->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_02'] = &$this->v_02;

        // v_03
        $this->v_03 = new DbField(
            $this, // Table
            'x_v_03', // Variable name
            'v_03', // Name
            '`v_03`', // Expression
            '`v_03`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_03`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->v_03->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 103");
        $this->v_03->addMethod("getLinkPrefix", fn() => "quotationlist?x_v_03=");
        $this->v_03->InputTextType = "text";
        $this->v_03->Required = true; // Required field
        $this->v_03->Lookup = new Lookup($this->v_03, 'varient_view2', true, 'code', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_03) . "',COALESCE(`name`,''))");
        $this->v_03->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_03'] = &$this->v_03;

        // v_04
        $this->v_04 = new DbField(
            $this, // Table
            'x_v_04', // Variable name
            'v_04', // Name
            '`v_04`', // Expression
            '`v_04`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_04`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->v_04->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 104");
        $this->v_04->addMethod("getLinkPrefix", fn() => "quotationlist?x_v_04=");
        $this->v_04->InputTextType = "text";
        $this->v_04->Required = true; // Required field
        $this->v_04->Lookup = new Lookup($this->v_04, 'varient_view2', true, 'code', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_04) . "',COALESCE(`name`,''))");
        $this->v_04->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_04'] = &$this->v_04;

        // v_05
        $this->v_05 = new DbField(
            $this, // Table
            'x_v_05', // Variable name
            'v_05', // Name
            '`v_05`', // Expression
            '`v_05`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`v_05`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->v_05->addMethod("getSelectFilter", fn() => "`status` = 1 and `no` = 105");
        $this->v_05->addMethod("getLinkPrefix", fn() => "quotationlist?x_v_05=");
        $this->v_05->InputTextType = "text";
        $this->v_05->Required = true; // Required field
        $this->v_05->Lookup = new Lookup($this->v_05, 'varient', true, 'code', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->v_05) . "',COALESCE(`name`,''))");
        $this->v_05->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['v_05'] = &$this->v_05;

        // Amount
        $this->Amount = new DbField(
            $this, // Table
            'x_Amount', // Variable name
            'Amount', // Name
            '`Amount`', // Expression
            '`Amount`', // Basic search expression
            131, // Type
            66, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Amount`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Amount->InputTextType = "text";
        $this->Amount->Raw = true;
        $this->Amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->Amount->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['Amount'] = &$this->Amount;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->packing_type->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "quotation";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->godown_id->DbValue = $row['godown_id'];
        $this->product->DbValue = $row['product'];
        $this->product_code->DbValue = $row['product_code'];
        $this->Balance->DbValue = $row['Balance'];
        $this->price->DbValue = $row['price'];
        $this->price_kg->DbValue = $row['price_kg'];
        $this->price_unit->DbValue = $row['price_unit'];
        $this->b_12->DbValue = $row['b_12'];
        $this->b_01->DbValue = $row['b_01'];
        $this->v_01->DbValue = $row['v_01'];
        $this->v_02->DbValue = $row['v_02'];
        $this->v_03->DbValue = $row['v_03'];
        $this->v_04->DbValue = $row['v_04'];
        $this->v_05->DbValue = $row['v_05'];
        $this->Amount->DbValue = $row['Amount'];
        $this->packing_type->DbValue = $row['packing_type'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $this->main_image->OldUploadPath = $this->main_image->getUploadPath(); // PHP
        $oldFiles = EmptyValue($row['main_image']) ? [] : [$row['main_image']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->main_image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->main_image->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("quotationlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "quotationview" => $Language->phrase("View"),
            "quotationedit" => $Language->phrase("Edit"),
            "quotationadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "quotationlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "QuotationView",
            Config("API_ADD_ACTION") => "QuotationAdd",
            Config("API_EDIT_ACTION") => "QuotationEdit",
            Config("API_DELETE_ACTION") => "QuotationDelete",
            Config("API_LIST_ACTION") => "QuotationList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "quotationlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("quotationview", $parm);
        } else {
            $url = $this->keyUrl("quotationview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "quotationadd?" . $parm;
        } else {
            $url = "quotationadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("quotationedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("quotationlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("quotationadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("quotationlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("quotationdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->main_image->Upload->DbValue = $row['main_image'];
        $this->godown_id->setDbValue($row['godown_id']);
        $this->product->setDbValue($row['product']);
        $this->product_code->setDbValue($row['product_code']);
        $this->Balance->setDbValue($row['Balance']);
        $this->price->setDbValue($row['price']);
        $this->price_kg->setDbValue($row['price_kg']);
        $this->price_unit->setDbValue($row['price_unit']);
        $this->b_12->setDbValue($row['b_12']);
        $this->b_01->setDbValue($row['b_01']);
        $this->v_01->setDbValue($row['v_01']);
        $this->v_02->setDbValue($row['v_02']);
        $this->v_03->setDbValue($row['v_03']);
        $this->v_04->setDbValue($row['v_04']);
        $this->v_05->setDbValue($row['v_05']);
        $this->Amount->setDbValue($row['Amount']);
        $this->packing_type->setDbValue($row['packing_type']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "QuotationList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // main_image

        // godown_id

        // product

        // product_code

        // Balance

        // price

        // price_kg

        // price_unit

        // b_12

        // b_01

        // v_01

        // v_02

        // v_03

        // v_04

        // v_05

        // Amount

        // packing_type

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // main_image
        $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
        if (!EmptyValue($this->main_image->Upload->DbValue)) {
            $this->main_image->ImageWidth = 0;
            $this->main_image->ImageHeight = 50;
            $this->main_image->ImageAlt = $this->main_image->alt();
            $this->main_image->ImageCssClass = "ew-image";
            $this->main_image->ViewValue = $this->main_image->Upload->DbValue;
        } else {
            $this->main_image->ViewValue = "";
        }

        // godown_id
        $curVal = strval($this->godown_id->CurrentValue);
        if ($curVal != "") {
            $this->godown_id->ViewValue = $this->godown_id->lookupCacheOption($curVal);
            if ($this->godown_id->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->godown_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->godown_id->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->godown_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->godown_id->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->godown_id->Lookup->renderViewRow($row);
                        $this->godown_id->ViewValue->add($this->godown_id->displayValue($arwrk));
                    }
                } else {
                    $this->godown_id->ViewValue = FormatNumber($this->godown_id->CurrentValue, $this->godown_id->formatPattern());
                }
            }
        } else {
            $this->godown_id->ViewValue = null;
        }

        // product
        $curVal = strval($this->product->CurrentValue);
        if ($curVal != "") {
            $this->product->ViewValue = $this->product->lookupCacheOption($curVal);
            if ($this->product->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->product->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->product->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->product->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->product->Lookup->renderViewRow($rswrk[0]);
                    $this->product->ViewValue = $this->product->displayValue($arwrk);
                } else {
                    $this->product->ViewValue = $this->product->CurrentValue;
                }
            }
        } else {
            $this->product->ViewValue = null;
        }

        // product_code
        $this->product_code->ViewValue = $this->product_code->CurrentValue;

        // Balance
        $this->Balance->ViewValue = $this->Balance->CurrentValue;

        // price
        $this->price->ViewValue = $this->price->CurrentValue;
        $this->price->ViewValue = FormatNumber($this->price->ViewValue, $this->price->formatPattern());

        // price_kg
        $this->price_kg->ViewValue = $this->price_kg->CurrentValue;
        $this->price_kg->ViewValue = FormatNumber($this->price_kg->ViewValue, $this->price_kg->formatPattern());

        // price_unit
        $this->price_unit->ViewValue = $this->price_unit->CurrentValue;
        $this->price_unit->ViewValue = FormatNumber($this->price_unit->ViewValue, $this->price_unit->formatPattern());

        // b_12
        $this->b_12->ViewValue = $this->b_12->CurrentValue;

        // b_01
        $this->b_01->ViewValue = $this->b_01->CurrentValue;

        // v_01
        $curVal = strval($this->v_01->CurrentValue);
        if ($curVal != "") {
            $this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
            if ($this->v_01->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->v_01->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_01->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->v_01->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_01->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_01->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_01->Lookup->renderViewRow($row);
                        $this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
                    }
                } else {
                    $this->v_01->ViewValue = $this->v_01->CurrentValue;
                }
            }
        } else {
            $this->v_01->ViewValue = null;
        }

        // v_02
        $curVal = strval($this->v_02->CurrentValue);
        if ($curVal != "") {
            $this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
            if ($this->v_02->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->v_02->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_02->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->v_02->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_02->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_02->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_02->Lookup->renderViewRow($row);
                        $this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
                    }
                } else {
                    $this->v_02->ViewValue = $this->v_02->CurrentValue;
                }
            }
        } else {
            $this->v_02->ViewValue = null;
        }

        // v_03
        $curVal = strval($this->v_03->CurrentValue);
        if ($curVal != "") {
            $this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
            if ($this->v_03->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->v_03->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_03->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->v_03->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_03->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_03->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_03->Lookup->renderViewRow($row);
                        $this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
                    }
                } else {
                    $this->v_03->ViewValue = $this->v_03->CurrentValue;
                }
            }
        } else {
            $this->v_03->ViewValue = null;
        }

        // v_04
        $curVal = strval($this->v_04->CurrentValue);
        if ($curVal != "") {
            $this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
            if ($this->v_04->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->v_04->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_04->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->v_04->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_04->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_04->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_04->Lookup->renderViewRow($row);
                        $this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
                    }
                } else {
                    $this->v_04->ViewValue = $this->v_04->CurrentValue;
                }
            }
        } else {
            $this->v_04->ViewValue = null;
        }

        // v_05
        $curVal = strval($this->v_05->CurrentValue);
        if ($curVal != "") {
            $this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
            if ($this->v_05->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->v_05->Lookup->getTable()->Fields["code"]->searchExpression(), "=", trim($wrk), $this->v_05->Lookup->getTable()->Fields["code"]->searchDataType(), ""), "OR");
                }
                $lookupFilter = $this->v_05->getSelectFilter($this); // PHP
                $sqlWrk = $this->v_05->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->v_05->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->v_05->Lookup->renderViewRow($row);
                        $this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
                    }
                } else {
                    $this->v_05->ViewValue = $this->v_05->CurrentValue;
                }
            }
        } else {
            $this->v_05->ViewValue = null;
        }

        // Amount
        $this->Amount->ViewValue = $this->Amount->CurrentValue;
        $this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, $this->Amount->formatPattern());

        // packing_type
        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
        $this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, $this->packing_type->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // main_image
        $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
        if (!EmptyValue($this->main_image->Upload->DbValue)) {
            $this->main_image->HrefValue = GetFileUploadUrl($this->main_image, $this->main_image->htmlDecode($this->main_image->Upload->DbValue)); // Add prefix/suffix
            $this->main_image->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
            }
        } else {
            $this->main_image->HrefValue = "";
        }
        $this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
        $this->main_image->TooltipValue = "";
        if ($this->main_image->UseColorbox) {
            if (EmptyValue($this->main_image->TooltipValue)) {
                $this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->main_image->LinkAttrs["data-rel"] = "quotation_x_main_image";
            $this->main_image->LinkAttrs->appendClass("ew-lightbox");
        }

        // godown_id
        if (!EmptyValue($this->godown_id->CurrentValue)) {
            $this->godown_id->HrefValue = $this->godown_id->getLinkPrefix() . $this->godown_id->CurrentValue; // Add prefix/suffix
            $this->godown_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->godown_id->HrefValue = FullUrl($this->godown_id->HrefValue, "href");
            }
        } else {
            $this->godown_id->HrefValue = "";
        }
        $this->godown_id->TooltipValue = "";

        // product
        if (!EmptyValue($this->product->CurrentValue)) {
            $this->product->HrefValue = $this->product->getLinkPrefix() . $this->product->CurrentValue; // Add prefix/suffix
            $this->product->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
            }
        } else {
            $this->product->HrefValue = "";
        }
        $this->product->TooltipValue = "";

        // product_code
        if (!EmptyValue($this->product_code->CurrentValue)) {
            $this->product_code->HrefValue = $this->product_code->getLinkPrefix() . $this->product_code->CurrentValue; // Add prefix/suffix
            $this->product_code->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
            }
        } else {
            $this->product_code->HrefValue = "";
        }
        $this->product_code->TooltipValue = "";

        // Balance
        $this->Balance->HrefValue = "";
        $this->Balance->TooltipValue = "";

        // price
        $this->price->HrefValue = "";
        $this->price->TooltipValue = "";

        // price_kg
        $this->price_kg->HrefValue = "";
        $this->price_kg->TooltipValue = "";

        // price_unit
        $this->price_unit->HrefValue = "";
        $this->price_unit->TooltipValue = "";

        // b_12
        $this->b_12->HrefValue = "";
        $this->b_12->TooltipValue = "";

        // b_01
        $this->b_01->HrefValue = "";
        $this->b_01->TooltipValue = "";

        // v_01
        if (!EmptyValue($this->v_01->CurrentValue)) {
            $this->v_01->HrefValue = $this->v_01->getLinkPrefix() . $this->v_01->CurrentValue; // Add prefix/suffix
            $this->v_01->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->v_01->HrefValue = FullUrl($this->v_01->HrefValue, "href");
            }
        } else {
            $this->v_01->HrefValue = "";
        }
        $this->v_01->TooltipValue = "";

        // v_02
        if (!EmptyValue($this->v_02->CurrentValue)) {
            $this->v_02->HrefValue = $this->v_02->getLinkPrefix() . $this->v_02->CurrentValue; // Add prefix/suffix
            $this->v_02->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->v_02->HrefValue = FullUrl($this->v_02->HrefValue, "href");
            }
        } else {
            $this->v_02->HrefValue = "";
        }
        $this->v_02->TooltipValue = "";

        // v_03
        if (!EmptyValue($this->v_03->CurrentValue)) {
            $this->v_03->HrefValue = $this->v_03->getLinkPrefix() . $this->v_03->CurrentValue; // Add prefix/suffix
            $this->v_03->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->v_03->HrefValue = FullUrl($this->v_03->HrefValue, "href");
            }
        } else {
            $this->v_03->HrefValue = "";
        }
        $this->v_03->TooltipValue = "";

        // v_04
        if (!EmptyValue($this->v_04->CurrentValue)) {
            $this->v_04->HrefValue = $this->v_04->getLinkPrefix() . $this->v_04->CurrentValue; // Add prefix/suffix
            $this->v_04->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->v_04->HrefValue = FullUrl($this->v_04->HrefValue, "href");
            }
        } else {
            $this->v_04->HrefValue = "";
        }
        $this->v_04->TooltipValue = "";

        // v_05
        if (!EmptyValue($this->v_05->CurrentValue)) {
            $this->v_05->HrefValue = $this->v_05->getLinkPrefix() . $this->v_05->CurrentValue; // Add prefix/suffix
            $this->v_05->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->v_05->HrefValue = FullUrl($this->v_05->HrefValue, "href");
            }
        } else {
            $this->v_05->HrefValue = "";
        }
        $this->v_05->TooltipValue = "";

        // Amount
        $this->Amount->HrefValue = "";
        $this->Amount->TooltipValue = "";

        // packing_type
        $this->packing_type->HrefValue = "";
        $this->packing_type->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());
        if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
            $this->id->EditValue = FormatNumber($this->id->EditValue, null);
        }

        // main_image
        $this->main_image->setupEditAttributes();
        $this->main_image->UploadPath = $this->main_image->getUploadPath(); // PHP
        if (!EmptyValue($this->main_image->Upload->DbValue)) {
            $this->main_image->ImageWidth = 0;
            $this->main_image->ImageHeight = 50;
            $this->main_image->ImageAlt = $this->main_image->alt();
            $this->main_image->ImageCssClass = "ew-image";
            $this->main_image->EditValue = $this->main_image->Upload->DbValue;
        } else {
            $this->main_image->EditValue = "";
        }
        if (!EmptyValue($this->main_image->CurrentValue)) {
            $this->main_image->Upload->FileName = $this->main_image->CurrentValue;
        }

        // godown_id
        $this->godown_id->PlaceHolder = RemoveHtml($this->godown_id->caption());

        // product
        $this->product->setupEditAttributes();
        $this->product->PlaceHolder = RemoveHtml($this->product->caption());

        // product_code
        $this->product_code->setupEditAttributes();
        if (!$this->product_code->Raw) {
            $this->product_code->CurrentValue = HtmlDecode($this->product_code->CurrentValue);
        }
        $this->product_code->EditValue = $this->product_code->CurrentValue;
        $this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

        // Balance
        $this->Balance->setupEditAttributes();
        if (!$this->Balance->Raw) {
            $this->Balance->CurrentValue = HtmlDecode($this->Balance->CurrentValue);
        }
        $this->Balance->EditValue = $this->Balance->CurrentValue;
        $this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());

        // price
        $this->price->setupEditAttributes();
        $this->price->EditValue = $this->price->CurrentValue;
        $this->price->PlaceHolder = RemoveHtml($this->price->caption());
        if (strval($this->price->EditValue) != "" && is_numeric($this->price->EditValue)) {
            $this->price->EditValue = FormatNumber($this->price->EditValue, null);
        }

        // price_kg
        $this->price_kg->setupEditAttributes();
        $this->price_kg->EditValue = $this->price_kg->CurrentValue;
        $this->price_kg->PlaceHolder = RemoveHtml($this->price_kg->caption());
        if (strval($this->price_kg->EditValue) != "" && is_numeric($this->price_kg->EditValue)) {
            $this->price_kg->EditValue = FormatNumber($this->price_kg->EditValue, null);
        }

        // price_unit
        $this->price_unit->setupEditAttributes();
        $this->price_unit->EditValue = $this->price_unit->CurrentValue;
        $this->price_unit->PlaceHolder = RemoveHtml($this->price_unit->caption());
        if (strval($this->price_unit->EditValue) != "" && is_numeric($this->price_unit->EditValue)) {
            $this->price_unit->EditValue = FormatNumber($this->price_unit->EditValue, null);
        }

        // b_12
        $this->b_12->setupEditAttributes();
        if (!$this->b_12->Raw) {
            $this->b_12->CurrentValue = HtmlDecode($this->b_12->CurrentValue);
        }
        $this->b_12->EditValue = $this->b_12->CurrentValue;
        $this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

        // b_01
        $this->b_01->setupEditAttributes();
        if (!$this->b_01->Raw) {
            $this->b_01->CurrentValue = HtmlDecode($this->b_01->CurrentValue);
        }
        $this->b_01->EditValue = $this->b_01->CurrentValue;
        $this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

        // v_01
        $this->v_01->PlaceHolder = RemoveHtml($this->v_01->caption());

        // v_02
        $this->v_02->PlaceHolder = RemoveHtml($this->v_02->caption());

        // v_03
        $this->v_03->PlaceHolder = RemoveHtml($this->v_03->caption());

        // v_04
        $this->v_04->PlaceHolder = RemoveHtml($this->v_04->caption());

        // v_05
        $this->v_05->PlaceHolder = RemoveHtml($this->v_05->caption());

        // Amount
        $this->Amount->setupEditAttributes();
        $this->Amount->EditValue = $this->Amount->CurrentValue;
        $this->Amount->PlaceHolder = RemoveHtml($this->Amount->caption());
        if (strval($this->Amount->EditValue) != "" && is_numeric($this->Amount->EditValue)) {
            $this->Amount->EditValue = FormatNumber($this->Amount->EditValue, null);
        }

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->EditValue = $this->packing_type->CurrentValue;
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
        if (strval($this->packing_type->EditValue) != "" && is_numeric($this->packing_type->EditValue)) {
            $this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->Balance->CurrentValue)) {
                $this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
            }
            $this->price_kg->Count++; // Increment count
            if (is_numeric($this->price_kg->CurrentValue)) {
                $this->price_kg->Total += $this->price_kg->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->Amount->CurrentValue)) {
                $this->Amount->Total += $this->Amount->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->Balance->CurrentValue = $this->Balance->Total;
            $this->Balance->ViewValue = $this->Balance->CurrentValue;
            $this->Balance->HrefValue = ""; // Clear href value
            if ($this->price_kg->Count > 0) {
                $this->price_kg->CurrentValue = $this->price_kg->Total / $this->price_kg->Count;
            }
            $this->price_kg->ViewValue = $this->price_kg->CurrentValue;
            $this->price_kg->ViewValue = FormatNumber($this->price_kg->ViewValue, $this->price_kg->formatPattern());
            $this->price_kg->HrefValue = ""; // Clear href value
            $this->Amount->CurrentValue = $this->Amount->Total;
            $this->Amount->ViewValue = $this->Amount->CurrentValue;
            $this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, $this->Amount->formatPattern());
            $this->Amount->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->main_image);
                    $doc->exportCaption($this->godown_id);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->price_kg);
                    $doc->exportCaption($this->price_unit);
                    $doc->exportCaption($this->b_12);
                    $doc->exportCaption($this->b_01);
                    $doc->exportCaption($this->v_01);
                    $doc->exportCaption($this->v_02);
                    $doc->exportCaption($this->v_03);
                    $doc->exportCaption($this->v_04);
                    $doc->exportCaption($this->v_05);
                    $doc->exportCaption($this->Amount);
                    $doc->exportCaption($this->packing_type);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->main_image);
                    $doc->exportCaption($this->godown_id);
                    $doc->exportCaption($this->product);
                    $doc->exportCaption($this->product_code);
                    $doc->exportCaption($this->Balance);
                    $doc->exportCaption($this->price);
                    $doc->exportCaption($this->price_kg);
                    $doc->exportCaption($this->price_unit);
                    $doc->exportCaption($this->b_12);
                    $doc->exportCaption($this->b_01);
                    $doc->exportCaption($this->v_01);
                    $doc->exportCaption($this->v_02);
                    $doc->exportCaption($this->v_03);
                    $doc->exportCaption($this->v_04);
                    $doc->exportCaption($this->v_05);
                    $doc->exportCaption($this->Amount);
                    $doc->exportCaption($this->packing_type);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->main_image);
                        $doc->exportField($this->godown_id);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->price);
                        $doc->exportField($this->price_kg);
                        $doc->exportField($this->price_unit);
                        $doc->exportField($this->b_12);
                        $doc->exportField($this->b_01);
                        $doc->exportField($this->v_01);
                        $doc->exportField($this->v_02);
                        $doc->exportField($this->v_03);
                        $doc->exportField($this->v_04);
                        $doc->exportField($this->v_05);
                        $doc->exportField($this->Amount);
                        $doc->exportField($this->packing_type);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->main_image);
                        $doc->exportField($this->godown_id);
                        $doc->exportField($this->product);
                        $doc->exportField($this->product_code);
                        $doc->exportField($this->Balance);
                        $doc->exportField($this->price);
                        $doc->exportField($this->price_kg);
                        $doc->exportField($this->price_unit);
                        $doc->exportField($this->b_12);
                        $doc->exportField($this->b_01);
                        $doc->exportField($this->v_01);
                        $doc->exportField($this->v_02);
                        $doc->exportField($this->v_03);
                        $doc->exportField($this->v_04);
                        $doc->exportField($this->v_05);
                        $doc->exportField($this->Amount);
                        $doc->exportField($this->packing_type);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->id, '');
                $doc->exportAggregate($this->main_image, '');
                $doc->exportAggregate($this->godown_id, '');
                $doc->exportAggregate($this->product, '');
                $doc->exportAggregate($this->product_code, '');
                $doc->exportAggregate($this->Balance, 'TOTAL');
                $doc->exportAggregate($this->price, '');
                $doc->exportAggregate($this->price_kg, 'AVERAGE');
                $doc->exportAggregate($this->price_unit, '');
                $doc->exportAggregate($this->b_12, '');
                $doc->exportAggregate($this->b_01, '');
                $doc->exportAggregate($this->v_01, '');
                $doc->exportAggregate($this->v_02, '');
                $doc->exportAggregate($this->v_03, '');
                $doc->exportAggregate($this->v_04, '');
                $doc->exportAggregate($this->v_05, '');
                $doc->exportAggregate($this->Amount, 'TOTAL');
                $doc->exportAggregate($this->packing_type, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'main_image') {
            $fldName = "main_image";
            $fileNameFld = "main_image";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 0) {
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
