<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class QueryProductionTableSearch extends QueryProductionTable
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "QueryProductionTableSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "queryproductiontablesearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->buyer->setVisibility();
        $this->po->setVisibility();
        $this->buyer_ref->setVisibility();
        $this->design_id->setVisibility();
        $this->size_cm->setVisibility();
        $this->Weaving->setVisibility();
        $this->Packing->setVisibility();
        $this->order_quantity->setVisibility();
        $this->count->setVisibility();
        $this->sqm->setVisibility();
        $this->sqm_a->setVisibility();
        $this->process_c->Visible = false;
        $this->process_d->Visible = false;
        $this->_barcode->setVisibility();
        $this->status->setVisibility();
        $this->dispatch_week_p->setVisibility();
        $this->current_works->setVisibility();
        $this->batch_no->setVisibility();
        $this->process->Visible = false;
        $this->url->Visible = false;
        $this->id->Visible = false;
        $this->URL_DSP->setVisibility();
        $this->buyer_barcode->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'query_production_table';
        $this->TableName = 'query_production_table';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (query_production_table)
        if (!isset($GLOBALS["query_production_table"]) || $GLOBALS["query_production_table"]::class == PROJECT_NAMESPACE . "query_production_table") {
            $GLOBALS["query_production_table"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'query_production_table');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "queryproductiontableview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->buyer);
        $this->setupLookupOptions($this->design_id);
        $this->setupLookupOptions($this->Weaving);
        $this->setupLookupOptions($this->Packing);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->dispatch_week_p);
        $this->setupLookupOptions($this->current_works);
        $this->setupLookupOptions($this->batch_no);
        $this->setupLookupOptions($this->process);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "queryproductiontablelist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->buyer); // buyer
        $this->buildSearchUrl($srchUrl, $this->po); // po
        $this->buildSearchUrl($srchUrl, $this->buyer_ref); // buyer_ref
        $this->buildSearchUrl($srchUrl, $this->design_id); // design_id
        $this->buildSearchUrl($srchUrl, $this->size_cm); // size_cm
        $this->buildSearchUrl($srchUrl, $this->Weaving); // Weaving
        $this->buildSearchUrl($srchUrl, $this->Packing); // Packing
        $this->buildSearchUrl($srchUrl, $this->order_quantity); // order_quantity
        $this->buildSearchUrl($srchUrl, $this->count); // count
        $this->buildSearchUrl($srchUrl, $this->sqm); // sqm
        $this->buildSearchUrl($srchUrl, $this->sqm_a); // sqm_a
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->dispatch_week_p); // dispatch_week_p
        $this->buildSearchUrl($srchUrl, $this->current_works); // current_works
        $this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
        $this->buildSearchUrl($srchUrl, $this->URL_DSP); // URL_DSP
        $this->buildSearchUrl($srchUrl, $this->buyer_barcode); // buyer_barcode
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // buyer
        if ($this->buyer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // po
        if ($this->po->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_ref
        if ($this->buyer_ref->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design_id
        if ($this->design_id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_cm
        if ($this->size_cm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Weaving
        if ($this->Weaving->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Packing
        if ($this->Packing->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // order_quantity
        if ($this->order_quantity->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // count
        if ($this->count->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm
        if ($this->sqm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // sqm_a
        if ($this->sqm_a->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process_c
        if ($this->process_c->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // process_d
        if ($this->process_d->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // dispatch_week_p
        if ($this->dispatch_week_p->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // current_works
        if ($this->current_works->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // batch_no
        if ($this->batch_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // URL_DSP
        if ($this->URL_DSP->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // buyer_barcode
        if ($this->buyer_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // buyer
        $this->buyer->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // buyer_ref
        $this->buyer_ref->RowCssClass = "row";

        // design_id
        $this->design_id->RowCssClass = "row";

        // size_cm
        $this->size_cm->RowCssClass = "row";

        // Weaving
        $this->Weaving->RowCssClass = "row";

        // Packing
        $this->Packing->RowCssClass = "row";

        // order_quantity
        $this->order_quantity->RowCssClass = "row";

        // count
        $this->count->RowCssClass = "row";

        // sqm
        $this->sqm->RowCssClass = "row";

        // sqm_a
        $this->sqm_a->RowCssClass = "row";

        // process_c
        $this->process_c->RowCssClass = "row";

        // process_d
        $this->process_d->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // dispatch_week_p
        $this->dispatch_week_p->RowCssClass = "row";

        // current_works
        $this->current_works->RowCssClass = "row";

        // batch_no
        $this->batch_no->RowCssClass = "row";

        // process
        $this->process->RowCssClass = "row";

        // url
        $this->url->RowCssClass = "row";

        // id
        $this->id->RowCssClass = "row";

        // URL_DSP
        $this->URL_DSP->RowCssClass = "row";

        // buyer_barcode
        $this->buyer_barcode->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // buyer
            if ($this->buyer->VirtualValue != "") {
                $this->buyer->ViewValue = $this->buyer->VirtualValue;
            } else {
                $this->buyer->ViewValue = $this->buyer->CurrentValue;
                $curVal = strval($this->buyer->CurrentValue);
                if ($curVal != "") {
                    $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                    if ($this->buyer->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                            $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                        } else {
                            $this->buyer->ViewValue = $this->buyer->CurrentValue;
                        }
                    }
                } else {
                    $this->buyer->ViewValue = null;
                }
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;

            // buyer_ref
            $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;

            // design_id
            $curVal = strval($this->design_id->CurrentValue);
            if ($curVal != "") {
                $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
                if ($this->design_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                        $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                    } else {
                        $this->design_id->ViewValue = $this->design_id->CurrentValue;
                    }
                }
            } else {
                $this->design_id->ViewValue = null;
            }

            // size_cm
            $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

            // Weaving
            if (strval($this->Weaving->CurrentValue) != "") {
                $this->Weaving->ViewValue = $this->Weaving->optionCaption($this->Weaving->CurrentValue);
            } else {
                $this->Weaving->ViewValue = null;
            }

            // Packing
            if (strval($this->Packing->CurrentValue) != "") {
                $this->Packing->ViewValue = $this->Packing->optionCaption($this->Packing->CurrentValue);
            } else {
                $this->Packing->ViewValue = null;
            }

            // order_quantity
            $this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
            $this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, $this->order_quantity->formatPattern());

            // count
            $this->count->ViewValue = $this->count->CurrentValue;
            $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());

            // sqm
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

            // sqm_a
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

            // process_c
            $this->process_c->ViewValue = $this->process_c->CurrentValue;

            // process_d
            $this->process_d->ViewValue = $this->process_d->CurrentValue;

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // dispatch_week_p
            $curVal = strval($this->dispatch_week_p->CurrentValue);
            if ($curVal != "") {
                $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
                if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                        $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                    } else {
                        $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                    }
                }
            } else {
                $this->dispatch_week_p->ViewValue = null;
            }

            // current_works
            $curVal = strval($this->current_works->CurrentValue);
            if ($curVal != "") {
                $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
                if ($this->current_works->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                    $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                        $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                    } else {
                        $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                    }
                }
            } else {
                $this->current_works->ViewValue = null;
            }

            // batch_no
            $curVal = strval($this->batch_no->CurrentValue);
            if ($curVal != "") {
                $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
                if ($this->batch_no->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                    $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                        $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                    } else {
                        $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                    }
                }
            } else {
                $this->batch_no->ViewValue = null;
            }

            // process
            if ($this->process->VirtualValue != "") {
                $this->process->ViewValue = $this->process->VirtualValue;
            } else {
                $curVal = strval($this->process->CurrentValue);
                if ($curVal != "") {
                    $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                    if ($this->process->ViewValue === null) { // Lookup from database
                        $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                        $filterWrk = "";
                        foreach ($arwrk as $wrk) {
                            AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                        }
                        $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $this->process->ViewValue = new OptionValues();
                            foreach ($rswrk as $row) {
                                $arwrk = $this->process->Lookup->renderViewRow($row);
                                $this->process->ViewValue->add($this->process->displayValue($arwrk));
                            }
                        } else {
                            $this->process->ViewValue = $this->process->CurrentValue;
                        }
                    }
                } else {
                    $this->process->ViewValue = null;
                }
            }

            // URL_DSP
            $this->URL_DSP->ViewValue = $this->URL_DSP->CurrentValue;

            // buyer_barcode
            $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

            // buyer
            $this->buyer->HrefValue = "";
            $this->buyer->TooltipValue = "";

            // po
            if (!EmptyValue($this->po->CurrentValue)) {
                $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
                $this->po->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
                }
            } else {
                $this->po->HrefValue = "";
            }
            $this->po->TooltipValue = "";

            // buyer_ref
            $this->buyer_ref->HrefValue = "";
            $this->buyer_ref->TooltipValue = "";

            // design_id
            $this->design_id->HrefValue = "";
            $this->design_id->TooltipValue = "";

            // size_cm
            if (!EmptyValue($this->URL_DSP->CurrentValue)) {
                $this->size_cm->HrefValue = $this->URL_DSP->CurrentValue; // Add prefix/suffix
                $this->size_cm->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->size_cm->HrefValue = FullUrl($this->size_cm->HrefValue, "href");
                }
            } else {
                $this->size_cm->HrefValue = "";
            }
            $this->size_cm->TooltipValue = "";

            // Weaving
            if (!EmptyValue($this->Weaving->CurrentValue)) {
                $this->Weaving->HrefValue = $this->Weaving->getLinkPrefix() . $this->Weaving->CurrentValue; // Add prefix/suffix
                $this->Weaving->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->Weaving->HrefValue = FullUrl($this->Weaving->HrefValue, "href");
                }
            } else {
                $this->Weaving->HrefValue = "";
            }
            $this->Weaving->TooltipValue = "";

            // Packing
            if (!EmptyValue($this->Packing->CurrentValue)) {
                $this->Packing->HrefValue = $this->Packing->getLinkPrefix() . $this->Packing->CurrentValue; // Add prefix/suffix
                $this->Packing->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->Packing->HrefValue = FullUrl($this->Packing->HrefValue, "href");
                }
            } else {
                $this->Packing->HrefValue = "";
            }
            $this->Packing->TooltipValue = "";

            // order_quantity
            $this->order_quantity->HrefValue = "";
            $this->order_quantity->TooltipValue = "";

            // count
            $this->count->HrefValue = "";
            $this->count->TooltipValue = "";

            // sqm
            $this->sqm->HrefValue = "";
            $this->sqm->TooltipValue = "";

            // sqm_a
            $this->sqm_a->HrefValue = "";
            $this->sqm_a->TooltipValue = "";

            // barcode
            if (!EmptyValue($this->url->CurrentValue)) {
                $this->_barcode->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
                $this->_barcode->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->_barcode->HrefValue = FullUrl($this->_barcode->HrefValue, "href");
                }
            } else {
                $this->_barcode->HrefValue = "";
            }
            $this->_barcode->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // dispatch_week_p
            $this->dispatch_week_p->HrefValue = "";
            $this->dispatch_week_p->TooltipValue = "";

            // current_works
            if (!EmptyValue($this->current_works->CurrentValue)) {
                $this->current_works->HrefValue = $this->current_works->getLinkPrefix() . $this->current_works->CurrentValue; // Add prefix/suffix
                $this->current_works->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->current_works->HrefValue = FullUrl($this->current_works->HrefValue, "href");
                }
            } else {
                $this->current_works->HrefValue = "";
            }
            $this->current_works->TooltipValue = "";

            // batch_no
            $this->batch_no->HrefValue = "";
            $this->batch_no->TooltipValue = "";

            // URL_DSP
            $this->URL_DSP->HrefValue = "";
            $this->URL_DSP->TooltipValue = "";

            // buyer_barcode
            $this->buyer_barcode->HrefValue = "";
            $this->buyer_barcode->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // buyer
            $this->buyer->setupEditAttributes();
            $this->buyer->EditValue = $this->buyer->AdvancedSearch->SearchValue;
            $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->AdvancedSearch->SearchValue;
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // buyer_ref
            $this->buyer_ref->setupEditAttributes();
            if (!$this->buyer_ref->Raw) {
                $this->buyer_ref->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_ref->AdvancedSearch->SearchValue);
            }
            $this->buyer_ref->EditValue = HtmlEncode($this->buyer_ref->AdvancedSearch->SearchValue);
            $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

            // design_id
            $this->design_id->setupEditAttributes();
            $curVal = trim(strval($this->design_id->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->lookupCacheOption($curVal);
            } else {
                $this->design_id->AdvancedSearch->ViewValue = $this->design_id->Lookup !== null && is_array($this->design_id->lookupOptions()) && count($this->design_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->design_id->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->design_id->EditValue = array_values($this->design_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->design_id->AdvancedSearch->SearchValue, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->design_id->EditValue = $arwrk;
            }
            $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

            // size_cm
            $this->size_cm->setupEditAttributes();
            if (!$this->size_cm->Raw) {
                $this->size_cm->AdvancedSearch->SearchValue = HtmlDecode($this->size_cm->AdvancedSearch->SearchValue);
            }
            $this->size_cm->EditValue = HtmlEncode($this->size_cm->AdvancedSearch->SearchValue);
            $this->size_cm->PlaceHolder = RemoveHtml($this->size_cm->caption());

            // Weaving
            $this->Weaving->setupEditAttributes();
            $this->Weaving->EditValue = $this->Weaving->options(true);
            $this->Weaving->PlaceHolder = RemoveHtml($this->Weaving->caption());
            $this->Weaving->setupEditAttributes();
            $this->Weaving->EditValue2 = $this->Weaving->options(true);
            $this->Weaving->PlaceHolder = RemoveHtml($this->Weaving->caption());

            // Packing
            $this->Packing->setupEditAttributes();
            $this->Packing->EditValue = $this->Packing->options(true);
            $this->Packing->PlaceHolder = RemoveHtml($this->Packing->caption());
            $this->Packing->setupEditAttributes();
            $this->Packing->EditValue2 = $this->Packing->options(true);
            $this->Packing->PlaceHolder = RemoveHtml($this->Packing->caption());

            // order_quantity
            $this->order_quantity->setupEditAttributes();
            $this->order_quantity->EditValue = $this->order_quantity->AdvancedSearch->SearchValue;
            $this->order_quantity->PlaceHolder = RemoveHtml($this->order_quantity->caption());

            // count
            $this->count->setupEditAttributes();
            $this->count->EditValue = $this->count->AdvancedSearch->SearchValue;
            $this->count->PlaceHolder = RemoveHtml($this->count->caption());
            $this->count->setupEditAttributes();
            $this->count->EditValue2 = $this->count->AdvancedSearch->SearchValue2;
            $this->count->PlaceHolder = RemoveHtml($this->count->caption());

            // sqm
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue = $this->sqm->AdvancedSearch->SearchValue;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
            $this->sqm->setupEditAttributes();
            $this->sqm->EditValue2 = $this->sqm->AdvancedSearch->SearchValue2;
            $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());

            // sqm_a
            $this->sqm_a->setupEditAttributes();
            $this->sqm_a->EditValue = $this->sqm_a->AdvancedSearch->SearchValue;
            $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
            $this->sqm_a->setupEditAttributes();
            $this->sqm_a->EditValue2 = $this->sqm_a->AdvancedSearch->SearchValue2;
            $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            if (!$this->_barcode->Raw) {
                $this->_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->_barcode->AdvancedSearch->SearchValue);
            }
            $this->_barcode->EditValue = HtmlEncode($this->_barcode->AdvancedSearch->SearchValue);
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->AdvancedSearch->SearchValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // dispatch_week_p
            $this->dispatch_week_p->setupEditAttributes();
            $curVal = trim(strval($this->dispatch_week_p->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
            } else {
                $this->dispatch_week_p->AdvancedSearch->ViewValue = $this->dispatch_week_p->Lookup !== null && is_array($this->dispatch_week_p->lookupOptions()) && count($this->dispatch_week_p->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->dispatch_week_p->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->dispatch_week_p->EditValue = array_values($this->dispatch_week_p->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->dispatch_week_p->AdvancedSearch->SearchValue, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->dispatch_week_p->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->dispatch_week_p->EditValue = $arwrk;
            }
            $this->dispatch_week_p->PlaceHolder = RemoveHtml($this->dispatch_week_p->caption());

            // current_works
            $this->current_works->setupEditAttributes();
            $curVal = trim(strval($this->current_works->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->lookupCacheOption($curVal);
            } else {
                $this->current_works->AdvancedSearch->ViewValue = $this->current_works->Lookup !== null && is_array($this->current_works->lookupOptions()) && count($this->current_works->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->current_works->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->current_works->EditValue = array_values($this->current_works->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->current_works->AdvancedSearch->SearchValue, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->current_works->EditValue = $arwrk;
            }
            $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

            // batch_no
            $this->batch_no->setupEditAttributes();
            $curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            } else {
                $this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== null && is_array($this->batch_no->lookupOptions()) && count($this->batch_no->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->batch_no->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->batch_no->EditValue = array_values($this->batch_no->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->batch_no->AdvancedSearch->SearchValue, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->batch_no->EditValue = $arwrk;
            }
            $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

            // URL_DSP
            $this->URL_DSP->setupEditAttributes();
            $this->URL_DSP->EditValue = HtmlEncode($this->URL_DSP->AdvancedSearch->SearchValue);
            $this->URL_DSP->PlaceHolder = RemoveHtml($this->URL_DSP->caption());

            // buyer_barcode
            $this->buyer_barcode->setupEditAttributes();
            if (!$this->buyer_barcode->Raw) {
                $this->buyer_barcode->AdvancedSearch->SearchValue = HtmlDecode($this->buyer_barcode->AdvancedSearch->SearchValue);
            }
            $this->buyer_barcode->EditValue = HtmlEncode($this->buyer_barcode->AdvancedSearch->SearchValue);
            $this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->order_quantity->AdvancedSearch->SearchValue)) {
            $this->order_quantity->addErrorMessage($this->order_quantity->getErrorMessage(false));
        }
        if (!CheckInteger($this->count->AdvancedSearch->SearchValue)) {
            $this->count->addErrorMessage($this->count->getErrorMessage(false));
        }
        if (!CheckInteger($this->count->AdvancedSearch->SearchValue2)) {
            $this->count->addErrorMessage($this->count->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm->AdvancedSearch->SearchValue2)) {
            $this->sqm->addErrorMessage($this->sqm->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm_a->AdvancedSearch->SearchValue)) {
            $this->sqm_a->addErrorMessage($this->sqm_a->getErrorMessage(false));
        }
        if (!CheckNumber($this->sqm_a->AdvancedSearch->SearchValue2)) {
            $this->sqm_a->addErrorMessage($this->sqm_a->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->buyer->AdvancedSearch->load();
        $this->po->AdvancedSearch->load();
        $this->buyer_ref->AdvancedSearch->load();
        $this->design_id->AdvancedSearch->load();
        $this->size_cm->AdvancedSearch->load();
        $this->Weaving->AdvancedSearch->load();
        $this->Packing->AdvancedSearch->load();
        $this->order_quantity->AdvancedSearch->load();
        $this->count->AdvancedSearch->load();
        $this->sqm->AdvancedSearch->load();
        $this->sqm_a->AdvancedSearch->load();
        $this->process_c->AdvancedSearch->load();
        $this->process_d->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->dispatch_week_p->AdvancedSearch->load();
        $this->current_works->AdvancedSearch->load();
        $this->batch_no->AdvancedSearch->load();
        $this->URL_DSP->AdvancedSearch->load();
        $this->buyer_barcode->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("queryproductiontablelist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_buyer":
                    break;
                case "x_design_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_Weaving":
                    break;
                case "x_Packing":
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_dispatch_week_p":
                    break;
                case "x_current_works":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_batch_no":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_process":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'query_production_table');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
