<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for query_production
 */
class QueryProduction extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = true;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $buyer;
    public $po;
    public $buyer_ref;
    public $design;
    public $size;
    public $design_id;
    public $size_cm;
    public $Weaving;
    public $Packing;
    public $order_quantity;
    public $count;
    public $sqm;
    public $sqm_a;
    public $process_c;
    public $process_d;
    public $status;
    public $_barcode;
    public $dispatch_week_p;
    public $current_works;
    public $shipping_type;
    public $batch_no;
    public $process;
    public $url;
    public $URL_DSP;
    public $id;
    public $buyer_barcode;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "query_production";
        $this->TableName = 'query_production';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "query_production";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // buyer
        $this->buyer = new DbField(
            $this, // Table
            'x_buyer', // Variable name
            'buyer', // Name
            '`buyer`', // Expression
            '`buyer`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__buyer', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer->addMethod("getLinkPrefix", fn() => "queryproductionlist?x_buyer=");
        $this->buyer->InputTextType = "text";
        $this->buyer->Raw = true;
        $this->buyer->Lookup = new Lookup($this->buyer, 'buyer', false, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->buyer->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer'] = &$this->buyer;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->addMethod("getLinkPrefix", fn() => "queryproductionlist?x_design_id=");
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->Lookup = new Lookup($this->po, 'po_b', true, 'po', ["po","","",""], '', '', [], [], [], [], [], [], false, '`po` ASC', '', "`po`");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // buyer_ref
        $this->buyer_ref = new DbField(
            $this, // Table
            'x_buyer_ref', // Variable name
            'buyer_ref', // Name
            '`buyer_ref`', // Expression
            '`buyer_ref`', // Basic search expression
            201, // Type
            2147483647, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_ref->InputTextType = "text";
        $this->buyer_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_ref'] = &$this->buyer_ref;

        // design
        $this->design = new DbField(
            $this, // Table
            'x_design', // Variable name
            'design', // Name
            '`design`', // Expression
            '`design`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design->InputTextType = "text";
        $this->design->Sortable = false; // Allow sort
        $this->design->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design'] = &$this->design;

        // size
        $this->size = new DbField(
            $this, // Table
            'x_size', // Variable name
            'size', // Name
            '`size`', // Expression
            '`size`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size->InputTextType = "text";
        $this->size->Nullable = false; // NOT NULL field
        $this->size->Required = true; // Required field
        $this->size->Sortable = false; // Allow sort
        $this->size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['size'] = &$this->size;

        // design_id
        $this->design_id = new DbField(
            $this, // Table
            'x_design_id', // Variable name
            'design_id', // Name
            '`design_id`', // Expression
            '`design_id`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->design_id->addMethod("getSelectFilter", fn() => "`product_type`  != 9 and `status` = 1");
        $this->design_id->addMethod("getLinkPrefix", fn() => "queryproductionlist?x_design_id=");
        $this->design_id->InputTextType = "text";
        $this->design_id->Sortable = false; // Allow sort
        $this->design_id->setSelectMultiple(false); // Select one
        $this->design_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->design_id->Lookup = new Lookup($this->design_id, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_id'] = &$this->design_id;

        // size_cm
        $this->size_cm = new DbField(
            $this, // Table
            'x_size_cm', // Variable name
            'size_cm', // Name
            '`size_cm`', // Expression
            '`size_cm`', // Basic search expression
            200, // Type
            245, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_cm->InputTextType = "text";
        $this->size_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_cm'] = &$this->size_cm;

        // Weaving
        $this->Weaving = new DbField(
            $this, // Table
            'x_Weaving', // Variable name
            'Weaving', // Name
            '`Weaving`', // Expression
            '`Weaving`', // Basic search expression
            200, // Type
            25, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Weaving`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Weaving->addMethod("getLinkPrefix", fn() => "queryproductionlist?x_Weaving=");
        $this->Weaving->InputTextType = "text";
        $this->Weaving->Nullable = false; // NOT NULL field
        $this->Weaving->Required = true; // Required field
        $this->Weaving->setSelectMultiple(false); // Select one
        $this->Weaving->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Weaving->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Weaving->Lookup = new Lookup($this->Weaving, 'query_production', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->Weaving->OptionCount = 2;
        $this->Weaving->SearchOperators = ["=", "<>"];
        $this->Fields['Weaving'] = &$this->Weaving;

        // Packing
        $this->Packing = new DbField(
            $this, // Table
            'x_Packing', // Variable name
            'Packing', // Name
            '`Packing`', // Expression
            '`Packing`', // Basic search expression
            200, // Type
            17, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Packing`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->Packing->addMethod("getLinkPrefix", fn() => "queryproductionlist?x_Packing=");
        $this->Packing->InputTextType = "text";
        $this->Packing->setSelectMultiple(false); // Select one
        $this->Packing->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->Packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->Packing->Lookup = new Lookup($this->Packing, 'query_production', true, 'Packing', ["Packing","","",""], '', '', [], [], [], [], [], [], false, '`Packing` ASC', '', "`Packing`");
        $this->Packing->OptionCount = 3;
        $this->Packing->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['Packing'] = &$this->Packing;

        // order_quantity
        $this->order_quantity = new DbField(
            $this, // Table
            'x_order_quantity', // Variable name
            'order_quantity', // Name
            '`order_quantity`', // Expression
            '`order_quantity`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`order_quantity`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_quantity->InputTextType = "text";
        $this->order_quantity->Raw = true;
        $this->order_quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->order_quantity->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['order_quantity'] = &$this->order_quantity;

        // count
        $this->count = new DbField(
            $this, // Table
            'x_count', // Variable name
            'count', // Name
            '`count`', // Expression
            '`count`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`count`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->count->addMethod("getDefault", fn() => 0);
        $this->count->InputTextType = "text";
        $this->count->Raw = true;
        $this->count->Nullable = false; // NOT NULL field
        $this->count->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->count->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['count'] = &$this->count;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            33, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm'] = &$this->sqm;

        // sqm_a
        $this->sqm_a = new DbField(
            $this, // Table
            'x_sqm_a', // Variable name
            'sqm_a', // Name
            '`sqm_a`', // Expression
            '`sqm_a`', // Basic search expression
            5, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm_a`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm_a->InputTextType = "text";
        $this->sqm_a->Raw = true;
        $this->sqm_a->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm_a->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm_a'] = &$this->sqm_a;

        // process_c
        $this->process_c = new DbField(
            $this, // Table
            'x_process_c', // Variable name
            'process_c', // Name
            '`process_c`', // Expression
            '`process_c`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_c`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->process_c->InputTextType = "text";
        $this->process_c->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_c'] = &$this->process_c;

        // process_d
        $this->process_d = new DbField(
            $this, // Table
            'x_process_d', // Variable name
            'process_d', // Name
            '`process_d`', // Expression
            '`process_d`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`process_d`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->process_d->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->process_d->InputTextType = "text";
        $this->process_d->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['process_d'] = &$this->process_d;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'status', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->addMethod("getDefault", fn() => 0);
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Required = true; // Required field
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['barcode'] = &$this->_barcode;

        // dispatch_week_p
        $this->dispatch_week_p = new DbField(
            $this, // Table
            'x_dispatch_week_p', // Variable name
            'dispatch_week_p', // Name
            '`dispatch_week_p`', // Expression
            '`dispatch_week_p`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`dispatch_week_p`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->dispatch_week_p->addMethod("getSelectFilter", fn() => "`weekstartday` >= date_add(NOW(), INTERVAL -28 Day)");
        $this->dispatch_week_p->InputTextType = "text";
        $this->dispatch_week_p->Raw = true;
        $this->dispatch_week_p->setSelectMultiple(false); // Select one
        $this->dispatch_week_p->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->dispatch_week_p->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->dispatch_week_p->Lookup = new Lookup($this->dispatch_week_p, 'not_week', false, 'id', ["week","weekstartday","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`week`, ''),'" . ValueSeparator(1, $this->dispatch_week_p) . "',COALESCE(" . CastDateFieldForLike("`weekstartday`", 111, "DB") . ",''))");
        $this->dispatch_week_p->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->dispatch_week_p->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['dispatch_week_p'] = &$this->dispatch_week_p;

        // current_works
        $this->current_works = new DbField(
            $this, // Table
            'x_current_works', // Variable name
            'current_works', // Name
            '`current_works`', // Expression
            '`current_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->current_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->current_works->addMethod("getDefault", fn() => 0);
        $this->current_works->InputTextType = "text";
        $this->current_works->Raw = true;
        $this->current_works->Nullable = false; // NOT NULL field
        $this->current_works->setSelectMultiple(false); // Select one
        $this->current_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->current_works->Lookup = new Lookup($this->current_works, 'godown_table', true, 'id', ["code","","",""], '', '', [], [], [], [], [], [], false, '`code` ASC', '', "`code`");
        $this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_works'] = &$this->current_works;

        // shipping_type
        $this->shipping_type = new DbField(
            $this, // Table
            'x_shipping_type', // Variable name
            'shipping_type', // Name
            '`shipping_type`', // Expression
            '`shipping_type`', // Basic search expression
            200, // Type
            100, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->shipping_type->addMethod("getSelectFilter", fn() => "`grp` = 82");
        $this->shipping_type->InputTextType = "text";
        $this->shipping_type->setSelectMultiple(false); // Select one
        $this->shipping_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->shipping_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->shipping_type->Lookup = new Lookup($this->shipping_type, 'misc', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->shipping_type->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_type'] = &$this->shipping_type;

        // batch_no
        $this->batch_no = new DbField(
            $this, // Table
            'x_batch_no', // Variable name
            'batch_no', // Name
            '`batch_no`', // Expression
            '`batch_no`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`batch_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->batch_no->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->batch_no->InputTextType = "text";
        $this->batch_no->Raw = true;
        $this->batch_no->setSelectMultiple(false); // Select one
        $this->batch_no->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->batch_no->Lookup = new Lookup($this->batch_no, 'batch_no', false, 'id', ["batch_no","","",""], '', '', [], [], [], [], [], [], false, '`batch_no` ASC', '', "`batch_no`");
        $this->batch_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->batch_no->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['batch_no'] = &$this->batch_no;

        // process
        $this->process = new DbField(
            $this, // Table
            'x_process', // Variable name
            'process', // Name
            '`process`', // Expression
            '`process`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            'EV__process', // Virtual expression
            true, // Is virtual
            true, // Force selection
            true, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->process->InputTextType = "text";
        $this->process->Sortable = false; // Allow sort
        $this->process->setSelectMultiple(true); // Select multiple
        $this->process->Lookup = new Lookup($this->process, 'sub_process_type', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->process->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['process'] = &$this->process;

        // url
        $this->url = new DbField(
            $this, // Table
            'x_url', // Variable name
            'url', // Name
            '`url`', // Expression
            '`url`', // Basic search expression
            200, // Type
            306, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`url`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->url->InputTextType = "text";
        $this->url->Sortable = false; // Allow sort
        $this->url->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['url'] = &$this->url;

        // URL_DSP
        $this->URL_DSP = new DbField(
            $this, // Table
            'x_URL_DSP', // Variable name
            'URL_DSP', // Name
            'concat(\'queryproductionlist?x_size_cm=\', `size_cm`, \'&x_po=\', `po`)', // Expression
            'concat(\'queryproductionlist?x_size_cm=\', `size_cm`, \'&x_po=\', `po`)', // Basic search expression
            201, // Type
            291, // Size
            -1, // Date/Time format
            false, // Is upload field
            'concat(\'queryproductionlist?x_size_cm=\', `size_cm`, \'&x_po=\', `po`)', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->URL_DSP->InputTextType = "text";
        $this->URL_DSP->IsCustom = true; // Custom field
        $this->URL_DSP->Sortable = false; // Allow sort
        $this->URL_DSP->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['URL_DSP'] = &$this->URL_DSP;

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Sortable = false; // Allow sort
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // buyer_barcode
        $this->buyer_barcode = new DbField(
            $this, // Table
            'x_buyer_barcode', // Variable name
            'buyer_barcode', // Name
            '`buyer_barcode`', // Expression
            '`buyer_barcode`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_barcode->InputTextType = "text";
        $this->buyer_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_barcode'] = &$this->buyer_barcode;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
            $sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortFieldList . " " . $curSort : "";
            if ($ctrl) {
                $orderByList = $this->getSessionOrderByList();
                $arOrderBy = !empty($orderByList) ? explode(", ", $orderByList) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderByList = implode(", ", $arOrderBy);
                $this->setSessionOrderByList($orderByList); // Save to Session
            } else {
                $this->setSessionOrderByList($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->useVirtualFields() ? $this->getSessionOrderByList() : $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Session ORDER BY for List page
    public function getSessionOrderByList()
    {
        return Session(PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST"));
    }

    public function setSessionOrderByList($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "query_production";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        return "*, concat('queryproductionlist?x_size_cm=', `size_cm`, '&x_po=', `po`) AS `URL_DSP`";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get SELECT clause for List page
    public function getSqlSelectList()
    {
        if ($this->SqlSelectList) {
            return $this->SqlSelectList;
        }
        $from = "(SELECT " . $this->sqlSelectFields() . ", (SELECT `code` FROM buyer TMP_LOOKUPTABLE WHERE TMP_LOOKUPTABLE.id = query_production.buyer LIMIT 1) AS EV__buyer FROM query_production)";
        return $from . " TMP_TABLE";
    }

    // Get SELECT clause for List page (for backward compatibility)
    public function sqlSelectList()
    {
        return $this->getSqlSelectList();
    }

    // Set SELECT clause for List page
    public function setSqlSelectList($v)
    {
        $this->SqlSelectList = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        if ($this->useVirtualFields()) {
            $select = "*";
            $from = $this->getSqlSelectList();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        } else {
            $select = $this->getSqlSelect();
            $from = $this->getSqlFrom();
            $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        }
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Check if virtual fields is used in SQL
    protected function useVirtualFields()
    {
        $where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
        $orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
        if ($where != "") {
            $where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
        }
        if ($orderBy != "") {
            $orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
        }
        if ($this->BasicSearch->getKeyword() != "") {
            return true;
        }
        if (
            $this->buyer->AdvancedSearch->SearchValue != "" ||
            $this->buyer->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->buyer->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->buyer->VirtualExpression . " ")) {
            return true;
        }
        if (
            $this->process->AdvancedSearch->SearchValue != "" ||
            $this->process->AdvancedSearch->SearchValue2 != "" ||
            ContainsString($where, " " . $this->process->VirtualExpression . " ")
        ) {
            return true;
        }
        if (ContainsString($orderBy, " " . $this->process->VirtualExpression . " ")) {
            return true;
        }
        return false;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        if ($this->useVirtualFields()) {
            $sql = $this->buildSelectSql("*", $this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        } else {
            $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        }
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->buyer->DbValue = $row['buyer'];
        $this->po->DbValue = $row['po'];
        $this->buyer_ref->DbValue = $row['buyer_ref'];
        $this->design->DbValue = $row['design'];
        $this->size->DbValue = $row['size'];
        $this->design_id->DbValue = $row['design_id'];
        $this->size_cm->DbValue = $row['size_cm'];
        $this->Weaving->DbValue = $row['Weaving'];
        $this->Packing->DbValue = $row['Packing'];
        $this->order_quantity->DbValue = $row['order_quantity'];
        $this->count->DbValue = $row['count'];
        $this->sqm->DbValue = $row['sqm'];
        $this->sqm_a->DbValue = $row['sqm_a'];
        $this->process_c->DbValue = $row['process_c'];
        $this->process_d->DbValue = $row['process_d'];
        $this->status->DbValue = $row['status'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->dispatch_week_p->DbValue = $row['dispatch_week_p'];
        $this->current_works->DbValue = $row['current_works'];
        $this->shipping_type->DbValue = $row['shipping_type'];
        $this->batch_no->DbValue = $row['batch_no'];
        $this->process->DbValue = $row['process'];
        $this->url->DbValue = $row['url'];
        $this->URL_DSP->DbValue = $row['URL_DSP'];
        $this->id->DbValue = $row['id'];
        $this->buyer_barcode->DbValue = $row['buyer_barcode'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("queryproductionlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "queryproductionview" => $Language->phrase("View"),
            "queryproductionedit" => $Language->phrase("Edit"),
            "queryproductionadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "queryproductionlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "QueryProductionView",
            Config("API_ADD_ACTION") => "QueryProductionAdd",
            Config("API_EDIT_ACTION") => "QueryProductionEdit",
            Config("API_DELETE_ACTION") => "QueryProductionDelete",
            Config("API_LIST_ACTION") => "QueryProductionList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "queryproductionlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("queryproductionview", $parm);
        } else {
            $url = $this->keyUrl("queryproductionview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "queryproductionadd?" . $parm;
        } else {
            $url = "queryproductionadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("queryproductionedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("queryproductionlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("queryproductionadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("queryproductionlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("queryproductiondelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->buyer->setDbValue($row['buyer']);
        $this->po->setDbValue($row['po']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->design->setDbValue($row['design']);
        $this->size->setDbValue($row['size']);
        $this->design_id->setDbValue($row['design_id']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->Weaving->setDbValue($row['Weaving']);
        $this->Packing->setDbValue($row['Packing']);
        $this->order_quantity->setDbValue($row['order_quantity']);
        $this->count->setDbValue($row['count']);
        $this->sqm->setDbValue($row['sqm']);
        $this->sqm_a->setDbValue($row['sqm_a']);
        $this->process_c->setDbValue($row['process_c']);
        $this->process_d->setDbValue($row['process_d']);
        $this->status->setDbValue($row['status']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->dispatch_week_p->setDbValue($row['dispatch_week_p']);
        $this->current_works->setDbValue($row['current_works']);
        $this->shipping_type->setDbValue($row['shipping_type']);
        $this->batch_no->setDbValue($row['batch_no']);
        $this->process->setDbValue($row['process']);
        $this->url->setDbValue($row['url']);
        $this->URL_DSP->setDbValue($row['URL_DSP']);
        $this->id->setDbValue($row['id']);
        $this->buyer_barcode->setDbValue($row['buyer_barcode']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "QueryProductionList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // buyer

        // po

        // buyer_ref

        // design
        $this->design->CellCssStyle = "white-space: nowrap;";

        // size
        $this->size->CellCssStyle = "white-space: nowrap;";

        // design_id

        // size_cm

        // Weaving

        // Packing

        // order_quantity

        // count

        // sqm

        // sqm_a

        // process_c

        // process_d

        // status

        // barcode
        $this->_barcode->CellCssStyle = "min-width: 300px;";

        // dispatch_week_p

        // current_works

        // shipping_type

        // batch_no

        // process
        $this->process->CellCssStyle = "white-space: nowrap;";

        // url
        $this->url->CellCssStyle = "white-space: nowrap;";

        // URL_DSP
        $this->URL_DSP->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->CellCssStyle = "white-space: nowrap;";

        // buyer_barcode

        // buyer
        if ($this->buyer->VirtualValue != "") {
            $this->buyer->ViewValue = $this->buyer->VirtualValue;
        } else {
            $this->buyer->ViewValue = $this->buyer->CurrentValue;
            $curVal = strval($this->buyer->CurrentValue);
            if ($curVal != "") {
                $this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
                if ($this->buyer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->buyer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->buyer->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->buyer->Lookup->renderViewRow($rswrk[0]);
                        $this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
                    } else {
                        $this->buyer->ViewValue = $this->buyer->CurrentValue;
                    }
                }
            } else {
                $this->buyer->ViewValue = null;
            }
        }

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $curVal = strval($this->po->CurrentValue);
        if ($curVal != "") {
            $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
            if ($this->po->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["po"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["po"]->searchDataType(), "");
                $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                    $this->po->ViewValue = $this->po->displayValue($arwrk);
                } else {
                    $this->po->ViewValue = $this->po->CurrentValue;
                }
            }
        } else {
            $this->po->ViewValue = null;
        }

        // buyer_ref
        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;

        // design
        $this->design->ViewValue = $this->design->CurrentValue;

        // size
        $this->size->ViewValue = $this->size->CurrentValue;

        // design_id
        $curVal = strval($this->design_id->CurrentValue);
        if ($curVal != "") {
            $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
            if ($this->design_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->ViewValue = $this->design_id->CurrentValue;
                }
            }
        } else {
            $this->design_id->ViewValue = null;
        }

        // size_cm
        $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

        // Weaving
        if (strval($this->Weaving->CurrentValue) != "") {
            $this->Weaving->ViewValue = $this->Weaving->optionCaption($this->Weaving->CurrentValue);
        } else {
            $this->Weaving->ViewValue = null;
        }

        // Packing
        if (strval($this->Packing->CurrentValue) != "") {
            $this->Packing->ViewValue = $this->Packing->optionCaption($this->Packing->CurrentValue);
        } else {
            $this->Packing->ViewValue = null;
        }

        // order_quantity
        $this->order_quantity->ViewValue = $this->order_quantity->CurrentValue;
        $this->order_quantity->ViewValue = FormatNumber($this->order_quantity->ViewValue, $this->order_quantity->formatPattern());

        // count
        $this->count->ViewValue = $this->count->CurrentValue;
        $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // sqm_a
        $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());

        // process_c
        $this->process_c->ViewValue = $this->process_c->CurrentValue;

        // process_d
        $this->process_d->ViewValue = $this->process_d->CurrentValue;

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

        // dispatch_week_p
        $curVal = strval($this->dispatch_week_p->CurrentValue);
        if ($curVal != "") {
            $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->lookupCacheOption($curVal);
            if ($this->dispatch_week_p->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->dispatch_week_p->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->dispatch_week_p->getSelectFilter($this); // PHP
                $sqlWrk = $this->dispatch_week_p->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->dispatch_week_p->Lookup->renderViewRow($rswrk[0]);
                    $this->dispatch_week_p->ViewValue = $this->dispatch_week_p->displayValue($arwrk);
                } else {
                    $this->dispatch_week_p->ViewValue = FormatNumber($this->dispatch_week_p->CurrentValue, $this->dispatch_week_p->formatPattern());
                }
            }
        } else {
            $this->dispatch_week_p->ViewValue = null;
        }

        // current_works
        $curVal = strval($this->current_works->CurrentValue);
        if ($curVal != "") {
            $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            if ($this->current_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                    $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                } else {
                    $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                }
            }
        } else {
            $this->current_works->ViewValue = null;
        }

        // shipping_type
        $curVal = strval($this->shipping_type->CurrentValue);
        if ($curVal != "") {
            $this->shipping_type->ViewValue = $this->shipping_type->lookupCacheOption($curVal);
            if ($this->shipping_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->shipping_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shipping_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->shipping_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->shipping_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->shipping_type->Lookup->renderViewRow($rswrk[0]);
                    $this->shipping_type->ViewValue = $this->shipping_type->displayValue($arwrk);
                } else {
                    $this->shipping_type->ViewValue = $this->shipping_type->CurrentValue;
                }
            }
        } else {
            $this->shipping_type->ViewValue = null;
        }

        // batch_no
        $curVal = strval($this->batch_no->CurrentValue);
        if ($curVal != "") {
            $this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
            if ($this->batch_no->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->batch_no->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->batch_no->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->batch_no->getSelectFilter($this); // PHP
                $sqlWrk = $this->batch_no->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->batch_no->Lookup->renderViewRow($rswrk[0]);
                    $this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
                } else {
                    $this->batch_no->ViewValue = FormatNumber($this->batch_no->CurrentValue, $this->batch_no->formatPattern());
                }
            }
        } else {
            $this->batch_no->ViewValue = null;
        }

        // process
        if ($this->process->VirtualValue != "") {
            $this->process->ViewValue = $this->process->VirtualValue;
        } else {
            $curVal = strval($this->process->CurrentValue);
            if ($curVal != "") {
                $this->process->ViewValue = $this->process->lookupCacheOption($curVal);
                if ($this->process->ViewValue === null) { // Lookup from database
                    $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                    $filterWrk = "";
                    foreach ($arwrk as $wrk) {
                        AddFilter($filterWrk, SearchFilter($this->process->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->process->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                    }
                    $sqlWrk = $this->process->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $this->process->ViewValue = new OptionValues();
                        foreach ($rswrk as $row) {
                            $arwrk = $this->process->Lookup->renderViewRow($row);
                            $this->process->ViewValue->add($this->process->displayValue($arwrk));
                        }
                    } else {
                        $this->process->ViewValue = $this->process->CurrentValue;
                    }
                }
            } else {
                $this->process->ViewValue = null;
            }
        }

        // url
        $this->url->ViewValue = $this->url->CurrentValue;

        // URL_DSP
        $this->URL_DSP->ViewValue = $this->URL_DSP->CurrentValue;

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // buyer_barcode
        $this->buyer_barcode->ViewValue = $this->buyer_barcode->CurrentValue;

        // buyer
        if (!EmptyValue($this->buyer->CurrentValue)) {
            $this->buyer->HrefValue = $this->buyer->getLinkPrefix() . $this->buyer->CurrentValue; // Add prefix/suffix
            $this->buyer->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyer->HrefValue = FullUrl($this->buyer->HrefValue, "href");
            }
        } else {
            $this->buyer->HrefValue = "";
        }
        $this->buyer->TooltipValue = "";

        // po
        if (!EmptyValue($this->po->CurrentValue)) {
            $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
            $this->po->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
            }
        } else {
            $this->po->HrefValue = "";
        }
        $this->po->TooltipValue = "";

        // buyer_ref
        $this->buyer_ref->HrefValue = "";
        $this->buyer_ref->TooltipValue = "";

        // design
        $this->design->HrefValue = "";
        $this->design->TooltipValue = "";

        // size
        $this->size->HrefValue = "";
        $this->size->TooltipValue = "";

        // design_id
        if (!EmptyValue($this->design_id->CurrentValue)) {
            $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . (!empty($this->design_id->ViewValue) && !is_array($this->design_id->ViewValue) ? RemoveHtml($this->design_id->ViewValue) : $this->design_id->CurrentValue); // Add prefix/suffix
            $this->design_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
            }
        } else {
            $this->design_id->HrefValue = "";
        }
        $this->design_id->TooltipValue = "";

        // size_cm
        if (!EmptyValue($this->URL_DSP->CurrentValue)) {
            $this->size_cm->HrefValue = $this->URL_DSP->CurrentValue; // Add prefix/suffix
            $this->size_cm->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->size_cm->HrefValue = FullUrl($this->size_cm->HrefValue, "href");
            }
        } else {
            $this->size_cm->HrefValue = "";
        }
        $this->size_cm->TooltipValue = "";

        // Weaving
        if (!EmptyValue($this->Weaving->CurrentValue)) {
            $this->Weaving->HrefValue = $this->Weaving->getLinkPrefix() . $this->Weaving->CurrentValue; // Add prefix/suffix
            $this->Weaving->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->Weaving->HrefValue = FullUrl($this->Weaving->HrefValue, "href");
            }
        } else {
            $this->Weaving->HrefValue = "";
        }
        $this->Weaving->TooltipValue = "";

        // Packing
        if (!EmptyValue($this->Packing->CurrentValue)) {
            $this->Packing->HrefValue = $this->Packing->getLinkPrefix() . $this->Packing->CurrentValue; // Add prefix/suffix
            $this->Packing->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->Packing->HrefValue = FullUrl($this->Packing->HrefValue, "href");
            }
        } else {
            $this->Packing->HrefValue = "";
        }
        $this->Packing->TooltipValue = "";

        // order_quantity
        if (!EmptyValue($this->url->CurrentValue)) {
            $this->order_quantity->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
            $this->order_quantity->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->order_quantity->HrefValue = FullUrl($this->order_quantity->HrefValue, "href");
            }
        } else {
            $this->order_quantity->HrefValue = "";
        }
        $this->order_quantity->TooltipValue = "";

        // count
        $this->count->HrefValue = "";
        $this->count->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // sqm_a
        $this->sqm_a->HrefValue = "";
        $this->sqm_a->TooltipValue = "";

        // process_c
        $this->process_c->HrefValue = "";
        $this->process_c->TooltipValue = "";

        // process_d
        $this->process_d->HrefValue = "";
        $this->process_d->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // barcode
        if (!EmptyValue($this->url->CurrentValue)) {
            $this->_barcode->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
            $this->_barcode->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->_barcode->HrefValue = FullUrl($this->_barcode->HrefValue, "href");
            }
        } else {
            $this->_barcode->HrefValue = "";
        }
        $this->_barcode->TooltipValue = "";

        // dispatch_week_p
        $this->dispatch_week_p->HrefValue = "";
        $this->dispatch_week_p->TooltipValue = "";

        // current_works
        $this->current_works->HrefValue = "";
        $this->current_works->TooltipValue = "";

        // shipping_type
        $this->shipping_type->HrefValue = "";
        $this->shipping_type->TooltipValue = "";

        // batch_no
        $this->batch_no->HrefValue = "";
        $this->batch_no->TooltipValue = "";

        // process
        $this->process->HrefValue = "";
        $this->process->TooltipValue = "";

        // url
        $this->url->HrefValue = "";
        $this->url->TooltipValue = "";

        // URL_DSP
        $this->URL_DSP->HrefValue = "";
        $this->URL_DSP->TooltipValue = "";

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // buyer_barcode
        $this->buyer_barcode->HrefValue = "";
        $this->buyer_barcode->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // buyer
        $this->buyer->setupEditAttributes();
        $this->buyer->EditValue = $this->buyer->CurrentValue;
        $this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $curVal = strval($this->po->CurrentValue);
        if ($curVal != "") {
            $this->po->EditValue = $this->po->lookupCacheOption($curVal);
            if ($this->po->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["po"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["po"]->searchDataType(), "");
                $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                    $this->po->EditValue = $this->po->displayValue($arwrk);
                } else {
                    $this->po->EditValue = $this->po->CurrentValue;
                }
            }
        } else {
            $this->po->EditValue = null;
        }

        // buyer_ref
        $this->buyer_ref->setupEditAttributes();
        if (!$this->buyer_ref->Raw) {
            $this->buyer_ref->CurrentValue = HtmlDecode($this->buyer_ref->CurrentValue);
        }
        $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
        $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

        // design
        $this->design->setupEditAttributes();
        if (!$this->design->Raw) {
            $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
        }
        $this->design->EditValue = $this->design->CurrentValue;
        $this->design->PlaceHolder = RemoveHtml($this->design->caption());

        // size
        $this->size->setupEditAttributes();
        if (!$this->size->Raw) {
            $this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
        }
        $this->size->EditValue = $this->size->CurrentValue;
        $this->size->PlaceHolder = RemoveHtml($this->size->caption());

        // design_id
        $this->design_id->setupEditAttributes();
        $this->design_id->PlaceHolder = RemoveHtml($this->design_id->caption());

        // size_cm
        $this->size_cm->setupEditAttributes();
        $this->size_cm->EditValue = $this->size_cm->CurrentValue;

        // Weaving
        $this->Weaving->setupEditAttributes();
        $this->Weaving->EditValue = $this->Weaving->options(true);
        $this->Weaving->PlaceHolder = RemoveHtml($this->Weaving->caption());

        // Packing
        $this->Packing->setupEditAttributes();
        $this->Packing->EditValue = $this->Packing->options(true);
        $this->Packing->PlaceHolder = RemoveHtml($this->Packing->caption());

        // order_quantity
        $this->order_quantity->setupEditAttributes();
        $this->order_quantity->EditValue = $this->order_quantity->CurrentValue;
        $this->order_quantity->PlaceHolder = RemoveHtml($this->order_quantity->caption());
        if (strval($this->order_quantity->EditValue) != "" && is_numeric($this->order_quantity->EditValue)) {
            $this->order_quantity->EditValue = FormatNumber($this->order_quantity->EditValue, null);
        }

        // count
        $this->count->setupEditAttributes();
        $this->count->EditValue = $this->count->CurrentValue;
        $this->count->PlaceHolder = RemoveHtml($this->count->caption());
        if (strval($this->count->EditValue) != "" && is_numeric($this->count->EditValue)) {
            $this->count->EditValue = FormatNumber($this->count->EditValue, null);
        }

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // sqm_a
        $this->sqm_a->setupEditAttributes();
        $this->sqm_a->EditValue = $this->sqm_a->CurrentValue;
        $this->sqm_a->PlaceHolder = RemoveHtml($this->sqm_a->caption());
        if (strval($this->sqm_a->EditValue) != "" && is_numeric($this->sqm_a->EditValue)) {
            $this->sqm_a->EditValue = FormatNumber($this->sqm_a->EditValue, null);
        }

        // process_c
        $this->process_c->setupEditAttributes();
        if (!$this->process_c->Raw) {
            $this->process_c->CurrentValue = HtmlDecode($this->process_c->CurrentValue);
        }
        $this->process_c->EditValue = $this->process_c->CurrentValue;
        $this->process_c->PlaceHolder = RemoveHtml($this->process_c->caption());

        // process_d
        $this->process_d->setupEditAttributes();
        if (!$this->process_d->Raw) {
            $this->process_d->CurrentValue = HtmlDecode($this->process_d->CurrentValue);
        }
        $this->process_d->EditValue = $this->process_d->CurrentValue;
        $this->process_d->PlaceHolder = RemoveHtml($this->process_d->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;

        // dispatch_week_p
        $this->dispatch_week_p->setupEditAttributes();
        $this->dispatch_week_p->PlaceHolder = RemoveHtml($this->dispatch_week_p->caption());

        // current_works
        $this->current_works->setupEditAttributes();
        $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

        // shipping_type
        $this->shipping_type->setupEditAttributes();
        $this->shipping_type->PlaceHolder = RemoveHtml($this->shipping_type->caption());

        // batch_no
        $this->batch_no->setupEditAttributes();
        $this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

        // process
        $this->process->setupEditAttributes();
        $this->process->PlaceHolder = RemoveHtml($this->process->caption());

        // url
        $this->url->setupEditAttributes();
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->PlaceHolder = RemoveHtml($this->url->caption());

        // URL_DSP
        $this->URL_DSP->setupEditAttributes();
        $this->URL_DSP->EditValue = $this->URL_DSP->CurrentValue;
        $this->URL_DSP->PlaceHolder = RemoveHtml($this->URL_DSP->caption());

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());

        // buyer_barcode
        $this->buyer_barcode->setupEditAttributes();
        if (!$this->buyer_barcode->Raw) {
            $this->buyer_barcode->CurrentValue = HtmlDecode($this->buyer_barcode->CurrentValue);
        }
        $this->buyer_barcode->EditValue = $this->buyer_barcode->CurrentValue;
        $this->buyer_barcode->PlaceHolder = RemoveHtml($this->buyer_barcode->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->count->CurrentValue)) {
                $this->count->Total += $this->count->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->sqm->CurrentValue)) {
                $this->sqm->Total += $this->sqm->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->sqm_a->CurrentValue)) {
                $this->sqm_a->Total += $this->sqm_a->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->count->CurrentValue = $this->count->Total;
            $this->count->ViewValue = $this->count->CurrentValue;
            $this->count->ViewValue = FormatNumber($this->count->ViewValue, $this->count->formatPattern());
            $this->count->HrefValue = ""; // Clear href value
            $this->sqm->CurrentValue = $this->sqm->Total;
            $this->sqm->ViewValue = $this->sqm->CurrentValue;
            $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());
            $this->sqm->HrefValue = ""; // Clear href value
            $this->sqm_a->CurrentValue = $this->sqm_a->Total;
            $this->sqm_a->ViewValue = $this->sqm_a->CurrentValue;
            $this->sqm_a->ViewValue = FormatNumber($this->sqm_a->ViewValue, $this->sqm_a->formatPattern());
            $this->sqm_a->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->buyer);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->Weaving);
                    $doc->exportCaption($this->Packing);
                    $doc->exportCaption($this->order_quantity);
                    $doc->exportCaption($this->count);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->process_c);
                    $doc->exportCaption($this->process_d);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->dispatch_week_p);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->shipping_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->buyer_barcode);
                } else {
                    $doc->exportCaption($this->buyer);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->Weaving);
                    $doc->exportCaption($this->Packing);
                    $doc->exportCaption($this->order_quantity);
                    $doc->exportCaption($this->count);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->sqm_a);
                    $doc->exportCaption($this->process_c);
                    $doc->exportCaption($this->process_d);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->dispatch_week_p);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->shipping_type);
                    $doc->exportCaption($this->batch_no);
                    $doc->exportCaption($this->process);
                    $doc->exportCaption($this->buyer_barcode);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->buyer);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->Weaving);
                        $doc->exportField($this->Packing);
                        $doc->exportField($this->order_quantity);
                        $doc->exportField($this->count);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->process_c);
                        $doc->exportField($this->process_d);
                        $doc->exportField($this->status);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->dispatch_week_p);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->shipping_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->process);
                        $doc->exportField($this->buyer_barcode);
                    } else {
                        $doc->exportField($this->buyer);
                        $doc->exportField($this->po);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->design);
                        $doc->exportField($this->size);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->Weaving);
                        $doc->exportField($this->Packing);
                        $doc->exportField($this->order_quantity);
                        $doc->exportField($this->count);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->sqm_a);
                        $doc->exportField($this->process_c);
                        $doc->exportField($this->process_d);
                        $doc->exportField($this->status);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->dispatch_week_p);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->shipping_type);
                        $doc->exportField($this->batch_no);
                        $doc->exportField($this->process);
                        $doc->exportField($this->buyer_barcode);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->buyer, '');
                $doc->exportAggregate($this->po, '');
                $doc->exportAggregate($this->buyer_ref, '');
                $doc->exportAggregate($this->design, '');
                $doc->exportAggregate($this->size, '');
                $doc->exportAggregate($this->size_cm, '');
                $doc->exportAggregate($this->Weaving, '');
                $doc->exportAggregate($this->Packing, '');
                $doc->exportAggregate($this->order_quantity, '');
                $doc->exportAggregate($this->count, 'TOTAL');
                $doc->exportAggregate($this->sqm, 'TOTAL');
                $doc->exportAggregate($this->sqm_a, 'TOTAL');
                $doc->exportAggregate($this->process_c, '');
                $doc->exportAggregate($this->process_d, '');
                $doc->exportAggregate($this->status, '');
                $doc->exportAggregate($this->_barcode, '');
                $doc->exportAggregate($this->dispatch_week_p, '');
                $doc->exportAggregate($this->current_works, '');
                $doc->exportAggregate($this->shipping_type, '');
                $doc->exportAggregate($this->batch_no, '');
                $doc->exportAggregate($this->process, '');
                $doc->exportAggregate($this->buyer_barcode, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
