<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for query_pppo_pending
 */
class QueryPppoPending extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $po;
    public $design_id;
    public $size_cm;
    public $despatch_week;
    public $Order;
    public $Received;
    public $Pending;
    public $ReceivedBC;
    public $PendingBC;
    public $size_buyer;
    public $buyer_ref;
    public $buyers_id;
    public $pp_id;
    public $design;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "query_pppo_pending";
        $this->TableName = 'query_pppo_pending';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "query_pppo_pending";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->addMethod("getLinkPrefix", fn() => "querypppopendinglist?x_po=");
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // design_id
        $this->design_id = new DbField(
            $this, // Table
            'x_design_id', // Variable name
            'design_id', // Name
            '`design_id`', // Expression
            '`design_id`', // Basic search expression
            200, // Type
            196, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->design_id->addMethod("getSelectFilter", fn() => "`product_type`  != 9 and `status` = 1");
        $this->design_id->addMethod("getLinkPrefix", fn() => "querypppopendinglist?x_design_id=");
        $this->design_id->InputTextType = "text";
        $this->design_id->setSelectMultiple(false); // Select one
        $this->design_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->design_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->design_id->Lookup = new Lookup($this->design_id, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design_id->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['design_id'] = &$this->design_id;

        // size_cm
        $this->size_cm = new DbField(
            $this, // Table
            'x_size_cm', // Variable name
            'size_cm', // Name
            '`size_cm`', // Expression
            '`size_cm`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_cm->addMethod("getLinkPrefix", fn() => "querypppopendinglist?x_size_cm=");
        $this->size_cm->InputTextType = "text";
        $this->size_cm->Nullable = false; // NOT NULL field
        $this->size_cm->Required = true; // Required field
        $this->size_cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['size_cm'] = &$this->size_cm;

        // despatch_week
        $this->despatch_week = new DbField(
            $this, // Table
            'x_despatch_week', // Variable name
            'despatch_week', // Name
            '`despatch_week`', // Expression
            '`despatch_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`despatch_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->despatch_week->addMethod("getLinkPrefix", fn() => "querypppopendinglist?x_despatch_week=");
        $this->despatch_week->InputTextType = "text";
        $this->despatch_week->Raw = true;
        $this->despatch_week->setSelectMultiple(false); // Select one
        $this->despatch_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->despatch_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->despatch_week->Lookup = new Lookup($this->despatch_week, 'not_week', false, 'id', ["wid","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`wid`, ''),'" . ValueSeparator(1, $this->despatch_week) . "',COALESCE(`wed`,''))");
        $this->despatch_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->despatch_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['despatch_week'] = &$this->despatch_week;

        // Order
        $this->Order = new DbField(
            $this, // Table
            'x_Order', // Variable name
            'Order', // Name
            '`Order`', // Expression
            '`Order`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Order`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Order->addMethod("getDefault", fn() => 0);
        $this->Order->InputTextType = "text";
        $this->Order->Raw = true;
        $this->Order->Nullable = false; // NOT NULL field
        $this->Order->Required = true; // Required field
        $this->Order->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Order->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Order'] = &$this->Order;

        // Received
        $this->Received = new DbField(
            $this, // Table
            'x_Received', // Variable name
            'Received', // Name
            '`Received`', // Expression
            '`Received`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Received`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Received->addMethod("getDefault", fn() => 0);
        $this->Received->InputTextType = "text";
        $this->Received->Raw = true;
        $this->Received->Nullable = false; // NOT NULL field
        $this->Received->Required = true; // Required field
        $this->Received->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Received->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Received'] = &$this->Received;

        // Pending
        $this->Pending = new DbField(
            $this, // Table
            'x_Pending', // Variable name
            'Pending', // Name
            '`Pending`', // Expression
            '`Pending`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Pending`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->Pending->addMethod("getDefault", fn() => 0);
        $this->Pending->InputTextType = "text";
        $this->Pending->Raw = true;
        $this->Pending->Nullable = false; // NOT NULL field
        $this->Pending->Required = true; // Required field
        $this->Pending->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Pending->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['Pending'] = &$this->Pending;

        // Received BC
        $this->ReceivedBC = new DbField(
            $this, // Table
            'x_ReceivedBC', // Variable name
            'Received BC', // Name
            '`Received BC`', // Expression
            '`Received BC`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Received BC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->ReceivedBC->InputTextType = "text";
        $this->ReceivedBC->Nullable = false; // NOT NULL field
        $this->ReceivedBC->Required = true; // Required field
        $this->ReceivedBC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Received BC'] = &$this->ReceivedBC;

        // Pending BC
        $this->PendingBC = new DbField(
            $this, // Table
            'x_PendingBC', // Variable name
            'Pending BC', // Name
            '`Pending BC`', // Expression
            '`Pending BC`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`Pending BC`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->PendingBC->InputTextType = "text";
        $this->PendingBC->Nullable = false; // NOT NULL field
        $this->PendingBC->Required = true; // Required field
        $this->PendingBC->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['Pending BC'] = &$this->PendingBC;

        // size_buyer
        $this->size_buyer = new DbField(
            $this, // Table
            'x_size_buyer', // Variable name
            'size_buyer', // Name
            '`size_buyer`', // Expression
            '`size_buyer`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_buyer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_buyer->InputTextType = "text";
        $this->size_buyer->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_buyer'] = &$this->size_buyer;

        // buyer_ref
        $this->buyer_ref = new DbField(
            $this, // Table
            'x_buyer_ref', // Variable name
            'buyer_ref', // Name
            '`buyer_ref`', // Expression
            '`buyer_ref`', // Basic search expression
            200, // Type
            1000, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyer_ref->addMethod("getLinkPrefix", fn() => "querypppopendinglist?x_buyer_ref=");
        $this->buyer_ref->InputTextType = "text";
        $this->buyer_ref->setSelectMultiple(false); // Select one
        $this->buyer_ref->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyer_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyer_ref->Lookup = new Lookup($this->buyer_ref, 'partner_product_ref', false, 'id', ["partner_ref","","",""], '', '', ["x_buyers_id"], [], ["partner"], ["x_partner"], [], [], false, '`partner_ref` ASC', '', "`partner_ref`");
        $this->buyer_ref->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_ref'] = &$this->buyer_ref;

        // buyers_id
        $this->buyers_id = new DbField(
            $this, // Table
            'x_buyers_id', // Variable name
            'buyers_id', // Name
            '`buyers_id`', // Expression
            '`buyers_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyers_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyers_id->addMethod("getSelectFilter", fn() => "`partner_type` = 2 and `id` >= 1000 and `status` = 1");
        $this->buyers_id->addMethod("getLinkPrefix", fn() => "querypppopendinglist?x_buyers_id=");
        $this->buyers_id->InputTextType = "text";
        $this->buyers_id->Raw = true;
        $this->buyers_id->setSelectMultiple(false); // Select one
        $this->buyers_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyers_id->Lookup = new Lookup($this->buyers_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], ["x_buyer_ref"], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyers_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyers_id'] = &$this->buyers_id;

        // pp_id
        $this->pp_id = new DbField(
            $this, // Table
            'x_pp_id', // Variable name
            'pp_id', // Name
            '`pp_id`', // Expression
            '`pp_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pp_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->pp_id->addMethod("getSelectFilter", fn() => "`partner_type` = 1 and `id` >= 200000 and `status` = 1");
        $this->pp_id->addMethod("getLinkPrefix", fn() => "querypppopendinglist?x_pp_id=");
        $this->pp_id->InputTextType = "text";
        $this->pp_id->Raw = true;
        $this->pp_id->setSelectMultiple(false); // Select one
        $this->pp_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->pp_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->pp_id->Lookup = new Lookup($this->pp_id, 'buyer_seller_view', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->pp_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->pp_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pp_id'] = &$this->pp_id;

        // design
        $this->design = new DbField(
            $this, // Table
            'x_design', // Variable name
            'design', // Name
            '`design`', // Expression
            '`design`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design->addMethod("getSelectFilter", fn() => "`product_type`  != 9 and `status` = 1");
        $this->design->InputTextType = "text";
        $this->design->Sortable = false; // Allow sort
        $this->design->Lookup = new Lookup($this->design, 'ref', false, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], false, '`product_code` ASC', '', "`product_code`");
        $this->design->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->design->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design'] = &$this->design;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "query_pppo_pending";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->po->DbValue = $row['po'];
        $this->design_id->DbValue = $row['design_id'];
        $this->size_cm->DbValue = $row['size_cm'];
        $this->despatch_week->DbValue = $row['despatch_week'];
        $this->Order->DbValue = $row['Order'];
        $this->Received->DbValue = $row['Received'];
        $this->Pending->DbValue = $row['Pending'];
        $this->ReceivedBC->DbValue = $row['Received BC'];
        $this->PendingBC->DbValue = $row['Pending BC'];
        $this->size_buyer->DbValue = $row['size_buyer'];
        $this->buyer_ref->DbValue = $row['buyer_ref'];
        $this->buyers_id->DbValue = $row['buyers_id'];
        $this->pp_id->DbValue = $row['pp_id'];
        $this->design->DbValue = $row['design'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("querypppopendinglist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "querypppopendingview" => $Language->phrase("View"),
            "querypppopendingedit" => $Language->phrase("Edit"),
            "querypppopendingadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "querypppopendinglist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "QueryPppoPendingView",
            Config("API_ADD_ACTION") => "QueryPppoPendingAdd",
            Config("API_EDIT_ACTION") => "QueryPppoPendingEdit",
            Config("API_DELETE_ACTION") => "QueryPppoPendingDelete",
            Config("API_LIST_ACTION") => "QueryPppoPendingList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "querypppopendinglist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("querypppopendingview", $parm);
        } else {
            $url = $this->keyUrl("querypppopendingview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "querypppopendingadd?" . $parm;
        } else {
            $url = "querypppopendingadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("querypppopendingedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("querypppopendinglist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("querypppopendingadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("querypppopendinglist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("querypppopendingdelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->po->setDbValue($row['po']);
        $this->design_id->setDbValue($row['design_id']);
        $this->size_cm->setDbValue($row['size_cm']);
        $this->despatch_week->setDbValue($row['despatch_week']);
        $this->Order->setDbValue($row['Order']);
        $this->Received->setDbValue($row['Received']);
        $this->Pending->setDbValue($row['Pending']);
        $this->ReceivedBC->setDbValue($row['Received BC']);
        $this->PendingBC->setDbValue($row['Pending BC']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->pp_id->setDbValue($row['pp_id']);
        $this->design->setDbValue($row['design']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "QueryPppoPendingList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // po

        // design_id

        // size_cm

        // despatch_week

        // Order

        // Received

        // Pending

        // Received BC

        // Pending BC

        // size_buyer

        // buyer_ref

        // buyers_id

        // pp_id

        // design
        $this->design->CellCssStyle = "white-space: nowrap;";

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // design_id
        $curVal = strval($this->design_id->CurrentValue);
        if ($curVal != "") {
            $this->design_id->ViewValue = $this->design_id->lookupCacheOption($curVal);
            if ($this->design_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->ViewValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->ViewValue = $this->design_id->CurrentValue;
                }
            }
        } else {
            $this->design_id->ViewValue = null;
        }

        // size_cm
        $this->size_cm->ViewValue = $this->size_cm->CurrentValue;

        // despatch_week
        $curVal = strval($this->despatch_week->CurrentValue);
        if ($curVal != "") {
            $this->despatch_week->ViewValue = $this->despatch_week->lookupCacheOption($curVal);
            if ($this->despatch_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->despatch_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->despatch_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->despatch_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->despatch_week->Lookup->renderViewRow($rswrk[0]);
                    $this->despatch_week->ViewValue = $this->despatch_week->displayValue($arwrk);
                } else {
                    $this->despatch_week->ViewValue = FormatNumber($this->despatch_week->CurrentValue, $this->despatch_week->formatPattern());
                }
            }
        } else {
            $this->despatch_week->ViewValue = null;
        }

        // Order
        $this->Order->ViewValue = $this->Order->CurrentValue;
        $this->Order->ViewValue = FormatNumber($this->Order->ViewValue, $this->Order->formatPattern());

        // Received
        $this->Received->ViewValue = $this->Received->CurrentValue;
        $this->Received->ViewValue = FormatNumber($this->Received->ViewValue, $this->Received->formatPattern());

        // Pending
        $this->Pending->ViewValue = $this->Pending->CurrentValue;
        $this->Pending->ViewValue = FormatNumber($this->Pending->ViewValue, $this->Pending->formatPattern());

        // Received BC
        $this->ReceivedBC->ViewValue = $this->ReceivedBC->CurrentValue;

        // Pending BC
        $this->PendingBC->ViewValue = $this->PendingBC->CurrentValue;

        // size_buyer
        $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

        // buyer_ref
        $curVal = strval($this->buyer_ref->CurrentValue);
        if ($curVal != "") {
            $this->buyer_ref->ViewValue = $this->buyer_ref->lookupCacheOption($curVal);
            if ($this->buyer_ref->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_ref->ViewValue = $this->buyer_ref->displayValue($arwrk);
                } else {
                    $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;
                }
            }
        } else {
            $this->buyer_ref->ViewValue = null;
        }

        // buyers_id
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->ViewValue = null;
        }

        // pp_id
        $curVal = strval($this->pp_id->CurrentValue);
        if ($curVal != "") {
            $this->pp_id->ViewValue = $this->pp_id->lookupCacheOption($curVal);
            if ($this->pp_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->pp_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->pp_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->pp_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->pp_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->pp_id->Lookup->renderViewRow($rswrk[0]);
                    $this->pp_id->ViewValue = $this->pp_id->displayValue($arwrk);
                } else {
                    $this->pp_id->ViewValue = FormatNumber($this->pp_id->CurrentValue, $this->pp_id->formatPattern());
                }
            }
        } else {
            $this->pp_id->ViewValue = null;
        }

        // design
        $this->design->ViewValue = $this->design->CurrentValue;
        $curVal = strval($this->design->CurrentValue);
        if ($curVal != "") {
            $this->design->ViewValue = $this->design->lookupCacheOption($curVal);
            if ($this->design->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design->getSelectFilter($this); // PHP
                $sqlWrk = $this->design->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design->Lookup->renderViewRow($rswrk[0]);
                    $this->design->ViewValue = $this->design->displayValue($arwrk);
                } else {
                    $this->design->ViewValue = $this->design->CurrentValue;
                }
            }
        } else {
            $this->design->ViewValue = null;
        }

        // po
        if (!EmptyValue($this->po->CurrentValue)) {
            $this->po->HrefValue = $this->po->getLinkPrefix() . $this->po->CurrentValue; // Add prefix/suffix
            $this->po->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
            }
        } else {
            $this->po->HrefValue = "";
        }
        $this->po->TooltipValue = "";

        // design_id
        if (!EmptyValue($this->design_id->CurrentValue)) {
            $this->design_id->HrefValue = $this->design_id->getLinkPrefix() . $this->design_id->CurrentValue; // Add prefix/suffix
            $this->design_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->design_id->HrefValue = FullUrl($this->design_id->HrefValue, "href");
            }
        } else {
            $this->design_id->HrefValue = "";
        }
        $this->design_id->TooltipValue = "";

        // size_cm
        if (!EmptyValue($this->size_cm->CurrentValue)) {
            $this->size_cm->HrefValue = $this->size_cm->getLinkPrefix() . $this->size_cm->CurrentValue; // Add prefix/suffix
            $this->size_cm->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->size_cm->HrefValue = FullUrl($this->size_cm->HrefValue, "href");
            }
        } else {
            $this->size_cm->HrefValue = "";
        }
        $this->size_cm->TooltipValue = "";

        // despatch_week
        if (!EmptyValue($this->despatch_week->CurrentValue)) {
            $this->despatch_week->HrefValue = $this->despatch_week->getLinkPrefix() . $this->despatch_week->CurrentValue; // Add prefix/suffix
            $this->despatch_week->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->despatch_week->HrefValue = FullUrl($this->despatch_week->HrefValue, "href");
            }
        } else {
            $this->despatch_week->HrefValue = "";
        }
        $this->despatch_week->TooltipValue = "";

        // Order
        $this->Order->HrefValue = "";
        $this->Order->TooltipValue = "";

        // Received
        $this->Received->HrefValue = "";
        $this->Received->TooltipValue = "";

        // Pending
        $this->Pending->HrefValue = "";
        $this->Pending->TooltipValue = "";

        // Received BC
        $this->ReceivedBC->HrefValue = "";
        $this->ReceivedBC->TooltipValue = "";

        // Pending BC
        $this->PendingBC->HrefValue = "";
        $this->PendingBC->TooltipValue = "";

        // size_buyer
        $this->size_buyer->HrefValue = "";
        $this->size_buyer->TooltipValue = "";

        // buyer_ref
        if (!EmptyValue($this->buyer_ref->CurrentValue)) {
            $this->buyer_ref->HrefValue = $this->buyer_ref->getLinkPrefix() . $this->buyer_ref->CurrentValue; // Add prefix/suffix
            $this->buyer_ref->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyer_ref->HrefValue = FullUrl($this->buyer_ref->HrefValue, "href");
            }
        } else {
            $this->buyer_ref->HrefValue = "";
        }
        $this->buyer_ref->TooltipValue = "";

        // buyers_id
        if (!EmptyValue($this->buyers_id->CurrentValue)) {
            $this->buyers_id->HrefValue = $this->buyers_id->getLinkPrefix() . $this->buyers_id->CurrentValue; // Add prefix/suffix
            $this->buyers_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->buyers_id->HrefValue = FullUrl($this->buyers_id->HrefValue, "href");
            }
        } else {
            $this->buyers_id->HrefValue = "";
        }
        $this->buyers_id->TooltipValue = "";

        // pp_id
        if (!EmptyValue($this->pp_id->CurrentValue)) {
            $this->pp_id->HrefValue = $this->pp_id->getLinkPrefix() . $this->pp_id->CurrentValue; // Add prefix/suffix
            $this->pp_id->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->pp_id->HrefValue = FullUrl($this->pp_id->HrefValue, "href");
            }
        } else {
            $this->pp_id->HrefValue = "";
        }
        $this->pp_id->TooltipValue = "";

        // design
        $this->design->HrefValue = "";
        $this->design->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->EditValue = FormatNumber($this->po->EditValue, $this->po->formatPattern());

        // design_id
        $this->design_id->setupEditAttributes();
        $curVal = strval($this->design_id->CurrentValue);
        if ($curVal != "") {
            $this->design_id->EditValue = $this->design_id->lookupCacheOption($curVal);
            if ($this->design_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->design_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->design_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->design_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->design_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->design_id->Lookup->renderViewRow($rswrk[0]);
                    $this->design_id->EditValue = $this->design_id->displayValue($arwrk);
                } else {
                    $this->design_id->EditValue = $this->design_id->CurrentValue;
                }
            }
        } else {
            $this->design_id->EditValue = null;
        }

        // size_cm
        $this->size_cm->setupEditAttributes();
        $this->size_cm->EditValue = $this->size_cm->CurrentValue;

        // despatch_week
        $this->despatch_week->setupEditAttributes();
        $this->despatch_week->PlaceHolder = RemoveHtml($this->despatch_week->caption());

        // Order
        $this->Order->setupEditAttributes();
        $this->Order->EditValue = $this->Order->CurrentValue;
        $this->Order->PlaceHolder = RemoveHtml($this->Order->caption());
        if (strval($this->Order->EditValue) != "" && is_numeric($this->Order->EditValue)) {
            $this->Order->EditValue = FormatNumber($this->Order->EditValue, null);
        }

        // Received
        $this->Received->setupEditAttributes();
        $this->Received->EditValue = $this->Received->CurrentValue;
        $this->Received->PlaceHolder = RemoveHtml($this->Received->caption());
        if (strval($this->Received->EditValue) != "" && is_numeric($this->Received->EditValue)) {
            $this->Received->EditValue = FormatNumber($this->Received->EditValue, null);
        }

        // Pending
        $this->Pending->setupEditAttributes();
        $this->Pending->EditValue = $this->Pending->CurrentValue;
        $this->Pending->PlaceHolder = RemoveHtml($this->Pending->caption());
        if (strval($this->Pending->EditValue) != "" && is_numeric($this->Pending->EditValue)) {
            $this->Pending->EditValue = FormatNumber($this->Pending->EditValue, null);
        }

        // Received BC
        $this->ReceivedBC->setupEditAttributes();
        $this->ReceivedBC->EditValue = $this->ReceivedBC->CurrentValue;
        $this->ReceivedBC->PlaceHolder = RemoveHtml($this->ReceivedBC->caption());

        // Pending BC
        $this->PendingBC->setupEditAttributes();
        $this->PendingBC->EditValue = $this->PendingBC->CurrentValue;
        $this->PendingBC->PlaceHolder = RemoveHtml($this->PendingBC->caption());

        // size_buyer
        $this->size_buyer->setupEditAttributes();
        $this->size_buyer->EditValue = $this->size_buyer->CurrentValue;

        // buyer_ref
        $this->buyer_ref->setupEditAttributes();
        $curVal = strval($this->buyer_ref->CurrentValue);
        if ($curVal != "") {
            $this->buyer_ref->EditValue = $this->buyer_ref->lookupCacheOption($curVal);
            if ($this->buyer_ref->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyer_ref->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyer_ref->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyer_ref->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyer_ref->Lookup->renderViewRow($rswrk[0]);
                    $this->buyer_ref->EditValue = $this->buyer_ref->displayValue($arwrk);
                } else {
                    $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
                }
            }
        } else {
            $this->buyer_ref->EditValue = null;
        }

        // buyers_id
        $this->buyers_id->setupEditAttributes();
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->EditValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->buyers_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->EditValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->EditValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->EditValue = null;
        }

        // pp_id
        $this->pp_id->setupEditAttributes();
        $this->pp_id->PlaceHolder = RemoveHtml($this->pp_id->caption());

        // design
        $this->design->setupEditAttributes();
        if (!$this->design->Raw) {
            $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
        }
        $this->design->EditValue = $this->design->CurrentValue;
        $this->design->PlaceHolder = RemoveHtml($this->design->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
            if (is_numeric($this->Order->CurrentValue)) {
                $this->Order->Total += $this->Order->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->Received->CurrentValue)) {
                $this->Received->Total += $this->Received->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->Pending->CurrentValue)) {
                $this->Pending->Total += $this->Pending->CurrentValue; // Accumulate total
            }
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
            $this->Order->CurrentValue = $this->Order->Total;
            $this->Order->ViewValue = $this->Order->CurrentValue;
            $this->Order->ViewValue = FormatNumber($this->Order->ViewValue, $this->Order->formatPattern());
            $this->Order->HrefValue = ""; // Clear href value
            $this->Received->CurrentValue = $this->Received->Total;
            $this->Received->ViewValue = $this->Received->CurrentValue;
            $this->Received->ViewValue = FormatNumber($this->Received->ViewValue, $this->Received->formatPattern());
            $this->Received->HrefValue = ""; // Clear href value
            $this->Pending->CurrentValue = $this->Pending->Total;
            $this->Pending->ViewValue = $this->Pending->CurrentValue;
            $this->Pending->ViewValue = FormatNumber($this->Pending->ViewValue, $this->Pending->formatPattern());
            $this->Pending->HrefValue = ""; // Clear href value

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->Order);
                    $doc->exportCaption($this->Received);
                    $doc->exportCaption($this->Pending);
                    $doc->exportCaption($this->ReceivedBC);
                    $doc->exportCaption($this->PendingBC);
                    $doc->exportCaption($this->size_buyer);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->pp_id);
                } else {
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->design_id);
                    $doc->exportCaption($this->size_cm);
                    $doc->exportCaption($this->despatch_week);
                    $doc->exportCaption($this->Order);
                    $doc->exportCaption($this->Received);
                    $doc->exportCaption($this->Pending);
                    $doc->exportCaption($this->ReceivedBC);
                    $doc->exportCaption($this->PendingBC);
                    $doc->exportCaption($this->size_buyer);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->pp_id);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);
                $this->aggregateListRowValues(); // Aggregate row values

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->po);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->Order);
                        $doc->exportField($this->Received);
                        $doc->exportField($this->Pending);
                        $doc->exportField($this->ReceivedBC);
                        $doc->exportField($this->PendingBC);
                        $doc->exportField($this->size_buyer);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->pp_id);
                    } else {
                        $doc->exportField($this->po);
                        $doc->exportField($this->design_id);
                        $doc->exportField($this->size_cm);
                        $doc->exportField($this->despatch_week);
                        $doc->exportField($this->Order);
                        $doc->exportField($this->Received);
                        $doc->exportField($this->Pending);
                        $doc->exportField($this->ReceivedBC);
                        $doc->exportField($this->PendingBC);
                        $doc->exportField($this->size_buyer);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->pp_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }

        // Export aggregates (horizontal format only)
        if ($doc->Horizontal) {
            $this->RowType = RowType::AGGREGATE;
            $this->resetAttributes();
            $this->aggregateListRow();
            if (!$doc->ExportCustom) {
                $doc->beginExportRow(-1);
                $doc->exportAggregate($this->po, '');
                $doc->exportAggregate($this->design_id, '');
                $doc->exportAggregate($this->size_cm, '');
                $doc->exportAggregate($this->despatch_week, '');
                $doc->exportAggregate($this->Order, 'TOTAL');
                $doc->exportAggregate($this->Received, 'TOTAL');
                $doc->exportAggregate($this->Pending, 'TOTAL');
                $doc->exportAggregate($this->ReceivedBC, '');
                $doc->exportAggregate($this->PendingBC, '');
                $doc->exportAggregate($this->size_buyer, '');
                $doc->exportAggregate($this->buyer_ref, '');
                $doc->exportAggregate($this->buyers_id, '');
                $doc->exportAggregate($this->pp_id, '');
                $doc->endExportRow();
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
