<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for query_oms_2
 */
class QueryOms2 extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = true;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $buyers_id;
    public $reports_to;
    public $order_week;
    public $order_date;
    public $category;
    public $current_works;
    public $buyer_order;
    public $po;
    public $item;
    public $buyer_ref;
    public $design;
    public $size_buyer;
    public $width;
    public $length;
    public $qty;
    public $revised_qty;
    public $sqm;
    public $ex_factory;
    public $ex_factory_p;
    public $shipping_mode;
    public $remarks;
    public $d_qty;
    public $pl_no;
    public $invoice_date;
    public $sailing_week;
    public $pending;
    public $pending_sqm;
    public $cbm;
    public $total_cbm;
    public $offloom;
    public $status;
    public $rejection;
    public $completed;
    public $weaving_works;
    public $cs;
    public $weight_sqm;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "query_oms_2";
        $this->TableName = 'query_oms_2';
        $this->TableType = "VIEW";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "query_oms_2";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            21, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['id'] = &$this->id;

        // buyers_id
        $this->buyers_id = new DbField(
            $this, // Table
            'x_buyers_id', // Variable name
            'buyers_id', // Name
            '`buyers_id`', // Expression
            '`buyers_id`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyers_id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->buyers_id->InputTextType = "text";
        $this->buyers_id->Raw = true;
        $this->buyers_id->setSelectMultiple(false); // Select one
        $this->buyers_id->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->buyers_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->buyers_id->Lookup = new Lookup($this->buyers_id, 'buyer', false, 'id', ["code","name","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`code`, ''),'" . ValueSeparator(1, $this->buyers_id) . "',COALESCE(`name`,''))");
        $this->buyers_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->buyers_id->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyers_id'] = &$this->buyers_id;

        // reports_to
        $this->reports_to = new DbField(
            $this, // Table
            'x_reports_to', // Variable name
            'reports_to', // Name
            '`reports_to`', // Expression
            '`reports_to`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`reports_to`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->reports_to->InputTextType = "text";
        $this->reports_to->setSelectMultiple(false); // Select one
        $this->reports_to->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->reports_to->Lookup = new Lookup($this->reports_to, 'admin', false, 'id', ["mobile","","",""], '', '', [], [], [], [], [], [], false, '', '', "`mobile`");
        $this->reports_to->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['reports_to'] = &$this->reports_to;

        // order_week
        $this->order_week = new DbField(
            $this, // Table
            'x_order_week', // Variable name
            'order_week', // Name
            '`order_week`', // Expression
            '`order_week`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`order_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->order_week->InputTextType = "text";
        $this->order_week->Raw = true;
        $this->order_week->setSelectMultiple(false); // Select one
        $this->order_week->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->order_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->order_week->Lookup = new Lookup($this->order_week, 'not_week', false, 'id', ["week","","",""], '', '', [], [], [], [], [], [], false, '`week` ASC', '', "`week`");
        $this->order_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->order_week->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['order_week'] = &$this->order_week;

        // order_date
        $this->order_date = new DbField(
            $this, // Table
            'x_order_date', // Variable name
            'order_date', // Name
            '`order_date`', // Expression
            CastDateFieldForLike("`order_date`", 7, "DB"), // Basic search expression
            133, // Type
            10, // Size
            7, // Date/Time format
            false, // Is upload field
            '`order_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->order_date->InputTextType = "text";
        $this->order_date->Raw = true;
        $this->order_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->order_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['order_date'] = &$this->order_date;

        // category
        $this->category = new DbField(
            $this, // Table
            'x_category', // Variable name
            'category', // Name
            '`category`', // Expression
            '`category`', // Basic search expression
            200, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`category`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->category->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->category->InputTextType = "text";
        $this->category->Nullable = false; // NOT NULL field
        $this->category->Required = true; // Required field
        $this->category->setSelectMultiple(false); // Select one
        $this->category->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->category->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->category->Lookup = new Lookup($this->category, 'product_category', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->category->SearchOperators = ["=", "<>"];
        $this->Fields['category'] = &$this->category;

        // current_works
        $this->current_works = new DbField(
            $this, // Table
            'x_current_works', // Variable name
            'current_works', // Name
            '`current_works`', // Expression
            '`current_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`current_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->current_works->addMethod("getSelectFilter", fn() => "`status`=1");
        $this->current_works->addMethod("getDefault", fn() => 0);
        $this->current_works->InputTextType = "text";
        $this->current_works->Raw = true;
        $this->current_works->Nullable = false; // NOT NULL field
        $this->current_works->Required = true; // Required field
        $this->current_works->setSelectMultiple(false); // Select one
        $this->current_works->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->current_works->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->current_works->Lookup = new Lookup($this->current_works, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->current_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->current_works->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['current_works'] = &$this->current_works;

        // buyer_order
        $this->buyer_order = new DbField(
            $this, // Table
            'x_buyer_order', // Variable name
            'buyer_order', // Name
            '`buyer_order`', // Expression
            '`buyer_order`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_order`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_order->InputTextType = "text";
        $this->buyer_order->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_order'] = &$this->buyer_order;

        // po
        $this->po = new DbField(
            $this, // Table
            'x_po', // Variable name
            'po', // Name
            '`po`', // Expression
            '`po`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`po`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->po->InputTextType = "text";
        $this->po->Raw = true;
        $this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->po->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['po'] = &$this->po;

        // item
        $this->item = new DbField(
            $this, // Table
            'x_item', // Variable name
            'item', // Name
            '`item`', // Expression
            '`item`', // Basic search expression
            200, // Type
            200, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`item`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->item->InputTextType = "text";
        $this->item->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['item'] = &$this->item;

        // buyer_ref
        $this->buyer_ref = new DbField(
            $this, // Table
            'x_buyer_ref', // Variable name
            'buyer_ref', // Name
            '`buyer_ref`', // Expression
            '`buyer_ref`', // Basic search expression
            200, // Type
            144, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`buyer_ref`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->buyer_ref->InputTextType = "text";
        $this->buyer_ref->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['buyer_ref'] = &$this->buyer_ref;

        // design
        $this->design = new DbField(
            $this, // Table
            'x_design', // Variable name
            'design', // Name
            '`design`', // Expression
            '`design`', // Basic search expression
            200, // Type
            192, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design->InputTextType = "text";
        $this->design->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design'] = &$this->design;

        // size_buyer
        $this->size_buyer = new DbField(
            $this, // Table
            'x_size_buyer', // Variable name
            'size_buyer', // Name
            '`size_buyer`', // Expression
            '`size_buyer`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_buyer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_buyer->InputTextType = "text";
        $this->size_buyer->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_buyer'] = &$this->size_buyer;

        // width
        $this->width = new DbField(
            $this, // Table
            'x_width', // Variable name
            'width', // Name
            '`width`', // Expression
            '`width`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`width`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->width->InputTextType = "text";
        $this->width->Raw = true;
        $this->width->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->width->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['width'] = &$this->width;

        // length
        $this->length = new DbField(
            $this, // Table
            'x_length', // Variable name
            'length', // Name
            '`length`', // Expression
            '`length`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`length`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->length->InputTextType = "text";
        $this->length->Raw = true;
        $this->length->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->length->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['length'] = &$this->length;

        // qty
        $this->qty = new DbField(
            $this, // Table
            'x_qty', // Variable name
            'qty', // Name
            '`qty`', // Expression
            '`qty`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qty->InputTextType = "text";
        $this->qty->Raw = true;
        $this->qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qty'] = &$this->qty;

        // revised_qty
        $this->revised_qty = new DbField(
            $this, // Table
            'x_revised_qty', // Variable name
            'revised_qty', // Name
            '`revised_qty`', // Expression
            '`revised_qty`', // Basic search expression
            20, // Type
            21, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`revised_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->revised_qty->InputTextType = "text";
        $this->revised_qty->Raw = true;
        $this->revised_qty->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->revised_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['revised_qty'] = &$this->revised_qty;

        // sqm
        $this->sqm = new DbField(
            $this, // Table
            'x_sqm', // Variable name
            'sqm', // Name
            '`sqm`', // Expression
            '`sqm`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->sqm->InputTextType = "text";
        $this->sqm->Raw = true;
        $this->sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['sqm'] = &$this->sqm;

        // ex_factory
        $this->ex_factory = new DbField(
            $this, // Table
            'x_ex_factory', // Variable name
            'ex_factory', // Name
            '`ex_factory`', // Expression
            '`ex_factory`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ex_factory`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->ex_factory->InputTextType = "text";
        $this->ex_factory->Raw = true;
        $this->ex_factory->setSelectMultiple(false); // Select one
        $this->ex_factory->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->ex_factory->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->ex_factory->Lookup = new Lookup($this->ex_factory, 'not_week', false, 'id', ["wid","wed","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "CONCAT(COALESCE(`wid`, ''),'" . ValueSeparator(1, $this->ex_factory) . "',COALESCE(`wed`,''))");
        $this->ex_factory->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->ex_factory->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['ex_factory'] = &$this->ex_factory;

        // ex_factory_p
        $this->ex_factory_p = new DbField(
            $this, // Table
            'x_ex_factory_p', // Variable name
            'ex_factory_p', // Name
            '`ex_factory_p`', // Expression
            '`ex_factory_p`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`ex_factory_p`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->ex_factory_p->InputTextType = "text";
        $this->ex_factory_p->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['ex_factory_p'] = &$this->ex_factory_p;

        // shipping_mode
        $this->shipping_mode = new DbField(
            $this, // Table
            'x_shipping_mode', // Variable name
            'shipping_mode', // Name
            '`shipping_mode`', // Expression
            '`shipping_mode`', // Basic search expression
            129, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_mode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->shipping_mode->InputTextType = "text";
        $this->shipping_mode->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_mode'] = &$this->shipping_mode;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // d_qty
        $this->d_qty = new DbField(
            $this, // Table
            'x_d_qty', // Variable name
            'd_qty', // Name
            '`d_qty`', // Expression
            '`d_qty`', // Basic search expression
            131, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`d_qty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->d_qty->InputTextType = "text";
        $this->d_qty->Raw = true;
        $this->d_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->d_qty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['d_qty'] = &$this->d_qty;

        // pl_no
        $this->pl_no = new DbField(
            $this, // Table
            'x_pl_no', // Variable name
            'pl_no', // Name
            '`pl_no`', // Expression
            '`pl_no`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pl_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->pl_no->InputTextType = "text";
        $this->pl_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['pl_no'] = &$this->pl_no;

        // invoice_date
        $this->invoice_date = new DbField(
            $this, // Table
            'x_invoice_date', // Variable name
            'invoice_date', // Name
            '`invoice_date`', // Expression
            '`invoice_date`', // Basic search expression
            129, // Type
            0, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`invoice_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->invoice_date->InputTextType = "text";
        $this->invoice_date->Nullable = false; // NOT NULL field
        $this->invoice_date->Required = true; // Required field
        $this->invoice_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['invoice_date'] = &$this->invoice_date;

        // sailing_week
        $this->sailing_week = new DbField(
            $this, // Table
            'x_sailing_week', // Variable name
            'sailing_week', // Name
            '`sailing_week`', // Expression
            '`sailing_week`', // Basic search expression
            129, // Type
            0, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`sailing_week`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->sailing_week->InputTextType = "text";
        $this->sailing_week->Nullable = false; // NOT NULL field
        $this->sailing_week->Required = true; // Required field
        $this->sailing_week->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['sailing_week'] = &$this->sailing_week;

        // pending
        $this->pending = new DbField(
            $this, // Table
            'x_pending', // Variable name
            'pending', // Name
            '`pending`', // Expression
            '`pending`', // Basic search expression
            131, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending->InputTextType = "text";
        $this->pending->Raw = true;
        $this->pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pending->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pending'] = &$this->pending;

        // pending_sqm
        $this->pending_sqm = new DbField(
            $this, // Table
            'x_pending_sqm', // Variable name
            'pending_sqm', // Name
            '`pending_sqm`', // Expression
            '`pending_sqm`', // Basic search expression
            131, // Type
            32, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`pending_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->pending_sqm->InputTextType = "text";
        $this->pending_sqm->Raw = true;
        $this->pending_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->pending_sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['pending_sqm'] = &$this->pending_sqm;

        // cbm
        $this->cbm = new DbField(
            $this, // Table
            'x_cbm', // Variable name
            'cbm', // Name
            '`cbm`', // Expression
            '`cbm`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->cbm->InputTextType = "text";
        $this->cbm->Raw = true;
        $this->cbm->Required = true; // Required field
        $this->cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cbm'] = &$this->cbm;

        // total_cbm
        $this->total_cbm = new DbField(
            $this, // Table
            'x_total_cbm', // Variable name
            'total_cbm', // Name
            '`total_cbm`', // Expression
            '`total_cbm`', // Basic search expression
            131, // Type
            39, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`total_cbm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->total_cbm->InputTextType = "text";
        $this->total_cbm->Raw = true;
        $this->total_cbm->Required = true; // Required field
        $this->total_cbm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['total_cbm'] = &$this->total_cbm;

        // offloom
        $this->offloom = new DbField(
            $this, // Table
            'x_offloom', // Variable name
            'offloom', // Name
            '`offloom`', // Expression
            '`offloom`', // Basic search expression
            131, // Type
            23, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`offloom`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->offloom->InputTextType = "text";
        $this->offloom->Raw = true;
        $this->offloom->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->offloom->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['offloom'] = &$this->offloom;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->InputTextType = "text";
        $this->status->setSelectMultiple(true); // Select multiple
        $this->status->Lookup = new Lookup($this->status, 'status', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`item` ASC', '', "`item`");
        $this->status->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // rejection
        $this->rejection = new DbField(
            $this, // Table
            'x_rejection', // Variable name
            'rejection', // Name
            '`rejection`', // Expression
            '`rejection`', // Basic search expression
            3, // Type
            1, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rejection`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rejection->InputTextType = "text";
        $this->rejection->Raw = true;
        $this->rejection->Nullable = false; // NOT NULL field
        $this->rejection->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rejection->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['rejection'] = &$this->rejection;

        // completed
        $this->completed = new DbField(
            $this, // Table
            'x_completed', // Variable name
            'completed', // Name
            '`completed`', // Expression
            '`completed`', // Basic search expression
            201, // Type
            16777215, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`completed`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'CHECKBOX' // Edit Tag
        );
        $this->completed->InputTextType = "text";
        $this->completed->Lookup = new Lookup($this->completed, 'query_oms_2', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->completed->OptionCount = 2;
        $this->completed->SearchOperators = ["=", "<>", "IS NULL", "IS NOT NULL"];
        $this->Fields['completed'] = &$this->completed;

        // weaving_works
        $this->weaving_works = new DbField(
            $this, // Table
            'x_weaving_works', // Variable name
            'weaving_works', // Name
            '`weaving_works`', // Expression
            '`weaving_works`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weaving_works`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weaving_works->addMethod("getDefault", fn() => 0);
        $this->weaving_works->InputTextType = "text";
        $this->weaving_works->Raw = true;
        $this->weaving_works->Nullable = false; // NOT NULL field
        $this->weaving_works->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->weaving_works->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['weaving_works'] = &$this->weaving_works;

        // cs
        $this->cs = new DbField(
            $this, // Table
            'x_cs', // Variable name
            'cs', // Name
            '`cs`', // Expression
            '`cs`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cs`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cs->addMethod("getDefault", fn() => 0);
        $this->cs->InputTextType = "text";
        $this->cs->Raw = true;
        $this->cs->Nullable = false; // NOT NULL field
        $this->cs->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->cs->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['cs'] = &$this->cs;

        // weight_sqm
        $this->weight_sqm = new DbField(
            $this, // Table
            'x_weight_sqm', // Variable name
            'weight_sqm', // Name
            '`weight_sqm`', // Expression
            '`weight_sqm`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weight_sqm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weight_sqm->InputTextType = "text";
        $this->weight_sqm->Raw = true;
        $this->weight_sqm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->weight_sqm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['weight_sqm'] = &$this->weight_sqm;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "query_oms_2";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->buyers_id->DbValue = $row['buyers_id'];
        $this->reports_to->DbValue = $row['reports_to'];
        $this->order_week->DbValue = $row['order_week'];
        $this->order_date->DbValue = $row['order_date'];
        $this->category->DbValue = $row['category'];
        $this->current_works->DbValue = $row['current_works'];
        $this->buyer_order->DbValue = $row['buyer_order'];
        $this->po->DbValue = $row['po'];
        $this->item->DbValue = $row['item'];
        $this->buyer_ref->DbValue = $row['buyer_ref'];
        $this->design->DbValue = $row['design'];
        $this->size_buyer->DbValue = $row['size_buyer'];
        $this->width->DbValue = $row['width'];
        $this->length->DbValue = $row['length'];
        $this->qty->DbValue = $row['qty'];
        $this->revised_qty->DbValue = $row['revised_qty'];
        $this->sqm->DbValue = $row['sqm'];
        $this->ex_factory->DbValue = $row['ex_factory'];
        $this->ex_factory_p->DbValue = $row['ex_factory_p'];
        $this->shipping_mode->DbValue = $row['shipping_mode'];
        $this->remarks->DbValue = $row['remarks'];
        $this->d_qty->DbValue = $row['d_qty'];
        $this->pl_no->DbValue = $row['pl_no'];
        $this->invoice_date->DbValue = $row['invoice_date'];
        $this->sailing_week->DbValue = $row['sailing_week'];
        $this->pending->DbValue = $row['pending'];
        $this->pending_sqm->DbValue = $row['pending_sqm'];
        $this->cbm->DbValue = $row['cbm'];
        $this->total_cbm->DbValue = $row['total_cbm'];
        $this->offloom->DbValue = $row['offloom'];
        $this->status->DbValue = $row['status'];
        $this->rejection->DbValue = $row['rejection'];
        $this->completed->DbValue = $row['completed'];
        $this->weaving_works->DbValue = $row['weaving_works'];
        $this->cs->DbValue = $row['cs'];
        $this->weight_sqm->DbValue = $row['weight_sqm'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 0) {
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("queryoms2list");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "queryoms2view" => $Language->phrase("View"),
            "queryoms2edit" => $Language->phrase("Edit"),
            "queryoms2add" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "queryoms2list";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "QueryOms2View",
            Config("API_ADD_ACTION") => "QueryOms2Add",
            Config("API_EDIT_ACTION") => "QueryOms2Edit",
            Config("API_DELETE_ACTION") => "QueryOms2Delete",
            Config("API_LIST_ACTION") => "QueryOms2List",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "queryoms2list";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("queryoms2view", $parm);
        } else {
            $url = $this->keyUrl("queryoms2view", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "queryoms2add?" . $parm;
        } else {
            $url = "queryoms2add";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("queryoms2edit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("queryoms2list", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("queryoms2add", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("queryoms2list", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("queryoms2delete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, -1))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, -1))) // Other API
                : []; // Non-API
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->buyers_id->setDbValue($row['buyers_id']);
        $this->reports_to->setDbValue($row['reports_to']);
        $this->order_week->setDbValue($row['order_week']);
        $this->order_date->setDbValue($row['order_date']);
        $this->category->setDbValue($row['category']);
        $this->current_works->setDbValue($row['current_works']);
        $this->buyer_order->setDbValue($row['buyer_order']);
        $this->po->setDbValue($row['po']);
        $this->item->setDbValue($row['item']);
        $this->buyer_ref->setDbValue($row['buyer_ref']);
        $this->design->setDbValue($row['design']);
        $this->size_buyer->setDbValue($row['size_buyer']);
        $this->width->setDbValue($row['width']);
        $this->length->setDbValue($row['length']);
        $this->qty->setDbValue($row['qty']);
        $this->revised_qty->setDbValue($row['revised_qty']);
        $this->sqm->setDbValue($row['sqm']);
        $this->ex_factory->setDbValue($row['ex_factory']);
        $this->ex_factory_p->setDbValue($row['ex_factory_p']);
        $this->shipping_mode->setDbValue($row['shipping_mode']);
        $this->remarks->setDbValue($row['remarks']);
        $this->d_qty->setDbValue($row['d_qty']);
        $this->pl_no->setDbValue($row['pl_no']);
        $this->invoice_date->setDbValue($row['invoice_date']);
        $this->sailing_week->setDbValue($row['sailing_week']);
        $this->pending->setDbValue($row['pending']);
        $this->pending_sqm->setDbValue($row['pending_sqm']);
        $this->cbm->setDbValue($row['cbm']);
        $this->total_cbm->setDbValue($row['total_cbm']);
        $this->offloom->setDbValue($row['offloom']);
        $this->status->setDbValue($row['status']);
        $this->rejection->setDbValue($row['rejection']);
        $this->completed->setDbValue($row['completed']);
        $this->weaving_works->setDbValue($row['weaving_works']);
        $this->cs->setDbValue($row['cs']);
        $this->weight_sqm->setDbValue($row['weight_sqm']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "QueryOms2List";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // buyers_id

        // reports_to

        // order_week

        // order_date

        // category

        // current_works

        // buyer_order

        // po

        // item

        // buyer_ref

        // design

        // size_buyer

        // width

        // length

        // qty

        // revised_qty

        // sqm

        // ex_factory

        // ex_factory_p

        // shipping_mode

        // remarks

        // d_qty

        // pl_no

        // invoice_date

        // sailing_week

        // pending

        // pending_sqm

        // cbm

        // total_cbm

        // offloom

        // status

        // rejection

        // completed

        // weaving_works

        // cs

        // weight_sqm

        // id
        $this->id->ViewValue = $this->id->CurrentValue;
        $this->id->ViewValue = FormatNumber($this->id->ViewValue, $this->id->formatPattern());

        // buyers_id
        $curVal = strval($this->buyers_id->CurrentValue);
        if ($curVal != "") {
            $this->buyers_id->ViewValue = $this->buyers_id->lookupCacheOption($curVal);
            if ($this->buyers_id->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->buyers_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->buyers_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->buyers_id->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->buyers_id->Lookup->renderViewRow($rswrk[0]);
                    $this->buyers_id->ViewValue = $this->buyers_id->displayValue($arwrk);
                } else {
                    $this->buyers_id->ViewValue = FormatNumber($this->buyers_id->CurrentValue, $this->buyers_id->formatPattern());
                }
            }
        } else {
            $this->buyers_id->ViewValue = null;
        }

        // reports_to
        $curVal = strval($this->reports_to->CurrentValue);
        if ($curVal != "") {
            $this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
            if ($this->reports_to->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->reports_to->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->reports_to->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->reports_to->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reports_to->Lookup->renderViewRow($rswrk[0]);
                    $this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
                } else {
                    $this->reports_to->ViewValue = $this->reports_to->CurrentValue;
                }
            }
        } else {
            $this->reports_to->ViewValue = null;
        }

        // order_week
        $curVal = strval($this->order_week->CurrentValue);
        if ($curVal != "") {
            $this->order_week->ViewValue = $this->order_week->lookupCacheOption($curVal);
            if ($this->order_week->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->order_week->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->order_week->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->order_week->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->order_week->Lookup->renderViewRow($rswrk[0]);
                    $this->order_week->ViewValue = $this->order_week->displayValue($arwrk);
                } else {
                    $this->order_week->ViewValue = FormatNumber($this->order_week->CurrentValue, $this->order_week->formatPattern());
                }
            }
        } else {
            $this->order_week->ViewValue = null;
        }

        // order_date
        $this->order_date->ViewValue = $this->order_date->CurrentValue;
        $this->order_date->ViewValue = FormatDateTime($this->order_date->ViewValue, $this->order_date->formatPattern());

        // category
        $curVal = strval($this->category->CurrentValue);
        if ($curVal != "") {
            $this->category->ViewValue = $this->category->lookupCacheOption($curVal);
            if ($this->category->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->category->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->category->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->category->getSelectFilter($this); // PHP
                $sqlWrk = $this->category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->category->Lookup->renderViewRow($rswrk[0]);
                    $this->category->ViewValue = $this->category->displayValue($arwrk);
                } else {
                    $this->category->ViewValue = $this->category->CurrentValue;
                }
            }
        } else {
            $this->category->ViewValue = null;
        }

        // current_works
        $curVal = strval($this->current_works->CurrentValue);
        if ($curVal != "") {
            $this->current_works->ViewValue = $this->current_works->lookupCacheOption($curVal);
            if ($this->current_works->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->current_works->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->current_works->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->current_works->getSelectFilter($this); // PHP
                $sqlWrk = $this->current_works->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->current_works->Lookup->renderViewRow($rswrk[0]);
                    $this->current_works->ViewValue = $this->current_works->displayValue($arwrk);
                } else {
                    $this->current_works->ViewValue = FormatNumber($this->current_works->CurrentValue, $this->current_works->formatPattern());
                }
            }
        } else {
            $this->current_works->ViewValue = null;
        }

        // buyer_order
        $this->buyer_order->ViewValue = $this->buyer_order->CurrentValue;

        // po
        $this->po->ViewValue = $this->po->CurrentValue;
        $this->po->ViewValue = FormatNumber($this->po->ViewValue, $this->po->formatPattern());

        // item
        $this->item->ViewValue = $this->item->CurrentValue;

        // buyer_ref
        $this->buyer_ref->ViewValue = $this->buyer_ref->CurrentValue;

        // design
        $this->design->ViewValue = $this->design->CurrentValue;

        // size_buyer
        $this->size_buyer->ViewValue = $this->size_buyer->CurrentValue;

        // width
        $this->width->ViewValue = $this->width->CurrentValue;
        $this->width->ViewValue = FormatNumber($this->width->ViewValue, $this->width->formatPattern());

        // length
        $this->length->ViewValue = $this->length->CurrentValue;
        $this->length->ViewValue = FormatNumber($this->length->ViewValue, $this->length->formatPattern());

        // qty
        $this->qty->ViewValue = $this->qty->CurrentValue;
        $this->qty->ViewValue = FormatNumber($this->qty->ViewValue, $this->qty->formatPattern());

        // revised_qty
        $this->revised_qty->ViewValue = $this->revised_qty->CurrentValue;
        $this->revised_qty->ViewValue = FormatNumber($this->revised_qty->ViewValue, $this->revised_qty->formatPattern());

        // sqm
        $this->sqm->ViewValue = $this->sqm->CurrentValue;
        $this->sqm->ViewValue = FormatNumber($this->sqm->ViewValue, $this->sqm->formatPattern());

        // ex_factory
        $curVal = strval($this->ex_factory->CurrentValue);
        if ($curVal != "") {
            $this->ex_factory->ViewValue = $this->ex_factory->lookupCacheOption($curVal);
            if ($this->ex_factory->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->ex_factory->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->ex_factory->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->ex_factory->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->ex_factory->Lookup->renderViewRow($rswrk[0]);
                    $this->ex_factory->ViewValue = $this->ex_factory->displayValue($arwrk);
                } else {
                    $this->ex_factory->ViewValue = FormatNumber($this->ex_factory->CurrentValue, $this->ex_factory->formatPattern());
                }
            }
        } else {
            $this->ex_factory->ViewValue = null;
        }

        // ex_factory_p
        $this->ex_factory_p->ViewValue = $this->ex_factory_p->CurrentValue;

        // shipping_mode
        $this->shipping_mode->ViewValue = $this->shipping_mode->CurrentValue;

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // d_qty
        $this->d_qty->ViewValue = $this->d_qty->CurrentValue;
        $this->d_qty->ViewValue = FormatNumber($this->d_qty->ViewValue, $this->d_qty->formatPattern());

        // pl_no
        $this->pl_no->ViewValue = $this->pl_no->CurrentValue;

        // invoice_date
        $this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;

        // sailing_week
        $this->sailing_week->ViewValue = $this->sailing_week->CurrentValue;

        // pending
        $this->pending->ViewValue = $this->pending->CurrentValue;
        $this->pending->ViewValue = FormatNumber($this->pending->ViewValue, $this->pending->formatPattern());

        // pending_sqm
        $this->pending_sqm->ViewValue = $this->pending_sqm->CurrentValue;
        $this->pending_sqm->ViewValue = FormatNumber($this->pending_sqm->ViewValue, $this->pending_sqm->formatPattern());

        // cbm
        $this->cbm->ViewValue = $this->cbm->CurrentValue;

        // total_cbm
        $this->total_cbm->ViewValue = $this->total_cbm->CurrentValue;

        // offloom
        $this->offloom->ViewValue = $this->offloom->CurrentValue;
        $this->offloom->ViewValue = FormatNumber($this->offloom->ViewValue, $this->offloom->formatPattern());

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), $curVal);
                $filterWrk = "";
                foreach ($arwrk as $wrk) {
                    AddFilter($filterWrk, SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", trim($wrk), $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), ""), "OR");
                }
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $this->status->ViewValue = new OptionValues();
                    foreach ($rswrk as $row) {
                        $arwrk = $this->status->Lookup->renderViewRow($row);
                        $this->status->ViewValue->add($this->status->displayValue($arwrk));
                    }
                } else {
                    $this->status->ViewValue = $this->status->CurrentValue;
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // rejection
        $this->rejection->ViewValue = $this->rejection->CurrentValue;
        $this->rejection->ViewValue = FormatNumber($this->rejection->ViewValue, $this->rejection->formatPattern());

        // completed
        if (strval($this->completed->CurrentValue) != "") {
            $this->completed->ViewValue = new OptionValues();
            $arwrk = explode(Config("MULTIPLE_OPTION_SEPARATOR"), strval($this->completed->CurrentValue));
            $cnt = count($arwrk);
            for ($ari = 0; $ari < $cnt; $ari++)
                $this->completed->ViewValue->add($this->completed->optionCaption(trim($arwrk[$ari])));
        } else {
            $this->completed->ViewValue = null;
        }

        // weaving_works
        $this->weaving_works->ViewValue = $this->weaving_works->CurrentValue;
        $this->weaving_works->ViewValue = FormatNumber($this->weaving_works->ViewValue, $this->weaving_works->formatPattern());

        // cs
        $this->cs->ViewValue = $this->cs->CurrentValue;
        $this->cs->ViewValue = FormatNumber($this->cs->ViewValue, $this->cs->formatPattern());

        // weight_sqm
        $this->weight_sqm->ViewValue = $this->weight_sqm->CurrentValue;
        $this->weight_sqm->ViewValue = FormatNumber($this->weight_sqm->ViewValue, $this->weight_sqm->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // buyers_id
        $this->buyers_id->HrefValue = "";
        $this->buyers_id->TooltipValue = "";

        // reports_to
        $this->reports_to->HrefValue = "";
        $this->reports_to->TooltipValue = "";

        // order_week
        $this->order_week->HrefValue = "";
        $this->order_week->TooltipValue = "";

        // order_date
        $this->order_date->HrefValue = "";
        $this->order_date->TooltipValue = "";

        // category
        $this->category->HrefValue = "";
        $this->category->TooltipValue = "";

        // current_works
        $this->current_works->HrefValue = "";
        $this->current_works->TooltipValue = "";

        // buyer_order
        $this->buyer_order->HrefValue = "";
        $this->buyer_order->TooltipValue = "";

        // po
        $this->po->HrefValue = "";
        $this->po->TooltipValue = "";

        // item
        $this->item->HrefValue = "";
        $this->item->TooltipValue = "";

        // buyer_ref
        $this->buyer_ref->HrefValue = "";
        $this->buyer_ref->TooltipValue = "";

        // design
        $this->design->HrefValue = "";
        $this->design->TooltipValue = "";

        // size_buyer
        $this->size_buyer->HrefValue = "";
        $this->size_buyer->TooltipValue = "";

        // width
        $this->width->HrefValue = "";
        $this->width->TooltipValue = "";

        // length
        $this->length->HrefValue = "";
        $this->length->TooltipValue = "";

        // qty
        $this->qty->HrefValue = "";
        $this->qty->TooltipValue = "";

        // revised_qty
        $this->revised_qty->HrefValue = "";
        $this->revised_qty->TooltipValue = "";

        // sqm
        $this->sqm->HrefValue = "";
        $this->sqm->TooltipValue = "";

        // ex_factory
        $this->ex_factory->HrefValue = "";
        $this->ex_factory->TooltipValue = "";

        // ex_factory_p
        $this->ex_factory_p->HrefValue = "";
        $this->ex_factory_p->TooltipValue = "";

        // shipping_mode
        $this->shipping_mode->HrefValue = "";
        $this->shipping_mode->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // d_qty
        $this->d_qty->HrefValue = "";
        $this->d_qty->TooltipValue = "";

        // pl_no
        $this->pl_no->HrefValue = "";
        $this->pl_no->TooltipValue = "";

        // invoice_date
        $this->invoice_date->HrefValue = "";
        $this->invoice_date->TooltipValue = "";

        // sailing_week
        $this->sailing_week->HrefValue = "";
        $this->sailing_week->TooltipValue = "";

        // pending
        $this->pending->HrefValue = "";
        $this->pending->TooltipValue = "";

        // pending_sqm
        $this->pending_sqm->HrefValue = "";
        $this->pending_sqm->TooltipValue = "";

        // cbm
        $this->cbm->HrefValue = "";
        $this->cbm->TooltipValue = "";

        // total_cbm
        $this->total_cbm->HrefValue = "";
        $this->total_cbm->TooltipValue = "";

        // offloom
        $this->offloom->HrefValue = "";
        $this->offloom->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // rejection
        $this->rejection->HrefValue = "";
        $this->rejection->TooltipValue = "";

        // completed
        $this->completed->HrefValue = "";
        $this->completed->TooltipValue = "";

        // weaving_works
        $this->weaving_works->HrefValue = "";
        $this->weaving_works->TooltipValue = "";

        // cs
        $this->cs->HrefValue = "";
        $this->cs->TooltipValue = "";

        // weight_sqm
        $this->weight_sqm->HrefValue = "";
        $this->weight_sqm->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;
        $this->id->PlaceHolder = RemoveHtml($this->id->caption());
        if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue)) {
            $this->id->EditValue = FormatNumber($this->id->EditValue, null);
        }

        // buyers_id
        $this->buyers_id->setupEditAttributes();
        $this->buyers_id->PlaceHolder = RemoveHtml($this->buyers_id->caption());

        // reports_to
        $this->reports_to->setupEditAttributes();
        $this->reports_to->PlaceHolder = RemoveHtml($this->reports_to->caption());

        // order_week
        $this->order_week->setupEditAttributes();
        $this->order_week->PlaceHolder = RemoveHtml($this->order_week->caption());

        // order_date
        $this->order_date->setupEditAttributes();
        $this->order_date->EditValue = FormatDateTime($this->order_date->CurrentValue, $this->order_date->formatPattern());
        $this->order_date->PlaceHolder = RemoveHtml($this->order_date->caption());

        // category
        $this->category->setupEditAttributes();
        $this->category->PlaceHolder = RemoveHtml($this->category->caption());

        // current_works
        $this->current_works->setupEditAttributes();
        $this->current_works->PlaceHolder = RemoveHtml($this->current_works->caption());

        // buyer_order
        $this->buyer_order->setupEditAttributes();
        if (!$this->buyer_order->Raw) {
            $this->buyer_order->CurrentValue = HtmlDecode($this->buyer_order->CurrentValue);
        }
        $this->buyer_order->EditValue = $this->buyer_order->CurrentValue;
        $this->buyer_order->PlaceHolder = RemoveHtml($this->buyer_order->caption());

        // po
        $this->po->setupEditAttributes();
        $this->po->EditValue = $this->po->CurrentValue;
        $this->po->PlaceHolder = RemoveHtml($this->po->caption());
        if (strval($this->po->EditValue) != "" && is_numeric($this->po->EditValue)) {
            $this->po->EditValue = FormatNumber($this->po->EditValue, null);
        }

        // item
        $this->item->setupEditAttributes();
        if (!$this->item->Raw) {
            $this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
        }
        $this->item->EditValue = $this->item->CurrentValue;
        $this->item->PlaceHolder = RemoveHtml($this->item->caption());

        // buyer_ref
        $this->buyer_ref->setupEditAttributes();
        if (!$this->buyer_ref->Raw) {
            $this->buyer_ref->CurrentValue = HtmlDecode($this->buyer_ref->CurrentValue);
        }
        $this->buyer_ref->EditValue = $this->buyer_ref->CurrentValue;
        $this->buyer_ref->PlaceHolder = RemoveHtml($this->buyer_ref->caption());

        // design
        $this->design->setupEditAttributes();
        if (!$this->design->Raw) {
            $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
        }
        $this->design->EditValue = $this->design->CurrentValue;
        $this->design->PlaceHolder = RemoveHtml($this->design->caption());

        // size_buyer
        $this->size_buyer->setupEditAttributes();
        if (!$this->size_buyer->Raw) {
            $this->size_buyer->CurrentValue = HtmlDecode($this->size_buyer->CurrentValue);
        }
        $this->size_buyer->EditValue = $this->size_buyer->CurrentValue;
        $this->size_buyer->PlaceHolder = RemoveHtml($this->size_buyer->caption());

        // width
        $this->width->setupEditAttributes();
        $this->width->EditValue = $this->width->CurrentValue;
        $this->width->PlaceHolder = RemoveHtml($this->width->caption());
        if (strval($this->width->EditValue) != "" && is_numeric($this->width->EditValue)) {
            $this->width->EditValue = FormatNumber($this->width->EditValue, null);
        }

        // length
        $this->length->setupEditAttributes();
        $this->length->EditValue = $this->length->CurrentValue;
        $this->length->PlaceHolder = RemoveHtml($this->length->caption());
        if (strval($this->length->EditValue) != "" && is_numeric($this->length->EditValue)) {
            $this->length->EditValue = FormatNumber($this->length->EditValue, null);
        }

        // qty
        $this->qty->setupEditAttributes();
        $this->qty->EditValue = $this->qty->CurrentValue;
        $this->qty->PlaceHolder = RemoveHtml($this->qty->caption());
        if (strval($this->qty->EditValue) != "" && is_numeric($this->qty->EditValue)) {
            $this->qty->EditValue = FormatNumber($this->qty->EditValue, null);
        }

        // revised_qty
        $this->revised_qty->setupEditAttributes();
        $this->revised_qty->EditValue = $this->revised_qty->CurrentValue;
        $this->revised_qty->PlaceHolder = RemoveHtml($this->revised_qty->caption());
        if (strval($this->revised_qty->EditValue) != "" && is_numeric($this->revised_qty->EditValue)) {
            $this->revised_qty->EditValue = FormatNumber($this->revised_qty->EditValue, null);
        }

        // sqm
        $this->sqm->setupEditAttributes();
        $this->sqm->EditValue = $this->sqm->CurrentValue;
        $this->sqm->PlaceHolder = RemoveHtml($this->sqm->caption());
        if (strval($this->sqm->EditValue) != "" && is_numeric($this->sqm->EditValue)) {
            $this->sqm->EditValue = FormatNumber($this->sqm->EditValue, null);
        }

        // ex_factory
        $this->ex_factory->setupEditAttributes();
        $this->ex_factory->PlaceHolder = RemoveHtml($this->ex_factory->caption());

        // ex_factory_p
        $this->ex_factory_p->setupEditAttributes();
        $this->ex_factory_p->EditValue = $this->ex_factory_p->CurrentValue;
        $this->ex_factory_p->PlaceHolder = RemoveHtml($this->ex_factory_p->caption());

        // shipping_mode
        $this->shipping_mode->setupEditAttributes();
        if (!$this->shipping_mode->Raw) {
            $this->shipping_mode->CurrentValue = HtmlDecode($this->shipping_mode->CurrentValue);
        }
        $this->shipping_mode->EditValue = $this->shipping_mode->CurrentValue;
        $this->shipping_mode->PlaceHolder = RemoveHtml($this->shipping_mode->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        if (!$this->remarks->Raw) {
            $this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
        }
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // d_qty
        $this->d_qty->setupEditAttributes();
        $this->d_qty->EditValue = $this->d_qty->CurrentValue;
        $this->d_qty->PlaceHolder = RemoveHtml($this->d_qty->caption());
        if (strval($this->d_qty->EditValue) != "" && is_numeric($this->d_qty->EditValue)) {
            $this->d_qty->EditValue = FormatNumber($this->d_qty->EditValue, null);
        }

        // pl_no
        $this->pl_no->setupEditAttributes();
        $this->pl_no->EditValue = $this->pl_no->CurrentValue;
        $this->pl_no->PlaceHolder = RemoveHtml($this->pl_no->caption());

        // invoice_date
        $this->invoice_date->setupEditAttributes();
        $this->invoice_date->EditValue = $this->invoice_date->CurrentValue;
        $this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

        // sailing_week
        $this->sailing_week->setupEditAttributes();
        $this->sailing_week->EditValue = $this->sailing_week->CurrentValue;
        $this->sailing_week->PlaceHolder = RemoveHtml($this->sailing_week->caption());

        // pending
        $this->pending->setupEditAttributes();
        $this->pending->EditValue = $this->pending->CurrentValue;
        $this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
        if (strval($this->pending->EditValue) != "" && is_numeric($this->pending->EditValue)) {
            $this->pending->EditValue = FormatNumber($this->pending->EditValue, null);
        }

        // pending_sqm
        $this->pending_sqm->setupEditAttributes();
        $this->pending_sqm->EditValue = $this->pending_sqm->CurrentValue;
        $this->pending_sqm->PlaceHolder = RemoveHtml($this->pending_sqm->caption());
        if (strval($this->pending_sqm->EditValue) != "" && is_numeric($this->pending_sqm->EditValue)) {
            $this->pending_sqm->EditValue = FormatNumber($this->pending_sqm->EditValue, null);
        }

        // cbm
        $this->cbm->setupEditAttributes();
        $this->cbm->EditValue = $this->cbm->CurrentValue;
        $this->cbm->PlaceHolder = RemoveHtml($this->cbm->caption());
        if (strval($this->cbm->EditValue) != "" && is_numeric($this->cbm->EditValue)) {
            $this->cbm->EditValue = $this->cbm->EditValue;
        }

        // total_cbm
        $this->total_cbm->setupEditAttributes();
        $this->total_cbm->EditValue = $this->total_cbm->CurrentValue;
        $this->total_cbm->PlaceHolder = RemoveHtml($this->total_cbm->caption());
        if (strval($this->total_cbm->EditValue) != "" && is_numeric($this->total_cbm->EditValue)) {
            $this->total_cbm->EditValue = $this->total_cbm->EditValue;
        }

        // offloom
        $this->offloom->setupEditAttributes();
        $this->offloom->EditValue = $this->offloom->CurrentValue;
        $this->offloom->PlaceHolder = RemoveHtml($this->offloom->caption());
        if (strval($this->offloom->EditValue) != "" && is_numeric($this->offloom->EditValue)) {
            $this->offloom->EditValue = FormatNumber($this->offloom->EditValue, null);
        }

        // status
        $this->status->setupEditAttributes();
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // rejection
        $this->rejection->setupEditAttributes();
        $this->rejection->EditValue = $this->rejection->CurrentValue;
        $this->rejection->PlaceHolder = RemoveHtml($this->rejection->caption());
        if (strval($this->rejection->EditValue) != "" && is_numeric($this->rejection->EditValue)) {
            $this->rejection->EditValue = FormatNumber($this->rejection->EditValue, null);
        }

        // completed
        $this->completed->EditValue = $this->completed->options(false);
        $this->completed->PlaceHolder = RemoveHtml($this->completed->caption());

        // weaving_works
        $this->weaving_works->setupEditAttributes();
        $this->weaving_works->EditValue = $this->weaving_works->CurrentValue;
        $this->weaving_works->PlaceHolder = RemoveHtml($this->weaving_works->caption());
        if (strval($this->weaving_works->EditValue) != "" && is_numeric($this->weaving_works->EditValue)) {
            $this->weaving_works->EditValue = FormatNumber($this->weaving_works->EditValue, null);
        }

        // cs
        $this->cs->setupEditAttributes();
        $this->cs->EditValue = $this->cs->CurrentValue;
        $this->cs->PlaceHolder = RemoveHtml($this->cs->caption());
        if (strval($this->cs->EditValue) != "" && is_numeric($this->cs->EditValue)) {
            $this->cs->EditValue = FormatNumber($this->cs->EditValue, null);
        }

        // weight_sqm
        $this->weight_sqm->setupEditAttributes();
        $this->weight_sqm->EditValue = $this->weight_sqm->CurrentValue;
        $this->weight_sqm->PlaceHolder = RemoveHtml($this->weight_sqm->caption());
        if (strval($this->weight_sqm->EditValue) != "" && is_numeric($this->weight_sqm->EditValue)) {
            $this->weight_sqm->EditValue = FormatNumber($this->weight_sqm->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->order_week);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->buyer_order);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->item);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->size_buyer);
                    $doc->exportCaption($this->width);
                    $doc->exportCaption($this->length);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->revised_qty);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->ex_factory);
                    $doc->exportCaption($this->ex_factory_p);
                    $doc->exportCaption($this->shipping_mode);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->d_qty);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->sailing_week);
                    $doc->exportCaption($this->pending);
                    $doc->exportCaption($this->pending_sqm);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->total_cbm);
                    $doc->exportCaption($this->offloom);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->rejection);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->cs);
                    $doc->exportCaption($this->weight_sqm);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->buyers_id);
                    $doc->exportCaption($this->reports_to);
                    $doc->exportCaption($this->order_week);
                    $doc->exportCaption($this->order_date);
                    $doc->exportCaption($this->category);
                    $doc->exportCaption($this->current_works);
                    $doc->exportCaption($this->buyer_order);
                    $doc->exportCaption($this->po);
                    $doc->exportCaption($this->item);
                    $doc->exportCaption($this->buyer_ref);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->size_buyer);
                    $doc->exportCaption($this->width);
                    $doc->exportCaption($this->length);
                    $doc->exportCaption($this->qty);
                    $doc->exportCaption($this->revised_qty);
                    $doc->exportCaption($this->sqm);
                    $doc->exportCaption($this->ex_factory);
                    $doc->exportCaption($this->ex_factory_p);
                    $doc->exportCaption($this->shipping_mode);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->d_qty);
                    $doc->exportCaption($this->pl_no);
                    $doc->exportCaption($this->invoice_date);
                    $doc->exportCaption($this->sailing_week);
                    $doc->exportCaption($this->pending);
                    $doc->exportCaption($this->pending_sqm);
                    $doc->exportCaption($this->cbm);
                    $doc->exportCaption($this->total_cbm);
                    $doc->exportCaption($this->offloom);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->rejection);
                    $doc->exportCaption($this->completed);
                    $doc->exportCaption($this->weaving_works);
                    $doc->exportCaption($this->cs);
                    $doc->exportCaption($this->weight_sqm);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->order_week);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->category);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->buyer_order);
                        $doc->exportField($this->po);
                        $doc->exportField($this->item);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->design);
                        $doc->exportField($this->size_buyer);
                        $doc->exportField($this->width);
                        $doc->exportField($this->length);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->revised_qty);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->ex_factory);
                        $doc->exportField($this->ex_factory_p);
                        $doc->exportField($this->shipping_mode);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->d_qty);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->sailing_week);
                        $doc->exportField($this->pending);
                        $doc->exportField($this->pending_sqm);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->total_cbm);
                        $doc->exportField($this->offloom);
                        $doc->exportField($this->status);
                        $doc->exportField($this->rejection);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->cs);
                        $doc->exportField($this->weight_sqm);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->buyers_id);
                        $doc->exportField($this->reports_to);
                        $doc->exportField($this->order_week);
                        $doc->exportField($this->order_date);
                        $doc->exportField($this->category);
                        $doc->exportField($this->current_works);
                        $doc->exportField($this->buyer_order);
                        $doc->exportField($this->po);
                        $doc->exportField($this->item);
                        $doc->exportField($this->buyer_ref);
                        $doc->exportField($this->design);
                        $doc->exportField($this->size_buyer);
                        $doc->exportField($this->width);
                        $doc->exportField($this->length);
                        $doc->exportField($this->qty);
                        $doc->exportField($this->revised_qty);
                        $doc->exportField($this->sqm);
                        $doc->exportField($this->ex_factory);
                        $doc->exportField($this->ex_factory_p);
                        $doc->exportField($this->shipping_mode);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->d_qty);
                        $doc->exportField($this->pl_no);
                        $doc->exportField($this->invoice_date);
                        $doc->exportField($this->sailing_week);
                        $doc->exportField($this->pending);
                        $doc->exportField($this->pending_sqm);
                        $doc->exportField($this->cbm);
                        $doc->exportField($this->total_cbm);
                        $doc->exportField($this->offloom);
                        $doc->exportField($this->status);
                        $doc->exportField($this->rejection);
                        $doc->exportField($this->completed);
                        $doc->exportField($this->weaving_works);
                        $doc->exportField($this->cs);
                        $doc->exportField($this->weight_sqm);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
