<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class QcSearch extends Qc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "QcSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "qcsearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->qc_stage->setVisibility();
        $this->_barcode->setVisibility();
        $this->lines_in_30cm->setVisibility();
        $this->size_actual->setVisibility();
        $this->weight_actual->setVisibility();
        $this->defect_nature->setVisibility();
        $this->defect_percentage->setVisibility();
        $this->deduction->setVisibility();
        $this->comments->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->e_operator->setVisibility();
        $this->e_datetime->setVisibility();
        $this->_action->setVisibility();
        $this->remarks->setVisibility();
        $this->product_image->setVisibility();
        $this->design->setVisibility();
        $this->size->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
        $this->uid->Visible = false;
        $this->bcode_status->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'qc';
        $this->TableName = 'qc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (qc)
        if (!isset($GLOBALS["qc"]) || $GLOBALS["qc"]::class == PROJECT_NAMESPACE . "qc") {
            $GLOBALS["qc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'qc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "qcview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->qc_stage);
        $this->setupLookupOptions($this->defect_nature);
        $this->setupLookupOptions($this->defect_percentage);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->e_operator);
        $this->setupLookupOptions($this->a_operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "qclist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->location); // location
        $this->buildSearchUrl($srchUrl, $this->qc_stage); // qc_stage
        $this->buildSearchUrl($srchUrl, $this->_barcode); // barcode
        $this->buildSearchUrl($srchUrl, $this->lines_in_30cm); // lines_in_30cm
        $this->buildSearchUrl($srchUrl, $this->size_actual); // size_actual
        $this->buildSearchUrl($srchUrl, $this->weight_actual); // weight_actual
        $this->buildSearchUrl($srchUrl, $this->defect_nature); // defect_nature
        $this->buildSearchUrl($srchUrl, $this->defect_percentage); // defect_percentage
        $this->buildSearchUrl($srchUrl, $this->deduction); // deduction
        $this->buildSearchUrl($srchUrl, $this->comments); // comments
        $this->buildSearchUrl($srchUrl, $this->status); // status
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        $this->buildSearchUrl($srchUrl, $this->e_operator); // e_operator
        $this->buildSearchUrl($srchUrl, $this->e_datetime); // e_datetime
        $this->buildSearchUrl($srchUrl, $this->_action); // action
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->product_image); // product_image
        $this->buildSearchUrl($srchUrl, $this->design); // design
        $this->buildSearchUrl($srchUrl, $this->size); // size
        $this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
        $this->buildSearchUrl($srchUrl, $this->a_datetime); // a_datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // location
        if ($this->location->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // qc_stage
        if ($this->qc_stage->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // barcode
        if ($this->_barcode->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lines_in_30cm
        if ($this->lines_in_30cm->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size_actual
        if ($this->size_actual->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // weight_actual
        if ($this->weight_actual->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // defect_nature
        if ($this->defect_nature->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // defect_percentage
        if ($this->defect_percentage->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // deduction
        if ($this->deduction->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // comments
        if ($this->comments->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // status
        if ($this->status->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // e_operator
        if ($this->e_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // e_datetime
        if ($this->e_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // action
        if ($this->_action->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // product_image
        if ($this->product_image->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // design
        if ($this->design->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // size
        if ($this->size->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_operator
        if ($this->a_operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // a_datetime
        if ($this->a_datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // qc_stage
        $this->qc_stage->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // lines_in_30cm
        $this->lines_in_30cm->RowCssClass = "row";

        // size_actual
        $this->size_actual->RowCssClass = "row";

        // weight_actual
        $this->weight_actual->RowCssClass = "row";

        // defect_nature
        $this->defect_nature->RowCssClass = "row";

        // defect_percentage
        $this->defect_percentage->RowCssClass = "row";

        // deduction
        $this->deduction->RowCssClass = "row";

        // comments
        $this->comments->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // e_operator
        $this->e_operator->RowCssClass = "row";

        // e_datetime
        $this->e_datetime->RowCssClass = "row";

        // action
        $this->_action->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // product_image
        $this->product_image->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // bcode_status
        $this->bcode_status->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // qc_stage
            $curVal = strval($this->qc_stage->CurrentValue);
            if ($curVal != "") {
                $this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
                if ($this->qc_stage->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->qc_stage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->qc_stage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->qc_stage->getSelectFilter($this); // PHP
                    $sqlWrk = $this->qc_stage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->qc_stage->Lookup->renderViewRow($rswrk[0]);
                        $this->qc_stage->ViewValue = $this->qc_stage->displayValue($arwrk);
                    } else {
                        $this->qc_stage->ViewValue = FormatNumber($this->qc_stage->CurrentValue, $this->qc_stage->formatPattern());
                    }
                }
            } else {
                $this->qc_stage->ViewValue = null;
            }

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // lines_in_30cm
            $this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
            $this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, $this->lines_in_30cm->formatPattern());

            // size_actual
            $this->size_actual->ViewValue = $this->size_actual->CurrentValue;

            // weight_actual
            $this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
            $this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, $this->weight_actual->formatPattern());

            // defect_nature
            $curVal = strval($this->defect_nature->CurrentValue);
            if ($curVal != "") {
                $this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
                if ($this->defect_nature->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->defect_nature->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_nature->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->defect_nature->getSelectFilter($this); // PHP
                    $sqlWrk = $this->defect_nature->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->defect_nature->Lookup->renderViewRow($rswrk[0]);
                        $this->defect_nature->ViewValue = $this->defect_nature->displayValue($arwrk);
                    } else {
                        $this->defect_nature->ViewValue = $this->defect_nature->CurrentValue;
                    }
                }
            } else {
                $this->defect_nature->ViewValue = null;
            }

            // defect_percentage
            $curVal = strval($this->defect_percentage->CurrentValue);
            if ($curVal != "") {
                $this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
                if ($this->defect_percentage->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->defect_percentage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_percentage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->defect_percentage->getSelectFilter($this); // PHP
                    $sqlWrk = $this->defect_percentage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->defect_percentage->Lookup->renderViewRow($rswrk[0]);
                        $this->defect_percentage->ViewValue = $this->defect_percentage->displayValue($arwrk);
                    } else {
                        $this->defect_percentage->ViewValue = FormatNumber($this->defect_percentage->CurrentValue, $this->defect_percentage->formatPattern());
                    }
                }
            } else {
                $this->defect_percentage->ViewValue = null;
            }

            // deduction
            $this->deduction->ViewValue = $this->deduction->CurrentValue;
            $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

            // comments
            $this->comments->ViewValue = $this->comments->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $curVal = strval($this->e_operator->CurrentValue);
            if ($curVal != "") {
                $this->e_operator->ViewValue = $this->e_operator->lookupCacheOption($curVal);
                if ($this->e_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->e_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->e_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->e_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->e_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->e_operator->ViewValue = $this->e_operator->displayValue($arwrk);
                    } else {
                        $this->e_operator->ViewValue = FormatNumber($this->e_operator->CurrentValue, $this->e_operator->formatPattern());
                    }
                }
            } else {
                $this->e_operator->ViewValue = null;
            }

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // action
            $this->_action->ViewValue = $this->_action->CurrentValue;
            $this->_action->ViewValue = FormatNumber($this->_action->ViewValue, $this->_action->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // product_image
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->ImageWidth = 0;
                $this->product_image->ImageHeight = 50;
                $this->product_image->ImageAlt = $this->product_image->alt();
                $this->product_image->ImageCssClass = "ew-image";
                $this->product_image->ViewValue = $this->product_image->Upload->DbValue;
            } else {
                $this->product_image->ViewValue = "";
            }

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = FormatNumber($this->a_operator->CurrentValue, $this->a_operator->formatPattern());
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // qc_stage
            $this->qc_stage->HrefValue = "";
            $this->qc_stage->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // lines_in_30cm
            $this->lines_in_30cm->HrefValue = "";
            $this->lines_in_30cm->TooltipValue = "";

            // size_actual
            $this->size_actual->HrefValue = "";
            $this->size_actual->TooltipValue = "";

            // weight_actual
            $this->weight_actual->HrefValue = "";
            $this->weight_actual->TooltipValue = "";

            // defect_nature
            $this->defect_nature->HrefValue = "";
            $this->defect_nature->TooltipValue = "";

            // defect_percentage
            $this->defect_percentage->HrefValue = "";
            $this->defect_percentage->TooltipValue = "";

            // deduction
            $this->deduction->HrefValue = "";
            $this->deduction->TooltipValue = "";

            // comments
            $this->comments->HrefValue = "";
            $this->comments->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // e_operator
            $this->e_operator->HrefValue = "";
            $this->e_operator->TooltipValue = "";

            // e_datetime
            $this->e_datetime->HrefValue = "";
            $this->e_datetime->TooltipValue = "";

            // action
            $this->_action->HrefValue = "";
            $this->_action->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // product_image
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->HrefValue = GetFileUploadUrl($this->product_image, $this->product_image->htmlDecode($this->product_image->Upload->DbValue)); // Add prefix/suffix
                $this->product_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->product_image->HrefValue = FullUrl($this->product_image->HrefValue, "href");
                }
            } else {
                $this->product_image->HrefValue = "";
            }
            $this->product_image->ExportHrefValue = $this->product_image->UploadPath . $this->product_image->Upload->DbValue;
            $this->product_image->TooltipValue = "";
            if ($this->product_image->UseColorbox) {
                if (EmptyValue($this->product_image->TooltipValue)) {
                    $this->product_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->product_image->LinkAttrs["data-rel"] = "qc_x_product_image";
                $this->product_image->LinkAttrs->appendClass("ew-lightbox");
            }

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->location->AdvancedSearch->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->AdvancedSearch->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->AdvancedSearch->SearchValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // qc_stage
            $this->qc_stage->setupEditAttributes();
            $curVal = trim(strval($this->qc_stage->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->qc_stage->AdvancedSearch->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
            } else {
                $this->qc_stage->AdvancedSearch->ViewValue = $this->qc_stage->Lookup !== null && is_array($this->qc_stage->lookupOptions()) && count($this->qc_stage->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->qc_stage->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->qc_stage->EditValue = array_values($this->qc_stage->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->qc_stage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->qc_stage->AdvancedSearch->SearchValue, $this->qc_stage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->qc_stage->getSelectFilter($this); // PHP
                $sqlWrk = $this->qc_stage->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->qc_stage->EditValue = $arwrk;
            }
            $this->qc_stage->PlaceHolder = RemoveHtml($this->qc_stage->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->AdvancedSearch->SearchValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

            // lines_in_30cm
            $this->lines_in_30cm->setupEditAttributes();
            $this->lines_in_30cm->EditValue = $this->lines_in_30cm->AdvancedSearch->SearchValue;
            $this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());

            // size_actual
            $this->size_actual->setupEditAttributes();
            if (!$this->size_actual->Raw) {
                $this->size_actual->AdvancedSearch->SearchValue = HtmlDecode($this->size_actual->AdvancedSearch->SearchValue);
            }
            $this->size_actual->EditValue = HtmlEncode($this->size_actual->AdvancedSearch->SearchValue);
            $this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

            // weight_actual
            $this->weight_actual->setupEditAttributes();
            $this->weight_actual->EditValue = $this->weight_actual->AdvancedSearch->SearchValue;
            $this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());

            // defect_nature
            $this->defect_nature->setupEditAttributes();
            $curVal = trim(strval($this->defect_nature->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->defect_nature->AdvancedSearch->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
            } else {
                $this->defect_nature->AdvancedSearch->ViewValue = $this->defect_nature->Lookup !== null && is_array($this->defect_nature->lookupOptions()) && count($this->defect_nature->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->defect_nature->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->defect_nature->EditValue = array_values($this->defect_nature->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->defect_nature->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->defect_nature->AdvancedSearch->SearchValue, $this->defect_nature->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->defect_nature->getSelectFilter($this); // PHP
                $sqlWrk = $this->defect_nature->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->defect_nature->EditValue = $arwrk;
            }
            $this->defect_nature->PlaceHolder = RemoveHtml($this->defect_nature->caption());

            // defect_percentage
            $this->defect_percentage->setupEditAttributes();
            $curVal = trim(strval($this->defect_percentage->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->defect_percentage->AdvancedSearch->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
            } else {
                $this->defect_percentage->AdvancedSearch->ViewValue = $this->defect_percentage->Lookup !== null && is_array($this->defect_percentage->lookupOptions()) && count($this->defect_percentage->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->defect_percentage->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->defect_percentage->EditValue = array_values($this->defect_percentage->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->defect_percentage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->defect_percentage->AdvancedSearch->SearchValue, $this->defect_percentage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->defect_percentage->getSelectFilter($this); // PHP
                $sqlWrk = $this->defect_percentage->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->defect_percentage->EditValue = $arwrk;
            }
            $this->defect_percentage->PlaceHolder = RemoveHtml($this->defect_percentage->caption());

            // deduction
            $this->deduction->setupEditAttributes();
            $this->deduction->EditValue = $this->deduction->AdvancedSearch->SearchValue;
            $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
            $this->deduction->setupEditAttributes();
            $this->deduction->EditValue2 = $this->deduction->AdvancedSearch->SearchValue2;
            $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());

            // comments
            $this->comments->setupEditAttributes();
            if (!$this->comments->Raw) {
                $this->comments->AdvancedSearch->SearchValue = HtmlDecode($this->comments->AdvancedSearch->SearchValue);
            }
            $this->comments->EditValue = HtmlEncode($this->comments->AdvancedSearch->SearchValue);
            $this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->AdvancedSearch->SearchValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

            // e_operator
            $this->e_operator->setupEditAttributes();
            $curVal = trim(strval($this->e_operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->e_operator->AdvancedSearch->ViewValue = $this->e_operator->lookupCacheOption($curVal);
            } else {
                $this->e_operator->AdvancedSearch->ViewValue = $this->e_operator->Lookup !== null && is_array($this->e_operator->lookupOptions()) && count($this->e_operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->e_operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->e_operator->EditValue = array_values($this->e_operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->e_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->e_operator->AdvancedSearch->SearchValue, $this->e_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->e_operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->e_operator->EditValue = $arwrk;
            }
            $this->e_operator->PlaceHolder = RemoveHtml($this->e_operator->caption());

            // e_datetime
            $this->e_datetime->setupEditAttributes();
            $this->e_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->e_datetime->AdvancedSearch->SearchValue, $this->e_datetime->formatPattern()), $this->e_datetime->formatPattern()));
            $this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());
            $this->e_datetime->setupEditAttributes();
            $this->e_datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->e_datetime->AdvancedSearch->SearchValue2, $this->e_datetime->formatPattern()), $this->e_datetime->formatPattern()));
            $this->e_datetime->PlaceHolder = RemoveHtml($this->e_datetime->caption());

            // action
            $this->_action->setupEditAttributes();
            $this->_action->EditValue = $this->_action->AdvancedSearch->SearchValue;
            $this->_action->PlaceHolder = RemoveHtml($this->_action->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // product_image
            $this->product_image->setupEditAttributes();
            if (!$this->product_image->Raw) {
                $this->product_image->AdvancedSearch->SearchValue = HtmlDecode($this->product_image->AdvancedSearch->SearchValue);
            }
            $this->product_image->EditValue = HtmlEncode($this->product_image->AdvancedSearch->SearchValue);
            $this->product_image->PlaceHolder = RemoveHtml($this->product_image->caption());

            // design
            $this->design->setupEditAttributes();
            if (!$this->design->Raw) {
                $this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
            }
            $this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
            $this->design->PlaceHolder = RemoveHtml($this->design->caption());

            // size
            $this->size->setupEditAttributes();
            if (!$this->size->Raw) {
                $this->size->AdvancedSearch->SearchValue = HtmlDecode($this->size->AdvancedSearch->SearchValue);
            }
            $this->size->EditValue = HtmlEncode($this->size->AdvancedSearch->SearchValue);
            $this->size->PlaceHolder = RemoveHtml($this->size->caption());

            // a_operator
            $this->a_operator->setupEditAttributes();
            $curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            } else {
                $this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== null && is_array($this->a_operator->lookupOptions()) && count($this->a_operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->a_operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->a_operator->EditValue = array_values($this->a_operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->a_operator->AdvancedSearch->SearchValue, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->a_operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->a_operator->EditValue = $arwrk;
            }
            $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());
            $this->a_operator->setupEditAttributes();
            $curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->a_operator->AdvancedSearch->ViewValue2 = $this->a_operator->lookupCacheOption($curVal);
            } else {
                $this->a_operator->AdvancedSearch->ViewValue2 = $this->a_operator->Lookup !== null && is_array($this->a_operator->lookupOptions()) && count($this->a_operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->a_operator->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->a_operator->EditValue2 = array_values($this->a_operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->a_operator->AdvancedSearch->SearchValue2, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->a_operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->a_operator->EditValue2 = $arwrk;
            }
            $this->a_operator->PlaceHolder = RemoveHtml($this->a_operator->caption());

            // a_datetime
            $this->a_datetime->setupEditAttributes();
            $this->a_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->a_datetime->AdvancedSearch->SearchValue, $this->a_datetime->formatPattern()), $this->a_datetime->formatPattern()));
            $this->a_datetime->PlaceHolder = RemoveHtml($this->a_datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->lines_in_30cm->AdvancedSearch->SearchValue)) {
            $this->lines_in_30cm->addErrorMessage($this->lines_in_30cm->getErrorMessage(false));
        }
        if (!CheckNumber($this->weight_actual->AdvancedSearch->SearchValue)) {
            $this->weight_actual->addErrorMessage($this->weight_actual->getErrorMessage(false));
        }
        if (!CheckInteger($this->deduction->AdvancedSearch->SearchValue)) {
            $this->deduction->addErrorMessage($this->deduction->getErrorMessage(false));
        }
        if (!CheckInteger($this->deduction->AdvancedSearch->SearchValue2)) {
            $this->deduction->addErrorMessage($this->deduction->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern())) {
            $this->datetime->addErrorMessage($this->datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->e_datetime->AdvancedSearch->SearchValue, $this->e_datetime->formatPattern())) {
            $this->e_datetime->addErrorMessage($this->e_datetime->getErrorMessage(false));
        }
        if (!CheckDate($this->e_datetime->AdvancedSearch->SearchValue2, $this->e_datetime->formatPattern())) {
            $this->e_datetime->addErrorMessage($this->e_datetime->getErrorMessage(false));
        }
        if (!CheckInteger($this->_action->AdvancedSearch->SearchValue)) {
            $this->_action->addErrorMessage($this->_action->getErrorMessage(false));
        }
        if (!CheckDate($this->a_datetime->AdvancedSearch->SearchValue, $this->a_datetime->formatPattern())) {
            $this->a_datetime->addErrorMessage($this->a_datetime->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->location->AdvancedSearch->load();
        $this->qc_stage->AdvancedSearch->load();
        $this->_barcode->AdvancedSearch->load();
        $this->lines_in_30cm->AdvancedSearch->load();
        $this->size_actual->AdvancedSearch->load();
        $this->weight_actual->AdvancedSearch->load();
        $this->defect_nature->AdvancedSearch->load();
        $this->defect_percentage->AdvancedSearch->load();
        $this->deduction->AdvancedSearch->load();
        $this->comments->AdvancedSearch->load();
        $this->status->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
        $this->e_operator->AdvancedSearch->load();
        $this->e_datetime->AdvancedSearch->load();
        $this->_action->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->product_image->AdvancedSearch->load();
        $this->design->AdvancedSearch->load();
        $this->size->AdvancedSearch->load();
        $this->a_operator->AdvancedSearch->load();
        $this->a_datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("qclist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_qc_stage":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_defect_nature":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_defect_percentage":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_e_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'qc');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
