<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for qc_old
 */
class QcOld extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $location;
    public $_barcode;
    public $defect_nature;
    public $qc_stage;
    public $defect_percentage;
    public $deduction;
    public $comments;
    public $status;
    public $operator;
    public $datetime;
    public $e_operator;
    public $e_datetime;
    public $_action;
    public $remarks;
    public $a_operator;
    public $a_datetime;
    public $uid;
    public $design;
    public $size;
    public $lines_in_30cm;
    public $size_actual;
    public $weight_actual;
    public $bcode_status;
    public $product_image;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "qc_old";
        $this->TableName = 'qc_old';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "qc_old";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // location
        $this->location = new DbField(
            $this, // Table
            'x_location', // Variable name
            'location', // Name
            '`location`', // Expression
            '`location`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`location`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->location->addMethod("getSelectFilter", fn() => (User_Site()  == 0)? "`id` > 0" : "`id` > 0 and FIND_IN_SET(`id`, '" . User_Site() . "')");
        $this->location->addMethod("getDefault", fn() => ((isset($_COOKIE["Location"]))? $_COOKIE["Location"]:''));
        $this->location->InputTextType = "text";
        $this->location->Raw = true;
        $this->location->Nullable = false; // NOT NULL field
        $this->location->Required = true; // Required field
        $this->location->setSelectMultiple(false); // Select one
        $this->location->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->location->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->location->Lookup = new Lookup($this->location, 'godown', true, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->location) . "',COALESCE(`code`,''))");
        $this->location->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->location->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['location'] = &$this->location;

        // barcode
        $this->_barcode = new DbField(
            $this, // Table
            'x__barcode', // Variable name
            'barcode', // Name
            '`barcode`', // Expression
            '`barcode`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`barcode`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_barcode->InputTextType = "text";
        $this->_barcode->Raw = true;
        $this->_barcode->Nullable = false; // NOT NULL field
        $this->_barcode->Required = true; // Required field
        $this->_barcode->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->_barcode->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['barcode'] = &$this->_barcode;

        // defect_nature
        $this->defect_nature = new DbField(
            $this, // Table
            'x_defect_nature', // Variable name
            'defect_nature', // Name
            '`defect_nature`', // Expression
            '`defect_nature`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`defect_nature`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->defect_nature->addMethod("getSelectFilter", fn() => "`grp` = 3 and `status` = 1");
        $this->defect_nature->addMethod("getDefault", fn() => 30);
        $this->defect_nature->InputTextType = "text";
        $this->defect_nature->Nullable = false; // NOT NULL field
        $this->defect_nature->Required = true; // Required field
        $this->defect_nature->setSelectMultiple(false); // Select one
        $this->defect_nature->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->defect_nature->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->defect_nature->Lookup = new Lookup($this->defect_nature, 'qc_items', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->defect_nature->SearchOperators = ["=", "<>"];
        $this->Fields['defect_nature'] = &$this->defect_nature;

        // qc_stage
        $this->qc_stage = new DbField(
            $this, // Table
            'x_qc_stage', // Variable name
            'qc_stage', // Name
            '`qc_stage`', // Expression
            '`qc_stage`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qc_stage`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->qc_stage->addMethod("getSelectFilter", fn() => "`grp` = 2 and `status` = 1");
        $this->qc_stage->addMethod("getDefault", fn() => ((isset($_COOKIE["qcs"]))? $_COOKIE["qcs"]:''));
        $this->qc_stage->InputTextType = "text";
        $this->qc_stage->Raw = true;
        $this->qc_stage->Nullable = false; // NOT NULL field
        $this->qc_stage->Required = true; // Required field
        $this->qc_stage->setSelectMultiple(false); // Select one
        $this->qc_stage->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->qc_stage->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->qc_stage->Lookup = new Lookup($this->qc_stage, 'qc_items', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->qc_stage->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->qc_stage->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['qc_stage'] = &$this->qc_stage;

        // defect_percentage
        $this->defect_percentage = new DbField(
            $this, // Table
            'x_defect_percentage', // Variable name
            'defect_percentage', // Name
            '`defect_percentage`', // Expression
            '`defect_percentage`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`defect_percentage`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->defect_percentage->addMethod("getSelectFilter", fn() => "`grp` = 4 and `status` = 1");
        $this->defect_percentage->addMethod("getDefault", fn() => 0);
        $this->defect_percentage->InputTextType = "text";
        $this->defect_percentage->Raw = true;
        $this->defect_percentage->setSelectMultiple(false); // Select one
        $this->defect_percentage->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->defect_percentage->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->defect_percentage->Lookup = new Lookup($this->defect_percentage, 'qc_items', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->defect_percentage->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->defect_percentage->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['defect_percentage'] = &$this->defect_percentage;

        // deduction
        $this->deduction = new DbField(
            $this, // Table
            'x_deduction', // Variable name
            'deduction', // Name
            '`deduction`', // Expression
            '`deduction`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`deduction`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->deduction->addMethod("getDefault", fn() => 0);
        $this->deduction->InputTextType = "text";
        $this->deduction->Raw = true;
        $this->deduction->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->deduction->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['deduction'] = &$this->deduction;

        // comments
        $this->comments = new DbField(
            $this, // Table
            'x_comments', // Variable name
            'comments', // Name
            '`comments`', // Expression
            '`comments`', // Basic search expression
            200, // Type
            255, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`comments`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->comments->InputTextType = "text";
        $this->comments->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['comments'] = &$this->comments;

        // status
        $this->status = new DbField(
            $this, // Table
            'x_status', // Variable name
            'status', // Name
            '`status`', // Expression
            '`status`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->status->addMethod("getSelectFilter", fn() => "`grp` = 5 and `status` = 1");
        $this->status->addMethod("getDefault", fn() => 0);
        $this->status->InputTextType = "text";
        $this->status->Raw = true;
        $this->status->setSelectMultiple(false); // Select one
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->status->Lookup = new Lookup($this->status, 'qc_items', false, 'id', ["item","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`item`");
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->status->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['status'] = &$this->status;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->Nullable = false; // NOT NULL field
        $this->datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['datetime'] = &$this->datetime;

        // e_operator
        $this->e_operator = new DbField(
            $this, // Table
            'x_e_operator', // Variable name
            'e_operator', // Name
            '`e_operator`', // Expression
            '`e_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`e_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->e_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->e_operator->InputTextType = "text";
        $this->e_operator->Raw = true;
        $this->e_operator->setSelectMultiple(false); // Select one
        $this->e_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->e_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->e_operator->Lookup = new Lookup($this->e_operator, 'admin', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->e_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->e_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['e_operator'] = &$this->e_operator;

        // e_datetime
        $this->e_datetime = new DbField(
            $this, // Table
            'x_e_datetime', // Variable name
            'e_datetime', // Name
            '`e_datetime`', // Expression
            CastDateFieldForLike("`e_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`e_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->e_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->e_datetime->InputTextType = "text";
        $this->e_datetime->Raw = true;
        $this->e_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->e_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['e_datetime'] = &$this->e_datetime;

        // action
        $this->_action = new DbField(
            $this, // Table
            'x__action', // Variable name
            'action', // Name
            '`action`', // Expression
            '`action`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`action`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->_action->InputTextType = "text";
        $this->_action->Raw = true;
        $this->_action->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->_action->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['action'] = &$this->_action;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // a_operator
        $this->a_operator = new DbField(
            $this, // Table
            'x_a_operator', // Variable name
            'a_operator', // Name
            '`a_operator`', // Expression
            '`a_operator`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`a_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->a_operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->a_operator->InputTextType = "text";
        $this->a_operator->Raw = true;
        $this->a_operator->setSelectMultiple(false); // Select one
        $this->a_operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->a_operator->Lookup = new Lookup($this->a_operator, 'admin', false, 'id', ["id","","",""], '', '', [], [], [], [], [], [], false, '`id` ASC', '', "`id`");
        $this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->a_operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_operator'] = &$this->a_operator;

        // a_datetime
        $this->a_datetime = new DbField(
            $this, // Table
            'x_a_datetime', // Variable name
            'a_datetime', // Name
            '`a_datetime`', // Expression
            CastDateFieldForLike("`a_datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`a_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->a_datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->a_datetime->InputTextType = "text";
        $this->a_datetime->Raw = true;
        $this->a_datetime->DefaultErrorMessage = str_replace("%s", DateFormat(111), $Language->phrase("IncorrectDate"));
        $this->a_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['a_datetime'] = &$this->a_datetime;

        // uid
        $this->uid = new DbField(
            $this, // Table
            'x_uid', // Variable name
            'uid', // Name
            '`uid`', // Expression
            '`uid`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`uid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->uid->InputTextType = "text";
        $this->uid->Sortable = false; // Allow sort
        $this->uid->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['uid'] = &$this->uid;

        // design
        $this->design = new DbField(
            $this, // Table
            'x_design', // Variable name
            'design', // Name
            '`design`', // Expression
            '`design`', // Basic search expression
            200, // Type
            96, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`design`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->design->InputTextType = "text";
        $this->design->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['design'] = &$this->design;

        // size
        $this->size = new DbField(
            $this, // Table
            'x_size', // Variable name
            'size', // Name
            '`size`', // Expression
            '`size`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size->InputTextType = "text";
        $this->size->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size'] = &$this->size;

        // lines_in_30cm
        $this->lines_in_30cm = new DbField(
            $this, // Table
            'x_lines_in_30cm', // Variable name
            'lines_in_30cm', // Name
            '`lines_in_30cm`', // Expression
            '`lines_in_30cm`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lines_in_30cm`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lines_in_30cm->InputTextType = "text";
        $this->lines_in_30cm->Raw = true;
        $this->lines_in_30cm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->lines_in_30cm->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['lines_in_30cm'] = &$this->lines_in_30cm;

        // size_actual
        $this->size_actual = new DbField(
            $this, // Table
            'x_size_actual', // Variable name
            'size_actual', // Name
            '`size_actual`', // Expression
            '`size_actual`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`size_actual`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->size_actual->InputTextType = "text";
        $this->size_actual->Required = true; // Required field
        $this->size_actual->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['size_actual'] = &$this->size_actual;

        // weight_actual
        $this->weight_actual = new DbField(
            $this, // Table
            'x_weight_actual', // Variable name
            'weight_actual', // Name
            '`weight_actual`', // Expression
            '`weight_actual`', // Basic search expression
            131, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`weight_actual`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->weight_actual->InputTextType = "text";
        $this->weight_actual->Raw = true;
        $this->weight_actual->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->weight_actual->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['weight_actual'] = &$this->weight_actual;

        // bcode_status
        $this->bcode_status = new DbField(
            $this, // Table
            'x_bcode_status', // Variable name
            'bcode_status', // Name
            '`bcode_status`', // Expression
            '`bcode_status`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bcode_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bcode_status->InputTextType = "text";
        $this->bcode_status->Raw = true;
        $this->bcode_status->Sortable = false; // Allow sort
        $this->bcode_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->bcode_status->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['bcode_status'] = &$this->bcode_status;

        // product_image
        $this->product_image = new DbField(
            $this, // Table
            'x_product_image', // Variable name
            'product_image', // Name
            '`product_image`', // Expression
            '`product_image`', // Basic search expression
            200, // Type
            250, // Size
            -1, // Date/Time format
            true, // Is upload field
            '`product_image`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'IMAGE', // View Tag
            'FILE' // Edit Tag
        );
        $this->product_image->InputTextType = "text";
        $this->product_image->ImageResize = true;
        $this->product_image->SearchOperators = ["=", "<>", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['product_image'] = &$this->product_image;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "qc_old";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "`operator` = " .  CurrentUserID() . "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->location->DbValue = $row['location'];
        $this->_barcode->DbValue = $row['barcode'];
        $this->defect_nature->DbValue = $row['defect_nature'];
        $this->qc_stage->DbValue = $row['qc_stage'];
        $this->defect_percentage->DbValue = $row['defect_percentage'];
        $this->deduction->DbValue = $row['deduction'];
        $this->comments->DbValue = $row['comments'];
        $this->status->DbValue = $row['status'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->e_operator->DbValue = $row['e_operator'];
        $this->e_datetime->DbValue = $row['e_datetime'];
        $this->_action->DbValue = $row['action'];
        $this->remarks->DbValue = $row['remarks'];
        $this->a_operator->DbValue = $row['a_operator'];
        $this->a_datetime->DbValue = $row['a_datetime'];
        $this->uid->DbValue = $row['uid'];
        $this->design->DbValue = $row['design'];
        $this->size->DbValue = $row['size'];
        $this->lines_in_30cm->DbValue = $row['lines_in_30cm'];
        $this->size_actual->DbValue = $row['size_actual'];
        $this->weight_actual->DbValue = $row['weight_actual'];
        $this->bcode_status->DbValue = $row['bcode_status'];
        $this->product_image->Upload->DbValue = $row['product_image'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
        $oldFiles = EmptyValue($row['product_image']) ? [] : [$row['product_image']];
        foreach ($oldFiles as $oldFile) {
            if (file_exists($this->product_image->oldPhysicalUploadPath() . $oldFile)) {
                @unlink($this->product_image->oldPhysicalUploadPath() . $oldFile);
            }
        }
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("qcoldlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "qcoldview" => $Language->phrase("View"),
            "qcoldedit" => $Language->phrase("Edit"),
            "qcoldadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "qcoldlist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "QcOldView",
            Config("API_ADD_ACTION") => "QcOldAdd",
            Config("API_EDIT_ACTION") => "QcOldEdit",
            Config("API_DELETE_ACTION") => "QcOldDelete",
            Config("API_LIST_ACTION") => "QcOldList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "qcoldlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("qcoldview", $parm);
        } else {
            $url = $this->keyUrl("qcoldview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "qcoldadd?" . $parm;
        } else {
            $url = "qcoldadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("qcoldedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("qcoldlist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("qcoldadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("qcoldlist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("qcolddelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->defect_nature->setDbValue($row['defect_nature']);
        $this->qc_stage->setDbValue($row['qc_stage']);
        $this->defect_percentage->setDbValue($row['defect_percentage']);
        $this->deduction->setDbValue($row['deduction']);
        $this->comments->setDbValue($row['comments']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_operator->setDbValue($row['e_operator']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->_action->setDbValue($row['action']);
        $this->remarks->setDbValue($row['remarks']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->uid->setDbValue($row['uid']);
        $this->design->setDbValue($row['design']);
        $this->size->setDbValue($row['size']);
        $this->lines_in_30cm->setDbValue($row['lines_in_30cm']);
        $this->size_actual->setDbValue($row['size_actual']);
        $this->weight_actual->setDbValue($row['weight_actual']);
        $this->bcode_status->setDbValue($row['bcode_status']);
        $this->product_image->Upload->DbValue = $row['product_image'];
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "QcOldList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // location

        // barcode

        // defect_nature

        // qc_stage

        // defect_percentage

        // deduction
        $this->deduction->CellCssStyle = "white-space: nowrap;";

        // comments

        // status

        // operator

        // datetime

        // e_operator

        // e_datetime

        // action

        // remarks

        // a_operator

        // a_datetime

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // design

        // size

        // lines_in_30cm

        // size_actual

        // weight_actual

        // bcode_status
        $this->bcode_status->CellCssStyle = "white-space: nowrap;";

        // product_image

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // location
        $curVal = strval($this->location->CurrentValue);
        if ($curVal != "") {
            $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            if ($this->location->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                    $this->location->ViewValue = $this->location->displayValue($arwrk);
                } else {
                    $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                }
            }
        } else {
            $this->location->ViewValue = null;
        }

        // barcode
        $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
        $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

        // defect_nature
        $curVal = strval($this->defect_nature->CurrentValue);
        if ($curVal != "") {
            $this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
            if ($this->defect_nature->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->defect_nature->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_nature->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->defect_nature->getSelectFilter($this); // PHP
                $sqlWrk = $this->defect_nature->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->defect_nature->Lookup->renderViewRow($rswrk[0]);
                    $this->defect_nature->ViewValue = $this->defect_nature->displayValue($arwrk);
                } else {
                    $this->defect_nature->ViewValue = $this->defect_nature->CurrentValue;
                }
            }
        } else {
            $this->defect_nature->ViewValue = null;
        }

        // qc_stage
        $curVal = strval($this->qc_stage->CurrentValue);
        if ($curVal != "") {
            $this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
            if ($this->qc_stage->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->qc_stage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->qc_stage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->qc_stage->getSelectFilter($this); // PHP
                $sqlWrk = $this->qc_stage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->qc_stage->Lookup->renderViewRow($rswrk[0]);
                    $this->qc_stage->ViewValue = $this->qc_stage->displayValue($arwrk);
                } else {
                    $this->qc_stage->ViewValue = FormatNumber($this->qc_stage->CurrentValue, $this->qc_stage->formatPattern());
                }
            }
        } else {
            $this->qc_stage->ViewValue = null;
        }

        // defect_percentage
        $curVal = strval($this->defect_percentage->CurrentValue);
        if ($curVal != "") {
            $this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
            if ($this->defect_percentage->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->defect_percentage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_percentage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->defect_percentage->getSelectFilter($this); // PHP
                $sqlWrk = $this->defect_percentage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->defect_percentage->Lookup->renderViewRow($rswrk[0]);
                    $this->defect_percentage->ViewValue = $this->defect_percentage->displayValue($arwrk);
                } else {
                    $this->defect_percentage->ViewValue = FormatNumber($this->defect_percentage->CurrentValue, $this->defect_percentage->formatPattern());
                }
            }
        } else {
            $this->defect_percentage->ViewValue = null;
        }

        // deduction
        $this->deduction->ViewValue = $this->deduction->CurrentValue;
        $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

        // comments
        $this->comments->ViewValue = $this->comments->CurrentValue;

        // status
        $curVal = strval($this->status->CurrentValue);
        if ($curVal != "") {
            $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            if ($this->status->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                    $this->status->ViewValue = $this->status->displayValue($arwrk);
                } else {
                    $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                }
            }
        } else {
            $this->status->ViewValue = null;
        }

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // e_operator
        $curVal = strval($this->e_operator->CurrentValue);
        if ($curVal != "") {
            $this->e_operator->ViewValue = $this->e_operator->lookupCacheOption($curVal);
            if ($this->e_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->e_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->e_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->e_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->e_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->e_operator->ViewValue = $this->e_operator->displayValue($arwrk);
                } else {
                    $this->e_operator->ViewValue = FormatNumber($this->e_operator->CurrentValue, $this->e_operator->formatPattern());
                }
            }
        } else {
            $this->e_operator->ViewValue = null;
        }

        // e_datetime
        $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
        $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

        // action
        $this->_action->ViewValue = $this->_action->CurrentValue;
        $this->_action->ViewValue = FormatNumber($this->_action->ViewValue, $this->_action->formatPattern());

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // a_operator
        $curVal = strval($this->a_operator->CurrentValue);
        if ($curVal != "") {
            $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
            if ($this->a_operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                    $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                } else {
                    $this->a_operator->ViewValue = FormatNumber($this->a_operator->CurrentValue, $this->a_operator->formatPattern());
                }
            }
        } else {
            $this->a_operator->ViewValue = null;
        }

        // a_datetime
        $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
        $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

        // uid
        $this->uid->ViewValue = $this->uid->CurrentValue;

        // design
        $this->design->ViewValue = $this->design->CurrentValue;

        // size
        $this->size->ViewValue = $this->size->CurrentValue;

        // lines_in_30cm
        $this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
        $this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, $this->lines_in_30cm->formatPattern());

        // size_actual
        $this->size_actual->ViewValue = $this->size_actual->CurrentValue;

        // weight_actual
        $this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
        $this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, $this->weight_actual->formatPattern());

        // bcode_status
        $this->bcode_status->ViewValue = $this->bcode_status->CurrentValue;
        $this->bcode_status->ViewValue = FormatNumber($this->bcode_status->ViewValue, $this->bcode_status->formatPattern());

        // product_image
        if (!EmptyValue($this->product_image->Upload->DbValue)) {
            $this->product_image->ImageWidth = 0;
            $this->product_image->ImageHeight = 50;
            $this->product_image->ImageAlt = $this->product_image->alt();
            $this->product_image->ImageCssClass = "ew-image";
            $this->product_image->ViewValue = $this->product_image->Upload->DbValue;
        } else {
            $this->product_image->ViewValue = "";
        }

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // location
        $this->location->HrefValue = "";
        $this->location->TooltipValue = "";

        // barcode
        $this->_barcode->HrefValue = "";
        $this->_barcode->TooltipValue = "";

        // defect_nature
        $this->defect_nature->HrefValue = "";
        $this->defect_nature->TooltipValue = "";

        // qc_stage
        $this->qc_stage->HrefValue = "";
        $this->qc_stage->TooltipValue = "";

        // defect_percentage
        $this->defect_percentage->HrefValue = "";
        $this->defect_percentage->TooltipValue = "";

        // deduction
        $this->deduction->HrefValue = "";
        $this->deduction->TooltipValue = "";

        // comments
        $this->comments->HrefValue = "";
        $this->comments->TooltipValue = "";

        // status
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // e_operator
        $this->e_operator->HrefValue = "";
        $this->e_operator->TooltipValue = "";

        // e_datetime
        $this->e_datetime->HrefValue = "";
        $this->e_datetime->TooltipValue = "";

        // action
        $this->_action->HrefValue = "";
        $this->_action->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // a_operator
        $this->a_operator->HrefValue = "";
        $this->a_operator->TooltipValue = "";

        // a_datetime
        $this->a_datetime->HrefValue = "";
        $this->a_datetime->TooltipValue = "";

        // uid
        $this->uid->HrefValue = "";
        $this->uid->TooltipValue = "";

        // design
        $this->design->HrefValue = "";
        $this->design->TooltipValue = "";

        // size
        $this->size->HrefValue = "";
        $this->size->TooltipValue = "";

        // lines_in_30cm
        $this->lines_in_30cm->HrefValue = "";
        $this->lines_in_30cm->TooltipValue = "";

        // size_actual
        $this->size_actual->HrefValue = "";
        $this->size_actual->TooltipValue = "";

        // weight_actual
        $this->weight_actual->HrefValue = "";
        $this->weight_actual->TooltipValue = "";

        // bcode_status
        $this->bcode_status->HrefValue = "";
        $this->bcode_status->TooltipValue = "";

        // product_image
        if (!EmptyValue($this->product_image->Upload->DbValue)) {
            $this->product_image->HrefValue = GetFileUploadUrl($this->product_image, $this->product_image->htmlDecode($this->product_image->Upload->DbValue)); // Add prefix/suffix
            $this->product_image->LinkAttrs["target"] = ""; // Add target
            if ($this->isExport()) {
                $this->product_image->HrefValue = FullUrl($this->product_image->HrefValue, "href");
            }
        } else {
            $this->product_image->HrefValue = "";
        }
        $this->product_image->ExportHrefValue = $this->product_image->UploadPath . $this->product_image->Upload->DbValue;
        $this->product_image->TooltipValue = "";
        if ($this->product_image->UseColorbox) {
            if (EmptyValue($this->product_image->TooltipValue)) {
                $this->product_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
            }
            $this->product_image->LinkAttrs["data-rel"] = "qc_old_x_product_image";
            $this->product_image->LinkAttrs->appendClass("ew-lightbox");
        }

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // location
        $this->location->setupEditAttributes();
        $this->location->PlaceHolder = RemoveHtml($this->location->caption());

        // barcode
        $this->_barcode->setupEditAttributes();
        $this->_barcode->EditValue = $this->_barcode->CurrentValue;
        $this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, $this->_barcode->formatPattern());

        // defect_nature
        $this->defect_nature->setupEditAttributes();
        $this->defect_nature->PlaceHolder = RemoveHtml($this->defect_nature->caption());

        // qc_stage
        $this->qc_stage->setupEditAttributes();
        $this->qc_stage->PlaceHolder = RemoveHtml($this->qc_stage->caption());

        // defect_percentage
        $this->defect_percentage->setupEditAttributes();
        $this->defect_percentage->PlaceHolder = RemoveHtml($this->defect_percentage->caption());

        // deduction
        $this->deduction->setupEditAttributes();
        $this->deduction->EditValue = $this->deduction->CurrentValue;
        $this->deduction->EditValue = FormatNumber($this->deduction->EditValue, $this->deduction->formatPattern());

        // comments
        $this->comments->setupEditAttributes();
        if (!$this->comments->Raw) {
            $this->comments->CurrentValue = HtmlDecode($this->comments->CurrentValue);
        }
        $this->comments->EditValue = $this->comments->CurrentValue;
        $this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

        // status
        $this->status->setupEditAttributes();
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // operator

        // datetime

        // e_operator

        // e_datetime

        // action
        $this->_action->setupEditAttributes();
        $this->_action->EditValue = $this->_action->CurrentValue;
        $this->_action->PlaceHolder = RemoveHtml($this->_action->caption());
        if (strval($this->_action->EditValue) != "" && is_numeric($this->_action->EditValue)) {
            $this->_action->EditValue = FormatNumber($this->_action->EditValue, null);
        }

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // a_operator

        // a_datetime

        // uid
        $this->uid->setupEditAttributes();
        if (!$this->uid->Raw) {
            $this->uid->CurrentValue = HtmlDecode($this->uid->CurrentValue);
        }
        $this->uid->EditValue = $this->uid->CurrentValue;
        $this->uid->PlaceHolder = RemoveHtml($this->uid->caption());

        // design
        $this->design->setupEditAttributes();
        if (!$this->design->Raw) {
            $this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
        }
        $this->design->EditValue = $this->design->CurrentValue;
        $this->design->PlaceHolder = RemoveHtml($this->design->caption());

        // size
        $this->size->setupEditAttributes();
        if (!$this->size->Raw) {
            $this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
        }
        $this->size->EditValue = $this->size->CurrentValue;
        $this->size->PlaceHolder = RemoveHtml($this->size->caption());

        // lines_in_30cm
        $this->lines_in_30cm->setupEditAttributes();
        $this->lines_in_30cm->EditValue = $this->lines_in_30cm->CurrentValue;
        $this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());
        if (strval($this->lines_in_30cm->EditValue) != "" && is_numeric($this->lines_in_30cm->EditValue)) {
            $this->lines_in_30cm->EditValue = FormatNumber($this->lines_in_30cm->EditValue, null);
        }

        // size_actual
        $this->size_actual->setupEditAttributes();
        if (!$this->size_actual->Raw) {
            $this->size_actual->CurrentValue = HtmlDecode($this->size_actual->CurrentValue);
        }
        $this->size_actual->EditValue = $this->size_actual->CurrentValue;
        $this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

        // weight_actual
        $this->weight_actual->setupEditAttributes();
        $this->weight_actual->EditValue = $this->weight_actual->CurrentValue;
        $this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());
        if (strval($this->weight_actual->EditValue) != "" && is_numeric($this->weight_actual->EditValue)) {
            $this->weight_actual->EditValue = FormatNumber($this->weight_actual->EditValue, null);
        }

        // bcode_status
        $this->bcode_status->setupEditAttributes();
        $this->bcode_status->EditValue = $this->bcode_status->CurrentValue;
        $this->bcode_status->PlaceHolder = RemoveHtml($this->bcode_status->caption());
        if (strval($this->bcode_status->EditValue) != "" && is_numeric($this->bcode_status->EditValue)) {
            $this->bcode_status->EditValue = FormatNumber($this->bcode_status->EditValue, null);
        }

        // product_image
        $this->product_image->setupEditAttributes();
        if (!EmptyValue($this->product_image->Upload->DbValue)) {
            $this->product_image->ImageWidth = 0;
            $this->product_image->ImageHeight = 50;
            $this->product_image->ImageAlt = $this->product_image->alt();
            $this->product_image->ImageCssClass = "ew-image";
            $this->product_image->EditValue = $this->product_image->Upload->DbValue;
        } else {
            $this->product_image->EditValue = "";
        }
        if (!EmptyValue($this->product_image->CurrentValue)) {
            $this->product_image->Upload->FileName = $this->product_image->CurrentValue;
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->defect_nature);
                    $doc->exportCaption($this->qc_stage);
                    $doc->exportCaption($this->defect_percentage);
                    $doc->exportCaption($this->deduction);
                    $doc->exportCaption($this->comments);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->e_operator);
                    $doc->exportCaption($this->e_datetime);
                    $doc->exportCaption($this->_action);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->a_datetime);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->lines_in_30cm);
                    $doc->exportCaption($this->size_actual);
                    $doc->exportCaption($this->weight_actual);
                    $doc->exportCaption($this->product_image);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->location);
                    $doc->exportCaption($this->_barcode);
                    $doc->exportCaption($this->defect_nature);
                    $doc->exportCaption($this->qc_stage);
                    $doc->exportCaption($this->defect_percentage);
                    $doc->exportCaption($this->deduction);
                    $doc->exportCaption($this->comments);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->e_operator);
                    $doc->exportCaption($this->e_datetime);
                    $doc->exportCaption($this->_action);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->a_operator);
                    $doc->exportCaption($this->a_datetime);
                    $doc->exportCaption($this->design);
                    $doc->exportCaption($this->size);
                    $doc->exportCaption($this->lines_in_30cm);
                    $doc->exportCaption($this->size_actual);
                    $doc->exportCaption($this->weight_actual);
                    $doc->exportCaption($this->product_image);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->defect_nature);
                        $doc->exportField($this->qc_stage);
                        $doc->exportField($this->defect_percentage);
                        $doc->exportField($this->deduction);
                        $doc->exportField($this->comments);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->e_operator);
                        $doc->exportField($this->e_datetime);
                        $doc->exportField($this->_action);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->a_datetime);
                        $doc->exportField($this->design);
                        $doc->exportField($this->size);
                        $doc->exportField($this->lines_in_30cm);
                        $doc->exportField($this->size_actual);
                        $doc->exportField($this->weight_actual);
                        $doc->exportField($this->product_image);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->location);
                        $doc->exportField($this->_barcode);
                        $doc->exportField($this->defect_nature);
                        $doc->exportField($this->qc_stage);
                        $doc->exportField($this->defect_percentage);
                        $doc->exportField($this->deduction);
                        $doc->exportField($this->comments);
                        $doc->exportField($this->status);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->e_operator);
                        $doc->exportField($this->e_datetime);
                        $doc->exportField($this->_action);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->a_operator);
                        $doc->exportField($this->a_datetime);
                        $doc->exportField($this->design);
                        $doc->exportField($this->size);
                        $doc->exportField($this->lines_in_30cm);
                        $doc->exportField($this->size_actual);
                        $doc->exportField($this->weight_actual);
                        $doc->exportField($this->product_image);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;
        $width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
        $height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

        // Set up field name / file name field / file type field
        $fldName = "";
        $fileNameFld = "";
        $fileTypeFld = "";
        if ($fldparm == 'product_image') {
            $fldName = "product_image";
            $fileNameFld = "product_image";
        } else {
            return false; // Incorrect field
        }

        // Set up key values
        $ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
        if (count($ar) == 1) {
            $this->id->CurrentValue = $ar[0];
        } else {
            return false; // Incorrect key
        }

        // Set up filter (WHERE Clause)
        $filter = $this->getRecordFilter();
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $dbtype = GetConnectionType($this->Dbid);
        if ($row = $conn->fetchAssociative($sql)) {
            $val = $row[$fldName];
            if (!EmptyValue($val)) {
                $fld = $this->Fields[$fldName];

                // Binary data
                if ($fld->DataType == DataType::BLOB) {
                    if ($dbtype != "MYSQL") {
                        if (is_resource($val) && get_resource_type($val) == "stream") { // Byte array
                            $val = stream_get_contents($val);
                        }
                    }
                    if ($resize) {
                        ResizeBinary($val, $width, $height, $plugins);
                    }

                    // Write file type
                    if ($fileTypeFld != "" && !EmptyValue($row[$fileTypeFld])) {
                        AddHeader("Content-type", $row[$fileTypeFld]);
                    } else {
                        AddHeader("Content-type", ContentType($val));
                    }

                    // Write file name
                    $downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
                    if ($fileNameFld != "" && !EmptyValue($row[$fileNameFld])) {
                        $fileName = $row[$fileNameFld];
                        $pathinfo = pathinfo($fileName);
                        $ext = strtolower($pathinfo["extension"] ?? "");
                        $isPdf = SameText($ext, "pdf");
                        if ($downloadPdf || !$isPdf) { // Skip header if not download PDF
                            AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
                        }
                    } else {
                        $ext = ContentExtension($val);
                        $isPdf = SameText($ext, ".pdf");
                        if ($isPdf && $downloadPdf) { // Add header if download PDF
                            AddHeader("Content-Disposition", "attachment" . ($DownloadFileName ? "; filename=\"" . $DownloadFileName . "\"" : ""));
                        }
                    }

                    // Write file data
                    if (
                        StartsString("PK", $val) &&
                        ContainsString($val, "[Content_Types].xml") &&
                        ContainsString($val, "_rels") &&
                        ContainsString($val, "docProps")
                    ) { // Fix Office 2007 documents
                        if (!EndsString("\0\0\0", $val)) { // Not ends with 3 or 4 \0
                            $val .= "\0\0\0\0";
                        }
                    }

                    // Clear any debug message
                    if (ob_get_length()) {
                        ob_end_clean();
                    }

                    // Write binary data
                    Write($val);

                // Upload to folder
                } else {
                    if ($fld->UploadMultiple) {
                        $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                    } else {
                        $files = [$val];
                    }
                    $data = [];
                    $ar = [];
                    if ($fld->hasMethod("getUploadPath")) { // Check field level upload path
                        $fld->UploadPath = $fld->getUploadPath();
                    }
                    foreach ($files as $file) {
                        if (!EmptyValue($file)) {
                            if (Config("ENCRYPT_FILE_PATH")) {
                                $ar[$file] = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $this->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                            } else {
                                $ar[$file] = FullUrl($fld->hrefPath() . $file);
                            }
                        }
                    }
                    $data[$fld->Param] = $ar;
                    WriteJson($data);
                }
            }
            return true;
        }
        return false;
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
