<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class QcDelete extends Qc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "QcDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "qcdelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->location->setVisibility();
        $this->qc_stage->setVisibility();
        $this->_barcode->setVisibility();
        $this->lines_in_30cm->setVisibility();
        $this->size_actual->setVisibility();
        $this->weight_actual->setVisibility();
        $this->defect_nature->setVisibility();
        $this->defect_percentage->setVisibility();
        $this->deduction->setVisibility();
        $this->comments->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->e_operator->setVisibility();
        $this->e_datetime->setVisibility();
        $this->_action->setVisibility();
        $this->remarks->setVisibility();
        $this->product_image->setVisibility();
        $this->design->setVisibility();
        $this->size->setVisibility();
        $this->a_operator->setVisibility();
        $this->a_datetime->setVisibility();
        $this->uid->Visible = false;
        $this->bcode_status->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'qc';
        $this->TableName = 'qc';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (qc)
        if (!isset($GLOBALS["qc"]) || $GLOBALS["qc"]::class == PROJECT_NAMESPACE . "qc") {
            $GLOBALS["qc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'qc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->qc_stage);
        $this->setupLookupOptions($this->defect_nature);
        $this->setupLookupOptions($this->defect_percentage);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->e_operator);
        $this->setupLookupOptions($this->a_operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("qclist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("qclist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->qc_stage->setDbValue($row['qc_stage']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->lines_in_30cm->setDbValue($row['lines_in_30cm']);
        $this->size_actual->setDbValue($row['size_actual']);
        $this->weight_actual->setDbValue($row['weight_actual']);
        $this->defect_nature->setDbValue($row['defect_nature']);
        $this->defect_percentage->setDbValue($row['defect_percentage']);
        $this->deduction->setDbValue($row['deduction']);
        $this->comments->setDbValue($row['comments']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_operator->setDbValue($row['e_operator']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->_action->setDbValue($row['action']);
        $this->remarks->setDbValue($row['remarks']);
        $this->product_image->Upload->DbValue = $row['product_image'];
        $this->product_image->setDbValue($this->product_image->Upload->DbValue);
        $this->design->setDbValue($row['design']);
        $this->size->setDbValue($row['size']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->uid->setDbValue($row['uid']);
        $this->bcode_status->setDbValue($row['bcode_status']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['qc_stage'] = $this->qc_stage->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['lines_in_30cm'] = $this->lines_in_30cm->DefaultValue;
        $row['size_actual'] = $this->size_actual->DefaultValue;
        $row['weight_actual'] = $this->weight_actual->DefaultValue;
        $row['defect_nature'] = $this->defect_nature->DefaultValue;
        $row['defect_percentage'] = $this->defect_percentage->DefaultValue;
        $row['deduction'] = $this->deduction->DefaultValue;
        $row['comments'] = $this->comments->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['e_operator'] = $this->e_operator->DefaultValue;
        $row['e_datetime'] = $this->e_datetime->DefaultValue;
        $row['action'] = $this->_action->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['product_image'] = $this->product_image->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['bcode_status'] = $this->bcode_status->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id

        // location

        // qc_stage

        // barcode

        // lines_in_30cm

        // size_actual

        // weight_actual

        // defect_nature

        // defect_percentage

        // deduction
        $this->deduction->CellCssStyle = "white-space: nowrap;";

        // comments

        // status

        // operator

        // datetime

        // e_operator

        // e_datetime

        // action

        // remarks

        // product_image

        // design

        // size

        // a_operator

        // a_datetime

        // uid
        $this->uid->CellCssStyle = "white-space: nowrap;";

        // bcode_status
        $this->bcode_status->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // qc_stage
            $curVal = strval($this->qc_stage->CurrentValue);
            if ($curVal != "") {
                $this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
                if ($this->qc_stage->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->qc_stage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->qc_stage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->qc_stage->getSelectFilter($this); // PHP
                    $sqlWrk = $this->qc_stage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->qc_stage->Lookup->renderViewRow($rswrk[0]);
                        $this->qc_stage->ViewValue = $this->qc_stage->displayValue($arwrk);
                    } else {
                        $this->qc_stage->ViewValue = FormatNumber($this->qc_stage->CurrentValue, $this->qc_stage->formatPattern());
                    }
                }
            } else {
                $this->qc_stage->ViewValue = null;
            }

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // lines_in_30cm
            $this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
            $this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, $this->lines_in_30cm->formatPattern());

            // size_actual
            $this->size_actual->ViewValue = $this->size_actual->CurrentValue;

            // weight_actual
            $this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
            $this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, $this->weight_actual->formatPattern());

            // defect_nature
            $curVal = strval($this->defect_nature->CurrentValue);
            if ($curVal != "") {
                $this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
                if ($this->defect_nature->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->defect_nature->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_nature->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->defect_nature->getSelectFilter($this); // PHP
                    $sqlWrk = $this->defect_nature->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->defect_nature->Lookup->renderViewRow($rswrk[0]);
                        $this->defect_nature->ViewValue = $this->defect_nature->displayValue($arwrk);
                    } else {
                        $this->defect_nature->ViewValue = $this->defect_nature->CurrentValue;
                    }
                }
            } else {
                $this->defect_nature->ViewValue = null;
            }

            // defect_percentage
            $curVal = strval($this->defect_percentage->CurrentValue);
            if ($curVal != "") {
                $this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
                if ($this->defect_percentage->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->defect_percentage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_percentage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->defect_percentage->getSelectFilter($this); // PHP
                    $sqlWrk = $this->defect_percentage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->defect_percentage->Lookup->renderViewRow($rswrk[0]);
                        $this->defect_percentage->ViewValue = $this->defect_percentage->displayValue($arwrk);
                    } else {
                        $this->defect_percentage->ViewValue = FormatNumber($this->defect_percentage->CurrentValue, $this->defect_percentage->formatPattern());
                    }
                }
            } else {
                $this->defect_percentage->ViewValue = null;
            }

            // deduction
            $this->deduction->ViewValue = $this->deduction->CurrentValue;
            $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

            // comments
            $this->comments->ViewValue = $this->comments->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $curVal = strval($this->e_operator->CurrentValue);
            if ($curVal != "") {
                $this->e_operator->ViewValue = $this->e_operator->lookupCacheOption($curVal);
                if ($this->e_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->e_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->e_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->e_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->e_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->e_operator->ViewValue = $this->e_operator->displayValue($arwrk);
                    } else {
                        $this->e_operator->ViewValue = FormatNumber($this->e_operator->CurrentValue, $this->e_operator->formatPattern());
                    }
                }
            } else {
                $this->e_operator->ViewValue = null;
            }

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // action
            $this->_action->ViewValue = $this->_action->CurrentValue;
            $this->_action->ViewValue = FormatNumber($this->_action->ViewValue, $this->_action->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // product_image
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->ImageWidth = 0;
                $this->product_image->ImageHeight = 50;
                $this->product_image->ImageAlt = $this->product_image->alt();
                $this->product_image->ImageCssClass = "ew-image";
                $this->product_image->ViewValue = $this->product_image->Upload->DbValue;
            } else {
                $this->product_image->ViewValue = "";
            }

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = FormatNumber($this->a_operator->CurrentValue, $this->a_operator->formatPattern());
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // location
            $this->location->HrefValue = "";
            $this->location->TooltipValue = "";

            // qc_stage
            $this->qc_stage->HrefValue = "";
            $this->qc_stage->TooltipValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // lines_in_30cm
            $this->lines_in_30cm->HrefValue = "";
            $this->lines_in_30cm->TooltipValue = "";

            // size_actual
            $this->size_actual->HrefValue = "";
            $this->size_actual->TooltipValue = "";

            // weight_actual
            $this->weight_actual->HrefValue = "";
            $this->weight_actual->TooltipValue = "";

            // defect_nature
            $this->defect_nature->HrefValue = "";
            $this->defect_nature->TooltipValue = "";

            // defect_percentage
            $this->defect_percentage->HrefValue = "";
            $this->defect_percentage->TooltipValue = "";

            // deduction
            $this->deduction->HrefValue = "";
            $this->deduction->TooltipValue = "";

            // comments
            $this->comments->HrefValue = "";
            $this->comments->TooltipValue = "";

            // status
            $this->status->HrefValue = "";
            $this->status->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // e_operator
            $this->e_operator->HrefValue = "";
            $this->e_operator->TooltipValue = "";

            // e_datetime
            $this->e_datetime->HrefValue = "";
            $this->e_datetime->TooltipValue = "";

            // action
            $this->_action->HrefValue = "";
            $this->_action->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // product_image
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->HrefValue = GetFileUploadUrl($this->product_image, $this->product_image->htmlDecode($this->product_image->Upload->DbValue)); // Add prefix/suffix
                $this->product_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->product_image->HrefValue = FullUrl($this->product_image->HrefValue, "href");
                }
            } else {
                $this->product_image->HrefValue = "";
            }
            $this->product_image->ExportHrefValue = $this->product_image->UploadPath . $this->product_image->Upload->DbValue;
            $this->product_image->TooltipValue = "";
            if ($this->product_image->UseColorbox) {
                if (EmptyValue($this->product_image->TooltipValue)) {
                    $this->product_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
                }
                $this->product_image->LinkAttrs["data-rel"] = "qc_x" . $this->RowCount . "_product_image";
                $this->product_image->LinkAttrs->appendClass("ew-lightbox");
            }

            // design
            $this->design->HrefValue = "";
            $this->design->TooltipValue = "";

            // size
            $this->size->HrefValue = "";
            $this->size->TooltipValue = "";

            // a_operator
            $this->a_operator->HrefValue = "";
            $this->a_operator->TooltipValue = "";

            // a_datetime
            $this->a_datetime->HrefValue = "";
            $this->a_datetime->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['id'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                if ($conn->isTransactionActive()) {
                    $conn->commit();
                }
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                if ($conn->isTransactionActive()) {
                    $conn->rollback();
                }
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("qclist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_qc_stage":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_defect_nature":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_defect_percentage":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_e_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'qc');		
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
