<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class QcAdd extends Qc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "QcAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "qcadd";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->location->setVisibility();
        $this->qc_stage->setVisibility();
        $this->_barcode->setVisibility();
        $this->lines_in_30cm->setVisibility();
        $this->size_actual->setVisibility();
        $this->weight_actual->setVisibility();
        $this->defect_nature->setVisibility();
        $this->defect_percentage->setVisibility();
        $this->deduction->setVisibility();
        $this->comments->setVisibility();
        $this->status->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->e_operator->Visible = false;
        $this->e_datetime->Visible = false;
        $this->_action->Visible = false;
        $this->remarks->Visible = false;
        $this->product_image->setVisibility();
        $this->design->Visible = false;
        $this->size->Visible = false;
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->uid->Visible = false;
        $this->bcode_status->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'qc';
        $this->TableName = 'qc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (qc)
        if (!isset($GLOBALS["qc"]) || $GLOBALS["qc"]::class == PROJECT_NAMESPACE . "qc") {
            $GLOBALS["qc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'qc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "qcview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->location);
        $this->setupLookupOptions($this->qc_stage);
        $this->setupLookupOptions($this->defect_nature);
        $this->setupLookupOptions($this->defect_percentage);
        $this->setupLookupOptions($this->status);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->e_operator);
        $this->setupLookupOptions($this->a_operator);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("qclist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getAddUrl();
                    if (GetPageName($returnUrl) == "qclist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "qcview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "qclist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "qclist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
        $this->product_image->Upload->Index = $CurrentForm->Index;
        $this->product_image->Upload->uploadFile();
        $this->product_image->CurrentValue = $this->product_image->Upload->FileName;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->location->DefaultValue = $this->location->getDefault(); // PHP
        $this->location->OldValue = $this->location->DefaultValue;
        $this->qc_stage->DefaultValue = $this->qc_stage->getDefault(); // PHP
        $this->qc_stage->OldValue = $this->qc_stage->DefaultValue;
        $this->defect_nature->DefaultValue = $this->defect_nature->getDefault(); // PHP
        $this->defect_nature->OldValue = $this->defect_nature->DefaultValue;
        $this->defect_percentage->DefaultValue = $this->defect_percentage->getDefault(); // PHP
        $this->defect_percentage->OldValue = $this->defect_percentage->DefaultValue;
        $this->deduction->DefaultValue = $this->deduction->getDefault(); // PHP
        $this->deduction->OldValue = $this->deduction->DefaultValue;
        $this->status->DefaultValue = $this->status->getDefault(); // PHP
        $this->status->OldValue = $this->status->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'location' first before field var 'x_location'
        $val = $CurrentForm->hasValue("location") ? $CurrentForm->getValue("location") : $CurrentForm->getValue("x_location");
        if (!$this->location->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->location->Visible = false; // Disable update for API request
            } else {
                $this->location->setFormValue($val);
            }
        }

        // Check field name 'qc_stage' first before field var 'x_qc_stage'
        $val = $CurrentForm->hasValue("qc_stage") ? $CurrentForm->getValue("qc_stage") : $CurrentForm->getValue("x_qc_stage");
        if (!$this->qc_stage->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_stage->Visible = false; // Disable update for API request
            } else {
                $this->qc_stage->setFormValue($val);
            }
        }

        // Check field name 'barcode' first before field var 'x__barcode'
        $val = $CurrentForm->hasValue("barcode") ? $CurrentForm->getValue("barcode") : $CurrentForm->getValue("x__barcode");
        if (!$this->_barcode->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_barcode->Visible = false; // Disable update for API request
            } else {
                $this->_barcode->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'lines_in_30cm' first before field var 'x_lines_in_30cm'
        $val = $CurrentForm->hasValue("lines_in_30cm") ? $CurrentForm->getValue("lines_in_30cm") : $CurrentForm->getValue("x_lines_in_30cm");
        if (!$this->lines_in_30cm->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lines_in_30cm->Visible = false; // Disable update for API request
            } else {
                $this->lines_in_30cm->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'size_actual' first before field var 'x_size_actual'
        $val = $CurrentForm->hasValue("size_actual") ? $CurrentForm->getValue("size_actual") : $CurrentForm->getValue("x_size_actual");
        if (!$this->size_actual->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->size_actual->Visible = false; // Disable update for API request
            } else {
                $this->size_actual->setFormValue($val);
            }
        }

        // Check field name 'weight_actual' first before field var 'x_weight_actual'
        $val = $CurrentForm->hasValue("weight_actual") ? $CurrentForm->getValue("weight_actual") : $CurrentForm->getValue("x_weight_actual");
        if (!$this->weight_actual->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->weight_actual->Visible = false; // Disable update for API request
            } else {
                $this->weight_actual->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'defect_nature' first before field var 'x_defect_nature'
        $val = $CurrentForm->hasValue("defect_nature") ? $CurrentForm->getValue("defect_nature") : $CurrentForm->getValue("x_defect_nature");
        if (!$this->defect_nature->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->defect_nature->Visible = false; // Disable update for API request
            } else {
                $this->defect_nature->setFormValue($val);
            }
        }

        // Check field name 'defect_percentage' first before field var 'x_defect_percentage'
        $val = $CurrentForm->hasValue("defect_percentage") ? $CurrentForm->getValue("defect_percentage") : $CurrentForm->getValue("x_defect_percentage");
        if (!$this->defect_percentage->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->defect_percentage->Visible = false; // Disable update for API request
            } else {
                $this->defect_percentage->setFormValue($val);
            }
        }

        // Check field name 'deduction' first before field var 'x_deduction'
        $val = $CurrentForm->hasValue("deduction") ? $CurrentForm->getValue("deduction") : $CurrentForm->getValue("x_deduction");
        if (!$this->deduction->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->deduction->Visible = false; // Disable update for API request
            } else {
                $this->deduction->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'comments' first before field var 'x_comments'
        $val = $CurrentForm->hasValue("comments") ? $CurrentForm->getValue("comments") : $CurrentForm->getValue("x_comments");
        if (!$this->comments->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->comments->Visible = false; // Disable update for API request
            } else {
                $this->comments->setFormValue($val);
            }
        }

        // Check field name 'status' first before field var 'x_status'
        $val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
        if (!$this->status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->status->Visible = false; // Disable update for API request
            } else {
                $this->status->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        $this->getUploadFiles(); // Get upload files
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->location->CurrentValue = $this->location->FormValue;
        $this->qc_stage->CurrentValue = $this->qc_stage->FormValue;
        $this->_barcode->CurrentValue = $this->_barcode->FormValue;
        $this->lines_in_30cm->CurrentValue = $this->lines_in_30cm->FormValue;
        $this->size_actual->CurrentValue = $this->size_actual->FormValue;
        $this->weight_actual->CurrentValue = $this->weight_actual->FormValue;
        $this->defect_nature->CurrentValue = $this->defect_nature->FormValue;
        $this->defect_percentage->CurrentValue = $this->defect_percentage->FormValue;
        $this->deduction->CurrentValue = $this->deduction->FormValue;
        $this->comments->CurrentValue = $this->comments->FormValue;
        $this->status->CurrentValue = $this->status->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->location->setDbValue($row['location']);
        $this->qc_stage->setDbValue($row['qc_stage']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->lines_in_30cm->setDbValue($row['lines_in_30cm']);
        $this->size_actual->setDbValue($row['size_actual']);
        $this->weight_actual->setDbValue($row['weight_actual']);
        $this->defect_nature->setDbValue($row['defect_nature']);
        $this->defect_percentage->setDbValue($row['defect_percentage']);
        $this->deduction->setDbValue($row['deduction']);
        $this->comments->setDbValue($row['comments']);
        $this->status->setDbValue($row['status']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->e_operator->setDbValue($row['e_operator']);
        $this->e_datetime->setDbValue($row['e_datetime']);
        $this->_action->setDbValue($row['action']);
        $this->remarks->setDbValue($row['remarks']);
        $this->product_image->Upload->DbValue = $row['product_image'];
        $this->product_image->setDbValue($this->product_image->Upload->DbValue);
        $this->design->setDbValue($row['design']);
        $this->size->setDbValue($row['size']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->uid->setDbValue($row['uid']);
        $this->bcode_status->setDbValue($row['bcode_status']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['location'] = $this->location->DefaultValue;
        $row['qc_stage'] = $this->qc_stage->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['lines_in_30cm'] = $this->lines_in_30cm->DefaultValue;
        $row['size_actual'] = $this->size_actual->DefaultValue;
        $row['weight_actual'] = $this->weight_actual->DefaultValue;
        $row['defect_nature'] = $this->defect_nature->DefaultValue;
        $row['defect_percentage'] = $this->defect_percentage->DefaultValue;
        $row['deduction'] = $this->deduction->DefaultValue;
        $row['comments'] = $this->comments->DefaultValue;
        $row['status'] = $this->status->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['e_operator'] = $this->e_operator->DefaultValue;
        $row['e_datetime'] = $this->e_datetime->DefaultValue;
        $row['action'] = $this->_action->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['product_image'] = $this->product_image->DefaultValue;
        $row['design'] = $this->design->DefaultValue;
        $row['size'] = $this->size->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['uid'] = $this->uid->DefaultValue;
        $row['bcode_status'] = $this->bcode_status->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // location
        $this->location->RowCssClass = "row";

        // qc_stage
        $this->qc_stage->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // lines_in_30cm
        $this->lines_in_30cm->RowCssClass = "row";

        // size_actual
        $this->size_actual->RowCssClass = "row";

        // weight_actual
        $this->weight_actual->RowCssClass = "row";

        // defect_nature
        $this->defect_nature->RowCssClass = "row";

        // defect_percentage
        $this->defect_percentage->RowCssClass = "row";

        // deduction
        $this->deduction->RowCssClass = "row";

        // comments
        $this->comments->RowCssClass = "row";

        // status
        $this->status->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // e_operator
        $this->e_operator->RowCssClass = "row";

        // e_datetime
        $this->e_datetime->RowCssClass = "row";

        // action
        $this->_action->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // product_image
        $this->product_image->RowCssClass = "row";

        // design
        $this->design->RowCssClass = "row";

        // size
        $this->size->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // uid
        $this->uid->RowCssClass = "row";

        // bcode_status
        $this->bcode_status->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // location
            $curVal = strval($this->location->CurrentValue);
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
                if ($this->location->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->location->getSelectFilter($this); // PHP
                    $sqlWrk = $this->location->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->location->Lookup->renderViewRow($rswrk[0]);
                        $this->location->ViewValue = $this->location->displayValue($arwrk);
                    } else {
                        $this->location->ViewValue = FormatNumber($this->location->CurrentValue, $this->location->formatPattern());
                    }
                }
            } else {
                $this->location->ViewValue = null;
            }

            // qc_stage
            $curVal = strval($this->qc_stage->CurrentValue);
            if ($curVal != "") {
                $this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
                if ($this->qc_stage->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->qc_stage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->qc_stage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->qc_stage->getSelectFilter($this); // PHP
                    $sqlWrk = $this->qc_stage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->qc_stage->Lookup->renderViewRow($rswrk[0]);
                        $this->qc_stage->ViewValue = $this->qc_stage->displayValue($arwrk);
                    } else {
                        $this->qc_stage->ViewValue = FormatNumber($this->qc_stage->CurrentValue, $this->qc_stage->formatPattern());
                    }
                }
            } else {
                $this->qc_stage->ViewValue = null;
            }

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;
            $this->_barcode->ViewValue = FormatNumber($this->_barcode->ViewValue, $this->_barcode->formatPattern());

            // lines_in_30cm
            $this->lines_in_30cm->ViewValue = $this->lines_in_30cm->CurrentValue;
            $this->lines_in_30cm->ViewValue = FormatNumber($this->lines_in_30cm->ViewValue, $this->lines_in_30cm->formatPattern());

            // size_actual
            $this->size_actual->ViewValue = $this->size_actual->CurrentValue;

            // weight_actual
            $this->weight_actual->ViewValue = $this->weight_actual->CurrentValue;
            $this->weight_actual->ViewValue = FormatNumber($this->weight_actual->ViewValue, $this->weight_actual->formatPattern());

            // defect_nature
            $curVal = strval($this->defect_nature->CurrentValue);
            if ($curVal != "") {
                $this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
                if ($this->defect_nature->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->defect_nature->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_nature->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->defect_nature->getSelectFilter($this); // PHP
                    $sqlWrk = $this->defect_nature->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->defect_nature->Lookup->renderViewRow($rswrk[0]);
                        $this->defect_nature->ViewValue = $this->defect_nature->displayValue($arwrk);
                    } else {
                        $this->defect_nature->ViewValue = $this->defect_nature->CurrentValue;
                    }
                }
            } else {
                $this->defect_nature->ViewValue = null;
            }

            // defect_percentage
            $curVal = strval($this->defect_percentage->CurrentValue);
            if ($curVal != "") {
                $this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
                if ($this->defect_percentage->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->defect_percentage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->defect_percentage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->defect_percentage->getSelectFilter($this); // PHP
                    $sqlWrk = $this->defect_percentage->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->defect_percentage->Lookup->renderViewRow($rswrk[0]);
                        $this->defect_percentage->ViewValue = $this->defect_percentage->displayValue($arwrk);
                    } else {
                        $this->defect_percentage->ViewValue = FormatNumber($this->defect_percentage->CurrentValue, $this->defect_percentage->formatPattern());
                    }
                }
            } else {
                $this->defect_percentage->ViewValue = null;
            }

            // deduction
            $this->deduction->ViewValue = $this->deduction->CurrentValue;
            $this->deduction->ViewValue = FormatNumber($this->deduction->ViewValue, $this->deduction->formatPattern());

            // comments
            $this->comments->ViewValue = $this->comments->CurrentValue;

            // status
            $curVal = strval($this->status->CurrentValue);
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
                if ($this->status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->status->Lookup->renderViewRow($rswrk[0]);
                        $this->status->ViewValue = $this->status->displayValue($arwrk);
                    } else {
                        $this->status->ViewValue = FormatNumber($this->status->CurrentValue, $this->status->formatPattern());
                    }
                }
            } else {
                $this->status->ViewValue = null;
            }

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = FormatNumber($this->operator->CurrentValue, $this->operator->formatPattern());
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // e_operator
            $curVal = strval($this->e_operator->CurrentValue);
            if ($curVal != "") {
                $this->e_operator->ViewValue = $this->e_operator->lookupCacheOption($curVal);
                if ($this->e_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->e_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->e_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->e_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->e_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->e_operator->ViewValue = $this->e_operator->displayValue($arwrk);
                    } else {
                        $this->e_operator->ViewValue = FormatNumber($this->e_operator->CurrentValue, $this->e_operator->formatPattern());
                    }
                }
            } else {
                $this->e_operator->ViewValue = null;
            }

            // e_datetime
            $this->e_datetime->ViewValue = $this->e_datetime->CurrentValue;
            $this->e_datetime->ViewValue = FormatDateTime($this->e_datetime->ViewValue, $this->e_datetime->formatPattern());

            // action
            $this->_action->ViewValue = $this->_action->CurrentValue;
            $this->_action->ViewValue = FormatNumber($this->_action->ViewValue, $this->_action->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // product_image
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->ImageWidth = 0;
                $this->product_image->ImageHeight = 50;
                $this->product_image->ImageAlt = $this->product_image->alt();
                $this->product_image->ImageCssClass = "ew-image";
                $this->product_image->ViewValue = $this->product_image->Upload->DbValue;
            } else {
                $this->product_image->ViewValue = "";
            }

            // design
            $this->design->ViewValue = $this->design->CurrentValue;

            // size
            $this->size->ViewValue = $this->size->CurrentValue;

            // a_operator
            $curVal = strval($this->a_operator->CurrentValue);
            if ($curVal != "") {
                $this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
                if ($this->a_operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->a_operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->a_operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->a_operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->a_operator->Lookup->renderViewRow($rswrk[0]);
                        $this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
                    } else {
                        $this->a_operator->ViewValue = FormatNumber($this->a_operator->CurrentValue, $this->a_operator->formatPattern());
                    }
                }
            } else {
                $this->a_operator->ViewValue = null;
            }

            // a_datetime
            $this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
            $this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, $this->a_datetime->formatPattern());

            // location
            $this->location->HrefValue = "";

            // qc_stage
            $this->qc_stage->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";
            $this->_barcode->TooltipValue = "";

            // lines_in_30cm
            $this->lines_in_30cm->HrefValue = "";

            // size_actual
            $this->size_actual->HrefValue = "";

            // weight_actual
            $this->weight_actual->HrefValue = "";

            // defect_nature
            $this->defect_nature->HrefValue = "";

            // defect_percentage
            $this->defect_percentage->HrefValue = "";

            // deduction
            $this->deduction->HrefValue = "";
            $this->deduction->TooltipValue = "";

            // comments
            $this->comments->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // product_image
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->HrefValue = GetFileUploadUrl($this->product_image, $this->product_image->htmlDecode($this->product_image->Upload->DbValue)); // Add prefix/suffix
                $this->product_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->product_image->HrefValue = FullUrl($this->product_image->HrefValue, "href");
                }
            } else {
                $this->product_image->HrefValue = "";
            }
            $this->product_image->ExportHrefValue = $this->product_image->UploadPath . $this->product_image->Upload->DbValue;
        } elseif ($this->RowType == RowType::ADD) {
            // location
            $this->location->setupEditAttributes();
            $curVal = trim(strval($this->location->CurrentValue));
            if ($curVal != "") {
                $this->location->ViewValue = $this->location->lookupCacheOption($curVal);
            } else {
                $this->location->ViewValue = $this->location->Lookup !== null && is_array($this->location->lookupOptions()) && count($this->location->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->location->ViewValue !== null) { // Load from cache
                $this->location->EditValue = array_values($this->location->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->location->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->location->CurrentValue, $this->location->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->location->getSelectFilter($this); // PHP
                $sqlWrk = $this->location->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->location->EditValue = $arwrk;
            }
            $this->location->PlaceHolder = RemoveHtml($this->location->caption());

            // qc_stage
            $this->qc_stage->setupEditAttributes();
            $curVal = trim(strval($this->qc_stage->CurrentValue));
            if ($curVal != "") {
                $this->qc_stage->ViewValue = $this->qc_stage->lookupCacheOption($curVal);
            } else {
                $this->qc_stage->ViewValue = $this->qc_stage->Lookup !== null && is_array($this->qc_stage->lookupOptions()) && count($this->qc_stage->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->qc_stage->ViewValue !== null) { // Load from cache
                $this->qc_stage->EditValue = array_values($this->qc_stage->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->qc_stage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->qc_stage->CurrentValue, $this->qc_stage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->qc_stage->getSelectFilter($this); // PHP
                $sqlWrk = $this->qc_stage->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->qc_stage->EditValue = $arwrk;
            }
            $this->qc_stage->PlaceHolder = RemoveHtml($this->qc_stage->caption());

            // barcode
            $this->_barcode->setupEditAttributes();
            $this->_barcode->EditValue = $this->_barcode->CurrentValue;
            $this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());
            if (strval($this->_barcode->EditValue) != "" && is_numeric($this->_barcode->EditValue)) {
                $this->_barcode->EditValue = FormatNumber($this->_barcode->EditValue, null);
            }

            // lines_in_30cm
            $this->lines_in_30cm->setupEditAttributes();
            $this->lines_in_30cm->EditValue = $this->lines_in_30cm->CurrentValue;
            $this->lines_in_30cm->PlaceHolder = RemoveHtml($this->lines_in_30cm->caption());
            if (strval($this->lines_in_30cm->EditValue) != "" && is_numeric($this->lines_in_30cm->EditValue)) {
                $this->lines_in_30cm->EditValue = FormatNumber($this->lines_in_30cm->EditValue, null);
            }

            // size_actual
            $this->size_actual->setupEditAttributes();
            if (!$this->size_actual->Raw) {
                $this->size_actual->CurrentValue = HtmlDecode($this->size_actual->CurrentValue);
            }
            $this->size_actual->EditValue = HtmlEncode($this->size_actual->CurrentValue);
            $this->size_actual->PlaceHolder = RemoveHtml($this->size_actual->caption());

            // weight_actual
            $this->weight_actual->setupEditAttributes();
            $this->weight_actual->EditValue = $this->weight_actual->CurrentValue;
            $this->weight_actual->PlaceHolder = RemoveHtml($this->weight_actual->caption());
            if (strval($this->weight_actual->EditValue) != "" && is_numeric($this->weight_actual->EditValue)) {
                $this->weight_actual->EditValue = FormatNumber($this->weight_actual->EditValue, null);
            }

            // defect_nature
            $this->defect_nature->setupEditAttributes();
            $curVal = trim(strval($this->defect_nature->CurrentValue));
            if ($curVal != "") {
                $this->defect_nature->ViewValue = $this->defect_nature->lookupCacheOption($curVal);
            } else {
                $this->defect_nature->ViewValue = $this->defect_nature->Lookup !== null && is_array($this->defect_nature->lookupOptions()) && count($this->defect_nature->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->defect_nature->ViewValue !== null) { // Load from cache
                $this->defect_nature->EditValue = array_values($this->defect_nature->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->defect_nature->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->defect_nature->CurrentValue, $this->defect_nature->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->defect_nature->getSelectFilter($this); // PHP
                $sqlWrk = $this->defect_nature->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->defect_nature->EditValue = $arwrk;
            }
            $this->defect_nature->PlaceHolder = RemoveHtml($this->defect_nature->caption());

            // defect_percentage
            $this->defect_percentage->setupEditAttributes();
            $curVal = trim(strval($this->defect_percentage->CurrentValue));
            if ($curVal != "") {
                $this->defect_percentage->ViewValue = $this->defect_percentage->lookupCacheOption($curVal);
            } else {
                $this->defect_percentage->ViewValue = $this->defect_percentage->Lookup !== null && is_array($this->defect_percentage->lookupOptions()) && count($this->defect_percentage->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->defect_percentage->ViewValue !== null) { // Load from cache
                $this->defect_percentage->EditValue = array_values($this->defect_percentage->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->defect_percentage->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->defect_percentage->CurrentValue, $this->defect_percentage->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->defect_percentage->getSelectFilter($this); // PHP
                $sqlWrk = $this->defect_percentage->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->defect_percentage->EditValue = $arwrk;
            }
            $this->defect_percentage->PlaceHolder = RemoveHtml($this->defect_percentage->caption());

            // deduction
            $this->deduction->setupEditAttributes();
            $this->deduction->EditValue = $this->deduction->CurrentValue;
            $this->deduction->PlaceHolder = RemoveHtml($this->deduction->caption());
            if (strval($this->deduction->EditValue) != "" && is_numeric($this->deduction->EditValue)) {
                $this->deduction->EditValue = FormatNumber($this->deduction->EditValue, null);
            }

            // comments
            $this->comments->setupEditAttributes();
            if (!$this->comments->Raw) {
                $this->comments->CurrentValue = HtmlDecode($this->comments->CurrentValue);
            }
            $this->comments->EditValue = HtmlEncode($this->comments->CurrentValue);
            $this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

            // status
            $this->status->setupEditAttributes();
            $curVal = trim(strval($this->status->CurrentValue));
            if ($curVal != "") {
                $this->status->ViewValue = $this->status->lookupCacheOption($curVal);
            } else {
                $this->status->ViewValue = $this->status->Lookup !== null && is_array($this->status->lookupOptions()) && count($this->status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->status->ViewValue !== null) { // Load from cache
                $this->status->EditValue = array_values($this->status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->status->CurrentValue, $this->status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->status->getSelectFilter($this); // PHP
                $sqlWrk = $this->status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->status->EditValue = $arwrk;
            }
            $this->status->PlaceHolder = RemoveHtml($this->status->caption());

            // operator

            // datetime

            // product_image
            $this->product_image->setupEditAttributes();
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->ImageWidth = 0;
                $this->product_image->ImageHeight = 50;
                $this->product_image->ImageAlt = $this->product_image->alt();
                $this->product_image->ImageCssClass = "ew-image";
                $this->product_image->EditValue = $this->product_image->Upload->DbValue;
            } else {
                $this->product_image->EditValue = "";
            }
            if (!EmptyValue($this->product_image->CurrentValue)) {
                $this->product_image->Upload->FileName = $this->product_image->CurrentValue;
            }
            if (!Config("CREATE_UPLOAD_FILE_ON_COPY")) {
                $this->product_image->Upload->DbValue = null;
            }
            if ($this->isShow() || $this->isCopy()) {
                RenderUploadField($this->product_image);
            }

            // Add refer script

            // location
            $this->location->HrefValue = "";

            // qc_stage
            $this->qc_stage->HrefValue = "";

            // barcode
            $this->_barcode->HrefValue = "";

            // lines_in_30cm
            $this->lines_in_30cm->HrefValue = "";

            // size_actual
            $this->size_actual->HrefValue = "";

            // weight_actual
            $this->weight_actual->HrefValue = "";

            // defect_nature
            $this->defect_nature->HrefValue = "";

            // defect_percentage
            $this->defect_percentage->HrefValue = "";

            // deduction
            $this->deduction->HrefValue = "";

            // comments
            $this->comments->HrefValue = "";

            // status
            $this->status->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // product_image
            if (!EmptyValue($this->product_image->Upload->DbValue)) {
                $this->product_image->HrefValue = GetFileUploadUrl($this->product_image, $this->product_image->htmlDecode($this->product_image->Upload->DbValue)); // Add prefix/suffix
                $this->product_image->LinkAttrs["target"] = ""; // Add target
                if ($this->isExport()) {
                    $this->product_image->HrefValue = FullUrl($this->product_image->HrefValue, "href");
                }
            } else {
                $this->product_image->HrefValue = "";
            }
            $this->product_image->ExportHrefValue = $this->product_image->UploadPath . $this->product_image->Upload->DbValue;
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->location->Visible && $this->location->Required) {
                if (!$this->location->IsDetailKey && EmptyValue($this->location->FormValue)) {
                    $this->location->addErrorMessage(str_replace("%s", $this->location->caption(), $this->location->RequiredErrorMessage));
                }
            }
            if ($this->qc_stage->Visible && $this->qc_stage->Required) {
                if (!$this->qc_stage->IsDetailKey && EmptyValue($this->qc_stage->FormValue)) {
                    $this->qc_stage->addErrorMessage(str_replace("%s", $this->qc_stage->caption(), $this->qc_stage->RequiredErrorMessage));
                }
            }
            if ($this->_barcode->Visible && $this->_barcode->Required) {
                if (!$this->_barcode->IsDetailKey && EmptyValue($this->_barcode->FormValue)) {
                    $this->_barcode->addErrorMessage(str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
                }
            }
            if ($this->lines_in_30cm->Visible && $this->lines_in_30cm->Required) {
                if (!$this->lines_in_30cm->IsDetailKey && EmptyValue($this->lines_in_30cm->FormValue)) {
                    $this->lines_in_30cm->addErrorMessage(str_replace("%s", $this->lines_in_30cm->caption(), $this->lines_in_30cm->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->lines_in_30cm->FormValue)) {
                $this->lines_in_30cm->addErrorMessage($this->lines_in_30cm->getErrorMessage(false));
            }
            if ($this->size_actual->Visible && $this->size_actual->Required) {
                if (!$this->size_actual->IsDetailKey && EmptyValue($this->size_actual->FormValue)) {
                    $this->size_actual->addErrorMessage(str_replace("%s", $this->size_actual->caption(), $this->size_actual->RequiredErrorMessage));
                }
            }
            if ($this->weight_actual->Visible && $this->weight_actual->Required) {
                if (!$this->weight_actual->IsDetailKey && EmptyValue($this->weight_actual->FormValue)) {
                    $this->weight_actual->addErrorMessage(str_replace("%s", $this->weight_actual->caption(), $this->weight_actual->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->weight_actual->FormValue)) {
                $this->weight_actual->addErrorMessage($this->weight_actual->getErrorMessage(false));
            }
            if ($this->defect_nature->Visible && $this->defect_nature->Required) {
                if (!$this->defect_nature->IsDetailKey && EmptyValue($this->defect_nature->FormValue)) {
                    $this->defect_nature->addErrorMessage(str_replace("%s", $this->defect_nature->caption(), $this->defect_nature->RequiredErrorMessage));
                }
            }
            if ($this->defect_percentage->Visible && $this->defect_percentage->Required) {
                if (!$this->defect_percentage->IsDetailKey && EmptyValue($this->defect_percentage->FormValue)) {
                    $this->defect_percentage->addErrorMessage(str_replace("%s", $this->defect_percentage->caption(), $this->defect_percentage->RequiredErrorMessage));
                }
            }
            if ($this->deduction->Visible && $this->deduction->Required) {
                if (!$this->deduction->IsDetailKey && EmptyValue($this->deduction->FormValue)) {
                    $this->deduction->addErrorMessage(str_replace("%s", $this->deduction->caption(), $this->deduction->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->deduction->FormValue)) {
                $this->deduction->addErrorMessage($this->deduction->getErrorMessage(false));
            }
            if ($this->comments->Visible && $this->comments->Required) {
                if (!$this->comments->IsDetailKey && EmptyValue($this->comments->FormValue)) {
                    $this->comments->addErrorMessage(str_replace("%s", $this->comments->caption(), $this->comments->RequiredErrorMessage));
                }
            }
            if ($this->status->Visible && $this->status->Required) {
                if (!$this->status->IsDetailKey && EmptyValue($this->status->FormValue)) {
                    $this->status->addErrorMessage(str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->product_image->Visible && $this->product_image->Required) {
                if ($this->product_image->Upload->FileName == "" && !$this->product_image->Upload->KeepFile) {
                    $this->product_image->addErrorMessage(str_replace("%s", $this->product_image->caption(), $this->product_image->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();
        if ($this->product_image->Visible && !$this->product_image->Upload->KeepFile) {
            if (!EmptyValue($this->product_image->Upload->FileName)) {
                $this->product_image->Upload->DbValue = null;
                FixUploadFileNames($this->product_image);
                $this->product_image->setDbValueDef($rsnew, $this->product_image->Upload->FileName, false);
            }
        }

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
                if ($this->product_image->Visible && !$this->product_image->Upload->KeepFile) {
                    $this->product_image->Upload->DbValue = null;
                    if (!SaveUploadFiles($this->product_image, $rsnew['product_image'], true)) {
                        $this->setFailureMessage($Language->phrase("UploadError7"));
                        return false;
                    }
                }
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // location
        $this->location->setDbValueDef($rsnew, $this->location->CurrentValue, false);

        // qc_stage
        $this->qc_stage->setDbValueDef($rsnew, $this->qc_stage->CurrentValue, false);

        // barcode
        $this->_barcode->setDbValueDef($rsnew, $this->_barcode->CurrentValue, false);

        // lines_in_30cm
        $this->lines_in_30cm->setDbValueDef($rsnew, $this->lines_in_30cm->CurrentValue, false);

        // size_actual
        $this->size_actual->setDbValueDef($rsnew, $this->size_actual->CurrentValue, false);

        // weight_actual
        $this->weight_actual->setDbValueDef($rsnew, $this->weight_actual->CurrentValue, false);

        // defect_nature
        $this->defect_nature->setDbValueDef($rsnew, $this->defect_nature->CurrentValue, false);

        // defect_percentage
        $this->defect_percentage->setDbValueDef($rsnew, $this->defect_percentage->CurrentValue, strval($this->defect_percentage->CurrentValue) == "");

        // deduction
        $this->deduction->setDbValueDef($rsnew, $this->deduction->CurrentValue, strval($this->deduction->CurrentValue) == "");

        // comments
        $this->comments->setDbValueDef($rsnew, $this->comments->CurrentValue, false);

        // status
        $this->status->setDbValueDef($rsnew, $this->status->CurrentValue, strval($this->status->CurrentValue) == "");

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // product_image
        if ($this->product_image->Visible && !$this->product_image->Upload->KeepFile) {
            if ($this->product_image->Upload->FileName == "") {
                $rsnew['product_image'] = null;
            } else {
                FixUploadTempFileNames($this->product_image);
                $rsnew['product_image'] = $this->product_image->Upload->FileName;
            }
            $this->product_image->ImageWidth = 640; // Resize width
            $this->product_image->ImageHeight = 640; // Resize height
        }
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['location'])) { // location
            $this->location->setFormValue($row['location']);
        }
        if (isset($row['qc_stage'])) { // qc_stage
            $this->qc_stage->setFormValue($row['qc_stage']);
        }
        if (isset($row['barcode'])) { // barcode
            $this->_barcode->setFormValue($row['barcode']);
        }
        if (isset($row['lines_in_30cm'])) { // lines_in_30cm
            $this->lines_in_30cm->setFormValue($row['lines_in_30cm']);
        }
        if (isset($row['size_actual'])) { // size_actual
            $this->size_actual->setFormValue($row['size_actual']);
        }
        if (isset($row['weight_actual'])) { // weight_actual
            $this->weight_actual->setFormValue($row['weight_actual']);
        }
        if (isset($row['defect_nature'])) { // defect_nature
            $this->defect_nature->setFormValue($row['defect_nature']);
        }
        if (isset($row['defect_percentage'])) { // defect_percentage
            $this->defect_percentage->setFormValue($row['defect_percentage']);
        }
        if (isset($row['deduction'])) { // deduction
            $this->deduction->setFormValue($row['deduction']);
        }
        if (isset($row['comments'])) { // comments
            $this->comments->setFormValue($row['comments']);
        }
        if (isset($row['status'])) { // status
            $this->status->setFormValue($row['status']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['product_image'])) { // product_image
            $this->product_image->setFormValue($row['product_image']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("qclist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_location":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_qc_stage":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_defect_nature":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_defect_percentage":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                case "x_e_operator":
                    break;
                case "x_a_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'qc');	
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
