<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PurchaseLQcEdit extends PurchaseLQc
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PurchaseLQcEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "purchaselqcedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->type->setVisibility();
        $this->po->setVisibility();
        $this->rid->setVisibility();
        $this->lot_no->setVisibility();
        $this->net_weight->setVisibility();
        $this->qc_status->setVisibility();
        $this->qc_remarks->setVisibility();
        $this->packets->setVisibility();
        $this->packing_type->setVisibility();
        $this->_40->setVisibility();
        $this->amount->setVisibility();
        $this->godown->setVisibility();
        $this->company_id->setVisibility();
        $this->rack->setVisibility();
        $this->dated->setVisibility();
        $this->goods_inward->setVisibility();
        $this->invoice_details->setVisibility();
        $this->invoice_dated->Visible = false;
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->remarks->setVisibility();
        $this->audit->Visible = false;
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->qc_operator->setVisibility();
        $this->qc_datetime->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'purchase_l_qc';
        $this->TableName = 'purchase_l_qc';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (purchase_l_qc)
        if (!isset($GLOBALS["purchase_l_qc"]) || $GLOBALS["purchase_l_qc"]::class == PROJECT_NAMESPACE . "purchase_l_qc") {
            $GLOBALS["purchase_l_qc"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_l_qc');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "purchaselqcview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->type->Required = false;
        $this->rid->Required = false;
        $this->lot_no->Required = false;
        $this->net_weight->Required = false;
        $this->packets->Required = false;
        $this->packing_type->Required = false;
        $this->amount->Required = false;
        $this->godown->Required = false;
        $this->company_id->Required = false;
        $this->dated->Required = false;
        $this->invoice_details->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->po);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->lot_no);
        $this->setupLookupOptions($this->qc_status);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("purchaselqclist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "purchaselqclist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "purchaselqclist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "purchaselqclist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'net_weight' first before field var 'x_net_weight'
        $val = $CurrentForm->hasValue("net_weight") ? $CurrentForm->getValue("net_weight") : $CurrentForm->getValue("x_net_weight");
        if (!$this->net_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->net_weight->Visible = false; // Disable update for API request
            } else {
                $this->net_weight->setFormValue($val);
            }
        }

        // Check field name 'qc_status' first before field var 'x_qc_status'
        $val = $CurrentForm->hasValue("qc_status") ? $CurrentForm->getValue("qc_status") : $CurrentForm->getValue("x_qc_status");
        if (!$this->qc_status->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_status->Visible = false; // Disable update for API request
            } else {
                $this->qc_status->setFormValue($val);
            }
        }

        // Check field name 'qc_remarks' first before field var 'x_qc_remarks'
        $val = $CurrentForm->hasValue("qc_remarks") ? $CurrentForm->getValue("qc_remarks") : $CurrentForm->getValue("x_qc_remarks");
        if (!$this->qc_remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_remarks->Visible = false; // Disable update for API request
            } else {
                $this->qc_remarks->setFormValue($val);
            }
        }

        // Check field name 'packets' first before field var 'x_packets'
        $val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
        if (!$this->packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets->Visible = false; // Disable update for API request
            } else {
                $this->packets->setFormValue($val);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name '@' first before field var 'x__40'
        $val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
        if (!$this->_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_40->Visible = false; // Disable update for API request
            } else {
                $this->_40->setFormValue($val);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'rack' first before field var 'x_rack'
        $val = $CurrentForm->hasValue("rack") ? $CurrentForm->getValue("rack") : $CurrentForm->getValue("x_rack");
        if (!$this->rack->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rack->Visible = false; // Disable update for API request
            } else {
                $this->rack->setFormValue($val);
            }
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'goods_inward' first before field var 'x_goods_inward'
        $val = $CurrentForm->hasValue("goods_inward") ? $CurrentForm->getValue("goods_inward") : $CurrentForm->getValue("x_goods_inward");
        if (!$this->goods_inward->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->goods_inward->Visible = false; // Disable update for API request
            } else {
                $this->goods_inward->setFormValue($val);
            }
        }

        // Check field name 'invoice_details' first before field var 'x_invoice_details'
        $val = $CurrentForm->hasValue("invoice_details") ? $CurrentForm->getValue("invoice_details") : $CurrentForm->getValue("x_invoice_details");
        if (!$this->invoice_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_details->Visible = false; // Disable update for API request
            } else {
                $this->invoice_details->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'qc_operator' first before field var 'x_qc_operator'
        $val = $CurrentForm->hasValue("qc_operator") ? $CurrentForm->getValue("qc_operator") : $CurrentForm->getValue("x_qc_operator");
        if (!$this->qc_operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_operator->Visible = false; // Disable update for API request
            } else {
                $this->qc_operator->setFormValue($val);
            }
        }

        // Check field name 'qc_datetime' first before field var 'x_qc_datetime'
        $val = $CurrentForm->hasValue("qc_datetime") ? $CurrentForm->getValue("qc_datetime") : $CurrentForm->getValue("x_qc_datetime");
        if (!$this->qc_datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->qc_datetime->Visible = false; // Disable update for API request
            } else {
                $this->qc_datetime->setFormValue($val);
            }
            $this->qc_datetime->CurrentValue = UnFormatDateTime($this->qc_datetime->CurrentValue, $this->qc_datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->net_weight->CurrentValue = $this->net_weight->FormValue;
        $this->qc_status->CurrentValue = $this->qc_status->FormValue;
        $this->qc_remarks->CurrentValue = $this->qc_remarks->FormValue;
        $this->packets->CurrentValue = $this->packets->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->_40->CurrentValue = $this->_40->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->rack->CurrentValue = $this->rack->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->goods_inward->CurrentValue = $this->goods_inward->FormValue;
        $this->invoice_details->CurrentValue = $this->invoice_details->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->qc_operator->CurrentValue = $this->qc_operator->FormValue;
        $this->qc_datetime->CurrentValue = $this->qc_datetime->FormValue;
        $this->qc_datetime->CurrentValue = UnFormatDateTime($this->qc_datetime->CurrentValue, $this->qc_datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->po->setDbValue($row['po']);
        $this->rid->setDbValue($row['rid']);
        $this->lot_no->setDbValue($row['lot_no']);
        if (array_key_exists('EV__lot_no', $row)) {
            $this->lot_no->VirtualValue = $row['EV__lot_no']; // Set up virtual field value
        } else {
            $this->lot_no->VirtualValue = ""; // Clear value
        }
        $this->net_weight->setDbValue($row['net_weight']);
        $this->qc_status->setDbValue($row['qc_status']);
        $this->qc_remarks->setDbValue($row['qc_remarks']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->_40->setDbValue($row['@']);
        $this->amount->setDbValue($row['amount']);
        $this->godown->setDbValue($row['godown']);
        $this->company_id->setDbValue($row['company_id']);
        $this->rack->setDbValue($row['rack']);
        $this->dated->setDbValue($row['dated']);
        $this->goods_inward->setDbValue($row['goods_inward']);
        $this->invoice_details->setDbValue($row['invoice_details']);
        $this->invoice_dated->setDbValue($row['invoice_dated']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->remarks->setDbValue($row['remarks']);
        $this->audit->setDbValue($row['audit']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->qc_operator->setDbValue($row['qc_operator']);
        $this->qc_datetime->setDbValue($row['qc_datetime']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['net_weight'] = $this->net_weight->DefaultValue;
        $row['qc_status'] = $this->qc_status->DefaultValue;
        $row['qc_remarks'] = $this->qc_remarks->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['@'] = $this->_40->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['rack'] = $this->rack->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['goods_inward'] = $this->goods_inward->DefaultValue;
        $row['invoice_details'] = $this->invoice_details->DefaultValue;
        $row['invoice_dated'] = $this->invoice_dated->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['audit'] = $this->audit->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['qc_operator'] = $this->qc_operator->DefaultValue;
        $row['qc_datetime'] = $this->qc_datetime->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // net_weight
        $this->net_weight->RowCssClass = "row";

        // qc_status
        $this->qc_status->RowCssClass = "row";

        // qc_remarks
        $this->qc_remarks->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // rack
        $this->rack->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // goods_inward
        $this->goods_inward->RowCssClass = "row";

        // invoice_details
        $this->invoice_details->RowCssClass = "row";

        // invoice_dated
        $this->invoice_dated->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // audit
        $this->audit->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // qc_operator
        $this->qc_operator->RowCssClass = "row";

        // qc_datetime
        $this->qc_datetime->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // type
            $curVal = strval($this->type->CurrentValue);
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
                if ($this->type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                        $this->type->ViewValue = $this->type->displayValue($arwrk);
                    } else {
                        $this->type->ViewValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                    }
                }
            } else {
                $this->type->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["cart_id"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["cart_id"]->searchDataType(), "");
                    $lookupFilter = $this->po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                        $this->po->ViewValue = $this->po->displayValue($arwrk);
                    } else {
                        $this->po->ViewValue = $this->po->CurrentValue;
                    }
                }
            } else {
                $this->po->ViewValue = null;
            }

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // lot_no
            if ($this->lot_no->VirtualValue != "") {
                $this->lot_no->ViewValue = $this->lot_no->VirtualValue;
            } else {
                $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                $curVal = strval($this->lot_no->CurrentValue);
                if ($curVal != "") {
                    $this->lot_no->ViewValue = $this->lot_no->lookupCacheOption($curVal);
                    if ($this->lot_no->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchExpression(), "=", $curVal, $this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchDataType(), "");
                        $sqlWrk = $this->lot_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->lot_no->Lookup->renderViewRow($rswrk[0]);
                            $this->lot_no->ViewValue = $this->lot_no->displayValue($arwrk);
                        } else {
                            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
                        }
                    }
                } else {
                    $this->lot_no->ViewValue = null;
                }
            }

            // net_weight
            $this->net_weight->ViewValue = $this->net_weight->CurrentValue;
            $this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, $this->net_weight->formatPattern());

            // qc_status
            $curVal = strval($this->qc_status->CurrentValue);
            if ($curVal != "") {
                $this->qc_status->ViewValue = $this->qc_status->lookupCacheOption($curVal);
                if ($this->qc_status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->qc_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->qc_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->qc_status->getSelectFilter($this); // PHP
                    $sqlWrk = $this->qc_status->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->qc_status->Lookup->renderViewRow($rswrk[0]);
                        $this->qc_status->ViewValue = $this->qc_status->displayValue($arwrk);
                    } else {
                        $this->qc_status->ViewValue = FormatNumber($this->qc_status->CurrentValue, $this->qc_status->formatPattern());
                    }
                }
            } else {
                $this->qc_status->ViewValue = null;
            }

            // qc_remarks
            $this->qc_remarks->ViewValue = $this->qc_remarks->CurrentValue;

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // rack
            $this->rack->ViewValue = $this->rack->CurrentValue;

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // goods_inward
            $this->goods_inward->ViewValue = $this->goods_inward->CurrentValue;

            // invoice_details
            $this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // qc_operator
            $this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
            $this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, $this->qc_operator->formatPattern());

            // qc_datetime
            $this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
            $this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, $this->qc_datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";
            $this->net_weight->TooltipValue = "";

            // qc_status
            $this->qc_status->HrefValue = "";

            // qc_remarks
            $this->qc_remarks->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }
            $this->packing_type->TooltipValue = "";

            // @
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }
            $this->godown->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // rack
            $this->rack->HrefValue = "";
            $this->rack->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // goods_inward
            $this->goods_inward->HrefValue = "";
            $this->goods_inward->TooltipValue = "";

            // invoice_details
            if (!EmptyValue($this->invoice_details->CurrentValue)) {
                $this->invoice_details->HrefValue = $this->invoice_details->getLinkPrefix() . $this->invoice_details->CurrentValue; // Add prefix/suffix
                $this->invoice_details->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->invoice_details->HrefValue = FullUrl($this->invoice_details->HrefValue, "href");
                }
            } else {
                $this->invoice_details->HrefValue = "";
            }
            $this->invoice_details->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // qc_operator
            $this->qc_operator->HrefValue = "";

            // qc_datetime
            $this->qc_datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // type
            $this->type->setupEditAttributes();
            $curVal = strval($this->type->CurrentValue);
            if ($curVal != "") {
                $this->type->EditValue = $this->type->lookupCacheOption($curVal);
                if ($this->type->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                        $this->type->EditValue = $this->type->displayValue($arwrk);
                    } else {
                        $this->type->EditValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                    }
                }
            } else {
                $this->type->EditValue = null;
            }

            // po
            $this->po->setupEditAttributes();
            $this->po->EditValue = $this->po->CurrentValue;
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->EditValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["cart_id"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["cart_id"]->searchDataType(), "");
                    $lookupFilter = $this->po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                        $this->po->EditValue = $this->po->displayValue($arwrk);
                    } else {
                        $this->po->EditValue = $this->po->CurrentValue;
                    }
                }
            } else {
                $this->po->EditValue = null;
            }

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }

            // lot_no
            $this->lot_no->setupEditAttributes();
            if ($this->lot_no->VirtualValue != "") {
                $this->lot_no->EditValue = $this->lot_no->VirtualValue;
            } else {
                $this->lot_no->EditValue = $this->lot_no->CurrentValue;
                $curVal = strval($this->lot_no->CurrentValue);
                if ($curVal != "") {
                    $this->lot_no->EditValue = $this->lot_no->lookupCacheOption($curVal);
                    if ($this->lot_no->EditValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchExpression(), "=", $curVal, $this->lot_no->Lookup->getTable()->Fields["lot_no"]->searchDataType(), "");
                        $sqlWrk = $this->lot_no->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->lot_no->Lookup->renderViewRow($rswrk[0]);
                            $this->lot_no->EditValue = $this->lot_no->displayValue($arwrk);
                        } else {
                            $this->lot_no->EditValue = $this->lot_no->CurrentValue;
                        }
                    }
                } else {
                    $this->lot_no->EditValue = null;
                }
            }

            // net_weight
            $this->net_weight->setupEditAttributes();
            $this->net_weight->EditValue = $this->net_weight->CurrentValue;
            $this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, $this->net_weight->formatPattern());

            // qc_status
            $this->qc_status->setupEditAttributes();
            $curVal = trim(strval($this->qc_status->CurrentValue));
            if ($curVal != "") {
                $this->qc_status->ViewValue = $this->qc_status->lookupCacheOption($curVal);
            } else {
                $this->qc_status->ViewValue = $this->qc_status->Lookup !== null && is_array($this->qc_status->lookupOptions()) && count($this->qc_status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->qc_status->ViewValue !== null) { // Load from cache
                $this->qc_status->EditValue = array_values($this->qc_status->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->qc_status->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->qc_status->CurrentValue, $this->qc_status->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->qc_status->getSelectFilter($this); // PHP
                $sqlWrk = $this->qc_status->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->qc_status->EditValue = $arwrk;
            }
            $this->qc_status->PlaceHolder = RemoveHtml($this->qc_status->caption());

            // qc_remarks
            $this->qc_remarks->setupEditAttributes();
            $this->qc_remarks->EditValue = HtmlEncode($this->qc_remarks->CurrentValue);
            $this->qc_remarks->PlaceHolder = RemoveHtml($this->qc_remarks->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, $this->packets->formatPattern());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->EditValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->EditValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->EditValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->EditValue = null;
            }

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->CurrentValue;
            $this->_40->EditValue = FormatNumber($this->_40->EditValue, $this->_40->formatPattern());

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->EditValue = FormatNumber($this->amount->EditValue, $this->amount->formatPattern());

            // godown
            $this->godown->setupEditAttributes();
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->EditValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->EditValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->EditValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->EditValue = null;
            }

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->EditValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->EditValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->EditValue = null;
            }

            // rack
            $this->rack->setupEditAttributes();
            $this->rack->EditValue = $this->rack->CurrentValue;

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = $this->dated->CurrentValue;
            $this->dated->EditValue = FormatDateTime($this->dated->EditValue, $this->dated->formatPattern());

            // goods_inward
            $this->goods_inward->setupEditAttributes();
            $this->goods_inward->EditValue = $this->goods_inward->CurrentValue;

            // invoice_details
            $this->invoice_details->setupEditAttributes();
            $this->invoice_details->EditValue = $this->invoice_details->CurrentValue;

            // operator
            $this->operator->setupEditAttributes();
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->EditValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->EditValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->EditValue = null;
            }

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = $this->datetime->CurrentValue;
            $this->datetime->EditValue = FormatDateTime($this->datetime->EditValue, $this->datetime->formatPattern());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = $this->remarks->CurrentValue;

            // qc_operator

            // qc_datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // po
            $this->po->HrefValue = "";
            $this->po->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";
            $this->net_weight->TooltipValue = "";

            // qc_status
            $this->qc_status->HrefValue = "";

            // qc_remarks
            $this->qc_remarks->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }
            $this->packing_type->TooltipValue = "";

            // @
            $this->_40->HrefValue = "";
            $this->_40->TooltipValue = "";

            // amount
            $this->amount->HrefValue = "";
            $this->amount->TooltipValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }
            $this->godown->TooltipValue = "";

            // company_id
            $this->company_id->HrefValue = "";
            $this->company_id->TooltipValue = "";

            // rack
            $this->rack->HrefValue = "";
            $this->rack->TooltipValue = "";

            // dated
            $this->dated->HrefValue = "";
            $this->dated->TooltipValue = "";

            // goods_inward
            $this->goods_inward->HrefValue = "";
            $this->goods_inward->TooltipValue = "";

            // invoice_details
            if (!EmptyValue($this->invoice_details->CurrentValue)) {
                $this->invoice_details->HrefValue = $this->invoice_details->getLinkPrefix() . $this->invoice_details->CurrentValue; // Add prefix/suffix
                $this->invoice_details->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->invoice_details->HrefValue = FullUrl($this->invoice_details->HrefValue, "href");
                }
            } else {
                $this->invoice_details->HrefValue = "";
            }
            $this->invoice_details->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // qc_operator
            $this->qc_operator->HrefValue = "";

            // qc_datetime
            $this->qc_datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->net_weight->Visible && $this->net_weight->Required) {
                if (!$this->net_weight->IsDetailKey && EmptyValue($this->net_weight->FormValue)) {
                    $this->net_weight->addErrorMessage(str_replace("%s", $this->net_weight->caption(), $this->net_weight->RequiredErrorMessage));
                }
            }
            if ($this->qc_status->Visible && $this->qc_status->Required) {
                if (!$this->qc_status->IsDetailKey && EmptyValue($this->qc_status->FormValue)) {
                    $this->qc_status->addErrorMessage(str_replace("%s", $this->qc_status->caption(), $this->qc_status->RequiredErrorMessage));
                }
            }
            if ($this->qc_remarks->Visible && $this->qc_remarks->Required) {
                if (!$this->qc_remarks->IsDetailKey && EmptyValue($this->qc_remarks->FormValue)) {
                    $this->qc_remarks->addErrorMessage(str_replace("%s", $this->qc_remarks->caption(), $this->qc_remarks->RequiredErrorMessage));
                }
            }
            if ($this->packets->Visible && $this->packets->Required) {
                if (!$this->packets->IsDetailKey && EmptyValue($this->packets->FormValue)) {
                    $this->packets->addErrorMessage(str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
                }
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->_40->Visible && $this->_40->Required) {
                if (!$this->_40->IsDetailKey && EmptyValue($this->_40->FormValue)) {
                    $this->_40->addErrorMessage(str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
                }
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if (!$this->godown->IsDetailKey && EmptyValue($this->godown->FormValue)) {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->rack->Visible && $this->rack->Required) {
                if (!$this->rack->IsDetailKey && EmptyValue($this->rack->FormValue)) {
                    $this->rack->addErrorMessage(str_replace("%s", $this->rack->caption(), $this->rack->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if ($this->goods_inward->Visible && $this->goods_inward->Required) {
                if (!$this->goods_inward->IsDetailKey && EmptyValue($this->goods_inward->FormValue)) {
                    $this->goods_inward->addErrorMessage(str_replace("%s", $this->goods_inward->caption(), $this->goods_inward->RequiredErrorMessage));
                }
            }
            if ($this->invoice_details->Visible && $this->invoice_details->Required) {
                if (!$this->invoice_details->IsDetailKey && EmptyValue($this->invoice_details->FormValue)) {
                    $this->invoice_details->addErrorMessage(str_replace("%s", $this->invoice_details->caption(), $this->invoice_details->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->qc_operator->Visible && $this->qc_operator->Required) {
                if (!$this->qc_operator->IsDetailKey && EmptyValue($this->qc_operator->FormValue)) {
                    $this->qc_operator->addErrorMessage(str_replace("%s", $this->qc_operator->caption(), $this->qc_operator->RequiredErrorMessage));
                }
            }
            if ($this->qc_datetime->Visible && $this->qc_datetime->Required) {
                if (!$this->qc_datetime->IsDetailKey && EmptyValue($this->qc_datetime->FormValue)) {
                    $this->qc_datetime->addErrorMessage(str_replace("%s", $this->qc_datetime->caption(), $this->qc_datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // qc_status
        $this->qc_status->setDbValueDef($rsnew, $this->qc_status->CurrentValue, $this->qc_status->ReadOnly);

        // qc_remarks
        $this->qc_remarks->setDbValueDef($rsnew, $this->qc_remarks->CurrentValue, $this->qc_remarks->ReadOnly);

        // qc_operator
        $this->qc_operator->CurrentValue = $this->qc_operator->getAutoUpdateValue(); // PHP
        $this->qc_operator->setDbValueDef($rsnew, $this->qc_operator->CurrentValue, $this->qc_operator->ReadOnly);

        // qc_datetime
        $this->qc_datetime->CurrentValue = $this->qc_datetime->getAutoUpdateValue(); // PHP
        $this->qc_datetime->setDbValueDef($rsnew, UnFormatDateTime($this->qc_datetime->CurrentValue, $this->qc_datetime->formatPattern()), $this->qc_datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['qc_status'])) { // qc_status
            $this->qc_status->CurrentValue = $row['qc_status'];
        }
        if (isset($row['qc_remarks'])) { // qc_remarks
            $this->qc_remarks->CurrentValue = $row['qc_remarks'];
        }
        if (isset($row['qc_operator'])) { // qc_operator
            $this->qc_operator->CurrentValue = $row['qc_operator'];
        }
        if (isset($row['qc_datetime'])) { // qc_datetime
            $this->qc_datetime->CurrentValue = $row['qc_datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchaselqclist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lot_no":
                    break;
                case "x_qc_status":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
