<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PurchaseLAdd extends PurchaseL
{
    use MessagesTrait;

    // Page ID
    public $PageID = "add";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PurchaseLAdd";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "purchaseladd";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->Visible = false;
        $this->type->setVisibility();
        $this->supplier->setVisibility();
        $this->po->setVisibility();
        $this->po_return->setVisibility();
        $this->company_id->setVisibility();
        $this->grp->Visible = false;
        $this->s_grp->Visible = false;
        $this->product->Visible = false;
        $this->rid_return->setVisibility();
        $this->rid->setVisibility();
        $this->packing_type->setVisibility();
        $this->lot_no->setVisibility();
        $this->avg_quantity->Visible = false;
        $this->packets->setVisibility();
        $this->net_weight->setVisibility();
        $this->_40->setVisibility();
        $this->amount->setVisibility();
        $this->godown->setVisibility();
        $this->dated->setVisibility();
        $this->operator->setVisibility();
        $this->rack->setVisibility();
        $this->updated->Visible = false;
        $this->datetime->setVisibility();
        $this->remarks->setVisibility();
        $this->goods_inward->setVisibility();
        $this->invoice_details->setVisibility();
        $this->invoice_dated->setVisibility();
        $this->_barcode->Visible = false;
        $this->country->Visible = false;
        $this->wool_type->Visible = false;
        $this->quality->Visible = false;
        $this->sorting_type->Visible = false;
        $this->scouring_type->Visible = false;
        $this->dye_type->Visible = false;
        $this->importer->Visible = false;
        $this->grade->Visible = false;
        $this->return_details->setVisibility();
        $this->audit->Visible = false;
        $this->a_operator->Visible = false;
        $this->a_datetime->Visible = false;
        $this->agent->Visible = false;
        $this->qc_remarks->Visible = false;
        $this->qc_status->Visible = false;
        $this->qc_operator->Visible = false;
        $this->qc_datetime->Visible = false;
        $this->age->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'purchase_l';
        $this->TableName = 'purchase_l';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-add-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (purchase_l)
        if (!isset($GLOBALS["purchase_l"]) || $GLOBALS["purchase_l"]::class == PROJECT_NAMESPACE . "purchase_l") {
            $GLOBALS["purchase_l"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_l');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "purchaselview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-add-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $Priv = 0;
    public $CopyRecord;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->type);
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->po);
        $this->setupLookupOptions($this->po_return);
        $this->setupLookupOptions($this->company_id);
        $this->setupLookupOptions($this->grp);
        $this->setupLookupOptions($this->s_grp);
        $this->setupLookupOptions($this->product);
        $this->setupLookupOptions($this->rid_return);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->operator);
        $this->setupLookupOptions($this->importer);
        $this->setupLookupOptions($this->agent);

        // Load default values for add
        $this->loadDefaultValues();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $postBack = false;

        // Set up current action
        if (IsApi()) {
            $this->CurrentAction = "insert"; // Add record directly
            $postBack = true;
        } elseif (Post("action", "") !== "") {
            $this->CurrentAction = Post("action"); // Get form action
            $this->setKey(Post($this->OldKeyName));
            $postBack = true;
        } else {
            // Load key values from QueryString
            if (($keyValue = Get("id") ?? Route("id")) !== null) {
                $this->id->setQueryStringValue($keyValue);
            }
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $this->CopyRecord = !EmptyValue($this->OldKey);
            if ($this->CopyRecord) {
                $this->CurrentAction = "copy"; // Copy record
                $this->setKey($this->OldKey); // Set up record key
            } else {
                $this->CurrentAction = "show"; // Display blank record
            }
        }

        // Load old record or default values
        $rsold = $this->loadOldRecord();

        // Load form values
        if ($postBack) {
            $this->loadFormValues(); // Load form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues(); // Restore form values
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = "show"; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "copy": // Copy an existing record
                if (!$rsold) { // Record not loaded
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                    }
                    $this->terminate("purchasellist"); // No matching record, return to list
                    return;
                }
                break;
            case "insert": // Add new record
                $this->SendEmail = true; // Send email on add success
                if ($this->addRow($rsold)) { // Add successful
                    if ($this->getSuccessMessage() == "" && Post("addopt") != "1") { // Skip success message for addopt (done in JavaScript)
                        $this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
                    }
                    $returnUrl = $this->getReturnUrl();
                    if (GetPageName($returnUrl) == "purchasellist") {
                        $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                    } elseif (GetPageName($returnUrl) == "purchaselview") {
                        $returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "purchasellist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "purchasellist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) { // Return to caller
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl);
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Add failed, restore form values
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row based on row type
        $this->RowType = RowType::ADD; // Render add type

        // Render row
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load default values
    protected function loadDefaultValues()
    {
        $this->type->DefaultValue = $this->type->getDefault(); // PHP
        $this->type->OldValue = $this->type->DefaultValue;
        $this->supplier->DefaultValue = $this->supplier->getDefault(); // PHP
        $this->supplier->OldValue = $this->supplier->DefaultValue;
        $this->grp->DefaultValue = $this->grp->getDefault(); // PHP
        $this->grp->OldValue = $this->grp->DefaultValue;
        $this->s_grp->DefaultValue = $this->s_grp->getDefault(); // PHP
        $this->s_grp->OldValue = $this->s_grp->DefaultValue;
        $this->product->DefaultValue = $this->product->getDefault(); // PHP
        $this->product->OldValue = $this->product->DefaultValue;
        $this->rid->DefaultValue = $this->rid->getDefault(); // PHP
        $this->rid->OldValue = $this->rid->DefaultValue;
        $this->packing_type->DefaultValue = $this->packing_type->getDefault(); // PHP
        $this->packing_type->OldValue = $this->packing_type->DefaultValue;
        $this->lot_no->DefaultValue = $this->lot_no->getDefault(); // PHP
        $this->lot_no->OldValue = $this->lot_no->DefaultValue;
        $this->avg_quantity->DefaultValue = $this->avg_quantity->getDefault(); // PHP
        $this->avg_quantity->OldValue = $this->avg_quantity->DefaultValue;
        $this->packets->DefaultValue = $this->packets->getDefault(); // PHP
        $this->packets->OldValue = $this->packets->DefaultValue;
        $this->net_weight->DefaultValue = $this->net_weight->getDefault(); // PHP
        $this->net_weight->OldValue = $this->net_weight->DefaultValue;
        $this->operator->DefaultValue = $this->operator->getDefault(); // PHP
        $this->operator->OldValue = $this->operator->DefaultValue;
        $this->rack->DefaultValue = $this->rack->getDefault(); // PHP
        $this->rack->OldValue = $this->rack->DefaultValue;
        $this->updated->DefaultValue = $this->updated->getDefault(); // PHP
        $this->updated->OldValue = $this->updated->DefaultValue;
        $this->invoice_details->DefaultValue = $this->invoice_details->getDefault(); // PHP
        $this->invoice_details->OldValue = $this->invoice_details->DefaultValue;
        $this->country->DefaultValue = $this->country->getDefault(); // PHP
        $this->country->OldValue = $this->country->DefaultValue;
        $this->wool_type->DefaultValue = $this->wool_type->getDefault(); // PHP
        $this->wool_type->OldValue = $this->wool_type->DefaultValue;
        $this->quality->DefaultValue = $this->quality->getDefault(); // PHP
        $this->quality->OldValue = $this->quality->DefaultValue;
        $this->sorting_type->DefaultValue = $this->sorting_type->getDefault(); // PHP
        $this->sorting_type->OldValue = $this->sorting_type->DefaultValue;
        $this->scouring_type->DefaultValue = $this->scouring_type->getDefault(); // PHP
        $this->scouring_type->OldValue = $this->scouring_type->DefaultValue;
        $this->dye_type->DefaultValue = $this->dye_type->getDefault(); // PHP
        $this->dye_type->OldValue = $this->dye_type->DefaultValue;
        $this->importer->DefaultValue = $this->importer->getDefault(); // PHP
        $this->importer->OldValue = $this->importer->DefaultValue;
        $this->grade->DefaultValue = $this->grade->getDefault(); // PHP
        $this->grade->OldValue = $this->grade->DefaultValue;
        $this->audit->DefaultValue = $this->audit->getDefault(); // PHP
        $this->audit->OldValue = $this->audit->DefaultValue;
        $this->age->DefaultValue = $this->age->getDefault(); // PHP
        $this->age->OldValue = $this->age->DefaultValue;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'type' first before field var 'x_type'
        $val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
        if (!$this->type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->type->Visible = false; // Disable update for API request
            } else {
                $this->type->setFormValue($val);
            }
        }

        // Check field name 'supplier' first before field var 'x_supplier'
        $val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
        if (!$this->supplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->supplier->Visible = false; // Disable update for API request
            } else {
                $this->supplier->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'po' first before field var 'x_po'
        $val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
        if (!$this->po->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po->Visible = false; // Disable update for API request
            } else {
                $this->po->setFormValue($val);
            }
        }

        // Check field name 'po_return' first before field var 'x_po_return'
        $val = $CurrentForm->hasValue("po_return") ? $CurrentForm->getValue("po_return") : $CurrentForm->getValue("x_po_return");
        if (!$this->po_return->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->po_return->Visible = false; // Disable update for API request
            } else {
                $this->po_return->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'company_id' first before field var 'x_company_id'
        $val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
        if (!$this->company_id->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->company_id->Visible = false; // Disable update for API request
            } else {
                $this->company_id->setFormValue($val);
            }
        }

        // Check field name 'rid_return' first before field var 'x_rid_return'
        $val = $CurrentForm->hasValue("rid_return") ? $CurrentForm->getValue("rid_return") : $CurrentForm->getValue("x_rid_return");
        if (!$this->rid_return->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid_return->Visible = false; // Disable update for API request
            } else {
                $this->rid_return->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'packets' first before field var 'x_packets'
        $val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
        if (!$this->packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets->Visible = false; // Disable update for API request
            } else {
                $this->packets->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'net_weight' first before field var 'x_net_weight'
        $val = $CurrentForm->hasValue("net_weight") ? $CurrentForm->getValue("net_weight") : $CurrentForm->getValue("x_net_weight");
        if (!$this->net_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->net_weight->Visible = false; // Disable update for API request
            } else {
                $this->net_weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name '@' first before field var 'x__40'
        $val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
        if (!$this->_40->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->_40->Visible = false; // Disable update for API request
            } else {
                $this->_40->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'amount' first before field var 'x_amount'
        $val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
        if (!$this->amount->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->amount->Visible = false; // Disable update for API request
            } else {
                $this->amount->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'dated' first before field var 'x_dated'
        $val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
        if (!$this->dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->dated->Visible = false; // Disable update for API request
            } else {
                $this->dated->setFormValue($val, true, $validate);
            }
            $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'rack' first before field var 'x_rack'
        $val = $CurrentForm->hasValue("rack") ? $CurrentForm->getValue("rack") : $CurrentForm->getValue("x_rack");
        if (!$this->rack->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rack->Visible = false; // Disable update for API request
            } else {
                $this->rack->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'goods_inward' first before field var 'x_goods_inward'
        $val = $CurrentForm->hasValue("goods_inward") ? $CurrentForm->getValue("goods_inward") : $CurrentForm->getValue("x_goods_inward");
        if (!$this->goods_inward->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->goods_inward->Visible = false; // Disable update for API request
            } else {
                $this->goods_inward->setFormValue($val);
            }
        }

        // Check field name 'invoice_details' first before field var 'x_invoice_details'
        $val = $CurrentForm->hasValue("invoice_details") ? $CurrentForm->getValue("invoice_details") : $CurrentForm->getValue("x_invoice_details");
        if (!$this->invoice_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_details->Visible = false; // Disable update for API request
            } else {
                $this->invoice_details->setFormValue($val);
            }
        }

        // Check field name 'invoice_dated' first before field var 'x_invoice_dated'
        $val = $CurrentForm->hasValue("invoice_dated") ? $CurrentForm->getValue("invoice_dated") : $CurrentForm->getValue("x_invoice_dated");
        if (!$this->invoice_dated->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_dated->Visible = false; // Disable update for API request
            } else {
                $this->invoice_dated->setFormValue($val, true, $validate);
            }
            $this->invoice_dated->CurrentValue = UnFormatDateTime($this->invoice_dated->CurrentValue, $this->invoice_dated->formatPattern());
        }

        // Check field name 'return_details' first before field var 'x_return_details'
        $val = $CurrentForm->hasValue("return_details") ? $CurrentForm->getValue("return_details") : $CurrentForm->getValue("x_return_details");
        if (!$this->return_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->return_details->Visible = false; // Disable update for API request
            } else {
                $this->return_details->setFormValue($val);
            }
        }

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->type->CurrentValue = $this->type->FormValue;
        $this->supplier->CurrentValue = $this->supplier->FormValue;
        $this->po->CurrentValue = $this->po->FormValue;
        $this->po_return->CurrentValue = $this->po_return->FormValue;
        $this->company_id->CurrentValue = $this->company_id->FormValue;
        $this->rid_return->CurrentValue = $this->rid_return->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->packets->CurrentValue = $this->packets->FormValue;
        $this->net_weight->CurrentValue = $this->net_weight->FormValue;
        $this->_40->CurrentValue = $this->_40->FormValue;
        $this->amount->CurrentValue = $this->amount->FormValue;
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->dated->CurrentValue = $this->dated->FormValue;
        $this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern());
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->rack->CurrentValue = $this->rack->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->goods_inward->CurrentValue = $this->goods_inward->FormValue;
        $this->invoice_details->CurrentValue = $this->invoice_details->FormValue;
        $this->invoice_dated->CurrentValue = $this->invoice_dated->FormValue;
        $this->invoice_dated->CurrentValue = UnFormatDateTime($this->invoice_dated->CurrentValue, $this->invoice_dated->formatPattern());
        $this->return_details->CurrentValue = $this->return_details->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->type->setDbValue($row['type']);
        $this->supplier->setDbValue($row['supplier']);
        $this->po->setDbValue($row['po']);
        $this->po_return->setDbValue($row['po_return']);
        $this->company_id->setDbValue($row['company_id']);
        $this->grp->setDbValue($row['grp']);
        $this->s_grp->setDbValue($row['s_grp']);
        $this->product->setDbValue($row['product']);
        $this->rid_return->setDbValue($row['rid_return']);
        if (array_key_exists('EV__rid_return', $row)) {
            $this->rid_return->VirtualValue = $row['EV__rid_return']; // Set up virtual field value
        } else {
            $this->rid_return->VirtualValue = ""; // Clear value
        }
        $this->rid->setDbValue($row['rid']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->lot_no->setDbValue($row['lot_no']);
        if (array_key_exists('EV__lot_no', $row)) {
            $this->lot_no->VirtualValue = $row['EV__lot_no']; // Set up virtual field value
        } else {
            $this->lot_no->VirtualValue = ""; // Clear value
        }
        $this->avg_quantity->setDbValue($row['avg_quantity']);
        $this->packets->setDbValue($row['packets']);
        $this->net_weight->setDbValue($row['net_weight']);
        $this->_40->setDbValue($row['@']);
        $this->amount->setDbValue($row['amount']);
        $this->godown->setDbValue($row['godown']);
        $this->dated->setDbValue($row['dated']);
        $this->operator->setDbValue($row['operator']);
        $this->rack->setDbValue($row['rack']);
        $this->updated->setDbValue($row['updated']);
        $this->datetime->setDbValue($row['datetime']);
        $this->remarks->setDbValue($row['remarks']);
        $this->goods_inward->setDbValue($row['goods_inward']);
        $this->invoice_details->setDbValue($row['invoice_details']);
        $this->invoice_dated->setDbValue($row['invoice_dated']);
        $this->_barcode->setDbValue($row['barcode']);
        $this->country->setDbValue($row['country']);
        $this->wool_type->setDbValue($row['wool_type']);
        $this->quality->setDbValue($row['quality']);
        $this->sorting_type->setDbValue($row['sorting_type']);
        $this->scouring_type->setDbValue($row['scouring_type']);
        $this->dye_type->setDbValue($row['dye_type']);
        $this->importer->setDbValue($row['importer']);
        $this->grade->setDbValue($row['grade']);
        $this->return_details->setDbValue($row['return_details']);
        $this->audit->setDbValue($row['audit']);
        $this->a_operator->setDbValue($row['a_operator']);
        $this->a_datetime->setDbValue($row['a_datetime']);
        $this->agent->setDbValue($row['agent']);
        $this->qc_remarks->setDbValue($row['qc_remarks']);
        $this->qc_status->setDbValue($row['qc_status']);
        $this->qc_operator->setDbValue($row['qc_operator']);
        $this->qc_datetime->setDbValue($row['qc_datetime']);
        $this->age->setDbValue($row['age']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['type'] = $this->type->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['po'] = $this->po->DefaultValue;
        $row['po_return'] = $this->po_return->DefaultValue;
        $row['company_id'] = $this->company_id->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['s_grp'] = $this->s_grp->DefaultValue;
        $row['product'] = $this->product->DefaultValue;
        $row['rid_return'] = $this->rid_return->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['avg_quantity'] = $this->avg_quantity->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['net_weight'] = $this->net_weight->DefaultValue;
        $row['@'] = $this->_40->DefaultValue;
        $row['amount'] = $this->amount->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['dated'] = $this->dated->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['rack'] = $this->rack->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['goods_inward'] = $this->goods_inward->DefaultValue;
        $row['invoice_details'] = $this->invoice_details->DefaultValue;
        $row['invoice_dated'] = $this->invoice_dated->DefaultValue;
        $row['barcode'] = $this->_barcode->DefaultValue;
        $row['country'] = $this->country->DefaultValue;
        $row['wool_type'] = $this->wool_type->DefaultValue;
        $row['quality'] = $this->quality->DefaultValue;
        $row['sorting_type'] = $this->sorting_type->DefaultValue;
        $row['scouring_type'] = $this->scouring_type->DefaultValue;
        $row['dye_type'] = $this->dye_type->DefaultValue;
        $row['importer'] = $this->importer->DefaultValue;
        $row['grade'] = $this->grade->DefaultValue;
        $row['return_details'] = $this->return_details->DefaultValue;
        $row['audit'] = $this->audit->DefaultValue;
        $row['a_operator'] = $this->a_operator->DefaultValue;
        $row['a_datetime'] = $this->a_datetime->DefaultValue;
        $row['agent'] = $this->agent->DefaultValue;
        $row['qc_remarks'] = $this->qc_remarks->DefaultValue;
        $row['qc_status'] = $this->qc_status->DefaultValue;
        $row['qc_operator'] = $this->qc_operator->DefaultValue;
        $row['qc_datetime'] = $this->qc_datetime->DefaultValue;
        $row['age'] = $this->age->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // type
        $this->type->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // po
        $this->po->RowCssClass = "row";

        // po_return
        $this->po_return->RowCssClass = "row";

        // company_id
        $this->company_id->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // s_grp
        $this->s_grp->RowCssClass = "row";

        // product
        $this->product->RowCssClass = "row";

        // rid_return
        $this->rid_return->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // avg_quantity
        $this->avg_quantity->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // net_weight
        $this->net_weight->RowCssClass = "row";

        // @
        $this->_40->RowCssClass = "row";

        // amount
        $this->amount->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // dated
        $this->dated->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // rack
        $this->rack->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // goods_inward
        $this->goods_inward->RowCssClass = "row";

        // invoice_details
        $this->invoice_details->RowCssClass = "row";

        // invoice_dated
        $this->invoice_dated->RowCssClass = "row";

        // barcode
        $this->_barcode->RowCssClass = "row";

        // country
        $this->country->RowCssClass = "row";

        // wool_type
        $this->wool_type->RowCssClass = "row";

        // quality
        $this->quality->RowCssClass = "row";

        // sorting_type
        $this->sorting_type->RowCssClass = "row";

        // scouring_type
        $this->scouring_type->RowCssClass = "row";

        // dye_type
        $this->dye_type->RowCssClass = "row";

        // importer
        $this->importer->RowCssClass = "row";

        // grade
        $this->grade->RowCssClass = "row";

        // return_details
        $this->return_details->RowCssClass = "row";

        // audit
        $this->audit->RowCssClass = "row";

        // a_operator
        $this->a_operator->RowCssClass = "row";

        // a_datetime
        $this->a_datetime->RowCssClass = "row";

        // agent
        $this->agent->RowCssClass = "row";

        // qc_remarks
        $this->qc_remarks->RowCssClass = "row";

        // qc_status
        $this->qc_status->RowCssClass = "row";

        // qc_operator
        $this->qc_operator->RowCssClass = "row";

        // qc_datetime
        $this->qc_datetime->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // type
            $curVal = strval($this->type->CurrentValue);
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
                if ($this->type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->type->Lookup->renderViewRow($rswrk[0]);
                        $this->type->ViewValue = $this->type->displayValue($arwrk);
                    } else {
                        $this->type->ViewValue = FormatNumber($this->type->CurrentValue, $this->type->formatPattern());
                    }
                }
            } else {
                $this->type->ViewValue = null;
            }

            // supplier
            $this->supplier->ViewValue = $this->supplier->CurrentValue;
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->ViewValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->ViewValue = null;
            }

            // po
            $this->po->ViewValue = $this->po->CurrentValue;
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->ViewValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["cart_id"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["cart_id"]->searchDataType(), "");
                    $lookupFilter = $this->po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                        $this->po->ViewValue = $this->po->displayValue($arwrk);
                    } else {
                        $this->po->ViewValue = $this->po->CurrentValue;
                    }
                }
            } else {
                $this->po->ViewValue = null;
            }

            // po_return
            $this->po_return->ViewValue = $this->po_return->CurrentValue;
            $curVal = strval($this->po_return->CurrentValue);
            if ($curVal != "") {
                $this->po_return->ViewValue = $this->po_return->lookupCacheOption($curVal);
                if ($this->po_return->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_return->Lookup->getTable()->Fields["cart_id"]->searchExpression(), "=", $curVal, $this->po_return->Lookup->getTable()->Fields["cart_id"]->searchDataType(), "");
                    $sqlWrk = $this->po_return->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_return->Lookup->renderViewRow($rswrk[0]);
                        $this->po_return->ViewValue = $this->po_return->displayValue($arwrk);
                    } else {
                        $this->po_return->ViewValue = FormatNumber($this->po_return->CurrentValue, $this->po_return->formatPattern());
                    }
                }
            } else {
                $this->po_return->ViewValue = null;
            }

            // company_id
            $curVal = strval($this->company_id->CurrentValue);
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
                if ($this->company_id->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                    $sqlWrk = $this->company_id->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->company_id->Lookup->renderViewRow($rswrk[0]);
                        $this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
                    } else {
                        $this->company_id->ViewValue = FormatNumber($this->company_id->CurrentValue, $this->company_id->formatPattern());
                    }
                }
            } else {
                $this->company_id->ViewValue = null;
            }

            // rid_return
            if ($this->rid_return->VirtualValue != "") {
                $this->rid_return->ViewValue = $this->rid_return->VirtualValue;
            } else {
                $curVal = strval($this->rid_return->CurrentValue);
                if ($curVal != "") {
                    $this->rid_return->ViewValue = $this->rid_return->lookupCacheOption($curVal);
                    if ($this->rid_return->ViewValue === null) { // Lookup from database
                        $filterWrk = SearchFilter($this->rid_return->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid_return->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                        $sqlWrk = $this->rid_return->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                        $conn = Conn();
                        $config = $conn->getConfiguration();
                        $config->setResultCache($this->Cache);
                        $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                        $ari = count($rswrk);
                        if ($ari > 0) { // Lookup values found
                            $arwrk = $this->rid_return->Lookup->renderViewRow($rswrk[0]);
                            $this->rid_return->ViewValue = $this->rid_return->displayValue($arwrk);
                        } else {
                            $this->rid_return->ViewValue = $this->rid_return->CurrentValue;
                        }
                    }
                } else {
                    $this->rid_return->ViewValue = null;
                }
            }

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // lot_no
            if ($this->lot_no->VirtualValue != "") {
                $this->lot_no->ViewValue = $this->lot_no->VirtualValue;
            } else {
                $this->lot_no->ViewValue = $this->lot_no->CurrentValue;
            }

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // net_weight
            $this->net_weight->ViewValue = $this->net_weight->CurrentValue;
            $this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, $this->net_weight->formatPattern());

            // @
            $this->_40->ViewValue = $this->_40->CurrentValue;
            $this->_40->ViewValue = FormatNumber($this->_40->ViewValue, $this->_40->formatPattern());

            // amount
            $this->amount->ViewValue = $this->amount->CurrentValue;
            $this->amount->ViewValue = FormatNumber($this->amount->ViewValue, $this->amount->formatPattern());

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // dated
            $this->dated->ViewValue = $this->dated->CurrentValue;
            $this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, $this->dated->formatPattern());

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->operator->getSelectFilter($this); // PHP
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // rack
            $this->rack->ViewValue = $this->rack->CurrentValue;

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // goods_inward
            $this->goods_inward->ViewValue = $this->goods_inward->CurrentValue;

            // invoice_details
            $this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;

            // invoice_dated
            $this->invoice_dated->ViewValue = $this->invoice_dated->CurrentValue;
            $this->invoice_dated->ViewValue = FormatDateTime($this->invoice_dated->ViewValue, $this->invoice_dated->formatPattern());

            // barcode
            $this->_barcode->ViewValue = $this->_barcode->CurrentValue;

            // return_details
            $this->return_details->ViewValue = $this->return_details->CurrentValue;

            // type
            $this->type->HrefValue = "";
            $this->type->TooltipValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // po
            $this->po->HrefValue = "";

            // po_return
            $this->po_return->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // rid_return
            $this->rid_return->HrefValue = "";
            $this->rid_return->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }

            // lot_no
            $this->lot_no->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // dated
            $this->dated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // rack
            $this->rack->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // goods_inward
            $this->goods_inward->HrefValue = "";

            // invoice_details
            if (!EmptyValue($this->invoice_details->CurrentValue)) {
                $this->invoice_details->HrefValue = $this->invoice_details->getLinkPrefix() . $this->invoice_details->CurrentValue; // Add prefix/suffix
                $this->invoice_details->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->invoice_details->HrefValue = FullUrl($this->invoice_details->HrefValue, "href");
                }
            } else {
                $this->invoice_details->HrefValue = "";
            }

            // invoice_dated
            if (!EmptyValue($this->invoice_details->CurrentValue)) {
                $this->invoice_dated->HrefValue = $this->invoice_dated->getLinkPrefix() . $this->invoice_details->CurrentValue; // Add prefix/suffix
                $this->invoice_dated->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->invoice_dated->HrefValue = FullUrl($this->invoice_dated->HrefValue, "href");
                }
            } else {
                $this->invoice_dated->HrefValue = "";
            }

            // return_details
            $this->return_details->HrefValue = "";
        } elseif ($this->RowType == RowType::ADD) {
            // type
            $this->type->setupEditAttributes();
            $curVal = trim(strval($this->type->CurrentValue));
            if ($curVal != "") {
                $this->type->ViewValue = $this->type->lookupCacheOption($curVal);
            } else {
                $this->type->ViewValue = $this->type->Lookup !== null && is_array($this->type->lookupOptions()) && count($this->type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->type->ViewValue !== null) { // Load from cache
                $this->type->EditValue = array_values($this->type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->type->CurrentValue, $this->type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->type->getSelectFilter($this); // PHP
                $sqlWrk = $this->type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->type->EditValue = $arwrk;
            }
            $this->type->PlaceHolder = RemoveHtml($this->type->caption());

            // supplier
            $this->supplier->setupEditAttributes();
            $this->supplier->EditValue = $this->supplier->CurrentValue;
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->EditValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->EditValue = HtmlEncode($this->supplier->CurrentValue);
                    }
                }
            } else {
                $this->supplier->EditValue = null;
            }
            $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());

            // po
            $this->po->setupEditAttributes();
            if (!$this->po->Raw) {
                $this->po->CurrentValue = HtmlDecode($this->po->CurrentValue);
            }
            $this->po->EditValue = HtmlEncode($this->po->CurrentValue);
            $curVal = strval($this->po->CurrentValue);
            if ($curVal != "") {
                $this->po->EditValue = $this->po->lookupCacheOption($curVal);
                if ($this->po->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po->Lookup->getTable()->Fields["cart_id"]->searchExpression(), "=", $curVal, $this->po->Lookup->getTable()->Fields["cart_id"]->searchDataType(), "");
                    $lookupFilter = $this->po->getSelectFilter($this); // PHP
                    $sqlWrk = $this->po->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po->Lookup->renderViewRow($rswrk[0]);
                        $this->po->EditValue = $this->po->displayValue($arwrk);
                    } else {
                        $this->po->EditValue = HtmlEncode($this->po->CurrentValue);
                    }
                }
            } else {
                $this->po->EditValue = null;
            }
            $this->po->PlaceHolder = RemoveHtml($this->po->caption());

            // po_return
            $this->po_return->setupEditAttributes();
            $this->po_return->EditValue = $this->po_return->CurrentValue;
            $curVal = strval($this->po_return->CurrentValue);
            if ($curVal != "") {
                $this->po_return->EditValue = $this->po_return->lookupCacheOption($curVal);
                if ($this->po_return->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->po_return->Lookup->getTable()->Fields["cart_id"]->searchExpression(), "=", $curVal, $this->po_return->Lookup->getTable()->Fields["cart_id"]->searchDataType(), "");
                    $sqlWrk = $this->po_return->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->po_return->Lookup->renderViewRow($rswrk[0]);
                        $this->po_return->EditValue = $this->po_return->displayValue($arwrk);
                    } else {
                        $this->po_return->EditValue = HtmlEncode(FormatNumber($this->po_return->CurrentValue, $this->po_return->formatPattern()));
                    }
                }
            } else {
                $this->po_return->EditValue = null;
            }
            $this->po_return->PlaceHolder = RemoveHtml($this->po_return->caption());

            // company_id
            $this->company_id->setupEditAttributes();
            $curVal = trim(strval($this->company_id->CurrentValue));
            if ($curVal != "") {
                $this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
            } else {
                $this->company_id->ViewValue = $this->company_id->Lookup !== null && is_array($this->company_id->lookupOptions()) && count($this->company_id->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->company_id->ViewValue !== null) { // Load from cache
                $this->company_id->EditValue = array_values($this->company_id->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->company_id->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->company_id->CurrentValue, $this->company_id->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->company_id->getSelectFilter($this); // PHP
                $sqlWrk = $this->company_id->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->company_id->EditValue = $arwrk;
            }
            $this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

            // rid_return
            $curVal = trim(strval($this->rid_return->CurrentValue));
            if ($curVal != "") {
                $this->rid_return->ViewValue = $this->rid_return->lookupCacheOption($curVal);
            } else {
                $this->rid_return->ViewValue = $this->rid_return->Lookup !== null && is_array($this->rid_return->lookupOptions()) && count($this->rid_return->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->rid_return->ViewValue !== null) { // Load from cache
                $this->rid_return->EditValue = array_values($this->rid_return->lookupOptions());
                if ($this->rid_return->ViewValue == "") {
                    $this->rid_return->ViewValue = $Language->phrase("PleaseSelect");
                }
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->rid_return->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->rid_return->CurrentValue, $this->rid_return->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->rid_return->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid_return->Lookup->renderViewRow($rswrk[0]);
                    $this->rid_return->ViewValue = $this->rid_return->displayValue($arwrk);
                } else {
                    $this->rid_return->ViewValue = $Language->phrase("PleaseSelect");
                }
                $arwrk = $rswrk;
                $this->rid_return->EditValue = $arwrk;
            }
            $this->rid_return->PlaceHolder = RemoveHtml($this->rid_return->caption());

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->rid->getSelectFilter($this); // PHP
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = HtmlEncode($this->rid->CurrentValue);
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }
            $this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->CurrentValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
                $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
            }

            // net_weight
            $this->net_weight->setupEditAttributes();
            $this->net_weight->EditValue = $this->net_weight->CurrentValue;
            $this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
            if (strval($this->net_weight->EditValue) != "" && is_numeric($this->net_weight->EditValue)) {
                $this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, null);
            }

            // @
            $this->_40->setupEditAttributes();
            $this->_40->EditValue = $this->_40->CurrentValue;
            $this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
            if (strval($this->_40->EditValue) != "" && is_numeric($this->_40->EditValue)) {
                $this->_40->EditValue = FormatNumber($this->_40->EditValue, null);
            }

            // amount
            $this->amount->setupEditAttributes();
            $this->amount->EditCustomAttributes = $this->amount->getEditCustomAttributes(); // PHP
            $this->amount->EditValue = $this->amount->CurrentValue;
            $this->amount->PlaceHolder = RemoveHtml($this->amount->caption());
            if (strval($this->amount->EditValue) != "" && is_numeric($this->amount->EditValue)) {
                $this->amount->EditValue = FormatNumber($this->amount->EditValue, null);
            }

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->CurrentValue));
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->CurrentValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // dated
            $this->dated->setupEditAttributes();
            $this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()));
            $this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

            // operator

            // rack
            $this->rack->setupEditAttributes();
            if (!$this->rack->Raw) {
                $this->rack->CurrentValue = HtmlDecode($this->rack->CurrentValue);
            }
            $this->rack->EditValue = HtmlEncode($this->rack->CurrentValue);
            $this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

            // datetime

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // goods_inward
            $this->goods_inward->setupEditAttributes();
            if (!$this->goods_inward->Raw) {
                $this->goods_inward->CurrentValue = HtmlDecode($this->goods_inward->CurrentValue);
            }
            $this->goods_inward->EditValue = HtmlEncode($this->goods_inward->CurrentValue);
            $this->goods_inward->PlaceHolder = RemoveHtml($this->goods_inward->caption());

            // invoice_details
            $this->invoice_details->setupEditAttributes();
            if (!$this->invoice_details->Raw) {
                $this->invoice_details->CurrentValue = HtmlDecode($this->invoice_details->CurrentValue);
            }
            $this->invoice_details->EditValue = HtmlEncode($this->invoice_details->CurrentValue);
            $this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

            // invoice_dated
            $this->invoice_dated->setupEditAttributes();
            $this->invoice_dated->EditValue = HtmlEncode(FormatDateTime($this->invoice_dated->CurrentValue, $this->invoice_dated->formatPattern()));
            $this->invoice_dated->PlaceHolder = RemoveHtml($this->invoice_dated->caption());

            // return_details
            $this->return_details->setupEditAttributes();
            $this->return_details->EditValue = HtmlEncode($this->return_details->CurrentValue);
            $this->return_details->PlaceHolder = RemoveHtml($this->return_details->caption());

            // Add refer script

            // type
            $this->type->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }

            // po
            $this->po->HrefValue = "";

            // po_return
            $this->po_return->HrefValue = "";

            // company_id
            $this->company_id->HrefValue = "";

            // rid_return
            $this->rid_return->HrefValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }

            // lot_no
            $this->lot_no->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";

            // @
            $this->_40->HrefValue = "";

            // amount
            $this->amount->HrefValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // dated
            $this->dated->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // rack
            $this->rack->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // goods_inward
            $this->goods_inward->HrefValue = "";

            // invoice_details
            if (!EmptyValue($this->invoice_details->CurrentValue)) {
                $this->invoice_details->HrefValue = $this->invoice_details->getLinkPrefix() . $this->invoice_details->CurrentValue; // Add prefix/suffix
                $this->invoice_details->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->invoice_details->HrefValue = FullUrl($this->invoice_details->HrefValue, "href");
                }
            } else {
                $this->invoice_details->HrefValue = "";
            }

            // invoice_dated
            if (!EmptyValue($this->invoice_details->CurrentValue)) {
                $this->invoice_dated->HrefValue = $this->invoice_dated->getLinkPrefix() . $this->invoice_details->CurrentValue; // Add prefix/suffix
                $this->invoice_dated->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->invoice_dated->HrefValue = FullUrl($this->invoice_dated->HrefValue, "href");
                }
            } else {
                $this->invoice_dated->HrefValue = "";
            }

            // return_details
            $this->return_details->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->type->Visible && $this->type->Required) {
                if (!$this->type->IsDetailKey && EmptyValue($this->type->FormValue)) {
                    $this->type->addErrorMessage(str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
                }
            }
            if ($this->supplier->Visible && $this->supplier->Required) {
                if (!$this->supplier->IsDetailKey && EmptyValue($this->supplier->FormValue)) {
                    $this->supplier->addErrorMessage(str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->supplier->FormValue)) {
                $this->supplier->addErrorMessage($this->supplier->getErrorMessage(false));
            }
            if ($this->po->Visible && $this->po->Required) {
                if (!$this->po->IsDetailKey && EmptyValue($this->po->FormValue)) {
                    $this->po->addErrorMessage(str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
                }
            }
            if ($this->po_return->Visible && $this->po_return->Required) {
                if (!$this->po_return->IsDetailKey && EmptyValue($this->po_return->FormValue)) {
                    $this->po_return->addErrorMessage(str_replace("%s", $this->po_return->caption(), $this->po_return->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->po_return->FormValue)) {
                $this->po_return->addErrorMessage($this->po_return->getErrorMessage(false));
            }
            if ($this->company_id->Visible && $this->company_id->Required) {
                if (!$this->company_id->IsDetailKey && EmptyValue($this->company_id->FormValue)) {
                    $this->company_id->addErrorMessage(str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
                }
            }
            if ($this->rid_return->Visible && $this->rid_return->Required) {
                if (!$this->rid_return->IsDetailKey && EmptyValue($this->rid_return->FormValue)) {
                    $this->rid_return->addErrorMessage(str_replace("%s", $this->rid_return->caption(), $this->rid_return->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->rid->FormValue)) {
                $this->rid->addErrorMessage($this->rid->getErrorMessage(false));
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->packets->Visible && $this->packets->Required) {
                if (!$this->packets->IsDetailKey && EmptyValue($this->packets->FormValue)) {
                    $this->packets->addErrorMessage(str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->packets->FormValue)) {
                $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
            }
            if ($this->net_weight->Visible && $this->net_weight->Required) {
                if (!$this->net_weight->IsDetailKey && EmptyValue($this->net_weight->FormValue)) {
                    $this->net_weight->addErrorMessage(str_replace("%s", $this->net_weight->caption(), $this->net_weight->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->net_weight->FormValue)) {
                $this->net_weight->addErrorMessage($this->net_weight->getErrorMessage(false));
            }
            if ($this->_40->Visible && $this->_40->Required) {
                if (!$this->_40->IsDetailKey && EmptyValue($this->_40->FormValue)) {
                    $this->_40->addErrorMessage(str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->_40->FormValue)) {
                $this->_40->addErrorMessage($this->_40->getErrorMessage(false));
            }
            if ($this->amount->Visible && $this->amount->Required) {
                if (!$this->amount->IsDetailKey && EmptyValue($this->amount->FormValue)) {
                    $this->amount->addErrorMessage(str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->amount->FormValue)) {
                $this->amount->addErrorMessage($this->amount->getErrorMessage(false));
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if (!$this->godown->IsDetailKey && EmptyValue($this->godown->FormValue)) {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->dated->Visible && $this->dated->Required) {
                if (!$this->dated->IsDetailKey && EmptyValue($this->dated->FormValue)) {
                    $this->dated->addErrorMessage(str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->dated->FormValue, $this->dated->formatPattern())) {
                $this->dated->addErrorMessage($this->dated->getErrorMessage(false));
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->rack->Visible && $this->rack->Required) {
                if (!$this->rack->IsDetailKey && EmptyValue($this->rack->FormValue)) {
                    $this->rack->addErrorMessage(str_replace("%s", $this->rack->caption(), $this->rack->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->goods_inward->Visible && $this->goods_inward->Required) {
                if (!$this->goods_inward->IsDetailKey && EmptyValue($this->goods_inward->FormValue)) {
                    $this->goods_inward->addErrorMessage(str_replace("%s", $this->goods_inward->caption(), $this->goods_inward->RequiredErrorMessage));
                }
            }
            if ($this->invoice_details->Visible && $this->invoice_details->Required) {
                if (!$this->invoice_details->IsDetailKey && EmptyValue($this->invoice_details->FormValue)) {
                    $this->invoice_details->addErrorMessage(str_replace("%s", $this->invoice_details->caption(), $this->invoice_details->RequiredErrorMessage));
                }
            }
            if ($this->invoice_dated->Visible && $this->invoice_dated->Required) {
                if (!$this->invoice_dated->IsDetailKey && EmptyValue($this->invoice_dated->FormValue)) {
                    $this->invoice_dated->addErrorMessage(str_replace("%s", $this->invoice_dated->caption(), $this->invoice_dated->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->invoice_dated->FormValue, $this->invoice_dated->formatPattern())) {
                $this->invoice_dated->addErrorMessage($this->invoice_dated->getErrorMessage(false));
            }
            if ($this->return_details->Visible && $this->return_details->Required) {
                if (!$this->return_details->IsDetailKey && EmptyValue($this->return_details->FormValue)) {
                    $this->return_details->addErrorMessage(str_replace("%s", $this->return_details->caption(), $this->return_details->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Add record
    protected function addRow($rsold = null)
    {
        global $Language, $Security;

        // Get new row
        $rsnew = $this->getAddRow();

        // Update current values
        $this->setCurrentValues($rsnew);
        $conn = $this->getConnection();

        // Load db values from old row
        $this->loadDbValues($rsold);

        // Call Row Inserting event
        $insertRow = $this->rowInserting($rsold, $rsnew);
        if ($insertRow) {
            $addRow = $this->insert($rsnew);
            if ($addRow) {
            } elseif (!EmptyValue($this->DbErrorMessage)) { // Show database error
                $this->setFailureMessage($this->DbErrorMessage);
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("InsertCancelled"));
            }
            $addRow = false;
        }
        if ($addRow) {
            // Call Row Inserted event
            $this->rowInserted($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $addRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_ADD_ACTION"), $table => $row]);
        }
        return $addRow;
    }

    /**
     * Get add row
     *
     * @return array
     */
    protected function getAddRow()
    {
        global $Security;
        $rsnew = [];

        // type
        $this->type->setDbValueDef($rsnew, $this->type->CurrentValue, false);

        // supplier
        $this->supplier->setDbValueDef($rsnew, $this->supplier->CurrentValue, false);

        // po
        $this->po->setDbValueDef($rsnew, $this->po->CurrentValue, false);

        // po_return
        $this->po_return->setDbValueDef($rsnew, $this->po_return->CurrentValue, false);

        // company_id
        $this->company_id->setDbValueDef($rsnew, $this->company_id->CurrentValue, false);

        // rid_return
        $this->rid_return->setDbValueDef($rsnew, $this->rid_return->CurrentValue, false);

        // rid
        $this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, false);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, false);

        // lot_no
        $this->lot_no->setDbValueDef($rsnew, $this->lot_no->CurrentValue, false);

        // packets
        $this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, false);

        // net_weight
        $this->net_weight->setDbValueDef($rsnew, $this->net_weight->CurrentValue, false);

        // @
        $this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, false);

        // amount
        $this->amount->setDbValueDef($rsnew, $this->amount->CurrentValue, false);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, false);

        // dated
        $this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, $this->dated->formatPattern()), false);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, strval($this->operator->CurrentValue) == "");

        // rack
        $this->rack->setDbValueDef($rsnew, $this->rack->CurrentValue, false);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), false);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, false);

        // goods_inward
        $this->goods_inward->setDbValueDef($rsnew, $this->goods_inward->CurrentValue, false);

        // invoice_details
        $this->invoice_details->setDbValueDef($rsnew, $this->invoice_details->CurrentValue, false);

        // invoice_dated
        $this->invoice_dated->setDbValueDef($rsnew, UnFormatDateTime($this->invoice_dated->CurrentValue, $this->invoice_dated->formatPattern()), false);

        // return_details
        $this->return_details->setDbValueDef($rsnew, $this->return_details->CurrentValue, false);
        return $rsnew;
    }

    /**
     * Restore add form from row
     * @param array $row Row
     */
    protected function restoreAddFormFromRow($row)
    {
        if (isset($row['type'])) { // type
            $this->type->setFormValue($row['type']);
        }
        if (isset($row['supplier'])) { // supplier
            $this->supplier->setFormValue($row['supplier']);
        }
        if (isset($row['po'])) { // po
            $this->po->setFormValue($row['po']);
        }
        if (isset($row['po_return'])) { // po_return
            $this->po_return->setFormValue($row['po_return']);
        }
        if (isset($row['company_id'])) { // company_id
            $this->company_id->setFormValue($row['company_id']);
        }
        if (isset($row['rid_return'])) { // rid_return
            $this->rid_return->setFormValue($row['rid_return']);
        }
        if (isset($row['rid'])) { // rid
            $this->rid->setFormValue($row['rid']);
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->setFormValue($row['packing_type']);
        }
        if (isset($row['lot_no'])) { // lot_no
            $this->lot_no->setFormValue($row['lot_no']);
        }
        if (isset($row['packets'])) { // packets
            $this->packets->setFormValue($row['packets']);
        }
        if (isset($row['net_weight'])) { // net_weight
            $this->net_weight->setFormValue($row['net_weight']);
        }
        if (isset($row['@'])) { // @
            $this->_40->setFormValue($row['@']);
        }
        if (isset($row['amount'])) { // amount
            $this->amount->setFormValue($row['amount']);
        }
        if (isset($row['godown'])) { // godown
            $this->godown->setFormValue($row['godown']);
        }
        if (isset($row['dated'])) { // dated
            $this->dated->setFormValue($row['dated']);
        }
        if (isset($row['operator'])) { // operator
            $this->operator->setFormValue($row['operator']);
        }
        if (isset($row['rack'])) { // rack
            $this->rack->setFormValue($row['rack']);
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->setFormValue($row['datetime']);
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->setFormValue($row['remarks']);
        }
        if (isset($row['goods_inward'])) { // goods_inward
            $this->goods_inward->setFormValue($row['goods_inward']);
        }
        if (isset($row['invoice_details'])) { // invoice_details
            $this->invoice_details->setFormValue($row['invoice_details']);
        }
        if (isset($row['invoice_dated'])) { // invoice_dated
            $this->invoice_dated->setFormValue($row['invoice_dated']);
        }
        if (isset($row['return_details'])) { // return_details
            $this->return_details->setFormValue($row['return_details']);
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchasellist"), "", $this->TableVar, true);
        $pageId = ($this->isCopy()) ? "Copy" : "Add";
        $Breadcrumb->add("add", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_po_return":
                    break;
                case "x_company_id":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_s_grp":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_product":
                    break;
                case "x_rid_return":
                    break;
                case "x_rid":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_lot_no":
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_importer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad() {
    	//echo "Page Load";
    	$CUID = CurrentUserID();
    	$row = ExecuteRow("SELECT `supplier`, `grp`, `s_grp`, `product`, `invoice_details`, `invoice_dated` from  `purchase_l` WHERE `operator` =  $CUID order by `id` DESC  LIMIT 1");
    	(isset($row['supplier']))? setcookie("sup", $row['supplier']) : setcookie("sup", '');	
    	(isset($row['grp']))? setcookie("grp", $row['grp']) : setcookie("grp", '');
    	(isset($row['s_grp']))? setcookie("s_grp", $row['s_grp']) : setcookie("s_grp", '');		
    	(isset($row['product']))? setcookie("product", $row['product']) : setcookie("product", '');
    	(isset($row['invoice_details']))? setcookie("ino", $row['invoice_details']) : setcookie("ino", '');
    	(isset($row['invoice_dated']))? setcookie("ind", $row['invoice_dated']) : setcookie("ind", '');	
    }

    // Page Unload event
    public function pageUnload() {
    	//echo "Page Unload";
    	$CUID = CurrentUserID();
    	$row = ExecuteRow("SELECT `supplier`, `grp`, `s_grp`, `product`, `invoice_details`, `invoice_dated` from  `purchase_l` WHERE `operator` =  $CUID order by `id` DESC  LIMIT 1");
    	(isset($row['supplier']))? setcookie("sup", $row['supplier']) : setcookie("sup", '');	
    	(isset($row['grp']))? setcookie("grp", $row['grp']) : setcookie("grp", '');
    	(isset($row['s_grp']))? setcookie("s_grp", $row['s_grp']) : setcookie("s_grp", '');		
    	(isset($row['product']))? setcookie("product", $row['product']) : setcookie("product", '');
    	(isset($row['invoice_details']))? setcookie("ino", $row['invoice_details']) : setcookie("ino", '');
    	(isset($row['invoice_dated']))? setcookie("ind", $row['invoice_dated']) : setcookie("ind", '');	
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender() {
    	//echo "Page Render";
    	PageFieldValidate($this,'purchase_l');
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError) {
    	// Return error message in CustomError
    	extract($_POST,EXTR_OVERWRITE);
    	$_SESSION[SESSION_MESSAGE] = '';
    	if (($x_type == 72) && (($x_po == '') || ($x_po == null))) 
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= 'Please Select Required Field PO';
    		}
    	if (($x_type != 73) && (($x_rid == '') || ($x_rid == null))) 
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= 'Please Select Required Field Code';
    		}
    	if (($x_type == 73) && (($x_rid_return == '') || ($x_rid_return == null))) 
    		{
    		$_SESSION[SESSION_WARNING_MESSAGE].= 'Please Select Required Field Code';
    		}
    IF ($_SESSION[SESSION_WARNING_MESSAGE] == '')
    {return true;}
    else
    {return false;}
    }
}
