<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PurchaseASearch extends PurchaseA
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PurchaseASearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "purchaseasearch";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->supplier->setVisibility();
        $this->booking_reference->setVisibility();
        $this->rid->Visible = false;
        $this->lot_no->setVisibility();
        $this->gross_weight->setVisibility();
        $this->net_weight->setVisibility();
        $this->packets->setVisibility();
        $this->packing_type->setVisibility();
        $this->containers->setVisibility();
        $this->shipping_line->setVisibility();
        $this->port_arrival_date->setVisibility();
        $this->godown_arrival_date->setVisibility();
        $this->godown->setVisibility();
        $this->rack->setVisibility();
        $this->invoice_details->setVisibility();
        $this->invoice_value->setVisibility();
        $this->currency_rate->setVisibility();
        $this->purchase_amount_inr->setVisibility();
        $this->duty_paid_by->setVisibility();
        $this->custom_duty->setVisibility();
        $this->transportation_charges->setVisibility();
        $this->port_clearing_charge->setVisibility();
        $this->cha_commission->setVisibility();
        $this->cha_agent->setVisibility();
        $this->clearance_bank->setVisibility();
        $this->bank_charges->setVisibility();
        $this->importer->setVisibility();
        $this->remarks->setVisibility();
        $this->fiba_fibd->setVisibility();
        $this->fibc->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->updated->Visible = false;
        $this->grp->Visible = false;
        $this->qc_remarks->Visible = false;
        $this->qc_status->Visible = false;
        $this->qc_operator->Visible = false;
        $this->qc_datetime->Visible = false;
        $this->rbi_compliance_date->Visible = false;
        $this->age->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'purchase_a';
        $this->TableName = 'purchase_a';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (purchase_a)
        if (!isset($GLOBALS["purchase_a"]) || $GLOBALS["purchase_a"]::class == PROJECT_NAMESPACE . "purchase_a") {
            $GLOBALS["purchase_a"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_a');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "purchaseaview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->booking_reference);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->shipping_line);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->duty_paid_by);
        $this->setupLookupOptions($this->cha_agent);
        $this->setupLookupOptions($this->clearance_bank);
        $this->setupLookupOptions($this->importer);
        $this->setupLookupOptions($this->operator);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "purchasealist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->id); // id
        $this->buildSearchUrl($srchUrl, $this->supplier); // supplier
        $this->buildSearchUrl($srchUrl, $this->booking_reference); // booking_reference
        $this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
        $this->buildSearchUrl($srchUrl, $this->gross_weight); // gross_weight
        $this->buildSearchUrl($srchUrl, $this->net_weight); // net_weight
        $this->buildSearchUrl($srchUrl, $this->packets); // packets
        $this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
        $this->buildSearchUrl($srchUrl, $this->containers); // containers
        $this->buildSearchUrl($srchUrl, $this->shipping_line); // shipping_line
        $this->buildSearchUrl($srchUrl, $this->port_arrival_date); // port_arrival_date
        $this->buildSearchUrl($srchUrl, $this->godown_arrival_date); // godown_arrival_date
        $this->buildSearchUrl($srchUrl, $this->godown); // godown
        $this->buildSearchUrl($srchUrl, $this->rack); // rack
        $this->buildSearchUrl($srchUrl, $this->invoice_details); // invoice_details
        $this->buildSearchUrl($srchUrl, $this->invoice_value); // invoice_value
        $this->buildSearchUrl($srchUrl, $this->currency_rate); // currency_rate
        $this->buildSearchUrl($srchUrl, $this->purchase_amount_inr); // purchase_amount_inr
        $this->buildSearchUrl($srchUrl, $this->duty_paid_by); // duty_paid_by
        $this->buildSearchUrl($srchUrl, $this->custom_duty); // custom_duty
        $this->buildSearchUrl($srchUrl, $this->transportation_charges); // transportation_charges
        $this->buildSearchUrl($srchUrl, $this->port_clearing_charge); // port_clearing_charge
        $this->buildSearchUrl($srchUrl, $this->cha_commission); // cha_commission
        $this->buildSearchUrl($srchUrl, $this->cha_agent); // cha_agent
        $this->buildSearchUrl($srchUrl, $this->clearance_bank); // clearance_bank
        $this->buildSearchUrl($srchUrl, $this->bank_charges); // bank_charges
        $this->buildSearchUrl($srchUrl, $this->importer); // importer
        $this->buildSearchUrl($srchUrl, $this->remarks); // remarks
        $this->buildSearchUrl($srchUrl, $this->fiba_fibd); // fiba_fibd
        $this->buildSearchUrl($srchUrl, $this->fibc); // fibc
        $this->buildSearchUrl($srchUrl, $this->operator); // operator
        $this->buildSearchUrl($srchUrl, $this->datetime); // datetime
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // id
        if ($this->id->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // supplier
        if ($this->supplier->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // booking_reference
        if ($this->booking_reference->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // lot_no
        if ($this->lot_no->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // gross_weight
        if ($this->gross_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // net_weight
        if ($this->net_weight->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packets
        if ($this->packets->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // packing_type
        if ($this->packing_type->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // containers
        if ($this->containers->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // shipping_line
        if ($this->shipping_line->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // port_arrival_date
        if ($this->port_arrival_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // godown_arrival_date
        if ($this->godown_arrival_date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // godown
        if ($this->godown->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // rack
        if ($this->rack->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_details
        if ($this->invoice_details->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // invoice_value
        if ($this->invoice_value->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // currency_rate
        if ($this->currency_rate->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // purchase_amount_inr
        if ($this->purchase_amount_inr->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // duty_paid_by
        if ($this->duty_paid_by->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // custom_duty
        if ($this->custom_duty->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // transportation_charges
        if ($this->transportation_charges->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // port_clearing_charge
        if ($this->port_clearing_charge->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cha_commission
        if ($this->cha_commission->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // cha_agent
        if ($this->cha_agent->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // clearance_bank
        if ($this->clearance_bank->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // bank_charges
        if ($this->bank_charges->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // importer
        if ($this->importer->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // remarks
        if ($this->remarks->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fiba_fibd
        if ($this->fiba_fibd->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // fibc
        if ($this->fibc->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // operator
        if ($this->operator->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // datetime
        if ($this->datetime->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // booking_reference
        $this->booking_reference->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // gross_weight
        $this->gross_weight->RowCssClass = "row";

        // net_weight
        $this->net_weight->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // containers
        $this->containers->RowCssClass = "row";

        // shipping_line
        $this->shipping_line->RowCssClass = "row";

        // port_arrival_date
        $this->port_arrival_date->RowCssClass = "row";

        // godown_arrival_date
        $this->godown_arrival_date->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // rack
        $this->rack->RowCssClass = "row";

        // invoice_details
        $this->invoice_details->RowCssClass = "row";

        // invoice_value
        $this->invoice_value->RowCssClass = "row";

        // currency_rate
        $this->currency_rate->RowCssClass = "row";

        // purchase_amount_inr
        $this->purchase_amount_inr->RowCssClass = "row";

        // duty_paid_by
        $this->duty_paid_by->RowCssClass = "row";

        // custom_duty
        $this->custom_duty->RowCssClass = "row";

        // transportation_charges
        $this->transportation_charges->RowCssClass = "row";

        // port_clearing_charge
        $this->port_clearing_charge->RowCssClass = "row";

        // cha_commission
        $this->cha_commission->RowCssClass = "row";

        // cha_agent
        $this->cha_agent->RowCssClass = "row";

        // clearance_bank
        $this->clearance_bank->RowCssClass = "row";

        // bank_charges
        $this->bank_charges->RowCssClass = "row";

        // importer
        $this->importer->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // fiba_fibd
        $this->fiba_fibd->RowCssClass = "row";

        // fibc
        $this->fibc->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // qc_remarks
        $this->qc_remarks->RowCssClass = "row";

        // qc_status
        $this->qc_status->RowCssClass = "row";

        // qc_operator
        $this->qc_operator->RowCssClass = "row";

        // qc_datetime
        $this->qc_datetime->RowCssClass = "row";

        // rbi_compliance_date
        $this->rbi_compliance_date->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // supplier
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->ViewValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->ViewValue = null;
            }

            // booking_reference
            $curVal = strval($this->booking_reference->CurrentValue);
            if ($curVal != "") {
                $this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
                if ($this->booking_reference->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_reference->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_reference->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->booking_reference->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_reference->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
                    } else {
                        $this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
                    }
                }
            } else {
                $this->booking_reference->ViewValue = null;
            }

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // gross_weight
            $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
            $this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, $this->gross_weight->formatPattern());

            // net_weight
            $this->net_weight->ViewValue = $this->net_weight->CurrentValue;
            $this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, $this->net_weight->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // containers
            $this->containers->ViewValue = $this->containers->CurrentValue;
            $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());

            // shipping_line
            $curVal = strval($this->shipping_line->CurrentValue);
            if ($curVal != "") {
                $this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
                if ($this->shipping_line->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shipping_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shipping_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->shipping_line->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shipping_line->Lookup->renderViewRow($rswrk[0]);
                        $this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
                    } else {
                        $this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
                    }
                }
            } else {
                $this->shipping_line->ViewValue = null;
            }

            // port_arrival_date
            $this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
            $this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, $this->port_arrival_date->formatPattern());

            // godown_arrival_date
            $this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
            $this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, $this->godown_arrival_date->formatPattern());

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // rack
            $this->rack->ViewValue = $this->rack->CurrentValue;

            // invoice_details
            $this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;

            // invoice_value
            $this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
            $this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, $this->invoice_value->formatPattern());

            // currency_rate
            $this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
            $this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, $this->currency_rate->formatPattern());

            // purchase_amount_inr
            $this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
            $this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, $this->purchase_amount_inr->formatPattern());

            // duty_paid_by
            if (strval($this->duty_paid_by->CurrentValue) != "") {
                $this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
            } else {
                $this->duty_paid_by->ViewValue = null;
            }

            // custom_duty
            $this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
            $this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, $this->custom_duty->formatPattern());

            // transportation_charges
            $this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
            $this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, $this->transportation_charges->formatPattern());

            // port_clearing_charge
            $this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
            $this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, $this->port_clearing_charge->formatPattern());

            // cha_commission
            $this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
            $this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, $this->cha_commission->formatPattern());

            // cha_agent
            $curVal = strval($this->cha_agent->CurrentValue);
            if ($curVal != "") {
                $this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
                if ($this->cha_agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->cha_agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->cha_agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->cha_agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->cha_agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->cha_agent->Lookup->renderViewRow($rswrk[0]);
                        $this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
                    } else {
                        $this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
                    }
                }
            } else {
                $this->cha_agent->ViewValue = null;
            }

            // clearance_bank
            $curVal = strval($this->clearance_bank->CurrentValue);
            if ($curVal != "") {
                $this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
                if ($this->clearance_bank->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->clearance_bank->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->clearance_bank->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->clearance_bank->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->clearance_bank->Lookup->renderViewRow($rswrk[0]);
                        $this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
                    } else {
                        $this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
                    }
                }
            } else {
                $this->clearance_bank->ViewValue = null;
            }

            // bank_charges
            $this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
            $this->bank_charges->ViewValue = FormatNumber($this->bank_charges->ViewValue, $this->bank_charges->formatPattern());

            // importer
            $curVal = strval($this->importer->CurrentValue);
            if ($curVal != "") {
                $this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
                if ($this->importer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->importer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->importer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->importer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->importer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->importer->Lookup->renderViewRow($rswrk[0]);
                        $this->importer->ViewValue = $this->importer->displayValue($arwrk);
                    } else {
                        $this->importer->ViewValue = $this->importer->CurrentValue;
                    }
                }
            } else {
                $this->importer->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // fiba_fibd
            $this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;

            // fibc
            $this->fibc->ViewValue = $this->fibc->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";
            $this->id->TooltipValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // booking_reference
            $this->booking_reference->HrefValue = "";
            $this->booking_reference->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // gross_weight
            $this->gross_weight->HrefValue = "";
            $this->gross_weight->TooltipValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";
            $this->net_weight->TooltipValue = "";

            // packets
            $this->packets->HrefValue = "";
            $this->packets->TooltipValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }
            $this->packing_type->TooltipValue = "";

            // containers
            $this->containers->HrefValue = "";
            $this->containers->TooltipValue = "";

            // shipping_line
            $this->shipping_line->HrefValue = "";
            $this->shipping_line->TooltipValue = "";

            // port_arrival_date
            $this->port_arrival_date->HrefValue = "";
            $this->port_arrival_date->TooltipValue = "";

            // godown_arrival_date
            $this->godown_arrival_date->HrefValue = "";
            $this->godown_arrival_date->TooltipValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }
            $this->godown->TooltipValue = "";

            // rack
            $this->rack->HrefValue = "";
            $this->rack->TooltipValue = "";

            // invoice_details
            $this->invoice_details->HrefValue = "";
            $this->invoice_details->TooltipValue = "";

            // invoice_value
            $this->invoice_value->HrefValue = "";
            $this->invoice_value->TooltipValue = "";

            // currency_rate
            $this->currency_rate->HrefValue = "";
            $this->currency_rate->TooltipValue = "";

            // purchase_amount_inr
            $this->purchase_amount_inr->HrefValue = "";
            $this->purchase_amount_inr->TooltipValue = "";

            // duty_paid_by
            $this->duty_paid_by->HrefValue = "";
            $this->duty_paid_by->TooltipValue = "";

            // custom_duty
            $this->custom_duty->HrefValue = "";
            $this->custom_duty->TooltipValue = "";

            // transportation_charges
            $this->transportation_charges->HrefValue = "";
            $this->transportation_charges->TooltipValue = "";

            // port_clearing_charge
            $this->port_clearing_charge->HrefValue = "";
            $this->port_clearing_charge->TooltipValue = "";

            // cha_commission
            $this->cha_commission->HrefValue = "";
            $this->cha_commission->TooltipValue = "";

            // cha_agent
            $this->cha_agent->HrefValue = "";
            $this->cha_agent->TooltipValue = "";

            // clearance_bank
            $this->clearance_bank->HrefValue = "";
            $this->clearance_bank->TooltipValue = "";

            // bank_charges
            $this->bank_charges->HrefValue = "";
            $this->bank_charges->TooltipValue = "";

            // importer
            $this->importer->HrefValue = "";
            $this->importer->TooltipValue = "";

            // remarks
            $this->remarks->HrefValue = "";
            $this->remarks->TooltipValue = "";

            // fiba_fibd
            $this->fiba_fibd->HrefValue = "";
            $this->fiba_fibd->TooltipValue = "";

            // fibc
            $this->fibc->HrefValue = "";
            $this->fibc->TooltipValue = "";

            // operator
            $this->operator->HrefValue = "";
            $this->operator->TooltipValue = "";

            // datetime
            $this->datetime->HrefValue = "";
            $this->datetime->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->AdvancedSearch->SearchValue;
            $this->id->PlaceHolder = RemoveHtml($this->id->caption());

            // supplier
            $this->supplier->setupEditAttributes();
            $curVal = trim(strval($this->supplier->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->supplier->AdvancedSearch->ViewValue = $this->supplier->lookupCacheOption($curVal);
            } else {
                $this->supplier->AdvancedSearch->ViewValue = $this->supplier->Lookup !== null && is_array($this->supplier->lookupOptions()) && count($this->supplier->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->supplier->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->supplier->EditValue = array_values($this->supplier->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->supplier->AdvancedSearch->SearchValue, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->supplier->EditValue = $arwrk;
            }
            $this->supplier->PlaceHolder = RemoveHtml($this->supplier->caption());

            // booking_reference
            $this->booking_reference->setupEditAttributes();
            $curVal = trim(strval($this->booking_reference->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->booking_reference->AdvancedSearch->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
            } else {
                $this->booking_reference->AdvancedSearch->ViewValue = $this->booking_reference->Lookup !== null && is_array($this->booking_reference->lookupOptions()) && count($this->booking_reference->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->booking_reference->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->booking_reference->EditValue = array_values($this->booking_reference->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->booking_reference->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->booking_reference->AdvancedSearch->SearchValue, $this->booking_reference->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->booking_reference->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->booking_reference->EditValue = $arwrk;
            }
            $this->booking_reference->PlaceHolder = RemoveHtml($this->booking_reference->caption());

            // lot_no
            $this->lot_no->setupEditAttributes();
            if (!$this->lot_no->Raw) {
                $this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
            }
            $this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
            $this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

            // gross_weight
            $this->gross_weight->setupEditAttributes();
            $this->gross_weight->EditValue = $this->gross_weight->AdvancedSearch->SearchValue;
            $this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());

            // net_weight
            $this->net_weight->setupEditAttributes();
            $this->net_weight->EditValue = $this->net_weight->AdvancedSearch->SearchValue;
            $this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
            $this->net_weight->setupEditAttributes();
            $this->net_weight->EditValue2 = $this->net_weight->AdvancedSearch->SearchValue2;
            $this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->AdvancedSearch->SearchValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            $this->packets->setupEditAttributes();
            $this->packets->EditValue2 = $this->packets->AdvancedSearch->SearchValue2;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->AdvancedSearch->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->AdvancedSearch->SearchValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // containers
            $this->containers->setupEditAttributes();
            $this->containers->EditValue = $this->containers->AdvancedSearch->SearchValue;
            $this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
            $this->containers->setupEditAttributes();
            $this->containers->EditValue2 = $this->containers->AdvancedSearch->SearchValue2;
            $this->containers->PlaceHolder = RemoveHtml($this->containers->caption());

            // shipping_line
            $this->shipping_line->setupEditAttributes();
            $curVal = trim(strval($this->shipping_line->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->shipping_line->AdvancedSearch->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
            } else {
                $this->shipping_line->AdvancedSearch->ViewValue = $this->shipping_line->Lookup !== null && is_array($this->shipping_line->lookupOptions()) && count($this->shipping_line->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shipping_line->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->shipping_line->EditValue = array_values($this->shipping_line->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shipping_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shipping_line->AdvancedSearch->SearchValue, $this->shipping_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->shipping_line->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shipping_line->EditValue = $arwrk;
            }
            $this->shipping_line->PlaceHolder = RemoveHtml($this->shipping_line->caption());

            // port_arrival_date
            $this->port_arrival_date->setupEditAttributes();
            $this->port_arrival_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->port_arrival_date->AdvancedSearch->SearchValue, $this->port_arrival_date->formatPattern()), $this->port_arrival_date->formatPattern()));
            $this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());
            $this->port_arrival_date->setupEditAttributes();
            $this->port_arrival_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->port_arrival_date->AdvancedSearch->SearchValue2, $this->port_arrival_date->formatPattern()), $this->port_arrival_date->formatPattern()));
            $this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());

            // godown_arrival_date
            $this->godown_arrival_date->setupEditAttributes();
            $this->godown_arrival_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->godown_arrival_date->AdvancedSearch->SearchValue, $this->godown_arrival_date->formatPattern()), $this->godown_arrival_date->formatPattern()));
            $this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());
            $this->godown_arrival_date->setupEditAttributes();
            $this->godown_arrival_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->godown_arrival_date->AdvancedSearch->SearchValue2, $this->godown_arrival_date->formatPattern()), $this->godown_arrival_date->formatPattern()));
            $this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->godown->AdvancedSearch->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->AdvancedSearch->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->AdvancedSearch->SearchValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // rack
            $this->rack->setupEditAttributes();
            if (!$this->rack->Raw) {
                $this->rack->AdvancedSearch->SearchValue = HtmlDecode($this->rack->AdvancedSearch->SearchValue);
            }
            $this->rack->EditValue = HtmlEncode($this->rack->AdvancedSearch->SearchValue);
            $this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

            // invoice_details
            $this->invoice_details->setupEditAttributes();
            if (!$this->invoice_details->Raw) {
                $this->invoice_details->AdvancedSearch->SearchValue = HtmlDecode($this->invoice_details->AdvancedSearch->SearchValue);
            }
            $this->invoice_details->EditValue = HtmlEncode($this->invoice_details->AdvancedSearch->SearchValue);
            $this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

            // invoice_value
            $this->invoice_value->setupEditAttributes();
            $this->invoice_value->EditValue = $this->invoice_value->AdvancedSearch->SearchValue;
            $this->invoice_value->PlaceHolder = RemoveHtml($this->invoice_value->caption());

            // currency_rate
            $this->currency_rate->setupEditAttributes();
            $this->currency_rate->EditValue = $this->currency_rate->AdvancedSearch->SearchValue;
            $this->currency_rate->PlaceHolder = RemoveHtml($this->currency_rate->caption());

            // purchase_amount_inr
            $this->purchase_amount_inr->setupEditAttributes();
            $this->purchase_amount_inr->EditValue = $this->purchase_amount_inr->AdvancedSearch->SearchValue;
            $this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());
            $this->purchase_amount_inr->setupEditAttributes();
            $this->purchase_amount_inr->EditValue2 = $this->purchase_amount_inr->AdvancedSearch->SearchValue2;
            $this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());

            // duty_paid_by
            $this->duty_paid_by->setupEditAttributes();
            $this->duty_paid_by->EditValue = $this->duty_paid_by->options(true);
            $this->duty_paid_by->PlaceHolder = RemoveHtml($this->duty_paid_by->caption());

            // custom_duty
            $this->custom_duty->setupEditAttributes();
            $this->custom_duty->EditValue = $this->custom_duty->AdvancedSearch->SearchValue;
            $this->custom_duty->PlaceHolder = RemoveHtml($this->custom_duty->caption());

            // transportation_charges
            $this->transportation_charges->setupEditAttributes();
            $this->transportation_charges->EditValue = $this->transportation_charges->AdvancedSearch->SearchValue;
            $this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());

            // port_clearing_charge
            $this->port_clearing_charge->setupEditAttributes();
            $this->port_clearing_charge->EditValue = $this->port_clearing_charge->AdvancedSearch->SearchValue;
            $this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());

            // cha_commission
            $this->cha_commission->setupEditAttributes();
            $this->cha_commission->EditValue = $this->cha_commission->AdvancedSearch->SearchValue;
            $this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());

            // cha_agent
            $this->cha_agent->setupEditAttributes();
            $curVal = trim(strval($this->cha_agent->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->cha_agent->AdvancedSearch->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
            } else {
                $this->cha_agent->AdvancedSearch->ViewValue = $this->cha_agent->Lookup !== null && is_array($this->cha_agent->lookupOptions()) && count($this->cha_agent->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->cha_agent->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->cha_agent->EditValue = array_values($this->cha_agent->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->cha_agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->cha_agent->AdvancedSearch->SearchValue, $this->cha_agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->cha_agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->cha_agent->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->cha_agent->EditValue = $arwrk;
            }
            $this->cha_agent->PlaceHolder = RemoveHtml($this->cha_agent->caption());

            // clearance_bank
            $this->clearance_bank->setupEditAttributes();
            $curVal = trim(strval($this->clearance_bank->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->clearance_bank->AdvancedSearch->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
            } else {
                $this->clearance_bank->AdvancedSearch->ViewValue = $this->clearance_bank->Lookup !== null && is_array($this->clearance_bank->lookupOptions()) && count($this->clearance_bank->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->clearance_bank->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->clearance_bank->EditValue = array_values($this->clearance_bank->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->clearance_bank->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->clearance_bank->AdvancedSearch->SearchValue, $this->clearance_bank->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->clearance_bank->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->clearance_bank->EditValue = $arwrk;
            }
            $this->clearance_bank->PlaceHolder = RemoveHtml($this->clearance_bank->caption());

            // bank_charges
            $this->bank_charges->setupEditAttributes();
            $this->bank_charges->EditValue = $this->bank_charges->AdvancedSearch->SearchValue;
            $this->bank_charges->PlaceHolder = RemoveHtml($this->bank_charges->caption());

            // importer
            $this->importer->setupEditAttributes();
            $curVal = trim(strval($this->importer->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->importer->AdvancedSearch->ViewValue = $this->importer->lookupCacheOption($curVal);
            } else {
                $this->importer->AdvancedSearch->ViewValue = $this->importer->Lookup !== null && is_array($this->importer->lookupOptions()) && count($this->importer->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->importer->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->importer->EditValue = array_values($this->importer->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->importer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->importer->AdvancedSearch->SearchValue, $this->importer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->importer->getSelectFilter($this); // PHP
                $sqlWrk = $this->importer->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->importer->EditValue = $arwrk;
            }
            $this->importer->PlaceHolder = RemoveHtml($this->importer->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // fiba_fibd
            $this->fiba_fibd->setupEditAttributes();
            if (!$this->fiba_fibd->Raw) {
                $this->fiba_fibd->AdvancedSearch->SearchValue = HtmlDecode($this->fiba_fibd->AdvancedSearch->SearchValue);
            }
            $this->fiba_fibd->EditValue = HtmlEncode($this->fiba_fibd->AdvancedSearch->SearchValue);
            $this->fiba_fibd->PlaceHolder = RemoveHtml($this->fiba_fibd->caption());

            // fibc
            $this->fibc->setupEditAttributes();
            if (!$this->fibc->Raw) {
                $this->fibc->AdvancedSearch->SearchValue = HtmlDecode($this->fibc->AdvancedSearch->SearchValue);
            }
            $this->fibc->EditValue = HtmlEncode($this->fibc->AdvancedSearch->SearchValue);
            $this->fibc->PlaceHolder = RemoveHtml($this->fibc->caption());

            // operator
            $this->operator->setupEditAttributes();
            $curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
            } else {
                $this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== null && is_array($this->operator->lookupOptions()) && count($this->operator->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->operator->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->operator->EditValue = array_values($this->operator->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->operator->AdvancedSearch->SearchValue, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->operator->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->operator->EditValue = $arwrk;
            }
            $this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

            // datetime
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
            $this->datetime->setupEditAttributes();
            $this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, $this->datetime->formatPattern()), $this->datetime->formatPattern()));
            $this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
            $this->id->addErrorMessage($this->id->getErrorMessage(false));
        }
        if (!CheckNumber($this->gross_weight->AdvancedSearch->SearchValue)) {
            $this->gross_weight->addErrorMessage($this->gross_weight->getErrorMessage(false));
        }
        if (!CheckNumber($this->net_weight->AdvancedSearch->SearchValue)) {
            $this->net_weight->addErrorMessage($this->net_weight->getErrorMessage(false));
        }
        if (!CheckNumber($this->net_weight->AdvancedSearch->SearchValue2)) {
            $this->net_weight->addErrorMessage($this->net_weight->getErrorMessage(false));
        }
        if (!CheckInteger($this->packets->AdvancedSearch->SearchValue)) {
            $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
        }
        if (!CheckInteger($this->packets->AdvancedSearch->SearchValue2)) {
            $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
        }
        if (!CheckNumber($this->containers->AdvancedSearch->SearchValue)) {
            $this->containers->addErrorMessage($this->containers->getErrorMessage(false));
        }
        if (!CheckNumber($this->containers->AdvancedSearch->SearchValue2)) {
            $this->containers->addErrorMessage($this->containers->getErrorMessage(false));
        }
        if (!CheckDate($this->port_arrival_date->AdvancedSearch->SearchValue, $this->port_arrival_date->formatPattern())) {
            $this->port_arrival_date->addErrorMessage($this->port_arrival_date->getErrorMessage(false));
        }
        if (!CheckDate($this->port_arrival_date->AdvancedSearch->SearchValue2, $this->port_arrival_date->formatPattern())) {
            $this->port_arrival_date->addErrorMessage($this->port_arrival_date->getErrorMessage(false));
        }
        if (!CheckDate($this->godown_arrival_date->AdvancedSearch->SearchValue, $this->godown_arrival_date->formatPattern())) {
            $this->godown_arrival_date->addErrorMessage($this->godown_arrival_date->getErrorMessage(false));
        }
        if (!CheckDate($this->godown_arrival_date->AdvancedSearch->SearchValue2, $this->godown_arrival_date->formatPattern())) {
            $this->godown_arrival_date->addErrorMessage($this->godown_arrival_date->getErrorMessage(false));
        }
        if (!CheckNumber($this->invoice_value->AdvancedSearch->SearchValue)) {
            $this->invoice_value->addErrorMessage($this->invoice_value->getErrorMessage(false));
        }
        if (!CheckNumber($this->currency_rate->AdvancedSearch->SearchValue)) {
            $this->currency_rate->addErrorMessage($this->currency_rate->getErrorMessage(false));
        }
        if (!CheckNumber($this->purchase_amount_inr->AdvancedSearch->SearchValue)) {
            $this->purchase_amount_inr->addErrorMessage($this->purchase_amount_inr->getErrorMessage(false));
        }
        if (!CheckNumber($this->purchase_amount_inr->AdvancedSearch->SearchValue2)) {
            $this->purchase_amount_inr->addErrorMessage($this->purchase_amount_inr->getErrorMessage(false));
        }
        if (!CheckNumber($this->custom_duty->AdvancedSearch->SearchValue)) {
            $this->custom_duty->addErrorMessage($this->custom_duty->getErrorMessage(false));
        }
        if (!CheckNumber($this->transportation_charges->AdvancedSearch->SearchValue)) {
            $this->transportation_charges->addErrorMessage($this->transportation_charges->getErrorMessage(false));
        }
        if (!CheckNumber($this->port_clearing_charge->AdvancedSearch->SearchValue)) {
            $this->port_clearing_charge->addErrorMessage($this->port_clearing_charge->getErrorMessage(false));
        }
        if (!CheckNumber($this->cha_commission->AdvancedSearch->SearchValue)) {
            $this->cha_commission->addErrorMessage($this->cha_commission->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->id->AdvancedSearch->load();
        $this->supplier->AdvancedSearch->load();
        $this->booking_reference->AdvancedSearch->load();
        $this->lot_no->AdvancedSearch->load();
        $this->gross_weight->AdvancedSearch->load();
        $this->net_weight->AdvancedSearch->load();
        $this->packets->AdvancedSearch->load();
        $this->packing_type->AdvancedSearch->load();
        $this->containers->AdvancedSearch->load();
        $this->shipping_line->AdvancedSearch->load();
        $this->port_arrival_date->AdvancedSearch->load();
        $this->godown_arrival_date->AdvancedSearch->load();
        $this->godown->AdvancedSearch->load();
        $this->rack->AdvancedSearch->load();
        $this->invoice_details->AdvancedSearch->load();
        $this->invoice_value->AdvancedSearch->load();
        $this->currency_rate->AdvancedSearch->load();
        $this->purchase_amount_inr->AdvancedSearch->load();
        $this->duty_paid_by->AdvancedSearch->load();
        $this->custom_duty->AdvancedSearch->load();
        $this->transportation_charges->AdvancedSearch->load();
        $this->port_clearing_charge->AdvancedSearch->load();
        $this->cha_commission->AdvancedSearch->load();
        $this->cha_agent->AdvancedSearch->load();
        $this->clearance_bank->AdvancedSearch->load();
        $this->bank_charges->AdvancedSearch->load();
        $this->importer->AdvancedSearch->load();
        $this->remarks->AdvancedSearch->load();
        $this->fiba_fibd->AdvancedSearch->load();
        $this->fibc->AdvancedSearch->load();
        $this->operator->AdvancedSearch->load();
        $this->datetime->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchasealist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_booking_reference":
                    break;
                case "x_rid":
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_line":
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_duty_paid_by":
                    break;
                case "x_cha_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_clearance_bank":
                    break;
                case "x_importer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
