<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PurchaseAEdit extends PurchaseA
{
    use MessagesTrait;

    // Page ID
    public $PageID = "edit";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PurchaseAEdit";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "purchaseaedit";

    // Audit Trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->id->setVisibility();
        $this->supplier->setVisibility();
        $this->booking_reference->setVisibility();
        $this->rid->setVisibility();
        $this->lot_no->setVisibility();
        $this->gross_weight->setVisibility();
        $this->net_weight->setVisibility();
        $this->packets->setVisibility();
        $this->packing_type->setVisibility();
        $this->containers->setVisibility();
        $this->shipping_line->setVisibility();
        $this->port_arrival_date->setVisibility();
        $this->godown_arrival_date->setVisibility();
        $this->godown->setVisibility();
        $this->rack->setVisibility();
        $this->invoice_details->setVisibility();
        $this->invoice_value->setVisibility();
        $this->currency_rate->setVisibility();
        $this->purchase_amount_inr->setVisibility();
        $this->duty_paid_by->setVisibility();
        $this->custom_duty->setVisibility();
        $this->transportation_charges->setVisibility();
        $this->port_clearing_charge->setVisibility();
        $this->cha_commission->setVisibility();
        $this->cha_agent->setVisibility();
        $this->clearance_bank->setVisibility();
        $this->bank_charges->setVisibility();
        $this->importer->setVisibility();
        $this->remarks->setVisibility();
        $this->fiba_fibd->setVisibility();
        $this->fibc->setVisibility();
        $this->operator->setVisibility();
        $this->datetime->setVisibility();
        $this->updated->Visible = false;
        $this->grp->Visible = false;
        $this->qc_remarks->Visible = false;
        $this->qc_status->Visible = false;
        $this->qc_operator->Visible = false;
        $this->qc_datetime->Visible = false;
        $this->rbi_compliance_date->Visible = false;
        $this->age->Visible = false;
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'purchase_a';
        $this->TableName = 'purchase_a';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (purchase_a)
        if (!isset($GLOBALS["purchase_a"]) || $GLOBALS["purchase_a"]::class == PROJECT_NAMESPACE . "purchase_a") {
            $GLOBALS["purchase_a"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'purchase_a');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl())) ||
                    SameString($pageName, GetPageName($this->getViewUrl())) ||
                    SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "purchaseaview"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                        $this->clearFailureMessage();
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['id'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->id->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Properties
    public $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public $IsModal = false;
    public $IsMobileOrModal = false;
    public $DbMasterFilter;
    public $DbDetailFilter;
    public $HashValue; // Hash Value
    public $DisplayRecords = 1;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $RecordCount;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();
        $this->supplier->Required = false;
        $this->booking_reference->Required = false;
        $this->rid->Required = false;
        $this->lot_no->Required = false;

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->supplier);
        $this->setupLookupOptions($this->booking_reference);
        $this->setupLookupOptions($this->rid);
        $this->setupLookupOptions($this->packing_type);
        $this->setupLookupOptions($this->shipping_line);
        $this->setupLookupOptions($this->godown);
        $this->setupLookupOptions($this->duty_paid_by);
        $this->setupLookupOptions($this->cha_agent);
        $this->setupLookupOptions($this->clearance_bank);
        $this->setupLookupOptions($this->importer);
        $this->setupLookupOptions($this->operator);

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = false;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load key values
            $loaded = true;
            if (($keyValue = Get("id") ?? Key(0) ?? Route(2)) !== null) {
                $this->id->setQueryStringValue($keyValue);
                $this->id->setOldValue($this->id->QueryStringValue);
            } elseif (Post("id") !== null) {
                $this->id->setFormValue(Post("id"));
                $this->id->setOldValue($this->id->FormValue);
            } else {
                $loaded = false; // Unable to load key
            }

            // Load record
            if ($loaded) {
                $loaded = $this->loadRow();
            }
            if (!$loaded) {
                $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if (Post("action", "") !== "") {
                $this->CurrentAction = Post("action"); // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey(Post($this->OldKeyName), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from QueryString
                $loadByQuery = false;
                if (($keyValue = Get("id") ?? Route("id")) !== null) {
                    $this->id->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->id->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                    // Load current record
                    $loaded = $this->loadRow();
                $this->OldKey = $loaded ? $this->getKey(true) : ""; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                $this->restoreFormValues();
                if (IsApi()) {
                    $this->terminate();
                    return;
                } else {
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                    if (!$loaded) { // Load record based on key
                        if ($this->getFailureMessage() == "") {
                            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("purchasealist"); // No matching record, return to list
                        return;
                    }
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "purchasealist") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                $this->SendEmail = true; // Send email on update success
                if ($this->editRow()) { // Update record based on key
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "purchasealist") {
                            Container("app.flash")->addMessage("Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "purchasealist"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate(true);
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    WriteJson(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                } elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render the record
        $this->RowType = RowType::EDIT; // Render as Edit
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles()
    {
        global $CurrentForm, $Language;
    }

    // Load form values
    protected function loadFormValues()
    {
        // Load from form
        global $CurrentForm;
        $validate = !Config("SERVER_VALIDATE");

        // Check field name 'id' first before field var 'x_id'
        $val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
        if (!$this->id->IsDetailKey) {
            $this->id->setFormValue($val);
        }

        // Check field name 'supplier' first before field var 'x_supplier'
        $val = $CurrentForm->hasValue("supplier") ? $CurrentForm->getValue("supplier") : $CurrentForm->getValue("x_supplier");
        if (!$this->supplier->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->supplier->Visible = false; // Disable update for API request
            } else {
                $this->supplier->setFormValue($val);
            }
        }

        // Check field name 'booking_reference' first before field var 'x_booking_reference'
        $val = $CurrentForm->hasValue("booking_reference") ? $CurrentForm->getValue("booking_reference") : $CurrentForm->getValue("x_booking_reference");
        if (!$this->booking_reference->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->booking_reference->Visible = false; // Disable update for API request
            } else {
                $this->booking_reference->setFormValue($val);
            }
        }

        // Check field name 'rid' first before field var 'x_rid'
        $val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
        if (!$this->rid->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rid->Visible = false; // Disable update for API request
            } else {
                $this->rid->setFormValue($val);
            }
        }

        // Check field name 'lot_no' first before field var 'x_lot_no'
        $val = $CurrentForm->hasValue("lot_no") ? $CurrentForm->getValue("lot_no") : $CurrentForm->getValue("x_lot_no");
        if (!$this->lot_no->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->lot_no->Visible = false; // Disable update for API request
            } else {
                $this->lot_no->setFormValue($val);
            }
        }

        // Check field name 'gross_weight' first before field var 'x_gross_weight'
        $val = $CurrentForm->hasValue("gross_weight") ? $CurrentForm->getValue("gross_weight") : $CurrentForm->getValue("x_gross_weight");
        if (!$this->gross_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->gross_weight->Visible = false; // Disable update for API request
            } else {
                $this->gross_weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'net_weight' first before field var 'x_net_weight'
        $val = $CurrentForm->hasValue("net_weight") ? $CurrentForm->getValue("net_weight") : $CurrentForm->getValue("x_net_weight");
        if (!$this->net_weight->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->net_weight->Visible = false; // Disable update for API request
            } else {
                $this->net_weight->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packets' first before field var 'x_packets'
        $val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
        if (!$this->packets->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packets->Visible = false; // Disable update for API request
            } else {
                $this->packets->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'packing_type' first before field var 'x_packing_type'
        $val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
        if (!$this->packing_type->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->packing_type->Visible = false; // Disable update for API request
            } else {
                $this->packing_type->setFormValue($val);
            }
        }

        // Check field name 'containers' first before field var 'x_containers'
        $val = $CurrentForm->hasValue("containers") ? $CurrentForm->getValue("containers") : $CurrentForm->getValue("x_containers");
        if (!$this->containers->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->containers->Visible = false; // Disable update for API request
            } else {
                $this->containers->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'shipping_line' first before field var 'x_shipping_line'
        $val = $CurrentForm->hasValue("shipping_line") ? $CurrentForm->getValue("shipping_line") : $CurrentForm->getValue("x_shipping_line");
        if (!$this->shipping_line->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->shipping_line->Visible = false; // Disable update for API request
            } else {
                $this->shipping_line->setFormValue($val);
            }
        }

        // Check field name 'port_arrival_date' first before field var 'x_port_arrival_date'
        $val = $CurrentForm->hasValue("port_arrival_date") ? $CurrentForm->getValue("port_arrival_date") : $CurrentForm->getValue("x_port_arrival_date");
        if (!$this->port_arrival_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_arrival_date->Visible = false; // Disable update for API request
            } else {
                $this->port_arrival_date->setFormValue($val, true, $validate);
            }
            $this->port_arrival_date->CurrentValue = UnFormatDateTime($this->port_arrival_date->CurrentValue, $this->port_arrival_date->formatPattern());
        }

        // Check field name 'godown_arrival_date' first before field var 'x_godown_arrival_date'
        $val = $CurrentForm->hasValue("godown_arrival_date") ? $CurrentForm->getValue("godown_arrival_date") : $CurrentForm->getValue("x_godown_arrival_date");
        if (!$this->godown_arrival_date->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown_arrival_date->Visible = false; // Disable update for API request
            } else {
                $this->godown_arrival_date->setFormValue($val, true, $validate);
            }
            $this->godown_arrival_date->CurrentValue = UnFormatDateTime($this->godown_arrival_date->CurrentValue, $this->godown_arrival_date->formatPattern());
        }

        // Check field name 'godown' first before field var 'x_godown'
        $val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
        if (!$this->godown->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->godown->Visible = false; // Disable update for API request
            } else {
                $this->godown->setFormValue($val);
            }
        }

        // Check field name 'rack' first before field var 'x_rack'
        $val = $CurrentForm->hasValue("rack") ? $CurrentForm->getValue("rack") : $CurrentForm->getValue("x_rack");
        if (!$this->rack->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->rack->Visible = false; // Disable update for API request
            } else {
                $this->rack->setFormValue($val);
            }
        }

        // Check field name 'invoice_details' first before field var 'x_invoice_details'
        $val = $CurrentForm->hasValue("invoice_details") ? $CurrentForm->getValue("invoice_details") : $CurrentForm->getValue("x_invoice_details");
        if (!$this->invoice_details->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_details->Visible = false; // Disable update for API request
            } else {
                $this->invoice_details->setFormValue($val);
            }
        }

        // Check field name 'invoice_value' first before field var 'x_invoice_value'
        $val = $CurrentForm->hasValue("invoice_value") ? $CurrentForm->getValue("invoice_value") : $CurrentForm->getValue("x_invoice_value");
        if (!$this->invoice_value->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->invoice_value->Visible = false; // Disable update for API request
            } else {
                $this->invoice_value->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'currency_rate' first before field var 'x_currency_rate'
        $val = $CurrentForm->hasValue("currency_rate") ? $CurrentForm->getValue("currency_rate") : $CurrentForm->getValue("x_currency_rate");
        if (!$this->currency_rate->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->currency_rate->Visible = false; // Disable update for API request
            } else {
                $this->currency_rate->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'purchase_amount_inr' first before field var 'x_purchase_amount_inr'
        $val = $CurrentForm->hasValue("purchase_amount_inr") ? $CurrentForm->getValue("purchase_amount_inr") : $CurrentForm->getValue("x_purchase_amount_inr");
        if (!$this->purchase_amount_inr->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->purchase_amount_inr->Visible = false; // Disable update for API request
            } else {
                $this->purchase_amount_inr->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'duty_paid_by' first before field var 'x_duty_paid_by'
        $val = $CurrentForm->hasValue("duty_paid_by") ? $CurrentForm->getValue("duty_paid_by") : $CurrentForm->getValue("x_duty_paid_by");
        if (!$this->duty_paid_by->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->duty_paid_by->Visible = false; // Disable update for API request
            } else {
                $this->duty_paid_by->setFormValue($val);
            }
        }

        // Check field name 'custom_duty' first before field var 'x_custom_duty'
        $val = $CurrentForm->hasValue("custom_duty") ? $CurrentForm->getValue("custom_duty") : $CurrentForm->getValue("x_custom_duty");
        if (!$this->custom_duty->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->custom_duty->Visible = false; // Disable update for API request
            } else {
                $this->custom_duty->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'transportation_charges' first before field var 'x_transportation_charges'
        $val = $CurrentForm->hasValue("transportation_charges") ? $CurrentForm->getValue("transportation_charges") : $CurrentForm->getValue("x_transportation_charges");
        if (!$this->transportation_charges->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->transportation_charges->Visible = false; // Disable update for API request
            } else {
                $this->transportation_charges->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'port_clearing_charge' first before field var 'x_port_clearing_charge'
        $val = $CurrentForm->hasValue("port_clearing_charge") ? $CurrentForm->getValue("port_clearing_charge") : $CurrentForm->getValue("x_port_clearing_charge");
        if (!$this->port_clearing_charge->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->port_clearing_charge->Visible = false; // Disable update for API request
            } else {
                $this->port_clearing_charge->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cha_commission' first before field var 'x_cha_commission'
        $val = $CurrentForm->hasValue("cha_commission") ? $CurrentForm->getValue("cha_commission") : $CurrentForm->getValue("x_cha_commission");
        if (!$this->cha_commission->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cha_commission->Visible = false; // Disable update for API request
            } else {
                $this->cha_commission->setFormValue($val, true, $validate);
            }
        }

        // Check field name 'cha_agent' first before field var 'x_cha_agent'
        $val = $CurrentForm->hasValue("cha_agent") ? $CurrentForm->getValue("cha_agent") : $CurrentForm->getValue("x_cha_agent");
        if (!$this->cha_agent->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->cha_agent->Visible = false; // Disable update for API request
            } else {
                $this->cha_agent->setFormValue($val);
            }
        }

        // Check field name 'clearance_bank' first before field var 'x_clearance_bank'
        $val = $CurrentForm->hasValue("clearance_bank") ? $CurrentForm->getValue("clearance_bank") : $CurrentForm->getValue("x_clearance_bank");
        if (!$this->clearance_bank->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->clearance_bank->Visible = false; // Disable update for API request
            } else {
                $this->clearance_bank->setFormValue($val);
            }
        }

        // Check field name 'bank_charges' first before field var 'x_bank_charges'
        $val = $CurrentForm->hasValue("bank_charges") ? $CurrentForm->getValue("bank_charges") : $CurrentForm->getValue("x_bank_charges");
        if (!$this->bank_charges->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->bank_charges->Visible = false; // Disable update for API request
            } else {
                $this->bank_charges->setFormValue($val);
            }
        }

        // Check field name 'importer' first before field var 'x_importer'
        $val = $CurrentForm->hasValue("importer") ? $CurrentForm->getValue("importer") : $CurrentForm->getValue("x_importer");
        if (!$this->importer->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->importer->Visible = false; // Disable update for API request
            } else {
                $this->importer->setFormValue($val);
            }
        }

        // Check field name 'remarks' first before field var 'x_remarks'
        $val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
        if (!$this->remarks->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->remarks->Visible = false; // Disable update for API request
            } else {
                $this->remarks->setFormValue($val);
            }
        }

        // Check field name 'fiba_fibd' first before field var 'x_fiba_fibd'
        $val = $CurrentForm->hasValue("fiba_fibd") ? $CurrentForm->getValue("fiba_fibd") : $CurrentForm->getValue("x_fiba_fibd");
        if (!$this->fiba_fibd->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fiba_fibd->Visible = false; // Disable update for API request
            } else {
                $this->fiba_fibd->setFormValue($val);
            }
        }

        // Check field name 'fibc' first before field var 'x_fibc'
        $val = $CurrentForm->hasValue("fibc") ? $CurrentForm->getValue("fibc") : $CurrentForm->getValue("x_fibc");
        if (!$this->fibc->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->fibc->Visible = false; // Disable update for API request
            } else {
                $this->fibc->setFormValue($val);
            }
        }

        // Check field name 'operator' first before field var 'x_operator'
        $val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
        if (!$this->operator->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->operator->Visible = false; // Disable update for API request
            } else {
                $this->operator->setFormValue($val);
            }
        }

        // Check field name 'datetime' first before field var 'x_datetime'
        $val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
        if (!$this->datetime->IsDetailKey) {
            if (IsApi() && $val === null) {
                $this->datetime->Visible = false; // Disable update for API request
            } else {
                $this->datetime->setFormValue($val);
            }
            $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
        }
    }

    // Restore form values
    public function restoreFormValues()
    {
        global $CurrentForm;
        $this->id->CurrentValue = $this->id->FormValue;
        $this->supplier->CurrentValue = $this->supplier->FormValue;
        $this->booking_reference->CurrentValue = $this->booking_reference->FormValue;
        $this->rid->CurrentValue = $this->rid->FormValue;
        $this->lot_no->CurrentValue = $this->lot_no->FormValue;
        $this->gross_weight->CurrentValue = $this->gross_weight->FormValue;
        $this->net_weight->CurrentValue = $this->net_weight->FormValue;
        $this->packets->CurrentValue = $this->packets->FormValue;
        $this->packing_type->CurrentValue = $this->packing_type->FormValue;
        $this->containers->CurrentValue = $this->containers->FormValue;
        $this->shipping_line->CurrentValue = $this->shipping_line->FormValue;
        $this->port_arrival_date->CurrentValue = $this->port_arrival_date->FormValue;
        $this->port_arrival_date->CurrentValue = UnFormatDateTime($this->port_arrival_date->CurrentValue, $this->port_arrival_date->formatPattern());
        $this->godown_arrival_date->CurrentValue = $this->godown_arrival_date->FormValue;
        $this->godown_arrival_date->CurrentValue = UnFormatDateTime($this->godown_arrival_date->CurrentValue, $this->godown_arrival_date->formatPattern());
        $this->godown->CurrentValue = $this->godown->FormValue;
        $this->rack->CurrentValue = $this->rack->FormValue;
        $this->invoice_details->CurrentValue = $this->invoice_details->FormValue;
        $this->invoice_value->CurrentValue = $this->invoice_value->FormValue;
        $this->currency_rate->CurrentValue = $this->currency_rate->FormValue;
        $this->purchase_amount_inr->CurrentValue = $this->purchase_amount_inr->FormValue;
        $this->duty_paid_by->CurrentValue = $this->duty_paid_by->FormValue;
        $this->custom_duty->CurrentValue = $this->custom_duty->FormValue;
        $this->transportation_charges->CurrentValue = $this->transportation_charges->FormValue;
        $this->port_clearing_charge->CurrentValue = $this->port_clearing_charge->FormValue;
        $this->cha_commission->CurrentValue = $this->cha_commission->FormValue;
        $this->cha_agent->CurrentValue = $this->cha_agent->FormValue;
        $this->clearance_bank->CurrentValue = $this->clearance_bank->FormValue;
        $this->bank_charges->CurrentValue = $this->bank_charges->FormValue;
        $this->importer->CurrentValue = $this->importer->FormValue;
        $this->remarks->CurrentValue = $this->remarks->FormValue;
        $this->fiba_fibd->CurrentValue = $this->fiba_fibd->FormValue;
        $this->fibc->CurrentValue = $this->fibc->FormValue;
        $this->operator->CurrentValue = $this->operator->FormValue;
        $this->datetime->CurrentValue = $this->datetime->FormValue;
        $this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern());
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->id->setDbValue($row['id']);
        $this->supplier->setDbValue($row['supplier']);
        $this->booking_reference->setDbValue($row['booking_reference']);
        $this->rid->setDbValue($row['rid']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->gross_weight->setDbValue($row['gross_weight']);
        $this->net_weight->setDbValue($row['net_weight']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->containers->setDbValue($row['containers']);
        $this->shipping_line->setDbValue($row['shipping_line']);
        $this->port_arrival_date->setDbValue($row['port_arrival_date']);
        $this->godown_arrival_date->setDbValue($row['godown_arrival_date']);
        $this->godown->setDbValue($row['godown']);
        $this->rack->setDbValue($row['rack']);
        $this->invoice_details->setDbValue($row['invoice_details']);
        $this->invoice_value->setDbValue($row['invoice_value']);
        $this->currency_rate->setDbValue($row['currency_rate']);
        $this->purchase_amount_inr->setDbValue($row['purchase_amount_inr']);
        $this->duty_paid_by->setDbValue($row['duty_paid_by']);
        $this->custom_duty->setDbValue($row['custom_duty']);
        $this->transportation_charges->setDbValue($row['transportation_charges']);
        $this->port_clearing_charge->setDbValue($row['port_clearing_charge']);
        $this->cha_commission->setDbValue($row['cha_commission']);
        $this->cha_agent->setDbValue($row['cha_agent']);
        $this->clearance_bank->setDbValue($row['clearance_bank']);
        $this->bank_charges->setDbValue($row['bank_charges']);
        $this->importer->setDbValue($row['importer']);
        $this->remarks->setDbValue($row['remarks']);
        $this->fiba_fibd->setDbValue($row['fiba_fibd']);
        $this->fibc->setDbValue($row['fibc']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->grp->setDbValue($row['grp']);
        $this->qc_remarks->setDbValue($row['qc_remarks']);
        $this->qc_status->setDbValue($row['qc_status']);
        $this->qc_operator->setDbValue($row['qc_operator']);
        $this->qc_datetime->setDbValue($row['qc_datetime']);
        $this->rbi_compliance_date->setDbValue($row['rbi_compliance_date']);
        $this->age->setDbValue($row['age']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['id'] = $this->id->DefaultValue;
        $row['supplier'] = $this->supplier->DefaultValue;
        $row['booking_reference'] = $this->booking_reference->DefaultValue;
        $row['rid'] = $this->rid->DefaultValue;
        $row['lot_no'] = $this->lot_no->DefaultValue;
        $row['gross_weight'] = $this->gross_weight->DefaultValue;
        $row['net_weight'] = $this->net_weight->DefaultValue;
        $row['packets'] = $this->packets->DefaultValue;
        $row['packing_type'] = $this->packing_type->DefaultValue;
        $row['containers'] = $this->containers->DefaultValue;
        $row['shipping_line'] = $this->shipping_line->DefaultValue;
        $row['port_arrival_date'] = $this->port_arrival_date->DefaultValue;
        $row['godown_arrival_date'] = $this->godown_arrival_date->DefaultValue;
        $row['godown'] = $this->godown->DefaultValue;
        $row['rack'] = $this->rack->DefaultValue;
        $row['invoice_details'] = $this->invoice_details->DefaultValue;
        $row['invoice_value'] = $this->invoice_value->DefaultValue;
        $row['currency_rate'] = $this->currency_rate->DefaultValue;
        $row['purchase_amount_inr'] = $this->purchase_amount_inr->DefaultValue;
        $row['duty_paid_by'] = $this->duty_paid_by->DefaultValue;
        $row['custom_duty'] = $this->custom_duty->DefaultValue;
        $row['transportation_charges'] = $this->transportation_charges->DefaultValue;
        $row['port_clearing_charge'] = $this->port_clearing_charge->DefaultValue;
        $row['cha_commission'] = $this->cha_commission->DefaultValue;
        $row['cha_agent'] = $this->cha_agent->DefaultValue;
        $row['clearance_bank'] = $this->clearance_bank->DefaultValue;
        $row['bank_charges'] = $this->bank_charges->DefaultValue;
        $row['importer'] = $this->importer->DefaultValue;
        $row['remarks'] = $this->remarks->DefaultValue;
        $row['fiba_fibd'] = $this->fiba_fibd->DefaultValue;
        $row['fibc'] = $this->fibc->DefaultValue;
        $row['operator'] = $this->operator->DefaultValue;
        $row['datetime'] = $this->datetime->DefaultValue;
        $row['updated'] = $this->updated->DefaultValue;
        $row['grp'] = $this->grp->DefaultValue;
        $row['qc_remarks'] = $this->qc_remarks->DefaultValue;
        $row['qc_status'] = $this->qc_status->DefaultValue;
        $row['qc_operator'] = $this->qc_operator->DefaultValue;
        $row['qc_datetime'] = $this->qc_datetime->DefaultValue;
        $row['rbi_compliance_date'] = $this->rbi_compliance_date->DefaultValue;
        $row['age'] = $this->age->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // id
        $this->id->RowCssClass = "row";

        // supplier
        $this->supplier->RowCssClass = "row";

        // booking_reference
        $this->booking_reference->RowCssClass = "row";

        // rid
        $this->rid->RowCssClass = "row";

        // lot_no
        $this->lot_no->RowCssClass = "row";

        // gross_weight
        $this->gross_weight->RowCssClass = "row";

        // net_weight
        $this->net_weight->RowCssClass = "row";

        // packets
        $this->packets->RowCssClass = "row";

        // packing_type
        $this->packing_type->RowCssClass = "row";

        // containers
        $this->containers->RowCssClass = "row";

        // shipping_line
        $this->shipping_line->RowCssClass = "row";

        // port_arrival_date
        $this->port_arrival_date->RowCssClass = "row";

        // godown_arrival_date
        $this->godown_arrival_date->RowCssClass = "row";

        // godown
        $this->godown->RowCssClass = "row";

        // rack
        $this->rack->RowCssClass = "row";

        // invoice_details
        $this->invoice_details->RowCssClass = "row";

        // invoice_value
        $this->invoice_value->RowCssClass = "row";

        // currency_rate
        $this->currency_rate->RowCssClass = "row";

        // purchase_amount_inr
        $this->purchase_amount_inr->RowCssClass = "row";

        // duty_paid_by
        $this->duty_paid_by->RowCssClass = "row";

        // custom_duty
        $this->custom_duty->RowCssClass = "row";

        // transportation_charges
        $this->transportation_charges->RowCssClass = "row";

        // port_clearing_charge
        $this->port_clearing_charge->RowCssClass = "row";

        // cha_commission
        $this->cha_commission->RowCssClass = "row";

        // cha_agent
        $this->cha_agent->RowCssClass = "row";

        // clearance_bank
        $this->clearance_bank->RowCssClass = "row";

        // bank_charges
        $this->bank_charges->RowCssClass = "row";

        // importer
        $this->importer->RowCssClass = "row";

        // remarks
        $this->remarks->RowCssClass = "row";

        // fiba_fibd
        $this->fiba_fibd->RowCssClass = "row";

        // fibc
        $this->fibc->RowCssClass = "row";

        // operator
        $this->operator->RowCssClass = "row";

        // datetime
        $this->datetime->RowCssClass = "row";

        // updated
        $this->updated->RowCssClass = "row";

        // grp
        $this->grp->RowCssClass = "row";

        // qc_remarks
        $this->qc_remarks->RowCssClass = "row";

        // qc_status
        $this->qc_status->RowCssClass = "row";

        // qc_operator
        $this->qc_operator->RowCssClass = "row";

        // qc_datetime
        $this->qc_datetime->RowCssClass = "row";

        // rbi_compliance_date
        $this->rbi_compliance_date->RowCssClass = "row";

        // age
        $this->age->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // id
            $this->id->ViewValue = $this->id->CurrentValue;

            // supplier
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->ViewValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->ViewValue = null;
            }

            // booking_reference
            $curVal = strval($this->booking_reference->CurrentValue);
            if ($curVal != "") {
                $this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
                if ($this->booking_reference->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_reference->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_reference->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->booking_reference->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_reference->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
                    } else {
                        $this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
                    }
                }
            } else {
                $this->booking_reference->ViewValue = null;
            }

            // rid
            $this->rid->ViewValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->ViewValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->ViewValue = null;
            }

            // lot_no
            $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

            // gross_weight
            $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
            $this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, $this->gross_weight->formatPattern());

            // net_weight
            $this->net_weight->ViewValue = $this->net_weight->CurrentValue;
            $this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, $this->net_weight->formatPattern());

            // packets
            $this->packets->ViewValue = $this->packets->CurrentValue;
            $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

            // packing_type
            $curVal = strval($this->packing_type->CurrentValue);
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
                if ($this->packing_type->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                    $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                        $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                    } else {
                        $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                    }
                }
            } else {
                $this->packing_type->ViewValue = null;
            }

            // containers
            $this->containers->ViewValue = $this->containers->CurrentValue;
            $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());

            // shipping_line
            $curVal = strval($this->shipping_line->CurrentValue);
            if ($curVal != "") {
                $this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
                if ($this->shipping_line->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->shipping_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shipping_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->shipping_line->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->shipping_line->Lookup->renderViewRow($rswrk[0]);
                        $this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
                    } else {
                        $this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
                    }
                }
            } else {
                $this->shipping_line->ViewValue = null;
            }

            // port_arrival_date
            $this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
            $this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, $this->port_arrival_date->formatPattern());

            // godown_arrival_date
            $this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
            $this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, $this->godown_arrival_date->formatPattern());

            // godown
            $curVal = strval($this->godown->CurrentValue);
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
                if ($this->godown->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                    $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                        $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                    } else {
                        $this->godown->ViewValue = $this->godown->CurrentValue;
                    }
                }
            } else {
                $this->godown->ViewValue = null;
            }

            // rack
            $this->rack->ViewValue = $this->rack->CurrentValue;

            // invoice_details
            $this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;

            // invoice_value
            $this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
            $this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, $this->invoice_value->formatPattern());

            // currency_rate
            $this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
            $this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, $this->currency_rate->formatPattern());

            // purchase_amount_inr
            $this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
            $this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, $this->purchase_amount_inr->formatPattern());

            // duty_paid_by
            if (strval($this->duty_paid_by->CurrentValue) != "") {
                $this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
            } else {
                $this->duty_paid_by->ViewValue = null;
            }

            // custom_duty
            $this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
            $this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, $this->custom_duty->formatPattern());

            // transportation_charges
            $this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
            $this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, $this->transportation_charges->formatPattern());

            // port_clearing_charge
            $this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
            $this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, $this->port_clearing_charge->formatPattern());

            // cha_commission
            $this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
            $this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, $this->cha_commission->formatPattern());

            // cha_agent
            $curVal = strval($this->cha_agent->CurrentValue);
            if ($curVal != "") {
                $this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
                if ($this->cha_agent->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->cha_agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->cha_agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->cha_agent->getSelectFilter($this); // PHP
                    $sqlWrk = $this->cha_agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->cha_agent->Lookup->renderViewRow($rswrk[0]);
                        $this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
                    } else {
                        $this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
                    }
                }
            } else {
                $this->cha_agent->ViewValue = null;
            }

            // clearance_bank
            $curVal = strval($this->clearance_bank->CurrentValue);
            if ($curVal != "") {
                $this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
                if ($this->clearance_bank->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->clearance_bank->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->clearance_bank->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->clearance_bank->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->clearance_bank->Lookup->renderViewRow($rswrk[0]);
                        $this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
                    } else {
                        $this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
                    }
                }
            } else {
                $this->clearance_bank->ViewValue = null;
            }

            // bank_charges
            $this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
            $this->bank_charges->ViewValue = FormatNumber($this->bank_charges->ViewValue, $this->bank_charges->formatPattern());

            // importer
            $curVal = strval($this->importer->CurrentValue);
            if ($curVal != "") {
                $this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
                if ($this->importer->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->importer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->importer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->importer->getSelectFilter($this); // PHP
                    $sqlWrk = $this->importer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->importer->Lookup->renderViewRow($rswrk[0]);
                        $this->importer->ViewValue = $this->importer->displayValue($arwrk);
                    } else {
                        $this->importer->ViewValue = $this->importer->CurrentValue;
                    }
                }
            } else {
                $this->importer->ViewValue = null;
            }

            // remarks
            $this->remarks->ViewValue = $this->remarks->CurrentValue;

            // fiba_fibd
            $this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;

            // fibc
            $this->fibc->ViewValue = $this->fibc->CurrentValue;

            // operator
            $curVal = strval($this->operator->CurrentValue);
            if ($curVal != "") {
                $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
                if ($this->operator->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                        $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                    } else {
                        $this->operator->ViewValue = $this->operator->CurrentValue;
                    }
                }
            } else {
                $this->operator->ViewValue = null;
            }

            // datetime
            $this->datetime->ViewValue = $this->datetime->CurrentValue;
            $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

            // id
            $this->id->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // booking_reference
            $this->booking_reference->HrefValue = "";
            $this->booking_reference->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // gross_weight
            $this->gross_weight->HrefValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }

            // containers
            $this->containers->HrefValue = "";

            // shipping_line
            $this->shipping_line->HrefValue = "";

            // port_arrival_date
            $this->port_arrival_date->HrefValue = "";

            // godown_arrival_date
            $this->godown_arrival_date->HrefValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // rack
            $this->rack->HrefValue = "";

            // invoice_details
            $this->invoice_details->HrefValue = "";

            // invoice_value
            $this->invoice_value->HrefValue = "";

            // currency_rate
            $this->currency_rate->HrefValue = "";

            // purchase_amount_inr
            $this->purchase_amount_inr->HrefValue = "";

            // duty_paid_by
            $this->duty_paid_by->HrefValue = "";

            // custom_duty
            $this->custom_duty->HrefValue = "";

            // transportation_charges
            $this->transportation_charges->HrefValue = "";

            // port_clearing_charge
            $this->port_clearing_charge->HrefValue = "";

            // cha_commission
            $this->cha_commission->HrefValue = "";

            // cha_agent
            $this->cha_agent->HrefValue = "";

            // clearance_bank
            $this->clearance_bank->HrefValue = "";

            // bank_charges
            $this->bank_charges->HrefValue = "";

            // importer
            $this->importer->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // fiba_fibd
            $this->fiba_fibd->HrefValue = "";

            // fibc
            $this->fibc->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // id
            $this->id->setupEditAttributes();
            $this->id->EditValue = $this->id->CurrentValue;

            // supplier
            $this->supplier->setupEditAttributes();
            $curVal = strval($this->supplier->CurrentValue);
            if ($curVal != "") {
                $this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
                if ($this->supplier->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                    $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                        $this->supplier->EditValue = $this->supplier->displayValue($arwrk);
                    } else {
                        $this->supplier->EditValue = $this->supplier->CurrentValue;
                    }
                }
            } else {
                $this->supplier->EditValue = null;
            }

            // booking_reference
            $this->booking_reference->setupEditAttributes();
            $curVal = strval($this->booking_reference->CurrentValue);
            if ($curVal != "") {
                $this->booking_reference->EditValue = $this->booking_reference->lookupCacheOption($curVal);
                if ($this->booking_reference->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->booking_reference->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_reference->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->booking_reference->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->booking_reference->Lookup->renderViewRow($rswrk[0]);
                        $this->booking_reference->EditValue = $this->booking_reference->displayValue($arwrk);
                    } else {
                        $this->booking_reference->EditValue = $this->booking_reference->CurrentValue;
                    }
                }
            } else {
                $this->booking_reference->EditValue = null;
            }

            // rid
            $this->rid->setupEditAttributes();
            $this->rid->EditValue = $this->rid->CurrentValue;
            $curVal = strval($this->rid->CurrentValue);
            if ($curVal != "") {
                $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
                if ($this->rid->EditValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                    $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                        $this->rid->EditValue = $this->rid->displayValue($arwrk);
                    } else {
                        $this->rid->EditValue = $this->rid->CurrentValue;
                    }
                }
            } else {
                $this->rid->EditValue = null;
            }

            // lot_no
            $this->lot_no->setupEditAttributes();
            $this->lot_no->EditValue = $this->lot_no->CurrentValue;

            // gross_weight
            $this->gross_weight->setupEditAttributes();
            $this->gross_weight->EditValue = $this->gross_weight->CurrentValue;
            $this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());
            if (strval($this->gross_weight->EditValue) != "" && is_numeric($this->gross_weight->EditValue)) {
                $this->gross_weight->EditValue = FormatNumber($this->gross_weight->EditValue, null);
            }

            // net_weight
            $this->net_weight->setupEditAttributes();
            $this->net_weight->EditValue = $this->net_weight->CurrentValue;
            $this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
            if (strval($this->net_weight->EditValue) != "" && is_numeric($this->net_weight->EditValue)) {
                $this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, null);
            }

            // packets
            $this->packets->setupEditAttributes();
            $this->packets->EditValue = $this->packets->CurrentValue;
            $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
            if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
                $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
            }

            // packing_type
            $this->packing_type->setupEditAttributes();
            $curVal = trim(strval($this->packing_type->CurrentValue));
            if ($curVal != "") {
                $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            } else {
                $this->packing_type->ViewValue = $this->packing_type->Lookup !== null && is_array($this->packing_type->lookupOptions()) && count($this->packing_type->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->packing_type->ViewValue !== null) { // Load from cache
                $this->packing_type->EditValue = array_values($this->packing_type->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->packing_type->CurrentValue, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->packing_type->EditValue = $arwrk;
            }
            $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

            // containers
            $this->containers->setupEditAttributes();
            $this->containers->EditValue = $this->containers->CurrentValue;
            $this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
            if (strval($this->containers->EditValue) != "" && is_numeric($this->containers->EditValue)) {
                $this->containers->EditValue = FormatNumber($this->containers->EditValue, null);
            }

            // shipping_line
            $this->shipping_line->setupEditAttributes();
            $curVal = trim(strval($this->shipping_line->CurrentValue));
            if ($curVal != "") {
                $this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
            } else {
                $this->shipping_line->ViewValue = $this->shipping_line->Lookup !== null && is_array($this->shipping_line->lookupOptions()) && count($this->shipping_line->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->shipping_line->ViewValue !== null) { // Load from cache
                $this->shipping_line->EditValue = array_values($this->shipping_line->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->shipping_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->shipping_line->CurrentValue, $this->shipping_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->shipping_line->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->shipping_line->EditValue = $arwrk;
            }
            $this->shipping_line->PlaceHolder = RemoveHtml($this->shipping_line->caption());

            // port_arrival_date
            $this->port_arrival_date->setupEditAttributes();
            $this->port_arrival_date->EditValue = HtmlEncode(FormatDateTime($this->port_arrival_date->CurrentValue, $this->port_arrival_date->formatPattern()));
            $this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());

            // godown_arrival_date
            $this->godown_arrival_date->setupEditAttributes();
            $this->godown_arrival_date->EditValue = HtmlEncode(FormatDateTime($this->godown_arrival_date->CurrentValue, $this->godown_arrival_date->formatPattern()));
            $this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

            // godown
            $this->godown->setupEditAttributes();
            $curVal = trim(strval($this->godown->CurrentValue));
            if ($curVal != "") {
                $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            } else {
                $this->godown->ViewValue = $this->godown->Lookup !== null && is_array($this->godown->lookupOptions()) && count($this->godown->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->godown->ViewValue !== null) { // Load from cache
                $this->godown->EditValue = array_values($this->godown->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->godown->CurrentValue, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->godown->EditValue = $arwrk;
            }
            $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

            // rack
            $this->rack->setupEditAttributes();
            if (!$this->rack->Raw) {
                $this->rack->CurrentValue = HtmlDecode($this->rack->CurrentValue);
            }
            $this->rack->EditValue = HtmlEncode($this->rack->CurrentValue);
            $this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

            // invoice_details
            $this->invoice_details->setupEditAttributes();
            if (!$this->invoice_details->Raw) {
                $this->invoice_details->CurrentValue = HtmlDecode($this->invoice_details->CurrentValue);
            }
            $this->invoice_details->EditValue = HtmlEncode($this->invoice_details->CurrentValue);
            $this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

            // invoice_value
            $this->invoice_value->setupEditAttributes();
            $this->invoice_value->EditValue = $this->invoice_value->CurrentValue;
            $this->invoice_value->PlaceHolder = RemoveHtml($this->invoice_value->caption());
            if (strval($this->invoice_value->EditValue) != "" && is_numeric($this->invoice_value->EditValue)) {
                $this->invoice_value->EditValue = FormatNumber($this->invoice_value->EditValue, null);
            }

            // currency_rate
            $this->currency_rate->setupEditAttributes();
            $this->currency_rate->EditValue = $this->currency_rate->CurrentValue;
            $this->currency_rate->PlaceHolder = RemoveHtml($this->currency_rate->caption());
            if (strval($this->currency_rate->EditValue) != "" && is_numeric($this->currency_rate->EditValue)) {
                $this->currency_rate->EditValue = FormatNumber($this->currency_rate->EditValue, null);
            }

            // purchase_amount_inr
            $this->purchase_amount_inr->setupEditAttributes();
            $this->purchase_amount_inr->EditValue = $this->purchase_amount_inr->CurrentValue;
            $this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());
            if (strval($this->purchase_amount_inr->EditValue) != "" && is_numeric($this->purchase_amount_inr->EditValue)) {
                $this->purchase_amount_inr->EditValue = FormatNumber($this->purchase_amount_inr->EditValue, null);
            }

            // duty_paid_by
            $this->duty_paid_by->setupEditAttributes();
            $this->duty_paid_by->EditValue = $this->duty_paid_by->options(true);
            $this->duty_paid_by->PlaceHolder = RemoveHtml($this->duty_paid_by->caption());

            // custom_duty
            $this->custom_duty->setupEditAttributes();
            $this->custom_duty->EditValue = $this->custom_duty->CurrentValue;
            $this->custom_duty->PlaceHolder = RemoveHtml($this->custom_duty->caption());
            if (strval($this->custom_duty->EditValue) != "" && is_numeric($this->custom_duty->EditValue)) {
                $this->custom_duty->EditValue = FormatNumber($this->custom_duty->EditValue, null);
            }

            // transportation_charges
            $this->transportation_charges->setupEditAttributes();
            $this->transportation_charges->EditValue = $this->transportation_charges->CurrentValue;
            $this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());
            if (strval($this->transportation_charges->EditValue) != "" && is_numeric($this->transportation_charges->EditValue)) {
                $this->transportation_charges->EditValue = FormatNumber($this->transportation_charges->EditValue, null);
            }

            // port_clearing_charge
            $this->port_clearing_charge->setupEditAttributes();
            $this->port_clearing_charge->EditValue = $this->port_clearing_charge->CurrentValue;
            $this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());
            if (strval($this->port_clearing_charge->EditValue) != "" && is_numeric($this->port_clearing_charge->EditValue)) {
                $this->port_clearing_charge->EditValue = FormatNumber($this->port_clearing_charge->EditValue, null);
            }

            // cha_commission
            $this->cha_commission->setupEditAttributes();
            $this->cha_commission->EditValue = $this->cha_commission->CurrentValue;
            $this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());
            if (strval($this->cha_commission->EditValue) != "" && is_numeric($this->cha_commission->EditValue)) {
                $this->cha_commission->EditValue = FormatNumber($this->cha_commission->EditValue, null);
            }

            // cha_agent
            $this->cha_agent->setupEditAttributes();
            $curVal = trim(strval($this->cha_agent->CurrentValue));
            if ($curVal != "") {
                $this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
            } else {
                $this->cha_agent->ViewValue = $this->cha_agent->Lookup !== null && is_array($this->cha_agent->lookupOptions()) && count($this->cha_agent->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->cha_agent->ViewValue !== null) { // Load from cache
                $this->cha_agent->EditValue = array_values($this->cha_agent->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->cha_agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->cha_agent->CurrentValue, $this->cha_agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->cha_agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->cha_agent->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->cha_agent->EditValue = $arwrk;
            }
            $this->cha_agent->PlaceHolder = RemoveHtml($this->cha_agent->caption());

            // clearance_bank
            $this->clearance_bank->setupEditAttributes();
            $curVal = trim(strval($this->clearance_bank->CurrentValue));
            if ($curVal != "") {
                $this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
            } else {
                $this->clearance_bank->ViewValue = $this->clearance_bank->Lookup !== null && is_array($this->clearance_bank->lookupOptions()) && count($this->clearance_bank->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->clearance_bank->ViewValue !== null) { // Load from cache
                $this->clearance_bank->EditValue = array_values($this->clearance_bank->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->clearance_bank->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->clearance_bank->CurrentValue, $this->clearance_bank->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $sqlWrk = $this->clearance_bank->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->clearance_bank->EditValue = $arwrk;
            }
            $this->clearance_bank->PlaceHolder = RemoveHtml($this->clearance_bank->caption());

            // bank_charges
            $this->bank_charges->setupEditAttributes();
            $this->bank_charges->EditValue = $this->bank_charges->CurrentValue;
            $this->bank_charges->PlaceHolder = RemoveHtml($this->bank_charges->caption());
            if (strval($this->bank_charges->EditValue) != "" && is_numeric($this->bank_charges->EditValue)) {
                $this->bank_charges->EditValue = FormatNumber($this->bank_charges->EditValue, null);
            }

            // importer
            $this->importer->setupEditAttributes();
            $curVal = trim(strval($this->importer->CurrentValue));
            if ($curVal != "") {
                $this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
            } else {
                $this->importer->ViewValue = $this->importer->Lookup !== null && is_array($this->importer->lookupOptions()) && count($this->importer->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->importer->ViewValue !== null) { // Load from cache
                $this->importer->EditValue = array_values($this->importer->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->importer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $this->importer->CurrentValue, $this->importer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                }
                $lookupFilter = $this->importer->getSelectFilter($this); // PHP
                $sqlWrk = $this->importer->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->importer->EditValue = $arwrk;
            }
            $this->importer->PlaceHolder = RemoveHtml($this->importer->caption());

            // remarks
            $this->remarks->setupEditAttributes();
            $this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
            $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

            // fiba_fibd
            $this->fiba_fibd->setupEditAttributes();
            if (!$this->fiba_fibd->Raw) {
                $this->fiba_fibd->CurrentValue = HtmlDecode($this->fiba_fibd->CurrentValue);
            }
            $this->fiba_fibd->EditValue = HtmlEncode($this->fiba_fibd->CurrentValue);
            $this->fiba_fibd->PlaceHolder = RemoveHtml($this->fiba_fibd->caption());

            // fibc
            $this->fibc->setupEditAttributes();
            if (!$this->fibc->Raw) {
                $this->fibc->CurrentValue = HtmlDecode($this->fibc->CurrentValue);
            }
            $this->fibc->EditValue = HtmlEncode($this->fibc->CurrentValue);
            $this->fibc->PlaceHolder = RemoveHtml($this->fibc->caption());

            // operator

            // datetime

            // Edit refer script

            // id
            $this->id->HrefValue = "";

            // supplier
            if (!EmptyValue($this->supplier->CurrentValue)) {
                $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
                $this->supplier->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
                }
            } else {
                $this->supplier->HrefValue = "";
            }
            $this->supplier->TooltipValue = "";

            // booking_reference
            $this->booking_reference->HrefValue = "";
            $this->booking_reference->TooltipValue = "";

            // rid
            if (!EmptyValue($this->rid->CurrentValue)) {
                $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
                $this->rid->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
                }
            } else {
                $this->rid->HrefValue = "";
            }
            $this->rid->TooltipValue = "";

            // lot_no
            $this->lot_no->HrefValue = "";
            $this->lot_no->TooltipValue = "";

            // gross_weight
            $this->gross_weight->HrefValue = "";

            // net_weight
            $this->net_weight->HrefValue = "";

            // packets
            $this->packets->HrefValue = "";

            // packing_type
            if (!EmptyValue($this->packing_type->CurrentValue)) {
                $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
                $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
                }
            } else {
                $this->packing_type->HrefValue = "";
            }

            // containers
            $this->containers->HrefValue = "";

            // shipping_line
            $this->shipping_line->HrefValue = "";

            // port_arrival_date
            $this->port_arrival_date->HrefValue = "";

            // godown_arrival_date
            $this->godown_arrival_date->HrefValue = "";

            // godown
            if (!EmptyValue($this->godown->CurrentValue)) {
                $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
                $this->godown->LinkAttrs["target"] = "_self"; // Add target
                if ($this->isExport()) {
                    $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
                }
            } else {
                $this->godown->HrefValue = "";
            }

            // rack
            $this->rack->HrefValue = "";

            // invoice_details
            $this->invoice_details->HrefValue = "";

            // invoice_value
            $this->invoice_value->HrefValue = "";

            // currency_rate
            $this->currency_rate->HrefValue = "";

            // purchase_amount_inr
            $this->purchase_amount_inr->HrefValue = "";

            // duty_paid_by
            $this->duty_paid_by->HrefValue = "";

            // custom_duty
            $this->custom_duty->HrefValue = "";

            // transportation_charges
            $this->transportation_charges->HrefValue = "";

            // port_clearing_charge
            $this->port_clearing_charge->HrefValue = "";

            // cha_commission
            $this->cha_commission->HrefValue = "";

            // cha_agent
            $this->cha_agent->HrefValue = "";

            // clearance_bank
            $this->clearance_bank->HrefValue = "";

            // bank_charges
            $this->bank_charges->HrefValue = "";

            // importer
            $this->importer->HrefValue = "";

            // remarks
            $this->remarks->HrefValue = "";

            // fiba_fibd
            $this->fiba_fibd->HrefValue = "";

            // fibc
            $this->fibc->HrefValue = "";

            // operator
            $this->operator->HrefValue = "";

            // datetime
            $this->datetime->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate form
    protected function validateForm()
    {
        global $Language, $Security;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
            if ($this->id->Visible && $this->id->Required) {
                if (!$this->id->IsDetailKey && EmptyValue($this->id->FormValue)) {
                    $this->id->addErrorMessage(str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
                }
            }
            if ($this->supplier->Visible && $this->supplier->Required) {
                if (!$this->supplier->IsDetailKey && EmptyValue($this->supplier->FormValue)) {
                    $this->supplier->addErrorMessage(str_replace("%s", $this->supplier->caption(), $this->supplier->RequiredErrorMessage));
                }
            }
            if ($this->booking_reference->Visible && $this->booking_reference->Required) {
                if (!$this->booking_reference->IsDetailKey && EmptyValue($this->booking_reference->FormValue)) {
                    $this->booking_reference->addErrorMessage(str_replace("%s", $this->booking_reference->caption(), $this->booking_reference->RequiredErrorMessage));
                }
            }
            if ($this->rid->Visible && $this->rid->Required) {
                if (!$this->rid->IsDetailKey && EmptyValue($this->rid->FormValue)) {
                    $this->rid->addErrorMessage(str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
                }
            }
            if ($this->lot_no->Visible && $this->lot_no->Required) {
                if (!$this->lot_no->IsDetailKey && EmptyValue($this->lot_no->FormValue)) {
                    $this->lot_no->addErrorMessage(str_replace("%s", $this->lot_no->caption(), $this->lot_no->RequiredErrorMessage));
                }
            }
            if ($this->gross_weight->Visible && $this->gross_weight->Required) {
                if (!$this->gross_weight->IsDetailKey && EmptyValue($this->gross_weight->FormValue)) {
                    $this->gross_weight->addErrorMessage(str_replace("%s", $this->gross_weight->caption(), $this->gross_weight->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->gross_weight->FormValue)) {
                $this->gross_weight->addErrorMessage($this->gross_weight->getErrorMessage(false));
            }
            if ($this->net_weight->Visible && $this->net_weight->Required) {
                if (!$this->net_weight->IsDetailKey && EmptyValue($this->net_weight->FormValue)) {
                    $this->net_weight->addErrorMessage(str_replace("%s", $this->net_weight->caption(), $this->net_weight->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->net_weight->FormValue)) {
                $this->net_weight->addErrorMessage($this->net_weight->getErrorMessage(false));
            }
            if ($this->packets->Visible && $this->packets->Required) {
                if (!$this->packets->IsDetailKey && EmptyValue($this->packets->FormValue)) {
                    $this->packets->addErrorMessage(str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
                }
            }
            if (!CheckInteger($this->packets->FormValue)) {
                $this->packets->addErrorMessage($this->packets->getErrorMessage(false));
            }
            if ($this->packing_type->Visible && $this->packing_type->Required) {
                if (!$this->packing_type->IsDetailKey && EmptyValue($this->packing_type->FormValue)) {
                    $this->packing_type->addErrorMessage(str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
                }
            }
            if ($this->containers->Visible && $this->containers->Required) {
                if (!$this->containers->IsDetailKey && EmptyValue($this->containers->FormValue)) {
                    $this->containers->addErrorMessage(str_replace("%s", $this->containers->caption(), $this->containers->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->containers->FormValue)) {
                $this->containers->addErrorMessage($this->containers->getErrorMessage(false));
            }
            if ($this->shipping_line->Visible && $this->shipping_line->Required) {
                if (!$this->shipping_line->IsDetailKey && EmptyValue($this->shipping_line->FormValue)) {
                    $this->shipping_line->addErrorMessage(str_replace("%s", $this->shipping_line->caption(), $this->shipping_line->RequiredErrorMessage));
                }
            }
            if ($this->port_arrival_date->Visible && $this->port_arrival_date->Required) {
                if (!$this->port_arrival_date->IsDetailKey && EmptyValue($this->port_arrival_date->FormValue)) {
                    $this->port_arrival_date->addErrorMessage(str_replace("%s", $this->port_arrival_date->caption(), $this->port_arrival_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->port_arrival_date->FormValue, $this->port_arrival_date->formatPattern())) {
                $this->port_arrival_date->addErrorMessage($this->port_arrival_date->getErrorMessage(false));
            }
            if ($this->godown_arrival_date->Visible && $this->godown_arrival_date->Required) {
                if (!$this->godown_arrival_date->IsDetailKey && EmptyValue($this->godown_arrival_date->FormValue)) {
                    $this->godown_arrival_date->addErrorMessage(str_replace("%s", $this->godown_arrival_date->caption(), $this->godown_arrival_date->RequiredErrorMessage));
                }
            }
            if (!CheckDate($this->godown_arrival_date->FormValue, $this->godown_arrival_date->formatPattern())) {
                $this->godown_arrival_date->addErrorMessage($this->godown_arrival_date->getErrorMessage(false));
            }
            if ($this->godown->Visible && $this->godown->Required) {
                if (!$this->godown->IsDetailKey && EmptyValue($this->godown->FormValue)) {
                    $this->godown->addErrorMessage(str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
                }
            }
            if ($this->rack->Visible && $this->rack->Required) {
                if (!$this->rack->IsDetailKey && EmptyValue($this->rack->FormValue)) {
                    $this->rack->addErrorMessage(str_replace("%s", $this->rack->caption(), $this->rack->RequiredErrorMessage));
                }
            }
            if ($this->invoice_details->Visible && $this->invoice_details->Required) {
                if (!$this->invoice_details->IsDetailKey && EmptyValue($this->invoice_details->FormValue)) {
                    $this->invoice_details->addErrorMessage(str_replace("%s", $this->invoice_details->caption(), $this->invoice_details->RequiredErrorMessage));
                }
            }
            if ($this->invoice_value->Visible && $this->invoice_value->Required) {
                if (!$this->invoice_value->IsDetailKey && EmptyValue($this->invoice_value->FormValue)) {
                    $this->invoice_value->addErrorMessage(str_replace("%s", $this->invoice_value->caption(), $this->invoice_value->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->invoice_value->FormValue)) {
                $this->invoice_value->addErrorMessage($this->invoice_value->getErrorMessage(false));
            }
            if ($this->currency_rate->Visible && $this->currency_rate->Required) {
                if (!$this->currency_rate->IsDetailKey && EmptyValue($this->currency_rate->FormValue)) {
                    $this->currency_rate->addErrorMessage(str_replace("%s", $this->currency_rate->caption(), $this->currency_rate->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->currency_rate->FormValue)) {
                $this->currency_rate->addErrorMessage($this->currency_rate->getErrorMessage(false));
            }
            if ($this->purchase_amount_inr->Visible && $this->purchase_amount_inr->Required) {
                if (!$this->purchase_amount_inr->IsDetailKey && EmptyValue($this->purchase_amount_inr->FormValue)) {
                    $this->purchase_amount_inr->addErrorMessage(str_replace("%s", $this->purchase_amount_inr->caption(), $this->purchase_amount_inr->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->purchase_amount_inr->FormValue)) {
                $this->purchase_amount_inr->addErrorMessage($this->purchase_amount_inr->getErrorMessage(false));
            }
            if ($this->duty_paid_by->Visible && $this->duty_paid_by->Required) {
                if (!$this->duty_paid_by->IsDetailKey && EmptyValue($this->duty_paid_by->FormValue)) {
                    $this->duty_paid_by->addErrorMessage(str_replace("%s", $this->duty_paid_by->caption(), $this->duty_paid_by->RequiredErrorMessage));
                }
            }
            if ($this->custom_duty->Visible && $this->custom_duty->Required) {
                if (!$this->custom_duty->IsDetailKey && EmptyValue($this->custom_duty->FormValue)) {
                    $this->custom_duty->addErrorMessage(str_replace("%s", $this->custom_duty->caption(), $this->custom_duty->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->custom_duty->FormValue)) {
                $this->custom_duty->addErrorMessage($this->custom_duty->getErrorMessage(false));
            }
            if ($this->transportation_charges->Visible && $this->transportation_charges->Required) {
                if (!$this->transportation_charges->IsDetailKey && EmptyValue($this->transportation_charges->FormValue)) {
                    $this->transportation_charges->addErrorMessage(str_replace("%s", $this->transportation_charges->caption(), $this->transportation_charges->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->transportation_charges->FormValue)) {
                $this->transportation_charges->addErrorMessage($this->transportation_charges->getErrorMessage(false));
            }
            if ($this->port_clearing_charge->Visible && $this->port_clearing_charge->Required) {
                if (!$this->port_clearing_charge->IsDetailKey && EmptyValue($this->port_clearing_charge->FormValue)) {
                    $this->port_clearing_charge->addErrorMessage(str_replace("%s", $this->port_clearing_charge->caption(), $this->port_clearing_charge->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->port_clearing_charge->FormValue)) {
                $this->port_clearing_charge->addErrorMessage($this->port_clearing_charge->getErrorMessage(false));
            }
            if ($this->cha_commission->Visible && $this->cha_commission->Required) {
                if (!$this->cha_commission->IsDetailKey && EmptyValue($this->cha_commission->FormValue)) {
                    $this->cha_commission->addErrorMessage(str_replace("%s", $this->cha_commission->caption(), $this->cha_commission->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->cha_commission->FormValue)) {
                $this->cha_commission->addErrorMessage($this->cha_commission->getErrorMessage(false));
            }
            if ($this->cha_agent->Visible && $this->cha_agent->Required) {
                if (!$this->cha_agent->IsDetailKey && EmptyValue($this->cha_agent->FormValue)) {
                    $this->cha_agent->addErrorMessage(str_replace("%s", $this->cha_agent->caption(), $this->cha_agent->RequiredErrorMessage));
                }
            }
            if ($this->clearance_bank->Visible && $this->clearance_bank->Required) {
                if (!$this->clearance_bank->IsDetailKey && EmptyValue($this->clearance_bank->FormValue)) {
                    $this->clearance_bank->addErrorMessage(str_replace("%s", $this->clearance_bank->caption(), $this->clearance_bank->RequiredErrorMessage));
                }
            }
            if ($this->bank_charges->Visible && $this->bank_charges->Required) {
                if (!$this->bank_charges->IsDetailKey && EmptyValue($this->bank_charges->FormValue)) {
                    $this->bank_charges->addErrorMessage(str_replace("%s", $this->bank_charges->caption(), $this->bank_charges->RequiredErrorMessage));
                }
            }
            if ($this->importer->Visible && $this->importer->Required) {
                if (!$this->importer->IsDetailKey && EmptyValue($this->importer->FormValue)) {
                    $this->importer->addErrorMessage(str_replace("%s", $this->importer->caption(), $this->importer->RequiredErrorMessage));
                }
            }
            if ($this->remarks->Visible && $this->remarks->Required) {
                if (!$this->remarks->IsDetailKey && EmptyValue($this->remarks->FormValue)) {
                    $this->remarks->addErrorMessage(str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
                }
            }
            if ($this->fiba_fibd->Visible && $this->fiba_fibd->Required) {
                if (!$this->fiba_fibd->IsDetailKey && EmptyValue($this->fiba_fibd->FormValue)) {
                    $this->fiba_fibd->addErrorMessage(str_replace("%s", $this->fiba_fibd->caption(), $this->fiba_fibd->RequiredErrorMessage));
                }
            }
            if ($this->fibc->Visible && $this->fibc->Required) {
                if (!$this->fibc->IsDetailKey && EmptyValue($this->fibc->FormValue)) {
                    $this->fibc->addErrorMessage(str_replace("%s", $this->fibc->caption(), $this->fibc->RequiredErrorMessage));
                }
            }
            if ($this->operator->Visible && $this->operator->Required) {
                if (!$this->operator->IsDetailKey && EmptyValue($this->operator->FormValue)) {
                    $this->operator->addErrorMessage(str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
                }
            }
            if ($this->datetime->Visible && $this->datetime->Required) {
                if (!$this->datetime->IsDetailKey && EmptyValue($this->datetime->FormValue)) {
                    $this->datetime->addErrorMessage(str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
                }
            }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow()
    {
        global $Security, $Language;
        $oldKeyFilter = $this->getRecordFilter();
        $filter = $this->applyUserIDFilters($oldKeyFilter);
        $conn = $this->getConnection();

        // Load old row
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $rsold = $conn->fetchAssociative($sql);
        if (!$rsold) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        } else {
            // Load old values
            $this->loadDbValues($rsold);
        }

        // Get new row
        $rsnew = $this->getEditRow($rsold);

        // Update current values
        $this->setCurrentValues($rsnew);

        // Call Row Updating event
        $updateRow = $this->rowUpdating($rsold, $rsnew);
        if ($updateRow) {
            if (count($rsnew) > 0) {
                $this->CurrentFilter = $filter; // Set up current filter
                $editRow = $this->update($rsnew, "", $rsold);
                if (!$editRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            } else {
                $editRow = true; // No field to update
            }
            if ($editRow) {
            }
        } else {
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("UpdateCancelled"));
            }
            $editRow = false;
        }

        // Call Row_Updated event
        if ($editRow) {
            $this->rowUpdated($rsold, $rsnew);
        }

        // Write JSON response
        if (IsJsonResponse() && $editRow) {
            $row = $this->getRecordsFromRecordset([$rsnew], true);
            $table = $this->TableVar;
            WriteJson(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $editRow;
    }

    /**
     * Get edit row
     *
     * @return array
     */
    protected function getEditRow($rsold)
    {
        global $Security;
        $rsnew = [];

        // gross_weight
        $this->gross_weight->setDbValueDef($rsnew, $this->gross_weight->CurrentValue, $this->gross_weight->ReadOnly);

        // net_weight
        $this->net_weight->setDbValueDef($rsnew, $this->net_weight->CurrentValue, $this->net_weight->ReadOnly);

        // packets
        $this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, $this->packets->ReadOnly);

        // packing_type
        $this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, $this->packing_type->ReadOnly);

        // containers
        $this->containers->setDbValueDef($rsnew, $this->containers->CurrentValue, $this->containers->ReadOnly);

        // shipping_line
        $this->shipping_line->setDbValueDef($rsnew, $this->shipping_line->CurrentValue, $this->shipping_line->ReadOnly);

        // port_arrival_date
        $this->port_arrival_date->setDbValueDef($rsnew, UnFormatDateTime($this->port_arrival_date->CurrentValue, $this->port_arrival_date->formatPattern()), $this->port_arrival_date->ReadOnly);

        // godown_arrival_date
        $this->godown_arrival_date->setDbValueDef($rsnew, UnFormatDateTime($this->godown_arrival_date->CurrentValue, $this->godown_arrival_date->formatPattern()), $this->godown_arrival_date->ReadOnly);

        // godown
        $this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, $this->godown->ReadOnly);

        // rack
        $this->rack->setDbValueDef($rsnew, $this->rack->CurrentValue, $this->rack->ReadOnly);

        // invoice_details
        $this->invoice_details->setDbValueDef($rsnew, $this->invoice_details->CurrentValue, $this->invoice_details->ReadOnly);

        // invoice_value
        $this->invoice_value->setDbValueDef($rsnew, $this->invoice_value->CurrentValue, $this->invoice_value->ReadOnly);

        // currency_rate
        $this->currency_rate->setDbValueDef($rsnew, $this->currency_rate->CurrentValue, $this->currency_rate->ReadOnly);

        // purchase_amount_inr
        $this->purchase_amount_inr->setDbValueDef($rsnew, $this->purchase_amount_inr->CurrentValue, $this->purchase_amount_inr->ReadOnly);

        // duty_paid_by
        $this->duty_paid_by->setDbValueDef($rsnew, $this->duty_paid_by->CurrentValue, $this->duty_paid_by->ReadOnly);

        // custom_duty
        $this->custom_duty->setDbValueDef($rsnew, $this->custom_duty->CurrentValue, $this->custom_duty->ReadOnly);

        // transportation_charges
        $this->transportation_charges->setDbValueDef($rsnew, $this->transportation_charges->CurrentValue, $this->transportation_charges->ReadOnly);

        // port_clearing_charge
        $this->port_clearing_charge->setDbValueDef($rsnew, $this->port_clearing_charge->CurrentValue, $this->port_clearing_charge->ReadOnly);

        // cha_commission
        $this->cha_commission->setDbValueDef($rsnew, $this->cha_commission->CurrentValue, $this->cha_commission->ReadOnly);

        // cha_agent
        $this->cha_agent->setDbValueDef($rsnew, $this->cha_agent->CurrentValue, $this->cha_agent->ReadOnly);

        // clearance_bank
        $this->clearance_bank->setDbValueDef($rsnew, $this->clearance_bank->CurrentValue, $this->clearance_bank->ReadOnly);

        // bank_charges
        $this->bank_charges->setDbValueDef($rsnew, $this->bank_charges->CurrentValue, $this->bank_charges->ReadOnly);

        // importer
        $this->importer->setDbValueDef($rsnew, $this->importer->CurrentValue, $this->importer->ReadOnly);

        // remarks
        $this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, $this->remarks->ReadOnly);

        // fiba_fibd
        $this->fiba_fibd->setDbValueDef($rsnew, $this->fiba_fibd->CurrentValue, $this->fiba_fibd->ReadOnly);

        // fibc
        $this->fibc->setDbValueDef($rsnew, $this->fibc->CurrentValue, $this->fibc->ReadOnly);

        // operator
        $this->operator->CurrentValue = $this->operator->getAutoUpdateValue(); // PHP
        $this->operator->setDbValueDef($rsnew, $this->operator->CurrentValue, $this->operator->ReadOnly);

        // datetime
        $this->datetime->CurrentValue = $this->datetime->getAutoUpdateValue(); // PHP
        $this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, $this->datetime->formatPattern()), $this->datetime->ReadOnly);
        return $rsnew;
    }

    /**
     * Restore edit form from row
     * @param array $row Row
     */
    protected function restoreEditFormFromRow($row)
    {
        if (isset($row['gross_weight'])) { // gross_weight
            $this->gross_weight->CurrentValue = $row['gross_weight'];
        }
        if (isset($row['net_weight'])) { // net_weight
            $this->net_weight->CurrentValue = $row['net_weight'];
        }
        if (isset($row['packets'])) { // packets
            $this->packets->CurrentValue = $row['packets'];
        }
        if (isset($row['packing_type'])) { // packing_type
            $this->packing_type->CurrentValue = $row['packing_type'];
        }
        if (isset($row['containers'])) { // containers
            $this->containers->CurrentValue = $row['containers'];
        }
        if (isset($row['shipping_line'])) { // shipping_line
            $this->shipping_line->CurrentValue = $row['shipping_line'];
        }
        if (isset($row['port_arrival_date'])) { // port_arrival_date
            $this->port_arrival_date->CurrentValue = $row['port_arrival_date'];
        }
        if (isset($row['godown_arrival_date'])) { // godown_arrival_date
            $this->godown_arrival_date->CurrentValue = $row['godown_arrival_date'];
        }
        if (isset($row['godown'])) { // godown
            $this->godown->CurrentValue = $row['godown'];
        }
        if (isset($row['rack'])) { // rack
            $this->rack->CurrentValue = $row['rack'];
        }
        if (isset($row['invoice_details'])) { // invoice_details
            $this->invoice_details->CurrentValue = $row['invoice_details'];
        }
        if (isset($row['invoice_value'])) { // invoice_value
            $this->invoice_value->CurrentValue = $row['invoice_value'];
        }
        if (isset($row['currency_rate'])) { // currency_rate
            $this->currency_rate->CurrentValue = $row['currency_rate'];
        }
        if (isset($row['purchase_amount_inr'])) { // purchase_amount_inr
            $this->purchase_amount_inr->CurrentValue = $row['purchase_amount_inr'];
        }
        if (isset($row['duty_paid_by'])) { // duty_paid_by
            $this->duty_paid_by->CurrentValue = $row['duty_paid_by'];
        }
        if (isset($row['custom_duty'])) { // custom_duty
            $this->custom_duty->CurrentValue = $row['custom_duty'];
        }
        if (isset($row['transportation_charges'])) { // transportation_charges
            $this->transportation_charges->CurrentValue = $row['transportation_charges'];
        }
        if (isset($row['port_clearing_charge'])) { // port_clearing_charge
            $this->port_clearing_charge->CurrentValue = $row['port_clearing_charge'];
        }
        if (isset($row['cha_commission'])) { // cha_commission
            $this->cha_commission->CurrentValue = $row['cha_commission'];
        }
        if (isset($row['cha_agent'])) { // cha_agent
            $this->cha_agent->CurrentValue = $row['cha_agent'];
        }
        if (isset($row['clearance_bank'])) { // clearance_bank
            $this->clearance_bank->CurrentValue = $row['clearance_bank'];
        }
        if (isset($row['bank_charges'])) { // bank_charges
            $this->bank_charges->CurrentValue = $row['bank_charges'];
        }
        if (isset($row['importer'])) { // importer
            $this->importer->CurrentValue = $row['importer'];
        }
        if (isset($row['remarks'])) { // remarks
            $this->remarks->CurrentValue = $row['remarks'];
        }
        if (isset($row['fiba_fibd'])) { // fiba_fibd
            $this->fiba_fibd->CurrentValue = $row['fiba_fibd'];
        }
        if (isset($row['fibc'])) { // fibc
            $this->fibc->CurrentValue = $row['fibc'];
        }
        if (isset($row['operator'])) { // operator
            $this->operator->CurrentValue = $row['operator'];
        }
        if (isset($row['datetime'])) { // datetime
            $this->datetime->CurrentValue = $row['datetime'];
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("db2");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("purchasealist"), "", $this->TableVar, true);
        $pageId = "edit";
        $Breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_supplier":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_booking_reference":
                    break;
                case "x_rid":
                    break;
                case "x_packing_type":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_shipping_line":
                    break;
                case "x_godown":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_duty_paid_by":
                    break;
                case "x_cha_agent":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_clearance_bank":
                    break;
                case "x_importer":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_operator":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = false;
        $recordNo = $pageNo ?? $startRec; // Record number = page number or start record
        if ($recordNo !== null && is_numeric($recordNo)) {
            $this->StartRecord = $recordNo;
        } else {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
