<?php

namespace PHPMaker2024\fibre;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Table class for purchase_a
 */
class PurchaseA extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $DbErrorMessage = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Audit trail
    public $AuditTrailOnAdd = true;
    public $AuditTrailOnEdit = true;
    public $AuditTrailOnDelete = true;
    public $AuditTrailOnView = false;
    public $AuditTrailOnViewData = false;
    public $AuditTrailOnSearch = false;

    // Ajax / Modal
    public $UseAjaxActions = false;
    public $ModalSearch = false;
    public $ModalView = false;
    public $ModalAdd = false;
    public $ModalEdit = false;
    public $ModalUpdate = false;
    public $InlineDelete = false;
    public $ModalGridAdd = false;
    public $ModalGridEdit = false;
    public $ModalMultiEdit = false;

    // Fields
    public $id;
    public $supplier;
    public $booking_reference;
    public $rid;
    public $lot_no;
    public $gross_weight;
    public $net_weight;
    public $packets;
    public $packing_type;
    public $containers;
    public $shipping_line;
    public $port_arrival_date;
    public $godown_arrival_date;
    public $godown;
    public $rack;
    public $invoice_details;
    public $invoice_value;
    public $currency_rate;
    public $purchase_amount_inr;
    public $duty_paid_by;
    public $custom_duty;
    public $transportation_charges;
    public $port_clearing_charge;
    public $cha_commission;
    public $cha_agent;
    public $clearance_bank;
    public $bank_charges;
    public $importer;
    public $remarks;
    public $fiba_fibd;
    public $fibc;
    public $operator;
    public $datetime;
    public $updated;
    public $grp;
    public $qc_remarks;
    public $qc_status;
    public $qc_operator;
    public $qc_datetime;
    public $rbi_compliance_date;
    public $age;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $CurrentLanguage, $CurrentLocale;

        // Language object
        $Language = Container("app.language");
        $this->TableVar = "purchase_a";
        $this->TableName = 'purchase_a';
        $this->TableType = "TABLE";
        $this->ImportUseTransaction = $this->supportsTransaction() && Config("IMPORT_USE_TRANSACTION");
        $this->UseTransaction = $this->supportsTransaction() && Config("USE_TRANSACTION");

        // Update Table
        $this->UpdateTable = "purchase_a";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)

        // PDF
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)

        // PhpSpreadsheet
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)

        // PHPWord
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordPageSize = "A4"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UseAjaxActions = $this->UseAjaxActions || Config("USE_AJAX_ACTIONS");
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this);
        $this->BasicSearch->TypeDefault = "OR";

        // id
        $this->id = new DbField(
            $this, // Table
            'x_id', // Variable name
            'id', // Name
            '`id`', // Expression
            '`id`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`id`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'NO' // Edit Tag
        );
        $this->id->InputTextType = "text";
        $this->id->Raw = true;
        $this->id->IsAutoIncrement = true; // Autoincrement field
        $this->id->IsPrimaryKey = true; // Primary key field
        $this->id->Nullable = false; // NOT NULL field
        $this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->id->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['id'] = &$this->id;

        // supplier
        $this->supplier = new DbField(
            $this, // Table
            'x_supplier', // Variable name
            'supplier', // Name
            '`supplier`', // Expression
            '`supplier`', // Basic search expression
            19, // Type
            8, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`supplier`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->supplier->addMethod("getSelectFilter", fn() => "`status`=1 and `category` = 1002");
        $this->supplier->addMethod("getLinkPrefix", fn() => "purchaseaflist?x_supplier=");
        $this->supplier->InputTextType = "text";
        $this->supplier->Raw = true;
        $this->supplier->Nullable = false; // NOT NULL field
        $this->supplier->Required = true; // Required field
        $this->supplier->setSelectMultiple(false); // Select one
        $this->supplier->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->supplier->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->supplier->Lookup = new Lookup($this->supplier, 'production_partner', true, 'id', ["name","code","",""], '', '', [], ["x_booking_reference"], [], [], [], [], false, '`category` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->supplier) . "',COALESCE(`code`,''))");
        $this->supplier->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->supplier->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['supplier'] = &$this->supplier;

        // booking_reference
        $this->booking_reference = new DbField(
            $this, // Table
            'x_booking_reference', // Variable name
            'booking_reference', // Name
            '`booking_reference`', // Expression
            '`booking_reference`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`booking_reference`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->booking_reference->InputTextType = "text";
        $this->booking_reference->Raw = true;
        $this->booking_reference->Nullable = false; // NOT NULL field
        $this->booking_reference->Required = true; // Required field
        $this->booking_reference->setSelectMultiple(false); // Select one
        $this->booking_reference->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->booking_reference->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->booking_reference->Lookup = new Lookup($this->booking_reference, 'booking_ref', false, 'id', ["ref","","product_code",""], '', '', ["x_supplier"], [], ["supplier_id"], ["x_supplier_id"], ["rid","packets","confirm_port_eta"], ["x_rid","x_packets","x_port_arrival_date"], false, '`ref` ASC', '', "CONCAT(COALESCE(`ref`, ''),'" . ValueSeparator(2, $this->booking_reference) . "',COALESCE(`product_code`,''))");
        $this->booking_reference->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->booking_reference->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['booking_reference'] = &$this->booking_reference;

        // rid
        $this->rid = new DbField(
            $this, // Table
            'x_rid', // Variable name
            'rid', // Name
            '`rid`', // Expression
            '`rid`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rid`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rid->addMethod("getLinkPrefix", fn() => "purchasealist?x_rid=");
        $this->rid->InputTextType = "text";
        $this->rid->Raw = true;
        $this->rid->Nullable = false; // NOT NULL field
        $this->rid->Required = true; // Required field
        $this->rid->Sortable = false; // Allow sort
        $this->rid->Lookup = new Lookup($this->rid, 'ref', true, 'id', ["product_code","","",""], '', '', [], [], [], [], [], [], true, '`product` ASC', '', "`product_code`");
        $this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->rid->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['rid'] = &$this->rid;

        // lot_no
        $this->lot_no = new DbField(
            $this, // Table
            'x_lot_no', // Variable name
            'lot_no', // Name
            '`lot_no`', // Expression
            '`lot_no`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`lot_no`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->lot_no->InputTextType = "text";
        $this->lot_no->Nullable = false; // NOT NULL field
        $this->lot_no->Required = true; // Required field
        $this->lot_no->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['lot_no'] = &$this->lot_no;

        // gross_weight
        $this->gross_weight = new DbField(
            $this, // Table
            'x_gross_weight', // Variable name
            'gross_weight', // Name
            '`gross_weight`', // Expression
            '`gross_weight`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`gross_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->gross_weight->InputTextType = "text";
        $this->gross_weight->Raw = true;
        $this->gross_weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->gross_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['gross_weight'] = &$this->gross_weight;

        // net_weight
        $this->net_weight = new DbField(
            $this, // Table
            'x_net_weight', // Variable name
            'net_weight', // Name
            '`net_weight`', // Expression
            '`net_weight`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`net_weight`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->net_weight->InputTextType = "text";
        $this->net_weight->Raw = true;
        $this->net_weight->Nullable = false; // NOT NULL field
        $this->net_weight->Required = true; // Required field
        $this->net_weight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->net_weight->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['net_weight'] = &$this->net_weight;

        // packets
        $this->packets = new DbField(
            $this, // Table
            'x_packets', // Variable name
            'packets', // Name
            '`packets`', // Expression
            '`packets`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packets`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->packets->InputTextType = "text";
        $this->packets->Raw = true;
        $this->packets->Required = true; // Required field
        $this->packets->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packets->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['packets'] = &$this->packets;

        // packing_type
        $this->packing_type = new DbField(
            $this, // Table
            'x_packing_type', // Variable name
            'packing_type', // Name
            '`packing_type`', // Expression
            '`packing_type`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`packing_type`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->packing_type->addMethod("getSelectFilter", fn() => "`id`=10 and `grp`=1");
        $this->packing_type->addMethod("getDefault", fn() => 1);
        $this->packing_type->addMethod("getLinkPrefix", fn() => "purchaseaflist?x_packing_type=");
        $this->packing_type->InputTextType = "text";
        $this->packing_type->Raw = true;
        $this->packing_type->Nullable = false; // NOT NULL field
        $this->packing_type->Required = true; // Required field
        $this->packing_type->setSelectMultiple(false); // Select one
        $this->packing_type->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->packing_type->Lookup = new Lookup($this->packing_type, 'packing_type', false, 'id', ["packing","code","",""], '', '', [], [], [], [], [], [], false, '`packing` ASC', '', "CONCAT(COALESCE(`packing`, ''),'" . ValueSeparator(1, $this->packing_type) . "',COALESCE(`code`,''))");
        $this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->packing_type->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['packing_type'] = &$this->packing_type;

        // containers
        $this->containers = new DbField(
            $this, // Table
            'x_containers', // Variable name
            'containers', // Name
            '`containers`', // Expression
            '`containers`', // Basic search expression
            131, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`containers`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->containers->InputTextType = "text";
        $this->containers->Raw = true;
        $this->containers->Nullable = false; // NOT NULL field
        $this->containers->Required = true; // Required field
        $this->containers->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->containers->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['containers'] = &$this->containers;

        // shipping_line
        $this->shipping_line = new DbField(
            $this, // Table
            'x_shipping_line', // Variable name
            'shipping_line', // Name
            '`shipping_line`', // Expression
            '`shipping_line`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`shipping_line`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->shipping_line->InputTextType = "text";
        $this->shipping_line->Raw = true;
        $this->shipping_line->setSelectMultiple(false); // Select one
        $this->shipping_line->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->shipping_line->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->shipping_line->Lookup = new Lookup($this->shipping_line, 'shipping_line', false, 'id', ["shipping_line","","",""], '', '', [], [], [], [], [], [], false, '`shipping_line` ASC', '', "`shipping_line`");
        $this->shipping_line->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['shipping_line'] = &$this->shipping_line;

        // port_arrival_date
        $this->port_arrival_date = new DbField(
            $this, // Table
            'x_port_arrival_date', // Variable name
            'port_arrival_date', // Name
            '`port_arrival_date`', // Expression
            CastDateFieldForLike("`port_arrival_date`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`port_arrival_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->port_arrival_date->InputTextType = "text";
        $this->port_arrival_date->Raw = true;
        $this->port_arrival_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->port_arrival_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['port_arrival_date'] = &$this->port_arrival_date;

        // godown_arrival_date
        $this->godown_arrival_date = new DbField(
            $this, // Table
            'x_godown_arrival_date', // Variable name
            'godown_arrival_date', // Name
            '`godown_arrival_date`', // Expression
            CastDateFieldForLike("`godown_arrival_date`", 7, "DB"), // Basic search expression
            135, // Type
            19, // Size
            7, // Date/Time format
            false, // Is upload field
            '`godown_arrival_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->godown_arrival_date->InputTextType = "text";
        $this->godown_arrival_date->Raw = true;
        $this->godown_arrival_date->DefaultErrorMessage = str_replace("%s", DateFormat(7), $Language->phrase("IncorrectDate"));
        $this->godown_arrival_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown_arrival_date'] = &$this->godown_arrival_date;

        // godown
        $this->godown = new DbField(
            $this, // Table
            'x_godown', // Variable name
            'godown', // Name
            '`godown`', // Expression
            '`godown`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`godown`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->godown->addMethod("getSelectFilter", fn() => "`id`>10");
        $this->godown->addMethod("getLinkPrefix", fn() => "purchaseaflist?x_godown=");
        $this->godown->InputTextType = "text";
        $this->godown->Raw = true;
        $this->godown->Required = true; // Required field
        $this->godown->setSelectMultiple(false); // Select one
        $this->godown->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->godown->Lookup = new Lookup($this->godown, 'godown_table', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->godown->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['godown'] = &$this->godown;

        // rack
        $this->rack = new DbField(
            $this, // Table
            'x_rack', // Variable name
            'rack', // Name
            '`rack`', // Expression
            '`rack`', // Basic search expression
            200, // Type
            24, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`rack`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rack->addMethod("getDefault", fn() => 0);
        $this->rack->InputTextType = "text";
        $this->rack->Nullable = false; // NOT NULL field
        $this->rack->Required = true; // Required field
        $this->rack->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['rack'] = &$this->rack;

        // invoice_details
        $this->invoice_details = new DbField(
            $this, // Table
            'x_invoice_details', // Variable name
            'invoice_details', // Name
            '`invoice_details`', // Expression
            '`invoice_details`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`invoice_details`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_details->InputTextType = "text";
        $this->invoice_details->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_details'] = &$this->invoice_details;

        // invoice_value
        $this->invoice_value = new DbField(
            $this, // Table
            'x_invoice_value', // Variable name
            'invoice_value', // Name
            '`invoice_value`', // Expression
            '`invoice_value`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`invoice_value`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->invoice_value->InputTextType = "text";
        $this->invoice_value->Raw = true;
        $this->invoice_value->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->invoice_value->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['invoice_value'] = &$this->invoice_value;

        // currency_rate
        $this->currency_rate = new DbField(
            $this, // Table
            'x_currency_rate', // Variable name
            'currency_rate', // Name
            '`currency_rate`', // Expression
            '`currency_rate`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`currency_rate`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->currency_rate->InputTextType = "text";
        $this->currency_rate->Raw = true;
        $this->currency_rate->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->currency_rate->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['currency_rate'] = &$this->currency_rate;

        // purchase_amount_inr
        $this->purchase_amount_inr = new DbField(
            $this, // Table
            'x_purchase_amount_inr', // Variable name
            'purchase_amount_inr', // Name
            '`purchase_amount_inr`', // Expression
            '`purchase_amount_inr`', // Basic search expression
            131, // Type
            14, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`purchase_amount_inr`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->purchase_amount_inr->InputTextType = "text";
        $this->purchase_amount_inr->Raw = true;
        $this->purchase_amount_inr->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->purchase_amount_inr->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['purchase_amount_inr'] = &$this->purchase_amount_inr;

        // duty_paid_by
        $this->duty_paid_by = new DbField(
            $this, // Table
            'x_duty_paid_by', // Variable name
            'duty_paid_by', // Name
            '`duty_paid_by`', // Expression
            '`duty_paid_by`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`duty_paid_by`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->duty_paid_by->InputTextType = "text";
        $this->duty_paid_by->Raw = true;
        $this->duty_paid_by->setSelectMultiple(false); // Select one
        $this->duty_paid_by->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->duty_paid_by->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->duty_paid_by->Lookup = new Lookup($this->duty_paid_by, 'purchase_a', false, '', ["","","",""], '', '', [], [], [], [], [], [], false, '', '', "");
        $this->duty_paid_by->OptionCount = 2;
        $this->duty_paid_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->duty_paid_by->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['duty_paid_by'] = &$this->duty_paid_by;

        // custom_duty
        $this->custom_duty = new DbField(
            $this, // Table
            'x_custom_duty', // Variable name
            'custom_duty', // Name
            '`custom_duty`', // Expression
            '`custom_duty`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`custom_duty`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->custom_duty->InputTextType = "text";
        $this->custom_duty->Raw = true;
        $this->custom_duty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->custom_duty->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['custom_duty'] = &$this->custom_duty;

        // transportation_charges
        $this->transportation_charges = new DbField(
            $this, // Table
            'x_transportation_charges', // Variable name
            'transportation_charges', // Name
            '`transportation_charges`', // Expression
            '`transportation_charges`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`transportation_charges`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->transportation_charges->InputTextType = "text";
        $this->transportation_charges->Raw = true;
        $this->transportation_charges->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->transportation_charges->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['transportation_charges'] = &$this->transportation_charges;

        // port_clearing_charge
        $this->port_clearing_charge = new DbField(
            $this, // Table
            'x_port_clearing_charge', // Variable name
            'port_clearing_charge', // Name
            '`port_clearing_charge`', // Expression
            '`port_clearing_charge`', // Basic search expression
            131, // Type
            11, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`port_clearing_charge`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->port_clearing_charge->InputTextType = "text";
        $this->port_clearing_charge->Raw = true;
        $this->port_clearing_charge->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->port_clearing_charge->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['port_clearing_charge'] = &$this->port_clearing_charge;

        // cha_commission
        $this->cha_commission = new DbField(
            $this, // Table
            'x_cha_commission', // Variable name
            'cha_commission', // Name
            '`cha_commission`', // Expression
            '`cha_commission`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cha_commission`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->cha_commission->InputTextType = "text";
        $this->cha_commission->Raw = true;
        $this->cha_commission->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
        $this->cha_commission->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cha_commission'] = &$this->cha_commission;

        // cha_agent
        $this->cha_agent = new DbField(
            $this, // Table
            'x_cha_agent', // Variable name
            'cha_agent', // Name
            '`cha_agent`', // Expression
            '`cha_agent`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`cha_agent`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->cha_agent->addMethod("getSelectFilter", fn() => "`grp` =1");
        $this->cha_agent->InputTextType = "text";
        $this->cha_agent->Raw = true;
        $this->cha_agent->setSelectMultiple(false); // Select one
        $this->cha_agent->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->cha_agent->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->cha_agent->Lookup = new Lookup($this->cha_agent, 'cha_agent', false, 'id', ["name","code","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->cha_agent) . "',COALESCE(`code`,''))");
        $this->cha_agent->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['cha_agent'] = &$this->cha_agent;

        // clearance_bank
        $this->clearance_bank = new DbField(
            $this, // Table
            'x_clearance_bank', // Variable name
            'clearance_bank', // Name
            '`clearance_bank`', // Expression
            '`clearance_bank`', // Basic search expression
            17, // Type
            3, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`clearance_bank`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->clearance_bank->InputTextType = "text";
        $this->clearance_bank->Raw = true;
        $this->clearance_bank->setSelectMultiple(false); // Select one
        $this->clearance_bank->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->clearance_bank->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->clearance_bank->Lookup = new Lookup($this->clearance_bank, 'bank', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->clearance_bank->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['clearance_bank'] = &$this->clearance_bank;

        // bank_charges
        $this->bank_charges = new DbField(
            $this, // Table
            'x_bank_charges', // Variable name
            'bank_charges', // Name
            '`bank_charges`', // Expression
            '`bank_charges`', // Basic search expression
            131, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`bank_charges`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->bank_charges->InputTextType = "text";
        $this->bank_charges->Raw = true;
        $this->bank_charges->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['bank_charges'] = &$this->bank_charges;

        // importer
        $this->importer = new DbField(
            $this, // Table
            'x_importer', // Variable name
            'importer', // Name
            '`importer`', // Expression
            '`importer`', // Basic search expression
            19, // Type
            10, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`importer`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->importer->addMethod("getSelectFilter", fn() => "`category`=1");
        $this->importer->InputTextType = "text";
        $this->importer->Raw = true;
        $this->importer->setSelectMultiple(false); // Select one
        $this->importer->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->importer->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->importer->Lookup = new Lookup($this->importer, 'production_partner', false, 'id', ["name","","",""], '', '', [], [], [], [], [], [], false, '`name` ASC', '', "`name`");
        $this->importer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->importer->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['importer'] = &$this->importer;

        // remarks
        $this->remarks = new DbField(
            $this, // Table
            'x_remarks', // Variable name
            'remarks', // Name
            '`remarks`', // Expression
            '`remarks`', // Basic search expression
            200, // Type
            150, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXTAREA' // Edit Tag
        );
        $this->remarks->InputTextType = "text";
        $this->remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['remarks'] = &$this->remarks;

        // fiba_fibd
        $this->fiba_fibd = new DbField(
            $this, // Table
            'x_fiba_fibd', // Variable name
            'fiba_fibd', // Name
            '`fiba_fibd`', // Expression
            '`fiba_fibd`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fiba_fibd`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fiba_fibd->InputTextType = "text";
        $this->fiba_fibd->Nullable = false; // NOT NULL field
        $this->fiba_fibd->Required = true; // Required field
        $this->fiba_fibd->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['fiba_fibd'] = &$this->fiba_fibd;

        // fibc
        $this->fibc = new DbField(
            $this, // Table
            'x_fibc', // Variable name
            'fibc', // Name
            '`fibc`', // Expression
            '`fibc`', // Basic search expression
            200, // Type
            48, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`fibc`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->fibc->InputTextType = "text";
        $this->fibc->Nullable = false; // NOT NULL field
        $this->fibc->Required = true; // Required field
        $this->fibc->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY"];
        $this->Fields['fibc'] = &$this->fibc;

        // operator
        $this->operator = new DbField(
            $this, // Table
            'x_operator', // Variable name
            'operator', // Name
            '`operator`', // Expression
            '`operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'SELECT' // Edit Tag
        );
        $this->operator->addMethod("getAutoUpdateValue", fn() => CurrentUserID());
        $this->operator->addMethod("getDefault", fn() => 0);
        $this->operator->InputTextType = "text";
        $this->operator->Raw = true;
        $this->operator->setSelectMultiple(false); // Select one
        $this->operator->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        $this->operator->Lookup = new Lookup($this->operator, 'admin_office', false, 'id', ["user_name","","",""], '', '', [], [], [], [], [], [], false, '`user_name` ASC', '', "`user_name`");
        $this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->operator->SearchOperators = ["=", "<>", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['operator'] = &$this->operator;

        // datetime
        $this->datetime = new DbField(
            $this, // Table
            'x_datetime', // Variable name
            'datetime', // Name
            '`datetime`', // Expression
            CastDateFieldForLike("`datetime`", 111, "DB"), // Basic search expression
            135, // Type
            19, // Size
            111, // Date/Time format
            false, // Is upload field
            '`datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->datetime->addMethod("getAutoUpdateValue", fn() => CurrentDateTime());
        $this->datetime->InputTextType = "text";
        $this->datetime->Raw = true;
        $this->datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['datetime'] = &$this->datetime;

        // updated
        $this->updated = new DbField(
            $this, // Table
            'x_updated', // Variable name
            'updated', // Name
            '`updated`', // Expression
            '`updated`', // Basic search expression
            16, // Type
            4, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`updated`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->updated->addMethod("getDefault", fn() => 0);
        $this->updated->InputTextType = "text";
        $this->updated->Raw = true;
        $this->updated->Nullable = false; // NOT NULL field
        $this->updated->Sortable = false; // Allow sort
        $this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->updated->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['updated'] = &$this->updated;

        // grp
        $this->grp = new DbField(
            $this, // Table
            'x_grp', // Variable name
            'grp', // Name
            '`grp`', // Expression
            '`grp`', // Basic search expression
            18, // Type
            5, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`grp`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->grp->InputTextType = "text";
        $this->grp->Raw = true;
        $this->grp->Nullable = false; // NOT NULL field
        $this->grp->Required = true; // Required field
        $this->grp->Sortable = false; // Allow sort
        $this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->grp->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['grp'] = &$this->grp;

        // qc_remarks
        $this->qc_remarks = new DbField(
            $this, // Table
            'x_qc_remarks', // Variable name
            'qc_remarks', // Name
            '`qc_remarks`', // Expression
            '`qc_remarks`', // Basic search expression
            200, // Type
            500, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qc_remarks`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qc_remarks->InputTextType = "text";
        $this->qc_remarks->Sortable = false; // Allow sort
        $this->qc_remarks->SearchOperators = ["=", "<>", "IN", "NOT IN", "STARTS WITH", "NOT STARTS WITH", "LIKE", "NOT LIKE", "ENDS WITH", "NOT ENDS WITH", "IS EMPTY", "IS NOT EMPTY", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_remarks'] = &$this->qc_remarks;

        // qc_status
        $this->qc_status = new DbField(
            $this, // Table
            'x_qc_status', // Variable name
            'qc_status', // Name
            '`qc_status`', // Expression
            '`qc_status`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qc_status`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qc_status->InputTextType = "text";
        $this->qc_status->Raw = true;
        $this->qc_status->Sortable = false; // Allow sort
        $this->qc_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->qc_status->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_status'] = &$this->qc_status;

        // qc_operator
        $this->qc_operator = new DbField(
            $this, // Table
            'x_qc_operator', // Variable name
            'qc_operator', // Name
            '`qc_operator`', // Expression
            '`qc_operator`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`qc_operator`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qc_operator->InputTextType = "text";
        $this->qc_operator->Raw = true;
        $this->qc_operator->Sortable = false; // Allow sort
        $this->qc_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->qc_operator->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_operator'] = &$this->qc_operator;

        // qc_datetime
        $this->qc_datetime = new DbField(
            $this, // Table
            'x_qc_datetime', // Variable name
            'qc_datetime', // Name
            '`qc_datetime`', // Expression
            CastDateFieldForLike("`qc_datetime`", 0, "DB"), // Basic search expression
            135, // Type
            19, // Size
            0, // Date/Time format
            false, // Is upload field
            '`qc_datetime`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->qc_datetime->InputTextType = "text";
        $this->qc_datetime->Raw = true;
        $this->qc_datetime->Sortable = false; // Allow sort
        $this->qc_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->qc_datetime->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['qc_datetime'] = &$this->qc_datetime;

        // rbi_compliance_date
        $this->rbi_compliance_date = new DbField(
            $this, // Table
            'x_rbi_compliance_date', // Variable name
            'rbi_compliance_date', // Name
            '`rbi_compliance_date`', // Expression
            CastDateFieldForLike("`rbi_compliance_date`", 0, "DB"), // Basic search expression
            133, // Type
            10, // Size
            0, // Date/Time format
            false, // Is upload field
            '`rbi_compliance_date`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->rbi_compliance_date->InputTextType = "text";
        $this->rbi_compliance_date->Raw = true;
        $this->rbi_compliance_date->Sortable = false; // Allow sort
        $this->rbi_compliance_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->rbi_compliance_date->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN", "IS NULL", "IS NOT NULL"];
        $this->Fields['rbi_compliance_date'] = &$this->rbi_compliance_date;

        // age
        $this->age = new DbField(
            $this, // Table
            'x_age', // Variable name
            'age', // Name
            '`age`', // Expression
            '`age`', // Basic search expression
            2, // Type
            6, // Size
            -1, // Date/Time format
            false, // Is upload field
            '`age`', // Virtual expression
            false, // Is virtual
            false, // Force selection
            false, // Is Virtual search
            'FORMATTED TEXT', // View Tag
            'TEXT' // Edit Tag
        );
        $this->age->addMethod("getDefault", fn() => 0);
        $this->age->InputTextType = "text";
        $this->age->Raw = true;
        $this->age->Nullable = false; // NOT NULL field
        $this->age->Sortable = false; // Allow sort
        $this->age->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->age->SearchOperators = ["=", "<>", "IN", "NOT IN", "<", "<=", ">", ">=", "BETWEEN", "NOT BETWEEN"];
        $this->Fields['age'] = &$this->age;

        // Add Doctrine Cache
        $this->Cache = new \Symfony\Component\Cache\Adapter\ArrayAdapter();
        $this->CacheProfile = new \Doctrine\DBAL\Cache\QueryCacheProfile(0, $this->TableVar);

        // Call Table Load event
        $this->tableLoad();
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Multiple column sort
    public function updateSort(&$fld, $ctrl)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $lastOrderBy = in_array($lastSort, ["ASC", "DESC"]) ? $sortField . " " . $lastSort : "";
            $curOrderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            if ($ctrl) {
                $orderBy = $this->getSessionOrderBy();
                $arOrderBy = !empty($orderBy) ? explode(", ", $orderBy) : [];
                if ($lastOrderBy != "" && in_array($lastOrderBy, $arOrderBy)) {
                    foreach ($arOrderBy as $key => $val) {
                        if ($val == $lastOrderBy) {
                            if ($curOrderBy == "") {
                                unset($arOrderBy[$key]);
                            } else {
                                $arOrderBy[$key] = $curOrderBy;
                            }
                        }
                    }
                } elseif ($curOrderBy != "") {
                    $arOrderBy[] = $curOrderBy;
                }
                $orderBy = implode(", ", $arOrderBy);
                $this->setSessionOrderBy($orderBy); // Save to Session
            } else {
                $this->setSessionOrderBy($curOrderBy); // Save to Session
            }
        }
    }

    // Update field sort
    public function updateFieldSort()
    {
        $orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
        $flds = GetSortFields($orderBy);
        foreach ($this->Fields as $field) {
            $fldSort = "";
            foreach ($flds as $fld) {
                if ($fld[0] == $field->Expression || $fld[0] == $field->VirtualExpression) {
                    $fldSort = $fld[1];
                }
            }
            $field->setSort($fldSort);
        }
    }

    // Render X Axis for chart
    public function renderChartXAxis($chartVar, $chartRow)
    {
        return $chartRow;
    }

    // Get FROM clause
    public function getSqlFrom()
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "purchase_a";
    }

    // Get FROM clause (for backward compatibility)
    public function sqlFrom()
    {
        return $this->getSqlFrom();
    }

    // Set FROM clause
    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    // Get SELECT clause
    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select($this->sqlSelectFields());
    }

    // Get list of fields
    private function sqlSelectFields()
    {
        $useFieldNames = false;
        $fieldNames = [];
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($this->Fields as $field) {
            $expr = $field->Expression;
            $customExpr = $field->CustomDataType?->convertToPHPValueSQL($expr, $platform) ?? $expr;
            if ($customExpr != $expr) {
                $fieldNames[] = $customExpr . " AS " . QuotedName($field->Name, $this->Dbid);
                $useFieldNames = true;
            } else {
                $fieldNames[] = $expr;
            }
        }
        return $useFieldNames ? implode(", ", $fieldNames) : "*";
    }

    // Get SELECT clause (for backward compatibility)
    public function sqlSelect()
    {
        return $this->getSqlSelect();
    }

    // Set SELECT clause
    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    // Get WHERE clause
    public function getSqlWhere()
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    // Get WHERE clause (for backward compatibility)
    public function sqlWhere()
    {
        return $this->getSqlWhere();
    }

    // Set WHERE clause
    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    // Get GROUP BY clause
    public function getSqlGroupBy()
    {
        return $this->SqlGroupBy != "" ? $this->SqlGroupBy : "";
    }

    // Get GROUP BY clause (for backward compatibility)
    public function sqlGroupBy()
    {
        return $this->getSqlGroupBy();
    }

    // set GROUP BY clause
    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    // Get HAVING clause
    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    // Get HAVING clause (for backward compatibility)
    public function sqlHaving()
    {
        return $this->getSqlHaving();
    }

    // Set HAVING clause
    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    // Get ORDER BY clause
    public function getSqlOrderBy()
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
    }

    // Get ORDER BY clause (for backward compatibility)
    public function sqlOrderBy()
    {
        return $this->getSqlOrderBy();
    }

    // set ORDER BY clause
    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter, $id = "")
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return ($allow & Allow::ADD->value) == Allow::ADD->value;
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return ($allow & Allow::EDIT->value) == Allow::EDIT->value;
            case "delete":
                return ($allow & Allow::DELETE->value) == Allow::DELETE->value;
            case "view":
                return ($allow & Allow::VIEW->value) == Allow::VIEW->value;
            case "search":
                return ($allow & Allow::SEARCH->value) == Allow::SEARCH->value;
            case "lookup":
                return ($allow & Allow::LOOKUP->value) == Allow::LOOKUP->value;
            default:
                return ($allow & Allow::LIST->value) == Allow::LIST->value;
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $sqlwrk = $sql instanceof QueryBuilder // Query builder
            ? (clone $sql)->resetQueryPart("orderBy")->getSQL()
            : $sql;
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            in_array($this->TableType, ["TABLE", "VIEW", "LINKTABLE"]) &&
            preg_match($pattern, $sqlwrk) &&
            !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*SELECT\s+DISTINCT\s+/i', $sqlwrk) &&
            !preg_match('/\s+ORDER\s+BY\s+/i', $sqlwrk)
        ) {
            $sqlcnt = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlcnt = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $cnt = $conn->fetchOne($sqlcnt);
        if ($cnt !== false) {
            return (int)$cnt;
        }
        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        $result = $conn->executeQuery($sqlwrk);
        $cnt = $result->rowCount();
        if ($cnt == 0) { // Unable to get record count, count directly
            while ($result->fetch()) {
                $cnt++;
            }
        }
        return $cnt;
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->getSqlAsQueryBuilder($where, $orderBy)->getSQL();
    }

    // Get QueryBuilder
    public function getSqlAsQueryBuilder($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        );
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $isCustomView = $this->TableType == "CUSTOMVIEW";
        $select = $isCustomView ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $isCustomView ? $this->getSqlGroupBy() : "";
        $having = $isCustomView ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    public function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->setValue($field->Expression, $parm);
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        try {
            $queryBuilder = $this->insertSql($rs);
            $result = $queryBuilder->executeStatement();
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $result = false;
            $this->DbErrorMessage = $e->getMessage();
        }
        if ($result) {
            $this->id->setDbValue($conn->lastInsertId());
            $rs['id'] = $this->id->DbValue;
            if ($this->AuditTrailOnAdd) {
                $this->writeAuditTrailOnAdd($rs);
            }
        }
        return $result;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        $platform = $this->getConnection()->getDatabasePlatform();
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $field = $this->Fields[$name];
            $parm = $queryBuilder->createPositionalParameter($value, $field->getParameterType());
            $parm = $field->CustomDataType?->convertToDatabaseValueSQL($parm, $platform) ?? $parm; // Convert database SQL
            $queryBuilder->set($field->Expression, $parm);
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        try {
            $success = $this->updateSql($rs, $where, $curfilter)->executeStatement();
            $success = $success > 0 ? $success : true;
            $this->DbErrorMessage = "";
        } catch (\Exception $e) {
            $success = false;
            $this->DbErrorMessage = $e->getMessage();
        }

        // Return auto increment field
        if ($success) {
            if (!isset($rs['id']) && !EmptyValue($this->id->CurrentValue)) {
                $rs['id'] = $this->id->CurrentValue;
            }
        }
        if ($success && $this->AuditTrailOnEdit && $rsold) {
            $rsaudit = $rs;
            $fldname = 'id';
            if (!array_key_exists($fldname, $rsaudit)) {
                $rsaudit[$fldname] = $rsold[$fldname];
            }
            $this->writeAuditTrailOnEdit($rsold, $rsaudit);
        }
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    public function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('id', $rs)) {
                AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
            }
        }
        $filter = $curfilter ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            try {
                $success = $this->deleteSql($rs, $where, $curfilter)->executeStatement();
                $this->DbErrorMessage = "";
            } catch (\Exception $e) {
                $success = false;
                $this->DbErrorMessage = $e->getMessage();
            }
        }
        if ($success && $this->AuditTrailOnDelete) {
            $this->writeAuditTrailOnDelete($rs);
        }
        return $success;
    }

    // Load DbValue from result set or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->id->DbValue = $row['id'];
        $this->supplier->DbValue = $row['supplier'];
        $this->booking_reference->DbValue = $row['booking_reference'];
        $this->rid->DbValue = $row['rid'];
        $this->lot_no->DbValue = $row['lot_no'];
        $this->gross_weight->DbValue = $row['gross_weight'];
        $this->net_weight->DbValue = $row['net_weight'];
        $this->packets->DbValue = $row['packets'];
        $this->packing_type->DbValue = $row['packing_type'];
        $this->containers->DbValue = $row['containers'];
        $this->shipping_line->DbValue = $row['shipping_line'];
        $this->port_arrival_date->DbValue = $row['port_arrival_date'];
        $this->godown_arrival_date->DbValue = $row['godown_arrival_date'];
        $this->godown->DbValue = $row['godown'];
        $this->rack->DbValue = $row['rack'];
        $this->invoice_details->DbValue = $row['invoice_details'];
        $this->invoice_value->DbValue = $row['invoice_value'];
        $this->currency_rate->DbValue = $row['currency_rate'];
        $this->purchase_amount_inr->DbValue = $row['purchase_amount_inr'];
        $this->duty_paid_by->DbValue = $row['duty_paid_by'];
        $this->custom_duty->DbValue = $row['custom_duty'];
        $this->transportation_charges->DbValue = $row['transportation_charges'];
        $this->port_clearing_charge->DbValue = $row['port_clearing_charge'];
        $this->cha_commission->DbValue = $row['cha_commission'];
        $this->cha_agent->DbValue = $row['cha_agent'];
        $this->clearance_bank->DbValue = $row['clearance_bank'];
        $this->bank_charges->DbValue = $row['bank_charges'];
        $this->importer->DbValue = $row['importer'];
        $this->remarks->DbValue = $row['remarks'];
        $this->fiba_fibd->DbValue = $row['fiba_fibd'];
        $this->fibc->DbValue = $row['fibc'];
        $this->operator->DbValue = $row['operator'];
        $this->datetime->DbValue = $row['datetime'];
        $this->updated->DbValue = $row['updated'];
        $this->grp->DbValue = $row['grp'];
        $this->qc_remarks->DbValue = $row['qc_remarks'];
        $this->qc_status->DbValue = $row['qc_status'];
        $this->qc_operator->DbValue = $row['qc_operator'];
        $this->qc_datetime->DbValue = $row['qc_datetime'];
        $this->rbi_compliance_date->DbValue = $row['rbi_compliance_date'];
        $this->age->DbValue = $row['age'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`id` = @id@";
    }

    // Get Key
    public function getKey($current = false, $keySeparator = null)
    {
        $keys = [];
        $val = $current ? $this->id->CurrentValue : $this->id->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        return implode($keySeparator, $keys);
    }

    // Set Key
    public function setKey($key, $current = false, $keySeparator = null)
    {
        $keySeparator ??= Config("COMPOSITE_KEY_SEPARATOR");
        $this->OldKey = strval($key);
        $keys = explode($keySeparator, $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->id->CurrentValue = $keys[0];
            } else {
                $this->id->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null, $current = false)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('id', $row) ? $row['id'] : null;
        } else {
            $val = !EmptyValue($this->id->OldValue) && !$current ? $this->id->OldValue : $this->id->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("purchasealist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        return match ($pageName) {
            "purchaseaview" => $Language->phrase("View"),
            "purchaseaedit" => $Language->phrase("Edit"),
            "purchaseaadd" => $Language->phrase("Add"),
            default => ""
        };
    }

    // Default route URL
    public function getDefaultRouteUrl()
    {
        return "purchasealist";
    }

    // API page name
    public function getApiPageName($action)
    {
        return match (strtolower($action)) {
            Config("API_VIEW_ACTION") => "PurchaseAView",
            Config("API_ADD_ACTION") => "PurchaseAAdd",
            Config("API_EDIT_ACTION") => "PurchaseAEdit",
            Config("API_DELETE_ACTION") => "PurchaseADelete",
            Config("API_LIST_ACTION") => "PurchaseAList",
            default => ""
        };
    }

    // Current URL
    public function getCurrentUrl($parm = "")
    {
        $url = CurrentPageUrl(false);
        if ($parm != "") {
            $url = $this->keyUrl($url, $parm);
        } else {
            $url = $this->keyUrl($url, Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // List URL
    public function getListUrl()
    {
        return "purchasealist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("purchaseaview", $parm);
        } else {
            $url = $this->keyUrl("purchaseaview", Config("TABLE_SHOW_DETAIL") . "=");
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "purchaseaadd?" . $parm;
        } else {
            $url = "purchaseaadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("purchaseaedit", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl("purchasealist", "action=edit");
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("purchaseaadd", $parm);
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl("purchasealist", "action=copy");
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl($parm = "")
    {
        if ($this->UseAjaxActions && ConvertToBool(Param("infinitescroll")) && CurrentPageID() == "list") {
            return $this->keyUrl(GetApiUrl(Config("API_DELETE_ACTION") . "/" . $this->TableVar));
        } else {
            return $this->keyUrl("purchaseadelete", $parm);
        }
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "\"id\":" . VarToJson($this->id->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->id->CurrentValue !== null) {
            $url .= "/" . $this->encodeKeyValue($this->id->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderFieldHeader($fld)
    {
        global $Security, $Language;
        $sortUrl = "";
        $attrs = "";
        if ($this->PageID != "grid" && $fld->Sortable) {
            $sortUrl = $this->sortUrl($fld);
            $attrs = ' role="button" data-ew-action="sort" data-ajax="' . ($this->UseAjaxActions ? "true" : "false") . '" data-sort-url="' . $sortUrl . '" data-sort-type="2"';
            if ($this->ContextClass) { // Add context
                $attrs .= ' data-context="' . HtmlEncode($this->ContextClass) . '"';
            }
        }
        $html = '<div class="ew-table-header-caption"' . $attrs . '>' . $fld->caption() . '</div>';
        if ($sortUrl) {
            $html .= '<div class="ew-table-header-sort">' . $fld->getSortIcon() . '</div>';
        }
        if ($this->PageID != "grid" && !$this->isExport() && $fld->UseFilter && $Security->canSearch()) {
            $html .= '<div class="ew-filter-dropdown-btn" data-ew-action="filter" data-table="' . $fld->TableVar . '" data-field="' . $fld->FieldVar .
                '"><div class="ew-table-header-filter" role="button" aria-haspopup="true">' . $Language->phrase("Filter") .
                (is_array($fld->EditValue) ? str_replace("%c", count($fld->EditValue), $Language->phrase("FilterCount")) : '') .
                '</div></div>';
        }
        $html = '<div class="ew-table-header-btn">' . $html . '</div>';
        if ($this->UseCustomTemplate) {
            $scriptId = str_replace("{id}", $fld->TableVar . "_" . $fld->Param, "tpc_{id}");
            $html = '<template id="' . $scriptId . '">' . $html . '</template>';
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        global $DashboardReport;
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = "order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort();
            if ($DashboardReport) {
                $urlParm .= "&amp;" . Config("PAGE_DASHBOARD") . "=" . $DashboardReport;
            }
            return $this->addMasterUrl($this->CurrentPageName . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            $isApi = IsApi();
            $keyValues = $isApi
                ? (Route(0) == "export"
                    ? array_map(fn ($i) => Route($i + 3), range(0, 0))  // Export API
                    : array_map(fn ($i) => Route($i + 2), range(0, 0))) // Other API
                : []; // Non-API
            if (($keyValue = Param("id") ?? Route("id")) !== null) {
                $arKeys[] = $keyValue;
            } elseif ($isApi && (($keyValue = Key(0) ?? $keyValues[0] ?? null) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from records
    public function getFilterFromRecords($rows)
    {
        return implode(" OR ", array_map(fn($row) => "(" . $this->getRecordFilter($row) . ")", $rows));
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->id->CurrentValue = $key;
            } else {
                $this->id->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load result set based on filter/sort
    public function loadRs($filter, $sort = "")
    {
        $sql = $this->getSql($filter, $sort); // Set up filter (WHERE Clause) / sort (ORDER BY Clause)
        $conn = $this->getConnection();
        return $conn->executeQuery($sql);
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->id->setDbValue($row['id']);
        $this->supplier->setDbValue($row['supplier']);
        $this->booking_reference->setDbValue($row['booking_reference']);
        $this->rid->setDbValue($row['rid']);
        $this->lot_no->setDbValue($row['lot_no']);
        $this->gross_weight->setDbValue($row['gross_weight']);
        $this->net_weight->setDbValue($row['net_weight']);
        $this->packets->setDbValue($row['packets']);
        $this->packing_type->setDbValue($row['packing_type']);
        $this->containers->setDbValue($row['containers']);
        $this->shipping_line->setDbValue($row['shipping_line']);
        $this->port_arrival_date->setDbValue($row['port_arrival_date']);
        $this->godown_arrival_date->setDbValue($row['godown_arrival_date']);
        $this->godown->setDbValue($row['godown']);
        $this->rack->setDbValue($row['rack']);
        $this->invoice_details->setDbValue($row['invoice_details']);
        $this->invoice_value->setDbValue($row['invoice_value']);
        $this->currency_rate->setDbValue($row['currency_rate']);
        $this->purchase_amount_inr->setDbValue($row['purchase_amount_inr']);
        $this->duty_paid_by->setDbValue($row['duty_paid_by']);
        $this->custom_duty->setDbValue($row['custom_duty']);
        $this->transportation_charges->setDbValue($row['transportation_charges']);
        $this->port_clearing_charge->setDbValue($row['port_clearing_charge']);
        $this->cha_commission->setDbValue($row['cha_commission']);
        $this->cha_agent->setDbValue($row['cha_agent']);
        $this->clearance_bank->setDbValue($row['clearance_bank']);
        $this->bank_charges->setDbValue($row['bank_charges']);
        $this->importer->setDbValue($row['importer']);
        $this->remarks->setDbValue($row['remarks']);
        $this->fiba_fibd->setDbValue($row['fiba_fibd']);
        $this->fibc->setDbValue($row['fibc']);
        $this->operator->setDbValue($row['operator']);
        $this->datetime->setDbValue($row['datetime']);
        $this->updated->setDbValue($row['updated']);
        $this->grp->setDbValue($row['grp']);
        $this->qc_remarks->setDbValue($row['qc_remarks']);
        $this->qc_status->setDbValue($row['qc_status']);
        $this->qc_operator->setDbValue($row['qc_operator']);
        $this->qc_datetime->setDbValue($row['qc_datetime']);
        $this->rbi_compliance_date->setDbValue($row['rbi_compliance_date']);
        $this->age->setDbValue($row['age']);
    }

    // Render list content
    public function renderListContent($filter)
    {
        global $Response;
        $listPage = "PurchaseAList";
        $listClass = PROJECT_NAMESPACE . $listPage;
        $page = new $listClass();
        $page->loadRecordsetFromFilter($filter);
        $view = Container("app.view");
        $template = $listPage . ".php"; // View
        $GLOBALS["Title"] ??= $page->Title; // Title
        try {
            $Response = $view->render($Response, $template, $GLOBALS);
        } finally {
            $page->terminate(); // Terminate page and clean up
        }
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // id

        // supplier

        // booking_reference

        // rid
        $this->rid->CellCssStyle = "white-space: nowrap;";

        // lot_no

        // gross_weight

        // net_weight

        // packets

        // packing_type

        // containers

        // shipping_line

        // port_arrival_date

        // godown_arrival_date

        // godown

        // rack

        // invoice_details

        // invoice_value

        // currency_rate

        // purchase_amount_inr

        // duty_paid_by

        // custom_duty

        // transportation_charges

        // port_clearing_charge

        // cha_commission

        // cha_agent

        // clearance_bank

        // bank_charges

        // importer

        // remarks

        // fiba_fibd

        // fibc

        // operator

        // datetime

        // updated
        $this->updated->CellCssStyle = "white-space: nowrap;";

        // grp
        $this->grp->CellCssStyle = "white-space: nowrap;";

        // qc_remarks
        $this->qc_remarks->CellCssStyle = "white-space: nowrap;";

        // qc_status
        $this->qc_status->CellCssStyle = "white-space: nowrap;";

        // qc_operator
        $this->qc_operator->CellCssStyle = "white-space: nowrap;";

        // qc_datetime
        $this->qc_datetime->CellCssStyle = "white-space: nowrap;";

        // rbi_compliance_date
        $this->rbi_compliance_date->CellCssStyle = "white-space: nowrap;";

        // age
        $this->age->CellCssStyle = "white-space: nowrap;";

        // id
        $this->id->ViewValue = $this->id->CurrentValue;

        // supplier
        $curVal = strval($this->supplier->CurrentValue);
        if ($curVal != "") {
            $this->supplier->ViewValue = $this->supplier->lookupCacheOption($curVal);
            if ($this->supplier->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                    $this->supplier->ViewValue = $this->supplier->displayValue($arwrk);
                } else {
                    $this->supplier->ViewValue = $this->supplier->CurrentValue;
                }
            }
        } else {
            $this->supplier->ViewValue = null;
        }

        // booking_reference
        $curVal = strval($this->booking_reference->CurrentValue);
        if ($curVal != "") {
            $this->booking_reference->ViewValue = $this->booking_reference->lookupCacheOption($curVal);
            if ($this->booking_reference->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->booking_reference->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_reference->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->booking_reference->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->booking_reference->Lookup->renderViewRow($rswrk[0]);
                    $this->booking_reference->ViewValue = $this->booking_reference->displayValue($arwrk);
                } else {
                    $this->booking_reference->ViewValue = $this->booking_reference->CurrentValue;
                }
            }
        } else {
            $this->booking_reference->ViewValue = null;
        }

        // rid
        $this->rid->ViewValue = $this->rid->CurrentValue;
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->ViewValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->ViewValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->ViewValue = null;
        }

        // lot_no
        $this->lot_no->ViewValue = $this->lot_no->CurrentValue;

        // gross_weight
        $this->gross_weight->ViewValue = $this->gross_weight->CurrentValue;
        $this->gross_weight->ViewValue = FormatNumber($this->gross_weight->ViewValue, $this->gross_weight->formatPattern());

        // net_weight
        $this->net_weight->ViewValue = $this->net_weight->CurrentValue;
        $this->net_weight->ViewValue = FormatNumber($this->net_weight->ViewValue, $this->net_weight->formatPattern());

        // packets
        $this->packets->ViewValue = $this->packets->CurrentValue;
        $this->packets->ViewValue = FormatNumber($this->packets->ViewValue, $this->packets->formatPattern());

        // packing_type
        $curVal = strval($this->packing_type->CurrentValue);
        if ($curVal != "") {
            $this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
            if ($this->packing_type->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->packing_type->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->packing_type->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->packing_type->getSelectFilter($this); // PHP
                $sqlWrk = $this->packing_type->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->packing_type->Lookup->renderViewRow($rswrk[0]);
                    $this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
                } else {
                    $this->packing_type->ViewValue = $this->packing_type->CurrentValue;
                }
            }
        } else {
            $this->packing_type->ViewValue = null;
        }

        // containers
        $this->containers->ViewValue = $this->containers->CurrentValue;
        $this->containers->ViewValue = FormatNumber($this->containers->ViewValue, $this->containers->formatPattern());

        // shipping_line
        $curVal = strval($this->shipping_line->CurrentValue);
        if ($curVal != "") {
            $this->shipping_line->ViewValue = $this->shipping_line->lookupCacheOption($curVal);
            if ($this->shipping_line->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->shipping_line->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->shipping_line->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->shipping_line->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->shipping_line->Lookup->renderViewRow($rswrk[0]);
                    $this->shipping_line->ViewValue = $this->shipping_line->displayValue($arwrk);
                } else {
                    $this->shipping_line->ViewValue = $this->shipping_line->CurrentValue;
                }
            }
        } else {
            $this->shipping_line->ViewValue = null;
        }

        // port_arrival_date
        $this->port_arrival_date->ViewValue = $this->port_arrival_date->CurrentValue;
        $this->port_arrival_date->ViewValue = FormatDateTime($this->port_arrival_date->ViewValue, $this->port_arrival_date->formatPattern());

        // godown_arrival_date
        $this->godown_arrival_date->ViewValue = $this->godown_arrival_date->CurrentValue;
        $this->godown_arrival_date->ViewValue = FormatDateTime($this->godown_arrival_date->ViewValue, $this->godown_arrival_date->formatPattern());

        // godown
        $curVal = strval($this->godown->CurrentValue);
        if ($curVal != "") {
            $this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
            if ($this->godown->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->godown->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->godown->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->godown->getSelectFilter($this); // PHP
                $sqlWrk = $this->godown->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->godown->Lookup->renderViewRow($rswrk[0]);
                    $this->godown->ViewValue = $this->godown->displayValue($arwrk);
                } else {
                    $this->godown->ViewValue = $this->godown->CurrentValue;
                }
            }
        } else {
            $this->godown->ViewValue = null;
        }

        // rack
        $this->rack->ViewValue = $this->rack->CurrentValue;

        // invoice_details
        $this->invoice_details->ViewValue = $this->invoice_details->CurrentValue;

        // invoice_value
        $this->invoice_value->ViewValue = $this->invoice_value->CurrentValue;
        $this->invoice_value->ViewValue = FormatNumber($this->invoice_value->ViewValue, $this->invoice_value->formatPattern());

        // currency_rate
        $this->currency_rate->ViewValue = $this->currency_rate->CurrentValue;
        $this->currency_rate->ViewValue = FormatCurrency($this->currency_rate->ViewValue, $this->currency_rate->formatPattern());

        // purchase_amount_inr
        $this->purchase_amount_inr->ViewValue = $this->purchase_amount_inr->CurrentValue;
        $this->purchase_amount_inr->ViewValue = FormatNumber($this->purchase_amount_inr->ViewValue, $this->purchase_amount_inr->formatPattern());

        // duty_paid_by
        if (strval($this->duty_paid_by->CurrentValue) != "") {
            $this->duty_paid_by->ViewValue = $this->duty_paid_by->optionCaption($this->duty_paid_by->CurrentValue);
        } else {
            $this->duty_paid_by->ViewValue = null;
        }

        // custom_duty
        $this->custom_duty->ViewValue = $this->custom_duty->CurrentValue;
        $this->custom_duty->ViewValue = FormatNumber($this->custom_duty->ViewValue, $this->custom_duty->formatPattern());

        // transportation_charges
        $this->transportation_charges->ViewValue = $this->transportation_charges->CurrentValue;
        $this->transportation_charges->ViewValue = FormatNumber($this->transportation_charges->ViewValue, $this->transportation_charges->formatPattern());

        // port_clearing_charge
        $this->port_clearing_charge->ViewValue = $this->port_clearing_charge->CurrentValue;
        $this->port_clearing_charge->ViewValue = FormatNumber($this->port_clearing_charge->ViewValue, $this->port_clearing_charge->formatPattern());

        // cha_commission
        $this->cha_commission->ViewValue = $this->cha_commission->CurrentValue;
        $this->cha_commission->ViewValue = FormatNumber($this->cha_commission->ViewValue, $this->cha_commission->formatPattern());

        // cha_agent
        $curVal = strval($this->cha_agent->CurrentValue);
        if ($curVal != "") {
            $this->cha_agent->ViewValue = $this->cha_agent->lookupCacheOption($curVal);
            if ($this->cha_agent->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->cha_agent->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->cha_agent->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->cha_agent->getSelectFilter($this); // PHP
                $sqlWrk = $this->cha_agent->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->cha_agent->Lookup->renderViewRow($rswrk[0]);
                    $this->cha_agent->ViewValue = $this->cha_agent->displayValue($arwrk);
                } else {
                    $this->cha_agent->ViewValue = $this->cha_agent->CurrentValue;
                }
            }
        } else {
            $this->cha_agent->ViewValue = null;
        }

        // clearance_bank
        $curVal = strval($this->clearance_bank->CurrentValue);
        if ($curVal != "") {
            $this->clearance_bank->ViewValue = $this->clearance_bank->lookupCacheOption($curVal);
            if ($this->clearance_bank->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->clearance_bank->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->clearance_bank->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->clearance_bank->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->clearance_bank->Lookup->renderViewRow($rswrk[0]);
                    $this->clearance_bank->ViewValue = $this->clearance_bank->displayValue($arwrk);
                } else {
                    $this->clearance_bank->ViewValue = $this->clearance_bank->CurrentValue;
                }
            }
        } else {
            $this->clearance_bank->ViewValue = null;
        }

        // bank_charges
        $this->bank_charges->ViewValue = $this->bank_charges->CurrentValue;
        $this->bank_charges->ViewValue = FormatNumber($this->bank_charges->ViewValue, $this->bank_charges->formatPattern());

        // importer
        $curVal = strval($this->importer->CurrentValue);
        if ($curVal != "") {
            $this->importer->ViewValue = $this->importer->lookupCacheOption($curVal);
            if ($this->importer->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->importer->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->importer->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->importer->getSelectFilter($this); // PHP
                $sqlWrk = $this->importer->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->importer->Lookup->renderViewRow($rswrk[0]);
                    $this->importer->ViewValue = $this->importer->displayValue($arwrk);
                } else {
                    $this->importer->ViewValue = $this->importer->CurrentValue;
                }
            }
        } else {
            $this->importer->ViewValue = null;
        }

        // remarks
        $this->remarks->ViewValue = $this->remarks->CurrentValue;

        // fiba_fibd
        $this->fiba_fibd->ViewValue = $this->fiba_fibd->CurrentValue;

        // fibc
        $this->fibc->ViewValue = $this->fibc->CurrentValue;

        // operator
        $curVal = strval($this->operator->CurrentValue);
        if ($curVal != "") {
            $this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
            if ($this->operator->ViewValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->operator->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->operator->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->operator->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->operator->Lookup->renderViewRow($rswrk[0]);
                    $this->operator->ViewValue = $this->operator->displayValue($arwrk);
                } else {
                    $this->operator->ViewValue = $this->operator->CurrentValue;
                }
            }
        } else {
            $this->operator->ViewValue = null;
        }

        // datetime
        $this->datetime->ViewValue = $this->datetime->CurrentValue;
        $this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, $this->datetime->formatPattern());

        // updated
        $this->updated->ViewValue = $this->updated->CurrentValue;

        // grp
        $this->grp->ViewValue = $this->grp->CurrentValue;
        $this->grp->ViewValue = FormatNumber($this->grp->ViewValue, $this->grp->formatPattern());

        // qc_remarks
        $this->qc_remarks->ViewValue = $this->qc_remarks->CurrentValue;

        // qc_status
        $this->qc_status->ViewValue = $this->qc_status->CurrentValue;
        $this->qc_status->ViewValue = FormatNumber($this->qc_status->ViewValue, $this->qc_status->formatPattern());

        // qc_operator
        $this->qc_operator->ViewValue = $this->qc_operator->CurrentValue;
        $this->qc_operator->ViewValue = FormatNumber($this->qc_operator->ViewValue, $this->qc_operator->formatPattern());

        // qc_datetime
        $this->qc_datetime->ViewValue = $this->qc_datetime->CurrentValue;
        $this->qc_datetime->ViewValue = FormatDateTime($this->qc_datetime->ViewValue, $this->qc_datetime->formatPattern());

        // rbi_compliance_date
        $this->rbi_compliance_date->ViewValue = $this->rbi_compliance_date->CurrentValue;
        $this->rbi_compliance_date->ViewValue = FormatDateTime($this->rbi_compliance_date->ViewValue, $this->rbi_compliance_date->formatPattern());

        // age
        $this->age->ViewValue = $this->age->CurrentValue;
        $this->age->ViewValue = FormatNumber($this->age->ViewValue, $this->age->formatPattern());

        // id
        $this->id->HrefValue = "";
        $this->id->TooltipValue = "";

        // supplier
        if (!EmptyValue($this->supplier->CurrentValue)) {
            $this->supplier->HrefValue = $this->supplier->getLinkPrefix() . $this->supplier->CurrentValue; // Add prefix/suffix
            $this->supplier->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->supplier->HrefValue = FullUrl($this->supplier->HrefValue, "href");
            }
        } else {
            $this->supplier->HrefValue = "";
        }
        $this->supplier->TooltipValue = "";

        // booking_reference
        $this->booking_reference->HrefValue = "";
        $this->booking_reference->TooltipValue = "";

        // rid
        if (!EmptyValue($this->rid->CurrentValue)) {
            $this->rid->HrefValue = $this->rid->getLinkPrefix() . $this->rid->CurrentValue; // Add prefix/suffix
            $this->rid->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
            }
        } else {
            $this->rid->HrefValue = "";
        }
        $this->rid->TooltipValue = "";

        // lot_no
        $this->lot_no->HrefValue = "";
        $this->lot_no->TooltipValue = "";

        // gross_weight
        $this->gross_weight->HrefValue = "";
        $this->gross_weight->TooltipValue = "";

        // net_weight
        $this->net_weight->HrefValue = "";
        $this->net_weight->TooltipValue = "";

        // packets
        $this->packets->HrefValue = "";
        $this->packets->TooltipValue = "";

        // packing_type
        if (!EmptyValue($this->packing_type->CurrentValue)) {
            $this->packing_type->HrefValue = $this->packing_type->getLinkPrefix() . $this->packing_type->CurrentValue; // Add prefix/suffix
            $this->packing_type->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
            }
        } else {
            $this->packing_type->HrefValue = "";
        }
        $this->packing_type->TooltipValue = "";

        // containers
        $this->containers->HrefValue = "";
        $this->containers->TooltipValue = "";

        // shipping_line
        $this->shipping_line->HrefValue = "";
        $this->shipping_line->TooltipValue = "";

        // port_arrival_date
        $this->port_arrival_date->HrefValue = "";
        $this->port_arrival_date->TooltipValue = "";

        // godown_arrival_date
        $this->godown_arrival_date->HrefValue = "";
        $this->godown_arrival_date->TooltipValue = "";

        // godown
        if (!EmptyValue($this->godown->CurrentValue)) {
            $this->godown->HrefValue = $this->godown->getLinkPrefix() . $this->godown->CurrentValue; // Add prefix/suffix
            $this->godown->LinkAttrs["target"] = "_self"; // Add target
            if ($this->isExport()) {
                $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
            }
        } else {
            $this->godown->HrefValue = "";
        }
        $this->godown->TooltipValue = "";

        // rack
        $this->rack->HrefValue = "";
        $this->rack->TooltipValue = "";

        // invoice_details
        $this->invoice_details->HrefValue = "";
        $this->invoice_details->TooltipValue = "";

        // invoice_value
        $this->invoice_value->HrefValue = "";
        $this->invoice_value->TooltipValue = "";

        // currency_rate
        $this->currency_rate->HrefValue = "";
        $this->currency_rate->TooltipValue = "";

        // purchase_amount_inr
        $this->purchase_amount_inr->HrefValue = "";
        $this->purchase_amount_inr->TooltipValue = "";

        // duty_paid_by
        $this->duty_paid_by->HrefValue = "";
        $this->duty_paid_by->TooltipValue = "";

        // custom_duty
        $this->custom_duty->HrefValue = "";
        $this->custom_duty->TooltipValue = "";

        // transportation_charges
        $this->transportation_charges->HrefValue = "";
        $this->transportation_charges->TooltipValue = "";

        // port_clearing_charge
        $this->port_clearing_charge->HrefValue = "";
        $this->port_clearing_charge->TooltipValue = "";

        // cha_commission
        $this->cha_commission->HrefValue = "";
        $this->cha_commission->TooltipValue = "";

        // cha_agent
        $this->cha_agent->HrefValue = "";
        $this->cha_agent->TooltipValue = "";

        // clearance_bank
        $this->clearance_bank->HrefValue = "";
        $this->clearance_bank->TooltipValue = "";

        // bank_charges
        $this->bank_charges->HrefValue = "";
        $this->bank_charges->TooltipValue = "";

        // importer
        $this->importer->HrefValue = "";
        $this->importer->TooltipValue = "";

        // remarks
        $this->remarks->HrefValue = "";
        $this->remarks->TooltipValue = "";

        // fiba_fibd
        $this->fiba_fibd->HrefValue = "";
        $this->fiba_fibd->TooltipValue = "";

        // fibc
        $this->fibc->HrefValue = "";
        $this->fibc->TooltipValue = "";

        // operator
        $this->operator->HrefValue = "";
        $this->operator->TooltipValue = "";

        // datetime
        $this->datetime->HrefValue = "";
        $this->datetime->TooltipValue = "";

        // updated
        $this->updated->HrefValue = "";
        $this->updated->TooltipValue = "";

        // grp
        $this->grp->HrefValue = "";
        $this->grp->TooltipValue = "";

        // qc_remarks
        $this->qc_remarks->HrefValue = "";
        $this->qc_remarks->TooltipValue = "";

        // qc_status
        $this->qc_status->HrefValue = "";
        $this->qc_status->TooltipValue = "";

        // qc_operator
        $this->qc_operator->HrefValue = "";
        $this->qc_operator->TooltipValue = "";

        // qc_datetime
        $this->qc_datetime->HrefValue = "";
        $this->qc_datetime->TooltipValue = "";

        // rbi_compliance_date
        $this->rbi_compliance_date->HrefValue = "";
        $this->rbi_compliance_date->TooltipValue = "";

        // age
        $this->age->HrefValue = "";
        $this->age->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // id
        $this->id->setupEditAttributes();
        $this->id->EditValue = $this->id->CurrentValue;

        // supplier
        $this->supplier->setupEditAttributes();
        $curVal = strval($this->supplier->CurrentValue);
        if ($curVal != "") {
            $this->supplier->EditValue = $this->supplier->lookupCacheOption($curVal);
            if ($this->supplier->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->supplier->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->supplier->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $lookupFilter = $this->supplier->getSelectFilter($this); // PHP
                $sqlWrk = $this->supplier->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->supplier->Lookup->renderViewRow($rswrk[0]);
                    $this->supplier->EditValue = $this->supplier->displayValue($arwrk);
                } else {
                    $this->supplier->EditValue = $this->supplier->CurrentValue;
                }
            }
        } else {
            $this->supplier->EditValue = null;
        }

        // booking_reference
        $this->booking_reference->setupEditAttributes();
        $curVal = strval($this->booking_reference->CurrentValue);
        if ($curVal != "") {
            $this->booking_reference->EditValue = $this->booking_reference->lookupCacheOption($curVal);
            if ($this->booking_reference->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->booking_reference->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->booking_reference->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->booking_reference->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->booking_reference->Lookup->renderViewRow($rswrk[0]);
                    $this->booking_reference->EditValue = $this->booking_reference->displayValue($arwrk);
                } else {
                    $this->booking_reference->EditValue = $this->booking_reference->CurrentValue;
                }
            }
        } else {
            $this->booking_reference->EditValue = null;
        }

        // rid
        $this->rid->setupEditAttributes();
        $this->rid->EditValue = $this->rid->CurrentValue;
        $curVal = strval($this->rid->CurrentValue);
        if ($curVal != "") {
            $this->rid->EditValue = $this->rid->lookupCacheOption($curVal);
            if ($this->rid->EditValue === null) { // Lookup from database
                $filterWrk = SearchFilter($this->rid->Lookup->getTable()->Fields["id"]->searchExpression(), "=", $curVal, $this->rid->Lookup->getTable()->Fields["id"]->searchDataType(), "");
                $sqlWrk = $this->rid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->rid->Lookup->renderViewRow($rswrk[0]);
                    $this->rid->EditValue = $this->rid->displayValue($arwrk);
                } else {
                    $this->rid->EditValue = $this->rid->CurrentValue;
                }
            }
        } else {
            $this->rid->EditValue = null;
        }

        // lot_no
        $this->lot_no->setupEditAttributes();
        $this->lot_no->EditValue = $this->lot_no->CurrentValue;

        // gross_weight
        $this->gross_weight->setupEditAttributes();
        $this->gross_weight->EditValue = $this->gross_weight->CurrentValue;
        $this->gross_weight->PlaceHolder = RemoveHtml($this->gross_weight->caption());
        if (strval($this->gross_weight->EditValue) != "" && is_numeric($this->gross_weight->EditValue)) {
            $this->gross_weight->EditValue = FormatNumber($this->gross_weight->EditValue, null);
        }

        // net_weight
        $this->net_weight->setupEditAttributes();
        $this->net_weight->EditValue = $this->net_weight->CurrentValue;
        $this->net_weight->PlaceHolder = RemoveHtml($this->net_weight->caption());
        if (strval($this->net_weight->EditValue) != "" && is_numeric($this->net_weight->EditValue)) {
            $this->net_weight->EditValue = FormatNumber($this->net_weight->EditValue, null);
        }

        // packets
        $this->packets->setupEditAttributes();
        $this->packets->EditValue = $this->packets->CurrentValue;
        $this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
        if (strval($this->packets->EditValue) != "" && is_numeric($this->packets->EditValue)) {
            $this->packets->EditValue = FormatNumber($this->packets->EditValue, null);
        }

        // packing_type
        $this->packing_type->setupEditAttributes();
        $this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

        // containers
        $this->containers->setupEditAttributes();
        $this->containers->EditValue = $this->containers->CurrentValue;
        $this->containers->PlaceHolder = RemoveHtml($this->containers->caption());
        if (strval($this->containers->EditValue) != "" && is_numeric($this->containers->EditValue)) {
            $this->containers->EditValue = FormatNumber($this->containers->EditValue, null);
        }

        // shipping_line
        $this->shipping_line->setupEditAttributes();
        $this->shipping_line->PlaceHolder = RemoveHtml($this->shipping_line->caption());

        // port_arrival_date
        $this->port_arrival_date->setupEditAttributes();
        $this->port_arrival_date->EditValue = FormatDateTime($this->port_arrival_date->CurrentValue, $this->port_arrival_date->formatPattern());
        $this->port_arrival_date->PlaceHolder = RemoveHtml($this->port_arrival_date->caption());

        // godown_arrival_date
        $this->godown_arrival_date->setupEditAttributes();
        $this->godown_arrival_date->EditValue = FormatDateTime($this->godown_arrival_date->CurrentValue, $this->godown_arrival_date->formatPattern());
        $this->godown_arrival_date->PlaceHolder = RemoveHtml($this->godown_arrival_date->caption());

        // godown
        $this->godown->setupEditAttributes();
        $this->godown->PlaceHolder = RemoveHtml($this->godown->caption());

        // rack
        $this->rack->setupEditAttributes();
        if (!$this->rack->Raw) {
            $this->rack->CurrentValue = HtmlDecode($this->rack->CurrentValue);
        }
        $this->rack->EditValue = $this->rack->CurrentValue;
        $this->rack->PlaceHolder = RemoveHtml($this->rack->caption());

        // invoice_details
        $this->invoice_details->setupEditAttributes();
        if (!$this->invoice_details->Raw) {
            $this->invoice_details->CurrentValue = HtmlDecode($this->invoice_details->CurrentValue);
        }
        $this->invoice_details->EditValue = $this->invoice_details->CurrentValue;
        $this->invoice_details->PlaceHolder = RemoveHtml($this->invoice_details->caption());

        // invoice_value
        $this->invoice_value->setupEditAttributes();
        $this->invoice_value->EditValue = $this->invoice_value->CurrentValue;
        $this->invoice_value->PlaceHolder = RemoveHtml($this->invoice_value->caption());
        if (strval($this->invoice_value->EditValue) != "" && is_numeric($this->invoice_value->EditValue)) {
            $this->invoice_value->EditValue = FormatNumber($this->invoice_value->EditValue, null);
        }

        // currency_rate
        $this->currency_rate->setupEditAttributes();
        $this->currency_rate->EditValue = $this->currency_rate->CurrentValue;
        $this->currency_rate->PlaceHolder = RemoveHtml($this->currency_rate->caption());
        if (strval($this->currency_rate->EditValue) != "" && is_numeric($this->currency_rate->EditValue)) {
            $this->currency_rate->EditValue = FormatNumber($this->currency_rate->EditValue, null);
        }

        // purchase_amount_inr
        $this->purchase_amount_inr->setupEditAttributes();
        $this->purchase_amount_inr->EditValue = $this->purchase_amount_inr->CurrentValue;
        $this->purchase_amount_inr->PlaceHolder = RemoveHtml($this->purchase_amount_inr->caption());
        if (strval($this->purchase_amount_inr->EditValue) != "" && is_numeric($this->purchase_amount_inr->EditValue)) {
            $this->purchase_amount_inr->EditValue = FormatNumber($this->purchase_amount_inr->EditValue, null);
        }

        // duty_paid_by
        $this->duty_paid_by->setupEditAttributes();
        $this->duty_paid_by->EditValue = $this->duty_paid_by->options(true);
        $this->duty_paid_by->PlaceHolder = RemoveHtml($this->duty_paid_by->caption());

        // custom_duty
        $this->custom_duty->setupEditAttributes();
        $this->custom_duty->EditValue = $this->custom_duty->CurrentValue;
        $this->custom_duty->PlaceHolder = RemoveHtml($this->custom_duty->caption());
        if (strval($this->custom_duty->EditValue) != "" && is_numeric($this->custom_duty->EditValue)) {
            $this->custom_duty->EditValue = FormatNumber($this->custom_duty->EditValue, null);
        }

        // transportation_charges
        $this->transportation_charges->setupEditAttributes();
        $this->transportation_charges->EditValue = $this->transportation_charges->CurrentValue;
        $this->transportation_charges->PlaceHolder = RemoveHtml($this->transportation_charges->caption());
        if (strval($this->transportation_charges->EditValue) != "" && is_numeric($this->transportation_charges->EditValue)) {
            $this->transportation_charges->EditValue = FormatNumber($this->transportation_charges->EditValue, null);
        }

        // port_clearing_charge
        $this->port_clearing_charge->setupEditAttributes();
        $this->port_clearing_charge->EditValue = $this->port_clearing_charge->CurrentValue;
        $this->port_clearing_charge->PlaceHolder = RemoveHtml($this->port_clearing_charge->caption());
        if (strval($this->port_clearing_charge->EditValue) != "" && is_numeric($this->port_clearing_charge->EditValue)) {
            $this->port_clearing_charge->EditValue = FormatNumber($this->port_clearing_charge->EditValue, null);
        }

        // cha_commission
        $this->cha_commission->setupEditAttributes();
        $this->cha_commission->EditValue = $this->cha_commission->CurrentValue;
        $this->cha_commission->PlaceHolder = RemoveHtml($this->cha_commission->caption());
        if (strval($this->cha_commission->EditValue) != "" && is_numeric($this->cha_commission->EditValue)) {
            $this->cha_commission->EditValue = FormatNumber($this->cha_commission->EditValue, null);
        }

        // cha_agent
        $this->cha_agent->setupEditAttributes();
        $this->cha_agent->PlaceHolder = RemoveHtml($this->cha_agent->caption());

        // clearance_bank
        $this->clearance_bank->setupEditAttributes();
        $this->clearance_bank->PlaceHolder = RemoveHtml($this->clearance_bank->caption());

        // bank_charges
        $this->bank_charges->setupEditAttributes();
        $this->bank_charges->EditValue = $this->bank_charges->CurrentValue;
        $this->bank_charges->PlaceHolder = RemoveHtml($this->bank_charges->caption());
        if (strval($this->bank_charges->EditValue) != "" && is_numeric($this->bank_charges->EditValue)) {
            $this->bank_charges->EditValue = FormatNumber($this->bank_charges->EditValue, null);
        }

        // importer
        $this->importer->setupEditAttributes();
        $this->importer->PlaceHolder = RemoveHtml($this->importer->caption());

        // remarks
        $this->remarks->setupEditAttributes();
        $this->remarks->EditValue = $this->remarks->CurrentValue;
        $this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

        // fiba_fibd
        $this->fiba_fibd->setupEditAttributes();
        if (!$this->fiba_fibd->Raw) {
            $this->fiba_fibd->CurrentValue = HtmlDecode($this->fiba_fibd->CurrentValue);
        }
        $this->fiba_fibd->EditValue = $this->fiba_fibd->CurrentValue;
        $this->fiba_fibd->PlaceHolder = RemoveHtml($this->fiba_fibd->caption());

        // fibc
        $this->fibc->setupEditAttributes();
        if (!$this->fibc->Raw) {
            $this->fibc->CurrentValue = HtmlDecode($this->fibc->CurrentValue);
        }
        $this->fibc->EditValue = $this->fibc->CurrentValue;
        $this->fibc->PlaceHolder = RemoveHtml($this->fibc->caption());

        // operator

        // datetime

        // updated
        $this->updated->setupEditAttributes();
        $this->updated->EditValue = $this->updated->CurrentValue;
        $this->updated->PlaceHolder = RemoveHtml($this->updated->caption());
        if (strval($this->updated->EditValue) != "" && is_numeric($this->updated->EditValue)) {
            $this->updated->EditValue = $this->updated->EditValue;
        }

        // grp
        $this->grp->setupEditAttributes();
        $this->grp->EditValue = $this->grp->CurrentValue;
        $this->grp->PlaceHolder = RemoveHtml($this->grp->caption());
        if (strval($this->grp->EditValue) != "" && is_numeric($this->grp->EditValue)) {
            $this->grp->EditValue = FormatNumber($this->grp->EditValue, null);
        }

        // qc_remarks
        $this->qc_remarks->setupEditAttributes();
        if (!$this->qc_remarks->Raw) {
            $this->qc_remarks->CurrentValue = HtmlDecode($this->qc_remarks->CurrentValue);
        }
        $this->qc_remarks->EditValue = $this->qc_remarks->CurrentValue;
        $this->qc_remarks->PlaceHolder = RemoveHtml($this->qc_remarks->caption());

        // qc_status
        $this->qc_status->setupEditAttributes();
        $this->qc_status->EditValue = $this->qc_status->CurrentValue;
        $this->qc_status->PlaceHolder = RemoveHtml($this->qc_status->caption());
        if (strval($this->qc_status->EditValue) != "" && is_numeric($this->qc_status->EditValue)) {
            $this->qc_status->EditValue = FormatNumber($this->qc_status->EditValue, null);
        }

        // qc_operator
        $this->qc_operator->setupEditAttributes();
        $this->qc_operator->EditValue = $this->qc_operator->CurrentValue;
        $this->qc_operator->PlaceHolder = RemoveHtml($this->qc_operator->caption());
        if (strval($this->qc_operator->EditValue) != "" && is_numeric($this->qc_operator->EditValue)) {
            $this->qc_operator->EditValue = FormatNumber($this->qc_operator->EditValue, null);
        }

        // qc_datetime
        $this->qc_datetime->setupEditAttributes();
        $this->qc_datetime->EditValue = FormatDateTime($this->qc_datetime->CurrentValue, $this->qc_datetime->formatPattern());
        $this->qc_datetime->PlaceHolder = RemoveHtml($this->qc_datetime->caption());

        // rbi_compliance_date
        $this->rbi_compliance_date->setupEditAttributes();
        $this->rbi_compliance_date->EditValue = FormatDateTime($this->rbi_compliance_date->CurrentValue, $this->rbi_compliance_date->formatPattern());
        $this->rbi_compliance_date->PlaceHolder = RemoveHtml($this->rbi_compliance_date->caption());

        // age
        $this->age->setupEditAttributes();
        $this->age->EditValue = $this->age->CurrentValue;
        $this->age->PlaceHolder = RemoveHtml($this->age->caption());
        if (strval($this->age->EditValue) != "" && is_numeric($this->age->EditValue)) {
            $this->age->EditValue = FormatNumber($this->age->EditValue, null);
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $result, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$result || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->supplier);
                    $doc->exportCaption($this->booking_reference);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->gross_weight);
                    $doc->exportCaption($this->net_weight);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->containers);
                    $doc->exportCaption($this->shipping_line);
                    $doc->exportCaption($this->port_arrival_date);
                    $doc->exportCaption($this->godown_arrival_date);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->rack);
                    $doc->exportCaption($this->invoice_details);
                    $doc->exportCaption($this->invoice_value);
                    $doc->exportCaption($this->currency_rate);
                    $doc->exportCaption($this->purchase_amount_inr);
                    $doc->exportCaption($this->duty_paid_by);
                    $doc->exportCaption($this->custom_duty);
                    $doc->exportCaption($this->transportation_charges);
                    $doc->exportCaption($this->port_clearing_charge);
                    $doc->exportCaption($this->cha_commission);
                    $doc->exportCaption($this->cha_agent);
                    $doc->exportCaption($this->clearance_bank);
                    $doc->exportCaption($this->bank_charges);
                    $doc->exportCaption($this->importer);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->fiba_fibd);
                    $doc->exportCaption($this->fibc);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                    $doc->exportCaption($this->updated);
                    $doc->exportCaption($this->rbi_compliance_date);
                } else {
                    $doc->exportCaption($this->id);
                    $doc->exportCaption($this->supplier);
                    $doc->exportCaption($this->booking_reference);
                    $doc->exportCaption($this->rid);
                    $doc->exportCaption($this->lot_no);
                    $doc->exportCaption($this->gross_weight);
                    $doc->exportCaption($this->net_weight);
                    $doc->exportCaption($this->packets);
                    $doc->exportCaption($this->packing_type);
                    $doc->exportCaption($this->containers);
                    $doc->exportCaption($this->shipping_line);
                    $doc->exportCaption($this->port_arrival_date);
                    $doc->exportCaption($this->godown_arrival_date);
                    $doc->exportCaption($this->godown);
                    $doc->exportCaption($this->rack);
                    $doc->exportCaption($this->invoice_details);
                    $doc->exportCaption($this->invoice_value);
                    $doc->exportCaption($this->currency_rate);
                    $doc->exportCaption($this->purchase_amount_inr);
                    $doc->exportCaption($this->duty_paid_by);
                    $doc->exportCaption($this->custom_duty);
                    $doc->exportCaption($this->transportation_charges);
                    $doc->exportCaption($this->port_clearing_charge);
                    $doc->exportCaption($this->cha_commission);
                    $doc->exportCaption($this->cha_agent);
                    $doc->exportCaption($this->clearance_bank);
                    $doc->exportCaption($this->bank_charges);
                    $doc->exportCaption($this->importer);
                    $doc->exportCaption($this->remarks);
                    $doc->exportCaption($this->fiba_fibd);
                    $doc->exportCaption($this->fibc);
                    $doc->exportCaption($this->operator);
                    $doc->exportCaption($this->datetime);
                }
                $doc->endExportRow();
            }
        }
        $recCnt = $startRec - 1;
        $stopRec = $stopRec > 0 ? $stopRec : PHP_INT_MAX;
        while (($row = $result->fetch()) && $recCnt < $stopRec) {
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = RowType::VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->id);
                        $doc->exportField($this->supplier);
                        $doc->exportField($this->booking_reference);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->gross_weight);
                        $doc->exportField($this->net_weight);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->containers);
                        $doc->exportField($this->shipping_line);
                        $doc->exportField($this->port_arrival_date);
                        $doc->exportField($this->godown_arrival_date);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->rack);
                        $doc->exportField($this->invoice_details);
                        $doc->exportField($this->invoice_value);
                        $doc->exportField($this->currency_rate);
                        $doc->exportField($this->purchase_amount_inr);
                        $doc->exportField($this->duty_paid_by);
                        $doc->exportField($this->custom_duty);
                        $doc->exportField($this->transportation_charges);
                        $doc->exportField($this->port_clearing_charge);
                        $doc->exportField($this->cha_commission);
                        $doc->exportField($this->cha_agent);
                        $doc->exportField($this->clearance_bank);
                        $doc->exportField($this->bank_charges);
                        $doc->exportField($this->importer);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->fiba_fibd);
                        $doc->exportField($this->fibc);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                        $doc->exportField($this->updated);
                        $doc->exportField($this->rbi_compliance_date);
                    } else {
                        $doc->exportField($this->id);
                        $doc->exportField($this->supplier);
                        $doc->exportField($this->booking_reference);
                        $doc->exportField($this->rid);
                        $doc->exportField($this->lot_no);
                        $doc->exportField($this->gross_weight);
                        $doc->exportField($this->net_weight);
                        $doc->exportField($this->packets);
                        $doc->exportField($this->packing_type);
                        $doc->exportField($this->containers);
                        $doc->exportField($this->shipping_line);
                        $doc->exportField($this->port_arrival_date);
                        $doc->exportField($this->godown_arrival_date);
                        $doc->exportField($this->godown);
                        $doc->exportField($this->rack);
                        $doc->exportField($this->invoice_details);
                        $doc->exportField($this->invoice_value);
                        $doc->exportField($this->currency_rate);
                        $doc->exportField($this->purchase_amount_inr);
                        $doc->exportField($this->duty_paid_by);
                        $doc->exportField($this->custom_duty);
                        $doc->exportField($this->transportation_charges);
                        $doc->exportField($this->port_clearing_charge);
                        $doc->exportField($this->cha_commission);
                        $doc->exportField($this->cha_agent);
                        $doc->exportField($this->clearance_bank);
                        $doc->exportField($this->bank_charges);
                        $doc->exportField($this->importer);
                        $doc->exportField($this->remarks);
                        $doc->exportField($this->fiba_fibd);
                        $doc->exportField($this->fibc);
                        $doc->exportField($this->operator);
                        $doc->exportField($this->datetime);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($doc, $row);
            }
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        global $DownloadFileName;

        // No binary fields
        return false;
    }

    // Write audit trail start/end for grid update
    public function writeAuditTrailDummy($typ)
    {
        WriteAuditLog(CurrentUserIdentifier(), $typ, 'purchase_a');
    }

    // Write audit trail (add page)
    public function writeAuditTrailOnAdd(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnAdd) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $newvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo Field
                    $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML Field
                    $newvalue = "[XML]";
                } else {
                    $newvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "A", 'purchase_a', $fldname, $key, "", $newvalue);
            }
        }
    }

    // Write audit trail (edit page)
    public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
    {
        global $Language;
        if (!$this->AuditTrailOnEdit) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rsold['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rsnew) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && array_key_exists($fldname, $rsold) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->DataType == DataType::DATE) { // DateTime field
                    $modified = (FormatDateTime($rsold[$fldname], 0) != FormatDateTime($rsnew[$fldname], 0));
                } else {
                    $modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
                }
                if ($modified) {
                    if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                        $oldvalue = $Language->phrase("PasswordMask");
                        $newvalue = $Language->phrase("PasswordMask");
                    } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                        $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsold[$fldname] : "[MEMO]";
                        $newvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rsnew[$fldname] : "[MEMO]";
                    } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                        $oldvalue = "[XML]";
                        $newvalue = "[XML]";
                    } else {
                        $oldvalue = $rsold[$fldname];
                        $newvalue = $rsnew[$fldname];
                    }
                    WriteAuditLog($usr, "U", 'purchase_a', $fldname, $key, $oldvalue, $newvalue);
                }
            }
        }
    }

    // Write audit trail (delete page)
    public function writeAuditTrailOnDelete(&$rs)
    {
        global $Language;
        if (!$this->AuditTrailOnDelete) {
            return;
        }

        // Get key value
        $key = "";
        if ($key != "") {
            $key .= Config("COMPOSITE_KEY_SEPARATOR");
        }
        $key .= $rs['id'];

        // Write audit trail
        $usr = CurrentUserIdentifier();
        foreach (array_keys($rs) as $fldname) {
            if (array_key_exists($fldname, $this->Fields) && $this->Fields[$fldname]->DataType != DataType::BLOB) { // Ignore BLOB fields
                if ($this->Fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
                    $oldvalue = $Language->phrase("PasswordMask");
                } elseif ($this->Fields[$fldname]->DataType == DataType::MEMO) { // Memo field
                    $oldvalue = Config("AUDIT_TRAIL_TO_DATABASE") ? $rs[$fldname] : "[MEMO]";
                } elseif ($this->Fields[$fldname]->DataType == DataType::XML) { // XML field
                    $oldvalue = "[XML]";
                } else {
                    $oldvalue = $rs[$fldname];
                }
                WriteAuditLog($usr, "D", 'purchase_a', $fldname, $key, $oldvalue);
            }
        }
    }

    // Table level events

    // Table Load event
    public function tableLoad()
    {
        // Enter your code here
    }

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected($rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, $rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, $rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted($rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, $args)
    {
        //var_dump($email, $args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
